/*
 * Copyright 2017-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Code generated by protoc-gen-go.
// source: schema.proto
// DO NOT EDIT!

/*
Package schema is a generated protocol buffer package.

It is generated from these files:
	schema.proto

It has these top-level messages:
	ProtoFile
	Schemas
*/
package schema

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Contains the name and content of a *.proto file
type ProtoFile struct {
	FileName    string `protobuf:"bytes,1,opt,name=file_name,json=fileName" json:"file_name,omitempty"`
	Proto       string `protobuf:"bytes,2,opt,name=proto" json:"proto,omitempty"`
	Descriptor_ []byte `protobuf:"bytes,3,opt,name=descriptor,proto3" json:"descriptor,omitempty"`
}

func (m *ProtoFile) Reset()                    { *m = ProtoFile{} }
func (m *ProtoFile) String() string            { return proto.CompactTextString(m) }
func (*ProtoFile) ProtoMessage()               {}
func (*ProtoFile) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *ProtoFile) GetFileName() string {
	if m != nil {
		return m.FileName
	}
	return ""
}

func (m *ProtoFile) GetProto() string {
	if m != nil {
		return m.Proto
	}
	return ""
}

func (m *ProtoFile) GetDescriptor_() []byte {
	if m != nil {
		return m.Descriptor_
	}
	return nil
}

// Proto files and compiled descriptors for this interface
type Schemas struct {
	// Proto files
	Protos []*ProtoFile `protobuf:"bytes,1,rep,name=protos" json:"protos,omitempty"`
	// Proto file name from which swagger.json shall be generated
	SwaggerFrom string `protobuf:"bytes,2,opt,name=swagger_from,json=swaggerFrom" json:"swagger_from,omitempty"`
	// Proto file name from which yang schemas shall be generated
	YangFrom string `protobuf:"bytes,3,opt,name=yang_from,json=yangFrom" json:"yang_from,omitempty"`
}

func (m *Schemas) Reset()                    { *m = Schemas{} }
func (m *Schemas) String() string            { return proto.CompactTextString(m) }
func (*Schemas) ProtoMessage()               {}
func (*Schemas) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Schemas) GetProtos() []*ProtoFile {
	if m != nil {
		return m.Protos
	}
	return nil
}

func (m *Schemas) GetSwaggerFrom() string {
	if m != nil {
		return m.SwaggerFrom
	}
	return ""
}

func (m *Schemas) GetYangFrom() string {
	if m != nil {
		return m.YangFrom
	}
	return ""
}

func init() {
	proto.RegisterType((*ProtoFile)(nil), "schema.ProtoFile")
	proto.RegisterType((*Schemas)(nil), "schema.Schemas")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for SchemaService service

type SchemaServiceClient interface {
	// Return active grpc schemas
	GetSchema(ctx context.Context, in *google_protobuf1.Empty, opts ...grpc.CallOption) (*Schemas, error)
}

type schemaServiceClient struct {
	cc *grpc.ClientConn
}

func NewSchemaServiceClient(cc *grpc.ClientConn) SchemaServiceClient {
	return &schemaServiceClient{cc}
}

func (c *schemaServiceClient) GetSchema(ctx context.Context, in *google_protobuf1.Empty, opts ...grpc.CallOption) (*Schemas, error) {
	out := new(Schemas)
	err := grpc.Invoke(ctx, "/schema.SchemaService/GetSchema", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for SchemaService service

type SchemaServiceServer interface {
	// Return active grpc schemas
	GetSchema(context.Context, *google_protobuf1.Empty) (*Schemas, error)
}

func RegisterSchemaServiceServer(s *grpc.Server, srv SchemaServiceServer) {
	s.RegisterService(&_SchemaService_serviceDesc, srv)
}

func _SchemaService_GetSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_protobuf1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchemaServiceServer).GetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/schema.SchemaService/GetSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchemaServiceServer).GetSchema(ctx, req.(*google_protobuf1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _SchemaService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "schema.SchemaService",
	HandlerType: (*SchemaServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSchema",
			Handler:    _SchemaService_GetSchema_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "schema.proto",
}

func init() { proto.RegisterFile("schema.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 278 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x4c, 0x90, 0xc1, 0x4a, 0xc3, 0x40,
	0x10, 0x86, 0x49, 0x8b, 0xad, 0x99, 0x56, 0x8a, 0x8b, 0x48, 0x48, 0x45, 0x62, 0x4e, 0xf1, 0x92,
	0x40, 0x7d, 0x86, 0xd6, 0x9b, 0x48, 0x0a, 0x1e, 0x2d, 0xdb, 0x38, 0x89, 0x0b, 0xd9, 0x6c, 0xd8,
	0x5d, 0x95, 0x5e, 0x7d, 0x05, 0x1f, 0xcd, 0x57, 0xf0, 0x41, 0x64, 0x33, 0x5b, 0xf1, 0xb6, 0xf3,
	0x7f, 0x33, 0xcc, 0xb7, 0x03, 0x73, 0x53, 0xbd, 0xa2, 0xe4, 0x79, 0xaf, 0x95, 0x55, 0x6c, 0x42,
	0x55, 0x7c, 0xd5, 0x28, 0xd5, 0xb4, 0x58, 0xf0, 0x5e, 0x14, 0xbc, 0xeb, 0x94, 0xe5, 0x56, 0xa8,
	0xce, 0x50, 0x57, 0xbc, 0xf4, 0x74, 0xa8, 0xf6, 0x6f, 0x75, 0x81, 0xb2, 0xb7, 0x07, 0x82, 0xe9,
	0x33, 0x84, 0x8f, 0xee, 0xb1, 0x11, 0x2d, 0xb2, 0x25, 0x84, 0xb5, 0x68, 0x71, 0xd7, 0x71, 0x89,
	0x51, 0x90, 0x04, 0x59, 0x58, 0x9e, 0xba, 0xe0, 0x81, 0x4b, 0x64, 0x17, 0x70, 0x32, 0x8c, 0x44,
	0xa3, 0x01, 0x50, 0xc1, 0xae, 0x01, 0x5e, 0xd0, 0x54, 0x5a, 0xf4, 0x56, 0xe9, 0x68, 0x9c, 0x04,
	0xd9, 0xbc, 0xfc, 0x97, 0xa4, 0x16, 0xa6, 0xdb, 0x41, 0xd2, 0xb0, 0x5b, 0x98, 0x0c, 0x33, 0x26,
	0x0a, 0x92, 0x71, 0x36, 0x5b, 0x9d, 0xe7, 0xfe, 0x33, 0x7f, 0x02, 0xa5, 0x6f, 0x60, 0x37, 0x30,
	0x37, 0x1f, 0xbc, 0x69, 0x50, 0xef, 0x6a, 0xad, 0xa4, 0x5f, 0x39, 0xf3, 0xd9, 0x46, 0x2b, 0xe9,
	0x5c, 0x0f, 0xbc, 0x6b, 0x88, 0x8f, 0xc9, 0xd5, 0x05, 0x0e, 0xae, 0x9e, 0xe0, 0x8c, 0xb6, 0x6e,
	0x51, 0xbf, 0x8b, 0x0a, 0xd9, 0x1a, 0xc2, 0x7b, 0xb4, 0x94, 0xb1, 0xcb, 0x9c, 0x2e, 0x92, 0x1f,
	0x2f, 0x92, 0xaf, 0xdd, 0x45, 0xe2, 0xc5, 0x51, 0xc8, 0x1b, 0xa7, 0x8b, 0xcf, 0xef, 0x9f, 0xaf,
	0x51, 0xc8, 0xa6, 0x05, 0x81, 0x3d, 0xf9, 0xdd, 0xfd, 0x06, 0x00, 0x00, 0xff, 0xff, 0xae, 0xf9,
	0x7e, 0x49, 0x87, 0x01, 0x00, 0x00,
}
