/*
 * Copyright 2017-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Code generated by protoc-gen-go.
// source: health.proto
// DO NOT EDIT!

/*
Package voltha is a generated protocol buffer package.

It is generated from these files:
	health.proto

It has these top-level messages:
	HealthStatus
*/
package health

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Health states
type HealthStatus_HealthState int32

const (
	HealthStatus_HEALTHY    HealthStatus_HealthState = 0
	HealthStatus_OVERLOADED HealthStatus_HealthState = 1
	HealthStatus_DYING      HealthStatus_HealthState = 2
)

var HealthStatus_HealthState_name = map[int32]string{
	0: "HEALTHY",
	1: "OVERLOADED",
	2: "DYING",
}
var HealthStatus_HealthState_value = map[string]int32{
	"HEALTHY":    0,
	"OVERLOADED": 1,
	"DYING":      2,
}

func (x HealthStatus_HealthState) String() string {
	return proto.EnumName(HealthStatus_HealthState_name, int32(x))
}
func (HealthStatus_HealthState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

// Encode health status of a Voltha instance
type HealthStatus struct {
	// Current state of health of this Voltha instance
	State HealthStatus_HealthState `protobuf:"varint,1,opt,name=state,enum=voltha.HealthStatus_HealthState" json:"state,omitempty"`
}

func (m *HealthStatus) Reset()                    { *m = HealthStatus{} }
func (m *HealthStatus) String() string            { return proto.CompactTextString(m) }
func (*HealthStatus) ProtoMessage()               {}
func (*HealthStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *HealthStatus) GetState() HealthStatus_HealthState {
	if m != nil {
		return m.State
	}
	return HealthStatus_HEALTHY
}

func init() {
	proto.RegisterType((*HealthStatus)(nil), "voltha.HealthStatus")
	proto.RegisterEnum("voltha.HealthStatus_HealthState", HealthStatus_HealthState_name, HealthStatus_HealthState_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HealthService service

type HealthServiceClient interface {
	// Return current health status of a Voltha instance
	GetHealthStatus(ctx context.Context, in *google_protobuf1.Empty, opts ...grpc.CallOption) (*HealthStatus, error)
}

type healthServiceClient struct {
	cc *grpc.ClientConn
}

func NewHealthServiceClient(cc *grpc.ClientConn) HealthServiceClient {
	return &healthServiceClient{cc}
}

func (c *healthServiceClient) GetHealthStatus(ctx context.Context, in *google_protobuf1.Empty, opts ...grpc.CallOption) (*HealthStatus, error) {
	out := new(HealthStatus)
	err := grpc.Invoke(ctx, "/voltha.HealthService/GetHealthStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HealthService service

type HealthServiceServer interface {
	// Return current health status of a Voltha instance
	GetHealthStatus(context.Context, *google_protobuf1.Empty) (*HealthStatus, error)
}

func RegisterHealthServiceServer(s *grpc.Server, srv HealthServiceServer) {
	s.RegisterService(&_HealthService_serviceDesc, srv)
}

func _HealthService_GetHealthStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_protobuf1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthServiceServer).GetHealthStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.HealthService/GetHealthStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthServiceServer).GetHealthStatus(ctx, req.(*google_protobuf1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _HealthService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "voltha.HealthService",
	HandlerType: (*HealthServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetHealthStatus",
			Handler:    _HealthService_GetHealthStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "health.proto",
}

func init() { proto.RegisterFile("health.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 248 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xe2, 0xc9, 0x48, 0x4d, 0xcc,
	0x29, 0xc9, 0xd0, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0x62, 0x2b, 0xcb, 0xcf, 0x29, 0xc9, 0x48,
	0x94, 0x92, 0x49, 0xcf, 0xcf, 0x4f, 0xcf, 0x49, 0xd5, 0x4f, 0x2c, 0xc8, 0xd4, 0x4f, 0xcc, 0xcb,
	0xcb, 0x2f, 0x49, 0x2c, 0xc9, 0xcc, 0xcf, 0x2b, 0x86, 0xa8, 0x92, 0x92, 0x86, 0xca, 0x82, 0x79,
	0x49, 0xa5, 0x69, 0xfa, 0xa9, 0xb9, 0x05, 0x25, 0x95, 0x50, 0x49, 0xae, 0xdc, 0xd4, 0x92, 0x44,
	0x08, 0x5b, 0xa9, 0x85, 0x91, 0x8b, 0xc7, 0x03, 0x6c, 0x7e, 0x70, 0x49, 0x62, 0x49, 0x69, 0xb1,
	0x90, 0x2d, 0x17, 0x6b, 0x71, 0x49, 0x62, 0x49, 0xaa, 0x04, 0xa3, 0x02, 0xa3, 0x06, 0x9f, 0x91,
	0x82, 0x1e, 0xc4, 0x3e, 0x3d, 0x64, 0x45, 0x48, 0x9c, 0x54, 0x27, 0xd6, 0x17, 0xdf, 0xce, 0xca,
	0x32, 0x06, 0x41, 0x74, 0x29, 0x99, 0x72, 0x71, 0x23, 0x49, 0x0a, 0x71, 0x73, 0xb1, 0x7b, 0xb8,
	0x3a, 0xfa, 0x84, 0x78, 0x44, 0x0a, 0x30, 0x08, 0xf1, 0x71, 0x71, 0xf9, 0x87, 0xb9, 0x06, 0xf9,
	0xf8, 0x3b, 0xba, 0xb8, 0xba, 0x08, 0x30, 0x0a, 0x71, 0x72, 0xb1, 0xba, 0x44, 0x7a, 0xfa, 0xb9,
	0x0b, 0x30, 0x19, 0x25, 0x72, 0xf1, 0x42, 0xb5, 0xa5, 0x16, 0x95, 0x65, 0x26, 0xa7, 0x0a, 0x05,
	0x70, 0xf1, 0xbb, 0xa7, 0x96, 0xa0, 0xb8, 0x4c, 0x4c, 0x0f, 0xe2, 0x29, 0x3d, 0x98, 0xa7, 0xf4,
	0x5c, 0x41, 0x9e, 0x92, 0x12, 0xc1, 0xe6, 0x44, 0x25, 0xfe, 0xa6, 0xcb, 0x4f, 0x26, 0x33, 0x71,
	0x0a, 0xb1, 0xeb, 0x43, 0x82, 0x2f, 0x89, 0x0d, 0xac, 0xcd, 0x18, 0x10, 0x00, 0x00, 0xff, 0xff,
	0x59, 0x30, 0x7e, 0x18, 0x4f, 0x01, 0x00, 0x00,
}
