# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template module.py
# Do not modify

import struct
import loxi
import util
import loxi.generic_util

import sys
ofp = sys.modules['loxi.of13']

class oxm(loxi.OFObject):
    subtypes = {}


    def __init__(self, type_len=None):
        if type_len != None:
            self.type_len = type_len
        else:
            self.type_len = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 0)
        subclass = oxm.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = oxm()
        obj.type_len = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type_len != other.type_len: return False
        return True

    def pretty_print(self, q):
        q.text("oxm {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class arp_op(oxm):
    type_len = 2147494402

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_op()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147494402)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("arp_op {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147494402] = arp_op

class arp_op_masked(oxm):
    type_len = 2147494660

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_op_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147494660)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("arp_op_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147494660] = arp_op_masked

class arp_sha(oxm):
    type_len = 2147495942

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_sha()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147495942)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("arp_sha {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147495942] = arp_sha

class arp_sha_masked(oxm):
    type_len = 2147496204

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_sha_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147496204)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("arp_sha_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147496204] = arp_sha_masked

class arp_spa(oxm):
    type_len = 2147494916

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_spa()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147494916)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("arp_spa {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147494916] = arp_spa

class arp_spa_masked(oxm):
    type_len = 2147495176

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_spa_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147495176)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("arp_spa_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147495176] = arp_spa_masked

class arp_tha(oxm):
    type_len = 2147496454

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_tha()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147496454)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("arp_tha {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147496454] = arp_tha

class arp_tha_masked(oxm):
    type_len = 2147496716

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_tha_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147496716)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("arp_tha_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147496716] = arp_tha_masked

class arp_tpa(oxm):
    type_len = 2147495428

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_tpa()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147495428)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("arp_tpa {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147495428] = arp_tpa

class arp_tpa_masked(oxm):
    type_len = 2147495688

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = arp_tpa_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147495688)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("arp_tpa_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147495688] = arp_tpa_masked

class bsn_egr_port_group_id(oxm):
    type_len = 200196

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_egr_port_group_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 200196)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_egr_port_group_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[200196] = bsn_egr_port_group_id

class bsn_egr_port_group_id_masked(oxm):
    type_len = 200456

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_egr_port_group_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 200456)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_egr_port_group_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[200456] = bsn_egr_port_group_id_masked

class bsn_global_vrf_allowed(oxm):
    type_len = 198145

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_global_vrf_allowed()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 198145)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_global_vrf_allowed {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[198145] = bsn_global_vrf_allowed

class bsn_global_vrf_allowed_masked(oxm):
    type_len = 198402

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_global_vrf_allowed_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 198402)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_global_vrf_allowed_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[198402] = bsn_global_vrf_allowed_masked

class bsn_in_ports_128(oxm):
    type_len = 196624

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = set()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_bitmap_128(self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_in_ports_128()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 196624)
        obj.value = util.unpack_bitmap_128(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_in_ports_128 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[196624] = bsn_in_ports_128

class bsn_in_ports_128_masked(oxm):
    type_len = 196896

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = set()
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = set()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_bitmap_128(self.value))
        packed.append(util.pack_bitmap_128(self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_in_ports_128_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 196896)
        obj.value = util.unpack_bitmap_128(reader)
        obj.value_mask = util.unpack_bitmap_128(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_in_ports_128_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.pp(self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[196896] = bsn_in_ports_128_masked

class bsn_in_ports_512(oxm):
    type_len = 206400

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = set()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_bitmap_512(self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_in_ports_512()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 206400)
        obj.value = util.unpack_bitmap_512(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_in_ports_512 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[206400] = bsn_in_ports_512

class bsn_in_ports_512_masked(oxm):
    type_len = 206720

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = set()
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = set()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_bitmap_512(self.value))
        packed.append(util.pack_bitmap_512(self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_in_ports_512_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 206720)
        obj.value = util.unpack_bitmap_512(reader)
        obj.value_mask = util.unpack_bitmap_512(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_in_ports_512_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.pp(self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[206720] = bsn_in_ports_512_masked

class bsn_ingress_port_group_id(oxm):
    type_len = 206852

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_ingress_port_group_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 206852)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_ingress_port_group_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[206852] = bsn_ingress_port_group_id

class bsn_ingress_port_group_id_masked(oxm):
    type_len = 207112

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_ingress_port_group_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 207112)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_ingress_port_group_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[207112] = bsn_ingress_port_group_id_masked

class bsn_inner_eth_dst(oxm):
    type_len = 207878

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_inner_eth_dst()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 207878)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_inner_eth_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[207878] = bsn_inner_eth_dst

class bsn_inner_eth_dst_masked(oxm):
    type_len = 208140

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_inner_eth_dst_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 208140)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_inner_eth_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[208140] = bsn_inner_eth_dst_masked

class bsn_inner_eth_src(oxm):
    type_len = 208390

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_inner_eth_src()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 208390)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_inner_eth_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[208390] = bsn_inner_eth_src

class bsn_inner_eth_src_masked(oxm):
    type_len = 208652

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_inner_eth_src_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 208652)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_inner_eth_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[208652] = bsn_inner_eth_src_masked

class bsn_inner_vlan_vid(oxm):
    type_len = 208898

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_inner_vlan_vid()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 208898)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_inner_vlan_vid {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[208898] = bsn_inner_vlan_vid

class bsn_inner_vlan_vid_masked(oxm):
    type_len = 209156

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_inner_vlan_vid_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 209156)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_inner_vlan_vid_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[209156] = bsn_inner_vlan_vid_masked

class bsn_l2_cache_hit(oxm):
    type_len = 205825

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_l2_cache_hit()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 205825)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_l2_cache_hit {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[205825] = bsn_l2_cache_hit

class bsn_l2_cache_hit_masked(oxm):
    type_len = 206082

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_l2_cache_hit_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 206082)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_l2_cache_hit_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[206082] = bsn_l2_cache_hit_masked

class bsn_l3_dst_class_id(oxm):
    type_len = 199684

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_l3_dst_class_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 199684)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_l3_dst_class_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[199684] = bsn_l3_dst_class_id

class bsn_l3_dst_class_id_masked(oxm):
    type_len = 199944

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_l3_dst_class_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 199944)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_l3_dst_class_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[199944] = bsn_l3_dst_class_id_masked

class bsn_l3_interface_class_id(oxm):
    type_len = 198660

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_l3_interface_class_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 198660)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_l3_interface_class_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[198660] = bsn_l3_interface_class_id

class bsn_l3_interface_class_id_masked(oxm):
    type_len = 198920

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_l3_interface_class_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 198920)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_l3_interface_class_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[198920] = bsn_l3_interface_class_id_masked

class bsn_l3_src_class_id(oxm):
    type_len = 199172

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_l3_src_class_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 199172)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_l3_src_class_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[199172] = bsn_l3_src_class_id

class bsn_l3_src_class_id_masked(oxm):
    type_len = 199432

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_l3_src_class_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 199432)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_l3_src_class_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[199432] = bsn_l3_src_class_id_masked

class bsn_lag_id(oxm):
    type_len = 197124

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_lag_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 197124)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_lag_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[197124] = bsn_lag_id

class bsn_lag_id_masked(oxm):
    type_len = 197384

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_lag_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 197384)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_lag_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[197384] = bsn_lag_id_masked

class bsn_tcp_flags(oxm):
    type_len = 204802

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_tcp_flags()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 204802)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_tcp_flags {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[204802] = bsn_tcp_flags

class bsn_tcp_flags_masked(oxm):
    type_len = 205060

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_tcp_flags_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 205060)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_tcp_flags_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[205060] = bsn_tcp_flags_masked

class bsn_udf0(oxm):
    type_len = 200708

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf0()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 200708)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf0 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[200708] = bsn_udf0

class bsn_udf0_masked(oxm):
    type_len = 200968

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf0_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 200968)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf0_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[200968] = bsn_udf0_masked

class bsn_udf1(oxm):
    type_len = 201220

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf1()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 201220)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf1 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[201220] = bsn_udf1

class bsn_udf1_masked(oxm):
    type_len = 201480

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf1_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 201480)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf1_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[201480] = bsn_udf1_masked

class bsn_udf2(oxm):
    type_len = 201732

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf2()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 201732)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf2 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[201732] = bsn_udf2

class bsn_udf2_masked(oxm):
    type_len = 201992

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf2_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 201992)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf2_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[201992] = bsn_udf2_masked

class bsn_udf3(oxm):
    type_len = 202244

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf3()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 202244)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf3 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[202244] = bsn_udf3

class bsn_udf3_masked(oxm):
    type_len = 202504

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf3_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 202504)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf3_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[202504] = bsn_udf3_masked

class bsn_udf4(oxm):
    type_len = 202756

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf4()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 202756)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf4 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[202756] = bsn_udf4

class bsn_udf4_masked(oxm):
    type_len = 203016

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf4_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 203016)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf4_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[203016] = bsn_udf4_masked

class bsn_udf5(oxm):
    type_len = 203268

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf5()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 203268)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf5 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[203268] = bsn_udf5

class bsn_udf5_masked(oxm):
    type_len = 203528

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf5_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 203528)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf5_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[203528] = bsn_udf5_masked

class bsn_udf6(oxm):
    type_len = 203780

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf6()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 203780)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf6 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[203780] = bsn_udf6

class bsn_udf6_masked(oxm):
    type_len = 204040

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf6_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 204040)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf6_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[204040] = bsn_udf6_masked

class bsn_udf7(oxm):
    type_len = 204292

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf7()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 204292)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf7 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[204292] = bsn_udf7

class bsn_udf7_masked(oxm):
    type_len = 204552

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_udf7_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 204552)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_udf7_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[204552] = bsn_udf7_masked

class bsn_vfi(oxm):
    type_len = 209410

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vfi()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 209410)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vfi {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[209410] = bsn_vfi

class bsn_vfi_masked(oxm):
    type_len = 209668

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vfi_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 209668)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vfi_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[209668] = bsn_vfi_masked

class bsn_vlan_xlate_port_group_id(oxm):
    type_len = 205316

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vlan_xlate_port_group_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 205316)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vlan_xlate_port_group_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[205316] = bsn_vlan_xlate_port_group_id

class bsn_vlan_xlate_port_group_id_masked(oxm):
    type_len = 205576

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vlan_xlate_port_group_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 205576)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vlan_xlate_port_group_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[205576] = bsn_vlan_xlate_port_group_id_masked

class bsn_vrf(oxm):
    type_len = 197636

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vrf()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 197636)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vrf {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[197636] = bsn_vrf

class bsn_vrf_masked(oxm):
    type_len = 197896

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vrf_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 197896)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vrf_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[197896] = bsn_vrf_masked

class bsn_vxlan_network_id(oxm):
    type_len = 207364

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vxlan_network_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 207364)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vxlan_network_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[207364] = bsn_vxlan_network_id

class bsn_vxlan_network_id_masked(oxm):
    type_len = 207624

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vxlan_network_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 207624)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vxlan_network_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[207624] = bsn_vxlan_network_id_masked

class eth_dst(oxm):
    type_len = 2147485190

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = eth_dst()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147485190)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("eth_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147485190] = eth_dst

class eth_dst_masked(oxm):
    type_len = 2147485452

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = eth_dst_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147485452)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("eth_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147485452] = eth_dst_masked

class eth_src(oxm):
    type_len = 2147485702

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = eth_src()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147485702)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("eth_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147485702] = eth_src

class eth_src_masked(oxm):
    type_len = 2147485964

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = eth_src_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147485964)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("eth_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147485964] = eth_src_masked

class eth_type(oxm):
    type_len = 2147486210

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = eth_type()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147486210)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("eth_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147486210] = eth_type

class eth_type_masked(oxm):
    type_len = 2147486468

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = eth_type_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147486468)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("eth_type_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147486468] = eth_type_masked

class icmpv4_code(oxm):
    type_len = 2147493889

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmpv4_code()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147493889)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("icmpv4_code {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147493889] = icmpv4_code

class icmpv4_code_masked(oxm):
    type_len = 2147494146

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmpv4_code_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147494146)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("icmpv4_code_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147494146] = icmpv4_code_masked

class icmpv4_type(oxm):
    type_len = 2147493377

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmpv4_type()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147493377)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("icmpv4_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147493377] = icmpv4_type

class icmpv4_type_masked(oxm):
    type_len = 2147493634

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmpv4_type_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147493634)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("icmpv4_type_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147493634] = icmpv4_type_masked

class icmpv6_code(oxm):
    type_len = 2147499009

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmpv6_code()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147499009)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("icmpv6_code {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147499009] = icmpv6_code

class icmpv6_code_masked(oxm):
    type_len = 2147499266

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmpv6_code_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147499266)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("icmpv6_code_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147499266] = icmpv6_code_masked

class icmpv6_type(oxm):
    type_len = 2147498497

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmpv6_type()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147498497)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("icmpv6_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147498497] = icmpv6_type

class icmpv6_type_masked(oxm):
    type_len = 2147498754

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmpv6_type_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147498754)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("icmpv6_type_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147498754] = icmpv6_type_masked

class in_phy_port(oxm):
    type_len = 2147484164

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_port_no(self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = in_phy_port()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147484164)
        obj.value = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("in_phy_port {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147484164] = in_phy_port

class in_phy_port_masked(oxm):
    type_len = 2147484424

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_port_no(self.value))
        packed.append(util.pack_port_no(self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = in_phy_port_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147484424)
        obj.value = util.unpack_port_no(reader)
        obj.value_mask = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("in_phy_port_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_port(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147484424] = in_phy_port_masked

class in_port(oxm):
    type_len = 2147483652

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_port_no(self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = in_port()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147483652)
        obj.value = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("in_port {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147483652] = in_port

class in_port_masked(oxm):
    type_len = 2147483912

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_port_no(self.value))
        packed.append(util.pack_port_no(self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = in_port_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147483912)
        obj.value = util.unpack_port_no(reader)
        obj.value_mask = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("in_port_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_port(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147483912] = in_port_masked

class ip_dscp(oxm):
    type_len = 2147487745

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ip_dscp()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147487745)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ip_dscp {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147487745] = ip_dscp

class ip_dscp_masked(oxm):
    type_len = 2147488002

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ip_dscp_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147488002)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ip_dscp_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147488002] = ip_dscp_masked

class ip_ecn(oxm):
    type_len = 2147488257

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ip_ecn()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147488257)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ip_ecn {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147488257] = ip_ecn

class ip_ecn_masked(oxm):
    type_len = 2147488514

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ip_ecn_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147488514)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ip_ecn_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147488514] = ip_ecn_masked

class ip_proto(oxm):
    type_len = 2147488769

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ip_proto()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147488769)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ip_proto {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147488769] = ip_proto

class ip_proto_masked(oxm):
    type_len = 2147489026

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ip_proto_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147489026)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ip_proto_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147489026] = ip_proto_masked

class ipv4_dst(oxm):
    type_len = 2147489796

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv4_dst()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147489796)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv4_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147489796] = ipv4_dst

class ipv4_dst_masked(oxm):
    type_len = 2147490056

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv4_dst_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147490056)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv4_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_ipv4(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147490056] = ipv4_dst_masked

class ipv4_src(oxm):
    type_len = 2147489284

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv4_src()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147489284)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv4_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147489284] = ipv4_src

class ipv4_src_masked(oxm):
    type_len = 2147489544

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv4_src_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147489544)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv4_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_ipv4(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147489544] = ipv4_src_masked

class ipv6_dst(oxm):
    type_len = 2147497488

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_dst()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147497488)
        obj.value = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147497488] = ipv6_dst

class ipv6_dst_masked(oxm):
    type_len = 2147497760

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        packed.append(struct.pack("!16s", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_dst_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147497760)
        obj.value = reader.read('!16s')[0]
        obj.value_mask = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.pp(self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147497760] = ipv6_dst_masked

class ipv6_exthdr(oxm):
    type_len = 2147503618

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_exthdr()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147503618)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_exthdr {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147503618] = ipv6_exthdr

class ipv6_exthdr_masked(oxm):
    type_len = 2147503876

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_exthdr_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147503876)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_exthdr_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147503876] = ipv6_exthdr_masked

class ipv6_flabel(oxm):
    type_len = 2147497988

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_flabel()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147497988)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_flabel {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147497988] = ipv6_flabel

class ipv6_flabel_masked(oxm):
    type_len = 2147498248

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_flabel_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147498248)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_flabel_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147498248] = ipv6_flabel_masked

class ipv6_nd_sll(oxm):
    type_len = 2147500038

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_nd_sll()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147500038)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_nd_sll {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147500038] = ipv6_nd_sll

class ipv6_nd_sll_masked(oxm):
    type_len = 2147500300

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_nd_sll_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147500300)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_nd_sll_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147500300] = ipv6_nd_sll_masked

class ipv6_nd_target(oxm):
    type_len = 2147499536

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_nd_target()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147499536)
        obj.value = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_nd_target {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147499536] = ipv6_nd_target

class ipv6_nd_target_masked(oxm):
    type_len = 2147499808

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        packed.append(struct.pack("!16s", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_nd_target_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147499808)
        obj.value = reader.read('!16s')[0]
        obj.value_mask = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_nd_target_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.pp(self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147499808] = ipv6_nd_target_masked

class ipv6_nd_tll(oxm):
    type_len = 2147500550

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_nd_tll()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147500550)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_nd_tll {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[2147500550] = ipv6_nd_tll

class ipv6_nd_tll_masked(oxm):
    type_len = 2147500812

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_nd_tll_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147500812)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_nd_tll_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[2147500812] = ipv6_nd_tll_masked

class ipv6_src(oxm):
    type_len = 2147496976

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_src()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147496976)
        obj.value = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147496976] = ipv6_src

class ipv6_src_masked(oxm):
    type_len = 2147497248

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        packed.append(struct.pack("!16s", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6_src_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147497248)
        obj.value = reader.read('!16s')[0]
        obj.value_mask = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.pp(self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147497248] = ipv6_src_masked

class metadata(oxm):
    type_len = 2147484680

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!Q", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = metadata()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147484680)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("metadata {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147484680] = metadata

class metadata_masked(oxm):
    type_len = 2147484944

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!Q", self.value))
        packed.append(struct.pack("!Q", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = metadata_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147484944)
        obj.value = reader.read("!Q")[0]
        obj.value_mask = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("metadata_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147484944] = metadata_masked

class mpls_bos(oxm):
    type_len = 2147502081

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_bos()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147502081)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_bos {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147502081] = mpls_bos

class mpls_bos_masked(oxm):
    type_len = 2147502338

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_bos_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147502338)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_bos_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147502338] = mpls_bos_masked

class mpls_label(oxm):
    type_len = 2147501060

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_label()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147501060)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_label {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147501060] = mpls_label

class mpls_label_masked(oxm):
    type_len = 2147501320

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_label_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147501320)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_label_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147501320] = mpls_label_masked

class mpls_tc(oxm):
    type_len = 2147501569

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_tc()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147501569)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_tc {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147501569] = mpls_tc

class mpls_tc_masked(oxm):
    type_len = 2147501826

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_tc_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147501826)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_tc_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147501826] = mpls_tc_masked

class sctp_dst(oxm):
    type_len = 2147492866

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = sctp_dst()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147492866)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("sctp_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147492866] = sctp_dst

class sctp_dst_masked(oxm):
    type_len = 2147493124

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = sctp_dst_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147493124)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("sctp_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147493124] = sctp_dst_masked

class sctp_src(oxm):
    type_len = 2147492354

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = sctp_src()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147492354)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("sctp_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147492354] = sctp_src

class sctp_src_masked(oxm):
    type_len = 2147492612

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = sctp_src_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147492612)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("sctp_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147492612] = sctp_src_masked

class tcp_dst(oxm):
    type_len = 2147490818

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tcp_dst()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147490818)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tcp_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147490818] = tcp_dst

class tcp_dst_masked(oxm):
    type_len = 2147491076

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tcp_dst_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147491076)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("tcp_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147491076] = tcp_dst_masked

class tcp_src(oxm):
    type_len = 2147490306

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tcp_src()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147490306)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tcp_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147490306] = tcp_src

class tcp_src_masked(oxm):
    type_len = 2147490564

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tcp_src_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147490564)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("tcp_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147490564] = tcp_src_masked

class tunnel_id(oxm):
    type_len = 2147503112

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!Q", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tunnel_id()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147503112)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tunnel_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147503112] = tunnel_id

class tunnel_id_masked(oxm):
    type_len = 2147503376

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!Q", self.value))
        packed.append(struct.pack("!Q", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tunnel_id_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147503376)
        obj.value = reader.read("!Q")[0]
        obj.value_mask = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("tunnel_id_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147503376] = tunnel_id_masked

class tunnel_ipv4_dst(oxm):
    type_len = 81924

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tunnel_ipv4_dst()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 81924)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tunnel_ipv4_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[81924] = tunnel_ipv4_dst

class tunnel_ipv4_dst_masked(oxm):
    type_len = 82184

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tunnel_ipv4_dst_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 82184)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("tunnel_ipv4_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_ipv4(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[82184] = tunnel_ipv4_dst_masked

class tunnel_ipv4_src(oxm):
    type_len = 81412

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tunnel_ipv4_src()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 81412)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tunnel_ipv4_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

oxm.subtypes[81412] = tunnel_ipv4_src

class tunnel_ipv4_src_masked(oxm):
    type_len = 81672

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tunnel_ipv4_src_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 81672)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("tunnel_ipv4_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_ipv4(self.value_mask))
            q.breakable()
        q.text('}')

oxm.subtypes[81672] = tunnel_ipv4_src_masked

class udp_dst(oxm):
    type_len = 2147491842

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udp_dst()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147491842)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("udp_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147491842] = udp_dst

class udp_dst_masked(oxm):
    type_len = 2147492100

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udp_dst_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147492100)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("udp_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147492100] = udp_dst_masked

class udp_src(oxm):
    type_len = 2147491330

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udp_src()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147491330)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("udp_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147491330] = udp_src

class udp_src_masked(oxm):
    type_len = 2147491588

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udp_src_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147491588)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("udp_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147491588] = udp_src_masked

class vlan_pcp(oxm):
    type_len = 2147487233

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vlan_pcp()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147487233)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("vlan_pcp {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147487233] = vlan_pcp

class vlan_pcp_masked(oxm):
    type_len = 2147487490

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vlan_pcp_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147487490)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("vlan_pcp_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147487490] = vlan_pcp_masked

class vlan_vid(oxm):
    type_len = 2147486722

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vlan_vid()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147486722)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("vlan_vid {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

oxm.subtypes[2147486722] = vlan_vid

class vlan_vid_masked(oxm):
    type_len = 2147486980

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vlan_vid_masked()
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147486980)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def pretty_print(self, q):
        q.text("vlan_vid_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

oxm.subtypes[2147486980] = vlan_vid_masked


