/*
 * Copyright 2017-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Code generated by protoc-gen-go.
// source: events.proto
// DO NOT EDIT!

/*
Package voltha is a generated protocol buffer package.

It is generated from these files:
	events.proto

It has these top-level messages:
	ConfigEventType
	ConfigEvent
	KpiEventType
	MetricValuePairs
	KpiEvent
	AlarmEventType
	AlarmEventCategory
	AlarmEventState
	AlarmEventSeverity
	AlarmEvent
*/
package events

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ConfigEventType_ConfigEventType int32

const (
	ConfigEventType_add    ConfigEventType_ConfigEventType = 0
	ConfigEventType_remove ConfigEventType_ConfigEventType = 1
	ConfigEventType_update ConfigEventType_ConfigEventType = 2
)

var ConfigEventType_ConfigEventType_name = map[int32]string{
	0: "add",
	1: "remove",
	2: "update",
}
var ConfigEventType_ConfigEventType_value = map[string]int32{
	"add":    0,
	"remove": 1,
	"update": 2,
}

func (x ConfigEventType_ConfigEventType) String() string {
	return proto.EnumName(ConfigEventType_ConfigEventType_name, int32(x))
}
func (ConfigEventType_ConfigEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0, 0}
}

type KpiEventType_KpiEventType int32

const (
	KpiEventType_slice KpiEventType_KpiEventType = 0
	KpiEventType_ts    KpiEventType_KpiEventType = 1
)

var KpiEventType_KpiEventType_name = map[int32]string{
	0: "slice",
	1: "ts",
}
var KpiEventType_KpiEventType_value = map[string]int32{
	"slice": 0,
	"ts":    1,
}

func (x KpiEventType_KpiEventType) String() string {
	return proto.EnumName(KpiEventType_KpiEventType_name, int32(x))
}
func (KpiEventType_KpiEventType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

type AlarmEventType_AlarmEventType int32

const (
	AlarmEventType_COMMUNICATION AlarmEventType_AlarmEventType = 0
	AlarmEventType_ENVIRONMENT   AlarmEventType_AlarmEventType = 1
	AlarmEventType_EQUIPMENT     AlarmEventType_AlarmEventType = 2
	AlarmEventType_SERVICE       AlarmEventType_AlarmEventType = 3
	AlarmEventType_PROCESSING    AlarmEventType_AlarmEventType = 4
	AlarmEventType_SECURITY      AlarmEventType_AlarmEventType = 5
)

var AlarmEventType_AlarmEventType_name = map[int32]string{
	0: "COMMUNICATION",
	1: "ENVIRONMENT",
	2: "EQUIPMENT",
	3: "SERVICE",
	4: "PROCESSING",
	5: "SECURITY",
}
var AlarmEventType_AlarmEventType_value = map[string]int32{
	"COMMUNICATION": 0,
	"ENVIRONMENT":   1,
	"EQUIPMENT":     2,
	"SERVICE":       3,
	"PROCESSING":    4,
	"SECURITY":      5,
}

func (x AlarmEventType_AlarmEventType) String() string {
	return proto.EnumName(AlarmEventType_AlarmEventType_name, int32(x))
}
func (AlarmEventType_AlarmEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{5, 0}
}

type AlarmEventCategory_AlarmEventCategory int32

const (
	AlarmEventCategory_PON AlarmEventCategory_AlarmEventCategory = 0
)

var AlarmEventCategory_AlarmEventCategory_name = map[int32]string{
	0: "PON",
}
var AlarmEventCategory_AlarmEventCategory_value = map[string]int32{
	"PON": 0,
}

func (x AlarmEventCategory_AlarmEventCategory) String() string {
	return proto.EnumName(AlarmEventCategory_AlarmEventCategory_name, int32(x))
}
func (AlarmEventCategory_AlarmEventCategory) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{6, 0}
}

type AlarmEventState_AlarmEventState int32

const (
	AlarmEventState_RAISED  AlarmEventState_AlarmEventState = 0
	AlarmEventState_CLEARED AlarmEventState_AlarmEventState = 1
)

var AlarmEventState_AlarmEventState_name = map[int32]string{
	0: "RAISED",
	1: "CLEARED",
}
var AlarmEventState_AlarmEventState_value = map[string]int32{
	"RAISED":  0,
	"CLEARED": 1,
}

func (x AlarmEventState_AlarmEventState) String() string {
	return proto.EnumName(AlarmEventState_AlarmEventState_name, int32(x))
}
func (AlarmEventState_AlarmEventState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{7, 0}
}

type AlarmEventSeverity_AlarmEventSeverity int32

const (
	AlarmEventSeverity_INDETERMINATE AlarmEventSeverity_AlarmEventSeverity = 0
	AlarmEventSeverity_WARNING       AlarmEventSeverity_AlarmEventSeverity = 1
	AlarmEventSeverity_MINOR         AlarmEventSeverity_AlarmEventSeverity = 2
	AlarmEventSeverity_MAJOR         AlarmEventSeverity_AlarmEventSeverity = 3
	AlarmEventSeverity_CRITICAL      AlarmEventSeverity_AlarmEventSeverity = 4
)

var AlarmEventSeverity_AlarmEventSeverity_name = map[int32]string{
	0: "INDETERMINATE",
	1: "WARNING",
	2: "MINOR",
	3: "MAJOR",
	4: "CRITICAL",
}
var AlarmEventSeverity_AlarmEventSeverity_value = map[string]int32{
	"INDETERMINATE": 0,
	"WARNING":       1,
	"MINOR":         2,
	"MAJOR":         3,
	"CRITICAL":      4,
}

func (x AlarmEventSeverity_AlarmEventSeverity) String() string {
	return proto.EnumName(AlarmEventSeverity_AlarmEventSeverity_name, int32(x))
}
func (AlarmEventSeverity_AlarmEventSeverity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{8, 0}
}

type ConfigEventType struct {
}

func (m *ConfigEventType) Reset()                    { *m = ConfigEventType{} }
func (m *ConfigEventType) String() string            { return proto.CompactTextString(m) }
func (*ConfigEventType) ProtoMessage()               {}
func (*ConfigEventType) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type ConfigEvent struct {
	Type ConfigEventType_ConfigEventType `protobuf:"varint,1,opt,name=type,enum=voltha.ConfigEventType_ConfigEventType" json:"type,omitempty"`
	Hash string                          `protobuf:"bytes,2,opt,name=hash" json:"hash,omitempty"`
	Data string                          `protobuf:"bytes,3,opt,name=data" json:"data,omitempty"`
}

func (m *ConfigEvent) Reset()                    { *m = ConfigEvent{} }
func (m *ConfigEvent) String() string            { return proto.CompactTextString(m) }
func (*ConfigEvent) ProtoMessage()               {}
func (*ConfigEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ConfigEvent) GetType() ConfigEventType_ConfigEventType {
	if m != nil {
		return m.Type
	}
	return ConfigEventType_add
}

func (m *ConfigEvent) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *ConfigEvent) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

type KpiEventType struct {
}

func (m *KpiEventType) Reset()                    { *m = KpiEventType{} }
func (m *KpiEventType) String() string            { return proto.CompactTextString(m) }
func (*KpiEventType) ProtoMessage()               {}
func (*KpiEventType) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

//
// Struct to convey a dictionary of metric->value pairs. Typically used in
// pure shared-timestamp or shared-timestamp + shared object prefix situations.
type MetricValuePairs struct {
	// Metric / value pairs.
	Metrics map[string]float32 `protobuf:"bytes,1,rep,name=metrics" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"fixed32,2,opt,name=value"`
}

func (m *MetricValuePairs) Reset()                    { *m = MetricValuePairs{} }
func (m *MetricValuePairs) String() string            { return proto.CompactTextString(m) }
func (*MetricValuePairs) ProtoMessage()               {}
func (*MetricValuePairs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *MetricValuePairs) GetMetrics() map[string]float32 {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type KpiEvent struct {
	Type     KpiEventType_KpiEventType    `protobuf:"varint,1,opt,name=type,enum=voltha.KpiEventType_KpiEventType" json:"type,omitempty"`
	Ts       float32                      `protobuf:"fixed32,2,opt,name=ts" json:"ts,omitempty"`
	Prefixes map[string]*MetricValuePairs `protobuf:"bytes,3,rep,name=prefixes" json:"prefixes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *KpiEvent) Reset()                    { *m = KpiEvent{} }
func (m *KpiEvent) String() string            { return proto.CompactTextString(m) }
func (*KpiEvent) ProtoMessage()               {}
func (*KpiEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *KpiEvent) GetType() KpiEventType_KpiEventType {
	if m != nil {
		return m.Type
	}
	return KpiEventType_slice
}

func (m *KpiEvent) GetTs() float32 {
	if m != nil {
		return m.Ts
	}
	return 0
}

func (m *KpiEvent) GetPrefixes() map[string]*MetricValuePairs {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

//
// Identify to the area of the system impacted by the alarm
type AlarmEventType struct {
}

func (m *AlarmEventType) Reset()                    { *m = AlarmEventType{} }
func (m *AlarmEventType) String() string            { return proto.CompactTextString(m) }
func (*AlarmEventType) ProtoMessage()               {}
func (*AlarmEventType) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

//
// Identify to the functional category originating the alarm
type AlarmEventCategory struct {
}

func (m *AlarmEventCategory) Reset()                    { *m = AlarmEventCategory{} }
func (m *AlarmEventCategory) String() string            { return proto.CompactTextString(m) }
func (*AlarmEventCategory) ProtoMessage()               {}
func (*AlarmEventCategory) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

//
// Active state of the alarm
type AlarmEventState struct {
}

func (m *AlarmEventState) Reset()                    { *m = AlarmEventState{} }
func (m *AlarmEventState) String() string            { return proto.CompactTextString(m) }
func (*AlarmEventState) ProtoMessage()               {}
func (*AlarmEventState) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

//
// Identify the overall impact of the alarm on the system
type AlarmEventSeverity struct {
}

func (m *AlarmEventSeverity) Reset()                    { *m = AlarmEventSeverity{} }
func (m *AlarmEventSeverity) String() string            { return proto.CompactTextString(m) }
func (*AlarmEventSeverity) ProtoMessage()               {}
func (*AlarmEventSeverity) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

//
//
type AlarmEvent struct {
	// Unique ID for this alarm.  e.g. voltha.some_olt.1234
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Refers to the area of the system impacted by the alarm
	Type AlarmEventType_AlarmEventType `protobuf:"varint,2,opt,name=type,enum=voltha.AlarmEventType_AlarmEventType" json:"type,omitempty"`
	// Refers to functional category of the alarm
	Category AlarmEventCategory_AlarmEventCategory `protobuf:"varint,3,opt,name=category,enum=voltha.AlarmEventCategory_AlarmEventCategory" json:"category,omitempty"`
	// Current active state of the alarm
	State AlarmEventState_AlarmEventState `protobuf:"varint,4,opt,name=state,enum=voltha.AlarmEventState_AlarmEventState" json:"state,omitempty"`
	// Overall impact of the alarm on the system
	Severity AlarmEventSeverity_AlarmEventSeverity `protobuf:"varint,5,opt,name=severity,enum=voltha.AlarmEventSeverity_AlarmEventSeverity" json:"severity,omitempty"`
	// Timestamp at which the alarm was first raised
	RaisedTs float32 `protobuf:"fixed32,6,opt,name=raised_ts,json=raisedTs" json:"raised_ts,omitempty"`
	// Timestamp at which the alarm was reported
	ReportedTs float32 `protobuf:"fixed32,7,opt,name=reported_ts,json=reportedTs" json:"reported_ts,omitempty"`
	// Timestamp at which the alarm has changed since it was raised
	ChangedTs float32 `protobuf:"fixed32,8,opt,name=changed_ts,json=changedTs" json:"changed_ts,omitempty"`
	// Identifier of the originating resource of the alarm
	ResourceId string `protobuf:"bytes,9,opt,name=resource_id,json=resourceId" json:"resource_id,omitempty"`
	// Textual explanation of the alarm
	Description string `protobuf:"bytes,10,opt,name=description" json:"description,omitempty"`
	// Key/Value storage for extra information that may give context to the alarm
	Context map[string]string `protobuf:"bytes,11,rep,name=context" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *AlarmEvent) Reset()                    { *m = AlarmEvent{} }
func (m *AlarmEvent) String() string            { return proto.CompactTextString(m) }
func (*AlarmEvent) ProtoMessage()               {}
func (*AlarmEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *AlarmEvent) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AlarmEvent) GetType() AlarmEventType_AlarmEventType {
	if m != nil {
		return m.Type
	}
	return AlarmEventType_COMMUNICATION
}

func (m *AlarmEvent) GetCategory() AlarmEventCategory_AlarmEventCategory {
	if m != nil {
		return m.Category
	}
	return AlarmEventCategory_PON
}

func (m *AlarmEvent) GetState() AlarmEventState_AlarmEventState {
	if m != nil {
		return m.State
	}
	return AlarmEventState_RAISED
}

func (m *AlarmEvent) GetSeverity() AlarmEventSeverity_AlarmEventSeverity {
	if m != nil {
		return m.Severity
	}
	return AlarmEventSeverity_INDETERMINATE
}

func (m *AlarmEvent) GetRaisedTs() float32 {
	if m != nil {
		return m.RaisedTs
	}
	return 0
}

func (m *AlarmEvent) GetReportedTs() float32 {
	if m != nil {
		return m.ReportedTs
	}
	return 0
}

func (m *AlarmEvent) GetChangedTs() float32 {
	if m != nil {
		return m.ChangedTs
	}
	return 0
}

func (m *AlarmEvent) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *AlarmEvent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AlarmEvent) GetContext() map[string]string {
	if m != nil {
		return m.Context
	}
	return nil
}

func init() {
	proto.RegisterType((*ConfigEventType)(nil), "voltha.ConfigEventType")
	proto.RegisterType((*ConfigEvent)(nil), "voltha.ConfigEvent")
	proto.RegisterType((*KpiEventType)(nil), "voltha.KpiEventType")
	proto.RegisterType((*MetricValuePairs)(nil), "voltha.MetricValuePairs")
	proto.RegisterType((*KpiEvent)(nil), "voltha.KpiEvent")
	proto.RegisterType((*AlarmEventType)(nil), "voltha.AlarmEventType")
	proto.RegisterType((*AlarmEventCategory)(nil), "voltha.AlarmEventCategory")
	proto.RegisterType((*AlarmEventState)(nil), "voltha.AlarmEventState")
	proto.RegisterType((*AlarmEventSeverity)(nil), "voltha.AlarmEventSeverity")
	proto.RegisterType((*AlarmEvent)(nil), "voltha.AlarmEvent")
	proto.RegisterEnum("voltha.ConfigEventType_ConfigEventType", ConfigEventType_ConfigEventType_name, ConfigEventType_ConfigEventType_value)
	proto.RegisterEnum("voltha.KpiEventType_KpiEventType", KpiEventType_KpiEventType_name, KpiEventType_KpiEventType_value)
	proto.RegisterEnum("voltha.AlarmEventType_AlarmEventType", AlarmEventType_AlarmEventType_name, AlarmEventType_AlarmEventType_value)
	proto.RegisterEnum("voltha.AlarmEventCategory_AlarmEventCategory", AlarmEventCategory_AlarmEventCategory_name, AlarmEventCategory_AlarmEventCategory_value)
	proto.RegisterEnum("voltha.AlarmEventState_AlarmEventState", AlarmEventState_AlarmEventState_name, AlarmEventState_AlarmEventState_value)
	proto.RegisterEnum("voltha.AlarmEventSeverity_AlarmEventSeverity", AlarmEventSeverity_AlarmEventSeverity_name, AlarmEventSeverity_AlarmEventSeverity_value)
}

func init() { proto.RegisterFile("events.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 775 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x55, 0xef, 0x6e, 0xe3, 0x44,
	0x10, 0xaf, 0x9d, 0xbf, 0x1e, 0xb7, 0xe9, 0xb2, 0xe2, 0x83, 0x55, 0x38, 0xae, 0x67, 0x09, 0x51,
	0x21, 0x91, 0x13, 0x39, 0x21, 0x71, 0x45, 0x27, 0x64, 0xb9, 0x2b, 0x64, 0xb8, 0x38, 0x61, 0xe3,
	0x16, 0xf8, 0x74, 0x5a, 0xe2, 0xbd, 0xd4, 0x22, 0xb5, 0x2d, 0xef, 0x36, 0xba, 0x7c, 0xe3, 0x0d,
	0x78, 0x28, 0x5e, 0x85, 0x07, 0x41, 0xbb, 0xb6, 0x1b, 0xc7, 0x4d, 0x75, 0xdf, 0x66, 0x7e, 0xf3,
	0xc7, 0xf3, 0x9b, 0x9d, 0x19, 0xc3, 0x31, 0xdf, 0xf0, 0x54, 0x8a, 0x71, 0x5e, 0x64, 0x32, 0xc3,
	0xfd, 0x4d, 0xb6, 0x96, 0xb7, 0xec, 0x0c, 0xee, 0xb8, 0x64, 0x25, 0x76, 0xf6, 0xf9, 0x2a, 0xcb,
	0x56, 0x6b, 0xfe, 0x92, 0xe5, 0xc9, 0x4b, 0x96, 0xa6, 0x99, 0x64, 0x32, 0xc9, 0xd2, 0x2a, 0xc2,
	0x25, 0x70, 0xea, 0x67, 0xe9, 0xfb, 0x64, 0x45, 0x54, 0x9e, 0x68, 0x9b, 0x73, 0x77, 0xf2, 0x08,
	0xc2, 0x03, 0xe8, 0xb0, 0x38, 0x46, 0x47, 0x18, 0xa0, 0x5f, 0xf0, 0xbb, 0x6c, 0xc3, 0x91, 0xa1,
	0xe4, 0xfb, 0x3c, 0x66, 0x92, 0x23, 0xd3, 0x2d, 0xc0, 0x6e, 0xc4, 0xe0, 0x1f, 0xa0, 0x2b, 0xb7,
	0x39, 0x77, 0x8c, 0x73, 0xe3, 0x62, 0x34, 0xf9, 0x6a, 0x5c, 0x96, 0x35, 0x6e, 0xa5, 0x6d, 0xeb,
	0x54, 0x07, 0x61, 0x0c, 0xdd, 0x5b, 0x26, 0x6e, 0x1d, 0xf3, 0xdc, 0xb8, 0xb0, 0xa8, 0x96, 0x15,
	0x16, 0x33, 0xc9, 0x9c, 0x4e, 0x89, 0x29, 0xd9, 0xfd, 0x16, 0x8e, 0x7f, 0xc9, 0x93, 0x5d, 0xdd,
	0x2f, 0xf6, 0x75, 0x6c, 0x41, 0x4f, 0xac, 0x93, 0x25, 0x47, 0x47, 0xb8, 0x0f, 0xa6, 0x14, 0xc8,
	0x70, 0xff, 0x31, 0x00, 0x4d, 0xb9, 0x2c, 0x92, 0xe5, 0x0d, 0x5b, 0xdf, 0xf3, 0x39, 0x4b, 0x0a,
	0x81, 0x7f, 0x84, 0xc1, 0x9d, 0xc6, 0x84, 0x63, 0x9c, 0x77, 0x2e, 0xec, 0xc9, 0x97, 0x75, 0xbd,
	0x6d, 0xd7, 0x0a, 0x10, 0x24, 0x95, 0xc5, 0x96, 0xd6, 0x51, 0x67, 0x97, 0x70, 0xdc, 0x34, 0x60,
	0x04, 0x9d, 0xbf, 0xf8, 0x56, 0x93, 0xb7, 0xa8, 0x12, 0xf1, 0xa7, 0xd0, 0xdb, 0xa8, 0x2c, 0x9a,
	0x93, 0x49, 0x4b, 0xe5, 0xd2, 0xfc, 0xde, 0x70, 0xff, 0x33, 0x60, 0x58, 0x57, 0x8d, 0xbf, 0xdb,
	0x6b, 0xdb, 0x8b, 0xba, 0x8c, 0x26, 0xab, 0x3d, 0xa5, 0x6a, 0xd8, 0x48, 0xb1, 0xab, 0x52, 0x9b,
	0x52, 0xe0, 0x4b, 0x18, 0xe6, 0x05, 0x7f, 0x9f, 0x7c, 0xe0, 0xc2, 0xe9, 0x68, 0x46, 0x5f, 0xb4,
	0x53, 0x8d, 0xe7, 0x95, 0x43, 0x49, 0xe5, 0xc1, 0xff, 0xec, 0x1a, 0x4e, 0xf6, 0x4c, 0x07, 0xc8,
	0x8c, 0x9b, 0x64, 0xec, 0x89, 0xf3, 0x54, 0xb7, 0x9a, 0x34, 0xff, 0x36, 0x60, 0xe4, 0xad, 0x59,
	0x71, 0xb7, 0x7b, 0xae, 0xb4, 0x8d, 0xe0, 0x4f, 0xe0, 0xc4, 0x9f, 0x4d, 0xa7, 0xd7, 0x61, 0xe0,
	0x7b, 0x51, 0x30, 0x0b, 0xd1, 0x11, 0x3e, 0x05, 0x9b, 0x84, 0x37, 0x01, 0x9d, 0x85, 0x53, 0x12,
	0x46, 0xc8, 0xc0, 0x27, 0x60, 0x91, 0x5f, 0xaf, 0x83, 0xb9, 0x56, 0x4d, 0x6c, 0xc3, 0x60, 0x41,
	0xe8, 0x4d, 0xe0, 0x13, 0xd4, 0xc1, 0x23, 0x80, 0x39, 0x9d, 0xf9, 0x64, 0xb1, 0x08, 0xc2, 0x9f,
	0x50, 0x17, 0x1f, 0xc3, 0x70, 0x41, 0xfc, 0x6b, 0x1a, 0x44, 0x7f, 0xa0, 0x9e, 0xfb, 0x0a, 0xf0,
	0xee, 0x7b, 0x3e, 0x93, 0x7c, 0x95, 0x15, 0x5b, 0xf7, 0xd9, 0x21, 0x54, 0xcd, 0xfb, 0x5c, 0x7d,
	0xdf, 0x7d, 0x03, 0xa7, 0x3b, 0xf3, 0x42, 0x32, 0xc9, 0xdd, 0xaf, 0x1f, 0x41, 0x6a, 0x13, 0xa8,
	0x17, 0x2c, 0xc8, 0x15, 0x3a, 0x52, 0x15, 0xf9, 0x6f, 0x89, 0x47, 0xc9, 0x15, 0x32, 0xdc, 0xb4,
	0x99, 0x7d, 0xc1, 0x37, 0xbc, 0x48, 0xe4, 0xd6, 0xfd, 0xfd, 0x10, 0xaa, 0xd8, 0x07, 0xe1, 0x15,
	0x89, 0x08, 0x9d, 0x06, 0xa1, 0x17, 0x91, 0x32, 0xd7, 0x6f, 0x1e, 0x0d, 0x15, 0x1b, 0x43, 0x8d,
	0xf3, 0x34, 0x08, 0x67, 0x14, 0x99, 0x5a, 0xf4, 0x7e, 0x9e, 0x51, 0xd4, 0x51, 0x1c, 0x7d, 0x1a,
	0x44, 0x81, 0xef, 0xbd, 0x45, 0x5d, 0xf7, 0xdf, 0x2e, 0xc0, 0x2e, 0xb5, 0x1a, 0x8c, 0x24, 0xae,
	0x9e, 0xce, 0x4c, 0x62, 0xfc, 0xba, 0x9a, 0x2f, 0x53, 0xcf, 0xd7, 0xc3, 0x98, 0xef, 0x3f, 0x43,
	0x4b, 0xad, 0x66, 0x2c, 0x80, 0xe1, 0xb2, 0xea, 0x8e, 0x5e, 0xc2, 0xd1, 0xe4, 0x9b, 0xc7, 0xe1,
	0x75, 0xff, 0x0e, 0x40, 0xf4, 0x21, 0x1c, 0xbf, 0x81, 0x9e, 0x50, 0x6d, 0x73, 0xba, 0xfb, 0xd7,
	0xa1, 0xd5, 0xd5, 0xb6, 0x4e, 0xcb, 0x28, 0x55, 0x89, 0xa8, 0x7a, 0xe6, 0xf4, 0x9e, 0xaa, 0xa4,
	0xee, 0xea, 0x01, 0x88, 0x3e, 0x84, 0xe3, 0xcf, 0xc0, 0x2a, 0x58, 0x22, 0x78, 0xfc, 0x4e, 0x0a,
	0xa7, 0xaf, 0xf7, 0x67, 0x58, 0x02, 0x91, 0xc0, 0xcf, 0xc1, 0x2e, 0x78, 0x9e, 0x15, 0xb2, 0x34,
	0x0f, 0xb4, 0x19, 0x6a, 0x28, 0x12, 0xf8, 0x19, 0xc0, 0xf2, 0x96, 0xa5, 0xab, 0xd2, 0x3e, 0xd4,
	0x76, 0xab, 0x42, 0xea, 0x78, 0x91, 0xdd, 0x17, 0x4b, 0xfe, 0x2e, 0x89, 0x1d, 0x4b, 0xbf, 0x02,
	0xd4, 0x50, 0x10, 0xe3, 0x73, 0xb0, 0x63, 0x2e, 0x96, 0x45, 0x92, 0xab, 0x83, 0xec, 0x80, 0x76,
	0x68, 0x42, 0xf8, 0x35, 0x0c, 0x96, 0x59, 0x2a, 0xf9, 0x07, 0xe9, 0xd8, 0x7a, 0x8f, 0x9f, 0x3f,
	0x66, 0xaa, 0x8e, 0xa8, 0xf2, 0xa8, 0x6e, 0x52, 0xe5, 0xaf, 0x6e, 0x52, 0xd3, 0xf0, 0xb1, 0x9b,
	0x64, 0x35, 0x96, 0xf5, 0xcf, 0xbe, 0xfe, 0x35, 0xbc, 0xfa, 0x3f, 0x00, 0x00, 0xff, 0xff, 0x27,
	0x78, 0x37, 0x67, 0x5c, 0x06, 0x00, 0x00,
}
