# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template module.py
# Do not modify

import struct
import loxi
import util
import loxi.generic_util

import sys
ofp = sys.modules['loxi.of14']

class bsn_tlv(loxi.OFObject):
    subtypes = {}


    def __init__(self, type=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 0)
        subclass = bsn_tlv.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = bsn_tlv()
        obj.type = reader.read("!H")[0]
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_tlv {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class actor_key(bsn_tlv):
    type = 44

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = actor_key()
        _type = reader.read("!H")[0]
        assert(_type == 44)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("actor_key {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[44] = actor_key

class actor_port_num(bsn_tlv):
    type = 43

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = actor_port_num()
        _type = reader.read("!H")[0]
        assert(_type == 43)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("actor_port_num {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[43] = actor_port_num

class actor_port_priority(bsn_tlv):
    type = 42

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = actor_port_priority()
        _type = reader.read("!H")[0]
        assert(_type == 42)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("actor_port_priority {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[42] = actor_port_priority

class actor_state(bsn_tlv):
    type = 53

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = actor_state()
        _type = reader.read("!H")[0]
        assert(_type == 53)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("actor_state {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[53] = actor_state

class actor_system_mac(bsn_tlv):
    type = 41

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = actor_system_mac()
        _type = reader.read("!H")[0]
        assert(_type == 41)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("actor_system_mac {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[41] = actor_system_mac

class actor_system_priority(bsn_tlv):
    type = 40

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = actor_system_priority()
        _type = reader.read("!H")[0]
        assert(_type == 40)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("actor_system_priority {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[40] = actor_system_priority

class anchor(bsn_tlv):
    type = 81

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = anchor()
        _type = reader.read("!H")[0]
        assert(_type == 81)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("anchor {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[81] = anchor

class broadcast_query_timeout(bsn_tlv):
    type = 10

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = broadcast_query_timeout()
        _type = reader.read("!H")[0]
        assert(_type == 10)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("broadcast_query_timeout {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[10] = broadcast_query_timeout

class broadcast_rate(bsn_tlv):
    type = 90

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = broadcast_rate()
        _type = reader.read("!H")[0]
        assert(_type == 90)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("broadcast_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[90] = broadcast_rate

class bucket(bsn_tlv):
    type = 64

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bucket()
        _type = reader.read("!H")[0]
        assert(_type == 64)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = loxi.generic_util.unpack_list(reader, ofp.bsn_tlv.bsn_tlv.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bucket {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[64] = bucket

class circuit_id(bsn_tlv):
    type = 14

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(self.value)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = circuit_id()
        _type = reader.read("!H")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("circuit_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[14] = circuit_id

class convergence_status(bsn_tlv):
    type = 45

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = convergence_status()
        _type = reader.read("!H")[0]
        assert(_type == 45)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("convergence_status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[45] = convergence_status

class crc_enabled(bsn_tlv):
    type = 22

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = crc_enabled()
        _type = reader.read("!H")[0]
        assert(_type == 22)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("crc_enabled {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[22] = crc_enabled

class data(bsn_tlv):
    type = 55

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(self.value)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = data()
        _type = reader.read("!H")[0]
        assert(_type == 55)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("data {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[55] = data

class decap(bsn_tlv):
    type = 85

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = decap()
        _type = reader.read("!H")[0]
        assert(_type == 85)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("decap {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[85] = decap

class eth_dst(bsn_tlv):
    type = 33

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = eth_dst()
        _type = reader.read("!H")[0]
        assert(_type == 33)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("eth_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[33] = eth_dst

class eth_src(bsn_tlv):
    type = 32

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = eth_src()
        _type = reader.read("!H")[0]
        assert(_type == 32)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("eth_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[32] = eth_src

class external_gateway_ip(bsn_tlv):
    type = 26

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = external_gateway_ip()
        _type = reader.read("!H")[0]
        assert(_type == 26)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("external_gateway_ip {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[26] = external_gateway_ip

class external_gateway_mac(bsn_tlv):
    type = 29

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = external_gateway_mac()
        _type = reader.read("!H")[0]
        assert(_type == 29)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("external_gateway_mac {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[29] = external_gateway_mac

class external_ip(bsn_tlv):
    type = 23

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = external_ip()
        _type = reader.read("!H")[0]
        assert(_type == 23)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("external_ip {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[23] = external_ip

class external_mac(bsn_tlv):
    type = 24

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = external_mac()
        _type = reader.read("!H")[0]
        assert(_type == 24)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("external_mac {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[24] = external_mac

class external_netmask(bsn_tlv):
    type = 25

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = external_netmask()
        _type = reader.read("!H")[0]
        assert(_type == 25)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("external_netmask {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[25] = external_netmask

class generation_id(bsn_tlv):
    type = 80

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = generation_id()
        _type = reader.read("!H")[0]
        assert(_type == 80)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("generation_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[80] = generation_id

class hash_packet_field(bsn_tlv):
    type = 103

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = hash_packet_field()
        _type = reader.read("!H")[0]
        assert(_type == 103)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("hash_packet_field {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[103] = hash_packet_field

class hash_packet_type(bsn_tlv):
    type = 102

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = hash_packet_type()
        _type = reader.read("!H")[0]
        assert(_type == 102)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("hash_packet_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[102] = hash_packet_type

class hash_seed(bsn_tlv):
    type = 100

    def __init__(self, seed1=None, seed2=None):
        if seed1 != None:
            self.seed1 = seed1
        else:
            self.seed1 = 0
        if seed2 != None:
            self.seed2 = seed2
        else:
            self.seed2 = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.seed1))
        packed.append(struct.pack("!L", self.seed2))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = hash_seed()
        _type = reader.read("!H")[0]
        assert(_type == 100)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.seed1 = reader.read("!L")[0]
        obj.seed2 = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.seed1 != other.seed1: return False
        if self.seed2 != other.seed2: return False
        return True

    def pretty_print(self, q):
        q.text("hash_seed {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("seed1 = ");
                q.text("%#x" % self.seed1)
                q.text(","); q.breakable()
                q.text("seed2 = ");
                q.text("%#x" % self.seed2)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[100] = hash_seed

class hash_type(bsn_tlv):
    type = 101

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = hash_type()
        _type = reader.read("!H")[0]
        assert(_type == 101)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("hash_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[101] = hash_type

class header_size(bsn_tlv):
    type = 31

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = header_size()
        _type = reader.read("!H")[0]
        assert(_type == 31)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("header_size {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[31] = header_size

class icmp_code(bsn_tlv):
    type = 69

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmp_code()
        _type = reader.read("!H")[0]
        assert(_type == 69)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("icmp_code {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[69] = icmp_code

class icmp_id(bsn_tlv):
    type = 70

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmp_id()
        _type = reader.read("!H")[0]
        assert(_type == 70)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("icmp_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[70] = icmp_id

class icmp_type(bsn_tlv):
    type = 68

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = icmp_type()
        _type = reader.read("!H")[0]
        assert(_type == 68)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("icmp_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[68] = icmp_type

class idle_notification(bsn_tlv):
    type = 7

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = idle_notification()
        _type = reader.read("!H")[0]
        assert(_type == 7)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("idle_notification {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[7] = idle_notification

class idle_time(bsn_tlv):
    type = 5

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = idle_time()
        _type = reader.read("!H")[0]
        assert(_type == 5)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("idle_time {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[5] = idle_time

class idle_timeout(bsn_tlv):
    type = 8

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = idle_timeout()
        _type = reader.read("!H")[0]
        assert(_type == 8)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("idle_timeout {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[8] = idle_timeout

class igmp_snooping(bsn_tlv):
    type = 78

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = igmp_snooping()
        _type = reader.read("!H")[0]
        assert(_type == 78)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("igmp_snooping {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[78] = igmp_snooping

class internal_gateway_mac(bsn_tlv):
    type = 28

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = internal_gateway_mac()
        _type = reader.read("!H")[0]
        assert(_type == 28)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("internal_gateway_mac {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[28] = internal_gateway_mac

class internal_mac(bsn_tlv):
    type = 27

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = internal_mac()
        _type = reader.read("!H")[0]
        assert(_type == 27)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("internal_mac {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[27] = internal_mac

class interval(bsn_tlv):
    type = 58

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = interval()
        _type = reader.read("!H")[0]
        assert(_type == 58)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("interval {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[58] = interval

class ip_proto(bsn_tlv):
    type = 67

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ip_proto()
        _type = reader.read("!H")[0]
        assert(_type == 67)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ip_proto {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[67] = ip_proto

class ipv4(bsn_tlv):
    type = 4

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv4()
        _type = reader.read("!H")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv4 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[4] = ipv4

class ipv4_dst(bsn_tlv):
    type = 35

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv4_dst()
        _type = reader.read("!H")[0]
        assert(_type == 35)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv4_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[35] = ipv4_dst

class ipv4_netmask(bsn_tlv):
    type = 60

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv4_netmask()
        _type = reader.read("!H")[0]
        assert(_type == 60)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv4_netmask {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[60] = ipv4_netmask

class ipv4_src(bsn_tlv):
    type = 34

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv4_src()
        _type = reader.read("!H")[0]
        assert(_type == 34)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv4_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[34] = ipv4_src

class ipv6(bsn_tlv):
    type = 84

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!16s", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ipv6()
        _type = reader.read("!H")[0]
        assert(_type == 84)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("ipv6 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[84] = ipv6

class known_multicast_rate(bsn_tlv):
    type = 91

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = known_multicast_rate()
        _type = reader.read("!H")[0]
        assert(_type == 91)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("known_multicast_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[91] = known_multicast_rate

class l2_multicast_lookup(bsn_tlv):
    type = 79

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = l2_multicast_lookup()
        _type = reader.read("!H")[0]
        assert(_type == 79)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("l2_multicast_lookup {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[79] = l2_multicast_lookup

class mac(bsn_tlv):
    type = 1

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mac()
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("mac {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[1] = mac

class mac_mask(bsn_tlv):
    type = 56

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mac_mask()
        _type = reader.read("!H")[0]
        assert(_type == 56)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("mac_mask {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[56] = mac_mask

class mcg_type_vxlan(bsn_tlv):
    type = 87

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mcg_type_vxlan()
        _type = reader.read("!H")[0]
        assert(_type == 87)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("mcg_type_vxlan {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[87] = mcg_type_vxlan

class miss_packets(bsn_tlv):
    type = 13

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = miss_packets()
        _type = reader.read("!H")[0]
        assert(_type == 13)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("miss_packets {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[13] = miss_packets

class mpls_control_word(bsn_tlv):
    type = 62

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_control_word()
        _type = reader.read("!H")[0]
        assert(_type == 62)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_control_word {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[62] = mpls_control_word

class mpls_label(bsn_tlv):
    type = 61

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_label()
        _type = reader.read("!H")[0]
        assert(_type == 61)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_label {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[61] = mpls_label

class mpls_sequenced(bsn_tlv):
    type = 63

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = mpls_sequenced()
        _type = reader.read("!H")[0]
        assert(_type == 63)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("mpls_sequenced {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[63] = mpls_sequenced

class multicast_interface_id(bsn_tlv):
    type = 95

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = multicast_interface_id()
        _type = reader.read("!H")[0]
        assert(_type == 95)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("multicast_interface_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[95] = multicast_interface_id

class name(bsn_tlv):
    type = 52

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(self.value)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = name()
        _type = reader.read("!H")[0]
        assert(_type == 52)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("name {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[52] = name

class negate(bsn_tlv):
    type = 83

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = negate()
        _type = reader.read("!H")[0]
        assert(_type == 83)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("negate {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[83] = negate

class nexthop_type_vxlan(bsn_tlv):
    type = 94

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = nexthop_type_vxlan()
        _type = reader.read("!H")[0]
        assert(_type == 94)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("nexthop_type_vxlan {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[94] = nexthop_type_vxlan

class offset(bsn_tlv):
    type = 82

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = offset()
        _type = reader.read("!H")[0]
        assert(_type == 82)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("offset {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[82] = offset

class partner_key(bsn_tlv):
    type = 51

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = partner_key()
        _type = reader.read("!H")[0]
        assert(_type == 51)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("partner_key {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[51] = partner_key

class partner_port_num(bsn_tlv):
    type = 50

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = partner_port_num()
        _type = reader.read("!H")[0]
        assert(_type == 50)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("partner_port_num {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[50] = partner_port_num

class partner_port_priority(bsn_tlv):
    type = 49

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = partner_port_priority()
        _type = reader.read("!H")[0]
        assert(_type == 49)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("partner_port_priority {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[49] = partner_port_priority

class partner_state(bsn_tlv):
    type = 54

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = partner_state()
        _type = reader.read("!H")[0]
        assert(_type == 54)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("partner_state {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[54] = partner_state

class partner_system_mac(bsn_tlv):
    type = 48

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!6B", *self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = partner_system_mac()
        _type = reader.read("!H")[0]
        assert(_type == 48)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("partner_system_mac {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[48] = partner_system_mac

class partner_system_priority(bsn_tlv):
    type = 47

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = partner_system_priority()
        _type = reader.read("!H")[0]
        assert(_type == 47)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("partner_system_priority {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[47] = partner_system_priority

class port(bsn_tlv):
    type = 0

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(util.pack_port_no(self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port()
        _type = reader.read("!H")[0]
        assert(_type == 0)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("port {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[0] = port

class port_vxlan_mode(bsn_tlv):
    type = 88

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_vxlan_mode()
        _type = reader.read("!H")[0]
        assert(_type == 88)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("port_vxlan_mode {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[88] = port_vxlan_mode

class priority(bsn_tlv):
    type = 57

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = priority()
        _type = reader.read("!H")[0]
        assert(_type == 57)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("priority {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[57] = priority

class queue_id(bsn_tlv):
    type = 20

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_id()
        _type = reader.read("!H")[0]
        assert(_type == 20)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("queue_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[20] = queue_id

class queue_weight(bsn_tlv):
    type = 21

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_weight()
        _type = reader.read("!H")[0]
        assert(_type == 21)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("queue_weight {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[21] = queue_weight

class rate_unit(bsn_tlv):
    type = 89

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = rate_unit()
        _type = reader.read("!H")[0]
        assert(_type == 89)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("rate_unit {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[89] = rate_unit

class reference(bsn_tlv):
    type = 59

    def __init__(self, table_id=None, key=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if key != None:
            self.key = key
        else:
            self.key = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.table_id))
        packed.append(loxi.generic_util.pack_list(self.key))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = reference()
        _type = reader.read("!H")[0]
        assert(_type == 59)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.table_id = reader.read("!H")[0]
        obj.key = loxi.generic_util.unpack_list(reader, ofp.bsn_tlv.bsn_tlv.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.key != other.key: return False
        return True

    def pretty_print(self, q):
        q.text("reference {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("key = ");
                q.pp(self.key)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[59] = reference

class reply_packets(bsn_tlv):
    type = 12

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = reply_packets()
        _type = reader.read("!H")[0]
        assert(_type == 12)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("reply_packets {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[12] = reply_packets

class request_packets(bsn_tlv):
    type = 11

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = request_packets()
        _type = reader.read("!H")[0]
        assert(_type == 11)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("request_packets {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[11] = request_packets

class rx_bytes(bsn_tlv):
    type = 71

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = rx_bytes()
        _type = reader.read("!H")[0]
        assert(_type == 71)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("rx_bytes {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[71] = rx_bytes

class rx_packets(bsn_tlv):
    type = 2

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = rx_packets()
        _type = reader.read("!H")[0]
        assert(_type == 2)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("rx_packets {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[2] = rx_packets

class sampling_rate(bsn_tlv):
    type = 30

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = sampling_rate()
        _type = reader.read("!H")[0]
        assert(_type == 30)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("sampling_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[30] = sampling_rate

class set_loopback_mode(bsn_tlv):
    type = 74

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = set_loopback_mode()
        _type = reader.read("!H")[0]
        assert(_type == 74)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("set_loopback_mode {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[74] = set_loopback_mode

class status(bsn_tlv):
    type = 97

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = status()
        _type = reader.read("!H")[0]
        assert(_type == 97)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[97] = status

class strip_mpls_l2_on_ingress(bsn_tlv):
    type = 75

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = strip_mpls_l2_on_ingress()
        _type = reader.read("!H")[0]
        assert(_type == 75)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("strip_mpls_l2_on_ingress {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[75] = strip_mpls_l2_on_ingress

class strip_mpls_l3_on_ingress(bsn_tlv):
    type = 76

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = strip_mpls_l3_on_ingress()
        _type = reader.read("!H")[0]
        assert(_type == 76)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("strip_mpls_l3_on_ingress {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[76] = strip_mpls_l3_on_ingress

class strip_vlan_on_egress(bsn_tlv):
    type = 73

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = strip_vlan_on_egress()
        _type = reader.read("!H")[0]
        assert(_type == 73)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("strip_vlan_on_egress {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[73] = strip_vlan_on_egress

class sub_agent_id(bsn_tlv):
    type = 38

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = sub_agent_id()
        _type = reader.read("!H")[0]
        assert(_type == 38)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("sub_agent_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[38] = sub_agent_id

class tcp_dst(bsn_tlv):
    type = 66

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tcp_dst()
        _type = reader.read("!H")[0]
        assert(_type == 66)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tcp_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[66] = tcp_dst

class tcp_src(bsn_tlv):
    type = 65

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tcp_src()
        _type = reader.read("!H")[0]
        assert(_type == 65)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tcp_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[65] = tcp_src

class tx_bytes(bsn_tlv):
    type = 39

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tx_bytes()
        _type = reader.read("!H")[0]
        assert(_type == 39)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tx_bytes {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[39] = tx_bytes

class tx_packets(bsn_tlv):
    type = 3

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!Q", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = tx_packets()
        _type = reader.read("!H")[0]
        assert(_type == 3)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("tx_packets {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[3] = tx_packets

class udf_anchor(bsn_tlv):
    type = 16

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udf_anchor()
        _type = reader.read("!H")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("udf_anchor {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[16] = udf_anchor

class udf_id(bsn_tlv):
    type = 15

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udf_id()
        _type = reader.read("!H")[0]
        assert(_type == 15)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("udf_id {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[15] = udf_id

class udf_length(bsn_tlv):
    type = 18

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udf_length()
        _type = reader.read("!H")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("udf_length {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[18] = udf_length

class udf_offset(bsn_tlv):
    type = 17

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udf_offset()
        _type = reader.read("!H")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("udf_offset {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[17] = udf_offset

class udp_dst(bsn_tlv):
    type = 37

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udp_dst()
        _type = reader.read("!H")[0]
        assert(_type == 37)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("udp_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[37] = udp_dst

class udp_src(bsn_tlv):
    type = 36

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = udp_src()
        _type = reader.read("!H")[0]
        assert(_type == 36)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("udp_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[36] = udp_src

class unicast_query_timeout(bsn_tlv):
    type = 9

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = unicast_query_timeout()
        _type = reader.read("!H")[0]
        assert(_type == 9)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("unicast_query_timeout {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[9] = unicast_query_timeout

class unicast_rate(bsn_tlv):
    type = 93

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = unicast_rate()
        _type = reader.read("!H")[0]
        assert(_type == 93)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("unicast_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[93] = unicast_rate

class unknown_multicast_rate(bsn_tlv):
    type = 92

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = unknown_multicast_rate()
        _type = reader.read("!H")[0]
        assert(_type == 92)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("unknown_multicast_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[92] = unknown_multicast_rate

class use_packet_state(bsn_tlv):
    type = 96

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = use_packet_state()
        _type = reader.read("!H")[0]
        assert(_type == 96)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("use_packet_state {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[96] = use_packet_state

class vfi(bsn_tlv):
    type = 99

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vfi()
        _type = reader.read("!H")[0]
        assert(_type == 99)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("vfi {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[99] = vfi

class vlan_pcp(bsn_tlv):
    type = 72

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!B", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vlan_pcp()
        _type = reader.read("!H")[0]
        assert(_type == 72)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("vlan_pcp {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[72] = vlan_pcp

class vlan_vid(bsn_tlv):
    type = 6

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vlan_vid()
        _type = reader.read("!H")[0]
        assert(_type == 6)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("vlan_vid {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[6] = vlan_vid

class vlan_vid_mask(bsn_tlv):
    type = 77

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!H", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vlan_vid_mask()
        _type = reader.read("!H")[0]
        assert(_type == 77)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("vlan_vid_mask {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[77] = vlan_vid_mask

class vni(bsn_tlv):
    type = 86

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vni()
        _type = reader.read("!H")[0]
        assert(_type == 86)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("vni {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[86] = vni

class vrf(bsn_tlv):
    type = 19

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.value))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = vrf()
        _type = reader.read("!H")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("vrf {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

bsn_tlv.subtypes[19] = vrf


