# Copyright 2017-present Adtran, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from voltha.protos.events_pb2 import AlarmEventType, AlarmEventSeverity, AlarmEventCategory
from adapter_alarms import AlarmBase


class OnuDyingGaspAlarm(AlarmBase):
    def __init__(self, handler, alarm_indication, onu_id):
        super(OnuDyingGaspAlarm, self).__init__(handler, 'onu DYING_GASP',
                                                alarm='DYING_GASP',
                                                alarm_indication=alarm_indication,
                                                alarm_category=AlarmEventCategory.ONU,
                                                alarm_type=AlarmEventType.COMMUNICATION,
                                                alarm_severity=AlarmEventSeverity.MINOR)
        self._onu_id = onu_id
        self._intf_id = self.alarm_indication.intf_id

    def get_context_data(self):
        try:
            retval = {'onu-id': self._onu_id,
                      'onu-intf-id': self._intf_id,
                      "logical-device-id": self._handler.logical_device_id}
        except Exception as e:
            raise Exception(e)
        return retval
