/*
 * Copyright 2017-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Code generated by protoc-gen-go.
// source: ponsim.proto
// DO NOT EDIT!

/*
Package voltha is a generated protocol buffer package.

It is generated from these files:
	ponsim.proto

It has these top-level messages:
	PonSimDeviceInfo
	FlowTable
	PonSimPacketCounter
	PonSimPortMetrics
	PonSimMetrics
*/
package ponsim

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/empty"
import openflow_13 "github.com/opencord/voltha/netconf/translator/voltha/openflow_13"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type PonSimDeviceInfo struct {
	NniPort  int32   `protobuf:"varint,1,opt,name=nni_port,json=nniPort" json:"nni_port,omitempty"`
	UniPorts []int32 `protobuf:"varint,2,rep,packed,name=uni_ports,json=uniPorts" json:"uni_ports,omitempty"`
}

func (m *PonSimDeviceInfo) Reset()                    { *m = PonSimDeviceInfo{} }
func (m *PonSimDeviceInfo) String() string            { return proto.CompactTextString(m) }
func (*PonSimDeviceInfo) ProtoMessage()               {}
func (*PonSimDeviceInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *PonSimDeviceInfo) GetNniPort() int32 {
	if m != nil {
		return m.NniPort
	}
	return 0
}

func (m *PonSimDeviceInfo) GetUniPorts() []int32 {
	if m != nil {
		return m.UniPorts
	}
	return nil
}

type FlowTable struct {
	Port  int32                       `protobuf:"varint,1,opt,name=port" json:"port,omitempty"`
	Flows []*openflow_13.OfpFlowStats `protobuf:"bytes,2,rep,name=flows" json:"flows,omitempty"`
}

func (m *FlowTable) Reset()                    { *m = FlowTable{} }
func (m *FlowTable) String() string            { return proto.CompactTextString(m) }
func (*FlowTable) ProtoMessage()               {}
func (*FlowTable) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *FlowTable) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *FlowTable) GetFlows() []*openflow_13.OfpFlowStats {
	if m != nil {
		return m.Flows
	}
	return nil
}

type PonSimPacketCounter struct {
	Name  string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Value int64  `protobuf:"varint,2,opt,name=value" json:"value,omitempty"`
}

func (m *PonSimPacketCounter) Reset()                    { *m = PonSimPacketCounter{} }
func (m *PonSimPacketCounter) String() string            { return proto.CompactTextString(m) }
func (*PonSimPacketCounter) ProtoMessage()               {}
func (*PonSimPacketCounter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *PonSimPacketCounter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PonSimPacketCounter) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type PonSimPortMetrics struct {
	PortName string                 `protobuf:"bytes,1,opt,name=port_name,json=portName" json:"port_name,omitempty"`
	Packets  []*PonSimPacketCounter `protobuf:"bytes,2,rep,name=packets" json:"packets,omitempty"`
}

func (m *PonSimPortMetrics) Reset()                    { *m = PonSimPortMetrics{} }
func (m *PonSimPortMetrics) String() string            { return proto.CompactTextString(m) }
func (*PonSimPortMetrics) ProtoMessage()               {}
func (*PonSimPortMetrics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *PonSimPortMetrics) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *PonSimPortMetrics) GetPackets() []*PonSimPacketCounter {
	if m != nil {
		return m.Packets
	}
	return nil
}

type PonSimMetrics struct {
	Device  string               `protobuf:"bytes,1,opt,name=device" json:"device,omitempty"`
	Metrics []*PonSimPortMetrics `protobuf:"bytes,2,rep,name=metrics" json:"metrics,omitempty"`
}

func (m *PonSimMetrics) Reset()                    { *m = PonSimMetrics{} }
func (m *PonSimMetrics) String() string            { return proto.CompactTextString(m) }
func (*PonSimMetrics) ProtoMessage()               {}
func (*PonSimMetrics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *PonSimMetrics) GetDevice() string {
	if m != nil {
		return m.Device
	}
	return ""
}

func (m *PonSimMetrics) GetMetrics() []*PonSimPortMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func init() {
	proto.RegisterType((*PonSimDeviceInfo)(nil), "voltha.PonSimDeviceInfo")
	proto.RegisterType((*FlowTable)(nil), "voltha.FlowTable")
	proto.RegisterType((*PonSimPacketCounter)(nil), "voltha.PonSimPacketCounter")
	proto.RegisterType((*PonSimPortMetrics)(nil), "voltha.PonSimPortMetrics")
	proto.RegisterType((*PonSimMetrics)(nil), "voltha.PonSimMetrics")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for PonSim service

type PonSimClient interface {
	GetDeviceInfo(ctx context.Context, in *google_protobuf.Empty, opts ...grpc.CallOption) (*PonSimDeviceInfo, error)
	UpdateFlowTable(ctx context.Context, in *FlowTable, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
	GetStats(ctx context.Context, in *google_protobuf.Empty, opts ...grpc.CallOption) (*PonSimMetrics, error)
}

type ponSimClient struct {
	cc *grpc.ClientConn
}

func NewPonSimClient(cc *grpc.ClientConn) PonSimClient {
	return &ponSimClient{cc}
}

func (c *ponSimClient) GetDeviceInfo(ctx context.Context, in *google_protobuf.Empty, opts ...grpc.CallOption) (*PonSimDeviceInfo, error) {
	out := new(PonSimDeviceInfo)
	err := grpc.Invoke(ctx, "/voltha.PonSim/GetDeviceInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ponSimClient) UpdateFlowTable(ctx context.Context, in *FlowTable, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/voltha.PonSim/UpdateFlowTable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ponSimClient) GetStats(ctx context.Context, in *google_protobuf.Empty, opts ...grpc.CallOption) (*PonSimMetrics, error) {
	out := new(PonSimMetrics)
	err := grpc.Invoke(ctx, "/voltha.PonSim/GetStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for PonSim service

type PonSimServer interface {
	GetDeviceInfo(context.Context, *google_protobuf.Empty) (*PonSimDeviceInfo, error)
	UpdateFlowTable(context.Context, *FlowTable) (*google_protobuf.Empty, error)
	GetStats(context.Context, *google_protobuf.Empty) (*PonSimMetrics, error)
}

func RegisterPonSimServer(s *grpc.Server, srv PonSimServer) {
	s.RegisterService(&_PonSim_serviceDesc, srv)
}

func _PonSim_GetDeviceInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_protobuf.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PonSimServer).GetDeviceInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.PonSim/GetDeviceInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PonSimServer).GetDeviceInfo(ctx, req.(*google_protobuf.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _PonSim_UpdateFlowTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FlowTable)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PonSimServer).UpdateFlowTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.PonSim/UpdateFlowTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PonSimServer).UpdateFlowTable(ctx, req.(*FlowTable))
	}
	return interceptor(ctx, in, info, handler)
}

func _PonSim_GetStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_protobuf.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PonSimServer).GetStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.PonSim/GetStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PonSimServer).GetStats(ctx, req.(*google_protobuf.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _PonSim_serviceDesc = grpc.ServiceDesc{
	ServiceName: "voltha.PonSim",
	HandlerType: (*PonSimServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDeviceInfo",
			Handler:    _PonSim_GetDeviceInfo_Handler,
		},
		{
			MethodName: "UpdateFlowTable",
			Handler:    _PonSim_UpdateFlowTable_Handler,
		},
		{
			MethodName: "GetStats",
			Handler:    _PonSim_GetStats_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ponsim.proto",
}

func init() { proto.RegisterFile("ponsim.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 391 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x91, 0x41, 0x8f, 0xd3, 0x30,
	0x10, 0x85, 0x9b, 0x5d, 0x92, 0xa6, 0x03, 0x2b, 0xa8, 0x81, 0x55, 0x36, 0xbd, 0x54, 0x3e, 0xf5,
	0x94, 0xd5, 0xb6, 0xe2, 0x84, 0x04, 0x87, 0x02, 0x15, 0x48, 0xa0, 0xca, 0x85, 0x1b, 0x52, 0x94,
	0xb6, 0x4e, 0x89, 0x48, 0x3c, 0x56, 0xe2, 0xb4, 0xe2, 0x2f, 0xf2, 0xab, 0x90, 0xed, 0x84, 0xa4,
	0x88, 0xde, 0xc6, 0x33, 0xcf, 0xdf, 0x3c, 0xfb, 0xc1, 0x13, 0x89, 0xa2, 0xca, 0x8a, 0x48, 0x96,
	0xa8, 0x90, 0x78, 0x47, 0xcc, 0xd5, 0x8f, 0x24, 0x9c, 0x1c, 0x10, 0x0f, 0x39, 0xbf, 0x37, 0xdd,
	0x6d, 0x9d, 0xde, 0xf3, 0x42, 0xaa, 0x5f, 0x56, 0x14, 0x8e, 0x51, 0x72, 0x91, 0xe6, 0x78, 0x8a,
	0x1f, 0x16, 0xb6, 0x45, 0x3f, 0xc1, 0xb3, 0x35, 0x8a, 0x4d, 0x56, 0xbc, 0xe3, 0xc7, 0x6c, 0xc7,
	0x3f, 0x8a, 0x14, 0xc9, 0x1d, 0xf8, 0x42, 0x64, 0xb1, 0xc4, 0x52, 0x05, 0xce, 0xd4, 0x99, 0xb9,
	0x6c, 0x28, 0x44, 0xb6, 0xc6, 0x52, 0x91, 0x09, 0x8c, 0xea, 0x66, 0x54, 0x05, 0x57, 0xd3, 0xeb,
	0x99, 0xcb, 0xfc, 0xda, 0xce, 0x2a, 0xca, 0x60, 0xf4, 0x21, 0xc7, 0xd3, 0xd7, 0x64, 0x9b, 0x73,
	0x42, 0xe0, 0x51, 0x0f, 0x60, 0x6a, 0xf2, 0x00, 0xae, 0xde, 0x6e, 0x6f, 0x3e, 0x9e, 0x4f, 0xa2,
	0xbe, 0x1f, 0x4c, 0x65, 0x6c, 0xea, 0x4a, 0x25, 0xaa, 0x62, 0x56, 0x49, 0xdf, 0xc2, 0x73, 0xeb,
	0x6f, 0x9d, 0xec, 0x7e, 0x72, 0xb5, 0xc4, 0x5a, 0x28, 0x5e, 0x6a, 0xba, 0x48, 0x0a, 0x6e, 0xe8,
	0x23, 0x66, 0x6a, 0xf2, 0x02, 0xdc, 0x63, 0x92, 0xd7, 0x3c, 0xb8, 0x9a, 0x3a, 0xb3, 0x6b, 0x66,
	0x0f, 0xf4, 0x00, 0xe3, 0x06, 0x80, 0xa5, 0xfa, 0xcc, 0x55, 0x99, 0xed, 0x2a, 0xfd, 0x0c, 0x6d,
	0x28, 0xee, 0x31, 0x7c, 0xdd, 0xf8, 0xa2, 0x39, 0xaf, 0x60, 0x28, 0xcd, 0xb2, 0xce, 0xa7, 0xfd,
	0xdc, 0xe8, 0x3f, 0x4e, 0x58, 0xab, 0xa5, 0xdf, 0xe1, 0xc6, 0xce, 0xdb, 0x25, 0xb7, 0xe0, 0xed,
	0xcd, 0xa7, 0x36, 0x1b, 0x9a, 0x13, 0x59, 0xc0, 0xb0, 0xb0, 0x92, 0x86, 0x7f, 0xf7, 0x0f, 0xbf,
	0x33, 0xca, 0x5a, 0xe5, 0xfc, 0xb7, 0x03, 0x9e, 0x1d, 0x93, 0x25, 0xdc, 0xac, 0xb8, 0xea, 0xe5,
	0x75, 0x1b, 0xd9, 0xd0, 0xa3, 0x36, 0xf4, 0xe8, 0xbd, 0x0e, 0x3d, 0x0c, 0xce, 0xb9, 0xdd, 0x0d,
	0x3a, 0x20, 0x6f, 0xe0, 0xe9, 0x37, 0xb9, 0x4f, 0x14, 0xef, 0x12, 0x1b, 0xb7, 0xf2, 0xbf, 0xad,
	0xf0, 0x02, 0x99, 0x0e, 0xc8, 0x6b, 0xf0, 0x57, 0x5c, 0x6d, 0x74, 0x54, 0x17, 0xf7, 0xbf, 0x3c,
	0xdf, 0xdf, 0xbc, 0x89, 0x0e, 0xb6, 0x9e, 0x11, 0x2e, 0xfe, 0x04, 0x00, 0x00, 0xff, 0xff, 0x68,
	0x97, 0xc4, 0x14, 0xc3, 0x02, 0x00, 0x00,
}
