#Copyright 2022 - present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# FIXME Can we use the same test against BBSim and Hardware?

*** Settings ***
Documentation     Test various end-to-end scenarios
Suite Setup       Setup Suite
Test Setup        Setup
Test Teardown     Teardown
Suite Teardown    Teardown Suite
Library           Collections
Library           String
Library           OperatingSystem
Library           XML
Library           RequestsLibrary
Library           ../../libraries/DependencyLibrary.py
Resource          ../../libraries/onos.robot
Resource          ../../libraries/voltctl.robot
Resource          ../../libraries/voltha.robot
Resource          ../../libraries/utils.robot
Resource          ../../libraries/k8s.robot
Resource          ../../variables/variables.robot
Resource          ../../libraries/power_switch.robot

*** Variables ***
${POD_NAME}       flex-ocp-cord
${KUBERNETES_CONF}    ${KUBERNETES_CONFIGS_DIR}/${POD_NAME}.conf
${KUBERNETES_CONFIGS_DIR}    ~/pod-configs/kubernetes-configs
#${KUBERNETES_CONFIGS_DIR}    ${KUBERNETES_CONFIGS_DIR}/${POD_NAME}.conf
${KUBERNETES_YAML}    ${KUBERNETES_CONFIGS_DIR}/${POD_NAME}.yml
${HELM_CHARTS_DIR}    ~/helm-charts
${VOLTHA_POD_NUM}    8
${NAMESPACE}      voltha
${INFRA_NAMESPACE}      default
# For below variable value, using deployment name as using grep for
# parsing radius pod name, we can also use full radius pod name
${RESTART_POD_NAME}    radius
${timeout}        60s
${of_id}          0
${logical_id}     0
${has_dataplane}    True
${teardown_device}    True
${scripts}        ../../scripts


# Per-test logging on failure is turned off by default; set this variable to enable
${container_log_dir}    ${None}

# logging flag to enable Collect Logs, can be passed via the command line too
# example: -v logging:False
${logging}    True

# Flag specific to Soak Jobs
${SOAK_TEST}    False
${bbsim_port}    50060

#Test the actual on board configuration (Not yet used but it is a placeholder)
#${testonboardconfiguration}     False

#Suppress the subscribe phase
${suppressaddsubscriber}     False

#Enable or Disable the MacLearning verifier for MacLearning ONOS APP
${maclearningenabled}   False   #Not yet used but it is a placeholder

*** Test Cases ***
Sanity E2E Test for TIM (HSIA)
    [Documentation]     Validate the correct construction of the flow rules in ONOS and in the devices:
    ...    Flow rules in accordance with TIM Workflow.
    ...    Set up the clean TIM test environment.
    ...    Make subscriptions of all possible subscribers described in the test case.
    ...    Verify the correctness of the flow rules generated by ONOS and written in
    ...    the respective devices (OLT and ONU), about PPPoE, IGMP and LLDP Flows.
    ...    We use a Transparent VLAN approach
    ...    Perform a scalability test both for flow rules in ONOS and in devices.
    [Tags]    sanityTIM
    [Setup]    Start Logging    SanityTestTIM
    [Teardown]    Run Keywords    Run Keyword If    ${logging}    Collect Logs
    ...           AND             Stop Logging    SanityTestTIM
    Run Keyword     Setup    ${SOAK_TEST}
    Run Keyword If    ${has_dataplane}    Clean Up Linux
    Perform Sanity Test TIM     supress_add_subscriber=${suppressaddsubscriber}
    ...     maclearning_enabled=${maclearningenabled}

Sanity E2E Test for TIM (MCAST)
    [Documentation]    Validate the correct construction of the flow rules in ONOS and in the devices:
    ...    Flow rules in accordance with TIM Workflow.
    ...    Verify the correctness of the flow/group rules generated by ONOS and written in
    ...    the respective devices (OLT and ONU), about IGMP.
    ...    We use a Transparent VLAN approach.
    ...    Perform a scalability test both for flow rules in ONOS and in devices.
    [Tags]    sanityTIM-MCast    notready
    [Setup]    Start Logging    sanityTIM-MCast
    [Teardown]    Run Keywords    Run Keyword If    ${logging}    Collect Logs
    ...           AND             Stop Logging    sanityTIM-MCast
    Run Keyword If    ${has_dataplane}    Clean Up Linux
    TODO: Yet to Implement below keyword
    Perform Sanity Test TIM MCAST     supress_add_subscriber=${suppressaddsubscriber}
    ...     maclearning_enabled=${maclearningenabled}

*** Keywords ***
Setup Suite
    [Documentation]    Set up the test suite
    Common Test Suite Setup
    #power_switch.robot needs it to support different vendor's power switch
    ${switch_type}=    Get Variable Value    ${web_power_switch.type}
    Run Keyword If  "${switch_type}"!=""    Set Global Variable    ${powerswitch_type}    ${switch_type}

