// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/device.proto

package voltha

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	common "github.com/opencord/voltha-protos/v3/go/common"
	openflow_13 "github.com/opencord/voltha-protos/v3/go/openflow_13"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PmConfig_PmType int32

const (
	PmConfig_COUNTER PmConfig_PmType = 0
	PmConfig_GAUGE   PmConfig_PmType = 1
	PmConfig_STATE   PmConfig_PmType = 2
	PmConfig_CONTEXT PmConfig_PmType = 3
)

var PmConfig_PmType_name = map[int32]string{
	0: "COUNTER",
	1: "GAUGE",
	2: "STATE",
	3: "CONTEXT",
}

var PmConfig_PmType_value = map[string]int32{
	"COUNTER": 0,
	"GAUGE":   1,
	"STATE":   2,
	"CONTEXT": 3,
}

func (x PmConfig_PmType) String() string {
	return proto.EnumName(PmConfig_PmType_name, int32(x))
}

func (PmConfig_PmType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{2, 0}
}

type ImageDownload_ImageDownloadState int32

const (
	ImageDownload_DOWNLOAD_UNKNOWN     ImageDownload_ImageDownloadState = 0
	ImageDownload_DOWNLOAD_SUCCEEDED   ImageDownload_ImageDownloadState = 1
	ImageDownload_DOWNLOAD_REQUESTED   ImageDownload_ImageDownloadState = 2
	ImageDownload_DOWNLOAD_STARTED     ImageDownload_ImageDownloadState = 3
	ImageDownload_DOWNLOAD_FAILED      ImageDownload_ImageDownloadState = 4
	ImageDownload_DOWNLOAD_UNSUPPORTED ImageDownload_ImageDownloadState = 5
	ImageDownload_DOWNLOAD_CANCELLED   ImageDownload_ImageDownloadState = 6
)

var ImageDownload_ImageDownloadState_name = map[int32]string{
	0: "DOWNLOAD_UNKNOWN",
	1: "DOWNLOAD_SUCCEEDED",
	2: "DOWNLOAD_REQUESTED",
	3: "DOWNLOAD_STARTED",
	4: "DOWNLOAD_FAILED",
	5: "DOWNLOAD_UNSUPPORTED",
	6: "DOWNLOAD_CANCELLED",
}

var ImageDownload_ImageDownloadState_value = map[string]int32{
	"DOWNLOAD_UNKNOWN":     0,
	"DOWNLOAD_SUCCEEDED":   1,
	"DOWNLOAD_REQUESTED":   2,
	"DOWNLOAD_STARTED":     3,
	"DOWNLOAD_FAILED":      4,
	"DOWNLOAD_UNSUPPORTED": 5,
	"DOWNLOAD_CANCELLED":   6,
}

func (x ImageDownload_ImageDownloadState) String() string {
	return proto.EnumName(ImageDownload_ImageDownloadState_name, int32(x))
}

func (ImageDownload_ImageDownloadState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 0}
}

type ImageDownload_ImageDownloadFailureReason int32

const (
	ImageDownload_NO_ERROR           ImageDownload_ImageDownloadFailureReason = 0
	ImageDownload_INVALID_URL        ImageDownload_ImageDownloadFailureReason = 1
	ImageDownload_DEVICE_BUSY        ImageDownload_ImageDownloadFailureReason = 2
	ImageDownload_INSUFFICIENT_SPACE ImageDownload_ImageDownloadFailureReason = 3
	ImageDownload_UNKNOWN_ERROR      ImageDownload_ImageDownloadFailureReason = 4
	ImageDownload_CANCELLED          ImageDownload_ImageDownloadFailureReason = 5
)

var ImageDownload_ImageDownloadFailureReason_name = map[int32]string{
	0: "NO_ERROR",
	1: "INVALID_URL",
	2: "DEVICE_BUSY",
	3: "INSUFFICIENT_SPACE",
	4: "UNKNOWN_ERROR",
	5: "CANCELLED",
}

var ImageDownload_ImageDownloadFailureReason_value = map[string]int32{
	"NO_ERROR":           0,
	"INVALID_URL":        1,
	"DEVICE_BUSY":        2,
	"INSUFFICIENT_SPACE": 3,
	"UNKNOWN_ERROR":      4,
	"CANCELLED":          5,
}

func (x ImageDownload_ImageDownloadFailureReason) String() string {
	return proto.EnumName(ImageDownload_ImageDownloadFailureReason_name, int32(x))
}

func (ImageDownload_ImageDownloadFailureReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 1}
}

type ImageDownload_ImageActivateState int32

const (
	ImageDownload_IMAGE_UNKNOWN    ImageDownload_ImageActivateState = 0
	ImageDownload_IMAGE_INACTIVE   ImageDownload_ImageActivateState = 1
	ImageDownload_IMAGE_ACTIVATING ImageDownload_ImageActivateState = 2
	ImageDownload_IMAGE_ACTIVE     ImageDownload_ImageActivateState = 3
	ImageDownload_IMAGE_REVERTING  ImageDownload_ImageActivateState = 4
	ImageDownload_IMAGE_REVERTED   ImageDownload_ImageActivateState = 5
)

var ImageDownload_ImageActivateState_name = map[int32]string{
	0: "IMAGE_UNKNOWN",
	1: "IMAGE_INACTIVE",
	2: "IMAGE_ACTIVATING",
	3: "IMAGE_ACTIVE",
	4: "IMAGE_REVERTING",
	5: "IMAGE_REVERTED",
}

var ImageDownload_ImageActivateState_value = map[string]int32{
	"IMAGE_UNKNOWN":    0,
	"IMAGE_INACTIVE":   1,
	"IMAGE_ACTIVATING": 2,
	"IMAGE_ACTIVE":     3,
	"IMAGE_REVERTING":  4,
	"IMAGE_REVERTED":   5,
}

func (x ImageDownload_ImageActivateState) String() string {
	return proto.EnumName(ImageDownload_ImageActivateState_name, int32(x))
}

func (ImageDownload_ImageActivateState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 2}
}

type Port_PortType int32

const (
	Port_UNKNOWN      Port_PortType = 0
	Port_ETHERNET_NNI Port_PortType = 1
	Port_ETHERNET_UNI Port_PortType = 2
	Port_PON_OLT      Port_PortType = 3
	Port_PON_ONU      Port_PortType = 4
	Port_VENET_OLT    Port_PortType = 5
	Port_VENET_ONU    Port_PortType = 6
)

var Port_PortType_name = map[int32]string{
	0: "UNKNOWN",
	1: "ETHERNET_NNI",
	2: "ETHERNET_UNI",
	3: "PON_OLT",
	4: "PON_ONU",
	5: "VENET_OLT",
	6: "VENET_ONU",
}

var Port_PortType_value = map[string]int32{
	"UNKNOWN":      0,
	"ETHERNET_NNI": 1,
	"ETHERNET_UNI": 2,
	"PON_OLT":      3,
	"PON_ONU":      4,
	"VENET_OLT":    5,
	"VENET_ONU":    6,
}

func (x Port_PortType) String() string {
	return proto.EnumName(Port_PortType_name, int32(x))
}

func (Port_PortType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9, 0}
}

type SimulateAlarmRequest_OperationType int32

const (
	SimulateAlarmRequest_RAISE SimulateAlarmRequest_OperationType = 0
	SimulateAlarmRequest_CLEAR SimulateAlarmRequest_OperationType = 1
)

var SimulateAlarmRequest_OperationType_name = map[int32]string{
	0: "RAISE",
	1: "CLEAR",
}

var SimulateAlarmRequest_OperationType_value = map[string]int32{
	"RAISE": 0,
	"CLEAR": 1,
}

func (x SimulateAlarmRequest_OperationType) String() string {
	return proto.EnumName(SimulateAlarmRequest_OperationType_name, int32(x))
}

func (SimulateAlarmRequest_OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13, 0}
}

// A Device Type
type DeviceType struct {
	// Unique name for the device type
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Unique vendor id for the device type applicable to ONU
	// 4 bytes of vendor id from ONU serial number
	VendorId  string   `protobuf:"bytes,5,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	VendorIds []string `protobuf:"bytes,6,rep,name=vendor_ids,json=vendorIds,proto3" json:"vendor_ids,omitempty"`
	// Name of the adapter that handles device type
	Adapter string `protobuf:"bytes,2,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Capabilities
	AcceptsBulkFlowUpdate           bool     `protobuf:"varint,3,opt,name=accepts_bulk_flow_update,json=acceptsBulkFlowUpdate,proto3" json:"accepts_bulk_flow_update,omitempty"`
	AcceptsAddRemoveFlowUpdates     bool     `protobuf:"varint,4,opt,name=accepts_add_remove_flow_updates,json=acceptsAddRemoveFlowUpdates,proto3" json:"accepts_add_remove_flow_updates,omitempty"`
	AcceptsDirectLogicalFlowsUpdate bool     `protobuf:"varint,7,opt,name=accepts_direct_logical_flows_update,json=acceptsDirectLogicalFlowsUpdate,proto3" json:"accepts_direct_logical_flows_update,omitempty"`
	XXX_NoUnkeyedLiteral            struct{} `json:"-"`
	XXX_unrecognized                []byte   `json:"-"`
	XXX_sizecache                   int32    `json:"-"`
}

func (m *DeviceType) Reset()         { *m = DeviceType{} }
func (m *DeviceType) String() string { return proto.CompactTextString(m) }
func (*DeviceType) ProtoMessage()    {}
func (*DeviceType) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{0}
}

func (m *DeviceType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceType.Unmarshal(m, b)
}
func (m *DeviceType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceType.Marshal(b, m, deterministic)
}
func (m *DeviceType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceType.Merge(m, src)
}
func (m *DeviceType) XXX_Size() int {
	return xxx_messageInfo_DeviceType.Size(m)
}
func (m *DeviceType) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceType.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceType proto.InternalMessageInfo

func (m *DeviceType) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeviceType) GetVendorId() string {
	if m != nil {
		return m.VendorId
	}
	return ""
}

func (m *DeviceType) GetVendorIds() []string {
	if m != nil {
		return m.VendorIds
	}
	return nil
}

func (m *DeviceType) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *DeviceType) GetAcceptsBulkFlowUpdate() bool {
	if m != nil {
		return m.AcceptsBulkFlowUpdate
	}
	return false
}

func (m *DeviceType) GetAcceptsAddRemoveFlowUpdates() bool {
	if m != nil {
		return m.AcceptsAddRemoveFlowUpdates
	}
	return false
}

func (m *DeviceType) GetAcceptsDirectLogicalFlowsUpdate() bool {
	if m != nil {
		return m.AcceptsDirectLogicalFlowsUpdate
	}
	return false
}

// A plurality of device types
type DeviceTypes struct {
	Items                []*DeviceType `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DeviceTypes) Reset()         { *m = DeviceTypes{} }
func (m *DeviceTypes) String() string { return proto.CompactTextString(m) }
func (*DeviceTypes) ProtoMessage()    {}
func (*DeviceTypes) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{1}
}

func (m *DeviceTypes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceTypes.Unmarshal(m, b)
}
func (m *DeviceTypes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceTypes.Marshal(b, m, deterministic)
}
func (m *DeviceTypes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceTypes.Merge(m, src)
}
func (m *DeviceTypes) XXX_Size() int {
	return xxx_messageInfo_DeviceTypes.Size(m)
}
func (m *DeviceTypes) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceTypes.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceTypes proto.InternalMessageInfo

func (m *DeviceTypes) GetItems() []*DeviceType {
	if m != nil {
		return m.Items
	}
	return nil
}

type PmConfig struct {
	Name                 string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type                 PmConfig_PmType `protobuf:"varint,2,opt,name=type,proto3,enum=voltha.PmConfig_PmType" json:"type,omitempty"`
	Enabled              bool            `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	SampleFreq           uint32          `protobuf:"varint,4,opt,name=sample_freq,json=sampleFreq,proto3" json:"sample_freq,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *PmConfig) Reset()         { *m = PmConfig{} }
func (m *PmConfig) String() string { return proto.CompactTextString(m) }
func (*PmConfig) ProtoMessage()    {}
func (*PmConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{2}
}

func (m *PmConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmConfig.Unmarshal(m, b)
}
func (m *PmConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmConfig.Marshal(b, m, deterministic)
}
func (m *PmConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmConfig.Merge(m, src)
}
func (m *PmConfig) XXX_Size() int {
	return xxx_messageInfo_PmConfig.Size(m)
}
func (m *PmConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PmConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PmConfig proto.InternalMessageInfo

func (m *PmConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PmConfig) GetType() PmConfig_PmType {
	if m != nil {
		return m.Type
	}
	return PmConfig_COUNTER
}

func (m *PmConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PmConfig) GetSampleFreq() uint32 {
	if m != nil {
		return m.SampleFreq
	}
	return 0
}

type PmGroupConfig struct {
	GroupName            string      `protobuf:"bytes,1,opt,name=group_name,json=groupName,proto3" json:"group_name,omitempty"`
	GroupFreq            uint32      `protobuf:"varint,2,opt,name=group_freq,json=groupFreq,proto3" json:"group_freq,omitempty"`
	Enabled              bool        `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Metrics              []*PmConfig `protobuf:"bytes,4,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *PmGroupConfig) Reset()         { *m = PmGroupConfig{} }
func (m *PmGroupConfig) String() string { return proto.CompactTextString(m) }
func (*PmGroupConfig) ProtoMessage()    {}
func (*PmGroupConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{3}
}

func (m *PmGroupConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmGroupConfig.Unmarshal(m, b)
}
func (m *PmGroupConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmGroupConfig.Marshal(b, m, deterministic)
}
func (m *PmGroupConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmGroupConfig.Merge(m, src)
}
func (m *PmGroupConfig) XXX_Size() int {
	return xxx_messageInfo_PmGroupConfig.Size(m)
}
func (m *PmGroupConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PmGroupConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PmGroupConfig proto.InternalMessageInfo

func (m *PmGroupConfig) GetGroupName() string {
	if m != nil {
		return m.GroupName
	}
	return ""
}

func (m *PmGroupConfig) GetGroupFreq() uint32 {
	if m != nil {
		return m.GroupFreq
	}
	return 0
}

func (m *PmGroupConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PmGroupConfig) GetMetrics() []*PmConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type PmConfigs struct {
	Id          string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	DefaultFreq uint32 `protobuf:"varint,2,opt,name=default_freq,json=defaultFreq,proto3" json:"default_freq,omitempty"`
	// Forces group names and group semantics
	Grouped bool `protobuf:"varint,3,opt,name=grouped,proto3" json:"grouped,omitempty"`
	// Allows Pm to set an individual sample frequency
	FreqOverride         bool             `protobuf:"varint,4,opt,name=freq_override,json=freqOverride,proto3" json:"freq_override,omitempty"`
	Groups               []*PmGroupConfig `protobuf:"bytes,5,rep,name=groups,proto3" json:"groups,omitempty"`
	Metrics              []*PmConfig      `protobuf:"bytes,6,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PmConfigs) Reset()         { *m = PmConfigs{} }
func (m *PmConfigs) String() string { return proto.CompactTextString(m) }
func (*PmConfigs) ProtoMessage()    {}
func (*PmConfigs) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{4}
}

func (m *PmConfigs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmConfigs.Unmarshal(m, b)
}
func (m *PmConfigs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmConfigs.Marshal(b, m, deterministic)
}
func (m *PmConfigs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmConfigs.Merge(m, src)
}
func (m *PmConfigs) XXX_Size() int {
	return xxx_messageInfo_PmConfigs.Size(m)
}
func (m *PmConfigs) XXX_DiscardUnknown() {
	xxx_messageInfo_PmConfigs.DiscardUnknown(m)
}

var xxx_messageInfo_PmConfigs proto.InternalMessageInfo

func (m *PmConfigs) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PmConfigs) GetDefaultFreq() uint32 {
	if m != nil {
		return m.DefaultFreq
	}
	return 0
}

func (m *PmConfigs) GetGrouped() bool {
	if m != nil {
		return m.Grouped
	}
	return false
}

func (m *PmConfigs) GetFreqOverride() bool {
	if m != nil {
		return m.FreqOverride
	}
	return false
}

func (m *PmConfigs) GetGroups() []*PmGroupConfig {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *PmConfigs) GetMetrics() []*PmConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// Describes instance of software image on the device
type Image struct {
	Name            string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version         string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Hash            string `protobuf:"bytes,3,opt,name=hash,proto3" json:"hash,omitempty"`
	InstallDatetime string `protobuf:"bytes,4,opt,name=install_datetime,json=installDatetime,proto3" json:"install_datetime,omitempty"`
	// The active software image is one that is currently loaded and executing
	// in the ONU or circuit pack. Under normal operation, one software image
	// is always active while the other is inactive. Under no circumstances are
	// both software images allowed to be active at the same time
	IsActive bool `protobuf:"varint,5,opt,name=is_active,json=isActive,proto3" json:"is_active,omitempty"`
	// The committed software image is loaded and executed upon reboot of the
	// ONU and/or circuit pack. During normal operation, one software image is
	// always committed, while the other is uncommitted.
	IsCommitted bool `protobuf:"varint,6,opt,name=is_committed,json=isCommitted,proto3" json:"is_committed,omitempty"`
	// A software image is valid if it has been verified to be an executable
	// code image. The verification mechanism is not subject to standardization;
	// however, it should include at least a data integrity (e.g., CRC) check of
	// the entire code image.
	IsValid              bool     `protobuf:"varint,7,opt,name=is_valid,json=isValid,proto3" json:"is_valid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{5}
}

func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Image) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Image) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *Image) GetInstallDatetime() string {
	if m != nil {
		return m.InstallDatetime
	}
	return ""
}

func (m *Image) GetIsActive() bool {
	if m != nil {
		return m.IsActive
	}
	return false
}

func (m *Image) GetIsCommitted() bool {
	if m != nil {
		return m.IsCommitted
	}
	return false
}

func (m *Image) GetIsValid() bool {
	if m != nil {
		return m.IsValid
	}
	return false
}

// List of software on the device
type Images struct {
	Image                []*Image `protobuf:"bytes,1,rep,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Images) Reset()         { *m = Images{} }
func (m *Images) String() string { return proto.CompactTextString(m) }
func (*Images) ProtoMessage()    {}
func (*Images) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{6}
}

func (m *Images) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Images.Unmarshal(m, b)
}
func (m *Images) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Images.Marshal(b, m, deterministic)
}
func (m *Images) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Images.Merge(m, src)
}
func (m *Images) XXX_Size() int {
	return xxx_messageInfo_Images.Size(m)
}
func (m *Images) XXX_DiscardUnknown() {
	xxx_messageInfo_Images.DiscardUnknown(m)
}

var xxx_messageInfo_Images proto.InternalMessageInfo

func (m *Images) GetImage() []*Image {
	if m != nil {
		return m.Image
	}
	return nil
}

type ImageDownload struct {
	// Device Identifier
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Image unique identifier
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// URL where the image is available
	// should include username password
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// CRC of the image to be verified aginst
	Crc uint32 `protobuf:"varint,4,opt,name=crc,proto3" json:"crc,omitempty"`
	// Download state
	DownloadState ImageDownload_ImageDownloadState `protobuf:"varint,5,opt,name=download_state,json=downloadState,proto3,enum=voltha.ImageDownload_ImageDownloadState" json:"download_state,omitempty"`
	// Downloaded version
	ImageVersion string `protobuf:"bytes,6,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Bytes downloaded
	DownloadedBytes uint32 `protobuf:"varint,7,opt,name=downloaded_bytes,json=downloadedBytes,proto3" json:"downloaded_bytes,omitempty"`
	// Download failure reason
	Reason ImageDownload_ImageDownloadFailureReason `protobuf:"varint,8,opt,name=reason,proto3,enum=voltha.ImageDownload_ImageDownloadFailureReason" json:"reason,omitempty"`
	// Additional info
	AdditionalInfo string `protobuf:"bytes,9,opt,name=additional_info,json=additionalInfo,proto3" json:"additional_info,omitempty"`
	// Save current configuration
	SaveConfig bool `protobuf:"varint,10,opt,name=save_config,json=saveConfig,proto3" json:"save_config,omitempty"`
	// Image local location
	LocalDir string `protobuf:"bytes,11,opt,name=local_dir,json=localDir,proto3" json:"local_dir,omitempty"`
	// Image activation state
	ImageState ImageDownload_ImageActivateState `protobuf:"varint,12,opt,name=image_state,json=imageState,proto3,enum=voltha.ImageDownload_ImageActivateState" json:"image_state,omitempty"`
	// Image file size
	FileSize             uint32   `protobuf:"varint,13,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageDownload) Reset()         { *m = ImageDownload{} }
func (m *ImageDownload) String() string { return proto.CompactTextString(m) }
func (*ImageDownload) ProtoMessage()    {}
func (*ImageDownload) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7}
}

func (m *ImageDownload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageDownload.Unmarshal(m, b)
}
func (m *ImageDownload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageDownload.Marshal(b, m, deterministic)
}
func (m *ImageDownload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageDownload.Merge(m, src)
}
func (m *ImageDownload) XXX_Size() int {
	return xxx_messageInfo_ImageDownload.Size(m)
}
func (m *ImageDownload) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageDownload.DiscardUnknown(m)
}

var xxx_messageInfo_ImageDownload proto.InternalMessageInfo

func (m *ImageDownload) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ImageDownload) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImageDownload) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *ImageDownload) GetCrc() uint32 {
	if m != nil {
		return m.Crc
	}
	return 0
}

func (m *ImageDownload) GetDownloadState() ImageDownload_ImageDownloadState {
	if m != nil {
		return m.DownloadState
	}
	return ImageDownload_DOWNLOAD_UNKNOWN
}

func (m *ImageDownload) GetImageVersion() string {
	if m != nil {
		return m.ImageVersion
	}
	return ""
}

func (m *ImageDownload) GetDownloadedBytes() uint32 {
	if m != nil {
		return m.DownloadedBytes
	}
	return 0
}

func (m *ImageDownload) GetReason() ImageDownload_ImageDownloadFailureReason {
	if m != nil {
		return m.Reason
	}
	return ImageDownload_NO_ERROR
}

func (m *ImageDownload) GetAdditionalInfo() string {
	if m != nil {
		return m.AdditionalInfo
	}
	return ""
}

func (m *ImageDownload) GetSaveConfig() bool {
	if m != nil {
		return m.SaveConfig
	}
	return false
}

func (m *ImageDownload) GetLocalDir() string {
	if m != nil {
		return m.LocalDir
	}
	return ""
}

func (m *ImageDownload) GetImageState() ImageDownload_ImageActivateState {
	if m != nil {
		return m.ImageState
	}
	return ImageDownload_IMAGE_UNKNOWN
}

func (m *ImageDownload) GetFileSize() uint32 {
	if m != nil {
		return m.FileSize
	}
	return 0
}

type ImageDownloads struct {
	Items                []*ImageDownload `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ImageDownloads) Reset()         { *m = ImageDownloads{} }
func (m *ImageDownloads) String() string { return proto.CompactTextString(m) }
func (*ImageDownloads) ProtoMessage()    {}
func (*ImageDownloads) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{8}
}

func (m *ImageDownloads) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageDownloads.Unmarshal(m, b)
}
func (m *ImageDownloads) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageDownloads.Marshal(b, m, deterministic)
}
func (m *ImageDownloads) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageDownloads.Merge(m, src)
}
func (m *ImageDownloads) XXX_Size() int {
	return xxx_messageInfo_ImageDownloads.Size(m)
}
func (m *ImageDownloads) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageDownloads.DiscardUnknown(m)
}

var xxx_messageInfo_ImageDownloads proto.InternalMessageInfo

func (m *ImageDownloads) GetItems() []*ImageDownload {
	if m != nil {
		return m.Items
	}
	return nil
}

type Port struct {
	PortNo               uint32                  `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	Label                string                  `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	Type                 Port_PortType           `protobuf:"varint,3,opt,name=type,proto3,enum=voltha.Port_PortType" json:"type,omitempty"`
	AdminState           common.AdminState_Types `protobuf:"varint,5,opt,name=admin_state,json=adminState,proto3,enum=common.AdminState_Types" json:"admin_state,omitempty"`
	OperStatus           common.OperStatus_Types `protobuf:"varint,6,opt,name=oper_status,json=operStatus,proto3,enum=common.OperStatus_Types" json:"oper_status,omitempty"`
	DeviceId             string                  `protobuf:"bytes,7,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	Peers                []*Port_PeerPort        `protobuf:"bytes,8,rep,name=peers,proto3" json:"peers,omitempty"`
	RxPackets            uint64                  `protobuf:"fixed64,9,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	RxBytes              uint64                  `protobuf:"fixed64,10,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	RxErrors             uint64                  `protobuf:"fixed64,11,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	TxPackets            uint64                  `protobuf:"fixed64,12,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	TxBytes              uint64                  `protobuf:"fixed64,13,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxErrors             uint64                  `protobuf:"fixed64,14,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Port) Reset()         { *m = Port{} }
func (m *Port) String() string { return proto.CompactTextString(m) }
func (*Port) ProtoMessage()    {}
func (*Port) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9}
}

func (m *Port) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Port.Unmarshal(m, b)
}
func (m *Port) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Port.Marshal(b, m, deterministic)
}
func (m *Port) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port.Merge(m, src)
}
func (m *Port) XXX_Size() int {
	return xxx_messageInfo_Port.Size(m)
}
func (m *Port) XXX_DiscardUnknown() {
	xxx_messageInfo_Port.DiscardUnknown(m)
}

var xxx_messageInfo_Port proto.InternalMessageInfo

func (m *Port) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *Port) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Port) GetType() Port_PortType {
	if m != nil {
		return m.Type
	}
	return Port_UNKNOWN
}

func (m *Port) GetAdminState() common.AdminState_Types {
	if m != nil {
		return m.AdminState
	}
	return common.AdminState_UNKNOWN
}

func (m *Port) GetOperStatus() common.OperStatus_Types {
	if m != nil {
		return m.OperStatus
	}
	return common.OperStatus_UNKNOWN
}

func (m *Port) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Port) GetPeers() []*Port_PeerPort {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *Port) GetRxPackets() uint64 {
	if m != nil {
		return m.RxPackets
	}
	return 0
}

func (m *Port) GetRxBytes() uint64 {
	if m != nil {
		return m.RxBytes
	}
	return 0
}

func (m *Port) GetRxErrors() uint64 {
	if m != nil {
		return m.RxErrors
	}
	return 0
}

func (m *Port) GetTxPackets() uint64 {
	if m != nil {
		return m.TxPackets
	}
	return 0
}

func (m *Port) GetTxBytes() uint64 {
	if m != nil {
		return m.TxBytes
	}
	return 0
}

func (m *Port) GetTxErrors() uint64 {
	if m != nil {
		return m.TxErrors
	}
	return 0
}

type Port_PeerPort struct {
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	PortNo               uint32   `protobuf:"varint,2,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Port_PeerPort) Reset()         { *m = Port_PeerPort{} }
func (m *Port_PeerPort) String() string { return proto.CompactTextString(m) }
func (*Port_PeerPort) ProtoMessage()    {}
func (*Port_PeerPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9, 0}
}

func (m *Port_PeerPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Port_PeerPort.Unmarshal(m, b)
}
func (m *Port_PeerPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Port_PeerPort.Marshal(b, m, deterministic)
}
func (m *Port_PeerPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port_PeerPort.Merge(m, src)
}
func (m *Port_PeerPort) XXX_Size() int {
	return xxx_messageInfo_Port_PeerPort.Size(m)
}
func (m *Port_PeerPort) XXX_DiscardUnknown() {
	xxx_messageInfo_Port_PeerPort.DiscardUnknown(m)
}

var xxx_messageInfo_Port_PeerPort proto.InternalMessageInfo

func (m *Port_PeerPort) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Port_PeerPort) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

type Ports struct {
	Items                []*Port  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Ports) Reset()         { *m = Ports{} }
func (m *Ports) String() string { return proto.CompactTextString(m) }
func (*Ports) ProtoMessage()    {}
func (*Ports) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{10}
}

func (m *Ports) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ports.Unmarshal(m, b)
}
func (m *Ports) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ports.Marshal(b, m, deterministic)
}
func (m *Ports) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ports.Merge(m, src)
}
func (m *Ports) XXX_Size() int {
	return xxx_messageInfo_Ports.Size(m)
}
func (m *Ports) XXX_DiscardUnknown() {
	xxx_messageInfo_Ports.DiscardUnknown(m)
}

var xxx_messageInfo_Ports proto.InternalMessageInfo

func (m *Ports) GetItems() []*Port {
	if m != nil {
		return m.Items
	}
	return nil
}

// A Physical Device instance
type Device struct {
	// Voltha's device identifier
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Device type, refers to one of the registered device types
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Is this device a root device. Each logical switch has one root
	// device that is associated with the logical flow switch.
	Root bool `protobuf:"varint,3,opt,name=root,proto3" json:"root,omitempty"`
	// Parent device id, in the device tree (for a root device, the parent_id
	// is the logical_device.id)
	ParentId     string `protobuf:"bytes,4,opt,name=parent_id,json=parentId,proto3" json:"parent_id,omitempty"`
	ParentPortNo uint32 `protobuf:"varint,20,opt,name=parent_port_no,json=parentPortNo,proto3" json:"parent_port_no,omitempty"`
	// Vendor, version, serial number, etc.
	Vendor          string `protobuf:"bytes,5,opt,name=vendor,proto3" json:"vendor,omitempty"`
	Model           string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	HardwareVersion string `protobuf:"bytes,7,opt,name=hardware_version,json=hardwareVersion,proto3" json:"hardware_version,omitempty"`
	FirmwareVersion string `protobuf:"bytes,8,opt,name=firmware_version,json=firmwareVersion,proto3" json:"firmware_version,omitempty"`
	// List of software on the device
	Images       *Images `protobuf:"bytes,9,opt,name=images,proto3" json:"images,omitempty"`
	SerialNumber string  `protobuf:"bytes,10,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	VendorId     string  `protobuf:"bytes,24,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	// Addapter that takes care of device
	Adapter string `protobuf:"bytes,11,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Device contact on vlan (if 0, no vlan)
	Vlan uint32 `protobuf:"varint,12,opt,name=vlan,proto3" json:"vlan,omitempty"`
	// Device contact MAC address (format: "xx:xx:xx:xx:xx:xx")
	MacAddress string `protobuf:"bytes,13,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// Types that are valid to be assigned to Address:
	//	*Device_Ipv4Address
	//	*Device_Ipv6Address
	//	*Device_HostAndPort
	Address       isDevice_Address           `protobuf_oneof:"address"`
	ExtraArgs     string                     `protobuf:"bytes,23,opt,name=extra_args,json=extraArgs,proto3" json:"extra_args,omitempty"`
	ProxyAddress  *Device_ProxyAddress       `protobuf:"bytes,19,opt,name=proxy_address,json=proxyAddress,proto3" json:"proxy_address,omitempty"`
	AdminState    common.AdminState_Types    `protobuf:"varint,16,opt,name=admin_state,json=adminState,proto3,enum=common.AdminState_Types" json:"admin_state,omitempty"`
	OperStatus    common.OperStatus_Types    `protobuf:"varint,17,opt,name=oper_status,json=operStatus,proto3,enum=common.OperStatus_Types" json:"oper_status,omitempty"`
	Reason        string                     `protobuf:"bytes,22,opt,name=reason,proto3" json:"reason,omitempty"`
	ConnectStatus common.ConnectStatus_Types `protobuf:"varint,18,opt,name=connect_status,json=connectStatus,proto3,enum=common.ConnectStatus_Types" json:"connect_status,omitempty"`
	// Device type specific attributes
	Custom     *any.Any                `protobuf:"bytes,64,opt,name=custom,proto3" json:"custom,omitempty"`
	Ports      []*Port                 `protobuf:"bytes,128,rep,name=ports,proto3" json:"ports,omitempty"`
	Flows      *openflow_13.Flows      `protobuf:"bytes,129,opt,name=flows,proto3" json:"flows,omitempty"`
	FlowGroups *openflow_13.FlowGroups `protobuf:"bytes,130,opt,name=flow_groups,json=flowGroups,proto3" json:"flow_groups,omitempty"`
	// PmConfigs will eventually converted to a child node of the
	// device to falicitata callbacks and to simplify manipulation.
	PmConfigs            *PmConfigs       `protobuf:"bytes,131,opt,name=pm_configs,json=pmConfigs,proto3" json:"pm_configs,omitempty"`
	ImageDownloads       []*ImageDownload `protobuf:"bytes,133,rep,name=image_downloads,json=imageDownloads,proto3" json:"image_downloads,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Device) Reset()         { *m = Device{} }
func (m *Device) String() string { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()    {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{11}
}

func (m *Device) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device.Unmarshal(m, b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device.Marshal(b, m, deterministic)
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return xxx_messageInfo_Device.Size(m)
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

func (m *Device) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Device) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Device) GetRoot() bool {
	if m != nil {
		return m.Root
	}
	return false
}

func (m *Device) GetParentId() string {
	if m != nil {
		return m.ParentId
	}
	return ""
}

func (m *Device) GetParentPortNo() uint32 {
	if m != nil {
		return m.ParentPortNo
	}
	return 0
}

func (m *Device) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *Device) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *Device) GetHardwareVersion() string {
	if m != nil {
		return m.HardwareVersion
	}
	return ""
}

func (m *Device) GetFirmwareVersion() string {
	if m != nil {
		return m.FirmwareVersion
	}
	return ""
}

func (m *Device) GetImages() *Images {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Device) GetSerialNumber() string {
	if m != nil {
		return m.SerialNumber
	}
	return ""
}

func (m *Device) GetVendorId() string {
	if m != nil {
		return m.VendorId
	}
	return ""
}

func (m *Device) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *Device) GetVlan() uint32 {
	if m != nil {
		return m.Vlan
	}
	return 0
}

func (m *Device) GetMacAddress() string {
	if m != nil {
		return m.MacAddress
	}
	return ""
}

type isDevice_Address interface {
	isDevice_Address()
}

type Device_Ipv4Address struct {
	Ipv4Address string `protobuf:"bytes,14,opt,name=ipv4_address,json=ipv4Address,proto3,oneof"`
}

type Device_Ipv6Address struct {
	Ipv6Address string `protobuf:"bytes,15,opt,name=ipv6_address,json=ipv6Address,proto3,oneof"`
}

type Device_HostAndPort struct {
	HostAndPort string `protobuf:"bytes,21,opt,name=host_and_port,json=hostAndPort,proto3,oneof"`
}

func (*Device_Ipv4Address) isDevice_Address() {}

func (*Device_Ipv6Address) isDevice_Address() {}

func (*Device_HostAndPort) isDevice_Address() {}

func (m *Device) GetAddress() isDevice_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Device) GetIpv4Address() string {
	if x, ok := m.GetAddress().(*Device_Ipv4Address); ok {
		return x.Ipv4Address
	}
	return ""
}

func (m *Device) GetIpv6Address() string {
	if x, ok := m.GetAddress().(*Device_Ipv6Address); ok {
		return x.Ipv6Address
	}
	return ""
}

func (m *Device) GetHostAndPort() string {
	if x, ok := m.GetAddress().(*Device_HostAndPort); ok {
		return x.HostAndPort
	}
	return ""
}

func (m *Device) GetExtraArgs() string {
	if m != nil {
		return m.ExtraArgs
	}
	return ""
}

func (m *Device) GetProxyAddress() *Device_ProxyAddress {
	if m != nil {
		return m.ProxyAddress
	}
	return nil
}

func (m *Device) GetAdminState() common.AdminState_Types {
	if m != nil {
		return m.AdminState
	}
	return common.AdminState_UNKNOWN
}

func (m *Device) GetOperStatus() common.OperStatus_Types {
	if m != nil {
		return m.OperStatus
	}
	return common.OperStatus_UNKNOWN
}

func (m *Device) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Device) GetConnectStatus() common.ConnectStatus_Types {
	if m != nil {
		return m.ConnectStatus
	}
	return common.ConnectStatus_UNKNOWN
}

func (m *Device) GetCustom() *any.Any {
	if m != nil {
		return m.Custom
	}
	return nil
}

func (m *Device) GetPorts() []*Port {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *Device) GetFlows() *openflow_13.Flows {
	if m != nil {
		return m.Flows
	}
	return nil
}

func (m *Device) GetFlowGroups() *openflow_13.FlowGroups {
	if m != nil {
		return m.FlowGroups
	}
	return nil
}

func (m *Device) GetPmConfigs() *PmConfigs {
	if m != nil {
		return m.PmConfigs
	}
	return nil
}

func (m *Device) GetImageDownloads() []*ImageDownload {
	if m != nil {
		return m.ImageDownloads
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Device) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Device_Ipv4Address)(nil),
		(*Device_Ipv6Address)(nil),
		(*Device_HostAndPort)(nil),
	}
}

type Device_ProxyAddress struct {
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	DeviceType           string   `protobuf:"bytes,2,opt,name=device_type,json=deviceType,proto3" json:"device_type,omitempty"`
	ChannelId            uint32   `protobuf:"varint,3,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	ChannelGroupId       uint32   `protobuf:"varint,4,opt,name=channel_group_id,json=channelGroupId,proto3" json:"channel_group_id,omitempty"`
	ChannelTermination   string   `protobuf:"bytes,5,opt,name=channel_termination,json=channelTermination,proto3" json:"channel_termination,omitempty"`
	OnuId                uint32   `protobuf:"varint,6,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	OnuSessionId         uint32   `protobuf:"varint,7,opt,name=onu_session_id,json=onuSessionId,proto3" json:"onu_session_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Device_ProxyAddress) Reset()         { *m = Device_ProxyAddress{} }
func (m *Device_ProxyAddress) String() string { return proto.CompactTextString(m) }
func (*Device_ProxyAddress) ProtoMessage()    {}
func (*Device_ProxyAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{11, 0}
}

func (m *Device_ProxyAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device_ProxyAddress.Unmarshal(m, b)
}
func (m *Device_ProxyAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device_ProxyAddress.Marshal(b, m, deterministic)
}
func (m *Device_ProxyAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device_ProxyAddress.Merge(m, src)
}
func (m *Device_ProxyAddress) XXX_Size() int {
	return xxx_messageInfo_Device_ProxyAddress.Size(m)
}
func (m *Device_ProxyAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_Device_ProxyAddress.DiscardUnknown(m)
}

var xxx_messageInfo_Device_ProxyAddress proto.InternalMessageInfo

func (m *Device_ProxyAddress) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Device_ProxyAddress) GetDeviceType() string {
	if m != nil {
		return m.DeviceType
	}
	return ""
}

func (m *Device_ProxyAddress) GetChannelId() uint32 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *Device_ProxyAddress) GetChannelGroupId() uint32 {
	if m != nil {
		return m.ChannelGroupId
	}
	return 0
}

func (m *Device_ProxyAddress) GetChannelTermination() string {
	if m != nil {
		return m.ChannelTermination
	}
	return ""
}

func (m *Device_ProxyAddress) GetOnuId() uint32 {
	if m != nil {
		return m.OnuId
	}
	return 0
}

func (m *Device_ProxyAddress) GetOnuSessionId() uint32 {
	if m != nil {
		return m.OnuSessionId
	}
	return 0
}

type Devices struct {
	Items                []*Device `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Devices) Reset()         { *m = Devices{} }
func (m *Devices) String() string { return proto.CompactTextString(m) }
func (*Devices) ProtoMessage()    {}
func (*Devices) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{12}
}

func (m *Devices) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Devices.Unmarshal(m, b)
}
func (m *Devices) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Devices.Marshal(b, m, deterministic)
}
func (m *Devices) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Devices.Merge(m, src)
}
func (m *Devices) XXX_Size() int {
	return xxx_messageInfo_Devices.Size(m)
}
func (m *Devices) XXX_DiscardUnknown() {
	xxx_messageInfo_Devices.DiscardUnknown(m)
}

var xxx_messageInfo_Devices proto.InternalMessageInfo

func (m *Devices) GetItems() []*Device {
	if m != nil {
		return m.Items
	}
	return nil
}

type SimulateAlarmRequest struct {
	// Device Identifier
	Id                   string                             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Indicator            string                             `protobuf:"bytes,2,opt,name=indicator,proto3" json:"indicator,omitempty"`
	IntfId               string                             `protobuf:"bytes,3,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	PortTypeName         string                             `protobuf:"bytes,4,opt,name=port_type_name,json=portTypeName,proto3" json:"port_type_name,omitempty"`
	OnuDeviceId          string                             `protobuf:"bytes,5,opt,name=onu_device_id,json=onuDeviceId,proto3" json:"onu_device_id,omitempty"`
	InverseBitErrorRate  int32                              `protobuf:"varint,6,opt,name=inverse_bit_error_rate,json=inverseBitErrorRate,proto3" json:"inverse_bit_error_rate,omitempty"`
	Drift                int32                              `protobuf:"varint,7,opt,name=drift,proto3" json:"drift,omitempty"`
	NewEqd               int32                              `protobuf:"varint,8,opt,name=new_eqd,json=newEqd,proto3" json:"new_eqd,omitempty"`
	OnuSerialNumber      string                             `protobuf:"bytes,9,opt,name=onu_serial_number,json=onuSerialNumber,proto3" json:"onu_serial_number,omitempty"`
	Operation            SimulateAlarmRequest_OperationType `protobuf:"varint,10,opt,name=operation,proto3,enum=voltha.SimulateAlarmRequest_OperationType" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *SimulateAlarmRequest) Reset()         { *m = SimulateAlarmRequest{} }
func (m *SimulateAlarmRequest) String() string { return proto.CompactTextString(m) }
func (*SimulateAlarmRequest) ProtoMessage()    {}
func (*SimulateAlarmRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13}
}

func (m *SimulateAlarmRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimulateAlarmRequest.Unmarshal(m, b)
}
func (m *SimulateAlarmRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimulateAlarmRequest.Marshal(b, m, deterministic)
}
func (m *SimulateAlarmRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimulateAlarmRequest.Merge(m, src)
}
func (m *SimulateAlarmRequest) XXX_Size() int {
	return xxx_messageInfo_SimulateAlarmRequest.Size(m)
}
func (m *SimulateAlarmRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SimulateAlarmRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SimulateAlarmRequest proto.InternalMessageInfo

func (m *SimulateAlarmRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SimulateAlarmRequest) GetIndicator() string {
	if m != nil {
		return m.Indicator
	}
	return ""
}

func (m *SimulateAlarmRequest) GetIntfId() string {
	if m != nil {
		return m.IntfId
	}
	return ""
}

func (m *SimulateAlarmRequest) GetPortTypeName() string {
	if m != nil {
		return m.PortTypeName
	}
	return ""
}

func (m *SimulateAlarmRequest) GetOnuDeviceId() string {
	if m != nil {
		return m.OnuDeviceId
	}
	return ""
}

func (m *SimulateAlarmRequest) GetInverseBitErrorRate() int32 {
	if m != nil {
		return m.InverseBitErrorRate
	}
	return 0
}

func (m *SimulateAlarmRequest) GetDrift() int32 {
	if m != nil {
		return m.Drift
	}
	return 0
}

func (m *SimulateAlarmRequest) GetNewEqd() int32 {
	if m != nil {
		return m.NewEqd
	}
	return 0
}

func (m *SimulateAlarmRequest) GetOnuSerialNumber() string {
	if m != nil {
		return m.OnuSerialNumber
	}
	return ""
}

func (m *SimulateAlarmRequest) GetOperation() SimulateAlarmRequest_OperationType {
	if m != nil {
		return m.Operation
	}
	return SimulateAlarmRequest_RAISE
}

func init() {
	proto.RegisterEnum("voltha.PmConfig_PmType", PmConfig_PmType_name, PmConfig_PmType_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageDownloadState", ImageDownload_ImageDownloadState_name, ImageDownload_ImageDownloadState_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageDownloadFailureReason", ImageDownload_ImageDownloadFailureReason_name, ImageDownload_ImageDownloadFailureReason_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageActivateState", ImageDownload_ImageActivateState_name, ImageDownload_ImageActivateState_value)
	proto.RegisterEnum("voltha.Port_PortType", Port_PortType_name, Port_PortType_value)
	proto.RegisterEnum("voltha.SimulateAlarmRequest_OperationType", SimulateAlarmRequest_OperationType_name, SimulateAlarmRequest_OperationType_value)
	proto.RegisterType((*DeviceType)(nil), "voltha.DeviceType")
	proto.RegisterType((*DeviceTypes)(nil), "voltha.DeviceTypes")
	proto.RegisterType((*PmConfig)(nil), "voltha.PmConfig")
	proto.RegisterType((*PmGroupConfig)(nil), "voltha.PmGroupConfig")
	proto.RegisterType((*PmConfigs)(nil), "voltha.PmConfigs")
	proto.RegisterType((*Image)(nil), "voltha.Image")
	proto.RegisterType((*Images)(nil), "voltha.Images")
	proto.RegisterType((*ImageDownload)(nil), "voltha.ImageDownload")
	proto.RegisterType((*ImageDownloads)(nil), "voltha.ImageDownloads")
	proto.RegisterType((*Port)(nil), "voltha.Port")
	proto.RegisterType((*Port_PeerPort)(nil), "voltha.Port.PeerPort")
	proto.RegisterType((*Ports)(nil), "voltha.Ports")
	proto.RegisterType((*Device)(nil), "voltha.Device")
	proto.RegisterType((*Device_ProxyAddress)(nil), "voltha.Device.ProxyAddress")
	proto.RegisterType((*Devices)(nil), "voltha.Devices")
	proto.RegisterType((*SimulateAlarmRequest)(nil), "voltha.SimulateAlarmRequest")
}

func init() { proto.RegisterFile("voltha_protos/device.proto", fileDescriptor_200940f73d155856) }

var fileDescriptor_200940f73d155856 = []byte{
	// 2359 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x58, 0x4d, 0x73, 0xdb, 0xc6,
	0xf9, 0x37, 0x29, 0x01, 0x24, 0x1e, 0xbe, 0x08, 0x5e, 0xcb, 0x31, 0x6c, 0xfd, 0x35, 0xf6, 0x9f,
	0x4e, 0xa7, 0x4a, 0x52, 0x4b, 0x6e, 0xdc, 0x49, 0xd2, 0x43, 0x67, 0x4c, 0x91, 0xb0, 0x8d, 0xa9,
	0x4a, 0xa9, 0x4b, 0x52, 0x69, 0x7b, 0xc1, 0x40, 0xc4, 0x4a, 0xc2, 0x04, 0x2f, 0xf4, 0x02, 0xa4,
	0xe5, 0x9c, 0xda, 0x66, 0xd2, 0x53, 0x6f, 0xfd, 0x12, 0xfd, 0x06, 0x3d, 0xb6, 0x33, 0x3d, 0x67,
	0xfa, 0x1d, 0xda, 0x99, 0x4e, 0x3f, 0x41, 0xce, 0x9d, 0x7d, 0x76, 0x97, 0x04, 0x64, 0xd7, 0x69,
	0x2f, 0x12, 0xf6, 0xf7, 0xbc, 0xec, 0xee, 0x6f, 0x77, 0x9f, 0x17, 0xc2, 0xbd, 0x65, 0x16, 0x17,
	0x97, 0x81, 0x3f, 0xe7, 0x59, 0x91, 0xe5, 0x07, 0x21, 0x5b, 0x46, 0x33, 0xb6, 0x8f, 0x23, 0x62,
	0x4a, 0xd9, 0xbd, 0xbb, 0x17, 0x59, 0x76, 0x11, 0xb3, 0x03, 0x44, 0xcf, 0x16, 0xe7, 0x07, 0x41,
	0xfa, 0x5a, 0xaa, 0xdc, 0xbb, 0x66, 0x3e, 0xcb, 0x92, 0x24, 0x4b, 0x95, 0xcc, 0xa9, 0xca, 0x12,
	0x56, 0x04, 0x4a, 0x72, 0xbf, 0x2a, 0xc9, 0xe6, 0x2c, 0x3d, 0x8f, 0xb3, 0x57, 0xfe, 0x0f, 0x9f,
	0x48, 0x85, 0xde, 0x9f, 0xeb, 0x00, 0x43, 0x5c, 0xca, 0xe4, 0xf5, 0x9c, 0x91, 0x2e, 0xd4, 0xa3,
	0xd0, 0xa9, 0x3d, 0xa8, 0xed, 0x59, 0xb4, 0x1e, 0x85, 0x64, 0x07, 0xac, 0x25, 0x4b, 0xc3, 0x8c,
	0xfb, 0x51, 0xe8, 0x18, 0x08, 0x37, 0x25, 0xe0, 0x85, 0x64, 0x17, 0x60, 0x25, 0xcc, 0x1d, 0xf3,
	0xc1, 0xc6, 0x9e, 0x45, 0x2d, 0x2d, 0xcd, 0x89, 0x03, 0x8d, 0x20, 0x0c, 0xe6, 0x05, 0xe3, 0x4e,
	0x1d, 0x2d, 0xf5, 0x90, 0x7c, 0x0a, 0x4e, 0x30, 0x9b, 0xb1, 0x79, 0x91, 0xfb, 0x67, 0x8b, 0xf8,
	0x0b, 0x1f, 0x97, 0xb4, 0x98, 0x87, 0x41, 0xc1, 0x9c, 0x8d, 0x07, 0xb5, 0xbd, 0x26, 0xbd, 0xad,
	0xe4, 0x87, 0x8b, 0xf8, 0x8b, 0x67, 0x71, 0xf6, 0x6a, 0x8a, 0x42, 0x32, 0x84, 0xfb, 0xda, 0x30,
	0x08, 0x43, 0x9f, 0xb3, 0x24, 0x5b, 0xb2, 0xb2, 0x79, 0xee, 0x6c, 0xa2, 0xfd, 0x8e, 0x52, 0xeb,
	0x87, 0x21, 0x45, 0xa5, 0xb5, 0x93, 0x9c, 0x1c, 0xc1, 0x43, 0xed, 0x25, 0x8c, 0x38, 0x9b, 0x15,
	0x7e, 0x9c, 0x5d, 0x44, 0xb3, 0x20, 0x46, 0x4f, 0xb9, 0x5e, 0x49, 0x03, 0x3d, 0xe9, 0x09, 0x87,
	0xa8, 0x79, 0x24, 0x15, 0x85, 0xb7, 0x5c, 0xba, 0xeb, 0x7d, 0x0a, 0xad, 0x35, 0x81, 0x39, 0xd9,
	0x03, 0x23, 0x2a, 0x58, 0x92, 0x3b, 0xb5, 0x07, 0x1b, 0x7b, 0xad, 0x8f, 0xc9, 0xbe, 0x3c, 0x81,
	0xfd, 0xb5, 0x0e, 0x95, 0x0a, 0xbd, 0xbf, 0xd4, 0xa0, 0x79, 0x92, 0x0c, 0xb2, 0xf4, 0x3c, 0xba,
	0x20, 0x04, 0x36, 0xd3, 0x20, 0x61, 0x8a, 0x7a, 0xfc, 0x26, 0x1f, 0xc1, 0x66, 0xf1, 0x7a, 0xce,
	0x90, 0xbd, 0xee, 0xc7, 0x77, 0xb4, 0x27, 0x6d, 0xb3, 0x7f, 0x92, 0xa0, 0x3b, 0x54, 0x12, 0x6c,
	0xb3, 0x34, 0x38, 0x8b, 0x59, 0xa8, 0x28, 0xd4, 0x43, 0x72, 0x1f, 0x5a, 0x79, 0x90, 0xcc, 0x63,
	0xe6, 0x9f, 0x73, 0xf6, 0x12, 0x09, 0xea, 0x50, 0x90, 0xd0, 0x33, 0xce, 0x5e, 0xf6, 0x3e, 0x03,
	0x53, 0xba, 0x22, 0x2d, 0x68, 0x0c, 0x8e, 0xa7, 0xa3, 0x89, 0x4b, 0xed, 0x1b, 0xc4, 0x02, 0xe3,
	0x79, 0x7f, 0xfa, 0xdc, 0xb5, 0x6b, 0xe2, 0x73, 0x3c, 0xe9, 0x4f, 0x5c, 0xbb, 0x2e, 0x55, 0x46,
	0x13, 0xf7, 0x17, 0x13, 0x7b, 0xa3, 0xf7, 0x87, 0x1a, 0x74, 0x4e, 0x92, 0xe7, 0x3c, 0x5b, 0xcc,
	0xd5, 0x3e, 0x76, 0x01, 0x2e, 0xc4, 0xd0, 0x2f, 0xed, 0xc6, 0x42, 0x64, 0x24, 0xb6, 0xb4, 0x12,
	0xe3, 0x52, 0xea, 0xb8, 0x14, 0x29, 0x16, 0x2b, 0x79, 0xc7, 0x26, 0x3e, 0x84, 0x46, 0xc2, 0x0a,
	0x1e, 0xcd, 0xc4, 0x09, 0x0b, 0x62, 0xed, 0xeb, 0x74, 0x50, 0xad, 0xd0, 0xfb, 0x67, 0x0d, 0x2c,
	0x8d, 0xe6, 0x6f, 0x5c, 0xe9, 0xff, 0x87, 0x76, 0xc8, 0xce, 0x83, 0x45, 0x5c, 0x94, 0x17, 0xd1,
	0x52, 0x18, 0x2e, 0xe3, 0x3e, 0x34, 0x70, 0x4d, 0x7a, 0x19, 0x87, 0xc6, 0xbf, 0xbe, 0xfd, 0x66,
	0xb7, 0x46, 0x35, 0x4a, 0x3e, 0x84, 0x8e, 0xb0, 0xf5, 0xb3, 0x25, 0xe3, 0x3c, 0x0a, 0x99, 0xbc,
	0x75, 0x5a, 0xad, 0x2d, 0x64, 0xc7, 0x4a, 0x44, 0x1e, 0x81, 0x89, 0x66, 0xb9, 0x63, 0xe0, 0xc2,
	0x6f, 0xaf, 0x17, 0x5e, 0x22, 0x8e, 0x2a, 0xa5, 0xf2, 0x46, 0xcd, 0xef, 0xda, 0xe8, 0xdf, 0x6a,
	0x60, 0x78, 0x49, 0x70, 0xc1, 0xde, 0x7a, 0x7d, 0x1c, 0x68, 0x2c, 0x19, 0xcf, 0xa3, 0x2c, 0xd5,
	0xef, 0x4f, 0x0d, 0x85, 0xf6, 0x65, 0x90, 0x5f, 0xe2, 0xe6, 0x2c, 0x8a, 0xdf, 0xe4, 0x03, 0xb0,
	0xa3, 0x34, 0x2f, 0x82, 0x38, 0xf6, 0xc5, 0xb5, 0x2e, 0xa2, 0x44, 0xee, 0xca, 0xa2, 0x5b, 0x0a,
	0x1f, 0x2a, 0x58, 0x04, 0x85, 0x28, 0xf7, 0x83, 0x59, 0x11, 0x2d, 0x19, 0x06, 0x85, 0x26, 0x6d,
	0x46, 0x79, 0x1f, 0xc7, 0x82, 0xde, 0x28, 0xf7, 0x45, 0x78, 0x8a, 0x8a, 0x82, 0x85, 0x8e, 0x89,
	0xf2, 0x56, 0x94, 0x0f, 0x34, 0x44, 0xee, 0x42, 0x33, 0xca, 0xfd, 0x65, 0x10, 0x47, 0xa1, 0x7a,
	0x64, 0x8d, 0x28, 0x3f, 0x15, 0xc3, 0xde, 0x23, 0x30, 0x71, 0x43, 0x39, 0x79, 0x08, 0x46, 0x24,
	0xbe, 0xd4, 0x3b, 0xea, 0x68, 0x16, 0x50, 0x4c, 0xa5, 0xac, 0xf7, 0x8f, 0x06, 0x74, 0x10, 0x18,
	0x66, 0xaf, 0xd2, 0x38, 0x0b, 0xc2, 0x37, 0x4e, 0x5b, 0x13, 0x53, 0x2f, 0x11, 0x63, 0xc3, 0xc6,
	0x82, 0xc7, 0x6a, 0xf7, 0xe2, 0x53, 0x20, 0x33, 0x3e, 0x53, 0x4f, 0x43, 0x7c, 0x92, 0x63, 0xe8,
	0x86, 0xca, 0xa7, 0x9f, 0x17, 0x22, 0x1c, 0x18, 0xf8, 0x0a, 0xf7, 0x2a, 0xeb, 0xd0, 0xd3, 0x56,
	0x47, 0x63, 0xa1, 0x4f, 0x3b, 0x61, 0x79, 0x48, 0x1e, 0x42, 0x07, 0xd7, 0xec, 0xeb, 0x33, 0x31,
	0x71, 0xfa, 0x36, 0x82, 0xa7, 0xea, 0x60, 0x3e, 0x00, 0x5b, 0x5b, 0xb1, 0xd0, 0x3f, 0x7b, 0x2d,
	0x02, 0x5a, 0x03, 0x17, 0xb5, 0xb5, 0xc6, 0x0f, 0x05, 0x4c, 0x5e, 0x80, 0xc9, 0x59, 0x90, 0x67,
	0xa9, 0xd3, 0xc4, 0x85, 0x3d, 0xfe, 0x2f, 0x16, 0xf6, 0x2c, 0x88, 0xe2, 0x05, 0x67, 0x14, 0xed,
	0xa8, 0xb2, 0x27, 0xdf, 0x87, 0xad, 0x20, 0x0c, 0xa3, 0x22, 0xca, 0xd2, 0x20, 0xf6, 0xa3, 0xf4,
	0x3c, 0x73, 0x2c, 0x5c, 0x5b, 0x77, 0x0d, 0x7b, 0xe9, 0x79, 0x26, 0x03, 0xc9, 0x92, 0xf9, 0x33,
	0xbc, 0x86, 0x0e, 0xe0, 0xd1, 0x81, 0x80, 0xd4, 0xe3, 0xdf, 0x01, 0x2b, 0xce, 0x44, 0x1c, 0x0d,
	0x23, 0xee, 0xb4, 0x64, 0xb6, 0x40, 0x60, 0x18, 0x71, 0xe2, 0x41, 0x4b, 0x12, 0x20, 0xe9, 0x6c,
	0x7f, 0x27, 0x9d, 0x78, 0xa1, 0x82, 0x82, 0x49, 0x3a, 0x01, 0x8d, 0x25, 0x97, 0x3b, 0x60, 0x9d,
	0x47, 0x31, 0xf3, 0xf3, 0xe8, 0x4b, 0xe6, 0x74, 0x90, 0x9f, 0xa6, 0x00, 0xc6, 0xd1, 0x97, 0xac,
	0xf7, 0xa7, 0x1a, 0x90, 0x37, 0x8f, 0x83, 0x6c, 0x83, 0x3d, 0x3c, 0xfe, 0x7c, 0x74, 0x74, 0xdc,
	0x1f, 0xfa, 0xd3, 0xd1, 0x4f, 0x47, 0xc7, 0x9f, 0x8f, 0xec, 0x1b, 0xe4, 0x3d, 0x20, 0x2b, 0x74,
	0x3c, 0x1d, 0x0c, 0x5c, 0x77, 0xe8, 0x0e, 0xed, 0x5a, 0x05, 0xa7, 0xee, 0xcf, 0xa7, 0xee, 0x78,
	0xe2, 0x0e, 0xed, 0x7a, 0xc5, 0xcb, 0x78, 0xd2, 0xa7, 0x02, 0xdd, 0x20, 0xb7, 0x60, 0x6b, 0x85,
	0x3e, 0xeb, 0x7b, 0x47, 0xee, 0xd0, 0xde, 0x24, 0x0e, 0x6c, 0x97, 0x26, 0x1c, 0x4f, 0x4f, 0x4e,
	0x8e, 0x51, 0xdd, 0xa8, 0x38, 0x1f, 0xf4, 0x47, 0x03, 0xf7, 0x48, 0x58, 0x98, 0xbd, 0xdf, 0xd5,
	0xe0, 0xde, 0x7f, 0x3e, 0x2f, 0xd2, 0x86, 0xe6, 0xe8, 0xd8, 0x77, 0x29, 0x3d, 0x16, 0xd1, 0x79,
	0x0b, 0x5a, 0xde, 0xe8, 0xb4, 0x7f, 0xe4, 0x0d, 0xfd, 0x29, 0x3d, 0xb2, 0x6b, 0x02, 0x18, 0xba,
	0xa7, 0xde, 0xc0, 0xf5, 0x0f, 0xa7, 0xe3, 0x5f, 0xda, 0x75, 0x31, 0x8d, 0x37, 0x1a, 0x4f, 0x9f,
	0x3d, 0xf3, 0x06, 0x9e, 0x3b, 0x9a, 0xf8, 0xe3, 0x93, 0xfe, 0xc0, 0xb5, 0x37, 0xc8, 0x4d, 0xe8,
	0x28, 0x02, 0x94, 0xb3, 0x4d, 0xd2, 0x01, 0x6b, 0xbd, 0x10, 0xa3, 0xf7, 0x7b, 0x4d, 0x61, 0xe5,
	0x08, 0x84, 0xa1, 0xf7, 0xb3, 0xfe, 0x73, 0xb7, 0xc4, 0x1f, 0x81, 0xae, 0x84, 0xbc, 0x51, 0x7f,
	0x30, 0xf1, 0x4e, 0x45, 0xb2, 0xd8, 0x06, 0x5b, 0x62, 0x88, 0xf4, 0x27, 0xde, 0xe8, 0xb9, 0x5d,
	0x27, 0x36, 0xb4, 0x4b, 0xa8, 0x2b, 0x59, 0x93, 0x08, 0x75, 0x4f, 0x5d, 0x8a, 0x6a, 0x9b, 0x6b,
	0x87, 0x12, 0xc4, 0xe5, 0xfc, 0x04, 0xba, 0x15, 0x5a, 0x72, 0xf2, 0x91, 0x4e, 0xb2, 0xf5, 0x6a,
	0x48, 0xad, 0xa8, 0xe9, 0x3c, 0xfb, 0xb5, 0x01, 0x9b, 0x27, 0x19, 0x2f, 0xc8, 0x1d, 0x68, 0xcc,
	0x33, 0x5e, 0xf8, 0x69, 0x86, 0x01, 0xa2, 0x43, 0x4d, 0x31, 0x1c, 0x65, 0x64, 0x1b, 0x8c, 0x38,
	0x38, 0x63, 0xb1, 0x8a, 0x12, 0x72, 0x40, 0x3e, 0x50, 0xe9, 0x77, 0x03, 0x6f, 0xea, 0x3a, 0x6c,
	0x67, 0xbc, 0xc0, 0x3f, 0xa5, 0xe4, 0xfb, 0x63, 0x68, 0x05, 0x61, 0x12, 0xa5, 0x95, 0x50, 0xe1,
	0xec, 0xab, 0x22, 0xad, 0x2f, 0x44, 0x48, 0xe1, 0x3e, 0xd6, 0x08, 0x14, 0x82, 0x15, 0x22, 0x4c,
	0xb3, 0x39, 0xe3, 0x68, 0xb9, 0xc8, 0x31, 0x2a, 0x94, 0x4c, 0x8f, 0xe7, 0x8c, 0x8f, 0x51, 0xa2,
	0x4d, 0xb3, 0x15, 0x22, 0x9e, 0x81, 0xac, 0x22, 0x7d, 0x15, 0x48, 0x2d, 0xda, 0x94, 0x80, 0x17,
	0x0a, 0x8a, 0xe6, 0x8c, 0xf1, 0xdc, 0x69, 0x5e, 0xcb, 0x3a, 0xb8, 0x7c, 0xc6, 0xb8, 0xf8, 0xa0,
	0x52, 0x47, 0xa4, 0x65, 0x7e, 0xe5, 0xcf, 0x83, 0xd9, 0x17, 0xac, 0xc8, 0xf1, 0xf5, 0x9b, 0xd4,
	0xe2, 0x57, 0x27, 0x12, 0x10, 0x01, 0x9b, 0x5f, 0xa9, 0x70, 0x04, 0x28, 0x6c, 0xf0, 0x2b, 0x19,
	0x86, 0x76, 0xc0, 0xe2, 0x57, 0x3e, 0xe3, 0x3c, 0xe3, 0x39, 0x3e, 0x79, 0x93, 0x36, 0xf9, 0x95,
	0x8b, 0x63, 0xe1, 0xb6, 0x58, 0xbb, 0x6d, 0x4b, 0xb7, 0x45, 0xd9, 0x6d, 0xa1, 0xdd, 0x76, 0xa4,
	0xdb, 0x62, 0xed, 0xb6, 0x58, 0xb9, 0xed, 0x4a, 0xb7, 0x85, 0x72, 0x7b, 0xef, 0x29, 0x34, 0xf5,
	0x06, 0xaa, 0x1c, 0xd4, 0xae, 0x71, 0x50, 0x3a, 0xf0, 0x7a, 0xf9, 0xc0, 0x7b, 0x39, 0x34, 0xf5,
	0x09, 0x8a, 0x82, 0x66, 0x7d, 0x9f, 0x6d, 0x68, 0xbb, 0x93, 0x17, 0x2e, 0x1d, 0xb9, 0x13, 0x7f,
	0x34, 0xf2, 0xec, 0x5a, 0x05, 0x99, 0x8e, 0x3c, 0x59, 0x01, 0x9d, 0x1c, 0x8f, 0xfc, 0xe3, 0xa3,
	0x89, 0xbd, 0xb1, 0x1a, 0x8c, 0xa6, 0xf2, 0x19, 0x9d, 0xba, 0x42, 0x51, 0xc8, 0x8c, 0xd2, 0x70,
	0x34, 0xb5, 0xcd, 0xde, 0x47, 0x60, 0x88, 0x49, 0x73, 0xd2, 0xab, 0x96, 0x88, 0xed, 0xf2, 0xd1,
	0xe8, 0x4b, 0xfb, 0xd7, 0x36, 0x98, 0xb2, 0x64, 0x24, 0xb7, 0xd7, 0x29, 0x4d, 0x57, 0x18, 0x22,
	0xb3, 0xdd, 0x2d, 0x55, 0x87, 0x2b, 0x81, 0xbc, 0x8e, 0x77, 0x61, 0x93, 0x67, 0x59, 0x51, 0x2d,
	0x5e, 0x10, 0x22, 0x3d, 0xb0, 0xe6, 0x01, 0x67, 0x69, 0x21, 0xf8, 0xda, 0x2c, 0x9b, 0x36, 0x25,
	0x8e, 0x57, 0xa7, 0xab, 0x74, 0x34, 0x7b, 0xdb, 0x82, 0xbd, 0x55, 0x79, 0x23, 0x85, 0x27, 0xf2,
	0xed, 0xec, 0x82, 0x29, 0x4b, 0x7e, 0xd9, 0x1e, 0x68, 0x25, 0x05, 0x92, 0x1d, 0x30, 0x92, 0x2c,
	0x64, 0xb1, 0x4c, 0x77, 0x5a, 0x2a, 0x31, 0xf2, 0x18, 0xec, 0xcb, 0x80, 0x87, 0xaf, 0x02, 0xbe,
	0x4e, 0x8b, 0x8d, 0xb2, 0xde, 0x96, 0x16, 0xeb, 0x04, 0xf9, 0x18, 0xec, 0xf3, 0x88, 0x27, 0x15,
	0x8b, 0x66, 0xc5, 0x42, 0x8b, 0xb5, 0xc5, 0x23, 0x30, 0x31, 0x73, 0xc8, 0x6b, 0xdd, 0xfa, 0xb8,
	0x5b, 0x89, 0x15, 0xf9, 0x6a, 0xbd, 0x52, 0x49, 0x54, 0x76, 0x39, 0xe3, 0x51, 0x10, 0xfb, 0xe9,
	0x22, 0x39, 0x63, 0x1c, 0xef, 0xfb, 0xca, 0x7b, 0x5b, 0xca, 0x46, 0x28, 0x12, 0x5c, 0xae, 0x9b,
	0x23, 0xa7, 0xc2, 0xe5, 0xaa, 0x47, 0xba, 0xbf, 0x6e, 0x82, 0x5a, 0x65, 0x8d, 0x55, 0x2f, 0x44,
	0x60, 0x73, 0x19, 0x07, 0x29, 0xbe, 0x8e, 0x0e, 0xc5, 0x6f, 0x91, 0x68, 0x93, 0x60, 0x26, 0x5a,
	0x1c, 0xce, 0x72, 0xf9, 0x36, 0x2c, 0x0a, 0x49, 0x30, 0xeb, 0x4b, 0x84, 0x3c, 0x84, 0x76, 0x34,
	0x5f, 0xfe, 0x68, 0xa5, 0x21, 0x5e, 0x88, 0xf5, 0xe2, 0x06, 0x6d, 0x09, 0xb4, 0xaa, 0xf4, 0xc9,
	0x4a, 0x69, 0xab, 0xa4, 0xf4, 0x89, 0x56, 0x7a, 0x1f, 0x3a, 0x97, 0x59, 0x5e, 0xf8, 0x41, 0x1a,
	0xe2, 0x69, 0x3b, 0xb7, 0xb5, 0x96, 0x80, 0xfb, 0x69, 0x88, 0xaf, 0x6c, 0x17, 0x80, 0x5d, 0x15,
	0x3c, 0xf0, 0x03, 0x7e, 0x91, 0x3b, 0x77, 0x64, 0x55, 0x8f, 0x48, 0x9f, 0x5f, 0xe4, 0xe4, 0x29,
	0x74, 0xe6, 0x3c, 0xbb, 0x7a, 0xbd, 0x9a, 0xea, 0x16, 0x52, 0xbd, 0x53, 0xed, 0x7d, 0xf6, 0x4f,
	0x84, 0x8e, 0x9a, 0x98, 0xb6, 0xe7, 0xa5, 0xd1, 0xf5, 0x00, 0x6a, 0xff, 0x0f, 0x01, 0xf4, 0x69,
	0x35, 0x80, 0xde, 0x7c, 0x77, 0x00, 0xd5, 0xfc, 0x97, 0xe3, 0xe8, 0xee, 0xaa, 0x94, 0x7a, 0xaf,
	0x72, 0x85, 0x55, 0x7d, 0xe4, 0x41, 0x77, 0x96, 0xa5, 0xa9, 0xe8, 0x13, 0xd5, 0x1c, 0x04, 0xe7,
	0xd8, 0xd1, 0x73, 0x0c, 0xa4, 0xf4, 0x6d, 0xd3, 0x74, 0x66, 0x65, 0x19, 0xf9, 0x01, 0x98, 0xb3,
	0x45, 0x5e, 0x64, 0x89, 0xf3, 0x14, 0x19, 0xda, 0xde, 0x97, 0x0d, 0xff, 0xbe, 0x6e, 0xf8, 0xf7,
	0xfb, 0xe9, 0x6b, 0xaa, 0x74, 0xc8, 0x13, 0x30, 0xc4, 0x91, 0xe4, 0xce, 0xaf, 0xdf, 0x12, 0x28,
	0x0e, 0xbb, 0x7f, 0xff, 0xf6, 0x9b, 0x5d, 0x6b, 0x15, 0xe1, 0xa8, 0xd4, 0x25, 0x8f, 0xc1, 0xc0,
	0x2e, 0xd6, 0xf9, 0x4d, 0x0d, 0xa7, 0x20, 0xfb, 0xe5, 0xa6, 0x1f, 0x1b, 0xd7, 0x43, 0x43, 0x98,
	0xde, 0xa0, 0x52, 0x51, 0x10, 0x88, 0x62, 0xd5, 0xa5, 0xfc, 0x56, 0xda, 0xdd, 0x79, 0xc3, 0x0e,
	0xbb, 0x95, 0x95, 0x31, 0x9c, 0xaf, 0x20, 0xf2, 0x19, 0xc0, 0x3c, 0x51, 0x65, 0x61, 0xee, 0x7c,
	0x25, 0x1d, 0xdc, 0xbc, 0xde, 0xb7, 0xac, 0x4c, 0xad, 0xf9, 0xaa, 0x39, 0x3b, 0x82, 0x2d, 0x59,
	0x14, 0xea, 0xf2, 0x36, 0x77, 0xbe, 0xae, 0xbd, 0x23, 0xa7, 0x1f, 0xb6, 0x84, 0x0b, 0x53, 0x16,
	0xf5, 0xb4, 0x1b, 0x55, 0xca, 0x82, 0x7b, 0x5f, 0xd5, 0xa1, 0x5d, 0xbe, 0x64, 0xef, 0xce, 0x0e,
	0xf7, 0xa1, 0xa5, 0x84, 0xeb, 0x38, 0x4a, 0x21, 0x5c, 0xff, 0x18, 0xb2, 0x0b, 0x30, 0xbb, 0x0c,
	0xd2, 0x94, 0xc5, 0xc2, 0x7c, 0x43, 0x36, 0xab, 0x0a, 0xf1, 0x42, 0xb2, 0x07, 0xb6, 0x16, 0xcb,
	0x9e, 0x56, 0x45, 0xd4, 0x0e, 0xed, 0x2a, 0x1c, 0xe9, 0xf1, 0x42, 0x72, 0x00, 0xb7, 0xb4, 0x66,
	0xc1, 0x78, 0x12, 0xa5, 0x81, 0xa8, 0xaa, 0xd5, 0xef, 0x29, 0x44, 0x89, 0x26, 0x6b, 0x09, 0xb9,
	0x0d, 0x66, 0x96, 0x2e, 0x84, 0x43, 0x13, 0x1d, 0x1a, 0x59, 0xba, 0xf0, 0x42, 0xf2, 0x3e, 0x74,
	0x05, 0x9c, 0xb3, 0x5c, 0x84, 0x36, 0x9d, 0xf5, 0x3b, 0xb4, 0x9d, 0xa5, 0x8b, 0xb1, 0x04, 0xbd,
	0xf0, 0xd0, 0x12, 0x21, 0x07, 0xf7, 0xdf, 0x3b, 0x80, 0x86, 0x7c, 0x7b, 0xe2, 0xa1, 0x57, 0x92,
	0x4e, 0xb7, 0xfa, 0x36, 0x75, 0xda, 0xf9, 0xe3, 0x06, 0x6c, 0x8f, 0xa3, 0x64, 0x11, 0x07, 0x05,
	0xeb, 0xc7, 0x01, 0x4f, 0x28, 0x7b, 0xb9, 0x60, 0x79, 0xf1, 0x46, 0x5f, 0xf5, 0x7f, 0x60, 0x45,
	0x69, 0x18, 0xcd, 0x82, 0x22, 0xd3, 0x3f, 0xef, 0xac, 0x01, 0x91, 0x78, 0xa3, 0xb4, 0x38, 0xd7,
	0xb4, 0x59, 0xd4, 0x14, 0x43, 0xb9, 0x03, 0xbc, 0xaf, 0x82, 0x71, 0xf9, 0x13, 0x81, 0xec, 0x31,
	0xdb, 0x73, 0x95, 0x8e, 0xf1, 0x57, 0x82, 0x1e, 0x74, 0xc4, 0x3e, 0xd7, 0x47, 0x27, 0x99, 0x6a,
	0x65, 0xe9, 0x62, 0xa8, 0x4f, 0xef, 0x09, 0xbc, 0x17, 0xa5, 0x22, 0x05, 0x30, 0xff, 0x2c, 0x2a,
	0x64, 0xa9, 0xe0, 0x73, 0x11, 0x3c, 0x04, 0x65, 0x06, 0xbd, 0xa5, 0xa4, 0x87, 0x51, 0x81, 0x65,
	0x03, 0x95, 0x4d, 0x80, 0x11, 0xf2, 0xe8, 0xbc, 0x40, 0xde, 0x0c, 0x2a, 0x07, 0x62, 0xb5, 0x29,
	0x7b, 0xe5, 0xb3, 0x97, 0x21, 0xe6, 0x12, 0x83, 0x9a, 0x29, 0x7b, 0xe5, 0xbe, 0x14, 0x6d, 0xfe,
	0x4d, 0xc9, 0x77, 0x39, 0x21, 0xc8, 0xde, 0x68, 0x0b, 0x29, 0x2f, 0x25, 0x83, 0x17, 0x60, 0x89,
	0x90, 0x22, 0x4f, 0x16, 0x30, 0x40, 0x7c, 0xa8, 0x39, 0x7e, 0x1b, 0xa3, 0x18, 0x99, 0x50, 0x1b,
	0xeb, 0xc8, 0xb5, 0x71, 0xef, 0x7b, 0xd0, 0xa9, 0xc8, 0x88, 0x05, 0x06, 0xed, 0x7b, 0x63, 0x57,
	0xfe, 0x26, 0x33, 0x38, 0x72, 0xfb, 0xd4, 0xae, 0x1d, 0x8e, 0xe1, 0x56, 0xc6, 0x2f, 0xf0, 0x95,
	0xce, 0x32, 0x1e, 0xaa, 0xb9, 0x0e, 0xdb, 0xa7, 0xf8, 0x5f, 0xf2, 0xf4, 0xab, 0xfd, 0x8b, 0xa8,
	0xb8, 0x5c, 0x9c, 0x89, 0x48, 0x75, 0xa0, 0x35, 0x0f, 0xa4, 0xe6, 0x23, 0xf5, 0x9b, 0xe0, 0xf2,
	0xc9, 0xc1, 0x45, 0xa6, 0xb0, 0x33, 0x13, 0xc1, 0x27, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x35,
	0x16, 0x1c, 0x6d, 0xad, 0x14, 0x00, 0x00,
}
