/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// Vdsl2LineConfigurationExtensions2ClassID is the 16-bit ID for the OMCI
// Managed entity VDSL2 line configuration extensions 2
const Vdsl2LineConfigurationExtensions2ClassID = ClassID(323) // 0x0143

var vdsl2lineconfigurationextensions2BME *ManagedEntityDefinition

// Vdsl2LineConfigurationExtensions2 (Class ID: #323 / 0x0143)
//	This ME extends the xDSL line configuration MEs. The ME name was chosen because its attributes
//	were initially unique to ITU-T G.993.2 VDSL2. Due to continuing standards development, two of
//	the attributes (FEXT and NEXT TXREFVNds) are also used in [ITUT-G.992.3] and [ITUT-G.992.5].
//	This ME therefore pertains to the latter Recommendations as well as to [ITU-T-G.993.2].
//
//	The attributes of this ME are further defined in [ITU-T G.997.1].
//
//	An instance of this ME is created and deleted by the OLT.
//
//	Relationships
//		An instance of this ME may be associated with zero or more instances of the PPTP xDSL UNI part
//		1.////		The overall xDSL line configuration profile is modelled in several parts, all of which are
//		associated together through a common ME ID. (The client PPTP xDSL UNI part 1 has a single
//		pointer, which refers to the entire set of line configuration parts.)
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. All xDSL and VDSL2 line
//			configuration profiles and extensions that pertain to a given PPTP xDSL must share a common ME
//			ID. (R, setbycreate) (mandatory) (2-bytes)
//
//		Sos Time Downstream
//			The SOS-TIME-ds attribute is used in the specification of receiver initiated SOS (see clause
//			13.4.3 of [ITUT G.993.2]). If the attribute value is not zero, the standard SOS triggering
//			criteria are enabled, and the value specifies the duration of the window used in the standard
//			SOS triggering criteria in the downstream direction. The special value zero indicates that the
//			standard SOS triggering criteria are disabled, i.e., vendor-discretionary values may be used
//			instead of the values configured in the MIB for the following parameters: SOS-NTONES-ds, SOS-
//			CRC-ds, SOS-TIME-ds. The valid range of non-zero values is from 1..255, specifying 64-ms to
//			16320 ms in steps of 64-ms. (R,-W, setbycreate) (optional) (1-byte)
//
//		Sos Time Upstream
//			The SOS-TIME-us attribute is used in the specification of receiver initiated SOS (see clause
//			13.4.3 of [ITUT G.993.2]). If the attribute value is not zero, the standard SOS triggering
//			criteria are enabled, and the value specifies the duration of the window used in the standard
//			SOS triggering criteria in the upstream direction. The special value zero indicates that the
//			standard SOS triggering criteria are disabled, i.e., vendor-discretionary values may be used
//			instead of the values configured in the MIB for the following parameters: SOS-NTONES-us, SOS-
//			CRC-us, SOS-TIME-us. The valid range of non-zero values is from 1..255, specifying 64-ms to
//			16320-ms in steps of 64-ms. (R,-W, setbycreate) (optional) (1-byte)
//
//		Sos Degraded Tones Threshold Downstream
//			The SOS-NTONES-ds attribute is the minimum percentage of tones in the downstream medley set that
//			must be degraded in order to arm the first subcondition of the standard SOS triggering criteria
//			in the downstream direction. The valid range of values is from 1 to 100% in steps of 1. Use of
//			the special value 0 is described in clause 13.4.3.2 of [ITUT G.993.2]. (R,-W, setbycreate)
//			(optional) (1-byte)
//
//		Sos Degraded Tones Threshold Upstream
//			The SOS-NTONES-us attribute is the minimum percentage of tones in the upstream medley set that
//			must be degraded in order to arm the first subcondition of the standard SOS triggering criteria
//			in the upstream direction. The valid range of values is from 1 to 100% in steps of 1. Use of the
//			special value 0 is described in clause 13.4.3.2 of [ITUT-G.993.2]. (R,-W, setbycreate)
//			(optional) (1-byte)
//
//		Sos Crc Threshold Downstream
//			The SOS-CRC-ds attribute is the minimum number of normalized CRC anomalies received in SOS-TIME-
//			ds seconds in order to arm the second sub-condition of the standard SOS triggering criteria (see
//			clause 13.4.3.2 of [ITU T G.993.2]) in the downstream direction. The valid range of SOS-CRC
//			values is 0.02 to (216-1)*0.02, in steps of 0.02. The value-0 specifies that the ONU uses its
//			internal default. (R, W, set-by-create) (optional) (2 bytes)
//
//		Sos Crc Threshold Upstream
//			The SOS-CRC-us attribute is the minimum number of normalized CRC anomalies received in SOS-TIME-
//			us seconds in order to arm the second sub-condition of the standard SOS triggering criteria (see
//			clause 13.4.3.2 of [ITU T G.993.2]) in the upstream direction. The valid range of SOS-CRC values
//			is 0.02 to (216-1)*0.02, in steps of 0.02. The value-0 specifies that the ONU uses its internal
//			default. (R, W, set-by-create) (optional) (2 bytes)
//
//		Max Sos Downstream
//			The MAX-SOS-ds attribute is used in deactivation. If the number of successful SOS procedures in
//			the downstream direction performed within a 120-s interval exceeds MAX-SOS-ds, the modem goes to
//			state L3. See clause 12.1.4 of [ITUT G.993.2] for details. The valid range of values is 1 to 15,
//			with the special value 0 as described in clause 12.1 of [ITUT G.993.2]. (R,-W, setbycreate)
//			(optional) (1-byte)
//
//		Max Sos Upstream
//			The MAX-SOS-us attribute is used in deactivation. If the number of successful SOS procedures in
//			the upstream direction performed within a 120-s interval exceeds MAX-SOS-us, the modem goes to
//			state L3. See clause 12.1.4 of [ITUT G.993.2] for details. The valid range of values is 1 to 15,
//			with the special value 0 as described in clause 12.1 of [ITUT G.993.2]. (R,-W, setbycreate)
//			(optional) (1-byte)
//
//		Snr Max Offset Downstream
//			The SNRMOFFSET-ROC-ds attribute is the SNR margin offset for the ROC in the downstream
//			direction. The attribute is used in the specification of the channel initialization policy (see
//			clause 12.3.7.1 of [ITUT G.993.2]). The valid range of SNR margin offset values is from 0..31-dB
//			in 0.1-dB steps. (R,-W, setbycreate) (optional) (2-bytes)
//
//		Snr Max Offset Upstream
//			The SNRMOFFSET-ROC-us attribute is the SNR margin offset for the ROC in the upstream direction.
//			The attribute is used in the specification of the channel initialization policy (see
//			clause-12.3.7.1 of [ITUT G.993.2]). The valid range of SNR margin offset values is from 0..31-dB
//			in 0.1-dB steps. (R,-W, setbycreate) (optional) (2-bytes)
//
//		Roc Minimum Impulse Noise Protection Downstream
//			The INPMIN-ROC-ds attribute specifies the minimum INP to apply on the ROC in the downstream
//			direction expressed in multiples of equivalent 4k DMT, xDSL (DMT) symbol length. The minimum INP
//			is an integer ranging from 0 to 8. (R,-W, setbycreate) (optional) (1-byte)
//
//		Roc Minimum Impulse Noise Protection Upstream
//			The INPMIN-ROC-us attribute specifies the minimum impulse noise protection to apply on the ROC
//			in the upstream direction expressed in multiples of equivalent 4k DMT symbol length. The minimum
//			INP is an integer ranging from 0 to 8. (R,-W, setbycreate) (optional) (1-byte)
//
//		Fext Downstream Transmitter Referred Virtual Noise Table
//			The FEXT TXREFVNds attribute is the downstream transmitter referred virtual noise specified for
//			FEXTR duration in Annex C of [ITUT G.992.3] (ADSL2) and Annex C of [ITUT G.992.5] (ADSL2plus).
//			The syntax of this attribute is the same as that of the TXREFVNds table attribute of the VDSL2
//			line configuration extensions ME. (R,-W) (mandatory for Annex-C of [ITUT-G.992.3] and Annex-C of
//			[ITUT-G.992.5]) (3-*-N bytes, where N is the number of breakpoints)
//
//		Next Downstream Transmitter Referred Virtual Noise Table
//			The NEXT TXREFVNds attribute is the downstream transmitter referred virtual noise specified for
//			NEXTR duration in Annex C of [ITUT G.992.3] (ADSL2) and Annex C of [ITUT G.992.5] (ADSL2plus).
//			The syntax of this attribute is the same as that of the TXREFVNds table attribute of the VDSL2
//			line configuration extensions ME. (R,-W) (mandatory for Annex-C of [ITUT-G.992.3] and Annex-C of
//			[ITUT-G.992.5]) (3-*-N bytes, where N is the number of breakpoints)
//
type Vdsl2LineConfigurationExtensions2 struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	vdsl2lineconfigurationextensions2BME = &ManagedEntityDefinition{
		Name:    "Vdsl2LineConfigurationExtensions2",
		ClassID: 323,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			GetNext,
			Set,
			SetTable,
		),
		AllowedAttributeMask: 0xfffc,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField("SosTimeDownstream", UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 1),
			2:  ByteField("SosTimeUpstream", UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 2),
			3:  ByteField("SosDegradedTonesThresholdDownstream", UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 3),
			4:  ByteField("SosDegradedTonesThresholdUpstream", UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 4),
			5:  Uint16Field("SosCrcThresholdDownstream", UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 5),
			6:  Uint16Field("SosCrcThresholdUpstream", UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 6),
			7:  ByteField("MaxSosDownstream", UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 7),
			8:  ByteField("MaxSosUpstream", UnsignedIntegerAttributeType, 0x0100, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 8),
			9:  Uint16Field("SnrMaxOffsetDownstream", UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 9),
			10: Uint16Field("SnrMaxOffsetUpstream", UnsignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 10),
			11: ByteField("RocMinimumImpulseNoiseProtectionDownstream", UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 11),
			12: ByteField("RocMinimumImpulseNoiseProtectionUpstream", UnsignedIntegerAttributeType, 0x0010, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 12),
			13: TableField("FextDownstreamTransmitterReferredVirtualNoiseTable", TableAttributeType, 0x0008, TableInfo{nil, 3}, mapset.NewSetWith(Read, Write), false, false, false, 13),
			14: TableField("NextDownstreamTransmitterReferredVirtualNoiseTable", TableAttributeType, 0x0004, TableInfo{nil, 3}, mapset.NewSetWith(Read, Write), false, false, false, 14),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
	}
}

// NewVdsl2LineConfigurationExtensions2 (class ID 323) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewVdsl2LineConfigurationExtensions2(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*vdsl2lineconfigurationextensions2BME, params...)
}
