/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 /*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// EnhancedTcPerformanceMonitoringHistoryDataClassID is the 16-bit ID for the OMCI
// Managed entity Enhanced TC performance monitoring history data
const EnhancedTcPerformanceMonitoringHistoryDataClassID ClassID = ClassID(454)

var enhancedtcperformancemonitoringhistorydataBME *ManagedEntityDefinition

// EnhancedTcPerformanceMonitoringHistoryData (class ID #454)
//	This ME collects PM data associated with the XGS-PON and subsequent ITU-T PON systems' TC layer.
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an ANI-G.
//
//	Attributes
//		Managed Entity Id
//			Managed entity ID: This attribute uniquely identifies each instance of this ME. Through an
//			identical ID, this ME is implicitly linked to an instance of the ANI-G. (R, set-by-create)
//			(mandatory) (2-bytes)
//
//		Interval End Time
//			Interval end time: This attribute identifies the most recently finished 15-min interval. (R)
//			(mandatory) (1-byte)
//
//		Threshold Data 64 Bit Id
//			Threshold data 64-bit ID: This attribute points to an instance of the threshold data 64-bit ME
//			that contains PM threshold values. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Psbd Hec Error Count
//			PSBd HEC error count: This attribute counts HEC errors in any of the fields of the downstream
//			physical sync block. (R) (optional) (4-bytes)
//
//		Xgtc Hec Error Count
//			XGTC HEC error count: This attribute counts HEC errors detected in the XGTC header. In [ITU-T
//			G.9807.1], this attribute is used for FS HEC error count management. (R) (optional) (4-bytes)
//
//		Unknown Profile Count
//			Unknown profile count: This attribute counts the number of grants received whose specified
//			profile was not known to the ONU. (R) (optional) (4-bytes)
//
//		Transmitted Xgem Frames
//			Transmitted XGEM frames: This attribute counts the number of non-idle XGEM frames transmitted.
//			If an SDU is fragmented, each fragment is an XGEM frame and is counted as such. (R) (mandatory)
//			(8 bytes)
//
//		Fragment Xgem Frames
//			Fragment XGEM frames: This attribute counts the number of XGEM frames that represent fragmented
//			SDUs, as indicated by the LF bit = 0. (R) (optional) (8-bytes)
//
//		Xgem Hec Lost Words Count
//			XGEM HEC lost words count: This attribute counts the number of 4-byte words lost because of an
//			XGEM frame HEC error. In general, all XGTC payload following the error is lost, until the next
//			PSBd event. (R) (optional) (8 bytes)
//
//		Xgem Key Errors
//			(R) (mandatory) (8 bytes)
//
//		Xgem Hec Error Count
//			XGEM HEC error count: This attribute counts the number of instances of an XGEM frame HEC error.
//			(R) (mandatory) (8 bytes)
//
//		Transmitted Bytes In Non_Idle Xgem Frames
//			Transmitted bytes in non-idle XGEM frames: This attribute counts the number of transmitted bytes
//			in non-idle XGEM frames. (R) (mandatory) (8 bytes)
//
//		Received Bytes In Non_Idle Xgem Frames
//			Received bytes in non-idle XGEM frames: This attribute counts the number of received bytes in
//			non-idle XGEM frames. (R) (optional) (8 bytes)
//
//		Lods Event Count
//			LODS event count: This attribute counts the number of state transitions from O5.1 to O6. (R)
//			(optional) (4-bytes)
//
//		Lods Event Restored Count
//			LODS event restored count: This attribute counts the number of LODS cleared events. (R)
//			(optional) (4-bytes)
//
//		Onu Reactivation By Lods Events
//			ONU reactivation by LODS events: This attribute counts the number of LODS events resulting in
//			ONU reactivation without synchronization being reacquired. (R) (optional) (4-bytes)
//
type EnhancedTcPerformanceMonitoringHistoryData struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	enhancedtcperformancemonitoringhistorydataBME = &ManagedEntityDefinition{
		Name:    "EnhancedTcPerformanceMonitoringHistoryData",
		ClassID: 454,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
		),
		AllowedAttributeMask: 0xfffe,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField("IntervalEndTime", UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field("ThresholdData64BitId", UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field("PsbdHecErrorCount", CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, true, false, 3),
			4:  Uint32Field("XgtcHecErrorCount", CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, true, false, 4),
			5:  Uint32Field("UnknownProfileCount", CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, true, false, 5),
			6:  Uint64Field("TransmittedXgemFrames", CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint64Field("FragmentXgemFrames", CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, true, false, 7),
			8:  Uint64Field("XgemHecLostWordsCount", CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, true, false, 8),
			9:  Uint64Field("XgemKeyErrors", CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: Uint64Field("XgemHecErrorCount", CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
			11: Uint64Field("TransmittedBytesInNonIdleXgemFrames", CounterAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, false, false, 11),
			12: Uint64Field("ReceivedBytesInNonIdleXgemFrames", CounterAttributeType, 0x0010, 0, mapset.NewSetWith(Read), false, true, false, 12),
			13: Uint32Field("LodsEventCount", CounterAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, true, false, 13),
			14: Uint32Field("LodsEventRestoredCount", CounterAttributeType, 0x0004, 0, mapset.NewSetWith(Read), false, true, false, 14),
			15: Uint32Field("OnuReactivationByLodsEvents", CounterAttributeType, 0x0002, 0, mapset.NewSetWith(Read), false, true, false, 15),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
	}
}

// NewEnhancedTcPerformanceMonitoringHistoryData (class ID 454) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewEnhancedTcPerformanceMonitoringHistoryData(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*enhancedtcperformancemonitoringhistorydataBME, params...)
}
