/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// TwdmChannelPloamPerformanceMonitoringHistoryDataPart3ClassID is the 16-bit ID for the OMCI
// Managed entity TWDM channel PLOAM performance monitoring history data part 3
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3ClassID = ClassID(448) // 0x01c0

var twdmchannelploamperformancemonitoringhistorydatapart3BME *ManagedEntityDefinition

// TwdmChannelPloamPerformanceMonitoringHistoryDataPart3 (Class ID: #448 / 0x01c0)
//	This ME collects remaining PLOAM-related PM data associated with the slot/circuit pack, hosting
//	one or more ANI-G MEs, for a specific TWDM channel. Instances of this ME are created and deleted
//	by the OLT.
//
//	This ME contains the counters related to transmitted upstream PLOAM messages. All these counters
//	are characterized as optional in clause 14 of [ITU-T- G.989.3].
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an instance of TWDM channel ME.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the TWDM channel ME. (R, setbycreate) (mandatory) (2-bytes)
//
//		Interval End Time
//			This attribute identifies the most recently finished 15-min interval. (R) (mandatory) (1-byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 and 2 MEs
//			that contains PM threshold values. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Upstream Ploam Message Count
//			The aggregate counter of PLOAM messages, other than AK PLOAM MT, transmitted by the given ONU.
//			(R) (mandatory) (4-byte)
//
//		Serial_Number_Onu In_Band Message Count
//			Serial_Number_ONU (in-band) message count: The counter of transmitted in-band Serial_Number_ONU
//			PLOAM messages. (R) (mandatory) (4-byte)
//
//		Serial_Number_Onu Amcc Message Count
//			Serial_Number_ONU (AMCC) message count: The counter of transmitted auxiliary management and
//			control channel (AMCC) Serial_Number_ONU PLOAM messages. (R) (mandatory) (4-byte)
//
//		Registration Message Count
//			The counter of transmitted Registration PLOAM messages. (R) (mandatory) (4-byte)
//
//		Key_Report Message Count
//			The counter of transmitted Key_Report PLOAM messages. (R) (mandatory) (4-byte)
//
//		Acknowledgement Message Count
//			The counter of transmitted Registration PLOAM messages. (R) (mandatory) (4-byte)
//
//		Sleep_Request Message Count
//			The counter of transmitted Sleep_Request PLOAM messages. (R) (mandatory) (4-byte)
//
//		Tuning_Response Ack_Nack Message Count
//			Tuning_Response (ACK/NACK) message count: The counter of transmitted Tuning_Response PLOAM
//			messages with ACK/NACK operation code. (R) (mandatory) (4-byte)
//
//		Tuning_Response Complete_U_Rollback Message Count
//			Tuning_Response (Complete_u/Rollback) message count: The counter of transmitted Tuning_Response
//			PLOAM messages with Complete_u/Rollback operation code. (R) (mandatory) (4-byte)
//
//		Power_Consumption_Report Message Count
//			The counter of transmitted Power_Consumption_Report PLOAM messages. (R) (mandatory) (4-byte)
//
//		Change_Power_Level Parameter Error Count
//			The counter of transmitted Acknowledgement PLOAM messages with Parameter Error completion code
//			in response to Change_Power_Level PLOAM message. (R) (mandatory) (4-byte)
//
type TwdmChannelPloamPerformanceMonitoringHistoryDataPart3 struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_IntervalEndTime = "IntervalEndTime"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_ThresholdData12Id = "ThresholdData12Id"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_UpstreamPloamMessageCount = "UpstreamPloamMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_SerialNumberOnuInBandMessageCount = "SerialNumberOnuInBandMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_SerialNumberOnuAmccMessageCount = "SerialNumberOnuAmccMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_RegistrationMessageCount = "RegistrationMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_KeyReportMessageCount = "KeyReportMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_AcknowledgementMessageCount = "AcknowledgementMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_SleepRequestMessageCount = "SleepRequestMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_TuningResponseAckNackMessageCount = "TuningResponseAckNackMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_TuningResponseCompleteURollbackMessageCount = "TuningResponseCompleteURollbackMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_PowerConsumptionReportMessageCount = "PowerConsumptionReportMessageCount"
const TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_ChangePowerLevelParameterErrorCount = "ChangePowerLevelParameterErrorCount"

func init() {
	twdmchannelploamperformancemonitoringhistorydatapart3BME = &ManagedEntityDefinition{
		Name:    "TwdmChannelPloamPerformanceMonitoringHistoryDataPart3",
		ClassID: TwdmChannelPloamPerformanceMonitoringHistoryDataPart3ClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
			GetCurrentData,
		),
		AllowedAttributeMask: 0xfff8,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_IntervalEndTime, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_ThresholdData12Id, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_UpstreamPloamMessageCount, CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, false, false, 3),
			4:  Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_SerialNumberOnuInBandMessageCount, CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_SerialNumberOnuAmccMessageCount, CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, false, 5),
			6:  Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_RegistrationMessageCount, CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_KeyReportMessageCount, CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, false, false, 7),
			8:  Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_AcknowledgementMessageCount, CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, false, false, 8),
			9:  Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_SleepRequestMessageCount, CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_TuningResponseAckNackMessageCount, CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
			11: Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_TuningResponseCompleteURollbackMessageCount, CounterAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, false, false, 11),
			12: Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_PowerConsumptionReportMessageCount, CounterAttributeType, 0x0010, 0, mapset.NewSetWith(Read), false, false, false, 12),
			13: Uint32Field(TwdmChannelPloamPerformanceMonitoringHistoryDataPart3_ChangePowerLevelParameterErrorCount, CounterAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, false, false, 13),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0: "Change_Power_Level parameter error count",
		},
	}
}

// NewTwdmChannelPloamPerformanceMonitoringHistoryDataPart3 (class ID 448) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewTwdmChannelPloamPerformanceMonitoringHistoryDataPart3(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*twdmchannelploamperformancemonitoringhistorydatapart3BME, params...)
}
