/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// OnuPowerSheddingClassID is the 16-bit ID for the OMCI
// Managed entity ONU power shedding
const OnuPowerSheddingClassID = ClassID(133) // 0x0085

var onupowersheddingBME *ManagedEntityDefinition

// OnuPowerShedding (Class ID: #133 / 0x0085)
//	This ME models the ONU's ability to shed services when the ONU goes into battery operation mode
//	after AC power failure. Shedding classes are defined in the following table, which may span
//	multiple circuit pack types. This feature works in conjunction with the power shed override
//	attribute of the circuit pack ME, which can selectively prevent power shedding of priority
//	ports.
//
//	An ONU that supports power shedding automatically creates an instance of this ME.
//
//	The following table defines the binding of shedding class and PPTP type. The coding is taken
//	from Table 9.1.5-1. In the case of hybrid circuit pack types, multiple shedding classes may
//	affect a circuit pack if the hardware is capable of partial power shedding.
//
//	An ONU may choose to model its ports with the port-mapping package of clause 9.1.8, rather than
//	with real or virtual circuit packs. In this case, power shedding pertains to individual PPTPs
//	(listed in column 2 of the table).
//
//	Relationships
//		One instance of this ME is associated with the ONU ME.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. There is only one instance, number
//			0. (R) (mandatory) (2-bytes)
//
//		Restore Power Timer Reset Interval
//			The time delay, in seconds, before resetting the power-shedding timers after full power
//			restoration. Upon ME instantiation, the ONU sets this attribute to 0. (R,-W) (mandatory)
//			(2-bytes)
//
//			For each class of service (CoS), an interval attribute is defined below. The value 0 disables
//			power shedding, while the value 1 enables immediate power shedding, i.e., as soon as AC power
//			fails. Other values specify the time, in seconds, to keep the service active after AC failure
//			before shutting them down and shedding power. Upon ME instantiation, the ONU sets each of the
//			interval attributes to 0.
//
//		Data Class Shedding Interval
//			(R,-W) (mandatory) (2-bytes)
//
//		Voice Class Shedding Interval
//			This attribute only pertains to voice services that terminate on the ONU and are under the
//			management control of the OMCI. 	(R,-W) (mandatory) (2-bytes)
//
//		Video Overlay Class Shedding Interval
//			(R,-W) (mandatory) (2-bytes)
//
//		Video Return Class Shedding Interval
//			(R,-W) (mandatory) (2-bytes)
//
//		Digital Subscriber Line Class Shedding Interval
//			Digital subscriber line (DSL) class shedding interval:	(R,-W) (mandatory) (2-bytes)
//
//		Atm Class Shedding Interval
//			(R,-W) (mandatory) (2-bytes)
//
//		Ces Class Shedding Interval
//			(R,-W) (mandatory) (2-bytes)
//
//		Frame Class Shedding Interval
//			(R,-W) (mandatory) (2-bytes)
//
//		Sdh_Sonet Class Shedding Interval
//			Sdh-sonet class shedding interval:	(R,-W) (mandatory) (2-bytes)
//
//		Shedding Status
//			Binary indication of power-shedding status for each shedding class. If this 2 byte field is
//			depicted 0b ABCD EFGH IJKL MNOP, its bits are assigned as follows-
//
//			A	Data class
//
//			B	Voice class
//
//			C	Video overlay class
//
//			D	Video return class
//
//			E	DSL class
//
//			F	ATM class
//
//			G	CES class
//
//			H	Frame class
//
//			I	Sdh-sonet class
//
//			J..P	Reserved and set to 0
//
//			The ONU sets each bit to 1 when power shedding is active, and clears it to 0 when the service is
//			restored. (R) (optional) (2-bytes)
//
type OnuPowerShedding struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const OnuPowerShedding_RestorePowerTimerResetInterval = "RestorePowerTimerResetInterval"
const OnuPowerShedding_DataClassSheddingInterval = "DataClassSheddingInterval"
const OnuPowerShedding_VoiceClassSheddingInterval = "VoiceClassSheddingInterval"
const OnuPowerShedding_VideoOverlayClassSheddingInterval = "VideoOverlayClassSheddingInterval"
const OnuPowerShedding_VideoReturnClassSheddingInterval = "VideoReturnClassSheddingInterval"
const OnuPowerShedding_DigitalSubscriberLineClassSheddingInterval = "DigitalSubscriberLineClassSheddingInterval"
const OnuPowerShedding_AtmClassSheddingInterval = "AtmClassSheddingInterval"
const OnuPowerShedding_CesClassSheddingInterval = "CesClassSheddingInterval"
const OnuPowerShedding_FrameClassSheddingInterval = "FrameClassSheddingInterval"
const OnuPowerShedding_SdhSonetClassSheddingInterval = "SdhSonetClassSheddingInterval"
const OnuPowerShedding_SheddingStatus = "SheddingStatus"

func init() {
	onupowersheddingBME = &ManagedEntityDefinition{
		Name:    "OnuPowerShedding",
		ClassID: OnuPowerSheddingClassID,
		MessageTypes: mapset.NewSetWith(
			Get,
			Set,
		),
		AllowedAttributeMask: 0xffe0,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read), false, false, false, 0),
			1:  Uint16Field(OnuPowerShedding_RestorePowerTimerResetInterval, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read, Write), false, false, false, 1),
			2:  Uint16Field(OnuPowerShedding_DataClassSheddingInterval, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, Write), false, false, false, 2),
			3:  Uint16Field(OnuPowerShedding_VoiceClassSheddingInterval, UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, Write), false, false, false, 3),
			4:  Uint16Field(OnuPowerShedding_VideoOverlayClassSheddingInterval, UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read, Write), false, false, false, 4),
			5:  Uint16Field(OnuPowerShedding_VideoReturnClassSheddingInterval, UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read, Write), false, false, false, 5),
			6:  Uint16Field(OnuPowerShedding_DigitalSubscriberLineClassSheddingInterval, UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read, Write), false, false, false, 6),
			7:  Uint16Field(OnuPowerShedding_AtmClassSheddingInterval, UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read, Write), false, false, false, 7),
			8:  Uint16Field(OnuPowerShedding_CesClassSheddingInterval, UnsignedIntegerAttributeType, 0x0100, 0, mapset.NewSetWith(Read, Write), false, false, false, 8),
			9:  Uint16Field(OnuPowerShedding_FrameClassSheddingInterval, UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read, Write), false, false, false, 9),
			10: Uint16Field(OnuPowerShedding_SdhSonetClassSheddingInterval, UnsignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read, Write), false, false, false, 10),
			11: Uint16Field(OnuPowerShedding_SheddingStatus, UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read), true, true, false, 11),
		},
		Access:  CreatedByOnu,
		Support: UnknownSupport,
	}
}

// NewOnuPowerShedding (class ID 133) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewOnuPowerShedding(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*onupowersheddingBME, params...)
}
