/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// XdslLineConfigurationProfilePart2ClassID is the 16-bit ID for the OMCI
// Managed entity xDSL line configuration profile part 2
const XdslLineConfigurationProfilePart2ClassID = ClassID(105) // 0x0069

var xdsllineconfigurationprofilepart2BME *ManagedEntityDefinition

// XdslLineConfigurationProfilePart2 (Class ID: #105 / 0x0069)
//	The overall xDSL line configuration profile is modelled in several parts, all of which are
//	associated together through a common ME ID (the client PPTP xDSL UNI part 1 has a single
//	pointer, which refers to the entire set of line configuration profile parts).
//
//	Relationships
//		An instance of this ME may be associated with zero or more instances of an xDSL UNI.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. All xDSL and VDSL2 line
//			configuration profiles and extensions that pertain to a given PPTP xDSL UNI must share a common
//			ME ID. (R, setbycreate) (mandatory) (2-bytes)
//
//		Downstream Minimum Time Interval For Upshift Rate Adaptation
//			This parameter defines the interval during which the downstream noise margin must remain above
//			the downstream upshift noise margin before the xTU-R attempts to increase the downstream net
//			data rate. Its value ranges from 0 to 16383-s. (R,-W, setbycreate) (optional) (2-bytes)
//
//		Upstream Minimum Time Interval For Upshift Rate Adaptation
//			This parameter defines the interval during which the upstream noise margin must remain above the
//			upstream upshift noise margin before the xTU-C attempts to increase the upstream net data rate.
//			Its value ranges from 0 to 16383-s. (R,-W, setbycreate) (optional) (2-bytes)
//
//		Downstream Downshift Noise Margin
//			If the downstream noise margin is below the downstream downshift noise margin and remains there
//			for more than the downstream minimum time interval for downshift rate adaptation, the xTU-R
//			attempts to decrease the downstream net data rate. This attribute's value ranges from 0 (0.0 dB)
//			to 310 (31.0 dB). (R,-W, setbycreate) (optional) (2-bytes)
//
//		Upstream Downshift Noise Margin
//			If the upstream noise margin is below the upstream downshift noise margin and remains there for
//			more than the upstream minimum time interval for downshift rate adaptation, the xTUC attempts to
//			decrease the upstream net data rate. This attribute's value ranges from 0 (0.0 dB) to 310 (31.0
//			dB). (R,-W, setbycreate) (optional) (2-bytes)
//
//		Downstream Minimum Time Interval For Downshift Rate Adaptation
//			This parameter defines the interval during which the downstream noise margin must remain below
//			the downstream downshift noise margin before the xTU-R attempts to decrease the downstream net
//			data rate. Its value ranges from 0 to 16383-s. (R,-W, setbycreate) (optional) (2-bytes)
//
//		Upstream Minimum Time Interval For Downshift Rate Adaptation
//			This parameter defines the interval during which the upstream noise margin must remain below the
//			upstream downshift noise margin before the xTU-C attempts to decrease the upstream net data
//			rate. Its value ranges from 0 to 16383-s. (R,-W, setbycreate) (optional) (2-bytes)
//
//		Xtu Impedance State Forced
//			This parameter forces the impedance state of the xTU-C. It applies only to the T/S interface,
//			and is deprecated in the OMCI, which stands proxy for the Q interface. It is only valid for
//			Annex A of [ITUT G.992.3], Annex A of [ITUT G.992.4] and Annex A of [ITUT G.992.5]. It is
//			defined as follows.
//
//			1	Force the xTU-C to the disabled state.
//
//			2	Force the xTU-C to the inactive state.
//
//			3	Force the xTU-C to the active state.
//
//			(R,-W, setbycreate) (optional) (1-byte)
//
//		L0_Time
//			L0-time:	This parameter specifies the minimum time between an exit from the L2 state and the
//			next entry into the L2 state. It is only valid for [ITUT-G.992.3], [ITUT-G.992.4] and
//			[ITUT-G.992.5]. It ranges from 0 to 255-s. (R,-W, setbycreate) (mandatory) (1 byte)
//
//		L2_Time
//			L2-time:	This parameter specifies the minimum time between an entry into the L2 state and the
//			first power trim in the L2 state, or between two consecutive power trims in the L2 state. It is
//			only valid for [ITUT-G.992.3], [ITUT-G.992.4] and [ITUT-G.992.5]. It ranges from 0 to 255-s. (R,
//			W, setbycreate) (mandatory) (1 byte)
//
//		Downstream Maximum Nominal Power Spectral Density
//			This attribute specifies the maximum nominal transmit PSD in the downstream direction during
//			initialization and showtime. A single MAXNOMPSDds attribute is defined per mode enabled in the
//			xTSE line configuration attribute. It is only valid for [ITUT-G.992.3], [ITUT-G.992.4] and
//			[ITUT-G.992.5]. Its value ranges from 0 (60.0-dBm/Hz) to 300 (-30-dBm/Hz). (R, W, setbycreate)
//			(mandatory) (2 bytes)
//
//		Upstream Maximum Nominal Power Spectral Density
//			This attribute specifies the maximum nominal transmit PSD in the upstream direction during
//			initialization and showtime. A single MAXNOMPSDus attribute is defined per mode enabled in the
//			xTSE line configuration attribute. It is only valid for [ITUT-G.992.3], [ITUT-G.992.4] and
//			[ITUT-G.993.2]. Its value ranges from 0 (-60.0-dBm/Hz) to 300 (-30-dBm/Hz). (R, W, setbycreate)
//			(mandatory) (2 bytes)
//
//		Downstream Maximum Nominal Aggregate Transmit Power
//			This attribute specifies the maximum nominal aggregate transmit power in the downstream
//			direction during initialization and showtime. It is only valid for [ITUT-G.992.3],
//			[ITUT-G.992.4], [ITUT-G.992.5] and [ITUT-G.993.2]. Its value ranges from 0 (0.0-dBm) to 255
//			(25.5-dBm). (R, W, setbycreate) (mandatory) (1-byte)
//
//		Upstream Maximum Nominal Aggregate Transmit Power
//			This parameter specifies the maximum nominal aggregate transmit power in the upstream direction
//			during initialization and showtime. It is only valid for [ITUT-G.992.3], [ITUT-G.992.4] and
//			[ITUT-G.992.5]. Its value ranges from 0 (0.0-dBm) to 255 (25.5-dBm). (R, W, setbycreate)
//			(mandatory) (1 byte)
//
//		Upstream Maximum Aggregate_Receive Power
//			Upstream maximum aggregate-receive power: This parameter specifies the maximum upstream
//			aggregate receive power over a set of subcarriers, as defined in the relevant Recommendation.
//			The xTU-C requests an upstream power cutback such that the upstream aggregate receive power over
//			that set of subcarriers is at or below the configured maximum value. It is only valid for
//			[ITUT-G.992.3], [ITUT-G.992.4] and [ITUT-G.992.5]. This attribute ranges from 0 (25.5-dBm) to
//			510 (+25.5-dBm). The special value 0xFFFF indicates that no upstream maximum aggregate receive
//			power limit is to be applied. (R, W setbycreate) (mandatory) (2 bytes)
//
//		Vdsl2 Transmission System Enabling
//			This configuration attribute extends the transmission system coding types to be allowed by the
//			xTU-C. It is a bit map, defined as octet 8 (bits 57..64) in Table-9.7.12-1. (R, W, setbycreate)
//			(optional) (1 byte)
//
type XdslLineConfigurationProfilePart2 struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const XdslLineConfigurationProfilePart2_DownstreamMinimumTimeIntervalForUpshiftRateAdaptation = "DownstreamMinimumTimeIntervalForUpshiftRateAdaptation"
const XdslLineConfigurationProfilePart2_UpstreamMinimumTimeIntervalForUpshiftRateAdaptation = "UpstreamMinimumTimeIntervalForUpshiftRateAdaptation"
const XdslLineConfigurationProfilePart2_DownstreamDownshiftNoiseMargin = "DownstreamDownshiftNoiseMargin"
const XdslLineConfigurationProfilePart2_UpstreamDownshiftNoiseMargin = "UpstreamDownshiftNoiseMargin"
const XdslLineConfigurationProfilePart2_DownstreamMinimumTimeIntervalForDownshiftRateAdaptation = "DownstreamMinimumTimeIntervalForDownshiftRateAdaptation"
const XdslLineConfigurationProfilePart2_UpstreamMinimumTimeIntervalForDownshiftRateAdaptation = "UpstreamMinimumTimeIntervalForDownshiftRateAdaptation"
const XdslLineConfigurationProfilePart2_XtuImpedanceStateForced = "XtuImpedanceStateForced"
const XdslLineConfigurationProfilePart2_L0Time = "L0Time"
const XdslLineConfigurationProfilePart2_L2Time = "L2Time"
const XdslLineConfigurationProfilePart2_DownstreamMaximumNominalPowerSpectralDensity = "DownstreamMaximumNominalPowerSpectralDensity"
const XdslLineConfigurationProfilePart2_UpstreamMaximumNominalPowerSpectralDensity = "UpstreamMaximumNominalPowerSpectralDensity"
const XdslLineConfigurationProfilePart2_DownstreamMaximumNominalAggregateTransmitPower = "DownstreamMaximumNominalAggregateTransmitPower"
const XdslLineConfigurationProfilePart2_UpstreamMaximumNominalAggregateTransmitPower = "UpstreamMaximumNominalAggregateTransmitPower"
const XdslLineConfigurationProfilePart2_UpstreamMaximumAggregateReceivePower = "UpstreamMaximumAggregateReceivePower"
const XdslLineConfigurationProfilePart2_Vdsl2TransmissionSystemEnabling = "Vdsl2TransmissionSystemEnabling"

func init() {
	xdsllineconfigurationprofilepart2BME = &ManagedEntityDefinition{
		Name:    "XdslLineConfigurationProfilePart2",
		ClassID: XdslLineConfigurationProfilePart2ClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
		),
		AllowedAttributeMask: 0xfffe,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  Uint16Field(XdslLineConfigurationProfilePart2_DownstreamMinimumTimeIntervalForUpshiftRateAdaptation, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 1),
			2:  Uint16Field(XdslLineConfigurationProfilePart2_UpstreamMinimumTimeIntervalForUpshiftRateAdaptation, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 2),
			3:  Uint16Field(XdslLineConfigurationProfilePart2_DownstreamDownshiftNoiseMargin, UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 3),
			4:  Uint16Field(XdslLineConfigurationProfilePart2_UpstreamDownshiftNoiseMargin, UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 4),
			5:  Uint16Field(XdslLineConfigurationProfilePart2_DownstreamMinimumTimeIntervalForDownshiftRateAdaptation, UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 5),
			6:  Uint16Field(XdslLineConfigurationProfilePart2_UpstreamMinimumTimeIntervalForDownshiftRateAdaptation, UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 6),
			7:  ByteField(XdslLineConfigurationProfilePart2_XtuImpedanceStateForced, UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 7),
			8:  ByteField(XdslLineConfigurationProfilePart2_L0Time, UnsignedIntegerAttributeType, 0x0100, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 8),
			9:  ByteField(XdslLineConfigurationProfilePart2_L2Time, UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 9),
			10: Uint16Field(XdslLineConfigurationProfilePart2_DownstreamMaximumNominalPowerSpectralDensity, UnsignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 10),
			11: Uint16Field(XdslLineConfigurationProfilePart2_UpstreamMaximumNominalPowerSpectralDensity, UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 11),
			12: ByteField(XdslLineConfigurationProfilePart2_DownstreamMaximumNominalAggregateTransmitPower, UnsignedIntegerAttributeType, 0x0010, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 12),
			13: ByteField(XdslLineConfigurationProfilePart2_UpstreamMaximumNominalAggregateTransmitPower, UnsignedIntegerAttributeType, 0x0008, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 13),
			14: Uint16Field(XdslLineConfigurationProfilePart2_UpstreamMaximumAggregateReceivePower, UnsignedIntegerAttributeType, 0x0004, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 14),
			15: ByteField(XdslLineConfigurationProfilePart2_Vdsl2TransmissionSystemEnabling, UnsignedIntegerAttributeType, 0x0002, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 15),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
	}
}

// NewXdslLineConfigurationProfilePart2 (class ID 105) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewXdslLineConfigurationProfilePart2(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*xdsllineconfigurationprofilepart2BME, params...)
}
