/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

// Package generated provides code-generated OMCI types
package generated

// This file is used to track the version(s) of code used to parse the ITU
// document and create the generated code.

// VersionInfo provides information on the parser/generator version used to create
// the generated data as well as the time of code generation
type VersionInfo struct {
	Name       string  // Type (pre-parser, parser, code-generator)
	Version    string  // Version of parser project
	CreateTime float32 // UTC linux time when ran
	ItuDocName string  // ITU G.988 document name
	SHA256     string  // ITU G.988 document SHA-256 hash
}

// Version provides version information of this generated cooe
var Versions []VersionInfo

func init() {
	Versions = make([]VersionInfo, 0)

	Versions = append(Versions,
		VersionInfo{
			Name:       "parser",
			Version:    "0.15.13",
			CreateTime: 1632853136.8901486,
			ItuDocName: "T-REC-G.988-202003-I!Amd3!MSW-E.docx",
			SHA256:     "084f5265bc090ca882fe45f6844d1ce368c218e52c77795060b7643240885469",
		})

	Versions = append(Versions,
		VersionInfo{
			Name:       "pre-parser",
			Version:    "0.15.12",
			CreateTime: 1628800053.665055,
			ItuDocName: "T-REC-G.988-202003-I!Amd3!MSW-E.docx",
			SHA256:     "084f5265bc090ca882fe45f6844d1ce368c218e52c77795060b7643240885469",
		})

	Versions = append(Versions,
		VersionInfo{
			Name:       "code-generator",
			Version:    "0.15.13",
			CreateTime: 1632853241.9567904,
			ItuDocName: "T-REC-G.988-202003-I!Amd3!MSW-E.docx",
			SHA256:     "084f5265bc090ca882fe45f6844d1ce368c218e52c77795060b7643240885469",
		})
}
