/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// TwdmChannelTuningPerformanceMonitoringHistoryDataPart3ClassID is the 16-bit ID for the OMCI
// Managed entity TWDM channel tuning performance monitoring history data part 3
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3ClassID = ClassID(451) // 0x01c3

var twdmchanneltuningperformancemonitoringhistorydatapart3BME *ManagedEntityDefinition

// TwdmChannelTuningPerformanceMonitoringHistoryDataPart3 (Class ID: #451 / 0x01c3)
//	This ME collects remaining tuning-control-related PM data associated with the slot/circuit pack,
//	hosting one or more ANI-G MEs, for a specific TWDM channel. Instances of this ME are created and
//	deleted by the OLT.
//
//	The relevant events this ME is concerned with are counted towards the PM statistics associated
//	with the source TWDM channel. This ME contains the counters characterized as optional in clause
//	14 of [ITU-T-G.989.3].
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an instance of TWDM channel ME.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the TWDM channel ME. (R, setbycreate) (mandatory) (2-bytes)
//
//		Interval End Time
//			This attribute identifies the most recently finished 15-min interval. (R) (mandatory) (1-byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 and 2 MEs
//			that contains PM threshold values. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Tuning Control Requests Rollback_Ds_Albl
//			Tuning control requests Rollback/DS_ALBL: The counter of controlled tuning attempts that failed
//			due to downstream administrative label inconsistency, as indicated by the Tuning_Response PLOAM
//			message with Rollback operation code and DS_ALBL response code. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rollback_Ds_Lktp
//			Tuning control requests Rollback/DS_LKTP: The counter of controlled tuning attempts that failed
//			due to downstream optical link type inconsistency, as indicated by the Tuning_Response PLOAM
//			message with Rollback operation code and DS_LKTP response code. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rollback_Us_Albl
//			Tuning control requests Rollback/US_ALBL: The counter of controlled tuning attempts that failed
//			due to upstream administrative label violation, as indicated by the Tuning_Response PLOAM
//			message with Rollback operation code and US_ALBL response code. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rollback_Us_Void
//			Tuning control requests Rollback/US_VOID: The counter of controlled tuning attempts that failed
//			due to the target upstream wavelength channel descriptor being void, as indicated by the
//			Tuning_Response PLOAM message with Rollback operation code and US_VOID response code. (R)
//			(mandatory) (4-byte)
//
//		Tuning Control Requests Rollback_Us_Tunr
//			Tuning control requests Rollback/US_TUNR: The counter of controlled tuning attempts that failed
//			due to the transmitter tuning range violation, as indicated by the Tuning_Response PLOAM message
//			with Rollback operation code and US_TUNR response code. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rollback_Us_Lktp
//			Tuning control requests Rollback/US_LKTP: The counter of controlled tuning attempts that failed
//			due to the upstream optical link type violation, as indicated by the Tuning_Response PLOAM
//			message with Rollback operation code and US_LKTP response code. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rollback_Us_Lnrt
//			Tuning control requests Rollback/US_LNRT: The counter of controlled tuning attempts that failed
//			due to the upstream line rate violation, as indicated by the Tuning_Response PLOAM message with
//			Rollback operation code and US_LNRT response code. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rollback_Us_Lncd
//			Tuning control requests Rollback/US_LNCD: The counter of controlled tuning attempts that failed
//			due to the upstream line code violation, as indicated by the Tuning_Response PLOAM message with
//			Rollback operation code and US_LNCD response code. (R) (mandatory) (4-byte)
//
type TwdmChannelTuningPerformanceMonitoringHistoryDataPart3 struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_IntervalEndTime = "IntervalEndTime"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_ThresholdData12Id = "ThresholdData12Id"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackDsAlbl = "TuningControlRequestsRollbackDsAlbl"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackDsLktp = "TuningControlRequestsRollbackDsLktp"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsAlbl = "TuningControlRequestsRollbackUsAlbl"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsVoid = "TuningControlRequestsRollbackUsVoid"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsTunr = "TuningControlRequestsRollbackUsTunr"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsLktp = "TuningControlRequestsRollbackUsLktp"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsLnrt = "TuningControlRequestsRollbackUsLnrt"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsLncd = "TuningControlRequestsRollbackUsLncd"

func init() {
	twdmchanneltuningperformancemonitoringhistorydatapart3BME = &ManagedEntityDefinition{
		Name:    "TwdmChannelTuningPerformanceMonitoringHistoryDataPart3",
		ClassID: TwdmChannelTuningPerformanceMonitoringHistoryDataPart3ClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
			GetCurrentData,
		),
		AllowedAttributeMask: 0xffc0,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_IntervalEndTime, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_ThresholdData12Id, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackDsAlbl, CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, false, false, 3),
			4:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackDsLktp, CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsAlbl, CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, false, 5),
			6:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsVoid, CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsTunr, CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, false, false, 7),
			8:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsLktp, CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, false, false, 8),
			9:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsLnrt, CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart3_TuningControlRequestsRollbackUsLncd, CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0: "Tuning control requests Rollback/DS_ALBL",
			1: "Tuning control requests Rollback /DS_LKTP",
			2: "Tuning control requests Rollback/US_ALBL",
			3: "Tuning control requests Rollback /US_VOID",
			4: "Tuning control requests Rollback/US_TUNR",
			5: "Tuning control requests Rollback /US_LKTP",
			6: "Tuning control requests Rollback/US_LNRT",
			7: "Tuning control requests Rollback /US_LNCD",
		},
	}
}

// NewTwdmChannelTuningPerformanceMonitoringHistoryDataPart3 (class ID 451) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewTwdmChannelTuningPerformanceMonitoringHistoryDataPart3(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*twdmchanneltuningperformancemonitoringhistorydatapart3BME, params...)
}
