// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/common.proto

package common

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type TestModeKeys int32

const (
	TestModeKeys_api_test TestModeKeys = 0
)

var TestModeKeys_name = map[int32]string{
	0: "api_test",
}

var TestModeKeys_value = map[string]int32{
	"api_test": 0,
}

func (x TestModeKeys) String() string {
	return proto.EnumName(TestModeKeys_name, int32(x))
}

func (TestModeKeys) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{0}
}

// Administrative State
type AdminState_Types int32

const (
	// The administrative state of the device is unknown
	AdminState_UNKNOWN AdminState_Types = 0
	// The device is pre-provisioned into Voltha, but not contacted by it
	AdminState_PREPROVISIONED AdminState_Types = 1
	// The device is enabled for activation and operation
	AdminState_ENABLED AdminState_Types = 2
	// The device is disabled and shall not perform its intended forwarding
	// functions other than being available for re-activation.
	AdminState_DISABLED AdminState_Types = 3
	// The device is in the state of image download
	AdminState_DOWNLOADING_IMAGE AdminState_Types = 4
)

var AdminState_Types_name = map[int32]string{
	0: "UNKNOWN",
	1: "PREPROVISIONED",
	2: "ENABLED",
	3: "DISABLED",
	4: "DOWNLOADING_IMAGE",
}

var AdminState_Types_value = map[string]int32{
	"UNKNOWN":           0,
	"PREPROVISIONED":    1,
	"ENABLED":           2,
	"DISABLED":          3,
	"DOWNLOADING_IMAGE": 4,
}

func (x AdminState_Types) String() string {
	return proto.EnumName(AdminState_Types_name, int32(x))
}

func (AdminState_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{4, 0}
}

// Operational Status
type OperStatus_Types int32

const (
	// The status of the device is unknown at this point
	OperStatus_UNKNOWN OperStatus_Types = 0
	// The device has been discovered, but not yet activated
	OperStatus_DISCOVERED OperStatus_Types = 1
	// The device is being activated (booted, rebooted, upgraded, etc.)
	OperStatus_ACTIVATING OperStatus_Types = 2
	// Service impacting tests are being conducted
	OperStatus_TESTING OperStatus_Types = 3
	// The device is up and active
	OperStatus_ACTIVE OperStatus_Types = 4
	// The device has failed and cannot fulfill its intended role
	OperStatus_FAILED OperStatus_Types = 5
	// The device is reconciling
	OperStatus_RECONCILING OperStatus_Types = 6
	// The device is in reconciling failed
	OperStatus_RECONCILING_FAILED OperStatus_Types = 7
	// The device has rebooted
	OperStatus_REBOOTED OperStatus_Types = 8
)

var OperStatus_Types_name = map[int32]string{
	0: "UNKNOWN",
	1: "DISCOVERED",
	2: "ACTIVATING",
	3: "TESTING",
	4: "ACTIVE",
	5: "FAILED",
	6: "RECONCILING",
	7: "RECONCILING_FAILED",
	8: "REBOOTED",
}

var OperStatus_Types_value = map[string]int32{
	"UNKNOWN":            0,
	"DISCOVERED":         1,
	"ACTIVATING":         2,
	"TESTING":            3,
	"ACTIVE":             4,
	"FAILED":             5,
	"RECONCILING":        6,
	"RECONCILING_FAILED": 7,
	"REBOOTED":           8,
}

func (x OperStatus_Types) String() string {
	return proto.EnumName(OperStatus_Types_name, int32(x))
}

func (OperStatus_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{5, 0}
}

// Connectivity Status
type ConnectStatus_Types int32

const (
	// The device connectivity status is unknown
	ConnectStatus_UNKNOWN ConnectStatus_Types = 0
	// The device cannot be reached by Voltha
	ConnectStatus_UNREACHABLE ConnectStatus_Types = 1
	// There is live communication between device and Voltha
	ConnectStatus_REACHABLE ConnectStatus_Types = 2
)

var ConnectStatus_Types_name = map[int32]string{
	0: "UNKNOWN",
	1: "UNREACHABLE",
	2: "REACHABLE",
}

var ConnectStatus_Types_value = map[string]int32{
	"UNKNOWN":     0,
	"UNREACHABLE": 1,
	"REACHABLE":   2,
}

func (x ConnectStatus_Types) String() string {
	return proto.EnumName(ConnectStatus_Types_name, int32(x))
}

func (ConnectStatus_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{6, 0}
}

type OperationResp_OperationReturnCode int32

const (
	OperationResp_OPERATION_SUCCESS     OperationResp_OperationReturnCode = 0
	OperationResp_OPERATION_FAILURE     OperationResp_OperationReturnCode = 1
	OperationResp_OPERATION_UNSUPPORTED OperationResp_OperationReturnCode = 2
	OperationResp_OPERATION_IN_PROGRESS OperationResp_OperationReturnCode = 3
)

var OperationResp_OperationReturnCode_name = map[int32]string{
	0: "OPERATION_SUCCESS",
	1: "OPERATION_FAILURE",
	2: "OPERATION_UNSUPPORTED",
	3: "OPERATION_IN_PROGRESS",
}

var OperationResp_OperationReturnCode_value = map[string]int32{
	"OPERATION_SUCCESS":     0,
	"OPERATION_FAILURE":     1,
	"OPERATION_UNSUPPORTED": 2,
	"OPERATION_IN_PROGRESS": 3,
}

func (x OperationResp_OperationReturnCode) String() string {
	return proto.EnumName(OperationResp_OperationReturnCode_name, int32(x))
}

func (OperationResp_OperationReturnCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{7, 0}
}

// Full path for KV store
type Key struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Key) Reset()         { *m = Key{} }
func (m *Key) String() string { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()    {}
func (*Key) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{0}
}

func (m *Key) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Key.Unmarshal(m, b)
}
func (m *Key) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Key.Marshal(b, m, deterministic)
}
func (m *Key) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Key.Merge(m, src)
}
func (m *Key) XXX_Size() int {
	return xxx_messageInfo_Key.Size(m)
}
func (m *Key) XXX_DiscardUnknown() {
	xxx_messageInfo_Key.DiscardUnknown(m)
}

var xxx_messageInfo_Key proto.InternalMessageInfo

func (m *Key) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

// Convey a resource identifier
type ID struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ID) Reset()         { *m = ID{} }
func (m *ID) String() string { return proto.CompactTextString(m) }
func (*ID) ProtoMessage()    {}
func (*ID) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{1}
}

func (m *ID) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ID.Unmarshal(m, b)
}
func (m *ID) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ID.Marshal(b, m, deterministic)
}
func (m *ID) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ID.Merge(m, src)
}
func (m *ID) XXX_Size() int {
	return xxx_messageInfo_ID.Size(m)
}
func (m *ID) XXX_DiscardUnknown() {
	xxx_messageInfo_ID.DiscardUnknown(m)
}

var xxx_messageInfo_ID proto.InternalMessageInfo

func (m *ID) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Represents a list of IDs
type IDs struct {
	Items                []*ID    `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IDs) Reset()         { *m = IDs{} }
func (m *IDs) String() string { return proto.CompactTextString(m) }
func (*IDs) ProtoMessage()    {}
func (*IDs) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{2}
}

func (m *IDs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IDs.Unmarshal(m, b)
}
func (m *IDs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IDs.Marshal(b, m, deterministic)
}
func (m *IDs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IDs.Merge(m, src)
}
func (m *IDs) XXX_Size() int {
	return xxx_messageInfo_IDs.Size(m)
}
func (m *IDs) XXX_DiscardUnknown() {
	xxx_messageInfo_IDs.DiscardUnknown(m)
}

var xxx_messageInfo_IDs proto.InternalMessageInfo

func (m *IDs) GetItems() []*ID {
	if m != nil {
		return m.Items
	}
	return nil
}

type Connection struct {
	// endpoint is the endpoint sending the request
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// contextInfo represents additional contextual information
	ContextInfo string `protobuf:"bytes,2,opt,name=contextInfo,proto3" json:"contextInfo,omitempty"`
	// keep_alive_interval is used to indicate to the remote endpoint how often it
	// will get a keep alive notification
	KeepAliveInterval    int64    `protobuf:"varint,3,opt,name=keep_alive_interval,json=keepAliveInterval,proto3" json:"keep_alive_interval,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Connection) Reset()         { *m = Connection{} }
func (m *Connection) String() string { return proto.CompactTextString(m) }
func (*Connection) ProtoMessage()    {}
func (*Connection) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{3}
}

func (m *Connection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Connection.Unmarshal(m, b)
}
func (m *Connection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Connection.Marshal(b, m, deterministic)
}
func (m *Connection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection.Merge(m, src)
}
func (m *Connection) XXX_Size() int {
	return xxx_messageInfo_Connection.Size(m)
}
func (m *Connection) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection.DiscardUnknown(m)
}

var xxx_messageInfo_Connection proto.InternalMessageInfo

func (m *Connection) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Connection) GetContextInfo() string {
	if m != nil {
		return m.ContextInfo
	}
	return ""
}

func (m *Connection) GetKeepAliveInterval() int64 {
	if m != nil {
		return m.KeepAliveInterval
	}
	return 0
}

type AdminState struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminState) Reset()         { *m = AdminState{} }
func (m *AdminState) String() string { return proto.CompactTextString(m) }
func (*AdminState) ProtoMessage()    {}
func (*AdminState) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{4}
}

func (m *AdminState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdminState.Unmarshal(m, b)
}
func (m *AdminState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdminState.Marshal(b, m, deterministic)
}
func (m *AdminState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminState.Merge(m, src)
}
func (m *AdminState) XXX_Size() int {
	return xxx_messageInfo_AdminState.Size(m)
}
func (m *AdminState) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminState.DiscardUnknown(m)
}

var xxx_messageInfo_AdminState proto.InternalMessageInfo

type OperStatus struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperStatus) Reset()         { *m = OperStatus{} }
func (m *OperStatus) String() string { return proto.CompactTextString(m) }
func (*OperStatus) ProtoMessage()    {}
func (*OperStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{5}
}

func (m *OperStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperStatus.Unmarshal(m, b)
}
func (m *OperStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperStatus.Marshal(b, m, deterministic)
}
func (m *OperStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperStatus.Merge(m, src)
}
func (m *OperStatus) XXX_Size() int {
	return xxx_messageInfo_OperStatus.Size(m)
}
func (m *OperStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_OperStatus.DiscardUnknown(m)
}

var xxx_messageInfo_OperStatus proto.InternalMessageInfo

type ConnectStatus struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectStatus) Reset()         { *m = ConnectStatus{} }
func (m *ConnectStatus) String() string { return proto.CompactTextString(m) }
func (*ConnectStatus) ProtoMessage()    {}
func (*ConnectStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{6}
}

func (m *ConnectStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnectStatus.Unmarshal(m, b)
}
func (m *ConnectStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnectStatus.Marshal(b, m, deterministic)
}
func (m *ConnectStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectStatus.Merge(m, src)
}
func (m *ConnectStatus) XXX_Size() int {
	return xxx_messageInfo_ConnectStatus.Size(m)
}
func (m *ConnectStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectStatus proto.InternalMessageInfo

type OperationResp struct {
	// Return code
	Code OperationResp_OperationReturnCode `protobuf:"varint,1,opt,name=code,proto3,enum=common.OperationResp_OperationReturnCode" json:"code,omitempty"`
	// Additional Info
	AdditionalInfo       string   `protobuf:"bytes,2,opt,name=additional_info,json=additionalInfo,proto3" json:"additional_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationResp) Reset()         { *m = OperationResp{} }
func (m *OperationResp) String() string { return proto.CompactTextString(m) }
func (*OperationResp) ProtoMessage()    {}
func (*OperationResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{7}
}

func (m *OperationResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationResp.Unmarshal(m, b)
}
func (m *OperationResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationResp.Marshal(b, m, deterministic)
}
func (m *OperationResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationResp.Merge(m, src)
}
func (m *OperationResp) XXX_Size() int {
	return xxx_messageInfo_OperationResp.Size(m)
}
func (m *OperationResp) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationResp.DiscardUnknown(m)
}

var xxx_messageInfo_OperationResp proto.InternalMessageInfo

func (m *OperationResp) GetCode() OperationResp_OperationReturnCode {
	if m != nil {
		return m.Code
	}
	return OperationResp_OPERATION_SUCCESS
}

func (m *OperationResp) GetAdditionalInfo() string {
	if m != nil {
		return m.AdditionalInfo
	}
	return ""
}

type PortStatistics struct {
	IntfId                  uint32   `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	RxBytes                 uint64   `protobuf:"fixed64,2,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	RxPackets               uint64   `protobuf:"fixed64,3,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	RxUcastPackets          uint64   `protobuf:"fixed64,4,opt,name=rx_ucast_packets,json=rxUcastPackets,proto3" json:"rx_ucast_packets,omitempty"`
	RxMcastPackets          uint64   `protobuf:"fixed64,5,opt,name=rx_mcast_packets,json=rxMcastPackets,proto3" json:"rx_mcast_packets,omitempty"`
	RxBcastPackets          uint64   `protobuf:"fixed64,6,opt,name=rx_bcast_packets,json=rxBcastPackets,proto3" json:"rx_bcast_packets,omitempty"`
	RxErrorPackets          uint64   `protobuf:"fixed64,7,opt,name=rx_error_packets,json=rxErrorPackets,proto3" json:"rx_error_packets,omitempty"`
	RxFrames                uint64   `protobuf:"fixed64,17,opt,name=rx_frames,json=rxFrames,proto3" json:"rx_frames,omitempty"`
	RxFrames_64             uint64   `protobuf:"fixed64,18,opt,name=rx_frames_64,json=rxFrames64,proto3" json:"rx_frames_64,omitempty"`
	RxFrames_65_127         uint64   `protobuf:"fixed64,19,opt,name=rx_frames_65_127,json=rxFrames65127,proto3" json:"rx_frames_65_127,omitempty"`
	RxFrames_128_255        uint64   `protobuf:"fixed64,20,opt,name=rx_frames_128_255,json=rxFrames128255,proto3" json:"rx_frames_128_255,omitempty"`
	RxFrames_256_511        uint64   `protobuf:"fixed64,21,opt,name=rx_frames_256_511,json=rxFrames256511,proto3" json:"rx_frames_256_511,omitempty"`
	RxFrames_512_1023       uint64   `protobuf:"fixed64,22,opt,name=rx_frames_512_1023,json=rxFrames5121023,proto3" json:"rx_frames_512_1023,omitempty"`
	RxFrames_1024_1518      uint64   `protobuf:"fixed64,23,opt,name=rx_frames_1024_1518,json=rxFrames10241518,proto3" json:"rx_frames_1024_1518,omitempty"`
	RxFrames_1519_2047      uint64   `protobuf:"fixed64,24,opt,name=rx_frames_1519_2047,json=rxFrames15192047,proto3" json:"rx_frames_1519_2047,omitempty"`
	RxFrames_2048_4095      uint64   `protobuf:"fixed64,25,opt,name=rx_frames_2048_4095,json=rxFrames20484095,proto3" json:"rx_frames_2048_4095,omitempty"`
	RxFrames_4096_9216      uint64   `protobuf:"fixed64,26,opt,name=rx_frames_4096_9216,json=rxFrames40969216,proto3" json:"rx_frames_4096_9216,omitempty"`
	RxFrames_9217_16383     uint64   `protobuf:"fixed64,27,opt,name=rx_frames_9217_16383,json=rxFrames921716383,proto3" json:"rx_frames_9217_16383,omitempty"`
	RxCrcErrors             uint64   `protobuf:"fixed64,14,opt,name=rx_crc_errors,json=rxCrcErrors,proto3" json:"rx_crc_errors,omitempty"`
	RxUndersizePackets      uint64   `protobuf:"fixed64,39,opt,name=rxUndersizePackets,proto3" json:"rxUndersizePackets,omitempty"`
	RxOversizePackets       uint64   `protobuf:"fixed64,40,opt,name=rxOversizePackets,proto3" json:"rxOversizePackets,omitempty"`
	RxGem                   uint64   `protobuf:"fixed64,43,opt,name=rxGem,proto3" json:"rxGem,omitempty"`
	RxGemDropped            uint64   `protobuf:"fixed64,44,opt,name=rxGemDropped,proto3" json:"rxGemDropped,omitempty"`
	RxGemIdle               uint64   `protobuf:"fixed64,45,opt,name=rxGemIdle,proto3" json:"rxGemIdle,omitempty"`
	RxGemCorrected          uint64   `protobuf:"fixed64,46,opt,name=rxGemCorrected,proto3" json:"rxGemCorrected,omitempty"`
	RxGemIllegal            uint64   `protobuf:"fixed64,47,opt,name=rxGemIllegal,proto3" json:"rxGemIllegal,omitempty"`
	RxFragmentError         uint64   `protobuf:"fixed64,48,opt,name=rxFragmentError,proto3" json:"rxFragmentError,omitempty"`
	RxPacketsDropped        uint64   `protobuf:"fixed64,49,opt,name=rxPacketsDropped,proto3" json:"rxPacketsDropped,omitempty"`
	RxCpuOmciPacketsDropped uint64   `protobuf:"fixed64,50,opt,name=rxCpuOmciPacketsDropped,proto3" json:"rxCpuOmciPacketsDropped,omitempty"`
	RxCpu                   uint64   `protobuf:"fixed64,51,opt,name=rxCpu,proto3" json:"rxCpu,omitempty"`
	RxOmci                  uint64   `protobuf:"fixed64,52,opt,name=rxOmci,proto3" json:"rxOmci,omitempty"`
	RxOmciPacketsCrcError   uint64   `protobuf:"fixed64,53,opt,name=rxOmciPacketsCrcError,proto3" json:"rxOmciPacketsCrcError,omitempty"`
	RxFcsErrorPackets       uint64   `protobuf:"fixed64,62,opt,name=rxFcsErrorPackets,proto3" json:"rxFcsErrorPackets,omitempty"`
	TxBytes                 uint64   `protobuf:"fixed64,8,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxPackets               uint64   `protobuf:"fixed64,9,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	TxUcastPackets          uint64   `protobuf:"fixed64,10,opt,name=tx_ucast_packets,json=txUcastPackets,proto3" json:"tx_ucast_packets,omitempty"`
	TxMcastPackets          uint64   `protobuf:"fixed64,11,opt,name=tx_mcast_packets,json=txMcastPackets,proto3" json:"tx_mcast_packets,omitempty"`
	TxBcastPackets          uint64   `protobuf:"fixed64,12,opt,name=tx_bcast_packets,json=txBcastPackets,proto3" json:"tx_bcast_packets,omitempty"`
	TxErrorPackets          uint64   `protobuf:"fixed64,13,opt,name=tx_error_packets,json=txErrorPackets,proto3" json:"tx_error_packets,omitempty"`
	TxFrames                uint64   `protobuf:"fixed64,28,opt,name=tx_frames,json=txFrames,proto3" json:"tx_frames,omitempty"`
	TxFrames_64             uint64   `protobuf:"fixed64,29,opt,name=tx_frames_64,json=txFrames64,proto3" json:"tx_frames_64,omitempty"`
	TxFrames_65_127         uint64   `protobuf:"fixed64,30,opt,name=tx_frames_65_127,json=txFrames65127,proto3" json:"tx_frames_65_127,omitempty"`
	TxFrames_128_255        uint64   `protobuf:"fixed64,31,opt,name=tx_frames_128_255,json=txFrames128255,proto3" json:"tx_frames_128_255,omitempty"`
	TxFrames_256_511        uint64   `protobuf:"fixed64,32,opt,name=tx_frames_256_511,json=txFrames256511,proto3" json:"tx_frames_256_511,omitempty"`
	TxFrames_512_1023       uint64   `protobuf:"fixed64,33,opt,name=tx_frames_512_1023,json=txFrames5121023,proto3" json:"tx_frames_512_1023,omitempty"`
	TxFrames_1024_1518      uint64   `protobuf:"fixed64,34,opt,name=tx_frames_1024_1518,json=txFrames10241518,proto3" json:"tx_frames_1024_1518,omitempty"`
	TxFrames_1519_2047      uint64   `protobuf:"fixed64,35,opt,name=tx_frames_1519_2047,json=txFrames15192047,proto3" json:"tx_frames_1519_2047,omitempty"`
	TxFrames_2048_4095      uint64   `protobuf:"fixed64,36,opt,name=tx_frames_2048_4095,json=txFrames20484095,proto3" json:"tx_frames_2048_4095,omitempty"`
	TxFrames_4096_9216      uint64   `protobuf:"fixed64,37,opt,name=tx_frames_4096_9216,json=txFrames40969216,proto3" json:"tx_frames_4096_9216,omitempty"`
	TxFrames_9217_16383     uint64   `protobuf:"fixed64,38,opt,name=tx_frames_9217_16383,json=txFrames921716383,proto3" json:"tx_frames_9217_16383,omitempty"`
	TxUndersizePackets      uint64   `protobuf:"fixed64,41,opt,name=txUndersizePackets,proto3" json:"txUndersizePackets,omitempty"`
	TxOversizePackets       uint64   `protobuf:"fixed64,42,opt,name=txOversizePackets,proto3" json:"txOversizePackets,omitempty"`
	TxGem                   uint64   `protobuf:"fixed64,54,opt,name=txGem,proto3" json:"txGem,omitempty"`
	TxCpu                   uint64   `protobuf:"fixed64,55,opt,name=txCpu,proto3" json:"txCpu,omitempty"`
	TxOmci                  uint64   `protobuf:"fixed64,56,opt,name=txOmci,proto3" json:"txOmci,omitempty"`
	TxDroppedIllegalLength  uint64   `protobuf:"fixed64,57,opt,name=txDroppedIllegalLength,proto3" json:"txDroppedIllegalLength,omitempty"`
	TxDroppedTpidMiss       uint64   `protobuf:"fixed64,58,opt,name=txDroppedTpidMiss,proto3" json:"txDroppedTpidMiss,omitempty"`
	TxDroppedVidMiss        uint64   `protobuf:"fixed64,59,opt,name=txDroppedVidMiss,proto3" json:"txDroppedVidMiss,omitempty"`
	TxDroppedTotal          uint64   `protobuf:"fixed64,60,opt,name=txDroppedTotal,proto3" json:"txDroppedTotal,omitempty"`
	BipErrors               uint64   `protobuf:"fixed64,15,opt,name=bip_errors,json=bipErrors,proto3" json:"bip_errors,omitempty"`
	BipUnits                uint64   `protobuf:"fixed64,61,opt,name=bip_units,json=bipUnits,proto3" json:"bip_units,omitempty"`
	Timestamp               uint32   `protobuf:"fixed32,16,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *PortStatistics) Reset()         { *m = PortStatistics{} }
func (m *PortStatistics) String() string { return proto.CompactTextString(m) }
func (*PortStatistics) ProtoMessage()    {}
func (*PortStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_c2e3fd231961e826, []int{8}
}

func (m *PortStatistics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PortStatistics.Unmarshal(m, b)
}
func (m *PortStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PortStatistics.Marshal(b, m, deterministic)
}
func (m *PortStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortStatistics.Merge(m, src)
}
func (m *PortStatistics) XXX_Size() int {
	return xxx_messageInfo_PortStatistics.Size(m)
}
func (m *PortStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_PortStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_PortStatistics proto.InternalMessageInfo

func (m *PortStatistics) GetIntfId() uint32 {
	if m != nil {
		return m.IntfId
	}
	return 0
}

func (m *PortStatistics) GetRxBytes() uint64 {
	if m != nil {
		return m.RxBytes
	}
	return 0
}

func (m *PortStatistics) GetRxPackets() uint64 {
	if m != nil {
		return m.RxPackets
	}
	return 0
}

func (m *PortStatistics) GetRxUcastPackets() uint64 {
	if m != nil {
		return m.RxUcastPackets
	}
	return 0
}

func (m *PortStatistics) GetRxMcastPackets() uint64 {
	if m != nil {
		return m.RxMcastPackets
	}
	return 0
}

func (m *PortStatistics) GetRxBcastPackets() uint64 {
	if m != nil {
		return m.RxBcastPackets
	}
	return 0
}

func (m *PortStatistics) GetRxErrorPackets() uint64 {
	if m != nil {
		return m.RxErrorPackets
	}
	return 0
}

func (m *PortStatistics) GetRxFrames() uint64 {
	if m != nil {
		return m.RxFrames
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_64() uint64 {
	if m != nil {
		return m.RxFrames_64
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_65_127() uint64 {
	if m != nil {
		return m.RxFrames_65_127
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_128_255() uint64 {
	if m != nil {
		return m.RxFrames_128_255
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_256_511() uint64 {
	if m != nil {
		return m.RxFrames_256_511
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_512_1023() uint64 {
	if m != nil {
		return m.RxFrames_512_1023
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_1024_1518() uint64 {
	if m != nil {
		return m.RxFrames_1024_1518
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_1519_2047() uint64 {
	if m != nil {
		return m.RxFrames_1519_2047
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_2048_4095() uint64 {
	if m != nil {
		return m.RxFrames_2048_4095
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_4096_9216() uint64 {
	if m != nil {
		return m.RxFrames_4096_9216
	}
	return 0
}

func (m *PortStatistics) GetRxFrames_9217_16383() uint64 {
	if m != nil {
		return m.RxFrames_9217_16383
	}
	return 0
}

func (m *PortStatistics) GetRxCrcErrors() uint64 {
	if m != nil {
		return m.RxCrcErrors
	}
	return 0
}

func (m *PortStatistics) GetRxUndersizePackets() uint64 {
	if m != nil {
		return m.RxUndersizePackets
	}
	return 0
}

func (m *PortStatistics) GetRxOversizePackets() uint64 {
	if m != nil {
		return m.RxOversizePackets
	}
	return 0
}

func (m *PortStatistics) GetRxGem() uint64 {
	if m != nil {
		return m.RxGem
	}
	return 0
}

func (m *PortStatistics) GetRxGemDropped() uint64 {
	if m != nil {
		return m.RxGemDropped
	}
	return 0
}

func (m *PortStatistics) GetRxGemIdle() uint64 {
	if m != nil {
		return m.RxGemIdle
	}
	return 0
}

func (m *PortStatistics) GetRxGemCorrected() uint64 {
	if m != nil {
		return m.RxGemCorrected
	}
	return 0
}

func (m *PortStatistics) GetRxGemIllegal() uint64 {
	if m != nil {
		return m.RxGemIllegal
	}
	return 0
}

func (m *PortStatistics) GetRxFragmentError() uint64 {
	if m != nil {
		return m.RxFragmentError
	}
	return 0
}

func (m *PortStatistics) GetRxPacketsDropped() uint64 {
	if m != nil {
		return m.RxPacketsDropped
	}
	return 0
}

func (m *PortStatistics) GetRxCpuOmciPacketsDropped() uint64 {
	if m != nil {
		return m.RxCpuOmciPacketsDropped
	}
	return 0
}

func (m *PortStatistics) GetRxCpu() uint64 {
	if m != nil {
		return m.RxCpu
	}
	return 0
}

func (m *PortStatistics) GetRxOmci() uint64 {
	if m != nil {
		return m.RxOmci
	}
	return 0
}

func (m *PortStatistics) GetRxOmciPacketsCrcError() uint64 {
	if m != nil {
		return m.RxOmciPacketsCrcError
	}
	return 0
}

func (m *PortStatistics) GetRxFcsErrorPackets() uint64 {
	if m != nil {
		return m.RxFcsErrorPackets
	}
	return 0
}

func (m *PortStatistics) GetTxBytes() uint64 {
	if m != nil {
		return m.TxBytes
	}
	return 0
}

func (m *PortStatistics) GetTxPackets() uint64 {
	if m != nil {
		return m.TxPackets
	}
	return 0
}

func (m *PortStatistics) GetTxUcastPackets() uint64 {
	if m != nil {
		return m.TxUcastPackets
	}
	return 0
}

func (m *PortStatistics) GetTxMcastPackets() uint64 {
	if m != nil {
		return m.TxMcastPackets
	}
	return 0
}

func (m *PortStatistics) GetTxBcastPackets() uint64 {
	if m != nil {
		return m.TxBcastPackets
	}
	return 0
}

func (m *PortStatistics) GetTxErrorPackets() uint64 {
	if m != nil {
		return m.TxErrorPackets
	}
	return 0
}

func (m *PortStatistics) GetTxFrames() uint64 {
	if m != nil {
		return m.TxFrames
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_64() uint64 {
	if m != nil {
		return m.TxFrames_64
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_65_127() uint64 {
	if m != nil {
		return m.TxFrames_65_127
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_128_255() uint64 {
	if m != nil {
		return m.TxFrames_128_255
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_256_511() uint64 {
	if m != nil {
		return m.TxFrames_256_511
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_512_1023() uint64 {
	if m != nil {
		return m.TxFrames_512_1023
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_1024_1518() uint64 {
	if m != nil {
		return m.TxFrames_1024_1518
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_1519_2047() uint64 {
	if m != nil {
		return m.TxFrames_1519_2047
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_2048_4095() uint64 {
	if m != nil {
		return m.TxFrames_2048_4095
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_4096_9216() uint64 {
	if m != nil {
		return m.TxFrames_4096_9216
	}
	return 0
}

func (m *PortStatistics) GetTxFrames_9217_16383() uint64 {
	if m != nil {
		return m.TxFrames_9217_16383
	}
	return 0
}

func (m *PortStatistics) GetTxUndersizePackets() uint64 {
	if m != nil {
		return m.TxUndersizePackets
	}
	return 0
}

func (m *PortStatistics) GetTxOversizePackets() uint64 {
	if m != nil {
		return m.TxOversizePackets
	}
	return 0
}

func (m *PortStatistics) GetTxGem() uint64 {
	if m != nil {
		return m.TxGem
	}
	return 0
}

func (m *PortStatistics) GetTxCpu() uint64 {
	if m != nil {
		return m.TxCpu
	}
	return 0
}

func (m *PortStatistics) GetTxOmci() uint64 {
	if m != nil {
		return m.TxOmci
	}
	return 0
}

func (m *PortStatistics) GetTxDroppedIllegalLength() uint64 {
	if m != nil {
		return m.TxDroppedIllegalLength
	}
	return 0
}

func (m *PortStatistics) GetTxDroppedTpidMiss() uint64 {
	if m != nil {
		return m.TxDroppedTpidMiss
	}
	return 0
}

func (m *PortStatistics) GetTxDroppedVidMiss() uint64 {
	if m != nil {
		return m.TxDroppedVidMiss
	}
	return 0
}

func (m *PortStatistics) GetTxDroppedTotal() uint64 {
	if m != nil {
		return m.TxDroppedTotal
	}
	return 0
}

func (m *PortStatistics) GetBipErrors() uint64 {
	if m != nil {
		return m.BipErrors
	}
	return 0
}

func (m *PortStatistics) GetBipUnits() uint64 {
	if m != nil {
		return m.BipUnits
	}
	return 0
}

func (m *PortStatistics) GetTimestamp() uint32 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func init() {
	proto.RegisterEnum("common.TestModeKeys", TestModeKeys_name, TestModeKeys_value)
	proto.RegisterEnum("common.AdminState_Types", AdminState_Types_name, AdminState_Types_value)
	proto.RegisterEnum("common.OperStatus_Types", OperStatus_Types_name, OperStatus_Types_value)
	proto.RegisterEnum("common.ConnectStatus_Types", ConnectStatus_Types_name, ConnectStatus_Types_value)
	proto.RegisterEnum("common.OperationResp_OperationReturnCode", OperationResp_OperationReturnCode_name, OperationResp_OperationReturnCode_value)
	proto.RegisterType((*Key)(nil), "common.Key")
	proto.RegisterType((*ID)(nil), "common.ID")
	proto.RegisterType((*IDs)(nil), "common.IDs")
	proto.RegisterType((*Connection)(nil), "common.Connection")
	proto.RegisterType((*AdminState)(nil), "common.AdminState")
	proto.RegisterType((*OperStatus)(nil), "common.OperStatus")
	proto.RegisterType((*ConnectStatus)(nil), "common.ConnectStatus")
	proto.RegisterType((*OperationResp)(nil), "common.OperationResp")
	proto.RegisterType((*PortStatistics)(nil), "common.PortStatistics")
}

func init() { proto.RegisterFile("voltha_protos/common.proto", fileDescriptor_c2e3fd231961e826) }

var fileDescriptor_c2e3fd231961e826 = []byte{
	// 1463 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x97, 0x5d, 0x53, 0xe2, 0xc8,
	0x1a, 0xc7, 0x07, 0x51, 0xd4, 0x47, 0x45, 0x6c, 0xdf, 0x7a, 0xde, 0xce, 0xf1, 0x70, 0x76, 0x47,
	0xe7, 0x0d, 0x49, 0x24, 0xa8, 0xbb, 0x3b, 0x5b, 0x85, 0x90, 0x71, 0x53, 0xa3, 0x84, 0x0a, 0xe0,
	0x54, 0xcd, 0x4d, 0x0a, 0x49, 0x8f, 0xa6, 0x06, 0x92, 0x54, 0xa7, 0xb1, 0x70, 0x3e, 0xc5, 0xde,
	0xef, 0xc5, 0x7e, 0xc7, 0xfd, 0x04, 0x5b, 0xdd, 0x9d, 0x00, 0x01, 0xe6, 0x8e, 0xe7, 0xff, 0xff,
	0x91, 0x74, 0xfa, 0x79, 0xfa, 0x0f, 0x81, 0x67, 0x0f, 0x7e, 0x8f, 0xdd, 0x77, 0xec, 0x80, 0xfa,
	0xcc, 0x0f, 0x8f, 0xbb, 0x7e, 0xbf, 0xef, 0x7b, 0x05, 0x51, 0xa1, 0x8c, 0xac, 0xf2, 0xfb, 0x90,
	0xfe, 0x44, 0x1e, 0x51, 0x0e, 0xd2, 0xdf, 0xc8, 0x23, 0x4e, 0x1d, 0xa4, 0x8e, 0x56, 0x2d, 0xfe,
	0x31, 0xbf, 0x03, 0x0b, 0x46, 0x0d, 0x65, 0x61, 0xc1, 0x75, 0x22, 0x79, 0xc1, 0x75, 0xf2, 0x87,
	0x90, 0x36, 0x6a, 0x21, 0x3a, 0x80, 0x25, 0x97, 0x91, 0x7e, 0x88, 0x53, 0x07, 0xe9, 0xa3, 0x35,
	0x15, 0x0a, 0xd1, 0xb5, 0x8d, 0x9a, 0x25, 0x8d, 0xfc, 0x77, 0x80, 0xaa, 0xef, 0x79, 0xa4, 0xcb,
	0x5c, 0xdf, 0x43, 0xcf, 0x60, 0x85, 0x78, 0x4e, 0xe0, 0xbb, 0x1e, 0x8b, 0x2e, 0x36, 0xaa, 0xd1,
	0x01, 0xac, 0x75, 0x7d, 0x8f, 0x91, 0x21, 0x33, 0xbc, 0xaf, 0x3e, 0x5e, 0x10, 0xf6, 0xa4, 0x84,
	0x0a, 0xb0, 0xfd, 0x8d, 0x90, 0xc0, 0xee, 0xf4, 0xdc, 0x07, 0x62, 0xbb, 0x1e, 0x23, 0xf4, 0xa1,
	0xd3, 0xc3, 0xe9, 0x83, 0xd4, 0x51, 0xda, 0xda, 0xe2, 0x56, 0x85, 0x3b, 0x46, 0x64, 0xe4, 0xef,
	0x01, 0x2a, 0x4e, 0xdf, 0xf5, 0x9a, 0xac, 0xc3, 0x48, 0xfe, 0x0b, 0x2c, 0xb5, 0x1e, 0x03, 0x12,
	0xa2, 0x35, 0x58, 0x6e, 0xd7, 0x3f, 0xd5, 0xcd, 0xcf, 0xf5, 0xdc, 0x13, 0x84, 0x20, 0xdb, 0xb0,
	0xf4, 0x86, 0x65, 0xde, 0x18, 0x4d, 0xc3, 0xac, 0xeb, 0xb5, 0x5c, 0x8a, 0x03, 0x7a, 0xbd, 0x72,
	0x71, 0xa5, 0xd7, 0x72, 0x0b, 0x68, 0x1d, 0x56, 0x6a, 0x46, 0x53, 0x56, 0x69, 0xb4, 0x0b, 0x5b,
	0x35, 0xf3, 0x73, 0xfd, 0xca, 0xac, 0xd4, 0x8c, 0xfa, 0xa5, 0x6d, 0x5c, 0x57, 0x2e, 0xf5, 0xdc,
	0x62, 0xfe, 0xef, 0x14, 0x80, 0x19, 0x10, 0xca, 0xef, 0x34, 0x08, 0xf3, 0x7f, 0xa6, 0xe6, 0xde,
	0x2b, 0x0b, 0x50, 0x33, 0x9a, 0x55, 0xf3, 0x46, 0xb7, 0xc4, 0x7d, 0xb2, 0x00, 0x95, 0x6a, 0xcb,
	0xb8, 0xa9, 0xb4, 0x8c, 0xfa, 0x65, 0x6e, 0x81, 0xc3, 0x2d, 0xbd, 0x29, 0x8a, 0x34, 0x02, 0xc8,
	0x08, 0x53, 0xcf, 0x2d, 0xf2, 0xcf, 0x1f, 0x2b, 0x06, 0x5f, 0xc1, 0x12, 0xda, 0x84, 0x35, 0x4b,
	0xaf, 0x9a, 0xf5, 0xaa, 0x71, 0xc5, 0xc1, 0x0c, 0xda, 0x03, 0x34, 0x21, 0xd8, 0x11, 0xb8, 0xcc,
	0x17, 0x6e, 0xe9, 0x17, 0xa6, 0xd9, 0xd2, 0x6b, 0xb9, 0x95, 0xbc, 0x0e, 0x1b, 0x51, 0x1f, 0xa2,
	0x35, 0x96, 0xe6, 0x2e, 0x71, 0x13, 0xd6, 0xda, 0x75, 0x4b, 0xaf, 0x54, 0xff, 0xe0, 0x4f, 0x9c,
	0x4b, 0xa1, 0x0d, 0x58, 0x1d, 0x97, 0x0b, 0xf9, 0x7f, 0x52, 0xb0, 0xc1, 0x1f, 0xb4, 0xc3, 0xdb,
	0x69, 0x91, 0x30, 0x40, 0x1f, 0x60, 0xb1, 0xeb, 0x3b, 0x44, 0xb4, 0x33, 0xab, 0xbe, 0x8e, 0x27,
	0x20, 0x01, 0x4d, 0x56, 0x6c, 0x40, 0xbd, 0xaa, 0xef, 0x10, 0x4b, 0x7c, 0x0d, 0x1d, 0xc2, 0x66,
	0xc7, 0x71, 0x5c, 0xee, 0x75, 0x7a, 0xb6, 0x3b, 0xee, 0x7c, 0x76, 0x2c, 0xf3, 0xe6, 0xe7, 0x1f,
	0x61, 0x7b, 0xce, 0x55, 0x78, 0x43, 0xcc, 0x86, 0x6e, 0x55, 0x5a, 0x86, 0x59, 0xb7, 0x9b, 0xed,
	0x6a, 0x55, 0x6f, 0x36, 0x73, 0x4f, 0x92, 0x32, 0xdf, 0x92, 0xb6, 0xc5, 0x9f, 0xe6, 0x29, 0xec,
	0x8e, 0xe5, 0x76, 0xbd, 0xd9, 0x6e, 0x34, 0x4c, 0xab, 0x25, 0xfa, 0x9c, 0xb0, 0x8c, 0xba, 0xdd,
	0xb0, 0xcc, 0x4b, 0x8b, 0x5f, 0x2c, 0x9d, 0xff, 0x6b, 0x1b, 0xb2, 0x0d, 0x9f, 0x8a, 0x9d, 0x73,
	0x43, 0xe6, 0x76, 0x43, 0xb4, 0x0f, 0xcb, 0xae, 0xc7, 0xbe, 0xda, 0xd1, 0xa1, 0x58, 0xb6, 0x32,
	0xbc, 0x34, 0x1c, 0xf4, 0x14, 0x56, 0xe8, 0xd0, 0xbe, 0x7d, 0x64, 0x24, 0x14, 0x0f, 0x92, 0xb1,
	0x96, 0xe9, 0xf0, 0x82, 0x97, 0xe8, 0x25, 0x00, 0x1d, 0xda, 0x41, 0xa7, 0xfb, 0x8d, 0xb0, 0x50,
	0x4c, 0x6d, 0xc6, 0x5a, 0xa5, 0xc3, 0x86, 0x14, 0xd0, 0x11, 0xe4, 0xe8, 0xd0, 0x1e, 0x74, 0x3b,
	0x21, 0x1b, 0x41, 0x8b, 0x02, 0xca, 0xd2, 0x61, 0x9b, 0xcb, 0x49, 0xb2, 0x9f, 0x20, 0x97, 0x62,
	0xf2, 0x7a, 0x96, 0xbc, 0x4d, 0x90, 0x99, 0x98, 0xbc, 0x98, 0x25, 0x09, 0xa5, 0x3e, 0x1d, 0x91,
	0xcb, 0x31, 0xa9, 0x73, 0x39, 0x26, 0x9f, 0xc3, 0x2a, 0x1d, 0xda, 0x5f, 0x69, 0xa7, 0x4f, 0x42,
	0xbc, 0x25, 0x90, 0x15, 0x3a, 0xfc, 0x28, 0x6a, 0x74, 0x00, 0xeb, 0x23, 0xd3, 0x2e, 0x97, 0x30,
	0x12, 0x3e, 0xc4, 0x7e, 0xb9, 0x84, 0x0e, 0xc5, 0x8d, 0x62, 0x42, 0xb3, 0x15, 0xf5, 0x14, 0x6f,
	0x0b, 0x6a, 0x63, 0x44, 0x69, 0x8a, 0x7a, 0x8a, 0x5e, 0xc3, 0xd6, 0x18, 0x54, 0xd4, 0x33, 0x5b,
	0xd5, 0x34, 0xbc, 0x13, 0x2f, 0x49, 0x92, 0x8a, 0x7a, 0xa6, 0x6a, 0x5a, 0x12, 0x55, 0xb5, 0xb2,
	0xad, 0x29, 0x0a, 0xde, 0x4d, 0xa2, 0xaa, 0x56, 0xd6, 0x14, 0x05, 0xbd, 0x05, 0x34, 0x46, 0x35,
	0x45, 0xb5, 0x95, 0xa2, 0x7a, 0x82, 0xf7, 0x04, 0xbb, 0x19, 0xb3, 0x9a, 0xa2, 0x72, 0x19, 0xbd,
	0x87, 0xed, 0x89, 0x25, 0x14, 0xd5, 0x92, 0xad, 0x68, 0xca, 0x19, 0xde, 0x17, 0x74, 0x6e, 0xb4,
	0x88, 0xa2, 0x5a, 0xe2, 0xfa, 0x14, 0xae, 0x29, 0xe7, 0xb6, 0x5a, 0x2c, 0x9d, 0x62, 0x3c, 0x85,
	0x6b, 0xca, 0x39, 0xd7, 0x93, 0xb8, 0x5a, 0x2c, 0x9d, 0xd9, 0xa5, 0xe2, 0xb9, 0x86, 0x9f, 0x26,
	0x71, 0x6e, 0x70, 0x3d, 0x89, 0x97, 0x8a, 0xe7, 0x65, 0xfb, 0x5c, 0x55, 0xca, 0xf8, 0x59, 0x12,
	0xe7, 0x06, 0xd7, 0xd1, 0x31, 0xec, 0x8c, 0xf1, 0x73, 0x55, 0x39, 0xb5, 0x95, 0xf2, 0xc9, 0xd9,
	0x09, 0x7e, 0x2e, 0xf8, 0xad, 0x98, 0xe7, 0x8e, 0x30, 0x50, 0x1e, 0x36, 0xe8, 0xd0, 0xee, 0xd2,
	0xae, 0x9c, 0x82, 0x10, 0x67, 0x05, 0xb9, 0x46, 0x87, 0x55, 0xda, 0x15, 0x13, 0x10, 0xa2, 0x02,
	0xdf, 0xbd, 0xb6, 0xe7, 0x10, 0x1a, 0xba, 0xdf, 0x49, 0x34, 0x11, 0xf8, 0x50, 0x80, 0x73, 0x1c,
	0xf4, 0x8e, 0x37, 0xc6, 0x7c, 0x48, 0xe2, 0x47, 0xf1, 0x0a, 0xa6, 0x0c, 0xb4, 0x03, 0x4b, 0x74,
	0x78, 0x49, 0xfa, 0xf8, 0xad, 0x20, 0x64, 0x81, 0xf2, 0x7c, 0xa4, 0x2e, 0x49, 0xbf, 0x46, 0xfd,
	0x20, 0x20, 0x0e, 0x7e, 0x27, 0xcc, 0x84, 0x86, 0x5e, 0xf0, 0x99, 0xbc, 0x24, 0x7d, 0xc3, 0xe9,
	0x11, 0xfc, 0x3e, 0x3e, 0x59, 0x91, 0x80, 0x5e, 0x41, 0x56, 0x14, 0x55, 0x9f, 0x52, 0xd2, 0x65,
	0xc4, 0xc1, 0x85, 0x78, 0x36, 0x26, 0xd5, 0xd1, 0x9d, 0x8c, 0x5e, 0x8f, 0xdc, 0x75, 0x7a, 0xf8,
	0x78, 0xe2, 0x4e, 0x91, 0x86, 0x8e, 0x40, 0x4e, 0xc9, 0x5d, 0x9f, 0x78, 0x4c, 0xec, 0x0a, 0x2e,
	0x4e, 0x0c, 0xcf, 0x58, 0x46, 0x6f, 0xf8, 0xa0, 0x47, 0x8f, 0x16, 0xaf, 0x5d, 0x89, 0x9b, 0x95,
	0xd4, 0xd1, 0x19, 0xec, 0xd3, 0x61, 0x35, 0x18, 0x98, 0xfd, 0xae, 0x3b, 0xf5, 0x15, 0x55, 0x7c,
	0xe5, 0x47, 0xb6, 0xdc, 0xb3, 0x6a, 0x30, 0xc0, 0x27, 0xf1, 0x9e, 0x55, 0x83, 0x01, 0xda, 0x83,
	0x0c, 0x1d, 0x72, 0x1a, 0x97, 0x84, 0x1c, 0x55, 0xa8, 0x04, 0xbb, 0xf2, 0x53, 0x74, 0x95, 0xb8,
	0xb3, 0x58, 0x13, 0xd8, 0x7c, 0x53, 0x76, 0xf1, 0x63, 0x37, 0x9c, 0x8c, 0x01, 0xfc, 0xfb, 0x68,
	0x8e, 0x92, 0x06, 0x4f, 0x40, 0x16, 0x27, 0xe0, 0x8a, 0x4c, 0x40, 0x36, 0x4e, 0x40, 0x36, 0x4e,
	0xc0, 0x55, 0xd9, 0x27, 0x36, 0x99, 0x80, 0x6c, 0x3a, 0x01, 0x41, 0x76, 0x8a, 0xcd, 0x24, 0x20,
	0x9b, 0x4e, 0xc0, 0xb5, 0x98, 0xbc, 0x9e, 0x25, 0x93, 0x09, 0xb8, 0x1e, 0x93, 0x17, 0xb3, 0x64,
	0x32, 0x01, 0x37, 0x62, 0x72, 0x3a, 0x01, 0xd9, 0x28, 0x01, 0x5f, 0xc8, 0x04, 0x64, 0x13, 0x09,
	0xc8, 0x26, 0x13, 0xf0, 0xa5, 0x4c, 0x40, 0x96, 0x48, 0x40, 0x36, 0x9d, 0x80, 0xff, 0x91, 0x09,
	0xc8, 0xa6, 0x13, 0x90, 0xcd, 0x24, 0xe0, 0x7f, 0xe3, 0x25, 0x4d, 0x27, 0x20, 0x9b, 0x49, 0xc0,
	0x83, 0x24, 0x3a, 0x4e, 0x40, 0x36, 0x9b, 0x80, 0xff, 0x93, 0x43, 0xcc, 0x66, 0x13, 0x90, 0xcd,
	0x49, 0xc0, 0xbc, 0x9c, 0x63, 0x36, 0x27, 0x01, 0xd9, 0x9c, 0x04, 0xfc, 0xff, 0x14, 0x3e, 0x91,
	0x80, 0x6c, 0x4e, 0x02, 0xfe, 0x94, 0xc4, 0x27, 0x13, 0x90, 0xcd, 0x49, 0xc0, 0x9f, 0x93, 0xf8,
	0x64, 0x02, 0xb2, 0x79, 0x09, 0xf8, 0x4a, 0x4e, 0x2e, 0x9b, 0x49, 0xc0, 0x02, 0xdf, 0x99, 0x99,
	0x74, 0x7b, 0x2d, 0xd3, 0x8d, 0xcd, 0x4d, 0x37, 0x36, 0x93, 0x6e, 0x6f, 0xe2, 0xab, 0xcf, 0x49,
	0x37, 0x26, 0xd2, 0xad, 0x2c, 0x4f, 0xaa, 0x28, 0xa4, 0xca, 0xcf, 0xef, 0x69, 0xac, 0x46, 0xe7,
	0x97, 0xc9, 0xf3, 0x7b, 0x26, 0xcf, 0xaf, 0xac, 0x50, 0x19, 0xf6, 0xd8, 0x30, 0x3a, 0xfa, 0x51,
	0x22, 0x5d, 0x11, 0xef, 0x8e, 0xdd, 0xe3, 0x73, 0xc1, 0xfd, 0xc0, 0x95, 0x2b, 0x8d, 0x9c, 0x56,
	0xe0, 0x3a, 0xd7, 0x6e, 0x18, 0xe2, 0x5f, 0xe2, 0x95, 0x4e, 0x19, 0x3c, 0xb9, 0x46, 0xe2, 0x4d,
	0x04, 0xff, 0x1a, 0x6f, 0x72, 0x52, 0xe7, 0xd9, 0x3a, 0xbe, 0x80, 0xcf, 0x3a, 0x3d, 0xfc, 0x5b,
	0x3c, 0x75, 0x93, 0x2a, 0x3f, 0xfa, 0xb7, 0x6e, 0x10, 0xff, 0xb4, 0x6c, 0xca, 0xa3, 0x7f, 0xeb,
	0x06, 0xd1, 0x0f, 0xcb, 0x73, 0xe0, 0x85, 0x3d, 0xf0, 0x5c, 0x16, 0xe2, 0x0f, 0xf2, 0x48, 0xdd,
	0xba, 0x41, 0x9b, 0xd7, 0x3c, 0xdd, 0x99, 0xdb, 0x27, 0x21, 0xeb, 0xf4, 0x03, 0x9c, 0x13, 0x7f,
	0xb7, 0xc6, 0xc2, 0x9b, 0x17, 0xb0, 0xde, 0x22, 0x21, 0xbb, 0xf6, 0x1d, 0xf2, 0x89, 0x3c, 0x86,
	0xfc, 0x7f, 0x6f, 0x27, 0x70, 0x6d, 0x46, 0x42, 0x96, 0x7b, 0x72, 0xa1, 0xc3, 0xb6, 0x4f, 0xef,
	0x0a, 0x7e, 0x40, 0xbc, 0xae, 0x4f, 0x9d, 0x82, 0x7c, 0x15, 0xfa, 0x52, 0xb8, 0x73, 0xd9, 0xfd,
	0xe0, 0x96, 0xff, 0x5b, 0x3d, 0x8e, 0xbd, 0x63, 0xe9, 0xbd, 0x8f, 0x5e, 0x93, 0x1e, 0xb4, 0xe3,
	0x3b, 0x3f, 0x7a, 0x59, 0xba, 0xcd, 0x08, 0xf1, 0xe4, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8,
	0x11, 0x5a, 0xa3, 0x4b, 0x0d, 0x00, 0x00,
}
