/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// Vdsl2LineInventoryAndStatusDataPart2ClassID is the 16-bit ID for the OMCI
// Managed entity VDSL2 line inventory and status data part 2
const Vdsl2LineInventoryAndStatusDataPart2ClassID = ClassID(169) // 0x00a9

var vdsl2lineinventoryandstatusdatapart2BME *ManagedEntityDefinition

// Vdsl2LineInventoryAndStatusDataPart2 (Class ID: #169 / 0x00a9)
//	This ME extends the xDSL line configuration MEs. The ME name was chosen because its attributes
//	were initially unique to ITU-T G.993.2 VDSL2. Due to continuing standards development, some
//	attributes - and therefore this ME - have also become applicable to other Recommendations,
//	specifically [ITU-T G.992.3] and [ITU-T G.992.5].
//
//	This ME contains upstream attributes.
//
//	Relationships
//		This is one of the status data MEs associated with an xDSL UNI. It is meaningful if the PPTP
//		supports [ITU-T G.992.3], [ITU-T G.992.5] or [ITU-T G.993.2]. The ONU automatically creates or
//		deletes an instance of this ME upon creation and deletion of a PPTP xDSL UNI part 1 that
//		supports these attributes.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the PPTP xDSL UNI part 1 ME. (R) (mandatory) (2-bytes)
//
//		Vdsl2 Transmission System Capability Xtu_R
//			VDSL2 transmission system capability xTU-R: This attribute extends the xTU-R transmission system
//			capability attribute of the xDSL line inventory and status data part 1 to include xTUR VDSL2
//			capabilities. It is a defined by bits 57..64 of Table 9.7.12-1. (R) (mandatory) (1-byte)
//
//		Actsnrmodeus
//			1	Virtual noise inactive
//
//			2	Virtual noise active
//
//			(R) (mandatory) (1-byte)
//
//			This attribute indicates whether transmitter-referred virtual noise is active on the line in the
//			upstream direction.
//
//		Upbokle
//			This attribute contains the electrical length estimated by the VTU-O expressed in decibels at
//			1-MHz, kl0 (see O-UPDATE in clause 12.3.3.2.1.2 of [ITUT-G.993.2]). This is the final electrical
//			length that would have been sent from the VTU-O to the VTU-R if the electrical length were not
//			forced by the OLT. The value lies in the range 0 (0.0-dB) to 1280 (128.0-dB) (R) (mandatory)
//			(2-bytes)
//
//			The following four attributes have similar definitions. In each case, valid attribute values are
//			1, 2, 4, 8. In ADSL applications, the corresponding value is fixed at 1, and therefore need not
//			be specified. For VDSL2, it is equal to the size of the subcarrier group used to compute these
//			attributes (see clause 11.4.1 of [ITUT G.993.2]).
//
//		Hlingus
//			This attribute is the number of subcarriers per group used to report HLINpsus. (R) (mandatory)
//			(1-byte)
//
//		Hloggus
//			This attribute is the number of subcarriers per group used to report HLOGpsus. (R) (mandatory)
//			(1-byte)
//
//		Qlngus
//			This attribute is the number of subcarriers per group used to report QLNpsus. (R) (mandatory)
//			(1-byte)
//
//		Snrgus
//			This attribute is the number of subcarriers per group used to report SNRpsus. (R) (mandatory)
//			(1-byte)
//
//		Mrefpsdus Table
//			The upstream medley reference PSD attribute contains the set of breakpoints exchanged in the
//			MREFPSDus fields of the R-PRM message of [ITU-T G.993.2].
//
//			The format is similar to that specified for the PSD descriptor in [ITUT-G.993.2]. In [ITU-T
//			G.993.2], the first byte gives the size of the table, each entry of which is 3-bytes. In the
//			OMCI definition, the first byte is omitted because the size of the table is known from the
//			response to the get command.
//
//			(R) (mandatory) (3 * N bytes, where N is the number of breakpoints)
//
//		Trellisus
//			This attribute reports whether trellis coding is in use in the upstream direction.
//
//			0	Trellis not used
//
//			1	Trellis used
//
//			(R) (mandatory for ITU-T G.993.2 VDSL2, optional for others) (1-byte)
//
//		Actualce
//			This attribute reports the cyclic extension used on the line. It is coded as an unsigned integer
//			from 2 to 16 in units of N/32 samples, where 2N is the IDFT size. (R) (mandatory) (1-byte)
//
//		Upbokle_R
//			UPBOKLE-R: This attribute contains the electrical length estimated by the VTU-R expressed in
//			decibels at 1-MHz. This is the value contained in the message RMSG1 (see clause 12.3.3.2.2.1of
//			[ITUT G.993.2]). Its value lies in the range 0 (0.0-dB) to 1280 (128.0-dB) (R) (optional)
//			(2-bytes)
//
//		Actual Rate Adaptation Mode Upstream
//			The ACT-RA-MODEus attribute indicates the actual active RA mode in the upstream direction.
//
//			1	MANUAL
//
//			2	AT_INIT
//
//			3	DYNAMIC
//
//			4	DYNAMIC with SOS ([ITU-T G.993.2] only)
//
//			(R) (optional) (1-byte)
//
//		Actual Impulse Noise Protection Roc Upstream
//			The ACTINP-ROC-us attribute reports the actual INP of the ROC in the upstream direction
//			expressed in multiples of T4k. The INP of this attribute is equal to the integer value
//			multiplied by 0.1 symbols. Valid values and usage are given in clause 7.5.1.34.2 of
//			[ITUT-G.997.1]. (R) (optional) (1-byte)
//
//		Snr Margin Roc Upstream
//			The SNRM-ROC-us attribute reports the actual signal-to-noise margin of the ROC in the upstream
//			direction. Its value ranges from 0  (-64.0-dB) to 1270 (+63.0-dB). The special value 0xFFFF
//			indicates that the attribute is out of range. (R) (optional) (2-bytes)
//
type Vdsl2LineInventoryAndStatusDataPart2 struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	vdsl2lineinventoryandstatusdatapart2BME = &ManagedEntityDefinition{
		Name:    "Vdsl2LineInventoryAndStatusDataPart2",
		ClassID: 169,
		MessageTypes: mapset.NewSetWith(
			Get,
			GetNext,
		),
		AllowedAttributeMask: 0xfffc,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read), false, false, false, 0),
			1:  ByteField("Vdsl2TransmissionSystemCapabilityXtuR", UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  ByteField("Actsnrmodeus", UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read), false, false, false, 2),
			3:  Uint16Field("Upbokle", UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, false, false, 3),
			4:  ByteField("Hlingus", UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  ByteField("Hloggus", UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, false, 5),
			6:  ByteField("Qlngus", UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  ByteField("Snrgus", UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, false, false, 7),
			8:  TableField("MrefpsdusTable", TableAttributeType, 0x0100, TableInfo{nil, 3}, mapset.NewSetWith(Read), false, false, false, 8),
			9:  ByteField("Trellisus", UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: ByteField("Actualce", UnsignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
			11: Uint16Field("UpbokleR", UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, true, false, 11),
			12: ByteField("ActualRateAdaptationModeUpstream", UnsignedIntegerAttributeType, 0x0010, 0, mapset.NewSetWith(Read), false, true, false, 12),
			13: ByteField("ActualImpulseNoiseProtectionRocUpstream", UnsignedIntegerAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, true, false, 13),
			14: Uint16Field("SnrMarginRocUpstream", UnsignedIntegerAttributeType, 0x0004, 0, mapset.NewSetWith(Read), false, true, false, 14),
		},
		Access:  CreatedByOnu,
		Support: UnknownSupport,
	}
}

// NewVdsl2LineInventoryAndStatusDataPart2 (class ID 169) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewVdsl2LineInventoryAndStatusDataPart2(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*vdsl2lineinventoryandstatusdatapart2BME, params...)
}
