/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// Vdsl2LineConfigurationExtensionsClassID is the 16-bit ID for the OMCI
// Managed entity VDSL2 line configuration extensions
const Vdsl2LineConfigurationExtensionsClassID = ClassID(165) // 0x00a5

var vdsl2lineconfigurationextensionsBME *ManagedEntityDefinition

// Vdsl2LineConfigurationExtensions (Class ID: #165 / 0x00a5)
//	This ME extends the xDSL line configuration MEs with attributes that were originally unique to
//	ITU-T G.993.2 VDSL2. Due to continuing standards development, some attributes - and therefore
//	this ME - have also become applicable to other Recommendations, specifically [ITU-T G.992.3] and
//	[ITU-T G.992.5]. The attributes of this ME are further defined in [ITUT G.997.1]. An instance of
//	this ME is created and deleted by the OLT.
//
//	Relationships
//		An instance of this ME may be associated with zero or more instances of an xDSL UNI.////		The overall xDSL line configuration profile is modelled in several parts, all of which are
//		associated together through a common ME ID (the client PPTP xDSL UNI part 1 has a single
//		pointer, which refers to the entire set of line configuration parts).
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. All xDSL and VDSL2 line
//			configuration profiles and extensions that pertain to a given PPTP xDSL UNI must share a common
//			ME ID. (R, setbycreate) (mandatory) (2-bytes)
//
//		Vdsl2 Profiles Enabling
//			The PROFILES attribute contains the ITU-T G.993.2 profiles to be allowed by the xTU-C. It is
//			coded in a bit map representation (0 if not allowed, 1 if allowed) with the following
//			definition.
//
//			Bit	Meaning
//
//			1 (LSB)	ITU-T G.993.2 profile 8a
//
//			2	ITU-T G.993.2 profile 8b
//
//			3	ITU-T G.993.2 profile 8c
//
//			4	ITU-T G.993.2 profile 8d
//
//			5	ITU-T G.993.2 profile 12a
//
//			6	ITU-T G.993.2 profile 12b
//
//			7	ITU-T G.993.2 profile 17a
//
//			8	ITU-T G.993.2 profile 30a
//
//			(R,-W, setbycreate) (mandatory for ITU-T G.993.2) (1-byte)
//
//		Vdsl2 Psd Mask Class Selection Classmask
//			NOTE 1 - A single PSD mask class may be selected per annex of [ITU-T G.993.2].
//
//			NOTE 2 - It is expected that only a single annex will be enabled at any given time, such that
//			the CLASSMASK attribute, as well as the LIMITMASK and US0DISABLE attributes below, need not be
//			vectors of values.
//
//			NOTE 3 - Attribute value 4 was formerly defined in [ITU-T G.997.1], and is no longer used.
//
//			(R,-W, setbycreate) (mandatory) (1-byte)
//
//			VDSL2 PSD mask class selection (CLASSMASK): To reduce the number of configuration possibilities,
//			the limit PSD masks are grouped in the following PSD mask classes.
//
//			-	Class 998 Annex A of [ITU-T G.993.2]: D-32, D-48, D-64, D-128
//
//			-	Class 997-M1c Annex B of [ITU-T G.993.2]: 997M1c-A-7
//
//			-	Class 997-M1x Annex B of [ITU-T G.993.2]: 997M1x-M
//
//			-	Class 997-M2x Annex B of [ITU-T G.993.2]: 997E17-M2x-NUS0, 997E30M2xNUS0
//
//			-	Class 998-M2x Annex B of [ITU-T G.993.2]: 998M2x-A, 998M2xM, 998M2x-B, 998-M2x-NUS0,
//			998E17-M2xNUS0, 998E17M2xNUS0-M, 998E30M2xNUS0, 998E30M2xNUS0M, 998E17-M2x-A
//
//			-	Class 998ADE-M2x Annex B of [ITU-T G.993.2]: 998-M2x-A, 998M2x-M, 998-M2x-B, 998-M2x-NUS0,
//			998ADE17-M2x-A, 998ADE17M2xB, 998ADE17-M2x-M, 998ADE17M2xNUS0-M, 998ADE30M2xNUS0-A,
//			998ADE30M2x-NUS0-M, HPEADE1230, HPEADE1730
//
//			-	Class 998-B Annex C: POTS-138b, POTS-276b (clause C.2.1.1 of [ITUT-G.993.2]), TCMISDN (clause
//			C.2.1.2 of [ITU-T G.993.2])
//
//			-	Class 998-CO Annex C of [ITU-T G.993.2]: POTS138co, POTS276co (clause C.2.1.1 of [ITU-T
//			G.993.2])
//
//			-	Class HPE-M1 Annex B of [ITU-T G.993.2]: HPE17M1-NUS0, HPE30M1NUS0, HPE1230-M1-NUS0,
//			HPE1730-M1-NUS0
//
//			Each class is designed such that the PSD levels of each limit PSD mask of a specific class are
//			equal in their respective passbands above 552 kHz.
//
//			The CLASSMASK attribute is defined per annex of [ITU-T G.993.2] enabled in the xTSE table (see
//			Table 9.7.12-1). It selects a single PSD mask class per annex of [ITU-T G.993.2] to be activated
//			at the very high-speed digital subscriber line transceiver unit, operator end (VTU-O). The
//			coding is as follows:
//
//		Vdsl2 Limit Psd Masks
//			The LIMITMASK attribute contains the ITU-T G.993.2 limit PSD masks of the selected PSD mask
//			class, enabled by the near-end xTU for each class of profiles. One LIMITMASK parameter is
//			defined per annex enabled in the xTSE (see Table 9.7.12-1).
//
//			The profiles are grouped in the following profile classes:
//
//			-	Class 8: Profiles 8a, 8b, 8c, 8d
//
//			-	Class 12: Profiles 12a, 12b
//
//			-	Class 17: Profile 17a
//
//			-	Class 30: Profile 30a
//
//			For each profile class, several limit PSD masks of the selected PSD mask class (CLASSMASK) may
//			be enabled. The enabling attribute is coded in a bit map representation (0 if the associated
//			mask is not allowed, 1 if it is allowed). The bit mask is defined in Table 9.7.6-1. (R,-W,
//			setbycreate) (mandatory) (8-bytes)
//
//		Vdsl2 Us0 Disabling
//			The US0DISABLE attribute specifies whether channel US0 is disabled for each limit PSD mask
//			enabled in the LIMITMASK attribute.
//
//			For each limit PSD mask enabled in the LIMITMASK attribute, one bit indicates if US0 is
//			disabled. The disabling attribute is a bit map where the value 1 specifies that US0 is disabled
//			for the associated limit mask. The bit map has the same structure as the LIMITMASK attribute.
//			(R,-W, setbycreate) (mandatory) (8-bytes)
//
//		Vdsl2 Us0 Psd Masks
//			The US0MASK attribute contains the US0 PSD masks to be allowed by the xTU-C. This attribute is
//			only defined for Annex-A of [ITUT-G.993.2]. It is represented as a bit map (0 if not allowed, 1
//			if allowed) with the definitions of Table-9.7.6-2. (R, W, setbycreate) (mandatory) (4-bytes)
//
//		Vdsl2_Carmask Table
//			VDSL2-CARMASK table: This attribute specifies restrictions, additional to the band plan, that
//			determine the set of subcarriers allowed for transmission in both upstream and downstream
//			directions.
//
//			The VDSL2-CARMASK attribute describes the not-masked subcarriers in terms of one or more
//			frequency bands. Each band is represented by start and stop subcarrier indices with a subcarrier
//			spacing of 4.3125-kHz. The valid range of subcarrier indices is from 0 to at least the index of
//			the highest allowed subcarrier in both transmission directions among all profiles enabled by the
//			VDSL2 profiles enabling (PROFILES) attribute. Up to 32 bands may be specified. Other subcarriers
//			are masked.
//
//			For profiles using 8.625 kHz tone spacing, the odd subcarrier indices i4.3125 in VDSL2-CARMASK
//			can be transformed into actual subcarrier indices i8.625 using the following rule:
//
//			- for the start frequency of each band: i8.625-=-(i4.3125 + 1)/2
//
//			- for the stop frequency of each band: i8.625-=-(i4.3125 - 1)/2.
//
//			The VDSL2-CARMASK attribute is a table where each entry comprises:
//
//			- an entry number field (1-byte, first entry numbered 1);
//
//			- band start subcarrier index (2-bytes);
//
//			- band stop subcarrier index (2-bytes).
//
//			By default, the table is empty. Entries are added or modified using the set action. Setting a
//			table entry with non-zero subcarrier references implies insertion into the table. Setting an
//			entry's subcarrier references to zero implies deletion from the table, if present.
//
//			The maximum number of bands is 32, so the maximum size of the table is 160-bytes. (R,-W)
//			(mandatory) (5 * N bytes, where N is the number of bands)
//
//		Carmask Valid
//			This attribute controls and reports the status of the VDSL2-CARMASK table. If CARMASK valid-= 1,
//			then the VDSL2-CARMASK has been effectuated on the xDSL equipment. If CARMASK valid-= 0
//			(default), then the VDSL2-CARMASK table is under construction and has not been effectuated on
//			the xDSL equipment.
//
//			This attribute behaves as follows.
//
//			If the OLT changes any of the VDSL2-CARMASK table entries or sets CARMASK valid-= 0, then
//			CARMASK valid-= 0.
//
//			If CARMASK valid-= 0 and the OLT sets CARMASK valid-= 1, then the ONU updates the xDSL equipment
//			with the contents of the table.
//
//			(R,-W) (mandatory) (1-byte)
//
//		Upboshaped
//			This attribute includes two parameters for each band. The parameters are a and b, in that order.
//			Parameter a lies in the range 4000 (40.00-dBm/Hz) to 8095 (80.95-dBm/Hz). Parameter b lies in
//			the range 0 (0.00-dBm/Hz) to 4095 (40.95-dBm/Hz). The special values a-= b-= 0 disable UPBO in
//			the respective upstream band.
//
//			The upstream electrical length parameter UPBOKL defines the electrical length expressed in
//			decibels at 1-MHz, kl0, which may also be configured by the OLT. Its value ranges from 0
//			(0.0-dB) to 1280 (128.0-dB).
//
//			If the force electrical length parameter UPBOKLF is 1, the very high-speed digital subscriber
//			line transceiver unit, remote end (VTU-R) is forced to use the electrical length from this
//			attribute (UPBOKL) to compute UPBO. Otherwise, the VDSL2 transceiver units (VTUs) determine the
//			electrical length themselves.
//
//			(R,-W) (mandatory) (23-bytes)
//
//			Upstream power back-off (UPBO) is specified in [ITUT G.993.2] to provide spectral compatibility
//			between loops of different lengths deployed in the same cable binder. The upstream transmit PSD
//			mask, UPBOMASKus is defined in clause 7.2.1.3.2 of [ITUT G.993.2].
//
//			The ITU-T G.993.2 UPBO configuration attributes a and b are set by the OLT via this attribute.
//			The reference length kl0_REF is set by the companion attribute UPBO klREF-pb, defined in the
//			following. Further details appear in [ITUT-G.997.1].
//
//		Cyclic Extension
//			The CEFLAG attribute enables (1) the optional cyclic extension values. If set to 0, the cyclic
//			extension is forced to the mandatory length 5N/32. (R,-W) (mandatory) (1-byte)
//
//		Downstream Signal_To_Noise Ratio Snr Mode
//			Downstream signal-to-noise ratio (SNR) mode: The SNRMODEds attribute controls transmitter
//			referred virtual noise in the downstream direction. If set to 1, virtual noise is disabled. If
//			set to 2, virtual noise is enabled. (R,-W) (mandatory) (1-byte)
//
//		Upstream Snr Mode
//			The SNRMODEus attribute controls transmitter referred virtual noise in the upstream direction.
//			If set to 1, virtual noise is disabled. If set to 2, virtual noise is enabled. (R,-W)
//			(mandatory) (1-byte)
//
//		Transmitter Referred Virtual Noise Downstream Table
//			Table entries for this attribute have the default value 254 for the noise PSD level. Entries are
//			added or modified using the set action. Setting an entry to a noise PSD level less than or equal
//			to 254 implies insertion into the table. Setting an entry's noise PSD level to 255 implies
//			deletion from the table, if present.
//
//			(R,-W) (optional) (3N bytes, where N is the number of breakpoints)
//
//			The TXREFVNds table defines the downstream transmitter referred virtual noise. TXREFVNds is
//			specified through a set of breakpoints. Each breakpoint comprises a subcarrier index t, with a
//			subcarrier spacing of 4.3125-kHz, and a noise PSD level at that subcarrier. The set of
//			breakpoints can then be represented as [(t1, PSD1), (t2, PSD2), ..., (tN, PSDN)]. The subcarrier
//			index t is an unsigned 2 byte integer. The noise level is 1-byte whose value ranges from 0
//			(-40-dBm/Hz) to 200 (-140-dBm/Hz), in steps of 0.5 dB. Values between 201 and 254 indicate a
//			noise PSD level of 0 W/Hz. The maximum number of breakpoints is 32; no more than 15 breakpoints
//			may be configured below the upper edge of the passband of every mode enabled for [ITU-T G.992.3]
//			and [ITUT-G.992.5].
//
//		Transmitter Referred Virtual Noise Upstream Table
//			The TXREFVNus attribute defines the upstream transmitter referred virtual noise. TXREFVNus is
//			specified through a set of breakpoints. Each breakpoint comprises a subcarrier index t, with a
//			subcarrier spacing of 4.3125-kHz, and a noise PSD level at that subcarrier. The set of
//			breakpoints can then be represented as [(t1, PSD1), (t2, PSD2), ..., (tN, PSDN)]. The subcarrier
//			index t is an unsigned 2-byte integer. The noise level is 1-byte whose value ranges from 0
//			(-40-dBm/Hz) to 200 (-140-dBm/Hz), in steps of 0.5 dB. Values between 201 and 254 indicate a
//			noise PSD level of 0-W/Hz. The maximum number of breakpoints is 16; no more than three
//			breakpoints may be configured below the upper edge of the passband of every mode enabled for
//			[ITU-T G.992.3] and [ITUT-G.992.5].
//
//			Table entries for this attribute have the default value 254 for the noise PSD level. Entries are
//			added or modified using the set action. Setting an entry to a noise PSD level less than or equal
//			to 254 implies insertion into the table. Setting an entry's noise PSD level to 255 implies
//			deletion from the table, if present.
//
//			(R,-W) (optional) (3N bytes, where N is the number of breakpoints)
//
//		Dpboshaped
//			Downstream power back-off - shaped is described in [ITUT G.997.1] as a vector of parameters that
//			modifies the downstream PSD mask.
//
//			DPBOEPSD - Assumed exchange PSD mask. This component points to a downstream xDSL PSD mask
//			profile ME. The PSD mask profile should contain no more than 16 break points. (2-bytes)
//
//			DPBOESEL - E-side electrical length. This component is the assumed loss at some reference
//			frequency of the electrical cable from the xDSL equipment to a possible flexibility point. It
//			ranges from 0 (0.0-dB) to 511 (255.5-dB) in steps of 0.5-dB. The value 0 has the special meaning
//			that it disables the DPBOSHAPED feature. (2-bytes)
//
//			The following three parameters describe the cable model. Further details appear in [ITUT
//			G.997.1]. Each is a scalar that represents the range -1 (coded as 0) to +1.5 (coded as 640) in
//			steps of 1/256.
//
//			DPBOESCMA - (2-bytes)
//
//			DPBOESCMB - (2-bytes)
//
//			DPBOESCMC - (2-bytes)
//
//			DPBOMUS - Assumed minimum usable receive PSD mask. This component ranges from 0 (0.0-dBm/Hz) to
//			255 (-127.5-dBm/Hz) in steps of 0.5 dB. (1-byte)
//
//			DPBOFMIN - The lower frequency bound above which DPBO is applied. This component ranges from 0
//			(0.00 kHz) to 2048 (8832.00 kHz) in steps of 4.3125 kHz. (2-bytes)
//
//			DPBOFMAX - The upper frequency bound below which DPBO is applied. This component ranges from 32
//			(138.00-kHz) to 6956 (29997.75-kHz) in steps of 4.3125-kHz. (2-bytes)
//
//			(R,-W) (optional) (15-bytes)
//
//		Upboklref_Pb
//			UPBOKLREF-pb: This attribute represents the reference loop length, the electrical length used to
//			compute upstream power back-off (UPBO) for each upstream band except US0, for the optional
//			equalized FEXT UPBO method. The value for each upstream band ranges from 1.8 to 63.5 dB in steps
//			of 0.1 dB, i.e., with values 18..635. The special value 0 is also allowed, with semantics as
//			defined in clause 7.2.1.3.2 of [ITUT G.993.2]. (R,-W) (optional) (2-bytes * 5 upstream bands)
//
//		Upboshaped Aele_Mode, Upboelmt
//			UPBOSHAPED (AELE-MODE, UPBOELMT): This attribute defines the UPBO electrical length estimation
//			mode (AELE-MODE) and UPBO electrical length minimum threshold percentile (UPBOELMT) to be used
//			in the alternative electrical length estimation method (ELE-M1). The format of this attribute is
//			given in octet 1 of Table 12-27 of [ITU-T G.993.2]. (R,-W) (optional) (1-byte)
//
type Vdsl2LineConfigurationExtensions struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	vdsl2lineconfigurationextensionsBME = &ManagedEntityDefinition{
		Name:    "Vdsl2LineConfigurationExtensions",
		ClassID: 165,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			GetNext,
			Set,
			SetTable,
		),
		AllowedAttributeMask: 0xffff,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField("Vdsl2ProfilesEnabling", UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 1),
			2:  ByteField("Vdsl2PsdMaskClassSelectionClassmask", UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint64Field("Vdsl2LimitPsdMasks", UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 3),
			4:  Uint64Field("Vdsl2Us0Disabling", UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 4),
			5:  Uint32Field("Vdsl2Us0PsdMasks", UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 5),
			6:  TableField("Vdsl2CarmaskTable", TableAttributeType, 0x0400, TableInfo{nil, 5}, mapset.NewSetWith(Read, Write), false, false, false, 6),
			7:  ByteField("CarmaskValid", UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read, Write), false, false, false, 7),
			8:  MultiByteField("Upboshaped", OctetsAttributeType, 0x0100, 23, toOctets("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="), mapset.NewSetWith(Read, Write), false, false, false, 8),
			9:  ByteField("CyclicExtension", UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read, Write), false, false, false, 9),
			10: ByteField("DownstreamSignalToNoiseRatioSnrMode", UnsignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read, Write), false, false, false, 10),
			11: ByteField("UpstreamSnrMode", UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read, Write), false, false, false, 11),
			12: TableField("TransmitterReferredVirtualNoiseDownstreamTable", TableAttributeType, 0x0010, TableInfo{nil, 3}, mapset.NewSetWith(Read, Write), false, true, false, 12),
			13: TableField("TransmitterReferredVirtualNoiseUpstreamTable", TableAttributeType, 0x0008, TableInfo{nil, 3}, mapset.NewSetWith(Read, Write), false, true, false, 13),
			14: MultiByteField("Dpboshaped", OctetsAttributeType, 0x0004, 15, toOctets("AAAAAAAAAAAAAAAAAAAA"), mapset.NewSetWith(Read, Write), false, true, false, 14),
			15: Uint16Field("UpboklrefPb", UnsignedIntegerAttributeType, 0x0002, 0, mapset.NewSetWith(Read, Write), false, true, false, 15),
			16: ByteField("UpboshapedAeleMode,Upboelmt", UnsignedIntegerAttributeType, 0x0001, 0, mapset.NewSetWith(Read, Write), false, true, false, 16),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
	}
}

// NewVdsl2LineConfigurationExtensions (class ID 165) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewVdsl2LineConfigurationExtensions(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*vdsl2lineconfigurationextensionsBME, params...)
}
