/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// EthernetPseudowireParametersClassID is the 16-bit ID for the OMCI
// Managed entity Ethernet pseudowire parameters
const EthernetPseudowireParametersClassID = ClassID(400) // 0x0190

var ethernetpseudowireparametersBME *ManagedEntityDefinition

// EthernetPseudowireParameters (Class ID: #400 / 0x0190)
//	This ME contains the Ethernet pseudowire parameters. Instances of this ME are created and
//	deleted by the OLT.
//
//	Relationships
//		An instance of this ME is associated with an instance of the PW Ethernet configuration data ME.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the PW Ethernet configuration data ME. (R, set-by-create)
//			(mandatory) (2 bytes)
//
//		Mtu
//			This attribute identifies the maximum transmission unit (bytes) that can be received from the
//			CPE in the upstream direction. Larger frames are discarded. (R, W, set-by-create) (mandatory) (2
//			bytes)
//
type EthernetPseudowireParameters struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const EthernetPseudowireParameters_Mtu = "Mtu"

func init() {
	ethernetpseudowireparametersBME = &ManagedEntityDefinition{
		Name:    "EthernetPseudowireParameters",
		ClassID: EthernetPseudowireParametersClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
		),
		AllowedAttributeMask: 0x8000,
		AttributeDefinitions: AttributeDefinitionMap{
			0: Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1: Uint16Field(EthernetPseudowireParameters_Mtu, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 1),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
	}
}

// NewEthernetPseudowireParameters (class ID 400) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewEthernetPseudowireParameters(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*ethernetpseudowireparametersBME, params...)
}
