/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// Dot1AgMepClassID is the 16-bit ID for the OMCI
// Managed entity Dot1ag MEP
const Dot1AgMepClassID ClassID = ClassID(302)

var dot1agmepBME *ManagedEntityDefinition

// Dot1AgMep (class ID #302)
//	This ME models an MEP as defined primarily in [IEEE 802.1ag] and secondarily in [ITUT Y.1731].
//	It is created and deleted by the OLT. An MEP exists at one of eight possible maintenance levels,
//	and resides at the boundary of a MD. It inherits a name, and optionally a set of associated
//	VLANs, from its associated MA.
//
//	Relationships
//		One or more MEPs may be associated with a MAC bridge port or an IEEE 802.1p mapper in the
//		absence of a MAC bridge. An MEP is also associated with zero or more VLANs and an MA.
//
//	Attributes
//		Managed Entity Id
//			Managed entity ID: This attribute uniquely identifies each instance of this ME. (R, setbycreate)
//			(mandatory) (2-bytes)
//
//		Layer 2 Entity Pointer
//			Layer 2 entity pointer: Depending on the value of the layer 2 type attribute, this pointer
//			specifies the MAC bridge port configuration data ME or the IEEE 802.1p mapper service profile ME
//			with which this MEP is associated. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Layer 2 Type
//			Layer 2 type:	This attribute specifies whether the MA is associated with a MAC bridge port
//			(value 0) or an IEEE 802.1p mapper (value 1). (R,-W, setbycreate) (mandatory) (1-byte)
//
//		Ma Pointer
//			MA pointer:	This pointer specifies the maintenance association with which this MEP is
//			associated. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Mep Id
//			MEP ID:	This attribute specifies the MEP's own identity in the MA. For a given MA, the MEP ID
//			must be unique throughout the network defined by the MD. The MEP ID is defined in the range
//			1..8191. The value 0 indicates that no MEP ID is (yet) configured. (R,-W, setbycreate)
//			(mandatory) (2-bytes)
//
//		Mep Control
//			(R,-W, setbycreate) (mandatory) (1-byte)
//
//		Primary Vlan
//			Primary VLAN: This attribute is a 12-bit VLAN ID. The value 0 indicates that the MEP inherits
//			its primary VLAN from its parent MA. CFM messages, except forwarded LTMs, are tagged with the
//			primary VLAN ID. If explicitly specified, the value of this attribute must be one of the VLANs
//			associated with the parent MA. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Administrative State
//			Administrative state: This attribute locks (1) and unlocks (0) the functions performed by this
//			ME. Administrative state is further described in clause A.1.6. (R,-W, setbycreate) (mandatory)
//			(1-byte)
//
//		Ccm And Ltm Priority
//			CCM and LTM priority: Ranging from 0..7, this attribute permits CCM and LTM frames to be
//			explicitly prioritized, which may be needed if flows are separated, e.g., by 802.1p priority.
//			The priority specified in this attribute is also used in linktrace reply (LTR) frames originated
//			by this MEP. The value 0xFF selects the IEEE 802.1ag default, whereby CCM and LTM frames are
//			transmitted with the highest Ethernet priority available. (R,-W, setbycreate) (mandatory)
//			(1-byte)
//
//		Egress Identifier
//			Egress identifier: This attribute comprises 8-bytes to be included in LTMs. They allow received
//			LTRs to be directed to the correct originator. The attribute includes the originator MAC address
//			and a locally defined identifier. If this field is 0, the ONU uses the MEP's MAC address, with 0
//			as the locally defined identifier. (R,-W, setbycreate) (mandatory) (8-bytes)
//
//		Peer Mep Ids
//			Peer MEP IDs: This attribute lists the expected peer MEPs for CCMs, 2-bytes per MEP ID. [IEEE
//			802.1ag] allows for multipoint networks, and therefore a list of peer MEPs. This attribute
//			allows for up to 12 peers for a given MEP, though GPON applications are expected to need only a
//			single peer. Missing or unexpected messages trigger alarm declaration after a soak interval.
//			Unused peer MEP slots should be set to 0. (R,-W) (mandatory) (24-bytes)
//
//		Eth Ais Control
//			(R,-W, setbycreate) (mandatory if ETH AIS is enabled) (1-byte)
//
//		Fault Alarm Threshold
//			(R,-W, setbycreate) (optional) (1-byte)
//
//		Alarm Declaration Soak Time
//			Alarm declaration soak time: This attribute defines the defect soak time that must elapse before
//			the MEP declares an alarm. It is expressed in 10-ms units with a range of 250 to 1000, i.e.,
//			2.5-s to 10-s. The default is recommended to be 2.5 seconds. (R,-W) (mandatory) (2-bytes)
//
//		Alarm Clear Soak Time
//			Alarm clear soak time: This attribute defines the defect-free soak time that must elapse before
//			the MEP clears an alarm. It is expressed in intervals of 10-ms with a range of 250 to 1-000,
//			i.e., 2.5-s to 10-s. The default is recommended to be 10-s. (R,-W) (mandatory) (2-bytes)
//
type Dot1AgMep struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	dot1agmepBME = &ManagedEntityDefinition{
		Name:    "Dot1AgMep",
		ClassID: 302,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
		),
		AllowedAttributeMask: 0xfffc,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  Uint16Field("Layer2EntityPointer", UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 1),
			2:  ByteField("Layer2Type", UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint16Field("MaPointer", UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 3),
			4:  Uint16Field("MepId", UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 4),
			5:  ByteField("MepControl", UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 5),
			6:  Uint16Field("PrimaryVlan", UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 6),
			7:  ByteField("AdministrativeState", UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 7),
			8:  ByteField("CcmAndLtmPriority", UnsignedIntegerAttributeType, 0x0100, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 8),
			9:  Uint64Field("EgressIdentifier", UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 9),
			10: MultiByteField("PeerMepIds", OctetsAttributeType, 0x0040, 24, toOctets("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), mapset.NewSetWith(Read, Write), false, false, false, 10),
			11: ByteField("EthAisControl", UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 11),
			12: ByteField("FaultAlarmThreshold", UnsignedIntegerAttributeType, 0x0010, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, true, false, 12),
			13: Uint16Field("AlarmDeclarationSoakTime", UnsignedIntegerAttributeType, 0x0008, 0, mapset.NewSetWith(Read, Write), false, false, false, 13),
			14: Uint16Field("AlarmClearSoakTime", UnsignedIntegerAttributeType, 0x0004, 0, mapset.NewSetWith(Read, Write), false, false, false, 14),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0: "RDI CCM",
			1: "MAC status",
			2: "Remote CCM",
			3: "Error CCM",
			4: "Xcon CCM",
			5: "Unexpected period",
			6: "AIS",
		},
	}
}

// NewDot1AgMep (class ID 302) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewDot1AgMep(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*dot1agmepBME, params...)
}
