/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// Vdsl2LineConfigurationExtensions3ClassID is the 16-bit ID for the OMCI
// Managed entity VDSL2 line configuration extensions 3
const Vdsl2LineConfigurationExtensions3ClassID = ClassID(410) // 0x019a

var vdsl2lineconfigurationextensions3BME *ManagedEntityDefinition

// Vdsl2LineConfigurationExtensions3 (Class ID: #410 / 0x019a)
//	This ME extends the xDSL line configuration MEs.
//
//	An instance of this ME is created and deleted by the OLT.
//
//	Relationships
//		An instance of this ME may be associated with zero or more instances of an xDSL UNI.////		The overall xDSL line configuration profile is modelled in several parts, all of which are
//		associated together through a common ME ID (the client PPTP xDSL UNI part 1 has a single
//		pointer, which refers to the entire set of line configuration parts).
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. All xDSL and VDSL2 line
//			configuration profiles and extensions that pertain to a given PPTP xDSL UNI must share a common
//			ME ID. (R, setbycreate) (mandatory) (2-bytes)
//
//		Ripolicyds
//			This attribute indicates which policy shall be applied to determine the triggers for re-
//			initialization in the downstream direction. A valid range of values is given in clause
//			7.3.1.1.12.1 of [ITU-T G.997.1]. (R,-W) (optional) (1-byte)
//
//		Ripolicyus
//			This attribute indicates which policy shall be applied to determine the triggers for re-
//			initialization in the upstream direction. A valid range of values is given in clause
//			7.3.1.1.12.2 of [ITU-T G.997.1]. (R,-W) (optional) (1-byte)
//
//		Reinit_Time_Thresholdds
//			This attribute indicates defines the downstream threshold for re-initialization based on SES, to
//			be used by the VTU receiver when re-initialization policy 1 is used in downstream. A valid range
//			of values is given in clause 7.3.1.1.13.1 of [ITU-T G.997.1]. (R,-W) (optional) (1-byte)
//
//		Reinit_Time_Thresholdus
//			This attribute indicates defines the upstream threshold for re-initialization based on SES, to
//			be used by the VTU receiver when reinitialization policy 1 is used in upstream. A valid range of
//			values is given in clause 7.3.1.1.13.2 of [ITU-T G.997.1]. (R,-W) (optional) (1-byte)
//
//		Rxrefvnsfus
//			If SNRM_MODE = 4, this attribute defines the upstream receiver-referred virtual noise scaling
//			factor. The attribute value ranges from 0  (-64.0-dBm) to 255 (+63.5-dBm) - see clause 7.3.1.7.5
//			of [ITU-T G.997.1]. (R,-W) (optional) (1-byte)
//
//		Txrefvnsfds
//			If SNRM_MODE = 4, this attribute defines the downstream transmitter referred virtual noise
//			scaling factor. The attribute value ranges from 0  (-64.0-dBm) to 255 (+63.5-dBm) - see clause
//			7.3.1.7.6 of [ITU-T G.997.1]. (R,-W) (optional) (1-byte)
//
//		Rtx_Modeds
//			This attribute controls the mode of operation of [ITU-T G.998.4] retransmission in the
//			downstream direction. A valid range of values is given in clause 7.3.1.11 of [ITU-T G.997.1].
//			(R,-W) (mandatory) (1-byte)
//
//		Rtx_Modeus
//			This attribute controls the mode of operation of [ITU-T G.998.4] retransmission in the upstream
//			direction. A valid range of values is given in clause 7.3.1.11 of [ITU-T G.997.1]. (R,-W)
//			(mandatory) (1-byte)
//
//		Leftr_Thresh
//			If retransmission is used in a given transmit direction, LEFTR_THRESH specifies the threshold
//			for declaring a near-end ''leftr'' defect. LEFTR_THRESH is equal to the integer value of this
//			attribute multiplied by 0.01. Valid values and usage are given in clause 7.3.1.12 of [ITU-T
//			G.997.1]. (R,-W) (mandatory) (1-byte)
//
//		Maxdelayoctet_Split Parameter Mdosplit
//			MAXDELAYOCTET-split parameter (MDOSPLIT): This attribute defines the percentage of the
//			MAXDELAYOCTET_ext if operating in [ITU-T G.998.4] or MAXDELAYOCTET in other cases allocated to
//			the downstream direction. MDOSPLIT is equal to the integer value of this attribute multiplied by
//			1%. Valid values and usage are given in clause 7.3.1.14 of [ITUT-G.997.1]. (R,-W) (optional)
//			(1-byte)
//
//		Attndr Method Attndr_Method
//			ATTNDR Method (ATTNDR_METHOD): This attribute specifies the method to be used for the
//			calculation of the ATTNDR in the downstream and upstream direction. Valid values are given in
//			clause 7.3.1.15.1 of [ITU-T G.997.1]. (R,-W) (optional) (1-byte)
//
//		Attndr Maxdelayoctet_Split Parameter Attndr_Mdosplit
//			ATTNDR MAXDELAYOCTET-split parameter (ATTNDR_MDOSPLIT): This attribute defines the percentage of
//			the MAXDELAYOCTET_ext if operating in [ITU-T G.998.4] or MAXDELAYOCTET in other cases allocated
//			to the downstream direction to be used in the improved method for calculation of the ATTNDR. The
//			valid values are identical to the values of the line configuration parameter MDOSPLIT. See
//			clause 7.3.1.15.2 of [ITUT-G.997.1]. (R,-W) (optional) (1-byte)
//
type Vdsl2LineConfigurationExtensions3 struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const Vdsl2LineConfigurationExtensions3_Ripolicyds = "Ripolicyds"
const Vdsl2LineConfigurationExtensions3_Ripolicyus = "Ripolicyus"
const Vdsl2LineConfigurationExtensions3_ReinitTimeThresholdds = "ReinitTimeThresholdds"
const Vdsl2LineConfigurationExtensions3_ReinitTimeThresholdus = "ReinitTimeThresholdus"
const Vdsl2LineConfigurationExtensions3_Rxrefvnsfus = "Rxrefvnsfus"
const Vdsl2LineConfigurationExtensions3_Txrefvnsfds = "Txrefvnsfds"
const Vdsl2LineConfigurationExtensions3_RtxModeds = "RtxModeds"
const Vdsl2LineConfigurationExtensions3_RtxModeus = "RtxModeus"
const Vdsl2LineConfigurationExtensions3_LeftrThresh = "LeftrThresh"
const Vdsl2LineConfigurationExtensions3_MaxdelayoctetSplitParameterMdosplit = "MaxdelayoctetSplitParameterMdosplit"
const Vdsl2LineConfigurationExtensions3_AttndrMethodAttndrMethod = "AttndrMethodAttndrMethod"
const Vdsl2LineConfigurationExtensions3_AttndrMaxdelayoctetSplitParameterAttndrMdosplit = "AttndrMaxdelayoctetSplitParameterAttndrMdosplit"

func init() {
	vdsl2lineconfigurationextensions3BME = &ManagedEntityDefinition{
		Name:    "Vdsl2LineConfigurationExtensions3",
		ClassID: Vdsl2LineConfigurationExtensions3ClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
		),
		AllowedAttributeMask: 0xfff0,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(Vdsl2LineConfigurationExtensions3_Ripolicyds, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read, Write), false, true, false, 1),
			2:  ByteField(Vdsl2LineConfigurationExtensions3_Ripolicyus, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, Write), false, true, false, 2),
			3:  ByteField(Vdsl2LineConfigurationExtensions3_ReinitTimeThresholdds, UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, Write), false, true, false, 3),
			4:  ByteField(Vdsl2LineConfigurationExtensions3_ReinitTimeThresholdus, UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read, Write), false, true, false, 4),
			5:  ByteField(Vdsl2LineConfigurationExtensions3_Rxrefvnsfus, UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read, Write), false, true, false, 5),
			6:  ByteField(Vdsl2LineConfigurationExtensions3_Txrefvnsfds, UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read, Write), false, true, false, 6),
			7:  ByteField(Vdsl2LineConfigurationExtensions3_RtxModeds, UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read, Write), false, false, false, 7),
			8:  ByteField(Vdsl2LineConfigurationExtensions3_RtxModeus, UnsignedIntegerAttributeType, 0x0100, 0, mapset.NewSetWith(Read, Write), false, false, false, 8),
			9:  ByteField(Vdsl2LineConfigurationExtensions3_LeftrThresh, UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read, Write), false, false, false, 9),
			10: ByteField(Vdsl2LineConfigurationExtensions3_MaxdelayoctetSplitParameterMdosplit, UnsignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read, Write), false, true, false, 10),
			11: ByteField(Vdsl2LineConfigurationExtensions3_AttndrMethodAttndrMethod, UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read, Write), false, true, false, 11),
			12: ByteField(Vdsl2LineConfigurationExtensions3_AttndrMaxdelayoctetSplitParameterAttndrMdosplit, UnsignedIntegerAttributeType, 0x0010, 0, mapset.NewSetWith(Read, Write), false, true, false, 12),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
	}
}

// NewVdsl2LineConfigurationExtensions3 (class ID 410) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewVdsl2LineConfigurationExtensions3(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*vdsl2lineconfigurationextensions3BME, params...)
}
