/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import (
	"fmt"
)

var relaxedDecode map[int]bool

func init() {
	relaxedDecode = make(map[int]bool)

	// Default for relaxed decode is True if there is relaxed decode support available
	// relaxedDecode[mkRelaxedKey(Get, false)] = true
	relaxedDecode[mkRelaxedKey(MibUploadNext, false)] = true
}

func mkRelaxedKey(msgType MsgType, request bool) int {
	if request {
		return int(msgType)
	}
	return 100 + int(msgType)
}

func SetRelaxedDecode(msgType MsgType, request bool, relax bool) error {
	key := mkRelaxedKey(msgType, request)

	if _, ok := relaxedDecode[key]; !ok {
		return fmt.Errorf("relax decode of '%v' is not supported", msgType)
	}
	relaxedDecode[key] = relax
	return nil
}

func GetRelaxedDecode(msgType MsgType, request bool) bool {
	key := mkRelaxedKey(msgType, request)

	relaxed, ok := relaxedDecode[key]
	return ok && relaxed
}

// GetRelaxedDecodeByOctetType decodes the payload message-type value and determine if
// relaxed decode is enabled
func GetRelaxedDecodeByOctetType(value byte) bool {
	msgType := MsgType(value & MsgTypeMask)
	var request bool

	if msgType != AlarmNotification && msgType != AttributeValueChange && msgType != TestResult {
		request = value&AR == AR || value&AK == 0
	}
	return GetRelaxedDecode(msgType, request)
}
