/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// SipConfigPortalClassID is the 16-bit ID for the OMCI
// Managed entity SIP config portal
const SipConfigPortalClassID = ClassID(149) // 0x0095

var sipconfigportalBME *ManagedEntityDefinition

// SipConfigPortal (Class ID: #149 / 0x0095)
//	The SIP config portal ME provides a way for the OLT to discover the configuration text delivered
//	to an ONU by a non-OMCI SIP VoIP configuration method ([BBF TR-069], sipping framework, etc.).
//	Text retrieved from this ME is not required to be understood by the OLT or EMS, but it may be
//	useful for human or vendor-specific analysis tools. See also the MGC config portal ME.
//
//	An instance of this ME may be created by an ONU that supports non-OMCI SIP configuration. It is
//	not reported during an MIB upload.
//
//	Relationships
//		One instance of this ME is associated with the ONU.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. There is one instance, number 0.
//			(R) (mandatory) (2-bytes)
//
//		Configuration Text Table
//			This attribute is used to pass a textual representation of the VoIP configuration back to the
//			OLT. The contents are vendor-specific. The get, get next sequence must be used with this
//			attribute since its size is unspecified. Upon ME instantiation, the ONU sets this attribute to
//			0. (R) (mandatory) (x-bytes)
//
type SipConfigPortal struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const SipConfigPortal_ConfigurationTextTable = "ConfigurationTextTable"

func init() {
	sipconfigportalBME = &ManagedEntityDefinition{
		Name:    "SipConfigPortal",
		ClassID: SipConfigPortalClassID,
		MessageTypes: mapset.NewSetWith(
			Get,
			GetNext,
		),
		AllowedAttributeMask: 0x8000,
		AttributeDefinitions: AttributeDefinitionMap{
			0: Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read), false, false, false, 0),
			1: TableField(SipConfigPortal_ConfigurationTextTable, TableAttributeType, 0x8000, TableInfo{nil, 25}, mapset.NewSetWith(Read), true, false, false, 1),
		},
		Access:  CreatedByOnu,
		Support: UnknownSupport,
	}
}

// NewSipConfigPortal (class ID 149) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewSipConfigPortal(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*sipconfigportalBME, params...)
}
