/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// MgcPerformanceMonitoringHistoryDataClassID is the 16-bit ID for the OMCI
// Managed entity MGC performance monitoring history data
const MgcPerformanceMonitoringHistoryDataClassID = ClassID(156) // 0x009c

var mgcperformancemonitoringhistorydataBME *ManagedEntityDefinition

// MgcPerformanceMonitoringHistoryData (Class ID: #156 / 0x009c)
//	The MGC monitoring data ME provides run-time statistics for an active MGC association. Instances
//	of this ME are created and deleted by the OLT.
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an instance of the MGC config data or MGC config
//		portal ME.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the associated MGC config data or to the MGC config portal
//			ME. If a non-OMCI configuration method is used for VoIP, there can be only one live ME instance,
//			associated with the MGC config portal, and with ME ID 0. (R, setbycreate) (mandatory) (2-bytes)
//
//		Interval End Time
//			This attribute identifies the most recently finished 15-min interval. (R) (mandatory) (1-byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 ME that
//			contains PM threshold values. Since no threshold value attribute number exceeds 7, a threshold
//			data 2 ME is optional. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Received Messages
//			This attribute counts the number of received Megaco messages on this association, as defined by
//			[ITUT H.341]. (R) (mandatory) (4-bytes)
//
//		Received Octets
//			This attribute counts the total number of octets received on this association, as defined by
//			[ITU-T H.341]. (R) (mandatory) (4-bytes)
//
//		Sent Messages
//			This attribute counts the total number of Megaco messages sent over this association, as defined
//			by [ITU-T H.341]. (R) (mandatory) (4-bytes)
//
//		Sent Octets
//			This attribute counts the total number of octets sent over this association, as defined by
//			[ITU-T H.341]. (R) (mandatory) (4-bytes)
//
//		Protocol Errors
//			This attribute counts the total number of errors detected on this association, as defined by
//			[ITU-T H.341]. This includes:
//
//			o	syntax errors detected in a given received message;
//
//			o	outgoing transactions that failed for protocol reasons.
//
//			(R) (mandatory) (4-bytes)
//
//		Transport Losses
//			This attribute counts the total number of transport losses (e.g., socket problems) detected on
//			this association. A link loss is defined as loss of communication with the remote entity due to
//			hardware/transient problems, or problems in related software. (R) (mandatory) (4-bytes)
//
//		Last Detected Event
//			This attribute reports the last event detected on this association. This includes events such as
//			the link failing or being set up. Under normal circumstances, a get action on this attribute
//			would return 0 to indicate no abnormal activity. This field is an enumeration as follows.
//
//			0	No event - No event has yet been detected during this PM interval.
//
//			1	Link up - The transport link underpinning the association came up.
//
//			2	Link down - The transport link underpinning the association went down.
//
//			3	Persistent error - A persistent error was detected on the link (such as the socket/TCP
//			connection to the remote node could not be set up).
//
//			4	Local shutdown - The association was brought down intentionally by the local application.
//
//			5	Failover down - The association was brought down as part of failover processing.
//
//			255	Other event - The latest event does not match any in the list.
//
//			(R) (mandatory) (1-byte)
//
//		Last Detected Event Time
//			This attribute reports the time in seconds since the last event on this association was
//			detected, as defined by [ITU-T H.341]. (R) (mandatory) (4-bytes)
//
//		Last Detected Reset Time
//			This attribute reports the time in seconds since these statistics were last reset, as defined by
//			[ITU-T H.341]. Under normal circumstances, a get action on this attribute would return 900-s to
//			indicate a completed 15-min interval. (R) (mandatory) (4-bytes)
//
type MgcPerformanceMonitoringHistoryData struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const MgcPerformanceMonitoringHistoryData_IntervalEndTime = "IntervalEndTime"
const MgcPerformanceMonitoringHistoryData_ThresholdData12Id = "ThresholdData12Id"
const MgcPerformanceMonitoringHistoryData_ReceivedMessages = "ReceivedMessages"
const MgcPerformanceMonitoringHistoryData_ReceivedOctets = "ReceivedOctets"
const MgcPerformanceMonitoringHistoryData_SentMessages = "SentMessages"
const MgcPerformanceMonitoringHistoryData_SentOctets = "SentOctets"
const MgcPerformanceMonitoringHistoryData_ProtocolErrors = "ProtocolErrors"
const MgcPerformanceMonitoringHistoryData_TransportLosses = "TransportLosses"
const MgcPerformanceMonitoringHistoryData_LastDetectedEvent = "LastDetectedEvent"
const MgcPerformanceMonitoringHistoryData_LastDetectedEventTime = "LastDetectedEventTime"
const MgcPerformanceMonitoringHistoryData_LastDetectedResetTime = "LastDetectedResetTime"

func init() {
	mgcperformancemonitoringhistorydataBME = &ManagedEntityDefinition{
		Name:    "MgcPerformanceMonitoringHistoryData",
		ClassID: MgcPerformanceMonitoringHistoryDataClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
			GetCurrentData,
		),
		AllowedAttributeMask: 0xffe0,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(MgcPerformanceMonitoringHistoryData_IntervalEndTime, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(MgcPerformanceMonitoringHistoryData_ThresholdData12Id, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field(MgcPerformanceMonitoringHistoryData_ReceivedMessages, CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, false, false, 3),
			4:  Uint32Field(MgcPerformanceMonitoringHistoryData_ReceivedOctets, CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  Uint32Field(MgcPerformanceMonitoringHistoryData_SentMessages, CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, false, 5),
			6:  Uint32Field(MgcPerformanceMonitoringHistoryData_SentOctets, CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint32Field(MgcPerformanceMonitoringHistoryData_ProtocolErrors, CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, false, false, 7),
			8:  Uint32Field(MgcPerformanceMonitoringHistoryData_TransportLosses, CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, false, false, 8),
			9:  ByteField(MgcPerformanceMonitoringHistoryData_LastDetectedEvent, CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: Uint32Field(MgcPerformanceMonitoringHistoryData_LastDetectedEventTime, CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
			11: Uint32Field(MgcPerformanceMonitoringHistoryData_LastDetectedResetTime, CounterAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, false, false, 11),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0: "MGCP protocol errors",
			1: "MGCP transport losses",
		},
	}
}

// NewMgcPerformanceMonitoringHistoryData (class ID 156) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewMgcPerformanceMonitoringHistoryData(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*mgcperformancemonitoringhistorydataBME, params...)
}
