// Copyright 2018-2024 Open Networking Foundation (ONF) and the ONF Contributors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at:
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.0
// - protoc             v4.25.8
// source: voltha_protos/openolt.proto

package openolt

import (
	context "context"
	common "github.com/opencord/voltha-protos/v5/go/common"
	config "github.com/opencord/voltha-protos/v5/go/ext/config"
	extension "github.com/opencord/voltha-protos/v5/go/extension"
	tech_profile "github.com/opencord/voltha-protos/v5/go/tech_profile"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Openolt_DisableOlt_FullMethodName                = "/openolt.Openolt/DisableOlt"
	Openolt_ReenableOlt_FullMethodName               = "/openolt.Openolt/ReenableOlt"
	Openolt_ActivateOnu_FullMethodName               = "/openolt.Openolt/ActivateOnu"
	Openolt_DeactivateOnu_FullMethodName             = "/openolt.Openolt/DeactivateOnu"
	Openolt_DeleteOnu_FullMethodName                 = "/openolt.Openolt/DeleteOnu"
	Openolt_OmciMsgOut_FullMethodName                = "/openolt.Openolt/OmciMsgOut"
	Openolt_OnuPacketOut_FullMethodName              = "/openolt.Openolt/OnuPacketOut"
	Openolt_UplinkPacketOut_FullMethodName           = "/openolt.Openolt/UplinkPacketOut"
	Openolt_FlowAdd_FullMethodName                   = "/openolt.Openolt/FlowAdd"
	Openolt_FlowRemove_FullMethodName                = "/openolt.Openolt/FlowRemove"
	Openolt_HeartbeatCheck_FullMethodName            = "/openolt.Openolt/HeartbeatCheck"
	Openolt_EnablePonIf_FullMethodName               = "/openolt.Openolt/EnablePonIf"
	Openolt_DisablePonIf_FullMethodName              = "/openolt.Openolt/DisablePonIf"
	Openolt_GetDeviceInfo_FullMethodName             = "/openolt.Openolt/GetDeviceInfo"
	Openolt_Reboot_FullMethodName                    = "/openolt.Openolt/Reboot"
	Openolt_CollectStatistics_FullMethodName         = "/openolt.Openolt/CollectStatistics"
	Openolt_GetOnuStatistics_FullMethodName          = "/openolt.Openolt/GetOnuStatistics"
	Openolt_GetGemPortStatistics_FullMethodName      = "/openolt.Openolt/GetGemPortStatistics"
	Openolt_CreateTrafficSchedulers_FullMethodName   = "/openolt.Openolt/CreateTrafficSchedulers"
	Openolt_RemoveTrafficSchedulers_FullMethodName   = "/openolt.Openolt/RemoveTrafficSchedulers"
	Openolt_CreateTrafficQueues_FullMethodName       = "/openolt.Openolt/CreateTrafficQueues"
	Openolt_RemoveTrafficQueues_FullMethodName       = "/openolt.Openolt/RemoveTrafficQueues"
	Openolt_EnableIndication_FullMethodName          = "/openolt.Openolt/EnableIndication"
	Openolt_PerformGroupOperation_FullMethodName     = "/openolt.Openolt/PerformGroupOperation"
	Openolt_DeleteGroup_FullMethodName               = "/openolt.Openolt/DeleteGroup"
	Openolt_GetExtValue_FullMethodName               = "/openolt.Openolt/GetExtValue"
	Openolt_OnuItuPonAlarmSet_FullMethodName         = "/openolt.Openolt/OnuItuPonAlarmSet"
	Openolt_GetLogicalOnuDistanceZero_FullMethodName = "/openolt.Openolt/GetLogicalOnuDistanceZero"
	Openolt_GetLogicalOnuDistance_FullMethodName     = "/openolt.Openolt/GetLogicalOnuDistance"
	Openolt_GetPonRxPower_FullMethodName             = "/openolt.Openolt/GetPonRxPower"
	Openolt_GetOnuInfo_FullMethodName                = "/openolt.Openolt/GetOnuInfo"
	Openolt_GetPonInterfaceInfo_FullMethodName       = "/openolt.Openolt/GetPonInterfaceInfo"
	Openolt_GetAllocIdStatistics_FullMethodName      = "/openolt.Openolt/GetAllocIdStatistics"
	Openolt_GetPonPortStatistics_FullMethodName      = "/openolt.Openolt/GetPonPortStatistics"
	Openolt_GetNniPortStatistics_FullMethodName      = "/openolt.Openolt/GetNniPortStatistics"
	Openolt_DisableOnu_FullMethodName                = "/openolt.Openolt/DisableOnu"
	Openolt_EnableOnu_FullMethodName                 = "/openolt.Openolt/EnableOnu"
	Openolt_DisableOnuSerialNumber_FullMethodName    = "/openolt.Openolt/DisableOnuSerialNumber"
	Openolt_EnableOnuSerialNumber_FullMethodName     = "/openolt.Openolt/EnableOnuSerialNumber"
)

// OpenoltClient is the client API for Openolt service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type OpenoltClient interface {
	DisableOlt(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
	ReenableOlt(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
	ActivateOnu(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*Empty, error)
	DeactivateOnu(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*Empty, error)
	DeleteOnu(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*Empty, error)
	OmciMsgOut(ctx context.Context, in *OmciMsg, opts ...grpc.CallOption) (*Empty, error)
	OnuPacketOut(ctx context.Context, in *OnuPacket, opts ...grpc.CallOption) (*Empty, error)
	UplinkPacketOut(ctx context.Context, in *UplinkPacket, opts ...grpc.CallOption) (*Empty, error)
	FlowAdd(ctx context.Context, in *Flow, opts ...grpc.CallOption) (*Empty, error)
	FlowRemove(ctx context.Context, in *Flow, opts ...grpc.CallOption) (*Empty, error)
	HeartbeatCheck(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Heartbeat, error)
	EnablePonIf(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*Empty, error)
	DisablePonIf(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*Empty, error)
	GetDeviceInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*DeviceInfo, error)
	Reboot(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
	CollectStatistics(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
	GetOnuStatistics(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*OnuStatistics, error)
	GetGemPortStatistics(ctx context.Context, in *OnuPacket, opts ...grpc.CallOption) (*GemPortStatistics, error)
	CreateTrafficSchedulers(ctx context.Context, in *tech_profile.TrafficSchedulers, opts ...grpc.CallOption) (*Empty, error)
	RemoveTrafficSchedulers(ctx context.Context, in *tech_profile.TrafficSchedulers, opts ...grpc.CallOption) (*Empty, error)
	CreateTrafficQueues(ctx context.Context, in *tech_profile.TrafficQueues, opts ...grpc.CallOption) (*Empty, error)
	RemoveTrafficQueues(ctx context.Context, in *tech_profile.TrafficQueues, opts ...grpc.CallOption) (*Empty, error)
	EnableIndication(ctx context.Context, in *Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[Indication], error)
	PerformGroupOperation(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Empty, error)
	DeleteGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Empty, error)
	GetExtValue(ctx context.Context, in *ValueParam, opts ...grpc.CallOption) (*extension.ReturnValues, error)
	OnuItuPonAlarmSet(ctx context.Context, in *config.OnuItuPonAlarm, opts ...grpc.CallOption) (*Empty, error)
	GetLogicalOnuDistanceZero(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*OnuLogicalDistance, error)
	GetLogicalOnuDistance(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*OnuLogicalDistance, error)
	GetPonRxPower(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*PonRxPowerData, error)
	// GetOnuInfo takes Onu id, serialnumber, and pon interface as argument from the onu structure.
	// Returns the Onu info from the device.
	GetOnuInfo(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*OnuInfo, error)
	// GetPonInterfaceInfo takes the pon intf id as argument.
	// Returns the pon interface information from the device.
	GetPonInterfaceInfo(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*PonIntfInfo, error)
	// GetAllocIdStatistics takes onuId and allocId as argument.
	// This method includes a default wait period of 10 secs before collecting the stats.
	// The caller has to be aware of this wait and handle it accordingly.
	// Returns AllocId statistics in the form of OnuAllocStatistics structure
	GetAllocIdStatistics(ctx context.Context, in *OnuPacket, opts ...grpc.CallOption) (*OnuAllocIdStatistics, error)
	// GetPonPortStatistics takes interface id and type as argument from Interface structure.
	// Returns Pon port statistics in the form of PonStatsData structure.
	GetPonPortStatistics(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*common.PortStatistics, error)
	// GetNniPortStatistics takes takes interface id and type as argument from Interface structure.
	// Returns Nni port statistics in the form of NniStatsData structure
	GetNniPortStatistics(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*common.PortStatistics, error)
	// Disable ONU serailnumber, disable device at PLOAM.
	// Takes input as intfid, onuid, sn of the ONU.
	// Returns success if the call towards the device is success, error otherwise.
	DisableOnu(ctx context.Context, in *InterfaceOnuSerialNumberOnuId, opts ...grpc.CallOption) (*Empty, error)
	// Enables ONU serailnumber, enable device at PLOAM.
	// Takes input as intfid, onuid, sn of the ONU.
	// Returns success if the call towards the device is success, error otherwise.
	EnableOnu(ctx context.Context, in *InterfaceOnuSerialNumberOnuId, opts ...grpc.CallOption) (*Empty, error)
	// Disable ONU serailnumber, disable device at PLOAM
	// Takes input as intfid and sn of the ONU. Generally used when the onu is not present in the OLT.
	// Returns success if the call towards the device is success, error otherwise.
	DisableOnuSerialNumber(ctx context.Context, in *InterfaceOnuSerialNumber, opts ...grpc.CallOption) (*Empty, error)
	// Enables ONU serailnumber, enable device at PLOAM
	// Takes input as intfid and sn of the ONU. Generally used when the onu is not present in the OLT.
	// Returns success if the call towards the device is success, error otherwise.
	EnableOnuSerialNumber(ctx context.Context, in *InterfaceOnuSerialNumber, opts ...grpc.CallOption) (*Empty, error)
}

type openoltClient struct {
	cc grpc.ClientConnInterface
}

func NewOpenoltClient(cc grpc.ClientConnInterface) OpenoltClient {
	return &openoltClient{cc}
}

func (c *openoltClient) DisableOlt(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_DisableOlt_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) ReenableOlt(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_ReenableOlt_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) ActivateOnu(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_ActivateOnu_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) DeactivateOnu(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_DeactivateOnu_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) DeleteOnu(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_DeleteOnu_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) OmciMsgOut(ctx context.Context, in *OmciMsg, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_OmciMsgOut_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) OnuPacketOut(ctx context.Context, in *OnuPacket, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_OnuPacketOut_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) UplinkPacketOut(ctx context.Context, in *UplinkPacket, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_UplinkPacketOut_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) FlowAdd(ctx context.Context, in *Flow, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_FlowAdd_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) FlowRemove(ctx context.Context, in *Flow, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_FlowRemove_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) HeartbeatCheck(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Heartbeat, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Heartbeat)
	err := c.cc.Invoke(ctx, Openolt_HeartbeatCheck_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) EnablePonIf(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_EnablePonIf_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) DisablePonIf(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_DisablePonIf_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetDeviceInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*DeviceInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeviceInfo)
	err := c.cc.Invoke(ctx, Openolt_GetDeviceInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) Reboot(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_Reboot_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) CollectStatistics(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_CollectStatistics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetOnuStatistics(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*OnuStatistics, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(OnuStatistics)
	err := c.cc.Invoke(ctx, Openolt_GetOnuStatistics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetGemPortStatistics(ctx context.Context, in *OnuPacket, opts ...grpc.CallOption) (*GemPortStatistics, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GemPortStatistics)
	err := c.cc.Invoke(ctx, Openolt_GetGemPortStatistics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) CreateTrafficSchedulers(ctx context.Context, in *tech_profile.TrafficSchedulers, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_CreateTrafficSchedulers_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) RemoveTrafficSchedulers(ctx context.Context, in *tech_profile.TrafficSchedulers, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_RemoveTrafficSchedulers_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) CreateTrafficQueues(ctx context.Context, in *tech_profile.TrafficQueues, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_CreateTrafficQueues_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) RemoveTrafficQueues(ctx context.Context, in *tech_profile.TrafficQueues, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_RemoveTrafficQueues_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) EnableIndication(ctx context.Context, in *Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[Indication], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &Openolt_ServiceDesc.Streams[0], Openolt_EnableIndication_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[Empty, Indication]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Openolt_EnableIndicationClient = grpc.ServerStreamingClient[Indication]

func (c *openoltClient) PerformGroupOperation(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_PerformGroupOperation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) DeleteGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_DeleteGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetExtValue(ctx context.Context, in *ValueParam, opts ...grpc.CallOption) (*extension.ReturnValues, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(extension.ReturnValues)
	err := c.cc.Invoke(ctx, Openolt_GetExtValue_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) OnuItuPonAlarmSet(ctx context.Context, in *config.OnuItuPonAlarm, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_OnuItuPonAlarmSet_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetLogicalOnuDistanceZero(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*OnuLogicalDistance, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(OnuLogicalDistance)
	err := c.cc.Invoke(ctx, Openolt_GetLogicalOnuDistanceZero_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetLogicalOnuDistance(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*OnuLogicalDistance, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(OnuLogicalDistance)
	err := c.cc.Invoke(ctx, Openolt_GetLogicalOnuDistance_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetPonRxPower(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*PonRxPowerData, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PonRxPowerData)
	err := c.cc.Invoke(ctx, Openolt_GetPonRxPower_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetOnuInfo(ctx context.Context, in *Onu, opts ...grpc.CallOption) (*OnuInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(OnuInfo)
	err := c.cc.Invoke(ctx, Openolt_GetOnuInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetPonInterfaceInfo(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*PonIntfInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PonIntfInfo)
	err := c.cc.Invoke(ctx, Openolt_GetPonInterfaceInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetAllocIdStatistics(ctx context.Context, in *OnuPacket, opts ...grpc.CallOption) (*OnuAllocIdStatistics, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(OnuAllocIdStatistics)
	err := c.cc.Invoke(ctx, Openolt_GetAllocIdStatistics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetPonPortStatistics(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*common.PortStatistics, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(common.PortStatistics)
	err := c.cc.Invoke(ctx, Openolt_GetPonPortStatistics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) GetNniPortStatistics(ctx context.Context, in *Interface, opts ...grpc.CallOption) (*common.PortStatistics, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(common.PortStatistics)
	err := c.cc.Invoke(ctx, Openolt_GetNniPortStatistics_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) DisableOnu(ctx context.Context, in *InterfaceOnuSerialNumberOnuId, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_DisableOnu_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) EnableOnu(ctx context.Context, in *InterfaceOnuSerialNumberOnuId, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_EnableOnu_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) DisableOnuSerialNumber(ctx context.Context, in *InterfaceOnuSerialNumber, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_DisableOnuSerialNumber_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openoltClient) EnableOnuSerialNumber(ctx context.Context, in *InterfaceOnuSerialNumber, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Openolt_EnableOnuSerialNumber_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OpenoltServer is the server API for Openolt service.
// All implementations must embed UnimplementedOpenoltServer
// for forward compatibility.
type OpenoltServer interface {
	DisableOlt(context.Context, *Empty) (*Empty, error)
	ReenableOlt(context.Context, *Empty) (*Empty, error)
	ActivateOnu(context.Context, *Onu) (*Empty, error)
	DeactivateOnu(context.Context, *Onu) (*Empty, error)
	DeleteOnu(context.Context, *Onu) (*Empty, error)
	OmciMsgOut(context.Context, *OmciMsg) (*Empty, error)
	OnuPacketOut(context.Context, *OnuPacket) (*Empty, error)
	UplinkPacketOut(context.Context, *UplinkPacket) (*Empty, error)
	FlowAdd(context.Context, *Flow) (*Empty, error)
	FlowRemove(context.Context, *Flow) (*Empty, error)
	HeartbeatCheck(context.Context, *Empty) (*Heartbeat, error)
	EnablePonIf(context.Context, *Interface) (*Empty, error)
	DisablePonIf(context.Context, *Interface) (*Empty, error)
	GetDeviceInfo(context.Context, *Empty) (*DeviceInfo, error)
	Reboot(context.Context, *Empty) (*Empty, error)
	CollectStatistics(context.Context, *Empty) (*Empty, error)
	GetOnuStatistics(context.Context, *Onu) (*OnuStatistics, error)
	GetGemPortStatistics(context.Context, *OnuPacket) (*GemPortStatistics, error)
	CreateTrafficSchedulers(context.Context, *tech_profile.TrafficSchedulers) (*Empty, error)
	RemoveTrafficSchedulers(context.Context, *tech_profile.TrafficSchedulers) (*Empty, error)
	CreateTrafficQueues(context.Context, *tech_profile.TrafficQueues) (*Empty, error)
	RemoveTrafficQueues(context.Context, *tech_profile.TrafficQueues) (*Empty, error)
	EnableIndication(*Empty, grpc.ServerStreamingServer[Indication]) error
	PerformGroupOperation(context.Context, *Group) (*Empty, error)
	DeleteGroup(context.Context, *Group) (*Empty, error)
	GetExtValue(context.Context, *ValueParam) (*extension.ReturnValues, error)
	OnuItuPonAlarmSet(context.Context, *config.OnuItuPonAlarm) (*Empty, error)
	GetLogicalOnuDistanceZero(context.Context, *Onu) (*OnuLogicalDistance, error)
	GetLogicalOnuDistance(context.Context, *Onu) (*OnuLogicalDistance, error)
	GetPonRxPower(context.Context, *Onu) (*PonRxPowerData, error)
	// GetOnuInfo takes Onu id, serialnumber, and pon interface as argument from the onu structure.
	// Returns the Onu info from the device.
	GetOnuInfo(context.Context, *Onu) (*OnuInfo, error)
	// GetPonInterfaceInfo takes the pon intf id as argument.
	// Returns the pon interface information from the device.
	GetPonInterfaceInfo(context.Context, *Interface) (*PonIntfInfo, error)
	// GetAllocIdStatistics takes onuId and allocId as argument.
	// This method includes a default wait period of 10 secs before collecting the stats.
	// The caller has to be aware of this wait and handle it accordingly.
	// Returns AllocId statistics in the form of OnuAllocStatistics structure
	GetAllocIdStatistics(context.Context, *OnuPacket) (*OnuAllocIdStatistics, error)
	// GetPonPortStatistics takes interface id and type as argument from Interface structure.
	// Returns Pon port statistics in the form of PonStatsData structure.
	GetPonPortStatistics(context.Context, *Interface) (*common.PortStatistics, error)
	// GetNniPortStatistics takes takes interface id and type as argument from Interface structure.
	// Returns Nni port statistics in the form of NniStatsData structure
	GetNniPortStatistics(context.Context, *Interface) (*common.PortStatistics, error)
	// Disable ONU serailnumber, disable device at PLOAM.
	// Takes input as intfid, onuid, sn of the ONU.
	// Returns success if the call towards the device is success, error otherwise.
	DisableOnu(context.Context, *InterfaceOnuSerialNumberOnuId) (*Empty, error)
	// Enables ONU serailnumber, enable device at PLOAM.
	// Takes input as intfid, onuid, sn of the ONU.
	// Returns success if the call towards the device is success, error otherwise.
	EnableOnu(context.Context, *InterfaceOnuSerialNumberOnuId) (*Empty, error)
	// Disable ONU serailnumber, disable device at PLOAM
	// Takes input as intfid and sn of the ONU. Generally used when the onu is not present in the OLT.
	// Returns success if the call towards the device is success, error otherwise.
	DisableOnuSerialNumber(context.Context, *InterfaceOnuSerialNumber) (*Empty, error)
	// Enables ONU serailnumber, enable device at PLOAM
	// Takes input as intfid and sn of the ONU. Generally used when the onu is not present in the OLT.
	// Returns success if the call towards the device is success, error otherwise.
	EnableOnuSerialNumber(context.Context, *InterfaceOnuSerialNumber) (*Empty, error)
	mustEmbedUnimplementedOpenoltServer()
}

// UnimplementedOpenoltServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedOpenoltServer struct{}

func (UnimplementedOpenoltServer) DisableOlt(context.Context, *Empty) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisableOlt not implemented")
}
func (UnimplementedOpenoltServer) ReenableOlt(context.Context, *Empty) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method ReenableOlt not implemented")
}
func (UnimplementedOpenoltServer) ActivateOnu(context.Context, *Onu) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method ActivateOnu not implemented")
}
func (UnimplementedOpenoltServer) DeactivateOnu(context.Context, *Onu) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeactivateOnu not implemented")
}
func (UnimplementedOpenoltServer) DeleteOnu(context.Context, *Onu) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteOnu not implemented")
}
func (UnimplementedOpenoltServer) OmciMsgOut(context.Context, *OmciMsg) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method OmciMsgOut not implemented")
}
func (UnimplementedOpenoltServer) OnuPacketOut(context.Context, *OnuPacket) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method OnuPacketOut not implemented")
}
func (UnimplementedOpenoltServer) UplinkPacketOut(context.Context, *UplinkPacket) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method UplinkPacketOut not implemented")
}
func (UnimplementedOpenoltServer) FlowAdd(context.Context, *Flow) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method FlowAdd not implemented")
}
func (UnimplementedOpenoltServer) FlowRemove(context.Context, *Flow) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method FlowRemove not implemented")
}
func (UnimplementedOpenoltServer) HeartbeatCheck(context.Context, *Empty) (*Heartbeat, error) {
	return nil, status.Error(codes.Unimplemented, "method HeartbeatCheck not implemented")
}
func (UnimplementedOpenoltServer) EnablePonIf(context.Context, *Interface) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method EnablePonIf not implemented")
}
func (UnimplementedOpenoltServer) DisablePonIf(context.Context, *Interface) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisablePonIf not implemented")
}
func (UnimplementedOpenoltServer) GetDeviceInfo(context.Context, *Empty) (*DeviceInfo, error) {
	return nil, status.Error(codes.Unimplemented, "method GetDeviceInfo not implemented")
}
func (UnimplementedOpenoltServer) Reboot(context.Context, *Empty) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method Reboot not implemented")
}
func (UnimplementedOpenoltServer) CollectStatistics(context.Context, *Empty) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method CollectStatistics not implemented")
}
func (UnimplementedOpenoltServer) GetOnuStatistics(context.Context, *Onu) (*OnuStatistics, error) {
	return nil, status.Error(codes.Unimplemented, "method GetOnuStatistics not implemented")
}
func (UnimplementedOpenoltServer) GetGemPortStatistics(context.Context, *OnuPacket) (*GemPortStatistics, error) {
	return nil, status.Error(codes.Unimplemented, "method GetGemPortStatistics not implemented")
}
func (UnimplementedOpenoltServer) CreateTrafficSchedulers(context.Context, *tech_profile.TrafficSchedulers) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method CreateTrafficSchedulers not implemented")
}
func (UnimplementedOpenoltServer) RemoveTrafficSchedulers(context.Context, *tech_profile.TrafficSchedulers) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method RemoveTrafficSchedulers not implemented")
}
func (UnimplementedOpenoltServer) CreateTrafficQueues(context.Context, *tech_profile.TrafficQueues) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method CreateTrafficQueues not implemented")
}
func (UnimplementedOpenoltServer) RemoveTrafficQueues(context.Context, *tech_profile.TrafficQueues) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method RemoveTrafficQueues not implemented")
}
func (UnimplementedOpenoltServer) EnableIndication(*Empty, grpc.ServerStreamingServer[Indication]) error {
	return status.Error(codes.Unimplemented, "method EnableIndication not implemented")
}
func (UnimplementedOpenoltServer) PerformGroupOperation(context.Context, *Group) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method PerformGroupOperation not implemented")
}
func (UnimplementedOpenoltServer) DeleteGroup(context.Context, *Group) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteGroup not implemented")
}
func (UnimplementedOpenoltServer) GetExtValue(context.Context, *ValueParam) (*extension.ReturnValues, error) {
	return nil, status.Error(codes.Unimplemented, "method GetExtValue not implemented")
}
func (UnimplementedOpenoltServer) OnuItuPonAlarmSet(context.Context, *config.OnuItuPonAlarm) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method OnuItuPonAlarmSet not implemented")
}
func (UnimplementedOpenoltServer) GetLogicalOnuDistanceZero(context.Context, *Onu) (*OnuLogicalDistance, error) {
	return nil, status.Error(codes.Unimplemented, "method GetLogicalOnuDistanceZero not implemented")
}
func (UnimplementedOpenoltServer) GetLogicalOnuDistance(context.Context, *Onu) (*OnuLogicalDistance, error) {
	return nil, status.Error(codes.Unimplemented, "method GetLogicalOnuDistance not implemented")
}
func (UnimplementedOpenoltServer) GetPonRxPower(context.Context, *Onu) (*PonRxPowerData, error) {
	return nil, status.Error(codes.Unimplemented, "method GetPonRxPower not implemented")
}
func (UnimplementedOpenoltServer) GetOnuInfo(context.Context, *Onu) (*OnuInfo, error) {
	return nil, status.Error(codes.Unimplemented, "method GetOnuInfo not implemented")
}
func (UnimplementedOpenoltServer) GetPonInterfaceInfo(context.Context, *Interface) (*PonIntfInfo, error) {
	return nil, status.Error(codes.Unimplemented, "method GetPonInterfaceInfo not implemented")
}
func (UnimplementedOpenoltServer) GetAllocIdStatistics(context.Context, *OnuPacket) (*OnuAllocIdStatistics, error) {
	return nil, status.Error(codes.Unimplemented, "method GetAllocIdStatistics not implemented")
}
func (UnimplementedOpenoltServer) GetPonPortStatistics(context.Context, *Interface) (*common.PortStatistics, error) {
	return nil, status.Error(codes.Unimplemented, "method GetPonPortStatistics not implemented")
}
func (UnimplementedOpenoltServer) GetNniPortStatistics(context.Context, *Interface) (*common.PortStatistics, error) {
	return nil, status.Error(codes.Unimplemented, "method GetNniPortStatistics not implemented")
}
func (UnimplementedOpenoltServer) DisableOnu(context.Context, *InterfaceOnuSerialNumberOnuId) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisableOnu not implemented")
}
func (UnimplementedOpenoltServer) EnableOnu(context.Context, *InterfaceOnuSerialNumberOnuId) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method EnableOnu not implemented")
}
func (UnimplementedOpenoltServer) DisableOnuSerialNumber(context.Context, *InterfaceOnuSerialNumber) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisableOnuSerialNumber not implemented")
}
func (UnimplementedOpenoltServer) EnableOnuSerialNumber(context.Context, *InterfaceOnuSerialNumber) (*Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method EnableOnuSerialNumber not implemented")
}
func (UnimplementedOpenoltServer) mustEmbedUnimplementedOpenoltServer() {}
func (UnimplementedOpenoltServer) testEmbeddedByValue()                 {}

// UnsafeOpenoltServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OpenoltServer will
// result in compilation errors.
type UnsafeOpenoltServer interface {
	mustEmbedUnimplementedOpenoltServer()
}

func RegisterOpenoltServer(s grpc.ServiceRegistrar, srv OpenoltServer) {
	// If the following call panics, it indicates UnimplementedOpenoltServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Openolt_ServiceDesc, srv)
}

func _Openolt_DisableOlt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).DisableOlt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_DisableOlt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).DisableOlt(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_ReenableOlt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).ReenableOlt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_ReenableOlt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).ReenableOlt(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_ActivateOnu_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Onu)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).ActivateOnu(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_ActivateOnu_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).ActivateOnu(ctx, req.(*Onu))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_DeactivateOnu_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Onu)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).DeactivateOnu(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_DeactivateOnu_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).DeactivateOnu(ctx, req.(*Onu))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_DeleteOnu_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Onu)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).DeleteOnu(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_DeleteOnu_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).DeleteOnu(ctx, req.(*Onu))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_OmciMsgOut_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OmciMsg)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).OmciMsgOut(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_OmciMsgOut_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).OmciMsgOut(ctx, req.(*OmciMsg))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_OnuPacketOut_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OnuPacket)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).OnuPacketOut(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_OnuPacketOut_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).OnuPacketOut(ctx, req.(*OnuPacket))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_UplinkPacketOut_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UplinkPacket)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).UplinkPacketOut(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_UplinkPacketOut_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).UplinkPacketOut(ctx, req.(*UplinkPacket))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_FlowAdd_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Flow)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).FlowAdd(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_FlowAdd_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).FlowAdd(ctx, req.(*Flow))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_FlowRemove_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Flow)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).FlowRemove(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_FlowRemove_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).FlowRemove(ctx, req.(*Flow))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_HeartbeatCheck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).HeartbeatCheck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_HeartbeatCheck_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).HeartbeatCheck(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_EnablePonIf_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Interface)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).EnablePonIf(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_EnablePonIf_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).EnablePonIf(ctx, req.(*Interface))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_DisablePonIf_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Interface)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).DisablePonIf(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_DisablePonIf_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).DisablePonIf(ctx, req.(*Interface))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetDeviceInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetDeviceInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetDeviceInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetDeviceInfo(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_Reboot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).Reboot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_Reboot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).Reboot(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_CollectStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).CollectStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_CollectStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).CollectStatistics(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetOnuStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Onu)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetOnuStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetOnuStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetOnuStatistics(ctx, req.(*Onu))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetGemPortStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OnuPacket)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetGemPortStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetGemPortStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetGemPortStatistics(ctx, req.(*OnuPacket))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_CreateTrafficSchedulers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tech_profile.TrafficSchedulers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).CreateTrafficSchedulers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_CreateTrafficSchedulers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).CreateTrafficSchedulers(ctx, req.(*tech_profile.TrafficSchedulers))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_RemoveTrafficSchedulers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tech_profile.TrafficSchedulers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).RemoveTrafficSchedulers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_RemoveTrafficSchedulers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).RemoveTrafficSchedulers(ctx, req.(*tech_profile.TrafficSchedulers))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_CreateTrafficQueues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tech_profile.TrafficQueues)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).CreateTrafficQueues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_CreateTrafficQueues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).CreateTrafficQueues(ctx, req.(*tech_profile.TrafficQueues))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_RemoveTrafficQueues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tech_profile.TrafficQueues)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).RemoveTrafficQueues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_RemoveTrafficQueues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).RemoveTrafficQueues(ctx, req.(*tech_profile.TrafficQueues))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_EnableIndication_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(OpenoltServer).EnableIndication(m, &grpc.GenericServerStream[Empty, Indication]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Openolt_EnableIndicationServer = grpc.ServerStreamingServer[Indication]

func _Openolt_PerformGroupOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).PerformGroupOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_PerformGroupOperation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).PerformGroupOperation(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_DeleteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).DeleteGroup(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetExtValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValueParam)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetExtValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetExtValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetExtValue(ctx, req.(*ValueParam))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_OnuItuPonAlarmSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(config.OnuItuPonAlarm)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).OnuItuPonAlarmSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_OnuItuPonAlarmSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).OnuItuPonAlarmSet(ctx, req.(*config.OnuItuPonAlarm))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetLogicalOnuDistanceZero_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Onu)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetLogicalOnuDistanceZero(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetLogicalOnuDistanceZero_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetLogicalOnuDistanceZero(ctx, req.(*Onu))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetLogicalOnuDistance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Onu)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetLogicalOnuDistance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetLogicalOnuDistance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetLogicalOnuDistance(ctx, req.(*Onu))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetPonRxPower_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Onu)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetPonRxPower(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetPonRxPower_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetPonRxPower(ctx, req.(*Onu))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetOnuInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Onu)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetOnuInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetOnuInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetOnuInfo(ctx, req.(*Onu))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetPonInterfaceInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Interface)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetPonInterfaceInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetPonInterfaceInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetPonInterfaceInfo(ctx, req.(*Interface))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetAllocIdStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OnuPacket)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetAllocIdStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetAllocIdStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetAllocIdStatistics(ctx, req.(*OnuPacket))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetPonPortStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Interface)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetPonPortStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetPonPortStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetPonPortStatistics(ctx, req.(*Interface))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_GetNniPortStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Interface)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).GetNniPortStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_GetNniPortStatistics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).GetNniPortStatistics(ctx, req.(*Interface))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_DisableOnu_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InterfaceOnuSerialNumberOnuId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).DisableOnu(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_DisableOnu_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).DisableOnu(ctx, req.(*InterfaceOnuSerialNumberOnuId))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_EnableOnu_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InterfaceOnuSerialNumberOnuId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).EnableOnu(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_EnableOnu_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).EnableOnu(ctx, req.(*InterfaceOnuSerialNumberOnuId))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_DisableOnuSerialNumber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InterfaceOnuSerialNumber)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).DisableOnuSerialNumber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_DisableOnuSerialNumber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).DisableOnuSerialNumber(ctx, req.(*InterfaceOnuSerialNumber))
	}
	return interceptor(ctx, in, info, handler)
}

func _Openolt_EnableOnuSerialNumber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InterfaceOnuSerialNumber)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenoltServer).EnableOnuSerialNumber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Openolt_EnableOnuSerialNumber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenoltServer).EnableOnuSerialNumber(ctx, req.(*InterfaceOnuSerialNumber))
	}
	return interceptor(ctx, in, info, handler)
}

// Openolt_ServiceDesc is the grpc.ServiceDesc for Openolt service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Openolt_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "openolt.Openolt",
	HandlerType: (*OpenoltServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DisableOlt",
			Handler:    _Openolt_DisableOlt_Handler,
		},
		{
			MethodName: "ReenableOlt",
			Handler:    _Openolt_ReenableOlt_Handler,
		},
		{
			MethodName: "ActivateOnu",
			Handler:    _Openolt_ActivateOnu_Handler,
		},
		{
			MethodName: "DeactivateOnu",
			Handler:    _Openolt_DeactivateOnu_Handler,
		},
		{
			MethodName: "DeleteOnu",
			Handler:    _Openolt_DeleteOnu_Handler,
		},
		{
			MethodName: "OmciMsgOut",
			Handler:    _Openolt_OmciMsgOut_Handler,
		},
		{
			MethodName: "OnuPacketOut",
			Handler:    _Openolt_OnuPacketOut_Handler,
		},
		{
			MethodName: "UplinkPacketOut",
			Handler:    _Openolt_UplinkPacketOut_Handler,
		},
		{
			MethodName: "FlowAdd",
			Handler:    _Openolt_FlowAdd_Handler,
		},
		{
			MethodName: "FlowRemove",
			Handler:    _Openolt_FlowRemove_Handler,
		},
		{
			MethodName: "HeartbeatCheck",
			Handler:    _Openolt_HeartbeatCheck_Handler,
		},
		{
			MethodName: "EnablePonIf",
			Handler:    _Openolt_EnablePonIf_Handler,
		},
		{
			MethodName: "DisablePonIf",
			Handler:    _Openolt_DisablePonIf_Handler,
		},
		{
			MethodName: "GetDeviceInfo",
			Handler:    _Openolt_GetDeviceInfo_Handler,
		},
		{
			MethodName: "Reboot",
			Handler:    _Openolt_Reboot_Handler,
		},
		{
			MethodName: "CollectStatistics",
			Handler:    _Openolt_CollectStatistics_Handler,
		},
		{
			MethodName: "GetOnuStatistics",
			Handler:    _Openolt_GetOnuStatistics_Handler,
		},
		{
			MethodName: "GetGemPortStatistics",
			Handler:    _Openolt_GetGemPortStatistics_Handler,
		},
		{
			MethodName: "CreateTrafficSchedulers",
			Handler:    _Openolt_CreateTrafficSchedulers_Handler,
		},
		{
			MethodName: "RemoveTrafficSchedulers",
			Handler:    _Openolt_RemoveTrafficSchedulers_Handler,
		},
		{
			MethodName: "CreateTrafficQueues",
			Handler:    _Openolt_CreateTrafficQueues_Handler,
		},
		{
			MethodName: "RemoveTrafficQueues",
			Handler:    _Openolt_RemoveTrafficQueues_Handler,
		},
		{
			MethodName: "PerformGroupOperation",
			Handler:    _Openolt_PerformGroupOperation_Handler,
		},
		{
			MethodName: "DeleteGroup",
			Handler:    _Openolt_DeleteGroup_Handler,
		},
		{
			MethodName: "GetExtValue",
			Handler:    _Openolt_GetExtValue_Handler,
		},
		{
			MethodName: "OnuItuPonAlarmSet",
			Handler:    _Openolt_OnuItuPonAlarmSet_Handler,
		},
		{
			MethodName: "GetLogicalOnuDistanceZero",
			Handler:    _Openolt_GetLogicalOnuDistanceZero_Handler,
		},
		{
			MethodName: "GetLogicalOnuDistance",
			Handler:    _Openolt_GetLogicalOnuDistance_Handler,
		},
		{
			MethodName: "GetPonRxPower",
			Handler:    _Openolt_GetPonRxPower_Handler,
		},
		{
			MethodName: "GetOnuInfo",
			Handler:    _Openolt_GetOnuInfo_Handler,
		},
		{
			MethodName: "GetPonInterfaceInfo",
			Handler:    _Openolt_GetPonInterfaceInfo_Handler,
		},
		{
			MethodName: "GetAllocIdStatistics",
			Handler:    _Openolt_GetAllocIdStatistics_Handler,
		},
		{
			MethodName: "GetPonPortStatistics",
			Handler:    _Openolt_GetPonPortStatistics_Handler,
		},
		{
			MethodName: "GetNniPortStatistics",
			Handler:    _Openolt_GetNniPortStatistics_Handler,
		},
		{
			MethodName: "DisableOnu",
			Handler:    _Openolt_DisableOnu_Handler,
		},
		{
			MethodName: "EnableOnu",
			Handler:    _Openolt_EnableOnu_Handler,
		},
		{
			MethodName: "DisableOnuSerialNumber",
			Handler:    _Openolt_DisableOnuSerialNumber_Handler,
		},
		{
			MethodName: "EnableOnuSerialNumber",
			Handler:    _Openolt_EnableOnuSerialNumber_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "EnableIndication",
			Handler:       _Openolt_EnableIndication_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "voltha_protos/openolt.proto",
}
