// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/core.proto

package core

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	common "github.com/opencord/voltha-protos/v5/go/common"
	inter_container "github.com/opencord/voltha-protos/v5/go/inter_container"
	voltha "github.com/opencord/voltha-protos/v5/go/voltha"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Transient State for devices
type DeviceTransientState_Types int32

const (
	// The transient state of the device is not set
	DeviceTransientState_NONE DeviceTransientState_Types = 0
	// The state of the device in core is any state, i.e DELETING, DELETED, DELETE_FAILED, NONE.
	// This state is only used for transitions.
	DeviceTransientState_ANY DeviceTransientState_Types = 1
	// The device is in FORCE_DELETING state
	DeviceTransientState_FORCE_DELETING DeviceTransientState_Types = 2
	// The device is getting deleted from adapter state
	DeviceTransientState_DELETING_FROM_ADAPTER DeviceTransientState_Types = 3
	// The device is deleted from adapter and is getting deleted in core.
	DeviceTransientState_DELETING_POST_ADAPTER_RESPONSE DeviceTransientState_Types = 4
	// State to represent that the device deletion is failed
	DeviceTransientState_DELETE_FAILED DeviceTransientState_Types = 5
	// State to represent that reconcile is in progress
	DeviceTransientState_RECONCILE_IN_PROGRESS DeviceTransientState_Types = 6
)

var DeviceTransientState_Types_name = map[int32]string{
	0: "NONE",
	1: "ANY",
	2: "FORCE_DELETING",
	3: "DELETING_FROM_ADAPTER",
	4: "DELETING_POST_ADAPTER_RESPONSE",
	5: "DELETE_FAILED",
	6: "RECONCILE_IN_PROGRESS",
}

var DeviceTransientState_Types_value = map[string]int32{
	"NONE":                           0,
	"ANY":                            1,
	"FORCE_DELETING":                 2,
	"DELETING_FROM_ADAPTER":          3,
	"DELETING_POST_ADAPTER_RESPONSE": 4,
	"DELETE_FAILED":                  5,
	"RECONCILE_IN_PROGRESS":          6,
}

func (x DeviceTransientState_Types) String() string {
	return proto.EnumName(DeviceTransientState_Types_name, int32(x))
}

func (DeviceTransientState_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_39634f15fb8a505e, []int{0, 0}
}

type DeviceTransientState struct {
	TransientState       DeviceTransientState_Types `protobuf:"varint,1,opt,name=transient_state,json=transientState,proto3,enum=voltha.DeviceTransientState_Types" json:"transient_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *DeviceTransientState) Reset()         { *m = DeviceTransientState{} }
func (m *DeviceTransientState) String() string { return proto.CompactTextString(m) }
func (*DeviceTransientState) ProtoMessage()    {}
func (*DeviceTransientState) Descriptor() ([]byte, []int) {
	return fileDescriptor_39634f15fb8a505e, []int{0}
}

func (m *DeviceTransientState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceTransientState.Unmarshal(m, b)
}
func (m *DeviceTransientState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceTransientState.Marshal(b, m, deterministic)
}
func (m *DeviceTransientState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceTransientState.Merge(m, src)
}
func (m *DeviceTransientState) XXX_Size() int {
	return xxx_messageInfo_DeviceTransientState.Size(m)
}
func (m *DeviceTransientState) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceTransientState.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceTransientState proto.InternalMessageInfo

func (m *DeviceTransientState) GetTransientState() DeviceTransientState_Types {
	if m != nil {
		return m.TransientState
	}
	return DeviceTransientState_NONE
}

func init() {
	proto.RegisterEnum("voltha.DeviceTransientState_Types", DeviceTransientState_Types_name, DeviceTransientState_Types_value)
	proto.RegisterType((*DeviceTransientState)(nil), "voltha.DeviceTransientState")
}

func init() { proto.RegisterFile("voltha_protos/core.proto", fileDescriptor_39634f15fb8a505e) }

var fileDescriptor_39634f15fb8a505e = []byte{
	// 771 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x5d, 0x6f, 0xeb, 0x44,
	0x10, 0x25, 0xf7, 0xa3, 0x5c, 0xa6, 0x6d, 0xe2, 0xee, 0x4d, 0xb9, 0x6d, 0x2a, 0x55, 0x28, 0x3c,
	0xc0, 0x43, 0xeb, 0x88, 0x16, 0x2a, 0x44, 0x11, 0xc8, 0xb5, 0x9d, 0x34, 0x22, 0x4d, 0x2c, 0x3b,
	0x08, 0xc1, 0x8b, 0xe5, 0xda, 0x53, 0xc7, 0xc2, 0xf1, 0x46, 0xbb, 0xdb, 0x40, 0x1e, 0xf9, 0x1d,
	0xfc, 0x14, 0xfe, 0x1c, 0xb2, 0xd7, 0x4e, 0xed, 0x34, 0x96, 0x2a, 0xdd, 0xb7, 0x64, 0xce, 0x9c,
	0x33, 0x3b, 0x73, 0x76, 0xbc, 0x70, 0xb4, 0xa4, 0xb1, 0x98, 0x79, 0xee, 0x82, 0x51, 0x41, 0x79,
	0xcf, 0xa7, 0x0c, 0xd5, 0xec, 0x37, 0xd9, 0x91, 0x48, 0xe7, 0x24, 0xa4, 0x34, 0x8c, 0xb1, 0x97,
	0x45, 0xef, 0x1f, 0x1f, 0x7a, 0x38, 0x5f, 0x88, 0x95, 0x4c, 0xea, 0x7c, 0x59, 0xa5, 0x47, 0x89,
	0x40, 0xe6, 0xfa, 0x34, 0x11, 0x5e, 0x94, 0x20, 0xcb, 0x93, 0x3a, 0x9b, 0x35, 0xe6, 0x73, 0x9a,
	0x6c, 0xc7, 0x02, 0x5c, 0x46, 0x3e, 0x6e, 0xc7, 0x66, 0xe8, 0xc5, 0x62, 0x26, 0xb1, 0xee, 0x3f,
	0xaf, 0xa0, 0x6d, 0x64, 0xc9, 0x53, 0xe6, 0x25, 0x3c, 0xc2, 0x44, 0x38, 0xc2, 0x13, 0x48, 0x7e,
	0x81, 0x96, 0x28, 0x22, 0x2e, 0x4f, 0x43, 0x47, 0x8d, 0x2f, 0x1a, 0x5f, 0x37, 0x2f, 0xba, 0xaa,
	0x94, 0x53, 0xb7, 0xd1, 0xd4, 0xe9, 0x6a, 0x81, 0xdc, 0x6e, 0x8a, 0x4a, 0xb4, 0xfb, 0x6f, 0x03,
	0xde, 0x66, 0x08, 0x79, 0x07, 0x6f, 0xc6, 0x93, 0xb1, 0xa9, 0x7c, 0x42, 0x3e, 0x85, 0xd7, 0xda,
	0xf8, 0x77, 0xa5, 0x41, 0x08, 0x34, 0xfb, 0x13, 0x5b, 0x37, 0x5d, 0xc3, 0x1c, 0x99, 0xd3, 0xe1,
	0x78, 0xa0, 0xbc, 0x22, 0xc7, 0x70, 0x58, 0xfc, 0x73, 0xfb, 0xf6, 0xe4, 0xce, 0xd5, 0x0c, 0xcd,
	0x9a, 0x9a, 0xb6, 0xf2, 0x9a, 0x74, 0xe1, 0x74, 0x0d, 0x59, 0x13, 0x67, 0x5a, 0x40, 0xae, 0x6d,
	0x3a, 0xd6, 0x64, 0xec, 0x98, 0xca, 0x1b, 0x72, 0x00, 0xfb, 0x59, 0x8e, 0xe9, 0xf6, 0xb5, 0xe1,
	0xc8, 0x34, 0x94, 0xb7, 0xa9, 0xa2, 0x6d, 0xea, 0x93, 0xb1, 0x3e, 0x1c, 0x99, 0xee, 0x70, 0xec,
	0x5a, 0xf6, 0x64, 0x60, 0x9b, 0x8e, 0xa3, 0xec, 0x5c, 0xfc, 0xb7, 0x0b, 0xbb, 0x3a, 0x65, 0xe8,
	0x20, 0x4b, 0x3b, 0x22, 0x3f, 0x43, 0x6b, 0x80, 0xe2, 0x36, 0x1b, 0x53, 0x7a, 0xfe, 0x47, 0x4e,
	0x3e, 0x57, 0xa5, 0x7b, 0x6a, 0xe1, 0x9e, 0x6a, 0xa6, 0xee, 0x75, 0xda, 0xc5, 0x30, 0x2a, 0xd9,
	0x7d, 0x68, 0xd9, 0x18, 0x46, 0x5c, 0x20, 0xd3, 0x02, 0x6f, 0x21, 0x90, 0x91, 0x93, 0x22, 0x31,
	0x0f, 0x48, 0x9c, 0x79, 0x22, 0xa2, 0x49, 0xa7, 0x46, 0x9d, 0x5c, 0xc1, 0x9e, 0x1c, 0xf2, 0xaf,
	0x8b, 0x20, 0xf5, 0xa4, 0x59, 0x1d, 0x7d, 0x2d, 0xef, 0x12, 0x76, 0x2d, 0xca, 0x84, 0xce, 0xd0,
	0x13, 0x18, 0x90, 0xbd, 0x82, 0x96, 0x06, 0x6b, 0x49, 0x3a, 0x28, 0x29, 0xce, 0x33, 0xc7, 0xf2,
	0x82, 0x1f, 0xca, 0xcc, 0x0c, 0xe8, 0x47, 0xb1, 0x40, 0x56, 0x2b, 0xf2, 0x2d, 0x34, 0x0d, 0x8c,
	0x51, 0xa0, 0x16, 0xc7, 0x99, 0x1a, 0x01, 0x35, 0xbf, 0xa7, 0x43, 0xa3, 0x96, 0xf5, 0x0d, 0xec,
	0x0f, 0x50, 0xc8, 0xa6, 0x52, 0x16, 0x21, 0xe5, 0xba, 0x79, 0xc9, 0x4a, 0x17, 0xe4, 0x0c, 0x5a,
	0xa3, 0x88, 0x97, 0x38, 0xd5, 0x4a, 0xfb, 0xe5, 0xe4, 0xd4, 0x90, 0x03, 0x99, 0x59, 0x6e, 0xee,
	0xb8, 0x3a, 0xcd, 0x97, 0xb4, 0xa7, 0x15, 0xcb, 0x62, 0xdd, 0xe9, 0x34, 0x79, 0x88, 0xc2, 0x5c,
	0xea, 0x60, 0x5d, 0x6e, 0x2e, 0xe3, 0xbc, 0x56, 0xe2, 0x27, 0x78, 0xaf, 0xcf, 0xa2, 0x38, 0x90,
	0x3a, 0x06, 0x0a, 0xf4, 0x53, 0x8f, 0x3e, 0x54, 0x0f, 0x63, 0x44, 0xdc, 0xa7, 0x4b, 0x64, 0xab,
	0xce, 0x86, 0xe7, 0xe4, 0x0a, 0x94, 0x12, 0x9f, 0x8f, 0x28, 0x17, 0x2f, 0x9a, 0xf1, 0x0f, 0xd0,
	0x2e, 0xf3, 0xd6, 0x85, 0x5f, 0xc2, 0xfd, 0x0a, 0x3e, 0x5b, 0xfb, 0x53, 0x21, 0x6c, 0x1e, 0xee,
	0x1a, 0x9a, 0x03, 0x14, 0xa5, 0x3a, 0x4f, 0x43, 0x2e, 0x05, 0xf3, 0x21, 0x6f, 0x92, 0xd5, 0x6c,
	0xed, 0xca, 0x87, 0xac, 0xd4, 0x6a, 0x55, 0xd3, 0x39, 0xf9, 0x1e, 0xf6, 0x1c, 0x4c, 0x02, 0xcb,
	0xf3, 0xff, 0x44, 0x31, 0x4c, 0x88, 0xb2, 0x36, 0x21, 0x8f, 0xd4, 0xf6, 0x73, 0x03, 0x44, 0x8a,
	0xd8, 0xe8, 0x71, 0x9a, 0xe4, 0x26, 0xb6, 0xab, 0x05, 0x24, 0x56, 0xab, 0xf1, 0x23, 0xb4, 0xd6,
	0x4b, 0xf1, 0xec, 0x16, 0x14, 0x40, 0x2d, 0xfb, 0x1a, 0x0e, 0x6d, 0xf4, 0x69, 0xe2, 0x47, 0x31,
	0xd6, 0x76, 0x5c, 0x47, 0xbe, 0x83, 0xd3, 0xea, 0xa0, 0x7e, 0x8b, 0xc4, 0xcc, 0x62, 0xf4, 0xef,
	0x95, 0x16, 0x04, 0x0c, 0x39, 0x7f, 0xfa, 0xda, 0x48, 0x5c, 0x2d, 0x83, 0xcf, 0xe6, 0x7e, 0x0e,
	0xef, 0x06, 0x28, 0xe4, 0xa2, 0x6c, 0x5b, 0xbc, 0x8d, 0x5d, 0xba, 0xcd, 0x2f, 0x30, 0xc3, 0xe4,
	0x23, 0xb7, 0xc9, 0x80, 0xf7, 0x92, 0x3c, 0x9c, 0x7b, 0x21, 0x1a, 0xf4, 0xaf, 0x24, 0xa6, 0x5e,
	0x40, 0x0e, 0x0b, 0xa5, 0x4a, 0xb8, 0x4e, 0xe5, 0xe6, 0x16, 0x8e, 0x28, 0x0b, 0x55, 0xba, 0xc0,
	0xc4, 0xa7, 0x2c, 0x28, 0xc8, 0xe9, 0x0b, 0xfc, 0xc7, 0x59, 0x18, 0x89, 0xd9, 0xe3, 0x7d, 0x3a,
	0xd3, 0x5e, 0x91, 0xd0, 0x93, 0x09, 0xe7, 0xf9, 0x6b, 0xb8, 0xfc, 0xae, 0x17, 0xd2, 0xec, 0xbd,
	0xbe, 0xdf, 0xc9, 0x42, 0x97, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x60, 0x7e, 0xd5, 0xfd, 0xcc,
	0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CoreServiceClient is the client API for CoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CoreServiceClient interface {
	//	 in coreProxy interface
	GetHealthStatus(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*voltha.HealthStatus, error)
	RegisterAdapter(ctx context.Context, in *inter_container.AdapterRegistration, opts ...grpc.CallOption) (*empty.Empty, error)
	DeviceUpdate(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error)
	PortCreated(ctx context.Context, in *voltha.Port, opts ...grpc.CallOption) (*empty.Empty, error)
	PortsStateUpdate(ctx context.Context, in *inter_container.PortStateFilter, opts ...grpc.CallOption) (*empty.Empty, error)
	DeleteAllPorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	GetDevicePort(ctx context.Context, in *inter_container.PortFilter, opts ...grpc.CallOption) (*voltha.Port, error)
	ListDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Ports, error)
	DeviceStateUpdate(ctx context.Context, in *inter_container.DeviceStateFilter, opts ...grpc.CallOption) (*empty.Empty, error)
	DevicePMConfigUpdate(ctx context.Context, in *voltha.PmConfigs, opts ...grpc.CallOption) (*empty.Empty, error)
	ChildDeviceDetected(ctx context.Context, in *inter_container.DeviceDiscovery, opts ...grpc.CallOption) (*voltha.Device, error)
	ChildDevicesLost(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	ChildDevicesDetected(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	GetDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Device, error)
	GetChildDevice(ctx context.Context, in *inter_container.ChildDeviceFilter, opts ...grpc.CallOption) (*voltha.Device, error)
	GetChildDevices(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Devices, error)
	SendPacketIn(ctx context.Context, in *inter_container.PacketIn, opts ...grpc.CallOption) (*empty.Empty, error)
	DeviceReasonUpdate(ctx context.Context, in *inter_container.DeviceReason, opts ...grpc.CallOption) (*empty.Empty, error)
	PortStateUpdate(ctx context.Context, in *inter_container.PortState, opts ...grpc.CallOption) (*empty.Empty, error)
	// Additional API found in the Core - unused?
	ReconcileChildDevices(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	GetChildDeviceWithProxyAddress(ctx context.Context, in *voltha.Device_ProxyAddress, opts ...grpc.CallOption) (*voltha.Device, error)
	GetPorts(ctx context.Context, in *inter_container.PortFilter, opts ...grpc.CallOption) (*voltha.Ports, error)
	ChildrenStateUpdate(ctx context.Context, in *inter_container.DeviceStateFilter, opts ...grpc.CallOption) (*empty.Empty, error)
	UpdateImageDownload(ctx context.Context, in *voltha.ImageDownload, opts ...grpc.CallOption) (*empty.Empty, error)
}

type coreServiceClient struct {
	cc *grpc.ClientConn
}

func NewCoreServiceClient(cc *grpc.ClientConn) CoreServiceClient {
	return &coreServiceClient{cc}
}

func (c *coreServiceClient) GetHealthStatus(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*voltha.HealthStatus, error) {
	out := new(voltha.HealthStatus)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/GetHealthStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) RegisterAdapter(ctx context.Context, in *inter_container.AdapterRegistration, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/RegisterAdapter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DeviceUpdate(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/DeviceUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) PortCreated(ctx context.Context, in *voltha.Port, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/PortCreated", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) PortsStateUpdate(ctx context.Context, in *inter_container.PortStateFilter, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/PortsStateUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DeleteAllPorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/DeleteAllPorts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetDevicePort(ctx context.Context, in *inter_container.PortFilter, opts ...grpc.CallOption) (*voltha.Port, error) {
	out := new(voltha.Port)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/GetDevicePort", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ListDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Ports, error) {
	out := new(voltha.Ports)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/ListDevicePorts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DeviceStateUpdate(ctx context.Context, in *inter_container.DeviceStateFilter, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/DeviceStateUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DevicePMConfigUpdate(ctx context.Context, in *voltha.PmConfigs, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/DevicePMConfigUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ChildDeviceDetected(ctx context.Context, in *inter_container.DeviceDiscovery, opts ...grpc.CallOption) (*voltha.Device, error) {
	out := new(voltha.Device)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/ChildDeviceDetected", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ChildDevicesLost(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/ChildDevicesLost", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ChildDevicesDetected(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/ChildDevicesDetected", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Device, error) {
	out := new(voltha.Device)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/GetDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetChildDevice(ctx context.Context, in *inter_container.ChildDeviceFilter, opts ...grpc.CallOption) (*voltha.Device, error) {
	out := new(voltha.Device)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/GetChildDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetChildDevices(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Devices, error) {
	out := new(voltha.Devices)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/GetChildDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) SendPacketIn(ctx context.Context, in *inter_container.PacketIn, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/SendPacketIn", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DeviceReasonUpdate(ctx context.Context, in *inter_container.DeviceReason, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/DeviceReasonUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) PortStateUpdate(ctx context.Context, in *inter_container.PortState, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/PortStateUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ReconcileChildDevices(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/ReconcileChildDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetChildDeviceWithProxyAddress(ctx context.Context, in *voltha.Device_ProxyAddress, opts ...grpc.CallOption) (*voltha.Device, error) {
	out := new(voltha.Device)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/GetChildDeviceWithProxyAddress", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetPorts(ctx context.Context, in *inter_container.PortFilter, opts ...grpc.CallOption) (*voltha.Ports, error) {
	out := new(voltha.Ports)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/GetPorts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ChildrenStateUpdate(ctx context.Context, in *inter_container.DeviceStateFilter, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/ChildrenStateUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) UpdateImageDownload(ctx context.Context, in *voltha.ImageDownload, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.CoreService/UpdateImageDownload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CoreServiceServer is the server API for CoreService service.
type CoreServiceServer interface {
	//	 in coreProxy interface
	GetHealthStatus(context.Context, *empty.Empty) (*voltha.HealthStatus, error)
	RegisterAdapter(context.Context, *inter_container.AdapterRegistration) (*empty.Empty, error)
	DeviceUpdate(context.Context, *voltha.Device) (*empty.Empty, error)
	PortCreated(context.Context, *voltha.Port) (*empty.Empty, error)
	PortsStateUpdate(context.Context, *inter_container.PortStateFilter) (*empty.Empty, error)
	DeleteAllPorts(context.Context, *common.ID) (*empty.Empty, error)
	GetDevicePort(context.Context, *inter_container.PortFilter) (*voltha.Port, error)
	ListDevicePorts(context.Context, *common.ID) (*voltha.Ports, error)
	DeviceStateUpdate(context.Context, *inter_container.DeviceStateFilter) (*empty.Empty, error)
	DevicePMConfigUpdate(context.Context, *voltha.PmConfigs) (*empty.Empty, error)
	ChildDeviceDetected(context.Context, *inter_container.DeviceDiscovery) (*voltha.Device, error)
	ChildDevicesLost(context.Context, *common.ID) (*empty.Empty, error)
	ChildDevicesDetected(context.Context, *common.ID) (*empty.Empty, error)
	GetDevice(context.Context, *common.ID) (*voltha.Device, error)
	GetChildDevice(context.Context, *inter_container.ChildDeviceFilter) (*voltha.Device, error)
	GetChildDevices(context.Context, *common.ID) (*voltha.Devices, error)
	SendPacketIn(context.Context, *inter_container.PacketIn) (*empty.Empty, error)
	DeviceReasonUpdate(context.Context, *inter_container.DeviceReason) (*empty.Empty, error)
	PortStateUpdate(context.Context, *inter_container.PortState) (*empty.Empty, error)
	// Additional API found in the Core - unused?
	ReconcileChildDevices(context.Context, *common.ID) (*empty.Empty, error)
	GetChildDeviceWithProxyAddress(context.Context, *voltha.Device_ProxyAddress) (*voltha.Device, error)
	GetPorts(context.Context, *inter_container.PortFilter) (*voltha.Ports, error)
	ChildrenStateUpdate(context.Context, *inter_container.DeviceStateFilter) (*empty.Empty, error)
	UpdateImageDownload(context.Context, *voltha.ImageDownload) (*empty.Empty, error)
}

// UnimplementedCoreServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCoreServiceServer struct {
}

func (*UnimplementedCoreServiceServer) GetHealthStatus(ctx context.Context, req *empty.Empty) (*voltha.HealthStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHealthStatus not implemented")
}
func (*UnimplementedCoreServiceServer) RegisterAdapter(ctx context.Context, req *inter_container.AdapterRegistration) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterAdapter not implemented")
}
func (*UnimplementedCoreServiceServer) DeviceUpdate(ctx context.Context, req *voltha.Device) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeviceUpdate not implemented")
}
func (*UnimplementedCoreServiceServer) PortCreated(ctx context.Context, req *voltha.Port) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PortCreated not implemented")
}
func (*UnimplementedCoreServiceServer) PortsStateUpdate(ctx context.Context, req *inter_container.PortStateFilter) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PortsStateUpdate not implemented")
}
func (*UnimplementedCoreServiceServer) DeleteAllPorts(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAllPorts not implemented")
}
func (*UnimplementedCoreServiceServer) GetDevicePort(ctx context.Context, req *inter_container.PortFilter) (*voltha.Port, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDevicePort not implemented")
}
func (*UnimplementedCoreServiceServer) ListDevicePorts(ctx context.Context, req *common.ID) (*voltha.Ports, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDevicePorts not implemented")
}
func (*UnimplementedCoreServiceServer) DeviceStateUpdate(ctx context.Context, req *inter_container.DeviceStateFilter) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeviceStateUpdate not implemented")
}
func (*UnimplementedCoreServiceServer) DevicePMConfigUpdate(ctx context.Context, req *voltha.PmConfigs) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DevicePMConfigUpdate not implemented")
}
func (*UnimplementedCoreServiceServer) ChildDeviceDetected(ctx context.Context, req *inter_container.DeviceDiscovery) (*voltha.Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChildDeviceDetected not implemented")
}
func (*UnimplementedCoreServiceServer) ChildDevicesLost(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChildDevicesLost not implemented")
}
func (*UnimplementedCoreServiceServer) ChildDevicesDetected(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChildDevicesDetected not implemented")
}
func (*UnimplementedCoreServiceServer) GetDevice(ctx context.Context, req *common.ID) (*voltha.Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDevice not implemented")
}
func (*UnimplementedCoreServiceServer) GetChildDevice(ctx context.Context, req *inter_container.ChildDeviceFilter) (*voltha.Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChildDevice not implemented")
}
func (*UnimplementedCoreServiceServer) GetChildDevices(ctx context.Context, req *common.ID) (*voltha.Devices, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChildDevices not implemented")
}
func (*UnimplementedCoreServiceServer) SendPacketIn(ctx context.Context, req *inter_container.PacketIn) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendPacketIn not implemented")
}
func (*UnimplementedCoreServiceServer) DeviceReasonUpdate(ctx context.Context, req *inter_container.DeviceReason) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeviceReasonUpdate not implemented")
}
func (*UnimplementedCoreServiceServer) PortStateUpdate(ctx context.Context, req *inter_container.PortState) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PortStateUpdate not implemented")
}
func (*UnimplementedCoreServiceServer) ReconcileChildDevices(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReconcileChildDevices not implemented")
}
func (*UnimplementedCoreServiceServer) GetChildDeviceWithProxyAddress(ctx context.Context, req *voltha.Device_ProxyAddress) (*voltha.Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChildDeviceWithProxyAddress not implemented")
}
func (*UnimplementedCoreServiceServer) GetPorts(ctx context.Context, req *inter_container.PortFilter) (*voltha.Ports, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPorts not implemented")
}
func (*UnimplementedCoreServiceServer) ChildrenStateUpdate(ctx context.Context, req *inter_container.DeviceStateFilter) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChildrenStateUpdate not implemented")
}
func (*UnimplementedCoreServiceServer) UpdateImageDownload(ctx context.Context, req *voltha.ImageDownload) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateImageDownload not implemented")
}

func RegisterCoreServiceServer(s *grpc.Server, srv CoreServiceServer) {
	s.RegisterService(&_CoreService_serviceDesc, srv)
}

func _CoreService_GetHealthStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetHealthStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/GetHealthStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetHealthStatus(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_RegisterAdapter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.AdapterRegistration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).RegisterAdapter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/RegisterAdapter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).RegisterAdapter(ctx, req.(*inter_container.AdapterRegistration))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DeviceUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.Device)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DeviceUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/DeviceUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DeviceUpdate(ctx, req.(*voltha.Device))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_PortCreated_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.Port)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).PortCreated(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/PortCreated",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).PortCreated(ctx, req.(*voltha.Port))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_PortsStateUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.PortStateFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).PortsStateUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/PortsStateUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).PortsStateUpdate(ctx, req.(*inter_container.PortStateFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DeleteAllPorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DeleteAllPorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/DeleteAllPorts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DeleteAllPorts(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetDevicePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.PortFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetDevicePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/GetDevicePort",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetDevicePort(ctx, req.(*inter_container.PortFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ListDevicePorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ListDevicePorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/ListDevicePorts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ListDevicePorts(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DeviceStateUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.DeviceStateFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DeviceStateUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/DeviceStateUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DeviceStateUpdate(ctx, req.(*inter_container.DeviceStateFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DevicePMConfigUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.PmConfigs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DevicePMConfigUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/DevicePMConfigUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DevicePMConfigUpdate(ctx, req.(*voltha.PmConfigs))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ChildDeviceDetected_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.DeviceDiscovery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ChildDeviceDetected(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/ChildDeviceDetected",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ChildDeviceDetected(ctx, req.(*inter_container.DeviceDiscovery))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ChildDevicesLost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ChildDevicesLost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/ChildDevicesLost",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ChildDevicesLost(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ChildDevicesDetected_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ChildDevicesDetected(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/ChildDevicesDetected",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ChildDevicesDetected(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/GetDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetChildDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.ChildDeviceFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetChildDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/GetChildDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetChildDevice(ctx, req.(*inter_container.ChildDeviceFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetChildDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetChildDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/GetChildDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetChildDevices(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_SendPacketIn_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.PacketIn)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).SendPacketIn(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/SendPacketIn",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).SendPacketIn(ctx, req.(*inter_container.PacketIn))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DeviceReasonUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.DeviceReason)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DeviceReasonUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/DeviceReasonUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DeviceReasonUpdate(ctx, req.(*inter_container.DeviceReason))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_PortStateUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.PortState)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).PortStateUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/PortStateUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).PortStateUpdate(ctx, req.(*inter_container.PortState))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ReconcileChildDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ReconcileChildDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/ReconcileChildDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ReconcileChildDevices(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetChildDeviceWithProxyAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.Device_ProxyAddress)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetChildDeviceWithProxyAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/GetChildDeviceWithProxyAddress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetChildDeviceWithProxyAddress(ctx, req.(*voltha.Device_ProxyAddress))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetPorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.PortFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetPorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/GetPorts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetPorts(ctx, req.(*inter_container.PortFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ChildrenStateUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(inter_container.DeviceStateFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ChildrenStateUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/ChildrenStateUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ChildrenStateUpdate(ctx, req.(*inter_container.DeviceStateFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_UpdateImageDownload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).UpdateImageDownload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.CoreService/UpdateImageDownload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).UpdateImageDownload(ctx, req.(*voltha.ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

var _CoreService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "voltha.CoreService",
	HandlerType: (*CoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetHealthStatus",
			Handler:    _CoreService_GetHealthStatus_Handler,
		},
		{
			MethodName: "RegisterAdapter",
			Handler:    _CoreService_RegisterAdapter_Handler,
		},
		{
			MethodName: "DeviceUpdate",
			Handler:    _CoreService_DeviceUpdate_Handler,
		},
		{
			MethodName: "PortCreated",
			Handler:    _CoreService_PortCreated_Handler,
		},
		{
			MethodName: "PortsStateUpdate",
			Handler:    _CoreService_PortsStateUpdate_Handler,
		},
		{
			MethodName: "DeleteAllPorts",
			Handler:    _CoreService_DeleteAllPorts_Handler,
		},
		{
			MethodName: "GetDevicePort",
			Handler:    _CoreService_GetDevicePort_Handler,
		},
		{
			MethodName: "ListDevicePorts",
			Handler:    _CoreService_ListDevicePorts_Handler,
		},
		{
			MethodName: "DeviceStateUpdate",
			Handler:    _CoreService_DeviceStateUpdate_Handler,
		},
		{
			MethodName: "DevicePMConfigUpdate",
			Handler:    _CoreService_DevicePMConfigUpdate_Handler,
		},
		{
			MethodName: "ChildDeviceDetected",
			Handler:    _CoreService_ChildDeviceDetected_Handler,
		},
		{
			MethodName: "ChildDevicesLost",
			Handler:    _CoreService_ChildDevicesLost_Handler,
		},
		{
			MethodName: "ChildDevicesDetected",
			Handler:    _CoreService_ChildDevicesDetected_Handler,
		},
		{
			MethodName: "GetDevice",
			Handler:    _CoreService_GetDevice_Handler,
		},
		{
			MethodName: "GetChildDevice",
			Handler:    _CoreService_GetChildDevice_Handler,
		},
		{
			MethodName: "GetChildDevices",
			Handler:    _CoreService_GetChildDevices_Handler,
		},
		{
			MethodName: "SendPacketIn",
			Handler:    _CoreService_SendPacketIn_Handler,
		},
		{
			MethodName: "DeviceReasonUpdate",
			Handler:    _CoreService_DeviceReasonUpdate_Handler,
		},
		{
			MethodName: "PortStateUpdate",
			Handler:    _CoreService_PortStateUpdate_Handler,
		},
		{
			MethodName: "ReconcileChildDevices",
			Handler:    _CoreService_ReconcileChildDevices_Handler,
		},
		{
			MethodName: "GetChildDeviceWithProxyAddress",
			Handler:    _CoreService_GetChildDeviceWithProxyAddress_Handler,
		},
		{
			MethodName: "GetPorts",
			Handler:    _CoreService_GetPorts_Handler,
		},
		{
			MethodName: "ChildrenStateUpdate",
			Handler:    _CoreService_ChildrenStateUpdate_Handler,
		},
		{
			MethodName: "UpdateImageDownload",
			Handler:    _CoreService_UpdateImageDownload_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "voltha_protos/core.proto",
}
