/*
 * Copyright 2021-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Code generated by MockGen. DO NOT EDIT.
// Source: ./adapter_services.pb.go

package grpc

import (
	context "context"
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	empty "github.com/golang/protobuf/ptypes/empty"
	common "github.com/opencord/voltha-protos/v5/go/common"
	extension "github.com/opencord/voltha-protos/v5/go/extension"
	inter_container "github.com/opencord/voltha-protos/v5/go/inter_container"
	voltha "github.com/opencord/voltha-protos/v5/go/voltha"
	grpc "google.golang.org/grpc"
)

// MockAdapterServiceClient is a mock of AdapterServiceClient interface.
type MockAdapterServiceClient struct {
	ctrl     *gomock.Controller
	recorder *MockAdapterServiceClientMockRecorder
}

// MockAdapterServiceClientMockRecorder is the mock recorder for MockAdapterServiceClient.
type MockAdapterServiceClientMockRecorder struct {
	mock *MockAdapterServiceClient
}

// NewMockAdapterServiceClient creates a new mock instance.
func NewMockAdapterServiceClient(ctrl *gomock.Controller) *MockAdapterServiceClient {
	mock := &MockAdapterServiceClient{ctrl: ctrl}
	mock.recorder = &MockAdapterServiceClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockAdapterServiceClient) EXPECT() *MockAdapterServiceClientMockRecorder {
	return m.recorder
}

// AbortOnuImageUpgrade mocks base method.
func (m *MockAdapterServiceClient) AbortOnuImageUpgrade(ctx context.Context, in *voltha.DeviceImageRequest, opts ...grpc.CallOption) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AbortOnuImageUpgrade", varargs...)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AbortOnuImageUpgrade indicates an expected call of AbortOnuImageUpgrade.
func (mr *MockAdapterServiceClientMockRecorder) AbortOnuImageUpgrade(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AbortOnuImageUpgrade", reflect.TypeOf((*MockAdapterServiceClient)(nil).AbortOnuImageUpgrade), varargs...)
}

// ActivateImageUpdate mocks base method.
func (m *MockAdapterServiceClient) ActivateImageUpdate(ctx context.Context, in *inter_container.ImageDownloadMessage, opts ...grpc.CallOption) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ActivateImageUpdate", varargs...)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ActivateImageUpdate indicates an expected call of ActivateImageUpdate.
func (mr *MockAdapterServiceClientMockRecorder) ActivateImageUpdate(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActivateImageUpdate", reflect.TypeOf((*MockAdapterServiceClient)(nil).ActivateImageUpdate), varargs...)
}

// ActivateOnuImage mocks base method.
func (m *MockAdapterServiceClient) ActivateOnuImage(ctx context.Context, in *voltha.DeviceImageRequest, opts ...grpc.CallOption) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ActivateOnuImage", varargs...)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ActivateOnuImage indicates an expected call of ActivateOnuImage.
func (mr *MockAdapterServiceClientMockRecorder) ActivateOnuImage(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActivateOnuImage", reflect.TypeOf((*MockAdapterServiceClient)(nil).ActivateOnuImage), varargs...)
}

// AdoptDevice mocks base method.
func (m *MockAdapterServiceClient) AdoptDevice(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AdoptDevice", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AdoptDevice indicates an expected call of AdoptDevice.
func (mr *MockAdapterServiceClientMockRecorder) AdoptDevice(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AdoptDevice", reflect.TypeOf((*MockAdapterServiceClient)(nil).AdoptDevice), varargs...)
}

// CancelImageDownload mocks base method.
func (m *MockAdapterServiceClient) CancelImageDownload(ctx context.Context, in *inter_container.ImageDownloadMessage, opts ...grpc.CallOption) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelImageDownload", varargs...)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelImageDownload indicates an expected call of CancelImageDownload.
func (mr *MockAdapterServiceClientMockRecorder) CancelImageDownload(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelImageDownload", reflect.TypeOf((*MockAdapterServiceClient)(nil).CancelImageDownload), varargs...)
}

// ChildDeviceLost mocks base method.
func (m *MockAdapterServiceClient) ChildDeviceLost(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ChildDeviceLost", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ChildDeviceLost indicates an expected call of ChildDeviceLost.
func (mr *MockAdapterServiceClientMockRecorder) ChildDeviceLost(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ChildDeviceLost", reflect.TypeOf((*MockAdapterServiceClient)(nil).ChildDeviceLost), varargs...)
}

// CommitOnuImage mocks base method.
func (m *MockAdapterServiceClient) CommitOnuImage(ctx context.Context, in *voltha.DeviceImageRequest, opts ...grpc.CallOption) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CommitOnuImage", varargs...)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CommitOnuImage indicates an expected call of CommitOnuImage.
func (mr *MockAdapterServiceClientMockRecorder) CommitOnuImage(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CommitOnuImage", reflect.TypeOf((*MockAdapterServiceClient)(nil).CommitOnuImage), varargs...)
}

// DeleteDevice mocks base method.
func (m *MockAdapterServiceClient) DeleteDevice(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteDevice", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteDevice indicates an expected call of DeleteDevice.
func (mr *MockAdapterServiceClientMockRecorder) DeleteDevice(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteDevice", reflect.TypeOf((*MockAdapterServiceClient)(nil).DeleteDevice), varargs...)
}

// DisableDevice mocks base method.
func (m *MockAdapterServiceClient) DisableDevice(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisableDevice", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableDevice indicates an expected call of DisableDevice.
func (mr *MockAdapterServiceClientMockRecorder) DisableDevice(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableDevice", reflect.TypeOf((*MockAdapterServiceClient)(nil).DisableDevice), varargs...)
}

// DisablePort mocks base method.
func (m *MockAdapterServiceClient) DisablePort(ctx context.Context, in *voltha.Port, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisablePort", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisablePort indicates an expected call of DisablePort.
func (mr *MockAdapterServiceClientMockRecorder) DisablePort(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisablePort", reflect.TypeOf((*MockAdapterServiceClient)(nil).DisablePort), varargs...)
}

// DownloadImage mocks base method.
func (m *MockAdapterServiceClient) DownloadImage(ctx context.Context, in *inter_container.ImageDownloadMessage, opts ...grpc.CallOption) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DownloadImage", varargs...)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DownloadImage indicates an expected call of DownloadImage.
func (mr *MockAdapterServiceClientMockRecorder) DownloadImage(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DownloadImage", reflect.TypeOf((*MockAdapterServiceClient)(nil).DownloadImage), varargs...)
}

// DownloadOnuImage mocks base method.
func (m *MockAdapterServiceClient) DownloadOnuImage(ctx context.Context, in *voltha.DeviceImageDownloadRequest, opts ...grpc.CallOption) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DownloadOnuImage", varargs...)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DownloadOnuImage indicates an expected call of DownloadOnuImage.
func (mr *MockAdapterServiceClientMockRecorder) DownloadOnuImage(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DownloadOnuImage", reflect.TypeOf((*MockAdapterServiceClient)(nil).DownloadOnuImage), varargs...)
}

// EnablePort mocks base method.
func (m *MockAdapterServiceClient) EnablePort(ctx context.Context, in *voltha.Port, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EnablePort", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnablePort indicates an expected call of EnablePort.
func (mr *MockAdapterServiceClientMockRecorder) EnablePort(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnablePort", reflect.TypeOf((*MockAdapterServiceClient)(nil).EnablePort), varargs...)
}

// GetExtValue mocks base method.
func (m *MockAdapterServiceClient) GetExtValue(ctx context.Context, in *inter_container.GetExtValueMessage, opts ...grpc.CallOption) (*common.ReturnValues, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetExtValue", varargs...)
	ret0, _ := ret[0].(*common.ReturnValues)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetExtValue indicates an expected call of GetExtValue.
func (mr *MockAdapterServiceClientMockRecorder) GetExtValue(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetExtValue", reflect.TypeOf((*MockAdapterServiceClient)(nil).GetExtValue), varargs...)
}

// GetHealthStatus mocks base method.
func (m *MockAdapterServiceClient) GetHealthStatus(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*voltha.HealthStatus, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetHealthStatus", varargs...)
	ret0, _ := ret[0].(*voltha.HealthStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHealthStatus indicates an expected call of GetHealthStatus.
func (mr *MockAdapterServiceClientMockRecorder) GetHealthStatus(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHealthStatus", reflect.TypeOf((*MockAdapterServiceClient)(nil).GetHealthStatus), varargs...)
}

// GetImageDownloadStatus mocks base method.
func (m *MockAdapterServiceClient) GetImageDownloadStatus(ctx context.Context, in *inter_container.ImageDownloadMessage, opts ...grpc.CallOption) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetImageDownloadStatus", varargs...)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetImageDownloadStatus indicates an expected call of GetImageDownloadStatus.
func (mr *MockAdapterServiceClientMockRecorder) GetImageDownloadStatus(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetImageDownloadStatus", reflect.TypeOf((*MockAdapterServiceClient)(nil).GetImageDownloadStatus), varargs...)
}

// GetOfpDeviceInfo mocks base method.
func (m *MockAdapterServiceClient) GetOfpDeviceInfo(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*inter_container.SwitchCapability, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetOfpDeviceInfo", varargs...)
	ret0, _ := ret[0].(*inter_container.SwitchCapability)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOfpDeviceInfo indicates an expected call of GetOfpDeviceInfo.
func (mr *MockAdapterServiceClientMockRecorder) GetOfpDeviceInfo(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOfpDeviceInfo", reflect.TypeOf((*MockAdapterServiceClient)(nil).GetOfpDeviceInfo), varargs...)
}

// GetOnuImageStatus mocks base method.
func (m *MockAdapterServiceClient) GetOnuImageStatus(ctx context.Context, in *voltha.DeviceImageRequest, opts ...grpc.CallOption) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetOnuImageStatus", varargs...)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOnuImageStatus indicates an expected call of GetOnuImageStatus.
func (mr *MockAdapterServiceClientMockRecorder) GetOnuImageStatus(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOnuImageStatus", reflect.TypeOf((*MockAdapterServiceClient)(nil).GetOnuImageStatus), varargs...)
}

// GetOnuImages mocks base method.
func (m *MockAdapterServiceClient) GetOnuImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.OnuImages, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetOnuImages", varargs...)
	ret0, _ := ret[0].(*voltha.OnuImages)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOnuImages indicates an expected call of GetOnuImages.
func (mr *MockAdapterServiceClientMockRecorder) GetOnuImages(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOnuImages", reflect.TypeOf((*MockAdapterServiceClient)(nil).GetOnuImages), varargs...)
}

// GetSingleValue mocks base method.
func (m *MockAdapterServiceClient) GetSingleValue(ctx context.Context, in *extension.SingleGetValueRequest, opts ...grpc.CallOption) (*extension.SingleGetValueResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetSingleValue", varargs...)
	ret0, _ := ret[0].(*extension.SingleGetValueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSingleValue indicates an expected call of GetSingleValue.
func (mr *MockAdapterServiceClientMockRecorder) GetSingleValue(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSingleValue", reflect.TypeOf((*MockAdapterServiceClient)(nil).GetSingleValue), varargs...)
}

// ReEnableDevice mocks base method.
func (m *MockAdapterServiceClient) ReEnableDevice(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ReEnableDevice", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReEnableDevice indicates an expected call of ReEnableDevice.
func (mr *MockAdapterServiceClientMockRecorder) ReEnableDevice(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReEnableDevice", reflect.TypeOf((*MockAdapterServiceClient)(nil).ReEnableDevice), varargs...)
}

// RebootDevice mocks base method.
func (m *MockAdapterServiceClient) RebootDevice(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RebootDevice", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RebootDevice indicates an expected call of RebootDevice.
func (mr *MockAdapterServiceClientMockRecorder) RebootDevice(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RebootDevice", reflect.TypeOf((*MockAdapterServiceClient)(nil).RebootDevice), varargs...)
}

// ReconcileDevice mocks base method.
func (m *MockAdapterServiceClient) ReconcileDevice(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ReconcileDevice", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReconcileDevice indicates an expected call of ReconcileDevice.
func (mr *MockAdapterServiceClientMockRecorder) ReconcileDevice(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReconcileDevice", reflect.TypeOf((*MockAdapterServiceClient)(nil).ReconcileDevice), varargs...)
}

// RevertImageUpdate mocks base method.
func (m *MockAdapterServiceClient) RevertImageUpdate(ctx context.Context, in *inter_container.ImageDownloadMessage, opts ...grpc.CallOption) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RevertImageUpdate", varargs...)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RevertImageUpdate indicates an expected call of RevertImageUpdate.
func (mr *MockAdapterServiceClientMockRecorder) RevertImageUpdate(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RevertImageUpdate", reflect.TypeOf((*MockAdapterServiceClient)(nil).RevertImageUpdate), varargs...)
}

// SelfTestDevice mocks base method.
func (m *MockAdapterServiceClient) SelfTestDevice(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SelfTestDevice", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SelfTestDevice indicates an expected call of SelfTestDevice.
func (mr *MockAdapterServiceClientMockRecorder) SelfTestDevice(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SelfTestDevice", reflect.TypeOf((*MockAdapterServiceClient)(nil).SelfTestDevice), varargs...)
}

// SendPacketOut mocks base method.
func (m *MockAdapterServiceClient) SendPacketOut(ctx context.Context, in *inter_container.PacketOut, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SendPacketOut", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SendPacketOut indicates an expected call of SendPacketOut.
func (mr *MockAdapterServiceClientMockRecorder) SendPacketOut(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendPacketOut", reflect.TypeOf((*MockAdapterServiceClient)(nil).SendPacketOut), varargs...)
}

// SetExtValue mocks base method.
func (m *MockAdapterServiceClient) SetExtValue(ctx context.Context, in *inter_container.SetExtValueMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SetExtValue", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetExtValue indicates an expected call of SetExtValue.
func (mr *MockAdapterServiceClientMockRecorder) SetExtValue(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetExtValue", reflect.TypeOf((*MockAdapterServiceClient)(nil).SetExtValue), varargs...)
}

// SetSingleValue mocks base method.
func (m *MockAdapterServiceClient) SetSingleValue(ctx context.Context, in *extension.SingleSetValueRequest, opts ...grpc.CallOption) (*extension.SingleSetValueResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SetSingleValue", varargs...)
	ret0, _ := ret[0].(*extension.SingleSetValueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetSingleValue indicates an expected call of SetSingleValue.
func (mr *MockAdapterServiceClientMockRecorder) SetSingleValue(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSingleValue", reflect.TypeOf((*MockAdapterServiceClient)(nil).SetSingleValue), varargs...)
}

// SimulateAlarm mocks base method.
func (m *MockAdapterServiceClient) SimulateAlarm(ctx context.Context, in *inter_container.SimulateAlarmMessage, opts ...grpc.CallOption) (*common.OperationResp, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SimulateAlarm", varargs...)
	ret0, _ := ret[0].(*common.OperationResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SimulateAlarm indicates an expected call of SimulateAlarm.
func (mr *MockAdapterServiceClientMockRecorder) SimulateAlarm(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SimulateAlarm", reflect.TypeOf((*MockAdapterServiceClient)(nil).SimulateAlarm), varargs...)
}

// StartOmciTest mocks base method.
func (m *MockAdapterServiceClient) StartOmciTest(ctx context.Context, in *inter_container.OMCITest, opts ...grpc.CallOption) (*voltha.TestResponse, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StartOmciTest", varargs...)
	ret0, _ := ret[0].(*voltha.TestResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartOmciTest indicates an expected call of StartOmciTest.
func (mr *MockAdapterServiceClientMockRecorder) StartOmciTest(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartOmciTest", reflect.TypeOf((*MockAdapterServiceClient)(nil).StartOmciTest), varargs...)
}

// SuppressEvent mocks base method.
func (m *MockAdapterServiceClient) SuppressEvent(ctx context.Context, in *voltha.EventFilter, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SuppressEvent", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SuppressEvent indicates an expected call of SuppressEvent.
func (mr *MockAdapterServiceClientMockRecorder) SuppressEvent(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SuppressEvent", reflect.TypeOf((*MockAdapterServiceClient)(nil).SuppressEvent), varargs...)
}

// UnSuppressEvent mocks base method.
func (m *MockAdapterServiceClient) UnSuppressEvent(ctx context.Context, in *voltha.EventFilter, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UnSuppressEvent", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UnSuppressEvent indicates an expected call of UnSuppressEvent.
func (mr *MockAdapterServiceClientMockRecorder) UnSuppressEvent(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UnSuppressEvent", reflect.TypeOf((*MockAdapterServiceClient)(nil).UnSuppressEvent), varargs...)
}

// UpdateFlowsBulk mocks base method.
func (m *MockAdapterServiceClient) UpdateFlowsBulk(ctx context.Context, in *inter_container.BulkFlows, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateFlowsBulk", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateFlowsBulk indicates an expected call of UpdateFlowsBulk.
func (mr *MockAdapterServiceClientMockRecorder) UpdateFlowsBulk(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateFlowsBulk", reflect.TypeOf((*MockAdapterServiceClient)(nil).UpdateFlowsBulk), varargs...)
}

// UpdateFlowsIncrementally mocks base method.
func (m *MockAdapterServiceClient) UpdateFlowsIncrementally(ctx context.Context, in *inter_container.IncrementalFlows, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateFlowsIncrementally", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateFlowsIncrementally indicates an expected call of UpdateFlowsIncrementally.
func (mr *MockAdapterServiceClientMockRecorder) UpdateFlowsIncrementally(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateFlowsIncrementally", reflect.TypeOf((*MockAdapterServiceClient)(nil).UpdateFlowsIncrementally), varargs...)
}

// UpdatePmConfig mocks base method.
func (m *MockAdapterServiceClient) UpdatePmConfig(ctx context.Context, in *inter_container.PmConfigsInfo, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdatePmConfig", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdatePmConfig indicates an expected call of UpdatePmConfig.
func (mr *MockAdapterServiceClientMockRecorder) UpdatePmConfig(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdatePmConfig", reflect.TypeOf((*MockAdapterServiceClient)(nil).UpdatePmConfig), varargs...)
}

// MockAdapterServiceServer is a mock of AdapterServiceServer interface.
type MockAdapterServiceServer struct {
	ctrl     *gomock.Controller
	recorder *MockAdapterServiceServerMockRecorder
}

// MockAdapterServiceServerMockRecorder is the mock recorder for MockAdapterServiceServer.
type MockAdapterServiceServerMockRecorder struct {
	mock *MockAdapterServiceServer
}

// NewMockAdapterServiceServer creates a new mock instance.
func NewMockAdapterServiceServer(ctrl *gomock.Controller) *MockAdapterServiceServer {
	mock := &MockAdapterServiceServer{ctrl: ctrl}
	mock.recorder = &MockAdapterServiceServerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockAdapterServiceServer) EXPECT() *MockAdapterServiceServerMockRecorder {
	return m.recorder
}

// AbortOnuImageUpgrade mocks base method.
func (m *MockAdapterServiceServer) AbortOnuImageUpgrade(arg0 context.Context, arg1 *voltha.DeviceImageRequest) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AbortOnuImageUpgrade", arg0, arg1)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AbortOnuImageUpgrade indicates an expected call of AbortOnuImageUpgrade.
func (mr *MockAdapterServiceServerMockRecorder) AbortOnuImageUpgrade(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AbortOnuImageUpgrade", reflect.TypeOf((*MockAdapterServiceServer)(nil).AbortOnuImageUpgrade), arg0, arg1)
}

// ActivateImageUpdate mocks base method.
func (m *MockAdapterServiceServer) ActivateImageUpdate(arg0 context.Context, arg1 *inter_container.ImageDownloadMessage) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ActivateImageUpdate", arg0, arg1)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ActivateImageUpdate indicates an expected call of ActivateImageUpdate.
func (mr *MockAdapterServiceServerMockRecorder) ActivateImageUpdate(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActivateImageUpdate", reflect.TypeOf((*MockAdapterServiceServer)(nil).ActivateImageUpdate), arg0, arg1)
}

// ActivateOnuImage mocks base method.
func (m *MockAdapterServiceServer) ActivateOnuImage(arg0 context.Context, arg1 *voltha.DeviceImageRequest) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ActivateOnuImage", arg0, arg1)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ActivateOnuImage indicates an expected call of ActivateOnuImage.
func (mr *MockAdapterServiceServerMockRecorder) ActivateOnuImage(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActivateOnuImage", reflect.TypeOf((*MockAdapterServiceServer)(nil).ActivateOnuImage), arg0, arg1)
}

// AdoptDevice mocks base method.
func (m *MockAdapterServiceServer) AdoptDevice(arg0 context.Context, arg1 *voltha.Device) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AdoptDevice", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AdoptDevice indicates an expected call of AdoptDevice.
func (mr *MockAdapterServiceServerMockRecorder) AdoptDevice(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AdoptDevice", reflect.TypeOf((*MockAdapterServiceServer)(nil).AdoptDevice), arg0, arg1)
}

// CancelImageDownload mocks base method.
func (m *MockAdapterServiceServer) CancelImageDownload(arg0 context.Context, arg1 *inter_container.ImageDownloadMessage) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelImageDownload", arg0, arg1)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelImageDownload indicates an expected call of CancelImageDownload.
func (mr *MockAdapterServiceServerMockRecorder) CancelImageDownload(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelImageDownload", reflect.TypeOf((*MockAdapterServiceServer)(nil).CancelImageDownload), arg0, arg1)
}

// ChildDeviceLost mocks base method.
func (m *MockAdapterServiceServer) ChildDeviceLost(arg0 context.Context, arg1 *voltha.Device) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ChildDeviceLost", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ChildDeviceLost indicates an expected call of ChildDeviceLost.
func (mr *MockAdapterServiceServerMockRecorder) ChildDeviceLost(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ChildDeviceLost", reflect.TypeOf((*MockAdapterServiceServer)(nil).ChildDeviceLost), arg0, arg1)
}

// CommitOnuImage mocks base method.
func (m *MockAdapterServiceServer) CommitOnuImage(arg0 context.Context, arg1 *voltha.DeviceImageRequest) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CommitOnuImage", arg0, arg1)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CommitOnuImage indicates an expected call of CommitOnuImage.
func (mr *MockAdapterServiceServerMockRecorder) CommitOnuImage(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CommitOnuImage", reflect.TypeOf((*MockAdapterServiceServer)(nil).CommitOnuImage), arg0, arg1)
}

// DeleteDevice mocks base method.
func (m *MockAdapterServiceServer) DeleteDevice(arg0 context.Context, arg1 *voltha.Device) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteDevice", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteDevice indicates an expected call of DeleteDevice.
func (mr *MockAdapterServiceServerMockRecorder) DeleteDevice(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteDevice", reflect.TypeOf((*MockAdapterServiceServer)(nil).DeleteDevice), arg0, arg1)
}

// DisableDevice mocks base method.
func (m *MockAdapterServiceServer) DisableDevice(arg0 context.Context, arg1 *voltha.Device) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableDevice", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableDevice indicates an expected call of DisableDevice.
func (mr *MockAdapterServiceServerMockRecorder) DisableDevice(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableDevice", reflect.TypeOf((*MockAdapterServiceServer)(nil).DisableDevice), arg0, arg1)
}

// DisablePort mocks base method.
func (m *MockAdapterServiceServer) DisablePort(arg0 context.Context, arg1 *voltha.Port) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisablePort", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisablePort indicates an expected call of DisablePort.
func (mr *MockAdapterServiceServerMockRecorder) DisablePort(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisablePort", reflect.TypeOf((*MockAdapterServiceServer)(nil).DisablePort), arg0, arg1)
}

// DownloadImage mocks base method.
func (m *MockAdapterServiceServer) DownloadImage(arg0 context.Context, arg1 *inter_container.ImageDownloadMessage) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DownloadImage", arg0, arg1)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DownloadImage indicates an expected call of DownloadImage.
func (mr *MockAdapterServiceServerMockRecorder) DownloadImage(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DownloadImage", reflect.TypeOf((*MockAdapterServiceServer)(nil).DownloadImage), arg0, arg1)
}

// DownloadOnuImage mocks base method.
func (m *MockAdapterServiceServer) DownloadOnuImage(arg0 context.Context, arg1 *voltha.DeviceImageDownloadRequest) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DownloadOnuImage", arg0, arg1)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DownloadOnuImage indicates an expected call of DownloadOnuImage.
func (mr *MockAdapterServiceServerMockRecorder) DownloadOnuImage(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DownloadOnuImage", reflect.TypeOf((*MockAdapterServiceServer)(nil).DownloadOnuImage), arg0, arg1)
}

// EnablePort mocks base method.
func (m *MockAdapterServiceServer) EnablePort(arg0 context.Context, arg1 *voltha.Port) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnablePort", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnablePort indicates an expected call of EnablePort.
func (mr *MockAdapterServiceServerMockRecorder) EnablePort(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnablePort", reflect.TypeOf((*MockAdapterServiceServer)(nil).EnablePort), arg0, arg1)
}

// GetExtValue mocks base method.
func (m *MockAdapterServiceServer) GetExtValue(arg0 context.Context, arg1 *inter_container.GetExtValueMessage) (*common.ReturnValues, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetExtValue", arg0, arg1)
	ret0, _ := ret[0].(*common.ReturnValues)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetExtValue indicates an expected call of GetExtValue.
func (mr *MockAdapterServiceServerMockRecorder) GetExtValue(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetExtValue", reflect.TypeOf((*MockAdapterServiceServer)(nil).GetExtValue), arg0, arg1)
}

// GetHealthStatus mocks base method.
func (m *MockAdapterServiceServer) GetHealthStatus(arg0 context.Context, arg1 *empty.Empty) (*voltha.HealthStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHealthStatus", arg0, arg1)
	ret0, _ := ret[0].(*voltha.HealthStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHealthStatus indicates an expected call of GetHealthStatus.
func (mr *MockAdapterServiceServerMockRecorder) GetHealthStatus(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHealthStatus", reflect.TypeOf((*MockAdapterServiceServer)(nil).GetHealthStatus), arg0, arg1)
}

// GetImageDownloadStatus mocks base method.
func (m *MockAdapterServiceServer) GetImageDownloadStatus(arg0 context.Context, arg1 *inter_container.ImageDownloadMessage) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetImageDownloadStatus", arg0, arg1)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetImageDownloadStatus indicates an expected call of GetImageDownloadStatus.
func (mr *MockAdapterServiceServerMockRecorder) GetImageDownloadStatus(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetImageDownloadStatus", reflect.TypeOf((*MockAdapterServiceServer)(nil).GetImageDownloadStatus), arg0, arg1)
}

// GetOfpDeviceInfo mocks base method.
func (m *MockAdapterServiceServer) GetOfpDeviceInfo(arg0 context.Context, arg1 *voltha.Device) (*inter_container.SwitchCapability, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOfpDeviceInfo", arg0, arg1)
	ret0, _ := ret[0].(*inter_container.SwitchCapability)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOfpDeviceInfo indicates an expected call of GetOfpDeviceInfo.
func (mr *MockAdapterServiceServerMockRecorder) GetOfpDeviceInfo(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOfpDeviceInfo", reflect.TypeOf((*MockAdapterServiceServer)(nil).GetOfpDeviceInfo), arg0, arg1)
}

// GetOnuImageStatus mocks base method.
func (m *MockAdapterServiceServer) GetOnuImageStatus(arg0 context.Context, arg1 *voltha.DeviceImageRequest) (*voltha.DeviceImageResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOnuImageStatus", arg0, arg1)
	ret0, _ := ret[0].(*voltha.DeviceImageResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOnuImageStatus indicates an expected call of GetOnuImageStatus.
func (mr *MockAdapterServiceServerMockRecorder) GetOnuImageStatus(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOnuImageStatus", reflect.TypeOf((*MockAdapterServiceServer)(nil).GetOnuImageStatus), arg0, arg1)
}

// GetOnuImages mocks base method.
func (m *MockAdapterServiceServer) GetOnuImages(arg0 context.Context, arg1 *common.ID) (*voltha.OnuImages, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOnuImages", arg0, arg1)
	ret0, _ := ret[0].(*voltha.OnuImages)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOnuImages indicates an expected call of GetOnuImages.
func (mr *MockAdapterServiceServerMockRecorder) GetOnuImages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOnuImages", reflect.TypeOf((*MockAdapterServiceServer)(nil).GetOnuImages), arg0, arg1)
}

// GetSingleValue mocks base method.
func (m *MockAdapterServiceServer) GetSingleValue(arg0 context.Context, arg1 *extension.SingleGetValueRequest) (*extension.SingleGetValueResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSingleValue", arg0, arg1)
	ret0, _ := ret[0].(*extension.SingleGetValueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSingleValue indicates an expected call of GetSingleValue.
func (mr *MockAdapterServiceServerMockRecorder) GetSingleValue(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSingleValue", reflect.TypeOf((*MockAdapterServiceServer)(nil).GetSingleValue), arg0, arg1)
}

// ReEnableDevice mocks base method.
func (m *MockAdapterServiceServer) ReEnableDevice(arg0 context.Context, arg1 *voltha.Device) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReEnableDevice", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReEnableDevice indicates an expected call of ReEnableDevice.
func (mr *MockAdapterServiceServerMockRecorder) ReEnableDevice(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReEnableDevice", reflect.TypeOf((*MockAdapterServiceServer)(nil).ReEnableDevice), arg0, arg1)
}

// RebootDevice mocks base method.
func (m *MockAdapterServiceServer) RebootDevice(arg0 context.Context, arg1 *voltha.Device) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RebootDevice", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RebootDevice indicates an expected call of RebootDevice.
func (mr *MockAdapterServiceServerMockRecorder) RebootDevice(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RebootDevice", reflect.TypeOf((*MockAdapterServiceServer)(nil).RebootDevice), arg0, arg1)
}

// ReconcileDevice mocks base method.
func (m *MockAdapterServiceServer) ReconcileDevice(arg0 context.Context, arg1 *voltha.Device) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReconcileDevice", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReconcileDevice indicates an expected call of ReconcileDevice.
func (mr *MockAdapterServiceServerMockRecorder) ReconcileDevice(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReconcileDevice", reflect.TypeOf((*MockAdapterServiceServer)(nil).ReconcileDevice), arg0, arg1)
}

// RevertImageUpdate mocks base method.
func (m *MockAdapterServiceServer) RevertImageUpdate(arg0 context.Context, arg1 *inter_container.ImageDownloadMessage) (*voltha.ImageDownload, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RevertImageUpdate", arg0, arg1)
	ret0, _ := ret[0].(*voltha.ImageDownload)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RevertImageUpdate indicates an expected call of RevertImageUpdate.
func (mr *MockAdapterServiceServerMockRecorder) RevertImageUpdate(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RevertImageUpdate", reflect.TypeOf((*MockAdapterServiceServer)(nil).RevertImageUpdate), arg0, arg1)
}

// SelfTestDevice mocks base method.
func (m *MockAdapterServiceServer) SelfTestDevice(arg0 context.Context, arg1 *voltha.Device) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SelfTestDevice", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SelfTestDevice indicates an expected call of SelfTestDevice.
func (mr *MockAdapterServiceServerMockRecorder) SelfTestDevice(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SelfTestDevice", reflect.TypeOf((*MockAdapterServiceServer)(nil).SelfTestDevice), arg0, arg1)
}

// SendPacketOut mocks base method.
func (m *MockAdapterServiceServer) SendPacketOut(arg0 context.Context, arg1 *inter_container.PacketOut) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SendPacketOut", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SendPacketOut indicates an expected call of SendPacketOut.
func (mr *MockAdapterServiceServerMockRecorder) SendPacketOut(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendPacketOut", reflect.TypeOf((*MockAdapterServiceServer)(nil).SendPacketOut), arg0, arg1)
}

// SetExtValue mocks base method.
func (m *MockAdapterServiceServer) SetExtValue(arg0 context.Context, arg1 *inter_container.SetExtValueMessage) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetExtValue", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetExtValue indicates an expected call of SetExtValue.
func (mr *MockAdapterServiceServerMockRecorder) SetExtValue(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetExtValue", reflect.TypeOf((*MockAdapterServiceServer)(nil).SetExtValue), arg0, arg1)
}

// SetSingleValue mocks base method.
func (m *MockAdapterServiceServer) SetSingleValue(arg0 context.Context, arg1 *extension.SingleSetValueRequest) (*extension.SingleSetValueResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSingleValue", arg0, arg1)
	ret0, _ := ret[0].(*extension.SingleSetValueResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetSingleValue indicates an expected call of SetSingleValue.
func (mr *MockAdapterServiceServerMockRecorder) SetSingleValue(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSingleValue", reflect.TypeOf((*MockAdapterServiceServer)(nil).SetSingleValue), arg0, arg1)
}

// SimulateAlarm mocks base method.
func (m *MockAdapterServiceServer) SimulateAlarm(arg0 context.Context, arg1 *inter_container.SimulateAlarmMessage) (*common.OperationResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SimulateAlarm", arg0, arg1)
	ret0, _ := ret[0].(*common.OperationResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SimulateAlarm indicates an expected call of SimulateAlarm.
func (mr *MockAdapterServiceServerMockRecorder) SimulateAlarm(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SimulateAlarm", reflect.TypeOf((*MockAdapterServiceServer)(nil).SimulateAlarm), arg0, arg1)
}

// StartOmciTest mocks base method.
func (m *MockAdapterServiceServer) StartOmciTest(arg0 context.Context, arg1 *inter_container.OMCITest) (*voltha.TestResponse, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartOmciTest", arg0, arg1)
	ret0, _ := ret[0].(*voltha.TestResponse)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartOmciTest indicates an expected call of StartOmciTest.
func (mr *MockAdapterServiceServerMockRecorder) StartOmciTest(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartOmciTest", reflect.TypeOf((*MockAdapterServiceServer)(nil).StartOmciTest), arg0, arg1)
}

// SuppressEvent mocks base method.
func (m *MockAdapterServiceServer) SuppressEvent(arg0 context.Context, arg1 *voltha.EventFilter) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SuppressEvent", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SuppressEvent indicates an expected call of SuppressEvent.
func (mr *MockAdapterServiceServerMockRecorder) SuppressEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SuppressEvent", reflect.TypeOf((*MockAdapterServiceServer)(nil).SuppressEvent), arg0, arg1)
}

// UnSuppressEvent mocks base method.
func (m *MockAdapterServiceServer) UnSuppressEvent(arg0 context.Context, arg1 *voltha.EventFilter) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UnSuppressEvent", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UnSuppressEvent indicates an expected call of UnSuppressEvent.
func (mr *MockAdapterServiceServerMockRecorder) UnSuppressEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UnSuppressEvent", reflect.TypeOf((*MockAdapterServiceServer)(nil).UnSuppressEvent), arg0, arg1)
}

// UpdateFlowsBulk mocks base method.
func (m *MockAdapterServiceServer) UpdateFlowsBulk(arg0 context.Context, arg1 *inter_container.BulkFlows) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateFlowsBulk", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateFlowsBulk indicates an expected call of UpdateFlowsBulk.
func (mr *MockAdapterServiceServerMockRecorder) UpdateFlowsBulk(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateFlowsBulk", reflect.TypeOf((*MockAdapterServiceServer)(nil).UpdateFlowsBulk), arg0, arg1)
}

// UpdateFlowsIncrementally mocks base method.
func (m *MockAdapterServiceServer) UpdateFlowsIncrementally(arg0 context.Context, arg1 *inter_container.IncrementalFlows) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateFlowsIncrementally", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateFlowsIncrementally indicates an expected call of UpdateFlowsIncrementally.
func (mr *MockAdapterServiceServerMockRecorder) UpdateFlowsIncrementally(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateFlowsIncrementally", reflect.TypeOf((*MockAdapterServiceServer)(nil).UpdateFlowsIncrementally), arg0, arg1)
}

// UpdatePmConfig mocks base method.
func (m *MockAdapterServiceServer) UpdatePmConfig(arg0 context.Context, arg1 *inter_container.PmConfigsInfo) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdatePmConfig", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdatePmConfig indicates an expected call of UpdatePmConfig.
func (mr *MockAdapterServiceServerMockRecorder) UpdatePmConfig(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdatePmConfig", reflect.TypeOf((*MockAdapterServiceServer)(nil).UpdatePmConfig), arg0, arg1)
}

// MockOnuInterAdapterServiceClient is a mock of OnuInterAdapterServiceClient interface.
type MockOnuInterAdapterServiceClient struct {
	ctrl     *gomock.Controller
	recorder *MockOnuInterAdapterServiceClientMockRecorder
}

// MockOnuInterAdapterServiceClientMockRecorder is the mock recorder for MockOnuInterAdapterServiceClient.
type MockOnuInterAdapterServiceClientMockRecorder struct {
	mock *MockOnuInterAdapterServiceClient
}

// NewMockOnuInterAdapterServiceClient creates a new mock instance.
func NewMockOnuInterAdapterServiceClient(ctrl *gomock.Controller) *MockOnuInterAdapterServiceClient {
	mock := &MockOnuInterAdapterServiceClient{ctrl: ctrl}
	mock.recorder = &MockOnuInterAdapterServiceClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockOnuInterAdapterServiceClient) EXPECT() *MockOnuInterAdapterServiceClientMockRecorder {
	return m.recorder
}

// DeleteGemPort mocks base method.
func (m *MockOnuInterAdapterServiceClient) DeleteGemPort(ctx context.Context, in *inter_container.DeleteGemPortMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteGemPort", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteGemPort indicates an expected call of DeleteGemPort.
func (mr *MockOnuInterAdapterServiceClientMockRecorder) DeleteGemPort(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteGemPort", reflect.TypeOf((*MockOnuInterAdapterServiceClient)(nil).DeleteGemPort), varargs...)
}

// DeleteTCont mocks base method.
func (m *MockOnuInterAdapterServiceClient) DeleteTCont(ctx context.Context, in *inter_container.DeleteTcontMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTCont", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTCont indicates an expected call of DeleteTCont.
func (mr *MockOnuInterAdapterServiceClientMockRecorder) DeleteTCont(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTCont", reflect.TypeOf((*MockOnuInterAdapterServiceClient)(nil).DeleteTCont), varargs...)
}

// DownloadTechProfile mocks base method.
func (m *MockOnuInterAdapterServiceClient) DownloadTechProfile(ctx context.Context, in *inter_container.TechProfileDownloadMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DownloadTechProfile", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DownloadTechProfile indicates an expected call of DownloadTechProfile.
func (mr *MockOnuInterAdapterServiceClientMockRecorder) DownloadTechProfile(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DownloadTechProfile", reflect.TypeOf((*MockOnuInterAdapterServiceClient)(nil).DownloadTechProfile), varargs...)
}

// GetHealthStatus mocks base method.
func (m *MockOnuInterAdapterServiceClient) GetHealthStatus(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*voltha.HealthStatus, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetHealthStatus", varargs...)
	ret0, _ := ret[0].(*voltha.HealthStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHealthStatus indicates an expected call of GetHealthStatus.
func (mr *MockOnuInterAdapterServiceClientMockRecorder) GetHealthStatus(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHealthStatus", reflect.TypeOf((*MockOnuInterAdapterServiceClient)(nil).GetHealthStatus), varargs...)
}

// OmciResponse mocks base method.
func (m *MockOnuInterAdapterServiceClient) OmciResponse(ctx context.Context, in *inter_container.OmciMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "OmciResponse", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// OmciResponse indicates an expected call of OmciResponse.
func (mr *MockOnuInterAdapterServiceClientMockRecorder) OmciResponse(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OmciResponse", reflect.TypeOf((*MockOnuInterAdapterServiceClient)(nil).OmciResponse), varargs...)
}

// OnuIndication mocks base method.
func (m *MockOnuInterAdapterServiceClient) OnuIndication(ctx context.Context, in *inter_container.OnuIndicationMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "OnuIndication", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// OnuIndication indicates an expected call of OnuIndication.
func (mr *MockOnuInterAdapterServiceClientMockRecorder) OnuIndication(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OnuIndication", reflect.TypeOf((*MockOnuInterAdapterServiceClient)(nil).OnuIndication), varargs...)
}

// MockOnuInterAdapterServiceServer is a mock of OnuInterAdapterServiceServer interface.
type MockOnuInterAdapterServiceServer struct {
	ctrl     *gomock.Controller
	recorder *MockOnuInterAdapterServiceServerMockRecorder
}

// MockOnuInterAdapterServiceServerMockRecorder is the mock recorder for MockOnuInterAdapterServiceServer.
type MockOnuInterAdapterServiceServerMockRecorder struct {
	mock *MockOnuInterAdapterServiceServer
}

// NewMockOnuInterAdapterServiceServer creates a new mock instance.
func NewMockOnuInterAdapterServiceServer(ctrl *gomock.Controller) *MockOnuInterAdapterServiceServer {
	mock := &MockOnuInterAdapterServiceServer{ctrl: ctrl}
	mock.recorder = &MockOnuInterAdapterServiceServerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockOnuInterAdapterServiceServer) EXPECT() *MockOnuInterAdapterServiceServerMockRecorder {
	return m.recorder
}

// DeleteGemPort mocks base method.
func (m *MockOnuInterAdapterServiceServer) DeleteGemPort(arg0 context.Context, arg1 *inter_container.DeleteGemPortMessage) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteGemPort", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteGemPort indicates an expected call of DeleteGemPort.
func (mr *MockOnuInterAdapterServiceServerMockRecorder) DeleteGemPort(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteGemPort", reflect.TypeOf((*MockOnuInterAdapterServiceServer)(nil).DeleteGemPort), arg0, arg1)
}

// DeleteTCont mocks base method.
func (m *MockOnuInterAdapterServiceServer) DeleteTCont(arg0 context.Context, arg1 *inter_container.DeleteTcontMessage) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTCont", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTCont indicates an expected call of DeleteTCont.
func (mr *MockOnuInterAdapterServiceServerMockRecorder) DeleteTCont(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTCont", reflect.TypeOf((*MockOnuInterAdapterServiceServer)(nil).DeleteTCont), arg0, arg1)
}

// DownloadTechProfile mocks base method.
func (m *MockOnuInterAdapterServiceServer) DownloadTechProfile(arg0 context.Context, arg1 *inter_container.TechProfileDownloadMessage) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DownloadTechProfile", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DownloadTechProfile indicates an expected call of DownloadTechProfile.
func (mr *MockOnuInterAdapterServiceServerMockRecorder) DownloadTechProfile(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DownloadTechProfile", reflect.TypeOf((*MockOnuInterAdapterServiceServer)(nil).DownloadTechProfile), arg0, arg1)
}

// GetHealthStatus mocks base method.
func (m *MockOnuInterAdapterServiceServer) GetHealthStatus(arg0 context.Context, arg1 *empty.Empty) (*voltha.HealthStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHealthStatus", arg0, arg1)
	ret0, _ := ret[0].(*voltha.HealthStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHealthStatus indicates an expected call of GetHealthStatus.
func (mr *MockOnuInterAdapterServiceServerMockRecorder) GetHealthStatus(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHealthStatus", reflect.TypeOf((*MockOnuInterAdapterServiceServer)(nil).GetHealthStatus), arg0, arg1)
}

// OmciResponse mocks base method.
func (m *MockOnuInterAdapterServiceServer) OmciResponse(arg0 context.Context, arg1 *inter_container.OmciMessage) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "OmciResponse", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// OmciResponse indicates an expected call of OmciResponse.
func (mr *MockOnuInterAdapterServiceServerMockRecorder) OmciResponse(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OmciResponse", reflect.TypeOf((*MockOnuInterAdapterServiceServer)(nil).OmciResponse), arg0, arg1)
}

// OnuIndication mocks base method.
func (m *MockOnuInterAdapterServiceServer) OnuIndication(arg0 context.Context, arg1 *inter_container.OnuIndicationMessage) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "OnuIndication", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// OnuIndication indicates an expected call of OnuIndication.
func (mr *MockOnuInterAdapterServiceServerMockRecorder) OnuIndication(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OnuIndication", reflect.TypeOf((*MockOnuInterAdapterServiceServer)(nil).OnuIndication), arg0, arg1)
}

// MockOltInterAdapterServiceClient is a mock of OltInterAdapterServiceClient interface.
type MockOltInterAdapterServiceClient struct {
	ctrl     *gomock.Controller
	recorder *MockOltInterAdapterServiceClientMockRecorder
}

// MockOltInterAdapterServiceClientMockRecorder is the mock recorder for MockOltInterAdapterServiceClient.
type MockOltInterAdapterServiceClientMockRecorder struct {
	mock *MockOltInterAdapterServiceClient
}

// NewMockOltInterAdapterServiceClient creates a new mock instance.
func NewMockOltInterAdapterServiceClient(ctrl *gomock.Controller) *MockOltInterAdapterServiceClient {
	mock := &MockOltInterAdapterServiceClient{ctrl: ctrl}
	mock.recorder = &MockOltInterAdapterServiceClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockOltInterAdapterServiceClient) EXPECT() *MockOltInterAdapterServiceClientMockRecorder {
	return m.recorder
}

// GetHealthStatus mocks base method.
func (m *MockOltInterAdapterServiceClient) GetHealthStatus(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*voltha.HealthStatus, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetHealthStatus", varargs...)
	ret0, _ := ret[0].(*voltha.HealthStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHealthStatus indicates an expected call of GetHealthStatus.
func (mr *MockOltInterAdapterServiceClientMockRecorder) GetHealthStatus(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHealthStatus", reflect.TypeOf((*MockOltInterAdapterServiceClient)(nil).GetHealthStatus), varargs...)
}

// GetTechProfileInstance mocks base method.
func (m *MockOltInterAdapterServiceClient) GetTechProfileInstance(ctx context.Context, in *inter_container.TechProfileInstanceRequestMessage, opts ...grpc.CallOption) (*inter_container.TechProfileDownloadMessage, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTechProfileInstance", varargs...)
	ret0, _ := ret[0].(*inter_container.TechProfileDownloadMessage)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTechProfileInstance indicates an expected call of GetTechProfileInstance.
func (mr *MockOltInterAdapterServiceClientMockRecorder) GetTechProfileInstance(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTechProfileInstance", reflect.TypeOf((*MockOltInterAdapterServiceClient)(nil).GetTechProfileInstance), varargs...)
}

// ProxyOmciRequest mocks base method.
func (m *MockOltInterAdapterServiceClient) ProxyOmciRequest(ctx context.Context, in *inter_container.OmciMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, in}
	for _, a := range opts {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ProxyOmciRequest", varargs...)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ProxyOmciRequest indicates an expected call of ProxyOmciRequest.
func (mr *MockOltInterAdapterServiceClientMockRecorder) ProxyOmciRequest(ctx, in interface{}, opts ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, in}, opts...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ProxyOmciRequest", reflect.TypeOf((*MockOltInterAdapterServiceClient)(nil).ProxyOmciRequest), varargs...)
}

// MockOltInterAdapterServiceServer is a mock of OltInterAdapterServiceServer interface.
type MockOltInterAdapterServiceServer struct {
	ctrl     *gomock.Controller
	recorder *MockOltInterAdapterServiceServerMockRecorder
}

// MockOltInterAdapterServiceServerMockRecorder is the mock recorder for MockOltInterAdapterServiceServer.
type MockOltInterAdapterServiceServerMockRecorder struct {
	mock *MockOltInterAdapterServiceServer
}

// NewMockOltInterAdapterServiceServer creates a new mock instance.
func NewMockOltInterAdapterServiceServer(ctrl *gomock.Controller) *MockOltInterAdapterServiceServer {
	mock := &MockOltInterAdapterServiceServer{ctrl: ctrl}
	mock.recorder = &MockOltInterAdapterServiceServerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockOltInterAdapterServiceServer) EXPECT() *MockOltInterAdapterServiceServerMockRecorder {
	return m.recorder
}

// GetHealthStatus mocks base method.
func (m *MockOltInterAdapterServiceServer) GetHealthStatus(arg0 context.Context, arg1 *empty.Empty) (*voltha.HealthStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHealthStatus", arg0, arg1)
	ret0, _ := ret[0].(*voltha.HealthStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHealthStatus indicates an expected call of GetHealthStatus.
func (mr *MockOltInterAdapterServiceServerMockRecorder) GetHealthStatus(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHealthStatus", reflect.TypeOf((*MockOltInterAdapterServiceServer)(nil).GetHealthStatus), arg0, arg1)
}

// GetTechProfileInstance mocks base method.
func (m *MockOltInterAdapterServiceServer) GetTechProfileInstance(arg0 context.Context, arg1 *inter_container.TechProfileInstanceRequestMessage) (*inter_container.TechProfileDownloadMessage, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTechProfileInstance", arg0, arg1)
	ret0, _ := ret[0].(*inter_container.TechProfileDownloadMessage)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTechProfileInstance indicates an expected call of GetTechProfileInstance.
func (mr *MockOltInterAdapterServiceServerMockRecorder) GetTechProfileInstance(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTechProfileInstance", reflect.TypeOf((*MockOltInterAdapterServiceServer)(nil).GetTechProfileInstance), arg0, arg1)
}

// ProxyOmciRequest mocks base method.
func (m *MockOltInterAdapterServiceServer) ProxyOmciRequest(arg0 context.Context, arg1 *inter_container.OmciMessage) (*empty.Empty, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ProxyOmciRequest", arg0, arg1)
	ret0, _ := ret[0].(*empty.Empty)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ProxyOmciRequest indicates an expected call of ProxyOmciRequest.
func (mr *MockOltInterAdapterServiceServerMockRecorder) ProxyOmciRequest(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ProxyOmciRequest", reflect.TypeOf((*MockOltInterAdapterServiceServer)(nil).ProxyOmciRequest), arg0, arg1)
}
