// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.0
// - protoc             v4.25.8
// source: voltha_protos/core_services.proto

package core_service

import (
	context "context"
	common "github.com/opencord/voltha-protos/v5/go/common"
	core_adapter "github.com/opencord/voltha-protos/v5/go/core_adapter"
	health "github.com/opencord/voltha-protos/v5/go/health"
	voltha "github.com/opencord/voltha-protos/v5/go/voltha"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	CoreService_GetHealthStatus_FullMethodName                = "/core_service.CoreService/GetHealthStatus"
	CoreService_RegisterAdapter_FullMethodName                = "/core_service.CoreService/RegisterAdapter"
	CoreService_DeviceUpdate_FullMethodName                   = "/core_service.CoreService/DeviceUpdate"
	CoreService_PortCreated_FullMethodName                    = "/core_service.CoreService/PortCreated"
	CoreService_PortsStateUpdate_FullMethodName               = "/core_service.CoreService/PortsStateUpdate"
	CoreService_DeleteAllPorts_FullMethodName                 = "/core_service.CoreService/DeleteAllPorts"
	CoreService_GetDevicePort_FullMethodName                  = "/core_service.CoreService/GetDevicePort"
	CoreService_ListDevicePorts_FullMethodName                = "/core_service.CoreService/ListDevicePorts"
	CoreService_DeviceStateUpdate_FullMethodName              = "/core_service.CoreService/DeviceStateUpdate"
	CoreService_DevicePMConfigUpdate_FullMethodName           = "/core_service.CoreService/DevicePMConfigUpdate"
	CoreService_ChildDeviceDetected_FullMethodName            = "/core_service.CoreService/ChildDeviceDetected"
	CoreService_ChildDevicesLost_FullMethodName               = "/core_service.CoreService/ChildDevicesLost"
	CoreService_ChildDevicesDetected_FullMethodName           = "/core_service.CoreService/ChildDevicesDetected"
	CoreService_GetDevice_FullMethodName                      = "/core_service.CoreService/GetDevice"
	CoreService_GetChildDevice_FullMethodName                 = "/core_service.CoreService/GetChildDevice"
	CoreService_GetChildDevices_FullMethodName                = "/core_service.CoreService/GetChildDevices"
	CoreService_SendPacketIn_FullMethodName                   = "/core_service.CoreService/SendPacketIn"
	CoreService_DeviceReasonUpdate_FullMethodName             = "/core_service.CoreService/DeviceReasonUpdate"
	CoreService_PortStateUpdate_FullMethodName                = "/core_service.CoreService/PortStateUpdate"
	CoreService_ReconcileChildDevices_FullMethodName          = "/core_service.CoreService/ReconcileChildDevices"
	CoreService_GetChildDeviceWithProxyAddress_FullMethodName = "/core_service.CoreService/GetChildDeviceWithProxyAddress"
	CoreService_GetPorts_FullMethodName                       = "/core_service.CoreService/GetPorts"
	CoreService_ChildrenStateUpdate_FullMethodName            = "/core_service.CoreService/ChildrenStateUpdate"
	CoreService_UpdateImageDownload_FullMethodName            = "/core_service.CoreService/UpdateImageDownload"
)

// CoreServiceClient is the client API for CoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// The CoreService is a gRPC service implemented by the Voltha RW-Core for the
// sole purpose of serving requests/updates from the Voltha adapters.
type CoreServiceClient interface {
	// GetHealthStatus is used by a CoreService client to verify connectivity
	// to the gRPC server hosting the CoreService service
	GetHealthStatus(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[common.Connection, health.HealthStatus], error)
	RegisterAdapter(ctx context.Context, in *core_adapter.AdapterRegistration, opts ...grpc.CallOption) (*emptypb.Empty, error)
	DeviceUpdate(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*emptypb.Empty, error)
	PortCreated(ctx context.Context, in *voltha.Port, opts ...grpc.CallOption) (*emptypb.Empty, error)
	PortsStateUpdate(ctx context.Context, in *core_adapter.PortStateFilter, opts ...grpc.CallOption) (*emptypb.Empty, error)
	DeleteAllPorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	GetDevicePort(ctx context.Context, in *core_adapter.PortFilter, opts ...grpc.CallOption) (*voltha.Port, error)
	ListDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Ports, error)
	DeviceStateUpdate(ctx context.Context, in *core_adapter.DeviceStateFilter, opts ...grpc.CallOption) (*emptypb.Empty, error)
	DevicePMConfigUpdate(ctx context.Context, in *voltha.PmConfigs, opts ...grpc.CallOption) (*emptypb.Empty, error)
	ChildDeviceDetected(ctx context.Context, in *core_adapter.DeviceDiscovery, opts ...grpc.CallOption) (*voltha.Device, error)
	ChildDevicesLost(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	ChildDevicesDetected(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	GetDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Device, error)
	GetChildDevice(ctx context.Context, in *core_adapter.ChildDeviceFilter, opts ...grpc.CallOption) (*voltha.Device, error)
	GetChildDevices(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Devices, error)
	SendPacketIn(ctx context.Context, in *core_adapter.PacketIn, opts ...grpc.CallOption) (*emptypb.Empty, error)
	DeviceReasonUpdate(ctx context.Context, in *core_adapter.DeviceReason, opts ...grpc.CallOption) (*emptypb.Empty, error)
	PortStateUpdate(ctx context.Context, in *core_adapter.PortState, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Additional API found in the Core - unused?
	ReconcileChildDevices(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	GetChildDeviceWithProxyAddress(ctx context.Context, in *voltha.Device_ProxyAddress, opts ...grpc.CallOption) (*voltha.Device, error)
	GetPorts(ctx context.Context, in *core_adapter.PortFilter, opts ...grpc.CallOption) (*voltha.Ports, error)
	ChildrenStateUpdate(ctx context.Context, in *core_adapter.DeviceStateFilter, opts ...grpc.CallOption) (*emptypb.Empty, error)
	UpdateImageDownload(ctx context.Context, in *voltha.ImageDownload, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type coreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCoreServiceClient(cc grpc.ClientConnInterface) CoreServiceClient {
	return &coreServiceClient{cc}
}

func (c *coreServiceClient) GetHealthStatus(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[common.Connection, health.HealthStatus], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &CoreService_ServiceDesc.Streams[0], CoreService_GetHealthStatus_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[common.Connection, health.HealthStatus]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type CoreService_GetHealthStatusClient = grpc.BidiStreamingClient[common.Connection, health.HealthStatus]

func (c *coreServiceClient) RegisterAdapter(ctx context.Context, in *core_adapter.AdapterRegistration, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_RegisterAdapter_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DeviceUpdate(ctx context.Context, in *voltha.Device, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_DeviceUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) PortCreated(ctx context.Context, in *voltha.Port, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_PortCreated_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) PortsStateUpdate(ctx context.Context, in *core_adapter.PortStateFilter, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_PortsStateUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DeleteAllPorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_DeleteAllPorts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetDevicePort(ctx context.Context, in *core_adapter.PortFilter, opts ...grpc.CallOption) (*voltha.Port, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(voltha.Port)
	err := c.cc.Invoke(ctx, CoreService_GetDevicePort_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ListDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Ports, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(voltha.Ports)
	err := c.cc.Invoke(ctx, CoreService_ListDevicePorts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DeviceStateUpdate(ctx context.Context, in *core_adapter.DeviceStateFilter, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_DeviceStateUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DevicePMConfigUpdate(ctx context.Context, in *voltha.PmConfigs, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_DevicePMConfigUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ChildDeviceDetected(ctx context.Context, in *core_adapter.DeviceDiscovery, opts ...grpc.CallOption) (*voltha.Device, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(voltha.Device)
	err := c.cc.Invoke(ctx, CoreService_ChildDeviceDetected_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ChildDevicesLost(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_ChildDevicesLost_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ChildDevicesDetected(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_ChildDevicesDetected_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Device, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(voltha.Device)
	err := c.cc.Invoke(ctx, CoreService_GetDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetChildDevice(ctx context.Context, in *core_adapter.ChildDeviceFilter, opts ...grpc.CallOption) (*voltha.Device, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(voltha.Device)
	err := c.cc.Invoke(ctx, CoreService_GetChildDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetChildDevices(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*voltha.Devices, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(voltha.Devices)
	err := c.cc.Invoke(ctx, CoreService_GetChildDevices_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) SendPacketIn(ctx context.Context, in *core_adapter.PacketIn, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_SendPacketIn_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) DeviceReasonUpdate(ctx context.Context, in *core_adapter.DeviceReason, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_DeviceReasonUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) PortStateUpdate(ctx context.Context, in *core_adapter.PortState, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_PortStateUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ReconcileChildDevices(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_ReconcileChildDevices_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetChildDeviceWithProxyAddress(ctx context.Context, in *voltha.Device_ProxyAddress, opts ...grpc.CallOption) (*voltha.Device, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(voltha.Device)
	err := c.cc.Invoke(ctx, CoreService_GetChildDeviceWithProxyAddress_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) GetPorts(ctx context.Context, in *core_adapter.PortFilter, opts ...grpc.CallOption) (*voltha.Ports, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(voltha.Ports)
	err := c.cc.Invoke(ctx, CoreService_GetPorts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) ChildrenStateUpdate(ctx context.Context, in *core_adapter.DeviceStateFilter, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_ChildrenStateUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *coreServiceClient) UpdateImageDownload(ctx context.Context, in *voltha.ImageDownload, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CoreService_UpdateImageDownload_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CoreServiceServer is the server API for CoreService service.
// All implementations must embed UnimplementedCoreServiceServer
// for forward compatibility.
//
// The CoreService is a gRPC service implemented by the Voltha RW-Core for the
// sole purpose of serving requests/updates from the Voltha adapters.
type CoreServiceServer interface {
	// GetHealthStatus is used by a CoreService client to verify connectivity
	// to the gRPC server hosting the CoreService service
	GetHealthStatus(grpc.BidiStreamingServer[common.Connection, health.HealthStatus]) error
	RegisterAdapter(context.Context, *core_adapter.AdapterRegistration) (*emptypb.Empty, error)
	DeviceUpdate(context.Context, *voltha.Device) (*emptypb.Empty, error)
	PortCreated(context.Context, *voltha.Port) (*emptypb.Empty, error)
	PortsStateUpdate(context.Context, *core_adapter.PortStateFilter) (*emptypb.Empty, error)
	DeleteAllPorts(context.Context, *common.ID) (*emptypb.Empty, error)
	GetDevicePort(context.Context, *core_adapter.PortFilter) (*voltha.Port, error)
	ListDevicePorts(context.Context, *common.ID) (*voltha.Ports, error)
	DeviceStateUpdate(context.Context, *core_adapter.DeviceStateFilter) (*emptypb.Empty, error)
	DevicePMConfigUpdate(context.Context, *voltha.PmConfigs) (*emptypb.Empty, error)
	ChildDeviceDetected(context.Context, *core_adapter.DeviceDiscovery) (*voltha.Device, error)
	ChildDevicesLost(context.Context, *common.ID) (*emptypb.Empty, error)
	ChildDevicesDetected(context.Context, *common.ID) (*emptypb.Empty, error)
	GetDevice(context.Context, *common.ID) (*voltha.Device, error)
	GetChildDevice(context.Context, *core_adapter.ChildDeviceFilter) (*voltha.Device, error)
	GetChildDevices(context.Context, *common.ID) (*voltha.Devices, error)
	SendPacketIn(context.Context, *core_adapter.PacketIn) (*emptypb.Empty, error)
	DeviceReasonUpdate(context.Context, *core_adapter.DeviceReason) (*emptypb.Empty, error)
	PortStateUpdate(context.Context, *core_adapter.PortState) (*emptypb.Empty, error)
	// Additional API found in the Core - unused?
	ReconcileChildDevices(context.Context, *common.ID) (*emptypb.Empty, error)
	GetChildDeviceWithProxyAddress(context.Context, *voltha.Device_ProxyAddress) (*voltha.Device, error)
	GetPorts(context.Context, *core_adapter.PortFilter) (*voltha.Ports, error)
	ChildrenStateUpdate(context.Context, *core_adapter.DeviceStateFilter) (*emptypb.Empty, error)
	UpdateImageDownload(context.Context, *voltha.ImageDownload) (*emptypb.Empty, error)
	mustEmbedUnimplementedCoreServiceServer()
}

// UnimplementedCoreServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedCoreServiceServer struct{}

func (UnimplementedCoreServiceServer) GetHealthStatus(grpc.BidiStreamingServer[common.Connection, health.HealthStatus]) error {
	return status.Error(codes.Unimplemented, "method GetHealthStatus not implemented")
}
func (UnimplementedCoreServiceServer) RegisterAdapter(context.Context, *core_adapter.AdapterRegistration) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method RegisterAdapter not implemented")
}
func (UnimplementedCoreServiceServer) DeviceUpdate(context.Context, *voltha.Device) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeviceUpdate not implemented")
}
func (UnimplementedCoreServiceServer) PortCreated(context.Context, *voltha.Port) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method PortCreated not implemented")
}
func (UnimplementedCoreServiceServer) PortsStateUpdate(context.Context, *core_adapter.PortStateFilter) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method PortsStateUpdate not implemented")
}
func (UnimplementedCoreServiceServer) DeleteAllPorts(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteAllPorts not implemented")
}
func (UnimplementedCoreServiceServer) GetDevicePort(context.Context, *core_adapter.PortFilter) (*voltha.Port, error) {
	return nil, status.Error(codes.Unimplemented, "method GetDevicePort not implemented")
}
func (UnimplementedCoreServiceServer) ListDevicePorts(context.Context, *common.ID) (*voltha.Ports, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDevicePorts not implemented")
}
func (UnimplementedCoreServiceServer) DeviceStateUpdate(context.Context, *core_adapter.DeviceStateFilter) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeviceStateUpdate not implemented")
}
func (UnimplementedCoreServiceServer) DevicePMConfigUpdate(context.Context, *voltha.PmConfigs) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DevicePMConfigUpdate not implemented")
}
func (UnimplementedCoreServiceServer) ChildDeviceDetected(context.Context, *core_adapter.DeviceDiscovery) (*voltha.Device, error) {
	return nil, status.Error(codes.Unimplemented, "method ChildDeviceDetected not implemented")
}
func (UnimplementedCoreServiceServer) ChildDevicesLost(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method ChildDevicesLost not implemented")
}
func (UnimplementedCoreServiceServer) ChildDevicesDetected(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method ChildDevicesDetected not implemented")
}
func (UnimplementedCoreServiceServer) GetDevice(context.Context, *common.ID) (*voltha.Device, error) {
	return nil, status.Error(codes.Unimplemented, "method GetDevice not implemented")
}
func (UnimplementedCoreServiceServer) GetChildDevice(context.Context, *core_adapter.ChildDeviceFilter) (*voltha.Device, error) {
	return nil, status.Error(codes.Unimplemented, "method GetChildDevice not implemented")
}
func (UnimplementedCoreServiceServer) GetChildDevices(context.Context, *common.ID) (*voltha.Devices, error) {
	return nil, status.Error(codes.Unimplemented, "method GetChildDevices not implemented")
}
func (UnimplementedCoreServiceServer) SendPacketIn(context.Context, *core_adapter.PacketIn) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method SendPacketIn not implemented")
}
func (UnimplementedCoreServiceServer) DeviceReasonUpdate(context.Context, *core_adapter.DeviceReason) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeviceReasonUpdate not implemented")
}
func (UnimplementedCoreServiceServer) PortStateUpdate(context.Context, *core_adapter.PortState) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method PortStateUpdate not implemented")
}
func (UnimplementedCoreServiceServer) ReconcileChildDevices(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method ReconcileChildDevices not implemented")
}
func (UnimplementedCoreServiceServer) GetChildDeviceWithProxyAddress(context.Context, *voltha.Device_ProxyAddress) (*voltha.Device, error) {
	return nil, status.Error(codes.Unimplemented, "method GetChildDeviceWithProxyAddress not implemented")
}
func (UnimplementedCoreServiceServer) GetPorts(context.Context, *core_adapter.PortFilter) (*voltha.Ports, error) {
	return nil, status.Error(codes.Unimplemented, "method GetPorts not implemented")
}
func (UnimplementedCoreServiceServer) ChildrenStateUpdate(context.Context, *core_adapter.DeviceStateFilter) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method ChildrenStateUpdate not implemented")
}
func (UnimplementedCoreServiceServer) UpdateImageDownload(context.Context, *voltha.ImageDownload) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateImageDownload not implemented")
}
func (UnimplementedCoreServiceServer) mustEmbedUnimplementedCoreServiceServer() {}
func (UnimplementedCoreServiceServer) testEmbeddedByValue()                     {}

// UnsafeCoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CoreServiceServer will
// result in compilation errors.
type UnsafeCoreServiceServer interface {
	mustEmbedUnimplementedCoreServiceServer()
}

func RegisterCoreServiceServer(s grpc.ServiceRegistrar, srv CoreServiceServer) {
	// If the following call panics, it indicates UnimplementedCoreServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&CoreService_ServiceDesc, srv)
}

func _CoreService_GetHealthStatus_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CoreServiceServer).GetHealthStatus(&grpc.GenericServerStream[common.Connection, health.HealthStatus]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type CoreService_GetHealthStatusServer = grpc.BidiStreamingServer[common.Connection, health.HealthStatus]

func _CoreService_RegisterAdapter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.AdapterRegistration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).RegisterAdapter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_RegisterAdapter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).RegisterAdapter(ctx, req.(*core_adapter.AdapterRegistration))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DeviceUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.Device)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DeviceUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_DeviceUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DeviceUpdate(ctx, req.(*voltha.Device))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_PortCreated_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.Port)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).PortCreated(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_PortCreated_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).PortCreated(ctx, req.(*voltha.Port))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_PortsStateUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.PortStateFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).PortsStateUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_PortsStateUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).PortsStateUpdate(ctx, req.(*core_adapter.PortStateFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DeleteAllPorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DeleteAllPorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_DeleteAllPorts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DeleteAllPorts(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetDevicePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.PortFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetDevicePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_GetDevicePort_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetDevicePort(ctx, req.(*core_adapter.PortFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ListDevicePorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ListDevicePorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_ListDevicePorts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ListDevicePorts(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DeviceStateUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.DeviceStateFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DeviceStateUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_DeviceStateUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DeviceStateUpdate(ctx, req.(*core_adapter.DeviceStateFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DevicePMConfigUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.PmConfigs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DevicePMConfigUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_DevicePMConfigUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DevicePMConfigUpdate(ctx, req.(*voltha.PmConfigs))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ChildDeviceDetected_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.DeviceDiscovery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ChildDeviceDetected(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_ChildDeviceDetected_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ChildDeviceDetected(ctx, req.(*core_adapter.DeviceDiscovery))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ChildDevicesLost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ChildDevicesLost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_ChildDevicesLost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ChildDevicesLost(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ChildDevicesDetected_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ChildDevicesDetected(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_ChildDevicesDetected_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ChildDevicesDetected(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_GetDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetChildDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.ChildDeviceFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetChildDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_GetChildDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetChildDevice(ctx, req.(*core_adapter.ChildDeviceFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetChildDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetChildDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_GetChildDevices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetChildDevices(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_SendPacketIn_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.PacketIn)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).SendPacketIn(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_SendPacketIn_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).SendPacketIn(ctx, req.(*core_adapter.PacketIn))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_DeviceReasonUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.DeviceReason)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).DeviceReasonUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_DeviceReasonUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).DeviceReasonUpdate(ctx, req.(*core_adapter.DeviceReason))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_PortStateUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.PortState)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).PortStateUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_PortStateUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).PortStateUpdate(ctx, req.(*core_adapter.PortState))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ReconcileChildDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ReconcileChildDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_ReconcileChildDevices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ReconcileChildDevices(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetChildDeviceWithProxyAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.Device_ProxyAddress)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetChildDeviceWithProxyAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_GetChildDeviceWithProxyAddress_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetChildDeviceWithProxyAddress(ctx, req.(*voltha.Device_ProxyAddress))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_GetPorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.PortFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).GetPorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_GetPorts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).GetPorts(ctx, req.(*core_adapter.PortFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_ChildrenStateUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(core_adapter.DeviceStateFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).ChildrenStateUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_ChildrenStateUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).ChildrenStateUpdate(ctx, req.(*core_adapter.DeviceStateFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _CoreService_UpdateImageDownload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voltha.ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CoreServiceServer).UpdateImageDownload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CoreService_UpdateImageDownload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CoreServiceServer).UpdateImageDownload(ctx, req.(*voltha.ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

// CoreService_ServiceDesc is the grpc.ServiceDesc for CoreService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CoreService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "core_service.CoreService",
	HandlerType: (*CoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RegisterAdapter",
			Handler:    _CoreService_RegisterAdapter_Handler,
		},
		{
			MethodName: "DeviceUpdate",
			Handler:    _CoreService_DeviceUpdate_Handler,
		},
		{
			MethodName: "PortCreated",
			Handler:    _CoreService_PortCreated_Handler,
		},
		{
			MethodName: "PortsStateUpdate",
			Handler:    _CoreService_PortsStateUpdate_Handler,
		},
		{
			MethodName: "DeleteAllPorts",
			Handler:    _CoreService_DeleteAllPorts_Handler,
		},
		{
			MethodName: "GetDevicePort",
			Handler:    _CoreService_GetDevicePort_Handler,
		},
		{
			MethodName: "ListDevicePorts",
			Handler:    _CoreService_ListDevicePorts_Handler,
		},
		{
			MethodName: "DeviceStateUpdate",
			Handler:    _CoreService_DeviceStateUpdate_Handler,
		},
		{
			MethodName: "DevicePMConfigUpdate",
			Handler:    _CoreService_DevicePMConfigUpdate_Handler,
		},
		{
			MethodName: "ChildDeviceDetected",
			Handler:    _CoreService_ChildDeviceDetected_Handler,
		},
		{
			MethodName: "ChildDevicesLost",
			Handler:    _CoreService_ChildDevicesLost_Handler,
		},
		{
			MethodName: "ChildDevicesDetected",
			Handler:    _CoreService_ChildDevicesDetected_Handler,
		},
		{
			MethodName: "GetDevice",
			Handler:    _CoreService_GetDevice_Handler,
		},
		{
			MethodName: "GetChildDevice",
			Handler:    _CoreService_GetChildDevice_Handler,
		},
		{
			MethodName: "GetChildDevices",
			Handler:    _CoreService_GetChildDevices_Handler,
		},
		{
			MethodName: "SendPacketIn",
			Handler:    _CoreService_SendPacketIn_Handler,
		},
		{
			MethodName: "DeviceReasonUpdate",
			Handler:    _CoreService_DeviceReasonUpdate_Handler,
		},
		{
			MethodName: "PortStateUpdate",
			Handler:    _CoreService_PortStateUpdate_Handler,
		},
		{
			MethodName: "ReconcileChildDevices",
			Handler:    _CoreService_ReconcileChildDevices_Handler,
		},
		{
			MethodName: "GetChildDeviceWithProxyAddress",
			Handler:    _CoreService_GetChildDeviceWithProxyAddress_Handler,
		},
		{
			MethodName: "GetPorts",
			Handler:    _CoreService_GetPorts_Handler,
		},
		{
			MethodName: "ChildrenStateUpdate",
			Handler:    _CoreService_ChildrenStateUpdate_Handler,
		},
		{
			MethodName: "UpdateImageDownload",
			Handler:    _CoreService_UpdateImageDownload_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetHealthStatus",
			Handler:       _CoreService_GetHealthStatus_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "voltha_protos/core_services.proto",
}
