// Copyright 2018-2024 Open Networking Foundation (ONF) and the ONF Contributors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at:
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v4.25.8
// source: voltha_protos/voip_system_profile.proto

package voip_system_profile

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type VoipSystemProfileRequest struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	Key               string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	VoipSystemProfile *VoipSystemProfile     `protobuf:"bytes,2,opt,name=voipSystemProfile,proto3" json:"voipSystemProfile,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *VoipSystemProfileRequest) Reset() {
	*x = VoipSystemProfileRequest{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoipSystemProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoipSystemProfileRequest) ProtoMessage() {}

func (x *VoipSystemProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoipSystemProfileRequest.ProtoReflect.Descriptor instead.
func (*VoipSystemProfileRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{0}
}

func (x *VoipSystemProfileRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *VoipSystemProfileRequest) GetVoipSystemProfile() *VoipSystemProfile {
	if x != nil {
		return x.VoipSystemProfile
	}
	return nil
}

// A system wide profile for voip service that can be stored into voltha KV anytime.
// Designed based on G988-2017 (also designed flexible to be able to be modified later on)
type VoipSystemProfile struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	SipConfig     *SipConfig             `protobuf:"bytes,1,opt,name=sipConfig,proto3" json:"sipConfig,omitempty"`
	VoipConfig    *VoipConfig            `protobuf:"bytes,2,opt,name=voipConfig,proto3" json:"voipConfig,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VoipSystemProfile) Reset() {
	*x = VoipSystemProfile{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoipSystemProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoipSystemProfile) ProtoMessage() {}

func (x *VoipSystemProfile) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoipSystemProfile.ProtoReflect.Descriptor instead.
func (*VoipSystemProfile) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{1}
}

func (x *VoipSystemProfile) GetSipConfig() *SipConfig {
	if x != nil {
		return x.SipConfig
	}
	return nil
}

func (x *VoipSystemProfile) GetVoipConfig() *VoipConfig {
	if x != nil {
		return x.VoipConfig
	}
	return nil
}

// Common voip fields are grouped here
type VoipConfig struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	IpHostConfig        *IpHostConfig          `protobuf:"bytes,1,opt,name=ipHostConfig,proto3" json:"ipHostConfig,omitempty"`
	TcpUdpConfig        *TcpUdpConfig          `protobuf:"bytes,2,opt,name=tcpUdpConfig,proto3" json:"tcpUdpConfig,omitempty"`
	VoipVoiceCtp        *VoipVoiceCtp          `protobuf:"bytes,3,opt,name=voipVoiceCtp,proto3" json:"voipVoiceCtp,omitempty"`
	VoipMediaProfile    *VoipMediaProfile      `protobuf:"bytes,4,opt,name=voipMediaProfile,proto3" json:"voipMediaProfile,omitempty"`
	VoiceServiceProfile *VoiceServiceProfile   `protobuf:"bytes,5,opt,name=voiceServiceProfile,proto3" json:"voiceServiceProfile,omitempty"`
	RtpProfile          *RtpProfile            `protobuf:"bytes,6,opt,name=rtpProfile,proto3" json:"rtpProfile,omitempty"`
	PptpPotsUni         *PptpPotsUni           `protobuf:"bytes,7,opt,name=pptpPotsUni,proto3" json:"pptpPotsUni,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *VoipConfig) Reset() {
	*x = VoipConfig{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoipConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoipConfig) ProtoMessage() {}

func (x *VoipConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoipConfig.ProtoReflect.Descriptor instead.
func (*VoipConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{2}
}

func (x *VoipConfig) GetIpHostConfig() *IpHostConfig {
	if x != nil {
		return x.IpHostConfig
	}
	return nil
}

func (x *VoipConfig) GetTcpUdpConfig() *TcpUdpConfig {
	if x != nil {
		return x.TcpUdpConfig
	}
	return nil
}

func (x *VoipConfig) GetVoipVoiceCtp() *VoipVoiceCtp {
	if x != nil {
		return x.VoipVoiceCtp
	}
	return nil
}

func (x *VoipConfig) GetVoipMediaProfile() *VoipMediaProfile {
	if x != nil {
		return x.VoipMediaProfile
	}
	return nil
}

func (x *VoipConfig) GetVoiceServiceProfile() *VoiceServiceProfile {
	if x != nil {
		return x.VoiceServiceProfile
	}
	return nil
}

func (x *VoipConfig) GetRtpProfile() *RtpProfile {
	if x != nil {
		return x.RtpProfile
	}
	return nil
}

func (x *VoipConfig) GetPptpPotsUni() *PptpPotsUni {
	if x != nil {
		return x.PptpPotsUni
	}
	return nil
}

type IpHostConfig struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	IpOptions         uint32                 `protobuf:"varint,1,opt,name=ipOptions,proto3" json:"ipOptions,omitempty"`
	OnuIdentifier     string                 `protobuf:"bytes,2,opt,name=onuIdentifier,proto3" json:"onuIdentifier,omitempty"`
	IpAddress         string                 `protobuf:"bytes,3,opt,name=ipAddress,proto3" json:"ipAddress,omitempty"`
	Mask              string                 `protobuf:"bytes,4,opt,name=mask,proto3" json:"mask,omitempty"`
	Gateway           string                 `protobuf:"bytes,5,opt,name=gateway,proto3" json:"gateway,omitempty"`
	PrimaryDns        string                 `protobuf:"bytes,6,opt,name=primaryDns,proto3" json:"primaryDns,omitempty"`
	SecondaryDns      string                 `protobuf:"bytes,7,opt,name=secondaryDns,proto3" json:"secondaryDns,omitempty"`
	RelayAgentOptions string                 `protobuf:"bytes,8,opt,name=relayAgentOptions,proto3" json:"relayAgentOptions,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *IpHostConfig) Reset() {
	*x = IpHostConfig{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IpHostConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IpHostConfig) ProtoMessage() {}

func (x *IpHostConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IpHostConfig.ProtoReflect.Descriptor instead.
func (*IpHostConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{3}
}

func (x *IpHostConfig) GetIpOptions() uint32 {
	if x != nil {
		return x.IpOptions
	}
	return 0
}

func (x *IpHostConfig) GetOnuIdentifier() string {
	if x != nil {
		return x.OnuIdentifier
	}
	return ""
}

func (x *IpHostConfig) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *IpHostConfig) GetMask() string {
	if x != nil {
		return x.Mask
	}
	return ""
}

func (x *IpHostConfig) GetGateway() string {
	if x != nil {
		return x.Gateway
	}
	return ""
}

func (x *IpHostConfig) GetPrimaryDns() string {
	if x != nil {
		return x.PrimaryDns
	}
	return ""
}

func (x *IpHostConfig) GetSecondaryDns() string {
	if x != nil {
		return x.SecondaryDns
	}
	return ""
}

func (x *IpHostConfig) GetRelayAgentOptions() string {
	if x != nil {
		return x.RelayAgentOptions
	}
	return ""
}

type TcpUdpConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Protocol      uint32                 `protobuf:"varint,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	TosField      string                 `protobuf:"bytes,2,opt,name=tosField,proto3" json:"tosField,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TcpUdpConfig) Reset() {
	*x = TcpUdpConfig{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpUdpConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpUdpConfig) ProtoMessage() {}

func (x *TcpUdpConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpUdpConfig.ProtoReflect.Descriptor instead.
func (*TcpUdpConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{4}
}

func (x *TcpUdpConfig) GetProtocol() uint32 {
	if x != nil {
		return x.Protocol
	}
	return 0
}

func (x *TcpUdpConfig) GetTosField() string {
	if x != nil {
		return x.TosField
	}
	return ""
}

type VoipVoiceCtp struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	SignallingCode uint32                 `protobuf:"varint,1,opt,name=signallingCode,proto3" json:"signallingCode,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *VoipVoiceCtp) Reset() {
	*x = VoipVoiceCtp{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoipVoiceCtp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoipVoiceCtp) ProtoMessage() {}

func (x *VoipVoiceCtp) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoipVoiceCtp.ProtoReflect.Descriptor instead.
func (*VoipVoiceCtp) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{5}
}

func (x *VoipVoiceCtp) GetSignallingCode() uint32 {
	if x != nil {
		return x.SignallingCode
	}
	return 0
}

type VoipMediaProfile struct {
	state                  protoimpl.MessageState `protogen:"open.v1"`
	FaxMode                uint32                 `protobuf:"varint,1,opt,name=faxMode,proto3" json:"faxMode,omitempty"`
	CodecSelection1        uint32                 `protobuf:"varint,2,opt,name=codecSelection1,proto3" json:"codecSelection1,omitempty"`
	PacketPeriodSelection1 uint32                 `protobuf:"varint,3,opt,name=packetPeriodSelection1,proto3" json:"packetPeriodSelection1,omitempty"`
	SilenceSuppression1    uint32                 `protobuf:"varint,4,opt,name=silenceSuppression1,proto3" json:"silenceSuppression1,omitempty"`
	CodecSelection2        uint32                 `protobuf:"varint,5,opt,name=codecSelection2,proto3" json:"codecSelection2,omitempty"`
	PacketPeriodSelection2 uint32                 `protobuf:"varint,6,opt,name=packetPeriodSelection2,proto3" json:"packetPeriodSelection2,omitempty"`
	SilenceSuppression2    uint32                 `protobuf:"varint,7,opt,name=silenceSuppression2,proto3" json:"silenceSuppression2,omitempty"`
	CodecSelection3        uint32                 `protobuf:"varint,8,opt,name=codecSelection3,proto3" json:"codecSelection3,omitempty"`
	PacketPeriodSelection3 uint32                 `protobuf:"varint,9,opt,name=packetPeriodSelection3,proto3" json:"packetPeriodSelection3,omitempty"`
	SilenceSuppression3    uint32                 `protobuf:"varint,10,opt,name=silenceSuppression3,proto3" json:"silenceSuppression3,omitempty"`
	CodecSelection4        uint32                 `protobuf:"varint,11,opt,name=codecSelection4,proto3" json:"codecSelection4,omitempty"`
	PacketPeriodSelection4 uint32                 `protobuf:"varint,12,opt,name=packetPeriodSelection4,proto3" json:"packetPeriodSelection4,omitempty"`
	SilenceSuppression4    uint32                 `protobuf:"varint,13,opt,name=silenceSuppression4,proto3" json:"silenceSuppression4,omitempty"`
	OobDtmf                uint32                 `protobuf:"varint,14,opt,name=oobDtmf,proto3" json:"oobDtmf,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *VoipMediaProfile) Reset() {
	*x = VoipMediaProfile{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoipMediaProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoipMediaProfile) ProtoMessage() {}

func (x *VoipMediaProfile) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoipMediaProfile.ProtoReflect.Descriptor instead.
func (*VoipMediaProfile) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{6}
}

func (x *VoipMediaProfile) GetFaxMode() uint32 {
	if x != nil {
		return x.FaxMode
	}
	return 0
}

func (x *VoipMediaProfile) GetCodecSelection1() uint32 {
	if x != nil {
		return x.CodecSelection1
	}
	return 0
}

func (x *VoipMediaProfile) GetPacketPeriodSelection1() uint32 {
	if x != nil {
		return x.PacketPeriodSelection1
	}
	return 0
}

func (x *VoipMediaProfile) GetSilenceSuppression1() uint32 {
	if x != nil {
		return x.SilenceSuppression1
	}
	return 0
}

func (x *VoipMediaProfile) GetCodecSelection2() uint32 {
	if x != nil {
		return x.CodecSelection2
	}
	return 0
}

func (x *VoipMediaProfile) GetPacketPeriodSelection2() uint32 {
	if x != nil {
		return x.PacketPeriodSelection2
	}
	return 0
}

func (x *VoipMediaProfile) GetSilenceSuppression2() uint32 {
	if x != nil {
		return x.SilenceSuppression2
	}
	return 0
}

func (x *VoipMediaProfile) GetCodecSelection3() uint32 {
	if x != nil {
		return x.CodecSelection3
	}
	return 0
}

func (x *VoipMediaProfile) GetPacketPeriodSelection3() uint32 {
	if x != nil {
		return x.PacketPeriodSelection3
	}
	return 0
}

func (x *VoipMediaProfile) GetSilenceSuppression3() uint32 {
	if x != nil {
		return x.SilenceSuppression3
	}
	return 0
}

func (x *VoipMediaProfile) GetCodecSelection4() uint32 {
	if x != nil {
		return x.CodecSelection4
	}
	return 0
}

func (x *VoipMediaProfile) GetPacketPeriodSelection4() uint32 {
	if x != nil {
		return x.PacketPeriodSelection4
	}
	return 0
}

func (x *VoipMediaProfile) GetSilenceSuppression4() uint32 {
	if x != nil {
		return x.SilenceSuppression4
	}
	return 0
}

func (x *VoipMediaProfile) GetOobDtmf() uint32 {
	if x != nil {
		return x.OobDtmf
	}
	return 0
}

type VoiceServiceProfile struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	AnnouncementType     uint32                 `protobuf:"varint,1,opt,name=announcementType,proto3" json:"announcementType,omitempty"`
	JitterTarget         uint32                 `protobuf:"varint,2,opt,name=jitterTarget,proto3" json:"jitterTarget,omitempty"`
	JitterBufferMax      uint32                 `protobuf:"varint,3,opt,name=jitterBufferMax,proto3" json:"jitterBufferMax,omitempty"`
	EchoCancelInd        bool                   `protobuf:"varint,4,opt,name=echoCancelInd,proto3" json:"echoCancelInd,omitempty"`
	PstnProtocolVariant  uint32                 `protobuf:"varint,5,opt,name=pstnProtocolVariant,proto3" json:"pstnProtocolVariant,omitempty"`
	DtmfDigitLevels      uint32                 `protobuf:"varint,6,opt,name=dtmfDigitLevels,proto3" json:"dtmfDigitLevels,omitempty"`
	DtmfDigitDuration    uint32                 `protobuf:"varint,7,opt,name=dtmfDigitDuration,proto3" json:"dtmfDigitDuration,omitempty"`
	HookFlashMinimumTime uint32                 `protobuf:"varint,8,opt,name=hookFlashMinimumTime,proto3" json:"hookFlashMinimumTime,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *VoiceServiceProfile) Reset() {
	*x = VoiceServiceProfile{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoiceServiceProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoiceServiceProfile) ProtoMessage() {}

func (x *VoiceServiceProfile) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoiceServiceProfile.ProtoReflect.Descriptor instead.
func (*VoiceServiceProfile) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{7}
}

func (x *VoiceServiceProfile) GetAnnouncementType() uint32 {
	if x != nil {
		return x.AnnouncementType
	}
	return 0
}

func (x *VoiceServiceProfile) GetJitterTarget() uint32 {
	if x != nil {
		return x.JitterTarget
	}
	return 0
}

func (x *VoiceServiceProfile) GetJitterBufferMax() uint32 {
	if x != nil {
		return x.JitterBufferMax
	}
	return 0
}

func (x *VoiceServiceProfile) GetEchoCancelInd() bool {
	if x != nil {
		return x.EchoCancelInd
	}
	return false
}

func (x *VoiceServiceProfile) GetPstnProtocolVariant() uint32 {
	if x != nil {
		return x.PstnProtocolVariant
	}
	return 0
}

func (x *VoiceServiceProfile) GetDtmfDigitLevels() uint32 {
	if x != nil {
		return x.DtmfDigitLevels
	}
	return 0
}

func (x *VoiceServiceProfile) GetDtmfDigitDuration() uint32 {
	if x != nil {
		return x.DtmfDigitDuration
	}
	return 0
}

func (x *VoiceServiceProfile) GetHookFlashMinimumTime() uint32 {
	if x != nil {
		return x.HookFlashMinimumTime
	}
	return 0
}

type RtpProfile struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	LocalPortMin    uint32                 `protobuf:"varint,1,opt,name=localPortMin,proto3" json:"localPortMin,omitempty"`
	LocalPortMax    uint32                 `protobuf:"varint,2,opt,name=localPortMax,proto3" json:"localPortMax,omitempty"`
	DscpMark        string                 `protobuf:"bytes,3,opt,name=dscpMark,proto3" json:"dscpMark,omitempty"`
	PiggyBackEvents uint32                 `protobuf:"varint,4,opt,name=piggyBackEvents,proto3" json:"piggyBackEvents,omitempty"`
	ToneEvents      uint32                 `protobuf:"varint,5,opt,name=toneEvents,proto3" json:"toneEvents,omitempty"`
	DtmfEvents      uint32                 `protobuf:"varint,6,opt,name=dtmfEvents,proto3" json:"dtmfEvents,omitempty"`
	CasEvents       uint32                 `protobuf:"varint,7,opt,name=casEvents,proto3" json:"casEvents,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *RtpProfile) Reset() {
	*x = RtpProfile{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RtpProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RtpProfile) ProtoMessage() {}

func (x *RtpProfile) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RtpProfile.ProtoReflect.Descriptor instead.
func (*RtpProfile) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{8}
}

func (x *RtpProfile) GetLocalPortMin() uint32 {
	if x != nil {
		return x.LocalPortMin
	}
	return 0
}

func (x *RtpProfile) GetLocalPortMax() uint32 {
	if x != nil {
		return x.LocalPortMax
	}
	return 0
}

func (x *RtpProfile) GetDscpMark() string {
	if x != nil {
		return x.DscpMark
	}
	return ""
}

func (x *RtpProfile) GetPiggyBackEvents() uint32 {
	if x != nil {
		return x.PiggyBackEvents
	}
	return 0
}

func (x *RtpProfile) GetToneEvents() uint32 {
	if x != nil {
		return x.ToneEvents
	}
	return 0
}

func (x *RtpProfile) GetDtmfEvents() uint32 {
	if x != nil {
		return x.DtmfEvents
	}
	return 0
}

func (x *RtpProfile) GetCasEvents() uint32 {
	if x != nil {
		return x.CasEvents
	}
	return 0
}

type PptpPotsUni struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	Arc                string                 `protobuf:"bytes,1,opt,name=arc,proto3" json:"arc,omitempty"`
	ArcInterval        string                 `protobuf:"bytes,2,opt,name=arcInterval,proto3" json:"arcInterval,omitempty"`
	Impedance          uint32                 `protobuf:"varint,3,opt,name=impedance,proto3" json:"impedance,omitempty"`
	TransmissionPath   uint32                 `protobuf:"varint,4,opt,name=transmissionPath,proto3" json:"transmissionPath,omitempty"`
	RxGain             int32                  `protobuf:"zigzag32,5,opt,name=rxGain,proto3" json:"rxGain,omitempty"`
	TxGain             int32                  `protobuf:"zigzag32,6,opt,name=txGain,proto3" json:"txGain,omitempty"`
	PotsHoldOverTime   uint32                 `protobuf:"varint,7,opt,name=potsHoldOverTime,proto3" json:"potsHoldOverTime,omitempty"`
	NominalFeedVoltage uint32                 `protobuf:"varint,8,opt,name=nominalFeedVoltage,proto3" json:"nominalFeedVoltage,omitempty"`
	LossOfSoftSwitch   uint32                 `protobuf:"varint,9,opt,name=lossOfSoftSwitch,proto3" json:"lossOfSoftSwitch,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PptpPotsUni) Reset() {
	*x = PptpPotsUni{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PptpPotsUni) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PptpPotsUni) ProtoMessage() {}

func (x *PptpPotsUni) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PptpPotsUni.ProtoReflect.Descriptor instead.
func (*PptpPotsUni) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{9}
}

func (x *PptpPotsUni) GetArc() string {
	if x != nil {
		return x.Arc
	}
	return ""
}

func (x *PptpPotsUni) GetArcInterval() string {
	if x != nil {
		return x.ArcInterval
	}
	return ""
}

func (x *PptpPotsUni) GetImpedance() uint32 {
	if x != nil {
		return x.Impedance
	}
	return 0
}

func (x *PptpPotsUni) GetTransmissionPath() uint32 {
	if x != nil {
		return x.TransmissionPath
	}
	return 0
}

func (x *PptpPotsUni) GetRxGain() int32 {
	if x != nil {
		return x.RxGain
	}
	return 0
}

func (x *PptpPotsUni) GetTxGain() int32 {
	if x != nil {
		return x.TxGain
	}
	return 0
}

func (x *PptpPotsUni) GetPotsHoldOverTime() uint32 {
	if x != nil {
		return x.PotsHoldOverTime
	}
	return 0
}

func (x *PptpPotsUni) GetNominalFeedVoltage() uint32 {
	if x != nil {
		return x.NominalFeedVoltage
	}
	return 0
}

func (x *PptpPotsUni) GetLossOfSoftSwitch() uint32 {
	if x != nil {
		return x.LossOfSoftSwitch
	}
	return 0
}

// Sip specific fields are grouped here
type SipConfig struct {
	state                         protoimpl.MessageState         `protogen:"open.v1"`
	SipUserData                   *SipUserData                   `protobuf:"bytes,1,opt,name=sipUserData,proto3" json:"sipUserData,omitempty"`
	SipAgentConfig                *SipAgentConfig                `protobuf:"bytes,2,opt,name=sipAgentConfig,proto3" json:"sipAgentConfig,omitempty"`
	NetworkDialPlan               *NetworkDialPlan               `protobuf:"bytes,3,opt,name=networkDialPlan,proto3" json:"networkDialPlan,omitempty"`
	VoipFeatureAccessCodes        *VoipFeatureAccessCodes        `protobuf:"bytes,4,opt,name=voipFeatureAccessCodes,proto3" json:"voipFeatureAccessCodes,omitempty"`
	VoipApplicationServiceProfile *VoipApplicationServiceProfile `protobuf:"bytes,5,opt,name=voipApplicationServiceProfile,proto3" json:"voipApplicationServiceProfile,omitempty"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *SipConfig) Reset() {
	*x = SipConfig{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SipConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SipConfig) ProtoMessage() {}

func (x *SipConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SipConfig.ProtoReflect.Descriptor instead.
func (*SipConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{10}
}

func (x *SipConfig) GetSipUserData() *SipUserData {
	if x != nil {
		return x.SipUserData
	}
	return nil
}

func (x *SipConfig) GetSipAgentConfig() *SipAgentConfig {
	if x != nil {
		return x.SipAgentConfig
	}
	return nil
}

func (x *SipConfig) GetNetworkDialPlan() *NetworkDialPlan {
	if x != nil {
		return x.NetworkDialPlan
	}
	return nil
}

func (x *SipConfig) GetVoipFeatureAccessCodes() *VoipFeatureAccessCodes {
	if x != nil {
		return x.VoipFeatureAccessCodes
	}
	return nil
}

func (x *SipConfig) GetVoipApplicationServiceProfile() *VoipApplicationServiceProfile {
	if x != nil {
		return x.VoipApplicationServiceProfile
	}
	return nil
}

type SipUserData struct {
	state                               protoimpl.MessageState `protogen:"open.v1"`
	UserPartAor                         string                 `protobuf:"bytes,1,opt,name=userPartAor,proto3" json:"userPartAor,omitempty"`
	UsernameAndPassword                 *UsernameAndPassword   `protobuf:"bytes,2,opt,name=usernameAndPassword,proto3" json:"usernameAndPassword,omitempty"`
	VoicemailServerSipUri               string                 `protobuf:"bytes,3,opt,name=voicemailServerSipUri,proto3" json:"voicemailServerSipUri,omitempty"`
	VoicemailSubscriptionExpirationTime int32                  `protobuf:"varint,4,opt,name=voicemailSubscriptionExpirationTime,proto3" json:"voicemailSubscriptionExpirationTime,omitempty"`
	ReleaseTimer                        int32                  `protobuf:"varint,5,opt,name=releaseTimer,proto3" json:"releaseTimer,omitempty"`
	RohTimer                            int32                  `protobuf:"varint,6,opt,name=rohTimer,proto3" json:"rohTimer,omitempty"`
	unknownFields                       protoimpl.UnknownFields
	sizeCache                           protoimpl.SizeCache
}

func (x *SipUserData) Reset() {
	*x = SipUserData{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SipUserData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SipUserData) ProtoMessage() {}

func (x *SipUserData) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SipUserData.ProtoReflect.Descriptor instead.
func (*SipUserData) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{11}
}

func (x *SipUserData) GetUserPartAor() string {
	if x != nil {
		return x.UserPartAor
	}
	return ""
}

func (x *SipUserData) GetUsernameAndPassword() *UsernameAndPassword {
	if x != nil {
		return x.UsernameAndPassword
	}
	return nil
}

func (x *SipUserData) GetVoicemailServerSipUri() string {
	if x != nil {
		return x.VoicemailServerSipUri
	}
	return ""
}

func (x *SipUserData) GetVoicemailSubscriptionExpirationTime() int32 {
	if x != nil {
		return x.VoicemailSubscriptionExpirationTime
	}
	return 0
}

func (x *SipUserData) GetReleaseTimer() int32 {
	if x != nil {
		return x.ReleaseTimer
	}
	return 0
}

func (x *SipUserData) GetRohTimer() int32 {
	if x != nil {
		return x.RohTimer
	}
	return 0
}

type SipAgentConfig struct {
	state                    protoimpl.MessageState `protogen:"open.v1"`
	OutboundProxyAddress     string                 `protobuf:"bytes,1,opt,name=outboundProxyAddress,proto3" json:"outboundProxyAddress,omitempty"`
	PrimarySipDns            string                 `protobuf:"bytes,2,opt,name=primarySipDns,proto3" json:"primarySipDns,omitempty"`
	SecondarySipDns          string                 `protobuf:"bytes,3,opt,name=secondarySipDns,proto3" json:"secondarySipDns,omitempty"`
	SipRegExpTime            int32                  `protobuf:"varint,4,opt,name=sipRegExpTime,proto3" json:"sipRegExpTime,omitempty"`
	SipReregHeadStartTime    int32                  `protobuf:"varint,5,opt,name=sipReregHeadStartTime,proto3" json:"sipReregHeadStartTime,omitempty"`
	SipRegistrar             string                 `protobuf:"bytes,6,opt,name=SipRegistrar,proto3" json:"SipRegistrar,omitempty"`
	SoftSwitch               string                 `protobuf:"bytes,7,opt,name=softSwitch,proto3" json:"softSwitch,omitempty"`
	SipResponseTable         *SipResponseTable      `protobuf:"bytes,8,opt,name=sipResponseTable,proto3" json:"sipResponseTable,omitempty"`
	SipOptionTransmitControl bool                   `protobuf:"varint,9,opt,name=sipOptionTransmitControl,proto3" json:"sipOptionTransmitControl,omitempty"`
	SipUriFormat             string                 `protobuf:"bytes,10,opt,name=sipUriFormat,proto3" json:"sipUriFormat,omitempty"`
	RedundantSipAgentPointer string                 `protobuf:"bytes,11,opt,name=redundantSipAgentPointer,proto3" json:"redundantSipAgentPointer,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *SipAgentConfig) Reset() {
	*x = SipAgentConfig{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SipAgentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SipAgentConfig) ProtoMessage() {}

func (x *SipAgentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SipAgentConfig.ProtoReflect.Descriptor instead.
func (*SipAgentConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{12}
}

func (x *SipAgentConfig) GetOutboundProxyAddress() string {
	if x != nil {
		return x.OutboundProxyAddress
	}
	return ""
}

func (x *SipAgentConfig) GetPrimarySipDns() string {
	if x != nil {
		return x.PrimarySipDns
	}
	return ""
}

func (x *SipAgentConfig) GetSecondarySipDns() string {
	if x != nil {
		return x.SecondarySipDns
	}
	return ""
}

func (x *SipAgentConfig) GetSipRegExpTime() int32 {
	if x != nil {
		return x.SipRegExpTime
	}
	return 0
}

func (x *SipAgentConfig) GetSipReregHeadStartTime() int32 {
	if x != nil {
		return x.SipReregHeadStartTime
	}
	return 0
}

func (x *SipAgentConfig) GetSipRegistrar() string {
	if x != nil {
		return x.SipRegistrar
	}
	return ""
}

func (x *SipAgentConfig) GetSoftSwitch() string {
	if x != nil {
		return x.SoftSwitch
	}
	return ""
}

func (x *SipAgentConfig) GetSipResponseTable() *SipResponseTable {
	if x != nil {
		return x.SipResponseTable
	}
	return nil
}

func (x *SipAgentConfig) GetSipOptionTransmitControl() bool {
	if x != nil {
		return x.SipOptionTransmitControl
	}
	return false
}

func (x *SipAgentConfig) GetSipUriFormat() string {
	if x != nil {
		return x.SipUriFormat
	}
	return ""
}

func (x *SipAgentConfig) GetRedundantSipAgentPointer() string {
	if x != nil {
		return x.RedundantSipAgentPointer
	}
	return ""
}

type NetworkDialPlan struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	CriticalDialTimeout uint32                 `protobuf:"varint,1,opt,name=criticalDialTimeout,proto3" json:"criticalDialTimeout,omitempty"`
	PartialDialTimeout  uint32                 `protobuf:"varint,2,opt,name=partialDialTimeout,proto3" json:"partialDialTimeout,omitempty"`
	DialPlanFormat      uint32                 `protobuf:"varint,3,opt,name=dialPlanFormat,proto3" json:"dialPlanFormat,omitempty"`
	DialPlanTable       *DialPlanTable         `protobuf:"bytes,4,opt,name=dialPlanTable,proto3" json:"dialPlanTable,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *NetworkDialPlan) Reset() {
	*x = NetworkDialPlan{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkDialPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkDialPlan) ProtoMessage() {}

func (x *NetworkDialPlan) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkDialPlan.ProtoReflect.Descriptor instead.
func (*NetworkDialPlan) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{13}
}

func (x *NetworkDialPlan) GetCriticalDialTimeout() uint32 {
	if x != nil {
		return x.CriticalDialTimeout
	}
	return 0
}

func (x *NetworkDialPlan) GetPartialDialTimeout() uint32 {
	if x != nil {
		return x.PartialDialTimeout
	}
	return 0
}

func (x *NetworkDialPlan) GetDialPlanFormat() uint32 {
	if x != nil {
		return x.DialPlanFormat
	}
	return 0
}

func (x *NetworkDialPlan) GetDialPlanTable() *DialPlanTable {
	if x != nil {
		return x.DialPlanTable
	}
	return nil
}

type UsernameAndPassword struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	ValidationScheme int32                  `protobuf:"varint,1,opt,name=validationScheme,proto3" json:"validationScheme,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *UsernameAndPassword) Reset() {
	*x = UsernameAndPassword{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UsernameAndPassword) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsernameAndPassword) ProtoMessage() {}

func (x *UsernameAndPassword) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsernameAndPassword.ProtoReflect.Descriptor instead.
func (*UsernameAndPassword) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{14}
}

func (x *UsernameAndPassword) GetValidationScheme() int32 {
	if x != nil {
		return x.ValidationScheme
	}
	return 0
}

type SipResponseTable struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	SipResponseCode string                 `protobuf:"bytes,1,opt,name=sipResponseCode,proto3" json:"sipResponseCode,omitempty"`
	Tone            string                 `protobuf:"bytes,2,opt,name=tone,proto3" json:"tone,omitempty"`
	TextMessage     string                 `protobuf:"bytes,3,opt,name=textMessage,proto3" json:"textMessage,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SipResponseTable) Reset() {
	*x = SipResponseTable{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SipResponseTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SipResponseTable) ProtoMessage() {}

func (x *SipResponseTable) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SipResponseTable.ProtoReflect.Descriptor instead.
func (*SipResponseTable) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{15}
}

func (x *SipResponseTable) GetSipResponseCode() string {
	if x != nil {
		return x.SipResponseCode
	}
	return ""
}

func (x *SipResponseTable) GetTone() string {
	if x != nil {
		return x.Tone
	}
	return ""
}

func (x *SipResponseTable) GetTextMessage() string {
	if x != nil {
		return x.TextMessage
	}
	return ""
}

type DialPlanTable struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	DialPlanId           uint32                 `protobuf:"varint,1,opt,name=dialPlanId,proto3" json:"dialPlanId,omitempty"`
	Action               uint32                 `protobuf:"varint,2,opt,name=action,proto3" json:"action,omitempty"`
	DialPlanToken        string                 `protobuf:"bytes,3,opt,name=dialPlanToken,proto3" json:"dialPlanToken,omitempty"`
	DialPlanTableMaxSize uint32                 `protobuf:"varint,4,opt,name=dialPlanTableMaxSize,proto3" json:"dialPlanTableMaxSize,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *DialPlanTable) Reset() {
	*x = DialPlanTable{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DialPlanTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DialPlanTable) ProtoMessage() {}

func (x *DialPlanTable) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DialPlanTable.ProtoReflect.Descriptor instead.
func (*DialPlanTable) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{16}
}

func (x *DialPlanTable) GetDialPlanId() uint32 {
	if x != nil {
		return x.DialPlanId
	}
	return 0
}

func (x *DialPlanTable) GetAction() uint32 {
	if x != nil {
		return x.Action
	}
	return 0
}

func (x *DialPlanTable) GetDialPlanToken() string {
	if x != nil {
		return x.DialPlanToken
	}
	return ""
}

func (x *DialPlanTable) GetDialPlanTableMaxSize() uint32 {
	if x != nil {
		return x.DialPlanTableMaxSize
	}
	return 0
}

type VoipFeatureAccessCodes struct {
	state                    protoimpl.MessageState `protogen:"open.v1"`
	CancelCallWaiting        string                 `protobuf:"bytes,1,opt,name=cancelCallWaiting,proto3" json:"cancelCallWaiting,omitempty"`
	CallHold                 string                 `protobuf:"bytes,2,opt,name=callHold,proto3" json:"callHold,omitempty"`
	CallPark                 string                 `protobuf:"bytes,3,opt,name=callPark,proto3" json:"callPark,omitempty"`
	CallerIdActivate         string                 `protobuf:"bytes,4,opt,name=callerIdActivate,proto3" json:"callerIdActivate,omitempty"`
	CallerIdDeactivate       string                 `protobuf:"bytes,5,opt,name=callerIdDeactivate,proto3" json:"callerIdDeactivate,omitempty"`
	DoNotDisturbActivation   string                 `protobuf:"bytes,6,opt,name=doNotDisturbActivation,proto3" json:"doNotDisturbActivation,omitempty"`
	DoNotDisturbDeactivation string                 `protobuf:"bytes,7,opt,name=doNotDisturbDeactivation,proto3" json:"doNotDisturbDeactivation,omitempty"`
	DoNotDisturbPinChange    string                 `protobuf:"bytes,8,opt,name=doNotDisturbPinChange,proto3" json:"doNotDisturbPinChange,omitempty"`
	EmergencyServiceNumber   string                 `protobuf:"bytes,9,opt,name=emergencyServiceNumber,proto3" json:"emergencyServiceNumber,omitempty"`
	IntercomService          string                 `protobuf:"bytes,10,opt,name=intercomService,proto3" json:"intercomService,omitempty"`
	UnattendedCallTransfer   string                 `protobuf:"bytes,11,opt,name=unattendedCallTransfer,proto3" json:"unattendedCallTransfer,omitempty"`
	AttendedCallTransfer     string                 `protobuf:"bytes,12,opt,name=attendedCallTransfer,proto3" json:"attendedCallTransfer,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *VoipFeatureAccessCodes) Reset() {
	*x = VoipFeatureAccessCodes{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoipFeatureAccessCodes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoipFeatureAccessCodes) ProtoMessage() {}

func (x *VoipFeatureAccessCodes) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoipFeatureAccessCodes.ProtoReflect.Descriptor instead.
func (*VoipFeatureAccessCodes) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{17}
}

func (x *VoipFeatureAccessCodes) GetCancelCallWaiting() string {
	if x != nil {
		return x.CancelCallWaiting
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetCallHold() string {
	if x != nil {
		return x.CallHold
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetCallPark() string {
	if x != nil {
		return x.CallPark
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetCallerIdActivate() string {
	if x != nil {
		return x.CallerIdActivate
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetCallerIdDeactivate() string {
	if x != nil {
		return x.CallerIdDeactivate
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetDoNotDisturbActivation() string {
	if x != nil {
		return x.DoNotDisturbActivation
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetDoNotDisturbDeactivation() string {
	if x != nil {
		return x.DoNotDisturbDeactivation
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetDoNotDisturbPinChange() string {
	if x != nil {
		return x.DoNotDisturbPinChange
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetEmergencyServiceNumber() string {
	if x != nil {
		return x.EmergencyServiceNumber
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetIntercomService() string {
	if x != nil {
		return x.IntercomService
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetUnattendedCallTransfer() string {
	if x != nil {
		return x.UnattendedCallTransfer
	}
	return ""
}

func (x *VoipFeatureAccessCodes) GetAttendedCallTransfer() string {
	if x != nil {
		return x.AttendedCallTransfer
	}
	return ""
}

type VoipApplicationServiceProfile struct {
	state                          protoimpl.MessageState `protogen:"open.v1"`
	CidFeatures                    uint32                 `protobuf:"varint,1,opt,name=cidFeatures,proto3" json:"cidFeatures,omitempty"`
	CallWaitingFeatures            uint32                 `protobuf:"varint,2,opt,name=callWaitingFeatures,proto3" json:"callWaitingFeatures,omitempty"`
	CallProgressOrTransferFeatures uint32                 `protobuf:"varint,3,opt,name=callProgressOrTransferFeatures,proto3" json:"callProgressOrTransferFeatures,omitempty"`
	CallPresentationFeatures       uint32                 `protobuf:"varint,4,opt,name=callPresentationFeatures,proto3" json:"callPresentationFeatures,omitempty"`
	DirectConnectFeature           uint32                 `protobuf:"varint,5,opt,name=directConnectFeature,proto3" json:"directConnectFeature,omitempty"`
	DirectConnectUriPointer        string                 `protobuf:"bytes,6,opt,name=directConnectUriPointer,proto3" json:"directConnectUriPointer,omitempty"`
	BridgedLineAgentUriPointer     string                 `protobuf:"bytes,7,opt,name=bridgedLineAgentUriPointer,proto3" json:"bridgedLineAgentUriPointer,omitempty"`
	ConferenceFactoryUriPointer    string                 `protobuf:"bytes,8,opt,name=conferenceFactoryUriPointer,proto3" json:"conferenceFactoryUriPointer,omitempty"`
	DialToneDelayTimer             uint32                 `protobuf:"varint,9,opt,name=dialToneDelayTimer,proto3" json:"dialToneDelayTimer,omitempty"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *VoipApplicationServiceProfile) Reset() {
	*x = VoipApplicationServiceProfile{}
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoipApplicationServiceProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoipApplicationServiceProfile) ProtoMessage() {}

func (x *VoipApplicationServiceProfile) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voip_system_profile_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoipApplicationServiceProfile.ProtoReflect.Descriptor instead.
func (*VoipApplicationServiceProfile) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voip_system_profile_proto_rawDescGZIP(), []int{18}
}

func (x *VoipApplicationServiceProfile) GetCidFeatures() uint32 {
	if x != nil {
		return x.CidFeatures
	}
	return 0
}

func (x *VoipApplicationServiceProfile) GetCallWaitingFeatures() uint32 {
	if x != nil {
		return x.CallWaitingFeatures
	}
	return 0
}

func (x *VoipApplicationServiceProfile) GetCallProgressOrTransferFeatures() uint32 {
	if x != nil {
		return x.CallProgressOrTransferFeatures
	}
	return 0
}

func (x *VoipApplicationServiceProfile) GetCallPresentationFeatures() uint32 {
	if x != nil {
		return x.CallPresentationFeatures
	}
	return 0
}

func (x *VoipApplicationServiceProfile) GetDirectConnectFeature() uint32 {
	if x != nil {
		return x.DirectConnectFeature
	}
	return 0
}

func (x *VoipApplicationServiceProfile) GetDirectConnectUriPointer() string {
	if x != nil {
		return x.DirectConnectUriPointer
	}
	return ""
}

func (x *VoipApplicationServiceProfile) GetBridgedLineAgentUriPointer() string {
	if x != nil {
		return x.BridgedLineAgentUriPointer
	}
	return ""
}

func (x *VoipApplicationServiceProfile) GetConferenceFactoryUriPointer() string {
	if x != nil {
		return x.ConferenceFactoryUriPointer
	}
	return ""
}

func (x *VoipApplicationServiceProfile) GetDialToneDelayTimer() uint32 {
	if x != nil {
		return x.DialToneDelayTimer
	}
	return 0
}

var File_voltha_protos_voip_system_profile_proto protoreflect.FileDescriptor

const file_voltha_protos_voip_system_profile_proto_rawDesc = "" +
	"\n" +
	"'voltha_protos/voip_system_profile.proto\x12\x13voip_system_profile\x1a\x1cgoogle/api/annotations.proto\"\x82\x01\n" +
	"\x18VoipSystemProfileRequest\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12T\n" +
	"\x11voipSystemProfile\x18\x02 \x01(\v2&.voip_system_profile.VoipSystemProfileR\x11voipSystemProfile\"\x92\x01\n" +
	"\x11VoipSystemProfile\x12<\n" +
	"\tsipConfig\x18\x01 \x01(\v2\x1e.voip_system_profile.SipConfigR\tsipConfig\x12?\n" +
	"\n" +
	"voipConfig\x18\x02 \x01(\v2\x1f.voip_system_profile.VoipConfigR\n" +
	"voipConfig\"\x95\x04\n" +
	"\n" +
	"VoipConfig\x12E\n" +
	"\fipHostConfig\x18\x01 \x01(\v2!.voip_system_profile.IpHostConfigR\fipHostConfig\x12E\n" +
	"\ftcpUdpConfig\x18\x02 \x01(\v2!.voip_system_profile.TcpUdpConfigR\ftcpUdpConfig\x12E\n" +
	"\fvoipVoiceCtp\x18\x03 \x01(\v2!.voip_system_profile.VoipVoiceCtpR\fvoipVoiceCtp\x12Q\n" +
	"\x10voipMediaProfile\x18\x04 \x01(\v2%.voip_system_profile.VoipMediaProfileR\x10voipMediaProfile\x12Z\n" +
	"\x13voiceServiceProfile\x18\x05 \x01(\v2(.voip_system_profile.VoiceServiceProfileR\x13voiceServiceProfile\x12?\n" +
	"\n" +
	"rtpProfile\x18\x06 \x01(\v2\x1f.voip_system_profile.RtpProfileR\n" +
	"rtpProfile\x12B\n" +
	"\vpptpPotsUni\x18\a \x01(\v2 .voip_system_profile.PptpPotsUniR\vpptpPotsUni\"\x90\x02\n" +
	"\fIpHostConfig\x12\x1c\n" +
	"\tipOptions\x18\x01 \x01(\rR\tipOptions\x12$\n" +
	"\ronuIdentifier\x18\x02 \x01(\tR\ronuIdentifier\x12\x1c\n" +
	"\tipAddress\x18\x03 \x01(\tR\tipAddress\x12\x12\n" +
	"\x04mask\x18\x04 \x01(\tR\x04mask\x12\x18\n" +
	"\agateway\x18\x05 \x01(\tR\agateway\x12\x1e\n" +
	"\n" +
	"primaryDns\x18\x06 \x01(\tR\n" +
	"primaryDns\x12\"\n" +
	"\fsecondaryDns\x18\a \x01(\tR\fsecondaryDns\x12,\n" +
	"\x11relayAgentOptions\x18\b \x01(\tR\x11relayAgentOptions\"F\n" +
	"\fTcpUdpConfig\x12\x1a\n" +
	"\bprotocol\x18\x01 \x01(\rR\bprotocol\x12\x1a\n" +
	"\btosField\x18\x02 \x01(\tR\btosField\"6\n" +
	"\fVoipVoiceCtp\x12&\n" +
	"\x0esignallingCode\x18\x01 \x01(\rR\x0esignallingCode\"\x96\x05\n" +
	"\x10VoipMediaProfile\x12\x18\n" +
	"\afaxMode\x18\x01 \x01(\rR\afaxMode\x12(\n" +
	"\x0fcodecSelection1\x18\x02 \x01(\rR\x0fcodecSelection1\x126\n" +
	"\x16packetPeriodSelection1\x18\x03 \x01(\rR\x16packetPeriodSelection1\x120\n" +
	"\x13silenceSuppression1\x18\x04 \x01(\rR\x13silenceSuppression1\x12(\n" +
	"\x0fcodecSelection2\x18\x05 \x01(\rR\x0fcodecSelection2\x126\n" +
	"\x16packetPeriodSelection2\x18\x06 \x01(\rR\x16packetPeriodSelection2\x120\n" +
	"\x13silenceSuppression2\x18\a \x01(\rR\x13silenceSuppression2\x12(\n" +
	"\x0fcodecSelection3\x18\b \x01(\rR\x0fcodecSelection3\x126\n" +
	"\x16packetPeriodSelection3\x18\t \x01(\rR\x16packetPeriodSelection3\x120\n" +
	"\x13silenceSuppression3\x18\n" +
	" \x01(\rR\x13silenceSuppression3\x12(\n" +
	"\x0fcodecSelection4\x18\v \x01(\rR\x0fcodecSelection4\x126\n" +
	"\x16packetPeriodSelection4\x18\f \x01(\rR\x16packetPeriodSelection4\x120\n" +
	"\x13silenceSuppression4\x18\r \x01(\rR\x13silenceSuppression4\x12\x18\n" +
	"\aoobDtmf\x18\x0e \x01(\rR\aoobDtmf\"\xf3\x02\n" +
	"\x13VoiceServiceProfile\x12*\n" +
	"\x10announcementType\x18\x01 \x01(\rR\x10announcementType\x12\"\n" +
	"\fjitterTarget\x18\x02 \x01(\rR\fjitterTarget\x12(\n" +
	"\x0fjitterBufferMax\x18\x03 \x01(\rR\x0fjitterBufferMax\x12$\n" +
	"\rechoCancelInd\x18\x04 \x01(\bR\rechoCancelInd\x120\n" +
	"\x13pstnProtocolVariant\x18\x05 \x01(\rR\x13pstnProtocolVariant\x12(\n" +
	"\x0fdtmfDigitLevels\x18\x06 \x01(\rR\x0fdtmfDigitLevels\x12,\n" +
	"\x11dtmfDigitDuration\x18\a \x01(\rR\x11dtmfDigitDuration\x122\n" +
	"\x14hookFlashMinimumTime\x18\b \x01(\rR\x14hookFlashMinimumTime\"\xf8\x01\n" +
	"\n" +
	"RtpProfile\x12\"\n" +
	"\flocalPortMin\x18\x01 \x01(\rR\flocalPortMin\x12\"\n" +
	"\flocalPortMax\x18\x02 \x01(\rR\flocalPortMax\x12\x1a\n" +
	"\bdscpMark\x18\x03 \x01(\tR\bdscpMark\x12(\n" +
	"\x0fpiggyBackEvents\x18\x04 \x01(\rR\x0fpiggyBackEvents\x12\x1e\n" +
	"\n" +
	"toneEvents\x18\x05 \x01(\rR\n" +
	"toneEvents\x12\x1e\n" +
	"\n" +
	"dtmfEvents\x18\x06 \x01(\rR\n" +
	"dtmfEvents\x12\x1c\n" +
	"\tcasEvents\x18\a \x01(\rR\tcasEvents\"\xc3\x02\n" +
	"\vPptpPotsUni\x12\x10\n" +
	"\x03arc\x18\x01 \x01(\tR\x03arc\x12 \n" +
	"\varcInterval\x18\x02 \x01(\tR\varcInterval\x12\x1c\n" +
	"\timpedance\x18\x03 \x01(\rR\timpedance\x12*\n" +
	"\x10transmissionPath\x18\x04 \x01(\rR\x10transmissionPath\x12\x16\n" +
	"\x06rxGain\x18\x05 \x01(\x11R\x06rxGain\x12\x16\n" +
	"\x06txGain\x18\x06 \x01(\x11R\x06txGain\x12*\n" +
	"\x10potsHoldOverTime\x18\a \x01(\rR\x10potsHoldOverTime\x12.\n" +
	"\x12nominalFeedVoltage\x18\b \x01(\rR\x12nominalFeedVoltage\x12*\n" +
	"\x10lossOfSoftSwitch\x18\t \x01(\rR\x10lossOfSoftSwitch\"\xcb\x03\n" +
	"\tSipConfig\x12B\n" +
	"\vsipUserData\x18\x01 \x01(\v2 .voip_system_profile.SipUserDataR\vsipUserData\x12K\n" +
	"\x0esipAgentConfig\x18\x02 \x01(\v2#.voip_system_profile.SipAgentConfigR\x0esipAgentConfig\x12N\n" +
	"\x0fnetworkDialPlan\x18\x03 \x01(\v2$.voip_system_profile.NetworkDialPlanR\x0fnetworkDialPlan\x12c\n" +
	"\x16voipFeatureAccessCodes\x18\x04 \x01(\v2+.voip_system_profile.VoipFeatureAccessCodesR\x16voipFeatureAccessCodes\x12x\n" +
	"\x1dvoipApplicationServiceProfile\x18\x05 \x01(\v22.voip_system_profile.VoipApplicationServiceProfileR\x1dvoipApplicationServiceProfile\"\xd3\x02\n" +
	"\vSipUserData\x12 \n" +
	"\vuserPartAor\x18\x01 \x01(\tR\vuserPartAor\x12Z\n" +
	"\x13usernameAndPassword\x18\x02 \x01(\v2(.voip_system_profile.UsernameAndPasswordR\x13usernameAndPassword\x124\n" +
	"\x15voicemailServerSipUri\x18\x03 \x01(\tR\x15voicemailServerSipUri\x12P\n" +
	"#voicemailSubscriptionExpirationTime\x18\x04 \x01(\x05R#voicemailSubscriptionExpirationTime\x12\"\n" +
	"\freleaseTimer\x18\x05 \x01(\x05R\freleaseTimer\x12\x1a\n" +
	"\brohTimer\x18\x06 \x01(\x05R\brohTimer\"\xa3\x04\n" +
	"\x0eSipAgentConfig\x122\n" +
	"\x14outboundProxyAddress\x18\x01 \x01(\tR\x14outboundProxyAddress\x12$\n" +
	"\rprimarySipDns\x18\x02 \x01(\tR\rprimarySipDns\x12(\n" +
	"\x0fsecondarySipDns\x18\x03 \x01(\tR\x0fsecondarySipDns\x12$\n" +
	"\rsipRegExpTime\x18\x04 \x01(\x05R\rsipRegExpTime\x124\n" +
	"\x15sipReregHeadStartTime\x18\x05 \x01(\x05R\x15sipReregHeadStartTime\x12\"\n" +
	"\fSipRegistrar\x18\x06 \x01(\tR\fSipRegistrar\x12\x1e\n" +
	"\n" +
	"softSwitch\x18\a \x01(\tR\n" +
	"softSwitch\x12Q\n" +
	"\x10sipResponseTable\x18\b \x01(\v2%.voip_system_profile.SipResponseTableR\x10sipResponseTable\x12:\n" +
	"\x18sipOptionTransmitControl\x18\t \x01(\bR\x18sipOptionTransmitControl\x12\"\n" +
	"\fsipUriFormat\x18\n" +
	" \x01(\tR\fsipUriFormat\x12:\n" +
	"\x18redundantSipAgentPointer\x18\v \x01(\tR\x18redundantSipAgentPointer\"\xe5\x01\n" +
	"\x0fNetworkDialPlan\x120\n" +
	"\x13criticalDialTimeout\x18\x01 \x01(\rR\x13criticalDialTimeout\x12.\n" +
	"\x12partialDialTimeout\x18\x02 \x01(\rR\x12partialDialTimeout\x12&\n" +
	"\x0edialPlanFormat\x18\x03 \x01(\rR\x0edialPlanFormat\x12H\n" +
	"\rdialPlanTable\x18\x04 \x01(\v2\".voip_system_profile.DialPlanTableR\rdialPlanTable\"A\n" +
	"\x13UsernameAndPassword\x12*\n" +
	"\x10validationScheme\x18\x01 \x01(\x05R\x10validationScheme\"r\n" +
	"\x10SipResponseTable\x12(\n" +
	"\x0fsipResponseCode\x18\x01 \x01(\tR\x0fsipResponseCode\x12\x12\n" +
	"\x04tone\x18\x02 \x01(\tR\x04tone\x12 \n" +
	"\vtextMessage\x18\x03 \x01(\tR\vtextMessage\"\xa1\x01\n" +
	"\rDialPlanTable\x12\x1e\n" +
	"\n" +
	"dialPlanId\x18\x01 \x01(\rR\n" +
	"dialPlanId\x12\x16\n" +
	"\x06action\x18\x02 \x01(\rR\x06action\x12$\n" +
	"\rdialPlanToken\x18\x03 \x01(\tR\rdialPlanToken\x122\n" +
	"\x14dialPlanTableMaxSize\x18\x04 \x01(\rR\x14dialPlanTableMaxSize\"\xd2\x04\n" +
	"\x16VoipFeatureAccessCodes\x12,\n" +
	"\x11cancelCallWaiting\x18\x01 \x01(\tR\x11cancelCallWaiting\x12\x1a\n" +
	"\bcallHold\x18\x02 \x01(\tR\bcallHold\x12\x1a\n" +
	"\bcallPark\x18\x03 \x01(\tR\bcallPark\x12*\n" +
	"\x10callerIdActivate\x18\x04 \x01(\tR\x10callerIdActivate\x12.\n" +
	"\x12callerIdDeactivate\x18\x05 \x01(\tR\x12callerIdDeactivate\x126\n" +
	"\x16doNotDisturbActivation\x18\x06 \x01(\tR\x16doNotDisturbActivation\x12:\n" +
	"\x18doNotDisturbDeactivation\x18\a \x01(\tR\x18doNotDisturbDeactivation\x124\n" +
	"\x15doNotDisturbPinChange\x18\b \x01(\tR\x15doNotDisturbPinChange\x126\n" +
	"\x16emergencyServiceNumber\x18\t \x01(\tR\x16emergencyServiceNumber\x12(\n" +
	"\x0fintercomService\x18\n" +
	" \x01(\tR\x0fintercomService\x126\n" +
	"\x16unattendedCallTransfer\x18\v \x01(\tR\x16unattendedCallTransfer\x122\n" +
	"\x14attendedCallTransfer\x18\f \x01(\tR\x14attendedCallTransfer\"\x97\x04\n" +
	"\x1dVoipApplicationServiceProfile\x12 \n" +
	"\vcidFeatures\x18\x01 \x01(\rR\vcidFeatures\x120\n" +
	"\x13callWaitingFeatures\x18\x02 \x01(\rR\x13callWaitingFeatures\x12F\n" +
	"\x1ecallProgressOrTransferFeatures\x18\x03 \x01(\rR\x1ecallProgressOrTransferFeatures\x12:\n" +
	"\x18callPresentationFeatures\x18\x04 \x01(\rR\x18callPresentationFeatures\x122\n" +
	"\x14directConnectFeature\x18\x05 \x01(\rR\x14directConnectFeature\x128\n" +
	"\x17directConnectUriPointer\x18\x06 \x01(\tR\x17directConnectUriPointer\x12>\n" +
	"\x1abridgedLineAgentUriPointer\x18\a \x01(\tR\x1abridgedLineAgentUriPointer\x12@\n" +
	"\x1bconferenceFactoryUriPointer\x18\b \x01(\tR\x1bconferenceFactoryUriPointer\x12.\n" +
	"\x12dialToneDelayTimer\x18\t \x01(\rR\x12dialToneDelayTimerBf\n" +
	"'org.opencord.voltha.voip_system_profileZ;github.com/opencord/voltha-protos/v5/go/voip_system_profileb\x06proto3"

var (
	file_voltha_protos_voip_system_profile_proto_rawDescOnce sync.Once
	file_voltha_protos_voip_system_profile_proto_rawDescData []byte
)

func file_voltha_protos_voip_system_profile_proto_rawDescGZIP() []byte {
	file_voltha_protos_voip_system_profile_proto_rawDescOnce.Do(func() {
		file_voltha_protos_voip_system_profile_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_voltha_protos_voip_system_profile_proto_rawDesc), len(file_voltha_protos_voip_system_profile_proto_rawDesc)))
	})
	return file_voltha_protos_voip_system_profile_proto_rawDescData
}

var file_voltha_protos_voip_system_profile_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_voltha_protos_voip_system_profile_proto_goTypes = []any{
	(*VoipSystemProfileRequest)(nil),      // 0: voip_system_profile.VoipSystemProfileRequest
	(*VoipSystemProfile)(nil),             // 1: voip_system_profile.VoipSystemProfile
	(*VoipConfig)(nil),                    // 2: voip_system_profile.VoipConfig
	(*IpHostConfig)(nil),                  // 3: voip_system_profile.IpHostConfig
	(*TcpUdpConfig)(nil),                  // 4: voip_system_profile.TcpUdpConfig
	(*VoipVoiceCtp)(nil),                  // 5: voip_system_profile.VoipVoiceCtp
	(*VoipMediaProfile)(nil),              // 6: voip_system_profile.VoipMediaProfile
	(*VoiceServiceProfile)(nil),           // 7: voip_system_profile.VoiceServiceProfile
	(*RtpProfile)(nil),                    // 8: voip_system_profile.RtpProfile
	(*PptpPotsUni)(nil),                   // 9: voip_system_profile.PptpPotsUni
	(*SipConfig)(nil),                     // 10: voip_system_profile.SipConfig
	(*SipUserData)(nil),                   // 11: voip_system_profile.SipUserData
	(*SipAgentConfig)(nil),                // 12: voip_system_profile.SipAgentConfig
	(*NetworkDialPlan)(nil),               // 13: voip_system_profile.NetworkDialPlan
	(*UsernameAndPassword)(nil),           // 14: voip_system_profile.UsernameAndPassword
	(*SipResponseTable)(nil),              // 15: voip_system_profile.SipResponseTable
	(*DialPlanTable)(nil),                 // 16: voip_system_profile.DialPlanTable
	(*VoipFeatureAccessCodes)(nil),        // 17: voip_system_profile.VoipFeatureAccessCodes
	(*VoipApplicationServiceProfile)(nil), // 18: voip_system_profile.VoipApplicationServiceProfile
}
var file_voltha_protos_voip_system_profile_proto_depIdxs = []int32{
	1,  // 0: voip_system_profile.VoipSystemProfileRequest.voipSystemProfile:type_name -> voip_system_profile.VoipSystemProfile
	10, // 1: voip_system_profile.VoipSystemProfile.sipConfig:type_name -> voip_system_profile.SipConfig
	2,  // 2: voip_system_profile.VoipSystemProfile.voipConfig:type_name -> voip_system_profile.VoipConfig
	3,  // 3: voip_system_profile.VoipConfig.ipHostConfig:type_name -> voip_system_profile.IpHostConfig
	4,  // 4: voip_system_profile.VoipConfig.tcpUdpConfig:type_name -> voip_system_profile.TcpUdpConfig
	5,  // 5: voip_system_profile.VoipConfig.voipVoiceCtp:type_name -> voip_system_profile.VoipVoiceCtp
	6,  // 6: voip_system_profile.VoipConfig.voipMediaProfile:type_name -> voip_system_profile.VoipMediaProfile
	7,  // 7: voip_system_profile.VoipConfig.voiceServiceProfile:type_name -> voip_system_profile.VoiceServiceProfile
	8,  // 8: voip_system_profile.VoipConfig.rtpProfile:type_name -> voip_system_profile.RtpProfile
	9,  // 9: voip_system_profile.VoipConfig.pptpPotsUni:type_name -> voip_system_profile.PptpPotsUni
	11, // 10: voip_system_profile.SipConfig.sipUserData:type_name -> voip_system_profile.SipUserData
	12, // 11: voip_system_profile.SipConfig.sipAgentConfig:type_name -> voip_system_profile.SipAgentConfig
	13, // 12: voip_system_profile.SipConfig.networkDialPlan:type_name -> voip_system_profile.NetworkDialPlan
	17, // 13: voip_system_profile.SipConfig.voipFeatureAccessCodes:type_name -> voip_system_profile.VoipFeatureAccessCodes
	18, // 14: voip_system_profile.SipConfig.voipApplicationServiceProfile:type_name -> voip_system_profile.VoipApplicationServiceProfile
	14, // 15: voip_system_profile.SipUserData.usernameAndPassword:type_name -> voip_system_profile.UsernameAndPassword
	15, // 16: voip_system_profile.SipAgentConfig.sipResponseTable:type_name -> voip_system_profile.SipResponseTable
	16, // 17: voip_system_profile.NetworkDialPlan.dialPlanTable:type_name -> voip_system_profile.DialPlanTable
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_voltha_protos_voip_system_profile_proto_init() }
func file_voltha_protos_voip_system_profile_proto_init() {
	if File_voltha_protos_voip_system_profile_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_voltha_protos_voip_system_profile_proto_rawDesc), len(file_voltha_protos_voip_system_profile_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_voltha_protos_voip_system_profile_proto_goTypes,
		DependencyIndexes: file_voltha_protos_voip_system_profile_proto_depIdxs,
		MessageInfos:      file_voltha_protos_voip_system_profile_proto_msgTypes,
	}.Build()
	File_voltha_protos_voip_system_profile_proto = out.File
	file_voltha_protos_voip_system_profile_proto_goTypes = nil
	file_voltha_protos_voip_system_profile_proto_depIdxs = nil
}
