// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/openflow_13.proto

package openflow_13

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Port numbering. Ports are numbered starting from 1.
type OfpPortNo int32

const (
	OfpPortNo_OFPP_INVALID OfpPortNo = 0
	// Maximum number of physical and logical switch ports.
	OfpPortNo_OFPP_MAX OfpPortNo = 2147483392
	// Reserved OpenFlow Port (fake output "ports").
	OfpPortNo_OFPP_IN_PORT    OfpPortNo = 2147483640
	OfpPortNo_OFPP_TABLE      OfpPortNo = 2147483641
	OfpPortNo_OFPP_NORMAL     OfpPortNo = 2147483642
	OfpPortNo_OFPP_FLOOD      OfpPortNo = 2147483643
	OfpPortNo_OFPP_ALL        OfpPortNo = 2147483644
	OfpPortNo_OFPP_CONTROLLER OfpPortNo = 2147483645
	OfpPortNo_OFPP_LOCAL      OfpPortNo = 2147483646
	OfpPortNo_OFPP_ANY        OfpPortNo = 2147483647
)

var OfpPortNo_name = map[int32]string{
	0:          "OFPP_INVALID",
	2147483392: "OFPP_MAX",
	2147483640: "OFPP_IN_PORT",
	2147483641: "OFPP_TABLE",
	2147483642: "OFPP_NORMAL",
	2147483643: "OFPP_FLOOD",
	2147483644: "OFPP_ALL",
	2147483645: "OFPP_CONTROLLER",
	2147483646: "OFPP_LOCAL",
	2147483647: "OFPP_ANY",
}

var OfpPortNo_value = map[string]int32{
	"OFPP_INVALID":    0,
	"OFPP_MAX":        2147483392,
	"OFPP_IN_PORT":    2147483640,
	"OFPP_TABLE":      2147483641,
	"OFPP_NORMAL":     2147483642,
	"OFPP_FLOOD":      2147483643,
	"OFPP_ALL":        2147483644,
	"OFPP_CONTROLLER": 2147483645,
	"OFPP_LOCAL":      2147483646,
	"OFPP_ANY":        2147483647,
}

func (x OfpPortNo) String() string {
	return proto.EnumName(OfpPortNo_name, int32(x))
}

func (OfpPortNo) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{0}
}

type OfpType int32

const (
	// Immutable messages.
	OfpType_OFPT_HELLO        OfpType = 0
	OfpType_OFPT_ERROR        OfpType = 1
	OfpType_OFPT_ECHO_REQUEST OfpType = 2
	OfpType_OFPT_ECHO_REPLY   OfpType = 3
	OfpType_OFPT_EXPERIMENTER OfpType = 4
	// Switch configuration messages.
	OfpType_OFPT_FEATURES_REQUEST   OfpType = 5
	OfpType_OFPT_FEATURES_REPLY     OfpType = 6
	OfpType_OFPT_GET_CONFIG_REQUEST OfpType = 7
	OfpType_OFPT_GET_CONFIG_REPLY   OfpType = 8
	OfpType_OFPT_SET_CONFIG         OfpType = 9
	// Asynchronous messages.
	OfpType_OFPT_PACKET_IN    OfpType = 10
	OfpType_OFPT_FLOW_REMOVED OfpType = 11
	OfpType_OFPT_PORT_STATUS  OfpType = 12
	// Controller command messages.
	OfpType_OFPT_PACKET_OUT OfpType = 13
	OfpType_OFPT_FLOW_MOD   OfpType = 14
	OfpType_OFPT_GROUP_MOD  OfpType = 15
	OfpType_OFPT_PORT_MOD   OfpType = 16
	OfpType_OFPT_TABLE_MOD  OfpType = 17
	// Multipart messages.
	OfpType_OFPT_MULTIPART_REQUEST OfpType = 18
	OfpType_OFPT_MULTIPART_REPLY   OfpType = 19
	// Barrier messages.
	OfpType_OFPT_BARRIER_REQUEST OfpType = 20
	OfpType_OFPT_BARRIER_REPLY   OfpType = 21
	// Queue Configuration messages.
	OfpType_OFPT_QUEUE_GET_CONFIG_REQUEST OfpType = 22
	OfpType_OFPT_QUEUE_GET_CONFIG_REPLY   OfpType = 23
	// Controller role change request messages.
	OfpType_OFPT_ROLE_REQUEST OfpType = 24
	OfpType_OFPT_ROLE_REPLY   OfpType = 25
	// Asynchronous message configuration.
	OfpType_OFPT_GET_ASYNC_REQUEST OfpType = 26
	OfpType_OFPT_GET_ASYNC_REPLY   OfpType = 27
	OfpType_OFPT_SET_ASYNC         OfpType = 28
	// Meters and rate limiters configuration messages.
	OfpType_OFPT_METER_MOD OfpType = 29
)

var OfpType_name = map[int32]string{
	0:  "OFPT_HELLO",
	1:  "OFPT_ERROR",
	2:  "OFPT_ECHO_REQUEST",
	3:  "OFPT_ECHO_REPLY",
	4:  "OFPT_EXPERIMENTER",
	5:  "OFPT_FEATURES_REQUEST",
	6:  "OFPT_FEATURES_REPLY",
	7:  "OFPT_GET_CONFIG_REQUEST",
	8:  "OFPT_GET_CONFIG_REPLY",
	9:  "OFPT_SET_CONFIG",
	10: "OFPT_PACKET_IN",
	11: "OFPT_FLOW_REMOVED",
	12: "OFPT_PORT_STATUS",
	13: "OFPT_PACKET_OUT",
	14: "OFPT_FLOW_MOD",
	15: "OFPT_GROUP_MOD",
	16: "OFPT_PORT_MOD",
	17: "OFPT_TABLE_MOD",
	18: "OFPT_MULTIPART_REQUEST",
	19: "OFPT_MULTIPART_REPLY",
	20: "OFPT_BARRIER_REQUEST",
	21: "OFPT_BARRIER_REPLY",
	22: "OFPT_QUEUE_GET_CONFIG_REQUEST",
	23: "OFPT_QUEUE_GET_CONFIG_REPLY",
	24: "OFPT_ROLE_REQUEST",
	25: "OFPT_ROLE_REPLY",
	26: "OFPT_GET_ASYNC_REQUEST",
	27: "OFPT_GET_ASYNC_REPLY",
	28: "OFPT_SET_ASYNC",
	29: "OFPT_METER_MOD",
}

var OfpType_value = map[string]int32{
	"OFPT_HELLO":                    0,
	"OFPT_ERROR":                    1,
	"OFPT_ECHO_REQUEST":             2,
	"OFPT_ECHO_REPLY":               3,
	"OFPT_EXPERIMENTER":             4,
	"OFPT_FEATURES_REQUEST":         5,
	"OFPT_FEATURES_REPLY":           6,
	"OFPT_GET_CONFIG_REQUEST":       7,
	"OFPT_GET_CONFIG_REPLY":         8,
	"OFPT_SET_CONFIG":               9,
	"OFPT_PACKET_IN":                10,
	"OFPT_FLOW_REMOVED":             11,
	"OFPT_PORT_STATUS":              12,
	"OFPT_PACKET_OUT":               13,
	"OFPT_FLOW_MOD":                 14,
	"OFPT_GROUP_MOD":                15,
	"OFPT_PORT_MOD":                 16,
	"OFPT_TABLE_MOD":                17,
	"OFPT_MULTIPART_REQUEST":        18,
	"OFPT_MULTIPART_REPLY":          19,
	"OFPT_BARRIER_REQUEST":          20,
	"OFPT_BARRIER_REPLY":            21,
	"OFPT_QUEUE_GET_CONFIG_REQUEST": 22,
	"OFPT_QUEUE_GET_CONFIG_REPLY":   23,
	"OFPT_ROLE_REQUEST":             24,
	"OFPT_ROLE_REPLY":               25,
	"OFPT_GET_ASYNC_REQUEST":        26,
	"OFPT_GET_ASYNC_REPLY":          27,
	"OFPT_SET_ASYNC":                28,
	"OFPT_METER_MOD":                29,
}

func (x OfpType) String() string {
	return proto.EnumName(OfpType_name, int32(x))
}

func (OfpType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{1}
}

// Hello elements types.
type OfpHelloElemType int32

const (
	OfpHelloElemType_OFPHET_INVALID       OfpHelloElemType = 0
	OfpHelloElemType_OFPHET_VERSIONBITMAP OfpHelloElemType = 1
)

var OfpHelloElemType_name = map[int32]string{
	0: "OFPHET_INVALID",
	1: "OFPHET_VERSIONBITMAP",
}

var OfpHelloElemType_value = map[string]int32{
	"OFPHET_INVALID":       0,
	"OFPHET_VERSIONBITMAP": 1,
}

func (x OfpHelloElemType) String() string {
	return proto.EnumName(OfpHelloElemType_name, int32(x))
}

func (OfpHelloElemType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{2}
}

type OfpConfigFlags int32

const (
	// Handling of IP fragments.
	OfpConfigFlags_OFPC_FRAG_NORMAL OfpConfigFlags = 0
	OfpConfigFlags_OFPC_FRAG_DROP   OfpConfigFlags = 1
	OfpConfigFlags_OFPC_FRAG_REASM  OfpConfigFlags = 2
	OfpConfigFlags_OFPC_FRAG_MASK   OfpConfigFlags = 3
)

var OfpConfigFlags_name = map[int32]string{
	0: "OFPC_FRAG_NORMAL",
	1: "OFPC_FRAG_DROP",
	2: "OFPC_FRAG_REASM",
	3: "OFPC_FRAG_MASK",
}

var OfpConfigFlags_value = map[string]int32{
	"OFPC_FRAG_NORMAL": 0,
	"OFPC_FRAG_DROP":   1,
	"OFPC_FRAG_REASM":  2,
	"OFPC_FRAG_MASK":   3,
}

func (x OfpConfigFlags) String() string {
	return proto.EnumName(OfpConfigFlags_name, int32(x))
}

func (OfpConfigFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{3}
}

// Flags to configure the table. Reserved for future use.
type OfpTableConfig int32

const (
	OfpTableConfig_OFPTC_INVALID         OfpTableConfig = 0
	OfpTableConfig_OFPTC_DEPRECATED_MASK OfpTableConfig = 3
)

var OfpTableConfig_name = map[int32]string{
	0: "OFPTC_INVALID",
	3: "OFPTC_DEPRECATED_MASK",
}

var OfpTableConfig_value = map[string]int32{
	"OFPTC_INVALID":         0,
	"OFPTC_DEPRECATED_MASK": 3,
}

func (x OfpTableConfig) String() string {
	return proto.EnumName(OfpTableConfig_name, int32(x))
}

func (OfpTableConfig) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{4}
}

// Table numbering. Tables can use any number up to OFPT_MAX.
type OfpTable int32

const (
	OfpTable_OFPTT_INVALID OfpTable = 0
	// Last usable table number.
	OfpTable_OFPTT_MAX OfpTable = 254
	// Fake tables.
	OfpTable_OFPTT_ALL OfpTable = 255
)

var OfpTable_name = map[int32]string{
	0:   "OFPTT_INVALID",
	254: "OFPTT_MAX",
	255: "OFPTT_ALL",
}

var OfpTable_value = map[string]int32{
	"OFPTT_INVALID": 0,
	"OFPTT_MAX":     254,
	"OFPTT_ALL":     255,
}

func (x OfpTable) String() string {
	return proto.EnumName(OfpTable_name, int32(x))
}

func (OfpTable) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{5}
}

// Capabilities supported by the datapath.
type OfpCapabilities int32

const (
	OfpCapabilities_OFPC_INVALID      OfpCapabilities = 0
	OfpCapabilities_OFPC_FLOW_STATS   OfpCapabilities = 1
	OfpCapabilities_OFPC_TABLE_STATS  OfpCapabilities = 2
	OfpCapabilities_OFPC_PORT_STATS   OfpCapabilities = 4
	OfpCapabilities_OFPC_GROUP_STATS  OfpCapabilities = 8
	OfpCapabilities_OFPC_IP_REASM     OfpCapabilities = 32
	OfpCapabilities_OFPC_QUEUE_STATS  OfpCapabilities = 64
	OfpCapabilities_OFPC_PORT_BLOCKED OfpCapabilities = 256
)

var OfpCapabilities_name = map[int32]string{
	0:   "OFPC_INVALID",
	1:   "OFPC_FLOW_STATS",
	2:   "OFPC_TABLE_STATS",
	4:   "OFPC_PORT_STATS",
	8:   "OFPC_GROUP_STATS",
	32:  "OFPC_IP_REASM",
	64:  "OFPC_QUEUE_STATS",
	256: "OFPC_PORT_BLOCKED",
}

var OfpCapabilities_value = map[string]int32{
	"OFPC_INVALID":      0,
	"OFPC_FLOW_STATS":   1,
	"OFPC_TABLE_STATS":  2,
	"OFPC_PORT_STATS":   4,
	"OFPC_GROUP_STATS":  8,
	"OFPC_IP_REASM":     32,
	"OFPC_QUEUE_STATS":  64,
	"OFPC_PORT_BLOCKED": 256,
}

func (x OfpCapabilities) String() string {
	return proto.EnumName(OfpCapabilities_name, int32(x))
}

func (OfpCapabilities) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{6}
}

// Flags to indicate behavior of the physical port.  These flags are
// used in ofp_port to describe the current configuration.  They are
// used in the ofp_port_mod message to configure the port's behavior.
type OfpPortConfig int32

const (
	OfpPortConfig_OFPPC_INVALID      OfpPortConfig = 0
	OfpPortConfig_OFPPC_PORT_DOWN    OfpPortConfig = 1
	OfpPortConfig_OFPPC_NO_RECV      OfpPortConfig = 4
	OfpPortConfig_OFPPC_NO_FWD       OfpPortConfig = 32
	OfpPortConfig_OFPPC_NO_PACKET_IN OfpPortConfig = 64
)

var OfpPortConfig_name = map[int32]string{
	0:  "OFPPC_INVALID",
	1:  "OFPPC_PORT_DOWN",
	4:  "OFPPC_NO_RECV",
	32: "OFPPC_NO_FWD",
	64: "OFPPC_NO_PACKET_IN",
}

var OfpPortConfig_value = map[string]int32{
	"OFPPC_INVALID":      0,
	"OFPPC_PORT_DOWN":    1,
	"OFPPC_NO_RECV":      4,
	"OFPPC_NO_FWD":       32,
	"OFPPC_NO_PACKET_IN": 64,
}

func (x OfpPortConfig) String() string {
	return proto.EnumName(OfpPortConfig_name, int32(x))
}

func (OfpPortConfig) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{7}
}

// Current state of the physical port.  These are not configurable from
// the controller.
type OfpPortState int32

const (
	OfpPortState_OFPPS_INVALID   OfpPortState = 0
	OfpPortState_OFPPS_LINK_DOWN OfpPortState = 1
	OfpPortState_OFPPS_BLOCKED   OfpPortState = 2
	OfpPortState_OFPPS_LIVE      OfpPortState = 4
)

var OfpPortState_name = map[int32]string{
	0: "OFPPS_INVALID",
	1: "OFPPS_LINK_DOWN",
	2: "OFPPS_BLOCKED",
	4: "OFPPS_LIVE",
}

var OfpPortState_value = map[string]int32{
	"OFPPS_INVALID":   0,
	"OFPPS_LINK_DOWN": 1,
	"OFPPS_BLOCKED":   2,
	"OFPPS_LIVE":      4,
}

func (x OfpPortState) String() string {
	return proto.EnumName(OfpPortState_name, int32(x))
}

func (OfpPortState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{8}
}

// Features of ports available in a datapath.
type OfpPortFeatures int32

const (
	OfpPortFeatures_OFPPF_INVALID    OfpPortFeatures = 0
	OfpPortFeatures_OFPPF_10MB_HD    OfpPortFeatures = 1
	OfpPortFeatures_OFPPF_10MB_FD    OfpPortFeatures = 2
	OfpPortFeatures_OFPPF_100MB_HD   OfpPortFeatures = 4
	OfpPortFeatures_OFPPF_100MB_FD   OfpPortFeatures = 8
	OfpPortFeatures_OFPPF_1GB_HD     OfpPortFeatures = 16
	OfpPortFeatures_OFPPF_1GB_FD     OfpPortFeatures = 32
	OfpPortFeatures_OFPPF_10GB_FD    OfpPortFeatures = 64
	OfpPortFeatures_OFPPF_40GB_FD    OfpPortFeatures = 128
	OfpPortFeatures_OFPPF_100GB_FD   OfpPortFeatures = 256
	OfpPortFeatures_OFPPF_1TB_FD     OfpPortFeatures = 512
	OfpPortFeatures_OFPPF_OTHER      OfpPortFeatures = 1024
	OfpPortFeatures_OFPPF_COPPER     OfpPortFeatures = 2048
	OfpPortFeatures_OFPPF_FIBER      OfpPortFeatures = 4096
	OfpPortFeatures_OFPPF_AUTONEG    OfpPortFeatures = 8192
	OfpPortFeatures_OFPPF_PAUSE      OfpPortFeatures = 16384
	OfpPortFeatures_OFPPF_PAUSE_ASYM OfpPortFeatures = 32768
)

var OfpPortFeatures_name = map[int32]string{
	0:     "OFPPF_INVALID",
	1:     "OFPPF_10MB_HD",
	2:     "OFPPF_10MB_FD",
	4:     "OFPPF_100MB_HD",
	8:     "OFPPF_100MB_FD",
	16:    "OFPPF_1GB_HD",
	32:    "OFPPF_1GB_FD",
	64:    "OFPPF_10GB_FD",
	128:   "OFPPF_40GB_FD",
	256:   "OFPPF_100GB_FD",
	512:   "OFPPF_1TB_FD",
	1024:  "OFPPF_OTHER",
	2048:  "OFPPF_COPPER",
	4096:  "OFPPF_FIBER",
	8192:  "OFPPF_AUTONEG",
	16384: "OFPPF_PAUSE",
	32768: "OFPPF_PAUSE_ASYM",
}

var OfpPortFeatures_value = map[string]int32{
	"OFPPF_INVALID":    0,
	"OFPPF_10MB_HD":    1,
	"OFPPF_10MB_FD":    2,
	"OFPPF_100MB_HD":   4,
	"OFPPF_100MB_FD":   8,
	"OFPPF_1GB_HD":     16,
	"OFPPF_1GB_FD":     32,
	"OFPPF_10GB_FD":    64,
	"OFPPF_40GB_FD":    128,
	"OFPPF_100GB_FD":   256,
	"OFPPF_1TB_FD":     512,
	"OFPPF_OTHER":      1024,
	"OFPPF_COPPER":     2048,
	"OFPPF_FIBER":      4096,
	"OFPPF_AUTONEG":    8192,
	"OFPPF_PAUSE":      16384,
	"OFPPF_PAUSE_ASYM": 32768,
}

func (x OfpPortFeatures) String() string {
	return proto.EnumName(OfpPortFeatures_name, int32(x))
}

func (OfpPortFeatures) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{9}
}

// What changed about the physical port
type OfpPortReason int32

const (
	OfpPortReason_OFPPR_ADD    OfpPortReason = 0
	OfpPortReason_OFPPR_DELETE OfpPortReason = 1
	OfpPortReason_OFPPR_MODIFY OfpPortReason = 2
)

var OfpPortReason_name = map[int32]string{
	0: "OFPPR_ADD",
	1: "OFPPR_DELETE",
	2: "OFPPR_MODIFY",
}

var OfpPortReason_value = map[string]int32{
	"OFPPR_ADD":    0,
	"OFPPR_DELETE": 1,
	"OFPPR_MODIFY": 2,
}

func (x OfpPortReason) String() string {
	return proto.EnumName(OfpPortReason_name, int32(x))
}

func (OfpPortReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{10}
}

// The match type indicates the match structure (set of fields that compose the
// match) in use. The match type is placed in the type field at the beginning
// of all match structures. The "OpenFlow Extensible Match" type corresponds
// to OXM TLV format described below and must be supported by all OpenFlow
// switches. Extensions that define other match types may be published on the
// ONF wiki. Support for extensions is optional.
type OfpMatchType int32

const (
	OfpMatchType_OFPMT_STANDARD OfpMatchType = 0
	OfpMatchType_OFPMT_OXM      OfpMatchType = 1
)

var OfpMatchType_name = map[int32]string{
	0: "OFPMT_STANDARD",
	1: "OFPMT_OXM",
}

var OfpMatchType_value = map[string]int32{
	"OFPMT_STANDARD": 0,
	"OFPMT_OXM":      1,
}

func (x OfpMatchType) String() string {
	return proto.EnumName(OfpMatchType_name, int32(x))
}

func (OfpMatchType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{11}
}

// OXM Class IDs.
// The high order bit differentiate reserved classes from member classes.
// Classes 0x0000 to 0x7FFF are member classes, allocated by ONF.
// Classes 0x8000 to 0xFFFE are reserved classes, reserved for standardisation.
type OfpOxmClass int32

const (
	OfpOxmClass_OFPXMC_NXM_0          OfpOxmClass = 0
	OfpOxmClass_OFPXMC_NXM_1          OfpOxmClass = 1
	OfpOxmClass_OFPXMC_OPENFLOW_BASIC OfpOxmClass = 32768
	OfpOxmClass_OFPXMC_EXPERIMENTER   OfpOxmClass = 65535
)

var OfpOxmClass_name = map[int32]string{
	0:     "OFPXMC_NXM_0",
	1:     "OFPXMC_NXM_1",
	32768: "OFPXMC_OPENFLOW_BASIC",
	65535: "OFPXMC_EXPERIMENTER",
}

var OfpOxmClass_value = map[string]int32{
	"OFPXMC_NXM_0":          0,
	"OFPXMC_NXM_1":          1,
	"OFPXMC_OPENFLOW_BASIC": 32768,
	"OFPXMC_EXPERIMENTER":   65535,
}

func (x OfpOxmClass) String() string {
	return proto.EnumName(OfpOxmClass_name, int32(x))
}

func (OfpOxmClass) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{12}
}

// OXM Flow field types for OpenFlow basic class.
type OxmOfbFieldTypes int32

const (
	OxmOfbFieldTypes_OFPXMT_OFB_IN_PORT        OxmOfbFieldTypes = 0
	OxmOfbFieldTypes_OFPXMT_OFB_IN_PHY_PORT    OxmOfbFieldTypes = 1
	OxmOfbFieldTypes_OFPXMT_OFB_METADATA       OxmOfbFieldTypes = 2
	OxmOfbFieldTypes_OFPXMT_OFB_ETH_DST        OxmOfbFieldTypes = 3
	OxmOfbFieldTypes_OFPXMT_OFB_ETH_SRC        OxmOfbFieldTypes = 4
	OxmOfbFieldTypes_OFPXMT_OFB_ETH_TYPE       OxmOfbFieldTypes = 5
	OxmOfbFieldTypes_OFPXMT_OFB_VLAN_VID       OxmOfbFieldTypes = 6
	OxmOfbFieldTypes_OFPXMT_OFB_VLAN_PCP       OxmOfbFieldTypes = 7
	OxmOfbFieldTypes_OFPXMT_OFB_IP_DSCP        OxmOfbFieldTypes = 8
	OxmOfbFieldTypes_OFPXMT_OFB_IP_ECN         OxmOfbFieldTypes = 9
	OxmOfbFieldTypes_OFPXMT_OFB_IP_PROTO       OxmOfbFieldTypes = 10
	OxmOfbFieldTypes_OFPXMT_OFB_IPV4_SRC       OxmOfbFieldTypes = 11
	OxmOfbFieldTypes_OFPXMT_OFB_IPV4_DST       OxmOfbFieldTypes = 12
	OxmOfbFieldTypes_OFPXMT_OFB_TCP_SRC        OxmOfbFieldTypes = 13
	OxmOfbFieldTypes_OFPXMT_OFB_TCP_DST        OxmOfbFieldTypes = 14
	OxmOfbFieldTypes_OFPXMT_OFB_UDP_SRC        OxmOfbFieldTypes = 15
	OxmOfbFieldTypes_OFPXMT_OFB_UDP_DST        OxmOfbFieldTypes = 16
	OxmOfbFieldTypes_OFPXMT_OFB_SCTP_SRC       OxmOfbFieldTypes = 17
	OxmOfbFieldTypes_OFPXMT_OFB_SCTP_DST       OxmOfbFieldTypes = 18
	OxmOfbFieldTypes_OFPXMT_OFB_ICMPV4_TYPE    OxmOfbFieldTypes = 19
	OxmOfbFieldTypes_OFPXMT_OFB_ICMPV4_CODE    OxmOfbFieldTypes = 20
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_OP         OxmOfbFieldTypes = 21
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_SPA        OxmOfbFieldTypes = 22
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_TPA        OxmOfbFieldTypes = 23
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_SHA        OxmOfbFieldTypes = 24
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_THA        OxmOfbFieldTypes = 25
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_SRC       OxmOfbFieldTypes = 26
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_DST       OxmOfbFieldTypes = 27
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_FLABEL    OxmOfbFieldTypes = 28
	OxmOfbFieldTypes_OFPXMT_OFB_ICMPV6_TYPE    OxmOfbFieldTypes = 29
	OxmOfbFieldTypes_OFPXMT_OFB_ICMPV6_CODE    OxmOfbFieldTypes = 30
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_ND_TARGET OxmOfbFieldTypes = 31
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_ND_SLL    OxmOfbFieldTypes = 32
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_ND_TLL    OxmOfbFieldTypes = 33
	OxmOfbFieldTypes_OFPXMT_OFB_MPLS_LABEL     OxmOfbFieldTypes = 34
	OxmOfbFieldTypes_OFPXMT_OFB_MPLS_TC        OxmOfbFieldTypes = 35
	OxmOfbFieldTypes_OFPXMT_OFB_MPLS_BOS       OxmOfbFieldTypes = 36
	OxmOfbFieldTypes_OFPXMT_OFB_PBB_ISID       OxmOfbFieldTypes = 37
	OxmOfbFieldTypes_OFPXMT_OFB_TUNNEL_ID      OxmOfbFieldTypes = 38
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_EXTHDR    OxmOfbFieldTypes = 39
)

var OxmOfbFieldTypes_name = map[int32]string{
	0:  "OFPXMT_OFB_IN_PORT",
	1:  "OFPXMT_OFB_IN_PHY_PORT",
	2:  "OFPXMT_OFB_METADATA",
	3:  "OFPXMT_OFB_ETH_DST",
	4:  "OFPXMT_OFB_ETH_SRC",
	5:  "OFPXMT_OFB_ETH_TYPE",
	6:  "OFPXMT_OFB_VLAN_VID",
	7:  "OFPXMT_OFB_VLAN_PCP",
	8:  "OFPXMT_OFB_IP_DSCP",
	9:  "OFPXMT_OFB_IP_ECN",
	10: "OFPXMT_OFB_IP_PROTO",
	11: "OFPXMT_OFB_IPV4_SRC",
	12: "OFPXMT_OFB_IPV4_DST",
	13: "OFPXMT_OFB_TCP_SRC",
	14: "OFPXMT_OFB_TCP_DST",
	15: "OFPXMT_OFB_UDP_SRC",
	16: "OFPXMT_OFB_UDP_DST",
	17: "OFPXMT_OFB_SCTP_SRC",
	18: "OFPXMT_OFB_SCTP_DST",
	19: "OFPXMT_OFB_ICMPV4_TYPE",
	20: "OFPXMT_OFB_ICMPV4_CODE",
	21: "OFPXMT_OFB_ARP_OP",
	22: "OFPXMT_OFB_ARP_SPA",
	23: "OFPXMT_OFB_ARP_TPA",
	24: "OFPXMT_OFB_ARP_SHA",
	25: "OFPXMT_OFB_ARP_THA",
	26: "OFPXMT_OFB_IPV6_SRC",
	27: "OFPXMT_OFB_IPV6_DST",
	28: "OFPXMT_OFB_IPV6_FLABEL",
	29: "OFPXMT_OFB_ICMPV6_TYPE",
	30: "OFPXMT_OFB_ICMPV6_CODE",
	31: "OFPXMT_OFB_IPV6_ND_TARGET",
	32: "OFPXMT_OFB_IPV6_ND_SLL",
	33: "OFPXMT_OFB_IPV6_ND_TLL",
	34: "OFPXMT_OFB_MPLS_LABEL",
	35: "OFPXMT_OFB_MPLS_TC",
	36: "OFPXMT_OFB_MPLS_BOS",
	37: "OFPXMT_OFB_PBB_ISID",
	38: "OFPXMT_OFB_TUNNEL_ID",
	39: "OFPXMT_OFB_IPV6_EXTHDR",
}

var OxmOfbFieldTypes_value = map[string]int32{
	"OFPXMT_OFB_IN_PORT":        0,
	"OFPXMT_OFB_IN_PHY_PORT":    1,
	"OFPXMT_OFB_METADATA":       2,
	"OFPXMT_OFB_ETH_DST":        3,
	"OFPXMT_OFB_ETH_SRC":        4,
	"OFPXMT_OFB_ETH_TYPE":       5,
	"OFPXMT_OFB_VLAN_VID":       6,
	"OFPXMT_OFB_VLAN_PCP":       7,
	"OFPXMT_OFB_IP_DSCP":        8,
	"OFPXMT_OFB_IP_ECN":         9,
	"OFPXMT_OFB_IP_PROTO":       10,
	"OFPXMT_OFB_IPV4_SRC":       11,
	"OFPXMT_OFB_IPV4_DST":       12,
	"OFPXMT_OFB_TCP_SRC":        13,
	"OFPXMT_OFB_TCP_DST":        14,
	"OFPXMT_OFB_UDP_SRC":        15,
	"OFPXMT_OFB_UDP_DST":        16,
	"OFPXMT_OFB_SCTP_SRC":       17,
	"OFPXMT_OFB_SCTP_DST":       18,
	"OFPXMT_OFB_ICMPV4_TYPE":    19,
	"OFPXMT_OFB_ICMPV4_CODE":    20,
	"OFPXMT_OFB_ARP_OP":         21,
	"OFPXMT_OFB_ARP_SPA":        22,
	"OFPXMT_OFB_ARP_TPA":        23,
	"OFPXMT_OFB_ARP_SHA":        24,
	"OFPXMT_OFB_ARP_THA":        25,
	"OFPXMT_OFB_IPV6_SRC":       26,
	"OFPXMT_OFB_IPV6_DST":       27,
	"OFPXMT_OFB_IPV6_FLABEL":    28,
	"OFPXMT_OFB_ICMPV6_TYPE":    29,
	"OFPXMT_OFB_ICMPV6_CODE":    30,
	"OFPXMT_OFB_IPV6_ND_TARGET": 31,
	"OFPXMT_OFB_IPV6_ND_SLL":    32,
	"OFPXMT_OFB_IPV6_ND_TLL":    33,
	"OFPXMT_OFB_MPLS_LABEL":     34,
	"OFPXMT_OFB_MPLS_TC":        35,
	"OFPXMT_OFB_MPLS_BOS":       36,
	"OFPXMT_OFB_PBB_ISID":       37,
	"OFPXMT_OFB_TUNNEL_ID":      38,
	"OFPXMT_OFB_IPV6_EXTHDR":    39,
}

func (x OxmOfbFieldTypes) String() string {
	return proto.EnumName(OxmOfbFieldTypes_name, int32(x))
}

func (OxmOfbFieldTypes) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{13}
}

// The VLAN id is 12-bits, so we can use the entire 16 bits to indicate
// special conditions.
type OfpVlanId int32

const (
	OfpVlanId_OFPVID_NONE    OfpVlanId = 0
	OfpVlanId_OFPVID_PRESENT OfpVlanId = 4096
)

var OfpVlanId_name = map[int32]string{
	0:    "OFPVID_NONE",
	4096: "OFPVID_PRESENT",
}

var OfpVlanId_value = map[string]int32{
	"OFPVID_NONE":    0,
	"OFPVID_PRESENT": 4096,
}

func (x OfpVlanId) String() string {
	return proto.EnumName(OfpVlanId_name, int32(x))
}

func (OfpVlanId) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{14}
}

// Bit definitions for IPv6 Extension Header pseudo-field.
type OfpIpv6ExthdrFlags int32

const (
	OfpIpv6ExthdrFlags_OFPIEH_INVALID OfpIpv6ExthdrFlags = 0
	OfpIpv6ExthdrFlags_OFPIEH_NONEXT  OfpIpv6ExthdrFlags = 1
	OfpIpv6ExthdrFlags_OFPIEH_ESP     OfpIpv6ExthdrFlags = 2
	OfpIpv6ExthdrFlags_OFPIEH_AUTH    OfpIpv6ExthdrFlags = 4
	OfpIpv6ExthdrFlags_OFPIEH_DEST    OfpIpv6ExthdrFlags = 8
	OfpIpv6ExthdrFlags_OFPIEH_FRAG    OfpIpv6ExthdrFlags = 16
	OfpIpv6ExthdrFlags_OFPIEH_ROUTER  OfpIpv6ExthdrFlags = 32
	OfpIpv6ExthdrFlags_OFPIEH_HOP     OfpIpv6ExthdrFlags = 64
	OfpIpv6ExthdrFlags_OFPIEH_UNREP   OfpIpv6ExthdrFlags = 128
	OfpIpv6ExthdrFlags_OFPIEH_UNSEQ   OfpIpv6ExthdrFlags = 256
)

var OfpIpv6ExthdrFlags_name = map[int32]string{
	0:   "OFPIEH_INVALID",
	1:   "OFPIEH_NONEXT",
	2:   "OFPIEH_ESP",
	4:   "OFPIEH_AUTH",
	8:   "OFPIEH_DEST",
	16:  "OFPIEH_FRAG",
	32:  "OFPIEH_ROUTER",
	64:  "OFPIEH_HOP",
	128: "OFPIEH_UNREP",
	256: "OFPIEH_UNSEQ",
}

var OfpIpv6ExthdrFlags_value = map[string]int32{
	"OFPIEH_INVALID": 0,
	"OFPIEH_NONEXT":  1,
	"OFPIEH_ESP":     2,
	"OFPIEH_AUTH":    4,
	"OFPIEH_DEST":    8,
	"OFPIEH_FRAG":    16,
	"OFPIEH_ROUTER":  32,
	"OFPIEH_HOP":     64,
	"OFPIEH_UNREP":   128,
	"OFPIEH_UNSEQ":   256,
}

func (x OfpIpv6ExthdrFlags) String() string {
	return proto.EnumName(OfpIpv6ExthdrFlags_name, int32(x))
}

func (OfpIpv6ExthdrFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{15}
}

type OfpActionType int32

const (
	OfpActionType_OFPAT_OUTPUT       OfpActionType = 0
	OfpActionType_OFPAT_COPY_TTL_OUT OfpActionType = 11
	OfpActionType_OFPAT_COPY_TTL_IN  OfpActionType = 12
	OfpActionType_OFPAT_SET_MPLS_TTL OfpActionType = 15
	OfpActionType_OFPAT_DEC_MPLS_TTL OfpActionType = 16
	OfpActionType_OFPAT_PUSH_VLAN    OfpActionType = 17
	OfpActionType_OFPAT_POP_VLAN     OfpActionType = 18
	OfpActionType_OFPAT_PUSH_MPLS    OfpActionType = 19
	OfpActionType_OFPAT_POP_MPLS     OfpActionType = 20
	OfpActionType_OFPAT_SET_QUEUE    OfpActionType = 21
	OfpActionType_OFPAT_GROUP        OfpActionType = 22
	OfpActionType_OFPAT_SET_NW_TTL   OfpActionType = 23
	OfpActionType_OFPAT_DEC_NW_TTL   OfpActionType = 24
	OfpActionType_OFPAT_SET_FIELD    OfpActionType = 25
	OfpActionType_OFPAT_PUSH_PBB     OfpActionType = 26
	OfpActionType_OFPAT_POP_PBB      OfpActionType = 27
	OfpActionType_OFPAT_EXPERIMENTER OfpActionType = 65535
)

var OfpActionType_name = map[int32]string{
	0:     "OFPAT_OUTPUT",
	11:    "OFPAT_COPY_TTL_OUT",
	12:    "OFPAT_COPY_TTL_IN",
	15:    "OFPAT_SET_MPLS_TTL",
	16:    "OFPAT_DEC_MPLS_TTL",
	17:    "OFPAT_PUSH_VLAN",
	18:    "OFPAT_POP_VLAN",
	19:    "OFPAT_PUSH_MPLS",
	20:    "OFPAT_POP_MPLS",
	21:    "OFPAT_SET_QUEUE",
	22:    "OFPAT_GROUP",
	23:    "OFPAT_SET_NW_TTL",
	24:    "OFPAT_DEC_NW_TTL",
	25:    "OFPAT_SET_FIELD",
	26:    "OFPAT_PUSH_PBB",
	27:    "OFPAT_POP_PBB",
	65535: "OFPAT_EXPERIMENTER",
}

var OfpActionType_value = map[string]int32{
	"OFPAT_OUTPUT":       0,
	"OFPAT_COPY_TTL_OUT": 11,
	"OFPAT_COPY_TTL_IN":  12,
	"OFPAT_SET_MPLS_TTL": 15,
	"OFPAT_DEC_MPLS_TTL": 16,
	"OFPAT_PUSH_VLAN":    17,
	"OFPAT_POP_VLAN":     18,
	"OFPAT_PUSH_MPLS":    19,
	"OFPAT_POP_MPLS":     20,
	"OFPAT_SET_QUEUE":    21,
	"OFPAT_GROUP":        22,
	"OFPAT_SET_NW_TTL":   23,
	"OFPAT_DEC_NW_TTL":   24,
	"OFPAT_SET_FIELD":    25,
	"OFPAT_PUSH_PBB":     26,
	"OFPAT_POP_PBB":      27,
	"OFPAT_EXPERIMENTER": 65535,
}

func (x OfpActionType) String() string {
	return proto.EnumName(OfpActionType_name, int32(x))
}

func (OfpActionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{16}
}

type OfpControllerMaxLen int32

const (
	OfpControllerMaxLen_OFPCML_INVALID   OfpControllerMaxLen = 0
	OfpControllerMaxLen_OFPCML_MAX       OfpControllerMaxLen = 65509
	OfpControllerMaxLen_OFPCML_NO_BUFFER OfpControllerMaxLen = 65535
)

var OfpControllerMaxLen_name = map[int32]string{
	0:     "OFPCML_INVALID",
	65509: "OFPCML_MAX",
	65535: "OFPCML_NO_BUFFER",
}

var OfpControllerMaxLen_value = map[string]int32{
	"OFPCML_INVALID":   0,
	"OFPCML_MAX":       65509,
	"OFPCML_NO_BUFFER": 65535,
}

func (x OfpControllerMaxLen) String() string {
	return proto.EnumName(OfpControllerMaxLen_name, int32(x))
}

func (OfpControllerMaxLen) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{17}
}

type OfpInstructionType int32

const (
	OfpInstructionType_OFPIT_INVALID        OfpInstructionType = 0
	OfpInstructionType_OFPIT_GOTO_TABLE     OfpInstructionType = 1
	OfpInstructionType_OFPIT_WRITE_METADATA OfpInstructionType = 2
	OfpInstructionType_OFPIT_WRITE_ACTIONS  OfpInstructionType = 3
	OfpInstructionType_OFPIT_APPLY_ACTIONS  OfpInstructionType = 4
	OfpInstructionType_OFPIT_CLEAR_ACTIONS  OfpInstructionType = 5
	OfpInstructionType_OFPIT_METER          OfpInstructionType = 6
	OfpInstructionType_OFPIT_EXPERIMENTER   OfpInstructionType = 65535
)

var OfpInstructionType_name = map[int32]string{
	0:     "OFPIT_INVALID",
	1:     "OFPIT_GOTO_TABLE",
	2:     "OFPIT_WRITE_METADATA",
	3:     "OFPIT_WRITE_ACTIONS",
	4:     "OFPIT_APPLY_ACTIONS",
	5:     "OFPIT_CLEAR_ACTIONS",
	6:     "OFPIT_METER",
	65535: "OFPIT_EXPERIMENTER",
}

var OfpInstructionType_value = map[string]int32{
	"OFPIT_INVALID":        0,
	"OFPIT_GOTO_TABLE":     1,
	"OFPIT_WRITE_METADATA": 2,
	"OFPIT_WRITE_ACTIONS":  3,
	"OFPIT_APPLY_ACTIONS":  4,
	"OFPIT_CLEAR_ACTIONS":  5,
	"OFPIT_METER":          6,
	"OFPIT_EXPERIMENTER":   65535,
}

func (x OfpInstructionType) String() string {
	return proto.EnumName(OfpInstructionType_name, int32(x))
}

func (OfpInstructionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{18}
}

type OfpFlowModCommand int32

const (
	OfpFlowModCommand_OFPFC_ADD           OfpFlowModCommand = 0
	OfpFlowModCommand_OFPFC_MODIFY        OfpFlowModCommand = 1
	OfpFlowModCommand_OFPFC_MODIFY_STRICT OfpFlowModCommand = 2
	OfpFlowModCommand_OFPFC_DELETE        OfpFlowModCommand = 3
	OfpFlowModCommand_OFPFC_DELETE_STRICT OfpFlowModCommand = 4
)

var OfpFlowModCommand_name = map[int32]string{
	0: "OFPFC_ADD",
	1: "OFPFC_MODIFY",
	2: "OFPFC_MODIFY_STRICT",
	3: "OFPFC_DELETE",
	4: "OFPFC_DELETE_STRICT",
}

var OfpFlowModCommand_value = map[string]int32{
	"OFPFC_ADD":           0,
	"OFPFC_MODIFY":        1,
	"OFPFC_MODIFY_STRICT": 2,
	"OFPFC_DELETE":        3,
	"OFPFC_DELETE_STRICT": 4,
}

func (x OfpFlowModCommand) String() string {
	return proto.EnumName(OfpFlowModCommand_name, int32(x))
}

func (OfpFlowModCommand) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{19}
}

type OfpFlowModFlags int32

const (
	OfpFlowModFlags_OFPFF_INVALID       OfpFlowModFlags = 0
	OfpFlowModFlags_OFPFF_SEND_FLOW_REM OfpFlowModFlags = 1
	OfpFlowModFlags_OFPFF_CHECK_OVERLAP OfpFlowModFlags = 2
	OfpFlowModFlags_OFPFF_RESET_COUNTS  OfpFlowModFlags = 4
	OfpFlowModFlags_OFPFF_NO_PKT_COUNTS OfpFlowModFlags = 8
	OfpFlowModFlags_OFPFF_NO_BYT_COUNTS OfpFlowModFlags = 16
)

var OfpFlowModFlags_name = map[int32]string{
	0:  "OFPFF_INVALID",
	1:  "OFPFF_SEND_FLOW_REM",
	2:  "OFPFF_CHECK_OVERLAP",
	4:  "OFPFF_RESET_COUNTS",
	8:  "OFPFF_NO_PKT_COUNTS",
	16: "OFPFF_NO_BYT_COUNTS",
}

var OfpFlowModFlags_value = map[string]int32{
	"OFPFF_INVALID":       0,
	"OFPFF_SEND_FLOW_REM": 1,
	"OFPFF_CHECK_OVERLAP": 2,
	"OFPFF_RESET_COUNTS":  4,
	"OFPFF_NO_PKT_COUNTS": 8,
	"OFPFF_NO_BYT_COUNTS": 16,
}

func (x OfpFlowModFlags) String() string {
	return proto.EnumName(OfpFlowModFlags_name, int32(x))
}

func (OfpFlowModFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{20}
}

// Group numbering. Groups can use any number up to OFPG_MAX.
type OfpGroup int32

const (
	OfpGroup_OFPG_INVALID OfpGroup = 0
	// Last usable group number.
	OfpGroup_OFPG_MAX OfpGroup = 2147483392
	// Fake groups.
	OfpGroup_OFPG_ALL OfpGroup = 2147483644
	OfpGroup_OFPG_ANY OfpGroup = 2147483647
)

var OfpGroup_name = map[int32]string{
	0:          "OFPG_INVALID",
	2147483392: "OFPG_MAX",
	2147483644: "OFPG_ALL",
	2147483647: "OFPG_ANY",
}

var OfpGroup_value = map[string]int32{
	"OFPG_INVALID": 0,
	"OFPG_MAX":     2147483392,
	"OFPG_ALL":     2147483644,
	"OFPG_ANY":     2147483647,
}

func (x OfpGroup) String() string {
	return proto.EnumName(OfpGroup_name, int32(x))
}

func (OfpGroup) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{21}
}

// Group commands
type OfpGroupModCommand int32

const (
	OfpGroupModCommand_OFPGC_ADD    OfpGroupModCommand = 0
	OfpGroupModCommand_OFPGC_MODIFY OfpGroupModCommand = 1
	OfpGroupModCommand_OFPGC_DELETE OfpGroupModCommand = 2
)

var OfpGroupModCommand_name = map[int32]string{
	0: "OFPGC_ADD",
	1: "OFPGC_MODIFY",
	2: "OFPGC_DELETE",
}

var OfpGroupModCommand_value = map[string]int32{
	"OFPGC_ADD":    0,
	"OFPGC_MODIFY": 1,
	"OFPGC_DELETE": 2,
}

func (x OfpGroupModCommand) String() string {
	return proto.EnumName(OfpGroupModCommand_name, int32(x))
}

func (OfpGroupModCommand) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{22}
}

// Group types.  Values in the range [128; 255] are reserved for experimental
// use.
type OfpGroupType int32

const (
	OfpGroupType_OFPGT_ALL      OfpGroupType = 0
	OfpGroupType_OFPGT_SELECT   OfpGroupType = 1
	OfpGroupType_OFPGT_INDIRECT OfpGroupType = 2
	OfpGroupType_OFPGT_FF       OfpGroupType = 3
)

var OfpGroupType_name = map[int32]string{
	0: "OFPGT_ALL",
	1: "OFPGT_SELECT",
	2: "OFPGT_INDIRECT",
	3: "OFPGT_FF",
}

var OfpGroupType_value = map[string]int32{
	"OFPGT_ALL":      0,
	"OFPGT_SELECT":   1,
	"OFPGT_INDIRECT": 2,
	"OFPGT_FF":       3,
}

func (x OfpGroupType) String() string {
	return proto.EnumName(OfpGroupType_name, int32(x))
}

func (OfpGroupType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{23}
}

// Why is this packet being sent to the controller?
type OfpPacketInReason int32

const (
	OfpPacketInReason_OFPR_NO_MATCH    OfpPacketInReason = 0
	OfpPacketInReason_OFPR_ACTION      OfpPacketInReason = 1
	OfpPacketInReason_OFPR_INVALID_TTL OfpPacketInReason = 2
)

var OfpPacketInReason_name = map[int32]string{
	0: "OFPR_NO_MATCH",
	1: "OFPR_ACTION",
	2: "OFPR_INVALID_TTL",
}

var OfpPacketInReason_value = map[string]int32{
	"OFPR_NO_MATCH":    0,
	"OFPR_ACTION":      1,
	"OFPR_INVALID_TTL": 2,
}

func (x OfpPacketInReason) String() string {
	return proto.EnumName(OfpPacketInReason_name, int32(x))
}

func (OfpPacketInReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{24}
}

// Why was this flow removed?
type OfpFlowRemovedReason int32

const (
	OfpFlowRemovedReason_OFPRR_IDLE_TIMEOUT OfpFlowRemovedReason = 0
	OfpFlowRemovedReason_OFPRR_HARD_TIMEOUT OfpFlowRemovedReason = 1
	OfpFlowRemovedReason_OFPRR_DELETE       OfpFlowRemovedReason = 2
	OfpFlowRemovedReason_OFPRR_GROUP_DELETE OfpFlowRemovedReason = 3
	OfpFlowRemovedReason_OFPRR_METER_DELETE OfpFlowRemovedReason = 4
)

var OfpFlowRemovedReason_name = map[int32]string{
	0: "OFPRR_IDLE_TIMEOUT",
	1: "OFPRR_HARD_TIMEOUT",
	2: "OFPRR_DELETE",
	3: "OFPRR_GROUP_DELETE",
	4: "OFPRR_METER_DELETE",
}

var OfpFlowRemovedReason_value = map[string]int32{
	"OFPRR_IDLE_TIMEOUT": 0,
	"OFPRR_HARD_TIMEOUT": 1,
	"OFPRR_DELETE":       2,
	"OFPRR_GROUP_DELETE": 3,
	"OFPRR_METER_DELETE": 4,
}

func (x OfpFlowRemovedReason) String() string {
	return proto.EnumName(OfpFlowRemovedReason_name, int32(x))
}

func (OfpFlowRemovedReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{25}
}

// Meter numbering. Flow meters can use any number up to OFPM_MAX.
type OfpMeter int32

const (
	OfpMeter_OFPM_ZERO OfpMeter = 0
	// Last usable meter.
	OfpMeter_OFPM_MAX OfpMeter = 2147418112
	// Virtual meters.
	OfpMeter_OFPM_SLOWPATH   OfpMeter = 2147483645
	OfpMeter_OFPM_CONTROLLER OfpMeter = 2147483646
	OfpMeter_OFPM_ALL        OfpMeter = 2147483647
)

var OfpMeter_name = map[int32]string{
	0:          "OFPM_ZERO",
	2147418112: "OFPM_MAX",
	2147483645: "OFPM_SLOWPATH",
	2147483646: "OFPM_CONTROLLER",
	2147483647: "OFPM_ALL",
}

var OfpMeter_value = map[string]int32{
	"OFPM_ZERO":       0,
	"OFPM_MAX":        2147418112,
	"OFPM_SLOWPATH":   2147483645,
	"OFPM_CONTROLLER": 2147483646,
	"OFPM_ALL":        2147483647,
}

func (x OfpMeter) String() string {
	return proto.EnumName(OfpMeter_name, int32(x))
}

func (OfpMeter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{26}
}

// Meter band types
type OfpMeterBandType int32

const (
	OfpMeterBandType_OFPMBT_INVALID      OfpMeterBandType = 0
	OfpMeterBandType_OFPMBT_DROP         OfpMeterBandType = 1
	OfpMeterBandType_OFPMBT_DSCP_REMARK  OfpMeterBandType = 2
	OfpMeterBandType_OFPMBT_EXPERIMENTER OfpMeterBandType = 65535
)

var OfpMeterBandType_name = map[int32]string{
	0:     "OFPMBT_INVALID",
	1:     "OFPMBT_DROP",
	2:     "OFPMBT_DSCP_REMARK",
	65535: "OFPMBT_EXPERIMENTER",
}

var OfpMeterBandType_value = map[string]int32{
	"OFPMBT_INVALID":      0,
	"OFPMBT_DROP":         1,
	"OFPMBT_DSCP_REMARK":  2,
	"OFPMBT_EXPERIMENTER": 65535,
}

func (x OfpMeterBandType) String() string {
	return proto.EnumName(OfpMeterBandType_name, int32(x))
}

func (OfpMeterBandType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{27}
}

// Meter commands
type OfpMeterModCommand int32

const (
	OfpMeterModCommand_OFPMC_ADD    OfpMeterModCommand = 0
	OfpMeterModCommand_OFPMC_MODIFY OfpMeterModCommand = 1
	OfpMeterModCommand_OFPMC_DELETE OfpMeterModCommand = 2
)

var OfpMeterModCommand_name = map[int32]string{
	0: "OFPMC_ADD",
	1: "OFPMC_MODIFY",
	2: "OFPMC_DELETE",
}

var OfpMeterModCommand_value = map[string]int32{
	"OFPMC_ADD":    0,
	"OFPMC_MODIFY": 1,
	"OFPMC_DELETE": 2,
}

func (x OfpMeterModCommand) String() string {
	return proto.EnumName(OfpMeterModCommand_name, int32(x))
}

func (OfpMeterModCommand) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{28}
}

// Meter configuration flags
type OfpMeterFlags int32

const (
	OfpMeterFlags_OFPMF_INVALID OfpMeterFlags = 0
	OfpMeterFlags_OFPMF_KBPS    OfpMeterFlags = 1
	OfpMeterFlags_OFPMF_PKTPS   OfpMeterFlags = 2
	OfpMeterFlags_OFPMF_BURST   OfpMeterFlags = 4
	OfpMeterFlags_OFPMF_STATS   OfpMeterFlags = 8
)

var OfpMeterFlags_name = map[int32]string{
	0: "OFPMF_INVALID",
	1: "OFPMF_KBPS",
	2: "OFPMF_PKTPS",
	4: "OFPMF_BURST",
	8: "OFPMF_STATS",
}

var OfpMeterFlags_value = map[string]int32{
	"OFPMF_INVALID": 0,
	"OFPMF_KBPS":    1,
	"OFPMF_PKTPS":   2,
	"OFPMF_BURST":   4,
	"OFPMF_STATS":   8,
}

func (x OfpMeterFlags) String() string {
	return proto.EnumName(OfpMeterFlags_name, int32(x))
}

func (OfpMeterFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{29}
}

// Values for 'type' in ofp_error_message.  These values are immutable: they
// will not change in future versions of the protocol (although new values may
// be added).
type OfpErrorType int32

const (
	OfpErrorType_OFPET_HELLO_FAILED          OfpErrorType = 0
	OfpErrorType_OFPET_BAD_REQUEST           OfpErrorType = 1
	OfpErrorType_OFPET_BAD_ACTION            OfpErrorType = 2
	OfpErrorType_OFPET_BAD_INSTRUCTION       OfpErrorType = 3
	OfpErrorType_OFPET_BAD_MATCH             OfpErrorType = 4
	OfpErrorType_OFPET_FLOW_MOD_FAILED       OfpErrorType = 5
	OfpErrorType_OFPET_GROUP_MOD_FAILED      OfpErrorType = 6
	OfpErrorType_OFPET_PORT_MOD_FAILED       OfpErrorType = 7
	OfpErrorType_OFPET_TABLE_MOD_FAILED      OfpErrorType = 8
	OfpErrorType_OFPET_QUEUE_OP_FAILED       OfpErrorType = 9
	OfpErrorType_OFPET_SWITCH_CONFIG_FAILED  OfpErrorType = 10
	OfpErrorType_OFPET_ROLE_REQUEST_FAILED   OfpErrorType = 11
	OfpErrorType_OFPET_METER_MOD_FAILED      OfpErrorType = 12
	OfpErrorType_OFPET_TABLE_FEATURES_FAILED OfpErrorType = 13
	OfpErrorType_OFPET_EXPERIMENTER          OfpErrorType = 65535
)

var OfpErrorType_name = map[int32]string{
	0:     "OFPET_HELLO_FAILED",
	1:     "OFPET_BAD_REQUEST",
	2:     "OFPET_BAD_ACTION",
	3:     "OFPET_BAD_INSTRUCTION",
	4:     "OFPET_BAD_MATCH",
	5:     "OFPET_FLOW_MOD_FAILED",
	6:     "OFPET_GROUP_MOD_FAILED",
	7:     "OFPET_PORT_MOD_FAILED",
	8:     "OFPET_TABLE_MOD_FAILED",
	9:     "OFPET_QUEUE_OP_FAILED",
	10:    "OFPET_SWITCH_CONFIG_FAILED",
	11:    "OFPET_ROLE_REQUEST_FAILED",
	12:    "OFPET_METER_MOD_FAILED",
	13:    "OFPET_TABLE_FEATURES_FAILED",
	65535: "OFPET_EXPERIMENTER",
}

var OfpErrorType_value = map[string]int32{
	"OFPET_HELLO_FAILED":          0,
	"OFPET_BAD_REQUEST":           1,
	"OFPET_BAD_ACTION":            2,
	"OFPET_BAD_INSTRUCTION":       3,
	"OFPET_BAD_MATCH":             4,
	"OFPET_FLOW_MOD_FAILED":       5,
	"OFPET_GROUP_MOD_FAILED":      6,
	"OFPET_PORT_MOD_FAILED":       7,
	"OFPET_TABLE_MOD_FAILED":      8,
	"OFPET_QUEUE_OP_FAILED":       9,
	"OFPET_SWITCH_CONFIG_FAILED":  10,
	"OFPET_ROLE_REQUEST_FAILED":   11,
	"OFPET_METER_MOD_FAILED":      12,
	"OFPET_TABLE_FEATURES_FAILED": 13,
	"OFPET_EXPERIMENTER":          65535,
}

func (x OfpErrorType) String() string {
	return proto.EnumName(OfpErrorType_name, int32(x))
}

func (OfpErrorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{30}
}

// ofp_error_msg 'code' values for OFPET_HELLO_FAILED.  'data' contains an
// ASCII text string that may give failure details.
type OfpHelloFailedCode int32

const (
	OfpHelloFailedCode_OFPHFC_INCOMPATIBLE OfpHelloFailedCode = 0
	OfpHelloFailedCode_OFPHFC_EPERM        OfpHelloFailedCode = 1
)

var OfpHelloFailedCode_name = map[int32]string{
	0: "OFPHFC_INCOMPATIBLE",
	1: "OFPHFC_EPERM",
}

var OfpHelloFailedCode_value = map[string]int32{
	"OFPHFC_INCOMPATIBLE": 0,
	"OFPHFC_EPERM":        1,
}

func (x OfpHelloFailedCode) String() string {
	return proto.EnumName(OfpHelloFailedCode_name, int32(x))
}

func (OfpHelloFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{31}
}

// ofp_error_msg 'code' values for OFPET_BAD_REQUEST.  'data' contains at least
// the first 64 bytes of the failed request.
type OfpBadRequestCode int32

const (
	OfpBadRequestCode_OFPBRC_BAD_VERSION               OfpBadRequestCode = 0
	OfpBadRequestCode_OFPBRC_BAD_TYPE                  OfpBadRequestCode = 1
	OfpBadRequestCode_OFPBRC_BAD_MULTIPART             OfpBadRequestCode = 2
	OfpBadRequestCode_OFPBRC_BAD_EXPERIMENTER          OfpBadRequestCode = 3
	OfpBadRequestCode_OFPBRC_BAD_EXP_TYPE              OfpBadRequestCode = 4
	OfpBadRequestCode_OFPBRC_EPERM                     OfpBadRequestCode = 5
	OfpBadRequestCode_OFPBRC_BAD_LEN                   OfpBadRequestCode = 6
	OfpBadRequestCode_OFPBRC_BUFFER_EMPTY              OfpBadRequestCode = 7
	OfpBadRequestCode_OFPBRC_BUFFER_UNKNOWN            OfpBadRequestCode = 8
	OfpBadRequestCode_OFPBRC_BAD_TABLE_ID              OfpBadRequestCode = 9
	OfpBadRequestCode_OFPBRC_IS_SLAVE                  OfpBadRequestCode = 10
	OfpBadRequestCode_OFPBRC_BAD_PORT                  OfpBadRequestCode = 11
	OfpBadRequestCode_OFPBRC_BAD_PACKET                OfpBadRequestCode = 12
	OfpBadRequestCode_OFPBRC_MULTIPART_BUFFER_OVERFLOW OfpBadRequestCode = 13
)

var OfpBadRequestCode_name = map[int32]string{
	0:  "OFPBRC_BAD_VERSION",
	1:  "OFPBRC_BAD_TYPE",
	2:  "OFPBRC_BAD_MULTIPART",
	3:  "OFPBRC_BAD_EXPERIMENTER",
	4:  "OFPBRC_BAD_EXP_TYPE",
	5:  "OFPBRC_EPERM",
	6:  "OFPBRC_BAD_LEN",
	7:  "OFPBRC_BUFFER_EMPTY",
	8:  "OFPBRC_BUFFER_UNKNOWN",
	9:  "OFPBRC_BAD_TABLE_ID",
	10: "OFPBRC_IS_SLAVE",
	11: "OFPBRC_BAD_PORT",
	12: "OFPBRC_BAD_PACKET",
	13: "OFPBRC_MULTIPART_BUFFER_OVERFLOW",
}

var OfpBadRequestCode_value = map[string]int32{
	"OFPBRC_BAD_VERSION":               0,
	"OFPBRC_BAD_TYPE":                  1,
	"OFPBRC_BAD_MULTIPART":             2,
	"OFPBRC_BAD_EXPERIMENTER":          3,
	"OFPBRC_BAD_EXP_TYPE":              4,
	"OFPBRC_EPERM":                     5,
	"OFPBRC_BAD_LEN":                   6,
	"OFPBRC_BUFFER_EMPTY":              7,
	"OFPBRC_BUFFER_UNKNOWN":            8,
	"OFPBRC_BAD_TABLE_ID":              9,
	"OFPBRC_IS_SLAVE":                  10,
	"OFPBRC_BAD_PORT":                  11,
	"OFPBRC_BAD_PACKET":                12,
	"OFPBRC_MULTIPART_BUFFER_OVERFLOW": 13,
}

func (x OfpBadRequestCode) String() string {
	return proto.EnumName(OfpBadRequestCode_name, int32(x))
}

func (OfpBadRequestCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{32}
}

// ofp_error_msg 'code' values for OFPET_BAD_ACTION.  'data' contains at least
// the first 64 bytes of the failed request.
type OfpBadActionCode int32

const (
	OfpBadActionCode_OFPBAC_BAD_TYPE           OfpBadActionCode = 0
	OfpBadActionCode_OFPBAC_BAD_LEN            OfpBadActionCode = 1
	OfpBadActionCode_OFPBAC_BAD_EXPERIMENTER   OfpBadActionCode = 2
	OfpBadActionCode_OFPBAC_BAD_EXP_TYPE       OfpBadActionCode = 3
	OfpBadActionCode_OFPBAC_BAD_OUT_PORT       OfpBadActionCode = 4
	OfpBadActionCode_OFPBAC_BAD_ARGUMENT       OfpBadActionCode = 5
	OfpBadActionCode_OFPBAC_EPERM              OfpBadActionCode = 6
	OfpBadActionCode_OFPBAC_TOO_MANY           OfpBadActionCode = 7
	OfpBadActionCode_OFPBAC_BAD_QUEUE          OfpBadActionCode = 8
	OfpBadActionCode_OFPBAC_BAD_OUT_GROUP      OfpBadActionCode = 9
	OfpBadActionCode_OFPBAC_MATCH_INCONSISTENT OfpBadActionCode = 10
	OfpBadActionCode_OFPBAC_UNSUPPORTED_ORDER  OfpBadActionCode = 11
	OfpBadActionCode_OFPBAC_BAD_TAG            OfpBadActionCode = 12
	OfpBadActionCode_OFPBAC_BAD_SET_TYPE       OfpBadActionCode = 13
	OfpBadActionCode_OFPBAC_BAD_SET_LEN        OfpBadActionCode = 14
	OfpBadActionCode_OFPBAC_BAD_SET_ARGUMENT   OfpBadActionCode = 15
)

var OfpBadActionCode_name = map[int32]string{
	0:  "OFPBAC_BAD_TYPE",
	1:  "OFPBAC_BAD_LEN",
	2:  "OFPBAC_BAD_EXPERIMENTER",
	3:  "OFPBAC_BAD_EXP_TYPE",
	4:  "OFPBAC_BAD_OUT_PORT",
	5:  "OFPBAC_BAD_ARGUMENT",
	6:  "OFPBAC_EPERM",
	7:  "OFPBAC_TOO_MANY",
	8:  "OFPBAC_BAD_QUEUE",
	9:  "OFPBAC_BAD_OUT_GROUP",
	10: "OFPBAC_MATCH_INCONSISTENT",
	11: "OFPBAC_UNSUPPORTED_ORDER",
	12: "OFPBAC_BAD_TAG",
	13: "OFPBAC_BAD_SET_TYPE",
	14: "OFPBAC_BAD_SET_LEN",
	15: "OFPBAC_BAD_SET_ARGUMENT",
}

var OfpBadActionCode_value = map[string]int32{
	"OFPBAC_BAD_TYPE":           0,
	"OFPBAC_BAD_LEN":            1,
	"OFPBAC_BAD_EXPERIMENTER":   2,
	"OFPBAC_BAD_EXP_TYPE":       3,
	"OFPBAC_BAD_OUT_PORT":       4,
	"OFPBAC_BAD_ARGUMENT":       5,
	"OFPBAC_EPERM":              6,
	"OFPBAC_TOO_MANY":           7,
	"OFPBAC_BAD_QUEUE":          8,
	"OFPBAC_BAD_OUT_GROUP":      9,
	"OFPBAC_MATCH_INCONSISTENT": 10,
	"OFPBAC_UNSUPPORTED_ORDER":  11,
	"OFPBAC_BAD_TAG":            12,
	"OFPBAC_BAD_SET_TYPE":       13,
	"OFPBAC_BAD_SET_LEN":        14,
	"OFPBAC_BAD_SET_ARGUMENT":   15,
}

func (x OfpBadActionCode) String() string {
	return proto.EnumName(OfpBadActionCode_name, int32(x))
}

func (OfpBadActionCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{33}
}

// ofp_error_msg 'code' values for OFPET_BAD_INSTRUCTION.  'data' contains at
// least the first 64 bytes of the failed request.
type OfpBadInstructionCode int32

const (
	OfpBadInstructionCode_OFPBIC_UNKNOWN_INST        OfpBadInstructionCode = 0
	OfpBadInstructionCode_OFPBIC_UNSUP_INST          OfpBadInstructionCode = 1
	OfpBadInstructionCode_OFPBIC_BAD_TABLE_ID        OfpBadInstructionCode = 2
	OfpBadInstructionCode_OFPBIC_UNSUP_METADATA      OfpBadInstructionCode = 3
	OfpBadInstructionCode_OFPBIC_UNSUP_METADATA_MASK OfpBadInstructionCode = 4
	OfpBadInstructionCode_OFPBIC_BAD_EXPERIMENTER    OfpBadInstructionCode = 5
	OfpBadInstructionCode_OFPBIC_BAD_EXP_TYPE        OfpBadInstructionCode = 6
	OfpBadInstructionCode_OFPBIC_BAD_LEN             OfpBadInstructionCode = 7
	OfpBadInstructionCode_OFPBIC_EPERM               OfpBadInstructionCode = 8
)

var OfpBadInstructionCode_name = map[int32]string{
	0: "OFPBIC_UNKNOWN_INST",
	1: "OFPBIC_UNSUP_INST",
	2: "OFPBIC_BAD_TABLE_ID",
	3: "OFPBIC_UNSUP_METADATA",
	4: "OFPBIC_UNSUP_METADATA_MASK",
	5: "OFPBIC_BAD_EXPERIMENTER",
	6: "OFPBIC_BAD_EXP_TYPE",
	7: "OFPBIC_BAD_LEN",
	8: "OFPBIC_EPERM",
}

var OfpBadInstructionCode_value = map[string]int32{
	"OFPBIC_UNKNOWN_INST":        0,
	"OFPBIC_UNSUP_INST":          1,
	"OFPBIC_BAD_TABLE_ID":        2,
	"OFPBIC_UNSUP_METADATA":      3,
	"OFPBIC_UNSUP_METADATA_MASK": 4,
	"OFPBIC_BAD_EXPERIMENTER":    5,
	"OFPBIC_BAD_EXP_TYPE":        6,
	"OFPBIC_BAD_LEN":             7,
	"OFPBIC_EPERM":               8,
}

func (x OfpBadInstructionCode) String() string {
	return proto.EnumName(OfpBadInstructionCode_name, int32(x))
}

func (OfpBadInstructionCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{34}
}

// ofp_error_msg 'code' values for OFPET_BAD_MATCH.  'data' contains at least
// the first 64 bytes of the failed request.
type OfpBadMatchCode int32

const (
	OfpBadMatchCode_OFPBMC_BAD_TYPE         OfpBadMatchCode = 0
	OfpBadMatchCode_OFPBMC_BAD_LEN          OfpBadMatchCode = 1
	OfpBadMatchCode_OFPBMC_BAD_TAG          OfpBadMatchCode = 2
	OfpBadMatchCode_OFPBMC_BAD_DL_ADDR_MASK OfpBadMatchCode = 3
	OfpBadMatchCode_OFPBMC_BAD_NW_ADDR_MASK OfpBadMatchCode = 4
	OfpBadMatchCode_OFPBMC_BAD_WILDCARDS    OfpBadMatchCode = 5
	OfpBadMatchCode_OFPBMC_BAD_FIELD        OfpBadMatchCode = 6
	OfpBadMatchCode_OFPBMC_BAD_VALUE        OfpBadMatchCode = 7
	OfpBadMatchCode_OFPBMC_BAD_MASK         OfpBadMatchCode = 8
	OfpBadMatchCode_OFPBMC_BAD_PREREQ       OfpBadMatchCode = 9
	OfpBadMatchCode_OFPBMC_DUP_FIELD        OfpBadMatchCode = 10
	OfpBadMatchCode_OFPBMC_EPERM            OfpBadMatchCode = 11
)

var OfpBadMatchCode_name = map[int32]string{
	0:  "OFPBMC_BAD_TYPE",
	1:  "OFPBMC_BAD_LEN",
	2:  "OFPBMC_BAD_TAG",
	3:  "OFPBMC_BAD_DL_ADDR_MASK",
	4:  "OFPBMC_BAD_NW_ADDR_MASK",
	5:  "OFPBMC_BAD_WILDCARDS",
	6:  "OFPBMC_BAD_FIELD",
	7:  "OFPBMC_BAD_VALUE",
	8:  "OFPBMC_BAD_MASK",
	9:  "OFPBMC_BAD_PREREQ",
	10: "OFPBMC_DUP_FIELD",
	11: "OFPBMC_EPERM",
}

var OfpBadMatchCode_value = map[string]int32{
	"OFPBMC_BAD_TYPE":         0,
	"OFPBMC_BAD_LEN":          1,
	"OFPBMC_BAD_TAG":          2,
	"OFPBMC_BAD_DL_ADDR_MASK": 3,
	"OFPBMC_BAD_NW_ADDR_MASK": 4,
	"OFPBMC_BAD_WILDCARDS":    5,
	"OFPBMC_BAD_FIELD":        6,
	"OFPBMC_BAD_VALUE":        7,
	"OFPBMC_BAD_MASK":         8,
	"OFPBMC_BAD_PREREQ":       9,
	"OFPBMC_DUP_FIELD":        10,
	"OFPBMC_EPERM":            11,
}

func (x OfpBadMatchCode) String() string {
	return proto.EnumName(OfpBadMatchCode_name, int32(x))
}

func (OfpBadMatchCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{35}
}

// ofp_error_msg 'code' values for OFPET_FLOW_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpFlowModFailedCode int32

const (
	OfpFlowModFailedCode_OFPFMFC_UNKNOWN      OfpFlowModFailedCode = 0
	OfpFlowModFailedCode_OFPFMFC_TABLE_FULL   OfpFlowModFailedCode = 1
	OfpFlowModFailedCode_OFPFMFC_BAD_TABLE_ID OfpFlowModFailedCode = 2
	OfpFlowModFailedCode_OFPFMFC_OVERLAP      OfpFlowModFailedCode = 3
	OfpFlowModFailedCode_OFPFMFC_EPERM        OfpFlowModFailedCode = 4
	OfpFlowModFailedCode_OFPFMFC_BAD_TIMEOUT  OfpFlowModFailedCode = 5
	OfpFlowModFailedCode_OFPFMFC_BAD_COMMAND  OfpFlowModFailedCode = 6
	OfpFlowModFailedCode_OFPFMFC_BAD_FLAGS    OfpFlowModFailedCode = 7
)

var OfpFlowModFailedCode_name = map[int32]string{
	0: "OFPFMFC_UNKNOWN",
	1: "OFPFMFC_TABLE_FULL",
	2: "OFPFMFC_BAD_TABLE_ID",
	3: "OFPFMFC_OVERLAP",
	4: "OFPFMFC_EPERM",
	5: "OFPFMFC_BAD_TIMEOUT",
	6: "OFPFMFC_BAD_COMMAND",
	7: "OFPFMFC_BAD_FLAGS",
}

var OfpFlowModFailedCode_value = map[string]int32{
	"OFPFMFC_UNKNOWN":      0,
	"OFPFMFC_TABLE_FULL":   1,
	"OFPFMFC_BAD_TABLE_ID": 2,
	"OFPFMFC_OVERLAP":      3,
	"OFPFMFC_EPERM":        4,
	"OFPFMFC_BAD_TIMEOUT":  5,
	"OFPFMFC_BAD_COMMAND":  6,
	"OFPFMFC_BAD_FLAGS":    7,
}

func (x OfpFlowModFailedCode) String() string {
	return proto.EnumName(OfpFlowModFailedCode_name, int32(x))
}

func (OfpFlowModFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{36}
}

// ofp_error_msg 'code' values for OFPET_GROUP_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpGroupModFailedCode int32

const (
	OfpGroupModFailedCode_OFPGMFC_GROUP_EXISTS         OfpGroupModFailedCode = 0
	OfpGroupModFailedCode_OFPGMFC_INVALID_GROUP        OfpGroupModFailedCode = 1
	OfpGroupModFailedCode_OFPGMFC_WEIGHT_UNSUPPORTED   OfpGroupModFailedCode = 2
	OfpGroupModFailedCode_OFPGMFC_OUT_OF_GROUPS        OfpGroupModFailedCode = 3
	OfpGroupModFailedCode_OFPGMFC_OUT_OF_BUCKETS       OfpGroupModFailedCode = 4
	OfpGroupModFailedCode_OFPGMFC_CHAINING_UNSUPPORTED OfpGroupModFailedCode = 5
	OfpGroupModFailedCode_OFPGMFC_WATCH_UNSUPPORTED    OfpGroupModFailedCode = 6
	OfpGroupModFailedCode_OFPGMFC_LOOP                 OfpGroupModFailedCode = 7
	OfpGroupModFailedCode_OFPGMFC_UNKNOWN_GROUP        OfpGroupModFailedCode = 8
	OfpGroupModFailedCode_OFPGMFC_CHAINED_GROUP        OfpGroupModFailedCode = 9
	OfpGroupModFailedCode_OFPGMFC_BAD_TYPE             OfpGroupModFailedCode = 10
	OfpGroupModFailedCode_OFPGMFC_BAD_COMMAND          OfpGroupModFailedCode = 11
	OfpGroupModFailedCode_OFPGMFC_BAD_BUCKET           OfpGroupModFailedCode = 12
	OfpGroupModFailedCode_OFPGMFC_BAD_WATCH            OfpGroupModFailedCode = 13
	OfpGroupModFailedCode_OFPGMFC_EPERM                OfpGroupModFailedCode = 14
)

var OfpGroupModFailedCode_name = map[int32]string{
	0:  "OFPGMFC_GROUP_EXISTS",
	1:  "OFPGMFC_INVALID_GROUP",
	2:  "OFPGMFC_WEIGHT_UNSUPPORTED",
	3:  "OFPGMFC_OUT_OF_GROUPS",
	4:  "OFPGMFC_OUT_OF_BUCKETS",
	5:  "OFPGMFC_CHAINING_UNSUPPORTED",
	6:  "OFPGMFC_WATCH_UNSUPPORTED",
	7:  "OFPGMFC_LOOP",
	8:  "OFPGMFC_UNKNOWN_GROUP",
	9:  "OFPGMFC_CHAINED_GROUP",
	10: "OFPGMFC_BAD_TYPE",
	11: "OFPGMFC_BAD_COMMAND",
	12: "OFPGMFC_BAD_BUCKET",
	13: "OFPGMFC_BAD_WATCH",
	14: "OFPGMFC_EPERM",
}

var OfpGroupModFailedCode_value = map[string]int32{
	"OFPGMFC_GROUP_EXISTS":         0,
	"OFPGMFC_INVALID_GROUP":        1,
	"OFPGMFC_WEIGHT_UNSUPPORTED":   2,
	"OFPGMFC_OUT_OF_GROUPS":        3,
	"OFPGMFC_OUT_OF_BUCKETS":       4,
	"OFPGMFC_CHAINING_UNSUPPORTED": 5,
	"OFPGMFC_WATCH_UNSUPPORTED":    6,
	"OFPGMFC_LOOP":                 7,
	"OFPGMFC_UNKNOWN_GROUP":        8,
	"OFPGMFC_CHAINED_GROUP":        9,
	"OFPGMFC_BAD_TYPE":             10,
	"OFPGMFC_BAD_COMMAND":          11,
	"OFPGMFC_BAD_BUCKET":           12,
	"OFPGMFC_BAD_WATCH":            13,
	"OFPGMFC_EPERM":                14,
}

func (x OfpGroupModFailedCode) String() string {
	return proto.EnumName(OfpGroupModFailedCode_name, int32(x))
}

func (OfpGroupModFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{37}
}

// ofp_error_msg 'code' values for OFPET_PORT_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpPortModFailedCode int32

const (
	OfpPortModFailedCode_OFPPMFC_BAD_PORT      OfpPortModFailedCode = 0
	OfpPortModFailedCode_OFPPMFC_BAD_HW_ADDR   OfpPortModFailedCode = 1
	OfpPortModFailedCode_OFPPMFC_BAD_CONFIG    OfpPortModFailedCode = 2
	OfpPortModFailedCode_OFPPMFC_BAD_ADVERTISE OfpPortModFailedCode = 3
	OfpPortModFailedCode_OFPPMFC_EPERM         OfpPortModFailedCode = 4
)

var OfpPortModFailedCode_name = map[int32]string{
	0: "OFPPMFC_BAD_PORT",
	1: "OFPPMFC_BAD_HW_ADDR",
	2: "OFPPMFC_BAD_CONFIG",
	3: "OFPPMFC_BAD_ADVERTISE",
	4: "OFPPMFC_EPERM",
}

var OfpPortModFailedCode_value = map[string]int32{
	"OFPPMFC_BAD_PORT":      0,
	"OFPPMFC_BAD_HW_ADDR":   1,
	"OFPPMFC_BAD_CONFIG":    2,
	"OFPPMFC_BAD_ADVERTISE": 3,
	"OFPPMFC_EPERM":         4,
}

func (x OfpPortModFailedCode) String() string {
	return proto.EnumName(OfpPortModFailedCode_name, int32(x))
}

func (OfpPortModFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{38}
}

// ofp_error_msg 'code' values for OFPET_TABLE_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpTableModFailedCode int32

const (
	OfpTableModFailedCode_OFPTMFC_BAD_TABLE  OfpTableModFailedCode = 0
	OfpTableModFailedCode_OFPTMFC_BAD_CONFIG OfpTableModFailedCode = 1
	OfpTableModFailedCode_OFPTMFC_EPERM      OfpTableModFailedCode = 2
)

var OfpTableModFailedCode_name = map[int32]string{
	0: "OFPTMFC_BAD_TABLE",
	1: "OFPTMFC_BAD_CONFIG",
	2: "OFPTMFC_EPERM",
}

var OfpTableModFailedCode_value = map[string]int32{
	"OFPTMFC_BAD_TABLE":  0,
	"OFPTMFC_BAD_CONFIG": 1,
	"OFPTMFC_EPERM":      2,
}

func (x OfpTableModFailedCode) String() string {
	return proto.EnumName(OfpTableModFailedCode_name, int32(x))
}

func (OfpTableModFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{39}
}

// ofp_error msg 'code' values for OFPET_QUEUE_OP_FAILED. 'data' contains
// at least the first 64 bytes of the failed request
type OfpQueueOpFailedCode int32

const (
	OfpQueueOpFailedCode_OFPQOFC_BAD_PORT  OfpQueueOpFailedCode = 0
	OfpQueueOpFailedCode_OFPQOFC_BAD_QUEUE OfpQueueOpFailedCode = 1
	OfpQueueOpFailedCode_OFPQOFC_EPERM     OfpQueueOpFailedCode = 2
)

var OfpQueueOpFailedCode_name = map[int32]string{
	0: "OFPQOFC_BAD_PORT",
	1: "OFPQOFC_BAD_QUEUE",
	2: "OFPQOFC_EPERM",
}

var OfpQueueOpFailedCode_value = map[string]int32{
	"OFPQOFC_BAD_PORT":  0,
	"OFPQOFC_BAD_QUEUE": 1,
	"OFPQOFC_EPERM":     2,
}

func (x OfpQueueOpFailedCode) String() string {
	return proto.EnumName(OfpQueueOpFailedCode_name, int32(x))
}

func (OfpQueueOpFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{40}
}

// ofp_error_msg 'code' values for OFPET_SWITCH_CONFIG_FAILED. 'data' contains
// at least the first 64 bytes of the failed request.
type OfpSwitchConfigFailedCode int32

const (
	OfpSwitchConfigFailedCode_OFPSCFC_BAD_FLAGS OfpSwitchConfigFailedCode = 0
	OfpSwitchConfigFailedCode_OFPSCFC_BAD_LEN   OfpSwitchConfigFailedCode = 1
	OfpSwitchConfigFailedCode_OFPSCFC_EPERM     OfpSwitchConfigFailedCode = 2
)

var OfpSwitchConfigFailedCode_name = map[int32]string{
	0: "OFPSCFC_BAD_FLAGS",
	1: "OFPSCFC_BAD_LEN",
	2: "OFPSCFC_EPERM",
}

var OfpSwitchConfigFailedCode_value = map[string]int32{
	"OFPSCFC_BAD_FLAGS": 0,
	"OFPSCFC_BAD_LEN":   1,
	"OFPSCFC_EPERM":     2,
}

func (x OfpSwitchConfigFailedCode) String() string {
	return proto.EnumName(OfpSwitchConfigFailedCode_name, int32(x))
}

func (OfpSwitchConfigFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{41}
}

// ofp_error_msg 'code' values for OFPET_ROLE_REQUEST_FAILED. 'data' contains
// at least the first 64 bytes of the failed request.
type OfpRoleRequestFailedCode int32

const (
	OfpRoleRequestFailedCode_OFPRRFC_STALE    OfpRoleRequestFailedCode = 0
	OfpRoleRequestFailedCode_OFPRRFC_UNSUP    OfpRoleRequestFailedCode = 1
	OfpRoleRequestFailedCode_OFPRRFC_BAD_ROLE OfpRoleRequestFailedCode = 2
)

var OfpRoleRequestFailedCode_name = map[int32]string{
	0: "OFPRRFC_STALE",
	1: "OFPRRFC_UNSUP",
	2: "OFPRRFC_BAD_ROLE",
}

var OfpRoleRequestFailedCode_value = map[string]int32{
	"OFPRRFC_STALE":    0,
	"OFPRRFC_UNSUP":    1,
	"OFPRRFC_BAD_ROLE": 2,
}

func (x OfpRoleRequestFailedCode) String() string {
	return proto.EnumName(OfpRoleRequestFailedCode_name, int32(x))
}

func (OfpRoleRequestFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{42}
}

// ofp_error_msg 'code' values for OFPET_METER_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpMeterModFailedCode int32

const (
	OfpMeterModFailedCode_OFPMMFC_UNKNOWN         OfpMeterModFailedCode = 0
	OfpMeterModFailedCode_OFPMMFC_METER_EXISTS    OfpMeterModFailedCode = 1
	OfpMeterModFailedCode_OFPMMFC_INVALID_METER   OfpMeterModFailedCode = 2
	OfpMeterModFailedCode_OFPMMFC_UNKNOWN_METER   OfpMeterModFailedCode = 3
	OfpMeterModFailedCode_OFPMMFC_BAD_COMMAND     OfpMeterModFailedCode = 4
	OfpMeterModFailedCode_OFPMMFC_BAD_FLAGS       OfpMeterModFailedCode = 5
	OfpMeterModFailedCode_OFPMMFC_BAD_RATE        OfpMeterModFailedCode = 6
	OfpMeterModFailedCode_OFPMMFC_BAD_BURST       OfpMeterModFailedCode = 7
	OfpMeterModFailedCode_OFPMMFC_BAD_BAND        OfpMeterModFailedCode = 8
	OfpMeterModFailedCode_OFPMMFC_BAD_BAND_DETAIL OfpMeterModFailedCode = 9
	OfpMeterModFailedCode_OFPMMFC_OUT_OF_METERS   OfpMeterModFailedCode = 10
	OfpMeterModFailedCode_OFPMMFC_OUT_OF_BANDS    OfpMeterModFailedCode = 11
)

var OfpMeterModFailedCode_name = map[int32]string{
	0:  "OFPMMFC_UNKNOWN",
	1:  "OFPMMFC_METER_EXISTS",
	2:  "OFPMMFC_INVALID_METER",
	3:  "OFPMMFC_UNKNOWN_METER",
	4:  "OFPMMFC_BAD_COMMAND",
	5:  "OFPMMFC_BAD_FLAGS",
	6:  "OFPMMFC_BAD_RATE",
	7:  "OFPMMFC_BAD_BURST",
	8:  "OFPMMFC_BAD_BAND",
	9:  "OFPMMFC_BAD_BAND_DETAIL",
	10: "OFPMMFC_OUT_OF_METERS",
	11: "OFPMMFC_OUT_OF_BANDS",
}

var OfpMeterModFailedCode_value = map[string]int32{
	"OFPMMFC_UNKNOWN":         0,
	"OFPMMFC_METER_EXISTS":    1,
	"OFPMMFC_INVALID_METER":   2,
	"OFPMMFC_UNKNOWN_METER":   3,
	"OFPMMFC_BAD_COMMAND":     4,
	"OFPMMFC_BAD_FLAGS":       5,
	"OFPMMFC_BAD_RATE":        6,
	"OFPMMFC_BAD_BURST":       7,
	"OFPMMFC_BAD_BAND":        8,
	"OFPMMFC_BAD_BAND_DETAIL": 9,
	"OFPMMFC_OUT_OF_METERS":   10,
	"OFPMMFC_OUT_OF_BANDS":    11,
}

func (x OfpMeterModFailedCode) String() string {
	return proto.EnumName(OfpMeterModFailedCode_name, int32(x))
}

func (OfpMeterModFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{43}
}

// ofp_error_msg 'code' values for OFPET_TABLE_FEATURES_FAILED. 'data' contains
// at least the first 64 bytes of the failed request.
type OfpTableFeaturesFailedCode int32

const (
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_TABLE    OfpTableFeaturesFailedCode = 0
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_METADATA OfpTableFeaturesFailedCode = 1
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_TYPE     OfpTableFeaturesFailedCode = 2
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_LEN      OfpTableFeaturesFailedCode = 3
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_ARGUMENT OfpTableFeaturesFailedCode = 4
	OfpTableFeaturesFailedCode_OFPTFFC_EPERM        OfpTableFeaturesFailedCode = 5
)

var OfpTableFeaturesFailedCode_name = map[int32]string{
	0: "OFPTFFC_BAD_TABLE",
	1: "OFPTFFC_BAD_METADATA",
	2: "OFPTFFC_BAD_TYPE",
	3: "OFPTFFC_BAD_LEN",
	4: "OFPTFFC_BAD_ARGUMENT",
	5: "OFPTFFC_EPERM",
}

var OfpTableFeaturesFailedCode_value = map[string]int32{
	"OFPTFFC_BAD_TABLE":    0,
	"OFPTFFC_BAD_METADATA": 1,
	"OFPTFFC_BAD_TYPE":     2,
	"OFPTFFC_BAD_LEN":      3,
	"OFPTFFC_BAD_ARGUMENT": 4,
	"OFPTFFC_EPERM":        5,
}

func (x OfpTableFeaturesFailedCode) String() string {
	return proto.EnumName(OfpTableFeaturesFailedCode_name, int32(x))
}

func (OfpTableFeaturesFailedCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{44}
}

type OfpMultipartType int32

const (
	// Description of this OpenFlow switch.
	// The request body is empty.
	// The reply body is struct ofp_desc.
	OfpMultipartType_OFPMP_DESC OfpMultipartType = 0
	// Individual flow statistics.
	// The request body is struct ofp_flow_stats_request.
	// The reply body is an array of struct ofp_flow_stats.
	OfpMultipartType_OFPMP_FLOW OfpMultipartType = 1
	// Aggregate flow statistics.
	// The request body is struct ofp_aggregate_stats_request.
	// The reply body is struct ofp_aggregate_stats_reply.
	OfpMultipartType_OFPMP_AGGREGATE OfpMultipartType = 2
	// Flow table statistics.
	// The request body is empty.
	// The reply body is an array of struct ofp_table_stats.
	OfpMultipartType_OFPMP_TABLE OfpMultipartType = 3
	// Port statistics.
	// The request body is struct ofp_port_stats_request.
	// The reply body is an array of struct ofp_port_stats.
	OfpMultipartType_OFPMP_PORT_STATS OfpMultipartType = 4
	// Queue statistics for a port
	// The request body is struct ofp_queue_stats_request.
	// The reply body is an array of struct ofp_queue_stats
	OfpMultipartType_OFPMP_QUEUE OfpMultipartType = 5
	// Group counter statistics.
	// The request body is struct ofp_group_stats_request.
	// The reply is an array of struct ofp_group_stats.
	OfpMultipartType_OFPMP_GROUP OfpMultipartType = 6
	// Group description.
	// The request body is empty.
	// The reply body is an array of struct ofp_group_desc.
	OfpMultipartType_OFPMP_GROUP_DESC OfpMultipartType = 7
	// Group features.
	// The request body is empty.
	// The reply body is struct ofp_group_features.
	OfpMultipartType_OFPMP_GROUP_FEATURES OfpMultipartType = 8
	// Meter statistics.
	// The request body is struct ofp_meter_multipart_requests.
	// The reply body is an array of struct ofp_meter_stats.
	OfpMultipartType_OFPMP_METER OfpMultipartType = 9
	// Meter configuration.
	// The request body is struct ofp_meter_multipart_requests.
	// The reply body is an array of struct ofp_meter_config.
	OfpMultipartType_OFPMP_METER_CONFIG OfpMultipartType = 10
	// Meter features.
	// The request body is empty.
	// The reply body is struct ofp_meter_features.
	OfpMultipartType_OFPMP_METER_FEATURES OfpMultipartType = 11
	// Table features.
	// The request body is either empty or contains an array of
	// struct ofp_table_features containing the controller's
	// desired view of the switch. If the switch is unable to
	// set the specified view an error is returned.
	// The reply body is an array of struct ofp_table_features.
	OfpMultipartType_OFPMP_TABLE_FEATURES OfpMultipartType = 12
	// Port description.
	// The request body is empty.
	// The reply body is an array of struct ofp_port.
	OfpMultipartType_OFPMP_PORT_DESC OfpMultipartType = 13
	// Experimenter extension.
	// The request and reply bodies begin with
	// struct ofp_experimenter_multipart_header.
	// The request and reply bodies are otherwise experimenter-defined.
	OfpMultipartType_OFPMP_EXPERIMENTER OfpMultipartType = 65535
)

var OfpMultipartType_name = map[int32]string{
	0:     "OFPMP_DESC",
	1:     "OFPMP_FLOW",
	2:     "OFPMP_AGGREGATE",
	3:     "OFPMP_TABLE",
	4:     "OFPMP_PORT_STATS",
	5:     "OFPMP_QUEUE",
	6:     "OFPMP_GROUP",
	7:     "OFPMP_GROUP_DESC",
	8:     "OFPMP_GROUP_FEATURES",
	9:     "OFPMP_METER",
	10:    "OFPMP_METER_CONFIG",
	11:    "OFPMP_METER_FEATURES",
	12:    "OFPMP_TABLE_FEATURES",
	13:    "OFPMP_PORT_DESC",
	65535: "OFPMP_EXPERIMENTER",
}

var OfpMultipartType_value = map[string]int32{
	"OFPMP_DESC":           0,
	"OFPMP_FLOW":           1,
	"OFPMP_AGGREGATE":      2,
	"OFPMP_TABLE":          3,
	"OFPMP_PORT_STATS":     4,
	"OFPMP_QUEUE":          5,
	"OFPMP_GROUP":          6,
	"OFPMP_GROUP_DESC":     7,
	"OFPMP_GROUP_FEATURES": 8,
	"OFPMP_METER":          9,
	"OFPMP_METER_CONFIG":   10,
	"OFPMP_METER_FEATURES": 11,
	"OFPMP_TABLE_FEATURES": 12,
	"OFPMP_PORT_DESC":      13,
	"OFPMP_EXPERIMENTER":   65535,
}

func (x OfpMultipartType) String() string {
	return proto.EnumName(OfpMultipartType_name, int32(x))
}

func (OfpMultipartType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{45}
}

type OfpMultipartRequestFlags int32

const (
	OfpMultipartRequestFlags_OFPMPF_REQ_INVALID OfpMultipartRequestFlags = 0
	OfpMultipartRequestFlags_OFPMPF_REQ_MORE    OfpMultipartRequestFlags = 1
)

var OfpMultipartRequestFlags_name = map[int32]string{
	0: "OFPMPF_REQ_INVALID",
	1: "OFPMPF_REQ_MORE",
}

var OfpMultipartRequestFlags_value = map[string]int32{
	"OFPMPF_REQ_INVALID": 0,
	"OFPMPF_REQ_MORE":    1,
}

func (x OfpMultipartRequestFlags) String() string {
	return proto.EnumName(OfpMultipartRequestFlags_name, int32(x))
}

func (OfpMultipartRequestFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{46}
}

type OfpMultipartReplyFlags int32

const (
	OfpMultipartReplyFlags_OFPMPF_REPLY_INVALID OfpMultipartReplyFlags = 0
	OfpMultipartReplyFlags_OFPMPF_REPLY_MORE    OfpMultipartReplyFlags = 1
)

var OfpMultipartReplyFlags_name = map[int32]string{
	0: "OFPMPF_REPLY_INVALID",
	1: "OFPMPF_REPLY_MORE",
}

var OfpMultipartReplyFlags_value = map[string]int32{
	"OFPMPF_REPLY_INVALID": 0,
	"OFPMPF_REPLY_MORE":    1,
}

func (x OfpMultipartReplyFlags) String() string {
	return proto.EnumName(OfpMultipartReplyFlags_name, int32(x))
}

func (OfpMultipartReplyFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{47}
}

// Table Feature property types.
// Low order bit cleared indicates a property for a regular Flow Entry.
// Low order bit set indicates a property for the Table-Miss Flow Entry.
type OfpTableFeaturePropType int32

const (
	OfpTableFeaturePropType_OFPTFPT_INSTRUCTIONS        OfpTableFeaturePropType = 0
	OfpTableFeaturePropType_OFPTFPT_INSTRUCTIONS_MISS   OfpTableFeaturePropType = 1
	OfpTableFeaturePropType_OFPTFPT_NEXT_TABLES         OfpTableFeaturePropType = 2
	OfpTableFeaturePropType_OFPTFPT_NEXT_TABLES_MISS    OfpTableFeaturePropType = 3
	OfpTableFeaturePropType_OFPTFPT_WRITE_ACTIONS       OfpTableFeaturePropType = 4
	OfpTableFeaturePropType_OFPTFPT_WRITE_ACTIONS_MISS  OfpTableFeaturePropType = 5
	OfpTableFeaturePropType_OFPTFPT_APPLY_ACTIONS       OfpTableFeaturePropType = 6
	OfpTableFeaturePropType_OFPTFPT_APPLY_ACTIONS_MISS  OfpTableFeaturePropType = 7
	OfpTableFeaturePropType_OFPTFPT_MATCH               OfpTableFeaturePropType = 8
	OfpTableFeaturePropType_OFPTFPT_WILDCARDS           OfpTableFeaturePropType = 10
	OfpTableFeaturePropType_OFPTFPT_WRITE_SETFIELD      OfpTableFeaturePropType = 12
	OfpTableFeaturePropType_OFPTFPT_WRITE_SETFIELD_MISS OfpTableFeaturePropType = 13
	OfpTableFeaturePropType_OFPTFPT_APPLY_SETFIELD      OfpTableFeaturePropType = 14
	OfpTableFeaturePropType_OFPTFPT_APPLY_SETFIELD_MISS OfpTableFeaturePropType = 15
	OfpTableFeaturePropType_OFPTFPT_EXPERIMENTER        OfpTableFeaturePropType = 65534
	OfpTableFeaturePropType_OFPTFPT_EXPERIMENTER_MISS   OfpTableFeaturePropType = 65535
)

var OfpTableFeaturePropType_name = map[int32]string{
	0:     "OFPTFPT_INSTRUCTIONS",
	1:     "OFPTFPT_INSTRUCTIONS_MISS",
	2:     "OFPTFPT_NEXT_TABLES",
	3:     "OFPTFPT_NEXT_TABLES_MISS",
	4:     "OFPTFPT_WRITE_ACTIONS",
	5:     "OFPTFPT_WRITE_ACTIONS_MISS",
	6:     "OFPTFPT_APPLY_ACTIONS",
	7:     "OFPTFPT_APPLY_ACTIONS_MISS",
	8:     "OFPTFPT_MATCH",
	10:    "OFPTFPT_WILDCARDS",
	12:    "OFPTFPT_WRITE_SETFIELD",
	13:    "OFPTFPT_WRITE_SETFIELD_MISS",
	14:    "OFPTFPT_APPLY_SETFIELD",
	15:    "OFPTFPT_APPLY_SETFIELD_MISS",
	65534: "OFPTFPT_EXPERIMENTER",
	65535: "OFPTFPT_EXPERIMENTER_MISS",
}

var OfpTableFeaturePropType_value = map[string]int32{
	"OFPTFPT_INSTRUCTIONS":        0,
	"OFPTFPT_INSTRUCTIONS_MISS":   1,
	"OFPTFPT_NEXT_TABLES":         2,
	"OFPTFPT_NEXT_TABLES_MISS":    3,
	"OFPTFPT_WRITE_ACTIONS":       4,
	"OFPTFPT_WRITE_ACTIONS_MISS":  5,
	"OFPTFPT_APPLY_ACTIONS":       6,
	"OFPTFPT_APPLY_ACTIONS_MISS":  7,
	"OFPTFPT_MATCH":               8,
	"OFPTFPT_WILDCARDS":           10,
	"OFPTFPT_WRITE_SETFIELD":      12,
	"OFPTFPT_WRITE_SETFIELD_MISS": 13,
	"OFPTFPT_APPLY_SETFIELD":      14,
	"OFPTFPT_APPLY_SETFIELD_MISS": 15,
	"OFPTFPT_EXPERIMENTER":        65534,
	"OFPTFPT_EXPERIMENTER_MISS":   65535,
}

func (x OfpTableFeaturePropType) String() string {
	return proto.EnumName(OfpTableFeaturePropType_name, int32(x))
}

func (OfpTableFeaturePropType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{48}
}

// Group configuration flags
type OfpGroupCapabilities int32

const (
	OfpGroupCapabilities_OFPGFC_INVALID         OfpGroupCapabilities = 0
	OfpGroupCapabilities_OFPGFC_SELECT_WEIGHT   OfpGroupCapabilities = 1
	OfpGroupCapabilities_OFPGFC_SELECT_LIVENESS OfpGroupCapabilities = 2
	OfpGroupCapabilities_OFPGFC_CHAINING        OfpGroupCapabilities = 4
	OfpGroupCapabilities_OFPGFC_CHAINING_CHECKS OfpGroupCapabilities = 8
)

var OfpGroupCapabilities_name = map[int32]string{
	0: "OFPGFC_INVALID",
	1: "OFPGFC_SELECT_WEIGHT",
	2: "OFPGFC_SELECT_LIVENESS",
	4: "OFPGFC_CHAINING",
	8: "OFPGFC_CHAINING_CHECKS",
}

var OfpGroupCapabilities_value = map[string]int32{
	"OFPGFC_INVALID":         0,
	"OFPGFC_SELECT_WEIGHT":   1,
	"OFPGFC_SELECT_LIVENESS": 2,
	"OFPGFC_CHAINING":        4,
	"OFPGFC_CHAINING_CHECKS": 8,
}

func (x OfpGroupCapabilities) String() string {
	return proto.EnumName(OfpGroupCapabilities_name, int32(x))
}

func (OfpGroupCapabilities) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{49}
}

type OfpQueueProperties int32

const (
	OfpQueueProperties_OFPQT_INVALID      OfpQueueProperties = 0
	OfpQueueProperties_OFPQT_MIN_RATE     OfpQueueProperties = 1
	OfpQueueProperties_OFPQT_MAX_RATE     OfpQueueProperties = 2
	OfpQueueProperties_OFPQT_EXPERIMENTER OfpQueueProperties = 65535
)

var OfpQueueProperties_name = map[int32]string{
	0:     "OFPQT_INVALID",
	1:     "OFPQT_MIN_RATE",
	2:     "OFPQT_MAX_RATE",
	65535: "OFPQT_EXPERIMENTER",
}

var OfpQueueProperties_value = map[string]int32{
	"OFPQT_INVALID":      0,
	"OFPQT_MIN_RATE":     1,
	"OFPQT_MAX_RATE":     2,
	"OFPQT_EXPERIMENTER": 65535,
}

func (x OfpQueueProperties) String() string {
	return proto.EnumName(OfpQueueProperties_name, int32(x))
}

func (OfpQueueProperties) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{50}
}

// Controller roles.
type OfpControllerRole int32

const (
	OfpControllerRole_OFPCR_ROLE_NOCHANGE OfpControllerRole = 0
	OfpControllerRole_OFPCR_ROLE_EQUAL    OfpControllerRole = 1
	OfpControllerRole_OFPCR_ROLE_MASTER   OfpControllerRole = 2
	OfpControllerRole_OFPCR_ROLE_SLAVE    OfpControllerRole = 3
)

var OfpControllerRole_name = map[int32]string{
	0: "OFPCR_ROLE_NOCHANGE",
	1: "OFPCR_ROLE_EQUAL",
	2: "OFPCR_ROLE_MASTER",
	3: "OFPCR_ROLE_SLAVE",
}

var OfpControllerRole_value = map[string]int32{
	"OFPCR_ROLE_NOCHANGE": 0,
	"OFPCR_ROLE_EQUAL":    1,
	"OFPCR_ROLE_MASTER":   2,
	"OFPCR_ROLE_SLAVE":    3,
}

func (x OfpControllerRole) String() string {
	return proto.EnumName(OfpControllerRole_name, int32(x))
}

func (OfpControllerRole) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{51}
}

// Header on all OpenFlow packets.
type OfpHeader struct {
	Version              uint32   `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Type                 OfpType  `protobuf:"varint,2,opt,name=type,proto3,enum=openflow_13.OfpType" json:"type,omitempty"`
	Xid                  uint32   `protobuf:"varint,3,opt,name=xid,proto3" json:"xid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpHeader) Reset()         { *m = OfpHeader{} }
func (m *OfpHeader) String() string { return proto.CompactTextString(m) }
func (*OfpHeader) ProtoMessage()    {}
func (*OfpHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{0}
}

func (m *OfpHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpHeader.Unmarshal(m, b)
}
func (m *OfpHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpHeader.Marshal(b, m, deterministic)
}
func (m *OfpHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpHeader.Merge(m, src)
}
func (m *OfpHeader) XXX_Size() int {
	return xxx_messageInfo_OfpHeader.Size(m)
}
func (m *OfpHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpHeader.DiscardUnknown(m)
}

var xxx_messageInfo_OfpHeader proto.InternalMessageInfo

func (m *OfpHeader) GetVersion() uint32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *OfpHeader) GetType() OfpType {
	if m != nil {
		return m.Type
	}
	return OfpType_OFPT_HELLO
}

func (m *OfpHeader) GetXid() uint32 {
	if m != nil {
		return m.Xid
	}
	return 0
}

// Common header for all Hello Elements
type OfpHelloElemHeader struct {
	Type OfpHelloElemType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpHelloElemType" json:"type,omitempty"`
	// Types that are valid to be assigned to Element:
	//	*OfpHelloElemHeader_Versionbitmap
	Element              isOfpHelloElemHeader_Element `protobuf_oneof:"element"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *OfpHelloElemHeader) Reset()         { *m = OfpHelloElemHeader{} }
func (m *OfpHelloElemHeader) String() string { return proto.CompactTextString(m) }
func (*OfpHelloElemHeader) ProtoMessage()    {}
func (*OfpHelloElemHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{1}
}

func (m *OfpHelloElemHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpHelloElemHeader.Unmarshal(m, b)
}
func (m *OfpHelloElemHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpHelloElemHeader.Marshal(b, m, deterministic)
}
func (m *OfpHelloElemHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpHelloElemHeader.Merge(m, src)
}
func (m *OfpHelloElemHeader) XXX_Size() int {
	return xxx_messageInfo_OfpHelloElemHeader.Size(m)
}
func (m *OfpHelloElemHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpHelloElemHeader.DiscardUnknown(m)
}

var xxx_messageInfo_OfpHelloElemHeader proto.InternalMessageInfo

func (m *OfpHelloElemHeader) GetType() OfpHelloElemType {
	if m != nil {
		return m.Type
	}
	return OfpHelloElemType_OFPHET_INVALID
}

type isOfpHelloElemHeader_Element interface {
	isOfpHelloElemHeader_Element()
}

type OfpHelloElemHeader_Versionbitmap struct {
	Versionbitmap *OfpHelloElemVersionbitmap `protobuf:"bytes,2,opt,name=versionbitmap,proto3,oneof"`
}

func (*OfpHelloElemHeader_Versionbitmap) isOfpHelloElemHeader_Element() {}

func (m *OfpHelloElemHeader) GetElement() isOfpHelloElemHeader_Element {
	if m != nil {
		return m.Element
	}
	return nil
}

func (m *OfpHelloElemHeader) GetVersionbitmap() *OfpHelloElemVersionbitmap {
	if x, ok := m.GetElement().(*OfpHelloElemHeader_Versionbitmap); ok {
		return x.Versionbitmap
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OfpHelloElemHeader) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OfpHelloElemHeader_Versionbitmap)(nil),
	}
}

// Version bitmap Hello Element
type OfpHelloElemVersionbitmap struct {
	Bitmaps              []uint32 `protobuf:"varint,2,rep,packed,name=bitmaps,proto3" json:"bitmaps,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpHelloElemVersionbitmap) Reset()         { *m = OfpHelloElemVersionbitmap{} }
func (m *OfpHelloElemVersionbitmap) String() string { return proto.CompactTextString(m) }
func (*OfpHelloElemVersionbitmap) ProtoMessage()    {}
func (*OfpHelloElemVersionbitmap) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{2}
}

func (m *OfpHelloElemVersionbitmap) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpHelloElemVersionbitmap.Unmarshal(m, b)
}
func (m *OfpHelloElemVersionbitmap) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpHelloElemVersionbitmap.Marshal(b, m, deterministic)
}
func (m *OfpHelloElemVersionbitmap) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpHelloElemVersionbitmap.Merge(m, src)
}
func (m *OfpHelloElemVersionbitmap) XXX_Size() int {
	return xxx_messageInfo_OfpHelloElemVersionbitmap.Size(m)
}
func (m *OfpHelloElemVersionbitmap) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpHelloElemVersionbitmap.DiscardUnknown(m)
}

var xxx_messageInfo_OfpHelloElemVersionbitmap proto.InternalMessageInfo

func (m *OfpHelloElemVersionbitmap) GetBitmaps() []uint32 {
	if m != nil {
		return m.Bitmaps
	}
	return nil
}

// OFPT_HELLO.  This message includes zero or more hello elements having
// variable size. Unknown elements types must be ignored/skipped, to allow
// for future extensions.
type OfpHello struct {
	// Hello element list
	Elements             []*OfpHelloElemHeader `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OfpHello) Reset()         { *m = OfpHello{} }
func (m *OfpHello) String() string { return proto.CompactTextString(m) }
func (*OfpHello) ProtoMessage()    {}
func (*OfpHello) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{3}
}

func (m *OfpHello) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpHello.Unmarshal(m, b)
}
func (m *OfpHello) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpHello.Marshal(b, m, deterministic)
}
func (m *OfpHello) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpHello.Merge(m, src)
}
func (m *OfpHello) XXX_Size() int {
	return xxx_messageInfo_OfpHello.Size(m)
}
func (m *OfpHello) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpHello.DiscardUnknown(m)
}

var xxx_messageInfo_OfpHello proto.InternalMessageInfo

func (m *OfpHello) GetElements() []*OfpHelloElemHeader {
	if m != nil {
		return m.Elements
	}
	return nil
}

// Switch configuration.
type OfpSwitchConfig struct {
	//ofp_header header;
	Flags                uint32   `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"`
	MissSendLen          uint32   `protobuf:"varint,2,opt,name=miss_send_len,json=missSendLen,proto3" json:"miss_send_len,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpSwitchConfig) Reset()         { *m = OfpSwitchConfig{} }
func (m *OfpSwitchConfig) String() string { return proto.CompactTextString(m) }
func (*OfpSwitchConfig) ProtoMessage()    {}
func (*OfpSwitchConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{4}
}

func (m *OfpSwitchConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpSwitchConfig.Unmarshal(m, b)
}
func (m *OfpSwitchConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpSwitchConfig.Marshal(b, m, deterministic)
}
func (m *OfpSwitchConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpSwitchConfig.Merge(m, src)
}
func (m *OfpSwitchConfig) XXX_Size() int {
	return xxx_messageInfo_OfpSwitchConfig.Size(m)
}
func (m *OfpSwitchConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpSwitchConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OfpSwitchConfig proto.InternalMessageInfo

func (m *OfpSwitchConfig) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *OfpSwitchConfig) GetMissSendLen() uint32 {
	if m != nil {
		return m.MissSendLen
	}
	return 0
}

// Configure/Modify behavior of a flow table
type OfpTableMod struct {
	//ofp_header header;
	TableId              uint32   `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	Config               uint32   `protobuf:"varint,2,opt,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpTableMod) Reset()         { *m = OfpTableMod{} }
func (m *OfpTableMod) String() string { return proto.CompactTextString(m) }
func (*OfpTableMod) ProtoMessage()    {}
func (*OfpTableMod) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{5}
}

func (m *OfpTableMod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableMod.Unmarshal(m, b)
}
func (m *OfpTableMod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableMod.Marshal(b, m, deterministic)
}
func (m *OfpTableMod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableMod.Merge(m, src)
}
func (m *OfpTableMod) XXX_Size() int {
	return xxx_messageInfo_OfpTableMod.Size(m)
}
func (m *OfpTableMod) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableMod.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableMod proto.InternalMessageInfo

func (m *OfpTableMod) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpTableMod) GetConfig() uint32 {
	if m != nil {
		return m.Config
	}
	return 0
}

// Description of a port
type OfpPort struct {
	PortNo uint32   `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	HwAddr []uint32 `protobuf:"varint,2,rep,packed,name=hw_addr,json=hwAddr,proto3" json:"hw_addr,omitempty"`
	Name   string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Config uint32   `protobuf:"varint,4,opt,name=config,proto3" json:"config,omitempty"`
	State  uint32   `protobuf:"varint,5,opt,name=state,proto3" json:"state,omitempty"`
	// Bitmaps of OFPPF_* that describe features.  All bits zeroed if
	// unsupported or unavailable.
	Curr                 uint32   `protobuf:"varint,6,opt,name=curr,proto3" json:"curr,omitempty"`
	Advertised           uint32   `protobuf:"varint,7,opt,name=advertised,proto3" json:"advertised,omitempty"`
	Supported            uint32   `protobuf:"varint,8,opt,name=supported,proto3" json:"supported,omitempty"`
	Peer                 uint32   `protobuf:"varint,9,opt,name=peer,proto3" json:"peer,omitempty"`
	CurrSpeed            uint32   `protobuf:"varint,10,opt,name=curr_speed,json=currSpeed,proto3" json:"curr_speed,omitempty"`
	MaxSpeed             uint32   `protobuf:"varint,11,opt,name=max_speed,json=maxSpeed,proto3" json:"max_speed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpPort) Reset()         { *m = OfpPort{} }
func (m *OfpPort) String() string { return proto.CompactTextString(m) }
func (*OfpPort) ProtoMessage()    {}
func (*OfpPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{6}
}

func (m *OfpPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpPort.Unmarshal(m, b)
}
func (m *OfpPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpPort.Marshal(b, m, deterministic)
}
func (m *OfpPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpPort.Merge(m, src)
}
func (m *OfpPort) XXX_Size() int {
	return xxx_messageInfo_OfpPort.Size(m)
}
func (m *OfpPort) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpPort.DiscardUnknown(m)
}

var xxx_messageInfo_OfpPort proto.InternalMessageInfo

func (m *OfpPort) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *OfpPort) GetHwAddr() []uint32 {
	if m != nil {
		return m.HwAddr
	}
	return nil
}

func (m *OfpPort) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *OfpPort) GetConfig() uint32 {
	if m != nil {
		return m.Config
	}
	return 0
}

func (m *OfpPort) GetState() uint32 {
	if m != nil {
		return m.State
	}
	return 0
}

func (m *OfpPort) GetCurr() uint32 {
	if m != nil {
		return m.Curr
	}
	return 0
}

func (m *OfpPort) GetAdvertised() uint32 {
	if m != nil {
		return m.Advertised
	}
	return 0
}

func (m *OfpPort) GetSupported() uint32 {
	if m != nil {
		return m.Supported
	}
	return 0
}

func (m *OfpPort) GetPeer() uint32 {
	if m != nil {
		return m.Peer
	}
	return 0
}

func (m *OfpPort) GetCurrSpeed() uint32 {
	if m != nil {
		return m.CurrSpeed
	}
	return 0
}

func (m *OfpPort) GetMaxSpeed() uint32 {
	if m != nil {
		return m.MaxSpeed
	}
	return 0
}

// Switch features.
type OfpSwitchFeatures struct {
	//ofp_header header;
	DatapathId  uint64 `protobuf:"varint,1,opt,name=datapath_id,json=datapathId,proto3" json:"datapath_id,omitempty"`
	NBuffers    uint32 `protobuf:"varint,2,opt,name=n_buffers,json=nBuffers,proto3" json:"n_buffers,omitempty"`
	NTables     uint32 `protobuf:"varint,3,opt,name=n_tables,json=nTables,proto3" json:"n_tables,omitempty"`
	AuxiliaryId uint32 `protobuf:"varint,4,opt,name=auxiliary_id,json=auxiliaryId,proto3" json:"auxiliary_id,omitempty"`
	// Features.
	Capabilities         uint32   `protobuf:"varint,5,opt,name=capabilities,proto3" json:"capabilities,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpSwitchFeatures) Reset()         { *m = OfpSwitchFeatures{} }
func (m *OfpSwitchFeatures) String() string { return proto.CompactTextString(m) }
func (*OfpSwitchFeatures) ProtoMessage()    {}
func (*OfpSwitchFeatures) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{7}
}

func (m *OfpSwitchFeatures) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpSwitchFeatures.Unmarshal(m, b)
}
func (m *OfpSwitchFeatures) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpSwitchFeatures.Marshal(b, m, deterministic)
}
func (m *OfpSwitchFeatures) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpSwitchFeatures.Merge(m, src)
}
func (m *OfpSwitchFeatures) XXX_Size() int {
	return xxx_messageInfo_OfpSwitchFeatures.Size(m)
}
func (m *OfpSwitchFeatures) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpSwitchFeatures.DiscardUnknown(m)
}

var xxx_messageInfo_OfpSwitchFeatures proto.InternalMessageInfo

func (m *OfpSwitchFeatures) GetDatapathId() uint64 {
	if m != nil {
		return m.DatapathId
	}
	return 0
}

func (m *OfpSwitchFeatures) GetNBuffers() uint32 {
	if m != nil {
		return m.NBuffers
	}
	return 0
}

func (m *OfpSwitchFeatures) GetNTables() uint32 {
	if m != nil {
		return m.NTables
	}
	return 0
}

func (m *OfpSwitchFeatures) GetAuxiliaryId() uint32 {
	if m != nil {
		return m.AuxiliaryId
	}
	return 0
}

func (m *OfpSwitchFeatures) GetCapabilities() uint32 {
	if m != nil {
		return m.Capabilities
	}
	return 0
}

// A physical port has changed in the datapath
type OfpPortStatus struct {
	//ofp_header header;
	Reason               OfpPortReason `protobuf:"varint,1,opt,name=reason,proto3,enum=openflow_13.OfpPortReason" json:"reason,omitempty"`
	Desc                 *OfpPort      `protobuf:"bytes,2,opt,name=desc,proto3" json:"desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *OfpPortStatus) Reset()         { *m = OfpPortStatus{} }
func (m *OfpPortStatus) String() string { return proto.CompactTextString(m) }
func (*OfpPortStatus) ProtoMessage()    {}
func (*OfpPortStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{8}
}

func (m *OfpPortStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpPortStatus.Unmarshal(m, b)
}
func (m *OfpPortStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpPortStatus.Marshal(b, m, deterministic)
}
func (m *OfpPortStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpPortStatus.Merge(m, src)
}
func (m *OfpPortStatus) XXX_Size() int {
	return xxx_messageInfo_OfpPortStatus.Size(m)
}
func (m *OfpPortStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpPortStatus.DiscardUnknown(m)
}

var xxx_messageInfo_OfpPortStatus proto.InternalMessageInfo

func (m *OfpPortStatus) GetReason() OfpPortReason {
	if m != nil {
		return m.Reason
	}
	return OfpPortReason_OFPPR_ADD
}

func (m *OfpPortStatus) GetDesc() *OfpPort {
	if m != nil {
		return m.Desc
	}
	return nil
}

// Modify behavior of the physical port
type OfpPortMod struct {
	//ofp_header header;
	PortNo uint32   `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	HwAddr []uint32 `protobuf:"varint,2,rep,packed,name=hw_addr,json=hwAddr,proto3" json:"hw_addr,omitempty"`
	// The hardware address is not
	//configurable.  This is used to
	//sanity-check the request, so it must
	//be the same as returned in an
	//ofp_port struct.
	Config               uint32   `protobuf:"varint,3,opt,name=config,proto3" json:"config,omitempty"`
	Mask                 uint32   `protobuf:"varint,4,opt,name=mask,proto3" json:"mask,omitempty"`
	Advertise            uint32   `protobuf:"varint,5,opt,name=advertise,proto3" json:"advertise,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpPortMod) Reset()         { *m = OfpPortMod{} }
func (m *OfpPortMod) String() string { return proto.CompactTextString(m) }
func (*OfpPortMod) ProtoMessage()    {}
func (*OfpPortMod) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{9}
}

func (m *OfpPortMod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpPortMod.Unmarshal(m, b)
}
func (m *OfpPortMod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpPortMod.Marshal(b, m, deterministic)
}
func (m *OfpPortMod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpPortMod.Merge(m, src)
}
func (m *OfpPortMod) XXX_Size() int {
	return xxx_messageInfo_OfpPortMod.Size(m)
}
func (m *OfpPortMod) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpPortMod.DiscardUnknown(m)
}

var xxx_messageInfo_OfpPortMod proto.InternalMessageInfo

func (m *OfpPortMod) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *OfpPortMod) GetHwAddr() []uint32 {
	if m != nil {
		return m.HwAddr
	}
	return nil
}

func (m *OfpPortMod) GetConfig() uint32 {
	if m != nil {
		return m.Config
	}
	return 0
}

func (m *OfpPortMod) GetMask() uint32 {
	if m != nil {
		return m.Mask
	}
	return 0
}

func (m *OfpPortMod) GetAdvertise() uint32 {
	if m != nil {
		return m.Advertise
	}
	return 0
}

// Fields to match against flows
type OfpMatch struct {
	Type                 OfpMatchType   `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpMatchType" json:"type,omitempty"`
	OxmFields            []*OfpOxmField `protobuf:"bytes,2,rep,name=oxm_fields,json=oxmFields,proto3" json:"oxm_fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *OfpMatch) Reset()         { *m = OfpMatch{} }
func (m *OfpMatch) String() string { return proto.CompactTextString(m) }
func (*OfpMatch) ProtoMessage()    {}
func (*OfpMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{10}
}

func (m *OfpMatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMatch.Unmarshal(m, b)
}
func (m *OfpMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMatch.Marshal(b, m, deterministic)
}
func (m *OfpMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMatch.Merge(m, src)
}
func (m *OfpMatch) XXX_Size() int {
	return xxx_messageInfo_OfpMatch.Size(m)
}
func (m *OfpMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMatch.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMatch proto.InternalMessageInfo

func (m *OfpMatch) GetType() OfpMatchType {
	if m != nil {
		return m.Type
	}
	return OfpMatchType_OFPMT_STANDARD
}

func (m *OfpMatch) GetOxmFields() []*OfpOxmField {
	if m != nil {
		return m.OxmFields
	}
	return nil
}

// OXM Flow match fields
type OfpOxmField struct {
	OxmClass OfpOxmClass `protobuf:"varint,1,opt,name=oxm_class,json=oxmClass,proto3,enum=openflow_13.OfpOxmClass" json:"oxm_class,omitempty"`
	// Types that are valid to be assigned to Field:
	//	*OfpOxmField_OfbField
	//	*OfpOxmField_ExperimenterField
	Field                isOfpOxmField_Field `protobuf_oneof:"field"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *OfpOxmField) Reset()         { *m = OfpOxmField{} }
func (m *OfpOxmField) String() string { return proto.CompactTextString(m) }
func (*OfpOxmField) ProtoMessage()    {}
func (*OfpOxmField) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{11}
}

func (m *OfpOxmField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpOxmField.Unmarshal(m, b)
}
func (m *OfpOxmField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpOxmField.Marshal(b, m, deterministic)
}
func (m *OfpOxmField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpOxmField.Merge(m, src)
}
func (m *OfpOxmField) XXX_Size() int {
	return xxx_messageInfo_OfpOxmField.Size(m)
}
func (m *OfpOxmField) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpOxmField.DiscardUnknown(m)
}

var xxx_messageInfo_OfpOxmField proto.InternalMessageInfo

func (m *OfpOxmField) GetOxmClass() OfpOxmClass {
	if m != nil {
		return m.OxmClass
	}
	return OfpOxmClass_OFPXMC_NXM_0
}

type isOfpOxmField_Field interface {
	isOfpOxmField_Field()
}

type OfpOxmField_OfbField struct {
	OfbField *OfpOxmOfbField `protobuf:"bytes,4,opt,name=ofb_field,json=ofbField,proto3,oneof"`
}

type OfpOxmField_ExperimenterField struct {
	ExperimenterField *OfpOxmExperimenterField `protobuf:"bytes,5,opt,name=experimenter_field,json=experimenterField,proto3,oneof"`
}

func (*OfpOxmField_OfbField) isOfpOxmField_Field() {}

func (*OfpOxmField_ExperimenterField) isOfpOxmField_Field() {}

func (m *OfpOxmField) GetField() isOfpOxmField_Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *OfpOxmField) GetOfbField() *OfpOxmOfbField {
	if x, ok := m.GetField().(*OfpOxmField_OfbField); ok {
		return x.OfbField
	}
	return nil
}

func (m *OfpOxmField) GetExperimenterField() *OfpOxmExperimenterField {
	if x, ok := m.GetField().(*OfpOxmField_ExperimenterField); ok {
		return x.ExperimenterField
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OfpOxmField) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OfpOxmField_OfbField)(nil),
		(*OfpOxmField_ExperimenterField)(nil),
	}
}

// OXM OpenFlow Basic Match Field
type OfpOxmOfbField struct {
	Type    OxmOfbFieldTypes `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OxmOfbFieldTypes" json:"type,omitempty"`
	HasMask bool             `protobuf:"varint,2,opt,name=has_mask,json=hasMask,proto3" json:"has_mask,omitempty"`
	// Types that are valid to be assigned to Value:
	//	*OfpOxmOfbField_Port
	//	*OfpOxmOfbField_PhysicalPort
	//	*OfpOxmOfbField_TableMetadata
	//	*OfpOxmOfbField_EthDst
	//	*OfpOxmOfbField_EthSrc
	//	*OfpOxmOfbField_EthType
	//	*OfpOxmOfbField_VlanVid
	//	*OfpOxmOfbField_VlanPcp
	//	*OfpOxmOfbField_IpDscp
	//	*OfpOxmOfbField_IpEcn
	//	*OfpOxmOfbField_IpProto
	//	*OfpOxmOfbField_Ipv4Src
	//	*OfpOxmOfbField_Ipv4Dst
	//	*OfpOxmOfbField_TcpSrc
	//	*OfpOxmOfbField_TcpDst
	//	*OfpOxmOfbField_UdpSrc
	//	*OfpOxmOfbField_UdpDst
	//	*OfpOxmOfbField_SctpSrc
	//	*OfpOxmOfbField_SctpDst
	//	*OfpOxmOfbField_Icmpv4Type
	//	*OfpOxmOfbField_Icmpv4Code
	//	*OfpOxmOfbField_ArpOp
	//	*OfpOxmOfbField_ArpSpa
	//	*OfpOxmOfbField_ArpTpa
	//	*OfpOxmOfbField_ArpSha
	//	*OfpOxmOfbField_ArpTha
	//	*OfpOxmOfbField_Ipv6Src
	//	*OfpOxmOfbField_Ipv6Dst
	//	*OfpOxmOfbField_Ipv6Flabel
	//	*OfpOxmOfbField_Icmpv6Type
	//	*OfpOxmOfbField_Icmpv6Code
	//	*OfpOxmOfbField_Ipv6NdTarget
	//	*OfpOxmOfbField_Ipv6NdSsl
	//	*OfpOxmOfbField_Ipv6NdTll
	//	*OfpOxmOfbField_MplsLabel
	//	*OfpOxmOfbField_MplsTc
	//	*OfpOxmOfbField_MplsBos
	//	*OfpOxmOfbField_PbbIsid
	//	*OfpOxmOfbField_TunnelId
	//	*OfpOxmOfbField_Ipv6Exthdr
	Value isOfpOxmOfbField_Value `protobuf_oneof:"value"`
	// Optional mask values (must be present when has_mask is true
	//
	// Types that are valid to be assigned to Mask:
	//	*OfpOxmOfbField_TableMetadataMask
	//	*OfpOxmOfbField_EthDstMask
	//	*OfpOxmOfbField_EthSrcMask
	//	*OfpOxmOfbField_VlanVidMask
	//	*OfpOxmOfbField_Ipv4SrcMask
	//	*OfpOxmOfbField_Ipv4DstMask
	//	*OfpOxmOfbField_ArpSpaMask
	//	*OfpOxmOfbField_ArpTpaMask
	//	*OfpOxmOfbField_Ipv6SrcMask
	//	*OfpOxmOfbField_Ipv6DstMask
	//	*OfpOxmOfbField_Ipv6FlabelMask
	//	*OfpOxmOfbField_PbbIsidMask
	//	*OfpOxmOfbField_TunnelIdMask
	//	*OfpOxmOfbField_Ipv6ExthdrMask
	Mask                 isOfpOxmOfbField_Mask `protobuf_oneof:"mask"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OfpOxmOfbField) Reset()         { *m = OfpOxmOfbField{} }
func (m *OfpOxmOfbField) String() string { return proto.CompactTextString(m) }
func (*OfpOxmOfbField) ProtoMessage()    {}
func (*OfpOxmOfbField) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{12}
}

func (m *OfpOxmOfbField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpOxmOfbField.Unmarshal(m, b)
}
func (m *OfpOxmOfbField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpOxmOfbField.Marshal(b, m, deterministic)
}
func (m *OfpOxmOfbField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpOxmOfbField.Merge(m, src)
}
func (m *OfpOxmOfbField) XXX_Size() int {
	return xxx_messageInfo_OfpOxmOfbField.Size(m)
}
func (m *OfpOxmOfbField) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpOxmOfbField.DiscardUnknown(m)
}

var xxx_messageInfo_OfpOxmOfbField proto.InternalMessageInfo

func (m *OfpOxmOfbField) GetType() OxmOfbFieldTypes {
	if m != nil {
		return m.Type
	}
	return OxmOfbFieldTypes_OFPXMT_OFB_IN_PORT
}

func (m *OfpOxmOfbField) GetHasMask() bool {
	if m != nil {
		return m.HasMask
	}
	return false
}

type isOfpOxmOfbField_Value interface {
	isOfpOxmOfbField_Value()
}

type OfpOxmOfbField_Port struct {
	Port uint32 `protobuf:"varint,3,opt,name=port,proto3,oneof"`
}

type OfpOxmOfbField_PhysicalPort struct {
	PhysicalPort uint32 `protobuf:"varint,4,opt,name=physical_port,json=physicalPort,proto3,oneof"`
}

type OfpOxmOfbField_TableMetadata struct {
	TableMetadata uint64 `protobuf:"varint,5,opt,name=table_metadata,json=tableMetadata,proto3,oneof"`
}

type OfpOxmOfbField_EthDst struct {
	EthDst []byte `protobuf:"bytes,6,opt,name=eth_dst,json=ethDst,proto3,oneof"`
}

type OfpOxmOfbField_EthSrc struct {
	EthSrc []byte `protobuf:"bytes,7,opt,name=eth_src,json=ethSrc,proto3,oneof"`
}

type OfpOxmOfbField_EthType struct {
	EthType uint32 `protobuf:"varint,8,opt,name=eth_type,json=ethType,proto3,oneof"`
}

type OfpOxmOfbField_VlanVid struct {
	VlanVid uint32 `protobuf:"varint,9,opt,name=vlan_vid,json=vlanVid,proto3,oneof"`
}

type OfpOxmOfbField_VlanPcp struct {
	VlanPcp uint32 `protobuf:"varint,10,opt,name=vlan_pcp,json=vlanPcp,proto3,oneof"`
}

type OfpOxmOfbField_IpDscp struct {
	IpDscp uint32 `protobuf:"varint,11,opt,name=ip_dscp,json=ipDscp,proto3,oneof"`
}

type OfpOxmOfbField_IpEcn struct {
	IpEcn uint32 `protobuf:"varint,12,opt,name=ip_ecn,json=ipEcn,proto3,oneof"`
}

type OfpOxmOfbField_IpProto struct {
	IpProto uint32 `protobuf:"varint,13,opt,name=ip_proto,json=ipProto,proto3,oneof"`
}

type OfpOxmOfbField_Ipv4Src struct {
	Ipv4Src uint32 `protobuf:"varint,14,opt,name=ipv4_src,json=ipv4Src,proto3,oneof"`
}

type OfpOxmOfbField_Ipv4Dst struct {
	Ipv4Dst uint32 `protobuf:"varint,15,opt,name=ipv4_dst,json=ipv4Dst,proto3,oneof"`
}

type OfpOxmOfbField_TcpSrc struct {
	TcpSrc uint32 `protobuf:"varint,16,opt,name=tcp_src,json=tcpSrc,proto3,oneof"`
}

type OfpOxmOfbField_TcpDst struct {
	TcpDst uint32 `protobuf:"varint,17,opt,name=tcp_dst,json=tcpDst,proto3,oneof"`
}

type OfpOxmOfbField_UdpSrc struct {
	UdpSrc uint32 `protobuf:"varint,18,opt,name=udp_src,json=udpSrc,proto3,oneof"`
}

type OfpOxmOfbField_UdpDst struct {
	UdpDst uint32 `protobuf:"varint,19,opt,name=udp_dst,json=udpDst,proto3,oneof"`
}

type OfpOxmOfbField_SctpSrc struct {
	SctpSrc uint32 `protobuf:"varint,20,opt,name=sctp_src,json=sctpSrc,proto3,oneof"`
}

type OfpOxmOfbField_SctpDst struct {
	SctpDst uint32 `protobuf:"varint,21,opt,name=sctp_dst,json=sctpDst,proto3,oneof"`
}

type OfpOxmOfbField_Icmpv4Type struct {
	Icmpv4Type uint32 `protobuf:"varint,22,opt,name=icmpv4_type,json=icmpv4Type,proto3,oneof"`
}

type OfpOxmOfbField_Icmpv4Code struct {
	Icmpv4Code uint32 `protobuf:"varint,23,opt,name=icmpv4_code,json=icmpv4Code,proto3,oneof"`
}

type OfpOxmOfbField_ArpOp struct {
	ArpOp uint32 `protobuf:"varint,24,opt,name=arp_op,json=arpOp,proto3,oneof"`
}

type OfpOxmOfbField_ArpSpa struct {
	ArpSpa uint32 `protobuf:"varint,25,opt,name=arp_spa,json=arpSpa,proto3,oneof"`
}

type OfpOxmOfbField_ArpTpa struct {
	ArpTpa uint32 `protobuf:"varint,26,opt,name=arp_tpa,json=arpTpa,proto3,oneof"`
}

type OfpOxmOfbField_ArpSha struct {
	ArpSha []byte `protobuf:"bytes,27,opt,name=arp_sha,json=arpSha,proto3,oneof"`
}

type OfpOxmOfbField_ArpTha struct {
	ArpTha []byte `protobuf:"bytes,28,opt,name=arp_tha,json=arpTha,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6Src struct {
	Ipv6Src []byte `protobuf:"bytes,29,opt,name=ipv6_src,json=ipv6Src,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6Dst struct {
	Ipv6Dst []byte `protobuf:"bytes,30,opt,name=ipv6_dst,json=ipv6Dst,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6Flabel struct {
	Ipv6Flabel uint32 `protobuf:"varint,31,opt,name=ipv6_flabel,json=ipv6Flabel,proto3,oneof"`
}

type OfpOxmOfbField_Icmpv6Type struct {
	Icmpv6Type uint32 `protobuf:"varint,32,opt,name=icmpv6_type,json=icmpv6Type,proto3,oneof"`
}

type OfpOxmOfbField_Icmpv6Code struct {
	Icmpv6Code uint32 `protobuf:"varint,33,opt,name=icmpv6_code,json=icmpv6Code,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6NdTarget struct {
	Ipv6NdTarget []byte `protobuf:"bytes,34,opt,name=ipv6_nd_target,json=ipv6NdTarget,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6NdSsl struct {
	Ipv6NdSsl []byte `protobuf:"bytes,35,opt,name=ipv6_nd_ssl,json=ipv6NdSsl,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6NdTll struct {
	Ipv6NdTll []byte `protobuf:"bytes,36,opt,name=ipv6_nd_tll,json=ipv6NdTll,proto3,oneof"`
}

type OfpOxmOfbField_MplsLabel struct {
	MplsLabel uint32 `protobuf:"varint,37,opt,name=mpls_label,json=mplsLabel,proto3,oneof"`
}

type OfpOxmOfbField_MplsTc struct {
	MplsTc uint32 `protobuf:"varint,38,opt,name=mpls_tc,json=mplsTc,proto3,oneof"`
}

type OfpOxmOfbField_MplsBos struct {
	MplsBos uint32 `protobuf:"varint,39,opt,name=mpls_bos,json=mplsBos,proto3,oneof"`
}

type OfpOxmOfbField_PbbIsid struct {
	PbbIsid uint32 `protobuf:"varint,40,opt,name=pbb_isid,json=pbbIsid,proto3,oneof"`
}

type OfpOxmOfbField_TunnelId struct {
	TunnelId uint64 `protobuf:"varint,41,opt,name=tunnel_id,json=tunnelId,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6Exthdr struct {
	Ipv6Exthdr uint32 `protobuf:"varint,42,opt,name=ipv6_exthdr,json=ipv6Exthdr,proto3,oneof"`
}

func (*OfpOxmOfbField_Port) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_PhysicalPort) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_TableMetadata) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_EthDst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_EthSrc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_EthType) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_VlanVid) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_VlanPcp) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_IpDscp) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_IpEcn) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_IpProto) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv4Src) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv4Dst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_TcpSrc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_TcpDst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_UdpSrc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_UdpDst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_SctpSrc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_SctpDst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Icmpv4Type) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Icmpv4Code) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpOp) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpSpa) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpTpa) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpSha) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpTha) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6Src) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6Dst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6Flabel) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Icmpv6Type) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Icmpv6Code) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6NdTarget) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6NdSsl) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6NdTll) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_MplsLabel) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_MplsTc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_MplsBos) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_PbbIsid) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_TunnelId) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6Exthdr) isOfpOxmOfbField_Value() {}

func (m *OfpOxmOfbField) GetValue() isOfpOxmOfbField_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *OfpOxmOfbField) GetPort() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Port); ok {
		return x.Port
	}
	return 0
}

func (m *OfpOxmOfbField) GetPhysicalPort() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_PhysicalPort); ok {
		return x.PhysicalPort
	}
	return 0
}

func (m *OfpOxmOfbField) GetTableMetadata() uint64 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_TableMetadata); ok {
		return x.TableMetadata
	}
	return 0
}

func (m *OfpOxmOfbField) GetEthDst() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_EthDst); ok {
		return x.EthDst
	}
	return nil
}

func (m *OfpOxmOfbField) GetEthSrc() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_EthSrc); ok {
		return x.EthSrc
	}
	return nil
}

func (m *OfpOxmOfbField) GetEthType() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_EthType); ok {
		return x.EthType
	}
	return 0
}

func (m *OfpOxmOfbField) GetVlanVid() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_VlanVid); ok {
		return x.VlanVid
	}
	return 0
}

func (m *OfpOxmOfbField) GetVlanPcp() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_VlanPcp); ok {
		return x.VlanPcp
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpDscp() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_IpDscp); ok {
		return x.IpDscp
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpEcn() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_IpEcn); ok {
		return x.IpEcn
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpProto() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_IpProto); ok {
		return x.IpProto
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpv4Src() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv4Src); ok {
		return x.Ipv4Src
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpv4Dst() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv4Dst); ok {
		return x.Ipv4Dst
	}
	return 0
}

func (m *OfpOxmOfbField) GetTcpSrc() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_TcpSrc); ok {
		return x.TcpSrc
	}
	return 0
}

func (m *OfpOxmOfbField) GetTcpDst() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_TcpDst); ok {
		return x.TcpDst
	}
	return 0
}

func (m *OfpOxmOfbField) GetUdpSrc() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_UdpSrc); ok {
		return x.UdpSrc
	}
	return 0
}

func (m *OfpOxmOfbField) GetUdpDst() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_UdpDst); ok {
		return x.UdpDst
	}
	return 0
}

func (m *OfpOxmOfbField) GetSctpSrc() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_SctpSrc); ok {
		return x.SctpSrc
	}
	return 0
}

func (m *OfpOxmOfbField) GetSctpDst() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_SctpDst); ok {
		return x.SctpDst
	}
	return 0
}

func (m *OfpOxmOfbField) GetIcmpv4Type() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Icmpv4Type); ok {
		return x.Icmpv4Type
	}
	return 0
}

func (m *OfpOxmOfbField) GetIcmpv4Code() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Icmpv4Code); ok {
		return x.Icmpv4Code
	}
	return 0
}

func (m *OfpOxmOfbField) GetArpOp() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_ArpOp); ok {
		return x.ArpOp
	}
	return 0
}

func (m *OfpOxmOfbField) GetArpSpa() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_ArpSpa); ok {
		return x.ArpSpa
	}
	return 0
}

func (m *OfpOxmOfbField) GetArpTpa() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_ArpTpa); ok {
		return x.ArpTpa
	}
	return 0
}

func (m *OfpOxmOfbField) GetArpSha() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_ArpSha); ok {
		return x.ArpSha
	}
	return nil
}

func (m *OfpOxmOfbField) GetArpTha() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_ArpTha); ok {
		return x.ArpTha
	}
	return nil
}

func (m *OfpOxmOfbField) GetIpv6Src() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv6Src); ok {
		return x.Ipv6Src
	}
	return nil
}

func (m *OfpOxmOfbField) GetIpv6Dst() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv6Dst); ok {
		return x.Ipv6Dst
	}
	return nil
}

func (m *OfpOxmOfbField) GetIpv6Flabel() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv6Flabel); ok {
		return x.Ipv6Flabel
	}
	return 0
}

func (m *OfpOxmOfbField) GetIcmpv6Type() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Icmpv6Type); ok {
		return x.Icmpv6Type
	}
	return 0
}

func (m *OfpOxmOfbField) GetIcmpv6Code() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Icmpv6Code); ok {
		return x.Icmpv6Code
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpv6NdTarget() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv6NdTarget); ok {
		return x.Ipv6NdTarget
	}
	return nil
}

func (m *OfpOxmOfbField) GetIpv6NdSsl() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv6NdSsl); ok {
		return x.Ipv6NdSsl
	}
	return nil
}

func (m *OfpOxmOfbField) GetIpv6NdTll() []byte {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv6NdTll); ok {
		return x.Ipv6NdTll
	}
	return nil
}

func (m *OfpOxmOfbField) GetMplsLabel() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_MplsLabel); ok {
		return x.MplsLabel
	}
	return 0
}

func (m *OfpOxmOfbField) GetMplsTc() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_MplsTc); ok {
		return x.MplsTc
	}
	return 0
}

func (m *OfpOxmOfbField) GetMplsBos() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_MplsBos); ok {
		return x.MplsBos
	}
	return 0
}

func (m *OfpOxmOfbField) GetPbbIsid() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_PbbIsid); ok {
		return x.PbbIsid
	}
	return 0
}

func (m *OfpOxmOfbField) GetTunnelId() uint64 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_TunnelId); ok {
		return x.TunnelId
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpv6Exthdr() uint32 {
	if x, ok := m.GetValue().(*OfpOxmOfbField_Ipv6Exthdr); ok {
		return x.Ipv6Exthdr
	}
	return 0
}

type isOfpOxmOfbField_Mask interface {
	isOfpOxmOfbField_Mask()
}

type OfpOxmOfbField_TableMetadataMask struct {
	TableMetadataMask uint64 `protobuf:"varint,105,opt,name=table_metadata_mask,json=tableMetadataMask,proto3,oneof"`
}

type OfpOxmOfbField_EthDstMask struct {
	EthDstMask []byte `protobuf:"bytes,106,opt,name=eth_dst_mask,json=ethDstMask,proto3,oneof"`
}

type OfpOxmOfbField_EthSrcMask struct {
	EthSrcMask []byte `protobuf:"bytes,107,opt,name=eth_src_mask,json=ethSrcMask,proto3,oneof"`
}

type OfpOxmOfbField_VlanVidMask struct {
	VlanVidMask uint32 `protobuf:"varint,109,opt,name=vlan_vid_mask,json=vlanVidMask,proto3,oneof"`
}

type OfpOxmOfbField_Ipv4SrcMask struct {
	Ipv4SrcMask uint32 `protobuf:"varint,114,opt,name=ipv4_src_mask,json=ipv4SrcMask,proto3,oneof"`
}

type OfpOxmOfbField_Ipv4DstMask struct {
	Ipv4DstMask uint32 `protobuf:"varint,115,opt,name=ipv4_dst_mask,json=ipv4DstMask,proto3,oneof"`
}

type OfpOxmOfbField_ArpSpaMask struct {
	ArpSpaMask uint32 `protobuf:"varint,125,opt,name=arp_spa_mask,json=arpSpaMask,proto3,oneof"`
}

type OfpOxmOfbField_ArpTpaMask struct {
	ArpTpaMask uint32 `protobuf:"varint,126,opt,name=arp_tpa_mask,json=arpTpaMask,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6SrcMask struct {
	Ipv6SrcMask []byte `protobuf:"bytes,129,opt,name=ipv6_src_mask,json=ipv6SrcMask,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6DstMask struct {
	Ipv6DstMask []byte `protobuf:"bytes,130,opt,name=ipv6_dst_mask,json=ipv6DstMask,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6FlabelMask struct {
	Ipv6FlabelMask uint32 `protobuf:"varint,131,opt,name=ipv6_flabel_mask,json=ipv6FlabelMask,proto3,oneof"`
}

type OfpOxmOfbField_PbbIsidMask struct {
	PbbIsidMask uint32 `protobuf:"varint,140,opt,name=pbb_isid_mask,json=pbbIsidMask,proto3,oneof"`
}

type OfpOxmOfbField_TunnelIdMask struct {
	TunnelIdMask uint64 `protobuf:"varint,141,opt,name=tunnel_id_mask,json=tunnelIdMask,proto3,oneof"`
}

type OfpOxmOfbField_Ipv6ExthdrMask struct {
	Ipv6ExthdrMask uint32 `protobuf:"varint,142,opt,name=ipv6_exthdr_mask,json=ipv6ExthdrMask,proto3,oneof"`
}

func (*OfpOxmOfbField_TableMetadataMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_EthDstMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_EthSrcMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_VlanVidMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv4SrcMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv4DstMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_ArpSpaMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_ArpTpaMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv6SrcMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv6DstMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv6FlabelMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_PbbIsidMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_TunnelIdMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv6ExthdrMask) isOfpOxmOfbField_Mask() {}

func (m *OfpOxmOfbField) GetMask() isOfpOxmOfbField_Mask {
	if m != nil {
		return m.Mask
	}
	return nil
}

func (m *OfpOxmOfbField) GetTableMetadataMask() uint64 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_TableMetadataMask); ok {
		return x.TableMetadataMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetEthDstMask() []byte {
	if x, ok := m.GetMask().(*OfpOxmOfbField_EthDstMask); ok {
		return x.EthDstMask
	}
	return nil
}

func (m *OfpOxmOfbField) GetEthSrcMask() []byte {
	if x, ok := m.GetMask().(*OfpOxmOfbField_EthSrcMask); ok {
		return x.EthSrcMask
	}
	return nil
}

func (m *OfpOxmOfbField) GetVlanVidMask() uint32 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_VlanVidMask); ok {
		return x.VlanVidMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpv4SrcMask() uint32 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_Ipv4SrcMask); ok {
		return x.Ipv4SrcMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpv4DstMask() uint32 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_Ipv4DstMask); ok {
		return x.Ipv4DstMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetArpSpaMask() uint32 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_ArpSpaMask); ok {
		return x.ArpSpaMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetArpTpaMask() uint32 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_ArpTpaMask); ok {
		return x.ArpTpaMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpv6SrcMask() []byte {
	if x, ok := m.GetMask().(*OfpOxmOfbField_Ipv6SrcMask); ok {
		return x.Ipv6SrcMask
	}
	return nil
}

func (m *OfpOxmOfbField) GetIpv6DstMask() []byte {
	if x, ok := m.GetMask().(*OfpOxmOfbField_Ipv6DstMask); ok {
		return x.Ipv6DstMask
	}
	return nil
}

func (m *OfpOxmOfbField) GetIpv6FlabelMask() uint32 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_Ipv6FlabelMask); ok {
		return x.Ipv6FlabelMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetPbbIsidMask() uint32 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_PbbIsidMask); ok {
		return x.PbbIsidMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetTunnelIdMask() uint64 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_TunnelIdMask); ok {
		return x.TunnelIdMask
	}
	return 0
}

func (m *OfpOxmOfbField) GetIpv6ExthdrMask() uint32 {
	if x, ok := m.GetMask().(*OfpOxmOfbField_Ipv6ExthdrMask); ok {
		return x.Ipv6ExthdrMask
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OfpOxmOfbField) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OfpOxmOfbField_Port)(nil),
		(*OfpOxmOfbField_PhysicalPort)(nil),
		(*OfpOxmOfbField_TableMetadata)(nil),
		(*OfpOxmOfbField_EthDst)(nil),
		(*OfpOxmOfbField_EthSrc)(nil),
		(*OfpOxmOfbField_EthType)(nil),
		(*OfpOxmOfbField_VlanVid)(nil),
		(*OfpOxmOfbField_VlanPcp)(nil),
		(*OfpOxmOfbField_IpDscp)(nil),
		(*OfpOxmOfbField_IpEcn)(nil),
		(*OfpOxmOfbField_IpProto)(nil),
		(*OfpOxmOfbField_Ipv4Src)(nil),
		(*OfpOxmOfbField_Ipv4Dst)(nil),
		(*OfpOxmOfbField_TcpSrc)(nil),
		(*OfpOxmOfbField_TcpDst)(nil),
		(*OfpOxmOfbField_UdpSrc)(nil),
		(*OfpOxmOfbField_UdpDst)(nil),
		(*OfpOxmOfbField_SctpSrc)(nil),
		(*OfpOxmOfbField_SctpDst)(nil),
		(*OfpOxmOfbField_Icmpv4Type)(nil),
		(*OfpOxmOfbField_Icmpv4Code)(nil),
		(*OfpOxmOfbField_ArpOp)(nil),
		(*OfpOxmOfbField_ArpSpa)(nil),
		(*OfpOxmOfbField_ArpTpa)(nil),
		(*OfpOxmOfbField_ArpSha)(nil),
		(*OfpOxmOfbField_ArpTha)(nil),
		(*OfpOxmOfbField_Ipv6Src)(nil),
		(*OfpOxmOfbField_Ipv6Dst)(nil),
		(*OfpOxmOfbField_Ipv6Flabel)(nil),
		(*OfpOxmOfbField_Icmpv6Type)(nil),
		(*OfpOxmOfbField_Icmpv6Code)(nil),
		(*OfpOxmOfbField_Ipv6NdTarget)(nil),
		(*OfpOxmOfbField_Ipv6NdSsl)(nil),
		(*OfpOxmOfbField_Ipv6NdTll)(nil),
		(*OfpOxmOfbField_MplsLabel)(nil),
		(*OfpOxmOfbField_MplsTc)(nil),
		(*OfpOxmOfbField_MplsBos)(nil),
		(*OfpOxmOfbField_PbbIsid)(nil),
		(*OfpOxmOfbField_TunnelId)(nil),
		(*OfpOxmOfbField_Ipv6Exthdr)(nil),
		(*OfpOxmOfbField_TableMetadataMask)(nil),
		(*OfpOxmOfbField_EthDstMask)(nil),
		(*OfpOxmOfbField_EthSrcMask)(nil),
		(*OfpOxmOfbField_VlanVidMask)(nil),
		(*OfpOxmOfbField_Ipv4SrcMask)(nil),
		(*OfpOxmOfbField_Ipv4DstMask)(nil),
		(*OfpOxmOfbField_ArpSpaMask)(nil),
		(*OfpOxmOfbField_ArpTpaMask)(nil),
		(*OfpOxmOfbField_Ipv6SrcMask)(nil),
		(*OfpOxmOfbField_Ipv6DstMask)(nil),
		(*OfpOxmOfbField_Ipv6FlabelMask)(nil),
		(*OfpOxmOfbField_PbbIsidMask)(nil),
		(*OfpOxmOfbField_TunnelIdMask)(nil),
		(*OfpOxmOfbField_Ipv6ExthdrMask)(nil),
	}
}

// Header for OXM experimenter match fields.
// The experimenter class should not use OXM_HEADER() macros for defining
// fields due to this extra header.
type OfpOxmExperimenterField struct {
	OxmHeader            uint32   `protobuf:"varint,1,opt,name=oxm_header,json=oxmHeader,proto3" json:"oxm_header,omitempty"`
	Experimenter         uint32   `protobuf:"varint,2,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpOxmExperimenterField) Reset()         { *m = OfpOxmExperimenterField{} }
func (m *OfpOxmExperimenterField) String() string { return proto.CompactTextString(m) }
func (*OfpOxmExperimenterField) ProtoMessage()    {}
func (*OfpOxmExperimenterField) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{13}
}

func (m *OfpOxmExperimenterField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpOxmExperimenterField.Unmarshal(m, b)
}
func (m *OfpOxmExperimenterField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpOxmExperimenterField.Marshal(b, m, deterministic)
}
func (m *OfpOxmExperimenterField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpOxmExperimenterField.Merge(m, src)
}
func (m *OfpOxmExperimenterField) XXX_Size() int {
	return xxx_messageInfo_OfpOxmExperimenterField.Size(m)
}
func (m *OfpOxmExperimenterField) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpOxmExperimenterField.DiscardUnknown(m)
}

var xxx_messageInfo_OfpOxmExperimenterField proto.InternalMessageInfo

func (m *OfpOxmExperimenterField) GetOxmHeader() uint32 {
	if m != nil {
		return m.OxmHeader
	}
	return 0
}

func (m *OfpOxmExperimenterField) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

// Action header that is common to all actions.  The length includes the
// header and any padding used to make the action 64-bit aligned.
// NB: The length of an action *must* always be a multiple of eight.
type OfpAction struct {
	Type OfpActionType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpActionType" json:"type,omitempty"`
	// Types that are valid to be assigned to Action:
	//	*OfpAction_Output
	//	*OfpAction_MplsTtl
	//	*OfpAction_Push
	//	*OfpAction_PopMpls
	//	*OfpAction_Group
	//	*OfpAction_NwTtl
	//	*OfpAction_SetField
	//	*OfpAction_Experimenter
	Action               isOfpAction_Action `protobuf_oneof:"action"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *OfpAction) Reset()         { *m = OfpAction{} }
func (m *OfpAction) String() string { return proto.CompactTextString(m) }
func (*OfpAction) ProtoMessage()    {}
func (*OfpAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{14}
}

func (m *OfpAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpAction.Unmarshal(m, b)
}
func (m *OfpAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpAction.Marshal(b, m, deterministic)
}
func (m *OfpAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpAction.Merge(m, src)
}
func (m *OfpAction) XXX_Size() int {
	return xxx_messageInfo_OfpAction.Size(m)
}
func (m *OfpAction) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpAction.DiscardUnknown(m)
}

var xxx_messageInfo_OfpAction proto.InternalMessageInfo

func (m *OfpAction) GetType() OfpActionType {
	if m != nil {
		return m.Type
	}
	return OfpActionType_OFPAT_OUTPUT
}

type isOfpAction_Action interface {
	isOfpAction_Action()
}

type OfpAction_Output struct {
	Output *OfpActionOutput `protobuf:"bytes,2,opt,name=output,proto3,oneof"`
}

type OfpAction_MplsTtl struct {
	MplsTtl *OfpActionMplsTtl `protobuf:"bytes,3,opt,name=mpls_ttl,json=mplsTtl,proto3,oneof"`
}

type OfpAction_Push struct {
	Push *OfpActionPush `protobuf:"bytes,4,opt,name=push,proto3,oneof"`
}

type OfpAction_PopMpls struct {
	PopMpls *OfpActionPopMpls `protobuf:"bytes,5,opt,name=pop_mpls,json=popMpls,proto3,oneof"`
}

type OfpAction_Group struct {
	Group *OfpActionGroup `protobuf:"bytes,6,opt,name=group,proto3,oneof"`
}

type OfpAction_NwTtl struct {
	NwTtl *OfpActionNwTtl `protobuf:"bytes,7,opt,name=nw_ttl,json=nwTtl,proto3,oneof"`
}

type OfpAction_SetField struct {
	SetField *OfpActionSetField `protobuf:"bytes,8,opt,name=set_field,json=setField,proto3,oneof"`
}

type OfpAction_Experimenter struct {
	Experimenter *OfpActionExperimenter `protobuf:"bytes,9,opt,name=experimenter,proto3,oneof"`
}

func (*OfpAction_Output) isOfpAction_Action() {}

func (*OfpAction_MplsTtl) isOfpAction_Action() {}

func (*OfpAction_Push) isOfpAction_Action() {}

func (*OfpAction_PopMpls) isOfpAction_Action() {}

func (*OfpAction_Group) isOfpAction_Action() {}

func (*OfpAction_NwTtl) isOfpAction_Action() {}

func (*OfpAction_SetField) isOfpAction_Action() {}

func (*OfpAction_Experimenter) isOfpAction_Action() {}

func (m *OfpAction) GetAction() isOfpAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *OfpAction) GetOutput() *OfpActionOutput {
	if x, ok := m.GetAction().(*OfpAction_Output); ok {
		return x.Output
	}
	return nil
}

func (m *OfpAction) GetMplsTtl() *OfpActionMplsTtl {
	if x, ok := m.GetAction().(*OfpAction_MplsTtl); ok {
		return x.MplsTtl
	}
	return nil
}

func (m *OfpAction) GetPush() *OfpActionPush {
	if x, ok := m.GetAction().(*OfpAction_Push); ok {
		return x.Push
	}
	return nil
}

func (m *OfpAction) GetPopMpls() *OfpActionPopMpls {
	if x, ok := m.GetAction().(*OfpAction_PopMpls); ok {
		return x.PopMpls
	}
	return nil
}

func (m *OfpAction) GetGroup() *OfpActionGroup {
	if x, ok := m.GetAction().(*OfpAction_Group); ok {
		return x.Group
	}
	return nil
}

func (m *OfpAction) GetNwTtl() *OfpActionNwTtl {
	if x, ok := m.GetAction().(*OfpAction_NwTtl); ok {
		return x.NwTtl
	}
	return nil
}

func (m *OfpAction) GetSetField() *OfpActionSetField {
	if x, ok := m.GetAction().(*OfpAction_SetField); ok {
		return x.SetField
	}
	return nil
}

func (m *OfpAction) GetExperimenter() *OfpActionExperimenter {
	if x, ok := m.GetAction().(*OfpAction_Experimenter); ok {
		return x.Experimenter
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OfpAction) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OfpAction_Output)(nil),
		(*OfpAction_MplsTtl)(nil),
		(*OfpAction_Push)(nil),
		(*OfpAction_PopMpls)(nil),
		(*OfpAction_Group)(nil),
		(*OfpAction_NwTtl)(nil),
		(*OfpAction_SetField)(nil),
		(*OfpAction_Experimenter)(nil),
	}
}

// Action structure for OFPAT_OUTPUT, which sends packets out 'port'.
// When the 'port' is the OFPP_CONTROLLER, 'max_len' indicates the max
// number of bytes to send.  A 'max_len' of zero means no bytes of the
// packet should be sent. A 'max_len' of OFPCML_NO_BUFFER means that
// the packet is not buffered and the complete packet is to be sent to
// the controller.
type OfpActionOutput struct {
	Port                 uint32   `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	MaxLen               uint32   `protobuf:"varint,2,opt,name=max_len,json=maxLen,proto3" json:"max_len,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpActionOutput) Reset()         { *m = OfpActionOutput{} }
func (m *OfpActionOutput) String() string { return proto.CompactTextString(m) }
func (*OfpActionOutput) ProtoMessage()    {}
func (*OfpActionOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{15}
}

func (m *OfpActionOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionOutput.Unmarshal(m, b)
}
func (m *OfpActionOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionOutput.Marshal(b, m, deterministic)
}
func (m *OfpActionOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionOutput.Merge(m, src)
}
func (m *OfpActionOutput) XXX_Size() int {
	return xxx_messageInfo_OfpActionOutput.Size(m)
}
func (m *OfpActionOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionOutput.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionOutput proto.InternalMessageInfo

func (m *OfpActionOutput) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *OfpActionOutput) GetMaxLen() uint32 {
	if m != nil {
		return m.MaxLen
	}
	return 0
}

// Action structure for OFPAT_SET_MPLS_TTL.
type OfpActionMplsTtl struct {
	MplsTtl              uint32   `protobuf:"varint,1,opt,name=mpls_ttl,json=mplsTtl,proto3" json:"mpls_ttl,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpActionMplsTtl) Reset()         { *m = OfpActionMplsTtl{} }
func (m *OfpActionMplsTtl) String() string { return proto.CompactTextString(m) }
func (*OfpActionMplsTtl) ProtoMessage()    {}
func (*OfpActionMplsTtl) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{16}
}

func (m *OfpActionMplsTtl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionMplsTtl.Unmarshal(m, b)
}
func (m *OfpActionMplsTtl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionMplsTtl.Marshal(b, m, deterministic)
}
func (m *OfpActionMplsTtl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionMplsTtl.Merge(m, src)
}
func (m *OfpActionMplsTtl) XXX_Size() int {
	return xxx_messageInfo_OfpActionMplsTtl.Size(m)
}
func (m *OfpActionMplsTtl) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionMplsTtl.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionMplsTtl proto.InternalMessageInfo

func (m *OfpActionMplsTtl) GetMplsTtl() uint32 {
	if m != nil {
		return m.MplsTtl
	}
	return 0
}

// Action structure for OFPAT_PUSH_VLAN/MPLS/PBB.
type OfpActionPush struct {
	Ethertype            uint32   `protobuf:"varint,1,opt,name=ethertype,proto3" json:"ethertype,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpActionPush) Reset()         { *m = OfpActionPush{} }
func (m *OfpActionPush) String() string { return proto.CompactTextString(m) }
func (*OfpActionPush) ProtoMessage()    {}
func (*OfpActionPush) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{17}
}

func (m *OfpActionPush) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionPush.Unmarshal(m, b)
}
func (m *OfpActionPush) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionPush.Marshal(b, m, deterministic)
}
func (m *OfpActionPush) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionPush.Merge(m, src)
}
func (m *OfpActionPush) XXX_Size() int {
	return xxx_messageInfo_OfpActionPush.Size(m)
}
func (m *OfpActionPush) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionPush.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionPush proto.InternalMessageInfo

func (m *OfpActionPush) GetEthertype() uint32 {
	if m != nil {
		return m.Ethertype
	}
	return 0
}

// Action structure for OFPAT_POP_MPLS.
type OfpActionPopMpls struct {
	Ethertype            uint32   `protobuf:"varint,1,opt,name=ethertype,proto3" json:"ethertype,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpActionPopMpls) Reset()         { *m = OfpActionPopMpls{} }
func (m *OfpActionPopMpls) String() string { return proto.CompactTextString(m) }
func (*OfpActionPopMpls) ProtoMessage()    {}
func (*OfpActionPopMpls) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{18}
}

func (m *OfpActionPopMpls) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionPopMpls.Unmarshal(m, b)
}
func (m *OfpActionPopMpls) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionPopMpls.Marshal(b, m, deterministic)
}
func (m *OfpActionPopMpls) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionPopMpls.Merge(m, src)
}
func (m *OfpActionPopMpls) XXX_Size() int {
	return xxx_messageInfo_OfpActionPopMpls.Size(m)
}
func (m *OfpActionPopMpls) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionPopMpls.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionPopMpls proto.InternalMessageInfo

func (m *OfpActionPopMpls) GetEthertype() uint32 {
	if m != nil {
		return m.Ethertype
	}
	return 0
}

// Action structure for OFPAT_GROUP.
type OfpActionGroup struct {
	GroupId              uint32   `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpActionGroup) Reset()         { *m = OfpActionGroup{} }
func (m *OfpActionGroup) String() string { return proto.CompactTextString(m) }
func (*OfpActionGroup) ProtoMessage()    {}
func (*OfpActionGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{19}
}

func (m *OfpActionGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionGroup.Unmarshal(m, b)
}
func (m *OfpActionGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionGroup.Marshal(b, m, deterministic)
}
func (m *OfpActionGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionGroup.Merge(m, src)
}
func (m *OfpActionGroup) XXX_Size() int {
	return xxx_messageInfo_OfpActionGroup.Size(m)
}
func (m *OfpActionGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionGroup.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionGroup proto.InternalMessageInfo

func (m *OfpActionGroup) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

// Action structure for OFPAT_SET_NW_TTL.
type OfpActionNwTtl struct {
	NwTtl                uint32   `protobuf:"varint,1,opt,name=nw_ttl,json=nwTtl,proto3" json:"nw_ttl,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpActionNwTtl) Reset()         { *m = OfpActionNwTtl{} }
func (m *OfpActionNwTtl) String() string { return proto.CompactTextString(m) }
func (*OfpActionNwTtl) ProtoMessage()    {}
func (*OfpActionNwTtl) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{20}
}

func (m *OfpActionNwTtl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionNwTtl.Unmarshal(m, b)
}
func (m *OfpActionNwTtl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionNwTtl.Marshal(b, m, deterministic)
}
func (m *OfpActionNwTtl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionNwTtl.Merge(m, src)
}
func (m *OfpActionNwTtl) XXX_Size() int {
	return xxx_messageInfo_OfpActionNwTtl.Size(m)
}
func (m *OfpActionNwTtl) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionNwTtl.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionNwTtl proto.InternalMessageInfo

func (m *OfpActionNwTtl) GetNwTtl() uint32 {
	if m != nil {
		return m.NwTtl
	}
	return 0
}

// Action structure for OFPAT_SET_FIELD.
type OfpActionSetField struct {
	Field                *OfpOxmField `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OfpActionSetField) Reset()         { *m = OfpActionSetField{} }
func (m *OfpActionSetField) String() string { return proto.CompactTextString(m) }
func (*OfpActionSetField) ProtoMessage()    {}
func (*OfpActionSetField) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{21}
}

func (m *OfpActionSetField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionSetField.Unmarshal(m, b)
}
func (m *OfpActionSetField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionSetField.Marshal(b, m, deterministic)
}
func (m *OfpActionSetField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionSetField.Merge(m, src)
}
func (m *OfpActionSetField) XXX_Size() int {
	return xxx_messageInfo_OfpActionSetField.Size(m)
}
func (m *OfpActionSetField) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionSetField.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionSetField proto.InternalMessageInfo

func (m *OfpActionSetField) GetField() *OfpOxmField {
	if m != nil {
		return m.Field
	}
	return nil
}

// Action header for OFPAT_EXPERIMENTER.
// The rest of the body is experimenter-defined.
type OfpActionExperimenter struct {
	Experimenter         uint32   `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpActionExperimenter) Reset()         { *m = OfpActionExperimenter{} }
func (m *OfpActionExperimenter) String() string { return proto.CompactTextString(m) }
func (*OfpActionExperimenter) ProtoMessage()    {}
func (*OfpActionExperimenter) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{22}
}

func (m *OfpActionExperimenter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionExperimenter.Unmarshal(m, b)
}
func (m *OfpActionExperimenter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionExperimenter.Marshal(b, m, deterministic)
}
func (m *OfpActionExperimenter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionExperimenter.Merge(m, src)
}
func (m *OfpActionExperimenter) XXX_Size() int {
	return xxx_messageInfo_OfpActionExperimenter.Size(m)
}
func (m *OfpActionExperimenter) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionExperimenter.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionExperimenter proto.InternalMessageInfo

func (m *OfpActionExperimenter) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

func (m *OfpActionExperimenter) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Instruction header that is common to all instructions.  The length includes
// the header and any padding used to make the instruction 64-bit aligned.
// NB: The length of an instruction *must* always be a multiple of eight.
type OfpInstruction struct {
	Type uint32 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	// Types that are valid to be assigned to Data:
	//	*OfpInstruction_GotoTable
	//	*OfpInstruction_WriteMetadata
	//	*OfpInstruction_Actions
	//	*OfpInstruction_Meter
	//	*OfpInstruction_Experimenter
	Data                 isOfpInstruction_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OfpInstruction) Reset()         { *m = OfpInstruction{} }
func (m *OfpInstruction) String() string { return proto.CompactTextString(m) }
func (*OfpInstruction) ProtoMessage()    {}
func (*OfpInstruction) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{23}
}

func (m *OfpInstruction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpInstruction.Unmarshal(m, b)
}
func (m *OfpInstruction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpInstruction.Marshal(b, m, deterministic)
}
func (m *OfpInstruction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpInstruction.Merge(m, src)
}
func (m *OfpInstruction) XXX_Size() int {
	return xxx_messageInfo_OfpInstruction.Size(m)
}
func (m *OfpInstruction) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpInstruction.DiscardUnknown(m)
}

var xxx_messageInfo_OfpInstruction proto.InternalMessageInfo

func (m *OfpInstruction) GetType() uint32 {
	if m != nil {
		return m.Type
	}
	return 0
}

type isOfpInstruction_Data interface {
	isOfpInstruction_Data()
}

type OfpInstruction_GotoTable struct {
	GotoTable *OfpInstructionGotoTable `protobuf:"bytes,2,opt,name=goto_table,json=gotoTable,proto3,oneof"`
}

type OfpInstruction_WriteMetadata struct {
	WriteMetadata *OfpInstructionWriteMetadata `protobuf:"bytes,3,opt,name=write_metadata,json=writeMetadata,proto3,oneof"`
}

type OfpInstruction_Actions struct {
	Actions *OfpInstructionActions `protobuf:"bytes,4,opt,name=actions,proto3,oneof"`
}

type OfpInstruction_Meter struct {
	Meter *OfpInstructionMeter `protobuf:"bytes,5,opt,name=meter,proto3,oneof"`
}

type OfpInstruction_Experimenter struct {
	Experimenter *OfpInstructionExperimenter `protobuf:"bytes,6,opt,name=experimenter,proto3,oneof"`
}

func (*OfpInstruction_GotoTable) isOfpInstruction_Data() {}

func (*OfpInstruction_WriteMetadata) isOfpInstruction_Data() {}

func (*OfpInstruction_Actions) isOfpInstruction_Data() {}

func (*OfpInstruction_Meter) isOfpInstruction_Data() {}

func (*OfpInstruction_Experimenter) isOfpInstruction_Data() {}

func (m *OfpInstruction) GetData() isOfpInstruction_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *OfpInstruction) GetGotoTable() *OfpInstructionGotoTable {
	if x, ok := m.GetData().(*OfpInstruction_GotoTable); ok {
		return x.GotoTable
	}
	return nil
}

func (m *OfpInstruction) GetWriteMetadata() *OfpInstructionWriteMetadata {
	if x, ok := m.GetData().(*OfpInstruction_WriteMetadata); ok {
		return x.WriteMetadata
	}
	return nil
}

func (m *OfpInstruction) GetActions() *OfpInstructionActions {
	if x, ok := m.GetData().(*OfpInstruction_Actions); ok {
		return x.Actions
	}
	return nil
}

func (m *OfpInstruction) GetMeter() *OfpInstructionMeter {
	if x, ok := m.GetData().(*OfpInstruction_Meter); ok {
		return x.Meter
	}
	return nil
}

func (m *OfpInstruction) GetExperimenter() *OfpInstructionExperimenter {
	if x, ok := m.GetData().(*OfpInstruction_Experimenter); ok {
		return x.Experimenter
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OfpInstruction) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OfpInstruction_GotoTable)(nil),
		(*OfpInstruction_WriteMetadata)(nil),
		(*OfpInstruction_Actions)(nil),
		(*OfpInstruction_Meter)(nil),
		(*OfpInstruction_Experimenter)(nil),
	}
}

// Instruction structure for OFPIT_GOTO_TABLE
type OfpInstructionGotoTable struct {
	TableId              uint32   `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpInstructionGotoTable) Reset()         { *m = OfpInstructionGotoTable{} }
func (m *OfpInstructionGotoTable) String() string { return proto.CompactTextString(m) }
func (*OfpInstructionGotoTable) ProtoMessage()    {}
func (*OfpInstructionGotoTable) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{24}
}

func (m *OfpInstructionGotoTable) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpInstructionGotoTable.Unmarshal(m, b)
}
func (m *OfpInstructionGotoTable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpInstructionGotoTable.Marshal(b, m, deterministic)
}
func (m *OfpInstructionGotoTable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpInstructionGotoTable.Merge(m, src)
}
func (m *OfpInstructionGotoTable) XXX_Size() int {
	return xxx_messageInfo_OfpInstructionGotoTable.Size(m)
}
func (m *OfpInstructionGotoTable) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpInstructionGotoTable.DiscardUnknown(m)
}

var xxx_messageInfo_OfpInstructionGotoTable proto.InternalMessageInfo

func (m *OfpInstructionGotoTable) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

// Instruction structure for OFPIT_WRITE_METADATA
type OfpInstructionWriteMetadata struct {
	Metadata             uint64   `protobuf:"varint,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	MetadataMask         uint64   `protobuf:"varint,2,opt,name=metadata_mask,json=metadataMask,proto3" json:"metadata_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpInstructionWriteMetadata) Reset()         { *m = OfpInstructionWriteMetadata{} }
func (m *OfpInstructionWriteMetadata) String() string { return proto.CompactTextString(m) }
func (*OfpInstructionWriteMetadata) ProtoMessage()    {}
func (*OfpInstructionWriteMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{25}
}

func (m *OfpInstructionWriteMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpInstructionWriteMetadata.Unmarshal(m, b)
}
func (m *OfpInstructionWriteMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpInstructionWriteMetadata.Marshal(b, m, deterministic)
}
func (m *OfpInstructionWriteMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpInstructionWriteMetadata.Merge(m, src)
}
func (m *OfpInstructionWriteMetadata) XXX_Size() int {
	return xxx_messageInfo_OfpInstructionWriteMetadata.Size(m)
}
func (m *OfpInstructionWriteMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpInstructionWriteMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OfpInstructionWriteMetadata proto.InternalMessageInfo

func (m *OfpInstructionWriteMetadata) GetMetadata() uint64 {
	if m != nil {
		return m.Metadata
	}
	return 0
}

func (m *OfpInstructionWriteMetadata) GetMetadataMask() uint64 {
	if m != nil {
		return m.MetadataMask
	}
	return 0
}

// Instruction structure for OFPIT_WRITE/APPLY/CLEAR_ACTIONS
type OfpInstructionActions struct {
	Actions              []*OfpAction `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OfpInstructionActions) Reset()         { *m = OfpInstructionActions{} }
func (m *OfpInstructionActions) String() string { return proto.CompactTextString(m) }
func (*OfpInstructionActions) ProtoMessage()    {}
func (*OfpInstructionActions) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{26}
}

func (m *OfpInstructionActions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpInstructionActions.Unmarshal(m, b)
}
func (m *OfpInstructionActions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpInstructionActions.Marshal(b, m, deterministic)
}
func (m *OfpInstructionActions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpInstructionActions.Merge(m, src)
}
func (m *OfpInstructionActions) XXX_Size() int {
	return xxx_messageInfo_OfpInstructionActions.Size(m)
}
func (m *OfpInstructionActions) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpInstructionActions.DiscardUnknown(m)
}

var xxx_messageInfo_OfpInstructionActions proto.InternalMessageInfo

func (m *OfpInstructionActions) GetActions() []*OfpAction {
	if m != nil {
		return m.Actions
	}
	return nil
}

// Instruction structure for OFPIT_METER
type OfpInstructionMeter struct {
	MeterId              uint32   `protobuf:"varint,1,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpInstructionMeter) Reset()         { *m = OfpInstructionMeter{} }
func (m *OfpInstructionMeter) String() string { return proto.CompactTextString(m) }
func (*OfpInstructionMeter) ProtoMessage()    {}
func (*OfpInstructionMeter) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{27}
}

func (m *OfpInstructionMeter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpInstructionMeter.Unmarshal(m, b)
}
func (m *OfpInstructionMeter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpInstructionMeter.Marshal(b, m, deterministic)
}
func (m *OfpInstructionMeter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpInstructionMeter.Merge(m, src)
}
func (m *OfpInstructionMeter) XXX_Size() int {
	return xxx_messageInfo_OfpInstructionMeter.Size(m)
}
func (m *OfpInstructionMeter) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpInstructionMeter.DiscardUnknown(m)
}

var xxx_messageInfo_OfpInstructionMeter proto.InternalMessageInfo

func (m *OfpInstructionMeter) GetMeterId() uint32 {
	if m != nil {
		return m.MeterId
	}
	return 0
}

// Instruction structure for experimental instructions
type OfpInstructionExperimenter struct {
	Experimenter uint32 `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	// Experimenter-defined arbitrary additional data.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpInstructionExperimenter) Reset()         { *m = OfpInstructionExperimenter{} }
func (m *OfpInstructionExperimenter) String() string { return proto.CompactTextString(m) }
func (*OfpInstructionExperimenter) ProtoMessage()    {}
func (*OfpInstructionExperimenter) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{28}
}

func (m *OfpInstructionExperimenter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpInstructionExperimenter.Unmarshal(m, b)
}
func (m *OfpInstructionExperimenter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpInstructionExperimenter.Marshal(b, m, deterministic)
}
func (m *OfpInstructionExperimenter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpInstructionExperimenter.Merge(m, src)
}
func (m *OfpInstructionExperimenter) XXX_Size() int {
	return xxx_messageInfo_OfpInstructionExperimenter.Size(m)
}
func (m *OfpInstructionExperimenter) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpInstructionExperimenter.DiscardUnknown(m)
}

var xxx_messageInfo_OfpInstructionExperimenter proto.InternalMessageInfo

func (m *OfpInstructionExperimenter) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

func (m *OfpInstructionExperimenter) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Flow setup and teardown (controller -> datapath).
type OfpFlowMod struct {
	//ofp_header header;
	Cookie               uint64            `protobuf:"varint,1,opt,name=cookie,proto3" json:"cookie,omitempty"`
	CookieMask           uint64            `protobuf:"varint,2,opt,name=cookie_mask,json=cookieMask,proto3" json:"cookie_mask,omitempty"`
	TableId              uint32            `protobuf:"varint,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	Command              OfpFlowModCommand `protobuf:"varint,4,opt,name=command,proto3,enum=openflow_13.OfpFlowModCommand" json:"command,omitempty"`
	IdleTimeout          uint32            `protobuf:"varint,5,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	HardTimeout          uint32            `protobuf:"varint,6,opt,name=hard_timeout,json=hardTimeout,proto3" json:"hard_timeout,omitempty"`
	Priority             uint32            `protobuf:"varint,7,opt,name=priority,proto3" json:"priority,omitempty"`
	BufferId             uint32            `protobuf:"varint,8,opt,name=buffer_id,json=bufferId,proto3" json:"buffer_id,omitempty"`
	OutPort              uint32            `protobuf:"varint,9,opt,name=out_port,json=outPort,proto3" json:"out_port,omitempty"`
	OutGroup             uint32            `protobuf:"varint,10,opt,name=out_group,json=outGroup,proto3" json:"out_group,omitempty"`
	Flags                uint32            `protobuf:"varint,11,opt,name=flags,proto3" json:"flags,omitempty"`
	Match                *OfpMatch         `protobuf:"bytes,12,opt,name=match,proto3" json:"match,omitempty"`
	Instructions         []*OfpInstruction `protobuf:"bytes,13,rep,name=instructions,proto3" json:"instructions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *OfpFlowMod) Reset()         { *m = OfpFlowMod{} }
func (m *OfpFlowMod) String() string { return proto.CompactTextString(m) }
func (*OfpFlowMod) ProtoMessage()    {}
func (*OfpFlowMod) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{29}
}

func (m *OfpFlowMod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpFlowMod.Unmarshal(m, b)
}
func (m *OfpFlowMod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpFlowMod.Marshal(b, m, deterministic)
}
func (m *OfpFlowMod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpFlowMod.Merge(m, src)
}
func (m *OfpFlowMod) XXX_Size() int {
	return xxx_messageInfo_OfpFlowMod.Size(m)
}
func (m *OfpFlowMod) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpFlowMod.DiscardUnknown(m)
}

var xxx_messageInfo_OfpFlowMod proto.InternalMessageInfo

func (m *OfpFlowMod) GetCookie() uint64 {
	if m != nil {
		return m.Cookie
	}
	return 0
}

func (m *OfpFlowMod) GetCookieMask() uint64 {
	if m != nil {
		return m.CookieMask
	}
	return 0
}

func (m *OfpFlowMod) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpFlowMod) GetCommand() OfpFlowModCommand {
	if m != nil {
		return m.Command
	}
	return OfpFlowModCommand_OFPFC_ADD
}

func (m *OfpFlowMod) GetIdleTimeout() uint32 {
	if m != nil {
		return m.IdleTimeout
	}
	return 0
}

func (m *OfpFlowMod) GetHardTimeout() uint32 {
	if m != nil {
		return m.HardTimeout
	}
	return 0
}

func (m *OfpFlowMod) GetPriority() uint32 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *OfpFlowMod) GetBufferId() uint32 {
	if m != nil {
		return m.BufferId
	}
	return 0
}

func (m *OfpFlowMod) GetOutPort() uint32 {
	if m != nil {
		return m.OutPort
	}
	return 0
}

func (m *OfpFlowMod) GetOutGroup() uint32 {
	if m != nil {
		return m.OutGroup
	}
	return 0
}

func (m *OfpFlowMod) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *OfpFlowMod) GetMatch() *OfpMatch {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *OfpFlowMod) GetInstructions() []*OfpInstruction {
	if m != nil {
		return m.Instructions
	}
	return nil
}

// Bucket for use in groups.
type OfpBucket struct {
	Weight               uint32       `protobuf:"varint,1,opt,name=weight,proto3" json:"weight,omitempty"`
	WatchPort            uint32       `protobuf:"varint,2,opt,name=watch_port,json=watchPort,proto3" json:"watch_port,omitempty"`
	WatchGroup           uint32       `protobuf:"varint,3,opt,name=watch_group,json=watchGroup,proto3" json:"watch_group,omitempty"`
	Actions              []*OfpAction `protobuf:"bytes,4,rep,name=actions,proto3" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OfpBucket) Reset()         { *m = OfpBucket{} }
func (m *OfpBucket) String() string { return proto.CompactTextString(m) }
func (*OfpBucket) ProtoMessage()    {}
func (*OfpBucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{30}
}

func (m *OfpBucket) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpBucket.Unmarshal(m, b)
}
func (m *OfpBucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpBucket.Marshal(b, m, deterministic)
}
func (m *OfpBucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpBucket.Merge(m, src)
}
func (m *OfpBucket) XXX_Size() int {
	return xxx_messageInfo_OfpBucket.Size(m)
}
func (m *OfpBucket) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpBucket.DiscardUnknown(m)
}

var xxx_messageInfo_OfpBucket proto.InternalMessageInfo

func (m *OfpBucket) GetWeight() uint32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *OfpBucket) GetWatchPort() uint32 {
	if m != nil {
		return m.WatchPort
	}
	return 0
}

func (m *OfpBucket) GetWatchGroup() uint32 {
	if m != nil {
		return m.WatchGroup
	}
	return 0
}

func (m *OfpBucket) GetActions() []*OfpAction {
	if m != nil {
		return m.Actions
	}
	return nil
}

// Group setup and teardown (controller -> datapath).
type OfpGroupMod struct {
	//ofp_header header;
	Command              OfpGroupModCommand `protobuf:"varint,1,opt,name=command,proto3,enum=openflow_13.OfpGroupModCommand" json:"command,omitempty"`
	Type                 OfpGroupType       `protobuf:"varint,2,opt,name=type,proto3,enum=openflow_13.OfpGroupType" json:"type,omitempty"`
	GroupId              uint32             `protobuf:"varint,3,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Buckets              []*OfpBucket       `protobuf:"bytes,4,rep,name=buckets,proto3" json:"buckets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *OfpGroupMod) Reset()         { *m = OfpGroupMod{} }
func (m *OfpGroupMod) String() string { return proto.CompactTextString(m) }
func (*OfpGroupMod) ProtoMessage()    {}
func (*OfpGroupMod) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{31}
}

func (m *OfpGroupMod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpGroupMod.Unmarshal(m, b)
}
func (m *OfpGroupMod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpGroupMod.Marshal(b, m, deterministic)
}
func (m *OfpGroupMod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpGroupMod.Merge(m, src)
}
func (m *OfpGroupMod) XXX_Size() int {
	return xxx_messageInfo_OfpGroupMod.Size(m)
}
func (m *OfpGroupMod) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpGroupMod.DiscardUnknown(m)
}

var xxx_messageInfo_OfpGroupMod proto.InternalMessageInfo

func (m *OfpGroupMod) GetCommand() OfpGroupModCommand {
	if m != nil {
		return m.Command
	}
	return OfpGroupModCommand_OFPGC_ADD
}

func (m *OfpGroupMod) GetType() OfpGroupType {
	if m != nil {
		return m.Type
	}
	return OfpGroupType_OFPGT_ALL
}

func (m *OfpGroupMod) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *OfpGroupMod) GetBuckets() []*OfpBucket {
	if m != nil {
		return m.Buckets
	}
	return nil
}

// Send packet (controller -> datapath).
type OfpPacketOut struct {
	//ofp_header header;
	BufferId uint32       `protobuf:"varint,1,opt,name=buffer_id,json=bufferId,proto3" json:"buffer_id,omitempty"`
	InPort   uint32       `protobuf:"varint,2,opt,name=in_port,json=inPort,proto3" json:"in_port,omitempty"`
	Actions  []*OfpAction `protobuf:"bytes,3,rep,name=actions,proto3" json:"actions,omitempty"`
	// The variable size action list is optionally followed by packet data.
	// This data is only present and meaningful if buffer_id == -1.
	Data                 []byte   `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpPacketOut) Reset()         { *m = OfpPacketOut{} }
func (m *OfpPacketOut) String() string { return proto.CompactTextString(m) }
func (*OfpPacketOut) ProtoMessage()    {}
func (*OfpPacketOut) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{32}
}

func (m *OfpPacketOut) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpPacketOut.Unmarshal(m, b)
}
func (m *OfpPacketOut) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpPacketOut.Marshal(b, m, deterministic)
}
func (m *OfpPacketOut) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpPacketOut.Merge(m, src)
}
func (m *OfpPacketOut) XXX_Size() int {
	return xxx_messageInfo_OfpPacketOut.Size(m)
}
func (m *OfpPacketOut) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpPacketOut.DiscardUnknown(m)
}

var xxx_messageInfo_OfpPacketOut proto.InternalMessageInfo

func (m *OfpPacketOut) GetBufferId() uint32 {
	if m != nil {
		return m.BufferId
	}
	return 0
}

func (m *OfpPacketOut) GetInPort() uint32 {
	if m != nil {
		return m.InPort
	}
	return 0
}

func (m *OfpPacketOut) GetActions() []*OfpAction {
	if m != nil {
		return m.Actions
	}
	return nil
}

func (m *OfpPacketOut) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Packet received on port (datapath -> controller).
type OfpPacketIn struct {
	//ofp_header header;
	BufferId             uint32            `protobuf:"varint,1,opt,name=buffer_id,json=bufferId,proto3" json:"buffer_id,omitempty"`
	Reason               OfpPacketInReason `protobuf:"varint,2,opt,name=reason,proto3,enum=openflow_13.OfpPacketInReason" json:"reason,omitempty"`
	TableId              uint32            `protobuf:"varint,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	Cookie               uint64            `protobuf:"varint,4,opt,name=cookie,proto3" json:"cookie,omitempty"`
	Match                *OfpMatch         `protobuf:"bytes,5,opt,name=match,proto3" json:"match,omitempty"`
	Data                 []byte            `protobuf:"bytes,6,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *OfpPacketIn) Reset()         { *m = OfpPacketIn{} }
func (m *OfpPacketIn) String() string { return proto.CompactTextString(m) }
func (*OfpPacketIn) ProtoMessage()    {}
func (*OfpPacketIn) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{33}
}

func (m *OfpPacketIn) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpPacketIn.Unmarshal(m, b)
}
func (m *OfpPacketIn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpPacketIn.Marshal(b, m, deterministic)
}
func (m *OfpPacketIn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpPacketIn.Merge(m, src)
}
func (m *OfpPacketIn) XXX_Size() int {
	return xxx_messageInfo_OfpPacketIn.Size(m)
}
func (m *OfpPacketIn) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpPacketIn.DiscardUnknown(m)
}

var xxx_messageInfo_OfpPacketIn proto.InternalMessageInfo

func (m *OfpPacketIn) GetBufferId() uint32 {
	if m != nil {
		return m.BufferId
	}
	return 0
}

func (m *OfpPacketIn) GetReason() OfpPacketInReason {
	if m != nil {
		return m.Reason
	}
	return OfpPacketInReason_OFPR_NO_MATCH
}

func (m *OfpPacketIn) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpPacketIn) GetCookie() uint64 {
	if m != nil {
		return m.Cookie
	}
	return 0
}

func (m *OfpPacketIn) GetMatch() *OfpMatch {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *OfpPacketIn) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Flow removed (datapath -> controller).
type OfpFlowRemoved struct {
	//ofp_header header;
	Cookie               uint64               `protobuf:"varint,1,opt,name=cookie,proto3" json:"cookie,omitempty"`
	Priority             uint32               `protobuf:"varint,2,opt,name=priority,proto3" json:"priority,omitempty"`
	Reason               OfpFlowRemovedReason `protobuf:"varint,3,opt,name=reason,proto3,enum=openflow_13.OfpFlowRemovedReason" json:"reason,omitempty"`
	TableId              uint32               `protobuf:"varint,4,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	DurationSec          uint32               `protobuf:"varint,5,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"`
	DurationNsec         uint32               `protobuf:"varint,6,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	IdleTimeout          uint32               `protobuf:"varint,7,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	HardTimeout          uint32               `protobuf:"varint,8,opt,name=hard_timeout,json=hardTimeout,proto3" json:"hard_timeout,omitempty"`
	PacketCount          uint64               `protobuf:"varint,9,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"`
	ByteCount            uint64               `protobuf:"varint,10,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`
	Match                *OfpMatch            `protobuf:"bytes,121,opt,name=match,proto3" json:"match,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OfpFlowRemoved) Reset()         { *m = OfpFlowRemoved{} }
func (m *OfpFlowRemoved) String() string { return proto.CompactTextString(m) }
func (*OfpFlowRemoved) ProtoMessage()    {}
func (*OfpFlowRemoved) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{34}
}

func (m *OfpFlowRemoved) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpFlowRemoved.Unmarshal(m, b)
}
func (m *OfpFlowRemoved) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpFlowRemoved.Marshal(b, m, deterministic)
}
func (m *OfpFlowRemoved) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpFlowRemoved.Merge(m, src)
}
func (m *OfpFlowRemoved) XXX_Size() int {
	return xxx_messageInfo_OfpFlowRemoved.Size(m)
}
func (m *OfpFlowRemoved) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpFlowRemoved.DiscardUnknown(m)
}

var xxx_messageInfo_OfpFlowRemoved proto.InternalMessageInfo

func (m *OfpFlowRemoved) GetCookie() uint64 {
	if m != nil {
		return m.Cookie
	}
	return 0
}

func (m *OfpFlowRemoved) GetPriority() uint32 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *OfpFlowRemoved) GetReason() OfpFlowRemovedReason {
	if m != nil {
		return m.Reason
	}
	return OfpFlowRemovedReason_OFPRR_IDLE_TIMEOUT
}

func (m *OfpFlowRemoved) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpFlowRemoved) GetDurationSec() uint32 {
	if m != nil {
		return m.DurationSec
	}
	return 0
}

func (m *OfpFlowRemoved) GetDurationNsec() uint32 {
	if m != nil {
		return m.DurationNsec
	}
	return 0
}

func (m *OfpFlowRemoved) GetIdleTimeout() uint32 {
	if m != nil {
		return m.IdleTimeout
	}
	return 0
}

func (m *OfpFlowRemoved) GetHardTimeout() uint32 {
	if m != nil {
		return m.HardTimeout
	}
	return 0
}

func (m *OfpFlowRemoved) GetPacketCount() uint64 {
	if m != nil {
		return m.PacketCount
	}
	return 0
}

func (m *OfpFlowRemoved) GetByteCount() uint64 {
	if m != nil {
		return m.ByteCount
	}
	return 0
}

func (m *OfpFlowRemoved) GetMatch() *OfpMatch {
	if m != nil {
		return m.Match
	}
	return nil
}

// Common header for all meter bands
type OfpMeterBandHeader struct {
	Type      OfpMeterBandType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpMeterBandType" json:"type,omitempty"`
	Rate      uint32           `protobuf:"varint,2,opt,name=rate,proto3" json:"rate,omitempty"`
	BurstSize uint32           `protobuf:"varint,3,opt,name=burst_size,json=burstSize,proto3" json:"burst_size,omitempty"`
	// Types that are valid to be assigned to Data:
	//	*OfpMeterBandHeader_Drop
	//	*OfpMeterBandHeader_DscpRemark
	//	*OfpMeterBandHeader_Experimenter
	Data                 isOfpMeterBandHeader_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *OfpMeterBandHeader) Reset()         { *m = OfpMeterBandHeader{} }
func (m *OfpMeterBandHeader) String() string { return proto.CompactTextString(m) }
func (*OfpMeterBandHeader) ProtoMessage()    {}
func (*OfpMeterBandHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{35}
}

func (m *OfpMeterBandHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterBandHeader.Unmarshal(m, b)
}
func (m *OfpMeterBandHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterBandHeader.Marshal(b, m, deterministic)
}
func (m *OfpMeterBandHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterBandHeader.Merge(m, src)
}
func (m *OfpMeterBandHeader) XXX_Size() int {
	return xxx_messageInfo_OfpMeterBandHeader.Size(m)
}
func (m *OfpMeterBandHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterBandHeader.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterBandHeader proto.InternalMessageInfo

func (m *OfpMeterBandHeader) GetType() OfpMeterBandType {
	if m != nil {
		return m.Type
	}
	return OfpMeterBandType_OFPMBT_INVALID
}

func (m *OfpMeterBandHeader) GetRate() uint32 {
	if m != nil {
		return m.Rate
	}
	return 0
}

func (m *OfpMeterBandHeader) GetBurstSize() uint32 {
	if m != nil {
		return m.BurstSize
	}
	return 0
}

type isOfpMeterBandHeader_Data interface {
	isOfpMeterBandHeader_Data()
}

type OfpMeterBandHeader_Drop struct {
	Drop *OfpMeterBandDrop `protobuf:"bytes,4,opt,name=drop,proto3,oneof"`
}

type OfpMeterBandHeader_DscpRemark struct {
	DscpRemark *OfpMeterBandDscpRemark `protobuf:"bytes,5,opt,name=dscp_remark,json=dscpRemark,proto3,oneof"`
}

type OfpMeterBandHeader_Experimenter struct {
	Experimenter *OfpMeterBandExperimenter `protobuf:"bytes,6,opt,name=experimenter,proto3,oneof"`
}

func (*OfpMeterBandHeader_Drop) isOfpMeterBandHeader_Data() {}

func (*OfpMeterBandHeader_DscpRemark) isOfpMeterBandHeader_Data() {}

func (*OfpMeterBandHeader_Experimenter) isOfpMeterBandHeader_Data() {}

func (m *OfpMeterBandHeader) GetData() isOfpMeterBandHeader_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *OfpMeterBandHeader) GetDrop() *OfpMeterBandDrop {
	if x, ok := m.GetData().(*OfpMeterBandHeader_Drop); ok {
		return x.Drop
	}
	return nil
}

func (m *OfpMeterBandHeader) GetDscpRemark() *OfpMeterBandDscpRemark {
	if x, ok := m.GetData().(*OfpMeterBandHeader_DscpRemark); ok {
		return x.DscpRemark
	}
	return nil
}

func (m *OfpMeterBandHeader) GetExperimenter() *OfpMeterBandExperimenter {
	if x, ok := m.GetData().(*OfpMeterBandHeader_Experimenter); ok {
		return x.Experimenter
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OfpMeterBandHeader) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OfpMeterBandHeader_Drop)(nil),
		(*OfpMeterBandHeader_DscpRemark)(nil),
		(*OfpMeterBandHeader_Experimenter)(nil),
	}
}

// OFPMBT_DROP band - drop packets
type OfpMeterBandDrop struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpMeterBandDrop) Reset()         { *m = OfpMeterBandDrop{} }
func (m *OfpMeterBandDrop) String() string { return proto.CompactTextString(m) }
func (*OfpMeterBandDrop) ProtoMessage()    {}
func (*OfpMeterBandDrop) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{36}
}

func (m *OfpMeterBandDrop) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterBandDrop.Unmarshal(m, b)
}
func (m *OfpMeterBandDrop) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterBandDrop.Marshal(b, m, deterministic)
}
func (m *OfpMeterBandDrop) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterBandDrop.Merge(m, src)
}
func (m *OfpMeterBandDrop) XXX_Size() int {
	return xxx_messageInfo_OfpMeterBandDrop.Size(m)
}
func (m *OfpMeterBandDrop) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterBandDrop.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterBandDrop proto.InternalMessageInfo

// OFPMBT_DSCP_REMARK band - Remark DSCP in the IP header
type OfpMeterBandDscpRemark struct {
	PrecLevel            uint32   `protobuf:"varint,1,opt,name=prec_level,json=precLevel,proto3" json:"prec_level,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpMeterBandDscpRemark) Reset()         { *m = OfpMeterBandDscpRemark{} }
func (m *OfpMeterBandDscpRemark) String() string { return proto.CompactTextString(m) }
func (*OfpMeterBandDscpRemark) ProtoMessage()    {}
func (*OfpMeterBandDscpRemark) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{37}
}

func (m *OfpMeterBandDscpRemark) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterBandDscpRemark.Unmarshal(m, b)
}
func (m *OfpMeterBandDscpRemark) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterBandDscpRemark.Marshal(b, m, deterministic)
}
func (m *OfpMeterBandDscpRemark) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterBandDscpRemark.Merge(m, src)
}
func (m *OfpMeterBandDscpRemark) XXX_Size() int {
	return xxx_messageInfo_OfpMeterBandDscpRemark.Size(m)
}
func (m *OfpMeterBandDscpRemark) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterBandDscpRemark.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterBandDscpRemark proto.InternalMessageInfo

func (m *OfpMeterBandDscpRemark) GetPrecLevel() uint32 {
	if m != nil {
		return m.PrecLevel
	}
	return 0
}

// OFPMBT_EXPERIMENTER band - Experimenter type.
// The rest of the band is experimenter-defined.
type OfpMeterBandExperimenter struct {
	Experimenter         uint32   `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpMeterBandExperimenter) Reset()         { *m = OfpMeterBandExperimenter{} }
func (m *OfpMeterBandExperimenter) String() string { return proto.CompactTextString(m) }
func (*OfpMeterBandExperimenter) ProtoMessage()    {}
func (*OfpMeterBandExperimenter) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{38}
}

func (m *OfpMeterBandExperimenter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterBandExperimenter.Unmarshal(m, b)
}
func (m *OfpMeterBandExperimenter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterBandExperimenter.Marshal(b, m, deterministic)
}
func (m *OfpMeterBandExperimenter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterBandExperimenter.Merge(m, src)
}
func (m *OfpMeterBandExperimenter) XXX_Size() int {
	return xxx_messageInfo_OfpMeterBandExperimenter.Size(m)
}
func (m *OfpMeterBandExperimenter) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterBandExperimenter.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterBandExperimenter proto.InternalMessageInfo

func (m *OfpMeterBandExperimenter) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

// Meter configuration. OFPT_METER_MOD.
type OfpMeterMod struct {
	Command              OfpMeterModCommand    `protobuf:"varint,1,opt,name=command,proto3,enum=openflow_13.OfpMeterModCommand" json:"command,omitempty"`
	Flags                uint32                `protobuf:"varint,2,opt,name=flags,proto3" json:"flags,omitempty"`
	MeterId              uint32                `protobuf:"varint,3,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"`
	Bands                []*OfpMeterBandHeader `protobuf:"bytes,4,rep,name=bands,proto3" json:"bands,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OfpMeterMod) Reset()         { *m = OfpMeterMod{} }
func (m *OfpMeterMod) String() string { return proto.CompactTextString(m) }
func (*OfpMeterMod) ProtoMessage()    {}
func (*OfpMeterMod) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{39}
}

func (m *OfpMeterMod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterMod.Unmarshal(m, b)
}
func (m *OfpMeterMod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterMod.Marshal(b, m, deterministic)
}
func (m *OfpMeterMod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterMod.Merge(m, src)
}
func (m *OfpMeterMod) XXX_Size() int {
	return xxx_messageInfo_OfpMeterMod.Size(m)
}
func (m *OfpMeterMod) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterMod.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterMod proto.InternalMessageInfo

func (m *OfpMeterMod) GetCommand() OfpMeterModCommand {
	if m != nil {
		return m.Command
	}
	return OfpMeterModCommand_OFPMC_ADD
}

func (m *OfpMeterMod) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *OfpMeterMod) GetMeterId() uint32 {
	if m != nil {
		return m.MeterId
	}
	return 0
}

func (m *OfpMeterMod) GetBands() []*OfpMeterBandHeader {
	if m != nil {
		return m.Bands
	}
	return nil
}

// OFPT_ERROR: Error message (datapath -> controller).
type OfpErrorMsg struct {
	Header               *OfpHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Type                 uint32     `protobuf:"varint,2,opt,name=type,proto3" json:"type,omitempty"`
	Code                 uint32     `protobuf:"varint,3,opt,name=code,proto3" json:"code,omitempty"`
	Data                 []byte     `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *OfpErrorMsg) Reset()         { *m = OfpErrorMsg{} }
func (m *OfpErrorMsg) String() string { return proto.CompactTextString(m) }
func (*OfpErrorMsg) ProtoMessage()    {}
func (*OfpErrorMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{40}
}

func (m *OfpErrorMsg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpErrorMsg.Unmarshal(m, b)
}
func (m *OfpErrorMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpErrorMsg.Marshal(b, m, deterministic)
}
func (m *OfpErrorMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpErrorMsg.Merge(m, src)
}
func (m *OfpErrorMsg) XXX_Size() int {
	return xxx_messageInfo_OfpErrorMsg.Size(m)
}
func (m *OfpErrorMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpErrorMsg.DiscardUnknown(m)
}

var xxx_messageInfo_OfpErrorMsg proto.InternalMessageInfo

func (m *OfpErrorMsg) GetHeader() *OfpHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *OfpErrorMsg) GetType() uint32 {
	if m != nil {
		return m.Type
	}
	return 0
}

func (m *OfpErrorMsg) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *OfpErrorMsg) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// OFPET_EXPERIMENTER: Error message (datapath -> controller).
type OfpErrorExperimenterMsg struct {
	Type                 uint32   `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	ExpType              uint32   `protobuf:"varint,2,opt,name=exp_type,json=expType,proto3" json:"exp_type,omitempty"`
	Experimenter         uint32   `protobuf:"varint,3,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	Data                 []byte   `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpErrorExperimenterMsg) Reset()         { *m = OfpErrorExperimenterMsg{} }
func (m *OfpErrorExperimenterMsg) String() string { return proto.CompactTextString(m) }
func (*OfpErrorExperimenterMsg) ProtoMessage()    {}
func (*OfpErrorExperimenterMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{41}
}

func (m *OfpErrorExperimenterMsg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpErrorExperimenterMsg.Unmarshal(m, b)
}
func (m *OfpErrorExperimenterMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpErrorExperimenterMsg.Marshal(b, m, deterministic)
}
func (m *OfpErrorExperimenterMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpErrorExperimenterMsg.Merge(m, src)
}
func (m *OfpErrorExperimenterMsg) XXX_Size() int {
	return xxx_messageInfo_OfpErrorExperimenterMsg.Size(m)
}
func (m *OfpErrorExperimenterMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpErrorExperimenterMsg.DiscardUnknown(m)
}

var xxx_messageInfo_OfpErrorExperimenterMsg proto.InternalMessageInfo

func (m *OfpErrorExperimenterMsg) GetType() uint32 {
	if m != nil {
		return m.Type
	}
	return 0
}

func (m *OfpErrorExperimenterMsg) GetExpType() uint32 {
	if m != nil {
		return m.ExpType
	}
	return 0
}

func (m *OfpErrorExperimenterMsg) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

func (m *OfpErrorExperimenterMsg) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type OfpMultipartRequest struct {
	//ofp_header header;
	Type                 OfpMultipartType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpMultipartType" json:"type,omitempty"`
	Flags                uint32           `protobuf:"varint,2,opt,name=flags,proto3" json:"flags,omitempty"`
	Body                 []byte           `protobuf:"bytes,3,opt,name=body,proto3" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *OfpMultipartRequest) Reset()         { *m = OfpMultipartRequest{} }
func (m *OfpMultipartRequest) String() string { return proto.CompactTextString(m) }
func (*OfpMultipartRequest) ProtoMessage()    {}
func (*OfpMultipartRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{42}
}

func (m *OfpMultipartRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMultipartRequest.Unmarshal(m, b)
}
func (m *OfpMultipartRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMultipartRequest.Marshal(b, m, deterministic)
}
func (m *OfpMultipartRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMultipartRequest.Merge(m, src)
}
func (m *OfpMultipartRequest) XXX_Size() int {
	return xxx_messageInfo_OfpMultipartRequest.Size(m)
}
func (m *OfpMultipartRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMultipartRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMultipartRequest proto.InternalMessageInfo

func (m *OfpMultipartRequest) GetType() OfpMultipartType {
	if m != nil {
		return m.Type
	}
	return OfpMultipartType_OFPMP_DESC
}

func (m *OfpMultipartRequest) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *OfpMultipartRequest) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

type OfpMultipartReply struct {
	//ofp_header header;
	Type                 OfpMultipartType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpMultipartType" json:"type,omitempty"`
	Flags                uint32           `protobuf:"varint,2,opt,name=flags,proto3" json:"flags,omitempty"`
	Body                 []byte           `protobuf:"bytes,3,opt,name=body,proto3" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *OfpMultipartReply) Reset()         { *m = OfpMultipartReply{} }
func (m *OfpMultipartReply) String() string { return proto.CompactTextString(m) }
func (*OfpMultipartReply) ProtoMessage()    {}
func (*OfpMultipartReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{43}
}

func (m *OfpMultipartReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMultipartReply.Unmarshal(m, b)
}
func (m *OfpMultipartReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMultipartReply.Marshal(b, m, deterministic)
}
func (m *OfpMultipartReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMultipartReply.Merge(m, src)
}
func (m *OfpMultipartReply) XXX_Size() int {
	return xxx_messageInfo_OfpMultipartReply.Size(m)
}
func (m *OfpMultipartReply) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMultipartReply.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMultipartReply proto.InternalMessageInfo

func (m *OfpMultipartReply) GetType() OfpMultipartType {
	if m != nil {
		return m.Type
	}
	return OfpMultipartType_OFPMP_DESC
}

func (m *OfpMultipartReply) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *OfpMultipartReply) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

// Body of reply to OFPMP_DESC request.  Each entry is a NULL-terminated
// ASCII string.
type OfpDesc struct {
	MfrDesc              string   `protobuf:"bytes,1,opt,name=mfr_desc,json=mfrDesc,proto3" json:"mfr_desc,omitempty"`
	HwDesc               string   `protobuf:"bytes,2,opt,name=hw_desc,json=hwDesc,proto3" json:"hw_desc,omitempty"`
	SwDesc               string   `protobuf:"bytes,3,opt,name=sw_desc,json=swDesc,proto3" json:"sw_desc,omitempty"`
	SerialNum            string   `protobuf:"bytes,4,opt,name=serial_num,json=serialNum,proto3" json:"serial_num,omitempty"`
	DpDesc               string   `protobuf:"bytes,5,opt,name=dp_desc,json=dpDesc,proto3" json:"dp_desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpDesc) Reset()         { *m = OfpDesc{} }
func (m *OfpDesc) String() string { return proto.CompactTextString(m) }
func (*OfpDesc) ProtoMessage()    {}
func (*OfpDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{44}
}

func (m *OfpDesc) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpDesc.Unmarshal(m, b)
}
func (m *OfpDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpDesc.Marshal(b, m, deterministic)
}
func (m *OfpDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpDesc.Merge(m, src)
}
func (m *OfpDesc) XXX_Size() int {
	return xxx_messageInfo_OfpDesc.Size(m)
}
func (m *OfpDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpDesc.DiscardUnknown(m)
}

var xxx_messageInfo_OfpDesc proto.InternalMessageInfo

func (m *OfpDesc) GetMfrDesc() string {
	if m != nil {
		return m.MfrDesc
	}
	return ""
}

func (m *OfpDesc) GetHwDesc() string {
	if m != nil {
		return m.HwDesc
	}
	return ""
}

func (m *OfpDesc) GetSwDesc() string {
	if m != nil {
		return m.SwDesc
	}
	return ""
}

func (m *OfpDesc) GetSerialNum() string {
	if m != nil {
		return m.SerialNum
	}
	return ""
}

func (m *OfpDesc) GetDpDesc() string {
	if m != nil {
		return m.DpDesc
	}
	return ""
}

// Body for ofp_multipart_request of type OFPMP_FLOW.
type OfpFlowStatsRequest struct {
	TableId              uint32    `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	OutPort              uint32    `protobuf:"varint,2,opt,name=out_port,json=outPort,proto3" json:"out_port,omitempty"`
	OutGroup             uint32    `protobuf:"varint,3,opt,name=out_group,json=outGroup,proto3" json:"out_group,omitempty"`
	Cookie               uint64    `protobuf:"varint,4,opt,name=cookie,proto3" json:"cookie,omitempty"`
	CookieMask           uint64    `protobuf:"varint,5,opt,name=cookie_mask,json=cookieMask,proto3" json:"cookie_mask,omitempty"`
	Match                *OfpMatch `protobuf:"bytes,6,opt,name=match,proto3" json:"match,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OfpFlowStatsRequest) Reset()         { *m = OfpFlowStatsRequest{} }
func (m *OfpFlowStatsRequest) String() string { return proto.CompactTextString(m) }
func (*OfpFlowStatsRequest) ProtoMessage()    {}
func (*OfpFlowStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{45}
}

func (m *OfpFlowStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpFlowStatsRequest.Unmarshal(m, b)
}
func (m *OfpFlowStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpFlowStatsRequest.Marshal(b, m, deterministic)
}
func (m *OfpFlowStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpFlowStatsRequest.Merge(m, src)
}
func (m *OfpFlowStatsRequest) XXX_Size() int {
	return xxx_messageInfo_OfpFlowStatsRequest.Size(m)
}
func (m *OfpFlowStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpFlowStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpFlowStatsRequest proto.InternalMessageInfo

func (m *OfpFlowStatsRequest) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpFlowStatsRequest) GetOutPort() uint32 {
	if m != nil {
		return m.OutPort
	}
	return 0
}

func (m *OfpFlowStatsRequest) GetOutGroup() uint32 {
	if m != nil {
		return m.OutGroup
	}
	return 0
}

func (m *OfpFlowStatsRequest) GetCookie() uint64 {
	if m != nil {
		return m.Cookie
	}
	return 0
}

func (m *OfpFlowStatsRequest) GetCookieMask() uint64 {
	if m != nil {
		return m.CookieMask
	}
	return 0
}

func (m *OfpFlowStatsRequest) GetMatch() *OfpMatch {
	if m != nil {
		return m.Match
	}
	return nil
}

// Body of reply to OFPMP_FLOW request.
type OfpFlowStats struct {
	Id                   uint64            `protobuf:"varint,14,opt,name=id,proto3" json:"id,omitempty"`
	TableId              uint32            `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	DurationSec          uint32            `protobuf:"varint,2,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"`
	DurationNsec         uint32            `protobuf:"varint,3,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	Priority             uint32            `protobuf:"varint,4,opt,name=priority,proto3" json:"priority,omitempty"`
	IdleTimeout          uint32            `protobuf:"varint,5,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	HardTimeout          uint32            `protobuf:"varint,6,opt,name=hard_timeout,json=hardTimeout,proto3" json:"hard_timeout,omitempty"`
	Flags                uint32            `protobuf:"varint,7,opt,name=flags,proto3" json:"flags,omitempty"`
	Cookie               uint64            `protobuf:"varint,8,opt,name=cookie,proto3" json:"cookie,omitempty"`
	PacketCount          uint64            `protobuf:"varint,9,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"`
	ByteCount            uint64            `protobuf:"varint,10,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`
	Match                *OfpMatch         `protobuf:"bytes,12,opt,name=match,proto3" json:"match,omitempty"`
	Instructions         []*OfpInstruction `protobuf:"bytes,13,rep,name=instructions,proto3" json:"instructions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *OfpFlowStats) Reset()         { *m = OfpFlowStats{} }
func (m *OfpFlowStats) String() string { return proto.CompactTextString(m) }
func (*OfpFlowStats) ProtoMessage()    {}
func (*OfpFlowStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{46}
}

func (m *OfpFlowStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpFlowStats.Unmarshal(m, b)
}
func (m *OfpFlowStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpFlowStats.Marshal(b, m, deterministic)
}
func (m *OfpFlowStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpFlowStats.Merge(m, src)
}
func (m *OfpFlowStats) XXX_Size() int {
	return xxx_messageInfo_OfpFlowStats.Size(m)
}
func (m *OfpFlowStats) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpFlowStats.DiscardUnknown(m)
}

var xxx_messageInfo_OfpFlowStats proto.InternalMessageInfo

func (m *OfpFlowStats) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *OfpFlowStats) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpFlowStats) GetDurationSec() uint32 {
	if m != nil {
		return m.DurationSec
	}
	return 0
}

func (m *OfpFlowStats) GetDurationNsec() uint32 {
	if m != nil {
		return m.DurationNsec
	}
	return 0
}

func (m *OfpFlowStats) GetPriority() uint32 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *OfpFlowStats) GetIdleTimeout() uint32 {
	if m != nil {
		return m.IdleTimeout
	}
	return 0
}

func (m *OfpFlowStats) GetHardTimeout() uint32 {
	if m != nil {
		return m.HardTimeout
	}
	return 0
}

func (m *OfpFlowStats) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *OfpFlowStats) GetCookie() uint64 {
	if m != nil {
		return m.Cookie
	}
	return 0
}

func (m *OfpFlowStats) GetPacketCount() uint64 {
	if m != nil {
		return m.PacketCount
	}
	return 0
}

func (m *OfpFlowStats) GetByteCount() uint64 {
	if m != nil {
		return m.ByteCount
	}
	return 0
}

func (m *OfpFlowStats) GetMatch() *OfpMatch {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *OfpFlowStats) GetInstructions() []*OfpInstruction {
	if m != nil {
		return m.Instructions
	}
	return nil
}

// Body for ofp_multipart_request of type OFPMP_AGGREGATE.
type OfpAggregateStatsRequest struct {
	TableId              uint32    `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	OutPort              uint32    `protobuf:"varint,2,opt,name=out_port,json=outPort,proto3" json:"out_port,omitempty"`
	OutGroup             uint32    `protobuf:"varint,3,opt,name=out_group,json=outGroup,proto3" json:"out_group,omitempty"`
	Cookie               uint64    `protobuf:"varint,4,opt,name=cookie,proto3" json:"cookie,omitempty"`
	CookieMask           uint64    `protobuf:"varint,5,opt,name=cookie_mask,json=cookieMask,proto3" json:"cookie_mask,omitempty"`
	Match                *OfpMatch `protobuf:"bytes,6,opt,name=match,proto3" json:"match,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OfpAggregateStatsRequest) Reset()         { *m = OfpAggregateStatsRequest{} }
func (m *OfpAggregateStatsRequest) String() string { return proto.CompactTextString(m) }
func (*OfpAggregateStatsRequest) ProtoMessage()    {}
func (*OfpAggregateStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{47}
}

func (m *OfpAggregateStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpAggregateStatsRequest.Unmarshal(m, b)
}
func (m *OfpAggregateStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpAggregateStatsRequest.Marshal(b, m, deterministic)
}
func (m *OfpAggregateStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpAggregateStatsRequest.Merge(m, src)
}
func (m *OfpAggregateStatsRequest) XXX_Size() int {
	return xxx_messageInfo_OfpAggregateStatsRequest.Size(m)
}
func (m *OfpAggregateStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpAggregateStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpAggregateStatsRequest proto.InternalMessageInfo

func (m *OfpAggregateStatsRequest) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpAggregateStatsRequest) GetOutPort() uint32 {
	if m != nil {
		return m.OutPort
	}
	return 0
}

func (m *OfpAggregateStatsRequest) GetOutGroup() uint32 {
	if m != nil {
		return m.OutGroup
	}
	return 0
}

func (m *OfpAggregateStatsRequest) GetCookie() uint64 {
	if m != nil {
		return m.Cookie
	}
	return 0
}

func (m *OfpAggregateStatsRequest) GetCookieMask() uint64 {
	if m != nil {
		return m.CookieMask
	}
	return 0
}

func (m *OfpAggregateStatsRequest) GetMatch() *OfpMatch {
	if m != nil {
		return m.Match
	}
	return nil
}

// Body of reply to OFPMP_AGGREGATE request.
type OfpAggregateStatsReply struct {
	PacketCount          uint64   `protobuf:"varint,1,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"`
	ByteCount            uint64   `protobuf:"varint,2,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`
	FlowCount            uint32   `protobuf:"varint,3,opt,name=flow_count,json=flowCount,proto3" json:"flow_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpAggregateStatsReply) Reset()         { *m = OfpAggregateStatsReply{} }
func (m *OfpAggregateStatsReply) String() string { return proto.CompactTextString(m) }
func (*OfpAggregateStatsReply) ProtoMessage()    {}
func (*OfpAggregateStatsReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{48}
}

func (m *OfpAggregateStatsReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpAggregateStatsReply.Unmarshal(m, b)
}
func (m *OfpAggregateStatsReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpAggregateStatsReply.Marshal(b, m, deterministic)
}
func (m *OfpAggregateStatsReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpAggregateStatsReply.Merge(m, src)
}
func (m *OfpAggregateStatsReply) XXX_Size() int {
	return xxx_messageInfo_OfpAggregateStatsReply.Size(m)
}
func (m *OfpAggregateStatsReply) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpAggregateStatsReply.DiscardUnknown(m)
}

var xxx_messageInfo_OfpAggregateStatsReply proto.InternalMessageInfo

func (m *OfpAggregateStatsReply) GetPacketCount() uint64 {
	if m != nil {
		return m.PacketCount
	}
	return 0
}

func (m *OfpAggregateStatsReply) GetByteCount() uint64 {
	if m != nil {
		return m.ByteCount
	}
	return 0
}

func (m *OfpAggregateStatsReply) GetFlowCount() uint32 {
	if m != nil {
		return m.FlowCount
	}
	return 0
}

// Common header for all Table Feature Properties
type OfpTableFeatureProperty struct {
	Type OfpTableFeaturePropType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpTableFeaturePropType" json:"type,omitempty"`
	// Types that are valid to be assigned to Value:
	//	*OfpTableFeatureProperty_Instructions
	//	*OfpTableFeatureProperty_NextTables
	//	*OfpTableFeatureProperty_Actions
	//	*OfpTableFeatureProperty_Oxm
	//	*OfpTableFeatureProperty_Experimenter
	Value                isOfpTableFeatureProperty_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *OfpTableFeatureProperty) Reset()         { *m = OfpTableFeatureProperty{} }
func (m *OfpTableFeatureProperty) String() string { return proto.CompactTextString(m) }
func (*OfpTableFeatureProperty) ProtoMessage()    {}
func (*OfpTableFeatureProperty) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{49}
}

func (m *OfpTableFeatureProperty) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableFeatureProperty.Unmarshal(m, b)
}
func (m *OfpTableFeatureProperty) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableFeatureProperty.Marshal(b, m, deterministic)
}
func (m *OfpTableFeatureProperty) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableFeatureProperty.Merge(m, src)
}
func (m *OfpTableFeatureProperty) XXX_Size() int {
	return xxx_messageInfo_OfpTableFeatureProperty.Size(m)
}
func (m *OfpTableFeatureProperty) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableFeatureProperty.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableFeatureProperty proto.InternalMessageInfo

func (m *OfpTableFeatureProperty) GetType() OfpTableFeaturePropType {
	if m != nil {
		return m.Type
	}
	return OfpTableFeaturePropType_OFPTFPT_INSTRUCTIONS
}

type isOfpTableFeatureProperty_Value interface {
	isOfpTableFeatureProperty_Value()
}

type OfpTableFeatureProperty_Instructions struct {
	Instructions *OfpTableFeaturePropInstructions `protobuf:"bytes,2,opt,name=instructions,proto3,oneof"`
}

type OfpTableFeatureProperty_NextTables struct {
	NextTables *OfpTableFeaturePropNextTables `protobuf:"bytes,3,opt,name=next_tables,json=nextTables,proto3,oneof"`
}

type OfpTableFeatureProperty_Actions struct {
	Actions *OfpTableFeaturePropActions `protobuf:"bytes,4,opt,name=actions,proto3,oneof"`
}

type OfpTableFeatureProperty_Oxm struct {
	Oxm *OfpTableFeaturePropOxm `protobuf:"bytes,5,opt,name=oxm,proto3,oneof"`
}

type OfpTableFeatureProperty_Experimenter struct {
	Experimenter *OfpTableFeaturePropExperimenter `protobuf:"bytes,6,opt,name=experimenter,proto3,oneof"`
}

func (*OfpTableFeatureProperty_Instructions) isOfpTableFeatureProperty_Value() {}

func (*OfpTableFeatureProperty_NextTables) isOfpTableFeatureProperty_Value() {}

func (*OfpTableFeatureProperty_Actions) isOfpTableFeatureProperty_Value() {}

func (*OfpTableFeatureProperty_Oxm) isOfpTableFeatureProperty_Value() {}

func (*OfpTableFeatureProperty_Experimenter) isOfpTableFeatureProperty_Value() {}

func (m *OfpTableFeatureProperty) GetValue() isOfpTableFeatureProperty_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *OfpTableFeatureProperty) GetInstructions() *OfpTableFeaturePropInstructions {
	if x, ok := m.GetValue().(*OfpTableFeatureProperty_Instructions); ok {
		return x.Instructions
	}
	return nil
}

func (m *OfpTableFeatureProperty) GetNextTables() *OfpTableFeaturePropNextTables {
	if x, ok := m.GetValue().(*OfpTableFeatureProperty_NextTables); ok {
		return x.NextTables
	}
	return nil
}

func (m *OfpTableFeatureProperty) GetActions() *OfpTableFeaturePropActions {
	if x, ok := m.GetValue().(*OfpTableFeatureProperty_Actions); ok {
		return x.Actions
	}
	return nil
}

func (m *OfpTableFeatureProperty) GetOxm() *OfpTableFeaturePropOxm {
	if x, ok := m.GetValue().(*OfpTableFeatureProperty_Oxm); ok {
		return x.Oxm
	}
	return nil
}

func (m *OfpTableFeatureProperty) GetExperimenter() *OfpTableFeaturePropExperimenter {
	if x, ok := m.GetValue().(*OfpTableFeatureProperty_Experimenter); ok {
		return x.Experimenter
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OfpTableFeatureProperty) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OfpTableFeatureProperty_Instructions)(nil),
		(*OfpTableFeatureProperty_NextTables)(nil),
		(*OfpTableFeatureProperty_Actions)(nil),
		(*OfpTableFeatureProperty_Oxm)(nil),
		(*OfpTableFeatureProperty_Experimenter)(nil),
	}
}

// Instructions property
type OfpTableFeaturePropInstructions struct {
	// One of OFPTFPT_INSTRUCTIONS,
	//OFPTFPT_INSTRUCTIONS_MISS.
	Instructions         []*OfpInstruction `protobuf:"bytes,1,rep,name=instructions,proto3" json:"instructions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *OfpTableFeaturePropInstructions) Reset()         { *m = OfpTableFeaturePropInstructions{} }
func (m *OfpTableFeaturePropInstructions) String() string { return proto.CompactTextString(m) }
func (*OfpTableFeaturePropInstructions) ProtoMessage()    {}
func (*OfpTableFeaturePropInstructions) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{50}
}

func (m *OfpTableFeaturePropInstructions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableFeaturePropInstructions.Unmarshal(m, b)
}
func (m *OfpTableFeaturePropInstructions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableFeaturePropInstructions.Marshal(b, m, deterministic)
}
func (m *OfpTableFeaturePropInstructions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableFeaturePropInstructions.Merge(m, src)
}
func (m *OfpTableFeaturePropInstructions) XXX_Size() int {
	return xxx_messageInfo_OfpTableFeaturePropInstructions.Size(m)
}
func (m *OfpTableFeaturePropInstructions) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableFeaturePropInstructions.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableFeaturePropInstructions proto.InternalMessageInfo

func (m *OfpTableFeaturePropInstructions) GetInstructions() []*OfpInstruction {
	if m != nil {
		return m.Instructions
	}
	return nil
}

// Next Tables property
type OfpTableFeaturePropNextTables struct {
	// One of OFPTFPT_NEXT_TABLES,
	//OFPTFPT_NEXT_TABLES_MISS.
	NextTableIds         []uint32 `protobuf:"varint,1,rep,packed,name=next_table_ids,json=nextTableIds,proto3" json:"next_table_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpTableFeaturePropNextTables) Reset()         { *m = OfpTableFeaturePropNextTables{} }
func (m *OfpTableFeaturePropNextTables) String() string { return proto.CompactTextString(m) }
func (*OfpTableFeaturePropNextTables) ProtoMessage()    {}
func (*OfpTableFeaturePropNextTables) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{51}
}

func (m *OfpTableFeaturePropNextTables) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableFeaturePropNextTables.Unmarshal(m, b)
}
func (m *OfpTableFeaturePropNextTables) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableFeaturePropNextTables.Marshal(b, m, deterministic)
}
func (m *OfpTableFeaturePropNextTables) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableFeaturePropNextTables.Merge(m, src)
}
func (m *OfpTableFeaturePropNextTables) XXX_Size() int {
	return xxx_messageInfo_OfpTableFeaturePropNextTables.Size(m)
}
func (m *OfpTableFeaturePropNextTables) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableFeaturePropNextTables.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableFeaturePropNextTables proto.InternalMessageInfo

func (m *OfpTableFeaturePropNextTables) GetNextTableIds() []uint32 {
	if m != nil {
		return m.NextTableIds
	}
	return nil
}

// Actions property
type OfpTableFeaturePropActions struct {
	// One of OFPTFPT_WRITE_ACTIONS,
	//OFPTFPT_WRITE_ACTIONS_MISS,
	//OFPTFPT_APPLY_ACTIONS,
	//OFPTFPT_APPLY_ACTIONS_MISS.
	Actions              []*OfpAction `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OfpTableFeaturePropActions) Reset()         { *m = OfpTableFeaturePropActions{} }
func (m *OfpTableFeaturePropActions) String() string { return proto.CompactTextString(m) }
func (*OfpTableFeaturePropActions) ProtoMessage()    {}
func (*OfpTableFeaturePropActions) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{52}
}

func (m *OfpTableFeaturePropActions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableFeaturePropActions.Unmarshal(m, b)
}
func (m *OfpTableFeaturePropActions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableFeaturePropActions.Marshal(b, m, deterministic)
}
func (m *OfpTableFeaturePropActions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableFeaturePropActions.Merge(m, src)
}
func (m *OfpTableFeaturePropActions) XXX_Size() int {
	return xxx_messageInfo_OfpTableFeaturePropActions.Size(m)
}
func (m *OfpTableFeaturePropActions) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableFeaturePropActions.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableFeaturePropActions proto.InternalMessageInfo

func (m *OfpTableFeaturePropActions) GetActions() []*OfpAction {
	if m != nil {
		return m.Actions
	}
	return nil
}

// Match, Wildcard or Set-Field property
type OfpTableFeaturePropOxm struct {
	// TODO is this a uint32???
	OxmIds               []uint32 `protobuf:"varint,3,rep,packed,name=oxm_ids,json=oxmIds,proto3" json:"oxm_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpTableFeaturePropOxm) Reset()         { *m = OfpTableFeaturePropOxm{} }
func (m *OfpTableFeaturePropOxm) String() string { return proto.CompactTextString(m) }
func (*OfpTableFeaturePropOxm) ProtoMessage()    {}
func (*OfpTableFeaturePropOxm) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{53}
}

func (m *OfpTableFeaturePropOxm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableFeaturePropOxm.Unmarshal(m, b)
}
func (m *OfpTableFeaturePropOxm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableFeaturePropOxm.Marshal(b, m, deterministic)
}
func (m *OfpTableFeaturePropOxm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableFeaturePropOxm.Merge(m, src)
}
func (m *OfpTableFeaturePropOxm) XXX_Size() int {
	return xxx_messageInfo_OfpTableFeaturePropOxm.Size(m)
}
func (m *OfpTableFeaturePropOxm) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableFeaturePropOxm.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableFeaturePropOxm proto.InternalMessageInfo

func (m *OfpTableFeaturePropOxm) GetOxmIds() []uint32 {
	if m != nil {
		return m.OxmIds
	}
	return nil
}

// Experimenter table feature property
type OfpTableFeaturePropExperimenter struct {
	// One of OFPTFPT_EXPERIMENTER,
	//OFPTFPT_EXPERIMENTER_MISS.
	Experimenter         uint32   `protobuf:"varint,2,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	ExpType              uint32   `protobuf:"varint,3,opt,name=exp_type,json=expType,proto3" json:"exp_type,omitempty"`
	ExperimenterData     []uint32 `protobuf:"varint,4,rep,packed,name=experimenter_data,json=experimenterData,proto3" json:"experimenter_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpTableFeaturePropExperimenter) Reset()         { *m = OfpTableFeaturePropExperimenter{} }
func (m *OfpTableFeaturePropExperimenter) String() string { return proto.CompactTextString(m) }
func (*OfpTableFeaturePropExperimenter) ProtoMessage()    {}
func (*OfpTableFeaturePropExperimenter) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{54}
}

func (m *OfpTableFeaturePropExperimenter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableFeaturePropExperimenter.Unmarshal(m, b)
}
func (m *OfpTableFeaturePropExperimenter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableFeaturePropExperimenter.Marshal(b, m, deterministic)
}
func (m *OfpTableFeaturePropExperimenter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableFeaturePropExperimenter.Merge(m, src)
}
func (m *OfpTableFeaturePropExperimenter) XXX_Size() int {
	return xxx_messageInfo_OfpTableFeaturePropExperimenter.Size(m)
}
func (m *OfpTableFeaturePropExperimenter) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableFeaturePropExperimenter.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableFeaturePropExperimenter proto.InternalMessageInfo

func (m *OfpTableFeaturePropExperimenter) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

func (m *OfpTableFeaturePropExperimenter) GetExpType() uint32 {
	if m != nil {
		return m.ExpType
	}
	return 0
}

func (m *OfpTableFeaturePropExperimenter) GetExperimenterData() []uint32 {
	if m != nil {
		return m.ExperimenterData
	}
	return nil
}

// Body for ofp_multipart_request of type OFPMP_TABLE_FEATURES./
// Body of reply to OFPMP_TABLE_FEATURES request.
type OfpTableFeatures struct {
	TableId       uint32 `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	Name          string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	MetadataMatch uint64 `protobuf:"varint,3,opt,name=metadata_match,json=metadataMatch,proto3" json:"metadata_match,omitempty"`
	MetadataWrite uint64 `protobuf:"varint,4,opt,name=metadata_write,json=metadataWrite,proto3" json:"metadata_write,omitempty"`
	Config        uint32 `protobuf:"varint,5,opt,name=config,proto3" json:"config,omitempty"`
	MaxEntries    uint32 `protobuf:"varint,6,opt,name=max_entries,json=maxEntries,proto3" json:"max_entries,omitempty"`
	// Table Feature Property list
	Properties           []*OfpTableFeatureProperty `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OfpTableFeatures) Reset()         { *m = OfpTableFeatures{} }
func (m *OfpTableFeatures) String() string { return proto.CompactTextString(m) }
func (*OfpTableFeatures) ProtoMessage()    {}
func (*OfpTableFeatures) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{55}
}

func (m *OfpTableFeatures) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableFeatures.Unmarshal(m, b)
}
func (m *OfpTableFeatures) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableFeatures.Marshal(b, m, deterministic)
}
func (m *OfpTableFeatures) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableFeatures.Merge(m, src)
}
func (m *OfpTableFeatures) XXX_Size() int {
	return xxx_messageInfo_OfpTableFeatures.Size(m)
}
func (m *OfpTableFeatures) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableFeatures.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableFeatures proto.InternalMessageInfo

func (m *OfpTableFeatures) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpTableFeatures) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *OfpTableFeatures) GetMetadataMatch() uint64 {
	if m != nil {
		return m.MetadataMatch
	}
	return 0
}

func (m *OfpTableFeatures) GetMetadataWrite() uint64 {
	if m != nil {
		return m.MetadataWrite
	}
	return 0
}

func (m *OfpTableFeatures) GetConfig() uint32 {
	if m != nil {
		return m.Config
	}
	return 0
}

func (m *OfpTableFeatures) GetMaxEntries() uint32 {
	if m != nil {
		return m.MaxEntries
	}
	return 0
}

func (m *OfpTableFeatures) GetProperties() []*OfpTableFeatureProperty {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Body of reply to OFPMP_TABLE request.
type OfpTableStats struct {
	TableId              uint32   `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	ActiveCount          uint32   `protobuf:"varint,2,opt,name=active_count,json=activeCount,proto3" json:"active_count,omitempty"`
	LookupCount          uint64   `protobuf:"varint,3,opt,name=lookup_count,json=lookupCount,proto3" json:"lookup_count,omitempty"`
	MatchedCount         uint64   `protobuf:"varint,4,opt,name=matched_count,json=matchedCount,proto3" json:"matched_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpTableStats) Reset()         { *m = OfpTableStats{} }
func (m *OfpTableStats) String() string { return proto.CompactTextString(m) }
func (*OfpTableStats) ProtoMessage()    {}
func (*OfpTableStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{56}
}

func (m *OfpTableStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpTableStats.Unmarshal(m, b)
}
func (m *OfpTableStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpTableStats.Marshal(b, m, deterministic)
}
func (m *OfpTableStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpTableStats.Merge(m, src)
}
func (m *OfpTableStats) XXX_Size() int {
	return xxx_messageInfo_OfpTableStats.Size(m)
}
func (m *OfpTableStats) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpTableStats.DiscardUnknown(m)
}

var xxx_messageInfo_OfpTableStats proto.InternalMessageInfo

func (m *OfpTableStats) GetTableId() uint32 {
	if m != nil {
		return m.TableId
	}
	return 0
}

func (m *OfpTableStats) GetActiveCount() uint32 {
	if m != nil {
		return m.ActiveCount
	}
	return 0
}

func (m *OfpTableStats) GetLookupCount() uint64 {
	if m != nil {
		return m.LookupCount
	}
	return 0
}

func (m *OfpTableStats) GetMatchedCount() uint64 {
	if m != nil {
		return m.MatchedCount
	}
	return 0
}

// Body for ofp_multipart_request of type OFPMP_PORT.
type OfpPortStatsRequest struct {
	PortNo               uint32   `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpPortStatsRequest) Reset()         { *m = OfpPortStatsRequest{} }
func (m *OfpPortStatsRequest) String() string { return proto.CompactTextString(m) }
func (*OfpPortStatsRequest) ProtoMessage()    {}
func (*OfpPortStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{57}
}

func (m *OfpPortStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpPortStatsRequest.Unmarshal(m, b)
}
func (m *OfpPortStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpPortStatsRequest.Marshal(b, m, deterministic)
}
func (m *OfpPortStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpPortStatsRequest.Merge(m, src)
}
func (m *OfpPortStatsRequest) XXX_Size() int {
	return xxx_messageInfo_OfpPortStatsRequest.Size(m)
}
func (m *OfpPortStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpPortStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpPortStatsRequest proto.InternalMessageInfo

func (m *OfpPortStatsRequest) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

// Body of reply to OFPMP_PORT request. If a counter is unsupported, set
// the field to all ones.
type OfpPortStats struct {
	PortNo               uint32   `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	RxPackets            uint64   `protobuf:"varint,2,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	TxPackets            uint64   `protobuf:"varint,3,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	RxBytes              uint64   `protobuf:"varint,4,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	TxBytes              uint64   `protobuf:"varint,5,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	RxDropped            uint64   `protobuf:"varint,6,opt,name=rx_dropped,json=rxDropped,proto3" json:"rx_dropped,omitempty"`
	TxDropped            uint64   `protobuf:"varint,7,opt,name=tx_dropped,json=txDropped,proto3" json:"tx_dropped,omitempty"`
	RxErrors             uint64   `protobuf:"varint,8,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	TxErrors             uint64   `protobuf:"varint,9,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	RxFrameErr           uint64   `protobuf:"varint,10,opt,name=rx_frame_err,json=rxFrameErr,proto3" json:"rx_frame_err,omitempty"`
	RxOverErr            uint64   `protobuf:"varint,11,opt,name=rx_over_err,json=rxOverErr,proto3" json:"rx_over_err,omitempty"`
	RxCrcErr             uint64   `protobuf:"varint,12,opt,name=rx_crc_err,json=rxCrcErr,proto3" json:"rx_crc_err,omitempty"`
	Collisions           uint64   `protobuf:"varint,13,opt,name=collisions,proto3" json:"collisions,omitempty"`
	DurationSec          uint32   `protobuf:"varint,14,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"`
	DurationNsec         uint32   `protobuf:"varint,15,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpPortStats) Reset()         { *m = OfpPortStats{} }
func (m *OfpPortStats) String() string { return proto.CompactTextString(m) }
func (*OfpPortStats) ProtoMessage()    {}
func (*OfpPortStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{58}
}

func (m *OfpPortStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpPortStats.Unmarshal(m, b)
}
func (m *OfpPortStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpPortStats.Marshal(b, m, deterministic)
}
func (m *OfpPortStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpPortStats.Merge(m, src)
}
func (m *OfpPortStats) XXX_Size() int {
	return xxx_messageInfo_OfpPortStats.Size(m)
}
func (m *OfpPortStats) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpPortStats.DiscardUnknown(m)
}

var xxx_messageInfo_OfpPortStats proto.InternalMessageInfo

func (m *OfpPortStats) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *OfpPortStats) GetRxPackets() uint64 {
	if m != nil {
		return m.RxPackets
	}
	return 0
}

func (m *OfpPortStats) GetTxPackets() uint64 {
	if m != nil {
		return m.TxPackets
	}
	return 0
}

func (m *OfpPortStats) GetRxBytes() uint64 {
	if m != nil {
		return m.RxBytes
	}
	return 0
}

func (m *OfpPortStats) GetTxBytes() uint64 {
	if m != nil {
		return m.TxBytes
	}
	return 0
}

func (m *OfpPortStats) GetRxDropped() uint64 {
	if m != nil {
		return m.RxDropped
	}
	return 0
}

func (m *OfpPortStats) GetTxDropped() uint64 {
	if m != nil {
		return m.TxDropped
	}
	return 0
}

func (m *OfpPortStats) GetRxErrors() uint64 {
	if m != nil {
		return m.RxErrors
	}
	return 0
}

func (m *OfpPortStats) GetTxErrors() uint64 {
	if m != nil {
		return m.TxErrors
	}
	return 0
}

func (m *OfpPortStats) GetRxFrameErr() uint64 {
	if m != nil {
		return m.RxFrameErr
	}
	return 0
}

func (m *OfpPortStats) GetRxOverErr() uint64 {
	if m != nil {
		return m.RxOverErr
	}
	return 0
}

func (m *OfpPortStats) GetRxCrcErr() uint64 {
	if m != nil {
		return m.RxCrcErr
	}
	return 0
}

func (m *OfpPortStats) GetCollisions() uint64 {
	if m != nil {
		return m.Collisions
	}
	return 0
}

func (m *OfpPortStats) GetDurationSec() uint32 {
	if m != nil {
		return m.DurationSec
	}
	return 0
}

func (m *OfpPortStats) GetDurationNsec() uint32 {
	if m != nil {
		return m.DurationNsec
	}
	return 0
}

// Body of OFPMP_GROUP request.
type OfpGroupStatsRequest struct {
	GroupId              uint32   `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpGroupStatsRequest) Reset()         { *m = OfpGroupStatsRequest{} }
func (m *OfpGroupStatsRequest) String() string { return proto.CompactTextString(m) }
func (*OfpGroupStatsRequest) ProtoMessage()    {}
func (*OfpGroupStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{59}
}

func (m *OfpGroupStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpGroupStatsRequest.Unmarshal(m, b)
}
func (m *OfpGroupStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpGroupStatsRequest.Marshal(b, m, deterministic)
}
func (m *OfpGroupStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpGroupStatsRequest.Merge(m, src)
}
func (m *OfpGroupStatsRequest) XXX_Size() int {
	return xxx_messageInfo_OfpGroupStatsRequest.Size(m)
}
func (m *OfpGroupStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpGroupStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpGroupStatsRequest proto.InternalMessageInfo

func (m *OfpGroupStatsRequest) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

// Used in group stats replies.
type OfpBucketCounter struct {
	PacketCount          uint64   `protobuf:"varint,1,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"`
	ByteCount            uint64   `protobuf:"varint,2,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpBucketCounter) Reset()         { *m = OfpBucketCounter{} }
func (m *OfpBucketCounter) String() string { return proto.CompactTextString(m) }
func (*OfpBucketCounter) ProtoMessage()    {}
func (*OfpBucketCounter) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{60}
}

func (m *OfpBucketCounter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpBucketCounter.Unmarshal(m, b)
}
func (m *OfpBucketCounter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpBucketCounter.Marshal(b, m, deterministic)
}
func (m *OfpBucketCounter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpBucketCounter.Merge(m, src)
}
func (m *OfpBucketCounter) XXX_Size() int {
	return xxx_messageInfo_OfpBucketCounter.Size(m)
}
func (m *OfpBucketCounter) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpBucketCounter.DiscardUnknown(m)
}

var xxx_messageInfo_OfpBucketCounter proto.InternalMessageInfo

func (m *OfpBucketCounter) GetPacketCount() uint64 {
	if m != nil {
		return m.PacketCount
	}
	return 0
}

func (m *OfpBucketCounter) GetByteCount() uint64 {
	if m != nil {
		return m.ByteCount
	}
	return 0
}

// Body of reply to OFPMP_GROUP request.
type OfpGroupStats struct {
	GroupId              uint32              `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	RefCount             uint32              `protobuf:"varint,2,opt,name=ref_count,json=refCount,proto3" json:"ref_count,omitempty"`
	PacketCount          uint64              `protobuf:"varint,3,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"`
	ByteCount            uint64              `protobuf:"varint,4,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`
	DurationSec          uint32              `protobuf:"varint,5,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"`
	DurationNsec         uint32              `protobuf:"varint,6,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	BucketStats          []*OfpBucketCounter `protobuf:"bytes,7,rep,name=bucket_stats,json=bucketStats,proto3" json:"bucket_stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *OfpGroupStats) Reset()         { *m = OfpGroupStats{} }
func (m *OfpGroupStats) String() string { return proto.CompactTextString(m) }
func (*OfpGroupStats) ProtoMessage()    {}
func (*OfpGroupStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{61}
}

func (m *OfpGroupStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpGroupStats.Unmarshal(m, b)
}
func (m *OfpGroupStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpGroupStats.Marshal(b, m, deterministic)
}
func (m *OfpGroupStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpGroupStats.Merge(m, src)
}
func (m *OfpGroupStats) XXX_Size() int {
	return xxx_messageInfo_OfpGroupStats.Size(m)
}
func (m *OfpGroupStats) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpGroupStats.DiscardUnknown(m)
}

var xxx_messageInfo_OfpGroupStats proto.InternalMessageInfo

func (m *OfpGroupStats) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *OfpGroupStats) GetRefCount() uint32 {
	if m != nil {
		return m.RefCount
	}
	return 0
}

func (m *OfpGroupStats) GetPacketCount() uint64 {
	if m != nil {
		return m.PacketCount
	}
	return 0
}

func (m *OfpGroupStats) GetByteCount() uint64 {
	if m != nil {
		return m.ByteCount
	}
	return 0
}

func (m *OfpGroupStats) GetDurationSec() uint32 {
	if m != nil {
		return m.DurationSec
	}
	return 0
}

func (m *OfpGroupStats) GetDurationNsec() uint32 {
	if m != nil {
		return m.DurationNsec
	}
	return 0
}

func (m *OfpGroupStats) GetBucketStats() []*OfpBucketCounter {
	if m != nil {
		return m.BucketStats
	}
	return nil
}

// Body of reply to OFPMP_GROUP_DESC request.
type OfpGroupDesc struct {
	Type                 OfpGroupType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpGroupType" json:"type,omitempty"`
	GroupId              uint32       `protobuf:"varint,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Buckets              []*OfpBucket `protobuf:"bytes,3,rep,name=buckets,proto3" json:"buckets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OfpGroupDesc) Reset()         { *m = OfpGroupDesc{} }
func (m *OfpGroupDesc) String() string { return proto.CompactTextString(m) }
func (*OfpGroupDesc) ProtoMessage()    {}
func (*OfpGroupDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{62}
}

func (m *OfpGroupDesc) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpGroupDesc.Unmarshal(m, b)
}
func (m *OfpGroupDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpGroupDesc.Marshal(b, m, deterministic)
}
func (m *OfpGroupDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpGroupDesc.Merge(m, src)
}
func (m *OfpGroupDesc) XXX_Size() int {
	return xxx_messageInfo_OfpGroupDesc.Size(m)
}
func (m *OfpGroupDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpGroupDesc.DiscardUnknown(m)
}

var xxx_messageInfo_OfpGroupDesc proto.InternalMessageInfo

func (m *OfpGroupDesc) GetType() OfpGroupType {
	if m != nil {
		return m.Type
	}
	return OfpGroupType_OFPGT_ALL
}

func (m *OfpGroupDesc) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *OfpGroupDesc) GetBuckets() []*OfpBucket {
	if m != nil {
		return m.Buckets
	}
	return nil
}

type OfpGroupEntry struct {
	Desc                 *OfpGroupDesc  `protobuf:"bytes,1,opt,name=desc,proto3" json:"desc,omitempty"`
	Stats                *OfpGroupStats `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *OfpGroupEntry) Reset()         { *m = OfpGroupEntry{} }
func (m *OfpGroupEntry) String() string { return proto.CompactTextString(m) }
func (*OfpGroupEntry) ProtoMessage()    {}
func (*OfpGroupEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{63}
}

func (m *OfpGroupEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpGroupEntry.Unmarshal(m, b)
}
func (m *OfpGroupEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpGroupEntry.Marshal(b, m, deterministic)
}
func (m *OfpGroupEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpGroupEntry.Merge(m, src)
}
func (m *OfpGroupEntry) XXX_Size() int {
	return xxx_messageInfo_OfpGroupEntry.Size(m)
}
func (m *OfpGroupEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpGroupEntry.DiscardUnknown(m)
}

var xxx_messageInfo_OfpGroupEntry proto.InternalMessageInfo

func (m *OfpGroupEntry) GetDesc() *OfpGroupDesc {
	if m != nil {
		return m.Desc
	}
	return nil
}

func (m *OfpGroupEntry) GetStats() *OfpGroupStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

// Body of reply to OFPMP_GROUP_FEATURES request. Group features.
type OfpGroupFeatures struct {
	Types                uint32   `protobuf:"varint,1,opt,name=types,proto3" json:"types,omitempty"`
	Capabilities         uint32   `protobuf:"varint,2,opt,name=capabilities,proto3" json:"capabilities,omitempty"`
	MaxGroups            []uint32 `protobuf:"varint,3,rep,packed,name=max_groups,json=maxGroups,proto3" json:"max_groups,omitempty"`
	Actions              []uint32 `protobuf:"varint,4,rep,packed,name=actions,proto3" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpGroupFeatures) Reset()         { *m = OfpGroupFeatures{} }
func (m *OfpGroupFeatures) String() string { return proto.CompactTextString(m) }
func (*OfpGroupFeatures) ProtoMessage()    {}
func (*OfpGroupFeatures) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{64}
}

func (m *OfpGroupFeatures) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpGroupFeatures.Unmarshal(m, b)
}
func (m *OfpGroupFeatures) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpGroupFeatures.Marshal(b, m, deterministic)
}
func (m *OfpGroupFeatures) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpGroupFeatures.Merge(m, src)
}
func (m *OfpGroupFeatures) XXX_Size() int {
	return xxx_messageInfo_OfpGroupFeatures.Size(m)
}
func (m *OfpGroupFeatures) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpGroupFeatures.DiscardUnknown(m)
}

var xxx_messageInfo_OfpGroupFeatures proto.InternalMessageInfo

func (m *OfpGroupFeatures) GetTypes() uint32 {
	if m != nil {
		return m.Types
	}
	return 0
}

func (m *OfpGroupFeatures) GetCapabilities() uint32 {
	if m != nil {
		return m.Capabilities
	}
	return 0
}

func (m *OfpGroupFeatures) GetMaxGroups() []uint32 {
	if m != nil {
		return m.MaxGroups
	}
	return nil
}

func (m *OfpGroupFeatures) GetActions() []uint32 {
	if m != nil {
		return m.Actions
	}
	return nil
}

// Body of OFPMP_METER and OFPMP_METER_CONFIG requests.
type OfpMeterMultipartRequest struct {
	MeterId              uint32   `protobuf:"varint,1,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpMeterMultipartRequest) Reset()         { *m = OfpMeterMultipartRequest{} }
func (m *OfpMeterMultipartRequest) String() string { return proto.CompactTextString(m) }
func (*OfpMeterMultipartRequest) ProtoMessage()    {}
func (*OfpMeterMultipartRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{65}
}

func (m *OfpMeterMultipartRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterMultipartRequest.Unmarshal(m, b)
}
func (m *OfpMeterMultipartRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterMultipartRequest.Marshal(b, m, deterministic)
}
func (m *OfpMeterMultipartRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterMultipartRequest.Merge(m, src)
}
func (m *OfpMeterMultipartRequest) XXX_Size() int {
	return xxx_messageInfo_OfpMeterMultipartRequest.Size(m)
}
func (m *OfpMeterMultipartRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterMultipartRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterMultipartRequest proto.InternalMessageInfo

func (m *OfpMeterMultipartRequest) GetMeterId() uint32 {
	if m != nil {
		return m.MeterId
	}
	return 0
}

// Statistics for each meter band
type OfpMeterBandStats struct {
	PacketBandCount      uint64   `protobuf:"varint,1,opt,name=packet_band_count,json=packetBandCount,proto3" json:"packet_band_count,omitempty"`
	ByteBandCount        uint64   `protobuf:"varint,2,opt,name=byte_band_count,json=byteBandCount,proto3" json:"byte_band_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpMeterBandStats) Reset()         { *m = OfpMeterBandStats{} }
func (m *OfpMeterBandStats) String() string { return proto.CompactTextString(m) }
func (*OfpMeterBandStats) ProtoMessage()    {}
func (*OfpMeterBandStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{66}
}

func (m *OfpMeterBandStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterBandStats.Unmarshal(m, b)
}
func (m *OfpMeterBandStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterBandStats.Marshal(b, m, deterministic)
}
func (m *OfpMeterBandStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterBandStats.Merge(m, src)
}
func (m *OfpMeterBandStats) XXX_Size() int {
	return xxx_messageInfo_OfpMeterBandStats.Size(m)
}
func (m *OfpMeterBandStats) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterBandStats.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterBandStats proto.InternalMessageInfo

func (m *OfpMeterBandStats) GetPacketBandCount() uint64 {
	if m != nil {
		return m.PacketBandCount
	}
	return 0
}

func (m *OfpMeterBandStats) GetByteBandCount() uint64 {
	if m != nil {
		return m.ByteBandCount
	}
	return 0
}

// Body of reply to OFPMP_METER request. Meter statistics.
type OfpMeterStats struct {
	MeterId              uint32               `protobuf:"varint,1,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"`
	FlowCount            uint32               `protobuf:"varint,2,opt,name=flow_count,json=flowCount,proto3" json:"flow_count,omitempty"`
	PacketInCount        uint64               `protobuf:"varint,3,opt,name=packet_in_count,json=packetInCount,proto3" json:"packet_in_count,omitempty"`
	ByteInCount          uint64               `protobuf:"varint,4,opt,name=byte_in_count,json=byteInCount,proto3" json:"byte_in_count,omitempty"`
	DurationSec          uint32               `protobuf:"varint,5,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"`
	DurationNsec         uint32               `protobuf:"varint,6,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	BandStats            []*OfpMeterBandStats `protobuf:"bytes,7,rep,name=band_stats,json=bandStats,proto3" json:"band_stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OfpMeterStats) Reset()         { *m = OfpMeterStats{} }
func (m *OfpMeterStats) String() string { return proto.CompactTextString(m) }
func (*OfpMeterStats) ProtoMessage()    {}
func (*OfpMeterStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{67}
}

func (m *OfpMeterStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterStats.Unmarshal(m, b)
}
func (m *OfpMeterStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterStats.Marshal(b, m, deterministic)
}
func (m *OfpMeterStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterStats.Merge(m, src)
}
func (m *OfpMeterStats) XXX_Size() int {
	return xxx_messageInfo_OfpMeterStats.Size(m)
}
func (m *OfpMeterStats) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterStats.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterStats proto.InternalMessageInfo

func (m *OfpMeterStats) GetMeterId() uint32 {
	if m != nil {
		return m.MeterId
	}
	return 0
}

func (m *OfpMeterStats) GetFlowCount() uint32 {
	if m != nil {
		return m.FlowCount
	}
	return 0
}

func (m *OfpMeterStats) GetPacketInCount() uint64 {
	if m != nil {
		return m.PacketInCount
	}
	return 0
}

func (m *OfpMeterStats) GetByteInCount() uint64 {
	if m != nil {
		return m.ByteInCount
	}
	return 0
}

func (m *OfpMeterStats) GetDurationSec() uint32 {
	if m != nil {
		return m.DurationSec
	}
	return 0
}

func (m *OfpMeterStats) GetDurationNsec() uint32 {
	if m != nil {
		return m.DurationNsec
	}
	return 0
}

func (m *OfpMeterStats) GetBandStats() []*OfpMeterBandStats {
	if m != nil {
		return m.BandStats
	}
	return nil
}

// Body of reply to OFPMP_METER_CONFIG request. Meter configuration.
type OfpMeterConfig struct {
	Flags                uint32                `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"`
	MeterId              uint32                `protobuf:"varint,2,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"`
	Bands                []*OfpMeterBandHeader `protobuf:"bytes,3,rep,name=bands,proto3" json:"bands,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OfpMeterConfig) Reset()         { *m = OfpMeterConfig{} }
func (m *OfpMeterConfig) String() string { return proto.CompactTextString(m) }
func (*OfpMeterConfig) ProtoMessage()    {}
func (*OfpMeterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{68}
}

func (m *OfpMeterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterConfig.Unmarshal(m, b)
}
func (m *OfpMeterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterConfig.Marshal(b, m, deterministic)
}
func (m *OfpMeterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterConfig.Merge(m, src)
}
func (m *OfpMeterConfig) XXX_Size() int {
	return xxx_messageInfo_OfpMeterConfig.Size(m)
}
func (m *OfpMeterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterConfig proto.InternalMessageInfo

func (m *OfpMeterConfig) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *OfpMeterConfig) GetMeterId() uint32 {
	if m != nil {
		return m.MeterId
	}
	return 0
}

func (m *OfpMeterConfig) GetBands() []*OfpMeterBandHeader {
	if m != nil {
		return m.Bands
	}
	return nil
}

// Body of reply to OFPMP_METER_FEATURES request. Meter features.
type OfpMeterFeatures struct {
	MaxMeter             uint32   `protobuf:"varint,1,opt,name=max_meter,json=maxMeter,proto3" json:"max_meter,omitempty"`
	BandTypes            uint32   `protobuf:"varint,2,opt,name=band_types,json=bandTypes,proto3" json:"band_types,omitempty"`
	Capabilities         uint32   `protobuf:"varint,3,opt,name=capabilities,proto3" json:"capabilities,omitempty"`
	MaxBands             uint32   `protobuf:"varint,4,opt,name=max_bands,json=maxBands,proto3" json:"max_bands,omitempty"`
	MaxColor             uint32   `protobuf:"varint,5,opt,name=max_color,json=maxColor,proto3" json:"max_color,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpMeterFeatures) Reset()         { *m = OfpMeterFeatures{} }
func (m *OfpMeterFeatures) String() string { return proto.CompactTextString(m) }
func (*OfpMeterFeatures) ProtoMessage()    {}
func (*OfpMeterFeatures) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{69}
}

func (m *OfpMeterFeatures) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterFeatures.Unmarshal(m, b)
}
func (m *OfpMeterFeatures) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterFeatures.Marshal(b, m, deterministic)
}
func (m *OfpMeterFeatures) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterFeatures.Merge(m, src)
}
func (m *OfpMeterFeatures) XXX_Size() int {
	return xxx_messageInfo_OfpMeterFeatures.Size(m)
}
func (m *OfpMeterFeatures) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterFeatures.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterFeatures proto.InternalMessageInfo

func (m *OfpMeterFeatures) GetMaxMeter() uint32 {
	if m != nil {
		return m.MaxMeter
	}
	return 0
}

func (m *OfpMeterFeatures) GetBandTypes() uint32 {
	if m != nil {
		return m.BandTypes
	}
	return 0
}

func (m *OfpMeterFeatures) GetCapabilities() uint32 {
	if m != nil {
		return m.Capabilities
	}
	return 0
}

func (m *OfpMeterFeatures) GetMaxBands() uint32 {
	if m != nil {
		return m.MaxBands
	}
	return 0
}

func (m *OfpMeterFeatures) GetMaxColor() uint32 {
	if m != nil {
		return m.MaxColor
	}
	return 0
}

type OfpMeterEntry struct {
	Config               *OfpMeterConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	Stats                *OfpMeterStats  `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *OfpMeterEntry) Reset()         { *m = OfpMeterEntry{} }
func (m *OfpMeterEntry) String() string { return proto.CompactTextString(m) }
func (*OfpMeterEntry) ProtoMessage()    {}
func (*OfpMeterEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{70}
}

func (m *OfpMeterEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpMeterEntry.Unmarshal(m, b)
}
func (m *OfpMeterEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpMeterEntry.Marshal(b, m, deterministic)
}
func (m *OfpMeterEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpMeterEntry.Merge(m, src)
}
func (m *OfpMeterEntry) XXX_Size() int {
	return xxx_messageInfo_OfpMeterEntry.Size(m)
}
func (m *OfpMeterEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpMeterEntry.DiscardUnknown(m)
}

var xxx_messageInfo_OfpMeterEntry proto.InternalMessageInfo

func (m *OfpMeterEntry) GetConfig() *OfpMeterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *OfpMeterEntry) GetStats() *OfpMeterStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

// Body for ofp_multipart_request/reply of type OFPMP_EXPERIMENTER.
type OfpExperimenterMultipartHeader struct {
	Experimenter         uint32   `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	ExpType              uint32   `protobuf:"varint,2,opt,name=exp_type,json=expType,proto3" json:"exp_type,omitempty"`
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpExperimenterMultipartHeader) Reset()         { *m = OfpExperimenterMultipartHeader{} }
func (m *OfpExperimenterMultipartHeader) String() string { return proto.CompactTextString(m) }
func (*OfpExperimenterMultipartHeader) ProtoMessage()    {}
func (*OfpExperimenterMultipartHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{71}
}

func (m *OfpExperimenterMultipartHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpExperimenterMultipartHeader.Unmarshal(m, b)
}
func (m *OfpExperimenterMultipartHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpExperimenterMultipartHeader.Marshal(b, m, deterministic)
}
func (m *OfpExperimenterMultipartHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpExperimenterMultipartHeader.Merge(m, src)
}
func (m *OfpExperimenterMultipartHeader) XXX_Size() int {
	return xxx_messageInfo_OfpExperimenterMultipartHeader.Size(m)
}
func (m *OfpExperimenterMultipartHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpExperimenterMultipartHeader.DiscardUnknown(m)
}

var xxx_messageInfo_OfpExperimenterMultipartHeader proto.InternalMessageInfo

func (m *OfpExperimenterMultipartHeader) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

func (m *OfpExperimenterMultipartHeader) GetExpType() uint32 {
	if m != nil {
		return m.ExpType
	}
	return 0
}

func (m *OfpExperimenterMultipartHeader) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Experimenter extension.
type OfpExperimenterHeader struct {
	//ofp_header header;  /* Type OFPT_EXPERIMENTER. */
	Experimenter         uint32   `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	ExpType              uint32   `protobuf:"varint,2,opt,name=exp_type,json=expType,proto3" json:"exp_type,omitempty"`
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpExperimenterHeader) Reset()         { *m = OfpExperimenterHeader{} }
func (m *OfpExperimenterHeader) String() string { return proto.CompactTextString(m) }
func (*OfpExperimenterHeader) ProtoMessage()    {}
func (*OfpExperimenterHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{72}
}

func (m *OfpExperimenterHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpExperimenterHeader.Unmarshal(m, b)
}
func (m *OfpExperimenterHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpExperimenterHeader.Marshal(b, m, deterministic)
}
func (m *OfpExperimenterHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpExperimenterHeader.Merge(m, src)
}
func (m *OfpExperimenterHeader) XXX_Size() int {
	return xxx_messageInfo_OfpExperimenterHeader.Size(m)
}
func (m *OfpExperimenterHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpExperimenterHeader.DiscardUnknown(m)
}

var xxx_messageInfo_OfpExperimenterHeader proto.InternalMessageInfo

func (m *OfpExperimenterHeader) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

func (m *OfpExperimenterHeader) GetExpType() uint32 {
	if m != nil {
		return m.ExpType
	}
	return 0
}

func (m *OfpExperimenterHeader) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Common description for a queue.
type OfpQueuePropHeader struct {
	Property             uint32   `protobuf:"varint,1,opt,name=property,proto3" json:"property,omitempty"`
	Len                  uint32   `protobuf:"varint,2,opt,name=len,proto3" json:"len,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpQueuePropHeader) Reset()         { *m = OfpQueuePropHeader{} }
func (m *OfpQueuePropHeader) String() string { return proto.CompactTextString(m) }
func (*OfpQueuePropHeader) ProtoMessage()    {}
func (*OfpQueuePropHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{73}
}

func (m *OfpQueuePropHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpQueuePropHeader.Unmarshal(m, b)
}
func (m *OfpQueuePropHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpQueuePropHeader.Marshal(b, m, deterministic)
}
func (m *OfpQueuePropHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpQueuePropHeader.Merge(m, src)
}
func (m *OfpQueuePropHeader) XXX_Size() int {
	return xxx_messageInfo_OfpQueuePropHeader.Size(m)
}
func (m *OfpQueuePropHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpQueuePropHeader.DiscardUnknown(m)
}

var xxx_messageInfo_OfpQueuePropHeader proto.InternalMessageInfo

func (m *OfpQueuePropHeader) GetProperty() uint32 {
	if m != nil {
		return m.Property
	}
	return 0
}

func (m *OfpQueuePropHeader) GetLen() uint32 {
	if m != nil {
		return m.Len
	}
	return 0
}

// Min-Rate queue property description.
type OfpQueuePropMinRate struct {
	PropHeader           *OfpQueuePropHeader `protobuf:"bytes,1,opt,name=prop_header,json=propHeader,proto3" json:"prop_header,omitempty"`
	Rate                 uint32              `protobuf:"varint,2,opt,name=rate,proto3" json:"rate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *OfpQueuePropMinRate) Reset()         { *m = OfpQueuePropMinRate{} }
func (m *OfpQueuePropMinRate) String() string { return proto.CompactTextString(m) }
func (*OfpQueuePropMinRate) ProtoMessage()    {}
func (*OfpQueuePropMinRate) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{74}
}

func (m *OfpQueuePropMinRate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpQueuePropMinRate.Unmarshal(m, b)
}
func (m *OfpQueuePropMinRate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpQueuePropMinRate.Marshal(b, m, deterministic)
}
func (m *OfpQueuePropMinRate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpQueuePropMinRate.Merge(m, src)
}
func (m *OfpQueuePropMinRate) XXX_Size() int {
	return xxx_messageInfo_OfpQueuePropMinRate.Size(m)
}
func (m *OfpQueuePropMinRate) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpQueuePropMinRate.DiscardUnknown(m)
}

var xxx_messageInfo_OfpQueuePropMinRate proto.InternalMessageInfo

func (m *OfpQueuePropMinRate) GetPropHeader() *OfpQueuePropHeader {
	if m != nil {
		return m.PropHeader
	}
	return nil
}

func (m *OfpQueuePropMinRate) GetRate() uint32 {
	if m != nil {
		return m.Rate
	}
	return 0
}

// Max-Rate queue property description.
type OfpQueuePropMaxRate struct {
	PropHeader           *OfpQueuePropHeader `protobuf:"bytes,1,opt,name=prop_header,json=propHeader,proto3" json:"prop_header,omitempty"`
	Rate                 uint32              `protobuf:"varint,2,opt,name=rate,proto3" json:"rate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *OfpQueuePropMaxRate) Reset()         { *m = OfpQueuePropMaxRate{} }
func (m *OfpQueuePropMaxRate) String() string { return proto.CompactTextString(m) }
func (*OfpQueuePropMaxRate) ProtoMessage()    {}
func (*OfpQueuePropMaxRate) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{75}
}

func (m *OfpQueuePropMaxRate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpQueuePropMaxRate.Unmarshal(m, b)
}
func (m *OfpQueuePropMaxRate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpQueuePropMaxRate.Marshal(b, m, deterministic)
}
func (m *OfpQueuePropMaxRate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpQueuePropMaxRate.Merge(m, src)
}
func (m *OfpQueuePropMaxRate) XXX_Size() int {
	return xxx_messageInfo_OfpQueuePropMaxRate.Size(m)
}
func (m *OfpQueuePropMaxRate) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpQueuePropMaxRate.DiscardUnknown(m)
}

var xxx_messageInfo_OfpQueuePropMaxRate proto.InternalMessageInfo

func (m *OfpQueuePropMaxRate) GetPropHeader() *OfpQueuePropHeader {
	if m != nil {
		return m.PropHeader
	}
	return nil
}

func (m *OfpQueuePropMaxRate) GetRate() uint32 {
	if m != nil {
		return m.Rate
	}
	return 0
}

// Experimenter queue property description.
type OfpQueuePropExperimenter struct {
	PropHeader           *OfpQueuePropHeader `protobuf:"bytes,1,opt,name=prop_header,json=propHeader,proto3" json:"prop_header,omitempty"`
	Experimenter         uint32              `protobuf:"varint,2,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	Data                 []byte              `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *OfpQueuePropExperimenter) Reset()         { *m = OfpQueuePropExperimenter{} }
func (m *OfpQueuePropExperimenter) String() string { return proto.CompactTextString(m) }
func (*OfpQueuePropExperimenter) ProtoMessage()    {}
func (*OfpQueuePropExperimenter) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{76}
}

func (m *OfpQueuePropExperimenter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpQueuePropExperimenter.Unmarshal(m, b)
}
func (m *OfpQueuePropExperimenter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpQueuePropExperimenter.Marshal(b, m, deterministic)
}
func (m *OfpQueuePropExperimenter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpQueuePropExperimenter.Merge(m, src)
}
func (m *OfpQueuePropExperimenter) XXX_Size() int {
	return xxx_messageInfo_OfpQueuePropExperimenter.Size(m)
}
func (m *OfpQueuePropExperimenter) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpQueuePropExperimenter.DiscardUnknown(m)
}

var xxx_messageInfo_OfpQueuePropExperimenter proto.InternalMessageInfo

func (m *OfpQueuePropExperimenter) GetPropHeader() *OfpQueuePropHeader {
	if m != nil {
		return m.PropHeader
	}
	return nil
}

func (m *OfpQueuePropExperimenter) GetExperimenter() uint32 {
	if m != nil {
		return m.Experimenter
	}
	return 0
}

func (m *OfpQueuePropExperimenter) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Full description for a queue.
type OfpPacketQueue struct {
	QueueId              uint32                `protobuf:"varint,1,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"`
	Port                 uint32                `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	Properties           []*OfpQueuePropHeader `protobuf:"bytes,4,rep,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OfpPacketQueue) Reset()         { *m = OfpPacketQueue{} }
func (m *OfpPacketQueue) String() string { return proto.CompactTextString(m) }
func (*OfpPacketQueue) ProtoMessage()    {}
func (*OfpPacketQueue) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{77}
}

func (m *OfpPacketQueue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpPacketQueue.Unmarshal(m, b)
}
func (m *OfpPacketQueue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpPacketQueue.Marshal(b, m, deterministic)
}
func (m *OfpPacketQueue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpPacketQueue.Merge(m, src)
}
func (m *OfpPacketQueue) XXX_Size() int {
	return xxx_messageInfo_OfpPacketQueue.Size(m)
}
func (m *OfpPacketQueue) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpPacketQueue.DiscardUnknown(m)
}

var xxx_messageInfo_OfpPacketQueue proto.InternalMessageInfo

func (m *OfpPacketQueue) GetQueueId() uint32 {
	if m != nil {
		return m.QueueId
	}
	return 0
}

func (m *OfpPacketQueue) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *OfpPacketQueue) GetProperties() []*OfpQueuePropHeader {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Query for port queue configuration.
type OfpQueueGetConfigRequest struct {
	//ofp_header header;
	Port                 uint32   `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpQueueGetConfigRequest) Reset()         { *m = OfpQueueGetConfigRequest{} }
func (m *OfpQueueGetConfigRequest) String() string { return proto.CompactTextString(m) }
func (*OfpQueueGetConfigRequest) ProtoMessage()    {}
func (*OfpQueueGetConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{78}
}

func (m *OfpQueueGetConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpQueueGetConfigRequest.Unmarshal(m, b)
}
func (m *OfpQueueGetConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpQueueGetConfigRequest.Marshal(b, m, deterministic)
}
func (m *OfpQueueGetConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpQueueGetConfigRequest.Merge(m, src)
}
func (m *OfpQueueGetConfigRequest) XXX_Size() int {
	return xxx_messageInfo_OfpQueueGetConfigRequest.Size(m)
}
func (m *OfpQueueGetConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpQueueGetConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpQueueGetConfigRequest proto.InternalMessageInfo

func (m *OfpQueueGetConfigRequest) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Queue configuration for a given port.
type OfpQueueGetConfigReply struct {
	//ofp_header header;
	Port                 uint32            `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	Queues               []*OfpPacketQueue `protobuf:"bytes,2,rep,name=queues,proto3" json:"queues,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *OfpQueueGetConfigReply) Reset()         { *m = OfpQueueGetConfigReply{} }
func (m *OfpQueueGetConfigReply) String() string { return proto.CompactTextString(m) }
func (*OfpQueueGetConfigReply) ProtoMessage()    {}
func (*OfpQueueGetConfigReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{79}
}

func (m *OfpQueueGetConfigReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpQueueGetConfigReply.Unmarshal(m, b)
}
func (m *OfpQueueGetConfigReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpQueueGetConfigReply.Marshal(b, m, deterministic)
}
func (m *OfpQueueGetConfigReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpQueueGetConfigReply.Merge(m, src)
}
func (m *OfpQueueGetConfigReply) XXX_Size() int {
	return xxx_messageInfo_OfpQueueGetConfigReply.Size(m)
}
func (m *OfpQueueGetConfigReply) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpQueueGetConfigReply.DiscardUnknown(m)
}

var xxx_messageInfo_OfpQueueGetConfigReply proto.InternalMessageInfo

func (m *OfpQueueGetConfigReply) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *OfpQueueGetConfigReply) GetQueues() []*OfpPacketQueue {
	if m != nil {
		return m.Queues
	}
	return nil
}

// OFPAT_SET_QUEUE action struct: send packets to given queue on port.
type OfpActionSetQueue struct {
	Type                 uint32   `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	QueueId              uint32   `protobuf:"varint,3,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpActionSetQueue) Reset()         { *m = OfpActionSetQueue{} }
func (m *OfpActionSetQueue) String() string { return proto.CompactTextString(m) }
func (*OfpActionSetQueue) ProtoMessage()    {}
func (*OfpActionSetQueue) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{80}
}

func (m *OfpActionSetQueue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpActionSetQueue.Unmarshal(m, b)
}
func (m *OfpActionSetQueue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpActionSetQueue.Marshal(b, m, deterministic)
}
func (m *OfpActionSetQueue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpActionSetQueue.Merge(m, src)
}
func (m *OfpActionSetQueue) XXX_Size() int {
	return xxx_messageInfo_OfpActionSetQueue.Size(m)
}
func (m *OfpActionSetQueue) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpActionSetQueue.DiscardUnknown(m)
}

var xxx_messageInfo_OfpActionSetQueue proto.InternalMessageInfo

func (m *OfpActionSetQueue) GetType() uint32 {
	if m != nil {
		return m.Type
	}
	return 0
}

func (m *OfpActionSetQueue) GetQueueId() uint32 {
	if m != nil {
		return m.QueueId
	}
	return 0
}

type OfpQueueStatsRequest struct {
	PortNo               uint32   `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	QueueId              uint32   `protobuf:"varint,2,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpQueueStatsRequest) Reset()         { *m = OfpQueueStatsRequest{} }
func (m *OfpQueueStatsRequest) String() string { return proto.CompactTextString(m) }
func (*OfpQueueStatsRequest) ProtoMessage()    {}
func (*OfpQueueStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{81}
}

func (m *OfpQueueStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpQueueStatsRequest.Unmarshal(m, b)
}
func (m *OfpQueueStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpQueueStatsRequest.Marshal(b, m, deterministic)
}
func (m *OfpQueueStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpQueueStatsRequest.Merge(m, src)
}
func (m *OfpQueueStatsRequest) XXX_Size() int {
	return xxx_messageInfo_OfpQueueStatsRequest.Size(m)
}
func (m *OfpQueueStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpQueueStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpQueueStatsRequest proto.InternalMessageInfo

func (m *OfpQueueStatsRequest) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *OfpQueueStatsRequest) GetQueueId() uint32 {
	if m != nil {
		return m.QueueId
	}
	return 0
}

type OfpQueueStats struct {
	PortNo               uint32   `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	QueueId              uint32   `protobuf:"varint,2,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"`
	TxBytes              uint64   `protobuf:"varint,3,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxPackets            uint64   `protobuf:"varint,4,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	TxErrors             uint64   `protobuf:"varint,5,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	DurationSec          uint32   `protobuf:"varint,6,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"`
	DurationNsec         uint32   `protobuf:"varint,7,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpQueueStats) Reset()         { *m = OfpQueueStats{} }
func (m *OfpQueueStats) String() string { return proto.CompactTextString(m) }
func (*OfpQueueStats) ProtoMessage()    {}
func (*OfpQueueStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{82}
}

func (m *OfpQueueStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpQueueStats.Unmarshal(m, b)
}
func (m *OfpQueueStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpQueueStats.Marshal(b, m, deterministic)
}
func (m *OfpQueueStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpQueueStats.Merge(m, src)
}
func (m *OfpQueueStats) XXX_Size() int {
	return xxx_messageInfo_OfpQueueStats.Size(m)
}
func (m *OfpQueueStats) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpQueueStats.DiscardUnknown(m)
}

var xxx_messageInfo_OfpQueueStats proto.InternalMessageInfo

func (m *OfpQueueStats) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *OfpQueueStats) GetQueueId() uint32 {
	if m != nil {
		return m.QueueId
	}
	return 0
}

func (m *OfpQueueStats) GetTxBytes() uint64 {
	if m != nil {
		return m.TxBytes
	}
	return 0
}

func (m *OfpQueueStats) GetTxPackets() uint64 {
	if m != nil {
		return m.TxPackets
	}
	return 0
}

func (m *OfpQueueStats) GetTxErrors() uint64 {
	if m != nil {
		return m.TxErrors
	}
	return 0
}

func (m *OfpQueueStats) GetDurationSec() uint32 {
	if m != nil {
		return m.DurationSec
	}
	return 0
}

func (m *OfpQueueStats) GetDurationNsec() uint32 {
	if m != nil {
		return m.DurationNsec
	}
	return 0
}

// Role request and reply message.
type OfpRoleRequest struct {
	//ofp_header header;        /* Type OFPT_ROLE_REQUEST/OFPT_ROLE_REPLY. */
	Role                 OfpControllerRole `protobuf:"varint,1,opt,name=role,proto3,enum=openflow_13.OfpControllerRole" json:"role,omitempty"`
	GenerationId         uint64            `protobuf:"varint,2,opt,name=generation_id,json=generationId,proto3" json:"generation_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *OfpRoleRequest) Reset()         { *m = OfpRoleRequest{} }
func (m *OfpRoleRequest) String() string { return proto.CompactTextString(m) }
func (*OfpRoleRequest) ProtoMessage()    {}
func (*OfpRoleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{83}
}

func (m *OfpRoleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpRoleRequest.Unmarshal(m, b)
}
func (m *OfpRoleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpRoleRequest.Marshal(b, m, deterministic)
}
func (m *OfpRoleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpRoleRequest.Merge(m, src)
}
func (m *OfpRoleRequest) XXX_Size() int {
	return xxx_messageInfo_OfpRoleRequest.Size(m)
}
func (m *OfpRoleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpRoleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfpRoleRequest proto.InternalMessageInfo

func (m *OfpRoleRequest) GetRole() OfpControllerRole {
	if m != nil {
		return m.Role
	}
	return OfpControllerRole_OFPCR_ROLE_NOCHANGE
}

func (m *OfpRoleRequest) GetGenerationId() uint64 {
	if m != nil {
		return m.GenerationId
	}
	return 0
}

// Asynchronous message configuration.
type OfpAsyncConfig struct {
	//ofp_header header;    /* OFPT_GET_ASYNC_REPLY or OFPT_SET_ASYNC. */
	PacketInMask         []uint32 `protobuf:"varint,1,rep,packed,name=packet_in_mask,json=packetInMask,proto3" json:"packet_in_mask,omitempty"`
	PortStatusMask       []uint32 `protobuf:"varint,2,rep,packed,name=port_status_mask,json=portStatusMask,proto3" json:"port_status_mask,omitempty"`
	FlowRemovedMask      []uint32 `protobuf:"varint,3,rep,packed,name=flow_removed_mask,json=flowRemovedMask,proto3" json:"flow_removed_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OfpAsyncConfig) Reset()         { *m = OfpAsyncConfig{} }
func (m *OfpAsyncConfig) String() string { return proto.CompactTextString(m) }
func (*OfpAsyncConfig) ProtoMessage()    {}
func (*OfpAsyncConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{84}
}

func (m *OfpAsyncConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OfpAsyncConfig.Unmarshal(m, b)
}
func (m *OfpAsyncConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OfpAsyncConfig.Marshal(b, m, deterministic)
}
func (m *OfpAsyncConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfpAsyncConfig.Merge(m, src)
}
func (m *OfpAsyncConfig) XXX_Size() int {
	return xxx_messageInfo_OfpAsyncConfig.Size(m)
}
func (m *OfpAsyncConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OfpAsyncConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OfpAsyncConfig proto.InternalMessageInfo

func (m *OfpAsyncConfig) GetPacketInMask() []uint32 {
	if m != nil {
		return m.PacketInMask
	}
	return nil
}

func (m *OfpAsyncConfig) GetPortStatusMask() []uint32 {
	if m != nil {
		return m.PortStatusMask
	}
	return nil
}

func (m *OfpAsyncConfig) GetFlowRemovedMask() []uint32 {
	if m != nil {
		return m.FlowRemovedMask
	}
	return nil
}

type MeterModUpdate struct {
	Id                   string       `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	MeterMod             *OfpMeterMod `protobuf:"bytes,2,opt,name=meter_mod,json=meterMod,proto3" json:"meter_mod,omitempty"`
	Xid                  uint32       `protobuf:"varint,3,opt,name=xid,proto3" json:"xid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *MeterModUpdate) Reset()         { *m = MeterModUpdate{} }
func (m *MeterModUpdate) String() string { return proto.CompactTextString(m) }
func (*MeterModUpdate) ProtoMessage()    {}
func (*MeterModUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{85}
}

func (m *MeterModUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MeterModUpdate.Unmarshal(m, b)
}
func (m *MeterModUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MeterModUpdate.Marshal(b, m, deterministic)
}
func (m *MeterModUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeterModUpdate.Merge(m, src)
}
func (m *MeterModUpdate) XXX_Size() int {
	return xxx_messageInfo_MeterModUpdate.Size(m)
}
func (m *MeterModUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_MeterModUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_MeterModUpdate proto.InternalMessageInfo

func (m *MeterModUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *MeterModUpdate) GetMeterMod() *OfpMeterMod {
	if m != nil {
		return m.MeterMod
	}
	return nil
}

func (m *MeterModUpdate) GetXid() uint32 {
	if m != nil {
		return m.Xid
	}
	return 0
}

type MeterStatsReply struct {
	MeterStats           []*OfpMeterStats `protobuf:"bytes,1,rep,name=meter_stats,json=meterStats,proto3" json:"meter_stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *MeterStatsReply) Reset()         { *m = MeterStatsReply{} }
func (m *MeterStatsReply) String() string { return proto.CompactTextString(m) }
func (*MeterStatsReply) ProtoMessage()    {}
func (*MeterStatsReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{86}
}

func (m *MeterStatsReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MeterStatsReply.Unmarshal(m, b)
}
func (m *MeterStatsReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MeterStatsReply.Marshal(b, m, deterministic)
}
func (m *MeterStatsReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeterStatsReply.Merge(m, src)
}
func (m *MeterStatsReply) XXX_Size() int {
	return xxx_messageInfo_MeterStatsReply.Size(m)
}
func (m *MeterStatsReply) XXX_DiscardUnknown() {
	xxx_messageInfo_MeterStatsReply.DiscardUnknown(m)
}

var xxx_messageInfo_MeterStatsReply proto.InternalMessageInfo

func (m *MeterStatsReply) GetMeterStats() []*OfpMeterStats {
	if m != nil {
		return m.MeterStats
	}
	return nil
}

type FlowTableUpdate struct {
	Id                   string      `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	FlowMod              *OfpFlowMod `protobuf:"bytes,2,opt,name=flow_mod,json=flowMod,proto3" json:"flow_mod,omitempty"`
	Xid                  uint32      `protobuf:"varint,3,opt,name=xid,proto3" json:"xid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *FlowTableUpdate) Reset()         { *m = FlowTableUpdate{} }
func (m *FlowTableUpdate) String() string { return proto.CompactTextString(m) }
func (*FlowTableUpdate) ProtoMessage()    {}
func (*FlowTableUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{87}
}

func (m *FlowTableUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FlowTableUpdate.Unmarshal(m, b)
}
func (m *FlowTableUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FlowTableUpdate.Marshal(b, m, deterministic)
}
func (m *FlowTableUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlowTableUpdate.Merge(m, src)
}
func (m *FlowTableUpdate) XXX_Size() int {
	return xxx_messageInfo_FlowTableUpdate.Size(m)
}
func (m *FlowTableUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_FlowTableUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_FlowTableUpdate proto.InternalMessageInfo

func (m *FlowTableUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *FlowTableUpdate) GetFlowMod() *OfpFlowMod {
	if m != nil {
		return m.FlowMod
	}
	return nil
}

func (m *FlowTableUpdate) GetXid() uint32 {
	if m != nil {
		return m.Xid
	}
	return 0
}

type FlowGroupTableUpdate struct {
	Id                   string       `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	GroupMod             *OfpGroupMod `protobuf:"bytes,2,opt,name=group_mod,json=groupMod,proto3" json:"group_mod,omitempty"`
	Xid                  uint32       `protobuf:"varint,3,opt,name=xid,proto3" json:"xid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *FlowGroupTableUpdate) Reset()         { *m = FlowGroupTableUpdate{} }
func (m *FlowGroupTableUpdate) String() string { return proto.CompactTextString(m) }
func (*FlowGroupTableUpdate) ProtoMessage()    {}
func (*FlowGroupTableUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{88}
}

func (m *FlowGroupTableUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FlowGroupTableUpdate.Unmarshal(m, b)
}
func (m *FlowGroupTableUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FlowGroupTableUpdate.Marshal(b, m, deterministic)
}
func (m *FlowGroupTableUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlowGroupTableUpdate.Merge(m, src)
}
func (m *FlowGroupTableUpdate) XXX_Size() int {
	return xxx_messageInfo_FlowGroupTableUpdate.Size(m)
}
func (m *FlowGroupTableUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_FlowGroupTableUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_FlowGroupTableUpdate proto.InternalMessageInfo

func (m *FlowGroupTableUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *FlowGroupTableUpdate) GetGroupMod() *OfpGroupMod {
	if m != nil {
		return m.GroupMod
	}
	return nil
}

func (m *FlowGroupTableUpdate) GetXid() uint32 {
	if m != nil {
		return m.Xid
	}
	return 0
}

type Flows struct {
	Items                []*OfpFlowStats `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Flows) Reset()         { *m = Flows{} }
func (m *Flows) String() string { return proto.CompactTextString(m) }
func (*Flows) ProtoMessage()    {}
func (*Flows) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{89}
}

func (m *Flows) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Flows.Unmarshal(m, b)
}
func (m *Flows) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Flows.Marshal(b, m, deterministic)
}
func (m *Flows) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Flows.Merge(m, src)
}
func (m *Flows) XXX_Size() int {
	return xxx_messageInfo_Flows.Size(m)
}
func (m *Flows) XXX_DiscardUnknown() {
	xxx_messageInfo_Flows.DiscardUnknown(m)
}

var xxx_messageInfo_Flows proto.InternalMessageInfo

func (m *Flows) GetItems() []*OfpFlowStats {
	if m != nil {
		return m.Items
	}
	return nil
}

type Meters struct {
	Items                []*OfpMeterEntry `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Meters) Reset()         { *m = Meters{} }
func (m *Meters) String() string { return proto.CompactTextString(m) }
func (*Meters) ProtoMessage()    {}
func (*Meters) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{90}
}

func (m *Meters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Meters.Unmarshal(m, b)
}
func (m *Meters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Meters.Marshal(b, m, deterministic)
}
func (m *Meters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Meters.Merge(m, src)
}
func (m *Meters) XXX_Size() int {
	return xxx_messageInfo_Meters.Size(m)
}
func (m *Meters) XXX_DiscardUnknown() {
	xxx_messageInfo_Meters.DiscardUnknown(m)
}

var xxx_messageInfo_Meters proto.InternalMessageInfo

func (m *Meters) GetItems() []*OfpMeterEntry {
	if m != nil {
		return m.Items
	}
	return nil
}

type FlowGroups struct {
	Items                []*OfpGroupEntry `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *FlowGroups) Reset()         { *m = FlowGroups{} }
func (m *FlowGroups) String() string { return proto.CompactTextString(m) }
func (*FlowGroups) ProtoMessage()    {}
func (*FlowGroups) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{91}
}

func (m *FlowGroups) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FlowGroups.Unmarshal(m, b)
}
func (m *FlowGroups) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FlowGroups.Marshal(b, m, deterministic)
}
func (m *FlowGroups) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlowGroups.Merge(m, src)
}
func (m *FlowGroups) XXX_Size() int {
	return xxx_messageInfo_FlowGroups.Size(m)
}
func (m *FlowGroups) XXX_DiscardUnknown() {
	xxx_messageInfo_FlowGroups.DiscardUnknown(m)
}

var xxx_messageInfo_FlowGroups proto.InternalMessageInfo

func (m *FlowGroups) GetItems() []*OfpGroupEntry {
	if m != nil {
		return m.Items
	}
	return nil
}

type FlowChanges struct {
	ToAdd                *Flows   `protobuf:"bytes,1,opt,name=to_add,json=toAdd,proto3" json:"to_add,omitempty"`
	ToRemove             *Flows   `protobuf:"bytes,2,opt,name=to_remove,json=toRemove,proto3" json:"to_remove,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FlowChanges) Reset()         { *m = FlowChanges{} }
func (m *FlowChanges) String() string { return proto.CompactTextString(m) }
func (*FlowChanges) ProtoMessage()    {}
func (*FlowChanges) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{92}
}

func (m *FlowChanges) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FlowChanges.Unmarshal(m, b)
}
func (m *FlowChanges) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FlowChanges.Marshal(b, m, deterministic)
}
func (m *FlowChanges) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlowChanges.Merge(m, src)
}
func (m *FlowChanges) XXX_Size() int {
	return xxx_messageInfo_FlowChanges.Size(m)
}
func (m *FlowChanges) XXX_DiscardUnknown() {
	xxx_messageInfo_FlowChanges.DiscardUnknown(m)
}

var xxx_messageInfo_FlowChanges proto.InternalMessageInfo

func (m *FlowChanges) GetToAdd() *Flows {
	if m != nil {
		return m.ToAdd
	}
	return nil
}

func (m *FlowChanges) GetToRemove() *Flows {
	if m != nil {
		return m.ToRemove
	}
	return nil
}

type FlowGroupChanges struct {
	ToAdd                *FlowGroups `protobuf:"bytes,1,opt,name=to_add,json=toAdd,proto3" json:"to_add,omitempty"`
	ToRemove             *FlowGroups `protobuf:"bytes,2,opt,name=to_remove,json=toRemove,proto3" json:"to_remove,omitempty"`
	ToUpdate             *FlowGroups `protobuf:"bytes,3,opt,name=to_update,json=toUpdate,proto3" json:"to_update,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *FlowGroupChanges) Reset()         { *m = FlowGroupChanges{} }
func (m *FlowGroupChanges) String() string { return proto.CompactTextString(m) }
func (*FlowGroupChanges) ProtoMessage()    {}
func (*FlowGroupChanges) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{93}
}

func (m *FlowGroupChanges) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FlowGroupChanges.Unmarshal(m, b)
}
func (m *FlowGroupChanges) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FlowGroupChanges.Marshal(b, m, deterministic)
}
func (m *FlowGroupChanges) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlowGroupChanges.Merge(m, src)
}
func (m *FlowGroupChanges) XXX_Size() int {
	return xxx_messageInfo_FlowGroupChanges.Size(m)
}
func (m *FlowGroupChanges) XXX_DiscardUnknown() {
	xxx_messageInfo_FlowGroupChanges.DiscardUnknown(m)
}

var xxx_messageInfo_FlowGroupChanges proto.InternalMessageInfo

func (m *FlowGroupChanges) GetToAdd() *FlowGroups {
	if m != nil {
		return m.ToAdd
	}
	return nil
}

func (m *FlowGroupChanges) GetToRemove() *FlowGroups {
	if m != nil {
		return m.ToRemove
	}
	return nil
}

func (m *FlowGroupChanges) GetToUpdate() *FlowGroups {
	if m != nil {
		return m.ToUpdate
	}
	return nil
}

type PacketIn struct {
	Id                   string       `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	PacketIn             *OfpPacketIn `protobuf:"bytes,2,opt,name=packet_in,json=packetIn,proto3" json:"packet_in,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PacketIn) Reset()         { *m = PacketIn{} }
func (m *PacketIn) String() string { return proto.CompactTextString(m) }
func (*PacketIn) ProtoMessage()    {}
func (*PacketIn) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{94}
}

func (m *PacketIn) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PacketIn.Unmarshal(m, b)
}
func (m *PacketIn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PacketIn.Marshal(b, m, deterministic)
}
func (m *PacketIn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PacketIn.Merge(m, src)
}
func (m *PacketIn) XXX_Size() int {
	return xxx_messageInfo_PacketIn.Size(m)
}
func (m *PacketIn) XXX_DiscardUnknown() {
	xxx_messageInfo_PacketIn.DiscardUnknown(m)
}

var xxx_messageInfo_PacketIn proto.InternalMessageInfo

func (m *PacketIn) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PacketIn) GetPacketIn() *OfpPacketIn {
	if m != nil {
		return m.PacketIn
	}
	return nil
}

type PacketOut struct {
	Id                   string        `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	PacketOut            *OfpPacketOut `protobuf:"bytes,2,opt,name=packet_out,json=packetOut,proto3" json:"packet_out,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *PacketOut) Reset()         { *m = PacketOut{} }
func (m *PacketOut) String() string { return proto.CompactTextString(m) }
func (*PacketOut) ProtoMessage()    {}
func (*PacketOut) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{95}
}

func (m *PacketOut) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PacketOut.Unmarshal(m, b)
}
func (m *PacketOut) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PacketOut.Marshal(b, m, deterministic)
}
func (m *PacketOut) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PacketOut.Merge(m, src)
}
func (m *PacketOut) XXX_Size() int {
	return xxx_messageInfo_PacketOut.Size(m)
}
func (m *PacketOut) XXX_DiscardUnknown() {
	xxx_messageInfo_PacketOut.DiscardUnknown(m)
}

var xxx_messageInfo_PacketOut proto.InternalMessageInfo

func (m *PacketOut) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PacketOut) GetPacketOut() *OfpPacketOut {
	if m != nil {
		return m.PacketOut
	}
	return nil
}

type ChangeEvent struct {
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Types that are valid to be assigned to Event:
	//	*ChangeEvent_PortStatus
	//	*ChangeEvent_Error
	Event                isChangeEvent_Event `protobuf_oneof:"event"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ChangeEvent) Reset()         { *m = ChangeEvent{} }
func (m *ChangeEvent) String() string { return proto.CompactTextString(m) }
func (*ChangeEvent) ProtoMessage()    {}
func (*ChangeEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_08e3a4e375aeddc7, []int{96}
}

func (m *ChangeEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChangeEvent.Unmarshal(m, b)
}
func (m *ChangeEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChangeEvent.Marshal(b, m, deterministic)
}
func (m *ChangeEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChangeEvent.Merge(m, src)
}
func (m *ChangeEvent) XXX_Size() int {
	return xxx_messageInfo_ChangeEvent.Size(m)
}
func (m *ChangeEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ChangeEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ChangeEvent proto.InternalMessageInfo

func (m *ChangeEvent) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type isChangeEvent_Event interface {
	isChangeEvent_Event()
}

type ChangeEvent_PortStatus struct {
	PortStatus *OfpPortStatus `protobuf:"bytes,2,opt,name=port_status,json=portStatus,proto3,oneof"`
}

type ChangeEvent_Error struct {
	Error *OfpErrorMsg `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*ChangeEvent_PortStatus) isChangeEvent_Event() {}

func (*ChangeEvent_Error) isChangeEvent_Event() {}

func (m *ChangeEvent) GetEvent() isChangeEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *ChangeEvent) GetPortStatus() *OfpPortStatus {
	if x, ok := m.GetEvent().(*ChangeEvent_PortStatus); ok {
		return x.PortStatus
	}
	return nil
}

func (m *ChangeEvent) GetError() *OfpErrorMsg {
	if x, ok := m.GetEvent().(*ChangeEvent_Error); ok {
		return x.Error
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ChangeEvent) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ChangeEvent_PortStatus)(nil),
		(*ChangeEvent_Error)(nil),
	}
}

func init() {
	proto.RegisterEnum("openflow_13.OfpPortNo", OfpPortNo_name, OfpPortNo_value)
	proto.RegisterEnum("openflow_13.OfpType", OfpType_name, OfpType_value)
	proto.RegisterEnum("openflow_13.OfpHelloElemType", OfpHelloElemType_name, OfpHelloElemType_value)
	proto.RegisterEnum("openflow_13.OfpConfigFlags", OfpConfigFlags_name, OfpConfigFlags_value)
	proto.RegisterEnum("openflow_13.OfpTableConfig", OfpTableConfig_name, OfpTableConfig_value)
	proto.RegisterEnum("openflow_13.OfpTable", OfpTable_name, OfpTable_value)
	proto.RegisterEnum("openflow_13.OfpCapabilities", OfpCapabilities_name, OfpCapabilities_value)
	proto.RegisterEnum("openflow_13.OfpPortConfig", OfpPortConfig_name, OfpPortConfig_value)
	proto.RegisterEnum("openflow_13.OfpPortState", OfpPortState_name, OfpPortState_value)
	proto.RegisterEnum("openflow_13.OfpPortFeatures", OfpPortFeatures_name, OfpPortFeatures_value)
	proto.RegisterEnum("openflow_13.OfpPortReason", OfpPortReason_name, OfpPortReason_value)
	proto.RegisterEnum("openflow_13.OfpMatchType", OfpMatchType_name, OfpMatchType_value)
	proto.RegisterEnum("openflow_13.OfpOxmClass", OfpOxmClass_name, OfpOxmClass_value)
	proto.RegisterEnum("openflow_13.OxmOfbFieldTypes", OxmOfbFieldTypes_name, OxmOfbFieldTypes_value)
	proto.RegisterEnum("openflow_13.OfpVlanId", OfpVlanId_name, OfpVlanId_value)
	proto.RegisterEnum("openflow_13.OfpIpv6ExthdrFlags", OfpIpv6ExthdrFlags_name, OfpIpv6ExthdrFlags_value)
	proto.RegisterEnum("openflow_13.OfpActionType", OfpActionType_name, OfpActionType_value)
	proto.RegisterEnum("openflow_13.OfpControllerMaxLen", OfpControllerMaxLen_name, OfpControllerMaxLen_value)
	proto.RegisterEnum("openflow_13.OfpInstructionType", OfpInstructionType_name, OfpInstructionType_value)
	proto.RegisterEnum("openflow_13.OfpFlowModCommand", OfpFlowModCommand_name, OfpFlowModCommand_value)
	proto.RegisterEnum("openflow_13.OfpFlowModFlags", OfpFlowModFlags_name, OfpFlowModFlags_value)
	proto.RegisterEnum("openflow_13.OfpGroup", OfpGroup_name, OfpGroup_value)
	proto.RegisterEnum("openflow_13.OfpGroupModCommand", OfpGroupModCommand_name, OfpGroupModCommand_value)
	proto.RegisterEnum("openflow_13.OfpGroupType", OfpGroupType_name, OfpGroupType_value)
	proto.RegisterEnum("openflow_13.OfpPacketInReason", OfpPacketInReason_name, OfpPacketInReason_value)
	proto.RegisterEnum("openflow_13.OfpFlowRemovedReason", OfpFlowRemovedReason_name, OfpFlowRemovedReason_value)
	proto.RegisterEnum("openflow_13.OfpMeter", OfpMeter_name, OfpMeter_value)
	proto.RegisterEnum("openflow_13.OfpMeterBandType", OfpMeterBandType_name, OfpMeterBandType_value)
	proto.RegisterEnum("openflow_13.OfpMeterModCommand", OfpMeterModCommand_name, OfpMeterModCommand_value)
	proto.RegisterEnum("openflow_13.OfpMeterFlags", OfpMeterFlags_name, OfpMeterFlags_value)
	proto.RegisterEnum("openflow_13.OfpErrorType", OfpErrorType_name, OfpErrorType_value)
	proto.RegisterEnum("openflow_13.OfpHelloFailedCode", OfpHelloFailedCode_name, OfpHelloFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpBadRequestCode", OfpBadRequestCode_name, OfpBadRequestCode_value)
	proto.RegisterEnum("openflow_13.OfpBadActionCode", OfpBadActionCode_name, OfpBadActionCode_value)
	proto.RegisterEnum("openflow_13.OfpBadInstructionCode", OfpBadInstructionCode_name, OfpBadInstructionCode_value)
	proto.RegisterEnum("openflow_13.OfpBadMatchCode", OfpBadMatchCode_name, OfpBadMatchCode_value)
	proto.RegisterEnum("openflow_13.OfpFlowModFailedCode", OfpFlowModFailedCode_name, OfpFlowModFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpGroupModFailedCode", OfpGroupModFailedCode_name, OfpGroupModFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpPortModFailedCode", OfpPortModFailedCode_name, OfpPortModFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpTableModFailedCode", OfpTableModFailedCode_name, OfpTableModFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpQueueOpFailedCode", OfpQueueOpFailedCode_name, OfpQueueOpFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpSwitchConfigFailedCode", OfpSwitchConfigFailedCode_name, OfpSwitchConfigFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpRoleRequestFailedCode", OfpRoleRequestFailedCode_name, OfpRoleRequestFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpMeterModFailedCode", OfpMeterModFailedCode_name, OfpMeterModFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpTableFeaturesFailedCode", OfpTableFeaturesFailedCode_name, OfpTableFeaturesFailedCode_value)
	proto.RegisterEnum("openflow_13.OfpMultipartType", OfpMultipartType_name, OfpMultipartType_value)
	proto.RegisterEnum("openflow_13.OfpMultipartRequestFlags", OfpMultipartRequestFlags_name, OfpMultipartRequestFlags_value)
	proto.RegisterEnum("openflow_13.OfpMultipartReplyFlags", OfpMultipartReplyFlags_name, OfpMultipartReplyFlags_value)
	proto.RegisterEnum("openflow_13.OfpTableFeaturePropType", OfpTableFeaturePropType_name, OfpTableFeaturePropType_value)
	proto.RegisterEnum("openflow_13.OfpGroupCapabilities", OfpGroupCapabilities_name, OfpGroupCapabilities_value)
	proto.RegisterEnum("openflow_13.OfpQueueProperties", OfpQueueProperties_name, OfpQueueProperties_value)
	proto.RegisterEnum("openflow_13.OfpControllerRole", OfpControllerRole_name, OfpControllerRole_value)
	proto.RegisterType((*OfpHeader)(nil), "openflow_13.ofp_header")
	proto.RegisterType((*OfpHelloElemHeader)(nil), "openflow_13.ofp_hello_elem_header")
	proto.RegisterType((*OfpHelloElemVersionbitmap)(nil), "openflow_13.ofp_hello_elem_versionbitmap")
	proto.RegisterType((*OfpHello)(nil), "openflow_13.ofp_hello")
	proto.RegisterType((*OfpSwitchConfig)(nil), "openflow_13.ofp_switch_config")
	proto.RegisterType((*OfpTableMod)(nil), "openflow_13.ofp_table_mod")
	proto.RegisterType((*OfpPort)(nil), "openflow_13.ofp_port")
	proto.RegisterType((*OfpSwitchFeatures)(nil), "openflow_13.ofp_switch_features")
	proto.RegisterType((*OfpPortStatus)(nil), "openflow_13.ofp_port_status")
	proto.RegisterType((*OfpPortMod)(nil), "openflow_13.ofp_port_mod")
	proto.RegisterType((*OfpMatch)(nil), "openflow_13.ofp_match")
	proto.RegisterType((*OfpOxmField)(nil), "openflow_13.ofp_oxm_field")
	proto.RegisterType((*OfpOxmOfbField)(nil), "openflow_13.ofp_oxm_ofb_field")
	proto.RegisterType((*OfpOxmExperimenterField)(nil), "openflow_13.ofp_oxm_experimenter_field")
	proto.RegisterType((*OfpAction)(nil), "openflow_13.ofp_action")
	proto.RegisterType((*OfpActionOutput)(nil), "openflow_13.ofp_action_output")
	proto.RegisterType((*OfpActionMplsTtl)(nil), "openflow_13.ofp_action_mpls_ttl")
	proto.RegisterType((*OfpActionPush)(nil), "openflow_13.ofp_action_push")
	proto.RegisterType((*OfpActionPopMpls)(nil), "openflow_13.ofp_action_pop_mpls")
	proto.RegisterType((*OfpActionGroup)(nil), "openflow_13.ofp_action_group")
	proto.RegisterType((*OfpActionNwTtl)(nil), "openflow_13.ofp_action_nw_ttl")
	proto.RegisterType((*OfpActionSetField)(nil), "openflow_13.ofp_action_set_field")
	proto.RegisterType((*OfpActionExperimenter)(nil), "openflow_13.ofp_action_experimenter")
	proto.RegisterType((*OfpInstruction)(nil), "openflow_13.ofp_instruction")
	proto.RegisterType((*OfpInstructionGotoTable)(nil), "openflow_13.ofp_instruction_goto_table")
	proto.RegisterType((*OfpInstructionWriteMetadata)(nil), "openflow_13.ofp_instruction_write_metadata")
	proto.RegisterType((*OfpInstructionActions)(nil), "openflow_13.ofp_instruction_actions")
	proto.RegisterType((*OfpInstructionMeter)(nil), "openflow_13.ofp_instruction_meter")
	proto.RegisterType((*OfpInstructionExperimenter)(nil), "openflow_13.ofp_instruction_experimenter")
	proto.RegisterType((*OfpFlowMod)(nil), "openflow_13.ofp_flow_mod")
	proto.RegisterType((*OfpBucket)(nil), "openflow_13.ofp_bucket")
	proto.RegisterType((*OfpGroupMod)(nil), "openflow_13.ofp_group_mod")
	proto.RegisterType((*OfpPacketOut)(nil), "openflow_13.ofp_packet_out")
	proto.RegisterType((*OfpPacketIn)(nil), "openflow_13.ofp_packet_in")
	proto.RegisterType((*OfpFlowRemoved)(nil), "openflow_13.ofp_flow_removed")
	proto.RegisterType((*OfpMeterBandHeader)(nil), "openflow_13.ofp_meter_band_header")
	proto.RegisterType((*OfpMeterBandDrop)(nil), "openflow_13.ofp_meter_band_drop")
	proto.RegisterType((*OfpMeterBandDscpRemark)(nil), "openflow_13.ofp_meter_band_dscp_remark")
	proto.RegisterType((*OfpMeterBandExperimenter)(nil), "openflow_13.ofp_meter_band_experimenter")
	proto.RegisterType((*OfpMeterMod)(nil), "openflow_13.ofp_meter_mod")
	proto.RegisterType((*OfpErrorMsg)(nil), "openflow_13.ofp_error_msg")
	proto.RegisterType((*OfpErrorExperimenterMsg)(nil), "openflow_13.ofp_error_experimenter_msg")
	proto.RegisterType((*OfpMultipartRequest)(nil), "openflow_13.ofp_multipart_request")
	proto.RegisterType((*OfpMultipartReply)(nil), "openflow_13.ofp_multipart_reply")
	proto.RegisterType((*OfpDesc)(nil), "openflow_13.ofp_desc")
	proto.RegisterType((*OfpFlowStatsRequest)(nil), "openflow_13.ofp_flow_stats_request")
	proto.RegisterType((*OfpFlowStats)(nil), "openflow_13.ofp_flow_stats")
	proto.RegisterType((*OfpAggregateStatsRequest)(nil), "openflow_13.ofp_aggregate_stats_request")
	proto.RegisterType((*OfpAggregateStatsReply)(nil), "openflow_13.ofp_aggregate_stats_reply")
	proto.RegisterType((*OfpTableFeatureProperty)(nil), "openflow_13.ofp_table_feature_property")
	proto.RegisterType((*OfpTableFeaturePropInstructions)(nil), "openflow_13.ofp_table_feature_prop_instructions")
	proto.RegisterType((*OfpTableFeaturePropNextTables)(nil), "openflow_13.ofp_table_feature_prop_next_tables")
	proto.RegisterType((*OfpTableFeaturePropActions)(nil), "openflow_13.ofp_table_feature_prop_actions")
	proto.RegisterType((*OfpTableFeaturePropOxm)(nil), "openflow_13.ofp_table_feature_prop_oxm")
	proto.RegisterType((*OfpTableFeaturePropExperimenter)(nil), "openflow_13.ofp_table_feature_prop_experimenter")
	proto.RegisterType((*OfpTableFeatures)(nil), "openflow_13.ofp_table_features")
	proto.RegisterType((*OfpTableStats)(nil), "openflow_13.ofp_table_stats")
	proto.RegisterType((*OfpPortStatsRequest)(nil), "openflow_13.ofp_port_stats_request")
	proto.RegisterType((*OfpPortStats)(nil), "openflow_13.ofp_port_stats")
	proto.RegisterType((*OfpGroupStatsRequest)(nil), "openflow_13.ofp_group_stats_request")
	proto.RegisterType((*OfpBucketCounter)(nil), "openflow_13.ofp_bucket_counter")
	proto.RegisterType((*OfpGroupStats)(nil), "openflow_13.ofp_group_stats")
	proto.RegisterType((*OfpGroupDesc)(nil), "openflow_13.ofp_group_desc")
	proto.RegisterType((*OfpGroupEntry)(nil), "openflow_13.ofp_group_entry")
	proto.RegisterType((*OfpGroupFeatures)(nil), "openflow_13.ofp_group_features")
	proto.RegisterType((*OfpMeterMultipartRequest)(nil), "openflow_13.ofp_meter_multipart_request")
	proto.RegisterType((*OfpMeterBandStats)(nil), "openflow_13.ofp_meter_band_stats")
	proto.RegisterType((*OfpMeterStats)(nil), "openflow_13.ofp_meter_stats")
	proto.RegisterType((*OfpMeterConfig)(nil), "openflow_13.ofp_meter_config")
	proto.RegisterType((*OfpMeterFeatures)(nil), "openflow_13.ofp_meter_features")
	proto.RegisterType((*OfpMeterEntry)(nil), "openflow_13.ofp_meter_entry")
	proto.RegisterType((*OfpExperimenterMultipartHeader)(nil), "openflow_13.ofp_experimenter_multipart_header")
	proto.RegisterType((*OfpExperimenterHeader)(nil), "openflow_13.ofp_experimenter_header")
	proto.RegisterType((*OfpQueuePropHeader)(nil), "openflow_13.ofp_queue_prop_header")
	proto.RegisterType((*OfpQueuePropMinRate)(nil), "openflow_13.ofp_queue_prop_min_rate")
	proto.RegisterType((*OfpQueuePropMaxRate)(nil), "openflow_13.ofp_queue_prop_max_rate")
	proto.RegisterType((*OfpQueuePropExperimenter)(nil), "openflow_13.ofp_queue_prop_experimenter")
	proto.RegisterType((*OfpPacketQueue)(nil), "openflow_13.ofp_packet_queue")
	proto.RegisterType((*OfpQueueGetConfigRequest)(nil), "openflow_13.ofp_queue_get_config_request")
	proto.RegisterType((*OfpQueueGetConfigReply)(nil), "openflow_13.ofp_queue_get_config_reply")
	proto.RegisterType((*OfpActionSetQueue)(nil), "openflow_13.ofp_action_set_queue")
	proto.RegisterType((*OfpQueueStatsRequest)(nil), "openflow_13.ofp_queue_stats_request")
	proto.RegisterType((*OfpQueueStats)(nil), "openflow_13.ofp_queue_stats")
	proto.RegisterType((*OfpRoleRequest)(nil), "openflow_13.ofp_role_request")
	proto.RegisterType((*OfpAsyncConfig)(nil), "openflow_13.ofp_async_config")
	proto.RegisterType((*MeterModUpdate)(nil), "openflow_13.MeterModUpdate")
	proto.RegisterType((*MeterStatsReply)(nil), "openflow_13.MeterStatsReply")
	proto.RegisterType((*FlowTableUpdate)(nil), "openflow_13.FlowTableUpdate")
	proto.RegisterType((*FlowGroupTableUpdate)(nil), "openflow_13.FlowGroupTableUpdate")
	proto.RegisterType((*Flows)(nil), "openflow_13.Flows")
	proto.RegisterType((*Meters)(nil), "openflow_13.Meters")
	proto.RegisterType((*FlowGroups)(nil), "openflow_13.FlowGroups")
	proto.RegisterType((*FlowChanges)(nil), "openflow_13.FlowChanges")
	proto.RegisterType((*FlowGroupChanges)(nil), "openflow_13.FlowGroupChanges")
	proto.RegisterType((*PacketIn)(nil), "openflow_13.PacketIn")
	proto.RegisterType((*PacketOut)(nil), "openflow_13.PacketOut")
	proto.RegisterType((*ChangeEvent)(nil), "openflow_13.ChangeEvent")
}

func init() { proto.RegisterFile("voltha_protos/openflow_13.proto", fileDescriptor_08e3a4e375aeddc7) }

var fileDescriptor_08e3a4e375aeddc7 = []byte{
	// 8470 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x7d, 0x5b, 0x8c, 0x1c, 0x59,
	0x96, 0x90, 0xf3, 0x51, 0x55, 0x99, 0x37, 0xab, 0xca, 0xe1, 0xf0, 0x2b, 0xed, 0xb2, 0xdb, 0x76,
	0x76, 0xf7, 0x4c, 0x4f, 0x0e, 0xdb, 0x6e, 0xbb, 0x3d, 0x9e, 0xd9, 0x79, 0x2c, 0x8e, 0xcc, 0x8c,
	0xac, 0xcc, 0x76, 0xbe, 0x1c, 0x11, 0x55, 0xb6, 0x07, 0x41, 0x28, 0x2b, 0x33, 0x5c, 0x95, 0xeb,
	0xcc, 0x8c, 0x9c, 0x88, 0xa8, 0x72, 0x79, 0x99, 0x45, 0x86, 0x15, 0x42, 0x02, 0x76, 0x17, 0xb4,
	0x1f, 0x23, 0xc1, 0x22, 0xb1, 0x02, 0x3e, 0x10, 0x12, 0x1f, 0x48, 0x48, 0x48, 0x7c, 0xaf, 0x04,
	0x12, 0x02, 0x69, 0x25, 0xb4, 0x3f, 0xbb, 0x7f, 0xcb, 0x0f, 0xd2, 0xfe, 0xc3, 0x32, 0x8c, 0xd1,
	0xb9, 0xe7, 0xdc, 0x1b, 0x37, 0xf2, 0x51, 0x5d, 0x33, 0xf4, 0xf0, 0xc1, 0x97, 0x33, 0xce, 0xeb,
	0x9e, 0x7b, 0xee, 0x39, 0xe7, 0x9e, 0x7b, 0xe2, 0x46, 0x99, 0xdd, 0x39, 0xf1, 0xc7, 0xd1, 0x51,
	0xdf, 0x9d, 0x05, 0x7e, 0xe4, 0x87, 0xf7, 0xfd, 0x99, 0x37, 0x7d, 0x35, 0xf6, 0xdf, 0xb8, 0x0f,
	0x3e, 0xff, 0x94, 0x83, 0xf4, 0x82, 0x02, 0xba, 0x79, 0xeb, 0xd0, 0xf7, 0x0f, 0xc7, 0xde, 0xfd,
	0xfe, 0x6c, 0x74, 0xbf, 0x3f, 0x9d, 0xfa, 0x51, 0x3f, 0x1a, 0xf9, 0xd3, 0x10, 0x49, 0x4b, 0x03,
	0xc6, 0xfc, 0x57, 0x33, 0xf7, 0xc8, 0xeb, 0x0f, 0xbd, 0x40, 0x2f, 0xb2, 0x8d, 0x13, 0x2f, 0x08,
	0x47, 0xfe, 0xb4, 0x98, 0xba, 0x9b, 0xfa, 0x64, 0xcb, 0x12, 0x8f, 0xfa, 0x37, 0x58, 0x36, 0x7a,
	0x3b, 0xf3, 0x8a, 0xe9, 0xbb, 0xa9, 0x4f, 0xb6, 0x1f, 0x5e, 0xfd, 0x54, 0x1d, 0x14, 0x04, 0x00,
	0xd2, 0xe2, 0x24, 0xba, 0xc6, 0x32, 0xa7, 0xa3, 0x61, 0x31, 0xc3, 0x05, 0xc0, 0xcf, 0xd2, 0xbf,
	0x4a, 0xb1, 0xab, 0x38, 0xca, 0x78, 0xec, 0xbb, 0xde, 0xd8, 0x9b, 0x88, 0x01, 0x1f, 0x91, 0xd8,
	0x14, 0x17, 0x7b, 0x77, 0x41, 0xac, 0xc2, 0xa1, 0x8c, 0xf0, 0x8c, 0x6d, 0x91, 0x5e, 0x07, 0xa3,
	0x68, 0xd2, 0x9f, 0x71, 0xad, 0x0a, 0x0f, 0xbf, 0x71, 0x16, 0x7b, 0x82, 0xa1, 0x71, 0xc1, 0x4a,
	0x4a, 0xa8, 0xe4, 0xd9, 0x06, 0x90, 0x79, 0xd3, 0xa8, 0xf4, 0x1d, 0x76, 0xeb, 0x2c, 0x5e, 0x30,
	0x12, 0xfe, 0x0a, 0x8b, 0xe9, 0xbb, 0x19, 0x30, 0x12, 0x3d, 0x96, 0x9e, 0xb2, 0xbc, 0xe4, 0xd4,
	0x7f, 0x8d, 0xe5, 0x48, 0x62, 0x58, 0x4c, 0xdd, 0xcd, 0x7c, 0x52, 0x78, 0x58, 0x3a, 0x4b, 0x3f,
	0x34, 0x88, 0x25, 0x79, 0x4a, 0x6d, 0x76, 0x09, 0x48, 0xc2, 0x37, 0xa3, 0x68, 0x70, 0xe4, 0x0e,
	0xfc, 0xe9, 0xab, 0xd1, 0xa1, 0x7e, 0x85, 0xad, 0xbd, 0x1a, 0xf7, 0x0f, 0x43, 0x5a, 0x1e, 0x7c,
	0xd0, 0x4b, 0x6c, 0x6b, 0x32, 0x0a, 0x43, 0x37, 0xf4, 0xa6, 0x43, 0x77, 0xec, 0x4d, 0xb9, 0x3d,
	0xb6, 0xac, 0x02, 0x00, 0x6d, 0x6f, 0x3a, 0x6c, 0x79, 0xd3, 0x52, 0x85, 0x6d, 0xf1, 0x75, 0xea,
	0x1f, 0x8c, 0x3d, 0x77, 0xe2, 0x0f, 0xf5, 0x1b, 0x2c, 0x87, 0x0f, 0xa3, 0xa1, 0x58, 0x6c, 0xfe,
	0xdc, 0x1c, 0xea, 0xd7, 0xd8, 0x3a, 0x8e, 0x47, 0x82, 0xe8, 0xa9, 0xf4, 0x4f, 0xd3, 0x2c, 0x07,
	0x42, 0x66, 0x7e, 0x10, 0xe9, 0xd7, 0xd9, 0x06, 0xfc, 0xeb, 0x4e, 0x7d, 0x62, 0x5f, 0x87, 0xc7,
	0x8e, 0x0f, 0x88, 0xa3, 0x37, 0x6e, 0x7f, 0x38, 0x0c, 0xc8, 0x3e, 0xeb, 0x47, 0x6f, 0x8c, 0xe1,
	0x30, 0xd0, 0x75, 0x96, 0x9d, 0xf6, 0x27, 0x1e, 0xf7, 0x8c, 0xbc, 0xc5, 0x7f, 0x2b, 0x43, 0x65,
	0xd5, 0xa1, 0x60, 0xa2, 0x61, 0xd4, 0x8f, 0xbc, 0xe2, 0x1a, 0x4e, 0x94, 0x3f, 0x80, 0x84, 0xc1,
	0x71, 0x10, 0x14, 0xd7, 0x39, 0x90, 0xff, 0xd6, 0x3f, 0x60, 0xac, 0x3f, 0x3c, 0xf1, 0x82, 0x68,
	0x14, 0x7a, 0xc3, 0xe2, 0x06, 0xc7, 0x28, 0x10, 0xfd, 0x16, 0xcb, 0x87, 0xc7, 0x33, 0xd0, 0xcd,
	0x1b, 0x16, 0x73, 0x1c, 0x1d, 0x03, 0x40, 0xe2, 0xcc, 0xf3, 0x82, 0x62, 0x1e, 0x25, 0xc2, 0x6f,
	0xfd, 0x36, 0x63, 0x20, 0xd9, 0x0d, 0x67, 0x9e, 0x37, 0x2c, 0x32, 0x64, 0x01, 0x88, 0x0d, 0x00,
	0x7d, 0x87, 0xe5, 0x27, 0xfd, 0x53, 0xc2, 0x16, 0x38, 0x36, 0x37, 0xe9, 0x9f, 0x72, 0x64, 0xe9,
	0xdf, 0xa6, 0xd8, 0x65, 0x65, 0xd9, 0x5e, 0x79, 0xfd, 0xe8, 0x38, 0xf0, 0x42, 0xfd, 0x0e, 0x2b,
	0x0c, 0xfb, 0x51, 0x7f, 0xd6, 0x8f, 0x8e, 0x84, 0xc1, 0xb3, 0x16, 0x13, 0xa0, 0x26, 0x97, 0x3a,
	0x75, 0x0f, 0x8e, 0x5f, 0xbd, 0xf2, 0x82, 0x90, 0xcc, 0x9e, 0x9b, 0x56, 0xf0, 0x19, 0xd6, 0x6a,
	0x8a, 0x4b, 0x17, 0x52, 0x5c, 0x6d, 0x4c, 0x1d, 0xfe, 0xa8, 0xdf, 0x63, 0x9b, 0xfd, 0xe3, 0xd3,
	0xd1, 0x78, 0xd4, 0x0f, 0xde, 0x82, 0x64, 0x34, 0x63, 0x41, 0xc2, 0x9a, 0x43, 0xbd, 0xc4, 0x36,
	0x07, 0xfd, 0x59, 0xff, 0x60, 0x34, 0x1e, 0x45, 0x23, 0x2f, 0x24, 0x93, 0x26, 0x60, 0xa5, 0x80,
	0x5d, 0x14, 0x2b, 0xeb, 0x82, 0xad, 0x8f, 0x43, 0xfd, 0x11, 0x5b, 0x0f, 0xbc, 0x7e, 0x48, 0xb9,
	0x60, 0xfb, 0xe1, 0xad, 0x05, 0xf7, 0xe5, 0xd4, 0x48, 0x63, 0x11, 0x2d, 0x24, 0x8a, 0xa1, 0x17,
	0x0e, 0x28, 0x24, 0xaf, 0x2e, 0xe5, 0xb1, 0x38, 0x49, 0xe9, 0xef, 0xa6, 0xd8, 0xa6, 0x14, 0x03,
	0x2e, 0xf9, 0xf3, 0xbb, 0x54, 0xec, 0x3e, 0x99, 0x84, 0xfb, 0xe8, 0x2c, 0x3b, 0xe9, 0x87, 0xaf,
	0xc9, 0x1a, 0xfc, 0x37, 0x38, 0x82, 0x74, 0x0b, 0xb2, 0x41, 0x0c, 0x28, 0xbd, 0xc1, 0xd8, 0x9d,
	0xf4, 0xa3, 0xc1, 0x91, 0x7e, 0x3f, 0x91, 0x96, 0x76, 0x16, 0x26, 0xc1, 0xa9, 0xd4, 0x8c, 0xf4,
	0xab, 0x8c, 0xf9, 0xa7, 0x13, 0xf7, 0xd5, 0xc8, 0x1b, 0x0f, 0x31, 0x2d, 0x14, 0x1e, 0xde, 0x5c,
	0x60, 0x93, 0x24, 0x56, 0xde, 0x3f, 0x9d, 0xd4, 0x39, 0x71, 0xe9, 0xbf, 0xa7, 0x30, 0x32, 0x25,
	0x52, 0xff, 0x36, 0x03, 0xb4, 0x3b, 0x18, 0xf7, 0xc3, 0x90, 0x54, 0x58, 0x2e, 0x8b, 0x53, 0x58,
	0x39, 0xff, 0x74, 0x52, 0x85, 0x5f, 0xfa, 0x0f, 0x60, 0x0e, 0x07, 0x28, 0x85, 0x4f, 0xbd, 0xf0,
	0xf0, 0x83, 0xa5, 0x8c, 0x92, 0xaa, 0x71, 0xc1, 0xca, 0xf9, 0xaf, 0x0e, 0xb8, 0x2a, 0xfa, 0x0b,
	0xa6, 0x7b, 0xa7, 0x33, 0x2f, 0x18, 0x41, 0x02, 0xf2, 0x02, 0x92, 0xb3, 0xc6, 0xe5, 0x7c, 0x7d,
	0xa9, 0x9c, 0x45, 0xf2, 0xc6, 0x05, 0xeb, 0x92, 0x0a, 0xe5, 0x92, 0x2b, 0x1b, 0x6c, 0x8d, 0x63,
	0x4b, 0x7f, 0xbc, 0x8d, 0x59, 0x2d, 0xa1, 0xc4, 0xd9, 0xbb, 0x80, 0x4a, 0xc9, 0x4d, 0x1e, 0x92,
	0xcd, 0x6f, 0xb0, 0xdc, 0x51, 0x3f, 0x74, 0xf9, 0x3a, 0x83, 0xb7, 0xe5, 0xac, 0x8d, 0xa3, 0x7e,
	0xd8, 0x86, 0xa5, 0xbe, 0xc2, 0xb2, 0xe0, 0x39, 0xe8, 0x14, 0x8d, 0x0b, 0x16, 0x7f, 0xd2, 0x3f,
	0x66, 0x5b, 0xb3, 0xa3, 0xb7, 0xe1, 0x68, 0xd0, 0x1f, 0x73, 0x9f, 0x43, 0xef, 0x68, 0x5c, 0xb0,
	0x36, 0x05, 0xb8, 0x07, 0x64, 0x5f, 0x67, 0xdb, 0x94, 0x25, 0xbd, 0xa8, 0x0f, 0x11, 0xca, 0x4d,
	0x90, 0x85, 0x3d, 0x83, 0xc3, 0xdb, 0x04, 0xd6, 0x6f, 0xb0, 0x0d, 0x2f, 0x3a, 0x72, 0x87, 0x61,
	0xc4, 0x13, 0xd2, 0x66, 0xe3, 0x82, 0xb5, 0xee, 0x45, 0x47, 0xb5, 0x30, 0x12, 0xa8, 0x30, 0x18,
	0xf0, 0x8c, 0x24, 0x50, 0x76, 0x30, 0xd0, 0x77, 0x58, 0x0e, 0x50, 0x7c, 0xc2, 0x39, 0x52, 0x00,
	0x88, 0x1d, 0x98, 0xd3, 0x0e, 0xcb, 0x9d, 0x8c, 0xfb, 0x53, 0xf7, 0x64, 0x34, 0xc4, 0x94, 0x04,
	0x48, 0x80, 0xec, 0x8f, 0x86, 0x12, 0x39, 0x1b, 0xcc, 0x30, 0x2b, 0x09, 0x64, 0x6f, 0x30, 0x83,
	0x11, 0x47, 0x33, 0x77, 0x18, 0x0e, 0x66, 0x98, 0x93, 0x60, 0xc4, 0xd1, 0xac, 0x16, 0x0e, 0x66,
	0xfa, 0x75, 0xb6, 0x3e, 0x9a, 0xb9, 0xde, 0x60, 0x5a, 0xdc, 0x24, 0xcc, 0xda, 0x68, 0x66, 0x0e,
	0xa6, 0x20, 0x70, 0x34, 0xc3, 0x32, 0xa2, 0xb8, 0x25, 0x04, 0x8e, 0x66, 0x3d, 0x5e, 0x44, 0x70,
	0xe4, 0xc9, 0x23, 0x3e, 0x87, 0xed, 0x18, 0x79, 0xf2, 0x88, 0x26, 0xc1, 0x91, 0x30, 0xf7, 0x8b,
	0x2a, 0x92, 0x26, 0x1f, 0x0d, 0x66, 0x9c, 0x51, 0x13, 0xaa, 0x44, 0x83, 0x19, 0xf0, 0x11, 0x0a,
	0xd8, 0x2e, 0x29, 0x28, 0xe2, 0x3a, 0x1e, 0x22, 0x97, 0x2e, 0x50, 0xc7, 0x43, 0xc1, 0x05, 0x28,
	0xe0, 0xba, 0xac, 0xa0, 0x80, 0x6b, 0x87, 0xe5, 0xc2, 0x41, 0x84, 0x6c, 0x57, 0x84, 0x22, 0x00,
	0x21, 0x2d, 0x39, 0x12, 0x18, 0xaf, 0xaa, 0x48, 0xe0, 0xbc, 0xc7, 0x0a, 0xa3, 0xc1, 0x04, 0x26,
	0xc1, 0x97, 0xe2, 0x1a, 0xe1, 0x19, 0x02, 0xf9, 0x6a, 0xc4, 0x24, 0x03, 0x7f, 0xe8, 0x15, 0xaf,
	0x27, 0x49, 0xaa, 0xfe, 0xd0, 0x03, 0xdb, 0xf6, 0x83, 0x99, 0xeb, 0xcf, 0x8a, 0x45, 0x61, 0xdb,
	0x7e, 0x30, 0xeb, 0xf2, 0xf5, 0x00, 0x44, 0x38, 0xeb, 0x17, 0x6f, 0x08, 0x9d, 0xfb, 0xc1, 0xcc,
	0x9e, 0xf5, 0x05, 0x2a, 0x9a, 0xf5, 0x8b, 0x37, 0x15, 0x94, 0x13, 0xa3, 0xc2, 0xa3, 0x7e, 0x71,
	0x47, 0xf8, 0x0d, 0x70, 0x1d, 0xc5, 0x5c, 0x47, 0xfd, 0xe2, 0x2d, 0x05, 0xe5, 0x1c, 0xf5, 0x69,
	0x35, 0x1e, 0x73, 0x23, 0xdc, 0x26, 0x1c, 0xac, 0xc6, 0xe3, 0x78, 0xa9, 0x1e, 0x73, 0x23, 0x7c,
	0xa0, 0x22, 0x85, 0x11, 0x00, 0xf9, 0x6a, 0xdc, 0x3f, 0xf0, 0xc6, 0xc5, 0x3b, 0x72, 0x86, 0xb3,
	0x93, 0xc7, 0x75, 0x0e, 0x93, 0x46, 0x78, 0x8c, 0x76, 0xba, 0x9b, 0x30, 0xc2, 0xe3, 0x84, 0x9d,
	0x1e, 0xa3, 0x9d, 0xee, 0x25, 0x49, 0xb8, 0x9d, 0xbe, 0xc6, 0xb6, 0xf9, 0x40, 0xd3, 0xa1, 0x1b,
	0xf5, 0x83, 0x43, 0x2f, 0x2a, 0x96, 0x48, 0x97, 0x4d, 0x80, 0x77, 0x86, 0x0e, 0x87, 0xea, 0x77,
	0x49, 0xa1, 0xe9, 0xd0, 0x0d, 0xc3, 0x71, 0xf1, 0x43, 0x22, 0xca, 0x23, 0x91, 0x1d, 0x8e, 0x55,
	0x8a, 0x68, 0x3c, 0x2e, 0x7e, 0x94, 0xa4, 0x70, 0xc6, 0x63, 0xfd, 0x0e, 0x63, 0x93, 0xd9, 0x38,
	0x74, 0x71, 0x4e, 0x1f, 0x93, 0x36, 0x79, 0x80, 0xb5, 0xf8, 0x94, 0x6e, 0xb0, 0x0d, 0x4e, 0x10,
	0x0d, 0x8a, 0x5f, 0x13, 0x0b, 0x00, 0x00, 0x87, 0x5b, 0x8b, 0xa3, 0x0e, 0xfc, 0xb0, 0xf8, 0x75,
	0xe1, 0x32, 0x00, 0xa9, 0xf8, 0x21, 0x20, 0x67, 0x07, 0x07, 0xee, 0x28, 0x1c, 0x0d, 0x8b, 0x9f,
	0x08, 0xe4, 0xec, 0xe0, 0xa0, 0x19, 0x8e, 0x86, 0xfa, 0x6d, 0x96, 0x8f, 0x8e, 0xa7, 0x53, 0x6f,
	0x0c, 0xbb, 0xf0, 0x37, 0x28, 0x63, 0xe4, 0x10, 0xd4, 0x1c, 0x4a, 0x4b, 0x7b, 0xa7, 0xd1, 0xd1,
	0x30, 0x28, 0x96, 0x55, 0x4b, 0x9b, 0x1c, 0xa6, 0x7f, 0xc6, 0x2e, 0x27, 0x13, 0x0f, 0xe6, 0xb6,
	0x11, 0x97, 0x95, 0xb2, 0x2e, 0x25, 0xb2, 0x0f, 0xcf, 0x73, 0x25, 0xb6, 0x49, 0x19, 0x08, 0x49,
	0x7f, 0x9d, 0x1b, 0x23, 0x65, 0x31, 0x4c, 0x43, 0x2a, 0x4d, 0x18, 0x0c, 0x90, 0xe6, 0xb5, 0x42,
	0x63, 0x07, 0x03, 0x4e, 0xf3, 0x11, 0xdb, 0x12, 0x69, 0x07, 0x89, 0x26, 0x5c, 0xbd, 0x94, 0x55,
	0xa0, 0xdc, 0x23, 0xa8, 0x44, 0x46, 0x40, 0xaa, 0x40, 0x50, 0x51, 0x5a, 0x48, 0x50, 0x49, 0xa5,
	0x42, 0x95, 0x4a, 0xd1, 0x8a, 0xc2, 0x03, 0x89, 0x7e, 0x93, 0x88, 0x18, 0xc6, 0x88, 0x4a, 0x13,
	0x09, 0x9a, 0xbf, 0xa1, 0xd0, 0x38, 0x44, 0xf3, 0x31, 0x1f, 0xed, 0x71, 0xac, 0xd3, 0xdf, 0x4c,
	0xd1, 0xfc, 0x0a, 0x14, 0x00, 0x09, 0x32, 0xa9, 0xd4, 0xdf, 0x4a, 0x90, 0x09, 0xad, 0xbe, 0xc9,
	0x34, 0x25, 0x1c, 0x90, 0xf2, 0xb7, 0x52, 0x34, 0xec, 0x76, 0x1c, 0x14, 0x42, 0xa6, 0xf0, 0x06,
	0xa4, 0xfc, 0xfb, 0x82, 0xb2, 0x40, 0x3e, 0xc1, 0xc9, 0x60, 0x3b, 0x11, 0x7e, 0x81, 0x74, 0xbf,
	0x9d, 0xa2, 0x15, 0xdd, 0x14, 0xde, 0x91, 0x18, 0x1c, 0x3d, 0x04, 0x49, 0x7f, 0x27, 0x31, 0x38,
	0xfa, 0x09, 0x10, 0xc3, 0x8e, 0x7a, 0xd2, 0x1f, 0x1f, 0x7b, 0x95, 0x75, 0xac, 0x74, 0x4a, 0x2e,
	0xbb, 0xb9, 0x7a, 0x57, 0x86, 0x92, 0x16, 0x30, 0x78, 0xc8, 0xa0, 0xe2, 0x0a, 0x8a, 0x8c, 0x06,
	0x1e, 0xc3, 0xc0, 0x47, 0x14, 0x26, 0xaa, 0x3f, 0x13, 0xb0, 0xd2, 0xbf, 0xc9, 0xe2, 0x51, 0xb1,
	0x3f, 0x80, 0xf3, 0xa3, 0xfe, 0x59, 0x62, 0xcf, 0x5e, 0xac, 0x0d, 0x91, 0x4c, 0xad, 0x91, 0xbe,
	0xc3, 0xd6, 0xfd, 0xe3, 0x68, 0x76, 0x1c, 0x51, 0x6d, 0xf8, 0xc1, 0x2a, 0x1e, 0xa4, 0x82, 0xa0,
	0xc4, 0x5f, 0xfa, 0x0f, 0x28, 0x28, 0xa3, 0x68, 0xcc, 0xb7, 0xf4, 0xc2, 0x92, 0x93, 0x22, 0xf1,
	0x0a, 0x3a, 0x11, 0xb6, 0x4e, 0x34, 0xd6, 0x1f, 0xb2, 0xec, 0xec, 0x38, 0x3c, 0xa2, 0x8a, 0x68,
	0xa5, 0xaa, 0x40, 0xc3, 0x6b, 0x85, 0xe3, 0xf0, 0x08, 0x86, 0x9c, 0xf9, 0x33, 0x2e, 0x8e, 0x2a,
	0xa0, 0x95, 0x43, 0x0a, 0x3a, 0x9e, 0x0c, 0xfc, 0x59, 0x7b, 0x36, 0x0e, 0xf5, 0x6f, 0xb1, 0xb5,
	0xc3, 0xc0, 0x3f, 0x9e, 0xf1, 0xc2, 0xa0, 0xf0, 0xf0, 0xf6, 0x2a, 0x5e, 0x4e, 0x04, 0x9b, 0x06,
	0xff, 0xa1, 0x7f, 0x9b, 0xad, 0x4f, 0xdf, 0xf0, 0x69, 0x6e, 0x9c, 0x6d, 0x22, 0xa4, 0x02, 0xc6,
	0xe9, 0x1b, 0x98, 0xe2, 0x13, 0x96, 0x0f, 0xbd, 0x88, 0x2a, 0xb6, 0x1c, 0xe7, 0xbd, 0xb7, 0x8a,
	0x57, 0x12, 0x42, 0x7e, 0x0a, 0xbd, 0x08, 0x8b, 0xbf, 0x2f, 0xe6, 0x5c, 0x20, 0xcf, 0x85, 0x7c,
	0xb4, 0x4a, 0x88, 0x4a, 0x0b, 0x49, 0x5c, 0x7d, 0xae, 0xe4, 0xd8, 0x3a, 0x92, 0x95, 0x9e, 0x60,
	0xb9, 0x97, 0x58, 0x58, 0x7e, 0xe6, 0x82, 0xf2, 0x2b, 0x45, 0x67, 0x2e, 0x3a, 0x4d, 0xc2, 0xa1,
	0x2a, 0x3e, 0xbc, 0xae, 0x4f, 0xfa, 0xa7, 0x70, 0x6e, 0xfd, 0x0c, 0xcf, 0x53, 0x73, 0xcb, 0x0b,
	0xc5, 0x9f, 0x74, 0x09, 0x3a, 0xbd, 0xd2, 0x72, 0x97, 0xee, 0xe3, 0x51, 0x46, 0x59, 0x55, 0x28,
	0xfd, 0xbd, 0xe8, 0xc8, 0x0b, 0xa4, 0xc7, 0x6e, 0x59, 0x31, 0xa0, 0xf4, 0x79, 0x62, 0x08, 0xb1,
	0x9c, 0x5f, 0xc2, 0xf4, 0x2b, 0x4c, 0x9b, 0x5f, 0x47, 0x50, 0x8a, 0xff, 0x50, 0x8e, 0xd4, 0xfc,
	0xb9, 0x39, 0x2c, 0x95, 0x13, 0x86, 0xc0, 0xe5, 0xd3, 0xaf, 0xca, 0xe5, 0xa6, 0xe3, 0x3c, 0x5f,
	0xcc, 0x52, 0x83, 0x5d, 0x59, 0xb6, 0x5c, 0xfa, 0x67, 0x54, 0x45, 0x73, 0xea, 0xb3, 0xcf, 0x17,
	0x54, 0x6e, 0x3f, 0x63, 0xd7, 0x57, 0xac, 0xd9, 0x42, 0xc8, 0xa7, 0x16, 0x43, 0x1e, 0x16, 0x8a,
	0xd7, 0xbf, 0xb0, 0x22, 0x9b, 0x16, 0xff, 0x5d, 0xfa, 0xfd, 0x0c, 0x9a, 0x77, 0x34, 0x0d, 0xa3,
	0xe0, 0x18, 0x73, 0x81, 0xae, 0xe4, 0x82, 0x2d, 0x8a, 0xf6, 0x06, 0x63, 0x87, 0x7e, 0xe4, 0xe3,
	0xa9, 0x95, 0x22, 0x7e, 0xf1, 0x10, 0xa1, 0x48, 0x71, 0x63, 0x72, 0xd8, 0xad, 0xe1, 0x89, 0x1f,
	0x71, 0x75, 0x87, 0x6d, 0xbf, 0x09, 0x46, 0x91, 0x52, 0x8f, 0x63, 0x0e, 0xf8, 0xe6, 0x99, 0xd2,
	0x92, 0x2c, 0x50, 0xbc, 0x73, 0x88, 0x2c, 0xde, 0x9f, 0xb0, 0x0d, 0x34, 0x4b, 0x48, 0x79, 0xe1,
	0xa3, 0x33, 0xc5, 0x11, 0x2d, 0xc4, 0x38, 0xfd, 0xd4, 0xbf, 0xcb, 0xd6, 0x26, 0x1e, 0x98, 0x0e,
	0xf3, 0x43, 0xe9, 0x4c, 0x7e, 0x4e, 0x09, 0xf1, 0xca, 0x7f, 0xe8, 0xdd, 0x39, 0xeb, 0xaf, 0xaf,
	0x68, 0x60, 0xa9, 0x22, 0xce, 0x0c, 0xb9, 0x75, 0x5c, 0xaa, 0xd2, 0xb7, 0x71, 0x1b, 0x58, 0x6e,
	0xd7, 0x33, 0x7a, 0x3e, 0xa5, 0x3e, 0xfb, 0xe0, 0x6c, 0x13, 0xea, 0x37, 0x59, 0x4e, 0xae, 0x00,
	0xf6, 0x2f, 0xe4, 0xb3, 0xfe, 0x21, 0xdb, 0x4a, 0x16, 0x2d, 0x69, 0x4e, 0xb0, 0x39, 0x51, 0xaa,
	0x95, 0x52, 0x0b, 0xbd, 0x71, 0x89, 0x59, 0xf5, 0x07, 0xf1, 0x6a, 0x60, 0xaf, 0xec, 0xfa, 0x8a,
	0xc4, 0x23, 0xcd, 0x5f, 0x7a, 0x88, 0x3d, 0xc5, 0x05, 0x23, 0xf3, 0xd4, 0x00, 0x3f, 0x94, 0x49,
	0xf2, 0xe7, 0xe6, 0xb0, 0xb4, 0x8f, 0xad, 0xbd, 0x55, 0x56, 0xfd, 0x85, 0x83, 0xe2, 0x4f, 0x32,
	0xd8, 0xc9, 0xe0, 0xfa, 0x4e, 0x7c, 0xea, 0xa0, 0xf9, 0xaf, 0x47, 0x1e, 0x59, 0x8a, 0x9e, 0xf4,
	0x3b, 0xac, 0x80, 0xbf, 0x54, 0x2b, 0x31, 0x04, 0xf1, 0x22, 0x40, 0x5d, 0xa1, 0x4c, 0xb2, 0x2b,
	0xf7, 0x3d, 0xb6, 0x31, 0xf0, 0x27, 0x93, 0xfe, 0x14, 0xcf, 0xf6, 0xdb, 0x4b, 0x32, 0xbc, 0x18,
	0xdf, 0x25, 0x42, 0x4b, 0x70, 0xe8, 0xf7, 0xd8, 0xe6, 0x68, 0x38, 0xf6, 0xdc, 0x68, 0x34, 0xf1,
	0xfc, 0xe3, 0x88, 0xfa, 0x1f, 0x05, 0x80, 0x39, 0x08, 0x02, 0x92, 0xa3, 0x7e, 0x30, 0x94, 0x24,
	0xd8, 0x64, 0x2b, 0x00, 0x4c, 0x90, 0xdc, 0x64, 0xb9, 0x59, 0x30, 0xf2, 0x83, 0x51, 0xf4, 0x96,
	0x3a, 0x6d, 0xf2, 0x59, 0xdf, 0x61, 0x79, 0x6c, 0x5f, 0x81, 0xea, 0xd8, 0x67, 0xcb, 0x21, 0xa0,
	0xc9, 0x9b, 0x8d, 0xfe, 0x71, 0x84, 0xa7, 0x6e, 0x6c, 0xb5, 0x6d, 0xf8, 0xc7, 0x11, 0x3f, 0x6e,
	0xef, 0xb0, 0x3c, 0xa0, 0x70, 0xbb, 0xc4, 0x66, 0x1b, 0xd0, 0xee, 0xf2, 0x8c, 0x2a, 0xfb, 0x9d,
	0x05, 0xb5, 0xdf, 0xf9, 0x97, 0xd8, 0x1a, 0xef, 0xc0, 0xf0, 0xf3, 0x6c, 0xe1, 0xe1, 0xb5, 0xe5,
	0xfd, 0x19, 0x0b, 0x89, 0xf4, 0x27, 0x6c, 0x53, 0x59, 0xf0, 0xb0, 0xb8, 0xc5, 0x1d, 0xec, 0xd6,
	0x59, 0xb1, 0x66, 0x25, 0x38, 0x4a, 0x3f, 0x49, 0x61, 0xe9, 0x73, 0x70, 0x3c, 0x78, 0xed, 0x45,
	0xb0, 0xb8, 0x6f, 0xbc, 0xd1, 0xe1, 0x91, 0xd8, 0xc1, 0xe8, 0x09, 0x8a, 0xac, 0x37, 0xbc, 0x31,
	0xc4, 0xa7, 0x89, 0xdb, 0x58, 0x9e, 0x43, 0xf8, 0x44, 0xef, 0xb0, 0x02, 0xa2, 0x71, 0xaa, 0xb8,
	0xba, 0xc8, 0x81, 0x93, 0x7d, 0xa0, 0xa6, 0xa4, 0xf3, 0x05, 0xc1, 0x7f, 0xa2, 0xe6, 0x11, 0x6e,
	0x3b, 0xe0, 0x79, 0xdf, 0x8f, 0xbd, 0x04, 0x4b, 0xb3, 0xc5, 0xbc, 0x24, 0x89, 0x17, 0xdd, 0xe4,
	0x7e, 0xa2, 0xcd, 0xbf, 0xb3, 0x82, 0x55, 0x29, 0xea, 0xd4, 0x2d, 0x2f, 0x93, 0xd8, 0xf2, 0x60,
	0x3a, 0x68, 0xb0, 0xd5, 0xd3, 0x41, 0xbc, 0x25, 0xe8, 0x4a, 0xbf, 0x9d, 0x62, 0xdb, 0xbc, 0x23,
	0xd8, 0x87, 0x67, 0xa8, 0x17, 0x92, 0x6e, 0x95, 0x9a, 0x73, 0xab, 0xeb, 0x6c, 0x63, 0x34, 0x55,
	0xcd, 0xbd, 0x3e, 0x9a, 0x72, 0x5b, 0x2b, 0xa6, 0xcc, 0x9c, 0xcf, 0x94, 0x32, 0xae, 0xb3, 0x6a,
	0x5c, 0x93, 0x79, 0x49, 0x9f, 0xd1, 0xf4, 0x6c, 0x75, 0x7e, 0x55, 0x76, 0x4c, 0xd3, 0x2b, 0x02,
	0x54, 0x0a, 0x9a, 0x6f, 0x9b, 0x9e, 0x11, 0xf7, 0x71, 0x2e, 0xc9, 0x26, 0x72, 0x89, 0x8c, 0x82,
	0xb5, 0xf3, 0x44, 0x81, 0x98, 0xde, 0xba, 0x32, 0xbd, 0x7f, 0x92, 0xc1, 0x22, 0x86, 0x33, 0x05,
	0xde, 0xc4, 0x3f, 0xf1, 0x56, 0xa7, 0x2e, 0x35, 0xf6, 0xd3, 0x73, 0xb1, 0xff, 0x7d, 0x39, 0xf1,
	0x0c, 0x9f, 0xf8, 0x47, 0xcb, 0x33, 0x13, 0x0d, 0x71, 0xd6, 0xdc, 0xb3, 0xc9, 0xb9, 0xdf, 0x63,
	0x9b, 0xc3, 0xe3, 0xa0, 0x4f, 0x85, 0xd0, 0x40, 0xa4, 0x2d, 0x01, 0xb3, 0xbd, 0x01, 0x6c, 0x3d,
	0x92, 0x64, 0x0a, 0x34, 0x98, 0xb7, 0x24, 0x5f, 0x27, 0xf4, 0x06, 0x0b, 0xe9, 0x6f, 0xe3, 0xcb,
	0xd3, 0x5f, 0x6e, 0x31, 0xfd, 0xdd, 0x63, 0x9b, 0xb4, 0x80, 0x03, 0xff, 0x78, 0x8a, 0x99, 0x2c,
	0x6b, 0x15, 0x10, 0x56, 0x05, 0x10, 0xe4, 0x80, 0x83, 0xb7, 0x91, 0x47, 0x04, 0x8c, 0x13, 0xe4,
	0x01, 0x82, 0x68, 0xb9, 0x66, 0x6f, 0xcf, 0xb1, 0x66, 0xa5, 0x3f, 0x49, 0xe3, 0x1e, 0x87, 0xdb,
	0xd9, 0x41, 0x7f, 0x3a, 0x3c, 0xef, 0x7b, 0x33, 0x85, 0x43, 0x09, 0x56, 0x9d, 0x65, 0x83, 0x7e,
	0xe4, 0xd1, 0xf2, 0xf1, 0xdf, 0x5c, 0xe1, 0xe3, 0x20, 0x8c, 0xdc, 0x70, 0xf4, 0x1b, 0x1e, 0xb9,
	0x5e, 0x9e, 0x43, 0xec, 0xd1, 0x6f, 0x78, 0xfa, 0x63, 0x96, 0x1d, 0x06, 0xfe, 0x8c, 0x6a, 0xa4,
	0x33, 0x07, 0x02, 0x3a, 0x38, 0x3f, 0xc1, 0xbf, 0xfa, 0x17, 0xac, 0x30, 0x0c, 0x07, 0x33, 0x58,
	0xf2, 0x7e, 0xf0, 0x7a, 0x65, 0x13, 0x59, 0x65, 0x8f, 0xc9, 0x1b, 0x17, 0x2c, 0x06, 0x8f, 0x16,
	0x7f, 0xd2, 0x3b, 0x4b, 0x8b, 0xa5, 0x4f, 0xce, 0x12, 0x76, 0xae, 0x5a, 0xe9, 0x2a, 0xd6, 0xfd,
	0x73, 0x53, 0x28, 0x7d, 0x0f, 0x4b, 0xa8, 0xe5, 0xaa, 0x81, 0xbd, 0x66, 0x81, 0x37, 0x70, 0xc7,
	0xde, 0x89, 0x27, 0xea, 0xf6, 0x3c, 0x40, 0x5a, 0x00, 0x28, 0x19, 0x6c, 0xe7, 0x0c, 0x55, 0xce,
	0x53, 0x60, 0x94, 0xfe, 0x1d, 0x25, 0x1d, 0x94, 0x71, 0xce, 0x9c, 0x2e, 0x89, 0x17, 0x73, 0xba,
	0xdc, 0x43, 0xd3, 0xea, 0x1e, 0xaa, 0x56, 0x49, 0x99, 0x44, 0x95, 0xa4, 0x7f, 0x87, 0xad, 0x81,
	0xe6, 0x22, 0x6d, 0x97, 0xce, 0x32, 0x34, 0xbd, 0xb6, 0x44, 0x86, 0xd2, 0x8f, 0x51, 0x73, 0x2f,
	0x08, 0xfc, 0xc0, 0x9d, 0x84, 0x87, 0xfa, 0x7d, 0xb6, 0xae, 0xf4, 0x1c, 0x96, 0xa5, 0x61, 0x12,
	0x40, 0x64, 0xf2, 0x28, 0x91, 0x56, 0x8e, 0x12, 0x3a, 0xcb, 0xf2, 0xbe, 0x62, 0x86, 0xde, 0xfa,
	0xf9, 0x43, 0x6f, 0x69, 0xb6, 0xfe, 0xad, 0x14, 0xae, 0x1c, 0x0e, 0x9f, 0xe8, 0x82, 0x80, 0x2e,
	0xcb, 0x4e, 0x29, 0x37, 0x58, 0xce, 0x3b, 0xc5, 0x0d, 0x8d, 0x86, 0xdc, 0xf0, 0x4e, 0x67, 0xbc,
	0xa9, 0x39, 0xbf, 0x54, 0x99, 0x33, 0x6a, 0x41, 0x55, 0x8b, 0x13, 0x8a, 0xd9, 0xe3, 0x71, 0x34,
	0x9a, 0xf5, 0xf9, 0x0b, 0xb2, 0x1f, 0x1d, 0x7b, 0x61, 0xa4, 0x7f, 0x9e, 0x88, 0xd9, 0x3b, 0x8b,
	0x56, 0x95, 0x1c, 0x4a, 0xc8, 0x2e, 0x5f, 0x3c, 0x9d, 0x65, 0x0f, 0xfc, 0xe1, 0x5b, 0xae, 0xd3,
	0xa6, 0xc5, 0x7f, 0x97, 0x22, 0xf2, 0x66, 0x65, 0xdc, 0xd9, 0xf8, 0xed, 0x2f, 0x7b, 0xd4, 0xdf,
	0x4d, 0xe1, 0x2b, 0xe1, 0xa1, 0x17, 0x0e, 0xb8, 0x4f, 0xbd, 0x0a, 0xf8, 0x6f, 0x3e, 0x5e, 0xde,
	0xda, 0x98, 0xbc, 0x0a, 0x6a, 0x80, 0xc2, 0x37, 0x78, 0xf2, 0xcd, 0x60, 0xde, 0x5a, 0x3f, 0x7a,
	0x23, 0x10, 0x21, 0x21, 0xf0, 0xbd, 0xf0, 0x7a, 0x88, 0x88, 0xdb, 0x8c, 0x85, 0x5e, 0x30, 0xea,
	0x8f, 0xdd, 0xe9, 0xf1, 0x84, 0x5b, 0x38, 0x6f, 0xe5, 0x11, 0xd2, 0x39, 0x9e, 0x00, 0xdf, 0x10,
	0x87, 0xe5, 0xc9, 0x25, 0x6f, 0xad, 0x0f, 0x67, 0xc0, 0x57, 0xfa, 0xa3, 0x14, 0xbb, 0x26, 0x77,
	0x9c, 0x30, 0xea, 0x47, 0xa1, 0x5c, 0x81, 0x33, 0x5e, 0x79, 0xab, 0x05, 0x6a, 0xfa, 0x8c, 0x02,
	0x35, 0x33, 0x57, 0xa0, 0xae, 0xda, 0x9c, 0xe7, 0x0a, 0xfd, 0xb5, 0x85, 0x42, 0x5f, 0xee, 0x04,
	0xeb, 0xe7, 0xd9, 0x09, 0xfe, 0x30, 0x83, 0x85, 0x51, 0x3c, 0x29, 0x7d, 0x9b, 0xa5, 0x47, 0x43,
	0xfe, 0x66, 0x26, 0x6b, 0xa5, 0x47, 0x67, 0xbe, 0xcf, 0x9f, 0xdf, 0x45, 0xd3, 0xe7, 0xd8, 0x45,
	0x33, 0x4b, 0x76, 0x51, 0xb5, 0x04, 0xc8, 0xce, 0x95, 0x00, 0x5f, 0xcd, 0x01, 0x43, 0x3a, 0xde,
	0x86, 0xea, 0x78, 0xb1, 0x91, 0x73, 0x09, 0x23, 0x7f, 0x85, 0xfb, 0xf1, 0xff, 0xa3, 0x93, 0xc4,
	0x1f, 0xa7, 0x70, 0x7f, 0xe8, 0x1f, 0x1e, 0x06, 0xde, 0x61, 0x3f, 0xf2, 0xfe, 0xbf, 0xf1, 0xd0,
	0x1f, 0xb3, 0x1b, 0xcb, 0x27, 0x06, 0x49, 0x68, 0x7e, 0xa1, 0x52, 0x5f, 0xb6, 0x50, 0xe9, 0xf9,
	0x85, 0xba, 0xcd, 0x18, 0x1f, 0x1a, 0xd1, 0x54, 0xa6, 0x00, 0x84, 0xa3, 0x4b, 0x7f, 0x9e, 0xc1,
	0xd4, 0x8f, 0xc6, 0xa3, 0x5b, 0x17, 0xee, 0x2c, 0xf0, 0x67, 0x5e, 0xc0, 0xeb, 0x53, 0x35, 0x09,
	0x2e, 0x56, 0x0e, 0x8b, 0x6c, 0x6a, 0x36, 0xdc, 0x9f, 0x5b, 0x76, 0x6c, 0x66, 0x7d, 0x76, 0x1e,
	0x29, 0x2a, 0x1f, 0x7f, 0xd7, 0xa5, 0x3c, 0xeb, 0x16, 0x2b, 0x4c, 0xbd, 0xd3, 0x48, 0xbd, 0xd8,
	0x51, 0x78, 0x78, 0xff, 0x3c, 0x62, 0x15, 0x36, 0xa8, 0x95, 0xe0, 0x91, 0xae, 0x83, 0xec, 0xce,
	0xb7, 0xb5, 0xbe, 0x79, 0x1e, 0x79, 0x4b, 0xba, 0x5b, 0xdf, 0x63, 0x19, 0xff, 0x74, 0xb2, 0xb2,
	0x70, 0x5b, 0x22, 0xc4, 0x3f, 0x9d, 0x34, 0x2e, 0x58, 0xc0, 0x05, 0x16, 0x5b, 0x52, 0xb1, 0x9d,
	0xcb, 0x62, 0x67, 0x56, 0x6e, 0xe2, 0xad, 0x47, 0xe9, 0x90, 0x7d, 0x78, 0x0e, 0x8b, 0x2f, 0x04,
	0x6c, 0xea, 0xe7, 0x0e, 0xd8, 0x2f, 0x58, 0xe9, 0xcb, 0xd7, 0x40, 0xff, 0x88, 0x6d, 0xc7, 0x8f,
	0xee, 0x68, 0x88, 0x23, 0x6d, 0x59, 0x9b, 0x72, 0x65, 0x9a, 0xc3, 0xb0, 0x64, 0x63, 0x8b, 0x6d,
	0xb5, 0xfd, 0x7f, 0x91, 0x36, 0xd8, 0xb7, 0x56, 0x39, 0x3e, 0xac, 0x07, 0xec, 0x92, 0xfe, 0xe9,
	0x84, 0x6b, 0x94, 0xc1, 0x8b, 0x33, 0xfe, 0xe9, 0x04, 0x74, 0xf9, 0x87, 0xa9, 0x95, 0x16, 0x3c,
	0xb3, 0x60, 0x5d, 0xf2, 0x66, 0x28, 0x51, 0x44, 0x65, 0x92, 0x45, 0xd4, 0x37, 0x59, 0xe2, 0x36,
	0x88, 0x4b, 0xd5, 0x12, 0x68, 0xa2, 0xa9, 0x88, 0x1a, 0x54, 0x4e, 0xbf, 0x97, 0x66, 0xfa, 0x82,
	0x4e, 0xe1, 0x59, 0x39, 0x51, 0xdc, 0x28, 0x4b, 0x2b, 0x37, 0xca, 0x3e, 0x66, 0xdb, 0x4a, 0x2b,
	0x12, 0xf2, 0x57, 0x86, 0x27, 0x93, 0xad, 0xb8, 0x17, 0x09, 0xb9, 0x5c, 0x25, 0xe3, 0x8d, 0x4e,
	0x4a, 0x8f, 0x92, 0xec, 0x39, 0x00, 0x95, 0x0b, 0x46, 0x6b, 0x89, 0x0b, 0x46, 0x77, 0x58, 0x61,
	0xd2, 0x3f, 0x75, 0xbd, 0x69, 0x14, 0x8c, 0xbc, 0x90, 0xb6, 0x32, 0x36, 0xe9, 0x9f, 0x9a, 0x08,
	0xd1, 0x77, 0xe1, 0x9c, 0xc0, 0xd3, 0x0f, 0xe0, 0x37, 0xf8, 0x6a, 0x9e, 0x27, 0x8c, 0x20, 0x5f,
	0x59, 0x0a, 0x6b, 0xe9, 0x27, 0x29, 0x6c, 0xb8, 0x23, 0x29, 0xee, 0xfd, 0x67, 0xef, 0xf5, 0xe0,
	0x1a, 0x27, 0x6a, 0x26, 0xdd, 0xb2, 0x0a, 0x08, 0xc3, 0x5c, 0x7a, 0x8f, 0x6d, 0x8e, 0x7d, 0xff,
	0xf5, 0xf1, 0x4c, 0xc9, 0xa6, 0x59, 0xab, 0x80, 0x30, 0x24, 0xf9, 0x90, 0x6d, 0x71, 0xdb, 0x79,
	0x43, 0xa2, 0xc9, 0x52, 0x3f, 0x17, 0x81, 0x98, 0x74, 0x1f, 0x60, 0xa1, 0x25, 0xef, 0x8c, 0xc5,
	0xdb, 0xd8, 0xaa, 0x8b, 0x5c, 0xa5, 0x3f, 0xa5, 0x3a, 0x26, 0xe6, 0x59, 0x7d, 0xe9, 0xeb, 0x36,
	0x63, 0xc1, 0x29, 0x75, 0x4c, 0x42, 0xb1, 0x23, 0x04, 0xa7, 0x3d, 0x04, 0x00, 0x3a, 0x8a, 0xd1,
	0x38, 0x87, 0x7c, 0x24, 0xd1, 0x37, 0x58, 0x2e, 0x38, 0x75, 0x61, 0x03, 0x09, 0x49, 0xf9, 0x8d,
	0xe0, 0xb4, 0x02, 0x8f, 0xdc, 0x7a, 0x02, 0x85, 0xdb, 0xde, 0x46, 0x44, 0x28, 0x1c, 0x13, 0x8e,
	0x81, 0x33, 0x6f, 0xc8, 0x57, 0x95, 0x8f, 0x59, 0x43, 0x00, 0x8d, 0x29, 0xd0, 0x1b, 0x62, 0x4c,
	0x81, 0xde, 0x61, 0xf9, 0xe0, 0x14, 0x8f, 0x1f, 0x21, 0x95, 0x2a, 0xb9, 0xe0, 0xd4, 0xe4, 0xcf,
	0x80, 0x8c, 0x24, 0x12, 0x2b, 0x95, 0x5c, 0x24, 0x90, 0x77, 0xd9, 0x66, 0x70, 0xea, 0xbe, 0x0a,
	0xfa, 0x13, 0x0f, 0x48, 0xa8, 0x50, 0x61, 0xc1, 0x69, 0x1d, 0x40, 0x26, 0xbf, 0xe6, 0x58, 0x08,
	0x4e, 0x5d, 0xff, 0xc4, 0x0b, 0x38, 0x41, 0x41, 0xa8, 0xd6, 0x3d, 0xf1, 0x02, 0xc0, 0xdf, 0xe2,
	0x9a, 0x0f, 0x82, 0x01, 0x47, 0x6f, 0x8a, 0xc1, 0xab, 0xc1, 0x00, 0xb9, 0xd9, 0xc0, 0x1f, 0x8f,
	0x47, 0x21, 0xd5, 0x2d, 0xb4, 0xd7, 0x0b, 0xc8, 0x42, 0x85, 0xb8, 0x7d, 0x8e, 0x0a, 0xf1, 0xe2,
	0x62, 0x85, 0x58, 0x7a, 0x84, 0x2d, 0x7e, 0x6c, 0x09, 0x2e, 0x94, 0x36, 0xab, 0x5e, 0x8e, 0xed,
	0x63, 0xdc, 0x63, 0x17, 0x10, 0x1d, 0xce, 0x0b, 0xfe, 0xef, 0x8b, 0x86, 0xd2, 0x4f, 0xd2, 0x18,
	0x3a, 0x8a, 0x3a, 0x67, 0xa8, 0xc1, 0x97, 0xcf, 0x7b, 0x95, 0x88, 0x9b, 0x5c, 0xe0, 0xbd, 0x92,
	0x41, 0x93, 0xd0, 0x26, 0xf3, 0x65, 0xda, 0x64, 0xe7, 0x4b, 0x98, 0xaf, 0xaa, 0x97, 0x55, 0x61,
	0x9b, 0x64, 0x29, 0x3e, 0x23, 0xca, 0x2d, 0x77, 0x56, 0x34, 0x57, 0x85, 0x39, 0xad, 0x02, 0x3e,
	0xdb, 0xc0, 0x03, 0xc7, 0xb6, 0xed, 0xd8, 0x32, 0xfc, 0xf0, 0xf6, 0x65, 0x77, 0x1e, 0xcf, 0x6c,
	0xfd, 0xa6, 0x57, 0xb6, 0x7e, 0x33, 0xe7, 0x6c, 0xfd, 0x9e, 0xa8, 0x4b, 0x05, 0x69, 0xf5, 0x2d,
	0x68, 0x24, 0x8f, 0x92, 0x85, 0x95, 0x1a, 0x01, 0x09, 0x5e, 0x28, 0xd5, 0x1f, 0xe2, 0xa5, 0x61,
	0x51, 0xa1, 0xdd, 0x5a, 0xc1, 0xc1, 0x69, 0xf0, 0x4a, 0x71, 0x58, 0xfa, 0x3b, 0x29, 0x74, 0x3e,
	0x44, 0xc9, 0x4d, 0xe7, 0x0a, 0x5b, 0xe3, 0x77, 0x0d, 0xc5, 0x9b, 0x59, 0xfe, 0xb0, 0x70, 0x93,
	0x36, 0xbd, 0x78, 0x93, 0x16, 0xbc, 0x00, 0x76, 0x06, 0x2e, 0x4f, 0xec, 0xba, 0xf9, 0x49, 0xff,
	0x94, 0x57, 0xe3, 0xa1, 0x5e, 0x4c, 0x36, 0xf9, 0xb7, 0xe2, 0x9d, 0xfc, 0x3b, 0x6a, 0xeb, 0x68,
	0xb1, 0x7d, 0x70, 0xc6, 0x6b, 0xad, 0x5f, 0xc7, 0x17, 0xc6, 0x4a, 0x5b, 0x06, 0x7d, 0xbd, 0xcc,
	0x2e, 0x91, 0xcf, 0x72, 0xa0, 0x1a, 0x46, 0x17, 0x11, 0x51, 0xe9, 0x4f, 0x31, 0x99, 0xeb, 0x5f,
	0x63, 0x17, 0xb9, 0xf3, 0x2a, 0x94, 0x18, 0x4f, 0x5b, 0x00, 0x96, 0x74, 0xa5, 0x3f, 0xa0, 0x98,
	0xc2, 0xc1, 0x64, 0x4c, 0xad, 0x50, 0x6d, 0xae, 0x6e, 0x4f, 0xcf, 0xd5, 0xed, 0x30, 0x6a, 0xdc,
	0x12, 0x57, 0x03, 0x6b, 0x0b, 0xc1, 0xcd, 0x29, 0xd2, 0x95, 0x18, 0x57, 0x23, 0xa6, 0xc2, 0xe8,
	0x2a, 0x00, 0x50, 0xd0, 0x7c, 0x55, 0xf1, 0xf5, 0x84, 0xb1, 0xd8, 0x86, 0x14, 0x5d, 0xf7, 0xce,
	0xea, 0x81, 0xa1, 0x3f, 0xe5, 0xe1, 0x37, 0x46, 0xd7, 0x6f, 0x62, 0x5b, 0x1d, 0x49, 0xce, 0xbc,
	0xb9, 0xaf, 0x5a, 0x2e, 0xbd, 0xa2, 0x0b, 0x97, 0xf9, 0x79, 0xbb, 0x70, 0xff, 0x9a, 0x5c, 0x1a,
	0x09, 0xa4, 0x4b, 0xd3, 0xbd, 0x75, 0x7c, 0x67, 0x9d, 0x92, 0xf7, 0xd6, 0xdb, 0xfc, 0xa5, 0xe9,
	0x6d, 0x9a, 0x34, 0x3a, 0x3d, 0xad, 0x13, 0x40, 0x9c, 0xa5, 0x8e, 0x9f, 0x59, 0xe2, 0xf8, 0x24,
	0x5f, 0xb4, 0x0e, 0x85, 0x7c, 0x70, 0x1d, 0x89, 0x1c, 0xf8, 0x63, 0x3f, 0xa0, 0x95, 0x01, 0x64,
	0x15, 0x9e, 0x4b, 0x3f, 0x56, 0x5d, 0x0a, 0x63, 0xff, 0x5b, 0xb2, 0xee, 0x4a, 0xad, 0xb8, 0x41,
	0xa3, 0x5a, 0x57, 0x96, 0x65, 0x5f, 0x9a, 0x01, 0x14, 0xb7, 0x15, 0x19, 0xe0, 0x84, 0xdd, 0xe3,
	0x5d, 0xc3, 0x44, 0xbf, 0x50, 0x86, 0xdf, 0xd1, 0xf2, 0x1b, 0x52, 0xa9, 0x2f, 0xa9, 0x83, 0xe7,
	0x9a, 0x89, 0xa2, 0x51, 0x98, 0x51, 0x1a, 0x85, 0x63, 0xdc, 0x2b, 0x13, 0xe3, 0xfe, 0xf2, 0x46,
	0x33, 0xb1, 0x2d, 0xf9, 0xa3, 0x63, 0xef, 0x98, 0xea, 0x7c, 0x1a, 0x8b, 0x37, 0x75, 0xb0, 0xee,
	0x14, 0x5e, 0x21, 0xcf, 0xcd, 0x1a, 0xcb, 0xc4, 0x37, 0x72, 0xe0, 0x67, 0x29, 0x40, 0xa5, 0x15,
	0x31, 0x93, 0xd1, 0xd4, 0xe5, 0x6f, 0x12, 0xaa, 0xac, 0xa0, 0xc8, 0xa5, 0x75, 0x5b, 0x74, 0xdb,
	0x05, 0x0d, 0xb0, 0xda, 0x6d, 0xc8, 0xfe, 0xef, 0xfc, 0x2b, 0x8a, 0x65, 0x63, 0xf6, 0x4f, 0x7f,
	0xc9, 0x63, 0xfe, 0x23, 0x6a, 0xd4, 0x28, 0x9c, 0x09, 0xeb, 0x7f, 0x25, 0x03, 0x9f, 0xe7, 0x70,
	0xb5, 0x6c, 0x2d, 0xff, 0x76, 0x0a, 0x13, 0x0c, 0xa5, 0x4e, 0x3e, 0x08, 0xf8, 0x03, 0x8e, 0x16,
	0x27, 0x61, 0xfe, 0x8c, 0xc7, 0x24, 0xa5, 0x6d, 0x84, 0x17, 0xae, 0x2a, 0x89, 0xf3, 0xc9, 0xaa,
	0x4e, 0xff, 0x0a, 0xfd, 0xe9, 0x68, 0xf2, 0x10, 0xaf, 0x53, 0x20, 0xd1, 0x21, 0xaf, 0x35, 0x20,
	0x0a, 0xe5, 0x96, 0xb5, 0xe4, 0xa2, 0x57, 0xe9, 0x10, 0xcf, 0xab, 0x4b, 0x78, 0x66, 0xe3, 0xb7,
	0x4b, 0xaf, 0x86, 0x7d, 0x8b, 0xad, 0x73, 0x6a, 0xf1, 0x5d, 0xc5, 0xed, 0x55, 0x6f, 0x55, 0x39,
	0x95, 0x45, 0xc4, 0x25, 0x73, 0xe1, 0x16, 0x15, 0xda, 0x69, 0xc5, 0x6b, 0x00, 0x69, 0xbb, 0x4c,
	0xc2, 0x76, 0xa5, 0xb6, 0xea, 0x7c, 0xe7, 0x3b, 0xe5, 0x24, 0xc4, 0xa5, 0x93, 0xe2, 0xfe, 0x8c,
	0x4e, 0x73, 0x8a, 0xbc, 0x5f, 0x44, 0x4e, 0xe2, 0x0c, 0x93, 0x59, 0x38, 0xc3, 0x28, 0x07, 0xa3,
	0xec, 0xfc, 0xc1, 0x28, 0x71, 0x0e, 0x59, 0x9b, 0x3b, 0x87, 0xcc, 0xef, 0xa1, 0xeb, 0xe7, 0xd8,
	0x43, 0x37, 0x96, 0x9c, 0x03, 0x26, 0xe8, 0xa0, 0x81, 0x3f, 0xf6, 0xa4, 0xb9, 0x1e, 0xb1, 0x2c,
	0x3c, 0xaf, 0x7c, 0x67, 0x39, 0xf0, 0xa7, 0x51, 0xe0, 0x8f, 0xc7, 0x5e, 0xc0, 0xf9, 0x2c, 0x4e,
	0x0d, 0xc3, 0x1d, 0x7a, 0x53, 0x8f, 0x06, 0x24, 0x43, 0x64, 0xad, 0xcd, 0x18, 0xd8, 0x1c, 0x96,
	0x7e, 0x87, 0x02, 0xa2, 0x1f, 0xbe, 0x9d, 0x0e, 0xc4, 0x8e, 0xfb, 0x11, 0xdb, 0x8e, 0x6b, 0x0b,
	0xde, 0xe3, 0xa4, 0xa6, 0x8c, 0x28, 0x2d, 0x78, 0x97, 0xf3, 0x13, 0xa6, 0x29, 0x1f, 0x3d, 0x89,
	0x6b, 0x39, 0x40, 0xb7, 0x0d, 0x70, 0x9b, 0x83, 0x39, 0x65, 0x99, 0x5d, 0x4a, 0xbc, 0xc5, 0xe6,
	0xa4, 0x58, 0xdf, 0x5d, 0x04, 0x84, 0x85, 0x70, 0x7e, 0xd5, 0xe9, 0x35, 0xdb, 0xe6, 0xfb, 0x6a,
	0xdb, 0x1f, 0xee, 0xcd, 0x86, 0x90, 0xa9, 0xb0, 0x5d, 0x8f, 0x6f, 0x45, 0xd2, 0x23, 0xfe, 0x91,
	0x8f, 0x7c, 0x67, 0x47, 0xbb, 0xd5, 0xcd, 0xd5, 0x6f, 0xf5, 0x2c, 0x2c, 0x13, 0xda, 0xfe, 0x70,
	0xc9, 0xe7, 0x95, 0x3d, 0x76, 0x91, 0x0f, 0xc6, 0x8b, 0x0f, 0x8b, 0xc7, 0xd1, 0x0f, 0x58, 0x41,
	0xd9, 0xe9, 0x56, 0xf6, 0xbd, 0xd4, 0xdd, 0x90, 0x4d, 0xa4, 0x8c, 0xd2, 0x88, 0x5d, 0xac, 0x8f,
	0xfd, 0x37, 0xbc, 0x73, 0xb5, 0x42, 0xff, 0x47, 0x2c, 0x27, 0x6e, 0x1b, 0x91, 0xfa, 0x37, 0x56,
	0x5e, 0x47, 0xb2, 0x36, 0xe0, 0xd7, 0x72, 0xe5, 0x7f, 0xc4, 0xae, 0xc0, 0x50, 0xbc, 0x3a, 0x3e,
	0x6b, 0xbc, 0x6f, 0xb3, 0xbc, 0xbc, 0xb7, 0xb2, 0xd2, 0x5e, 0x92, 0xc2, 0xc2, 0xa3, 0xc9, 0xf2,
	0x21, 0xbf, 0xcb, 0xd6, 0x60, 0xc8, 0x50, 0x7f, 0xc0, 0xd6, 0x46, 0x91, 0x37, 0x11, 0xf6, 0xd9,
	0x59, 0x3e, 0x01, 0x2a, 0x16, 0x38, 0x65, 0xe9, 0xfb, 0x6c, 0x9d, 0xdb, 0x3a, 0x84, 0x52, 0x43,
	0x65, 0x5e, 0x65, 0x5c, 0x5e, 0xce, 0x08, 0xee, 0x27, 0x8c, 0xc9, 0xc9, 0x9e, 0x43, 0x82, 0x72,
	0x18, 0x12, 0x12, 0x46, 0xac, 0x00, 0x12, 0xaa, 0x47, 0xfd, 0xe9, 0xa1, 0x17, 0xea, 0xdf, 0x60,
	0xeb, 0x91, 0xef, 0xf6, 0x87, 0xe2, 0x4e, 0xa8, 0x9e, 0x90, 0xc1, 0x67, 0x69, 0xad, 0x45, 0xbe,
	0x31, 0x1c, 0xea, 0xf7, 0x59, 0x3e, 0xf2, 0xc9, 0x79, 0xc9, 0x80, 0xcb, 0xa8, 0x73, 0x91, 0x8f,
	0x8e, 0x0c, 0x65, 0xa4, 0x26, 0xb5, 0x15, 0x03, 0x7e, 0x3a, 0x37, 0xe0, 0xf5, 0x05, 0x11, 0x38,
	0x39, 0x31, 0xea, 0xa3, 0xc5, 0x51, 0x57, 0xb2, 0xc8, 0xa1, 0x89, 0xeb, 0x98, 0x7b, 0x02, 0xf5,
	0xc5, 0xcf, 0xe2, 0x42, 0x97, 0x29, 0xd9, 0x2c, 0xd7, 0xa3, 0xd0, 0x5e, 0xe6, 0x3e, 0x32, 0x19,
	0xac, 0x74, 0x1f, 0x49, 0x61, 0xe5, 0x44, 0x8e, 0x28, 0x3d, 0x67, 0x79, 0x14, 0xda, 0x3d, 0x8e,
	0x16, 0xa4, 0x7e, 0x97, 0xb1, 0xf8, 0xaa, 0x12, 0x89, 0xdd, 0x59, 0x25, 0xd6, 0x3f, 0x8e, 0x2c,
	0x52, 0xa2, 0x7b, 0x1c, 0x95, 0xfe, 0x71, 0x8a, 0x15, 0xd0, 0xaa, 0xe6, 0x89, 0x37, 0x5d, 0x94,
	0xfd, 0x97, 0x59, 0x41, 0x49, 0x4c, 0x2b, 0x0b, 0x5a, 0x85, 0xa6, 0x71, 0xc1, 0x62, 0x71, 0xce,
	0x02, 0xf7, 0xe2, 0x59, 0x9e, 0x0c, 0xb8, 0x38, 0x5d, 0xf9, 0x9a, 0xbe, 0x71, 0xc1, 0x42, 0xd2,
	0xca, 0x06, 0x5b, 0xf3, 0x40, 0x9b, 0xf2, 0x7f, 0x4d, 0xb1, 0x82, 0x14, 0x3f, 0xf5, 0x75, 0x8d,
	0x6d, 0x76, 0xeb, 0xbd, 0x9e, 0xdb, 0xec, 0xec, 0x1b, 0xad, 0x66, 0x4d, 0xbb, 0xa0, 0x6b, 0x2c,
	0xc7, 0x21, 0x6d, 0xe3, 0x85, 0xf6, 0xee, 0x67, 0xef, 0xdf, 0x6f, 0xe8, 0x57, 0x24, 0x8d, 0xdb,
	0xeb, 0x5a, 0x8e, 0xf6, 0x3f, 0xde, 0x03, 0x54, 0x67, 0x8c, 0x43, 0x1d, 0xa3, 0xd2, 0x32, 0xb5,
	0xff, 0xc9, 0x61, 0x97, 0x59, 0x81, 0xc3, 0x3a, 0x5d, 0xab, 0x6d, 0xb4, 0xb4, 0xbf, 0x48, 0x10,
	0xd6, 0x5b, 0xdd, 0x6e, 0x4d, 0xfb, 0x5f, 0x1c, 0x26, 0x06, 0x31, 0x5a, 0x2d, 0xed, 0xa7, 0x1c,
	0x72, 0x9d, 0x5d, 0xe4, 0x90, 0x6a, 0xb7, 0xe3, 0x58, 0xdd, 0x56, 0xcb, 0xb4, 0xb4, 0xff, 0x9d,
	0x60, 0x6f, 0x75, 0xab, 0x46, 0x4b, 0xfb, 0x59, 0x92, 0xbd, 0xf3, 0x52, 0x7b, 0x0f, 0x90, 0xf2,
	0x7f, 0x58, 0xc3, 0xf7, 0xd5, 0x7c, 0xdb, 0xdf, 0xe6, 0x2c, 0x8e, 0xdb, 0x30, 0x5b, 0xad, 0xae,
	0x76, 0x41, 0x3e, 0x9b, 0x96, 0xd5, 0xb5, 0xb4, 0x94, 0x7e, 0x95, 0x5d, 0xc2, 0xe7, 0x6a, 0xa3,
	0xeb, 0x5a, 0xe6, 0xb3, 0x3d, 0xd3, 0x76, 0xb4, 0xb4, 0x7e, 0x99, 0xab, 0x20, 0xc1, 0xbd, 0xd6,
	0x4b, 0x2d, 0x13, 0xd3, 0xbe, 0xe8, 0x99, 0x56, 0xb3, 0x6d, 0x76, 0x1c, 0xd3, 0xd2, 0xb2, 0xfa,
	0x0d, 0x76, 0x95, 0x83, 0xeb, 0xa6, 0xe1, 0xec, 0x59, 0xa6, 0x2d, 0xc5, 0xac, 0xe9, 0xd7, 0xd9,
	0xe5, 0x79, 0x14, 0x88, 0x5a, 0xd7, 0x77, 0xd8, 0x75, 0x8e, 0xd8, 0x35, 0x1d, 0x98, 0x66, 0xbd,
	0xb9, 0x2b, 0xb9, 0x36, 0xa4, 0xc0, 0x04, 0x12, 0xf8, 0x72, 0x52, 0x2f, 0x5b, 0xa2, 0xb4, 0xbc,
	0xae, 0xb3, 0x6d, 0x0e, 0xec, 0x19, 0xd5, 0xa7, 0xa6, 0xe3, 0x36, 0x3b, 0x1a, 0x93, 0xba, 0xd6,
	0x5b, 0xdd, 0xe7, 0xae, 0x65, 0xb6, 0xbb, 0xfb, 0x66, 0x4d, 0x2b, 0xe8, 0x57, 0x98, 0x86, 0xa4,
	0x5d, 0xcb, 0x71, 0x6d, 0xc7, 0x70, 0xf6, 0x6c, 0x6d, 0x53, 0x4a, 0x25, 0x01, 0xdd, 0x3d, 0x47,
	0xdb, 0xd2, 0x2f, 0xb1, 0xad, 0x58, 0x42, 0xbb, 0x5b, 0xd3, 0xb6, 0xe5, 0x40, 0xbb, 0x56, 0x77,
	0xaf, 0xc7, 0x61, 0x17, 0x25, 0x19, 0x97, 0x08, 0x20, 0x4d, 0x92, 0x71, 0x77, 0xe0, 0xb0, 0x4b,
	0xfa, 0x4d, 0x76, 0x8d, 0xc3, 0xda, 0x7b, 0x2d, 0xa7, 0xd9, 0x33, 0x2c, 0x47, 0xce, 0x57, 0xd7,
	0x8b, 0xec, 0xca, 0x02, 0x0e, 0xa6, 0x7b, 0x59, 0x62, 0x2a, 0x86, 0x65, 0x35, 0x4d, 0x4b, 0xf2,
	0x5c, 0xd1, 0xaf, 0x31, 0x7d, 0x0e, 0x03, 0x1c, 0x57, 0xf5, 0x7b, 0xec, 0x36, 0x87, 0x3f, 0xdb,
	0x33, 0xf7, 0xcc, 0x65, 0xe6, 0xbd, 0xa6, 0xdf, 0x61, 0x3b, 0xab, 0x48, 0x40, 0xc6, 0x75, 0x69,
	0x3b, 0xab, 0xdb, 0x32, 0x25, 0x5f, 0x51, 0x5a, 0x89, 0xc0, 0x40, 0x7b, 0x43, 0xce, 0x0b, 0xc4,
	0x18, 0xf6, 0xcb, 0x4e, 0x55, 0x32, 0xdc, 0x94, 0xda, 0xab, 0x38, 0xe0, 0xda, 0x91, 0x16, 0xb2,
	0x05, 0x46, 0xbb, 0x25, 0x61, 0x6d, 0xd3, 0x31, 0x2d, 0x6e, 0xb5, 0xdb, 0xe5, 0x2a, 0x5e, 0xf8,
	0x98, 0xfb, 0x13, 0x09, 0x44, 0xda, 0xe0, 0x6b, 0x2d, 0x62, 0x15, 0x07, 0x03, 0xd8, 0xbe, 0x69,
	0xd9, 0xcd, 0x6e, 0xa7, 0xd2, 0x74, 0xda, 0x46, 0x4f, 0x4b, 0x95, 0x3d, 0x2c, 0x9c, 0xa8, 0x08,
	0xc7, 0xa6, 0x04, 0xfa, 0x41, 0xd5, 0xad, 0x5b, 0xc6, 0xae, 0x08, 0xd1, 0x0b, 0x24, 0x97, 0xa0,
	0x35, 0xab, 0xdb, 0xd3, 0x52, 0x34, 0x6b, 0x82, 0x59, 0xa6, 0x61, 0xb7, 0xb5, 0x74, 0x92, 0xb0,
	0x6d, 0xd8, 0x4f, 0xb5, 0x4c, 0xf9, 0x09, 0x0e, 0x83, 0x2f, 0x2d, 0xa8, 0x3e, 0x23, 0xe7, 0xa8,
	0x2a, 0x7a, 0x92, 0x73, 0x57, 0xdd, 0x9a, 0xd9, 0xb3, 0xcc, 0xaa, 0xe1, 0x98, 0x35, 0x21, 0xe1,
	0xd7, 0xf0, 0xfb, 0x6c, 0xbc, 0xc7, 0x4e, 0xac, 0xea, 0x14, 0xb7, 0x59, 0x1e, 0x41, 0x90, 0x8f,
	0x7e, 0x96, 0x8a, 0x9f, 0x21, 0x75, 0xbc, 0x4f, 0x95, 0xff, 0x3d, 0x95, 0x88, 0x89, 0x96, 0x05,
	0x66, 0x35, 0x55, 0x03, 0x39, 0x23, 0x70, 0x6c, 0x88, 0x01, 0x5b, 0x4b, 0x49, 0x83, 0xa0, 0xcf,
	0x22, 0x34, 0x2d, 0x49, 0x65, 0xb8, 0xd8, 0x5a, 0x56, 0x92, 0x62, 0x14, 0x20, 0x34, 0x47, 0xfa,
	0x56, 0xdd, 0x66, 0x8f, 0xac, 0x74, 0x57, 0x12, 0xa2, 0xa3, 0x21, 0xe1, 0x13, 0xfd, 0x1a, 0xf7,
	0x2e, 0x92, 0x59, 0x69, 0x75, 0xab, 0x4f, 0xcd, 0x9a, 0xf6, 0x2e, 0x5d, 0x3e, 0x51, 0x3e, 0xcf,
	0x4f, 0x98, 0x6f, 0x89, 0xf2, 0x82, 0xbd, 0xd6, 0x7d, 0xde, 0xd1, 0x52, 0x31, 0x5d, 0x07, 0x92,
	0x55, 0x75, 0x5f, 0xcb, 0x8a, 0x64, 0xce, 0x41, 0xf5, 0xe7, 0x35, 0xed, 0x2e, 0x45, 0x0c, 0x42,
	0xe2, 0x4c, 0xf1, 0xa4, 0xfc, 0x57, 0xe6, 0x5e, 0xd7, 0x08, 0xd3, 0xf7, 0xec, 0xc5, 0x61, 0x6d,
	0xb7, 0xd5, 0xec, 0x3c, 0x9d, 0x1b, 0xd6, 0x96, 0xb3, 0x48, 0x53, 0x7a, 0xe5, 0x74, 0xfb, 0xa6,
	0x96, 0x2d, 0xff, 0x69, 0x1a, 0x3f, 0x8a, 0xe1, 0xd2, 0x65, 0x9b, 0x8a, 0x18, 0xeb, 0xca, 0x00,
	0x12, 0xf4, 0xe0, 0xb3, 0x76, 0xc5, 0x6d, 0xd4, 0x62, 0xf1, 0x04, 0xaa, 0xd7, 0xa4, 0xdf, 0x71,
	0x10, 0x91, 0x65, 0xe7, 0x61, 0xf5, 0x9a, 0x96, 0x13, 0xb3, 0xaf, 0xbb, 0x0f, 0x76, 0x39, 0x95,
	0x96, 0x84, 0xd4, 0xc1, 0x1e, 0x8a, 0x78, 0x04, 0x3d, 0xd1, 0x75, 0x01, 0x7a, 0x44, 0xa0, 0x77,
	0xe0, 0xff, 0xb1, 0x78, 0x02, 0xa6, 0xf5, 0x4b, 0x52, 0x9a, 0x83, 0x20, 0x30, 0x78, 0x01, 0x41,
	0x5d, 0xa7, 0x61, 0x5a, 0xda, 0xbb, 0x5c, 0x4c, 0x54, 0xed, 0xf6, 0x7a, 0x00, 0xd2, 0x62, 0xa2,
	0x7a, 0xb3, 0x02, 0x90, 0xbb, 0xf1, 0x90, 0xc6, 0x9e, 0xd3, 0xed, 0x98, 0xbb, 0xda, 0xbb, 0x27,
	0xfa, 0x25, 0x41, 0xd5, 0x33, 0xf6, 0x6c, 0x53, 0x7b, 0xf7, 0x2e, 0xa5, 0x5f, 0xe3, 0xae, 0x24,
	0x40, 0x90, 0x33, 0xda, 0xda, 0xbb, 0x77, 0xe9, 0x72, 0x4d, 0x71, 0x1a, 0xba, 0x6a, 0xbb, 0xc5,
	0xa3, 0xa2, 0x67, 0xb9, 0x46, 0x0d, 0xf7, 0xf0, 0x4d, 0x7c, 0xac, 0x99, 0x2d, 0xd3, 0x31, 0xb5,
	0x54, 0x0c, 0x69, 0x77, 0x6b, 0xcd, 0xfa, 0x4b, 0x2d, 0x5d, 0xfe, 0x1c, 0x5d, 0x20, 0xfe, 0x93,
	0x07, 0x64, 0xd4, 0x36, 0x77, 0xfa, 0x4e, 0xcd, 0xb0, 0x40, 0x12, 0x0a, 0x6e, 0x3b, 0x6e, 0xf7,
	0x45, 0x5b, 0x4b, 0x95, 0x5f, 0xc7, 0x7f, 0xd3, 0x80, 0xff, 0x91, 0x02, 0x92, 0xfb, 0xa2, 0x5d,
	0x75, 0x3b, 0x2f, 0xda, 0xee, 0x67, 0x72, 0x6c, 0x01, 0x79, 0xa0, 0xa5, 0xf4, 0x1d, 0x1e, 0xfd,
	0x00, 0xe9, 0xf6, 0xcc, 0x0e, 0x8f, 0xc0, 0x8a, 0x61, 0x37, 0xab, 0x30, 0x19, 0xfd, 0x06, 0xdf,
	0x2d, 0x01, 0x99, 0xd8, 0x61, 0xdf, 0xbf, 0xcf, 0x94, 0xff, 0x41, 0x8e, 0x5d, 0x5e, 0xf2, 0x67,
	0x02, 0xc8, 0xa9, 0x5f, 0x80, 0x52, 0xf5, 0x8a, 0xac, 0x4a, 0x2e, 0x50, 0x5a, 0x56, 0xe1, 0x8d,
	0x97, 0x88, 0x4b, 0xd1, 0xa6, 0x2c, 0x70, 0x6d, 0xd3, 0x31, 0x6a, 0x86, 0x63, 0x68, 0xe9, 0x39,
	0x61, 0xa6, 0xd3, 0x70, 0x6b, 0xb6, 0xa3, 0x65, 0x96, 0xc0, 0x6d, 0xab, 0xaa, 0x65, 0xe7, 0x04,
	0x01, 0xdc, 0x79, 0xd9, 0x33, 0xe5, 0xb6, 0x2f, 0x10, 0xfb, 0x2d, 0xa3, 0xe3, 0xee, 0x37, 0x6b,
	0xda, 0xfa, 0x32, 0x44, 0xaf, 0xda, 0xd3, 0x36, 0xe6, 0xe7, 0xd1, 0x73, 0x6b, 0x76, 0xb5, 0xa7,
	0xe5, 0x68, 0x2b, 0x52, 0xe0, 0x66, 0xb5, 0xa3, 0xe5, 0xe7, 0xe4, 0x34, 0x7b, 0x6e, 0xcf, 0xea,
	0x3a, 0x5d, 0x8d, 0x2d, 0x20, 0xf6, 0x1f, 0x71, 0x5d, 0x0b, 0xcb, 0x10, 0x30, 0xb9, 0xcd, 0xb9,
	0x91, 0x9d, 0x6a, 0x8f, 0x33, 0x6c, 0x2d, 0x81, 0x03, 0xfd, 0xf6, 0x1c, 0x7c, 0xaf, 0x86, 0xf4,
	0x17, 0x97, 0xc0, 0x81, 0x5e, 0x9b, 0x1b, 0xd8, 0xae, 0x3a, 0xc8, 0x70, 0x69, 0x19, 0xa2, 0xc6,
	0xcb, 0x81, 0xb9, 0xb5, 0xab, 0xb6, 0x41, 0x59, 0x6e, 0xd9, 0xcb, 0xcb, 0x71, 0xd5, 0x6e, 0xcd,
	0xd4, 0xae, 0xcc, 0xd9, 0xca, 0xb0, 0x7a, 0x6e, 0xb7, 0xa7, 0x5d, 0x9d, 0x53, 0x0c, 0xc0, 0x76,
	0xcf, 0xd0, 0xae, 0x2d, 0x81, 0x3b, 0x3d, 0x43, 0xbb, 0xbe, 0x8c, 0xbe, 0x61, 0x68, 0xc5, 0x65,
	0xf4, 0x0d, 0x43, 0xbb, 0xb1, 0x68, 0xd9, 0xc7, 0x7c, 0x82, 0x37, 0x97, 0x21, 0x60, 0x82, 0x3b,
	0xf3, 0x93, 0x00, 0x44, 0xbd, 0x65, 0x54, 0xcc, 0x96, 0x76, 0x6b, 0xd9, 0x04, 0x1f, 0xe3, 0xe4,
	0x6f, 0x2f, 0xc7, 0xf1, 0xc9, 0x7f, 0xa0, 0xdf, 0x66, 0x37, 0xe6, 0x65, 0x76, 0x6a, 0xae, 0x63,
	0x58, 0xbb, 0xa6, 0xa3, 0xdd, 0x59, 0x36, 0x64, 0xa7, 0xe6, 0xda, 0xad, 0x96, 0x76, 0x77, 0x05,
	0xce, 0x69, 0xb5, 0xb4, 0x7b, 0xb4, 0x5b, 0xcb, 0x58, 0xe9, 0xb5, 0x6c, 0x17, 0x35, 0x2d, 0xcd,
	0xd9, 0x83, 0xa3, 0x9c, 0xaa, 0xf6, 0xe1, 0x7c, 0x78, 0x01, 0xbc, 0xd2, 0xb5, 0xb5, 0x8f, 0xe6,
	0x10, 0xbd, 0x4a, 0xc5, 0x6d, 0xda, 0xcd, 0x9a, 0xf6, 0x31, 0x95, 0x2e, 0xd2, 0xd5, 0xf6, 0x3a,
	0x1d, 0xb3, 0xe5, 0x36, 0x6b, 0xda, 0xd7, 0x96, 0xa9, 0x66, 0xbe, 0x70, 0x1a, 0x35, 0x4b, 0xfb,
	0x7a, 0xf9, 0x73, 0x3c, 0xbd, 0xf0, 0x8f, 0xda, 0x47, 0x43, 0xfd, 0x22, 0x4f, 0x9a, 0xfb, 0xcd,
	0x9a, 0xdb, 0xe9, 0x76, 0x4c, 0xbe, 0x65, 0x6d, 0x13, 0xa0, 0x67, 0x99, 0xb6, 0xd9, 0x71, 0xb4,
	0x77, 0x77, 0xcb, 0xff, 0x31, 0x85, 0x2d, 0xc3, 0xd1, 0xec, 0xe4, 0x31, 0x7d, 0x84, 0x2d, 0x2e,
	0xbe, 0x02, 0x75, 0xd3, 0x6c, 0x2c, 0xec, 0x49, 0x00, 0x03, 0x91, 0x2f, 0x20, 0x77, 0xe0, 0xfe,
	0x06, 0x20, 0xd3, 0xee, 0x69, 0x69, 0x1a, 0x15, 0x9e, 0x8d, 0x3d, 0xa7, 0xa1, 0x65, 0x15, 0x40,
	0x0d, 0x8a, 0xc0, 0x9c, 0x02, 0x80, 0x62, 0x49, 0xd3, 0x14, 0xa9, 0x56, 0x77, 0x0f, 0xf2, 0xdb,
	0x5d, 0x45, 0x6a, 0xa3, 0xdb, 0xd3, 0x9e, 0xd0, 0xce, 0x01, 0xcf, 0x7b, 0x1d, 0xcb, 0xec, 0xc1,
	0x36, 0xa4, 0x82, 0x6c, 0xf3, 0x19, 0x14, 0x0c, 0x3f, 0x4d, 0x27, 0xbe, 0x82, 0xa5, 0x3f, 0xcc,
	0x05, 0x64, 0x06, 0xaf, 0xe1, 0x7b, 0x7b, 0x90, 0x09, 0x71, 0x99, 0x0c, 0x28, 0x72, 0x7b, 0x2f,
	0x5d, 0xc7, 0x69, 0xf1, 0xf2, 0xbe, 0x40, 0xd1, 0xa2, 0xc2, 0x9b, 0x1d, 0x99, 0x0e, 0x0c, 0x2c,
	0x4d, 0x71, 0x51, 0x9d, 0x96, 0x0c, 0x6f, 0xc3, 0x71, 0x6b, 0x66, 0x35, 0x86, 0x6b, 0x54, 0x18,
	0x18, 0x8e, 0xdb, 0xdb, 0xb3, 0x1b, 0x3c, 0xa3, 0x69, 0x97, 0xc8, 0x98, 0x00, 0xec, 0xf6, 0x10,
	0xa6, 0xcf, 0x11, 0x82, 0x04, 0xed, 0x72, 0x92, 0x90, 0xc3, 0xae, 0xc4, 0x84, 0xa0, 0x01, 0x2f,
	0x9d, 0xb4, 0xab, 0x64, 0x45, 0x83, 0x8e, 0x1e, 0xda, 0x35, 0xaa, 0xad, 0x88, 0xaa, 0xf3, 0x9c,
	0x6b, 0x73, 0x3d, 0x86, 0x82, 0x96, 0x04, 0x2d, 0x26, 0x25, 0xd6, 0x9b, 0x66, 0xab, 0xa6, 0xdd,
	0x50, 0x86, 0x06, 0x7d, 0x7a, 0x95, 0x8a, 0x76, 0x93, 0x96, 0x86, 0xd4, 0x01, 0xd0, 0x8e, 0x5e,
	0x14, 0xf3, 0x5e, 0xd8, 0x92, 0xf6, 0xf1, 0x6a, 0x8c, 0xd2, 0xd2, 0xa4, 0xaf, 0x9b, 0x45, 0x75,
	0xdc, 0x6e, 0x25, 0x8e, 0xd2, 0x8c, 0x60, 0x50, 0xbc, 0xfe, 0xb7, 0xf7, 0x19, 0xda, 0xd2, 0x01,
	0xd2, 0xe9, 0xba, 0x95, 0xbd, 0x7a, 0x9d, 0xe4, 0xfe, 0x17, 0xe1, 0xa2, 0xca, 0x17, 0x8c, 0x7c,
	0x6d, 0xc9, 0x71, 0xd4, 0x8a, 0x18, 0xe7, 0xdb, 0x74, 0xdc, 0xdd, 0xae, 0xd3, 0xa5, 0xe3, 0x77,
	0x8a, 0xe2, 0xa9, 0xe9, 0xb8, 0xcf, 0xad, 0xa6, 0x63, 0xaa, 0x3b, 0x1c, 0x86, 0xa0, 0xc4, 0x18,
	0x55, 0xa7, 0xd9, 0xed, 0xd8, 0x5a, 0x26, 0x46, 0x18, 0xbd, 0x5e, 0xeb, 0xa5, 0x44, 0x64, 0x63,
	0x44, 0xb5, 0x65, 0x1a, 0x96, 0x44, 0xac, 0x09, 0xbf, 0xa6, 0xf3, 0x8a, 0xb6, 0x4e, 0x96, 0x6a,
	0x2e, 0xb1, 0xd4, 0x5f, 0xc7, 0x09, 0xcd, 0x7f, 0xb9, 0x48, 0x05, 0x45, 0xbd, 0x9a, 0xa8, 0x54,
	0xea, 0x55, 0x51, 0x97, 0x88, 0x9d, 0x5a, 0x42, 0x5c, 0xdb, 0xb1, 0x9a, 0x55, 0x38, 0x9e, 0x4b,
	0x52, 0x2a, 0x6a, 0x32, 0x31, 0x29, 0x42, 0x04, 0x69, 0xb6, 0xfc, 0xcf, 0xe8, 0x4d, 0xa9, 0x1c,
	0x1d, 0xe3, 0x1d, 0x8d, 0x59, 0x57, 0x4b, 0x50, 0x12, 0x51, 0x77, 0x6d, 0xb3, 0x53, 0x93, 0x07,
	0xe7, 0x58, 0x8d, 0xba, 0x5b, 0x6d, 0x98, 0xd5, 0xa7, 0x6e, 0x77, 0xdf, 0xb4, 0x5a, 0x46, 0x4f,
	0x16, 0x0c, 0xf5, 0xba, 0x0b, 0x09, 0x06, 0x22, 0x69, 0xaf, 0xe3, 0xc4, 0x46, 0xab, 0xd7, 0x79,
	0xa9, 0xfd, 0x54, 0x22, 0x72, 0x09, 0x44, 0xe5, 0xa5, 0x44, 0x68, 0x65, 0x1b, 0x8f, 0x3e, 0xf8,
	0x8d, 0x39, 0xce, 0x6e, 0x77, 0xa1, 0x11, 0xb3, 0xab, 0x34, 0x62, 0x04, 0x24, 0xee, 0x9a, 0x48,
	0x88, 0x6c, 0x84, 0x7c, 0x81, 0xef, 0x03, 0x17, 0xbe, 0x05, 0x24, 0xc3, 0xef, 0x26, 0x0d, 0xbf,
	0xab, 0x18, 0x5e, 0x42, 0xc8, 0xbe, 0xe9, 0xb2, 0xad, 0x5e, 0x26, 0xe1, 0xee, 0x48, 0x42, 0xf0,
	0xf4, 0x25, 0x85, 0x40, 0x90, 0xb5, 0xcc, 0x2a, 0xe4, 0x4a, 0x0c, 0x83, 0x5d, 0xf0, 0xd7, 0x5a,
	0xd3, 0x32, 0xf9, 0xc2, 0x6d, 0xa2, 0x92, 0x8e, 0x5b, 0xaf, 0x6b, 0x99, 0x72, 0x0f, 0x1d, 0x63,
	0xfe, 0x8b, 0x39, 0x5a, 0x1c, 0x0b, 0xac, 0xd4, 0x36, 0x9c, 0x6a, 0x43, 0xbb, 0x40, 0xee, 0x26,
	0x1c, 0x50, 0x1e, 0xd8, 0x2c, 0x61, 0x24, 0x1e, 0xea, 0xe9, 0xf2, 0xdf, 0x4b, 0xe1, 0xbb, 0x9c,
	0x25, 0xdf, 0xa2, 0xd1, 0x6a, 0x59, 0x96, 0xdb, 0xac, 0xb5, 0x4c, 0xd7, 0x69, 0xb6, 0xcd, 0xae,
	0x92, 0x21, 0x2d, 0xcb, 0x6d, 0x18, 0x56, 0x4d, 0xc2, 0x85, 0x11, 0x2c, 0x59, 0x39, 0xa7, 0x63,
	0x4a, 0x3c, 0xfa, 0x49, 0xe7, 0x93, 0x70, 0x3c, 0xbb, 0x13, 0x3c, 0x5b, 0x9e, 0xd2, 0x1f, 0x1c,
	0xe3, 0xaf, 0xdf, 0xa9, 0x7c, 0x76, 0x7f, 0x68, 0x5a, 0x5d, 0xb9, 0xa4, 0x6d, 0x5c, 0xd2, 0x77,
	0x3f, 0x7d, 0xbf, 0xa1, 0x5f, 0xe5, 0xb3, 0x6e, 0xbb, 0x76, 0xab, 0xfb, 0xbc, 0x67, 0x38, 0x0d,
	0x6a, 0x7a, 0x61, 0x37, 0xac, 0xad, 0x76, 0xc3, 0xd4, 0xce, 0x57, 0x1b, 0x4f, 0xbf, 0x7c, 0xc1,
	0x27, 0x0b, 0x5f, 0x3b, 0xa9, 0xc5, 0x7c, 0x45, 0xcd, 0x1c, 0x68, 0x4f, 0x80, 0xd1, 0x39, 0x1f,
	0xe7, 0xc0, 0x01, 0x76, 0x15, 0xce, 0xb0, 0x6d, 0xc3, 0x7a, 0xaa, 0x89, 0xa2, 0x1c, 0xe0, 0x0b,
	0x71, 0xfd, 0x85, 0xfa, 0xe9, 0xda, 0xa2, 0x7f, 0xb5, 0x93, 0xfe, 0xd5, 0x5e, 0xf0, 0xaf, 0xb6,
	0xe2, 0x5f, 0x87, 0xea, 0xfd, 0x00, 0x35, 0x44, 0xdb, 0xf5, 0x44, 0x07, 0x80, 0x21, 0xe8, 0x69,
	0xa5, 0x07, 0xa7, 0x76, 0x9a, 0x45, 0x1d, 0xa2, 0xac, 0x67, 0xcb, 0xfd, 0xb8, 0x5d, 0x77, 0x2b,
	0x7b, 0x96, 0xed, 0xc8, 0xfd, 0xb8, 0x5d, 0x17, 0xe7, 0xf4, 0xf2, 0x3f, 0xa7, 0xeb, 0x89, 0xd8,
	0x19, 0xe5, 0xf6, 0xc1, 0xa9, 0x9b, 0xd4, 0x24, 0x74, 0xeb, 0x46, 0xb3, 0x65, 0xc2, 0x68, 0xb8,
	0x45, 0x9a, 0x8e, 0x5b, 0x31, 0x6a, 0xb2, 0xad, 0x23, 0x3c, 0x8f, 0xc0, 0xe4, 0x8f, 0x69, 0xaa,
	0x94, 0x08, 0xda, 0xec, 0xd8, 0x8e, 0xb5, 0x87, 0xa8, 0x0c, 0xed, 0x3f, 0x84, 0x42, 0x87, 0xce,
	0xc6, 0xf4, 0xa2, 0xbf, 0x26, 0xc6, 0x5d, 0xa3, 0xaa, 0xc7, 0x54, 0xfa, 0x6c, 0x02, 0xb7, 0x1e,
	0xb3, 0x89, 0x7e, 0x9b, 0x40, 0x6d, 0xc4, 0x6c, 0xb2, 0xef, 0x26, 0x70, 0xb9, 0x98, 0x0d, 0x7b,
	0x11, 0xdd, 0x9e, 0x40, 0xe5, 0xf5, 0x0f, 0xd8, 0x4d, 0x44, 0xd9, 0xcf, 0x9b, 0x4e, 0xb5, 0x21,
	0x9a, 0x61, 0x84, 0x67, 0x54, 0x59, 0x9a, 0xc9, 0x76, 0x98, 0x40, 0x17, 0xe2, 0x51, 0x65, 0xdf,
	0x4a, 0xe0, 0x36, 0xa9, 0xd3, 0x26, 0x35, 0x92, 0x5d, 0x50, 0x22, 0xd8, 0xa2, 0x3d, 0xc3, 0x5c,
	0xe2, 0x5b, 0x15, 0xf5, 0xcf, 0x89, 0xbe, 0xea, 0x8f, 0xc6, 0xfc, 0x9a, 0x2a, 0xff, 0x6b, 0x5c,
	0xe0, 0x8f, 0x8d, 0x7a, 0xd5, 0x6d, 0x76, 0xaa, 0xdd, 0x76, 0xcf, 0x70, 0x9a, 0xb0, 0xeb, 0x09,
	0x2f, 0x03, 0x84, 0xd9, 0x33, 0x2d, 0x38, 0xa1, 0xfe, 0x79, 0x1a, 0xf3, 0xcb, 0x41, 0x7f, 0x28,
	0xde, 0x50, 0xa2, 0x0c, 0x5c, 0xf0, 0x8a, 0x55, 0xe5, 0x2b, 0x42, 0xfd, 0x32, 0xd9, 0xe5, 0x10,
	0x70, 0x5e, 0x75, 0x8b, 0xdd, 0x54, 0x00, 0x65, 0x8f, 0x52, 0x4b, 0x53, 0x13, 0x57, 0x60, 0x12,
	0x53, 0x10, 0x1b, 0x92, 0x82, 0x44, 0x79, 0xa2, 0x33, 0x03, 0x08, 0xd4, 0x73, 0x8d, 0xe2, 0x53,
	0x90, 0xb6, 0xcc, 0x8e, 0x3c, 0x29, 0x72, 0x18, 0x2f, 0x0d, 0x5c, 0xb3, 0xdd, 0x73, 0x5e, 0xca,
	0xe6, 0xb0, 0x82, 0xd8, 0xeb, 0x3c, 0xed, 0x74, 0x9f, 0x77, 0xe4, 0xee, 0x22, 0xd5, 0xe7, 0x36,
	0x6f, 0xc2, 0x12, 0xc7, 0xf3, 0x6a, 0xda, 0xae, 0xdd, 0x32, 0xf6, 0x4d, 0x8d, 0xcd, 0x4d, 0x96,
	0x9f, 0x8d, 0x45, 0x55, 0x28, 0x81, 0xbc, 0x4d, 0xa4, 0x6d, 0xea, 0x1f, 0xb1, 0xbb, 0x04, 0x8e,
	0x7b, 0xb4, 0x34, 0x3c, 0xec, 0x86, 0xe0, 0xc2, 0xda, 0x56, 0xf9, 0xf7, 0x33, 0x98, 0x7f, 0xc0,
	0xde, 0x54, 0x94, 0x72, 0x73, 0xd3, 0x48, 0x86, 0x62, 0x56, 0xd1, 0x6b, 0x14, 0x40, 0x98, 0x74,
	0x4a, 0x18, 0xd4, 0x58, 0x62, 0x50, 0x51, 0xbb, 0x28, 0x48, 0x94, 0x94, 0x99, 0x43, 0x74, 0xf7,
	0x30, 0x36, 0xe4, 0x36, 0x2c, 0x10, 0x86, 0xb5, 0xbb, 0x07, 0xc2, 0xb4, 0x35, 0xb1, 0x04, 0x86,
	0x58, 0x82, 0x75, 0x45, 0x45, 0xa7, 0x0b, 0x9b, 0x4e, 0x07, 0x4c, 0x8d, 0x81, 0x2e, 0xf8, 0xb1,
	0x14, 0xcd, 0x09, 0x7f, 0x50, 0x86, 0xc3, 0x9a, 0x34, 0x4f, 0x91, 0x02, 0x18, 0x1e, 0xe4, 0xdc,
	0x41, 0x3b, 0x76, 0xd3, 0x76, 0x60, 0x54, 0xa6, 0xdf, 0x62, 0x45, 0x42, 0xef, 0x75, 0xec, 0xbd,
	0x1e, 0x28, 0x69, 0xd6, 0xdc, 0xae, 0x55, 0x33, 0x2d, 0xad, 0x30, 0x67, 0x0f, 0xc7, 0xd8, 0xd5,
	0x36, 0xe7, 0x26, 0x00, 0x25, 0x06, 0x9f, 0xb2, 0x38, 0x9c, 0xab, 0x08, 0x30, 0xe0, 0xf6, 0x9c,
	0x01, 0x79, 0x77, 0x59, 0xcc, 0xfa, 0x62, 0xf9, 0x2f, 0x52, 0xac, 0x28, 0x96, 0x47, 0x2d, 0x2e,
	0x95, 0xb0, 0xaa, 0x34, 0xab, 0xc2, 0x9f, 0x78, 0x0e, 0x93, 0x49, 0x10, 0x11, 0xf6, 0x5e, 0x0f,
	0xc1, 0x29, 0x85, 0x3e, 0xe1, 0x6b, 0x22, 0x0f, 0xc6, 0xf4, 0xb2, 0xfa, 0xcc, 0x50, 0xa6, 0x59,
	0x44, 0x61, 0xff, 0x37, 0x2b, 0xb4, 0x6f, 0x2e, 0x59, 0xfe, 0xb5, 0xb9, 0x01, 0xe5, 0xf2, 0xaf,
	0x0b, 0xc3, 0x35, 0x63, 0x47, 0xda, 0x10, 0x0b, 0xdc, 0x14, 0x0b, 0x9c, 0x2b, 0xff, 0x0b, 0xfa,
	0xf0, 0x00, 0x26, 0x8f, 0x7d, 0x2e, 0xd5, 0x35, 0xdb, 0xcb, 0x5c, 0xb3, 0xad, 0xba, 0x66, 0x12,
	0x06, 0xcb, 0x23, 0xe3, 0x9f, 0x60, 0xb5, 0x16, 0x6c, 0x77, 0x16, 0x35, 0xb3, 0xe7, 0x90, 0x9d,
	0xe7, 0x0a, 0x32, 0x2b, 0x7c, 0x88, 0x90, 0xcf, 0x9b, 0xad, 0x5a, 0xd5, 0xb0, 0x6a, 0x50, 0x56,
	0x93, 0xcf, 0x11, 0x06, 0x0f, 0x2b, 0xeb, 0x73, 0xd0, 0x7d, 0xa3, 0xb5, 0x67, 0x6a, 0x1b, 0x73,
	0xca, 0x73, 0xd1, 0xa2, 0x63, 0x24, 0x80, 0x3d, 0xcb, 0xb4, 0xcc, 0x67, 0x5a, 0x5e, 0x91, 0x50,
	0xdb, 0xeb, 0x91, 0x5c, 0x26, 0xec, 0xd4, 0x16, 0x76, 0x2a, 0x94, 0xff, 0x88, 0x9c, 0x24, 0x2e,
	0x97, 0x95, 0xdc, 0x8b, 0x03, 0xd6, 0xdb, 0x75, 0xe9, 0x25, 0xb2, 0x7c, 0xe2, 0x40, 0x4a, 0xf3,
	0x7b, 0xad, 0x96, 0xcc, 0x9b, 0x1c, 0x3e, 0xe7, 0x22, 0x8a, 0x18, 0x51, 0x4b, 0x67, 0x44, 0x41,
	0xde, 0x96, 0xf9, 0x5b, 0x96, 0xd1, 0x52, 0x02, 0x55, 0x66, 0x6b, 0xf3, 0x88, 0x6a, 0xb7, 0xdd,
	0x36, 0x3a, 0x60, 0x27, 0x9c, 0xbc, 0x44, 0xd4, 0x5b, 0xc6, 0xae, 0xad, 0x6d, 0x94, 0xff, 0x20,
	0x83, 0x5f, 0xae, 0xc5, 0x95, 0xb0, 0x3a, 0x2b, 0x54, 0x74, 0x17, 0x98, 0x70, 0xc3, 0x35, 0x5f,
	0x34, 0x6d, 0xc7, 0x96, 0xef, 0x2a, 0x38, 0x46, 0x94, 0x99, 0x18, 0xeb, 0x29, 0xf2, 0x65, 0x8e,
	0x7a, 0x6e, 0x36, 0x77, 0x1b, 0x8e, 0x1a, 0xd4, 0x32, 0x0c, 0x38, 0x1e, 0x52, 0x44, 0xb7, 0x8e,
	0x9c, 0x70, 0xd6, 0xc2, 0x1d, 0x53, 0x45, 0x55, 0xf6, 0x20, 0xcf, 0xc2, 0xc9, 0xe1, 0x2e, 0xbb,
	0x25, 0x70, 0xd5, 0x86, 0xd1, 0xec, 0x34, 0x3b, 0xbb, 0x09, 0xc1, 0x6b, 0x94, 0x64, 0x70, 0x60,
	0x9e, 0x65, 0x54, 0xf4, 0xba, 0x28, 0xc3, 0x01, 0xdd, 0xea, 0x76, 0x7b, 0x72, 0xc3, 0xd8, 0x55,
	0x16, 0x8d, 0x26, 0x91, 0x53, 0x51, 0x7c, 0x34, 0xb3, 0x26, 0x73, 0x19, 0xfa, 0xcb, 0xae, 0xb4,
	0x3d, 0x44, 0x86, 0x68, 0x2f, 0xee, 0xce, 0x1b, 0xbe, 0x40, 0x4e, 0x20, 0x11, 0x38, 0x21, 0x6d,
	0x93, 0x16, 0x44, 0xc2, 0xb9, 0xc6, 0xf2, 0xdd, 0xe2, 0x6e, 0xbc, 0xd8, 0xdb, 0xe5, 0xdf, 0x25,
	0xc7, 0x13, 0x7f, 0x29, 0x38, 0xb1, 0x44, 0xa8, 0x4d, 0x4f, 0x88, 0xa1, 0x26, 0x2f, 0x6a, 0x23,
	0xa1, 0x0d, 0x8c, 0x31, 0x59, 0xcb, 0xf6, 0x62, 0x35, 0xf9, 0x8b, 0x52, 0xb1, 0x28, 0x12, 0x6e,
	0xd4, 0xf6, 0x4d, 0xcb, 0x69, 0xda, 0xa6, 0x74, 0xbf, 0x9e, 0xe2, 0x7e, 0xe5, 0xbf, 0x8a, 0x4e,
	0x23, 0xff, 0x9c, 0x76, 0x42, 0x23, 0x7a, 0x47, 0x98, 0xf0, 0x6e, 0x19, 0x0c, 0xce, 0xdc, 0xc8,
	0xe2, 0x5d, 0x86, 0x13, 0x8b, 0x4f, 0x97, 0x7f, 0x88, 0xf3, 0xc5, 0xdb, 0x5f, 0xfe, 0x6c, 0xc9,
	0x7c, 0x9f, 0x75, 0x93, 0xf3, 0xc5, 0x31, 0x25, 0x14, 0x37, 0x24, 0x21, 0x9b, 0x83, 0x85, 0xec,
	0xbf, 0xc6, 0x6e, 0x2f, 0xfc, 0x61, 0xf1, 0x25, 0xea, 0xdb, 0xd5, 0x44, 0xa0, 0x88, 0x02, 0x48,
	0x82, 0x31, 0xf5, 0xa1, 0x7c, 0x0e, 0x8c, 0x75, 0xbf, 0x35, 0x7f, 0xf7, 0x2b, 0x21, 0x9e, 0x0e,
	0x70, 0x56, 0xbd, 0x0a, 0x75, 0x37, 0xb7, 0x8c, 0x02, 0xe2, 0x1e, 0x1b, 0x1f, 0xe1, 0x2c, 0x1a,
	0x0d, 0xea, 0x4b, 0x2d, 0x5d, 0xfe, 0xc3, 0x34, 0xda, 0x3d, 0x3e, 0x56, 0x2c, 0xa6, 0xa0, 0x76,
	0x32, 0x05, 0x61, 0x04, 0x73, 0x20, 0x56, 0xa1, 0x14, 0xc1, 0x29, 0x5a, 0xf1, 0xb6, 0x1a, 0xc1,
	0xd8, 0xaf, 0x48, 0xab, 0x28, 0x11, 0x17, 0x88, 0x12, 0x15, 0x45, 0x7b, 0xde, 0xcd, 0xb3, 0x64,
	0xb6, 0x76, 0x32, 0xbf, 0x88, 0xa4, 0x2d, 0xc1, 0x96, 0xe1, 0x98, 0x32, 0x19, 0xb5, 0xe3, 0x98,
	0xb0, 0xf8, 0xdb, 0xfd, 0x39, 0xe2, 0x0a, 0x48, 0xce, 0xd1, 0x76, 0x91, 0x80, 0xba, 0x35, 0xd3,
	0x31, 0x9a, 0x2d, 0x2d, 0xaf, 0xaa, 0x4a, 0x19, 0x83, 0x6b, 0x6a, 0x6b, 0x4c, 0x9d, 0xba, 0x48,
	0x26, 0x46, 0xa7, 0x66, 0x6b, 0x85, 0xf2, 0xbf, 0x4c, 0x2d, 0xf9, 0x16, 0x31, 0x5c, 0xe6, 0xc4,
	0xf5, 0x39, 0x27, 0xa6, 0xf7, 0xd6, 0x02, 0x2c, 0x77, 0x70, 0xb1, 0x62, 0x31, 0x03, 0x64, 0x05,
	0x79, 0x59, 0xa2, 0xae, 0x78, 0x4d, 0x66, 0x5e, 0x88, 0xac, 0x43, 0xb2, 0x22, 0x16, 0xea, 0xd2,
	0x9f, 0xd6, 0xca, 0xff, 0x99, 0x76, 0xe7, 0xe4, 0x5f, 0x2a, 0x10, 0xc7, 0x3d, 0x38, 0x69, 0xdb,
	0xd5, 0xf8, 0xf8, 0xc7, 0xef, 0x8f, 0x3c, 0x97, 0xef, 0xa6, 0xdb, 0x3d, 0xd7, 0xd8, 0xdd, 0xb5,
	0xcc, 0x5d, 0x83, 0x1f, 0xd2, 0xe9, 0xc4, 0x27, 0x6e, 0xa3, 0x64, 0x84, 0xc1, 0x7b, 0xc9, 0xb7,
	0xb8, 0x92, 0x0c, 0xc3, 0x68, 0x2d, 0x06, 0x60, 0x0a, 0x5c, 0x8f, 0xf9, 0xc4, 0x69, 0xdf, 0xae,
	0x6a, 0x1b, 0xc2, 0xe0, 0x02, 0x2a, 0xce, 0x34, 0xb2, 0xd3, 0xdb, 0xee, 0x91, 0x1b, 0xe5, 0xc5,
	0x91, 0x9a, 0x00, 0x22, 0x19, 0xb0, 0x58, 0x04, 0xc2, 0xa5, 0x88, 0x42, 0x8c, 0x49, 0x1e, 0x98,
	0xe4, 0x15, 0x0d, 0x31, 0x09, 0xae, 0x8b, 0x38, 0x3e, 0xb5, 0x7b, 0xcb, 0x8e, 0xe6, 0x3b, 0x4b,
	0xff, 0x42, 0x85, 0x2b, 0xbe, 0xb6, 0x47, 0xc6, 0x3a, 0x9c, 0xe7, 0x16, 0x5e, 0xf3, 0x0a, 0x78,
	0xbb, 0x6b, 0x99, 0x5a, 0xaa, 0xdc, 0xa2, 0x78, 0x4c, 0xfe, 0xd5, 0x09, 0x92, 0x24, 0x34, 0xae,
	0xe3, 0xdd, 0x06, 0x45, 0x16, 0xb9, 0xbf, 0xc4, 0x90, 0xb4, 0x3f, 0xcb, 0xa0, 0x6a, 0x2b, 0xbe,
	0xc7, 0x96, 0x7e, 0xd3, 0x73, 0xd4, 0x53, 0x34, 0x24, 0x27, 0xdc, 0xf9, 0x16, 0x30, 0x6e, 0xbb,
	0x69, 0xdb, 0xb2, 0x22, 0xe5, 0xe8, 0x8e, 0xf9, 0x82, 0xce, 0x9c, 0xb6, 0x96, 0xa6, 0xba, 0x7b,
	0x1e, 0x81, 0x6c, 0x19, 0x71, 0x1f, 0x01, 0xb0, 0xc9, 0xa6, 0x68, 0x96, 0xf6, 0xf8, 0x45, 0x14,
	0xb2, 0xae, 0xa9, 0xac, 0xc9, 0xb6, 0xe9, 0xba, 0xca, 0x9a, 0x40, 0x21, 0xeb, 0x86, 0x8c, 0x81,
	0x9e, 0x43, 0x0d, 0x81, 0x9c, 0x0c, 0x46, 0x18, 0x4d, 0x16, 0x84, 0x4c, 0x5c, 0x30, 0x89, 0x95,
	0xb0, 0x4d, 0x07, 0xcb, 0x37, 0x71, 0xbe, 0x5e, 0x82, 0xc3, 0x61, 0xb6, 0x54, 0x66, 0x54, 0x43,
	0x32, 0x6f, 0xab, 0xcc, 0x49, 0x1c, 0x32, 0x5f, 0xd4, 0x6f, 0xc6, 0x2b, 0x91, 0xf0, 0xaf, 0x9f,
	0xbd, 0xcf, 0xe8, 0x77, 0xe2, 0xb5, 0x50, 0x71, 0xc8, 0x0a, 0x0e, 0xf8, 0x7b, 0xf4, 0x27, 0x3a,
	0xb0, 0xe4, 0x4a, 0xdc, 0xc8, 0xa0, 0xbe, 0x60, 0xbd, 0xba, 0x70, 0x7b, 0x05, 0x60, 0xd8, 0x3e,
	0xa4, 0xa2, 0x4a, 0x4b, 0x89, 0x6a, 0x29, 0xc6, 0xb4, 0x9a, 0xfb, 0x66, 0xc7, 0xb4, 0xe3, 0xeb,
	0x19, 0xbb, 0x4a, 0xb1, 0xa4, 0x65, 0x15, 0x06, 0x59, 0x41, 0xf1, 0xbe, 0xad, 0xad, 0xe5, 0xca,
	0xaf, 0xb1, 0x21, 0x10, 0x5f, 0x79, 0xc7, 0x5b, 0xee, 0x62, 0x0b, 0x55, 0x1b, 0x64, 0xa8, 0xe5,
	0x33, 0xc7, 0x6d, 0x37, 0x3b, 0x98, 0xd1, 0x53, 0x0a, 0xcc, 0x78, 0x81, 0xb0, 0x34, 0xc5, 0xe0,
	0xb3, 0x25, 0x2d, 0x8c, 0x1f, 0xe1, 0x69, 0x78, 0xee, 0xce, 0x33, 0xf9, 0x69, 0xd5, 0xc2, 0x7e,
	0x4a, 0xa7, 0x5b, 0x6d, 0x18, 0x9d, 0x5d, 0x53, 0x36, 0xf3, 0x05, 0xc2, 0x7c, 0xb6, 0x67, 0xb4,
	0xe4, 0x05, 0x35, 0x01, 0x6d, 0x1b, 0x36, 0xee, 0x5e, 0x49, 0x62, 0x3c, 0xd3, 0x67, 0x2a, 0x7b,
	0xec, 0x03, 0x3f, 0x38, 0xe4, 0xb7, 0x00, 0x07, 0x7e, 0x30, 0xfc, 0x14, 0xff, 0x17, 0x19, 0x79,
	0x2b, 0xf0, 0xc1, 0xe7, 0x3f, 0xfc, 0xfc, 0x70, 0x14, 0x1d, 0x1d, 0x1f, 0x7c, 0x3a, 0xf0, 0x27,
	0xf7, 0x05, 0xd9, 0x7d, 0x24, 0xfb, 0x15, 0xfa, 0xcf, 0x66, 0x4e, 0x1e, 0xdd, 0x3f, 0xf4, 0xd5,
	0xff, 0x72, 0xe6, 0x60, 0x9d, 0x63, 0x3e, 0xff, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x5b, 0x23,
	0xc1, 0x5b, 0x96, 0x66, 0x00, 0x00,
}
