// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/events.proto

package voltha

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	common "github.com/opencord/voltha-protos/v5/go/common"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type EventFilterRuleKey_EventFilterRuleType int32

const (
	EventFilterRuleKey_filter_all        EventFilterRuleKey_EventFilterRuleType = 0
	EventFilterRuleKey_category          EventFilterRuleKey_EventFilterRuleType = 1
	EventFilterRuleKey_sub_category      EventFilterRuleKey_EventFilterRuleType = 2
	EventFilterRuleKey_kpi_event_type    EventFilterRuleKey_EventFilterRuleType = 3
	EventFilterRuleKey_config_event_type EventFilterRuleKey_EventFilterRuleType = 4
	EventFilterRuleKey_device_event_type EventFilterRuleKey_EventFilterRuleType = 5
)

var EventFilterRuleKey_EventFilterRuleType_name = map[int32]string{
	0: "filter_all",
	1: "category",
	2: "sub_category",
	3: "kpi_event_type",
	4: "config_event_type",
	5: "device_event_type",
}

var EventFilterRuleKey_EventFilterRuleType_value = map[string]int32{
	"filter_all":        0,
	"category":          1,
	"sub_category":      2,
	"kpi_event_type":    3,
	"config_event_type": 4,
	"device_event_type": 5,
}

func (x EventFilterRuleKey_EventFilterRuleType) String() string {
	return proto.EnumName(EventFilterRuleKey_EventFilterRuleType_name, int32(x))
}

func (EventFilterRuleKey_EventFilterRuleType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{0, 0}
}

type ConfigEventType_Types int32

const (
	ConfigEventType_add    ConfigEventType_Types = 0
	ConfigEventType_remove ConfigEventType_Types = 1
	ConfigEventType_update ConfigEventType_Types = 2
)

var ConfigEventType_Types_name = map[int32]string{
	0: "add",
	1: "remove",
	2: "update",
}

var ConfigEventType_Types_value = map[string]int32{
	"add":    0,
	"remove": 1,
	"update": 2,
}

func (x ConfigEventType_Types) String() string {
	return proto.EnumName(ConfigEventType_Types_name, int32(x))
}

func (ConfigEventType_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{4, 0}
}

type KpiEventType_Types int32

const (
	KpiEventType_slice KpiEventType_Types = 0
	KpiEventType_ts    KpiEventType_Types = 1
)

var KpiEventType_Types_name = map[int32]string{
	0: "slice",
	1: "ts",
}

var KpiEventType_Types_value = map[string]int32{
	"slice": 0,
	"ts":    1,
}

func (x KpiEventType_Types) String() string {
	return proto.EnumName(KpiEventType_Types_name, int32(x))
}

func (KpiEventType_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{6, 0}
}

type EventCategory_Types int32

const (
	EventCategory_COMMUNICATION EventCategory_Types = 0
	EventCategory_ENVIRONMENT   EventCategory_Types = 1
	EventCategory_EQUIPMENT     EventCategory_Types = 2
	EventCategory_SERVICE       EventCategory_Types = 3
	EventCategory_PROCESSING    EventCategory_Types = 4
	EventCategory_SECURITY      EventCategory_Types = 5
)

var EventCategory_Types_name = map[int32]string{
	0: "COMMUNICATION",
	1: "ENVIRONMENT",
	2: "EQUIPMENT",
	3: "SERVICE",
	4: "PROCESSING",
	5: "SECURITY",
}

var EventCategory_Types_value = map[string]int32{
	"COMMUNICATION": 0,
	"ENVIRONMENT":   1,
	"EQUIPMENT":     2,
	"SERVICE":       3,
	"PROCESSING":    4,
	"SECURITY":      5,
}

func (x EventCategory_Types) String() string {
	return proto.EnumName(EventCategory_Types_name, int32(x))
}

func (EventCategory_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{14, 0}
}

type EventSubCategory_Types int32

const (
	EventSubCategory_PON  EventSubCategory_Types = 0
	EventSubCategory_OLT  EventSubCategory_Types = 1
	EventSubCategory_ONT  EventSubCategory_Types = 2
	EventSubCategory_ONU  EventSubCategory_Types = 3
	EventSubCategory_NNI  EventSubCategory_Types = 4
	EventSubCategory_NONE EventSubCategory_Types = 5
)

var EventSubCategory_Types_name = map[int32]string{
	0: "PON",
	1: "OLT",
	2: "ONT",
	3: "ONU",
	4: "NNI",
	5: "NONE",
}

var EventSubCategory_Types_value = map[string]int32{
	"PON":  0,
	"OLT":  1,
	"ONT":  2,
	"ONU":  3,
	"NNI":  4,
	"NONE": 5,
}

func (x EventSubCategory_Types) String() string {
	return proto.EnumName(EventSubCategory_Types_name, int32(x))
}

func (EventSubCategory_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{15, 0}
}

type EventType_Types int32

const (
	EventType_CONFIG_EVENT EventType_Types = 0
	EventType_KPI_EVENT    EventType_Types = 1
	EventType_KPI_EVENT2   EventType_Types = 2
	EventType_DEVICE_EVENT EventType_Types = 3
	EventType_RPC_EVENT    EventType_Types = 4
)

var EventType_Types_name = map[int32]string{
	0: "CONFIG_EVENT",
	1: "KPI_EVENT",
	2: "KPI_EVENT2",
	3: "DEVICE_EVENT",
	4: "RPC_EVENT",
}

var EventType_Types_value = map[string]int32{
	"CONFIG_EVENT": 0,
	"KPI_EVENT":    1,
	"KPI_EVENT2":   2,
	"DEVICE_EVENT": 3,
	"RPC_EVENT":    4,
}

func (x EventType_Types) String() string {
	return proto.EnumName(EventType_Types_name, int32(x))
}

func (EventType_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{16, 0}
}

type EventFilterRuleKey struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventFilterRuleKey) Reset()         { *m = EventFilterRuleKey{} }
func (m *EventFilterRuleKey) String() string { return proto.CompactTextString(m) }
func (*EventFilterRuleKey) ProtoMessage()    {}
func (*EventFilterRuleKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{0}
}

func (m *EventFilterRuleKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventFilterRuleKey.Unmarshal(m, b)
}
func (m *EventFilterRuleKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventFilterRuleKey.Marshal(b, m, deterministic)
}
func (m *EventFilterRuleKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventFilterRuleKey.Merge(m, src)
}
func (m *EventFilterRuleKey) XXX_Size() int {
	return xxx_messageInfo_EventFilterRuleKey.Size(m)
}
func (m *EventFilterRuleKey) XXX_DiscardUnknown() {
	xxx_messageInfo_EventFilterRuleKey.DiscardUnknown(m)
}

var xxx_messageInfo_EventFilterRuleKey proto.InternalMessageInfo

type EventFilterRule struct {
	Key                  EventFilterRuleKey_EventFilterRuleType `protobuf:"varint,1,opt,name=key,proto3,enum=event.EventFilterRuleKey_EventFilterRuleType" json:"key,omitempty"`
	Value                string                                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *EventFilterRule) Reset()         { *m = EventFilterRule{} }
func (m *EventFilterRule) String() string { return proto.CompactTextString(m) }
func (*EventFilterRule) ProtoMessage()    {}
func (*EventFilterRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{1}
}

func (m *EventFilterRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventFilterRule.Unmarshal(m, b)
}
func (m *EventFilterRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventFilterRule.Marshal(b, m, deterministic)
}
func (m *EventFilterRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventFilterRule.Merge(m, src)
}
func (m *EventFilterRule) XXX_Size() int {
	return xxx_messageInfo_EventFilterRule.Size(m)
}
func (m *EventFilterRule) XXX_DiscardUnknown() {
	xxx_messageInfo_EventFilterRule.DiscardUnknown(m)
}

var xxx_messageInfo_EventFilterRule proto.InternalMessageInfo

func (m *EventFilterRule) GetKey() EventFilterRuleKey_EventFilterRuleType {
	if m != nil {
		return m.Key
	}
	return EventFilterRuleKey_filter_all
}

func (m *EventFilterRule) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type EventFilter struct {
	Id                   string             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Enable               bool               `protobuf:"varint,2,opt,name=enable,proto3" json:"enable,omitempty"`
	DeviceId             string             `protobuf:"bytes,3,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	EventType            string             `protobuf:"bytes,4,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	Rules                []*EventFilterRule `protobuf:"bytes,5,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *EventFilter) Reset()         { *m = EventFilter{} }
func (m *EventFilter) String() string { return proto.CompactTextString(m) }
func (*EventFilter) ProtoMessage()    {}
func (*EventFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{2}
}

func (m *EventFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventFilter.Unmarshal(m, b)
}
func (m *EventFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventFilter.Marshal(b, m, deterministic)
}
func (m *EventFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventFilter.Merge(m, src)
}
func (m *EventFilter) XXX_Size() int {
	return xxx_messageInfo_EventFilter.Size(m)
}
func (m *EventFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EventFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EventFilter proto.InternalMessageInfo

func (m *EventFilter) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *EventFilter) GetEnable() bool {
	if m != nil {
		return m.Enable
	}
	return false
}

func (m *EventFilter) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *EventFilter) GetEventType() string {
	if m != nil {
		return m.EventType
	}
	return ""
}

func (m *EventFilter) GetRules() []*EventFilterRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

type EventFilters struct {
	Filters              []*EventFilter `protobuf:"bytes,1,rep,name=filters,proto3" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *EventFilters) Reset()         { *m = EventFilters{} }
func (m *EventFilters) String() string { return proto.CompactTextString(m) }
func (*EventFilters) ProtoMessage()    {}
func (*EventFilters) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{3}
}

func (m *EventFilters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventFilters.Unmarshal(m, b)
}
func (m *EventFilters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventFilters.Marshal(b, m, deterministic)
}
func (m *EventFilters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventFilters.Merge(m, src)
}
func (m *EventFilters) XXX_Size() int {
	return xxx_messageInfo_EventFilters.Size(m)
}
func (m *EventFilters) XXX_DiscardUnknown() {
	xxx_messageInfo_EventFilters.DiscardUnknown(m)
}

var xxx_messageInfo_EventFilters proto.InternalMessageInfo

func (m *EventFilters) GetFilters() []*EventFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

type ConfigEventType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigEventType) Reset()         { *m = ConfigEventType{} }
func (m *ConfigEventType) String() string { return proto.CompactTextString(m) }
func (*ConfigEventType) ProtoMessage()    {}
func (*ConfigEventType) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{4}
}

func (m *ConfigEventType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigEventType.Unmarshal(m, b)
}
func (m *ConfigEventType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigEventType.Marshal(b, m, deterministic)
}
func (m *ConfigEventType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigEventType.Merge(m, src)
}
func (m *ConfigEventType) XXX_Size() int {
	return xxx_messageInfo_ConfigEventType.Size(m)
}
func (m *ConfigEventType) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigEventType.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigEventType proto.InternalMessageInfo

type ConfigEvent struct {
	Type                 ConfigEventType_Types `protobuf:"varint,1,opt,name=type,proto3,enum=event.ConfigEventType_Types" json:"type,omitempty"`
	Hash                 string                `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	Data                 string                `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ConfigEvent) Reset()         { *m = ConfigEvent{} }
func (m *ConfigEvent) String() string { return proto.CompactTextString(m) }
func (*ConfigEvent) ProtoMessage()    {}
func (*ConfigEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{5}
}

func (m *ConfigEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigEvent.Unmarshal(m, b)
}
func (m *ConfigEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigEvent.Marshal(b, m, deterministic)
}
func (m *ConfigEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigEvent.Merge(m, src)
}
func (m *ConfigEvent) XXX_Size() int {
	return xxx_messageInfo_ConfigEvent.Size(m)
}
func (m *ConfigEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigEvent proto.InternalMessageInfo

func (m *ConfigEvent) GetType() ConfigEventType_Types {
	if m != nil {
		return m.Type
	}
	return ConfigEventType_add
}

func (m *ConfigEvent) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *ConfigEvent) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

type KpiEventType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KpiEventType) Reset()         { *m = KpiEventType{} }
func (m *KpiEventType) String() string { return proto.CompactTextString(m) }
func (*KpiEventType) ProtoMessage()    {}
func (*KpiEventType) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{6}
}

func (m *KpiEventType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KpiEventType.Unmarshal(m, b)
}
func (m *KpiEventType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KpiEventType.Marshal(b, m, deterministic)
}
func (m *KpiEventType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KpiEventType.Merge(m, src)
}
func (m *KpiEventType) XXX_Size() int {
	return xxx_messageInfo_KpiEventType.Size(m)
}
func (m *KpiEventType) XXX_DiscardUnknown() {
	xxx_messageInfo_KpiEventType.DiscardUnknown(m)
}

var xxx_messageInfo_KpiEventType proto.InternalMessageInfo

//
// Struct to convey a dictionary of metric metadata.
type MetricMetaData struct {
	Title           string  `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	Ts              float64 `protobuf:"fixed64,2,opt,name=ts,proto3" json:"ts,omitempty"`
	LogicalDeviceId string  `protobuf:"bytes,3,opt,name=logical_device_id,json=logicalDeviceId,proto3" json:"logical_device_id,omitempty"`
	// (equivalent to the DPID that ONOS has
	// for the VOLTHA device without the
	//  'of:' prefix
	SerialNo             string            `protobuf:"bytes,4,opt,name=serial_no,json=serialNo,proto3" json:"serial_no,omitempty"`
	DeviceId             string            `protobuf:"bytes,5,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	Context              map[string]string `protobuf:"bytes,6,rep,name=context,proto3" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Uuid                 string            `protobuf:"bytes,7,opt,name=uuid,proto3" json:"uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MetricMetaData) Reset()         { *m = MetricMetaData{} }
func (m *MetricMetaData) String() string { return proto.CompactTextString(m) }
func (*MetricMetaData) ProtoMessage()    {}
func (*MetricMetaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{7}
}

func (m *MetricMetaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricMetaData.Unmarshal(m, b)
}
func (m *MetricMetaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricMetaData.Marshal(b, m, deterministic)
}
func (m *MetricMetaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricMetaData.Merge(m, src)
}
func (m *MetricMetaData) XXX_Size() int {
	return xxx_messageInfo_MetricMetaData.Size(m)
}
func (m *MetricMetaData) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricMetaData.DiscardUnknown(m)
}

var xxx_messageInfo_MetricMetaData proto.InternalMessageInfo

func (m *MetricMetaData) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *MetricMetaData) GetTs() float64 {
	if m != nil {
		return m.Ts
	}
	return 0
}

func (m *MetricMetaData) GetLogicalDeviceId() string {
	if m != nil {
		return m.LogicalDeviceId
	}
	return ""
}

func (m *MetricMetaData) GetSerialNo() string {
	if m != nil {
		return m.SerialNo
	}
	return ""
}

func (m *MetricMetaData) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *MetricMetaData) GetContext() map[string]string {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *MetricMetaData) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

//
// Struct to convey a dictionary of metric->value pairs. Typically used in
// pure shared-timestamp or shared-timestamp + shared object prefix situations.
type MetricValuePairs struct {
	// Metric / value pairs.
	Metrics              map[string]float32 `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MetricValuePairs) Reset()         { *m = MetricValuePairs{} }
func (m *MetricValuePairs) String() string { return proto.CompactTextString(m) }
func (*MetricValuePairs) ProtoMessage()    {}
func (*MetricValuePairs) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{8}
}

func (m *MetricValuePairs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricValuePairs.Unmarshal(m, b)
}
func (m *MetricValuePairs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricValuePairs.Marshal(b, m, deterministic)
}
func (m *MetricValuePairs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricValuePairs.Merge(m, src)
}
func (m *MetricValuePairs) XXX_Size() int {
	return xxx_messageInfo_MetricValuePairs.Size(m)
}
func (m *MetricValuePairs) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricValuePairs.DiscardUnknown(m)
}

var xxx_messageInfo_MetricValuePairs proto.InternalMessageInfo

func (m *MetricValuePairs) GetMetrics() map[string]float32 {
	if m != nil {
		return m.Metrics
	}
	return nil
}

//
// Struct to group metadata for a metric (or group of metrics) with the key-value
// pairs of collected metrics
type MetricInformation struct {
	Metadata             *MetricMetaData    `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Metrics              map[string]float32 `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MetricInformation) Reset()         { *m = MetricInformation{} }
func (m *MetricInformation) String() string { return proto.CompactTextString(m) }
func (*MetricInformation) ProtoMessage()    {}
func (*MetricInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{9}
}

func (m *MetricInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricInformation.Unmarshal(m, b)
}
func (m *MetricInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricInformation.Marshal(b, m, deterministic)
}
func (m *MetricInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricInformation.Merge(m, src)
}
func (m *MetricInformation) XXX_Size() int {
	return xxx_messageInfo_MetricInformation.Size(m)
}
func (m *MetricInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricInformation.DiscardUnknown(m)
}

var xxx_messageInfo_MetricInformation proto.InternalMessageInfo

func (m *MetricInformation) GetMetadata() *MetricMetaData {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *MetricInformation) GetMetrics() map[string]float32 {
	if m != nil {
		return m.Metrics
	}
	return nil
}

//
// Legacy KPI Event structured.  In mid-August, the KPI event format was updated
//                               to a more easily parsable format. See VOL-1140
//                               for more information.
type KpiEvent struct {
	Type                 KpiEventType_Types           `protobuf:"varint,1,opt,name=type,proto3,enum=event.KpiEventType_Types" json:"type,omitempty"`
	Ts                   float32                      `protobuf:"fixed32,2,opt,name=ts,proto3" json:"ts,omitempty"`
	Prefixes             map[string]*MetricValuePairs `protobuf:"bytes,3,rep,name=prefixes,proto3" json:"prefixes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *KpiEvent) Reset()         { *m = KpiEvent{} }
func (m *KpiEvent) String() string { return proto.CompactTextString(m) }
func (*KpiEvent) ProtoMessage()    {}
func (*KpiEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{10}
}

func (m *KpiEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KpiEvent.Unmarshal(m, b)
}
func (m *KpiEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KpiEvent.Marshal(b, m, deterministic)
}
func (m *KpiEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KpiEvent.Merge(m, src)
}
func (m *KpiEvent) XXX_Size() int {
	return xxx_messageInfo_KpiEvent.Size(m)
}
func (m *KpiEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_KpiEvent.DiscardUnknown(m)
}

var xxx_messageInfo_KpiEvent proto.InternalMessageInfo

func (m *KpiEvent) GetType() KpiEventType_Types {
	if m != nil {
		return m.Type
	}
	return KpiEventType_slice
}

func (m *KpiEvent) GetTs() float32 {
	if m != nil {
		return m.Ts
	}
	return 0
}

func (m *KpiEvent) GetPrefixes() map[string]*MetricValuePairs {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

type KpiEvent2 struct {
	// Type of KPI Event
	Type KpiEventType_Types `protobuf:"varint,1,opt,name=type,proto3,enum=event.KpiEventType_Types" json:"type,omitempty"`
	// Fields used when for slice:
	Ts                   float64              `protobuf:"fixed64,2,opt,name=ts,proto3" json:"ts,omitempty"`
	SliceData            []*MetricInformation `protobuf:"bytes,3,rep,name=slice_data,json=sliceData,proto3" json:"slice_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *KpiEvent2) Reset()         { *m = KpiEvent2{} }
func (m *KpiEvent2) String() string { return proto.CompactTextString(m) }
func (*KpiEvent2) ProtoMessage()    {}
func (*KpiEvent2) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{11}
}

func (m *KpiEvent2) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KpiEvent2.Unmarshal(m, b)
}
func (m *KpiEvent2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KpiEvent2.Marshal(b, m, deterministic)
}
func (m *KpiEvent2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KpiEvent2.Merge(m, src)
}
func (m *KpiEvent2) XXX_Size() int {
	return xxx_messageInfo_KpiEvent2.Size(m)
}
func (m *KpiEvent2) XXX_DiscardUnknown() {
	xxx_messageInfo_KpiEvent2.DiscardUnknown(m)
}

var xxx_messageInfo_KpiEvent2 proto.InternalMessageInfo

func (m *KpiEvent2) GetType() KpiEventType_Types {
	if m != nil {
		return m.Type
	}
	return KpiEventType_slice
}

func (m *KpiEvent2) GetTs() float64 {
	if m != nil {
		return m.Ts
	}
	return 0
}

func (m *KpiEvent2) GetSliceData() []*MetricInformation {
	if m != nil {
		return m.SliceData
	}
	return nil
}

//
// Describes the events specific to device
type DeviceEvent struct {
	// Identifier of the originating resource of the event, for ex: device_id
	ResourceId string `protobuf:"bytes,1,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// device_event_name indicates clearly the name of the device event
	DeviceEventName string `protobuf:"bytes,2,opt,name=device_event_name,json=deviceEventName,proto3" json:"device_event_name,omitempty"`
	// Textual explanation of the device event
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Key/Value storage for extra information that may give context to the event
	Context              map[string]string `protobuf:"bytes,4,rep,name=context,proto3" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DeviceEvent) Reset()         { *m = DeviceEvent{} }
func (m *DeviceEvent) String() string { return proto.CompactTextString(m) }
func (*DeviceEvent) ProtoMessage()    {}
func (*DeviceEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{12}
}

func (m *DeviceEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceEvent.Unmarshal(m, b)
}
func (m *DeviceEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceEvent.Marshal(b, m, deterministic)
}
func (m *DeviceEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceEvent.Merge(m, src)
}
func (m *DeviceEvent) XXX_Size() int {
	return xxx_messageInfo_DeviceEvent.Size(m)
}
func (m *DeviceEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceEvent proto.InternalMessageInfo

func (m *DeviceEvent) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *DeviceEvent) GetDeviceEventName() string {
	if m != nil {
		return m.DeviceEventName
	}
	return ""
}

func (m *DeviceEvent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DeviceEvent) GetContext() map[string]string {
	if m != nil {
		return m.Context
	}
	return nil
}

//
// Describes the events specific to an RPC request
type RPCEvent struct {
	// RPC name
	Rpc string `protobuf:"bytes,1,opt,name=rpc,proto3" json:"rpc,omitempty"`
	// The operation id of that request.  Can be a log correlation ID
	OperationId string `protobuf:"bytes,2,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Identifies the service name originating the event
	Service string `protobuf:"bytes,3,opt,name=service,proto3" json:"service,omitempty"`
	// Identifies the stack originating the event
	StackId string `protobuf:"bytes,4,opt,name=stack_id,json=stackId,proto3" json:"stack_id,omitempty"`
	// Identifies the resource upon which the action is taken, e.g. device_id
	ResourceId string `protobuf:"bytes,5,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// Textual explanation of the event
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Key/Value storage for extra information that may give context to the event
	Context map[string]string `protobuf:"bytes,7,rep,name=context,proto3" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Status of the RPC Event
	Status               *common.OperationResp `protobuf:"bytes,8,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *RPCEvent) Reset()         { *m = RPCEvent{} }
func (m *RPCEvent) String() string { return proto.CompactTextString(m) }
func (*RPCEvent) ProtoMessage()    {}
func (*RPCEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{13}
}

func (m *RPCEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RPCEvent.Unmarshal(m, b)
}
func (m *RPCEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RPCEvent.Marshal(b, m, deterministic)
}
func (m *RPCEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RPCEvent.Merge(m, src)
}
func (m *RPCEvent) XXX_Size() int {
	return xxx_messageInfo_RPCEvent.Size(m)
}
func (m *RPCEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_RPCEvent.DiscardUnknown(m)
}

var xxx_messageInfo_RPCEvent proto.InternalMessageInfo

func (m *RPCEvent) GetRpc() string {
	if m != nil {
		return m.Rpc
	}
	return ""
}

func (m *RPCEvent) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *RPCEvent) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *RPCEvent) GetStackId() string {
	if m != nil {
		return m.StackId
	}
	return ""
}

func (m *RPCEvent) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *RPCEvent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *RPCEvent) GetContext() map[string]string {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RPCEvent) GetStatus() *common.OperationResp {
	if m != nil {
		return m.Status
	}
	return nil
}

//
// Identify the area of the system impacted by the event.
type EventCategory struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventCategory) Reset()         { *m = EventCategory{} }
func (m *EventCategory) String() string { return proto.CompactTextString(m) }
func (*EventCategory) ProtoMessage()    {}
func (*EventCategory) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{14}
}

func (m *EventCategory) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventCategory.Unmarshal(m, b)
}
func (m *EventCategory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventCategory.Marshal(b, m, deterministic)
}
func (m *EventCategory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventCategory.Merge(m, src)
}
func (m *EventCategory) XXX_Size() int {
	return xxx_messageInfo_EventCategory.Size(m)
}
func (m *EventCategory) XXX_DiscardUnknown() {
	xxx_messageInfo_EventCategory.DiscardUnknown(m)
}

var xxx_messageInfo_EventCategory proto.InternalMessageInfo

//
// Identify the functional category originating the event
type EventSubCategory struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventSubCategory) Reset()         { *m = EventSubCategory{} }
func (m *EventSubCategory) String() string { return proto.CompactTextString(m) }
func (*EventSubCategory) ProtoMessage()    {}
func (*EventSubCategory) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{15}
}

func (m *EventSubCategory) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventSubCategory.Unmarshal(m, b)
}
func (m *EventSubCategory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventSubCategory.Marshal(b, m, deterministic)
}
func (m *EventSubCategory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventSubCategory.Merge(m, src)
}
func (m *EventSubCategory) XXX_Size() int {
	return xxx_messageInfo_EventSubCategory.Size(m)
}
func (m *EventSubCategory) XXX_DiscardUnknown() {
	xxx_messageInfo_EventSubCategory.DiscardUnknown(m)
}

var xxx_messageInfo_EventSubCategory proto.InternalMessageInfo

//
// Identify the type of event
type EventType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventType) Reset()         { *m = EventType{} }
func (m *EventType) String() string { return proto.CompactTextString(m) }
func (*EventType) ProtoMessage()    {}
func (*EventType) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{16}
}

func (m *EventType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventType.Unmarshal(m, b)
}
func (m *EventType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventType.Marshal(b, m, deterministic)
}
func (m *EventType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventType.Merge(m, src)
}
func (m *EventType) XXX_Size() int {
	return xxx_messageInfo_EventType.Size(m)
}
func (m *EventType) XXX_DiscardUnknown() {
	xxx_messageInfo_EventType.DiscardUnknown(m)
}

var xxx_messageInfo_EventType proto.InternalMessageInfo

//
// Identify the functional category originating the event
type EventHeader struct {
	// Unique ID for this event.  e.g. voltha.some_olt.1234
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Refers to the functional area affect by the event
	Category EventCategory_Types `protobuf:"varint,2,opt,name=category,proto3,enum=event.EventCategory_Types" json:"category,omitempty"`
	// Refers to functional category of the event
	SubCategory EventSubCategory_Types `protobuf:"varint,3,opt,name=sub_category,json=subCategory,proto3,enum=event.EventSubCategory_Types" json:"sub_category,omitempty"`
	// Refers to the type of the event
	Type EventType_Types `protobuf:"varint,4,opt,name=type,proto3,enum=event.EventType_Types" json:"type,omitempty"`
	// The version identifier for this event type, thus allowing each
	// event type to evolve independently. The version should be in the
	// format “MAJOR.MINOR” format and minor changes must only be additive
	// and non-breaking.
	TypeVersion string `protobuf:"bytes,5,opt,name=type_version,json=typeVersion,proto3" json:"type_version,omitempty"`
	// Timestamp at which the event was first raised.
	// This represents the UTC time stamp since epoch (in seconds) when the
	// the event was first raised from the source entity.
	// If the source entity doesn't send the raised_ts, this shall be set
	// to timestamp when the event was received.
	RaisedTs *timestamp.Timestamp `protobuf:"bytes,6,opt,name=raised_ts,json=raisedTs,proto3" json:"raised_ts,omitempty"`
	// Timestamp at which the event was reported.
	// This represents the UTC time stamp since epoch (in seconds) when the
	// the event was reported (this time stamp is >= raised_ts).
	// If the source entity that reported this event doesn't send the
	// reported_ts, this shall be set to the same value as raised_ts.
	ReportedTs           *timestamp.Timestamp `protobuf:"bytes,7,opt,name=reported_ts,json=reportedTs,proto3" json:"reported_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *EventHeader) Reset()         { *m = EventHeader{} }
func (m *EventHeader) String() string { return proto.CompactTextString(m) }
func (*EventHeader) ProtoMessage()    {}
func (*EventHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{17}
}

func (m *EventHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventHeader.Unmarshal(m, b)
}
func (m *EventHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventHeader.Marshal(b, m, deterministic)
}
func (m *EventHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventHeader.Merge(m, src)
}
func (m *EventHeader) XXX_Size() int {
	return xxx_messageInfo_EventHeader.Size(m)
}
func (m *EventHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_EventHeader.DiscardUnknown(m)
}

var xxx_messageInfo_EventHeader proto.InternalMessageInfo

func (m *EventHeader) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *EventHeader) GetCategory() EventCategory_Types {
	if m != nil {
		return m.Category
	}
	return EventCategory_COMMUNICATION
}

func (m *EventHeader) GetSubCategory() EventSubCategory_Types {
	if m != nil {
		return m.SubCategory
	}
	return EventSubCategory_PON
}

func (m *EventHeader) GetType() EventType_Types {
	if m != nil {
		return m.Type
	}
	return EventType_CONFIG_EVENT
}

func (m *EventHeader) GetTypeVersion() string {
	if m != nil {
		return m.TypeVersion
	}
	return ""
}

func (m *EventHeader) GetRaisedTs() *timestamp.Timestamp {
	if m != nil {
		return m.RaisedTs
	}
	return nil
}

func (m *EventHeader) GetReportedTs() *timestamp.Timestamp {
	if m != nil {
		return m.ReportedTs
	}
	return nil
}

//
// Event Structure
type Event struct {
	// event header
	Header *EventHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// oneof event types referred by EventType.
	//
	// Types that are valid to be assigned to EventType:
	//	*Event_ConfigEvent
	//	*Event_KpiEvent
	//	*Event_KpiEvent2
	//	*Event_DeviceEvent
	//	*Event_RpcEvent
	EventType            isEvent_EventType `protobuf_oneof:"event_type"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{18}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetHeader() *EventHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

type isEvent_EventType interface {
	isEvent_EventType()
}

type Event_ConfigEvent struct {
	ConfigEvent *ConfigEvent `protobuf:"bytes,2,opt,name=config_event,json=configEvent,proto3,oneof"`
}

type Event_KpiEvent struct {
	KpiEvent *KpiEvent `protobuf:"bytes,3,opt,name=kpi_event,json=kpiEvent,proto3,oneof"`
}

type Event_KpiEvent2 struct {
	KpiEvent2 *KpiEvent2 `protobuf:"bytes,4,opt,name=kpi_event2,json=kpiEvent2,proto3,oneof"`
}

type Event_DeviceEvent struct {
	DeviceEvent *DeviceEvent `protobuf:"bytes,5,opt,name=device_event,json=deviceEvent,proto3,oneof"`
}

type Event_RpcEvent struct {
	RpcEvent *RPCEvent `protobuf:"bytes,6,opt,name=rpc_event,json=rpcEvent,proto3,oneof"`
}

func (*Event_ConfigEvent) isEvent_EventType() {}

func (*Event_KpiEvent) isEvent_EventType() {}

func (*Event_KpiEvent2) isEvent_EventType() {}

func (*Event_DeviceEvent) isEvent_EventType() {}

func (*Event_RpcEvent) isEvent_EventType() {}

func (m *Event) GetEventType() isEvent_EventType {
	if m != nil {
		return m.EventType
	}
	return nil
}

func (m *Event) GetConfigEvent() *ConfigEvent {
	if x, ok := m.GetEventType().(*Event_ConfigEvent); ok {
		return x.ConfigEvent
	}
	return nil
}

func (m *Event) GetKpiEvent() *KpiEvent {
	if x, ok := m.GetEventType().(*Event_KpiEvent); ok {
		return x.KpiEvent
	}
	return nil
}

func (m *Event) GetKpiEvent2() *KpiEvent2 {
	if x, ok := m.GetEventType().(*Event_KpiEvent2); ok {
		return x.KpiEvent2
	}
	return nil
}

func (m *Event) GetDeviceEvent() *DeviceEvent {
	if x, ok := m.GetEventType().(*Event_DeviceEvent); ok {
		return x.DeviceEvent
	}
	return nil
}

func (m *Event) GetRpcEvent() *RPCEvent {
	if x, ok := m.GetEventType().(*Event_RpcEvent); ok {
		return x.RpcEvent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Event) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Event_ConfigEvent)(nil),
		(*Event_KpiEvent)(nil),
		(*Event_KpiEvent2)(nil),
		(*Event_DeviceEvent)(nil),
		(*Event_RpcEvent)(nil),
	}
}

func init() {
	proto.RegisterEnum("event.EventFilterRuleKey_EventFilterRuleType", EventFilterRuleKey_EventFilterRuleType_name, EventFilterRuleKey_EventFilterRuleType_value)
	proto.RegisterEnum("event.ConfigEventType_Types", ConfigEventType_Types_name, ConfigEventType_Types_value)
	proto.RegisterEnum("event.KpiEventType_Types", KpiEventType_Types_name, KpiEventType_Types_value)
	proto.RegisterEnum("event.EventCategory_Types", EventCategory_Types_name, EventCategory_Types_value)
	proto.RegisterEnum("event.EventSubCategory_Types", EventSubCategory_Types_name, EventSubCategory_Types_value)
	proto.RegisterEnum("event.EventType_Types", EventType_Types_name, EventType_Types_value)
	proto.RegisterType((*EventFilterRuleKey)(nil), "event.EventFilterRuleKey")
	proto.RegisterType((*EventFilterRule)(nil), "event.EventFilterRule")
	proto.RegisterType((*EventFilter)(nil), "event.EventFilter")
	proto.RegisterType((*EventFilters)(nil), "event.EventFilters")
	proto.RegisterType((*ConfigEventType)(nil), "event.ConfigEventType")
	proto.RegisterType((*ConfigEvent)(nil), "event.ConfigEvent")
	proto.RegisterType((*KpiEventType)(nil), "event.KpiEventType")
	proto.RegisterType((*MetricMetaData)(nil), "event.MetricMetaData")
	proto.RegisterMapType((map[string]string)(nil), "event.MetricMetaData.ContextEntry")
	proto.RegisterType((*MetricValuePairs)(nil), "event.MetricValuePairs")
	proto.RegisterMapType((map[string]float32)(nil), "event.MetricValuePairs.MetricsEntry")
	proto.RegisterType((*MetricInformation)(nil), "event.MetricInformation")
	proto.RegisterMapType((map[string]float32)(nil), "event.MetricInformation.MetricsEntry")
	proto.RegisterType((*KpiEvent)(nil), "event.KpiEvent")
	proto.RegisterMapType((map[string]*MetricValuePairs)(nil), "event.KpiEvent.PrefixesEntry")
	proto.RegisterType((*KpiEvent2)(nil), "event.KpiEvent2")
	proto.RegisterType((*DeviceEvent)(nil), "event.DeviceEvent")
	proto.RegisterMapType((map[string]string)(nil), "event.DeviceEvent.ContextEntry")
	proto.RegisterType((*RPCEvent)(nil), "event.RPCEvent")
	proto.RegisterMapType((map[string]string)(nil), "event.RPCEvent.ContextEntry")
	proto.RegisterType((*EventCategory)(nil), "event.EventCategory")
	proto.RegisterType((*EventSubCategory)(nil), "event.EventSubCategory")
	proto.RegisterType((*EventType)(nil), "event.EventType")
	proto.RegisterType((*EventHeader)(nil), "event.EventHeader")
	proto.RegisterType((*Event)(nil), "event.Event")
}

func init() { proto.RegisterFile("voltha_protos/events.proto", fileDescriptor_e63e6c07044fd2c4) }

var fileDescriptor_e63e6c07044fd2c4 = []byte{
	// 1436 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xdb, 0x6e, 0xdb, 0x46,
	0x13, 0x16, 0xa9, 0x23, 0x87, 0xb2, 0x4d, 0xef, 0xff, 0x27, 0x55, 0x94, 0x04, 0x71, 0x88, 0x16,
	0x30, 0x8c, 0x58, 0x6e, 0x54, 0x34, 0x6e, 0x0e, 0x48, 0xda, 0x28, 0x4a, 0x4c, 0x24, 0x96, 0x54,
	0x5a, 0x36, 0x90, 0xde, 0x08, 0x6b, 0x72, 0x2d, 0x13, 0xa6, 0x44, 0x82, 0xbb, 0x12, 0xe2, 0xeb,
	0x5e, 0xf4, 0xae, 0x8f, 0xd0, 0xde, 0xf7, 0x35, 0x0a, 0xf4, 0x21, 0x82, 0xbe, 0x45, 0x5f, 0xa0,
	0xd8, 0x03, 0x25, 0x4a, 0x56, 0x1a, 0xa0, 0x41, 0xaf, 0xb4, 0x3b, 0x3b, 0xc3, 0xf9, 0xe6, 0x9b,
	0x9d, 0xd9, 0x11, 0xd4, 0xa7, 0x51, 0xc8, 0xce, 0xf1, 0x20, 0x4e, 0x22, 0x16, 0xd1, 0x3d, 0x32,
	0x25, 0x63, 0x46, 0x1b, 0x62, 0x87, 0x8a, 0x62, 0x57, 0xbf, 0x35, 0x8c, 0xa2, 0x61, 0x48, 0xf6,
	0x70, 0x1c, 0xec, 0xe1, 0xf1, 0x38, 0x62, 0x98, 0x05, 0xd1, 0x58, 0x29, 0xd5, 0xef, 0xa8, 0x53,
	0xb1, 0x3b, 0x9d, 0x9c, 0xed, 0xb1, 0x60, 0x44, 0x28, 0xc3, 0xa3, 0x58, 0x29, 0x2c, 0x79, 0xf0,
	0xa2, 0xd1, 0x28, 0x1a, 0xcb, 0x33, 0xfb, 0x17, 0x0d, 0x50, 0x9b, 0x3b, 0x79, 0x19, 0x84, 0x8c,
	0x24, 0xee, 0x24, 0x24, 0xaf, 0xc9, 0xa5, 0xfd, 0x93, 0x06, 0xff, 0x5b, 0x12, 0xf7, 0x2f, 0x63,
	0x82, 0xd6, 0x01, 0xce, 0x84, 0x64, 0x80, 0xc3, 0xd0, 0xca, 0xa1, 0x2a, 0x54, 0x3c, 0xcc, 0xc8,
	0x30, 0x4a, 0x2e, 0x2d, 0x0d, 0x59, 0x50, 0xa5, 0x93, 0xd3, 0xc1, 0x4c, 0xa2, 0x23, 0x04, 0xeb,
	0x17, 0x71, 0x30, 0x10, 0x61, 0x0c, 0xd8, 0x65, 0x4c, 0xac, 0x3c, 0xba, 0x06, 0x9b, 0x5e, 0x34,
	0x3e, 0x0b, 0x86, 0x59, 0x71, 0x81, 0x8b, 0x7d, 0x32, 0x0d, 0x3c, 0x92, 0x15, 0x17, 0xed, 0x73,
	0xd8, 0x58, 0x02, 0x82, 0x9e, 0x41, 0xfe, 0x82, 0x5c, 0xd6, 0xb4, 0x2d, 0x6d, 0x7b, 0xbd, 0xb9,
	0xdb, 0x10, 0xea, 0x8d, 0xab, 0x41, 0x34, 0x56, 0x04, 0xe0, 0x72, 0x4b, 0xf4, 0x7f, 0x28, 0x4e,
	0x71, 0x38, 0x21, 0x35, 0x7d, 0x4b, 0xdb, 0x36, 0x5c, 0xb9, 0xb1, 0x7f, 0xd5, 0xc0, 0xcc, 0x98,
	0xa0, 0x75, 0xd0, 0x03, 0x5f, 0x78, 0x31, 0x5c, 0x3d, 0xf0, 0xd1, 0x75, 0x28, 0x91, 0x31, 0x3e,
	0x0d, 0xa5, 0x59, 0xc5, 0x55, 0x3b, 0x74, 0x13, 0x0c, 0x05, 0x3c, 0xf0, 0x6b, 0x79, 0xa1, 0x5e,
	0x91, 0x02, 0xc7, 0x47, 0xb7, 0x01, 0xe6, 0xe1, 0xd4, 0x0a, 0xe2, 0xd4, 0x10, 0x12, 0xc1, 0xe7,
	0x3d, 0x28, 0x26, 0x93, 0x90, 0xd0, 0x5a, 0x71, 0x2b, 0xbf, 0x6d, 0x36, 0xaf, 0xaf, 0x0e, 0xc6,
	0x95, 0x4a, 0xf6, 0x13, 0xa8, 0x66, 0x4e, 0x28, 0xba, 0x07, 0x65, 0x99, 0x0d, 0x5a, 0xd3, 0x84,
	0x3d, 0x5a, 0x61, 0x9f, 0xaa, 0xd8, 0x8f, 0x61, 0xa3, 0x25, 0x78, 0x6f, 0xa7, 0xee, 0xed, 0x6d,
	0x28, 0xf2, 0x5f, 0x8a, 0xca, 0x90, 0xc7, 0xbe, 0x6f, 0xe5, 0x10, 0x40, 0x29, 0x21, 0xa3, 0x68,
	0x4a, 0x2c, 0x8d, 0xaf, 0x27, 0xb1, 0x8f, 0x19, 0xb1, 0x74, 0x7b, 0x08, 0x66, 0xc6, 0x18, 0x7d,
	0x09, 0x05, 0x11, 0x90, 0xcc, 0xc1, 0x2d, 0xe5, 0x76, 0xe9, 0xf3, 0x0d, 0xf1, 0x6d, 0x57, 0x68,
	0x22, 0x04, 0x85, 0x73, 0x4c, 0xcf, 0x15, 0xe5, 0x62, 0xcd, 0x65, 0x3e, 0x66, 0x58, 0x91, 0x26,
	0xd6, 0xf6, 0x0e, 0x54, 0x5f, 0xc7, 0xc1, 0x1c, 0x62, 0x3d, 0x85, 0x68, 0x40, 0x91, 0x86, 0x81,
	0x47, 0xac, 0x1c, 0x2a, 0x81, 0xce, 0xa8, 0xa5, 0xd9, 0xbf, 0xe9, 0xb0, 0x7e, 0x48, 0x58, 0x12,
	0x78, 0x87, 0x84, 0xe1, 0x17, 0x98, 0x61, 0x9e, 0x5a, 0x16, 0xb0, 0x90, 0xa8, 0xbc, 0xc9, 0x0d,
	0x4f, 0x25, 0xa3, 0xc2, 0xb5, 0xe6, 0xea, 0x8c, 0xa2, 0x1d, 0xd8, 0x0c, 0xa3, 0x61, 0xe0, 0xe1,
	0x70, 0xb0, 0x9c, 0xba, 0x0d, 0x75, 0xf0, 0x22, 0xcd, 0xe0, 0x4d, 0x30, 0x28, 0x49, 0x02, 0x1c,
	0x0e, 0xc6, 0x91, 0x4a, 0x60, 0x45, 0x0a, 0x3a, 0xd1, 0x62, 0xee, 0x8b, 0x4b, 0xb9, 0x7f, 0x02,
	0x65, 0x2f, 0x1a, 0x33, 0xf2, 0x8e, 0xd5, 0x4a, 0x22, 0x3d, 0xb6, 0xe2, 0x69, 0x11, 0x33, 0xa7,
	0x8d, 0x2b, 0xb5, 0xc7, 0x2c, 0xb9, 0x74, 0x53, 0x13, 0x4e, 0xce, 0x64, 0x12, 0xf8, 0xb5, 0xb2,
	0x24, 0x87, 0xaf, 0xeb, 0x8f, 0xa0, 0x9a, 0x55, 0x46, 0xd6, 0xbc, 0x12, 0x8c, 0x7f, 0xb8, 0xda,
	0x8f, 0xf4, 0x6f, 0x34, 0xfb, 0x67, 0x0d, 0x2c, 0xe9, 0xf8, 0x84, 0xcb, 0x7a, 0x38, 0x48, 0x28,
	0x7a, 0x0a, 0xe5, 0x91, 0x90, 0xa5, 0x37, 0xe8, 0xf3, 0x05, 0x88, 0x73, 0x4d, 0x25, 0xa0, 0x0a,
	0xa4, 0x32, 0xe2, 0x80, 0xb2, 0x07, 0x1f, 0x03, 0xa4, 0x67, 0x01, 0xfd, 0xae, 0xc1, 0xa6, 0x34,
	0x76, 0xc6, 0x67, 0x51, 0x32, 0x12, 0x4d, 0x0d, 0xdd, 0x87, 0xca, 0x88, 0x30, 0x2c, 0xee, 0x05,
	0xff, 0x8c, 0xd9, 0xbc, 0xb6, 0x92, 0x35, 0x77, 0xa6, 0x86, 0x9e, 0xcd, 0x83, 0xd0, 0x45, 0x10,
	0x5f, 0x2c, 0x58, 0x64, 0xbe, 0xfe, 0x1f, 0x44, 0xf1, 0x5e, 0x83, 0x4a, 0x7a, 0x61, 0xd1, 0xee,
	0x42, 0x59, 0xdc, 0x50, 0x30, 0xb2, 0xf7, 0x79, 0xa1, 0x26, 0xe6, 0xd7, 0x52, 0x17, 0xd7, 0xf2,
	0x21, 0x54, 0xe2, 0x84, 0x9c, 0x05, 0xef, 0x08, 0xad, 0xe5, 0x45, 0x24, 0xb7, 0x97, 0x3e, 0xd1,
	0xe8, 0xa9, 0x73, 0x19, 0xc1, 0x4c, 0xbd, 0xde, 0x87, 0xb5, 0x85, 0xa3, 0x15, 0x31, 0xec, 0x66,
	0x63, 0x30, 0x9b, 0x9f, 0x7d, 0x20, 0xd3, 0xd9, 0xe0, 0x7e, 0xd4, 0xc0, 0x48, 0x5d, 0x37, 0xff,
	0x7d, 0x74, 0xb2, 0xe8, 0xf6, 0x01, 0x44, 0x01, 0x0f, 0x54, 0xcd, 0xf3, 0xf8, 0x6a, 0x1f, 0xca,
	0x94, 0x6b, 0x08, 0x5d, 0x9e, 0x69, 0xfb, 0x2f, 0x0d, 0x4c, 0x59, 0x8e, 0x92, 0xe5, 0x3b, 0x60,
	0x26, 0x84, 0x46, 0x93, 0x44, 0x96, 0x9d, 0x0c, 0x11, 0x52, 0x91, 0xe3, 0xf3, 0xf2, 0x5e, 0x78,
	0x4a, 0xc6, 0x78, 0x94, 0x16, 0xc4, 0x86, 0x3f, 0xff, 0x50, 0x07, 0x8f, 0x08, 0xda, 0x02, 0xd3,
	0x27, 0xd4, 0x4b, 0x82, 0x98, 0xbb, 0x55, 0x4d, 0x20, 0x2b, 0x42, 0x0f, 0xe7, 0x65, 0x5c, 0x10,
	0xa0, 0xef, 0x28, 0xd0, 0x19, 0x4c, 0xab, 0x6b, 0xf8, 0x93, 0xea, 0xf5, 0xbd, 0x0e, 0x15, 0xb7,
	0xd7, 0x92, 0x21, 0x5b, 0x90, 0x4f, 0x62, 0x2f, 0x35, 0x4c, 0x62, 0x0f, 0xdd, 0x85, 0x6a, 0x14,
	0x93, 0x44, 0x90, 0xc5, 0x59, 0x90, 0xf6, 0xe6, 0x4c, 0xe6, 0xf8, 0xa8, 0x06, 0x65, 0x4a, 0x12,
	0x8e, 0x51, 0x85, 0x95, 0x6e, 0xd1, 0x0d, 0xa8, 0x50, 0x86, 0xbd, 0x0b, 0x6e, 0x58, 0x50, 0x47,
	0x7c, 0xef, 0xf8, 0xcb, 0xe4, 0x16, 0xaf, 0x90, 0xbb, 0x44, 0x58, 0xe9, 0x2a, 0x61, 0x0f, 0xe6,
	0x84, 0x95, 0x05, 0x61, 0xe9, 0xfb, 0x90, 0x86, 0xf3, 0x81, 0x8e, 0xb7, 0x0b, 0x25, 0xca, 0x30,
	0x9b, 0xd0, 0x5a, 0x45, 0x15, 0xbe, 0x1a, 0x55, 0xba, 0x69, 0x50, 0x2e, 0xa1, 0xb1, 0xab, 0x94,
	0x3e, 0x89, 0xdc, 0x29, 0xac, 0x09, 0x24, 0x2d, 0x35, 0xaa, 0xd8, 0x24, 0x7d, 0x66, 0x36, 0x61,
	0xad, 0xd5, 0x3d, 0x3c, 0x3c, 0xee, 0x38, 0xad, 0xef, 0xfa, 0x4e, 0xb7, 0x63, 0xe5, 0xd0, 0x06,
	0x98, 0xed, 0xce, 0x89, 0xe3, 0x76, 0x3b, 0x87, 0xed, 0x4e, 0xdf, 0xd2, 0xd0, 0x1a, 0x18, 0xed,
	0xef, 0x8f, 0x9d, 0x9e, 0xd8, 0xea, 0xc8, 0x84, 0xf2, 0x51, 0xdb, 0x3d, 0x71, 0x5a, 0x6d, 0x2b,
	0xcf, 0x27, 0xa4, 0x9e, 0xdb, 0x6d, 0xb5, 0x8f, 0x8e, 0x9c, 0xce, 0x2b, 0xab, 0xc0, 0x27, 0xa4,
	0xa3, 0x76, 0xeb, 0xd8, 0x75, 0xfa, 0x6f, 0xad, 0xa2, 0xed, 0x82, 0x25, 0xfc, 0x1e, 0x4d, 0x4e,
	0x67, 0xae, 0x9f, 0x66, 0x1e, 0xe1, 0x9e, 0x70, 0x58, 0x86, 0x7c, 0xf7, 0x0d, 0x77, 0xc4, 0x17,
	0xc2, 0x85, 0x58, 0x1c, 0x5b, 0x79, 0xbe, 0xe8, 0x74, 0x1c, 0xab, 0x80, 0x2a, 0x50, 0xe8, 0x74,
	0x3b, 0x6d, 0xab, 0x68, 0x9f, 0x81, 0x31, 0x7f, 0x2e, 0xdf, 0xa6, 0x1f, 0xb3, 0xa0, 0xda, 0xea,
	0x76, 0x5e, 0x3a, 0xaf, 0x06, 0xed, 0x13, 0x0e, 0x33, 0xc7, 0x51, 0xbf, 0xee, 0x39, 0x6a, 0xab,
	0x71, 0xa0, 0xb3, 0x6d, 0xd3, 0xd2, 0xb9, 0xc1, 0x8b, 0x36, 0x0f, 0x42, 0x69, 0xe4, 0xb9, 0x81,
	0xdb, 0x6b, 0xa9, 0x6d, 0xc1, 0xfe, 0x53, 0x57, 0xf3, 0xd1, 0x01, 0xc1, 0xfe, 0x8a, 0xf9, 0xe8,
	0xc1, 0x7c, 0x16, 0x14, 0x84, 0xaf, 0x37, 0xeb, 0xd9, 0x71, 0x24, 0x8d, 0x57, 0xf5, 0x88, 0x99,
	0x2e, 0xfa, 0x76, 0x71, 0x6a, 0x14, 0x77, 0x75, 0x7d, 0xd6, 0xf9, 0x96, 0xe9, 0x52, 0xe6, 0x26,
	0x9d, 0x8b, 0xd0, 0x8e, 0x6a, 0x4c, 0x05, 0x61, 0xb9, 0x30, 0x44, 0x5d, 0xe9, 0x4a, 0x77, 0xa1,
	0xca, 0x7f, 0x07, 0x53, 0x92, 0x50, 0x7e, 0x7f, 0xe5, 0x05, 0x37, 0xb9, 0xec, 0x44, 0x8a, 0xd0,
	0x3e, 0x18, 0x09, 0x0e, 0x28, 0xf1, 0x07, 0x8c, 0x8a, 0xfb, 0x6d, 0x36, 0xeb, 0x0d, 0x39, 0x64,
	0x37, 0xd2, 0x21, 0xbb, 0xd1, 0x4f, 0x87, 0x6c, 0xb7, 0x22, 0x95, 0xfb, 0x14, 0x3d, 0xe6, 0xb5,
	0x13, 0x47, 0x09, 0x93, 0xa6, 0xe5, 0x8f, 0x9a, 0x42, 0xaa, 0xde, 0xa7, 0xf6, 0x1f, 0x3a, 0x14,
	0x65, 0xb1, 0xef, 0x40, 0xe9, 0x5c, 0x50, 0xac, 0x1e, 0xc0, 0x85, 0xa9, 0x4e, 0x92, 0xef, 0x2a,
	0x0d, 0xb4, 0x0f, 0xd5, 0xec, 0x30, 0xad, 0x7a, 0x3b, 0xba, 0x3a, 0x90, 0x1d, 0xe4, 0x5c, 0xd3,
	0xcb, 0x4c, 0x70, 0x0d, 0x30, 0x66, 0x93, 0xb9, 0xa0, 0xdc, 0x6c, 0x6e, 0x2c, 0x75, 0xf4, 0x83,
	0x9c, 0x5b, 0xb9, 0x48, 0x9f, 0xb6, 0xfb, 0x00, 0x33, 0xfd, 0xa6, 0x60, 0xda, 0x6c, 0x5a, 0x4b,
	0x06, 0xcd, 0x83, 0x9c, 0x6b, 0x5c, 0xcc, 0xde, 0x8b, 0x7d, 0xa8, 0x66, 0xdb, 0xb0, 0xa0, 0x7a,
	0x8e, 0x2d, 0xd3, 0x3d, 0x39, 0xb6, 0x4c, 0x5f, 0xe6, 0xd8, 0x92, 0xd8, 0x53, 0x56, 0xa5, 0x05,
	0x6c, 0x69, 0x0b, 0xe1, 0xd8, 0x92, 0xd8, 0x13, 0xeb, 0xe7, 0xd5, 0xec, 0x90, 0xfd, 0xfc, 0x0d,
	0xd4, 0xa3, 0x64, 0xd8, 0x88, 0x62, 0x32, 0xf6, 0xa2, 0xc4, 0x6f, 0xc8, 0x7f, 0x3f, 0xd2, 0x9e,
	0xfe, 0xd0, 0x18, 0x06, 0xec, 0x7c, 0x72, 0xca, 0x5b, 0xcb, 0x5e, 0xaa, 0xb2, 0x27, 0x55, 0x76,
	0xd5, 0x1f, 0xa4, 0xe9, 0xd7, 0x7b, 0xc3, 0x48, 0xc9, 0x4e, 0x4b, 0x42, 0xf8, 0xd5, 0xdf, 0x01,
	0x00, 0x00, 0xff, 0xff, 0xb2, 0x68, 0x11, 0x5e, 0xa7, 0x0d, 0x00, 0x00,
}
