// Copyright 2018-2024 Open Networking Foundation (ONF) and the ONF Contributors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at:
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v4.25.8
// source: voltha_protos/tech_profile.proto

package tech_profile

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Direction int32

const (
	Direction_UPSTREAM      Direction = 0
	Direction_DOWNSTREAM    Direction = 1
	Direction_BIDIRECTIONAL Direction = 2
)

// Enum value maps for Direction.
var (
	Direction_name = map[int32]string{
		0: "UPSTREAM",
		1: "DOWNSTREAM",
		2: "BIDIRECTIONAL",
	}
	Direction_value = map[string]int32{
		"UPSTREAM":      0,
		"DOWNSTREAM":    1,
		"BIDIRECTIONAL": 2,
	}
)

func (x Direction) Enum() *Direction {
	p := new(Direction)
	*p = x
	return p
}

func (x Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_tech_profile_proto_enumTypes[0].Descriptor()
}

func (Direction) Type() protoreflect.EnumType {
	return &file_voltha_protos_tech_profile_proto_enumTypes[0]
}

func (x Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Direction.Descriptor instead.
func (Direction) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{0}
}

type SchedulingPolicy int32

const (
	SchedulingPolicy_WRR            SchedulingPolicy = 0
	SchedulingPolicy_StrictPriority SchedulingPolicy = 1
	SchedulingPolicy_Hybrid         SchedulingPolicy = 2
)

// Enum value maps for SchedulingPolicy.
var (
	SchedulingPolicy_name = map[int32]string{
		0: "WRR",
		1: "StrictPriority",
		2: "Hybrid",
	}
	SchedulingPolicy_value = map[string]int32{
		"WRR":            0,
		"StrictPriority": 1,
		"Hybrid":         2,
	}
)

func (x SchedulingPolicy) Enum() *SchedulingPolicy {
	p := new(SchedulingPolicy)
	*p = x
	return p
}

func (x SchedulingPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchedulingPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_tech_profile_proto_enumTypes[1].Descriptor()
}

func (SchedulingPolicy) Type() protoreflect.EnumType {
	return &file_voltha_protos_tech_profile_proto_enumTypes[1]
}

func (x SchedulingPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchedulingPolicy.Descriptor instead.
func (SchedulingPolicy) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{1}
}

type AdditionalBW int32

const (
	AdditionalBW_AdditionalBW_None       AdditionalBW = 0
	AdditionalBW_AdditionalBW_NA         AdditionalBW = 1
	AdditionalBW_AdditionalBW_BestEffort AdditionalBW = 2
	AdditionalBW_AdditionalBW_Auto       AdditionalBW = 3
)

// Enum value maps for AdditionalBW.
var (
	AdditionalBW_name = map[int32]string{
		0: "AdditionalBW_None",
		1: "AdditionalBW_NA",
		2: "AdditionalBW_BestEffort",
		3: "AdditionalBW_Auto",
	}
	AdditionalBW_value = map[string]int32{
		"AdditionalBW_None":       0,
		"AdditionalBW_NA":         1,
		"AdditionalBW_BestEffort": 2,
		"AdditionalBW_Auto":       3,
	}
)

func (x AdditionalBW) Enum() *AdditionalBW {
	p := new(AdditionalBW)
	*p = x
	return p
}

func (x AdditionalBW) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdditionalBW) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_tech_profile_proto_enumTypes[2].Descriptor()
}

func (AdditionalBW) Type() protoreflect.EnumType {
	return &file_voltha_protos_tech_profile_proto_enumTypes[2]
}

func (x AdditionalBW) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdditionalBW.Descriptor instead.
func (AdditionalBW) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{2}
}

type DiscardPolicy int32

const (
	DiscardPolicy_TailDrop  DiscardPolicy = 0
	DiscardPolicy_WTailDrop DiscardPolicy = 1
	DiscardPolicy_Red       DiscardPolicy = 2
	DiscardPolicy_WRed      DiscardPolicy = 3
)

// Enum value maps for DiscardPolicy.
var (
	DiscardPolicy_name = map[int32]string{
		0: "TailDrop",
		1: "WTailDrop",
		2: "Red",
		3: "WRed",
	}
	DiscardPolicy_value = map[string]int32{
		"TailDrop":  0,
		"WTailDrop": 1,
		"Red":       2,
		"WRed":      3,
	}
)

func (x DiscardPolicy) Enum() *DiscardPolicy {
	p := new(DiscardPolicy)
	*p = x
	return p
}

func (x DiscardPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscardPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_tech_profile_proto_enumTypes[3].Descriptor()
}

func (DiscardPolicy) Type() protoreflect.EnumType {
	return &file_voltha_protos_tech_profile_proto_enumTypes[3]
}

func (x DiscardPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscardPolicy.Descriptor instead.
func (DiscardPolicy) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{3}
}

type InferredAdditionBWIndication int32

const (
	InferredAdditionBWIndication_InferredAdditionBWIndication_None       InferredAdditionBWIndication = 0
	InferredAdditionBWIndication_InferredAdditionBWIndication_Assured    InferredAdditionBWIndication = 1
	InferredAdditionBWIndication_InferredAdditionBWIndication_BestEffort InferredAdditionBWIndication = 2
)

// Enum value maps for InferredAdditionBWIndication.
var (
	InferredAdditionBWIndication_name = map[int32]string{
		0: "InferredAdditionBWIndication_None",
		1: "InferredAdditionBWIndication_Assured",
		2: "InferredAdditionBWIndication_BestEffort",
	}
	InferredAdditionBWIndication_value = map[string]int32{
		"InferredAdditionBWIndication_None":       0,
		"InferredAdditionBWIndication_Assured":    1,
		"InferredAdditionBWIndication_BestEffort": 2,
	}
)

func (x InferredAdditionBWIndication) Enum() *InferredAdditionBWIndication {
	p := new(InferredAdditionBWIndication)
	*p = x
	return p
}

func (x InferredAdditionBWIndication) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InferredAdditionBWIndication) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_tech_profile_proto_enumTypes[4].Descriptor()
}

func (InferredAdditionBWIndication) Type() protoreflect.EnumType {
	return &file_voltha_protos_tech_profile_proto_enumTypes[4]
}

func (x InferredAdditionBWIndication) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InferredAdditionBWIndication.Descriptor instead.
func (InferredAdditionBWIndication) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{4}
}

type SchedulerConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Direction     Direction              `protobuf:"varint,1,opt,name=direction,proto3,enum=tech_profile.Direction" json:"direction,omitempty"`
	AdditionalBw  AdditionalBW           `protobuf:"varint,2,opt,name=additional_bw,json=additionalBw,proto3,enum=tech_profile.AdditionalBW" json:"additional_bw,omitempty"` // Valid on for “direction == Upstream”.
	Priority      uint32                 `protobuf:"fixed32,3,opt,name=priority,proto3" json:"priority,omitempty"`
	Weight        uint32                 `protobuf:"fixed32,4,opt,name=weight,proto3" json:"weight,omitempty"`
	SchedPolicy   SchedulingPolicy       `protobuf:"varint,5,opt,name=sched_policy,json=schedPolicy,proto3,enum=tech_profile.SchedulingPolicy" json:"sched_policy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SchedulerConfig) Reset() {
	*x = SchedulerConfig{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchedulerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulerConfig) ProtoMessage() {}

func (x *SchedulerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulerConfig.ProtoReflect.Descriptor instead.
func (*SchedulerConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{0}
}

func (x *SchedulerConfig) GetDirection() Direction {
	if x != nil {
		return x.Direction
	}
	return Direction_UPSTREAM
}

func (x *SchedulerConfig) GetAdditionalBw() AdditionalBW {
	if x != nil {
		return x.AdditionalBw
	}
	return AdditionalBW_AdditionalBW_None
}

func (x *SchedulerConfig) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *SchedulerConfig) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *SchedulerConfig) GetSchedPolicy() SchedulingPolicy {
	if x != nil {
		return x.SchedPolicy
	}
	return SchedulingPolicy_WRR
}

type TrafficShapingInfo struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Cir           uint32                       `protobuf:"fixed32,1,opt,name=cir,proto3" json:"cir,omitempty"`
	Cbs           uint32                       `protobuf:"fixed32,2,opt,name=cbs,proto3" json:"cbs,omitempty"`
	Pir           uint32                       `protobuf:"fixed32,3,opt,name=pir,proto3" json:"pir,omitempty"`
	Pbs           uint32                       `protobuf:"fixed32,4,opt,name=pbs,proto3" json:"pbs,omitempty"`
	Gir           uint32                       `protobuf:"fixed32,5,opt,name=gir,proto3" json:"gir,omitempty"`                                                                           // only if “direction == Upstream ”
	AddBwInd      InferredAdditionBWIndication `protobuf:"varint,6,opt,name=add_bw_ind,json=addBwInd,proto3,enum=tech_profile.InferredAdditionBWIndication" json:"add_bw_ind,omitempty"` // only if “direction == Upstream”
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficShapingInfo) Reset() {
	*x = TrafficShapingInfo{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficShapingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficShapingInfo) ProtoMessage() {}

func (x *TrafficShapingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficShapingInfo.ProtoReflect.Descriptor instead.
func (*TrafficShapingInfo) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{1}
}

func (x *TrafficShapingInfo) GetCir() uint32 {
	if x != nil {
		return x.Cir
	}
	return 0
}

func (x *TrafficShapingInfo) GetCbs() uint32 {
	if x != nil {
		return x.Cbs
	}
	return 0
}

func (x *TrafficShapingInfo) GetPir() uint32 {
	if x != nil {
		return x.Pir
	}
	return 0
}

func (x *TrafficShapingInfo) GetPbs() uint32 {
	if x != nil {
		return x.Pbs
	}
	return 0
}

func (x *TrafficShapingInfo) GetGir() uint32 {
	if x != nil {
		return x.Gir
	}
	return 0
}

func (x *TrafficShapingInfo) GetAddBwInd() InferredAdditionBWIndication {
	if x != nil {
		return x.AddBwInd
	}
	return InferredAdditionBWIndication_InferredAdditionBWIndication_None
}

type TrafficScheduler struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	Direction          Direction              `protobuf:"varint,1,opt,name=direction,proto3,enum=tech_profile.Direction" json:"direction,omitempty"`
	AllocId            uint32                 `protobuf:"fixed32,2,opt,name=alloc_id,json=allocId,proto3" json:"alloc_id,omitempty"` // valid only if “direction == Upstream ”
	Scheduler          *SchedulerConfig       `protobuf:"bytes,3,opt,name=scheduler,proto3" json:"scheduler,omitempty"`
	TrafficShapingInfo *TrafficShapingInfo    `protobuf:"bytes,4,opt,name=traffic_shaping_info,json=trafficShapingInfo,proto3" json:"traffic_shaping_info,omitempty"`
	TechProfileId      uint32                 `protobuf:"fixed32,5,opt,name=tech_profile_id,json=techProfileId,proto3" json:"tech_profile_id,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *TrafficScheduler) Reset() {
	*x = TrafficScheduler{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficScheduler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficScheduler) ProtoMessage() {}

func (x *TrafficScheduler) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficScheduler.ProtoReflect.Descriptor instead.
func (*TrafficScheduler) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{2}
}

func (x *TrafficScheduler) GetDirection() Direction {
	if x != nil {
		return x.Direction
	}
	return Direction_UPSTREAM
}

func (x *TrafficScheduler) GetAllocId() uint32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *TrafficScheduler) GetScheduler() *SchedulerConfig {
	if x != nil {
		return x.Scheduler
	}
	return nil
}

func (x *TrafficScheduler) GetTrafficShapingInfo() *TrafficShapingInfo {
	if x != nil {
		return x.TrafficShapingInfo
	}
	return nil
}

func (x *TrafficScheduler) GetTechProfileId() uint32 {
	if x != nil {
		return x.TechProfileId
	}
	return 0
}

type TrafficSchedulers struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	UniId         uint32                 `protobuf:"fixed32,4,opt,name=uni_id,json=uniId,proto3" json:"uni_id,omitempty"`
	PortNo        uint32                 `protobuf:"fixed32,5,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	TrafficScheds []*TrafficScheduler    `protobuf:"bytes,3,rep,name=traffic_scheds,json=trafficScheds,proto3" json:"traffic_scheds,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficSchedulers) Reset() {
	*x = TrafficSchedulers{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficSchedulers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficSchedulers) ProtoMessage() {}

func (x *TrafficSchedulers) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficSchedulers.ProtoReflect.Descriptor instead.
func (*TrafficSchedulers) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{3}
}

func (x *TrafficSchedulers) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *TrafficSchedulers) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *TrafficSchedulers) GetUniId() uint32 {
	if x != nil {
		return x.UniId
	}
	return 0
}

func (x *TrafficSchedulers) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *TrafficSchedulers) GetTrafficScheds() []*TrafficScheduler {
	if x != nil {
		return x.TrafficScheds
	}
	return nil
}

type TailDropDiscardConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	QueueSize     uint32                 `protobuf:"fixed32,1,opt,name=queue_size,json=queueSize,proto3" json:"queue_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TailDropDiscardConfig) Reset() {
	*x = TailDropDiscardConfig{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TailDropDiscardConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TailDropDiscardConfig) ProtoMessage() {}

func (x *TailDropDiscardConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TailDropDiscardConfig.ProtoReflect.Descriptor instead.
func (*TailDropDiscardConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{4}
}

func (x *TailDropDiscardConfig) GetQueueSize() uint32 {
	if x != nil {
		return x.QueueSize
	}
	return 0
}

type RedDiscardConfig struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	MinThreshold   uint32                 `protobuf:"fixed32,1,opt,name=min_threshold,json=minThreshold,proto3" json:"min_threshold,omitempty"`
	MaxThreshold   uint32                 `protobuf:"fixed32,2,opt,name=max_threshold,json=maxThreshold,proto3" json:"max_threshold,omitempty"`
	MaxProbability uint32                 `protobuf:"fixed32,3,opt,name=max_probability,json=maxProbability,proto3" json:"max_probability,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *RedDiscardConfig) Reset() {
	*x = RedDiscardConfig{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedDiscardConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedDiscardConfig) ProtoMessage() {}

func (x *RedDiscardConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedDiscardConfig.ProtoReflect.Descriptor instead.
func (*RedDiscardConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{5}
}

func (x *RedDiscardConfig) GetMinThreshold() uint32 {
	if x != nil {
		return x.MinThreshold
	}
	return 0
}

func (x *RedDiscardConfig) GetMaxThreshold() uint32 {
	if x != nil {
		return x.MaxThreshold
	}
	return 0
}

func (x *RedDiscardConfig) GetMaxProbability() uint32 {
	if x != nil {
		return x.MaxProbability
	}
	return 0
}

type WRedDiscardConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Green         *RedDiscardConfig      `protobuf:"bytes,1,opt,name=green,proto3" json:"green,omitempty"`
	Yellow        *RedDiscardConfig      `protobuf:"bytes,2,opt,name=yellow,proto3" json:"yellow,omitempty"`
	Red           *RedDiscardConfig      `protobuf:"bytes,3,opt,name=red,proto3" json:"red,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WRedDiscardConfig) Reset() {
	*x = WRedDiscardConfig{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WRedDiscardConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WRedDiscardConfig) ProtoMessage() {}

func (x *WRedDiscardConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WRedDiscardConfig.ProtoReflect.Descriptor instead.
func (*WRedDiscardConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{6}
}

func (x *WRedDiscardConfig) GetGreen() *RedDiscardConfig {
	if x != nil {
		return x.Green
	}
	return nil
}

func (x *WRedDiscardConfig) GetYellow() *RedDiscardConfig {
	if x != nil {
		return x.Yellow
	}
	return nil
}

func (x *WRedDiscardConfig) GetRed() *RedDiscardConfig {
	if x != nil {
		return x.Red
	}
	return nil
}

type DiscardConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	DiscardPolicy DiscardPolicy          `protobuf:"varint,1,opt,name=discard_policy,json=discardPolicy,proto3,enum=tech_profile.DiscardPolicy" json:"discard_policy,omitempty"`
	// Types that are valid to be assigned to DiscardConfig:
	//
	//	*DiscardConfig_TailDropDiscardConfig
	//	*DiscardConfig_RedDiscardConfig
	//	*DiscardConfig_WredDiscardConfig
	DiscardConfig isDiscardConfig_DiscardConfig `protobuf_oneof:"discard_config"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiscardConfig) Reset() {
	*x = DiscardConfig{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiscardConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscardConfig) ProtoMessage() {}

func (x *DiscardConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscardConfig.ProtoReflect.Descriptor instead.
func (*DiscardConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{7}
}

func (x *DiscardConfig) GetDiscardPolicy() DiscardPolicy {
	if x != nil {
		return x.DiscardPolicy
	}
	return DiscardPolicy_TailDrop
}

func (x *DiscardConfig) GetDiscardConfig() isDiscardConfig_DiscardConfig {
	if x != nil {
		return x.DiscardConfig
	}
	return nil
}

func (x *DiscardConfig) GetTailDropDiscardConfig() *TailDropDiscardConfig {
	if x != nil {
		if x, ok := x.DiscardConfig.(*DiscardConfig_TailDropDiscardConfig); ok {
			return x.TailDropDiscardConfig
		}
	}
	return nil
}

func (x *DiscardConfig) GetRedDiscardConfig() *RedDiscardConfig {
	if x != nil {
		if x, ok := x.DiscardConfig.(*DiscardConfig_RedDiscardConfig); ok {
			return x.RedDiscardConfig
		}
	}
	return nil
}

func (x *DiscardConfig) GetWredDiscardConfig() *WRedDiscardConfig {
	if x != nil {
		if x, ok := x.DiscardConfig.(*DiscardConfig_WredDiscardConfig); ok {
			return x.WredDiscardConfig
		}
	}
	return nil
}

type isDiscardConfig_DiscardConfig interface {
	isDiscardConfig_DiscardConfig()
}

type DiscardConfig_TailDropDiscardConfig struct {
	TailDropDiscardConfig *TailDropDiscardConfig `protobuf:"bytes,2,opt,name=tail_drop_discard_config,json=tailDropDiscardConfig,proto3,oneof"`
}

type DiscardConfig_RedDiscardConfig struct {
	RedDiscardConfig *RedDiscardConfig `protobuf:"bytes,3,opt,name=red_discard_config,json=redDiscardConfig,proto3,oneof"`
}

type DiscardConfig_WredDiscardConfig struct {
	WredDiscardConfig *WRedDiscardConfig `protobuf:"bytes,4,opt,name=wred_discard_config,json=wredDiscardConfig,proto3,oneof"`
}

func (*DiscardConfig_TailDropDiscardConfig) isDiscardConfig_DiscardConfig() {}

func (*DiscardConfig_RedDiscardConfig) isDiscardConfig_DiscardConfig() {}

func (*DiscardConfig_WredDiscardConfig) isDiscardConfig_DiscardConfig() {}

type TrafficQueue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Direction     Direction              `protobuf:"varint,1,opt,name=direction,proto3,enum=tech_profile.Direction" json:"direction,omitempty"`
	GemportId     uint32                 `protobuf:"fixed32,2,opt,name=gemport_id,json=gemportId,proto3" json:"gemport_id,omitempty"`
	PbitMap       string                 `protobuf:"bytes,3,opt,name=pbit_map,json=pbitMap,proto3" json:"pbit_map,omitempty"`
	AesEncryption bool                   `protobuf:"varint,4,opt,name=aes_encryption,json=aesEncryption,proto3" json:"aes_encryption,omitempty"`
	SchedPolicy   SchedulingPolicy       `protobuf:"varint,5,opt,name=sched_policy,json=schedPolicy,proto3,enum=tech_profile.SchedulingPolicy" json:"sched_policy,omitempty"` // This can be SP or WRR
	Priority      uint32                 `protobuf:"fixed32,6,opt,name=priority,proto3" json:"priority,omitempty"`
	Weight        uint32                 `protobuf:"fixed32,7,opt,name=weight,proto3" json:"weight,omitempty"`
	DiscardPolicy DiscardPolicy          `protobuf:"varint,8,opt,name=discard_policy,json=discardPolicy,proto3,enum=tech_profile.DiscardPolicy" json:"discard_policy,omitempty"`
	DiscardConfig *DiscardConfig         `protobuf:"bytes,9,opt,name=discard_config,json=discardConfig,proto3" json:"discard_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficQueue) Reset() {
	*x = TrafficQueue{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficQueue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficQueue) ProtoMessage() {}

func (x *TrafficQueue) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficQueue.ProtoReflect.Descriptor instead.
func (*TrafficQueue) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{8}
}

func (x *TrafficQueue) GetDirection() Direction {
	if x != nil {
		return x.Direction
	}
	return Direction_UPSTREAM
}

func (x *TrafficQueue) GetGemportId() uint32 {
	if x != nil {
		return x.GemportId
	}
	return 0
}

func (x *TrafficQueue) GetPbitMap() string {
	if x != nil {
		return x.PbitMap
	}
	return ""
}

func (x *TrafficQueue) GetAesEncryption() bool {
	if x != nil {
		return x.AesEncryption
	}
	return false
}

func (x *TrafficQueue) GetSchedPolicy() SchedulingPolicy {
	if x != nil {
		return x.SchedPolicy
	}
	return SchedulingPolicy_WRR
}

func (x *TrafficQueue) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *TrafficQueue) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *TrafficQueue) GetDiscardPolicy() DiscardPolicy {
	if x != nil {
		return x.DiscardPolicy
	}
	return DiscardPolicy_TailDrop
}

func (x *TrafficQueue) GetDiscardConfig() *DiscardConfig {
	if x != nil {
		return x.DiscardConfig
	}
	return nil
}

type TrafficQueues struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	UniId         uint32                 `protobuf:"fixed32,4,opt,name=uni_id,json=uniId,proto3" json:"uni_id,omitempty"`
	PortNo        uint32                 `protobuf:"fixed32,5,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	TrafficQueues []*TrafficQueue        `protobuf:"bytes,6,rep,name=traffic_queues,json=trafficQueues,proto3" json:"traffic_queues,omitempty"`
	TechProfileId uint32                 `protobuf:"fixed32,7,opt,name=tech_profile_id,json=techProfileId,proto3" json:"tech_profile_id,omitempty"`
	NetworkIntfId uint32                 `protobuf:"fixed32,8,opt,name=network_intf_id,json=networkIntfId,proto3" json:"network_intf_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficQueues) Reset() {
	*x = TrafficQueues{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficQueues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficQueues) ProtoMessage() {}

func (x *TrafficQueues) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficQueues.ProtoReflect.Descriptor instead.
func (*TrafficQueues) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{9}
}

func (x *TrafficQueues) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *TrafficQueues) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *TrafficQueues) GetUniId() uint32 {
	if x != nil {
		return x.UniId
	}
	return 0
}

func (x *TrafficQueues) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *TrafficQueues) GetTrafficQueues() []*TrafficQueue {
	if x != nil {
		return x.TrafficQueues
	}
	return nil
}

func (x *TrafficQueues) GetTechProfileId() uint32 {
	if x != nil {
		return x.TechProfileId
	}
	return 0
}

func (x *TrafficQueues) GetNetworkIntfId() uint32 {
	if x != nil {
		return x.NetworkIntfId
	}
	return 0
}

type InstanceControl struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	Onu               string                 `protobuf:"bytes,1,opt,name=onu,proto3" json:"onu,omitempty"`
	Uni               string                 `protobuf:"bytes,2,opt,name=uni,proto3" json:"uni,omitempty"`
	MaxGemPayloadSize string                 `protobuf:"bytes,3,opt,name=max_gem_payload_size,json=maxGemPayloadSize,proto3" json:"max_gem_payload_size,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *InstanceControl) Reset() {
	*x = InstanceControl{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstanceControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceControl) ProtoMessage() {}

func (x *InstanceControl) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceControl.ProtoReflect.Descriptor instead.
func (*InstanceControl) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{10}
}

func (x *InstanceControl) GetOnu() string {
	if x != nil {
		return x.Onu
	}
	return ""
}

func (x *InstanceControl) GetUni() string {
	if x != nil {
		return x.Uni
	}
	return ""
}

func (x *InstanceControl) GetMaxGemPayloadSize() string {
	if x != nil {
		return x.MaxGemPayloadSize
	}
	return ""
}

type QThresholds struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	QThreshold1   uint32                 `protobuf:"varint,1,opt,name=q_threshold1,json=qThreshold1,proto3" json:"q_threshold1,omitempty"`
	QThreshold2   uint32                 `protobuf:"varint,2,opt,name=q_threshold2,json=qThreshold2,proto3" json:"q_threshold2,omitempty"`
	QThreshold3   uint32                 `protobuf:"varint,3,opt,name=q_threshold3,json=qThreshold3,proto3" json:"q_threshold3,omitempty"`
	QThreshold4   uint32                 `protobuf:"varint,4,opt,name=q_threshold4,json=qThreshold4,proto3" json:"q_threshold4,omitempty"`
	QThreshold5   uint32                 `protobuf:"varint,5,opt,name=q_threshold5,json=qThreshold5,proto3" json:"q_threshold5,omitempty"`
	QThreshold6   uint32                 `protobuf:"varint,6,opt,name=q_threshold6,json=qThreshold6,proto3" json:"q_threshold6,omitempty"`
	QThreshold7   uint32                 `protobuf:"varint,7,opt,name=q_threshold7,json=qThreshold7,proto3" json:"q_threshold7,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QThresholds) Reset() {
	*x = QThresholds{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QThresholds) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QThresholds) ProtoMessage() {}

func (x *QThresholds) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QThresholds.ProtoReflect.Descriptor instead.
func (*QThresholds) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{11}
}

func (x *QThresholds) GetQThreshold1() uint32 {
	if x != nil {
		return x.QThreshold1
	}
	return 0
}

func (x *QThresholds) GetQThreshold2() uint32 {
	if x != nil {
		return x.QThreshold2
	}
	return 0
}

func (x *QThresholds) GetQThreshold3() uint32 {
	if x != nil {
		return x.QThreshold3
	}
	return 0
}

func (x *QThresholds) GetQThreshold4() uint32 {
	if x != nil {
		return x.QThreshold4
	}
	return 0
}

func (x *QThresholds) GetQThreshold5() uint32 {
	if x != nil {
		return x.QThreshold5
	}
	return 0
}

func (x *QThresholds) GetQThreshold6() uint32 {
	if x != nil {
		return x.QThreshold6
	}
	return 0
}

func (x *QThresholds) GetQThreshold7() uint32 {
	if x != nil {
		return x.QThreshold7
	}
	return 0
}

type GemPortAttributes struct {
	state                    protoimpl.MessageState `protogen:"open.v1"`
	GemportId                uint32                 `protobuf:"fixed32,1,opt,name=gemport_id,json=gemportId,proto3" json:"gemport_id,omitempty"` // valid only when referenced in the tech profile instance
	MaxQSize                 string                 `protobuf:"bytes,2,opt,name=max_q_size,json=maxQSize,proto3" json:"max_q_size,omitempty"`
	PbitMap                  string                 `protobuf:"bytes,3,opt,name=pbit_map,json=pbitMap,proto3" json:"pbit_map,omitempty"`
	AesEncryption            string                 `protobuf:"bytes,4,opt,name=aes_encryption,json=aesEncryption,proto3" json:"aes_encryption,omitempty"`
	SchedulingPolicy         SchedulingPolicy       `protobuf:"varint,5,opt,name=scheduling_policy,json=schedulingPolicy,proto3,enum=tech_profile.SchedulingPolicy" json:"scheduling_policy,omitempty"` // This can be SP or WRR
	PriorityQ                uint32                 `protobuf:"fixed32,6,opt,name=priority_q,json=priorityQ,proto3" json:"priority_q,omitempty"`
	Weight                   uint32                 `protobuf:"fixed32,7,opt,name=weight,proto3" json:"weight,omitempty"`
	DiscardPolicy            DiscardPolicy          `protobuf:"varint,8,opt,name=discard_policy,json=discardPolicy,proto3,enum=tech_profile.DiscardPolicy" json:"discard_policy,omitempty"`
	DiscardConfig            *RedDiscardConfig      `protobuf:"bytes,9,opt,name=discard_config,json=discardConfig,proto3" json:"discard_config,omitempty"`          // used with version 1 of tech profile
	DiscardConfigV2          *DiscardConfig         `protobuf:"bytes,14,opt,name=discard_config_v2,json=discardConfigV2,proto3" json:"discard_config_v2,omitempty"` // used with version 2 of tech profile
	IsMulticast              string                 `protobuf:"bytes,10,opt,name=is_multicast,json=isMulticast,proto3" json:"is_multicast,omitempty"`
	MulticastGemId           uint32                 `protobuf:"fixed32,11,opt,name=multicast_gem_id,json=multicastGemId,proto3" json:"multicast_gem_id,omitempty"`
	DynamicAccessControlList string                 `protobuf:"bytes,12,opt,name=dynamic_access_control_list,json=dynamicAccessControlList,proto3" json:"dynamic_access_control_list,omitempty"`
	StaticAccessControlList  string                 `protobuf:"bytes,13,opt,name=static_access_control_list,json=staticAccessControlList,proto3" json:"static_access_control_list,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *GemPortAttributes) Reset() {
	*x = GemPortAttributes{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GemPortAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GemPortAttributes) ProtoMessage() {}

func (x *GemPortAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GemPortAttributes.ProtoReflect.Descriptor instead.
func (*GemPortAttributes) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{12}
}

func (x *GemPortAttributes) GetGemportId() uint32 {
	if x != nil {
		return x.GemportId
	}
	return 0
}

func (x *GemPortAttributes) GetMaxQSize() string {
	if x != nil {
		return x.MaxQSize
	}
	return ""
}

func (x *GemPortAttributes) GetPbitMap() string {
	if x != nil {
		return x.PbitMap
	}
	return ""
}

func (x *GemPortAttributes) GetAesEncryption() string {
	if x != nil {
		return x.AesEncryption
	}
	return ""
}

func (x *GemPortAttributes) GetSchedulingPolicy() SchedulingPolicy {
	if x != nil {
		return x.SchedulingPolicy
	}
	return SchedulingPolicy_WRR
}

func (x *GemPortAttributes) GetPriorityQ() uint32 {
	if x != nil {
		return x.PriorityQ
	}
	return 0
}

func (x *GemPortAttributes) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *GemPortAttributes) GetDiscardPolicy() DiscardPolicy {
	if x != nil {
		return x.DiscardPolicy
	}
	return DiscardPolicy_TailDrop
}

func (x *GemPortAttributes) GetDiscardConfig() *RedDiscardConfig {
	if x != nil {
		return x.DiscardConfig
	}
	return nil
}

func (x *GemPortAttributes) GetDiscardConfigV2() *DiscardConfig {
	if x != nil {
		return x.DiscardConfigV2
	}
	return nil
}

func (x *GemPortAttributes) GetIsMulticast() string {
	if x != nil {
		return x.IsMulticast
	}
	return ""
}

func (x *GemPortAttributes) GetMulticastGemId() uint32 {
	if x != nil {
		return x.MulticastGemId
	}
	return 0
}

func (x *GemPortAttributes) GetDynamicAccessControlList() string {
	if x != nil {
		return x.DynamicAccessControlList
	}
	return ""
}

func (x *GemPortAttributes) GetStaticAccessControlList() string {
	if x != nil {
		return x.StaticAccessControlList
	}
	return ""
}

type SchedulerAttributes struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Direction     Direction              `protobuf:"varint,1,opt,name=direction,proto3,enum=tech_profile.Direction" json:"direction,omitempty"`
	AllocId       uint32                 `protobuf:"varint,2,opt,name=alloc_id,json=allocId,proto3" json:"alloc_id,omitempty"`                                               //  Valid on for “direction == Upstream” and when referenced in the tech profile instance
	AdditionalBw  AdditionalBW           `protobuf:"varint,3,opt,name=additional_bw,json=additionalBw,proto3,enum=tech_profile.AdditionalBW" json:"additional_bw,omitempty"` // Valid on for “direction == Upstream”.
	Priority      uint32                 `protobuf:"fixed32,4,opt,name=priority,proto3" json:"priority,omitempty"`
	Weight        uint32                 `protobuf:"fixed32,5,opt,name=weight,proto3" json:"weight,omitempty"`
	QSchedPolicy  SchedulingPolicy       `protobuf:"varint,6,opt,name=q_sched_policy,json=qSchedPolicy,proto3,enum=tech_profile.SchedulingPolicy" json:"q_sched_policy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SchedulerAttributes) Reset() {
	*x = SchedulerAttributes{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchedulerAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulerAttributes) ProtoMessage() {}

func (x *SchedulerAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulerAttributes.ProtoReflect.Descriptor instead.
func (*SchedulerAttributes) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{13}
}

func (x *SchedulerAttributes) GetDirection() Direction {
	if x != nil {
		return x.Direction
	}
	return Direction_UPSTREAM
}

func (x *SchedulerAttributes) GetAllocId() uint32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *SchedulerAttributes) GetAdditionalBw() AdditionalBW {
	if x != nil {
		return x.AdditionalBw
	}
	return AdditionalBW_AdditionalBW_None
}

func (x *SchedulerAttributes) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *SchedulerAttributes) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *SchedulerAttributes) GetQSchedPolicy() SchedulingPolicy {
	if x != nil {
		return x.QSchedPolicy
	}
	return SchedulingPolicy_WRR
}

type EPONQueueAttributes struct {
	state                     protoimpl.MessageState `protogen:"open.v1"`
	MaxQSize                  string                 `protobuf:"bytes,1,opt,name=max_q_size,json=maxQSize,proto3" json:"max_q_size,omitempty"`
	PbitMap                   string                 `protobuf:"bytes,2,opt,name=pbit_map,json=pbitMap,proto3" json:"pbit_map,omitempty"`
	GemportId                 uint32                 `protobuf:"varint,3,opt,name=gemport_id,json=gemportId,proto3" json:"gemport_id,omitempty"`
	AesEncryption             string                 `protobuf:"bytes,4,opt,name=aes_encryption,json=aesEncryption,proto3" json:"aes_encryption,omitempty"`
	TrafficType               string                 `protobuf:"bytes,5,opt,name=traffic_type,json=trafficType,proto3" json:"traffic_type,omitempty"`
	UnsolicitedGrantSize      uint32                 `protobuf:"varint,6,opt,name=unsolicited_grant_size,json=unsolicitedGrantSize,proto3" json:"unsolicited_grant_size,omitempty"`
	NominalInterval           uint32                 `protobuf:"varint,7,opt,name=nominal_interval,json=nominalInterval,proto3" json:"nominal_interval,omitempty"`
	ToleratedPollJitter       uint32                 `protobuf:"varint,8,opt,name=tolerated_poll_jitter,json=toleratedPollJitter,proto3" json:"tolerated_poll_jitter,omitempty"`
	RequestTransmissionPolicy uint32                 `protobuf:"varint,9,opt,name=request_transmission_policy,json=requestTransmissionPolicy,proto3" json:"request_transmission_policy,omitempty"`
	NumQSets                  uint32                 `protobuf:"varint,10,opt,name=num_q_sets,json=numQSets,proto3" json:"num_q_sets,omitempty"`
	QThresholds               *QThresholds           `protobuf:"bytes,11,opt,name=q_thresholds,json=qThresholds,proto3" json:"q_thresholds,omitempty"`
	SchedulingPolicy          SchedulingPolicy       `protobuf:"varint,12,opt,name=scheduling_policy,json=schedulingPolicy,proto3,enum=tech_profile.SchedulingPolicy" json:"scheduling_policy,omitempty"`
	PriorityQ                 uint32                 `protobuf:"varint,13,opt,name=priority_q,json=priorityQ,proto3" json:"priority_q,omitempty"`
	Weight                    uint32                 `protobuf:"varint,14,opt,name=weight,proto3" json:"weight,omitempty"`
	DiscardPolicy             DiscardPolicy          `protobuf:"varint,15,opt,name=discard_policy,json=discardPolicy,proto3,enum=tech_profile.DiscardPolicy" json:"discard_policy,omitempty"`
	DiscardConfig             *RedDiscardConfig      `protobuf:"bytes,16,opt,name=discard_config,json=discardConfig,proto3" json:"discard_config,omitempty"`         // used with version 1 of tech profile
	DiscardConfigV2           *DiscardConfig         `protobuf:"bytes,17,opt,name=discard_config_v2,json=discardConfigV2,proto3" json:"discard_config_v2,omitempty"` // used with version 2 of tech profile
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *EPONQueueAttributes) Reset() {
	*x = EPONQueueAttributes{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EPONQueueAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EPONQueueAttributes) ProtoMessage() {}

func (x *EPONQueueAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EPONQueueAttributes.ProtoReflect.Descriptor instead.
func (*EPONQueueAttributes) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{14}
}

func (x *EPONQueueAttributes) GetMaxQSize() string {
	if x != nil {
		return x.MaxQSize
	}
	return ""
}

func (x *EPONQueueAttributes) GetPbitMap() string {
	if x != nil {
		return x.PbitMap
	}
	return ""
}

func (x *EPONQueueAttributes) GetGemportId() uint32 {
	if x != nil {
		return x.GemportId
	}
	return 0
}

func (x *EPONQueueAttributes) GetAesEncryption() string {
	if x != nil {
		return x.AesEncryption
	}
	return ""
}

func (x *EPONQueueAttributes) GetTrafficType() string {
	if x != nil {
		return x.TrafficType
	}
	return ""
}

func (x *EPONQueueAttributes) GetUnsolicitedGrantSize() uint32 {
	if x != nil {
		return x.UnsolicitedGrantSize
	}
	return 0
}

func (x *EPONQueueAttributes) GetNominalInterval() uint32 {
	if x != nil {
		return x.NominalInterval
	}
	return 0
}

func (x *EPONQueueAttributes) GetToleratedPollJitter() uint32 {
	if x != nil {
		return x.ToleratedPollJitter
	}
	return 0
}

func (x *EPONQueueAttributes) GetRequestTransmissionPolicy() uint32 {
	if x != nil {
		return x.RequestTransmissionPolicy
	}
	return 0
}

func (x *EPONQueueAttributes) GetNumQSets() uint32 {
	if x != nil {
		return x.NumQSets
	}
	return 0
}

func (x *EPONQueueAttributes) GetQThresholds() *QThresholds {
	if x != nil {
		return x.QThresholds
	}
	return nil
}

func (x *EPONQueueAttributes) GetSchedulingPolicy() SchedulingPolicy {
	if x != nil {
		return x.SchedulingPolicy
	}
	return SchedulingPolicy_WRR
}

func (x *EPONQueueAttributes) GetPriorityQ() uint32 {
	if x != nil {
		return x.PriorityQ
	}
	return 0
}

func (x *EPONQueueAttributes) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *EPONQueueAttributes) GetDiscardPolicy() DiscardPolicy {
	if x != nil {
		return x.DiscardPolicy
	}
	return DiscardPolicy_TailDrop
}

func (x *EPONQueueAttributes) GetDiscardConfig() *RedDiscardConfig {
	if x != nil {
		return x.DiscardConfig
	}
	return nil
}

func (x *EPONQueueAttributes) GetDiscardConfigV2() *DiscardConfig {
	if x != nil {
		return x.DiscardConfigV2
	}
	return nil
}

// TechProfile definition (relevant for GPON, XGPON and XGS-PON technologies)
type TechProfile struct {
	state                          protoimpl.MessageState `protogen:"open.v1"`
	Name                           string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version                        uint32                 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	ProfileType                    string                 `protobuf:"bytes,3,opt,name=profile_type,json=profileType,proto3" json:"profile_type,omitempty"`
	NumGemPorts                    uint32                 `protobuf:"varint,4,opt,name=num_gem_ports,json=numGemPorts,proto3" json:"num_gem_ports,omitempty"`
	InstanceControl                *InstanceControl       `protobuf:"bytes,5,opt,name=instance_control,json=instanceControl,proto3" json:"instance_control,omitempty"`
	UsScheduler                    *SchedulerAttributes   `protobuf:"bytes,6,opt,name=us_scheduler,json=usScheduler,proto3" json:"us_scheduler,omitempty"`
	DsScheduler                    *SchedulerAttributes   `protobuf:"bytes,7,opt,name=ds_scheduler,json=dsScheduler,proto3" json:"ds_scheduler,omitempty"`
	UpstreamGemPortAttributeList   []*GemPortAttributes   `protobuf:"bytes,8,rep,name=upstream_gem_port_attribute_list,json=upstreamGemPortAttributeList,proto3" json:"upstream_gem_port_attribute_list,omitempty"`
	DownstreamGemPortAttributeList []*GemPortAttributes   `protobuf:"bytes,9,rep,name=downstream_gem_port_attribute_list,json=downstreamGemPortAttributeList,proto3" json:"downstream_gem_port_attribute_list,omitempty"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *TechProfile) Reset() {
	*x = TechProfile{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TechProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TechProfile) ProtoMessage() {}

func (x *TechProfile) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TechProfile.ProtoReflect.Descriptor instead.
func (*TechProfile) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{15}
}

func (x *TechProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TechProfile) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *TechProfile) GetProfileType() string {
	if x != nil {
		return x.ProfileType
	}
	return ""
}

func (x *TechProfile) GetNumGemPorts() uint32 {
	if x != nil {
		return x.NumGemPorts
	}
	return 0
}

func (x *TechProfile) GetInstanceControl() *InstanceControl {
	if x != nil {
		return x.InstanceControl
	}
	return nil
}

func (x *TechProfile) GetUsScheduler() *SchedulerAttributes {
	if x != nil {
		return x.UsScheduler
	}
	return nil
}

func (x *TechProfile) GetDsScheduler() *SchedulerAttributes {
	if x != nil {
		return x.DsScheduler
	}
	return nil
}

func (x *TechProfile) GetUpstreamGemPortAttributeList() []*GemPortAttributes {
	if x != nil {
		return x.UpstreamGemPortAttributeList
	}
	return nil
}

func (x *TechProfile) GetDownstreamGemPortAttributeList() []*GemPortAttributes {
	if x != nil {
		return x.DownstreamGemPortAttributeList
	}
	return nil
}

// EPON TechProfile definition
type EponTechProfile struct {
	state                        protoimpl.MessageState `protogen:"open.v1"`
	Name                         string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version                      uint32                 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	ProfileType                  string                 `protobuf:"bytes,3,opt,name=profile_type,json=profileType,proto3" json:"profile_type,omitempty"`
	NumGemPorts                  uint32                 `protobuf:"varint,4,opt,name=num_gem_ports,json=numGemPorts,proto3" json:"num_gem_ports,omitempty"`
	InstanceControl              *InstanceControl       `protobuf:"bytes,5,opt,name=instance_control,json=instanceControl,proto3" json:"instance_control,omitempty"`
	PackageType                  string                 `protobuf:"bytes,6,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	UpstreamQueueAttributeList   []*EPONQueueAttributes `protobuf:"bytes,7,rep,name=upstream_queue_attribute_list,json=upstreamQueueAttributeList,proto3" json:"upstream_queue_attribute_list,omitempty"`
	DownstreamQueueAttributeList []*EPONQueueAttributes `protobuf:"bytes,8,rep,name=downstream_queue_attribute_list,json=downstreamQueueAttributeList,proto3" json:"downstream_queue_attribute_list,omitempty"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *EponTechProfile) Reset() {
	*x = EponTechProfile{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EponTechProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EponTechProfile) ProtoMessage() {}

func (x *EponTechProfile) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EponTechProfile.ProtoReflect.Descriptor instead.
func (*EponTechProfile) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{16}
}

func (x *EponTechProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EponTechProfile) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EponTechProfile) GetProfileType() string {
	if x != nil {
		return x.ProfileType
	}
	return ""
}

func (x *EponTechProfile) GetNumGemPorts() uint32 {
	if x != nil {
		return x.NumGemPorts
	}
	return 0
}

func (x *EponTechProfile) GetInstanceControl() *InstanceControl {
	if x != nil {
		return x.InstanceControl
	}
	return nil
}

func (x *EponTechProfile) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

func (x *EponTechProfile) GetUpstreamQueueAttributeList() []*EPONQueueAttributes {
	if x != nil {
		return x.UpstreamQueueAttributeList
	}
	return nil
}

func (x *EponTechProfile) GetDownstreamQueueAttributeList() []*EPONQueueAttributes {
	if x != nil {
		return x.DownstreamQueueAttributeList
	}
	return nil
}

// TechProfile Instance definition (relevant for GPON, XGPON and XGS-PON technologies)
type TechProfileInstance struct {
	state                          protoimpl.MessageState `protogen:"open.v1"`
	Name                           string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version                        uint32                 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	SubscriberIdentifier           string                 `protobuf:"bytes,3,opt,name=subscriber_identifier,json=subscriberIdentifier,proto3" json:"subscriber_identifier,omitempty"`
	ProfileType                    string                 `protobuf:"bytes,4,opt,name=profile_type,json=profileType,proto3" json:"profile_type,omitempty"`
	NumGemPorts                    uint32                 `protobuf:"varint,5,opt,name=num_gem_ports,json=numGemPorts,proto3" json:"num_gem_ports,omitempty"`
	InstanceControl                *InstanceControl       `protobuf:"bytes,6,opt,name=instance_control,json=instanceControl,proto3" json:"instance_control,omitempty"`
	UsScheduler                    *SchedulerAttributes   `protobuf:"bytes,7,opt,name=us_scheduler,json=usScheduler,proto3" json:"us_scheduler,omitempty"`
	DsScheduler                    *SchedulerAttributes   `protobuf:"bytes,8,opt,name=ds_scheduler,json=dsScheduler,proto3" json:"ds_scheduler,omitempty"`
	UpstreamGemPortAttributeList   []*GemPortAttributes   `protobuf:"bytes,9,rep,name=upstream_gem_port_attribute_list,json=upstreamGemPortAttributeList,proto3" json:"upstream_gem_port_attribute_list,omitempty"`
	DownstreamGemPortAttributeList []*GemPortAttributes   `protobuf:"bytes,10,rep,name=downstream_gem_port_attribute_list,json=downstreamGemPortAttributeList,proto3" json:"downstream_gem_port_attribute_list,omitempty"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *TechProfileInstance) Reset() {
	*x = TechProfileInstance{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TechProfileInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TechProfileInstance) ProtoMessage() {}

func (x *TechProfileInstance) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TechProfileInstance.ProtoReflect.Descriptor instead.
func (*TechProfileInstance) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{17}
}

func (x *TechProfileInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TechProfileInstance) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *TechProfileInstance) GetSubscriberIdentifier() string {
	if x != nil {
		return x.SubscriberIdentifier
	}
	return ""
}

func (x *TechProfileInstance) GetProfileType() string {
	if x != nil {
		return x.ProfileType
	}
	return ""
}

func (x *TechProfileInstance) GetNumGemPorts() uint32 {
	if x != nil {
		return x.NumGemPorts
	}
	return 0
}

func (x *TechProfileInstance) GetInstanceControl() *InstanceControl {
	if x != nil {
		return x.InstanceControl
	}
	return nil
}

func (x *TechProfileInstance) GetUsScheduler() *SchedulerAttributes {
	if x != nil {
		return x.UsScheduler
	}
	return nil
}

func (x *TechProfileInstance) GetDsScheduler() *SchedulerAttributes {
	if x != nil {
		return x.DsScheduler
	}
	return nil
}

func (x *TechProfileInstance) GetUpstreamGemPortAttributeList() []*GemPortAttributes {
	if x != nil {
		return x.UpstreamGemPortAttributeList
	}
	return nil
}

func (x *TechProfileInstance) GetDownstreamGemPortAttributeList() []*GemPortAttributes {
	if x != nil {
		return x.DownstreamGemPortAttributeList
	}
	return nil
}

// EPON TechProfile Instance definition.
type EponTechProfileInstance struct {
	state                        protoimpl.MessageState `protogen:"open.v1"`
	Name                         string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version                      uint32                 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	SubscriberIdentifier         string                 `protobuf:"bytes,3,opt,name=subscriber_identifier,json=subscriberIdentifier,proto3" json:"subscriber_identifier,omitempty"`
	ProfileType                  string                 `protobuf:"bytes,4,opt,name=profile_type,json=profileType,proto3" json:"profile_type,omitempty"`
	NumGemPorts                  uint32                 `protobuf:"varint,5,opt,name=num_gem_ports,json=numGemPorts,proto3" json:"num_gem_ports,omitempty"`
	AllocId                      uint32                 `protobuf:"varint,6,opt,name=alloc_id,json=allocId,proto3" json:"alloc_id,omitempty"`
	InstanceControl              *InstanceControl       `protobuf:"bytes,7,opt,name=instance_control,json=instanceControl,proto3" json:"instance_control,omitempty"`
	PackageType                  string                 `protobuf:"bytes,8,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	UpstreamQueueAttributeList   []*EPONQueueAttributes `protobuf:"bytes,9,rep,name=upstream_queue_attribute_list,json=upstreamQueueAttributeList,proto3" json:"upstream_queue_attribute_list,omitempty"`
	DownstreamQueueAttributeList []*EPONQueueAttributes `protobuf:"bytes,10,rep,name=downstream_queue_attribute_list,json=downstreamQueueAttributeList,proto3" json:"downstream_queue_attribute_list,omitempty"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *EponTechProfileInstance) Reset() {
	*x = EponTechProfileInstance{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EponTechProfileInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EponTechProfileInstance) ProtoMessage() {}

func (x *EponTechProfileInstance) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EponTechProfileInstance.ProtoReflect.Descriptor instead.
func (*EponTechProfileInstance) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{18}
}

func (x *EponTechProfileInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EponTechProfileInstance) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EponTechProfileInstance) GetSubscriberIdentifier() string {
	if x != nil {
		return x.SubscriberIdentifier
	}
	return ""
}

func (x *EponTechProfileInstance) GetProfileType() string {
	if x != nil {
		return x.ProfileType
	}
	return ""
}

func (x *EponTechProfileInstance) GetNumGemPorts() uint32 {
	if x != nil {
		return x.NumGemPorts
	}
	return 0
}

func (x *EponTechProfileInstance) GetAllocId() uint32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *EponTechProfileInstance) GetInstanceControl() *InstanceControl {
	if x != nil {
		return x.InstanceControl
	}
	return nil
}

func (x *EponTechProfileInstance) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

func (x *EponTechProfileInstance) GetUpstreamQueueAttributeList() []*EPONQueueAttributes {
	if x != nil {
		return x.UpstreamQueueAttributeList
	}
	return nil
}

func (x *EponTechProfileInstance) GetDownstreamQueueAttributeList() []*EPONQueueAttributes {
	if x != nil {
		return x.DownstreamQueueAttributeList
	}
	return nil
}

// Resource Instance definition
type ResourceInstance struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	TpId                 uint32                 `protobuf:"varint,1,opt,name=tp_id,json=tpId,proto3" json:"tp_id,omitempty"`
	ProfileType          string                 `protobuf:"bytes,2,opt,name=profile_type,json=profileType,proto3" json:"profile_type,omitempty"`
	SubscriberIdentifier string                 `protobuf:"bytes,3,opt,name=subscriber_identifier,json=subscriberIdentifier,proto3" json:"subscriber_identifier,omitempty"`
	AllocId              uint32                 `protobuf:"varint,4,opt,name=alloc_id,json=allocId,proto3" json:"alloc_id,omitempty"`
	GemportIds           []uint32               `protobuf:"varint,5,rep,packed,name=gemport_ids,json=gemportIds,proto3" json:"gemport_ids,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ResourceInstance) Reset() {
	*x = ResourceInstance{}
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceInstance) ProtoMessage() {}

func (x *ResourceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_tech_profile_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceInstance.ProtoReflect.Descriptor instead.
func (*ResourceInstance) Descriptor() ([]byte, []int) {
	return file_voltha_protos_tech_profile_proto_rawDescGZIP(), []int{19}
}

func (x *ResourceInstance) GetTpId() uint32 {
	if x != nil {
		return x.TpId
	}
	return 0
}

func (x *ResourceInstance) GetProfileType() string {
	if x != nil {
		return x.ProfileType
	}
	return ""
}

func (x *ResourceInstance) GetSubscriberIdentifier() string {
	if x != nil {
		return x.SubscriberIdentifier
	}
	return ""
}

func (x *ResourceInstance) GetAllocId() uint32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *ResourceInstance) GetGemportIds() []uint32 {
	if x != nil {
		return x.GemportIds
	}
	return nil
}

var File_voltha_protos_tech_profile_proto protoreflect.FileDescriptor

const file_voltha_protos_tech_profile_proto_rawDesc = "" +
	"\n" +
	" voltha_protos/tech_profile.proto\x12\ftech_profile\x1a\x1cgoogle/api/annotations.proto\"\x80\x02\n" +
	"\x0fSchedulerConfig\x125\n" +
	"\tdirection\x18\x01 \x01(\x0e2\x17.tech_profile.DirectionR\tdirection\x12?\n" +
	"\radditional_bw\x18\x02 \x01(\x0e2\x1a.tech_profile.AdditionalBWR\fadditionalBw\x12\x1a\n" +
	"\bpriority\x18\x03 \x01(\aR\bpriority\x12\x16\n" +
	"\x06weight\x18\x04 \x01(\aR\x06weight\x12A\n" +
	"\fsched_policy\x18\x05 \x01(\x0e2\x1e.tech_profile.SchedulingPolicyR\vschedPolicy\"\xb8\x01\n" +
	"\x12TrafficShapingInfo\x12\x10\n" +
	"\x03cir\x18\x01 \x01(\aR\x03cir\x12\x10\n" +
	"\x03cbs\x18\x02 \x01(\aR\x03cbs\x12\x10\n" +
	"\x03pir\x18\x03 \x01(\aR\x03pir\x12\x10\n" +
	"\x03pbs\x18\x04 \x01(\aR\x03pbs\x12\x10\n" +
	"\x03gir\x18\x05 \x01(\aR\x03gir\x12H\n" +
	"\n" +
	"add_bw_ind\x18\x06 \x01(\x0e2*.tech_profile.InferredAdditionBWIndicationR\baddBwInd\"\x9d\x02\n" +
	"\x10TrafficScheduler\x125\n" +
	"\tdirection\x18\x01 \x01(\x0e2\x17.tech_profile.DirectionR\tdirection\x12\x19\n" +
	"\balloc_id\x18\x02 \x01(\aR\aallocId\x12;\n" +
	"\tscheduler\x18\x03 \x01(\v2\x1d.tech_profile.SchedulerConfigR\tscheduler\x12R\n" +
	"\x14traffic_shaping_info\x18\x04 \x01(\v2 .tech_profile.TrafficShapingInfoR\x12trafficShapingInfo\x12&\n" +
	"\x0ftech_profile_id\x18\x05 \x01(\aR\rtechProfileId\"\xba\x01\n" +
	"\x11TrafficSchedulers\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x15\n" +
	"\x06uni_id\x18\x04 \x01(\aR\x05uniId\x12\x17\n" +
	"\aport_no\x18\x05 \x01(\aR\x06portNo\x12E\n" +
	"\x0etraffic_scheds\x18\x03 \x03(\v2\x1e.tech_profile.TrafficSchedulerR\rtrafficScheds\"6\n" +
	"\x15TailDropDiscardConfig\x12\x1d\n" +
	"\n" +
	"queue_size\x18\x01 \x01(\aR\tqueueSize\"\x85\x01\n" +
	"\x10RedDiscardConfig\x12#\n" +
	"\rmin_threshold\x18\x01 \x01(\aR\fminThreshold\x12#\n" +
	"\rmax_threshold\x18\x02 \x01(\aR\fmaxThreshold\x12'\n" +
	"\x0fmax_probability\x18\x03 \x01(\aR\x0emaxProbability\"\xb3\x01\n" +
	"\x11WRedDiscardConfig\x124\n" +
	"\x05green\x18\x01 \x01(\v2\x1e.tech_profile.RedDiscardConfigR\x05green\x126\n" +
	"\x06yellow\x18\x02 \x01(\v2\x1e.tech_profile.RedDiscardConfigR\x06yellow\x120\n" +
	"\x03red\x18\x03 \x01(\v2\x1e.tech_profile.RedDiscardConfigR\x03red\"\xe8\x02\n" +
	"\rDiscardConfig\x12B\n" +
	"\x0ediscard_policy\x18\x01 \x01(\x0e2\x1b.tech_profile.DiscardPolicyR\rdiscardPolicy\x12^\n" +
	"\x18tail_drop_discard_config\x18\x02 \x01(\v2#.tech_profile.TailDropDiscardConfigH\x00R\x15tailDropDiscardConfig\x12N\n" +
	"\x12red_discard_config\x18\x03 \x01(\v2\x1e.tech_profile.RedDiscardConfigH\x00R\x10redDiscardConfig\x12Q\n" +
	"\x13wred_discard_config\x18\x04 \x01(\v2\x1f.tech_profile.WRedDiscardConfigH\x00R\x11wredDiscardConfigB\x10\n" +
	"\x0ediscard_config\"\xa5\x03\n" +
	"\fTrafficQueue\x125\n" +
	"\tdirection\x18\x01 \x01(\x0e2\x17.tech_profile.DirectionR\tdirection\x12\x1d\n" +
	"\n" +
	"gemport_id\x18\x02 \x01(\aR\tgemportId\x12\x19\n" +
	"\bpbit_map\x18\x03 \x01(\tR\apbitMap\x12%\n" +
	"\x0eaes_encryption\x18\x04 \x01(\bR\raesEncryption\x12A\n" +
	"\fsched_policy\x18\x05 \x01(\x0e2\x1e.tech_profile.SchedulingPolicyR\vschedPolicy\x12\x1a\n" +
	"\bpriority\x18\x06 \x01(\aR\bpriority\x12\x16\n" +
	"\x06weight\x18\a \x01(\aR\x06weight\x12B\n" +
	"\x0ediscard_policy\x18\b \x01(\x0e2\x1b.tech_profile.DiscardPolicyR\rdiscardPolicy\x12B\n" +
	"\x0ediscard_config\x18\t \x01(\v2\x1b.tech_profile.DiscardConfigR\rdiscardConfig\"\x82\x02\n" +
	"\rTrafficQueues\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x15\n" +
	"\x06uni_id\x18\x04 \x01(\aR\x05uniId\x12\x17\n" +
	"\aport_no\x18\x05 \x01(\aR\x06portNo\x12A\n" +
	"\x0etraffic_queues\x18\x06 \x03(\v2\x1a.tech_profile.TrafficQueueR\rtrafficQueues\x12&\n" +
	"\x0ftech_profile_id\x18\a \x01(\aR\rtechProfileId\x12&\n" +
	"\x0fnetwork_intf_id\x18\b \x01(\aR\rnetworkIntfId\"f\n" +
	"\x0fInstanceControl\x12\x10\n" +
	"\x03onu\x18\x01 \x01(\tR\x03onu\x12\x10\n" +
	"\x03uni\x18\x02 \x01(\tR\x03uni\x12/\n" +
	"\x14max_gem_payload_size\x18\x03 \x01(\tR\x11maxGemPayloadSize\"\x82\x02\n" +
	"\vQThresholds\x12!\n" +
	"\fq_threshold1\x18\x01 \x01(\rR\vqThreshold1\x12!\n" +
	"\fq_threshold2\x18\x02 \x01(\rR\vqThreshold2\x12!\n" +
	"\fq_threshold3\x18\x03 \x01(\rR\vqThreshold3\x12!\n" +
	"\fq_threshold4\x18\x04 \x01(\rR\vqThreshold4\x12!\n" +
	"\fq_threshold5\x18\x05 \x01(\rR\vqThreshold5\x12!\n" +
	"\fq_threshold6\x18\x06 \x01(\rR\vqThreshold6\x12!\n" +
	"\fq_threshold7\x18\a \x01(\rR\vqThreshold7\"\xb3\x05\n" +
	"\x11GemPortAttributes\x12\x1d\n" +
	"\n" +
	"gemport_id\x18\x01 \x01(\aR\tgemportId\x12\x1c\n" +
	"\n" +
	"max_q_size\x18\x02 \x01(\tR\bmaxQSize\x12\x19\n" +
	"\bpbit_map\x18\x03 \x01(\tR\apbitMap\x12%\n" +
	"\x0eaes_encryption\x18\x04 \x01(\tR\raesEncryption\x12K\n" +
	"\x11scheduling_policy\x18\x05 \x01(\x0e2\x1e.tech_profile.SchedulingPolicyR\x10schedulingPolicy\x12\x1d\n" +
	"\n" +
	"priority_q\x18\x06 \x01(\aR\tpriorityQ\x12\x16\n" +
	"\x06weight\x18\a \x01(\aR\x06weight\x12B\n" +
	"\x0ediscard_policy\x18\b \x01(\x0e2\x1b.tech_profile.DiscardPolicyR\rdiscardPolicy\x12E\n" +
	"\x0ediscard_config\x18\t \x01(\v2\x1e.tech_profile.RedDiscardConfigR\rdiscardConfig\x12G\n" +
	"\x11discard_config_v2\x18\x0e \x01(\v2\x1b.tech_profile.DiscardConfigR\x0fdiscardConfigV2\x12!\n" +
	"\fis_multicast\x18\n" +
	" \x01(\tR\visMulticast\x12(\n" +
	"\x10multicast_gem_id\x18\v \x01(\aR\x0emulticastGemId\x12=\n" +
	"\x1bdynamic_access_control_list\x18\f \x01(\tR\x18dynamicAccessControlList\x12;\n" +
	"\x1astatic_access_control_list\x18\r \x01(\tR\x17staticAccessControlList\"\xa2\x02\n" +
	"\x13SchedulerAttributes\x125\n" +
	"\tdirection\x18\x01 \x01(\x0e2\x17.tech_profile.DirectionR\tdirection\x12\x19\n" +
	"\balloc_id\x18\x02 \x01(\rR\aallocId\x12?\n" +
	"\radditional_bw\x18\x03 \x01(\x0e2\x1a.tech_profile.AdditionalBWR\fadditionalBw\x12\x1a\n" +
	"\bpriority\x18\x04 \x01(\aR\bpriority\x12\x16\n" +
	"\x06weight\x18\x05 \x01(\aR\x06weight\x12D\n" +
	"\x0eq_sched_policy\x18\x06 \x01(\x0e2\x1e.tech_profile.SchedulingPolicyR\fqSchedPolicy\"\xc0\x06\n" +
	"\x13EPONQueueAttributes\x12\x1c\n" +
	"\n" +
	"max_q_size\x18\x01 \x01(\tR\bmaxQSize\x12\x19\n" +
	"\bpbit_map\x18\x02 \x01(\tR\apbitMap\x12\x1d\n" +
	"\n" +
	"gemport_id\x18\x03 \x01(\rR\tgemportId\x12%\n" +
	"\x0eaes_encryption\x18\x04 \x01(\tR\raesEncryption\x12!\n" +
	"\ftraffic_type\x18\x05 \x01(\tR\vtrafficType\x124\n" +
	"\x16unsolicited_grant_size\x18\x06 \x01(\rR\x14unsolicitedGrantSize\x12)\n" +
	"\x10nominal_interval\x18\a \x01(\rR\x0fnominalInterval\x122\n" +
	"\x15tolerated_poll_jitter\x18\b \x01(\rR\x13toleratedPollJitter\x12>\n" +
	"\x1brequest_transmission_policy\x18\t \x01(\rR\x19requestTransmissionPolicy\x12\x1c\n" +
	"\n" +
	"num_q_sets\x18\n" +
	" \x01(\rR\bnumQSets\x12<\n" +
	"\fq_thresholds\x18\v \x01(\v2\x19.tech_profile.QThresholdsR\vqThresholds\x12K\n" +
	"\x11scheduling_policy\x18\f \x01(\x0e2\x1e.tech_profile.SchedulingPolicyR\x10schedulingPolicy\x12\x1d\n" +
	"\n" +
	"priority_q\x18\r \x01(\rR\tpriorityQ\x12\x16\n" +
	"\x06weight\x18\x0e \x01(\rR\x06weight\x12B\n" +
	"\x0ediscard_policy\x18\x0f \x01(\x0e2\x1b.tech_profile.DiscardPolicyR\rdiscardPolicy\x12E\n" +
	"\x0ediscard_config\x18\x10 \x01(\v2\x1e.tech_profile.RedDiscardConfigR\rdiscardConfig\x12G\n" +
	"\x11discard_config_v2\x18\x11 \x01(\v2\x1b.tech_profile.DiscardConfigR\x0fdiscardConfigV2\"\xae\x04\n" +
	"\vTechProfile\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\rR\aversion\x12!\n" +
	"\fprofile_type\x18\x03 \x01(\tR\vprofileType\x12\"\n" +
	"\rnum_gem_ports\x18\x04 \x01(\rR\vnumGemPorts\x12H\n" +
	"\x10instance_control\x18\x05 \x01(\v2\x1d.tech_profile.InstanceControlR\x0finstanceControl\x12D\n" +
	"\fus_scheduler\x18\x06 \x01(\v2!.tech_profile.SchedulerAttributesR\vusScheduler\x12D\n" +
	"\fds_scheduler\x18\a \x01(\v2!.tech_profile.SchedulerAttributesR\vdsScheduler\x12g\n" +
	" upstream_gem_port_attribute_list\x18\b \x03(\v2\x1f.tech_profile.GemPortAttributesR\x1cupstreamGemPortAttributeList\x12k\n" +
	"\"downstream_gem_port_attribute_list\x18\t \x03(\v2\x1f.tech_profile.GemPortAttributesR\x1edownstreamGemPortAttributeList\"\xc3\x03\n" +
	"\x0fEponTechProfile\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\rR\aversion\x12!\n" +
	"\fprofile_type\x18\x03 \x01(\tR\vprofileType\x12\"\n" +
	"\rnum_gem_ports\x18\x04 \x01(\rR\vnumGemPorts\x12H\n" +
	"\x10instance_control\x18\x05 \x01(\v2\x1d.tech_profile.InstanceControlR\x0finstanceControl\x12!\n" +
	"\fpackage_type\x18\x06 \x01(\tR\vpackageType\x12d\n" +
	"\x1dupstream_queue_attribute_list\x18\a \x03(\v2!.tech_profile.EPONQueueAttributesR\x1aupstreamQueueAttributeList\x12h\n" +
	"\x1fdownstream_queue_attribute_list\x18\b \x03(\v2!.tech_profile.EPONQueueAttributesR\x1cdownstreamQueueAttributeList\"\xeb\x04\n" +
	"\x13TechProfileInstance\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\rR\aversion\x123\n" +
	"\x15subscriber_identifier\x18\x03 \x01(\tR\x14subscriberIdentifier\x12!\n" +
	"\fprofile_type\x18\x04 \x01(\tR\vprofileType\x12\"\n" +
	"\rnum_gem_ports\x18\x05 \x01(\rR\vnumGemPorts\x12H\n" +
	"\x10instance_control\x18\x06 \x01(\v2\x1d.tech_profile.InstanceControlR\x0finstanceControl\x12D\n" +
	"\fus_scheduler\x18\a \x01(\v2!.tech_profile.SchedulerAttributesR\vusScheduler\x12D\n" +
	"\fds_scheduler\x18\b \x01(\v2!.tech_profile.SchedulerAttributesR\vdsScheduler\x12g\n" +
	" upstream_gem_port_attribute_list\x18\t \x03(\v2\x1f.tech_profile.GemPortAttributesR\x1cupstreamGemPortAttributeList\x12k\n" +
	"\"downstream_gem_port_attribute_list\x18\n" +
	" \x03(\v2\x1f.tech_profile.GemPortAttributesR\x1edownstreamGemPortAttributeList\"\x9b\x04\n" +
	"\x17EponTechProfileInstance\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aversion\x18\x02 \x01(\rR\aversion\x123\n" +
	"\x15subscriber_identifier\x18\x03 \x01(\tR\x14subscriberIdentifier\x12!\n" +
	"\fprofile_type\x18\x04 \x01(\tR\vprofileType\x12\"\n" +
	"\rnum_gem_ports\x18\x05 \x01(\rR\vnumGemPorts\x12\x19\n" +
	"\balloc_id\x18\x06 \x01(\rR\aallocId\x12H\n" +
	"\x10instance_control\x18\a \x01(\v2\x1d.tech_profile.InstanceControlR\x0finstanceControl\x12!\n" +
	"\fpackage_type\x18\b \x01(\tR\vpackageType\x12d\n" +
	"\x1dupstream_queue_attribute_list\x18\t \x03(\v2!.tech_profile.EPONQueueAttributesR\x1aupstreamQueueAttributeList\x12h\n" +
	"\x1fdownstream_queue_attribute_list\x18\n" +
	" \x03(\v2!.tech_profile.EPONQueueAttributesR\x1cdownstreamQueueAttributeList\"\xbb\x01\n" +
	"\x10ResourceInstance\x12\x13\n" +
	"\x05tp_id\x18\x01 \x01(\rR\x04tpId\x12!\n" +
	"\fprofile_type\x18\x02 \x01(\tR\vprofileType\x123\n" +
	"\x15subscriber_identifier\x18\x03 \x01(\tR\x14subscriberIdentifier\x12\x19\n" +
	"\balloc_id\x18\x04 \x01(\rR\aallocId\x12\x1f\n" +
	"\vgemport_ids\x18\x05 \x03(\rR\n" +
	"gemportIds*<\n" +
	"\tDirection\x12\f\n" +
	"\bUPSTREAM\x10\x00\x12\x0e\n" +
	"\n" +
	"DOWNSTREAM\x10\x01\x12\x11\n" +
	"\rBIDIRECTIONAL\x10\x02*;\n" +
	"\x10SchedulingPolicy\x12\a\n" +
	"\x03WRR\x10\x00\x12\x12\n" +
	"\x0eStrictPriority\x10\x01\x12\n" +
	"\n" +
	"\x06Hybrid\x10\x02*n\n" +
	"\fAdditionalBW\x12\x15\n" +
	"\x11AdditionalBW_None\x10\x00\x12\x13\n" +
	"\x0fAdditionalBW_NA\x10\x01\x12\x1b\n" +
	"\x17AdditionalBW_BestEffort\x10\x02\x12\x15\n" +
	"\x11AdditionalBW_Auto\x10\x03*?\n" +
	"\rDiscardPolicy\x12\f\n" +
	"\bTailDrop\x10\x00\x12\r\n" +
	"\tWTailDrop\x10\x01\x12\a\n" +
	"\x03Red\x10\x02\x12\b\n" +
	"\x04WRed\x10\x03*\x9c\x01\n" +
	"\x1cInferredAdditionBWIndication\x12%\n" +
	"!InferredAdditionBWIndication_None\x10\x00\x12(\n" +
	"$InferredAdditionBWIndication_Assured\x10\x01\x12+\n" +
	"'InferredAdditionBWIndication_BestEffort\x10\x02BX\n" +
	" org.opencord.voltha.tech_profileZ4github.com/opencord/voltha-protos/v5/go/tech_profileb\x06proto3"

var (
	file_voltha_protos_tech_profile_proto_rawDescOnce sync.Once
	file_voltha_protos_tech_profile_proto_rawDescData []byte
)

func file_voltha_protos_tech_profile_proto_rawDescGZIP() []byte {
	file_voltha_protos_tech_profile_proto_rawDescOnce.Do(func() {
		file_voltha_protos_tech_profile_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_voltha_protos_tech_profile_proto_rawDesc), len(file_voltha_protos_tech_profile_proto_rawDesc)))
	})
	return file_voltha_protos_tech_profile_proto_rawDescData
}

var file_voltha_protos_tech_profile_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_voltha_protos_tech_profile_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_voltha_protos_tech_profile_proto_goTypes = []any{
	(Direction)(0),                    // 0: tech_profile.Direction
	(SchedulingPolicy)(0),             // 1: tech_profile.SchedulingPolicy
	(AdditionalBW)(0),                 // 2: tech_profile.AdditionalBW
	(DiscardPolicy)(0),                // 3: tech_profile.DiscardPolicy
	(InferredAdditionBWIndication)(0), // 4: tech_profile.InferredAdditionBWIndication
	(*SchedulerConfig)(nil),           // 5: tech_profile.SchedulerConfig
	(*TrafficShapingInfo)(nil),        // 6: tech_profile.TrafficShapingInfo
	(*TrafficScheduler)(nil),          // 7: tech_profile.TrafficScheduler
	(*TrafficSchedulers)(nil),         // 8: tech_profile.TrafficSchedulers
	(*TailDropDiscardConfig)(nil),     // 9: tech_profile.TailDropDiscardConfig
	(*RedDiscardConfig)(nil),          // 10: tech_profile.RedDiscardConfig
	(*WRedDiscardConfig)(nil),         // 11: tech_profile.WRedDiscardConfig
	(*DiscardConfig)(nil),             // 12: tech_profile.DiscardConfig
	(*TrafficQueue)(nil),              // 13: tech_profile.TrafficQueue
	(*TrafficQueues)(nil),             // 14: tech_profile.TrafficQueues
	(*InstanceControl)(nil),           // 15: tech_profile.InstanceControl
	(*QThresholds)(nil),               // 16: tech_profile.QThresholds
	(*GemPortAttributes)(nil),         // 17: tech_profile.GemPortAttributes
	(*SchedulerAttributes)(nil),       // 18: tech_profile.SchedulerAttributes
	(*EPONQueueAttributes)(nil),       // 19: tech_profile.EPONQueueAttributes
	(*TechProfile)(nil),               // 20: tech_profile.TechProfile
	(*EponTechProfile)(nil),           // 21: tech_profile.EponTechProfile
	(*TechProfileInstance)(nil),       // 22: tech_profile.TechProfileInstance
	(*EponTechProfileInstance)(nil),   // 23: tech_profile.EponTechProfileInstance
	(*ResourceInstance)(nil),          // 24: tech_profile.ResourceInstance
}
var file_voltha_protos_tech_profile_proto_depIdxs = []int32{
	0,  // 0: tech_profile.SchedulerConfig.direction:type_name -> tech_profile.Direction
	2,  // 1: tech_profile.SchedulerConfig.additional_bw:type_name -> tech_profile.AdditionalBW
	1,  // 2: tech_profile.SchedulerConfig.sched_policy:type_name -> tech_profile.SchedulingPolicy
	4,  // 3: tech_profile.TrafficShapingInfo.add_bw_ind:type_name -> tech_profile.InferredAdditionBWIndication
	0,  // 4: tech_profile.TrafficScheduler.direction:type_name -> tech_profile.Direction
	5,  // 5: tech_profile.TrafficScheduler.scheduler:type_name -> tech_profile.SchedulerConfig
	6,  // 6: tech_profile.TrafficScheduler.traffic_shaping_info:type_name -> tech_profile.TrafficShapingInfo
	7,  // 7: tech_profile.TrafficSchedulers.traffic_scheds:type_name -> tech_profile.TrafficScheduler
	10, // 8: tech_profile.WRedDiscardConfig.green:type_name -> tech_profile.RedDiscardConfig
	10, // 9: tech_profile.WRedDiscardConfig.yellow:type_name -> tech_profile.RedDiscardConfig
	10, // 10: tech_profile.WRedDiscardConfig.red:type_name -> tech_profile.RedDiscardConfig
	3,  // 11: tech_profile.DiscardConfig.discard_policy:type_name -> tech_profile.DiscardPolicy
	9,  // 12: tech_profile.DiscardConfig.tail_drop_discard_config:type_name -> tech_profile.TailDropDiscardConfig
	10, // 13: tech_profile.DiscardConfig.red_discard_config:type_name -> tech_profile.RedDiscardConfig
	11, // 14: tech_profile.DiscardConfig.wred_discard_config:type_name -> tech_profile.WRedDiscardConfig
	0,  // 15: tech_profile.TrafficQueue.direction:type_name -> tech_profile.Direction
	1,  // 16: tech_profile.TrafficQueue.sched_policy:type_name -> tech_profile.SchedulingPolicy
	3,  // 17: tech_profile.TrafficQueue.discard_policy:type_name -> tech_profile.DiscardPolicy
	12, // 18: tech_profile.TrafficQueue.discard_config:type_name -> tech_profile.DiscardConfig
	13, // 19: tech_profile.TrafficQueues.traffic_queues:type_name -> tech_profile.TrafficQueue
	1,  // 20: tech_profile.GemPortAttributes.scheduling_policy:type_name -> tech_profile.SchedulingPolicy
	3,  // 21: tech_profile.GemPortAttributes.discard_policy:type_name -> tech_profile.DiscardPolicy
	10, // 22: tech_profile.GemPortAttributes.discard_config:type_name -> tech_profile.RedDiscardConfig
	12, // 23: tech_profile.GemPortAttributes.discard_config_v2:type_name -> tech_profile.DiscardConfig
	0,  // 24: tech_profile.SchedulerAttributes.direction:type_name -> tech_profile.Direction
	2,  // 25: tech_profile.SchedulerAttributes.additional_bw:type_name -> tech_profile.AdditionalBW
	1,  // 26: tech_profile.SchedulerAttributes.q_sched_policy:type_name -> tech_profile.SchedulingPolicy
	16, // 27: tech_profile.EPONQueueAttributes.q_thresholds:type_name -> tech_profile.QThresholds
	1,  // 28: tech_profile.EPONQueueAttributes.scheduling_policy:type_name -> tech_profile.SchedulingPolicy
	3,  // 29: tech_profile.EPONQueueAttributes.discard_policy:type_name -> tech_profile.DiscardPolicy
	10, // 30: tech_profile.EPONQueueAttributes.discard_config:type_name -> tech_profile.RedDiscardConfig
	12, // 31: tech_profile.EPONQueueAttributes.discard_config_v2:type_name -> tech_profile.DiscardConfig
	15, // 32: tech_profile.TechProfile.instance_control:type_name -> tech_profile.InstanceControl
	18, // 33: tech_profile.TechProfile.us_scheduler:type_name -> tech_profile.SchedulerAttributes
	18, // 34: tech_profile.TechProfile.ds_scheduler:type_name -> tech_profile.SchedulerAttributes
	17, // 35: tech_profile.TechProfile.upstream_gem_port_attribute_list:type_name -> tech_profile.GemPortAttributes
	17, // 36: tech_profile.TechProfile.downstream_gem_port_attribute_list:type_name -> tech_profile.GemPortAttributes
	15, // 37: tech_profile.EponTechProfile.instance_control:type_name -> tech_profile.InstanceControl
	19, // 38: tech_profile.EponTechProfile.upstream_queue_attribute_list:type_name -> tech_profile.EPONQueueAttributes
	19, // 39: tech_profile.EponTechProfile.downstream_queue_attribute_list:type_name -> tech_profile.EPONQueueAttributes
	15, // 40: tech_profile.TechProfileInstance.instance_control:type_name -> tech_profile.InstanceControl
	18, // 41: tech_profile.TechProfileInstance.us_scheduler:type_name -> tech_profile.SchedulerAttributes
	18, // 42: tech_profile.TechProfileInstance.ds_scheduler:type_name -> tech_profile.SchedulerAttributes
	17, // 43: tech_profile.TechProfileInstance.upstream_gem_port_attribute_list:type_name -> tech_profile.GemPortAttributes
	17, // 44: tech_profile.TechProfileInstance.downstream_gem_port_attribute_list:type_name -> tech_profile.GemPortAttributes
	15, // 45: tech_profile.EponTechProfileInstance.instance_control:type_name -> tech_profile.InstanceControl
	19, // 46: tech_profile.EponTechProfileInstance.upstream_queue_attribute_list:type_name -> tech_profile.EPONQueueAttributes
	19, // 47: tech_profile.EponTechProfileInstance.downstream_queue_attribute_list:type_name -> tech_profile.EPONQueueAttributes
	48, // [48:48] is the sub-list for method output_type
	48, // [48:48] is the sub-list for method input_type
	48, // [48:48] is the sub-list for extension type_name
	48, // [48:48] is the sub-list for extension extendee
	0,  // [0:48] is the sub-list for field type_name
}

func init() { file_voltha_protos_tech_profile_proto_init() }
func file_voltha_protos_tech_profile_proto_init() {
	if File_voltha_protos_tech_profile_proto != nil {
		return
	}
	file_voltha_protos_tech_profile_proto_msgTypes[7].OneofWrappers = []any{
		(*DiscardConfig_TailDropDiscardConfig)(nil),
		(*DiscardConfig_RedDiscardConfig)(nil),
		(*DiscardConfig_WredDiscardConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_voltha_protos_tech_profile_proto_rawDesc), len(file_voltha_protos_tech_profile_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_voltha_protos_tech_profile_proto_goTypes,
		DependencyIndexes: file_voltha_protos_tech_profile_proto_depIdxs,
		EnumInfos:         file_voltha_protos_tech_profile_proto_enumTypes,
		MessageInfos:      file_voltha_protos_tech_profile_proto_msgTypes,
	}.Build()
	File_voltha_protos_tech_profile_proto = out.File
	file_voltha_protos_tech_profile_proto_goTypes = nil
	file_voltha_protos_tech_profile_proto_depIdxs = nil
}
