// Copyright 2018-2024 Open Networking Foundation (ONF) and the ONF Contributors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at:
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v4.25.8
// source: voltha_protos/openolt.proto

package openolt

import (
	common "github.com/opencord/voltha-protos/v5/go/common"
	config "github.com/opencord/voltha-protos/v5/go/ext/config"
	extension "github.com/opencord/voltha-protos/v5/go/extension"
	tech_profile "github.com/opencord/voltha-protos/v5/go/tech_profile"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AlarmState int32

const (
	AlarmState_OFF AlarmState = 0
	AlarmState_ON  AlarmState = 1
)

// Enum value maps for AlarmState.
var (
	AlarmState_name = map[int32]string{
		0: "OFF",
		1: "ON",
	}
	AlarmState_value = map[string]int32{
		"OFF": 0,
		"ON":  1,
	}
)

func (x AlarmState) Enum() *AlarmState {
	p := new(AlarmState)
	*p = x
	return p
}

func (x AlarmState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AlarmState) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[0].Descriptor()
}

func (AlarmState) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[0]
}

func (x AlarmState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AlarmState.Descriptor instead.
func (AlarmState) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{0}
}

// * activation fail reason.
type OnuIndication_ActivationFailReason int32

const (
	OnuIndication_ONU_ACTIVATION_FAIL_REASON_NONE                    OnuIndication_ActivationFailReason = 0
	OnuIndication_ONU_ACTIVATION_FAIL_REASON_RANGING                 OnuIndication_ActivationFailReason = 1 //Ranging Failure
	OnuIndication_ONU_ACTIVATION_FAIL_REASON_PASSWORD_AUTHENTICATION OnuIndication_ActivationFailReason = 2 //Password authentication
	OnuIndication_ONU_ACTIVATION_FAIL_REASON_LOS                     OnuIndication_ActivationFailReason = 3 //LOS
	OnuIndication_ONU_ACTIVATION_FAIL_ONU_ALARM                      OnuIndication_ActivationFailReason = 4 // ONU Alarm
	OnuIndication_ONU_ACTIVATION_FAIL_SWITCH_OVER                    OnuIndication_ActivationFailReason = 5 //protection switch over
)

// Enum value maps for OnuIndication_ActivationFailReason.
var (
	OnuIndication_ActivationFailReason_name = map[int32]string{
		0: "ONU_ACTIVATION_FAIL_REASON_NONE",
		1: "ONU_ACTIVATION_FAIL_REASON_RANGING",
		2: "ONU_ACTIVATION_FAIL_REASON_PASSWORD_AUTHENTICATION",
		3: "ONU_ACTIVATION_FAIL_REASON_LOS",
		4: "ONU_ACTIVATION_FAIL_ONU_ALARM",
		5: "ONU_ACTIVATION_FAIL_SWITCH_OVER",
	}
	OnuIndication_ActivationFailReason_value = map[string]int32{
		"ONU_ACTIVATION_FAIL_REASON_NONE":                    0,
		"ONU_ACTIVATION_FAIL_REASON_RANGING":                 1,
		"ONU_ACTIVATION_FAIL_REASON_PASSWORD_AUTHENTICATION": 2,
		"ONU_ACTIVATION_FAIL_REASON_LOS":                     3,
		"ONU_ACTIVATION_FAIL_ONU_ALARM":                      4,
		"ONU_ACTIVATION_FAIL_SWITCH_OVER":                    5,
	}
)

func (x OnuIndication_ActivationFailReason) Enum() *OnuIndication_ActivationFailReason {
	p := new(OnuIndication_ActivationFailReason)
	*p = x
	return p
}

func (x OnuIndication_ActivationFailReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OnuIndication_ActivationFailReason) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[1].Descriptor()
}

func (OnuIndication_ActivationFailReason) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[1]
}

func (x OnuIndication_ActivationFailReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OnuIndication_ActivationFailReason.Descriptor instead.
func (OnuIndication_ActivationFailReason) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{5, 0}
}

type IntfOperIndication_PONResourceRanges_Pool_PoolType int32

const (
	IntfOperIndication_PONResourceRanges_Pool_ONU_ID     IntfOperIndication_PONResourceRanges_Pool_PoolType = 0
	IntfOperIndication_PONResourceRanges_Pool_ALLOC_ID   IntfOperIndication_PONResourceRanges_Pool_PoolType = 1
	IntfOperIndication_PONResourceRanges_Pool_GEMPORT_ID IntfOperIndication_PONResourceRanges_Pool_PoolType = 2
	IntfOperIndication_PONResourceRanges_Pool_FLOW_ID    IntfOperIndication_PONResourceRanges_Pool_PoolType = 3
)

// Enum value maps for IntfOperIndication_PONResourceRanges_Pool_PoolType.
var (
	IntfOperIndication_PONResourceRanges_Pool_PoolType_name = map[int32]string{
		0: "ONU_ID",
		1: "ALLOC_ID",
		2: "GEMPORT_ID",
		3: "FLOW_ID",
	}
	IntfOperIndication_PONResourceRanges_Pool_PoolType_value = map[string]int32{
		"ONU_ID":     0,
		"ALLOC_ID":   1,
		"GEMPORT_ID": 2,
		"FLOW_ID":    3,
	}
)

func (x IntfOperIndication_PONResourceRanges_Pool_PoolType) Enum() *IntfOperIndication_PONResourceRanges_Pool_PoolType {
	p := new(IntfOperIndication_PONResourceRanges_Pool_PoolType)
	*p = x
	return p
}

func (x IntfOperIndication_PONResourceRanges_Pool_PoolType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IntfOperIndication_PONResourceRanges_Pool_PoolType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[2].Descriptor()
}

func (IntfOperIndication_PONResourceRanges_Pool_PoolType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[2]
}

func (x IntfOperIndication_PONResourceRanges_Pool_PoolType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IntfOperIndication_PONResourceRanges_Pool_PoolType.Descriptor instead.
func (IntfOperIndication_PONResourceRanges_Pool_PoolType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{8, 0, 0, 0}
}

type DeviceInfo_DeviceResourceRanges_Pool_PoolType int32

const (
	DeviceInfo_DeviceResourceRanges_Pool_ONU_ID     DeviceInfo_DeviceResourceRanges_Pool_PoolType = 0
	DeviceInfo_DeviceResourceRanges_Pool_ALLOC_ID   DeviceInfo_DeviceResourceRanges_Pool_PoolType = 1
	DeviceInfo_DeviceResourceRanges_Pool_GEMPORT_ID DeviceInfo_DeviceResourceRanges_Pool_PoolType = 2
	DeviceInfo_DeviceResourceRanges_Pool_FLOW_ID    DeviceInfo_DeviceResourceRanges_Pool_PoolType = 3
)

// Enum value maps for DeviceInfo_DeviceResourceRanges_Pool_PoolType.
var (
	DeviceInfo_DeviceResourceRanges_Pool_PoolType_name = map[int32]string{
		0: "ONU_ID",
		1: "ALLOC_ID",
		2: "GEMPORT_ID",
		3: "FLOW_ID",
	}
	DeviceInfo_DeviceResourceRanges_Pool_PoolType_value = map[string]int32{
		"ONU_ID":     0,
		"ALLOC_ID":   1,
		"GEMPORT_ID": 2,
		"FLOW_ID":    3,
	}
)

func (x DeviceInfo_DeviceResourceRanges_Pool_PoolType) Enum() *DeviceInfo_DeviceResourceRanges_Pool_PoolType {
	p := new(DeviceInfo_DeviceResourceRanges_Pool_PoolType)
	*p = x
	return p
}

func (x DeviceInfo_DeviceResourceRanges_Pool_PoolType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeviceInfo_DeviceResourceRanges_Pool_PoolType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[3].Descriptor()
}

func (DeviceInfo_DeviceResourceRanges_Pool_PoolType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[3]
}

func (x DeviceInfo_DeviceResourceRanges_Pool_PoolType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeviceInfo_DeviceResourceRanges_Pool_PoolType.Descriptor instead.
func (DeviceInfo_DeviceResourceRanges_Pool_PoolType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{18, 0, 0, 0}
}

type DeviceInfo_DeviceResourceRanges_Pool_SharingType int32

const (
	DeviceInfo_DeviceResourceRanges_Pool_DEDICATED_PER_INTF           DeviceInfo_DeviceResourceRanges_Pool_SharingType = 0
	DeviceInfo_DeviceResourceRanges_Pool_SHARED_BY_ALL_INTF_ALL_TECH  DeviceInfo_DeviceResourceRanges_Pool_SharingType = 1 // Shared across all interfaces in all technologies in all ranges
	DeviceInfo_DeviceResourceRanges_Pool_SHARED_BY_ALL_INTF_SAME_TECH DeviceInfo_DeviceResourceRanges_Pool_SharingType = 2 // Shared across all interfaces of the same technology used in this range
)

// Enum value maps for DeviceInfo_DeviceResourceRanges_Pool_SharingType.
var (
	DeviceInfo_DeviceResourceRanges_Pool_SharingType_name = map[int32]string{
		0: "DEDICATED_PER_INTF",
		1: "SHARED_BY_ALL_INTF_ALL_TECH",
		2: "SHARED_BY_ALL_INTF_SAME_TECH",
	}
	DeviceInfo_DeviceResourceRanges_Pool_SharingType_value = map[string]int32{
		"DEDICATED_PER_INTF":           0,
		"SHARED_BY_ALL_INTF_ALL_TECH":  1,
		"SHARED_BY_ALL_INTF_SAME_TECH": 2,
	}
)

func (x DeviceInfo_DeviceResourceRanges_Pool_SharingType) Enum() *DeviceInfo_DeviceResourceRanges_Pool_SharingType {
	p := new(DeviceInfo_DeviceResourceRanges_Pool_SharingType)
	*p = x
	return p
}

func (x DeviceInfo_DeviceResourceRanges_Pool_SharingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeviceInfo_DeviceResourceRanges_Pool_SharingType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[4].Descriptor()
}

func (DeviceInfo_DeviceResourceRanges_Pool_SharingType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[4]
}

func (x DeviceInfo_DeviceResourceRanges_Pool_SharingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeviceInfo_DeviceResourceRanges_Pool_SharingType.Descriptor instead.
func (DeviceInfo_DeviceResourceRanges_Pool_SharingType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{18, 0, 0, 1}
}

type GroupMember_InterfaceType int32

const (
	GroupMember_PON           GroupMember_InterfaceType = 0
	GroupMember_EPON_1G_PATH  GroupMember_InterfaceType = 1
	GroupMember_EPON_10G_PATH GroupMember_InterfaceType = 2
)

// Enum value maps for GroupMember_InterfaceType.
var (
	GroupMember_InterfaceType_name = map[int32]string{
		0: "PON",
		1: "EPON_1G_PATH",
		2: "EPON_10G_PATH",
	}
	GroupMember_InterfaceType_value = map[string]int32{
		"PON":           0,
		"EPON_1G_PATH":  1,
		"EPON_10G_PATH": 2,
	}
)

func (x GroupMember_InterfaceType) Enum() *GroupMember_InterfaceType {
	p := new(GroupMember_InterfaceType)
	*p = x
	return p
}

func (x GroupMember_InterfaceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GroupMember_InterfaceType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[5].Descriptor()
}

func (GroupMember_InterfaceType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[5]
}

func (x GroupMember_InterfaceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GroupMember_InterfaceType.Descriptor instead.
func (GroupMember_InterfaceType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{47, 0}
}

type Group_GroupMembersCommand int32

const (
	Group_ADD_MEMBERS    Group_GroupMembersCommand = 0
	Group_REMOVE_MEMBERS Group_GroupMembersCommand = 1
	Group_SET_MEMBERS    Group_GroupMembersCommand = 2
)

// Enum value maps for Group_GroupMembersCommand.
var (
	Group_GroupMembersCommand_name = map[int32]string{
		0: "ADD_MEMBERS",
		1: "REMOVE_MEMBERS",
		2: "SET_MEMBERS",
	}
	Group_GroupMembersCommand_value = map[string]int32{
		"ADD_MEMBERS":    0,
		"REMOVE_MEMBERS": 1,
		"SET_MEMBERS":    2,
	}
)

func (x Group_GroupMembersCommand) Enum() *Group_GroupMembersCommand {
	p := new(Group_GroupMembersCommand)
	*p = x
	return p
}

func (x Group_GroupMembersCommand) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Group_GroupMembersCommand) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[6].Descriptor()
}

func (Group_GroupMembersCommand) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[6]
}

func (x Group_GroupMembersCommand) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Group_GroupMembersCommand.Descriptor instead.
func (Group_GroupMembersCommand) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{48, 0}
}

type PonRxPowerData_RssiMeasurementFailReason int32

const (
	PonRxPowerData_FAIL_REASON_NONE         PonRxPowerData_RssiMeasurementFailReason = 0
	PonRxPowerData_FAIL_REASON_NO_DELIMITER PonRxPowerData_RssiMeasurementFailReason = 1
	PonRxPowerData_FAIL_REASON_NO_ACCESS    PonRxPowerData_RssiMeasurementFailReason = 2
)

// Enum value maps for PonRxPowerData_RssiMeasurementFailReason.
var (
	PonRxPowerData_RssiMeasurementFailReason_name = map[int32]string{
		0: "FAIL_REASON_NONE",
		1: "FAIL_REASON_NO_DELIMITER",
		2: "FAIL_REASON_NO_ACCESS",
	}
	PonRxPowerData_RssiMeasurementFailReason_value = map[string]int32{
		"FAIL_REASON_NONE":         0,
		"FAIL_REASON_NO_DELIMITER": 1,
		"FAIL_REASON_NO_ACCESS":    2,
	}
)

func (x PonRxPowerData_RssiMeasurementFailReason) Enum() *PonRxPowerData_RssiMeasurementFailReason {
	p := new(PonRxPowerData_RssiMeasurementFailReason)
	*p = x
	return p
}

func (x PonRxPowerData_RssiMeasurementFailReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PonRxPowerData_RssiMeasurementFailReason) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[7].Descriptor()
}

func (PonRxPowerData_RssiMeasurementFailReason) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[7]
}

func (x PonRxPowerData_RssiMeasurementFailReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PonRxPowerData_RssiMeasurementFailReason.Descriptor instead.
func (PonRxPowerData_RssiMeasurementFailReason) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{50, 0}
}

type OnuInfo_OnuState int32

const (
	// There are other states in BAL for ONU, which voltha is not interested as of now.
	// UNKNOWN is to be filled for the rest of the states other than NOT_CONFIGURED/ACTIVE/INACTIVE/DISABLED
	OnuInfo_UNKNOWN        OnuInfo_OnuState = 0
	OnuInfo_NOT_CONFIGURED OnuInfo_OnuState = 1
	OnuInfo_ACTIVE         OnuInfo_OnuState = 2
	OnuInfo_INACTIVE       OnuInfo_OnuState = 3
	OnuInfo_DISABLED       OnuInfo_OnuState = 4
)

// Enum value maps for OnuInfo_OnuState.
var (
	OnuInfo_OnuState_name = map[int32]string{
		0: "UNKNOWN",
		1: "NOT_CONFIGURED",
		2: "ACTIVE",
		3: "INACTIVE",
		4: "DISABLED",
	}
	OnuInfo_OnuState_value = map[string]int32{
		"UNKNOWN":        0,
		"NOT_CONFIGURED": 1,
		"ACTIVE":         2,
		"INACTIVE":       3,
		"DISABLED":       4,
	}
)

func (x OnuInfo_OnuState) Enum() *OnuInfo_OnuState {
	p := new(OnuInfo_OnuState)
	*p = x
	return p
}

func (x OnuInfo_OnuState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OnuInfo_OnuState) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[8].Descriptor()
}

func (OnuInfo_OnuState) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[8]
}

func (x OnuInfo_OnuState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OnuInfo_OnuState.Descriptor instead.
func (OnuInfo_OnuState) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{52, 0}
}

type PonIntfInfo_PonIntfState int32

const (
	PonIntfInfo_UNKNOWN        PonIntfInfo_PonIntfState = 0
	PonIntfInfo_ACTIVE_WORKING PonIntfInfo_PonIntfState = 1
	PonIntfInfo_ACTIVE_STANDBY PonIntfInfo_PonIntfState = 2
	PonIntfInfo_INACTIVE       PonIntfInfo_PonIntfState = 3
	PonIntfInfo_DISABLED       PonIntfInfo_PonIntfState = 4
)

// Enum value maps for PonIntfInfo_PonIntfState.
var (
	PonIntfInfo_PonIntfState_name = map[int32]string{
		0: "UNKNOWN",
		1: "ACTIVE_WORKING",
		2: "ACTIVE_STANDBY",
		3: "INACTIVE",
		4: "DISABLED",
	}
	PonIntfInfo_PonIntfState_value = map[string]int32{
		"UNKNOWN":        0,
		"ACTIVE_WORKING": 1,
		"ACTIVE_STANDBY": 2,
		"INACTIVE":       3,
		"DISABLED":       4,
	}
)

func (x PonIntfInfo_PonIntfState) Enum() *PonIntfInfo_PonIntfState {
	p := new(PonIntfInfo_PonIntfState)
	*p = x
	return p
}

func (x PonIntfInfo_PonIntfState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PonIntfInfo_PonIntfState) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openolt_proto_enumTypes[9].Descriptor()
}

func (PonIntfInfo_PonIntfState) Type() protoreflect.EnumType {
	return &file_voltha_protos_openolt_proto_enumTypes[9]
}

func (x PonIntfInfo_PonIntfState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PonIntfInfo_PonIntfState.Descriptor instead.
func (PonIntfInfo_PonIntfState) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{53, 0}
}

type Indication struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Data:
	//
	//	*Indication_OltInd
	//	*Indication_IntfInd
	//	*Indication_IntfOperInd
	//	*Indication_OnuDiscInd
	//	*Indication_OnuInd
	//	*Indication_OmciInd
	//	*Indication_PktInd
	//	*Indication_PortStats
	//	*Indication_FlowStats
	//	*Indication_AlarmInd
	//	*Indication_OnuDisabledInd
	//	*Indication_OnuEnabledInd
	Data          isIndication_Data `protobuf_oneof:"data"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Indication) Reset() {
	*x = Indication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Indication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Indication) ProtoMessage() {}

func (x *Indication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Indication.ProtoReflect.Descriptor instead.
func (*Indication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{0}
}

func (x *Indication) GetData() isIndication_Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Indication) GetOltInd() *OltIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_OltInd); ok {
			return x.OltInd
		}
	}
	return nil
}

func (x *Indication) GetIntfInd() *IntfIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_IntfInd); ok {
			return x.IntfInd
		}
	}
	return nil
}

func (x *Indication) GetIntfOperInd() *IntfOperIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_IntfOperInd); ok {
			return x.IntfOperInd
		}
	}
	return nil
}

func (x *Indication) GetOnuDiscInd() *OnuDiscIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_OnuDiscInd); ok {
			return x.OnuDiscInd
		}
	}
	return nil
}

func (x *Indication) GetOnuInd() *OnuIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_OnuInd); ok {
			return x.OnuInd
		}
	}
	return nil
}

func (x *Indication) GetOmciInd() *OmciIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_OmciInd); ok {
			return x.OmciInd
		}
	}
	return nil
}

func (x *Indication) GetPktInd() *PacketIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_PktInd); ok {
			return x.PktInd
		}
	}
	return nil
}

func (x *Indication) GetPortStats() *common.PortStatistics {
	if x != nil {
		if x, ok := x.Data.(*Indication_PortStats); ok {
			return x.PortStats
		}
	}
	return nil
}

func (x *Indication) GetFlowStats() *FlowStatistics {
	if x != nil {
		if x, ok := x.Data.(*Indication_FlowStats); ok {
			return x.FlowStats
		}
	}
	return nil
}

func (x *Indication) GetAlarmInd() *AlarmIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_AlarmInd); ok {
			return x.AlarmInd
		}
	}
	return nil
}

func (x *Indication) GetOnuDisabledInd() *OnuDisabledIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_OnuDisabledInd); ok {
			return x.OnuDisabledInd
		}
	}
	return nil
}

func (x *Indication) GetOnuEnabledInd() *OnuEnabledIndication {
	if x != nil {
		if x, ok := x.Data.(*Indication_OnuEnabledInd); ok {
			return x.OnuEnabledInd
		}
	}
	return nil
}

type isIndication_Data interface {
	isIndication_Data()
}

type Indication_OltInd struct {
	OltInd *OltIndication `protobuf:"bytes,1,opt,name=olt_ind,json=oltInd,proto3,oneof"`
}

type Indication_IntfInd struct {
	IntfInd *IntfIndication `protobuf:"bytes,2,opt,name=intf_ind,json=intfInd,proto3,oneof"`
}

type Indication_IntfOperInd struct {
	IntfOperInd *IntfOperIndication `protobuf:"bytes,3,opt,name=intf_oper_ind,json=intfOperInd,proto3,oneof"`
}

type Indication_OnuDiscInd struct {
	OnuDiscInd *OnuDiscIndication `protobuf:"bytes,4,opt,name=onu_disc_ind,json=onuDiscInd,proto3,oneof"`
}

type Indication_OnuInd struct {
	OnuInd *OnuIndication `protobuf:"bytes,5,opt,name=onu_ind,json=onuInd,proto3,oneof"`
}

type Indication_OmciInd struct {
	OmciInd *OmciIndication `protobuf:"bytes,6,opt,name=omci_ind,json=omciInd,proto3,oneof"`
}

type Indication_PktInd struct {
	PktInd *PacketIndication `protobuf:"bytes,7,opt,name=pkt_ind,json=pktInd,proto3,oneof"`
}

type Indication_PortStats struct {
	PortStats *common.PortStatistics `protobuf:"bytes,8,opt,name=port_stats,json=portStats,proto3,oneof"`
}

type Indication_FlowStats struct {
	FlowStats *FlowStatistics `protobuf:"bytes,9,opt,name=flow_stats,json=flowStats,proto3,oneof"`
}

type Indication_AlarmInd struct {
	AlarmInd *AlarmIndication `protobuf:"bytes,10,opt,name=alarm_ind,json=alarmInd,proto3,oneof"`
}

type Indication_OnuDisabledInd struct {
	OnuDisabledInd *OnuDisabledIndication `protobuf:"bytes,11,opt,name=onu_disabled_ind,json=onuDisabledInd,proto3,oneof"`
}

type Indication_OnuEnabledInd struct {
	OnuEnabledInd *OnuEnabledIndication `protobuf:"bytes,12,opt,name=onu_enabled_ind,json=onuEnabledInd,proto3,oneof"`
}

func (*Indication_OltInd) isIndication_Data() {}

func (*Indication_IntfInd) isIndication_Data() {}

func (*Indication_IntfOperInd) isIndication_Data() {}

func (*Indication_OnuDiscInd) isIndication_Data() {}

func (*Indication_OnuInd) isIndication_Data() {}

func (*Indication_OmciInd) isIndication_Data() {}

func (*Indication_PktInd) isIndication_Data() {}

func (*Indication_PortStats) isIndication_Data() {}

func (*Indication_FlowStats) isIndication_Data() {}

func (*Indication_AlarmInd) isIndication_Data() {}

func (*Indication_OnuDisabledInd) isIndication_Data() {}

func (*Indication_OnuEnabledInd) isIndication_Data() {}

type AlarmIndication struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Data:
	//
	//	*AlarmIndication_LosInd
	//	*AlarmIndication_DyingGaspInd
	//	*AlarmIndication_OnuAlarmInd
	//	*AlarmIndication_OnuStartupFailInd
	//	*AlarmIndication_OnuSignalDegradeInd
	//	*AlarmIndication_OnuDriftOfWindowInd
	//	*AlarmIndication_OnuLossOmciInd
	//	*AlarmIndication_OnuSignalsFailInd
	//	*AlarmIndication_OnuTiwiInd
	//	*AlarmIndication_OnuActivationFailInd
	//	*AlarmIndication_OnuProcessingErrorInd
	//	*AlarmIndication_OnuLossOfSyncFailInd
	//	*AlarmIndication_OnuItuPonStatsInd
	//	*AlarmIndication_OnuDeactivationFailureInd
	//	*AlarmIndication_OnuRemoteDefectInd
	//	*AlarmIndication_OnuLossGemDelineationInd
	//	*AlarmIndication_OnuPhysicalEquipmentErrorInd
	//	*AlarmIndication_OnuLossOfAckInd
	//	*AlarmIndication_OnuDiffReachExceededInd
	Data          isAlarmIndication_Data `protobuf_oneof:"data"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AlarmIndication) Reset() {
	*x = AlarmIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AlarmIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlarmIndication) ProtoMessage() {}

func (x *AlarmIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlarmIndication.ProtoReflect.Descriptor instead.
func (*AlarmIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{1}
}

func (x *AlarmIndication) GetData() isAlarmIndication_Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *AlarmIndication) GetLosInd() *LosIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_LosInd); ok {
			return x.LosInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetDyingGaspInd() *DyingGaspIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_DyingGaspInd); ok {
			return x.DyingGaspInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuAlarmInd() *OnuAlarmIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuAlarmInd); ok {
			return x.OnuAlarmInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuStartupFailInd() *OnuStartupFailureIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuStartupFailInd); ok {
			return x.OnuStartupFailInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuSignalDegradeInd() *OnuSignalDegradeIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuSignalDegradeInd); ok {
			return x.OnuSignalDegradeInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuDriftOfWindowInd() *OnuDriftOfWindowIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuDriftOfWindowInd); ok {
			return x.OnuDriftOfWindowInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuLossOmciInd() *OnuLossOfOmciChannelIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuLossOmciInd); ok {
			return x.OnuLossOmciInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuSignalsFailInd() *OnuSignalsFailureIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuSignalsFailInd); ok {
			return x.OnuSignalsFailInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuTiwiInd() *OnuTransmissionInterferenceWarning {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuTiwiInd); ok {
			return x.OnuTiwiInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuActivationFailInd() *OnuActivationFailureIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuActivationFailInd); ok {
			return x.OnuActivationFailInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuProcessingErrorInd() *OnuProcessingErrorIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuProcessingErrorInd); ok {
			return x.OnuProcessingErrorInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuLossOfSyncFailInd() *OnuLossOfKeySyncFailureIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuLossOfSyncFailInd); ok {
			return x.OnuLossOfSyncFailInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuItuPonStatsInd() *OnuItuPonStatsIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuItuPonStatsInd); ok {
			return x.OnuItuPonStatsInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuDeactivationFailureInd() *OnuDeactivationFailureIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuDeactivationFailureInd); ok {
			return x.OnuDeactivationFailureInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuRemoteDefectInd() *OnuRemoteDefectIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuRemoteDefectInd); ok {
			return x.OnuRemoteDefectInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuLossGemDelineationInd() *OnuLossOfGEMChannelDelineationIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuLossGemDelineationInd); ok {
			return x.OnuLossGemDelineationInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuPhysicalEquipmentErrorInd() *OnuPhysicalEquipmentErrorIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuPhysicalEquipmentErrorInd); ok {
			return x.OnuPhysicalEquipmentErrorInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuLossOfAckInd() *OnuLossOfAcknowledgementIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuLossOfAckInd); ok {
			return x.OnuLossOfAckInd
		}
	}
	return nil
}

func (x *AlarmIndication) GetOnuDiffReachExceededInd() *OnuDifferentialReachExceededIndication {
	if x != nil {
		if x, ok := x.Data.(*AlarmIndication_OnuDiffReachExceededInd); ok {
			return x.OnuDiffReachExceededInd
		}
	}
	return nil
}

type isAlarmIndication_Data interface {
	isAlarmIndication_Data()
}

type AlarmIndication_LosInd struct {
	LosInd *LosIndication `protobuf:"bytes,1,opt,name=los_ind,json=losInd,proto3,oneof"`
}

type AlarmIndication_DyingGaspInd struct {
	DyingGaspInd *DyingGaspIndication `protobuf:"bytes,2,opt,name=dying_gasp_ind,json=dyingGaspInd,proto3,oneof"`
}

type AlarmIndication_OnuAlarmInd struct {
	OnuAlarmInd *OnuAlarmIndication `protobuf:"bytes,3,opt,name=onu_alarm_ind,json=onuAlarmInd,proto3,oneof"`
}

type AlarmIndication_OnuStartupFailInd struct {
	OnuStartupFailInd *OnuStartupFailureIndication `protobuf:"bytes,4,opt,name=onu_startup_fail_ind,json=onuStartupFailInd,proto3,oneof"`
}

type AlarmIndication_OnuSignalDegradeInd struct {
	OnuSignalDegradeInd *OnuSignalDegradeIndication `protobuf:"bytes,5,opt,name=onu_signal_degrade_ind,json=onuSignalDegradeInd,proto3,oneof"`
}

type AlarmIndication_OnuDriftOfWindowInd struct {
	OnuDriftOfWindowInd *OnuDriftOfWindowIndication `protobuf:"bytes,6,opt,name=onu_drift_of_window_ind,json=onuDriftOfWindowInd,proto3,oneof"`
}

type AlarmIndication_OnuLossOmciInd struct {
	OnuLossOmciInd *OnuLossOfOmciChannelIndication `protobuf:"bytes,7,opt,name=onu_loss_omci_ind,json=onuLossOmciInd,proto3,oneof"`
}

type AlarmIndication_OnuSignalsFailInd struct {
	OnuSignalsFailInd *OnuSignalsFailureIndication `protobuf:"bytes,8,opt,name=onu_signals_fail_ind,json=onuSignalsFailInd,proto3,oneof"`
}

type AlarmIndication_OnuTiwiInd struct {
	OnuTiwiInd *OnuTransmissionInterferenceWarning `protobuf:"bytes,9,opt,name=onu_tiwi_ind,json=onuTiwiInd,proto3,oneof"`
}

type AlarmIndication_OnuActivationFailInd struct {
	OnuActivationFailInd *OnuActivationFailureIndication `protobuf:"bytes,10,opt,name=onu_activation_fail_ind,json=onuActivationFailInd,proto3,oneof"`
}

type AlarmIndication_OnuProcessingErrorInd struct {
	OnuProcessingErrorInd *OnuProcessingErrorIndication `protobuf:"bytes,11,opt,name=onu_processing_error_ind,json=onuProcessingErrorInd,proto3,oneof"`
}

type AlarmIndication_OnuLossOfSyncFailInd struct {
	OnuLossOfSyncFailInd *OnuLossOfKeySyncFailureIndication `protobuf:"bytes,12,opt,name=onu_loss_of_sync_fail_ind,json=onuLossOfSyncFailInd,proto3,oneof"`
}

type AlarmIndication_OnuItuPonStatsInd struct {
	OnuItuPonStatsInd *OnuItuPonStatsIndication `protobuf:"bytes,13,opt,name=onu_itu_pon_stats_ind,json=onuItuPonStatsInd,proto3,oneof"`
}

type AlarmIndication_OnuDeactivationFailureInd struct {
	OnuDeactivationFailureInd *OnuDeactivationFailureIndication `protobuf:"bytes,14,opt,name=onu_deactivation_failure_ind,json=onuDeactivationFailureInd,proto3,oneof"`
}

type AlarmIndication_OnuRemoteDefectInd struct {
	OnuRemoteDefectInd *OnuRemoteDefectIndication `protobuf:"bytes,15,opt,name=onu_remote_defect_ind,json=onuRemoteDefectInd,proto3,oneof"`
}

type AlarmIndication_OnuLossGemDelineationInd struct {
	OnuLossGemDelineationInd *OnuLossOfGEMChannelDelineationIndication `protobuf:"bytes,16,opt,name=onu_loss_gem_delineation_ind,json=onuLossGemDelineationInd,proto3,oneof"`
}

type AlarmIndication_OnuPhysicalEquipmentErrorInd struct {
	OnuPhysicalEquipmentErrorInd *OnuPhysicalEquipmentErrorIndication `protobuf:"bytes,17,opt,name=onu_physical_equipment_error_ind,json=onuPhysicalEquipmentErrorInd,proto3,oneof"`
}

type AlarmIndication_OnuLossOfAckInd struct {
	OnuLossOfAckInd *OnuLossOfAcknowledgementIndication `protobuf:"bytes,18,opt,name=onu_loss_of_ack_ind,json=onuLossOfAckInd,proto3,oneof"`
}

type AlarmIndication_OnuDiffReachExceededInd struct {
	OnuDiffReachExceededInd *OnuDifferentialReachExceededIndication `protobuf:"bytes,19,opt,name=onu_diff_reach_exceeded_ind,json=onuDiffReachExceededInd,proto3,oneof"`
}

func (*AlarmIndication_LosInd) isAlarmIndication_Data() {}

func (*AlarmIndication_DyingGaspInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuAlarmInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuStartupFailInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuSignalDegradeInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuDriftOfWindowInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuLossOmciInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuSignalsFailInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuTiwiInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuActivationFailInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuProcessingErrorInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuLossOfSyncFailInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuItuPonStatsInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuDeactivationFailureInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuRemoteDefectInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuLossGemDelineationInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuPhysicalEquipmentErrorInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuLossOfAckInd) isAlarmIndication_Data() {}

func (*AlarmIndication_OnuDiffReachExceededInd) isAlarmIndication_Data() {}

type OltIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OperState     string                 `protobuf:"bytes,1,opt,name=oper_state,json=operState,proto3" json:"oper_state,omitempty"` // up, down
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OltIndication) Reset() {
	*x = OltIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OltIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OltIndication) ProtoMessage() {}

func (x *OltIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OltIndication.ProtoReflect.Descriptor instead.
func (*OltIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{2}
}

func (x *OltIndication) GetOperState() string {
	if x != nil {
		return x.OperState
	}
	return ""
}

type IntfIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OperState     string                 `protobuf:"bytes,2,opt,name=oper_state,json=operState,proto3" json:"oper_state,omitempty"` // up, down
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IntfIndication) Reset() {
	*x = IntfIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntfIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntfIndication) ProtoMessage() {}

func (x *IntfIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntfIndication.ProtoReflect.Descriptor instead.
func (*IntfIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{3}
}

func (x *IntfIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *IntfIndication) GetOperState() string {
	if x != nil {
		return x.OperState
	}
	return ""
}

type OnuDiscIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	SerialNumber  *SerialNumber          `protobuf:"bytes,2,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuDiscIndication) Reset() {
	*x = OnuDiscIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuDiscIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuDiscIndication) ProtoMessage() {}

func (x *OnuDiscIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuDiscIndication.ProtoReflect.Descriptor instead.
func (*OnuDiscIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{4}
}

func (x *OnuDiscIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuDiscIndication) GetSerialNumber() *SerialNumber {
	if x != nil {
		return x.SerialNumber
	}
	return nil
}

type OnuIndication struct {
	state         protoimpl.MessageState             `protogen:"open.v1"`
	IntfId        uint32                             `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                             `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	OperState     string                             `protobuf:"bytes,3,opt,name=oper_state,json=operState,proto3" json:"oper_state,omitempty"`    // up, down
	AdminState    string                             `protobuf:"bytes,5,opt,name=admin_state,json=adminState,proto3" json:"admin_state,omitempty"` // up, down
	SerialNumber  *SerialNumber                      `protobuf:"bytes,4,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	FailReason    OnuIndication_ActivationFailReason `protobuf:"varint,6,opt,name=fail_reason,json=failReason,proto3,enum=openolt.OnuIndication_ActivationFailReason" json:"fail_reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuIndication) Reset() {
	*x = OnuIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuIndication) ProtoMessage() {}

func (x *OnuIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuIndication.ProtoReflect.Descriptor instead.
func (*OnuIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{5}
}

func (x *OnuIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuIndication) GetOperState() string {
	if x != nil {
		return x.OperState
	}
	return ""
}

func (x *OnuIndication) GetAdminState() string {
	if x != nil {
		return x.AdminState
	}
	return ""
}

func (x *OnuIndication) GetSerialNumber() *SerialNumber {
	if x != nil {
		return x.SerialNumber
	}
	return nil
}

func (x *OnuIndication) GetFailReason() OnuIndication_ActivationFailReason {
	if x != nil {
		return x.FailReason
	}
	return OnuIndication_ONU_ACTIVATION_FAIL_REASON_NONE
}

type OnuDisabledIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	SerialNumber  *SerialNumber          `protobuf:"bytes,4,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuDisabledIndication) Reset() {
	*x = OnuDisabledIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuDisabledIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuDisabledIndication) ProtoMessage() {}

func (x *OnuDisabledIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuDisabledIndication.ProtoReflect.Descriptor instead.
func (*OnuDisabledIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{6}
}

func (x *OnuDisabledIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuDisabledIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuDisabledIndication) GetSerialNumber() *SerialNumber {
	if x != nil {
		return x.SerialNumber
	}
	return nil
}

type OnuEnabledIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	SerialNumber  *SerialNumber          `protobuf:"bytes,4,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuEnabledIndication) Reset() {
	*x = OnuEnabledIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuEnabledIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuEnabledIndication) ProtoMessage() {}

func (x *OnuEnabledIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuEnabledIndication.ProtoReflect.Descriptor instead.
func (*OnuEnabledIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{7}
}

func (x *OnuEnabledIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuEnabledIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuEnabledIndication) GetSerialNumber() *SerialNumber {
	if x != nil {
		return x.SerialNumber
	}
	return nil
}

type IntfOperIndication struct {
	state         protoimpl.MessageState                `protogen:"open.v1"`
	Type          string                                `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"` // nni, pon
	IntfId        uint32                                `protobuf:"fixed32,2,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OperState     string                                `protobuf:"bytes,3,opt,name=oper_state,json=operState,proto3" json:"oper_state,omitempty"` // up, down
	Speed         uint32                                `protobuf:"fixed32,4,opt,name=speed,proto3" json:"speed,omitempty"`                        // measured in Mbps
	Technology    string                                `protobuf:"bytes,5,opt,name=technology,proto3" json:"technology,omitempty"`
	Ranges        *IntfOperIndication_PONResourceRanges `protobuf:"bytes,6,opt,name=ranges,proto3" json:"ranges,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IntfOperIndication) Reset() {
	*x = IntfOperIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntfOperIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntfOperIndication) ProtoMessage() {}

func (x *IntfOperIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntfOperIndication.ProtoReflect.Descriptor instead.
func (*IntfOperIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{8}
}

func (x *IntfOperIndication) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *IntfOperIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *IntfOperIndication) GetOperState() string {
	if x != nil {
		return x.OperState
	}
	return ""
}

func (x *IntfOperIndication) GetSpeed() uint32 {
	if x != nil {
		return x.Speed
	}
	return 0
}

func (x *IntfOperIndication) GetTechnology() string {
	if x != nil {
		return x.Technology
	}
	return ""
}

func (x *IntfOperIndication) GetRanges() *IntfOperIndication_PONResourceRanges {
	if x != nil {
		return x.Ranges
	}
	return nil
}

type OmciIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Pkt           []byte                 `protobuf:"bytes,3,opt,name=pkt,proto3" json:"pkt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OmciIndication) Reset() {
	*x = OmciIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OmciIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OmciIndication) ProtoMessage() {}

func (x *OmciIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OmciIndication.ProtoReflect.Descriptor instead.
func (*OmciIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{9}
}

func (x *OmciIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OmciIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OmciIndication) GetPkt() []byte {
	if x != nil {
		return x.Pkt
	}
	return nil
}

type PacketIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfType      string                 `protobuf:"bytes,5,opt,name=intf_type,json=intfType,proto3" json:"intf_type,omitempty"` // nni, pon, unknown
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,8,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	UniId         uint32                 `protobuf:"fixed32,9,opt,name=uni_id,json=uniId,proto3" json:"uni_id,omitempty"`
	GemportId     uint32                 `protobuf:"fixed32,2,opt,name=gemport_id,json=gemportId,proto3" json:"gemport_id,omitempty"`
	FlowId        uint32                 `protobuf:"fixed32,3,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	PortNo        uint32                 `protobuf:"fixed32,6,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	Cookie        uint64                 `protobuf:"fixed64,7,opt,name=cookie,proto3" json:"cookie,omitempty"`
	Pkt           []byte                 `protobuf:"bytes,4,opt,name=pkt,proto3" json:"pkt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PacketIndication) Reset() {
	*x = PacketIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PacketIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketIndication) ProtoMessage() {}

func (x *PacketIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketIndication.ProtoReflect.Descriptor instead.
func (*PacketIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{10}
}

func (x *PacketIndication) GetIntfType() string {
	if x != nil {
		return x.IntfType
	}
	return ""
}

func (x *PacketIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *PacketIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *PacketIndication) GetUniId() uint32 {
	if x != nil {
		return x.UniId
	}
	return 0
}

func (x *PacketIndication) GetGemportId() uint32 {
	if x != nil {
		return x.GemportId
	}
	return 0
}

func (x *PacketIndication) GetFlowId() uint32 {
	if x != nil {
		return x.FlowId
	}
	return 0
}

func (x *PacketIndication) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *PacketIndication) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *PacketIndication) GetPkt() []byte {
	if x != nil {
		return x.Pkt
	}
	return nil
}

type Interface struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	IntfType      uint32                 `protobuf:"fixed32,2,opt,name=intf_type,json=intfType,proto3" json:"intf_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Interface) Reset() {
	*x = Interface{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Interface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Interface) ProtoMessage() {}

func (x *Interface) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Interface.ProtoReflect.Descriptor instead.
func (*Interface) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{11}
}

func (x *Interface) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *Interface) GetIntfType() uint32 {
	if x != nil {
		return x.IntfType
	}
	return 0
}

type Heartbeat struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	HeartbeatSignature uint32                 `protobuf:"fixed32,1,opt,name=heartbeat_signature,json=heartbeatSignature,proto3" json:"heartbeat_signature,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Heartbeat) Reset() {
	*x = Heartbeat{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Heartbeat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Heartbeat) ProtoMessage() {}

func (x *Heartbeat) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Heartbeat.ProtoReflect.Descriptor instead.
func (*Heartbeat) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{12}
}

func (x *Heartbeat) GetHeartbeatSignature() uint32 {
	if x != nil {
		return x.HeartbeatSignature
	}
	return 0
}

type Onu struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	IntfId         uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId          uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	SerialNumber   *SerialNumber          `protobuf:"bytes,3,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	Pir            uint32                 `protobuf:"fixed32,4,opt,name=pir,proto3" json:"pir,omitempty"` // peak information rate assigned to onu
	OmccEncryption bool                   `protobuf:"varint,5,opt,name=omcc_encryption,json=omccEncryption,proto3" json:"omcc_encryption,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Onu) Reset() {
	*x = Onu{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Onu) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Onu) ProtoMessage() {}

func (x *Onu) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Onu.ProtoReflect.Descriptor instead.
func (*Onu) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{13}
}

func (x *Onu) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *Onu) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *Onu) GetSerialNumber() *SerialNumber {
	if x != nil {
		return x.SerialNumber
	}
	return nil
}

func (x *Onu) GetPir() uint32 {
	if x != nil {
		return x.Pir
	}
	return 0
}

func (x *Onu) GetOmccEncryption() bool {
	if x != nil {
		return x.OmccEncryption
	}
	return false
}

type OnuLogicalDistance struct {
	state                  protoimpl.MessageState `protogen:"open.v1"`
	IntfId                 uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId                  uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	LogicalOnuDistanceZero uint32                 `protobuf:"fixed32,3,opt,name=logical_onu_distance_zero,json=logicalOnuDistanceZero,proto3" json:"logical_onu_distance_zero,omitempty"` //0km logical distance
	LogicalOnuDistance     uint32                 `protobuf:"fixed32,4,opt,name=logical_onu_distance,json=logicalOnuDistance,proto3" json:"logical_onu_distance,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *OnuLogicalDistance) Reset() {
	*x = OnuLogicalDistance{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuLogicalDistance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuLogicalDistance) ProtoMessage() {}

func (x *OnuLogicalDistance) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuLogicalDistance.ProtoReflect.Descriptor instead.
func (*OnuLogicalDistance) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{14}
}

func (x *OnuLogicalDistance) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuLogicalDistance) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuLogicalDistance) GetLogicalOnuDistanceZero() uint32 {
	if x != nil {
		return x.LogicalOnuDistanceZero
	}
	return 0
}

func (x *OnuLogicalDistance) GetLogicalOnuDistance() uint32 {
	if x != nil {
		return x.LogicalOnuDistance
	}
	return 0
}

type OmciMsg struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Pkt           []byte                 `protobuf:"bytes,3,opt,name=pkt,proto3" json:"pkt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OmciMsg) Reset() {
	*x = OmciMsg{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OmciMsg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OmciMsg) ProtoMessage() {}

func (x *OmciMsg) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OmciMsg.ProtoReflect.Descriptor instead.
func (*OmciMsg) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{15}
}

func (x *OmciMsg) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OmciMsg) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OmciMsg) GetPkt() []byte {
	if x != nil {
		return x.Pkt
	}
	return nil
}

type OnuPacket struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	PortNo        uint32                 `protobuf:"fixed32,4,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	GemportId     uint32                 `protobuf:"fixed32,5,opt,name=gemport_id,json=gemportId,proto3" json:"gemport_id,omitempty"`
	AllocId       uint32                 `protobuf:"fixed32,6,opt,name=alloc_id,json=allocId,proto3" json:"alloc_id,omitempty"`
	Pkt           []byte                 `protobuf:"bytes,3,opt,name=pkt,proto3" json:"pkt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuPacket) Reset() {
	*x = OnuPacket{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuPacket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuPacket) ProtoMessage() {}

func (x *OnuPacket) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuPacket.ProtoReflect.Descriptor instead.
func (*OnuPacket) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{16}
}

func (x *OnuPacket) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuPacket) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuPacket) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *OnuPacket) GetGemportId() uint32 {
	if x != nil {
		return x.GemportId
	}
	return 0
}

func (x *OnuPacket) GetAllocId() uint32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *OnuPacket) GetPkt() []byte {
	if x != nil {
		return x.Pkt
	}
	return nil
}

type UplinkPacket struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	Pkt           []byte                 `protobuf:"bytes,2,opt,name=pkt,proto3" json:"pkt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UplinkPacket) Reset() {
	*x = UplinkPacket{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkPacket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkPacket) ProtoMessage() {}

func (x *UplinkPacket) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkPacket.ProtoReflect.Descriptor instead.
func (*UplinkPacket) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{17}
}

func (x *UplinkPacket) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *UplinkPacket) GetPkt() []byte {
	if x != nil {
		return x.Pkt
	}
	return nil
}

type DeviceInfo struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	Vendor              string                 `protobuf:"bytes,1,opt,name=vendor,proto3" json:"vendor,omitempty"`
	Model               string                 `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	HardwareVersion     string                 `protobuf:"bytes,3,opt,name=hardware_version,json=hardwareVersion,proto3" json:"hardware_version,omitempty"`
	FirmwareVersion     string                 `protobuf:"bytes,4,opt,name=firmware_version,json=firmwareVersion,proto3" json:"firmware_version,omitempty"`
	DeviceId            string                 `protobuf:"bytes,16,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	DeviceSerialNumber  string                 `protobuf:"bytes,17,opt,name=device_serial_number,json=deviceSerialNumber,proto3" json:"device_serial_number,omitempty"`
	PreviouslyConnected bool                   `protobuf:"varint,19,opt,name=previously_connected,json=previouslyConnected,proto3" json:"previously_connected,omitempty"` // used to indicate agent reconcile status
	// Total number of pon intf ports on the device
	PonPorts uint32 `protobuf:"fixed32,12,opt,name=pon_ports,json=ponPorts,proto3" json:"pon_ports,omitempty"`
	// Total number of nni intf ports on the device
	NniPorts      uint32                             `protobuf:"fixed32,20,opt,name=nni_ports,json=nniPorts,proto3" json:"nni_ports,omitempty"`
	Ranges        []*DeviceInfo_DeviceResourceRanges `protobuf:"bytes,15,rep,name=ranges,proto3" json:"ranges,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeviceInfo) Reset() {
	*x = DeviceInfo{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceInfo) ProtoMessage() {}

func (x *DeviceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceInfo.ProtoReflect.Descriptor instead.
func (*DeviceInfo) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{18}
}

func (x *DeviceInfo) GetVendor() string {
	if x != nil {
		return x.Vendor
	}
	return ""
}

func (x *DeviceInfo) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *DeviceInfo) GetHardwareVersion() string {
	if x != nil {
		return x.HardwareVersion
	}
	return ""
}

func (x *DeviceInfo) GetFirmwareVersion() string {
	if x != nil {
		return x.FirmwareVersion
	}
	return ""
}

func (x *DeviceInfo) GetDeviceId() string {
	if x != nil {
		return x.DeviceId
	}
	return ""
}

func (x *DeviceInfo) GetDeviceSerialNumber() string {
	if x != nil {
		return x.DeviceSerialNumber
	}
	return ""
}

func (x *DeviceInfo) GetPreviouslyConnected() bool {
	if x != nil {
		return x.PreviouslyConnected
	}
	return false
}

func (x *DeviceInfo) GetPonPorts() uint32 {
	if x != nil {
		return x.PonPorts
	}
	return 0
}

func (x *DeviceInfo) GetNniPorts() uint32 {
	if x != nil {
		return x.NniPorts
	}
	return 0
}

func (x *DeviceInfo) GetRanges() []*DeviceInfo_DeviceResourceRanges {
	if x != nil {
		return x.Ranges
	}
	return nil
}

type Classifier struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OTpid         uint32                 `protobuf:"fixed32,1,opt,name=o_tpid,json=oTpid,proto3" json:"o_tpid,omitempty"`
	OVid          uint32                 `protobuf:"fixed32,2,opt,name=o_vid,json=oVid,proto3" json:"o_vid,omitempty"`
	ITpid         uint32                 `protobuf:"fixed32,3,opt,name=i_tpid,json=iTpid,proto3" json:"i_tpid,omitempty"`
	IVid          uint32                 `protobuf:"fixed32,4,opt,name=i_vid,json=iVid,proto3" json:"i_vid,omitempty"`
	OPbits        uint32                 `protobuf:"fixed32,5,opt,name=o_pbits,json=oPbits,proto3" json:"o_pbits,omitempty"`
	IPbits        uint32                 `protobuf:"fixed32,6,opt,name=i_pbits,json=iPbits,proto3" json:"i_pbits,omitempty"`
	EthType       uint32                 `protobuf:"fixed32,7,opt,name=eth_type,json=ethType,proto3" json:"eth_type,omitempty"`
	DstMac        []byte                 `protobuf:"bytes,8,opt,name=dst_mac,json=dstMac,proto3" json:"dst_mac,omitempty"`
	SrcMac        []byte                 `protobuf:"bytes,9,opt,name=src_mac,json=srcMac,proto3" json:"src_mac,omitempty"`
	IpProto       uint32                 `protobuf:"fixed32,10,opt,name=ip_proto,json=ipProto,proto3" json:"ip_proto,omitempty"`
	DstIp         uint32                 `protobuf:"fixed32,11,opt,name=dst_ip,json=dstIp,proto3" json:"dst_ip,omitempty"`
	SrcIp         uint32                 `protobuf:"fixed32,12,opt,name=src_ip,json=srcIp,proto3" json:"src_ip,omitempty"`
	SrcPort       uint32                 `protobuf:"fixed32,13,opt,name=src_port,json=srcPort,proto3" json:"src_port,omitempty"`
	DstPort       uint32                 `protobuf:"fixed32,14,opt,name=dst_port,json=dstPort,proto3" json:"dst_port,omitempty"`
	PktTagType    string                 `protobuf:"bytes,15,opt,name=pkt_tag_type,json=pktTagType,proto3" json:"pkt_tag_type,omitempty"` // untagged, single_tag, double_tag
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Classifier) Reset() {
	*x = Classifier{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Classifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Classifier) ProtoMessage() {}

func (x *Classifier) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Classifier.ProtoReflect.Descriptor instead.
func (*Classifier) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{19}
}

func (x *Classifier) GetOTpid() uint32 {
	if x != nil {
		return x.OTpid
	}
	return 0
}

func (x *Classifier) GetOVid() uint32 {
	if x != nil {
		return x.OVid
	}
	return 0
}

func (x *Classifier) GetITpid() uint32 {
	if x != nil {
		return x.ITpid
	}
	return 0
}

func (x *Classifier) GetIVid() uint32 {
	if x != nil {
		return x.IVid
	}
	return 0
}

func (x *Classifier) GetOPbits() uint32 {
	if x != nil {
		return x.OPbits
	}
	return 0
}

func (x *Classifier) GetIPbits() uint32 {
	if x != nil {
		return x.IPbits
	}
	return 0
}

func (x *Classifier) GetEthType() uint32 {
	if x != nil {
		return x.EthType
	}
	return 0
}

func (x *Classifier) GetDstMac() []byte {
	if x != nil {
		return x.DstMac
	}
	return nil
}

func (x *Classifier) GetSrcMac() []byte {
	if x != nil {
		return x.SrcMac
	}
	return nil
}

func (x *Classifier) GetIpProto() uint32 {
	if x != nil {
		return x.IpProto
	}
	return 0
}

func (x *Classifier) GetDstIp() uint32 {
	if x != nil {
		return x.DstIp
	}
	return 0
}

func (x *Classifier) GetSrcIp() uint32 {
	if x != nil {
		return x.SrcIp
	}
	return 0
}

func (x *Classifier) GetSrcPort() uint32 {
	if x != nil {
		return x.SrcPort
	}
	return 0
}

func (x *Classifier) GetDstPort() uint32 {
	if x != nil {
		return x.DstPort
	}
	return 0
}

func (x *Classifier) GetPktTagType() string {
	if x != nil {
		return x.PktTagType
	}
	return ""
}

type ActionCmd struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	AddOuterTag       bool                   `protobuf:"varint,1,opt,name=add_outer_tag,json=addOuterTag,proto3" json:"add_outer_tag,omitempty"`
	RemoveOuterTag    bool                   `protobuf:"varint,2,opt,name=remove_outer_tag,json=removeOuterTag,proto3" json:"remove_outer_tag,omitempty"`
	TrapToHost        bool                   `protobuf:"varint,3,opt,name=trap_to_host,json=trapToHost,proto3" json:"trap_to_host,omitempty"`
	RemarkOuterPbits  bool                   `protobuf:"varint,4,opt,name=remark_outer_pbits,json=remarkOuterPbits,proto3" json:"remark_outer_pbits,omitempty"`
	RemarkInnerPbits  bool                   `protobuf:"varint,5,opt,name=remark_inner_pbits,json=remarkInnerPbits,proto3" json:"remark_inner_pbits,omitempty"`
	AddInnerTag       bool                   `protobuf:"varint,6,opt,name=add_inner_tag,json=addInnerTag,proto3" json:"add_inner_tag,omitempty"`
	RemoveInnerTag    bool                   `protobuf:"varint,7,opt,name=remove_inner_tag,json=removeInnerTag,proto3" json:"remove_inner_tag,omitempty"`
	TranslateInnerTag bool                   `protobuf:"varint,8,opt,name=translate_inner_tag,json=translateInnerTag,proto3" json:"translate_inner_tag,omitempty"`
	TranslateOuterTag bool                   `protobuf:"varint,9,opt,name=translate_outer_tag,json=translateOuterTag,proto3" json:"translate_outer_tag,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *ActionCmd) Reset() {
	*x = ActionCmd{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ActionCmd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionCmd) ProtoMessage() {}

func (x *ActionCmd) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionCmd.ProtoReflect.Descriptor instead.
func (*ActionCmd) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{20}
}

func (x *ActionCmd) GetAddOuterTag() bool {
	if x != nil {
		return x.AddOuterTag
	}
	return false
}

func (x *ActionCmd) GetRemoveOuterTag() bool {
	if x != nil {
		return x.RemoveOuterTag
	}
	return false
}

func (x *ActionCmd) GetTrapToHost() bool {
	if x != nil {
		return x.TrapToHost
	}
	return false
}

func (x *ActionCmd) GetRemarkOuterPbits() bool {
	if x != nil {
		return x.RemarkOuterPbits
	}
	return false
}

func (x *ActionCmd) GetRemarkInnerPbits() bool {
	if x != nil {
		return x.RemarkInnerPbits
	}
	return false
}

func (x *ActionCmd) GetAddInnerTag() bool {
	if x != nil {
		return x.AddInnerTag
	}
	return false
}

func (x *ActionCmd) GetRemoveInnerTag() bool {
	if x != nil {
		return x.RemoveInnerTag
	}
	return false
}

func (x *ActionCmd) GetTranslateInnerTag() bool {
	if x != nil {
		return x.TranslateInnerTag
	}
	return false
}

func (x *ActionCmd) GetTranslateOuterTag() bool {
	if x != nil {
		return x.TranslateOuterTag
	}
	return false
}

type Action struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Cmd           *ActionCmd             `protobuf:"bytes,1,opt,name=cmd,proto3" json:"cmd,omitempty"`
	OVid          uint32                 `protobuf:"fixed32,2,opt,name=o_vid,json=oVid,proto3" json:"o_vid,omitempty"`
	OPbits        uint32                 `protobuf:"fixed32,3,opt,name=o_pbits,json=oPbits,proto3" json:"o_pbits,omitempty"`
	OTpid         uint32                 `protobuf:"fixed32,4,opt,name=o_tpid,json=oTpid,proto3" json:"o_tpid,omitempty"`
	IVid          uint32                 `protobuf:"fixed32,5,opt,name=i_vid,json=iVid,proto3" json:"i_vid,omitempty"`
	IPbits        uint32                 `protobuf:"fixed32,6,opt,name=i_pbits,json=iPbits,proto3" json:"i_pbits,omitempty"`
	ITpid         uint32                 `protobuf:"fixed32,7,opt,name=i_tpid,json=iTpid,proto3" json:"i_tpid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Action) Reset() {
	*x = Action{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{21}
}

func (x *Action) GetCmd() *ActionCmd {
	if x != nil {
		return x.Cmd
	}
	return nil
}

func (x *Action) GetOVid() uint32 {
	if x != nil {
		return x.OVid
	}
	return 0
}

func (x *Action) GetOPbits() uint32 {
	if x != nil {
		return x.OPbits
	}
	return 0
}

func (x *Action) GetOTpid() uint32 {
	if x != nil {
		return x.OTpid
	}
	return 0
}

func (x *Action) GetIVid() uint32 {
	if x != nil {
		return x.IVid
	}
	return 0
}

func (x *Action) GetIPbits() uint32 {
	if x != nil {
		return x.IPbits
	}
	return 0
}

func (x *Action) GetITpid() uint32 {
	if x != nil {
		return x.ITpid
	}
	return 0
}

type Flow struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	AccessIntfId    int32                  `protobuf:"fixed32,1,opt,name=access_intf_id,json=accessIntfId,proto3" json:"access_intf_id,omitempty"`
	OnuId           int32                  `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	UniId           int32                  `protobuf:"fixed32,11,opt,name=uni_id,json=uniId,proto3" json:"uni_id,omitempty"`
	FlowId          uint64                 `protobuf:"fixed64,3,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`                               // voltha flow-id. 0 is not a valid flow_id
	SymmetricFlowId uint64                 `protobuf:"fixed64,18,opt,name=symmetric_flow_id,json=symmetricFlowId,proto3" json:"symmetric_flow_id,omitempty"` // symmetric voltha flow-id, if applicable. All data path flows generally have a symmetric flow,
	FlowType        string                 `protobuf:"bytes,4,opt,name=flow_type,json=flowType,proto3" json:"flow_type,omitempty"`                           // upstream, downstream, broadcast, multicast
	AllocId         int32                  `protobuf:"fixed32,10,opt,name=alloc_id,json=allocId,proto3" json:"alloc_id,omitempty"`
	NetworkIntfId   int32                  `protobuf:"fixed32,5,opt,name=network_intf_id,json=networkIntfId,proto3" json:"network_intf_id,omitempty"`
	GemportId       int32                  `protobuf:"fixed32,6,opt,name=gemport_id,json=gemportId,proto3" json:"gemport_id,omitempty"` // When 'replicate_flow' field is true, this field is obsolete.
	Classifier      *Classifier            `protobuf:"bytes,7,opt,name=classifier,proto3" json:"classifier,omitempty"`
	Action          *Action                `protobuf:"bytes,8,opt,name=action,proto3" json:"action,omitempty"`
	Priority        int32                  `protobuf:"fixed32,9,opt,name=priority,proto3" json:"priority,omitempty"`
	Cookie          uint64                 `protobuf:"fixed64,12,opt,name=cookie,proto3" json:"cookie,omitempty"`               // must be provided for any flow with trap_to_host action. Returned in PacketIndication
	PortNo          uint32                 `protobuf:"fixed32,13,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"` // must be provided for any flow with trap_to_host action. Returned in PacketIndication
	GroupId         uint32                 `protobuf:"fixed32,14,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	TechProfileId   uint32                 `protobuf:"fixed32,15,opt,name=tech_profile_id,json=techProfileId,proto3" json:"tech_profile_id,omitempty"`
	ReplicateFlow   bool                   `protobuf:"varint,16,opt,name=replicate_flow,json=replicateFlow,proto3" json:"replicate_flow,omitempty"`                                                                                // When this field is true, use pbitToGemPortID to know which p-bit needs to be classfied to which gem port.
	PbitToGemport   map[uint32]uint32      `protobuf:"bytes,17,rep,name=pbit_to_gemport,json=pbitToGemport,proto3" json:"pbit_to_gemport,omitempty" protobuf_key:"fixed32,1,opt,name=key" protobuf_val:"fixed32,2,opt,name=value"` // Map of p-bit to gem port ID
	GemportToAes    map[uint32]bool        `protobuf:"bytes,19,rep,name=gemport_to_aes,json=gemportToAes,proto3" json:"gemport_to_aes,omitempty" protobuf_key:"fixed32,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`     // Map of gem port ID to aes encryption
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Flow) Reset() {
	*x = Flow{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Flow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Flow) ProtoMessage() {}

func (x *Flow) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Flow.ProtoReflect.Descriptor instead.
func (*Flow) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{22}
}

func (x *Flow) GetAccessIntfId() int32 {
	if x != nil {
		return x.AccessIntfId
	}
	return 0
}

func (x *Flow) GetOnuId() int32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *Flow) GetUniId() int32 {
	if x != nil {
		return x.UniId
	}
	return 0
}

func (x *Flow) GetFlowId() uint64 {
	if x != nil {
		return x.FlowId
	}
	return 0
}

func (x *Flow) GetSymmetricFlowId() uint64 {
	if x != nil {
		return x.SymmetricFlowId
	}
	return 0
}

func (x *Flow) GetFlowType() string {
	if x != nil {
		return x.FlowType
	}
	return ""
}

func (x *Flow) GetAllocId() int32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *Flow) GetNetworkIntfId() int32 {
	if x != nil {
		return x.NetworkIntfId
	}
	return 0
}

func (x *Flow) GetGemportId() int32 {
	if x != nil {
		return x.GemportId
	}
	return 0
}

func (x *Flow) GetClassifier() *Classifier {
	if x != nil {
		return x.Classifier
	}
	return nil
}

func (x *Flow) GetAction() *Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *Flow) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Flow) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *Flow) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *Flow) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

func (x *Flow) GetTechProfileId() uint32 {
	if x != nil {
		return x.TechProfileId
	}
	return 0
}

func (x *Flow) GetReplicateFlow() bool {
	if x != nil {
		return x.ReplicateFlow
	}
	return false
}

func (x *Flow) GetPbitToGemport() map[uint32]uint32 {
	if x != nil {
		return x.PbitToGemport
	}
	return nil
}

func (x *Flow) GetGemportToAes() map[uint32]bool {
	if x != nil {
		return x.GemportToAes
	}
	return nil
}

type SerialNumber struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	VendorId       []byte                 `protobuf:"bytes,1,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	VendorSpecific []byte                 `protobuf:"bytes,2,opt,name=vendor_specific,json=vendorSpecific,proto3" json:"vendor_specific,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SerialNumber) Reset() {
	*x = SerialNumber{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SerialNumber) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerialNumber) ProtoMessage() {}

func (x *SerialNumber) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerialNumber.ProtoReflect.Descriptor instead.
func (*SerialNumber) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{23}
}

func (x *SerialNumber) GetVendorId() []byte {
	if x != nil {
		return x.VendorId
	}
	return nil
}

func (x *SerialNumber) GetVendorSpecific() []byte {
	if x != nil {
		return x.VendorSpecific
	}
	return nil
}

type OnuStatistics struct {
	state                     protoimpl.MessageState `protogen:"open.v1"`
	IntfId                    uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId                     uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	PositiveDrift             uint64                 `protobuf:"fixed64,3,opt,name=positive_drift,json=positiveDrift,proto3" json:"positive_drift,omitempty"`
	NegativeDrift             uint64                 `protobuf:"fixed64,4,opt,name=negative_drift,json=negativeDrift,proto3" json:"negative_drift,omitempty"`
	DelimiterMissDetection    uint64                 `protobuf:"fixed64,5,opt,name=delimiter_miss_detection,json=delimiterMissDetection,proto3" json:"delimiter_miss_detection,omitempty"`
	BipErrors                 uint64                 `protobuf:"fixed64,6,opt,name=bip_errors,json=bipErrors,proto3" json:"bip_errors,omitempty"`
	BipUnits                  uint64                 `protobuf:"fixed64,7,opt,name=bip_units,json=bipUnits,proto3" json:"bip_units,omitempty"`
	FecCorrectedSymbols       uint64                 `protobuf:"fixed64,8,opt,name=fec_corrected_symbols,json=fecCorrectedSymbols,proto3" json:"fec_corrected_symbols,omitempty"`
	FecCodewordsCorrected     uint64                 `protobuf:"fixed64,9,opt,name=fec_codewords_corrected,json=fecCodewordsCorrected,proto3" json:"fec_codewords_corrected,omitempty"`
	FecCodewordsUncorrectable uint64                 `protobuf:"fixed64,10,opt,name=fec_codewords_uncorrectable,json=fecCodewordsUncorrectable,proto3" json:"fec_codewords_uncorrectable,omitempty"`
	FecCodewords              uint64                 `protobuf:"fixed64,11,opt,name=fec_codewords,json=fecCodewords,proto3" json:"fec_codewords,omitempty"`
	FecCorrectedUnits         uint64                 `protobuf:"fixed64,12,opt,name=fec_corrected_units,json=fecCorrectedUnits,proto3" json:"fec_corrected_units,omitempty"`
	XgemKeyErrors             uint64                 `protobuf:"fixed64,13,opt,name=xgem_key_errors,json=xgemKeyErrors,proto3" json:"xgem_key_errors,omitempty"`
	XgemLoss                  uint64                 `protobuf:"fixed64,14,opt,name=xgem_loss,json=xgemLoss,proto3" json:"xgem_loss,omitempty"`
	RxPloamsError             uint64                 `protobuf:"fixed64,15,opt,name=rx_ploams_error,json=rxPloamsError,proto3" json:"rx_ploams_error,omitempty"`
	RxPloamsNonIdle           uint64                 `protobuf:"fixed64,16,opt,name=rx_ploams_non_idle,json=rxPloamsNonIdle,proto3" json:"rx_ploams_non_idle,omitempty"`
	RxOmci                    uint64                 `protobuf:"fixed64,17,opt,name=rx_omci,json=rxOmci,proto3" json:"rx_omci,omitempty"`
	RxOmciPacketsCrcError     uint64                 `protobuf:"fixed64,18,opt,name=rx_omci_packets_crc_error,json=rxOmciPacketsCrcError,proto3" json:"rx_omci_packets_crc_error,omitempty"`
	RxBytes                   uint64                 `protobuf:"fixed64,19,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	RxPackets                 uint64                 `protobuf:"fixed64,20,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	TxBytes                   uint64                 `protobuf:"fixed64,21,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxPackets                 uint64                 `protobuf:"fixed64,22,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	BerReported               uint64                 `protobuf:"fixed64,23,opt,name=ber_reported,json=berReported,proto3" json:"ber_reported,omitempty"`
	LcdgErrors                uint64                 `protobuf:"fixed64,24,opt,name=lcdg_errors,json=lcdgErrors,proto3" json:"lcdg_errors,omitempty"`
	RdiErrors                 uint64                 `protobuf:"fixed64,25,opt,name=rdi_errors,json=rdiErrors,proto3" json:"rdi_errors,omitempty"`
	Timestamp                 uint32                 `protobuf:"fixed32,26,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *OnuStatistics) Reset() {
	*x = OnuStatistics{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuStatistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuStatistics) ProtoMessage() {}

func (x *OnuStatistics) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuStatistics.ProtoReflect.Descriptor instead.
func (*OnuStatistics) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{24}
}

func (x *OnuStatistics) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuStatistics) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuStatistics) GetPositiveDrift() uint64 {
	if x != nil {
		return x.PositiveDrift
	}
	return 0
}

func (x *OnuStatistics) GetNegativeDrift() uint64 {
	if x != nil {
		return x.NegativeDrift
	}
	return 0
}

func (x *OnuStatistics) GetDelimiterMissDetection() uint64 {
	if x != nil {
		return x.DelimiterMissDetection
	}
	return 0
}

func (x *OnuStatistics) GetBipErrors() uint64 {
	if x != nil {
		return x.BipErrors
	}
	return 0
}

func (x *OnuStatistics) GetBipUnits() uint64 {
	if x != nil {
		return x.BipUnits
	}
	return 0
}

func (x *OnuStatistics) GetFecCorrectedSymbols() uint64 {
	if x != nil {
		return x.FecCorrectedSymbols
	}
	return 0
}

func (x *OnuStatistics) GetFecCodewordsCorrected() uint64 {
	if x != nil {
		return x.FecCodewordsCorrected
	}
	return 0
}

func (x *OnuStatistics) GetFecCodewordsUncorrectable() uint64 {
	if x != nil {
		return x.FecCodewordsUncorrectable
	}
	return 0
}

func (x *OnuStatistics) GetFecCodewords() uint64 {
	if x != nil {
		return x.FecCodewords
	}
	return 0
}

func (x *OnuStatistics) GetFecCorrectedUnits() uint64 {
	if x != nil {
		return x.FecCorrectedUnits
	}
	return 0
}

func (x *OnuStatistics) GetXgemKeyErrors() uint64 {
	if x != nil {
		return x.XgemKeyErrors
	}
	return 0
}

func (x *OnuStatistics) GetXgemLoss() uint64 {
	if x != nil {
		return x.XgemLoss
	}
	return 0
}

func (x *OnuStatistics) GetRxPloamsError() uint64 {
	if x != nil {
		return x.RxPloamsError
	}
	return 0
}

func (x *OnuStatistics) GetRxPloamsNonIdle() uint64 {
	if x != nil {
		return x.RxPloamsNonIdle
	}
	return 0
}

func (x *OnuStatistics) GetRxOmci() uint64 {
	if x != nil {
		return x.RxOmci
	}
	return 0
}

func (x *OnuStatistics) GetRxOmciPacketsCrcError() uint64 {
	if x != nil {
		return x.RxOmciPacketsCrcError
	}
	return 0
}

func (x *OnuStatistics) GetRxBytes() uint64 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

func (x *OnuStatistics) GetRxPackets() uint64 {
	if x != nil {
		return x.RxPackets
	}
	return 0
}

func (x *OnuStatistics) GetTxBytes() uint64 {
	if x != nil {
		return x.TxBytes
	}
	return 0
}

func (x *OnuStatistics) GetTxPackets() uint64 {
	if x != nil {
		return x.TxPackets
	}
	return 0
}

func (x *OnuStatistics) GetBerReported() uint64 {
	if x != nil {
		return x.BerReported
	}
	return 0
}

func (x *OnuStatistics) GetLcdgErrors() uint64 {
	if x != nil {
		return x.LcdgErrors
	}
	return 0
}

func (x *OnuStatistics) GetRdiErrors() uint64 {
	if x != nil {
		return x.RdiErrors
	}
	return 0
}

func (x *OnuStatistics) GetTimestamp() uint32 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type GemPortStatistics struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	GemportId     uint32                 `protobuf:"fixed32,2,opt,name=gemport_id,json=gemportId,proto3" json:"gemport_id,omitempty"`
	RxPackets     uint64                 `protobuf:"fixed64,3,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	RxBytes       uint64                 `protobuf:"fixed64,4,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	TxPackets     uint64                 `protobuf:"fixed64,5,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	TxBytes       uint64                 `protobuf:"fixed64,6,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	Timestamp     uint32                 `protobuf:"fixed32,26,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GemPortStatistics) Reset() {
	*x = GemPortStatistics{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GemPortStatistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GemPortStatistics) ProtoMessage() {}

func (x *GemPortStatistics) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GemPortStatistics.ProtoReflect.Descriptor instead.
func (*GemPortStatistics) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{25}
}

func (x *GemPortStatistics) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *GemPortStatistics) GetGemportId() uint32 {
	if x != nil {
		return x.GemportId
	}
	return 0
}

func (x *GemPortStatistics) GetRxPackets() uint64 {
	if x != nil {
		return x.RxPackets
	}
	return 0
}

func (x *GemPortStatistics) GetRxBytes() uint64 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

func (x *GemPortStatistics) GetTxPackets() uint64 {
	if x != nil {
		return x.TxPackets
	}
	return 0
}

func (x *GemPortStatistics) GetTxBytes() uint64 {
	if x != nil {
		return x.TxBytes
	}
	return 0
}

func (x *GemPortStatistics) GetTimestamp() uint32 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type FlowStatistics struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FlowId        uint32                 `protobuf:"fixed32,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	RxBytes       uint64                 `protobuf:"fixed64,2,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	RxPackets     uint64                 `protobuf:"fixed64,3,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	TxBytes       uint64                 `protobuf:"fixed64,8,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxPackets     uint64                 `protobuf:"fixed64,9,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	Timestamp     uint32                 `protobuf:"fixed32,16,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowStatistics) Reset() {
	*x = FlowStatistics{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowStatistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowStatistics) ProtoMessage() {}

func (x *FlowStatistics) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowStatistics.ProtoReflect.Descriptor instead.
func (*FlowStatistics) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{26}
}

func (x *FlowStatistics) GetFlowId() uint32 {
	if x != nil {
		return x.FlowId
	}
	return 0
}

func (x *FlowStatistics) GetRxBytes() uint64 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

func (x *FlowStatistics) GetRxPackets() uint64 {
	if x != nil {
		return x.RxPackets
	}
	return 0
}

func (x *FlowStatistics) GetTxBytes() uint64 {
	if x != nil {
		return x.TxBytes
	}
	return 0
}

func (x *FlowStatistics) GetTxPackets() uint64 {
	if x != nil {
		return x.TxPackets
	}
	return 0
}

func (x *FlowStatistics) GetTimestamp() uint32 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type LosIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	Status        string                 `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LosIndication) Reset() {
	*x = LosIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LosIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LosIndication) ProtoMessage() {}

func (x *LosIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LosIndication.ProtoReflect.Descriptor instead.
func (*LosIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{27}
}

func (x *LosIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *LosIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type DyingGaspIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DyingGaspIndication) Reset() {
	*x = DyingGaspIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DyingGaspIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DyingGaspIndication) ProtoMessage() {}

func (x *DyingGaspIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DyingGaspIndication.ProtoReflect.Descriptor instead.
func (*DyingGaspIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{28}
}

func (x *DyingGaspIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *DyingGaspIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *DyingGaspIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type OnuAlarmIndication struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	IntfId             uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId              uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	LosStatus          string                 `protobuf:"bytes,3,opt,name=los_status,json=losStatus,proto3" json:"los_status,omitempty"`
	LobStatus          string                 `protobuf:"bytes,4,opt,name=lob_status,json=lobStatus,proto3" json:"lob_status,omitempty"`
	LopcMissStatus     string                 `protobuf:"bytes,5,opt,name=lopc_miss_status,json=lopcMissStatus,proto3" json:"lopc_miss_status,omitempty"`
	LopcMicErrorStatus string                 `protobuf:"bytes,6,opt,name=lopc_mic_error_status,json=lopcMicErrorStatus,proto3" json:"lopc_mic_error_status,omitempty"`
	LofiStatus         string                 `protobuf:"bytes,7,opt,name=lofi_status,json=lofiStatus,proto3" json:"lofi_status,omitempty"`
	LoamiStatus        string                 `protobuf:"bytes,8,opt,name=loami_status,json=loamiStatus,proto3" json:"loami_status,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *OnuAlarmIndication) Reset() {
	*x = OnuAlarmIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuAlarmIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuAlarmIndication) ProtoMessage() {}

func (x *OnuAlarmIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuAlarmIndication.ProtoReflect.Descriptor instead.
func (*OnuAlarmIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{29}
}

func (x *OnuAlarmIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuAlarmIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuAlarmIndication) GetLosStatus() string {
	if x != nil {
		return x.LosStatus
	}
	return ""
}

func (x *OnuAlarmIndication) GetLobStatus() string {
	if x != nil {
		return x.LobStatus
	}
	return ""
}

func (x *OnuAlarmIndication) GetLopcMissStatus() string {
	if x != nil {
		return x.LopcMissStatus
	}
	return ""
}

func (x *OnuAlarmIndication) GetLopcMicErrorStatus() string {
	if x != nil {
		return x.LopcMicErrorStatus
	}
	return ""
}

func (x *OnuAlarmIndication) GetLofiStatus() string {
	if x != nil {
		return x.LofiStatus
	}
	return ""
}

func (x *OnuAlarmIndication) GetLoamiStatus() string {
	if x != nil {
		return x.LoamiStatus
	}
	return ""
}

type OnuStartupFailureIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuStartupFailureIndication) Reset() {
	*x = OnuStartupFailureIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuStartupFailureIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuStartupFailureIndication) ProtoMessage() {}

func (x *OnuStartupFailureIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuStartupFailureIndication.ProtoReflect.Descriptor instead.
func (*OnuStartupFailureIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{30}
}

func (x *OnuStartupFailureIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuStartupFailureIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuStartupFailureIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type OnuSignalDegradeIndication struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	IntfId              uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId               uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status              string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	InverseBitErrorRate uint32                 `protobuf:"fixed32,4,opt,name=inverse_bit_error_rate,json=inverseBitErrorRate,proto3" json:"inverse_bit_error_rate,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *OnuSignalDegradeIndication) Reset() {
	*x = OnuSignalDegradeIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuSignalDegradeIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuSignalDegradeIndication) ProtoMessage() {}

func (x *OnuSignalDegradeIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuSignalDegradeIndication.ProtoReflect.Descriptor instead.
func (*OnuSignalDegradeIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{31}
}

func (x *OnuSignalDegradeIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuSignalDegradeIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuSignalDegradeIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *OnuSignalDegradeIndication) GetInverseBitErrorRate() uint32 {
	if x != nil {
		return x.InverseBitErrorRate
	}
	return 0
}

type OnuDriftOfWindowIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Drift         uint32                 `protobuf:"fixed32,4,opt,name=drift,proto3" json:"drift,omitempty"`
	NewEqd        uint32                 `protobuf:"fixed32,5,opt,name=new_eqd,json=newEqd,proto3" json:"new_eqd,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuDriftOfWindowIndication) Reset() {
	*x = OnuDriftOfWindowIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuDriftOfWindowIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuDriftOfWindowIndication) ProtoMessage() {}

func (x *OnuDriftOfWindowIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuDriftOfWindowIndication.ProtoReflect.Descriptor instead.
func (*OnuDriftOfWindowIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{32}
}

func (x *OnuDriftOfWindowIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuDriftOfWindowIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuDriftOfWindowIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *OnuDriftOfWindowIndication) GetDrift() uint32 {
	if x != nil {
		return x.Drift
	}
	return 0
}

func (x *OnuDriftOfWindowIndication) GetNewEqd() uint32 {
	if x != nil {
		return x.NewEqd
	}
	return 0
}

type OnuLossOfOmciChannelIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuLossOfOmciChannelIndication) Reset() {
	*x = OnuLossOfOmciChannelIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuLossOfOmciChannelIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuLossOfOmciChannelIndication) ProtoMessage() {}

func (x *OnuLossOfOmciChannelIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuLossOfOmciChannelIndication.ProtoReflect.Descriptor instead.
func (*OnuLossOfOmciChannelIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{33}
}

func (x *OnuLossOfOmciChannelIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuLossOfOmciChannelIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuLossOfOmciChannelIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type OnuSignalsFailureIndication struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	IntfId              uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId               uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status              string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	InverseBitErrorRate uint32                 `protobuf:"fixed32,4,opt,name=inverse_bit_error_rate,json=inverseBitErrorRate,proto3" json:"inverse_bit_error_rate,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *OnuSignalsFailureIndication) Reset() {
	*x = OnuSignalsFailureIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuSignalsFailureIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuSignalsFailureIndication) ProtoMessage() {}

func (x *OnuSignalsFailureIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuSignalsFailureIndication.ProtoReflect.Descriptor instead.
func (*OnuSignalsFailureIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{34}
}

func (x *OnuSignalsFailureIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuSignalsFailureIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuSignalsFailureIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *OnuSignalsFailureIndication) GetInverseBitErrorRate() uint32 {
	if x != nil {
		return x.InverseBitErrorRate
	}
	return 0
}

type OnuTransmissionInterferenceWarning struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Drift         uint32                 `protobuf:"fixed32,4,opt,name=drift,proto3" json:"drift,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuTransmissionInterferenceWarning) Reset() {
	*x = OnuTransmissionInterferenceWarning{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuTransmissionInterferenceWarning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuTransmissionInterferenceWarning) ProtoMessage() {}

func (x *OnuTransmissionInterferenceWarning) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuTransmissionInterferenceWarning.ProtoReflect.Descriptor instead.
func (*OnuTransmissionInterferenceWarning) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{35}
}

func (x *OnuTransmissionInterferenceWarning) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuTransmissionInterferenceWarning) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuTransmissionInterferenceWarning) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *OnuTransmissionInterferenceWarning) GetDrift() uint32 {
	if x != nil {
		return x.Drift
	}
	return 0
}

type OnuActivationFailureIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	FailReason    uint32                 `protobuf:"fixed32,3,opt,name=fail_reason,json=failReason,proto3" json:"fail_reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuActivationFailureIndication) Reset() {
	*x = OnuActivationFailureIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuActivationFailureIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuActivationFailureIndication) ProtoMessage() {}

func (x *OnuActivationFailureIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuActivationFailureIndication.ProtoReflect.Descriptor instead.
func (*OnuActivationFailureIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{36}
}

func (x *OnuActivationFailureIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuActivationFailureIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuActivationFailureIndication) GetFailReason() uint32 {
	if x != nil {
		return x.FailReason
	}
	return 0
}

type OnuLossOfKeySyncFailureIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuLossOfKeySyncFailureIndication) Reset() {
	*x = OnuLossOfKeySyncFailureIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuLossOfKeySyncFailureIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuLossOfKeySyncFailureIndication) ProtoMessage() {}

func (x *OnuLossOfKeySyncFailureIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuLossOfKeySyncFailureIndication.ProtoReflect.Descriptor instead.
func (*OnuLossOfKeySyncFailureIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{37}
}

func (x *OnuLossOfKeySyncFailureIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuLossOfKeySyncFailureIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuLossOfKeySyncFailureIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type RdiErrorIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RdiErrorCount uint64                 `protobuf:"fixed64,1,opt,name=rdi_error_count,json=rdiErrorCount,proto3" json:"rdi_error_count,omitempty"` // RDI Error count
	Status        string                 `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`                                        // on/off based on configured reporting condition
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RdiErrorIndication) Reset() {
	*x = RdiErrorIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RdiErrorIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RdiErrorIndication) ProtoMessage() {}

func (x *RdiErrorIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RdiErrorIndication.ProtoReflect.Descriptor instead.
func (*RdiErrorIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{38}
}

func (x *RdiErrorIndication) GetRdiErrorCount() uint64 {
	if x != nil {
		return x.RdiErrorCount
	}
	return 0
}

func (x *RdiErrorIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type OnuItuPonStatsIndication struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	IntfId uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId  uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	// Types that are valid to be assigned to Stats:
	//
	//	*OnuItuPonStatsIndication_RdiErrorInd
	Stats         isOnuItuPonStatsIndication_Stats `protobuf_oneof:"stats"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuItuPonStatsIndication) Reset() {
	*x = OnuItuPonStatsIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuItuPonStatsIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuItuPonStatsIndication) ProtoMessage() {}

func (x *OnuItuPonStatsIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuItuPonStatsIndication.ProtoReflect.Descriptor instead.
func (*OnuItuPonStatsIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{39}
}

func (x *OnuItuPonStatsIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuItuPonStatsIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuItuPonStatsIndication) GetStats() isOnuItuPonStatsIndication_Stats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *OnuItuPonStatsIndication) GetRdiErrorInd() *RdiErrorIndication {
	if x != nil {
		if x, ok := x.Stats.(*OnuItuPonStatsIndication_RdiErrorInd); ok {
			return x.RdiErrorInd
		}
	}
	return nil
}

type isOnuItuPonStatsIndication_Stats interface {
	isOnuItuPonStatsIndication_Stats()
}

type OnuItuPonStatsIndication_RdiErrorInd struct {
	RdiErrorInd *RdiErrorIndication `protobuf:"bytes,3,opt,name=rdi_error_ind,json=rdiErrorInd,proto3,oneof"` // add more here
}

func (*OnuItuPonStatsIndication_RdiErrorInd) isOnuItuPonStatsIndication_Stats() {}

type OnuProcessingErrorIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuProcessingErrorIndication) Reset() {
	*x = OnuProcessingErrorIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuProcessingErrorIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuProcessingErrorIndication) ProtoMessage() {}

func (x *OnuProcessingErrorIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuProcessingErrorIndication.ProtoReflect.Descriptor instead.
func (*OnuProcessingErrorIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{40}
}

func (x *OnuProcessingErrorIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuProcessingErrorIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

type OnuDeactivationFailureIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuDeactivationFailureIndication) Reset() {
	*x = OnuDeactivationFailureIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuDeactivationFailureIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuDeactivationFailureIndication) ProtoMessage() {}

func (x *OnuDeactivationFailureIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuDeactivationFailureIndication.ProtoReflect.Descriptor instead.
func (*OnuDeactivationFailureIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{41}
}

func (x *OnuDeactivationFailureIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuDeactivationFailureIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuDeactivationFailureIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type OnuRemoteDefectIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	RdiErrors     uint64                 `protobuf:"fixed64,3,opt,name=rdi_errors,json=rdiErrors,proto3" json:"rdi_errors,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuRemoteDefectIndication) Reset() {
	*x = OnuRemoteDefectIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuRemoteDefectIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuRemoteDefectIndication) ProtoMessage() {}

func (x *OnuRemoteDefectIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuRemoteDefectIndication.ProtoReflect.Descriptor instead.
func (*OnuRemoteDefectIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{42}
}

func (x *OnuRemoteDefectIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuRemoteDefectIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuRemoteDefectIndication) GetRdiErrors() uint64 {
	if x != nil {
		return x.RdiErrors
	}
	return 0
}

type OnuLossOfGEMChannelDelineationIndication struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	IntfId            uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId             uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status            string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	DelineationErrors uint32                 `protobuf:"fixed32,4,opt,name=delineation_errors,json=delineationErrors,proto3" json:"delineation_errors,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *OnuLossOfGEMChannelDelineationIndication) Reset() {
	*x = OnuLossOfGEMChannelDelineationIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuLossOfGEMChannelDelineationIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuLossOfGEMChannelDelineationIndication) ProtoMessage() {}

func (x *OnuLossOfGEMChannelDelineationIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuLossOfGEMChannelDelineationIndication.ProtoReflect.Descriptor instead.
func (*OnuLossOfGEMChannelDelineationIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{43}
}

func (x *OnuLossOfGEMChannelDelineationIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuLossOfGEMChannelDelineationIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuLossOfGEMChannelDelineationIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *OnuLossOfGEMChannelDelineationIndication) GetDelineationErrors() uint32 {
	if x != nil {
		return x.DelineationErrors
	}
	return 0
}

type OnuPhysicalEquipmentErrorIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuPhysicalEquipmentErrorIndication) Reset() {
	*x = OnuPhysicalEquipmentErrorIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuPhysicalEquipmentErrorIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuPhysicalEquipmentErrorIndication) ProtoMessage() {}

func (x *OnuPhysicalEquipmentErrorIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuPhysicalEquipmentErrorIndication.ProtoReflect.Descriptor instead.
func (*OnuPhysicalEquipmentErrorIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{44}
}

func (x *OnuPhysicalEquipmentErrorIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuPhysicalEquipmentErrorIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuPhysicalEquipmentErrorIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type OnuLossOfAcknowledgementIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuLossOfAcknowledgementIndication) Reset() {
	*x = OnuLossOfAcknowledgementIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuLossOfAcknowledgementIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuLossOfAcknowledgementIndication) ProtoMessage() {}

func (x *OnuLossOfAcknowledgementIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuLossOfAcknowledgementIndication.ProtoReflect.Descriptor instead.
func (*OnuLossOfAcknowledgementIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{45}
}

func (x *OnuLossOfAcknowledgementIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuLossOfAcknowledgementIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuLossOfAcknowledgementIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type OnuDifferentialReachExceededIndication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Distance      uint32                 `protobuf:"fixed32,4,opt,name=distance,proto3" json:"distance,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuDifferentialReachExceededIndication) Reset() {
	*x = OnuDifferentialReachExceededIndication{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuDifferentialReachExceededIndication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuDifferentialReachExceededIndication) ProtoMessage() {}

func (x *OnuDifferentialReachExceededIndication) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuDifferentialReachExceededIndication.ProtoReflect.Descriptor instead.
func (*OnuDifferentialReachExceededIndication) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{46}
}

func (x *OnuDifferentialReachExceededIndication) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuDifferentialReachExceededIndication) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuDifferentialReachExceededIndication) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *OnuDifferentialReachExceededIndication) GetDistance() uint32 {
	if x != nil {
		return x.Distance
	}
	return 0
}

type GroupMember struct {
	state         protoimpl.MessageState    `protogen:"open.v1"`
	InterfaceId   uint32                    `protobuf:"varint,1,opt,name=interface_id,json=interfaceId,proto3" json:"interface_id,omitempty"`
	InterfaceType GroupMember_InterfaceType `protobuf:"varint,2,opt,name=interface_type,json=interfaceType,proto3,enum=openolt.GroupMember_InterfaceType" json:"interface_type,omitempty"`
	GemPortId     uint32                    `protobuf:"varint,3,opt,name=gem_port_id,json=gemPortId,proto3" json:"gem_port_id,omitempty"`
	Priority      uint32                    `protobuf:"varint,4,opt,name=priority,proto3" json:"priority,omitempty"` // Priority (and also the ID) of the default fixed queue for the multicast traffic.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupMember) Reset() {
	*x = GroupMember{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupMember) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupMember) ProtoMessage() {}

func (x *GroupMember) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupMember.ProtoReflect.Descriptor instead.
func (*GroupMember) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{47}
}

func (x *GroupMember) GetInterfaceId() uint32 {
	if x != nil {
		return x.InterfaceId
	}
	return 0
}

func (x *GroupMember) GetInterfaceType() GroupMember_InterfaceType {
	if x != nil {
		return x.InterfaceType
	}
	return GroupMember_PON
}

func (x *GroupMember) GetGemPortId() uint32 {
	if x != nil {
		return x.GemPortId
	}
	return 0
}

func (x *GroupMember) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

type Group struct {
	state         protoimpl.MessageState    `protogen:"open.v1"`
	GroupId       uint32                    `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Command       Group_GroupMembersCommand `protobuf:"varint,2,opt,name=command,proto3,enum=openolt.Group_GroupMembersCommand" json:"command,omitempty"`
	Members       []*GroupMember            `protobuf:"bytes,3,rep,name=members,proto3" json:"members,omitempty"`
	Action        *Action                   `protobuf:"bytes,4,opt,name=action,proto3" json:"action,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Group) Reset() {
	*x = Group{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Group) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Group) ProtoMessage() {}

func (x *Group) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Group.ProtoReflect.Descriptor instead.
func (*Group) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{48}
}

func (x *Group) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

func (x *Group) GetCommand() Group_GroupMembersCommand {
	if x != nil {
		return x.Command
	}
	return Group_ADD_MEMBERS
}

func (x *Group) GetMembers() []*GroupMember {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *Group) GetAction() *Action {
	if x != nil {
		return x.Action
	}
	return nil
}

type ValueParam struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Onu           *Onu                     `protobuf:"bytes,1,opt,name=onu,proto3" json:"onu,omitempty"`
	Value         extension.ValueType_Type `protobuf:"varint,2,opt,name=value,proto3,enum=extension.ValueType_Type" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValueParam) Reset() {
	*x = ValueParam{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValueParam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueParam) ProtoMessage() {}

func (x *ValueParam) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueParam.ProtoReflect.Descriptor instead.
func (*ValueParam) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{49}
}

func (x *ValueParam) GetOnu() *Onu {
	if x != nil {
		return x.Onu
	}
	return nil
}

func (x *ValueParam) GetValue() extension.ValueType_Type {
	if x != nil {
		return x.Value
	}
	return extension.ValueType_Type(0)
}

type PonRxPowerData struct {
	state          protoimpl.MessageState                   `protogen:"open.v1"`
	IntfId         uint32                                   `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId          uint32                                   `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status         string                                   `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	FailReason     PonRxPowerData_RssiMeasurementFailReason `protobuf:"varint,4,opt,name=fail_reason,json=failReason,proto3,enum=openolt.PonRxPowerData_RssiMeasurementFailReason" json:"fail_reason,omitempty"`
	RxPowerMeanDbm float64                                  `protobuf:"fixed64,5,opt,name=rx_power_mean_dbm,json=rxPowerMeanDbm,proto3" json:"rx_power_mean_dbm,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *PonRxPowerData) Reset() {
	*x = PonRxPowerData{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PonRxPowerData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PonRxPowerData) ProtoMessage() {}

func (x *PonRxPowerData) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PonRxPowerData.ProtoReflect.Descriptor instead.
func (*PonRxPowerData) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{50}
}

func (x *PonRxPowerData) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *PonRxPowerData) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *PonRxPowerData) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *PonRxPowerData) GetFailReason() PonRxPowerData_RssiMeasurementFailReason {
	if x != nil {
		return x.FailReason
	}
	return PonRxPowerData_FAIL_REASON_NONE
}

func (x *PonRxPowerData) GetRxPowerMeanDbm() float64 {
	if x != nil {
		return x.RxPowerMeanDbm
	}
	return 0
}

type OnuAllocIdStatistics struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intfId,proto3" json:"intfId,omitempty"`
	AllocId       uint32                 `protobuf:"fixed32,2,opt,name=allocId,proto3" json:"allocId,omitempty"`
	RxBytes       uint64                 `protobuf:"fixed64,3,opt,name=rxBytes,proto3" json:"rxBytes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuAllocIdStatistics) Reset() {
	*x = OnuAllocIdStatistics{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuAllocIdStatistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuAllocIdStatistics) ProtoMessage() {}

func (x *OnuAllocIdStatistics) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuAllocIdStatistics.ProtoReflect.Descriptor instead.
func (*OnuAllocIdStatistics) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{51}
}

func (x *OnuAllocIdStatistics) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *OnuAllocIdStatistics) GetAllocId() uint32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *OnuAllocIdStatistics) GetRxBytes() uint64 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

// contains the onu id, state of the onu and the information about the alarms on the onu.
// As of now only few alarms are added, any further information needed can be added to the structure.
type OnuInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OnuId         uint32                 `protobuf:"fixed32,1,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	State         OnuInfo_OnuState       `protobuf:"varint,2,opt,name=state,proto3,enum=openolt.OnuInfo_OnuState" json:"state,omitempty"`
	Losi          AlarmState             `protobuf:"varint,3,opt,name=losi,proto3,enum=openolt.AlarmState" json:"losi,omitempty"`
	Lofi          AlarmState             `protobuf:"varint,4,opt,name=lofi,proto3,enum=openolt.AlarmState" json:"lofi,omitempty"`
	Loami         AlarmState             `protobuf:"varint,5,opt,name=loami,proto3,enum=openolt.AlarmState" json:"loami,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuInfo) Reset() {
	*x = OnuInfo{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuInfo) ProtoMessage() {}

func (x *OnuInfo) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuInfo.ProtoReflect.Descriptor instead.
func (*OnuInfo) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{52}
}

func (x *OnuInfo) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *OnuInfo) GetState() OnuInfo_OnuState {
	if x != nil {
		return x.State
	}
	return OnuInfo_UNKNOWN
}

func (x *OnuInfo) GetLosi() AlarmState {
	if x != nil {
		return x.Losi
	}
	return AlarmState_OFF
}

func (x *OnuInfo) GetLofi() AlarmState {
	if x != nil {
		return x.Lofi
	}
	return AlarmState_OFF
}

func (x *OnuInfo) GetLoami() AlarmState {
	if x != nil {
		return x.Loami
	}
	return AlarmState_OFF
}

// IntfInfo has the interface Id and if there are any alarms active on that interface.
// Any further information needed from the interface object can be added to the structure.
type PonIntfInfo struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	IntfId        uint32                   `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	State         PonIntfInfo_PonIntfState `protobuf:"varint,3,opt,name=state,proto3,enum=openolt.PonIntfInfo_PonIntfState" json:"state,omitempty"`
	Los           AlarmState               `protobuf:"varint,4,opt,name=los,proto3,enum=openolt.AlarmState" json:"los,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PonIntfInfo) Reset() {
	*x = PonIntfInfo{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PonIntfInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PonIntfInfo) ProtoMessage() {}

func (x *PonIntfInfo) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PonIntfInfo.ProtoReflect.Descriptor instead.
func (*PonIntfInfo) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{53}
}

func (x *PonIntfInfo) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *PonIntfInfo) GetState() PonIntfInfo_PonIntfState {
	if x != nil {
		return x.State
	}
	return PonIntfInfo_UNKNOWN
}

func (x *PonIntfInfo) GetLos() AlarmState {
	if x != nil {
		return x.Los
	}
	return AlarmState_OFF
}

// Message used for disabling device by serialnumber, disable at PLOAM
type InterfaceOnuSerialNumberOnuId struct {
	state           protoimpl.MessageState    `protogen:"open.v1"`
	IntfIdSerialNum *InterfaceOnuSerialNumber `protobuf:"bytes,1,opt,name=intf_id_serial_num,json=intfIdSerialNum,proto3" json:"intf_id_serial_num,omitempty"`
	OnuId           uint32                    `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *InterfaceOnuSerialNumberOnuId) Reset() {
	*x = InterfaceOnuSerialNumberOnuId{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InterfaceOnuSerialNumberOnuId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterfaceOnuSerialNumberOnuId) ProtoMessage() {}

func (x *InterfaceOnuSerialNumberOnuId) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterfaceOnuSerialNumberOnuId.ProtoReflect.Descriptor instead.
func (*InterfaceOnuSerialNumberOnuId) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{54}
}

func (x *InterfaceOnuSerialNumberOnuId) GetIntfIdSerialNum() *InterfaceOnuSerialNumber {
	if x != nil {
		return x.IntfIdSerialNum
	}
	return nil
}

func (x *InterfaceOnuSerialNumberOnuId) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

type InterfaceOnuSerialNumber struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	IntfId          uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuSerialNumber *SerialNumber          `protobuf:"bytes,2,opt,name=onu_serial_number,json=onuSerialNumber,proto3" json:"onu_serial_number,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *InterfaceOnuSerialNumber) Reset() {
	*x = InterfaceOnuSerialNumber{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InterfaceOnuSerialNumber) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterfaceOnuSerialNumber) ProtoMessage() {}

func (x *InterfaceOnuSerialNumber) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterfaceOnuSerialNumber.ProtoReflect.Descriptor instead.
func (*InterfaceOnuSerialNumber) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{55}
}

func (x *InterfaceOnuSerialNumber) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *InterfaceOnuSerialNumber) GetOnuSerialNumber() *SerialNumber {
	if x != nil {
		return x.OnuSerialNumber
	}
	return nil
}

type Empty struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Empty) Reset() {
	*x = Empty{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Empty) ProtoMessage() {}

func (x *Empty) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Empty.ProtoReflect.Descriptor instead.
func (*Empty) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{56}
}

type IntfOperIndication_PONResourceRanges struct {
	state         protoimpl.MessageState                       `protogen:"open.v1"`
	Pools         []*IntfOperIndication_PONResourceRanges_Pool `protobuf:"bytes,3,rep,name=pools,proto3" json:"pools,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IntfOperIndication_PONResourceRanges) Reset() {
	*x = IntfOperIndication_PONResourceRanges{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntfOperIndication_PONResourceRanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntfOperIndication_PONResourceRanges) ProtoMessage() {}

func (x *IntfOperIndication_PONResourceRanges) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntfOperIndication_PONResourceRanges.ProtoReflect.Descriptor instead.
func (*IntfOperIndication_PONResourceRanges) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{8, 0}
}

func (x *IntfOperIndication_PONResourceRanges) GetPools() []*IntfOperIndication_PONResourceRanges_Pool {
	if x != nil {
		return x.Pools
	}
	return nil
}

type IntfOperIndication_PONResourceRanges_Pool struct {
	state         protoimpl.MessageState                             `protogen:"open.v1"`
	Type          IntfOperIndication_PONResourceRanges_Pool_PoolType `protobuf:"varint,1,opt,name=type,proto3,enum=openolt.IntfOperIndication_PONResourceRanges_Pool_PoolType" json:"type,omitempty"`
	Start         uint32                                             `protobuf:"fixed32,3,opt,name=start,proto3" json:"start,omitempty"` // lower bound on IDs allocated from this pool
	End           uint32                                             `protobuf:"fixed32,4,opt,name=end,proto3" json:"end,omitempty"`     // upper bound on IDs allocated from this pool
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IntfOperIndication_PONResourceRanges_Pool) Reset() {
	*x = IntfOperIndication_PONResourceRanges_Pool{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntfOperIndication_PONResourceRanges_Pool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntfOperIndication_PONResourceRanges_Pool) ProtoMessage() {}

func (x *IntfOperIndication_PONResourceRanges_Pool) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntfOperIndication_PONResourceRanges_Pool.ProtoReflect.Descriptor instead.
func (*IntfOperIndication_PONResourceRanges_Pool) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{8, 0, 0}
}

func (x *IntfOperIndication_PONResourceRanges_Pool) GetType() IntfOperIndication_PONResourceRanges_Pool_PoolType {
	if x != nil {
		return x.Type
	}
	return IntfOperIndication_PONResourceRanges_Pool_ONU_ID
}

func (x *IntfOperIndication_PONResourceRanges_Pool) GetStart() uint32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *IntfOperIndication_PONResourceRanges_Pool) GetEnd() uint32 {
	if x != nil {
		return x.End
	}
	return 0
}

type DeviceInfo_DeviceResourceRanges struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of 0 or more intf_ids that use the same technology and pools.
	// If 0 intf_ids supplied, it implies ALL interfaces
	IntfIds []uint32 `protobuf:"fixed32,1,rep,packed,name=intf_ids,json=intfIds,proto3" json:"intf_ids,omitempty"`
	// Technology profile for this pool
	Technology    string                                  `protobuf:"bytes,2,opt,name=technology,proto3" json:"technology,omitempty"`
	Pools         []*DeviceInfo_DeviceResourceRanges_Pool `protobuf:"bytes,3,rep,name=pools,proto3" json:"pools,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeviceInfo_DeviceResourceRanges) Reset() {
	*x = DeviceInfo_DeviceResourceRanges{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceInfo_DeviceResourceRanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceInfo_DeviceResourceRanges) ProtoMessage() {}

func (x *DeviceInfo_DeviceResourceRanges) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceInfo_DeviceResourceRanges.ProtoReflect.Descriptor instead.
func (*DeviceInfo_DeviceResourceRanges) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{18, 0}
}

func (x *DeviceInfo_DeviceResourceRanges) GetIntfIds() []uint32 {
	if x != nil {
		return x.IntfIds
	}
	return nil
}

func (x *DeviceInfo_DeviceResourceRanges) GetTechnology() string {
	if x != nil {
		return x.Technology
	}
	return ""
}

func (x *DeviceInfo_DeviceResourceRanges) GetPools() []*DeviceInfo_DeviceResourceRanges_Pool {
	if x != nil {
		return x.Pools
	}
	return nil
}

type DeviceInfo_DeviceResourceRanges_Pool struct {
	state         protoimpl.MessageState                           `protogen:"open.v1"`
	Type          DeviceInfo_DeviceResourceRanges_Pool_PoolType    `protobuf:"varint,1,opt,name=type,proto3,enum=openolt.DeviceInfo_DeviceResourceRanges_Pool_PoolType" json:"type,omitempty"`
	Sharing       DeviceInfo_DeviceResourceRanges_Pool_SharingType `protobuf:"varint,2,opt,name=sharing,proto3,enum=openolt.DeviceInfo_DeviceResourceRanges_Pool_SharingType" json:"sharing,omitempty"`
	Start         uint32                                           `protobuf:"fixed32,3,opt,name=start,proto3" json:"start,omitempty"` // lower bound on IDs allocated from this pool
	End           uint32                                           `protobuf:"fixed32,4,opt,name=end,proto3" json:"end,omitempty"`     // upper bound on IDs allocated from this pool
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeviceInfo_DeviceResourceRanges_Pool) Reset() {
	*x = DeviceInfo_DeviceResourceRanges_Pool{}
	mi := &file_voltha_protos_openolt_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceInfo_DeviceResourceRanges_Pool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceInfo_DeviceResourceRanges_Pool) ProtoMessage() {}

func (x *DeviceInfo_DeviceResourceRanges_Pool) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openolt_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceInfo_DeviceResourceRanges_Pool.ProtoReflect.Descriptor instead.
func (*DeviceInfo_DeviceResourceRanges_Pool) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openolt_proto_rawDescGZIP(), []int{18, 0, 0}
}

func (x *DeviceInfo_DeviceResourceRanges_Pool) GetType() DeviceInfo_DeviceResourceRanges_Pool_PoolType {
	if x != nil {
		return x.Type
	}
	return DeviceInfo_DeviceResourceRanges_Pool_ONU_ID
}

func (x *DeviceInfo_DeviceResourceRanges_Pool) GetSharing() DeviceInfo_DeviceResourceRanges_Pool_SharingType {
	if x != nil {
		return x.Sharing
	}
	return DeviceInfo_DeviceResourceRanges_Pool_DEDICATED_PER_INTF
}

func (x *DeviceInfo_DeviceResourceRanges_Pool) GetStart() uint32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *DeviceInfo_DeviceResourceRanges_Pool) GetEnd() uint32 {
	if x != nil {
		return x.End
	}
	return 0
}

var File_voltha_protos_openolt_proto protoreflect.FileDescriptor

const file_voltha_protos_openolt_proto_rawDesc = "" +
	"\n" +
	"\x1bvoltha_protos/openolt.proto\x12\aopenolt\x1a\x1cgoogle/api/annotations.proto\x1a voltha_protos/tech_profile.proto\x1a\x1evoltha_protos/ext_config.proto\x1a\x1evoltha_protos/extensions.proto\x1a\x1avoltha_protos/common.proto\"\xe0\x05\n" +
	"\n" +
	"Indication\x121\n" +
	"\aolt_ind\x18\x01 \x01(\v2\x16.openolt.OltIndicationH\x00R\x06oltInd\x124\n" +
	"\bintf_ind\x18\x02 \x01(\v2\x17.openolt.IntfIndicationH\x00R\aintfInd\x12A\n" +
	"\rintf_oper_ind\x18\x03 \x01(\v2\x1b.openolt.IntfOperIndicationH\x00R\vintfOperInd\x12>\n" +
	"\fonu_disc_ind\x18\x04 \x01(\v2\x1a.openolt.OnuDiscIndicationH\x00R\n" +
	"onuDiscInd\x121\n" +
	"\aonu_ind\x18\x05 \x01(\v2\x16.openolt.OnuIndicationH\x00R\x06onuInd\x124\n" +
	"\bomci_ind\x18\x06 \x01(\v2\x17.openolt.OmciIndicationH\x00R\aomciInd\x124\n" +
	"\apkt_ind\x18\a \x01(\v2\x19.openolt.PacketIndicationH\x00R\x06pktInd\x127\n" +
	"\n" +
	"port_stats\x18\b \x01(\v2\x16.common.PortStatisticsH\x00R\tportStats\x128\n" +
	"\n" +
	"flow_stats\x18\t \x01(\v2\x17.openolt.FlowStatisticsH\x00R\tflowStats\x127\n" +
	"\talarm_ind\x18\n" +
	" \x01(\v2\x18.openolt.AlarmIndicationH\x00R\balarmInd\x12J\n" +
	"\x10onu_disabled_ind\x18\v \x01(\v2\x1e.openolt.OnuDisabledIndicationH\x00R\x0eonuDisabledInd\x12G\n" +
	"\x0fonu_enabled_ind\x18\f \x01(\v2\x1d.openolt.OnuEnabledIndicationH\x00R\ronuEnabledIndB\x06\n" +
	"\x04data\"\xeb\r\n" +
	"\x0fAlarmIndication\x121\n" +
	"\alos_ind\x18\x01 \x01(\v2\x16.openolt.LosIndicationH\x00R\x06losInd\x12D\n" +
	"\x0edying_gasp_ind\x18\x02 \x01(\v2\x1c.openolt.DyingGaspIndicationH\x00R\fdyingGaspInd\x12A\n" +
	"\ronu_alarm_ind\x18\x03 \x01(\v2\x1b.openolt.OnuAlarmIndicationH\x00R\vonuAlarmInd\x12W\n" +
	"\x14onu_startup_fail_ind\x18\x04 \x01(\v2$.openolt.OnuStartupFailureIndicationH\x00R\x11onuStartupFailInd\x12Z\n" +
	"\x16onu_signal_degrade_ind\x18\x05 \x01(\v2#.openolt.OnuSignalDegradeIndicationH\x00R\x13onuSignalDegradeInd\x12[\n" +
	"\x17onu_drift_of_window_ind\x18\x06 \x01(\v2#.openolt.OnuDriftOfWindowIndicationH\x00R\x13onuDriftOfWindowInd\x12T\n" +
	"\x11onu_loss_omci_ind\x18\a \x01(\v2'.openolt.OnuLossOfOmciChannelIndicationH\x00R\x0eonuLossOmciInd\x12W\n" +
	"\x14onu_signals_fail_ind\x18\b \x01(\v2$.openolt.OnuSignalsFailureIndicationH\x00R\x11onuSignalsFailInd\x12O\n" +
	"\fonu_tiwi_ind\x18\t \x01(\v2+.openolt.OnuTransmissionInterferenceWarningH\x00R\n" +
	"onuTiwiInd\x12`\n" +
	"\x17onu_activation_fail_ind\x18\n" +
	" \x01(\v2'.openolt.OnuActivationFailureIndicationH\x00R\x14onuActivationFailInd\x12`\n" +
	"\x18onu_processing_error_ind\x18\v \x01(\v2%.openolt.OnuProcessingErrorIndicationH\x00R\x15onuProcessingErrorInd\x12e\n" +
	"\x19onu_loss_of_sync_fail_ind\x18\f \x01(\v2*.openolt.OnuLossOfKeySyncFailureIndicationH\x00R\x14onuLossOfSyncFailInd\x12U\n" +
	"\x15onu_itu_pon_stats_ind\x18\r \x01(\v2!.openolt.OnuItuPonStatsIndicationH\x00R\x11onuItuPonStatsInd\x12l\n" +
	"\x1conu_deactivation_failure_ind\x18\x0e \x01(\v2).openolt.OnuDeactivationFailureIndicationH\x00R\x19onuDeactivationFailureInd\x12W\n" +
	"\x15onu_remote_defect_ind\x18\x0f \x01(\v2\".openolt.OnuRemoteDefectIndicationH\x00R\x12onuRemoteDefectInd\x12s\n" +
	"\x1conu_loss_gem_delineation_ind\x18\x10 \x01(\v21.openolt.OnuLossOfGEMChannelDelineationIndicationH\x00R\x18onuLossGemDelineationInd\x12v\n" +
	" onu_physical_equipment_error_ind\x18\x11 \x01(\v2,.openolt.OnuPhysicalEquipmentErrorIndicationH\x00R\x1conuPhysicalEquipmentErrorInd\x12[\n" +
	"\x13onu_loss_of_ack_ind\x18\x12 \x01(\v2+.openolt.OnuLossOfAcknowledgementIndicationH\x00R\x0fonuLossOfAckInd\x12o\n" +
	"\x1bonu_diff_reach_exceeded_ind\x18\x13 \x01(\v2/.openolt.OnuDifferentialReachExceededIndicationH\x00R\x17onuDiffReachExceededIndB\x06\n" +
	"\x04data\".\n" +
	"\rOltIndication\x12\x1d\n" +
	"\n" +
	"oper_state\x18\x01 \x01(\tR\toperState\"H\n" +
	"\x0eIntfIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x1d\n" +
	"\n" +
	"oper_state\x18\x02 \x01(\tR\toperState\"h\n" +
	"\x11OnuDiscIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12:\n" +
	"\rserial_number\x18\x02 \x01(\v2\x15.openolt.SerialNumberR\fserialNumber\"\x93\x04\n" +
	"\rOnuIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x1d\n" +
	"\n" +
	"oper_state\x18\x03 \x01(\tR\toperState\x12\x1f\n" +
	"\vadmin_state\x18\x05 \x01(\tR\n" +
	"adminState\x12:\n" +
	"\rserial_number\x18\x04 \x01(\v2\x15.openolt.SerialNumberR\fserialNumber\x12L\n" +
	"\vfail_reason\x18\x06 \x01(\x0e2+.openolt.OnuIndication.ActivationFailReasonR\n" +
	"failReason\"\x87\x02\n" +
	"\x14ActivationFailReason\x12#\n" +
	"\x1fONU_ACTIVATION_FAIL_REASON_NONE\x10\x00\x12&\n" +
	"\"ONU_ACTIVATION_FAIL_REASON_RANGING\x10\x01\x126\n" +
	"2ONU_ACTIVATION_FAIL_REASON_PASSWORD_AUTHENTICATION\x10\x02\x12\"\n" +
	"\x1eONU_ACTIVATION_FAIL_REASON_LOS\x10\x03\x12!\n" +
	"\x1dONU_ACTIVATION_FAIL_ONU_ALARM\x10\x04\x12#\n" +
	"\x1fONU_ACTIVATION_FAIL_SWITCH_OVER\x10\x05\"\x83\x01\n" +
	"\x15OnuDisabledIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12:\n" +
	"\rserial_number\x18\x04 \x01(\v2\x15.openolt.SerialNumberR\fserialNumber\"\x82\x01\n" +
	"\x14OnuEnabledIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12:\n" +
	"\rserial_number\x18\x04 \x01(\v2\x15.openolt.SerialNumberR\fserialNumber\"\x82\x04\n" +
	"\x12IntfOperIndication\x12\x12\n" +
	"\x04type\x18\x01 \x01(\tR\x04type\x12\x17\n" +
	"\aintf_id\x18\x02 \x01(\aR\x06intfId\x12\x1d\n" +
	"\n" +
	"oper_state\x18\x03 \x01(\tR\toperState\x12\x14\n" +
	"\x05speed\x18\x04 \x01(\aR\x05speed\x12\x1e\n" +
	"\n" +
	"technology\x18\x05 \x01(\tR\n" +
	"technology\x12E\n" +
	"\x06ranges\x18\x06 \x01(\v2-.openolt.IntfOperIndication.PONResourceRangesR\x06ranges\x1a\xa2\x02\n" +
	"\x11PONResourceRanges\x12H\n" +
	"\x05pools\x18\x03 \x03(\v22.openolt.IntfOperIndication.PONResourceRanges.PoolR\x05pools\x1a\xc2\x01\n" +
	"\x04Pool\x12O\n" +
	"\x04type\x18\x01 \x01(\x0e2;.openolt.IntfOperIndication.PONResourceRanges.Pool.PoolTypeR\x04type\x12\x14\n" +
	"\x05start\x18\x03 \x01(\aR\x05start\x12\x10\n" +
	"\x03end\x18\x04 \x01(\aR\x03end\"A\n" +
	"\bPoolType\x12\n" +
	"\n" +
	"\x06ONU_ID\x10\x00\x12\f\n" +
	"\bALLOC_ID\x10\x01\x12\x0e\n" +
	"\n" +
	"GEMPORT_ID\x10\x02\x12\v\n" +
	"\aFLOW_ID\x10\x03\"R\n" +
	"\x0eOmciIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x10\n" +
	"\x03pkt\x18\x03 \x01(\fR\x03pkt\"\xf1\x01\n" +
	"\x10PacketIndication\x12\x1b\n" +
	"\tintf_type\x18\x05 \x01(\tR\bintfType\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\b \x01(\aR\x05onuId\x12\x15\n" +
	"\x06uni_id\x18\t \x01(\aR\x05uniId\x12\x1d\n" +
	"\n" +
	"gemport_id\x18\x02 \x01(\aR\tgemportId\x12\x17\n" +
	"\aflow_id\x18\x03 \x01(\aR\x06flowId\x12\x17\n" +
	"\aport_no\x18\x06 \x01(\aR\x06portNo\x12\x16\n" +
	"\x06cookie\x18\a \x01(\x06R\x06cookie\x12\x10\n" +
	"\x03pkt\x18\x04 \x01(\fR\x03pkt\"A\n" +
	"\tInterface\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x1b\n" +
	"\tintf_type\x18\x02 \x01(\aR\bintfType\"<\n" +
	"\tHeartbeat\x12/\n" +
	"\x13heartbeat_signature\x18\x01 \x01(\aR\x12heartbeatSignature\"\xac\x01\n" +
	"\x03Onu\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12:\n" +
	"\rserial_number\x18\x03 \x01(\v2\x15.openolt.SerialNumberR\fserialNumber\x12\x10\n" +
	"\x03pir\x18\x04 \x01(\aR\x03pir\x12'\n" +
	"\x0fomcc_encryption\x18\x05 \x01(\bR\x0eomccEncryption\"\xb1\x01\n" +
	"\x12OnuLogicalDistance\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x129\n" +
	"\x19logical_onu_distance_zero\x18\x03 \x01(\aR\x16logicalOnuDistanceZero\x120\n" +
	"\x14logical_onu_distance\x18\x04 \x01(\aR\x12logicalOnuDistance\"K\n" +
	"\aOmciMsg\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x10\n" +
	"\x03pkt\x18\x03 \x01(\fR\x03pkt\"\xa0\x01\n" +
	"\tOnuPacket\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x17\n" +
	"\aport_no\x18\x04 \x01(\aR\x06portNo\x12\x1d\n" +
	"\n" +
	"gemport_id\x18\x05 \x01(\aR\tgemportId\x12\x19\n" +
	"\balloc_id\x18\x06 \x01(\aR\aallocId\x12\x10\n" +
	"\x03pkt\x18\x03 \x01(\fR\x03pkt\"9\n" +
	"\fUplinkPacket\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x10\n" +
	"\x03pkt\x18\x02 \x01(\fR\x03pkt\"\xb8\a\n" +
	"\n" +
	"DeviceInfo\x12\x16\n" +
	"\x06vendor\x18\x01 \x01(\tR\x06vendor\x12\x14\n" +
	"\x05model\x18\x02 \x01(\tR\x05model\x12)\n" +
	"\x10hardware_version\x18\x03 \x01(\tR\x0fhardwareVersion\x12)\n" +
	"\x10firmware_version\x18\x04 \x01(\tR\x0ffirmwareVersion\x12\x1b\n" +
	"\tdevice_id\x18\x10 \x01(\tR\bdeviceId\x120\n" +
	"\x14device_serial_number\x18\x11 \x01(\tR\x12deviceSerialNumber\x121\n" +
	"\x14previously_connected\x18\x13 \x01(\bR\x13previouslyConnected\x12\x1b\n" +
	"\tpon_ports\x18\f \x01(\aR\bponPorts\x12\x1b\n" +
	"\tnni_ports\x18\x14 \x01(\aR\bnniPorts\x12@\n" +
	"\x06ranges\x18\x0f \x03(\v2(.openolt.DeviceInfo.DeviceResourceRangesR\x06ranges\x1a\x95\x04\n" +
	"\x14DeviceResourceRanges\x12\x19\n" +
	"\bintf_ids\x18\x01 \x03(\aR\aintfIds\x12\x1e\n" +
	"\n" +
	"technology\x18\x02 \x01(\tR\n" +
	"technology\x12C\n" +
	"\x05pools\x18\x03 \x03(\v2-.openolt.DeviceInfo.DeviceResourceRanges.PoolR\x05pools\x1a\xfc\x02\n" +
	"\x04Pool\x12J\n" +
	"\x04type\x18\x01 \x01(\x0e26.openolt.DeviceInfo.DeviceResourceRanges.Pool.PoolTypeR\x04type\x12S\n" +
	"\asharing\x18\x02 \x01(\x0e29.openolt.DeviceInfo.DeviceResourceRanges.Pool.SharingTypeR\asharing\x12\x14\n" +
	"\x05start\x18\x03 \x01(\aR\x05start\x12\x10\n" +
	"\x03end\x18\x04 \x01(\aR\x03end\"A\n" +
	"\bPoolType\x12\n" +
	"\n" +
	"\x06ONU_ID\x10\x00\x12\f\n" +
	"\bALLOC_ID\x10\x01\x12\x0e\n" +
	"\n" +
	"GEMPORT_ID\x10\x02\x12\v\n" +
	"\aFLOW_ID\x10\x03\"h\n" +
	"\vSharingType\x12\x16\n" +
	"\x12DEDICATED_PER_INTF\x10\x00\x12\x1f\n" +
	"\x1bSHARED_BY_ALL_INTF_ALL_TECH\x10\x01\x12 \n" +
	"\x1cSHARED_BY_ALL_INTF_SAME_TECH\x10\x02J\x04\b\x05\x10\fJ\x04\b\r\x10\x0eJ\x04\b\x0e\x10\x0f\"\x84\x03\n" +
	"\n" +
	"Classifier\x12\x15\n" +
	"\x06o_tpid\x18\x01 \x01(\aR\x05oTpid\x12\x13\n" +
	"\x05o_vid\x18\x02 \x01(\aR\x04oVid\x12\x15\n" +
	"\x06i_tpid\x18\x03 \x01(\aR\x05iTpid\x12\x13\n" +
	"\x05i_vid\x18\x04 \x01(\aR\x04iVid\x12\x17\n" +
	"\ao_pbits\x18\x05 \x01(\aR\x06oPbits\x12\x17\n" +
	"\ai_pbits\x18\x06 \x01(\aR\x06iPbits\x12\x19\n" +
	"\beth_type\x18\a \x01(\aR\aethType\x12\x17\n" +
	"\adst_mac\x18\b \x01(\fR\x06dstMac\x12\x17\n" +
	"\asrc_mac\x18\t \x01(\fR\x06srcMac\x12\x19\n" +
	"\bip_proto\x18\n" +
	" \x01(\aR\aipProto\x12\x15\n" +
	"\x06dst_ip\x18\v \x01(\aR\x05dstIp\x12\x15\n" +
	"\x06src_ip\x18\f \x01(\aR\x05srcIp\x12\x19\n" +
	"\bsrc_port\x18\r \x01(\aR\asrcPort\x12\x19\n" +
	"\bdst_port\x18\x0e \x01(\aR\adstPort\x12 \n" +
	"\fpkt_tag_type\x18\x0f \x01(\tR\n" +
	"pktTagType\"\x85\x03\n" +
	"\tActionCmd\x12\"\n" +
	"\radd_outer_tag\x18\x01 \x01(\bR\vaddOuterTag\x12(\n" +
	"\x10remove_outer_tag\x18\x02 \x01(\bR\x0eremoveOuterTag\x12 \n" +
	"\ftrap_to_host\x18\x03 \x01(\bR\n" +
	"trapToHost\x12,\n" +
	"\x12remark_outer_pbits\x18\x04 \x01(\bR\x10remarkOuterPbits\x12,\n" +
	"\x12remark_inner_pbits\x18\x05 \x01(\bR\x10remarkInnerPbits\x12\"\n" +
	"\radd_inner_tag\x18\x06 \x01(\bR\vaddInnerTag\x12(\n" +
	"\x10remove_inner_tag\x18\a \x01(\bR\x0eremoveInnerTag\x12.\n" +
	"\x13translate_inner_tag\x18\b \x01(\bR\x11translateInnerTag\x12.\n" +
	"\x13translate_outer_tag\x18\t \x01(\bR\x11translateOuterTag\"\xb8\x01\n" +
	"\x06Action\x12$\n" +
	"\x03cmd\x18\x01 \x01(\v2\x12.openolt.ActionCmdR\x03cmd\x12\x13\n" +
	"\x05o_vid\x18\x02 \x01(\aR\x04oVid\x12\x17\n" +
	"\ao_pbits\x18\x03 \x01(\aR\x06oPbits\x12\x15\n" +
	"\x06o_tpid\x18\x04 \x01(\aR\x05oTpid\x12\x13\n" +
	"\x05i_vid\x18\x05 \x01(\aR\x04iVid\x12\x17\n" +
	"\ai_pbits\x18\x06 \x01(\aR\x06iPbits\x12\x15\n" +
	"\x06i_tpid\x18\a \x01(\aR\x05iTpid\"\xc7\x06\n" +
	"\x04Flow\x12$\n" +
	"\x0eaccess_intf_id\x18\x01 \x01(\x0fR\faccessIntfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\x0fR\x05onuId\x12\x15\n" +
	"\x06uni_id\x18\v \x01(\x0fR\x05uniId\x12\x17\n" +
	"\aflow_id\x18\x03 \x01(\x06R\x06flowId\x12*\n" +
	"\x11symmetric_flow_id\x18\x12 \x01(\x06R\x0fsymmetricFlowId\x12\x1b\n" +
	"\tflow_type\x18\x04 \x01(\tR\bflowType\x12\x19\n" +
	"\balloc_id\x18\n" +
	" \x01(\x0fR\aallocId\x12&\n" +
	"\x0fnetwork_intf_id\x18\x05 \x01(\x0fR\rnetworkIntfId\x12\x1d\n" +
	"\n" +
	"gemport_id\x18\x06 \x01(\x0fR\tgemportId\x123\n" +
	"\n" +
	"classifier\x18\a \x01(\v2\x13.openolt.ClassifierR\n" +
	"classifier\x12'\n" +
	"\x06action\x18\b \x01(\v2\x0f.openolt.ActionR\x06action\x12\x1a\n" +
	"\bpriority\x18\t \x01(\x0fR\bpriority\x12\x16\n" +
	"\x06cookie\x18\f \x01(\x06R\x06cookie\x12\x17\n" +
	"\aport_no\x18\r \x01(\aR\x06portNo\x12\x19\n" +
	"\bgroup_id\x18\x0e \x01(\aR\agroupId\x12&\n" +
	"\x0ftech_profile_id\x18\x0f \x01(\aR\rtechProfileId\x12%\n" +
	"\x0ereplicate_flow\x18\x10 \x01(\bR\rreplicateFlow\x12H\n" +
	"\x0fpbit_to_gemport\x18\x11 \x03(\v2 .openolt.Flow.PbitToGemportEntryR\rpbitToGemport\x12E\n" +
	"\x0egemport_to_aes\x18\x13 \x03(\v2\x1f.openolt.Flow.GemportToAesEntryR\fgemportToAes\x1a@\n" +
	"\x12PbitToGemportEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\aR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\aR\x05value:\x028\x01\x1a?\n" +
	"\x11GemportToAesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\aR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\bR\x05value:\x028\x01\"T\n" +
	"\fSerialNumber\x12\x1b\n" +
	"\tvendor_id\x18\x01 \x01(\fR\bvendorId\x12'\n" +
	"\x0fvendor_specific\x18\x02 \x01(\fR\x0evendorSpecific\"\xe6\a\n" +
	"\rOnuStatistics\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12%\n" +
	"\x0epositive_drift\x18\x03 \x01(\x06R\rpositiveDrift\x12%\n" +
	"\x0enegative_drift\x18\x04 \x01(\x06R\rnegativeDrift\x128\n" +
	"\x18delimiter_miss_detection\x18\x05 \x01(\x06R\x16delimiterMissDetection\x12\x1d\n" +
	"\n" +
	"bip_errors\x18\x06 \x01(\x06R\tbipErrors\x12\x1b\n" +
	"\tbip_units\x18\a \x01(\x06R\bbipUnits\x122\n" +
	"\x15fec_corrected_symbols\x18\b \x01(\x06R\x13fecCorrectedSymbols\x126\n" +
	"\x17fec_codewords_corrected\x18\t \x01(\x06R\x15fecCodewordsCorrected\x12>\n" +
	"\x1bfec_codewords_uncorrectable\x18\n" +
	" \x01(\x06R\x19fecCodewordsUncorrectable\x12#\n" +
	"\rfec_codewords\x18\v \x01(\x06R\ffecCodewords\x12.\n" +
	"\x13fec_corrected_units\x18\f \x01(\x06R\x11fecCorrectedUnits\x12&\n" +
	"\x0fxgem_key_errors\x18\r \x01(\x06R\rxgemKeyErrors\x12\x1b\n" +
	"\txgem_loss\x18\x0e \x01(\x06R\bxgemLoss\x12&\n" +
	"\x0frx_ploams_error\x18\x0f \x01(\x06R\rrxPloamsError\x12+\n" +
	"\x12rx_ploams_non_idle\x18\x10 \x01(\x06R\x0frxPloamsNonIdle\x12\x17\n" +
	"\arx_omci\x18\x11 \x01(\x06R\x06rxOmci\x128\n" +
	"\x19rx_omci_packets_crc_error\x18\x12 \x01(\x06R\x15rxOmciPacketsCrcError\x12\x19\n" +
	"\brx_bytes\x18\x13 \x01(\x06R\arxBytes\x12\x1d\n" +
	"\n" +
	"rx_packets\x18\x14 \x01(\x06R\trxPackets\x12\x19\n" +
	"\btx_bytes\x18\x15 \x01(\x06R\atxBytes\x12\x1d\n" +
	"\n" +
	"tx_packets\x18\x16 \x01(\x06R\ttxPackets\x12!\n" +
	"\fber_reported\x18\x17 \x01(\x06R\vberReported\x12\x1f\n" +
	"\vlcdg_errors\x18\x18 \x01(\x06R\n" +
	"lcdgErrors\x12\x1d\n" +
	"\n" +
	"rdi_errors\x18\x19 \x01(\x06R\trdiErrors\x12\x1c\n" +
	"\ttimestamp\x18\x1a \x01(\aR\ttimestamp\"\xdd\x01\n" +
	"\x11GemPortStatistics\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x1d\n" +
	"\n" +
	"gemport_id\x18\x02 \x01(\aR\tgemportId\x12\x1d\n" +
	"\n" +
	"rx_packets\x18\x03 \x01(\x06R\trxPackets\x12\x19\n" +
	"\brx_bytes\x18\x04 \x01(\x06R\arxBytes\x12\x1d\n" +
	"\n" +
	"tx_packets\x18\x05 \x01(\x06R\ttxPackets\x12\x19\n" +
	"\btx_bytes\x18\x06 \x01(\x06R\atxBytes\x12\x1c\n" +
	"\ttimestamp\x18\x1a \x01(\aR\ttimestamp\"\xbb\x01\n" +
	"\x0eFlowStatistics\x12\x17\n" +
	"\aflow_id\x18\x01 \x01(\aR\x06flowId\x12\x19\n" +
	"\brx_bytes\x18\x02 \x01(\x06R\arxBytes\x12\x1d\n" +
	"\n" +
	"rx_packets\x18\x03 \x01(\x06R\trxPackets\x12\x19\n" +
	"\btx_bytes\x18\b \x01(\x06R\atxBytes\x12\x1d\n" +
	"\n" +
	"tx_packets\x18\t \x01(\x06R\ttxPackets\x12\x1c\n" +
	"\ttimestamp\x18\x10 \x01(\aR\ttimestamp\"@\n" +
	"\rLosIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x16\n" +
	"\x06status\x18\x02 \x01(\tR\x06status\"]\n" +
	"\x13DyingGaspIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\"\xa3\x02\n" +
	"\x12OnuAlarmIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x1d\n" +
	"\n" +
	"los_status\x18\x03 \x01(\tR\tlosStatus\x12\x1d\n" +
	"\n" +
	"lob_status\x18\x04 \x01(\tR\tlobStatus\x12(\n" +
	"\x10lopc_miss_status\x18\x05 \x01(\tR\x0elopcMissStatus\x121\n" +
	"\x15lopc_mic_error_status\x18\x06 \x01(\tR\x12lopcMicErrorStatus\x12\x1f\n" +
	"\vlofi_status\x18\a \x01(\tR\n" +
	"lofiStatus\x12!\n" +
	"\floami_status\x18\b \x01(\tR\vloamiStatus\"e\n" +
	"\x1bOnuStartupFailureIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\"\x99\x01\n" +
	"\x1aOnuSignalDegradeIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\x123\n" +
	"\x16inverse_bit_error_rate\x18\x04 \x01(\aR\x13inverseBitErrorRate\"\x93\x01\n" +
	"\x1aOnuDriftOfWindowIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\x12\x14\n" +
	"\x05drift\x18\x04 \x01(\aR\x05drift\x12\x17\n" +
	"\anew_eqd\x18\x05 \x01(\aR\x06newEqd\"h\n" +
	"\x1eOnuLossOfOmciChannelIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\"\x9a\x01\n" +
	"\x1bOnuSignalsFailureIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\x123\n" +
	"\x16inverse_bit_error_rate\x18\x04 \x01(\aR\x13inverseBitErrorRate\"\x82\x01\n" +
	"\"OnuTransmissionInterferenceWarning\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\x12\x14\n" +
	"\x05drift\x18\x04 \x01(\aR\x05drift\"q\n" +
	"\x1eOnuActivationFailureIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x1f\n" +
	"\vfail_reason\x18\x03 \x01(\aR\n" +
	"failReason\"k\n" +
	"!OnuLossOfKeySyncFailureIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\"T\n" +
	"\x12RdiErrorIndication\x12&\n" +
	"\x0frdi_error_count\x18\x01 \x01(\x06R\rrdiErrorCount\x12\x16\n" +
	"\x06status\x18\x02 \x01(\tR\x06status\"\x96\x01\n" +
	"\x18OnuItuPonStatsIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12A\n" +
	"\rrdi_error_ind\x18\x03 \x01(\v2\x1b.openolt.RdiErrorIndicationH\x00R\vrdiErrorIndB\a\n" +
	"\x05stats\"N\n" +
	"\x1cOnuProcessingErrorIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\"j\n" +
	" OnuDeactivationFailureIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\"j\n" +
	"\x19OnuRemoteDefectIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x1d\n" +
	"\n" +
	"rdi_errors\x18\x03 \x01(\x06R\trdiErrors\"\xa1\x01\n" +
	"(OnuLossOfGEMChannelDelineationIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\x12-\n" +
	"\x12delineation_errors\x18\x04 \x01(\aR\x11delineationErrors\"m\n" +
	"#OnuPhysicalEquipmentErrorIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\"l\n" +
	"\"OnuLossOfAcknowledgementIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\"\x8c\x01\n" +
	"&OnuDifferentialReachExceededIndication\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\x12\x1a\n" +
	"\bdistance\x18\x04 \x01(\aR\bdistance\"\xf6\x01\n" +
	"\vGroupMember\x12!\n" +
	"\finterface_id\x18\x01 \x01(\rR\vinterfaceId\x12I\n" +
	"\x0einterface_type\x18\x02 \x01(\x0e2\".openolt.GroupMember.InterfaceTypeR\rinterfaceType\x12\x1e\n" +
	"\vgem_port_id\x18\x03 \x01(\rR\tgemPortId\x12\x1a\n" +
	"\bpriority\x18\x04 \x01(\rR\bpriority\"=\n" +
	"\rInterfaceType\x12\a\n" +
	"\x03PON\x10\x00\x12\x10\n" +
	"\fEPON_1G_PATH\x10\x01\x12\x11\n" +
	"\rEPON_10G_PATH\x10\x02\"\x86\x02\n" +
	"\x05Group\x12\x19\n" +
	"\bgroup_id\x18\x01 \x01(\rR\agroupId\x12<\n" +
	"\acommand\x18\x02 \x01(\x0e2\".openolt.Group.GroupMembersCommandR\acommand\x12.\n" +
	"\amembers\x18\x03 \x03(\v2\x14.openolt.GroupMemberR\amembers\x12'\n" +
	"\x06action\x18\x04 \x01(\v2\x0f.openolt.ActionR\x06action\"K\n" +
	"\x13GroupMembersCommand\x12\x0f\n" +
	"\vADD_MEMBERS\x10\x00\x12\x12\n" +
	"\x0eREMOVE_MEMBERS\x10\x01\x12\x0f\n" +
	"\vSET_MEMBERS\x10\x02\"]\n" +
	"\n" +
	"ValueParam\x12\x1e\n" +
	"\x03onu\x18\x01 \x01(\v2\f.openolt.OnuR\x03onu\x12/\n" +
	"\x05value\x18\x02 \x01(\x0e2\x19.extension.ValueType.TypeR\x05value\"\xc3\x02\n" +
	"\x0ePonRxPowerData\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\x12R\n" +
	"\vfail_reason\x18\x04 \x01(\x0e21.openolt.PonRxPowerData.RssiMeasurementFailReasonR\n" +
	"failReason\x12)\n" +
	"\x11rx_power_mean_dbm\x18\x05 \x01(\x01R\x0erxPowerMeanDbm\"j\n" +
	"\x19RssiMeasurementFailReason\x12\x14\n" +
	"\x10FAIL_REASON_NONE\x10\x00\x12\x1c\n" +
	"\x18FAIL_REASON_NO_DELIMITER\x10\x01\x12\x19\n" +
	"\x15FAIL_REASON_NO_ACCESS\x10\x02\"b\n" +
	"\x14OnuAllocIdStatistics\x12\x16\n" +
	"\x06intfId\x18\x01 \x01(\aR\x06intfId\x12\x18\n" +
	"\aallocId\x18\x02 \x01(\aR\aallocId\x12\x18\n" +
	"\arxBytes\x18\x03 \x01(\x06R\arxBytes\"\xa3\x02\n" +
	"\aOnuInfo\x12\x15\n" +
	"\x06onu_id\x18\x01 \x01(\aR\x05onuId\x12/\n" +
	"\x05state\x18\x02 \x01(\x0e2\x19.openolt.OnuInfo.OnuStateR\x05state\x12'\n" +
	"\x04losi\x18\x03 \x01(\x0e2\x13.openolt.AlarmStateR\x04losi\x12'\n" +
	"\x04lofi\x18\x04 \x01(\x0e2\x13.openolt.AlarmStateR\x04lofi\x12)\n" +
	"\x05loami\x18\x05 \x01(\x0e2\x13.openolt.AlarmStateR\x05loami\"S\n" +
	"\bOnuState\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\x12\n" +
	"\x0eNOT_CONFIGURED\x10\x01\x12\n" +
	"\n" +
	"\x06ACTIVE\x10\x02\x12\f\n" +
	"\bINACTIVE\x10\x03\x12\f\n" +
	"\bDISABLED\x10\x04\"\xe7\x01\n" +
	"\vPonIntfInfo\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x127\n" +
	"\x05state\x18\x03 \x01(\x0e2!.openolt.PonIntfInfo.PonIntfStateR\x05state\x12%\n" +
	"\x03los\x18\x04 \x01(\x0e2\x13.openolt.AlarmStateR\x03los\"_\n" +
	"\fPonIntfState\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\x12\n" +
	"\x0eACTIVE_WORKING\x10\x01\x12\x12\n" +
	"\x0eACTIVE_STANDBY\x10\x02\x12\f\n" +
	"\bINACTIVE\x10\x03\x12\f\n" +
	"\bDISABLED\x10\x04\"\x86\x01\n" +
	"\x1dInterfaceOnuSerialNumberOnuId\x12N\n" +
	"\x12intf_id_serial_num\x18\x01 \x01(\v2!.openolt.InterfaceOnuSerialNumberR\x0fintfIdSerialNum\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\"v\n" +
	"\x18InterfaceOnuSerialNumber\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12A\n" +
	"\x11onu_serial_number\x18\x02 \x01(\v2\x15.openolt.SerialNumberR\x0fonuSerialNumber\"\a\n" +
	"\x05Empty*\x1d\n" +
	"\n" +
	"AlarmState\x12\a\n" +
	"\x03OFF\x10\x00\x12\x06\n" +
	"\x02ON\x10\x012\xa6\x1b\n" +
	"\aOpenolt\x12D\n" +
	"\n" +
	"DisableOlt\x12\x0e.openolt.Empty\x1a\x0e.openolt.Empty\"\x16\x82\xd3\xe4\x93\x02\x10:\x01*\"\v/v1/Disable\x12F\n" +
	"\vReenableOlt\x12\x0e.openolt.Empty\x1a\x0e.openolt.Empty\"\x17\x82\xd3\xe4\x93\x02\x11:\x01*\"\f/v1/Reenable\x12E\n" +
	"\vActivateOnu\x12\f.openolt.Onu\x1a\x0e.openolt.Empty\"\x18\x82\xd3\xe4\x93\x02\x12:\x01*\"\r/v1/EnableOnu\x12H\n" +
	"\rDeactivateOnu\x12\f.openolt.Onu\x1a\x0e.openolt.Empty\"\x19\x82\xd3\xe4\x93\x02\x13:\x01*\"\x0e/v1/DisableOnu\x12C\n" +
	"\tDeleteOnu\x12\f.openolt.Onu\x1a\x0e.openolt.Empty\"\x18\x82\xd3\xe4\x93\x02\x12:\x01*\"\r/v1/DeleteOnu\x12I\n" +
	"\n" +
	"OmciMsgOut\x12\x10.openolt.OmciMsg\x1a\x0e.openolt.Empty\"\x19\x82\xd3\xe4\x93\x02\x13:\x01*\"\x0e/v1/OmciMsgOut\x12O\n" +
	"\fOnuPacketOut\x12\x12.openolt.OnuPacket\x1a\x0e.openolt.Empty\"\x1b\x82\xd3\xe4\x93\x02\x15:\x01*\"\x10/v1/OnuPacketOut\x12X\n" +
	"\x0fUplinkPacketOut\x12\x15.openolt.UplinkPacket\x1a\x0e.openolt.Empty\"\x1e\x82\xd3\xe4\x93\x02\x18:\x01*\"\x13/v1/UplinkPacketOut\x12@\n" +
	"\aFlowAdd\x12\r.openolt.Flow\x1a\x0e.openolt.Empty\"\x16\x82\xd3\xe4\x93\x02\x10:\x01*\"\v/v1/FlowAdd\x12F\n" +
	"\n" +
	"FlowRemove\x12\r.openolt.Flow\x1a\x0e.openolt.Empty\"\x19\x82\xd3\xe4\x93\x02\x13:\x01*\"\x0e/v1/FlowRemove\x12S\n" +
	"\x0eHeartbeatCheck\x12\x0e.openolt.Empty\x1a\x12.openolt.Heartbeat\"\x1d\x82\xd3\xe4\x93\x02\x17:\x01*\"\x12/v1/HeartbeatCheck\x12M\n" +
	"\vEnablePonIf\x12\x12.openolt.Interface\x1a\x0e.openolt.Empty\"\x1a\x82\xd3\xe4\x93\x02\x14:\x01*\"\x0f/v1/EnablePonIf\x12O\n" +
	"\fDisablePonIf\x12\x12.openolt.Interface\x1a\x0e.openolt.Empty\"\x1b\x82\xd3\xe4\x93\x02\x15:\x01*\"\x10/v1/DisablePonIf\x12R\n" +
	"\rGetDeviceInfo\x12\x0e.openolt.Empty\x1a\x13.openolt.DeviceInfo\"\x1c\x82\xd3\xe4\x93\x02\x16:\x01*\"\x11/v1/GetDeviceInfo\x12?\n" +
	"\x06Reboot\x12\x0e.openolt.Empty\x1a\x0e.openolt.Empty\"\x15\x82\xd3\xe4\x93\x02\x0f:\x01*\"\n" +
	"/v1/Reboot\x12U\n" +
	"\x11CollectStatistics\x12\x0e.openolt.Empty\x1a\x0e.openolt.Empty\" \x82\xd3\xe4\x93\x02\x1a:\x01*\"\x15/v1/CollectStatistics\x12Y\n" +
	"\x10GetOnuStatistics\x12\f.openolt.Onu\x1a\x16.openolt.OnuStatistics\"\x1f\x82\xd3\xe4\x93\x02\x19:\x01*\"\x14/v1/GetOnuStatistics\x12k\n" +
	"\x14GetGemPortStatistics\x12\x12.openolt.OnuPacket\x1a\x1a.openolt.GemPortStatistics\"#\x82\xd3\xe4\x93\x02\x1d:\x01*\"\x18/v1/GetGemPortStatistics\x12r\n" +
	"\x17CreateTrafficSchedulers\x12\x1f.tech_profile.TrafficSchedulers\x1a\x0e.openolt.Empty\"&\x82\xd3\xe4\x93\x02 :\x01*\"\x1b/v1/CreateTrafficSchedulers\x12r\n" +
	"\x17RemoveTrafficSchedulers\x12\x1f.tech_profile.TrafficSchedulers\x1a\x0e.openolt.Empty\"&\x82\xd3\xe4\x93\x02 :\x01*\"\x1b/v1/RemoveTrafficSchedulers\x12f\n" +
	"\x13CreateTrafficQueues\x12\x1b.tech_profile.TrafficQueues\x1a\x0e.openolt.Empty\"\"\x82\xd3\xe4\x93\x02\x1c:\x01*\"\x17/v1/CreateTrafficQueues\x12f\n" +
	"\x13RemoveTrafficQueues\x12\x1b.tech_profile.TrafficQueues\x1a\x0e.openolt.Empty\"\"\x82\xd3\xe4\x93\x02\x1c:\x01*\"\x17/v1/RemoveTrafficQueues\x12;\n" +
	"\x10EnableIndication\x12\x0e.openolt.Empty\x1a\x13.openolt.Indication\"\x000\x01\x12]\n" +
	"\x15PerformGroupOperation\x12\x0e.openolt.Group\x1a\x0e.openolt.Empty\"$\x82\xd3\xe4\x93\x02\x1e:\x01*\"\x19/v1/PerformGroupOperation\x12I\n" +
	"\vDeleteGroup\x12\x0e.openolt.Group\x1a\x0e.openolt.Empty\"\x1a\x82\xd3\xe4\x93\x02\x14:\x01*\"\x0f/v1/DeleteGroup\x12W\n" +
	"\vGetExtValue\x12\x13.openolt.ValueParam\x1a\x17.extension.ReturnValues\"\x1a\x82\xd3\xe4\x93\x02\x14:\x01*\"\x0f/v1/GetExtValue\x12]\n" +
	"\x11OnuItuPonAlarmSet\x12\x16.config.OnuItuPonAlarm\x1a\x0e.openolt.Empty\" \x82\xd3\xe4\x93\x02\x1a:\x01*\"\x15/v1/OnuItuPonAlarmSet\x12p\n" +
	"\x19GetLogicalOnuDistanceZero\x12\f.openolt.Onu\x1a\x1b.openolt.OnuLogicalDistance\"(\x82\xd3\xe4\x93\x02\":\x01*\"\x1d/v1/GetLogicalOnuDistanceZero\x12h\n" +
	"\x15GetLogicalOnuDistance\x12\f.openolt.Onu\x1a\x1b.openolt.OnuLogicalDistance\"$\x82\xd3\xe4\x93\x02\x1e:\x01*\"\x19/v1/GetLogicalOnuDistance\x12T\n" +
	"\rGetPonRxPower\x12\f.openolt.Onu\x1a\x17.openolt.PonRxPowerData\"\x1c\x82\xd3\xe4\x93\x02\x16:\x01*\"\x11/v1/GetPonRxPower\x12G\n" +
	"\n" +
	"GetOnuInfo\x12\f.openolt.Onu\x1a\x10.openolt.OnuInfo\"\x19\x82\xd3\xe4\x93\x02\x13:\x01*\"\x0e/v1/GetOnuInfo\x12`\n" +
	"\x13GetPonInterfaceInfo\x12\x12.openolt.Interface\x1a\x14.openolt.PonIntfInfo\"\x1f\x82\xd3\xe4\x93\x02\x19:\x01*\"\x14/v1/GetInterfaceInfo\x12n\n" +
	"\x14GetAllocIdStatistics\x12\x12.openolt.OnuPacket\x1a\x1d.openolt.OnuAllocIdStatistics\"#\x82\xd3\xe4\x93\x02\x1d:\x01*\"\x18/v1/GetAllocIdStatistics\x12g\n" +
	"\x14GetPonPortStatistics\x12\x12.openolt.Interface\x1a\x16.common.PortStatistics\"#\x82\xd3\xe4\x93\x02\x1d:\x01*\"\x18/v1/GetPonPortStatistics\x12g\n" +
	"\x14GetNniPortStatistics\x12\x12.openolt.Interface\x1a\x16.common.PortStatistics\"#\x82\xd3\xe4\x93\x02\x1d:\x01*\"\x18/v1/GetNniPortStatistics\x12\\\n" +
	"\n" +
	"DisableOnu\x12&.openolt.InterfaceOnuSerialNumberOnuId\x1a\x0e.openolt.Empty\"\x16\x82\xd3\xe4\x93\x02\x10\"\x0e/v1/DisableOnu\x12Z\n" +
	"\tEnableOnu\x12&.openolt.InterfaceOnuSerialNumberOnuId\x1a\x0e.openolt.Empty\"\x15\x82\xd3\xe4\x93\x02\x0f\"\r/v1/EnableOnu\x12o\n" +
	"\x16DisableOnuSerialNumber\x12!.openolt.InterfaceOnuSerialNumber\x1a\x0e.openolt.Empty\"\"\x82\xd3\xe4\x93\x02\x1c\"\x1a/v1/DisableOnuSerialNumber\x12m\n" +
	"\x15EnableOnuSerialNumber\x12!.openolt.InterfaceOnuSerialNumber\x1a\x0e.openolt.Empty\"!\x82\xd3\xe4\x93\x02\x1b\"\x19/v1/EnableOnuSerialNumberB]\n" +
	"\x1borg.opencord.voltha.openoltB\rVolthaOpenOLTZ/github.com/opencord/voltha-protos/v5/go/openoltb\x06proto3"

var (
	file_voltha_protos_openolt_proto_rawDescOnce sync.Once
	file_voltha_protos_openolt_proto_rawDescData []byte
)

func file_voltha_protos_openolt_proto_rawDescGZIP() []byte {
	file_voltha_protos_openolt_proto_rawDescOnce.Do(func() {
		file_voltha_protos_openolt_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_voltha_protos_openolt_proto_rawDesc), len(file_voltha_protos_openolt_proto_rawDesc)))
	})
	return file_voltha_protos_openolt_proto_rawDescData
}

var file_voltha_protos_openolt_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_voltha_protos_openolt_proto_msgTypes = make([]protoimpl.MessageInfo, 63)
var file_voltha_protos_openolt_proto_goTypes = []any{
	(AlarmState)(0),                                         // 0: openolt.AlarmState
	(OnuIndication_ActivationFailReason)(0),                 // 1: openolt.OnuIndication.ActivationFailReason
	(IntfOperIndication_PONResourceRanges_Pool_PoolType)(0), // 2: openolt.IntfOperIndication.PONResourceRanges.Pool.PoolType
	(DeviceInfo_DeviceResourceRanges_Pool_PoolType)(0),      // 3: openolt.DeviceInfo.DeviceResourceRanges.Pool.PoolType
	(DeviceInfo_DeviceResourceRanges_Pool_SharingType)(0),   // 4: openolt.DeviceInfo.DeviceResourceRanges.Pool.SharingType
	(GroupMember_InterfaceType)(0),                          // 5: openolt.GroupMember.InterfaceType
	(Group_GroupMembersCommand)(0),                          // 6: openolt.Group.GroupMembersCommand
	(PonRxPowerData_RssiMeasurementFailReason)(0),           // 7: openolt.PonRxPowerData.RssiMeasurementFailReason
	(OnuInfo_OnuState)(0),                                   // 8: openolt.OnuInfo.OnuState
	(PonIntfInfo_PonIntfState)(0),                           // 9: openolt.PonIntfInfo.PonIntfState
	(*Indication)(nil),                                      // 10: openolt.Indication
	(*AlarmIndication)(nil),                                 // 11: openolt.AlarmIndication
	(*OltIndication)(nil),                                   // 12: openolt.OltIndication
	(*IntfIndication)(nil),                                  // 13: openolt.IntfIndication
	(*OnuDiscIndication)(nil),                               // 14: openolt.OnuDiscIndication
	(*OnuIndication)(nil),                                   // 15: openolt.OnuIndication
	(*OnuDisabledIndication)(nil),                           // 16: openolt.OnuDisabledIndication
	(*OnuEnabledIndication)(nil),                            // 17: openolt.OnuEnabledIndication
	(*IntfOperIndication)(nil),                              // 18: openolt.IntfOperIndication
	(*OmciIndication)(nil),                                  // 19: openolt.OmciIndication
	(*PacketIndication)(nil),                                // 20: openolt.PacketIndication
	(*Interface)(nil),                                       // 21: openolt.Interface
	(*Heartbeat)(nil),                                       // 22: openolt.Heartbeat
	(*Onu)(nil),                                             // 23: openolt.Onu
	(*OnuLogicalDistance)(nil),                              // 24: openolt.OnuLogicalDistance
	(*OmciMsg)(nil),                                         // 25: openolt.OmciMsg
	(*OnuPacket)(nil),                                       // 26: openolt.OnuPacket
	(*UplinkPacket)(nil),                                    // 27: openolt.UplinkPacket
	(*DeviceInfo)(nil),                                      // 28: openolt.DeviceInfo
	(*Classifier)(nil),                                      // 29: openolt.Classifier
	(*ActionCmd)(nil),                                       // 30: openolt.ActionCmd
	(*Action)(nil),                                          // 31: openolt.Action
	(*Flow)(nil),                                            // 32: openolt.Flow
	(*SerialNumber)(nil),                                    // 33: openolt.SerialNumber
	(*OnuStatistics)(nil),                                   // 34: openolt.OnuStatistics
	(*GemPortStatistics)(nil),                               // 35: openolt.GemPortStatistics
	(*FlowStatistics)(nil),                                  // 36: openolt.FlowStatistics
	(*LosIndication)(nil),                                   // 37: openolt.LosIndication
	(*DyingGaspIndication)(nil),                             // 38: openolt.DyingGaspIndication
	(*OnuAlarmIndication)(nil),                              // 39: openolt.OnuAlarmIndication
	(*OnuStartupFailureIndication)(nil),                     // 40: openolt.OnuStartupFailureIndication
	(*OnuSignalDegradeIndication)(nil),                      // 41: openolt.OnuSignalDegradeIndication
	(*OnuDriftOfWindowIndication)(nil),                      // 42: openolt.OnuDriftOfWindowIndication
	(*OnuLossOfOmciChannelIndication)(nil),                  // 43: openolt.OnuLossOfOmciChannelIndication
	(*OnuSignalsFailureIndication)(nil),                     // 44: openolt.OnuSignalsFailureIndication
	(*OnuTransmissionInterferenceWarning)(nil),              // 45: openolt.OnuTransmissionInterferenceWarning
	(*OnuActivationFailureIndication)(nil),                  // 46: openolt.OnuActivationFailureIndication
	(*OnuLossOfKeySyncFailureIndication)(nil),               // 47: openolt.OnuLossOfKeySyncFailureIndication
	(*RdiErrorIndication)(nil),                              // 48: openolt.RdiErrorIndication
	(*OnuItuPonStatsIndication)(nil),                        // 49: openolt.OnuItuPonStatsIndication
	(*OnuProcessingErrorIndication)(nil),                    // 50: openolt.OnuProcessingErrorIndication
	(*OnuDeactivationFailureIndication)(nil),                // 51: openolt.OnuDeactivationFailureIndication
	(*OnuRemoteDefectIndication)(nil),                       // 52: openolt.OnuRemoteDefectIndication
	(*OnuLossOfGEMChannelDelineationIndication)(nil),        // 53: openolt.OnuLossOfGEMChannelDelineationIndication
	(*OnuPhysicalEquipmentErrorIndication)(nil),             // 54: openolt.OnuPhysicalEquipmentErrorIndication
	(*OnuLossOfAcknowledgementIndication)(nil),              // 55: openolt.OnuLossOfAcknowledgementIndication
	(*OnuDifferentialReachExceededIndication)(nil),          // 56: openolt.OnuDifferentialReachExceededIndication
	(*GroupMember)(nil),                                     // 57: openolt.GroupMember
	(*Group)(nil),                                           // 58: openolt.Group
	(*ValueParam)(nil),                                      // 59: openolt.ValueParam
	(*PonRxPowerData)(nil),                                  // 60: openolt.PonRxPowerData
	(*OnuAllocIdStatistics)(nil),                            // 61: openolt.OnuAllocIdStatistics
	(*OnuInfo)(nil),                                         // 62: openolt.OnuInfo
	(*PonIntfInfo)(nil),                                     // 63: openolt.PonIntfInfo
	(*InterfaceOnuSerialNumberOnuId)(nil),                   // 64: openolt.InterfaceOnuSerialNumberOnuId
	(*InterfaceOnuSerialNumber)(nil),                        // 65: openolt.InterfaceOnuSerialNumber
	(*Empty)(nil),                                           // 66: openolt.Empty
	(*IntfOperIndication_PONResourceRanges)(nil),            // 67: openolt.IntfOperIndication.PONResourceRanges
	(*IntfOperIndication_PONResourceRanges_Pool)(nil),       // 68: openolt.IntfOperIndication.PONResourceRanges.Pool
	(*DeviceInfo_DeviceResourceRanges)(nil),                 // 69: openolt.DeviceInfo.DeviceResourceRanges
	(*DeviceInfo_DeviceResourceRanges_Pool)(nil),            // 70: openolt.DeviceInfo.DeviceResourceRanges.Pool
	nil,                                    // 71: openolt.Flow.PbitToGemportEntry
	nil,                                    // 72: openolt.Flow.GemportToAesEntry
	(*common.PortStatistics)(nil),          // 73: common.PortStatistics
	(extension.ValueType_Type)(0),          // 74: extension.ValueType.Type
	(*tech_profile.TrafficSchedulers)(nil), // 75: tech_profile.TrafficSchedulers
	(*tech_profile.TrafficQueues)(nil),     // 76: tech_profile.TrafficQueues
	(*config.OnuItuPonAlarm)(nil),          // 77: config.OnuItuPonAlarm
	(*extension.ReturnValues)(nil),         // 78: extension.ReturnValues
}
var file_voltha_protos_openolt_proto_depIdxs = []int32{
	12,  // 0: openolt.Indication.olt_ind:type_name -> openolt.OltIndication
	13,  // 1: openolt.Indication.intf_ind:type_name -> openolt.IntfIndication
	18,  // 2: openolt.Indication.intf_oper_ind:type_name -> openolt.IntfOperIndication
	14,  // 3: openolt.Indication.onu_disc_ind:type_name -> openolt.OnuDiscIndication
	15,  // 4: openolt.Indication.onu_ind:type_name -> openolt.OnuIndication
	19,  // 5: openolt.Indication.omci_ind:type_name -> openolt.OmciIndication
	20,  // 6: openolt.Indication.pkt_ind:type_name -> openolt.PacketIndication
	73,  // 7: openolt.Indication.port_stats:type_name -> common.PortStatistics
	36,  // 8: openolt.Indication.flow_stats:type_name -> openolt.FlowStatistics
	11,  // 9: openolt.Indication.alarm_ind:type_name -> openolt.AlarmIndication
	16,  // 10: openolt.Indication.onu_disabled_ind:type_name -> openolt.OnuDisabledIndication
	17,  // 11: openolt.Indication.onu_enabled_ind:type_name -> openolt.OnuEnabledIndication
	37,  // 12: openolt.AlarmIndication.los_ind:type_name -> openolt.LosIndication
	38,  // 13: openolt.AlarmIndication.dying_gasp_ind:type_name -> openolt.DyingGaspIndication
	39,  // 14: openolt.AlarmIndication.onu_alarm_ind:type_name -> openolt.OnuAlarmIndication
	40,  // 15: openolt.AlarmIndication.onu_startup_fail_ind:type_name -> openolt.OnuStartupFailureIndication
	41,  // 16: openolt.AlarmIndication.onu_signal_degrade_ind:type_name -> openolt.OnuSignalDegradeIndication
	42,  // 17: openolt.AlarmIndication.onu_drift_of_window_ind:type_name -> openolt.OnuDriftOfWindowIndication
	43,  // 18: openolt.AlarmIndication.onu_loss_omci_ind:type_name -> openolt.OnuLossOfOmciChannelIndication
	44,  // 19: openolt.AlarmIndication.onu_signals_fail_ind:type_name -> openolt.OnuSignalsFailureIndication
	45,  // 20: openolt.AlarmIndication.onu_tiwi_ind:type_name -> openolt.OnuTransmissionInterferenceWarning
	46,  // 21: openolt.AlarmIndication.onu_activation_fail_ind:type_name -> openolt.OnuActivationFailureIndication
	50,  // 22: openolt.AlarmIndication.onu_processing_error_ind:type_name -> openolt.OnuProcessingErrorIndication
	47,  // 23: openolt.AlarmIndication.onu_loss_of_sync_fail_ind:type_name -> openolt.OnuLossOfKeySyncFailureIndication
	49,  // 24: openolt.AlarmIndication.onu_itu_pon_stats_ind:type_name -> openolt.OnuItuPonStatsIndication
	51,  // 25: openolt.AlarmIndication.onu_deactivation_failure_ind:type_name -> openolt.OnuDeactivationFailureIndication
	52,  // 26: openolt.AlarmIndication.onu_remote_defect_ind:type_name -> openolt.OnuRemoteDefectIndication
	53,  // 27: openolt.AlarmIndication.onu_loss_gem_delineation_ind:type_name -> openolt.OnuLossOfGEMChannelDelineationIndication
	54,  // 28: openolt.AlarmIndication.onu_physical_equipment_error_ind:type_name -> openolt.OnuPhysicalEquipmentErrorIndication
	55,  // 29: openolt.AlarmIndication.onu_loss_of_ack_ind:type_name -> openolt.OnuLossOfAcknowledgementIndication
	56,  // 30: openolt.AlarmIndication.onu_diff_reach_exceeded_ind:type_name -> openolt.OnuDifferentialReachExceededIndication
	33,  // 31: openolt.OnuDiscIndication.serial_number:type_name -> openolt.SerialNumber
	33,  // 32: openolt.OnuIndication.serial_number:type_name -> openolt.SerialNumber
	1,   // 33: openolt.OnuIndication.fail_reason:type_name -> openolt.OnuIndication.ActivationFailReason
	33,  // 34: openolt.OnuDisabledIndication.serial_number:type_name -> openolt.SerialNumber
	33,  // 35: openolt.OnuEnabledIndication.serial_number:type_name -> openolt.SerialNumber
	67,  // 36: openolt.IntfOperIndication.ranges:type_name -> openolt.IntfOperIndication.PONResourceRanges
	33,  // 37: openolt.Onu.serial_number:type_name -> openolt.SerialNumber
	69,  // 38: openolt.DeviceInfo.ranges:type_name -> openolt.DeviceInfo.DeviceResourceRanges
	30,  // 39: openolt.Action.cmd:type_name -> openolt.ActionCmd
	29,  // 40: openolt.Flow.classifier:type_name -> openolt.Classifier
	31,  // 41: openolt.Flow.action:type_name -> openolt.Action
	71,  // 42: openolt.Flow.pbit_to_gemport:type_name -> openolt.Flow.PbitToGemportEntry
	72,  // 43: openolt.Flow.gemport_to_aes:type_name -> openolt.Flow.GemportToAesEntry
	48,  // 44: openolt.OnuItuPonStatsIndication.rdi_error_ind:type_name -> openolt.RdiErrorIndication
	5,   // 45: openolt.GroupMember.interface_type:type_name -> openolt.GroupMember.InterfaceType
	6,   // 46: openolt.Group.command:type_name -> openolt.Group.GroupMembersCommand
	57,  // 47: openolt.Group.members:type_name -> openolt.GroupMember
	31,  // 48: openolt.Group.action:type_name -> openolt.Action
	23,  // 49: openolt.ValueParam.onu:type_name -> openolt.Onu
	74,  // 50: openolt.ValueParam.value:type_name -> extension.ValueType.Type
	7,   // 51: openolt.PonRxPowerData.fail_reason:type_name -> openolt.PonRxPowerData.RssiMeasurementFailReason
	8,   // 52: openolt.OnuInfo.state:type_name -> openolt.OnuInfo.OnuState
	0,   // 53: openolt.OnuInfo.losi:type_name -> openolt.AlarmState
	0,   // 54: openolt.OnuInfo.lofi:type_name -> openolt.AlarmState
	0,   // 55: openolt.OnuInfo.loami:type_name -> openolt.AlarmState
	9,   // 56: openolt.PonIntfInfo.state:type_name -> openolt.PonIntfInfo.PonIntfState
	0,   // 57: openolt.PonIntfInfo.los:type_name -> openolt.AlarmState
	65,  // 58: openolt.InterfaceOnuSerialNumberOnuId.intf_id_serial_num:type_name -> openolt.InterfaceOnuSerialNumber
	33,  // 59: openolt.InterfaceOnuSerialNumber.onu_serial_number:type_name -> openolt.SerialNumber
	68,  // 60: openolt.IntfOperIndication.PONResourceRanges.pools:type_name -> openolt.IntfOperIndication.PONResourceRanges.Pool
	2,   // 61: openolt.IntfOperIndication.PONResourceRanges.Pool.type:type_name -> openolt.IntfOperIndication.PONResourceRanges.Pool.PoolType
	70,  // 62: openolt.DeviceInfo.DeviceResourceRanges.pools:type_name -> openolt.DeviceInfo.DeviceResourceRanges.Pool
	3,   // 63: openolt.DeviceInfo.DeviceResourceRanges.Pool.type:type_name -> openolt.DeviceInfo.DeviceResourceRanges.Pool.PoolType
	4,   // 64: openolt.DeviceInfo.DeviceResourceRanges.Pool.sharing:type_name -> openolt.DeviceInfo.DeviceResourceRanges.Pool.SharingType
	66,  // 65: openolt.Openolt.DisableOlt:input_type -> openolt.Empty
	66,  // 66: openolt.Openolt.ReenableOlt:input_type -> openolt.Empty
	23,  // 67: openolt.Openolt.ActivateOnu:input_type -> openolt.Onu
	23,  // 68: openolt.Openolt.DeactivateOnu:input_type -> openolt.Onu
	23,  // 69: openolt.Openolt.DeleteOnu:input_type -> openolt.Onu
	25,  // 70: openolt.Openolt.OmciMsgOut:input_type -> openolt.OmciMsg
	26,  // 71: openolt.Openolt.OnuPacketOut:input_type -> openolt.OnuPacket
	27,  // 72: openolt.Openolt.UplinkPacketOut:input_type -> openolt.UplinkPacket
	32,  // 73: openolt.Openolt.FlowAdd:input_type -> openolt.Flow
	32,  // 74: openolt.Openolt.FlowRemove:input_type -> openolt.Flow
	66,  // 75: openolt.Openolt.HeartbeatCheck:input_type -> openolt.Empty
	21,  // 76: openolt.Openolt.EnablePonIf:input_type -> openolt.Interface
	21,  // 77: openolt.Openolt.DisablePonIf:input_type -> openolt.Interface
	66,  // 78: openolt.Openolt.GetDeviceInfo:input_type -> openolt.Empty
	66,  // 79: openolt.Openolt.Reboot:input_type -> openolt.Empty
	66,  // 80: openolt.Openolt.CollectStatistics:input_type -> openolt.Empty
	23,  // 81: openolt.Openolt.GetOnuStatistics:input_type -> openolt.Onu
	26,  // 82: openolt.Openolt.GetGemPortStatistics:input_type -> openolt.OnuPacket
	75,  // 83: openolt.Openolt.CreateTrafficSchedulers:input_type -> tech_profile.TrafficSchedulers
	75,  // 84: openolt.Openolt.RemoveTrafficSchedulers:input_type -> tech_profile.TrafficSchedulers
	76,  // 85: openolt.Openolt.CreateTrafficQueues:input_type -> tech_profile.TrafficQueues
	76,  // 86: openolt.Openolt.RemoveTrafficQueues:input_type -> tech_profile.TrafficQueues
	66,  // 87: openolt.Openolt.EnableIndication:input_type -> openolt.Empty
	58,  // 88: openolt.Openolt.PerformGroupOperation:input_type -> openolt.Group
	58,  // 89: openolt.Openolt.DeleteGroup:input_type -> openolt.Group
	59,  // 90: openolt.Openolt.GetExtValue:input_type -> openolt.ValueParam
	77,  // 91: openolt.Openolt.OnuItuPonAlarmSet:input_type -> config.OnuItuPonAlarm
	23,  // 92: openolt.Openolt.GetLogicalOnuDistanceZero:input_type -> openolt.Onu
	23,  // 93: openolt.Openolt.GetLogicalOnuDistance:input_type -> openolt.Onu
	23,  // 94: openolt.Openolt.GetPonRxPower:input_type -> openolt.Onu
	23,  // 95: openolt.Openolt.GetOnuInfo:input_type -> openolt.Onu
	21,  // 96: openolt.Openolt.GetPonInterfaceInfo:input_type -> openolt.Interface
	26,  // 97: openolt.Openolt.GetAllocIdStatistics:input_type -> openolt.OnuPacket
	21,  // 98: openolt.Openolt.GetPonPortStatistics:input_type -> openolt.Interface
	21,  // 99: openolt.Openolt.GetNniPortStatistics:input_type -> openolt.Interface
	64,  // 100: openolt.Openolt.DisableOnu:input_type -> openolt.InterfaceOnuSerialNumberOnuId
	64,  // 101: openolt.Openolt.EnableOnu:input_type -> openolt.InterfaceOnuSerialNumberOnuId
	65,  // 102: openolt.Openolt.DisableOnuSerialNumber:input_type -> openolt.InterfaceOnuSerialNumber
	65,  // 103: openolt.Openolt.EnableOnuSerialNumber:input_type -> openolt.InterfaceOnuSerialNumber
	66,  // 104: openolt.Openolt.DisableOlt:output_type -> openolt.Empty
	66,  // 105: openolt.Openolt.ReenableOlt:output_type -> openolt.Empty
	66,  // 106: openolt.Openolt.ActivateOnu:output_type -> openolt.Empty
	66,  // 107: openolt.Openolt.DeactivateOnu:output_type -> openolt.Empty
	66,  // 108: openolt.Openolt.DeleteOnu:output_type -> openolt.Empty
	66,  // 109: openolt.Openolt.OmciMsgOut:output_type -> openolt.Empty
	66,  // 110: openolt.Openolt.OnuPacketOut:output_type -> openolt.Empty
	66,  // 111: openolt.Openolt.UplinkPacketOut:output_type -> openolt.Empty
	66,  // 112: openolt.Openolt.FlowAdd:output_type -> openolt.Empty
	66,  // 113: openolt.Openolt.FlowRemove:output_type -> openolt.Empty
	22,  // 114: openolt.Openolt.HeartbeatCheck:output_type -> openolt.Heartbeat
	66,  // 115: openolt.Openolt.EnablePonIf:output_type -> openolt.Empty
	66,  // 116: openolt.Openolt.DisablePonIf:output_type -> openolt.Empty
	28,  // 117: openolt.Openolt.GetDeviceInfo:output_type -> openolt.DeviceInfo
	66,  // 118: openolt.Openolt.Reboot:output_type -> openolt.Empty
	66,  // 119: openolt.Openolt.CollectStatistics:output_type -> openolt.Empty
	34,  // 120: openolt.Openolt.GetOnuStatistics:output_type -> openolt.OnuStatistics
	35,  // 121: openolt.Openolt.GetGemPortStatistics:output_type -> openolt.GemPortStatistics
	66,  // 122: openolt.Openolt.CreateTrafficSchedulers:output_type -> openolt.Empty
	66,  // 123: openolt.Openolt.RemoveTrafficSchedulers:output_type -> openolt.Empty
	66,  // 124: openolt.Openolt.CreateTrafficQueues:output_type -> openolt.Empty
	66,  // 125: openolt.Openolt.RemoveTrafficQueues:output_type -> openolt.Empty
	10,  // 126: openolt.Openolt.EnableIndication:output_type -> openolt.Indication
	66,  // 127: openolt.Openolt.PerformGroupOperation:output_type -> openolt.Empty
	66,  // 128: openolt.Openolt.DeleteGroup:output_type -> openolt.Empty
	78,  // 129: openolt.Openolt.GetExtValue:output_type -> extension.ReturnValues
	66,  // 130: openolt.Openolt.OnuItuPonAlarmSet:output_type -> openolt.Empty
	24,  // 131: openolt.Openolt.GetLogicalOnuDistanceZero:output_type -> openolt.OnuLogicalDistance
	24,  // 132: openolt.Openolt.GetLogicalOnuDistance:output_type -> openolt.OnuLogicalDistance
	60,  // 133: openolt.Openolt.GetPonRxPower:output_type -> openolt.PonRxPowerData
	62,  // 134: openolt.Openolt.GetOnuInfo:output_type -> openolt.OnuInfo
	63,  // 135: openolt.Openolt.GetPonInterfaceInfo:output_type -> openolt.PonIntfInfo
	61,  // 136: openolt.Openolt.GetAllocIdStatistics:output_type -> openolt.OnuAllocIdStatistics
	73,  // 137: openolt.Openolt.GetPonPortStatistics:output_type -> common.PortStatistics
	73,  // 138: openolt.Openolt.GetNniPortStatistics:output_type -> common.PortStatistics
	66,  // 139: openolt.Openolt.DisableOnu:output_type -> openolt.Empty
	66,  // 140: openolt.Openolt.EnableOnu:output_type -> openolt.Empty
	66,  // 141: openolt.Openolt.DisableOnuSerialNumber:output_type -> openolt.Empty
	66,  // 142: openolt.Openolt.EnableOnuSerialNumber:output_type -> openolt.Empty
	104, // [104:143] is the sub-list for method output_type
	65,  // [65:104] is the sub-list for method input_type
	65,  // [65:65] is the sub-list for extension type_name
	65,  // [65:65] is the sub-list for extension extendee
	0,   // [0:65] is the sub-list for field type_name
}

func init() { file_voltha_protos_openolt_proto_init() }
func file_voltha_protos_openolt_proto_init() {
	if File_voltha_protos_openolt_proto != nil {
		return
	}
	file_voltha_protos_openolt_proto_msgTypes[0].OneofWrappers = []any{
		(*Indication_OltInd)(nil),
		(*Indication_IntfInd)(nil),
		(*Indication_IntfOperInd)(nil),
		(*Indication_OnuDiscInd)(nil),
		(*Indication_OnuInd)(nil),
		(*Indication_OmciInd)(nil),
		(*Indication_PktInd)(nil),
		(*Indication_PortStats)(nil),
		(*Indication_FlowStats)(nil),
		(*Indication_AlarmInd)(nil),
		(*Indication_OnuDisabledInd)(nil),
		(*Indication_OnuEnabledInd)(nil),
	}
	file_voltha_protos_openolt_proto_msgTypes[1].OneofWrappers = []any{
		(*AlarmIndication_LosInd)(nil),
		(*AlarmIndication_DyingGaspInd)(nil),
		(*AlarmIndication_OnuAlarmInd)(nil),
		(*AlarmIndication_OnuStartupFailInd)(nil),
		(*AlarmIndication_OnuSignalDegradeInd)(nil),
		(*AlarmIndication_OnuDriftOfWindowInd)(nil),
		(*AlarmIndication_OnuLossOmciInd)(nil),
		(*AlarmIndication_OnuSignalsFailInd)(nil),
		(*AlarmIndication_OnuTiwiInd)(nil),
		(*AlarmIndication_OnuActivationFailInd)(nil),
		(*AlarmIndication_OnuProcessingErrorInd)(nil),
		(*AlarmIndication_OnuLossOfSyncFailInd)(nil),
		(*AlarmIndication_OnuItuPonStatsInd)(nil),
		(*AlarmIndication_OnuDeactivationFailureInd)(nil),
		(*AlarmIndication_OnuRemoteDefectInd)(nil),
		(*AlarmIndication_OnuLossGemDelineationInd)(nil),
		(*AlarmIndication_OnuPhysicalEquipmentErrorInd)(nil),
		(*AlarmIndication_OnuLossOfAckInd)(nil),
		(*AlarmIndication_OnuDiffReachExceededInd)(nil),
	}
	file_voltha_protos_openolt_proto_msgTypes[39].OneofWrappers = []any{
		(*OnuItuPonStatsIndication_RdiErrorInd)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_voltha_protos_openolt_proto_rawDesc), len(file_voltha_protos_openolt_proto_rawDesc)),
			NumEnums:      10,
			NumMessages:   63,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_voltha_protos_openolt_proto_goTypes,
		DependencyIndexes: file_voltha_protos_openolt_proto_depIdxs,
		EnumInfos:         file_voltha_protos_openolt_proto_enumTypes,
		MessageInfos:      file_voltha_protos_openolt_proto_msgTypes,
	}.Build()
	File_voltha_protos_openolt_proto = out.File
	file_voltha_protos_openolt_proto_goTypes = nil
	file_voltha_protos_openolt_proto_depIdxs = nil
}
