# voltha-protos

Protobuf files used by [VOLTHA](https://wiki.opencord.org/display/CORD/VOLTHA).

Currently this is used to generate both go and python.

Protobuf definition files are located in `protos/voltha_protos` directory. This
directory heirarchy and import scheme is required to allow the python code
generated by the GRPC compiler to [have the correct import
paths](https://github.com/grpc/grpc/issues/9575#issuecomment-293934506).

> NOTE: The `protos/google/api` directory has files copied from the [Google
> APIs](https://github.com/googleapis/googleapis), and is only included for
> initial compilation of the VOLTHA protobuf files - these API's should be
> installed independently via either the python
> [googleapis-common-protos](https://pypi.org/project/googleapis-common-protos/)
> package or the golang [go-genproto](https://github.com/google/go-genproto)
> repo.

## Go environment

Get the Voltha-protos repository:
```
git clone https://gerrit.opencord.org/voltha-protos
cd voltha-protos
```

### Setting up the Go environment

After installing Go on the MAC, the GOPATH environment variable should be set to ~/go.
Create a symbolic link in the $GOPATH/src tree to the voltha-go repository:

```
mkdir $GOPATH/src/github.com/opencord
ln -s ~/repos/voltha-protos $GOPATH/src/github.com/opencord/voltha-protos
```

## Go dependencies

### install dependencies

```
cd $GOPATH/src/github.com/opencord/voltha-protos
go get github.com/golang/protobuf/
cd $GOPATH/github.com/golang/protobuf
git checkout v1.3.1
```

## Building locally

```
cd ~/repos/voltha-protos/
make build
```

use dist/*.tar.gz for local python imports
use go/ for local go imports

## Using voltha-protos in your project

### Python

Installation: `pip install voltha-protos`

Use: `from voltha_protos import voltha_pb2`

### go

```
go get github.com/opencord/voltha-protos
cd $GOPATH/github.com/opencord/voltha-protos
make build
````
protos should be importable from github.com/opencord/voltha-protos/go/packagename


To use the libraries, import protos with the root path github.com/opencord/voltha-protos/go/

## Testing

`make test` will run tests for all languages.

