// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/device.proto

package voltha

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	common "github.com/opencord/voltha-protos/go/common"
	openflow_13 "github.com/opencord/voltha-protos/go/openflow_13"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PmConfig_PmType int32

const (
	PmConfig_COUNTER PmConfig_PmType = 0
	PmConfig_GAUGE   PmConfig_PmType = 1
	PmConfig_STATE   PmConfig_PmType = 2
	PmConfig_CONTEXT PmConfig_PmType = 3
)

var PmConfig_PmType_name = map[int32]string{
	0: "COUNTER",
	1: "GAUGE",
	2: "STATE",
	3: "CONTEXT",
}

var PmConfig_PmType_value = map[string]int32{
	"COUNTER": 0,
	"GAUGE":   1,
	"STATE":   2,
	"CONTEXT": 3,
}

func (x PmConfig_PmType) String() string {
	return proto.EnumName(PmConfig_PmType_name, int32(x))
}

func (PmConfig_PmType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{2, 0}
}

type ImageDownload_ImageDownloadState int32

const (
	ImageDownload_DOWNLOAD_UNKNOWN     ImageDownload_ImageDownloadState = 0
	ImageDownload_DOWNLOAD_SUCCEEDED   ImageDownload_ImageDownloadState = 1
	ImageDownload_DOWNLOAD_REQUESTED   ImageDownload_ImageDownloadState = 2
	ImageDownload_DOWNLOAD_STARTED     ImageDownload_ImageDownloadState = 3
	ImageDownload_DOWNLOAD_FAILED      ImageDownload_ImageDownloadState = 4
	ImageDownload_DOWNLOAD_UNSUPPORTED ImageDownload_ImageDownloadState = 5
	ImageDownload_DOWNLOAD_CANCELLED   ImageDownload_ImageDownloadState = 6
)

var ImageDownload_ImageDownloadState_name = map[int32]string{
	0: "DOWNLOAD_UNKNOWN",
	1: "DOWNLOAD_SUCCEEDED",
	2: "DOWNLOAD_REQUESTED",
	3: "DOWNLOAD_STARTED",
	4: "DOWNLOAD_FAILED",
	5: "DOWNLOAD_UNSUPPORTED",
	6: "DOWNLOAD_CANCELLED",
}

var ImageDownload_ImageDownloadState_value = map[string]int32{
	"DOWNLOAD_UNKNOWN":     0,
	"DOWNLOAD_SUCCEEDED":   1,
	"DOWNLOAD_REQUESTED":   2,
	"DOWNLOAD_STARTED":     3,
	"DOWNLOAD_FAILED":      4,
	"DOWNLOAD_UNSUPPORTED": 5,
	"DOWNLOAD_CANCELLED":   6,
}

func (x ImageDownload_ImageDownloadState) String() string {
	return proto.EnumName(ImageDownload_ImageDownloadState_name, int32(x))
}

func (ImageDownload_ImageDownloadState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 0}
}

type ImageDownload_ImageDownloadFailureReason int32

const (
	ImageDownload_NO_ERROR           ImageDownload_ImageDownloadFailureReason = 0
	ImageDownload_INVALID_URL        ImageDownload_ImageDownloadFailureReason = 1
	ImageDownload_DEVICE_BUSY        ImageDownload_ImageDownloadFailureReason = 2
	ImageDownload_INSUFFICIENT_SPACE ImageDownload_ImageDownloadFailureReason = 3
	ImageDownload_UNKNOWN_ERROR      ImageDownload_ImageDownloadFailureReason = 4
	ImageDownload_CANCELLED          ImageDownload_ImageDownloadFailureReason = 5
)

var ImageDownload_ImageDownloadFailureReason_name = map[int32]string{
	0: "NO_ERROR",
	1: "INVALID_URL",
	2: "DEVICE_BUSY",
	3: "INSUFFICIENT_SPACE",
	4: "UNKNOWN_ERROR",
	5: "CANCELLED",
}

var ImageDownload_ImageDownloadFailureReason_value = map[string]int32{
	"NO_ERROR":           0,
	"INVALID_URL":        1,
	"DEVICE_BUSY":        2,
	"INSUFFICIENT_SPACE": 3,
	"UNKNOWN_ERROR":      4,
	"CANCELLED":          5,
}

func (x ImageDownload_ImageDownloadFailureReason) String() string {
	return proto.EnumName(ImageDownload_ImageDownloadFailureReason_name, int32(x))
}

func (ImageDownload_ImageDownloadFailureReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 1}
}

type ImageDownload_ImageActivateState int32

const (
	ImageDownload_IMAGE_UNKNOWN    ImageDownload_ImageActivateState = 0
	ImageDownload_IMAGE_INACTIVE   ImageDownload_ImageActivateState = 1
	ImageDownload_IMAGE_ACTIVATING ImageDownload_ImageActivateState = 2
	ImageDownload_IMAGE_ACTIVE     ImageDownload_ImageActivateState = 3
	ImageDownload_IMAGE_REVERTING  ImageDownload_ImageActivateState = 4
	ImageDownload_IMAGE_REVERTED   ImageDownload_ImageActivateState = 5
)

var ImageDownload_ImageActivateState_name = map[int32]string{
	0: "IMAGE_UNKNOWN",
	1: "IMAGE_INACTIVE",
	2: "IMAGE_ACTIVATING",
	3: "IMAGE_ACTIVE",
	4: "IMAGE_REVERTING",
	5: "IMAGE_REVERTED",
}

var ImageDownload_ImageActivateState_value = map[string]int32{
	"IMAGE_UNKNOWN":    0,
	"IMAGE_INACTIVE":   1,
	"IMAGE_ACTIVATING": 2,
	"IMAGE_ACTIVE":     3,
	"IMAGE_REVERTING":  4,
	"IMAGE_REVERTED":   5,
}

func (x ImageDownload_ImageActivateState) String() string {
	return proto.EnumName(ImageDownload_ImageActivateState_name, int32(x))
}

func (ImageDownload_ImageActivateState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 2}
}

type Port_PortType int32

const (
	Port_UNKNOWN      Port_PortType = 0
	Port_ETHERNET_NNI Port_PortType = 1
	Port_ETHERNET_UNI Port_PortType = 2
	Port_PON_OLT      Port_PortType = 3
	Port_PON_ONU      Port_PortType = 4
	Port_VENET_OLT    Port_PortType = 5
	Port_VENET_ONU    Port_PortType = 6
)

var Port_PortType_name = map[int32]string{
	0: "UNKNOWN",
	1: "ETHERNET_NNI",
	2: "ETHERNET_UNI",
	3: "PON_OLT",
	4: "PON_ONU",
	5: "VENET_OLT",
	6: "VENET_ONU",
}

var Port_PortType_value = map[string]int32{
	"UNKNOWN":      0,
	"ETHERNET_NNI": 1,
	"ETHERNET_UNI": 2,
	"PON_OLT":      3,
	"PON_ONU":      4,
	"VENET_OLT":    5,
	"VENET_ONU":    6,
}

func (x Port_PortType) String() string {
	return proto.EnumName(Port_PortType_name, int32(x))
}

func (Port_PortType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9, 0}
}

type SimulateAlarmRequest_OperationType int32

const (
	SimulateAlarmRequest_RAISE SimulateAlarmRequest_OperationType = 0
	SimulateAlarmRequest_CLEAR SimulateAlarmRequest_OperationType = 1
)

var SimulateAlarmRequest_OperationType_name = map[int32]string{
	0: "RAISE",
	1: "CLEAR",
}

var SimulateAlarmRequest_OperationType_value = map[string]int32{
	"RAISE": 0,
	"CLEAR": 1,
}

func (x SimulateAlarmRequest_OperationType) String() string {
	return proto.EnumName(SimulateAlarmRequest_OperationType_name, int32(x))
}

func (SimulateAlarmRequest_OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13, 0}
}

// A Device Type
type DeviceType struct {
	// Unique name for the device type
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Unique vendor id for the device type applicable to ONU
	// 4 bytes of vendor id from ONU serial number
	VendorId  string   `protobuf:"bytes,5,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	VendorIds []string `protobuf:"bytes,6,rep,name=vendor_ids,json=vendorIds,proto3" json:"vendor_ids,omitempty"`
	// Name of the adapter that handles device type
	Adapter string `protobuf:"bytes,2,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Capabilities
	AcceptsBulkFlowUpdate           bool     `protobuf:"varint,3,opt,name=accepts_bulk_flow_update,json=acceptsBulkFlowUpdate,proto3" json:"accepts_bulk_flow_update,omitempty"`
	AcceptsAddRemoveFlowUpdates     bool     `protobuf:"varint,4,opt,name=accepts_add_remove_flow_updates,json=acceptsAddRemoveFlowUpdates,proto3" json:"accepts_add_remove_flow_updates,omitempty"`
	AcceptsDirectLogicalFlowsUpdate bool     `protobuf:"varint,7,opt,name=accepts_direct_logical_flows_update,json=acceptsDirectLogicalFlowsUpdate,proto3" json:"accepts_direct_logical_flows_update,omitempty"`
	XXX_NoUnkeyedLiteral            struct{} `json:"-"`
	XXX_unrecognized                []byte   `json:"-"`
	XXX_sizecache                   int32    `json:"-"`
}

func (m *DeviceType) Reset()         { *m = DeviceType{} }
func (m *DeviceType) String() string { return proto.CompactTextString(m) }
func (*DeviceType) ProtoMessage()    {}
func (*DeviceType) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{0}
}

func (m *DeviceType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceType.Unmarshal(m, b)
}
func (m *DeviceType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceType.Marshal(b, m, deterministic)
}
func (m *DeviceType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceType.Merge(m, src)
}
func (m *DeviceType) XXX_Size() int {
	return xxx_messageInfo_DeviceType.Size(m)
}
func (m *DeviceType) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceType.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceType proto.InternalMessageInfo

func (m *DeviceType) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeviceType) GetVendorId() string {
	if m != nil {
		return m.VendorId
	}
	return ""
}

func (m *DeviceType) GetVendorIds() []string {
	if m != nil {
		return m.VendorIds
	}
	return nil
}

func (m *DeviceType) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *DeviceType) GetAcceptsBulkFlowUpdate() bool {
	if m != nil {
		return m.AcceptsBulkFlowUpdate
	}
	return false
}

func (m *DeviceType) GetAcceptsAddRemoveFlowUpdates() bool {
	if m != nil {
		return m.AcceptsAddRemoveFlowUpdates
	}
	return false
}

func (m *DeviceType) GetAcceptsDirectLogicalFlowsUpdate() bool {
	if m != nil {
		return m.AcceptsDirectLogicalFlowsUpdate
	}
	return false
}

// A plurality of device types
type DeviceTypes struct {
	Items                []*DeviceType `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DeviceTypes) Reset()         { *m = DeviceTypes{} }
func (m *DeviceTypes) String() string { return proto.CompactTextString(m) }
func (*DeviceTypes) ProtoMessage()    {}
func (*DeviceTypes) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{1}
}

func (m *DeviceTypes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceTypes.Unmarshal(m, b)
}
func (m *DeviceTypes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceTypes.Marshal(b, m, deterministic)
}
func (m *DeviceTypes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceTypes.Merge(m, src)
}
func (m *DeviceTypes) XXX_Size() int {
	return xxx_messageInfo_DeviceTypes.Size(m)
}
func (m *DeviceTypes) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceTypes.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceTypes proto.InternalMessageInfo

func (m *DeviceTypes) GetItems() []*DeviceType {
	if m != nil {
		return m.Items
	}
	return nil
}

type PmConfig struct {
	Name                 string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type                 PmConfig_PmType `protobuf:"varint,2,opt,name=type,proto3,enum=voltha.PmConfig_PmType" json:"type,omitempty"`
	Enabled              bool            `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	SampleFreq           uint32          `protobuf:"varint,4,opt,name=sample_freq,json=sampleFreq,proto3" json:"sample_freq,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *PmConfig) Reset()         { *m = PmConfig{} }
func (m *PmConfig) String() string { return proto.CompactTextString(m) }
func (*PmConfig) ProtoMessage()    {}
func (*PmConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{2}
}

func (m *PmConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmConfig.Unmarshal(m, b)
}
func (m *PmConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmConfig.Marshal(b, m, deterministic)
}
func (m *PmConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmConfig.Merge(m, src)
}
func (m *PmConfig) XXX_Size() int {
	return xxx_messageInfo_PmConfig.Size(m)
}
func (m *PmConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PmConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PmConfig proto.InternalMessageInfo

func (m *PmConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PmConfig) GetType() PmConfig_PmType {
	if m != nil {
		return m.Type
	}
	return PmConfig_COUNTER
}

func (m *PmConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PmConfig) GetSampleFreq() uint32 {
	if m != nil {
		return m.SampleFreq
	}
	return 0
}

type PmGroupConfig struct {
	GroupName            string      `protobuf:"bytes,1,opt,name=group_name,json=groupName,proto3" json:"group_name,omitempty"`
	GroupFreq            uint32      `protobuf:"varint,2,opt,name=group_freq,json=groupFreq,proto3" json:"group_freq,omitempty"`
	Enabled              bool        `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Metrics              []*PmConfig `protobuf:"bytes,4,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *PmGroupConfig) Reset()         { *m = PmGroupConfig{} }
func (m *PmGroupConfig) String() string { return proto.CompactTextString(m) }
func (*PmGroupConfig) ProtoMessage()    {}
func (*PmGroupConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{3}
}

func (m *PmGroupConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmGroupConfig.Unmarshal(m, b)
}
func (m *PmGroupConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmGroupConfig.Marshal(b, m, deterministic)
}
func (m *PmGroupConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmGroupConfig.Merge(m, src)
}
func (m *PmGroupConfig) XXX_Size() int {
	return xxx_messageInfo_PmGroupConfig.Size(m)
}
func (m *PmGroupConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PmGroupConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PmGroupConfig proto.InternalMessageInfo

func (m *PmGroupConfig) GetGroupName() string {
	if m != nil {
		return m.GroupName
	}
	return ""
}

func (m *PmGroupConfig) GetGroupFreq() uint32 {
	if m != nil {
		return m.GroupFreq
	}
	return 0
}

func (m *PmGroupConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PmGroupConfig) GetMetrics() []*PmConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type PmConfigs struct {
	Id          string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	DefaultFreq uint32 `protobuf:"varint,2,opt,name=default_freq,json=defaultFreq,proto3" json:"default_freq,omitempty"`
	// Forces group names and group semantics
	Grouped bool `protobuf:"varint,3,opt,name=grouped,proto3" json:"grouped,omitempty"`
	// Allows Pm to set an individual sample frequency
	FreqOverride         bool             `protobuf:"varint,4,opt,name=freq_override,json=freqOverride,proto3" json:"freq_override,omitempty"`
	Groups               []*PmGroupConfig `protobuf:"bytes,5,rep,name=groups,proto3" json:"groups,omitempty"`
	Metrics              []*PmConfig      `protobuf:"bytes,6,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PmConfigs) Reset()         { *m = PmConfigs{} }
func (m *PmConfigs) String() string { return proto.CompactTextString(m) }
func (*PmConfigs) ProtoMessage()    {}
func (*PmConfigs) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{4}
}

func (m *PmConfigs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmConfigs.Unmarshal(m, b)
}
func (m *PmConfigs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmConfigs.Marshal(b, m, deterministic)
}
func (m *PmConfigs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmConfigs.Merge(m, src)
}
func (m *PmConfigs) XXX_Size() int {
	return xxx_messageInfo_PmConfigs.Size(m)
}
func (m *PmConfigs) XXX_DiscardUnknown() {
	xxx_messageInfo_PmConfigs.DiscardUnknown(m)
}

var xxx_messageInfo_PmConfigs proto.InternalMessageInfo

func (m *PmConfigs) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PmConfigs) GetDefaultFreq() uint32 {
	if m != nil {
		return m.DefaultFreq
	}
	return 0
}

func (m *PmConfigs) GetGrouped() bool {
	if m != nil {
		return m.Grouped
	}
	return false
}

func (m *PmConfigs) GetFreqOverride() bool {
	if m != nil {
		return m.FreqOverride
	}
	return false
}

func (m *PmConfigs) GetGroups() []*PmGroupConfig {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *PmConfigs) GetMetrics() []*PmConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// Describes instance of software image on the device
type Image struct {
	Name            string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version         string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Hash            string `protobuf:"bytes,3,opt,name=hash,proto3" json:"hash,omitempty"`
	InstallDatetime string `protobuf:"bytes,4,opt,name=install_datetime,json=installDatetime,proto3" json:"install_datetime,omitempty"`
	// The active software image is one that is currently loaded and executing
	// in the ONU or circuit pack. Under normal operation, one software image
	// is always active while the other is inactive. Under no circumstances are
	// both software images allowed to be active at the same time
	IsActive bool `protobuf:"varint,5,opt,name=is_active,json=isActive,proto3" json:"is_active,omitempty"`
	// The committed software image is loaded and executed upon reboot of the
	// ONU and/or circuit pack. During normal operation, one software image is
	// always committed, while the other is uncommitted.
	IsCommitted bool `protobuf:"varint,6,opt,name=is_committed,json=isCommitted,proto3" json:"is_committed,omitempty"`
	// A software image is valid if it has been verified to be an executable
	// code image. The verification mechanism is not subject to standardization;
	// however, it should include at least a data integrity (e.g., CRC) check of
	// the entire code image.
	IsValid              bool     `protobuf:"varint,7,opt,name=is_valid,json=isValid,proto3" json:"is_valid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{5}
}

func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Image) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Image) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *Image) GetInstallDatetime() string {
	if m != nil {
		return m.InstallDatetime
	}
	return ""
}

func (m *Image) GetIsActive() bool {
	if m != nil {
		return m.IsActive
	}
	return false
}

func (m *Image) GetIsCommitted() bool {
	if m != nil {
		return m.IsCommitted
	}
	return false
}

func (m *Image) GetIsValid() bool {
	if m != nil {
		return m.IsValid
	}
	return false
}

// List of software on the device
type Images struct {
	Image                []*Image `protobuf:"bytes,1,rep,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Images) Reset()         { *m = Images{} }
func (m *Images) String() string { return proto.CompactTextString(m) }
func (*Images) ProtoMessage()    {}
func (*Images) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{6}
}

func (m *Images) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Images.Unmarshal(m, b)
}
func (m *Images) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Images.Marshal(b, m, deterministic)
}
func (m *Images) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Images.Merge(m, src)
}
func (m *Images) XXX_Size() int {
	return xxx_messageInfo_Images.Size(m)
}
func (m *Images) XXX_DiscardUnknown() {
	xxx_messageInfo_Images.DiscardUnknown(m)
}

var xxx_messageInfo_Images proto.InternalMessageInfo

func (m *Images) GetImage() []*Image {
	if m != nil {
		return m.Image
	}
	return nil
}

type ImageDownload struct {
	// Device Identifier
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Image unique identifier
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// URL where the image is available
	// should include username password
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// CRC of the image to be verified aginst
	Crc uint32 `protobuf:"varint,4,opt,name=crc,proto3" json:"crc,omitempty"`
	// Download state
	DownloadState ImageDownload_ImageDownloadState `protobuf:"varint,5,opt,name=download_state,json=downloadState,proto3,enum=voltha.ImageDownload_ImageDownloadState" json:"download_state,omitempty"`
	// Downloaded version
	ImageVersion string `protobuf:"bytes,6,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Bytes downloaded
	DownloadedBytes uint32 `protobuf:"varint,7,opt,name=downloaded_bytes,json=downloadedBytes,proto3" json:"downloaded_bytes,omitempty"`
	// Download failure reason
	Reason ImageDownload_ImageDownloadFailureReason `protobuf:"varint,8,opt,name=reason,proto3,enum=voltha.ImageDownload_ImageDownloadFailureReason" json:"reason,omitempty"`
	// Additional info
	AdditionalInfo string `protobuf:"bytes,9,opt,name=additional_info,json=additionalInfo,proto3" json:"additional_info,omitempty"`
	// Save current configuration
	SaveConfig bool `protobuf:"varint,10,opt,name=save_config,json=saveConfig,proto3" json:"save_config,omitempty"`
	// Image local location
	LocalDir string `protobuf:"bytes,11,opt,name=local_dir,json=localDir,proto3" json:"local_dir,omitempty"`
	// Image activation state
	ImageState ImageDownload_ImageActivateState `protobuf:"varint,12,opt,name=image_state,json=imageState,proto3,enum=voltha.ImageDownload_ImageActivateState" json:"image_state,omitempty"`
	// Image file size
	FileSize             uint32   `protobuf:"varint,13,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageDownload) Reset()         { *m = ImageDownload{} }
func (m *ImageDownload) String() string { return proto.CompactTextString(m) }
func (*ImageDownload) ProtoMessage()    {}
func (*ImageDownload) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7}
}

func (m *ImageDownload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageDownload.Unmarshal(m, b)
}
func (m *ImageDownload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageDownload.Marshal(b, m, deterministic)
}
func (m *ImageDownload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageDownload.Merge(m, src)
}
func (m *ImageDownload) XXX_Size() int {
	return xxx_messageInfo_ImageDownload.Size(m)
}
func (m *ImageDownload) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageDownload.DiscardUnknown(m)
}

var xxx_messageInfo_ImageDownload proto.InternalMessageInfo

func (m *ImageDownload) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ImageDownload) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImageDownload) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *ImageDownload) GetCrc() uint32 {
	if m != nil {
		return m.Crc
	}
	return 0
}

func (m *ImageDownload) GetDownloadState() ImageDownload_ImageDownloadState {
	if m != nil {
		return m.DownloadState
	}
	return ImageDownload_DOWNLOAD_UNKNOWN
}

func (m *ImageDownload) GetImageVersion() string {
	if m != nil {
		return m.ImageVersion
	}
	return ""
}

func (m *ImageDownload) GetDownloadedBytes() uint32 {
	if m != nil {
		return m.DownloadedBytes
	}
	return 0
}

func (m *ImageDownload) GetReason() ImageDownload_ImageDownloadFailureReason {
	if m != nil {
		return m.Reason
	}
	return ImageDownload_NO_ERROR
}

func (m *ImageDownload) GetAdditionalInfo() string {
	if m != nil {
		return m.AdditionalInfo
	}
	return ""
}

func (m *ImageDownload) GetSaveConfig() bool {
	if m != nil {
		return m.SaveConfig
	}
	return false
}

func (m *ImageDownload) GetLocalDir() string {
	if m != nil {
		return m.LocalDir
	}
	return ""
}

func (m *ImageDownload) GetImageState() ImageDownload_ImageActivateState {
	if m != nil {
		return m.ImageState
	}
	return ImageDownload_IMAGE_UNKNOWN
}

func (m *ImageDownload) GetFileSize() uint32 {
	if m != nil {
		return m.FileSize
	}
	return 0
}

type ImageDownloads struct {
	Items                []*ImageDownload `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ImageDownloads) Reset()         { *m = ImageDownloads{} }
func (m *ImageDownloads) String() string { return proto.CompactTextString(m) }
func (*ImageDownloads) ProtoMessage()    {}
func (*ImageDownloads) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{8}
}

func (m *ImageDownloads) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageDownloads.Unmarshal(m, b)
}
func (m *ImageDownloads) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageDownloads.Marshal(b, m, deterministic)
}
func (m *ImageDownloads) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageDownloads.Merge(m, src)
}
func (m *ImageDownloads) XXX_Size() int {
	return xxx_messageInfo_ImageDownloads.Size(m)
}
func (m *ImageDownloads) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageDownloads.DiscardUnknown(m)
}

var xxx_messageInfo_ImageDownloads proto.InternalMessageInfo

func (m *ImageDownloads) GetItems() []*ImageDownload {
	if m != nil {
		return m.Items
	}
	return nil
}

type Port struct {
	PortNo               uint32                       `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	Label                string                       `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	Type                 Port_PortType                `protobuf:"varint,3,opt,name=type,proto3,enum=voltha.Port_PortType" json:"type,omitempty"`
	AdminState           common.AdminState_AdminState `protobuf:"varint,5,opt,name=admin_state,json=adminState,proto3,enum=common.AdminState_AdminState" json:"admin_state,omitempty"`
	OperStatus           common.OperStatus_OperStatus `protobuf:"varint,6,opt,name=oper_status,json=operStatus,proto3,enum=common.OperStatus_OperStatus" json:"oper_status,omitempty"`
	DeviceId             string                       `protobuf:"bytes,7,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	Peers                []*Port_PeerPort             `protobuf:"bytes,8,rep,name=peers,proto3" json:"peers,omitempty"`
	RxPackets            uint64                       `protobuf:"fixed64,9,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	RxBytes              uint64                       `protobuf:"fixed64,10,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	RxErrors             uint64                       `protobuf:"fixed64,11,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	TxPackets            uint64                       `protobuf:"fixed64,12,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	TxBytes              uint64                       `protobuf:"fixed64,13,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxErrors             uint64                       `protobuf:"fixed64,14,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Port) Reset()         { *m = Port{} }
func (m *Port) String() string { return proto.CompactTextString(m) }
func (*Port) ProtoMessage()    {}
func (*Port) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9}
}

func (m *Port) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Port.Unmarshal(m, b)
}
func (m *Port) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Port.Marshal(b, m, deterministic)
}
func (m *Port) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port.Merge(m, src)
}
func (m *Port) XXX_Size() int {
	return xxx_messageInfo_Port.Size(m)
}
func (m *Port) XXX_DiscardUnknown() {
	xxx_messageInfo_Port.DiscardUnknown(m)
}

var xxx_messageInfo_Port proto.InternalMessageInfo

func (m *Port) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *Port) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Port) GetType() Port_PortType {
	if m != nil {
		return m.Type
	}
	return Port_UNKNOWN
}

func (m *Port) GetAdminState() common.AdminState_AdminState {
	if m != nil {
		return m.AdminState
	}
	return common.AdminState_UNKNOWN
}

func (m *Port) GetOperStatus() common.OperStatus_OperStatus {
	if m != nil {
		return m.OperStatus
	}
	return common.OperStatus_UNKNOWN
}

func (m *Port) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Port) GetPeers() []*Port_PeerPort {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *Port) GetRxPackets() uint64 {
	if m != nil {
		return m.RxPackets
	}
	return 0
}

func (m *Port) GetRxBytes() uint64 {
	if m != nil {
		return m.RxBytes
	}
	return 0
}

func (m *Port) GetRxErrors() uint64 {
	if m != nil {
		return m.RxErrors
	}
	return 0
}

func (m *Port) GetTxPackets() uint64 {
	if m != nil {
		return m.TxPackets
	}
	return 0
}

func (m *Port) GetTxBytes() uint64 {
	if m != nil {
		return m.TxBytes
	}
	return 0
}

func (m *Port) GetTxErrors() uint64 {
	if m != nil {
		return m.TxErrors
	}
	return 0
}

type Port_PeerPort struct {
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	PortNo               uint32   `protobuf:"varint,2,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Port_PeerPort) Reset()         { *m = Port_PeerPort{} }
func (m *Port_PeerPort) String() string { return proto.CompactTextString(m) }
func (*Port_PeerPort) ProtoMessage()    {}
func (*Port_PeerPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9, 0}
}

func (m *Port_PeerPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Port_PeerPort.Unmarshal(m, b)
}
func (m *Port_PeerPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Port_PeerPort.Marshal(b, m, deterministic)
}
func (m *Port_PeerPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port_PeerPort.Merge(m, src)
}
func (m *Port_PeerPort) XXX_Size() int {
	return xxx_messageInfo_Port_PeerPort.Size(m)
}
func (m *Port_PeerPort) XXX_DiscardUnknown() {
	xxx_messageInfo_Port_PeerPort.DiscardUnknown(m)
}

var xxx_messageInfo_Port_PeerPort proto.InternalMessageInfo

func (m *Port_PeerPort) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Port_PeerPort) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

type Ports struct {
	Items                []*Port  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Ports) Reset()         { *m = Ports{} }
func (m *Ports) String() string { return proto.CompactTextString(m) }
func (*Ports) ProtoMessage()    {}
func (*Ports) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{10}
}

func (m *Ports) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ports.Unmarshal(m, b)
}
func (m *Ports) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ports.Marshal(b, m, deterministic)
}
func (m *Ports) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ports.Merge(m, src)
}
func (m *Ports) XXX_Size() int {
	return xxx_messageInfo_Ports.Size(m)
}
func (m *Ports) XXX_DiscardUnknown() {
	xxx_messageInfo_Ports.DiscardUnknown(m)
}

var xxx_messageInfo_Ports proto.InternalMessageInfo

func (m *Ports) GetItems() []*Port {
	if m != nil {
		return m.Items
	}
	return nil
}

// A Physical Device instance
type Device struct {
	// Voltha's device identifier
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Device type, refers to one of the registered device types
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Is this device a root device. Each logical switch has one root
	// device that is associated with the logical flow switch.
	Root bool `protobuf:"varint,3,opt,name=root,proto3" json:"root,omitempty"`
	// Parent device id, in the device tree (for a root device, the parent_id
	// is the logical_device.id)
	ParentId     string `protobuf:"bytes,4,opt,name=parent_id,json=parentId,proto3" json:"parent_id,omitempty"`
	ParentPortNo uint32 `protobuf:"varint,20,opt,name=parent_port_no,json=parentPortNo,proto3" json:"parent_port_no,omitempty"`
	// Vendor, version, serial number, etc.
	Vendor          string `protobuf:"bytes,5,opt,name=vendor,proto3" json:"vendor,omitempty"`
	Model           string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	HardwareVersion string `protobuf:"bytes,7,opt,name=hardware_version,json=hardwareVersion,proto3" json:"hardware_version,omitempty"`
	FirmwareVersion string `protobuf:"bytes,8,opt,name=firmware_version,json=firmwareVersion,proto3" json:"firmware_version,omitempty"`
	// List of software on the device
	Images       *Images `protobuf:"bytes,9,opt,name=images,proto3" json:"images,omitempty"`
	SerialNumber string  `protobuf:"bytes,10,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	VendorId     string  `protobuf:"bytes,24,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	// Addapter that takes care of device
	Adapter string `protobuf:"bytes,11,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Device contact on vlan (if 0, no vlan)
	Vlan uint32 `protobuf:"varint,12,opt,name=vlan,proto3" json:"vlan,omitempty"`
	// Device contact MAC address (format: "xx:xx:xx:xx:xx:xx")
	MacAddress string `protobuf:"bytes,13,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// Types that are valid to be assigned to Address:
	//	*Device_Ipv4Address
	//	*Device_Ipv6Address
	//	*Device_HostAndPort
	Address       isDevice_Address                   `protobuf_oneof:"address"`
	ExtraArgs     string                             `protobuf:"bytes,23,opt,name=extra_args,json=extraArgs,proto3" json:"extra_args,omitempty"`
	ProxyAddress  *Device_ProxyAddress               `protobuf:"bytes,19,opt,name=proxy_address,json=proxyAddress,proto3" json:"proxy_address,omitempty"`
	AdminState    common.AdminState_AdminState       `protobuf:"varint,16,opt,name=admin_state,json=adminState,proto3,enum=common.AdminState_AdminState" json:"admin_state,omitempty"`
	OperStatus    common.OperStatus_OperStatus       `protobuf:"varint,17,opt,name=oper_status,json=operStatus,proto3,enum=common.OperStatus_OperStatus" json:"oper_status,omitempty"`
	Reason        string                             `protobuf:"bytes,22,opt,name=reason,proto3" json:"reason,omitempty"`
	ConnectStatus common.ConnectStatus_ConnectStatus `protobuf:"varint,18,opt,name=connect_status,json=connectStatus,proto3,enum=common.ConnectStatus_ConnectStatus" json:"connect_status,omitempty"`
	// Device type specific attributes
	Custom     *any.Any                `protobuf:"bytes,64,opt,name=custom,proto3" json:"custom,omitempty"`
	Ports      []*Port                 `protobuf:"bytes,128,rep,name=ports,proto3" json:"ports,omitempty"`
	Flows      *openflow_13.Flows      `protobuf:"bytes,129,opt,name=flows,proto3" json:"flows,omitempty"`
	FlowGroups *openflow_13.FlowGroups `protobuf:"bytes,130,opt,name=flow_groups,json=flowGroups,proto3" json:"flow_groups,omitempty"`
	// PmConfigs will eventually converted to a child node of the
	// device to falicitata callbacks and to simplify manipulation.
	PmConfigs            *PmConfigs       `protobuf:"bytes,131,opt,name=pm_configs,json=pmConfigs,proto3" json:"pm_configs,omitempty"`
	ImageDownloads       []*ImageDownload `protobuf:"bytes,133,rep,name=image_downloads,json=imageDownloads,proto3" json:"image_downloads,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Device) Reset()         { *m = Device{} }
func (m *Device) String() string { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()    {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{11}
}

func (m *Device) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device.Unmarshal(m, b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device.Marshal(b, m, deterministic)
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return xxx_messageInfo_Device.Size(m)
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

func (m *Device) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Device) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Device) GetRoot() bool {
	if m != nil {
		return m.Root
	}
	return false
}

func (m *Device) GetParentId() string {
	if m != nil {
		return m.ParentId
	}
	return ""
}

func (m *Device) GetParentPortNo() uint32 {
	if m != nil {
		return m.ParentPortNo
	}
	return 0
}

func (m *Device) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *Device) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *Device) GetHardwareVersion() string {
	if m != nil {
		return m.HardwareVersion
	}
	return ""
}

func (m *Device) GetFirmwareVersion() string {
	if m != nil {
		return m.FirmwareVersion
	}
	return ""
}

func (m *Device) GetImages() *Images {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Device) GetSerialNumber() string {
	if m != nil {
		return m.SerialNumber
	}
	return ""
}

func (m *Device) GetVendorId() string {
	if m != nil {
		return m.VendorId
	}
	return ""
}

func (m *Device) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *Device) GetVlan() uint32 {
	if m != nil {
		return m.Vlan
	}
	return 0
}

func (m *Device) GetMacAddress() string {
	if m != nil {
		return m.MacAddress
	}
	return ""
}

type isDevice_Address interface {
	isDevice_Address()
}

type Device_Ipv4Address struct {
	Ipv4Address string `protobuf:"bytes,14,opt,name=ipv4_address,json=ipv4Address,proto3,oneof"`
}

type Device_Ipv6Address struct {
	Ipv6Address string `protobuf:"bytes,15,opt,name=ipv6_address,json=ipv6Address,proto3,oneof"`
}

type Device_HostAndPort struct {
	HostAndPort string `protobuf:"bytes,21,opt,name=host_and_port,json=hostAndPort,proto3,oneof"`
}

func (*Device_Ipv4Address) isDevice_Address() {}

func (*Device_Ipv6Address) isDevice_Address() {}

func (*Device_HostAndPort) isDevice_Address() {}

func (m *Device) GetAddress() isDevice_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Device) GetIpv4Address() string {
	if x, ok := m.GetAddress().(*Device_Ipv4Address); ok {
		return x.Ipv4Address
	}
	return ""
}

func (m *Device) GetIpv6Address() string {
	if x, ok := m.GetAddress().(*Device_Ipv6Address); ok {
		return x.Ipv6Address
	}
	return ""
}

func (m *Device) GetHostAndPort() string {
	if x, ok := m.GetAddress().(*Device_HostAndPort); ok {
		return x.HostAndPort
	}
	return ""
}

func (m *Device) GetExtraArgs() string {
	if m != nil {
		return m.ExtraArgs
	}
	return ""
}

func (m *Device) GetProxyAddress() *Device_ProxyAddress {
	if m != nil {
		return m.ProxyAddress
	}
	return nil
}

func (m *Device) GetAdminState() common.AdminState_AdminState {
	if m != nil {
		return m.AdminState
	}
	return common.AdminState_UNKNOWN
}

func (m *Device) GetOperStatus() common.OperStatus_OperStatus {
	if m != nil {
		return m.OperStatus
	}
	return common.OperStatus_UNKNOWN
}

func (m *Device) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Device) GetConnectStatus() common.ConnectStatus_ConnectStatus {
	if m != nil {
		return m.ConnectStatus
	}
	return common.ConnectStatus_UNKNOWN
}

func (m *Device) GetCustom() *any.Any {
	if m != nil {
		return m.Custom
	}
	return nil
}

func (m *Device) GetPorts() []*Port {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *Device) GetFlows() *openflow_13.Flows {
	if m != nil {
		return m.Flows
	}
	return nil
}

func (m *Device) GetFlowGroups() *openflow_13.FlowGroups {
	if m != nil {
		return m.FlowGroups
	}
	return nil
}

func (m *Device) GetPmConfigs() *PmConfigs {
	if m != nil {
		return m.PmConfigs
	}
	return nil
}

func (m *Device) GetImageDownloads() []*ImageDownload {
	if m != nil {
		return m.ImageDownloads
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Device) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Device_Ipv4Address)(nil),
		(*Device_Ipv6Address)(nil),
		(*Device_HostAndPort)(nil),
	}
}

type Device_ProxyAddress struct {
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	DeviceType           string   `protobuf:"bytes,2,opt,name=device_type,json=deviceType,proto3" json:"device_type,omitempty"`
	ChannelId            uint32   `protobuf:"varint,3,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	ChannelGroupId       uint32   `protobuf:"varint,4,opt,name=channel_group_id,json=channelGroupId,proto3" json:"channel_group_id,omitempty"`
	ChannelTermination   string   `protobuf:"bytes,5,opt,name=channel_termination,json=channelTermination,proto3" json:"channel_termination,omitempty"`
	OnuId                uint32   `protobuf:"varint,6,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	OnuSessionId         uint32   `protobuf:"varint,7,opt,name=onu_session_id,json=onuSessionId,proto3" json:"onu_session_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Device_ProxyAddress) Reset()         { *m = Device_ProxyAddress{} }
func (m *Device_ProxyAddress) String() string { return proto.CompactTextString(m) }
func (*Device_ProxyAddress) ProtoMessage()    {}
func (*Device_ProxyAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{11, 0}
}

func (m *Device_ProxyAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device_ProxyAddress.Unmarshal(m, b)
}
func (m *Device_ProxyAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device_ProxyAddress.Marshal(b, m, deterministic)
}
func (m *Device_ProxyAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device_ProxyAddress.Merge(m, src)
}
func (m *Device_ProxyAddress) XXX_Size() int {
	return xxx_messageInfo_Device_ProxyAddress.Size(m)
}
func (m *Device_ProxyAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_Device_ProxyAddress.DiscardUnknown(m)
}

var xxx_messageInfo_Device_ProxyAddress proto.InternalMessageInfo

func (m *Device_ProxyAddress) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Device_ProxyAddress) GetDeviceType() string {
	if m != nil {
		return m.DeviceType
	}
	return ""
}

func (m *Device_ProxyAddress) GetChannelId() uint32 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *Device_ProxyAddress) GetChannelGroupId() uint32 {
	if m != nil {
		return m.ChannelGroupId
	}
	return 0
}

func (m *Device_ProxyAddress) GetChannelTermination() string {
	if m != nil {
		return m.ChannelTermination
	}
	return ""
}

func (m *Device_ProxyAddress) GetOnuId() uint32 {
	if m != nil {
		return m.OnuId
	}
	return 0
}

func (m *Device_ProxyAddress) GetOnuSessionId() uint32 {
	if m != nil {
		return m.OnuSessionId
	}
	return 0
}

type Devices struct {
	Items                []*Device `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Devices) Reset()         { *m = Devices{} }
func (m *Devices) String() string { return proto.CompactTextString(m) }
func (*Devices) ProtoMessage()    {}
func (*Devices) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{12}
}

func (m *Devices) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Devices.Unmarshal(m, b)
}
func (m *Devices) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Devices.Marshal(b, m, deterministic)
}
func (m *Devices) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Devices.Merge(m, src)
}
func (m *Devices) XXX_Size() int {
	return xxx_messageInfo_Devices.Size(m)
}
func (m *Devices) XXX_DiscardUnknown() {
	xxx_messageInfo_Devices.DiscardUnknown(m)
}

var xxx_messageInfo_Devices proto.InternalMessageInfo

func (m *Devices) GetItems() []*Device {
	if m != nil {
		return m.Items
	}
	return nil
}

type SimulateAlarmRequest struct {
	// Device Identifier
	Id                   string                             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Indicator            string                             `protobuf:"bytes,2,opt,name=indicator,proto3" json:"indicator,omitempty"`
	IntfId               string                             `protobuf:"bytes,3,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	PortTypeName         string                             `protobuf:"bytes,4,opt,name=port_type_name,json=portTypeName,proto3" json:"port_type_name,omitempty"`
	OnuDeviceId          string                             `protobuf:"bytes,5,opt,name=onu_device_id,json=onuDeviceId,proto3" json:"onu_device_id,omitempty"`
	InverseBitErrorRate  int32                              `protobuf:"varint,6,opt,name=inverse_bit_error_rate,json=inverseBitErrorRate,proto3" json:"inverse_bit_error_rate,omitempty"`
	Drift                int32                              `protobuf:"varint,7,opt,name=drift,proto3" json:"drift,omitempty"`
	NewEqd               int32                              `protobuf:"varint,8,opt,name=new_eqd,json=newEqd,proto3" json:"new_eqd,omitempty"`
	OnuSerialNumber      string                             `protobuf:"bytes,9,opt,name=onu_serial_number,json=onuSerialNumber,proto3" json:"onu_serial_number,omitempty"`
	Operation            SimulateAlarmRequest_OperationType `protobuf:"varint,10,opt,name=operation,proto3,enum=voltha.SimulateAlarmRequest_OperationType" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *SimulateAlarmRequest) Reset()         { *m = SimulateAlarmRequest{} }
func (m *SimulateAlarmRequest) String() string { return proto.CompactTextString(m) }
func (*SimulateAlarmRequest) ProtoMessage()    {}
func (*SimulateAlarmRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13}
}

func (m *SimulateAlarmRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimulateAlarmRequest.Unmarshal(m, b)
}
func (m *SimulateAlarmRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimulateAlarmRequest.Marshal(b, m, deterministic)
}
func (m *SimulateAlarmRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimulateAlarmRequest.Merge(m, src)
}
func (m *SimulateAlarmRequest) XXX_Size() int {
	return xxx_messageInfo_SimulateAlarmRequest.Size(m)
}
func (m *SimulateAlarmRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SimulateAlarmRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SimulateAlarmRequest proto.InternalMessageInfo

func (m *SimulateAlarmRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SimulateAlarmRequest) GetIndicator() string {
	if m != nil {
		return m.Indicator
	}
	return ""
}

func (m *SimulateAlarmRequest) GetIntfId() string {
	if m != nil {
		return m.IntfId
	}
	return ""
}

func (m *SimulateAlarmRequest) GetPortTypeName() string {
	if m != nil {
		return m.PortTypeName
	}
	return ""
}

func (m *SimulateAlarmRequest) GetOnuDeviceId() string {
	if m != nil {
		return m.OnuDeviceId
	}
	return ""
}

func (m *SimulateAlarmRequest) GetInverseBitErrorRate() int32 {
	if m != nil {
		return m.InverseBitErrorRate
	}
	return 0
}

func (m *SimulateAlarmRequest) GetDrift() int32 {
	if m != nil {
		return m.Drift
	}
	return 0
}

func (m *SimulateAlarmRequest) GetNewEqd() int32 {
	if m != nil {
		return m.NewEqd
	}
	return 0
}

func (m *SimulateAlarmRequest) GetOnuSerialNumber() string {
	if m != nil {
		return m.OnuSerialNumber
	}
	return ""
}

func (m *SimulateAlarmRequest) GetOperation() SimulateAlarmRequest_OperationType {
	if m != nil {
		return m.Operation
	}
	return SimulateAlarmRequest_RAISE
}

func init() {
	proto.RegisterEnum("voltha.PmConfig_PmType", PmConfig_PmType_name, PmConfig_PmType_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageDownloadState", ImageDownload_ImageDownloadState_name, ImageDownload_ImageDownloadState_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageDownloadFailureReason", ImageDownload_ImageDownloadFailureReason_name, ImageDownload_ImageDownloadFailureReason_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageActivateState", ImageDownload_ImageActivateState_name, ImageDownload_ImageActivateState_value)
	proto.RegisterEnum("voltha.Port_PortType", Port_PortType_name, Port_PortType_value)
	proto.RegisterEnum("voltha.SimulateAlarmRequest_OperationType", SimulateAlarmRequest_OperationType_name, SimulateAlarmRequest_OperationType_value)
	proto.RegisterType((*DeviceType)(nil), "voltha.DeviceType")
	proto.RegisterType((*DeviceTypes)(nil), "voltha.DeviceTypes")
	proto.RegisterType((*PmConfig)(nil), "voltha.PmConfig")
	proto.RegisterType((*PmGroupConfig)(nil), "voltha.PmGroupConfig")
	proto.RegisterType((*PmConfigs)(nil), "voltha.PmConfigs")
	proto.RegisterType((*Image)(nil), "voltha.Image")
	proto.RegisterType((*Images)(nil), "voltha.Images")
	proto.RegisterType((*ImageDownload)(nil), "voltha.ImageDownload")
	proto.RegisterType((*ImageDownloads)(nil), "voltha.ImageDownloads")
	proto.RegisterType((*Port)(nil), "voltha.Port")
	proto.RegisterType((*Port_PeerPort)(nil), "voltha.Port.PeerPort")
	proto.RegisterType((*Ports)(nil), "voltha.Ports")
	proto.RegisterType((*Device)(nil), "voltha.Device")
	proto.RegisterType((*Device_ProxyAddress)(nil), "voltha.Device.ProxyAddress")
	proto.RegisterType((*Devices)(nil), "voltha.Devices")
	proto.RegisterType((*SimulateAlarmRequest)(nil), "voltha.SimulateAlarmRequest")
}

func init() { proto.RegisterFile("voltha_protos/device.proto", fileDescriptor_200940f73d155856) }

var fileDescriptor_200940f73d155856 = []byte{
	// 2378 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x58, 0xcb, 0x6e, 0x1b, 0xc9,
	0xd5, 0x36, 0x29, 0x75, 0x93, 0x7d, 0x78, 0x51, 0xbb, 0x2c, 0xdb, 0x6d, 0xe9, 0x17, 0xe4, 0x9f,
	0x9e, 0x20, 0xb2, 0x1d, 0x4b, 0x8e, 0x1d, 0xcc, 0x0c, 0x02, 0x24, 0x30, 0x45, 0xb6, 0x6c, 0x22,
	0x0a, 0xa9, 0x29, 0x92, 0x9a, 0x24, 0x9b, 0x46, 0x8b, 0x5d, 0x94, 0x1a, 0xee, 0x0b, 0x5d, 0xd5,
	0xd4, 0x65, 0x56, 0x49, 0x06, 0xc9, 0x2a, 0xbb, 0x00, 0x79, 0x86, 0xbc, 0x41, 0x96, 0xc9, 0x0b,
	0x18, 0x79, 0x81, 0xac, 0xb2, 0x08, 0x82, 0xac, 0xb2, 0xf2, 0x3a, 0xa8, 0x1b, 0xd9, 0x2d, 0x3b,
	0x9e, 0xc9, 0xa6, 0x51, 0xf5, 0x9d, 0x4b, 0x55, 0x7d, 0x55, 0x75, 0xce, 0xa9, 0x86, 0x8d, 0xf3,
	0x34, 0xca, 0xce, 0x7c, 0x6f, 0x46, 0xd3, 0x2c, 0x65, 0x7b, 0x01, 0x39, 0x0f, 0x27, 0x64, 0x57,
	0xf4, 0x90, 0x29, 0x65, 0x1b, 0xf7, 0x4e, 0xd3, 0xf4, 0x34, 0x22, 0x7b, 0x02, 0x3d, 0x99, 0x4f,
	0xf7, 0xfc, 0xe4, 0x4a, 0xaa, 0x6c, 0x5c, 0x33, 0x9f, 0xa4, 0x71, 0x9c, 0x26, 0x4a, 0xe6, 0x14,
	0x65, 0x31, 0xc9, 0x7c, 0x25, 0xd9, 0x2e, 0x4a, 0xd2, 0x19, 0x49, 0xa6, 0x51, 0x7a, 0xe1, 0x7d,
	0xff, 0xb9, 0x52, 0xb8, 0x5f, 0x54, 0xb8, 0xf2, 0x93, 0x53, 0x2f, 0x9d, 0x65, 0x61, 0x9a, 0x30,
	0xa9, 0xd1, 0xfa, 0x73, 0x19, 0xa0, 0x2b, 0x26, 0x3b, 0xba, 0x9a, 0x11, 0xd4, 0x84, 0x72, 0x18,
	0x38, 0xa5, 0xfb, 0xa5, 0x1d, 0x0b, 0x97, 0xc3, 0x00, 0x6d, 0x82, 0x75, 0x4e, 0x92, 0x20, 0xa5,
	0x5e, 0x18, 0x38, 0x86, 0x80, 0xab, 0x12, 0xe8, 0x05, 0x68, 0x0b, 0x60, 0x21, 0x64, 0x8e, 0x79,
	0x7f, 0x65, 0xc7, 0xc2, 0x96, 0x96, 0x32, 0xe4, 0x40, 0xc5, 0x0f, 0xfc, 0x59, 0x46, 0xa8, 0x53,
	0x16, 0x96, 0xba, 0x8b, 0x3e, 0x03, 0xc7, 0x9f, 0x4c, 0xc8, 0x2c, 0x63, 0xde, 0xc9, 0x3c, 0x7a,
	0xed, 0x89, 0x49, 0xcf, 0x67, 0x81, 0x9f, 0x11, 0x67, 0xe5, 0x7e, 0x69, 0xa7, 0x8a, 0x6f, 0x2b,
	0xf9, 0xfe, 0x3c, 0x7a, 0x7d, 0x10, 0xa5, 0x17, 0x63, 0x21, 0x44, 0x5d, 0xd8, 0xd6, 0x86, 0x7e,
	0x10, 0x78, 0x94, 0xc4, 0xe9, 0x39, 0xc9, 0x9b, 0x33, 0x67, 0x55, 0xd8, 0x6f, 0x2a, 0xb5, 0x76,
	0x10, 0x60, 0xa1, 0xb4, 0x74, 0xc2, 0xd0, 0x21, 0x3c, 0xd0, 0x5e, 0x82, 0x90, 0x92, 0x49, 0xe6,
	0x45, 0xe9, 0x69, 0x38, 0xf1, 0x23, 0xe1, 0x89, 0xe9, 0x99, 0x54, 0x84, 0x27, 0x3d, 0x60, 0x57,
	0x68, 0x1e, 0x4a, 0x45, 0xee, 0x8d, 0x49, 0x77, 0xad, 0xcf, 0xa0, 0xb6, 0x24, 0x90, 0xa1, 0x1d,
	0x30, 0xc2, 0x8c, 0xc4, 0xcc, 0x29, 0xdd, 0x5f, 0xd9, 0xa9, 0x3d, 0x43, 0xbb, 0x72, 0x0b, 0x76,
	0x97, 0x3a, 0x58, 0x2a, 0xb4, 0xfe, 0x52, 0x82, 0xea, 0x51, 0xdc, 0x49, 0x93, 0x69, 0x78, 0x8a,
	0x10, 0xac, 0x26, 0x7e, 0x4c, 0x14, 0xf5, 0xa2, 0x8d, 0x1e, 0xc3, 0x6a, 0x76, 0x35, 0x23, 0x82,
	0xbd, 0xe6, 0xb3, 0xbb, 0xda, 0x93, 0xb6, 0xd9, 0x3d, 0x8a, 0x85, 0x3b, 0xa1, 0xc4, 0xd9, 0x26,
	0x89, 0x7f, 0x12, 0x91, 0x40, 0x51, 0xa8, 0xbb, 0x68, 0x1b, 0x6a, 0xcc, 0x8f, 0x67, 0x11, 0xf1,
	0xa6, 0x94, 0xbc, 0x11, 0x04, 0x35, 0x30, 0x48, 0xe8, 0x80, 0x92, 0x37, 0xad, 0xcf, 0xc1, 0x94,
	0xae, 0x50, 0x0d, 0x2a, 0x9d, 0xc1, 0xb8, 0x3f, 0x72, 0xb1, 0x7d, 0x03, 0x59, 0x60, 0xbc, 0x6c,
	0x8f, 0x5f, 0xba, 0x76, 0x89, 0x37, 0x87, 0xa3, 0xf6, 0xc8, 0xb5, 0xcb, 0x52, 0xa5, 0x3f, 0x72,
	0x7f, 0x36, 0xb2, 0x57, 0x5a, 0xbf, 0x2f, 0x41, 0xe3, 0x28, 0x7e, 0x49, 0xd3, 0xf9, 0x4c, 0xad,
	0x63, 0x0b, 0xe0, 0x94, 0x77, 0xbd, 0xdc, 0x6a, 0x2c, 0x81, 0xf4, 0xf9, 0x92, 0x16, 0x62, 0x31,
	0x95, 0xb2, 0x98, 0x8a, 0x14, 0xf3, 0x99, 0x7c, 0x64, 0x11, 0x8f, 0xa0, 0x12, 0x93, 0x8c, 0x86,
	0x13, 0xbe, 0xc3, 0x9c, 0x58, 0xfb, 0x3a, 0x1d, 0x58, 0x2b, 0xb4, 0xfe, 0x51, 0x02, 0x4b, 0xa3,
	0xec, 0xbd, 0x23, 0xfd, 0xff, 0x50, 0x0f, 0xc8, 0xd4, 0x9f, 0x47, 0x59, 0x7e, 0x12, 0x35, 0x85,
	0x89, 0x69, 0x6c, 0x43, 0x45, 0xcc, 0x49, 0x4f, 0x63, 0xdf, 0xf8, 0xe7, 0xbb, 0xb7, 0x5b, 0x25,
	0xac, 0x51, 0xf4, 0x08, 0x1a, 0xdc, 0xd6, 0x4b, 0xcf, 0x09, 0xa5, 0x61, 0x40, 0xe4, 0xa9, 0xd3,
	0x6a, 0x75, 0x2e, 0x1b, 0x28, 0x11, 0x7a, 0x02, 0xa6, 0x30, 0x63, 0x8e, 0x21, 0x26, 0x7e, 0x7b,
	0x39, 0xf1, 0x1c, 0x71, 0x58, 0x29, 0xe5, 0x17, 0x6a, 0x7e, 0xd3, 0x42, 0xff, 0x5a, 0x02, 0xa3,
	0x17, 0xfb, 0xa7, 0xe4, 0x83, 0xc7, 0xc7, 0x81, 0xca, 0x39, 0xa1, 0x2c, 0x4c, 0x13, 0x7d, 0xff,
	0x54, 0x97, 0x6b, 0x9f, 0xf9, 0xec, 0x4c, 0x2c, 0xce, 0xc2, 0xa2, 0x8d, 0x1e, 0x82, 0x1d, 0x26,
	0x2c, 0xf3, 0xa3, 0xc8, 0xe3, 0xc7, 0x3a, 0x0b, 0x63, 0xb9, 0x2a, 0x0b, 0xaf, 0x29, 0xbc, 0xab,
	0x60, 0x1e, 0x14, 0x42, 0xe6, 0xf9, 0x93, 0x2c, 0x3c, 0x27, 0x22, 0x28, 0x54, 0x71, 0x35, 0x64,
	0x6d, 0xd1, 0xe7, 0xf4, 0x86, 0xcc, 0xe3, 0x01, 0x2c, 0xcc, 0x32, 0x12, 0x38, 0xa6, 0x90, 0xd7,
	0x42, 0xd6, 0xd1, 0x10, 0xba, 0x07, 0xd5, 0x90, 0x79, 0xe7, 0x7e, 0x14, 0x06, 0xea, 0x92, 0x55,
	0x42, 0x76, 0xcc, 0xbb, 0xad, 0x27, 0x60, 0x8a, 0x05, 0x31, 0xf4, 0x00, 0x8c, 0x90, 0xb7, 0xd4,
	0x3d, 0x6a, 0x68, 0x16, 0x84, 0x18, 0x4b, 0x59, 0xeb, 0x5f, 0x15, 0x68, 0x08, 0xa0, 0x9b, 0x5e,
	0x24, 0x51, 0xea, 0x07, 0xef, 0xed, 0xb6, 0x26, 0xa6, 0x9c, 0x23, 0xc6, 0x86, 0x95, 0x39, 0x8d,
	0xd4, 0xea, 0x79, 0x93, 0x23, 0x13, 0x3a, 0x51, 0x57, 0x83, 0x37, 0xd1, 0x00, 0x9a, 0x81, 0xf2,
	0xe9, 0xb1, 0x8c, 0x87, 0x03, 0x43, 0xdc, 0xc2, 0x9d, 0xc2, 0x3c, 0xf4, 0xb0, 0xc5, 0xde, 0x90,
	0xeb, 0xe3, 0x46, 0x90, 0xef, 0xa2, 0x07, 0xd0, 0x10, 0x73, 0xf6, 0xf4, 0x9e, 0x98, 0x62, 0xf8,
	0xba, 0x00, 0x8f, 0xd5, 0xc6, 0x3c, 0x04, 0x5b, 0x5b, 0x91, 0xc0, 0x3b, 0xb9, 0xe2, 0x01, 0xad,
	0x22, 0x26, 0xb5, 0xb6, 0xc4, 0xf7, 0x39, 0x8c, 0x5e, 0x81, 0x49, 0x89, 0xcf, 0xd2, 0xc4, 0xa9,
	0x8a, 0x89, 0x3d, 0xfd, 0x16, 0x13, 0x3b, 0xf0, 0xc3, 0x68, 0x4e, 0x09, 0x16, 0x76, 0x58, 0xd9,
	0xa3, 0xef, 0xc2, 0x9a, 0x1f, 0x04, 0x21, 0xcf, 0x0a, 0x7e, 0xe4, 0x85, 0xc9, 0x34, 0x75, 0x2c,
	0x31, 0xb7, 0xe6, 0x12, 0xee, 0x25, 0xd3, 0x54, 0x06, 0x92, 0x73, 0xe2, 0x4d, 0xc4, 0x31, 0x74,
	0x40, 0x6c, 0x1d, 0x70, 0x48, 0x5d, 0xfe, 0x4d, 0xb0, 0xa2, 0x94, 0xc7, 0xd1, 0x20, 0xa4, 0x4e,
	0x4d, 0x66, 0x0b, 0x01, 0x74, 0x43, 0x8a, 0x7a, 0x50, 0x93, 0x04, 0x48, 0x3a, 0xeb, 0xdf, 0x48,
	0xa7, 0x38, 0x50, 0x7e, 0x46, 0x24, 0x9d, 0x20, 0x8c, 0x25, 0x97, 0x9b, 0x60, 0x4d, 0xc3, 0x88,
	0x78, 0x2c, 0xfc, 0x8a, 0x38, 0x0d, 0xc1, 0x4f, 0x95, 0x03, 0xc3, 0xf0, 0x2b, 0xd2, 0xfa, 0x53,
	0x09, 0xd0, 0xfb, 0xdb, 0x81, 0xd6, 0xc1, 0xee, 0x0e, 0xbe, 0xec, 0x1f, 0x0e, 0xda, 0x5d, 0x6f,
	0xdc, 0xff, 0x49, 0x7f, 0xf0, 0x65, 0xdf, 0xbe, 0x81, 0xee, 0x00, 0x5a, 0xa0, 0xc3, 0x71, 0xa7,
	0xe3, 0xba, 0x5d, 0xb7, 0x6b, 0x97, 0x0a, 0x38, 0x76, 0xbf, 0x18, 0xbb, 0xc3, 0x91, 0xdb, 0xb5,
	0xcb, 0x05, 0x2f, 0xc3, 0x51, 0x1b, 0x73, 0x74, 0x05, 0xdd, 0x82, 0xb5, 0x05, 0x7a, 0xd0, 0xee,
	0x1d, 0xba, 0x5d, 0x7b, 0x15, 0x39, 0xb0, 0x9e, 0x1b, 0x70, 0x38, 0x3e, 0x3a, 0x1a, 0x08, 0x75,
	0xa3, 0xe0, 0xbc, 0xd3, 0xee, 0x77, 0xdc, 0x43, 0x6e, 0x61, 0xb6, 0x7e, 0x5b, 0x82, 0x8d, 0xff,
	0xbe, 0x5f, 0xa8, 0x0e, 0xd5, 0xfe, 0xc0, 0x73, 0x31, 0x1e, 0xf0, 0xe8, 0xbc, 0x06, 0xb5, 0x5e,
	0xff, 0xb8, 0x7d, 0xd8, 0xeb, 0x7a, 0x63, 0x7c, 0x68, 0x97, 0x38, 0xd0, 0x75, 0x8f, 0x7b, 0x1d,
	0xd7, 0xdb, 0x1f, 0x0f, 0x7f, 0x6e, 0x97, 0xf9, 0x30, 0xbd, 0xfe, 0x70, 0x7c, 0x70, 0xd0, 0xeb,
	0xf4, 0xdc, 0xfe, 0xc8, 0x1b, 0x1e, 0xb5, 0x3b, 0xae, 0xbd, 0x82, 0x6e, 0x42, 0x43, 0x11, 0xa0,
	0x9c, 0xad, 0xa2, 0x06, 0x58, 0xcb, 0x89, 0x18, 0xad, 0xdf, 0x69, 0x0a, 0x0b, 0x5b, 0xc0, 0x0d,
	0x7b, 0x3f, 0x6d, 0xbf, 0x74, 0x73, 0xfc, 0x21, 0x68, 0x4a, 0xa8, 0xd7, 0x6f, 0x77, 0x46, 0xbd,
	0x63, 0x9e, 0x2c, 0xd6, 0xc1, 0x96, 0x98, 0x40, 0xda, 0xa3, 0x5e, 0xff, 0xa5, 0x5d, 0x46, 0x36,
	0xd4, 0x73, 0xa8, 0x2b, 0x59, 0x93, 0x08, 0x76, 0x8f, 0x5d, 0x2c, 0xd4, 0x56, 0x97, 0x0e, 0x25,
	0xc8, 0xa7, 0xf3, 0x43, 0xe3, 0xdf, 0xef, 0xde, 0x6e, 0xdd, 0x68, 0xfd, 0x08, 0x9a, 0x05, 0x76,
	0x18, 0x7a, 0xac, 0x73, 0x6d, 0xb9, 0x18, 0x59, 0x0b, 0x6a, 0x3a, 0xdd, 0xfe, 0xc1, 0x80, 0xd5,
	0xa3, 0x94, 0x66, 0xe8, 0x2e, 0x54, 0x66, 0x29, 0xcd, 0xbc, 0x24, 0x15, 0x71, 0xa2, 0x81, 0x4d,
	0xde, 0xed, 0xa7, 0x68, 0x1d, 0x8c, 0xc8, 0x3f, 0x21, 0x91, 0x0a, 0x16, 0xb2, 0x83, 0x1e, 0xaa,
	0x2c, 0xbc, 0x22, 0x0e, 0xec, 0x32, 0x7a, 0xa7, 0x34, 0x13, 0x9f, 0x5c, 0x0e, 0xfe, 0x31, 0xd4,
	0xfc, 0x20, 0x0e, 0x93, 0x42, 0xc4, 0xd8, 0xda, 0x55, 0xd5, 0x5c, 0x9b, 0x8b, 0x04, 0x93, 0xb9,
	0x26, 0x06, 0x7f, 0xd1, 0xe6, 0xf6, 0xe9, 0x8c, 0x50, 0x61, 0x3e, 0x67, 0x22, 0x42, 0xe4, 0xec,
	0x07, 0x33, 0x42, 0x87, 0x42, 0x92, 0x6b, 0x62, 0x48, 0x17, 0x6d, 0x7e, 0x2f, 0x64, 0xe1, 0xe9,
	0xa9, 0xc8, 0x6a, 0xe1, 0xaa, 0x04, 0x7a, 0x01, 0x27, 0x6b, 0x46, 0x08, 0x65, 0x4e, 0xf5, 0x5a,
	0x1a, 0x12, 0x0b, 0x21, 0x84, 0xf2, 0x06, 0x96, 0x3a, 0x3c, 0x4f, 0xd3, 0x4b, 0x6f, 0xe6, 0x4f,
	0x5e, 0x93, 0x8c, 0x89, 0x70, 0x60, 0x62, 0x8b, 0x5e, 0x1e, 0x49, 0x80, 0x47, 0x70, 0x7a, 0xa9,
	0xe2, 0x13, 0x08, 0x61, 0x85, 0x5e, 0xca, 0xb8, 0xb4, 0x09, 0x16, 0xbd, 0xf4, 0x08, 0xa5, 0x29,
	0x65, 0x22, 0x06, 0x98, 0xb8, 0x4a, 0x2f, 0x5d, 0xd1, 0xe7, 0x6e, 0xb3, 0xa5, 0xdb, 0xba, 0x74,
	0x9b, 0xe5, 0xdd, 0x66, 0xda, 0x6d, 0x43, 0xba, 0xcd, 0x96, 0x6e, 0xb3, 0x85, 0xdb, 0xa6, 0x74,
	0x9b, 0x29, 0xb7, 0x1b, 0x2f, 0xa0, 0xaa, 0x17, 0x50, 0xe4, 0xa0, 0x74, 0x8d, 0x83, 0xdc, 0xd6,
	0x97, 0xf3, 0x5b, 0xdf, 0x62, 0x50, 0xd5, 0x7b, 0xc9, 0x2b, 0x9c, 0xe5, 0x01, 0xb7, 0xa1, 0xee,
	0x8e, 0x5e, 0xb9, 0xb8, 0xef, 0x8e, 0xbc, 0x7e, 0xbf, 0x67, 0x97, 0x0a, 0xc8, 0xb8, 0xdf, 0x93,
	0x25, 0xd1, 0xd1, 0xa0, 0xef, 0x0d, 0x0e, 0x47, 0xf6, 0xca, 0xa2, 0xd3, 0x1f, 0xcb, 0x7b, 0x75,
	0xec, 0x72, 0x45, 0x2e, 0x33, 0x72, 0xdd, 0xfe, 0xd8, 0x36, 0xf5, 0xb9, 0x7e, 0x0c, 0x06, 0x1f,
	0x9b, 0xa1, 0x56, 0xb1, 0x74, 0xac, 0xe7, 0x77, 0x48, 0x9f, 0xe2, 0xbf, 0xd5, 0xc1, 0x94, 0xa5,
	0x24, 0xba, 0xbd, 0x4c, 0x75, 0xba, 0xf2, 0xe0, 0x19, 0xef, 0x5e, 0xae, 0x6a, 0x5c, 0x08, 0xe4,
	0xf9, 0xbc, 0x07, 0xab, 0x34, 0x4d, 0xb3, 0x62, 0x51, 0x23, 0x20, 0xd4, 0x02, 0x6b, 0xe6, 0x53,
	0x92, 0x64, 0x9c, 0xb6, 0xd5, 0xbc, 0x69, 0x55, 0xe2, 0xe2, 0x04, 0x35, 0x95, 0x8e, 0x26, 0x71,
	0x9d, 0x93, 0xb8, 0x28, 0x7b, 0xa4, 0xf0, 0x48, 0x5e, 0xa6, 0x2d, 0x30, 0xe5, 0x53, 0x40, 0x3e,
	0x1b, 0xb4, 0x92, 0x02, 0xd1, 0x26, 0x18, 0x71, 0x1a, 0x90, 0x48, 0xa6, 0x41, 0x2d, 0x95, 0x18,
	0x7a, 0x0a, 0xf6, 0x99, 0x4f, 0x83, 0x0b, 0x9f, 0x2e, 0xd3, 0x65, 0x25, 0xaf, 0xb7, 0xa6, 0xc5,
	0x3a, 0x71, 0x3e, 0x05, 0x7b, 0x1a, 0xd2, 0xb8, 0x60, 0x51, 0x2d, 0x58, 0x68, 0xb1, 0xb6, 0x78,
	0x02, 0xa6, 0xc8, 0x28, 0xf2, 0x74, 0xd7, 0x9e, 0x35, 0x0b, 0xc1, 0x83, 0x2d, 0xe6, 0x2b, 0x95,
	0x78, 0xc5, 0xc7, 0x08, 0x0d, 0xfd, 0xc8, 0x4b, 0xe6, 0xf1, 0x09, 0xa1, 0xe2, 0xd8, 0x2f, 0xbc,
	0xd7, 0xa5, 0xac, 0x2f, 0x44, 0x9c, 0xcb, 0xe5, 0xa3, 0xc9, 0x29, 0x70, 0xb9, 0x78, 0x3b, 0x6d,
	0x2f, 0x1f, 0x47, 0xb5, 0xbc, 0xc6, 0xe2, 0x8d, 0x84, 0x60, 0xf5, 0x3c, 0xf2, 0x13, 0x71, 0x49,
	0x1a, 0x58, 0xb4, 0x79, 0x02, 0x8e, 0xfd, 0x09, 0x7f, 0xfa, 0x50, 0xc2, 0xe4, 0x15, 0xb1, 0x30,
	0xc4, 0xfe, 0xa4, 0x2d, 0x11, 0xf4, 0x00, 0xea, 0xe1, 0xec, 0xfc, 0x07, 0x0b, 0x0d, 0x7e, 0x51,
	0xac, 0x57, 0x37, 0x70, 0x8d, 0xa3, 0x45, 0xa5, 0x4f, 0x17, 0x4a, 0x6b, 0x39, 0xa5, 0x4f, 0xb5,
	0xd2, 0x27, 0xd0, 0x38, 0x4b, 0x59, 0xe6, 0xf9, 0x49, 0x20, 0x76, 0xdb, 0xb9, 0xad, 0xb5, 0x38,
	0xdc, 0x4e, 0x02, 0x71, 0xd9, 0xb6, 0x00, 0xc8, 0x65, 0x46, 0x7d, 0xcf, 0xa7, 0xa7, 0xcc, 0xb9,
	0x2b, 0xab, 0x7d, 0x81, 0xb4, 0xe9, 0x29, 0x43, 0x2f, 0xa0, 0x31, 0xa3, 0xe9, 0xe5, 0xd5, 0x62,
	0xa8, 0x5b, 0x82, 0xea, 0xcd, 0xe2, 0x9b, 0x68, 0xf7, 0x88, 0xeb, 0xa8, 0x81, 0x71, 0x7d, 0x96,
	0xeb, 0x5d, 0x8f, 0xa8, 0xf6, 0xff, 0x1a, 0x51, 0xdd, 0x62, 0x44, 0xbd, 0xf9, 0x2d, 0x22, 0xaa,
	0xde, 0x89, 0x7c, 0x60, 0xdd, 0x5a, 0x14, 0x5b, 0x77, 0x0a, 0x87, 0x59, 0x55, 0x50, 0x5f, 0x40,
	0x73, 0x92, 0x26, 0x09, 0x7f, 0x49, 0xaa, 0x81, 0x90, 0x18, 0xe8, 0x81, 0x1e, 0xa8, 0x23, 0xa5,
	0x6a, 0xac, 0x42, 0x4f, 0xfb, 0x6a, 0x4c, 0xf2, 0x28, 0xfa, 0x1e, 0x98, 0x93, 0x39, 0xcb, 0xd2,
	0xd8, 0x79, 0x21, 0x38, 0x5b, 0xdf, 0x95, 0x3f, 0x0f, 0x76, 0xf5, 0xcf, 0x83, 0xdd, 0x76, 0x72,
	0x85, 0x95, 0x0e, 0x7a, 0x0e, 0x06, 0xdf, 0x24, 0xe6, 0xfc, 0xf2, 0x03, 0xa1, 0x63, 0xbf, 0xf9,
	0xf7, 0x77, 0x6f, 0xb7, 0xac, 0x45, 0xe8, 0xc3, 0x52, 0x17, 0x3d, 0x05, 0x43, 0xbc, 0x77, 0x9d,
	0x5f, 0x95, 0xc4, 0x10, 0x68, 0x37, 0xff, 0x03, 0x41, 0x3c, 0x71, 0xf7, 0x0d, 0x6e, 0x7a, 0x03,
	0x4b, 0x45, 0xf4, 0x02, 0x6a, 0x42, 0xac, 0xde, 0x33, 0xbf, 0x96, 0x76, 0x77, 0xdf, 0xb3, 0x13,
	0xef, 0x9a, 0x85, 0x31, 0x4c, 0x17, 0x10, 0xfa, 0x1c, 0x60, 0x16, 0xab, 0x02, 0x92, 0x39, 0x5f,
	0x4b, 0x07, 0x37, 0xaf, 0xbf, 0x70, 0x16, 0xa6, 0xd6, 0x6c, 0xf1, 0x8c, 0x3b, 0x84, 0x35, 0x59,
	0x3e, 0xea, 0x42, 0x98, 0x39, 0xbf, 0x29, 0x7d, 0x24, 0xed, 0xef, 0xd7, 0xb8, 0x0b, 0x53, 0x96,
	0xff, 0xb8, 0x19, 0x16, 0x2a, 0x87, 0x8d, 0xaf, 0xcb, 0x50, 0xcf, 0x1f, 0xbb, 0x8f, 0xa7, 0x8d,
	0x6d, 0xa8, 0x29, 0xe1, 0x32, 0xb2, 0x62, 0x08, 0x96, 0xbf, 0x4d, 0xb6, 0x00, 0x26, 0x67, 0x7e,
	0x92, 0x90, 0x88, 0x9b, 0xaf, 0xc8, 0x67, 0xad, 0x42, 0x7a, 0x01, 0xda, 0x01, 0x5b, 0x8b, 0xe5,
	0xeb, 0x57, 0xc5, 0xd8, 0x06, 0x6e, 0x2a, 0x5c, 0xd0, 0xd3, 0x0b, 0xd0, 0x1e, 0xdc, 0xd2, 0x9a,
	0x19, 0xa1, 0x71, 0x98, 0xf8, 0xbc, 0xfe, 0x56, 0x7f, 0x5e, 0x90, 0x12, 0x8d, 0x96, 0x12, 0x74,
	0x1b, 0xcc, 0x34, 0x99, 0x73, 0x87, 0xa6, 0x70, 0x68, 0xa4, 0xc9, 0xbc, 0x17, 0xa0, 0x4f, 0xa0,
	0xc9, 0x61, 0x46, 0x18, 0x0f, 0x76, 0xba, 0x1c, 0x68, 0xe0, 0x7a, 0x9a, 0xcc, 0x87, 0x12, 0xec,
	0x05, 0x2a, 0x01, 0xed, 0x5b, 0x3c, 0x16, 0x09, 0x1a, 0x5a, 0x7b, 0x50, 0x91, 0x97, 0x92, 0x47,
	0x80, 0x42, 0x36, 0x6a, 0x16, 0x2f, 0xad, 0xce, 0x47, 0x7f, 0x5c, 0x81, 0xf5, 0x61, 0x18, 0xcf,
	0x23, 0x3f, 0x23, 0xed, 0xc8, 0xa7, 0x31, 0x26, 0x6f, 0xe6, 0x84, 0x65, 0xef, 0x3d, 0xc4, 0xfe,
	0x0f, 0xac, 0x30, 0x09, 0xc2, 0x89, 0x9f, 0xa5, 0xfa, 0x7f, 0xd0, 0x12, 0xe0, 0x89, 0x39, 0x4c,
	0xb2, 0xa9, 0x66, 0xcf, 0xc2, 0x26, 0xef, 0xca, 0x85, 0x88, 0x63, 0xcb, 0x89, 0x97, 0xff, 0x14,
	0xe4, 0xa3, 0xb4, 0x3e, 0x53, 0xe9, 0x5a, 0xfc, 0x56, 0x68, 0x41, 0x83, 0x2f, 0x77, 0xb9, 0x83,
	0x92, 0xb0, 0x5a, 0x9a, 0xcc, 0xbb, 0x7a, 0x13, 0x9f, 0xc3, 0x9d, 0x30, 0xe1, 0xb9, 0x81, 0x78,
	0x27, 0x61, 0x26, 0x4b, 0x09, 0x8f, 0xf2, 0xa8, 0xc2, 0x99, 0x33, 0xf0, 0x2d, 0x25, 0xdd, 0x0f,
	0x33, 0x51, 0x56, 0x60, 0xf9, 0x6a, 0x30, 0x02, 0x1a, 0x4e, 0x33, 0x41, 0x9f, 0x81, 0x65, 0x87,
	0xcf, 0x36, 0x21, 0x17, 0x1e, 0x79, 0x13, 0x88, 0x24, 0x63, 0x60, 0x33, 0x21, 0x17, 0xee, 0x9b,
	0x00, 0x3d, 0x82, 0x9b, 0x92, 0xf6, 0x7c, 0xa6, 0x90, 0x8f, 0xa9, 0x35, 0xc1, 0x7c, 0x2e, 0x4b,
	0xbc, 0x02, 0x8b, 0x47, 0x18, 0xb9, 0xc1, 0x20, 0xe2, 0xc5, 0x23, 0xcd, 0xf1, 0x87, 0x18, 0x15,
	0x21, 0x4a, 0x68, 0x8b, 0x8a, 0x73, 0x69, 0xdc, 0xfa, 0x0e, 0x34, 0x0a, 0x32, 0x64, 0x81, 0x81,
	0xdb, 0xbd, 0xa1, 0x2b, 0x7f, 0xe2, 0x74, 0x0e, 0xdd, 0x36, 0xb6, 0x4b, 0xfb, 0x4f, 0x7e, 0xf1,
	0xf8, 0x34, 0xcc, 0xce, 0xe6, 0x27, 0x3c, 0x2a, 0x89, 0x9f, 0x85, 0x93, 0x94, 0x06, 0x7b, 0x72,
	0xc8, 0x27, 0xea, 0x17, 0xe1, 0x69, 0xaa, 0x80, 0x13, 0x53, 0x20, 0xcf, 0xff, 0x13, 0x00, 0x00,
	0xff, 0xff, 0x55, 0xf2, 0x46, 0x65, 0xda, 0x14, 0x00, 0x00,
}
