# Voltha CLI (~/cli)

## Overview

The Voltha CLI allows a user to manage OLT and ONU devices along with their corresponding logical devices.   


## Building the CLI

From the voltha-go directory:
```
cd python
source env.sh
make cli
```

## Usage

#### Setup (Development Mode)
Since the CLI does not do much by itself, then to fully use it, you will need a somewhat complete 
set of dependent containers running as well.  These will include the rw_core, OLT/ONU adapters and the actual OLT
 and ONU devices. For the examples below we will use ponsim as the adapters and ponsimv2 as the devices.  In order to get 
 everything running we also need Kafka (with zookeeper) and the Etcd KV store. 
 
First run the dependent containers from the voltha-go directory. In the commands below, replace the IP 
with the IP of the host.
```
DOCKER_HOST_IP=<Host IP> docker-compose -f compose/docker-compose-zk-kafka-test.yml up -d
DOCKER_HOST_IP=<Host IP> docker-compose -f compose/docker-compose-etcd.yml up -d
DOCKER_HOST_IP=<Host IP> docker-compose -f compose/rw_core.yml up -d
DOCKER_HOST_IP=<Host IP> docker-compose -f compose/cli.yml up -d
DOCKER_HOST_IP=<Host IP> docker-compose -f compose/adapters-ponsim.yml up -d
REPOSITORY=voltha/ docker-compose -f compose/ponsim_olt.yml up -d
REPOSITORY=voltha/ docker-compose -f compose/ponsim_onu.yml up -d
```

#### Starting the CLI

Now, start the CLI. Password for 'voltha' user is 'admin'. Please see Dockerfile.cli for passwords

```$xslt
tput rmam // If you are running on MAC for a clean output
ssh -p 5022 voltha@localhost
```

At the prompt, if you type ```help``` you will see all the supported commands and sub-commands.

####Provisioning and activating an OLT device

Run the following at the prompt

```$xslt
preprovision_olt -t ponsim_olt -H <IP of Ponsim OLT>:50060 // Note this is the actial ponsim_olt container IP
enable <deviceId>  // Use the device ID returned in the previous command
```

The ```enable``` command returns the logical device Id assigned to that OLT.  It is typically the MAC address 
(without the ```:```) of the OLT device.

Now go and try out the commands and sub-commands of the CLI.

####Changing the logging level of the RW Core via the CLI

You can dynamically change the logging level on the Voltha RW Core.  The change can be done at a package 
level or for the entire RW Core.  

The syntax to change log level is as follows:

```
log -p [package_name] -l log_level

where 
    package_name (optional) is one of:
        db/kvstore
        db/model
        kafka
        rw_core/core
        rw_core/flow_decomposition
        rw_core/graph
    
    log_level is one of:
        DEBUG
        INFO
        WARNING
        ERROR
        CRITICAL
        FATAL 
```

Below are some examples.
```$xslt
log -l ERROR // This sets the entire RW_CORE to output ERROR and above logs for all packages
log -p rw_core/core -l DEBUG // This sets the rw_core/core package to debug level
```

Typically, if you want to debug, say something with the kvstore, then you would set the log level for
the entire RW Core to error followed by setting the log level to debug for the kvstore as shown below.
```$xslt
log -l ERROR // This sets the entire RW_CORE to output ERROR and above logs for all packages
log -p db/kvstore -l DEBUG // This sets the db/kvstore package to debug level
```

###Future CLI improvements

* Add auto-completion for most common args like device and logical device ids
* Add consistent argument checking
* Unify code that retrieves data from gRPC
* Unify code that prints out data/response, to allow:
  * Selectable output mode:
    * JSON
    * Tabular
* Organize history per sub context so that in each context the commands 
  entered in that context will show
* Metaprogramming [BIG ONE]: Make large part of the commands come from annotations embedded in
  the protobuf files and have corresponding handler auto-generated by protoc
* Package CLI as docker container, bake it into composition
