/*
 * Copyright 2021-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/opencord/voltha-lib-go/v7/pkg/kafka (interfaces: InterContainerProxy)

// Package device is a generated GoMock package.
package device

import (
	context "context"
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	any "github.com/golang/protobuf/ptypes/any"
	kafka "github.com/opencord/voltha-lib-go/v7/pkg/kafka"
)

// MockInterContainerProxy is a mock of InterContainerProxy interface.
type MockInterContainerProxy struct {
	ctrl     *gomock.Controller
	recorder *MockInterContainerProxyMockRecorder
}

// MockInterContainerProxyMockRecorder is the mock recorder for MockInterContainerProxy.
type MockInterContainerProxyMockRecorder struct {
	mock *MockInterContainerProxy
}

// NewMockInterContainerProxy creates a new mock instance.
func NewMockInterContainerProxy(ctrl *gomock.Controller) *MockInterContainerProxy {
	mock := &MockInterContainerProxy{ctrl: ctrl}
	mock.recorder = &MockInterContainerProxyMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockInterContainerProxy) EXPECT() *MockInterContainerProxyMockRecorder {
	return m.recorder
}

// DeleteTopic mocks base method.
func (m *MockInterContainerProxy) DeleteTopic(arg0 context.Context, arg1 kafka.Topic) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTopic", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteTopic indicates an expected call of DeleteTopic.
func (mr *MockInterContainerProxyMockRecorder) DeleteTopic(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTopic", reflect.TypeOf((*MockInterContainerProxy)(nil).DeleteTopic), arg0, arg1)
}

// EnableLivenessChannel mocks base method.
func (m *MockInterContainerProxy) EnableLivenessChannel(arg0 context.Context, arg1 bool) chan bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableLivenessChannel", arg0, arg1)
	ret0, _ := ret[0].(chan bool)
	return ret0
}

// EnableLivenessChannel indicates an expected call of EnableLivenessChannel.
func (mr *MockInterContainerProxyMockRecorder) EnableLivenessChannel(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableLivenessChannel", reflect.TypeOf((*MockInterContainerProxy)(nil).EnableLivenessChannel), arg0, arg1)
}

// GetDefaultTopic mocks base method.
func (m *MockInterContainerProxy) GetDefaultTopic() *kafka.Topic {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDefaultTopic")
	ret0, _ := ret[0].(*kafka.Topic)
	return ret0
}

// GetDefaultTopic indicates an expected call of GetDefaultTopic.
func (mr *MockInterContainerProxyMockRecorder) GetDefaultTopic() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDefaultTopic", reflect.TypeOf((*MockInterContainerProxy)(nil).GetDefaultTopic))
}

// InvokeAsyncRPC mocks base method.
func (m *MockInterContainerProxy) InvokeAsyncRPC(arg0 context.Context, arg1 string, arg2, arg3 *kafka.Topic, arg4 bool, arg5 string, arg6 ...*kafka.KVArg) chan *kafka.RpcResponse {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2, arg3, arg4, arg5}
	for _, a := range arg6 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "InvokeAsyncRPC", varargs...)
	ret0, _ := ret[0].(chan *kafka.RpcResponse)
	return ret0
}

// InvokeAsyncRPC indicates an expected call of InvokeAsyncRPC.
func (mr *MockInterContainerProxyMockRecorder) InvokeAsyncRPC(arg0, arg1, arg2, arg3, arg4, arg5 interface{}, arg6 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2, arg3, arg4, arg5}, arg6...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InvokeAsyncRPC", reflect.TypeOf((*MockInterContainerProxy)(nil).InvokeAsyncRPC), varargs...)
}

// InvokeRPC mocks base method.
func (m *MockInterContainerProxy) InvokeRPC(arg0 context.Context, arg1 string, arg2, arg3 *kafka.Topic, arg4 bool, arg5 string, arg6 ...*kafka.KVArg) (bool, *any.Any) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2, arg3, arg4, arg5}
	for _, a := range arg6 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "InvokeRPC", varargs...)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(*any.Any)
	return ret0, ret1
}

// InvokeRPC indicates an expected call of InvokeRPC.
func (mr *MockInterContainerProxyMockRecorder) InvokeRPC(arg0, arg1, arg2, arg3, arg4, arg5 interface{}, arg6 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2, arg3, arg4, arg5}, arg6...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InvokeRPC", reflect.TypeOf((*MockInterContainerProxy)(nil).InvokeRPC), varargs...)
}

// SendLiveness mocks base method.
func (m *MockInterContainerProxy) SendLiveness(arg0 context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SendLiveness", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// SendLiveness indicates an expected call of SendLiveness.
func (mr *MockInterContainerProxyMockRecorder) SendLiveness(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendLiveness", reflect.TypeOf((*MockInterContainerProxy)(nil).SendLiveness), arg0)
}

// Start mocks base method.
func (m *MockInterContainerProxy) Start(arg0 context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Start", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// Start indicates an expected call of Start.
func (mr *MockInterContainerProxyMockRecorder) Start(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Start", reflect.TypeOf((*MockInterContainerProxy)(nil).Start), arg0)
}

// Stop mocks base method.
func (m *MockInterContainerProxy) Stop(arg0 context.Context) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Stop", arg0)
}

// Stop indicates an expected call of Stop.
func (mr *MockInterContainerProxyMockRecorder) Stop(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Stop", reflect.TypeOf((*MockInterContainerProxy)(nil).Stop), arg0)
}

// SubscribeWithDefaultRequestHandler mocks base method.
func (m *MockInterContainerProxy) SubscribeWithDefaultRequestHandler(arg0 context.Context, arg1 kafka.Topic, arg2 int64) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SubscribeWithDefaultRequestHandler", arg0, arg1, arg2)
	ret0, _ := ret[0].(error)
	return ret0
}

// SubscribeWithDefaultRequestHandler indicates an expected call of SubscribeWithDefaultRequestHandler.
func (mr *MockInterContainerProxyMockRecorder) SubscribeWithDefaultRequestHandler(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SubscribeWithDefaultRequestHandler", reflect.TypeOf((*MockInterContainerProxy)(nil).SubscribeWithDefaultRequestHandler), arg0, arg1, arg2)
}

// SubscribeWithRequestHandlerInterface mocks base method.
func (m *MockInterContainerProxy) SubscribeWithRequestHandlerInterface(arg0 context.Context, arg1 kafka.Topic, arg2 interface{}) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SubscribeWithRequestHandlerInterface", arg0, arg1, arg2)
	ret0, _ := ret[0].(error)
	return ret0
}

// SubscribeWithRequestHandlerInterface indicates an expected call of SubscribeWithRequestHandlerInterface.
func (mr *MockInterContainerProxyMockRecorder) SubscribeWithRequestHandlerInterface(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SubscribeWithRequestHandlerInterface", reflect.TypeOf((*MockInterContainerProxy)(nil).SubscribeWithRequestHandlerInterface), arg0, arg1, arg2)
}

// UnSubscribeFromRequestHandler mocks base method.
func (m *MockInterContainerProxy) UnSubscribeFromRequestHandler(arg0 context.Context, arg1 kafka.Topic) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UnSubscribeFromRequestHandler", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// UnSubscribeFromRequestHandler indicates an expected call of UnSubscribeFromRequestHandler.
func (mr *MockInterContainerProxyMockRecorder) UnSubscribeFromRequestHandler(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UnSubscribeFromRequestHandler", reflect.TypeOf((*MockInterContainerProxy)(nil).UnSubscribeFromRequestHandler), arg0, arg1)
}
