# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template module.py
# Do not modify

import struct
import loxi
import util
import loxi.generic_util

import sys
ofp = sys.modules['loxi.of10']

class bsn_interface(loxi.OFObject):

    def __init__(self, hw_addr=None, name=None, ipv4_addr=None, ipv4_netmask=None):
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if ipv4_addr != None:
            self.ipv4_addr = ipv4_addr
        else:
            self.ipv4_addr = 0
        if ipv4_netmask != None:
            self.ipv4_netmask = ipv4_netmask
        else:
            self.ipv4_netmask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.ipv4_addr))
        packed.append(struct.pack("!L", self.ipv4_netmask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_interface()
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.name = reader.read("!16s")[0].rstrip("\x00")
        obj.ipv4_addr = reader.read("!L")[0]
        obj.ipv4_netmask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.ipv4_addr != other.ipv4_addr: return False
        if self.ipv4_netmask != other.ipv4_netmask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_interface {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("ipv4_addr = ");
                q.text(util.pretty_ipv4(self.ipv4_addr))
                q.text(","); q.breakable()
                q.text("ipv4_netmask = ");
                q.text(util.pretty_ipv4(self.ipv4_netmask))
            q.breakable()
        q.text('}')


class bsn_vport(loxi.OFObject):
    subtypes = {}


    def __init__(self, type=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 0)
        subclass = bsn_vport.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = bsn_vport()
        obj.type = reader.read("!H")[0]
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vport {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class bsn_vport_l2gre(bsn_vport):
    type = 1

    def __init__(self, flags=None, port_no=None, loopback_port_no=None, local_mac=None, nh_mac=None, src_ip=None, dst_ip=None, dscp=None, ttl=None, vpn=None, rate_limit=None, if_name=None):
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if loopback_port_no != None:
            self.loopback_port_no = loopback_port_no
        else:
            self.loopback_port_no = 0
        if local_mac != None:
            self.local_mac = local_mac
        else:
            self.local_mac = [0,0,0,0,0,0]
        if nh_mac != None:
            self.nh_mac = nh_mac
        else:
            self.nh_mac = [0,0,0,0,0,0]
        if src_ip != None:
            self.src_ip = src_ip
        else:
            self.src_ip = 0
        if dst_ip != None:
            self.dst_ip = dst_ip
        else:
            self.dst_ip = 0
        if dscp != None:
            self.dscp = dscp
        else:
            self.dscp = 0
        if ttl != None:
            self.ttl = ttl
        else:
            self.ttl = 0
        if vpn != None:
            self.vpn = vpn
        else:
            self.vpn = 0
        if rate_limit != None:
            self.rate_limit = rate_limit
        else:
            self.rate_limit = 0
        if if_name != None:
            self.if_name = if_name
        else:
            self.if_name = ""
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.flags))
        packed.append(util.pack_port_no(self.port_no))
        packed.append(util.pack_port_no(self.loopback_port_no))
        packed.append(struct.pack("!6B", *self.local_mac))
        packed.append(struct.pack("!6B", *self.nh_mac))
        packed.append(struct.pack("!L", self.src_ip))
        packed.append(struct.pack("!L", self.dst_ip))
        packed.append(struct.pack("!B", self.dscp))
        packed.append(struct.pack("!B", self.ttl))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.vpn))
        packed.append(struct.pack("!L", self.rate_limit))
        packed.append(struct.pack("!16s", self.if_name))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vport_l2gre()
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.flags = reader.read("!L")[0]
        obj.port_no = util.unpack_port_no(reader)
        obj.loopback_port_no = util.unpack_port_no(reader)
        obj.local_mac = list(reader.read('!6B'))
        obj.nh_mac = list(reader.read('!6B'))
        obj.src_ip = reader.read("!L")[0]
        obj.dst_ip = reader.read("!L")[0]
        obj.dscp = reader.read("!B")[0]
        obj.ttl = reader.read("!B")[0]
        reader.skip(2)
        obj.vpn = reader.read("!L")[0]
        obj.rate_limit = reader.read("!L")[0]
        obj.if_name = reader.read("!16s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        if self.loopback_port_no != other.loopback_port_no: return False
        if self.local_mac != other.local_mac: return False
        if self.nh_mac != other.nh_mac: return False
        if self.src_ip != other.src_ip: return False
        if self.dst_ip != other.dst_ip: return False
        if self.dscp != other.dscp: return False
        if self.ttl != other.ttl: return False
        if self.vpn != other.vpn: return False
        if self.rate_limit != other.rate_limit: return False
        if self.if_name != other.if_name: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vport_l2gre {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("loopback_port_no = ");
                q.text(util.pretty_port(self.loopback_port_no))
                q.text(","); q.breakable()
                q.text("local_mac = ");
                q.text(util.pretty_mac(self.local_mac))
                q.text(","); q.breakable()
                q.text("nh_mac = ");
                q.text(util.pretty_mac(self.nh_mac))
                q.text(","); q.breakable()
                q.text("src_ip = ");
                q.text(util.pretty_ipv4(self.src_ip))
                q.text(","); q.breakable()
                q.text("dst_ip = ");
                q.text(util.pretty_ipv4(self.dst_ip))
                q.text(","); q.breakable()
                q.text("dscp = ");
                q.text("%#x" % self.dscp)
                q.text(","); q.breakable()
                q.text("ttl = ");
                q.text("%#x" % self.ttl)
                q.text(","); q.breakable()
                q.text("vpn = ");
                q.text("%#x" % self.vpn)
                q.text(","); q.breakable()
                q.text("rate_limit = ");
                q.text("%#x" % self.rate_limit)
                q.text(","); q.breakable()
                q.text("if_name = ");
                q.pp(self.if_name)
            q.breakable()
        q.text('}')

bsn_vport.subtypes[1] = bsn_vport_l2gre

class bsn_vport_q_in_q(bsn_vport):
    type = 0

    def __init__(self, port_no=None, ingress_tpid=None, ingress_vlan_id=None, egress_tpid=None, egress_vlan_id=None, if_name=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if ingress_tpid != None:
            self.ingress_tpid = ingress_tpid
        else:
            self.ingress_tpid = 0
        if ingress_vlan_id != None:
            self.ingress_vlan_id = ingress_vlan_id
        else:
            self.ingress_vlan_id = 0
        if egress_tpid != None:
            self.egress_tpid = egress_tpid
        else:
            self.egress_tpid = 0
        if egress_vlan_id != None:
            self.egress_vlan_id = egress_vlan_id
        else:
            self.egress_vlan_id = 0
        if if_name != None:
            self.if_name = if_name
        else:
            self.if_name = ""
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.port_no))
        packed.append(struct.pack("!H", self.ingress_tpid))
        packed.append(struct.pack("!H", self.ingress_vlan_id))
        packed.append(struct.pack("!H", self.egress_tpid))
        packed.append(struct.pack("!H", self.egress_vlan_id))
        packed.append(struct.pack("!16s", self.if_name))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vport_q_in_q()
        _type = reader.read("!H")[0]
        assert(_type == 0)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 4)
        obj.port_no = reader.read("!L")[0]
        obj.ingress_tpid = reader.read("!H")[0]
        obj.ingress_vlan_id = reader.read("!H")[0]
        obj.egress_tpid = reader.read("!H")[0]
        obj.egress_vlan_id = reader.read("!H")[0]
        obj.if_name = reader.read("!16s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.ingress_tpid != other.ingress_tpid: return False
        if self.ingress_vlan_id != other.ingress_vlan_id: return False
        if self.egress_tpid != other.egress_tpid: return False
        if self.egress_vlan_id != other.egress_vlan_id: return False
        if self.if_name != other.if_name: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vport_q_in_q {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text("%#x" % self.port_no)
                q.text(","); q.breakable()
                q.text("ingress_tpid = ");
                q.text("%#x" % self.ingress_tpid)
                q.text(","); q.breakable()
                q.text("ingress_vlan_id = ");
                q.text("%#x" % self.ingress_vlan_id)
                q.text(","); q.breakable()
                q.text("egress_tpid = ");
                q.text("%#x" % self.egress_tpid)
                q.text(","); q.breakable()
                q.text("egress_vlan_id = ");
                q.text("%#x" % self.egress_vlan_id)
                q.text(","); q.breakable()
                q.text("if_name = ");
                q.pp(self.if_name)
            q.breakable()
        q.text('}')

bsn_vport.subtypes[0] = bsn_vport_q_in_q

class flow_stats_entry(loxi.OFObject):

    def __init__(self, table_id=None, match=None, duration_sec=None, duration_nsec=None, priority=None, idle_timeout=None, hard_timeout=None, cookie=None, packet_count=None, byte_count=None, actions=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if match != None:
            self.match = match
        else:
            self.match = ofp.match()
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 1)
        packed.append(self.match.pack())
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append('\x00' * 6)
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(loxi.generic_util.pack_list(self.actions))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length, 2)
        obj.table_id = reader.read("!B")[0]
        reader.skip(1)
        obj.match = ofp.match.unpack(reader)
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        obj.priority = reader.read("!H")[0]
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        reader.skip(6)
        obj.cookie = reader.read("!Q")[0]
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        obj.actions = loxi.generic_util.unpack_list(reader, ofp.action.action.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.match != other.match: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.priority != other.priority: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.cookie != other.cookie: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.actions != other.actions: return False
        return True

    def pretty_print(self, q):
        q.text("flow_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')


class match_v1(loxi.OFObject):

    def __init__(self, wildcards=None, in_port=None, eth_src=None, eth_dst=None, vlan_vid=None, vlan_pcp=None, eth_type=None, ip_dscp=None, ip_proto=None, ipv4_src=None, ipv4_dst=None, tcp_src=None, tcp_dst=None):
        if wildcards != None:
            self.wildcards = wildcards
        else:
            self.wildcards = util.init_wc_bmap()
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if eth_src != None:
            self.eth_src = eth_src
        else:
            self.eth_src = [0,0,0,0,0,0]
        if eth_dst != None:
            self.eth_dst = eth_dst
        else:
            self.eth_dst = [0,0,0,0,0,0]
        if vlan_vid != None:
            self.vlan_vid = vlan_vid
        else:
            self.vlan_vid = 0
        if vlan_pcp != None:
            self.vlan_pcp = vlan_pcp
        else:
            self.vlan_pcp = 0
        if eth_type != None:
            self.eth_type = eth_type
        else:
            self.eth_type = 0
        if ip_dscp != None:
            self.ip_dscp = ip_dscp
        else:
            self.ip_dscp = 0
        if ip_proto != None:
            self.ip_proto = ip_proto
        else:
            self.ip_proto = 0
        if ipv4_src != None:
            self.ipv4_src = ipv4_src
        else:
            self.ipv4_src = 0
        if ipv4_dst != None:
            self.ipv4_dst = ipv4_dst
        else:
            self.ipv4_dst = 0
        if tcp_src != None:
            self.tcp_src = tcp_src
        else:
            self.tcp_src = 0
        if tcp_dst != None:
            self.tcp_dst = tcp_dst
        else:
            self.tcp_dst = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_wc_bmap(self.wildcards))
        packed.append(util.pack_port_no(self.in_port))
        packed.append(struct.pack("!6B", *self.eth_src))
        packed.append(struct.pack("!6B", *self.eth_dst))
        packed.append(struct.pack("!H", self.vlan_vid))
        packed.append(struct.pack("!B", self.vlan_pcp))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.eth_type))
        packed.append(struct.pack("!B", self.ip_dscp))
        packed.append(struct.pack("!B", self.ip_proto))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.ipv4_src))
        packed.append(struct.pack("!L", self.ipv4_dst))
        packed.append(struct.pack("!H", self.tcp_src))
        packed.append(struct.pack("!H", self.tcp_dst))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = match_v1()
        obj.wildcards = util.unpack_wc_bmap(reader)
        obj.in_port = util.unpack_port_no(reader)
        obj.eth_src = list(reader.read('!6B'))
        obj.eth_dst = list(reader.read('!6B'))
        obj.vlan_vid = reader.read("!H")[0]
        obj.vlan_pcp = reader.read("!B")[0]
        reader.skip(1)
        obj.eth_type = reader.read("!H")[0]
        obj.ip_dscp = reader.read("!B")[0]
        obj.ip_proto = reader.read("!B")[0]
        reader.skip(2)
        obj.ipv4_src = reader.read("!L")[0]
        obj.ipv4_dst = reader.read("!L")[0]
        obj.tcp_src = reader.read("!H")[0]
        obj.tcp_dst = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.wildcards != other.wildcards: return False
        if self.in_port != other.in_port: return False
        if self.eth_src != other.eth_src: return False
        if self.eth_dst != other.eth_dst: return False
        if self.vlan_vid != other.vlan_vid: return False
        if self.vlan_pcp != other.vlan_pcp: return False
        if self.eth_type != other.eth_type: return False
        if self.ip_dscp != other.ip_dscp: return False
        if self.ip_proto != other.ip_proto: return False
        if self.ipv4_src != other.ipv4_src: return False
        if self.ipv4_dst != other.ipv4_dst: return False
        if self.tcp_src != other.tcp_src: return False
        if self.tcp_dst != other.tcp_dst: return False
        return True

    def pretty_print(self, q):
        q.text("match_v1 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("wildcards = ");
                q.text(util.pretty_wildcards(self.wildcards))
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("eth_src = ");
                q.text(util.pretty_mac(self.eth_src))
                q.text(","); q.breakable()
                q.text("eth_dst = ");
                q.text(util.pretty_mac(self.eth_dst))
                q.text(","); q.breakable()
                q.text("vlan_vid = ");
                q.text("%#x" % self.vlan_vid)
                q.text(","); q.breakable()
                q.text("vlan_pcp = ");
                q.text("%#x" % self.vlan_pcp)
                q.text(","); q.breakable()
                q.text("eth_type = ");
                q.text("%#x" % self.eth_type)
                q.text(","); q.breakable()
                q.text("ip_dscp = ");
                q.text("%#x" % self.ip_dscp)
                q.text(","); q.breakable()
                q.text("ip_proto = ");
                q.text("%#x" % self.ip_proto)
                q.text(","); q.breakable()
                q.text("ipv4_src = ");
                q.text(util.pretty_ipv4(self.ipv4_src))
                q.text(","); q.breakable()
                q.text("ipv4_dst = ");
                q.text(util.pretty_ipv4(self.ipv4_dst))
                q.text(","); q.breakable()
                q.text("tcp_src = ");
                q.text("%#x" % self.tcp_src)
                q.text(","); q.breakable()
                q.text("tcp_dst = ");
                q.text("%#x" % self.tcp_dst)
            q.breakable()
        q.text('}')


class packet_queue(loxi.OFObject):

    def __init__(self, queue_id=None, properties=None):
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if properties != None:
            self.properties = properties
        else:
            self.properties = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 2)
        packed.append(loxi.generic_util.pack_list(self.properties))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = packet_queue()
        obj.queue_id = reader.read("!L")[0]
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 6)
        reader.skip(2)
        obj.properties = loxi.generic_util.unpack_list(reader, ofp.common.queue_prop.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.queue_id != other.queue_id: return False
        if self.properties != other.properties: return False
        return True

    def pretty_print(self, q):
        q.text("packet_queue {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("properties = ");
                q.pp(self.properties)
            q.breakable()
        q.text('}')


class port_desc(loxi.OFObject):

    def __init__(self, port_no=None, hw_addr=None, name=None, config=None, state=None, curr=None, advertised=None, supported=None, peer=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if config != None:
            self.config = config
        else:
            self.config = 0
        if state != None:
            self.state = state
        else:
            self.state = 0
        if curr != None:
            self.curr = curr
        else:
            self.curr = 0
        if advertised != None:
            self.advertised = advertised
        else:
            self.advertised = 0
        if supported != None:
            self.supported = supported
        else:
            self.supported = 0
        if peer != None:
            self.peer = peer
        else:
            self.peer = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.state))
        packed.append(struct.pack("!L", self.curr))
        packed.append(struct.pack("!L", self.advertised))
        packed.append(struct.pack("!L", self.supported))
        packed.append(struct.pack("!L", self.peer))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_desc()
        obj.port_no = util.unpack_port_no(reader)
        obj.hw_addr = list(reader.read('!6B'))
        obj.name = reader.read("!16s")[0].rstrip("\x00")
        obj.config = reader.read("!L")[0]
        obj.state = reader.read("!L")[0]
        obj.curr = reader.read("!L")[0]
        obj.advertised = reader.read("!L")[0]
        obj.supported = reader.read("!L")[0]
        obj.peer = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.config != other.config: return False
        if self.state != other.state: return False
        if self.curr != other.curr: return False
        if self.advertised != other.advertised: return False
        if self.supported != other.supported: return False
        if self.peer != other.peer: return False
        return True

    def pretty_print(self, q):
        q.text("port_desc {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("state = ");
                q.text("%#x" % self.state)
                q.text(","); q.breakable()
                q.text("curr = ");
                q.text("%#x" % self.curr)
                q.text(","); q.breakable()
                q.text("advertised = ");
                q.text("%#x" % self.advertised)
                q.text(","); q.breakable()
                q.text("supported = ");
                q.text("%#x" % self.supported)
                q.text(","); q.breakable()
                q.text("peer = ");
                q.text("%#x" % self.peer)
            q.breakable()
        q.text('}')


class port_stats_entry(loxi.OFObject):

    def __init__(self, port_no=None, rx_packets=None, tx_packets=None, rx_bytes=None, tx_bytes=None, rx_dropped=None, tx_dropped=None, rx_errors=None, tx_errors=None, rx_frame_err=None, rx_over_err=None, rx_crc_err=None, collisions=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if rx_packets != None:
            self.rx_packets = rx_packets
        else:
            self.rx_packets = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if rx_bytes != None:
            self.rx_bytes = rx_bytes
        else:
            self.rx_bytes = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if rx_dropped != None:
            self.rx_dropped = rx_dropped
        else:
            self.rx_dropped = 0
        if tx_dropped != None:
            self.tx_dropped = tx_dropped
        else:
            self.tx_dropped = 0
        if rx_errors != None:
            self.rx_errors = rx_errors
        else:
            self.rx_errors = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        if rx_frame_err != None:
            self.rx_frame_err = rx_frame_err
        else:
            self.rx_frame_err = 0
        if rx_over_err != None:
            self.rx_over_err = rx_over_err
        else:
            self.rx_over_err = 0
        if rx_crc_err != None:
            self.rx_crc_err = rx_crc_err
        else:
            self.rx_crc_err = 0
        if collisions != None:
            self.collisions = collisions
        else:
            self.collisions = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 6)
        packed.append(struct.pack("!Q", self.rx_packets))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.rx_bytes))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.rx_dropped))
        packed.append(struct.pack("!Q", self.tx_dropped))
        packed.append(struct.pack("!Q", self.rx_errors))
        packed.append(struct.pack("!Q", self.tx_errors))
        packed.append(struct.pack("!Q", self.rx_frame_err))
        packed.append(struct.pack("!Q", self.rx_over_err))
        packed.append(struct.pack("!Q", self.rx_crc_err))
        packed.append(struct.pack("!Q", self.collisions))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_stats_entry()
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(6)
        obj.rx_packets = reader.read("!Q")[0]
        obj.tx_packets = reader.read("!Q")[0]
        obj.rx_bytes = reader.read("!Q")[0]
        obj.tx_bytes = reader.read("!Q")[0]
        obj.rx_dropped = reader.read("!Q")[0]
        obj.tx_dropped = reader.read("!Q")[0]
        obj.rx_errors = reader.read("!Q")[0]
        obj.tx_errors = reader.read("!Q")[0]
        obj.rx_frame_err = reader.read("!Q")[0]
        obj.rx_over_err = reader.read("!Q")[0]
        obj.rx_crc_err = reader.read("!Q")[0]
        obj.collisions = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.rx_packets != other.rx_packets: return False
        if self.tx_packets != other.tx_packets: return False
        if self.rx_bytes != other.rx_bytes: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.rx_dropped != other.rx_dropped: return False
        if self.tx_dropped != other.tx_dropped: return False
        if self.rx_errors != other.rx_errors: return False
        if self.tx_errors != other.tx_errors: return False
        if self.rx_frame_err != other.rx_frame_err: return False
        if self.rx_over_err != other.rx_over_err: return False
        if self.rx_crc_err != other.rx_crc_err: return False
        if self.collisions != other.collisions: return False
        return True

    def pretty_print(self, q):
        q.text("port_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("rx_packets = ");
                q.text("%#x" % self.rx_packets)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("rx_bytes = ");
                q.text("%#x" % self.rx_bytes)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("rx_dropped = ");
                q.text("%#x" % self.rx_dropped)
                q.text(","); q.breakable()
                q.text("tx_dropped = ");
                q.text("%#x" % self.tx_dropped)
                q.text(","); q.breakable()
                q.text("rx_errors = ");
                q.text("%#x" % self.rx_errors)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
                q.text(","); q.breakable()
                q.text("rx_frame_err = ");
                q.text("%#x" % self.rx_frame_err)
                q.text(","); q.breakable()
                q.text("rx_over_err = ");
                q.text("%#x" % self.rx_over_err)
                q.text(","); q.breakable()
                q.text("rx_crc_err = ");
                q.text("%#x" % self.rx_crc_err)
                q.text(","); q.breakable()
                q.text("collisions = ");
                q.text("%#x" % self.collisions)
            q.breakable()
        q.text('}')


class queue_prop(loxi.OFObject):
    subtypes = {}


    def __init__(self, type=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 0)
        subclass = queue_prop.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = queue_prop()
        obj.type = reader.read("!H")[0]
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        return True

    def pretty_print(self, q):
        q.text("queue_prop {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class queue_prop_min_rate(queue_prop):
    type = 1

    def __init__(self, rate=None):
        if rate != None:
            self.rate = rate
        else:
            self.rate = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        packed.append(struct.pack("!H", self.rate))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_prop_min_rate()
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        obj.rate = reader.read("!H")[0]
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.rate != other.rate: return False
        return True

    def pretty_print(self, q):
        q.text("queue_prop_min_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("rate = ");
                q.text("%#x" % self.rate)
            q.breakable()
        q.text('}')

queue_prop.subtypes[1] = queue_prop_min_rate

class queue_stats_entry(loxi.OFObject):

    def __init__(self, port_no=None, queue_id=None, tx_bytes=None, tx_packets=None, tx_errors=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.tx_errors))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_stats_entry()
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(2)
        obj.queue_id = reader.read("!L")[0]
        obj.tx_bytes = reader.read("!Q")[0]
        obj.tx_packets = reader.read("!Q")[0]
        obj.tx_errors = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.queue_id != other.queue_id: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.tx_packets != other.tx_packets: return False
        if self.tx_errors != other.tx_errors: return False
        return True

    def pretty_print(self, q):
        q.text("queue_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
            q.breakable()
        q.text('}')


class table_stats_entry(loxi.OFObject):

    def __init__(self, table_id=None, name=None, wildcards=None, max_entries=None, active_count=None, lookup_count=None, matched_count=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if name != None:
            self.name = name
        else:
            self.name = ""
        if wildcards != None:
            self.wildcards = wildcards
        else:
            self.wildcards = util.init_wc_bmap()
        if max_entries != None:
            self.max_entries = max_entries
        else:
            self.max_entries = 0
        if active_count != None:
            self.active_count = active_count
        else:
            self.active_count = 0
        if lookup_count != None:
            self.lookup_count = lookup_count
        else:
            self.lookup_count = 0
        if matched_count != None:
            self.matched_count = matched_count
        else:
            self.matched_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!32s", self.name))
        packed.append(util.pack_wc_bmap(self.wildcards))
        packed.append(struct.pack("!L", self.max_entries))
        packed.append(struct.pack("!L", self.active_count))
        packed.append(struct.pack("!Q", self.lookup_count))
        packed.append(struct.pack("!Q", self.matched_count))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_stats_entry()
        obj.table_id = reader.read("!B")[0]
        reader.skip(3)
        obj.name = reader.read("!32s")[0].rstrip("\x00")
        obj.wildcards = util.unpack_wc_bmap(reader)
        obj.max_entries = reader.read("!L")[0]
        obj.active_count = reader.read("!L")[0]
        obj.lookup_count = reader.read("!Q")[0]
        obj.matched_count = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.name != other.name: return False
        if self.wildcards != other.wildcards: return False
        if self.max_entries != other.max_entries: return False
        if self.active_count != other.active_count: return False
        if self.lookup_count != other.lookup_count: return False
        if self.matched_count != other.matched_count: return False
        return True

    def pretty_print(self, q):
        q.text("table_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("wildcards = ");
                q.text(util.pretty_wildcards(self.wildcards))
                q.text(","); q.breakable()
                q.text("max_entries = ");
                q.text("%#x" % self.max_entries)
                q.text(","); q.breakable()
                q.text("active_count = ");
                q.text("%#x" % self.active_count)
                q.text(","); q.breakable()
                q.text("lookup_count = ");
                q.text("%#x" % self.lookup_count)
                q.text(","); q.breakable()
                q.text("matched_count = ");
                q.text("%#x" % self.matched_count)
            q.breakable()
        q.text('}')



match = match_v1
