// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/events.proto

package voltha

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/opencord/voltha-protos/v3/go/common"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ConfigEventType_Types int32

const (
	ConfigEventType_add    ConfigEventType_Types = 0
	ConfigEventType_remove ConfigEventType_Types = 1
	ConfigEventType_update ConfigEventType_Types = 2
)

var ConfigEventType_Types_name = map[int32]string{
	0: "add",
	1: "remove",
	2: "update",
}

var ConfigEventType_Types_value = map[string]int32{
	"add":    0,
	"remove": 1,
	"update": 2,
}

func (x ConfigEventType_Types) String() string {
	return proto.EnumName(ConfigEventType_Types_name, int32(x))
}

func (ConfigEventType_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{0, 0}
}

type KpiEventType_Types int32

const (
	KpiEventType_slice KpiEventType_Types = 0
	KpiEventType_ts    KpiEventType_Types = 1
)

var KpiEventType_Types_name = map[int32]string{
	0: "slice",
	1: "ts",
}

var KpiEventType_Types_value = map[string]int32{
	"slice": 0,
	"ts":    1,
}

func (x KpiEventType_Types) String() string {
	return proto.EnumName(KpiEventType_Types_name, int32(x))
}

func (KpiEventType_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{2, 0}
}

type AlarmEventType_Types int32

const (
	AlarmEventType_COMMUNICATION AlarmEventType_Types = 0
	AlarmEventType_ENVIRONMENT   AlarmEventType_Types = 1
	AlarmEventType_EQUIPMENT     AlarmEventType_Types = 2
	AlarmEventType_SERVICE       AlarmEventType_Types = 3
	AlarmEventType_PROCESSING    AlarmEventType_Types = 4
	AlarmEventType_SECURITY      AlarmEventType_Types = 5
)

var AlarmEventType_Types_name = map[int32]string{
	0: "COMMUNICATION",
	1: "ENVIRONMENT",
	2: "EQUIPMENT",
	3: "SERVICE",
	4: "PROCESSING",
	5: "SECURITY",
}

var AlarmEventType_Types_value = map[string]int32{
	"COMMUNICATION": 0,
	"ENVIRONMENT":   1,
	"EQUIPMENT":     2,
	"SERVICE":       3,
	"PROCESSING":    4,
	"SECURITY":      5,
}

func (x AlarmEventType_Types) String() string {
	return proto.EnumName(AlarmEventType_Types_name, int32(x))
}

func (AlarmEventType_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{8, 0}
}

type AlarmEventCategory_Types int32

const (
	AlarmEventCategory_PON AlarmEventCategory_Types = 0
	AlarmEventCategory_OLT AlarmEventCategory_Types = 1
	AlarmEventCategory_ONT AlarmEventCategory_Types = 2
	AlarmEventCategory_ONU AlarmEventCategory_Types = 3
	AlarmEventCategory_NNI AlarmEventCategory_Types = 4
)

var AlarmEventCategory_Types_name = map[int32]string{
	0: "PON",
	1: "OLT",
	2: "ONT",
	3: "ONU",
	4: "NNI",
}

var AlarmEventCategory_Types_value = map[string]int32{
	"PON": 0,
	"OLT": 1,
	"ONT": 2,
	"ONU": 3,
	"NNI": 4,
}

func (x AlarmEventCategory_Types) String() string {
	return proto.EnumName(AlarmEventCategory_Types_name, int32(x))
}

func (AlarmEventCategory_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{9, 0}
}

type AlarmEventState_Types int32

const (
	AlarmEventState_RAISED  AlarmEventState_Types = 0
	AlarmEventState_CLEARED AlarmEventState_Types = 1
)

var AlarmEventState_Types_name = map[int32]string{
	0: "RAISED",
	1: "CLEARED",
}

var AlarmEventState_Types_value = map[string]int32{
	"RAISED":  0,
	"CLEARED": 1,
}

func (x AlarmEventState_Types) String() string {
	return proto.EnumName(AlarmEventState_Types_name, int32(x))
}

func (AlarmEventState_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{10, 0}
}

type AlarmEventSeverity_Types int32

const (
	AlarmEventSeverity_INDETERMINATE AlarmEventSeverity_Types = 0
	AlarmEventSeverity_WARNING       AlarmEventSeverity_Types = 1
	AlarmEventSeverity_MINOR         AlarmEventSeverity_Types = 2
	AlarmEventSeverity_MAJOR         AlarmEventSeverity_Types = 3
	AlarmEventSeverity_CRITICAL      AlarmEventSeverity_Types = 4
)

var AlarmEventSeverity_Types_name = map[int32]string{
	0: "INDETERMINATE",
	1: "WARNING",
	2: "MINOR",
	3: "MAJOR",
	4: "CRITICAL",
}

var AlarmEventSeverity_Types_value = map[string]int32{
	"INDETERMINATE": 0,
	"WARNING":       1,
	"MINOR":         2,
	"MAJOR":         3,
	"CRITICAL":      4,
}

func (x AlarmEventSeverity_Types) String() string {
	return proto.EnumName(AlarmEventSeverity_Types_name, int32(x))
}

func (AlarmEventSeverity_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{11, 0}
}

type EventCategory_Types int32

const (
	EventCategory_COMMUNICATION EventCategory_Types = 0
	EventCategory_ENVIRONMENT   EventCategory_Types = 1
	EventCategory_EQUIPMENT     EventCategory_Types = 2
	EventCategory_SERVICE       EventCategory_Types = 3
	EventCategory_PROCESSING    EventCategory_Types = 4
	EventCategory_SECURITY      EventCategory_Types = 5
)

var EventCategory_Types_name = map[int32]string{
	0: "COMMUNICATION",
	1: "ENVIRONMENT",
	2: "EQUIPMENT",
	3: "SERVICE",
	4: "PROCESSING",
	5: "SECURITY",
}

var EventCategory_Types_value = map[string]int32{
	"COMMUNICATION": 0,
	"ENVIRONMENT":   1,
	"EQUIPMENT":     2,
	"SERVICE":       3,
	"PROCESSING":    4,
	"SECURITY":      5,
}

func (x EventCategory_Types) String() string {
	return proto.EnumName(EventCategory_Types_name, int32(x))
}

func (EventCategory_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{14, 0}
}

type EventSubCategory_Types int32

const (
	EventSubCategory_PON EventSubCategory_Types = 0
	EventSubCategory_OLT EventSubCategory_Types = 1
	EventSubCategory_ONT EventSubCategory_Types = 2
	EventSubCategory_ONU EventSubCategory_Types = 3
	EventSubCategory_NNI EventSubCategory_Types = 4
)

var EventSubCategory_Types_name = map[int32]string{
	0: "PON",
	1: "OLT",
	2: "ONT",
	3: "ONU",
	4: "NNI",
}

var EventSubCategory_Types_value = map[string]int32{
	"PON": 0,
	"OLT": 1,
	"ONT": 2,
	"ONU": 3,
	"NNI": 4,
}

func (x EventSubCategory_Types) String() string {
	return proto.EnumName(EventSubCategory_Types_name, int32(x))
}

func (EventSubCategory_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{15, 0}
}

type EventType_Types int32

const (
	EventType_CONFIG_EVENT EventType_Types = 0
	EventType_KPI_EVENT    EventType_Types = 1
	EventType_KPI_EVENT2   EventType_Types = 2
	EventType_DEVICE_EVENT EventType_Types = 3
)

var EventType_Types_name = map[int32]string{
	0: "CONFIG_EVENT",
	1: "KPI_EVENT",
	2: "KPI_EVENT2",
	3: "DEVICE_EVENT",
}

var EventType_Types_value = map[string]int32{
	"CONFIG_EVENT": 0,
	"KPI_EVENT":    1,
	"KPI_EVENT2":   2,
	"DEVICE_EVENT": 3,
}

func (x EventType_Types) String() string {
	return proto.EnumName(EventType_Types_name, int32(x))
}

func (EventType_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{16, 0}
}

type ConfigEventType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigEventType) Reset()         { *m = ConfigEventType{} }
func (m *ConfigEventType) String() string { return proto.CompactTextString(m) }
func (*ConfigEventType) ProtoMessage()    {}
func (*ConfigEventType) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{0}
}

func (m *ConfigEventType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigEventType.Unmarshal(m, b)
}
func (m *ConfigEventType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigEventType.Marshal(b, m, deterministic)
}
func (m *ConfigEventType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigEventType.Merge(m, src)
}
func (m *ConfigEventType) XXX_Size() int {
	return xxx_messageInfo_ConfigEventType.Size(m)
}
func (m *ConfigEventType) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigEventType.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigEventType proto.InternalMessageInfo

type ConfigEvent struct {
	Type                 ConfigEventType_Types `protobuf:"varint,1,opt,name=type,proto3,enum=voltha.ConfigEventType_Types" json:"type,omitempty"`
	Hash                 string                `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	Data                 string                `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ConfigEvent) Reset()         { *m = ConfigEvent{} }
func (m *ConfigEvent) String() string { return proto.CompactTextString(m) }
func (*ConfigEvent) ProtoMessage()    {}
func (*ConfigEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{1}
}

func (m *ConfigEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigEvent.Unmarshal(m, b)
}
func (m *ConfigEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigEvent.Marshal(b, m, deterministic)
}
func (m *ConfigEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigEvent.Merge(m, src)
}
func (m *ConfigEvent) XXX_Size() int {
	return xxx_messageInfo_ConfigEvent.Size(m)
}
func (m *ConfigEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigEvent proto.InternalMessageInfo

func (m *ConfigEvent) GetType() ConfigEventType_Types {
	if m != nil {
		return m.Type
	}
	return ConfigEventType_add
}

func (m *ConfigEvent) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *ConfigEvent) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

type KpiEventType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KpiEventType) Reset()         { *m = KpiEventType{} }
func (m *KpiEventType) String() string { return proto.CompactTextString(m) }
func (*KpiEventType) ProtoMessage()    {}
func (*KpiEventType) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{2}
}

func (m *KpiEventType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KpiEventType.Unmarshal(m, b)
}
func (m *KpiEventType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KpiEventType.Marshal(b, m, deterministic)
}
func (m *KpiEventType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KpiEventType.Merge(m, src)
}
func (m *KpiEventType) XXX_Size() int {
	return xxx_messageInfo_KpiEventType.Size(m)
}
func (m *KpiEventType) XXX_DiscardUnknown() {
	xxx_messageInfo_KpiEventType.DiscardUnknown(m)
}

var xxx_messageInfo_KpiEventType proto.InternalMessageInfo

//
// Struct to convey a dictionary of metric metadata.
type MetricMetaData struct {
	Title           string  `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	Ts              float64 `protobuf:"fixed64,2,opt,name=ts,proto3" json:"ts,omitempty"`
	LogicalDeviceId string  `protobuf:"bytes,3,opt,name=logical_device_id,json=logicalDeviceId,proto3" json:"logical_device_id,omitempty"`
	// (equivalent to the DPID that ONOS has
	// for the VOLTHA device without the
	//  'of:' prefix
	SerialNo             string            `protobuf:"bytes,4,opt,name=serial_no,json=serialNo,proto3" json:"serial_no,omitempty"`
	DeviceId             string            `protobuf:"bytes,5,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	Context              map[string]string `protobuf:"bytes,6,rep,name=context,proto3" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MetricMetaData) Reset()         { *m = MetricMetaData{} }
func (m *MetricMetaData) String() string { return proto.CompactTextString(m) }
func (*MetricMetaData) ProtoMessage()    {}
func (*MetricMetaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{3}
}

func (m *MetricMetaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricMetaData.Unmarshal(m, b)
}
func (m *MetricMetaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricMetaData.Marshal(b, m, deterministic)
}
func (m *MetricMetaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricMetaData.Merge(m, src)
}
func (m *MetricMetaData) XXX_Size() int {
	return xxx_messageInfo_MetricMetaData.Size(m)
}
func (m *MetricMetaData) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricMetaData.DiscardUnknown(m)
}

var xxx_messageInfo_MetricMetaData proto.InternalMessageInfo

func (m *MetricMetaData) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *MetricMetaData) GetTs() float64 {
	if m != nil {
		return m.Ts
	}
	return 0
}

func (m *MetricMetaData) GetLogicalDeviceId() string {
	if m != nil {
		return m.LogicalDeviceId
	}
	return ""
}

func (m *MetricMetaData) GetSerialNo() string {
	if m != nil {
		return m.SerialNo
	}
	return ""
}

func (m *MetricMetaData) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *MetricMetaData) GetContext() map[string]string {
	if m != nil {
		return m.Context
	}
	return nil
}

//
// Struct to convey a dictionary of metric->value pairs. Typically used in
// pure shared-timestamp or shared-timestamp + shared object prefix situations.
type MetricValuePairs struct {
	// Metric / value pairs.
	Metrics              map[string]float32 `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MetricValuePairs) Reset()         { *m = MetricValuePairs{} }
func (m *MetricValuePairs) String() string { return proto.CompactTextString(m) }
func (*MetricValuePairs) ProtoMessage()    {}
func (*MetricValuePairs) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{4}
}

func (m *MetricValuePairs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricValuePairs.Unmarshal(m, b)
}
func (m *MetricValuePairs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricValuePairs.Marshal(b, m, deterministic)
}
func (m *MetricValuePairs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricValuePairs.Merge(m, src)
}
func (m *MetricValuePairs) XXX_Size() int {
	return xxx_messageInfo_MetricValuePairs.Size(m)
}
func (m *MetricValuePairs) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricValuePairs.DiscardUnknown(m)
}

var xxx_messageInfo_MetricValuePairs proto.InternalMessageInfo

func (m *MetricValuePairs) GetMetrics() map[string]float32 {
	if m != nil {
		return m.Metrics
	}
	return nil
}

//
// Struct to group metadata for a metric (or group of metrics) with the key-value
// pairs of collected metrics
type MetricInformation struct {
	Metadata             *MetricMetaData    `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Metrics              map[string]float32 `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MetricInformation) Reset()         { *m = MetricInformation{} }
func (m *MetricInformation) String() string { return proto.CompactTextString(m) }
func (*MetricInformation) ProtoMessage()    {}
func (*MetricInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{5}
}

func (m *MetricInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricInformation.Unmarshal(m, b)
}
func (m *MetricInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricInformation.Marshal(b, m, deterministic)
}
func (m *MetricInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricInformation.Merge(m, src)
}
func (m *MetricInformation) XXX_Size() int {
	return xxx_messageInfo_MetricInformation.Size(m)
}
func (m *MetricInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricInformation.DiscardUnknown(m)
}

var xxx_messageInfo_MetricInformation proto.InternalMessageInfo

func (m *MetricInformation) GetMetadata() *MetricMetaData {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *MetricInformation) GetMetrics() map[string]float32 {
	if m != nil {
		return m.Metrics
	}
	return nil
}

//
// Legacy KPI Event structured.  In mid-August, the KPI event format was updated
//                               to a more easily parsable format. See VOL-1140
//                               for more information.
type KpiEvent struct {
	Type                 KpiEventType_Types           `protobuf:"varint,1,opt,name=type,proto3,enum=voltha.KpiEventType_Types" json:"type,omitempty"`
	Ts                   float32                      `protobuf:"fixed32,2,opt,name=ts,proto3" json:"ts,omitempty"`
	Prefixes             map[string]*MetricValuePairs `protobuf:"bytes,3,rep,name=prefixes,proto3" json:"prefixes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *KpiEvent) Reset()         { *m = KpiEvent{} }
func (m *KpiEvent) String() string { return proto.CompactTextString(m) }
func (*KpiEvent) ProtoMessage()    {}
func (*KpiEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{6}
}

func (m *KpiEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KpiEvent.Unmarshal(m, b)
}
func (m *KpiEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KpiEvent.Marshal(b, m, deterministic)
}
func (m *KpiEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KpiEvent.Merge(m, src)
}
func (m *KpiEvent) XXX_Size() int {
	return xxx_messageInfo_KpiEvent.Size(m)
}
func (m *KpiEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_KpiEvent.DiscardUnknown(m)
}

var xxx_messageInfo_KpiEvent proto.InternalMessageInfo

func (m *KpiEvent) GetType() KpiEventType_Types {
	if m != nil {
		return m.Type
	}
	return KpiEventType_slice
}

func (m *KpiEvent) GetTs() float32 {
	if m != nil {
		return m.Ts
	}
	return 0
}

func (m *KpiEvent) GetPrefixes() map[string]*MetricValuePairs {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

type KpiEvent2 struct {
	// Type of KPI Event
	Type KpiEventType_Types `protobuf:"varint,1,opt,name=type,proto3,enum=voltha.KpiEventType_Types" json:"type,omitempty"`
	// Fields used when for slice:
	Ts                   float64              `protobuf:"fixed64,2,opt,name=ts,proto3" json:"ts,omitempty"`
	SliceData            []*MetricInformation `protobuf:"bytes,3,rep,name=slice_data,json=sliceData,proto3" json:"slice_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *KpiEvent2) Reset()         { *m = KpiEvent2{} }
func (m *KpiEvent2) String() string { return proto.CompactTextString(m) }
func (*KpiEvent2) ProtoMessage()    {}
func (*KpiEvent2) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{7}
}

func (m *KpiEvent2) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KpiEvent2.Unmarshal(m, b)
}
func (m *KpiEvent2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KpiEvent2.Marshal(b, m, deterministic)
}
func (m *KpiEvent2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KpiEvent2.Merge(m, src)
}
func (m *KpiEvent2) XXX_Size() int {
	return xxx_messageInfo_KpiEvent2.Size(m)
}
func (m *KpiEvent2) XXX_DiscardUnknown() {
	xxx_messageInfo_KpiEvent2.DiscardUnknown(m)
}

var xxx_messageInfo_KpiEvent2 proto.InternalMessageInfo

func (m *KpiEvent2) GetType() KpiEventType_Types {
	if m != nil {
		return m.Type
	}
	return KpiEventType_slice
}

func (m *KpiEvent2) GetTs() float64 {
	if m != nil {
		return m.Ts
	}
	return 0
}

func (m *KpiEvent2) GetSliceData() []*MetricInformation {
	if m != nil {
		return m.SliceData
	}
	return nil
}

//
// Identify to the area of the system impacted by the alarm
// To be deprecated once python version of OpenOLT adapter
// moves to the new event defination for device alarms
type AlarmEventType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AlarmEventType) Reset()         { *m = AlarmEventType{} }
func (m *AlarmEventType) String() string { return proto.CompactTextString(m) }
func (*AlarmEventType) ProtoMessage()    {}
func (*AlarmEventType) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{8}
}

func (m *AlarmEventType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlarmEventType.Unmarshal(m, b)
}
func (m *AlarmEventType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlarmEventType.Marshal(b, m, deterministic)
}
func (m *AlarmEventType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlarmEventType.Merge(m, src)
}
func (m *AlarmEventType) XXX_Size() int {
	return xxx_messageInfo_AlarmEventType.Size(m)
}
func (m *AlarmEventType) XXX_DiscardUnknown() {
	xxx_messageInfo_AlarmEventType.DiscardUnknown(m)
}

var xxx_messageInfo_AlarmEventType proto.InternalMessageInfo

//
// Identify to the functional category originating the alarm
// To be deprecated once python version of OpenOLT adapter
// as well as OpenONU adapter moves to the new event
// defination for device alarms
type AlarmEventCategory struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AlarmEventCategory) Reset()         { *m = AlarmEventCategory{} }
func (m *AlarmEventCategory) String() string { return proto.CompactTextString(m) }
func (*AlarmEventCategory) ProtoMessage()    {}
func (*AlarmEventCategory) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{9}
}

func (m *AlarmEventCategory) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlarmEventCategory.Unmarshal(m, b)
}
func (m *AlarmEventCategory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlarmEventCategory.Marshal(b, m, deterministic)
}
func (m *AlarmEventCategory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlarmEventCategory.Merge(m, src)
}
func (m *AlarmEventCategory) XXX_Size() int {
	return xxx_messageInfo_AlarmEventCategory.Size(m)
}
func (m *AlarmEventCategory) XXX_DiscardUnknown() {
	xxx_messageInfo_AlarmEventCategory.DiscardUnknown(m)
}

var xxx_messageInfo_AlarmEventCategory proto.InternalMessageInfo

//
// Active state of the alarm
// To be deprecated once python version of OpenOLT adapter
// as well as OpenONU adapter moves to the new event
// defination for device alarms
type AlarmEventState struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AlarmEventState) Reset()         { *m = AlarmEventState{} }
func (m *AlarmEventState) String() string { return proto.CompactTextString(m) }
func (*AlarmEventState) ProtoMessage()    {}
func (*AlarmEventState) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{10}
}

func (m *AlarmEventState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlarmEventState.Unmarshal(m, b)
}
func (m *AlarmEventState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlarmEventState.Marshal(b, m, deterministic)
}
func (m *AlarmEventState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlarmEventState.Merge(m, src)
}
func (m *AlarmEventState) XXX_Size() int {
	return xxx_messageInfo_AlarmEventState.Size(m)
}
func (m *AlarmEventState) XXX_DiscardUnknown() {
	xxx_messageInfo_AlarmEventState.DiscardUnknown(m)
}

var xxx_messageInfo_AlarmEventState proto.InternalMessageInfo

//
// Identify the overall impact of the alarm on the system
// To be deprecated once python version of OpenOLT adapter
// as well as OpenONU adapter moves to the new event
// defination for device alarms
type AlarmEventSeverity struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AlarmEventSeverity) Reset()         { *m = AlarmEventSeverity{} }
func (m *AlarmEventSeverity) String() string { return proto.CompactTextString(m) }
func (*AlarmEventSeverity) ProtoMessage()    {}
func (*AlarmEventSeverity) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{11}
}

func (m *AlarmEventSeverity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlarmEventSeverity.Unmarshal(m, b)
}
func (m *AlarmEventSeverity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlarmEventSeverity.Marshal(b, m, deterministic)
}
func (m *AlarmEventSeverity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlarmEventSeverity.Merge(m, src)
}
func (m *AlarmEventSeverity) XXX_Size() int {
	return xxx_messageInfo_AlarmEventSeverity.Size(m)
}
func (m *AlarmEventSeverity) XXX_DiscardUnknown() {
	xxx_messageInfo_AlarmEventSeverity.DiscardUnknown(m)
}

var xxx_messageInfo_AlarmEventSeverity proto.InternalMessageInfo

//
// To be deprecated once python version of OpenOLT adapter
// as well as OpenONU adapter moves to the new event
// defination for device alarms
type AlarmEvent struct {
	// Unique ID for this alarm.  e.g. voltha.some_olt.1234
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Refers to the area of the system impacted by the alarm
	Type AlarmEventType_Types `protobuf:"varint,2,opt,name=type,proto3,enum=voltha.AlarmEventType_Types" json:"type,omitempty"`
	// Refers to functional category of the alarm
	Category AlarmEventCategory_Types `protobuf:"varint,3,opt,name=category,proto3,enum=voltha.AlarmEventCategory_Types" json:"category,omitempty"`
	// Current active state of the alarm
	State AlarmEventState_Types `protobuf:"varint,4,opt,name=state,proto3,enum=voltha.AlarmEventState_Types" json:"state,omitempty"`
	// Overall impact of the alarm on the system
	Severity AlarmEventSeverity_Types `protobuf:"varint,5,opt,name=severity,proto3,enum=voltha.AlarmEventSeverity_Types" json:"severity,omitempty"`
	// Timestamp at which the alarm was first raised
	RaisedTs float32 `protobuf:"fixed32,6,opt,name=raised_ts,json=raisedTs,proto3" json:"raised_ts,omitempty"`
	// Timestamp at which the alarm was reported
	ReportedTs float32 `protobuf:"fixed32,7,opt,name=reported_ts,json=reportedTs,proto3" json:"reported_ts,omitempty"`
	// Timestamp at which the alarm has changed since it was raised
	ChangedTs float32 `protobuf:"fixed32,8,opt,name=changed_ts,json=changedTs,proto3" json:"changed_ts,omitempty"`
	// Identifier of the originating resource of the alarm
	ResourceId string `protobuf:"bytes,9,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// Textual explanation of the alarm
	Description string `protobuf:"bytes,10,opt,name=description,proto3" json:"description,omitempty"`
	// Key/Value storage for extra information that may give context to the alarm
	Context map[string]string `protobuf:"bytes,11,rep,name=context,proto3" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// logical device id
	LogicalDeviceId string `protobuf:"bytes,12,opt,name=logical_device_id,json=logicalDeviceId,proto3" json:"logical_device_id,omitempty"`
	// alarm_type  name indicates clearly the name of the alarm
	AlarmTypeName        string   `protobuf:"bytes,13,opt,name=alarm_type_name,json=alarmTypeName,proto3" json:"alarm_type_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AlarmEvent) Reset()         { *m = AlarmEvent{} }
func (m *AlarmEvent) String() string { return proto.CompactTextString(m) }
func (*AlarmEvent) ProtoMessage()    {}
func (*AlarmEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{12}
}

func (m *AlarmEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlarmEvent.Unmarshal(m, b)
}
func (m *AlarmEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlarmEvent.Marshal(b, m, deterministic)
}
func (m *AlarmEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlarmEvent.Merge(m, src)
}
func (m *AlarmEvent) XXX_Size() int {
	return xxx_messageInfo_AlarmEvent.Size(m)
}
func (m *AlarmEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_AlarmEvent.DiscardUnknown(m)
}

var xxx_messageInfo_AlarmEvent proto.InternalMessageInfo

func (m *AlarmEvent) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AlarmEvent) GetType() AlarmEventType_Types {
	if m != nil {
		return m.Type
	}
	return AlarmEventType_COMMUNICATION
}

func (m *AlarmEvent) GetCategory() AlarmEventCategory_Types {
	if m != nil {
		return m.Category
	}
	return AlarmEventCategory_PON
}

func (m *AlarmEvent) GetState() AlarmEventState_Types {
	if m != nil {
		return m.State
	}
	return AlarmEventState_RAISED
}

func (m *AlarmEvent) GetSeverity() AlarmEventSeverity_Types {
	if m != nil {
		return m.Severity
	}
	return AlarmEventSeverity_INDETERMINATE
}

func (m *AlarmEvent) GetRaisedTs() float32 {
	if m != nil {
		return m.RaisedTs
	}
	return 0
}

func (m *AlarmEvent) GetReportedTs() float32 {
	if m != nil {
		return m.ReportedTs
	}
	return 0
}

func (m *AlarmEvent) GetChangedTs() float32 {
	if m != nil {
		return m.ChangedTs
	}
	return 0
}

func (m *AlarmEvent) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *AlarmEvent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AlarmEvent) GetContext() map[string]string {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *AlarmEvent) GetLogicalDeviceId() string {
	if m != nil {
		return m.LogicalDeviceId
	}
	return ""
}

func (m *AlarmEvent) GetAlarmTypeName() string {
	if m != nil {
		return m.AlarmTypeName
	}
	return ""
}

//
// Describes the events specific to device
type DeviceEvent struct {
	// Identifier of the originating resource of the event, for ex: device_id
	ResourceId string `protobuf:"bytes,1,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// device_event_name indicates clearly the name of the device event
	DeviceEventName string `protobuf:"bytes,2,opt,name=device_event_name,json=deviceEventName,proto3" json:"device_event_name,omitempty"`
	// Textual explanation of the device event
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Key/Value storage for extra information that may give context to the event
	Context              map[string]string `protobuf:"bytes,4,rep,name=context,proto3" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DeviceEvent) Reset()         { *m = DeviceEvent{} }
func (m *DeviceEvent) String() string { return proto.CompactTextString(m) }
func (*DeviceEvent) ProtoMessage()    {}
func (*DeviceEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{13}
}

func (m *DeviceEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceEvent.Unmarshal(m, b)
}
func (m *DeviceEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceEvent.Marshal(b, m, deterministic)
}
func (m *DeviceEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceEvent.Merge(m, src)
}
func (m *DeviceEvent) XXX_Size() int {
	return xxx_messageInfo_DeviceEvent.Size(m)
}
func (m *DeviceEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceEvent proto.InternalMessageInfo

func (m *DeviceEvent) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *DeviceEvent) GetDeviceEventName() string {
	if m != nil {
		return m.DeviceEventName
	}
	return ""
}

func (m *DeviceEvent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DeviceEvent) GetContext() map[string]string {
	if m != nil {
		return m.Context
	}
	return nil
}

//
// Identify the area of the system impacted by the event.
type EventCategory struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventCategory) Reset()         { *m = EventCategory{} }
func (m *EventCategory) String() string { return proto.CompactTextString(m) }
func (*EventCategory) ProtoMessage()    {}
func (*EventCategory) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{14}
}

func (m *EventCategory) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventCategory.Unmarshal(m, b)
}
func (m *EventCategory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventCategory.Marshal(b, m, deterministic)
}
func (m *EventCategory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventCategory.Merge(m, src)
}
func (m *EventCategory) XXX_Size() int {
	return xxx_messageInfo_EventCategory.Size(m)
}
func (m *EventCategory) XXX_DiscardUnknown() {
	xxx_messageInfo_EventCategory.DiscardUnknown(m)
}

var xxx_messageInfo_EventCategory proto.InternalMessageInfo

//
// Identify the functional category originating the event
type EventSubCategory struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventSubCategory) Reset()         { *m = EventSubCategory{} }
func (m *EventSubCategory) String() string { return proto.CompactTextString(m) }
func (*EventSubCategory) ProtoMessage()    {}
func (*EventSubCategory) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{15}
}

func (m *EventSubCategory) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventSubCategory.Unmarshal(m, b)
}
func (m *EventSubCategory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventSubCategory.Marshal(b, m, deterministic)
}
func (m *EventSubCategory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventSubCategory.Merge(m, src)
}
func (m *EventSubCategory) XXX_Size() int {
	return xxx_messageInfo_EventSubCategory.Size(m)
}
func (m *EventSubCategory) XXX_DiscardUnknown() {
	xxx_messageInfo_EventSubCategory.DiscardUnknown(m)
}

var xxx_messageInfo_EventSubCategory proto.InternalMessageInfo

//
// Identify the type of event
type EventType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventType) Reset()         { *m = EventType{} }
func (m *EventType) String() string { return proto.CompactTextString(m) }
func (*EventType) ProtoMessage()    {}
func (*EventType) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{16}
}

func (m *EventType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventType.Unmarshal(m, b)
}
func (m *EventType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventType.Marshal(b, m, deterministic)
}
func (m *EventType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventType.Merge(m, src)
}
func (m *EventType) XXX_Size() int {
	return xxx_messageInfo_EventType.Size(m)
}
func (m *EventType) XXX_DiscardUnknown() {
	xxx_messageInfo_EventType.DiscardUnknown(m)
}

var xxx_messageInfo_EventType proto.InternalMessageInfo

//
// Identify the functional category originating the event
type EventHeader struct {
	// Unique ID for this event.  e.g. voltha.some_olt.1234
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Refers to the functional area affect by the event
	Category EventCategory_Types `protobuf:"varint,2,opt,name=category,proto3,enum=voltha.EventCategory_Types" json:"category,omitempty"`
	// Refers to functional category of the event
	SubCategory EventSubCategory_Types `protobuf:"varint,3,opt,name=sub_category,json=subCategory,proto3,enum=voltha.EventSubCategory_Types" json:"sub_category,omitempty"`
	// Refers to the type of the event
	Type EventType_Types `protobuf:"varint,4,opt,name=type,proto3,enum=voltha.EventType_Types" json:"type,omitempty"`
	// The version identifier for this event type, thus allowing each
	// event type to evolve independently. The version should be in the
	// format “MAJOR.MINOR” format and minor changes must only be additive
	// and non-breaking.
	TypeVersion string `protobuf:"bytes,5,opt,name=type_version,json=typeVersion,proto3" json:"type_version,omitempty"`
	// Timestamp at which the event was first raised.
	// This represents the UTC time stamp since epoch (in seconds) when the
	// the event was first raised from the source entity.
	// If the source entity doesn't send the raised_ts, this shall be set
	// to timestamp when the event was received.
	RaisedTs float32 `protobuf:"fixed32,6,opt,name=raised_ts,json=raisedTs,proto3" json:"raised_ts,omitempty"`
	// Timestamp at which the event was reported.
	// This represents the UTC time stamp since epoch (in seconds) when the
	// the event was reported (this time stamp is >= raised_ts).
	// If the source entity that reported this event doesn't send the
	// reported_ts, this shall be set to the same value as raised_ts.
	ReportedTs           float32  `protobuf:"fixed32,7,opt,name=reported_ts,json=reportedTs,proto3" json:"reported_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventHeader) Reset()         { *m = EventHeader{} }
func (m *EventHeader) String() string { return proto.CompactTextString(m) }
func (*EventHeader) ProtoMessage()    {}
func (*EventHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{17}
}

func (m *EventHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventHeader.Unmarshal(m, b)
}
func (m *EventHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventHeader.Marshal(b, m, deterministic)
}
func (m *EventHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventHeader.Merge(m, src)
}
func (m *EventHeader) XXX_Size() int {
	return xxx_messageInfo_EventHeader.Size(m)
}
func (m *EventHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_EventHeader.DiscardUnknown(m)
}

var xxx_messageInfo_EventHeader proto.InternalMessageInfo

func (m *EventHeader) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *EventHeader) GetCategory() EventCategory_Types {
	if m != nil {
		return m.Category
	}
	return EventCategory_COMMUNICATION
}

func (m *EventHeader) GetSubCategory() EventSubCategory_Types {
	if m != nil {
		return m.SubCategory
	}
	return EventSubCategory_PON
}

func (m *EventHeader) GetType() EventType_Types {
	if m != nil {
		return m.Type
	}
	return EventType_CONFIG_EVENT
}

func (m *EventHeader) GetTypeVersion() string {
	if m != nil {
		return m.TypeVersion
	}
	return ""
}

func (m *EventHeader) GetRaisedTs() float32 {
	if m != nil {
		return m.RaisedTs
	}
	return 0
}

func (m *EventHeader) GetReportedTs() float32 {
	if m != nil {
		return m.ReportedTs
	}
	return 0
}

//
// Event Structure
type Event struct {
	// event header
	Header *EventHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// oneof event types referred by EventType.
	//
	// Types that are valid to be assigned to EventType:
	//	*Event_ConfigEvent
	//	*Event_KpiEvent
	//	*Event_KpiEvent2
	//	*Event_DeviceEvent
	EventType            isEvent_EventType `protobuf_oneof:"event_type"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_e63e6c07044fd2c4, []int{18}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetHeader() *EventHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

type isEvent_EventType interface {
	isEvent_EventType()
}

type Event_ConfigEvent struct {
	ConfigEvent *ConfigEvent `protobuf:"bytes,2,opt,name=config_event,json=configEvent,proto3,oneof"`
}

type Event_KpiEvent struct {
	KpiEvent *KpiEvent `protobuf:"bytes,3,opt,name=kpi_event,json=kpiEvent,proto3,oneof"`
}

type Event_KpiEvent2 struct {
	KpiEvent2 *KpiEvent2 `protobuf:"bytes,4,opt,name=kpi_event2,json=kpiEvent2,proto3,oneof"`
}

type Event_DeviceEvent struct {
	DeviceEvent *DeviceEvent `protobuf:"bytes,5,opt,name=device_event,json=deviceEvent,proto3,oneof"`
}

func (*Event_ConfigEvent) isEvent_EventType() {}

func (*Event_KpiEvent) isEvent_EventType() {}

func (*Event_KpiEvent2) isEvent_EventType() {}

func (*Event_DeviceEvent) isEvent_EventType() {}

func (m *Event) GetEventType() isEvent_EventType {
	if m != nil {
		return m.EventType
	}
	return nil
}

func (m *Event) GetConfigEvent() *ConfigEvent {
	if x, ok := m.GetEventType().(*Event_ConfigEvent); ok {
		return x.ConfigEvent
	}
	return nil
}

func (m *Event) GetKpiEvent() *KpiEvent {
	if x, ok := m.GetEventType().(*Event_KpiEvent); ok {
		return x.KpiEvent
	}
	return nil
}

func (m *Event) GetKpiEvent2() *KpiEvent2 {
	if x, ok := m.GetEventType().(*Event_KpiEvent2); ok {
		return x.KpiEvent2
	}
	return nil
}

func (m *Event) GetDeviceEvent() *DeviceEvent {
	if x, ok := m.GetEventType().(*Event_DeviceEvent); ok {
		return x.DeviceEvent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Event) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Event_ConfigEvent)(nil),
		(*Event_KpiEvent)(nil),
		(*Event_KpiEvent2)(nil),
		(*Event_DeviceEvent)(nil),
	}
}

func init() {
	proto.RegisterEnum("voltha.ConfigEventType_Types", ConfigEventType_Types_name, ConfigEventType_Types_value)
	proto.RegisterEnum("voltha.KpiEventType_Types", KpiEventType_Types_name, KpiEventType_Types_value)
	proto.RegisterEnum("voltha.AlarmEventType_Types", AlarmEventType_Types_name, AlarmEventType_Types_value)
	proto.RegisterEnum("voltha.AlarmEventCategory_Types", AlarmEventCategory_Types_name, AlarmEventCategory_Types_value)
	proto.RegisterEnum("voltha.AlarmEventState_Types", AlarmEventState_Types_name, AlarmEventState_Types_value)
	proto.RegisterEnum("voltha.AlarmEventSeverity_Types", AlarmEventSeverity_Types_name, AlarmEventSeverity_Types_value)
	proto.RegisterEnum("voltha.EventCategory_Types", EventCategory_Types_name, EventCategory_Types_value)
	proto.RegisterEnum("voltha.EventSubCategory_Types", EventSubCategory_Types_name, EventSubCategory_Types_value)
	proto.RegisterEnum("voltha.EventType_Types", EventType_Types_name, EventType_Types_value)
	proto.RegisterType((*ConfigEventType)(nil), "voltha.ConfigEventType")
	proto.RegisterType((*ConfigEvent)(nil), "voltha.ConfigEvent")
	proto.RegisterType((*KpiEventType)(nil), "voltha.KpiEventType")
	proto.RegisterType((*MetricMetaData)(nil), "voltha.MetricMetaData")
	proto.RegisterMapType((map[string]string)(nil), "voltha.MetricMetaData.ContextEntry")
	proto.RegisterType((*MetricValuePairs)(nil), "voltha.MetricValuePairs")
	proto.RegisterMapType((map[string]float32)(nil), "voltha.MetricValuePairs.MetricsEntry")
	proto.RegisterType((*MetricInformation)(nil), "voltha.MetricInformation")
	proto.RegisterMapType((map[string]float32)(nil), "voltha.MetricInformation.MetricsEntry")
	proto.RegisterType((*KpiEvent)(nil), "voltha.KpiEvent")
	proto.RegisterMapType((map[string]*MetricValuePairs)(nil), "voltha.KpiEvent.PrefixesEntry")
	proto.RegisterType((*KpiEvent2)(nil), "voltha.KpiEvent2")
	proto.RegisterType((*AlarmEventType)(nil), "voltha.AlarmEventType")
	proto.RegisterType((*AlarmEventCategory)(nil), "voltha.AlarmEventCategory")
	proto.RegisterType((*AlarmEventState)(nil), "voltha.AlarmEventState")
	proto.RegisterType((*AlarmEventSeverity)(nil), "voltha.AlarmEventSeverity")
	proto.RegisterType((*AlarmEvent)(nil), "voltha.AlarmEvent")
	proto.RegisterMapType((map[string]string)(nil), "voltha.AlarmEvent.ContextEntry")
	proto.RegisterType((*DeviceEvent)(nil), "voltha.DeviceEvent")
	proto.RegisterMapType((map[string]string)(nil), "voltha.DeviceEvent.ContextEntry")
	proto.RegisterType((*EventCategory)(nil), "voltha.EventCategory")
	proto.RegisterType((*EventSubCategory)(nil), "voltha.EventSubCategory")
	proto.RegisterType((*EventType)(nil), "voltha.EventType")
	proto.RegisterType((*EventHeader)(nil), "voltha.EventHeader")
	proto.RegisterType((*Event)(nil), "voltha.Event")
}

func init() { proto.RegisterFile("voltha_protos/events.proto", fileDescriptor_e63e6c07044fd2c4) }

var fileDescriptor_e63e6c07044fd2c4 = []byte{
	// 1334 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xdd, 0x72, 0xdb, 0x44,
	0x14, 0xb6, 0xe4, 0x9f, 0xd8, 0x47, 0x4e, 0xa2, 0x6c, 0x19, 0x30, 0xee, 0x5f, 0x10, 0x43, 0x27,
	0xd3, 0x0e, 0x36, 0x38, 0xcc, 0x10, 0x02, 0x0c, 0xb8, 0x8e, 0x68, 0xd4, 0xd6, 0x72, 0x90, 0x9d,
	0x74, 0xe0, 0xc6, 0xb3, 0xb1, 0x36, 0xb6, 0x26, 0xb6, 0xe4, 0x91, 0x36, 0xa6, 0x79, 0x00, 0xae,
	0xb9, 0xe4, 0x82, 0x07, 0xe0, 0x49, 0x78, 0x0c, 0x5e, 0x80, 0x6b, 0x1e, 0x80, 0xd9, 0x1f, 0x59,
	0x92, 0xe3, 0xc2, 0x45, 0xa6, 0x5c, 0x79, 0x75, 0xfe, 0xf6, 0x3b, 0xdf, 0x9e, 0x73, 0x76, 0x0d,
	0xf5, 0x45, 0x30, 0xa5, 0x13, 0x3c, 0x9c, 0x87, 0x01, 0x0d, 0xa2, 0x26, 0x59, 0x10, 0x9f, 0x46,
	0x0d, 0xfe, 0x85, 0x4a, 0x42, 0x57, 0xaf, 0x65, 0x6d, 0x66, 0x84, 0x62, 0x61, 0x51, 0xbf, 0x37,
	0x0e, 0x82, 0xf1, 0x94, 0x34, 0xf1, 0xdc, 0x6b, 0x62, 0xdf, 0x0f, 0x28, 0xa6, 0x5e, 0xe0, 0x4b,
	0x7f, 0xe3, 0x4b, 0xd8, 0xee, 0x04, 0xfe, 0x85, 0x37, 0x36, 0x59, 0xd4, 0xc1, 0xf5, 0x9c, 0x18,
	0x7b, 0x50, 0x64, 0xbf, 0x11, 0xda, 0x80, 0x3c, 0x76, 0x5d, 0x3d, 0x87, 0x00, 0x4a, 0x21, 0x99,
	0x05, 0x0b, 0xa2, 0x2b, 0x6c, 0x7d, 0x35, 0x77, 0x31, 0x25, 0xba, 0x6a, 0x4c, 0x40, 0x4b, 0x39,
	0xa3, 0x4f, 0xa1, 0x40, 0xaf, 0xe7, 0xa4, 0xa6, 0xec, 0x2a, 0x7b, 0x5b, 0xad, 0xfb, 0x0d, 0x01,
	0xa9, 0xb1, 0x12, 0xbf, 0xc1, 0x83, 0x3b, 0xdc, 0x14, 0x21, 0x28, 0x4c, 0x70, 0x34, 0xa9, 0xa9,
	0xbb, 0xca, 0x5e, 0xc5, 0xe1, 0x6b, 0x26, 0x73, 0x31, 0xc5, 0xb5, 0xbc, 0x90, 0xb1, 0xb5, 0xf1,
	0x18, 0xaa, 0x2f, 0xe6, 0x5e, 0x82, 0xb1, 0x1e, 0x63, 0xac, 0x40, 0x31, 0x9a, 0x7a, 0x23, 0xa2,
	0xe7, 0x50, 0x09, 0x54, 0x1a, 0xe9, 0x8a, 0xf1, 0xab, 0x0a, 0x5b, 0x5d, 0x42, 0x43, 0x6f, 0xd4,
	0x25, 0x14, 0x1f, 0x61, 0x8a, 0xd1, 0x3b, 0x50, 0xa4, 0x1e, 0x9d, 0x0a, 0x68, 0x15, 0x47, 0x7c,
	0xa0, 0x2d, 0xe6, 0xc0, 0xb7, 0x56, 0x1c, 0x95, 0x46, 0xe8, 0x31, 0xec, 0x4c, 0x83, 0xb1, 0x37,
	0xc2, 0xd3, 0xa1, 0x4b, 0x16, 0xde, 0x88, 0x0c, 0x3d, 0x57, 0xa2, 0xd8, 0x96, 0x8a, 0x23, 0x2e,
	0xb7, 0x5c, 0x74, 0x17, 0x2a, 0x11, 0x09, 0x3d, 0x3c, 0x1d, 0xfa, 0x41, 0xad, 0xc0, 0x6d, 0xca,
	0x42, 0x60, 0x07, 0x4c, 0x99, 0x04, 0x28, 0x0a, 0xa5, 0x1b, 0x7b, 0x7e, 0x0d, 0x1b, 0xa3, 0xc0,
	0xa7, 0xe4, 0x35, 0xad, 0x95, 0x76, 0xf3, 0x7b, 0x5a, 0xeb, 0xc3, 0x98, 0xa8, 0x2c, 0x68, 0xc6,
	0x1b, 0xb3, 0x32, 0x7d, 0x1a, 0x5e, 0x3b, 0xb1, 0x4f, 0xfd, 0x10, 0xaa, 0x69, 0x05, 0xd2, 0x21,
	0x7f, 0x49, 0xae, 0x65, 0x62, 0x6c, 0xc9, 0x92, 0x5d, 0xe0, 0xe9, 0x15, 0x91, 0xa4, 0x8a, 0x8f,
	0x43, 0xf5, 0x40, 0x31, 0x7e, 0x51, 0x40, 0x17, 0x9b, 0x9c, 0x31, 0xd9, 0x09, 0xf6, 0xc2, 0x08,
	0x7d, 0x03, 0x1b, 0x33, 0x2e, 0x8b, 0x6a, 0x0a, 0xc7, 0xf3, 0x51, 0x16, 0x4f, 0x62, 0x2a, 0x05,
	0x91, 0x44, 0x24, 0xbd, 0x18, 0xa2, 0xb4, 0xe2, 0xbf, 0x10, 0xa9, 0x69, 0x44, 0x7f, 0x28, 0xb0,
	0x23, 0x9c, 0x2d, 0xff, 0x22, 0x08, 0x67, 0xbc, 0x36, 0x51, 0x0b, 0xca, 0xac, 0x80, 0x79, 0x15,
	0xb0, 0x30, 0x5a, 0xeb, 0xdd, 0xf5, 0x1c, 0x39, 0x4b, 0x3b, 0xf4, 0x6d, 0x92, 0x86, 0xca, 0xd3,
	0x78, 0x94, 0x75, 0x49, 0xc5, 0x7f, 0x0b, 0x79, 0xfc, 0xa9, 0x40, 0x39, 0x2e, 0x50, 0xd4, 0xc8,
	0xf4, 0x41, 0x3d, 0xc6, 0x91, 0x2e, 0xe0, 0x4c, 0x13, 0x24, 0x75, 0xa8, 0xf2, 0x3a, 0x3c, 0x84,
	0xf2, 0x3c, 0x24, 0x17, 0xde, 0x6b, 0x12, 0xd5, 0xf2, 0x3c, 0x97, 0x07, 0xab, 0x31, 0x1a, 0x27,
	0xd2, 0x40, 0xe4, 0xb0, 0xb4, 0xaf, 0x9f, 0xc2, 0x66, 0x46, 0xb5, 0x26, 0x8b, 0x46, 0x3a, 0x0b,
	0xad, 0x55, 0x7b, 0xd3, 0x71, 0xa7, 0xf3, 0xfb, 0x59, 0x81, 0x4a, 0xbc, 0x77, 0xeb, 0x16, 0x09,
	0x8a, 0x46, 0x3b, 0x00, 0xe0, 0x4d, 0x3b, 0x94, 0x7d, 0xce, 0x52, 0x7c, 0xff, 0x8d, 0xc7, 0xe5,
	0x54, 0xb8, 0x31, 0x3b, 0x6f, 0xe3, 0x27, 0xd8, 0x6a, 0x4f, 0x71, 0x38, 0x4b, 0x26, 0x01, 0x89,
	0x27, 0xc1, 0x0e, 0x6c, 0x76, 0x7a, 0xdd, 0xee, 0xa9, 0x6d, 0x75, 0xda, 0x03, 0xab, 0x67, 0xeb,
	0x39, 0xb4, 0x0d, 0x9a, 0x69, 0x9f, 0x59, 0x4e, 0xcf, 0xee, 0x9a, 0xf6, 0x40, 0x57, 0xd0, 0x26,
	0x54, 0xcc, 0xef, 0x4f, 0xad, 0x13, 0xfe, 0xa9, 0x22, 0x0d, 0x36, 0xfa, 0xa6, 0x73, 0x66, 0x75,
	0x4c, 0x3d, 0x8f, 0xb6, 0x00, 0x4e, 0x9c, 0x5e, 0xc7, 0xec, 0xf7, 0x2d, 0xfb, 0x99, 0x5e, 0x40,
	0x55, 0x28, 0xf7, 0xcd, 0xce, 0xa9, 0x63, 0x0d, 0x7e, 0xd0, 0x8b, 0xc6, 0x73, 0x40, 0xc9, 0xc6,
	0x1d, 0x4c, 0xc9, 0x38, 0x08, 0xaf, 0x8d, 0xcf, 0x52, 0xa3, 0xf2, 0x84, 0x6f, 0xb9, 0x01, 0xf9,
	0xde, 0x4b, 0xb6, 0x15, 0x5b, 0xf0, 0x4d, 0xf8, 0xe2, 0x54, 0xcf, 0xb3, 0x85, 0x6d, 0x5b, 0x7a,
	0xc1, 0xd8, 0x87, 0xed, 0x24, 0x56, 0x9f, 0x62, 0x4a, 0x8c, 0xdd, 0x38, 0x10, 0x40, 0xc9, 0x69,
	0x5b, 0x7d, 0xf3, 0x48, 0xcf, 0x31, 0x78, 0x9d, 0x97, 0x66, 0xdb, 0x31, 0x8f, 0x74, 0xc5, 0xc0,
	0x69, 0x00, 0x7d, 0xb2, 0x20, 0xa1, 0x47, 0xaf, 0x8d, 0x17, 0xa9, 0xec, 0x2d, 0xfb, 0xc8, 0x1c,
	0x98, 0x4e, 0xd7, 0xb2, 0xdb, 0x03, 0x53, 0xb8, 0xbf, 0x6a, 0x3b, 0x36, 0xcb, 0x46, 0x61, 0x73,
	0xb2, 0x6b, 0xd9, 0x3d, 0x47, 0x57, 0xf9, 0xb2, 0xfd, 0xbc, 0xe7, 0xe8, 0x79, 0x96, 0x63, 0xc7,
	0xb1, 0x06, 0x56, 0xa7, 0xfd, 0x52, 0x2f, 0x18, 0x7f, 0x15, 0x00, 0x92, 0x3d, 0xd8, 0xa9, 0x79,
	0xae, 0x2c, 0x1c, 0xd5, 0x73, 0xd1, 0x27, 0xf2, 0xd4, 0x55, 0x7e, 0xea, 0xf7, 0xe2, 0xf3, 0xca,
	0x9e, 0x47, 0xe6, 0xdc, 0xbf, 0x82, 0xf2, 0x48, 0x52, 0xc5, 0xe7, 0xe8, 0x56, 0x6b, 0xf7, 0xa6,
	0x57, 0x4c, 0xa6, 0xf4, 0x5c, 0x7a, 0xa0, 0x7d, 0x28, 0x46, 0x8c, 0x1c, 0x3e, 0x5e, 0x53, 0xf7,
	0xc9, 0x0a, 0x77, 0xd2, 0x4f, 0xd8, 0xb2, 0x2d, 0x23, 0x49, 0x0e, 0x9f, 0xbc, 0x6b, 0xb7, 0x8c,
	0xe9, 0x8b, 0xb7, 0x8c, 0x3d, 0xd8, 0xe0, 0x0e, 0xb1, 0x17, 0x11, 0x77, 0x48, 0xa3, 0x5a, 0x89,
	0x37, 0x64, 0x59, 0x08, 0x06, 0x11, 0x7a, 0x08, 0x5a, 0x48, 0xe6, 0x41, 0x48, 0x85, 0x7a, 0x83,
	0xab, 0x21, 0x16, 0x0d, 0x22, 0x74, 0x1f, 0x60, 0x34, 0xc1, 0xfe, 0x58, 0xe8, 0xcb, 0x5c, 0x5f,
	0x91, 0x92, 0xd8, 0x3f, 0x0a, 0xae, 0x42, 0x71, 0x2f, 0x54, 0x38, 0xb1, 0x10, 0x8b, 0x2c, 0x17,
	0xed, 0x82, 0xe6, 0x92, 0x68, 0x14, 0x7a, 0x73, 0x56, 0xf6, 0x35, 0xe0, 0x06, 0x69, 0x11, 0xfa,
	0x22, 0xb9, 0x3b, 0x34, 0xde, 0x35, 0x0f, 0x6f, 0x26, 0xb7, 0xfe, 0xde, 0x58, 0x7f, 0xb9, 0x55,
	0xd7, 0x5f, 0x6e, 0x8f, 0x60, 0x1b, 0xb3, 0x78, 0x43, 0x76, 0x8a, 0x43, 0x1f, 0xcf, 0x48, 0x6d,
	0x93, 0x5b, 0x6e, 0x72, 0x31, 0x63, 0xcd, 0xc6, 0x33, 0x72, 0xab, 0xbb, 0xe8, 0x6f, 0x05, 0x34,
	0xb1, 0xa1, 0xa8, 0xb6, 0x15, 0x76, 0x94, 0x1b, 0xec, 0x3c, 0x86, 0x1d, 0x09, 0x9c, 0x3f, 0x80,
	0x04, 0x2c, 0x11, 0x76, 0xdb, 0x4d, 0x02, 0x31, 0x60, 0xab, 0x4c, 0xe6, 0x6f, 0x32, 0x79, 0x98,
	0x30, 0x59, 0xe0, 0x4c, 0x2e, 0xcb, 0x24, 0x05, 0xea, 0x2d, 0x5c, 0xc1, 0x0b, 0xd8, 0xcc, 0x8e,
	0x90, 0xff, 0x69, 0x7e, 0x1d, 0x83, 0x2e, 0x4a, 0xff, 0xea, 0xfc, 0x96, 0xd3, 0xeb, 0x15, 0x54,
	0x92, 0xe9, 0xfb, 0x3c, 0x0e, 0xa1, 0x43, 0xb5, 0xd3, 0xb3, 0xbf, 0xb3, 0x9e, 0x0d, 0xcd, 0x33,
	0x06, 0x2e, 0xc7, 0xb0, 0xbe, 0x38, 0xb1, 0xe4, 0xa7, 0xc2, 0xe0, 0x2d, 0x3f, 0x5b, 0xba, 0xca,
	0x1c, 0x8e, 0x4c, 0x06, 0x5d, 0x5a, 0xe4, 0x8d, 0xdf, 0x55, 0xd0, 0x78, 0xe4, 0x63, 0x82, 0x5d,
	0x12, 0xde, 0x98, 0x3f, 0x9f, 0xa7, 0xa6, 0x89, 0x98, 0x41, 0x77, 0xe3, 0x33, 0xfb, 0xf7, 0x41,
	0xd2, 0x86, 0x6a, 0x74, 0x75, 0x3e, 0x5c, 0x19, 0x45, 0x0f, 0x32, 0xce, 0x29, 0x5e, 0xa4, 0xbf,
	0x16, 0x25, 0x22, 0xf4, 0x44, 0xce, 0x3e, 0x31, 0x8a, 0xde, 0xcb, 0xb8, 0xde, 0x18, 0x7b, 0x1f,
	0x40, 0x95, 0x37, 0xce, 0x82, 0x84, 0x11, 0x2b, 0x3f, 0xf1, 0x02, 0xd4, 0x98, 0xec, 0x4c, 0x88,
	0x6e, 0x37, 0x68, 0x8c, 0xdf, 0x54, 0x28, 0x8a, 0xae, 0x79, 0x02, 0xa5, 0x09, 0x67, 0x4b, 0xbe,
	0x93, 0xee, 0x64, 0x90, 0x09, 0x22, 0x1d, 0x69, 0x82, 0x0e, 0xa0, 0x3a, 0xe2, 0x6f, 0x71, 0xd1,
	0x41, 0xf2, 0xfe, 0xbf, 0xb3, 0xe6, 0x9d, 0x7e, 0x9c, 0x73, 0xb4, 0x51, 0xea, 0x65, 0xdf, 0x84,
	0xca, 0xe5, 0xdc, 0x93, 0x6e, 0x79, 0xee, 0xa6, 0xaf, 0xde, 0xfa, 0xc7, 0x39, 0xa7, 0x7c, 0x19,
	0x3f, 0x81, 0x5a, 0x00, 0x4b, 0x87, 0x16, 0x67, 0x4d, 0x6b, 0xed, 0xac, 0x7a, 0xb4, 0x8e, 0x73,
	0x4e, 0xe5, 0x72, 0xf9, 0xaa, 0x38, 0x80, 0x6a, 0xba, 0xc1, 0x39, 0x6d, 0x29, 0x78, 0xa9, 0xbe,
	0x64, 0xf0, 0x52, 0x2d, 0xff, 0xb4, 0x0a, 0x20, 0x66, 0x02, 0xa3, 0xf8, 0xa9, 0x09, 0x77, 0x82,
	0x70, 0xdc, 0x08, 0xe6, 0xc4, 0x1f, 0x05, 0xa1, 0x2b, 0xfd, 0x7f, 0x6c, 0x8c, 0x3d, 0x3a, 0xb9,
	0x3a, 0x6f, 0x8c, 0x82, 0x59, 0x33, 0xd6, 0x35, 0x85, 0xee, 0x63, 0xf9, 0xaf, 0x69, 0xb1, 0xdf,
	0x1c, 0x07, 0x52, 0x76, 0x5e, 0xe2, 0xc2, 0xfd, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x8c, 0x4c,
	0x16, 0xa6, 0x7e, 0x0d, 0x00, 0x00,
}
