/*
 * Copyright 2018-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The template for the tester.
// This template is filled in by the
// test driver based on the configuration.

package main

import (
	"os"
	//"time"
	"fmt"
	"os/exec"
	"io/ioutil"
	"github.com/opencord/voltha-go/common/log"
)


func main() {
	var cmd *exec.Cmd
	var cmdStr string
	// Setup logging
	if _, err := log.SetDefaultLogger(log.JSON, 0, nil); err != nil {
		log.With(log.Fields{"error": err}).Fatal("Cannot setup logging")
	}

	defer log.CleanUp()

	statFn = "stats.json"

	log.Info("Running tests")
	if err:= os.Chdir(os.Args[1]); err != nil {
		log.Error("Could not change directory to %s: %v", os.Args[1], err)
	}

	if err := initStats(statFn); err != nil {
		log.Error(err)
		return
	}

	{{range .}}
	cmdStr =  "./"+"{{.}}"+".e"

	log.Infof("Running test suite %s",cmdStr)
	cmd = exec.Command(cmdStr, statFn)
	cmd.Stdin = os.Stdin
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr
	if err := cmd.Run(); err != nil {
		log.Errorf("Test '%s' failed", cmdStr)
	}
	{{end}}
	// Open the results file and output it.
	if s,err := readStats(statFn); err != nil {
		log.Error(err)
		return
	} else {
		stats = s
	}

	//log.Infof("Stats are: %v", stats)
	if resFile, err := ioutil.ReadFile(statFn); err == nil {
		fmt.Println(string(resFile))
	} else {
		log.Error("Could not load the stats file 'stats.json'")
	}
	fmt.Println("Test result summary")
	for _,v := range stats.TestSuites {
		fmt.Printf("Test suite: %s\n", v.Name[2:len(v.Name)-2])
		pass := 0
		fail := 0
		total := 0
		for _,v1 := range v.TestCases {
			total++
			if v1.Result == true {
				pass++
			} else {
				fail++
			}
		}
		fmt.Printf("\tTotal test cases: %d\n", total)
		fmt.Printf("\t\tTotal passed test cases: %d\n", pass)
		fmt.Printf("\t\tTotal failed test cases: %d\n", fail)
	}
	log.Info("Tests complete")
}
