//
// Top-level Voltha API definition
//
// For details, see individual definition files.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.0
// - protoc             v4.25.8
// source: voltha_protos/voltha.proto

package voltha

import (
	context "context"
	common "github.com/opencord/voltha-protos/v5/go/common"
	extension "github.com/opencord/voltha-protos/v5/go/extension"
	omci "github.com/opencord/voltha-protos/v5/go/omci"
	openflow_13 "github.com/opencord/voltha-protos/v5/go/openflow_13"
	voip_system_profile "github.com/opencord/voltha-protos/v5/go/voip_system_profile"
	voip_user_profile "github.com/opencord/voltha-protos/v5/go/voip_user_profile"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	VolthaService_GetVoltha_FullMethodName                         = "/voltha.VolthaService/GetVoltha"
	VolthaService_ListCoreInstances_FullMethodName                 = "/voltha.VolthaService/ListCoreInstances"
	VolthaService_GetCoreInstance_FullMethodName                   = "/voltha.VolthaService/GetCoreInstance"
	VolthaService_ListAdapters_FullMethodName                      = "/voltha.VolthaService/ListAdapters"
	VolthaService_ListLogicalDevices_FullMethodName                = "/voltha.VolthaService/ListLogicalDevices"
	VolthaService_GetLogicalDevice_FullMethodName                  = "/voltha.VolthaService/GetLogicalDevice"
	VolthaService_ListLogicalDevicePorts_FullMethodName            = "/voltha.VolthaService/ListLogicalDevicePorts"
	VolthaService_GetLogicalDevicePort_FullMethodName              = "/voltha.VolthaService/GetLogicalDevicePort"
	VolthaService_EnableLogicalDevicePort_FullMethodName           = "/voltha.VolthaService/EnableLogicalDevicePort"
	VolthaService_DisableLogicalDevicePort_FullMethodName          = "/voltha.VolthaService/DisableLogicalDevicePort"
	VolthaService_ListLogicalDeviceFlows_FullMethodName            = "/voltha.VolthaService/ListLogicalDeviceFlows"
	VolthaService_UpdateLogicalDeviceFlowTable_FullMethodName      = "/voltha.VolthaService/UpdateLogicalDeviceFlowTable"
	VolthaService_UpdateLogicalDeviceMeterTable_FullMethodName     = "/voltha.VolthaService/UpdateLogicalDeviceMeterTable"
	VolthaService_ListLogicalDeviceMeters_FullMethodName           = "/voltha.VolthaService/ListLogicalDeviceMeters"
	VolthaService_ListLogicalDeviceFlowGroups_FullMethodName       = "/voltha.VolthaService/ListLogicalDeviceFlowGroups"
	VolthaService_UpdateLogicalDeviceFlowGroupTable_FullMethodName = "/voltha.VolthaService/UpdateLogicalDeviceFlowGroupTable"
	VolthaService_ListDevices_FullMethodName                       = "/voltha.VolthaService/ListDevices"
	VolthaService_ListDeviceIds_FullMethodName                     = "/voltha.VolthaService/ListDeviceIds"
	VolthaService_ReconcileDevices_FullMethodName                  = "/voltha.VolthaService/ReconcileDevices"
	VolthaService_GetDevice_FullMethodName                         = "/voltha.VolthaService/GetDevice"
	VolthaService_CreateDevice_FullMethodName                      = "/voltha.VolthaService/CreateDevice"
	VolthaService_EnableDevice_FullMethodName                      = "/voltha.VolthaService/EnableDevice"
	VolthaService_DisableDevice_FullMethodName                     = "/voltha.VolthaService/DisableDevice"
	VolthaService_RebootDevice_FullMethodName                      = "/voltha.VolthaService/RebootDevice"
	VolthaService_DeleteDevice_FullMethodName                      = "/voltha.VolthaService/DeleteDevice"
	VolthaService_ForceDeleteDevice_FullMethodName                 = "/voltha.VolthaService/ForceDeleteDevice"
	VolthaService_DownloadImage_FullMethodName                     = "/voltha.VolthaService/DownloadImage"
	VolthaService_GetImageDownloadStatus_FullMethodName            = "/voltha.VolthaService/GetImageDownloadStatus"
	VolthaService_GetImageDownload_FullMethodName                  = "/voltha.VolthaService/GetImageDownload"
	VolthaService_ListImageDownloads_FullMethodName                = "/voltha.VolthaService/ListImageDownloads"
	VolthaService_CancelImageDownload_FullMethodName               = "/voltha.VolthaService/CancelImageDownload"
	VolthaService_ActivateImageUpdate_FullMethodName               = "/voltha.VolthaService/ActivateImageUpdate"
	VolthaService_RevertImageUpdate_FullMethodName                 = "/voltha.VolthaService/RevertImageUpdate"
	VolthaService_DownloadImageToDevice_FullMethodName             = "/voltha.VolthaService/DownloadImageToDevice"
	VolthaService_GetImageStatus_FullMethodName                    = "/voltha.VolthaService/GetImageStatus"
	VolthaService_AbortImageUpgradeToDevice_FullMethodName         = "/voltha.VolthaService/AbortImageUpgradeToDevice"
	VolthaService_GetOnuImages_FullMethodName                      = "/voltha.VolthaService/GetOnuImages"
	VolthaService_ActivateImage_FullMethodName                     = "/voltha.VolthaService/ActivateImage"
	VolthaService_CommitImage_FullMethodName                       = "/voltha.VolthaService/CommitImage"
	VolthaService_ListDevicePorts_FullMethodName                   = "/voltha.VolthaService/ListDevicePorts"
	VolthaService_ListDevicePmConfigs_FullMethodName               = "/voltha.VolthaService/ListDevicePmConfigs"
	VolthaService_UpdateDevicePmConfigs_FullMethodName             = "/voltha.VolthaService/UpdateDevicePmConfigs"
	VolthaService_ListDeviceFlows_FullMethodName                   = "/voltha.VolthaService/ListDeviceFlows"
	VolthaService_ListDeviceFlowGroups_FullMethodName              = "/voltha.VolthaService/ListDeviceFlowGroups"
	VolthaService_ListDeviceTypes_FullMethodName                   = "/voltha.VolthaService/ListDeviceTypes"
	VolthaService_GetDeviceType_FullMethodName                     = "/voltha.VolthaService/GetDeviceType"
	VolthaService_StreamPacketsOut_FullMethodName                  = "/voltha.VolthaService/StreamPacketsOut"
	VolthaService_ReceivePacketsIn_FullMethodName                  = "/voltha.VolthaService/ReceivePacketsIn"
	VolthaService_ReceiveChangeEvents_FullMethodName               = "/voltha.VolthaService/ReceiveChangeEvents"
	VolthaService_CreateEventFilter_FullMethodName                 = "/voltha.VolthaService/CreateEventFilter"
	VolthaService_GetEventFilter_FullMethodName                    = "/voltha.VolthaService/GetEventFilter"
	VolthaService_UpdateEventFilter_FullMethodName                 = "/voltha.VolthaService/UpdateEventFilter"
	VolthaService_DeleteEventFilter_FullMethodName                 = "/voltha.VolthaService/DeleteEventFilter"
	VolthaService_ListEventFilters_FullMethodName                  = "/voltha.VolthaService/ListEventFilters"
	VolthaService_GetImages_FullMethodName                         = "/voltha.VolthaService/GetImages"
	VolthaService_SelfTest_FullMethodName                          = "/voltha.VolthaService/SelfTest"
	VolthaService_GetMibDeviceData_FullMethodName                  = "/voltha.VolthaService/GetMibDeviceData"
	VolthaService_GetAlarmDeviceData_FullMethodName                = "/voltha.VolthaService/GetAlarmDeviceData"
	VolthaService_SimulateAlarm_FullMethodName                     = "/voltha.VolthaService/SimulateAlarm"
	VolthaService_EnablePort_FullMethodName                        = "/voltha.VolthaService/EnablePort"
	VolthaService_DisablePort_FullMethodName                       = "/voltha.VolthaService/DisablePort"
	VolthaService_GetExtValue_FullMethodName                       = "/voltha.VolthaService/GetExtValue"
	VolthaService_SetExtValue_FullMethodName                       = "/voltha.VolthaService/SetExtValue"
	VolthaService_StartOmciTestAction_FullMethodName               = "/voltha.VolthaService/StartOmciTestAction"
	VolthaService_PutVoipSystemProfile_FullMethodName              = "/voltha.VolthaService/PutVoipSystemProfile"
	VolthaService_DeleteVoipSystemProfile_FullMethodName           = "/voltha.VolthaService/DeleteVoipSystemProfile"
	VolthaService_PutVoipUserProfile_FullMethodName                = "/voltha.VolthaService/PutVoipUserProfile"
	VolthaService_DeleteVoipUserProfile_FullMethodName             = "/voltha.VolthaService/DeleteVoipUserProfile"
	VolthaService_DisableOnuDevice_FullMethodName                  = "/voltha.VolthaService/DisableOnuDevice"
	VolthaService_EnableOnuDevice_FullMethodName                   = "/voltha.VolthaService/EnableOnuDevice"
	VolthaService_DisableOnuSerialNumber_FullMethodName            = "/voltha.VolthaService/DisableOnuSerialNumber"
	VolthaService_EnableOnuSerialNumber_FullMethodName             = "/voltha.VolthaService/EnableOnuSerialNumber"
	VolthaService_UpdateDevice_FullMethodName                      = "/voltha.VolthaService/UpdateDevice"
)

// VolthaServiceClient is the client API for VolthaService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Voltha APIs
type VolthaServiceClient interface {
	// Get high level information on the Voltha cluster
	GetVoltha(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Voltha, error)
	// List all Voltha cluster core instances
	ListCoreInstances(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*CoreInstances, error)
	// Get details on a Voltha cluster instance
	GetCoreInstance(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*CoreInstance, error)
	// List all active adapters (plugins) in the Voltha cluster
	ListAdapters(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Adapters, error)
	// List all logical devices managed by the Voltha cluster
	ListLogicalDevices(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*LogicalDevices, error)
	// Get additional information on a given logical device
	GetLogicalDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*LogicalDevice, error)
	// List ports of a logical device
	ListLogicalDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*LogicalPorts, error)
	// Gets a logical device port
	GetLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*LogicalPort, error)
	// Enables a logical device port
	EnableLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Disables a logical device port
	DisableLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all flows of a logical device
	ListLogicalDeviceFlows(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Flows, error)
	// Update flow table for logical device
	UpdateLogicalDeviceFlowTable(ctx context.Context, in *openflow_13.FlowTableUpdate, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Update meter table for logical device
	UpdateLogicalDeviceMeterTable(ctx context.Context, in *openflow_13.MeterModUpdate, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all meters of a logical device
	ListLogicalDeviceMeters(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Meters, error)
	// List all flow groups of a logical device
	ListLogicalDeviceFlowGroups(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.FlowGroups, error)
	// Update group table for device
	UpdateLogicalDeviceFlowGroupTable(ctx context.Context, in *openflow_13.FlowGroupTableUpdate, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all physical devices controlled by the Voltha cluster
	ListDevices(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Devices, error)
	// List all physical devices IDs controlled by the Voltha cluster
	ListDeviceIds(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*common.IDs, error)
	// Request to a voltha Core to reconcile a set of devices based on their IDs
	ReconcileDevices(ctx context.Context, in *common.IDs, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get more information on a given physical device
	GetDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Device, error)
	// Pre-provision a new physical device
	CreateDevice(ctx context.Context, in *Device, opts ...grpc.CallOption) (*Device, error)
	// Enable a device.  If the device was in pre-provisioned state then it
	// will transition to ENABLED state.  If it was is DISABLED state then it
	// will transition to ENABLED state as well.
	EnableDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Disable a device
	DisableDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Reboot a device
	RebootDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Delete a device
	DeleteDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Forcefully delete a device
	ForceDeleteDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Request an image download to the standby partition
	// of a device.
	// Note that the call is expected to be non-blocking.
	DownloadImage(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error)
	// Deprecated: Do not use.
	// Get image download status on a device
	// The request retrieves progress on device and updates db record
	// Deprecated in voltha 2.8, will be removed
	GetImageDownloadStatus(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*ImageDownload, error)
	// Deprecated: Do not use.
	// Get image download db record
	// Deprecated in voltha 2.8, will be removed
	GetImageDownload(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*ImageDownload, error)
	// Deprecated: Do not use.
	// List image download db records for a given device
	// Deprecated in voltha 2.8, will be removed
	ListImageDownloads(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*ImageDownloads, error)
	// Deprecated: Do not use.
	// Cancel an existing image download process on a device
	// Deprecated in voltha 2.8, will be removed
	CancelImageDownload(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error)
	// Deprecated: Do not use.
	// Activate the specified image at a standby partition
	// to active partition.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device
	// Note that the call is expected to be non-blocking.
	// Deprecated in voltha 2.8, will be removed
	ActivateImageUpdate(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error)
	// Deprecated: Do not use.
	// Revert the specified image at standby partition
	// to active partition, and revert to previous image
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// previous image running on device
	// Note that the call is expected to be non-blocking.
	// Deprecated in voltha 2.8, will be removed
	RevertImageUpdate(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error)
	// Downloads a certain image to the standby partition of the devices
	// Note that the call is expected to be non-blocking.
	DownloadImageToDevice(ctx context.Context, in *DeviceImageDownloadRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// Get image status on a number of devices devices
	// Polled from northbound systems to get state of download/activate/commit
	GetImageStatus(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// Aborts the upgrade of an image on a device
	// To be used carefully, stops any further operations for the Image on the given devices
	// Might also stop if possible existing work, but no guarantees are given,
	// depends on implementation and procedure status.
	AbortImageUpgradeToDevice(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// Get Both Active and Standby image for a given device
	GetOnuImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*OnuImages, error)
	// Activate the specified image from a standby partition
	// to active partition.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device
	// Note that the call is expected to be non-blocking.
	ActivateImage(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// Commit the specified image to be default.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device upon next reboot
	// Note that the call is expected to be non-blocking.
	CommitImage(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// List ports of a device
	ListDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Ports, error)
	// List pm config of a device
	ListDevicePmConfigs(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*PmConfigs, error)
	// Update the pm config of a device
	UpdateDevicePmConfigs(ctx context.Context, in *PmConfigs, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all flows of a device
	ListDeviceFlows(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Flows, error)
	// List all flow groups of a device
	ListDeviceFlowGroups(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.FlowGroups, error)
	// List device types known to Voltha
	ListDeviceTypes(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*DeviceTypes, error)
	// Get additional information on a device type
	GetDeviceType(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*DeviceType, error)
	// Stream control packets to the dataplane
	StreamPacketsOut(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[openflow_13.PacketOut, emptypb.Empty], error)
	// Receive control packet stream
	ReceivePacketsIn(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[openflow_13.PacketIn], error)
	ReceiveChangeEvents(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[openflow_13.ChangeEvent], error)
	CreateEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*EventFilter, error)
	// Get all filters present for a device
	GetEventFilter(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*EventFilters, error)
	UpdateEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*EventFilter, error)
	DeleteEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get all the filters present
	ListEventFilters(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*EventFilters, error)
	GetImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Images, error)
	SelfTest(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*SelfTestResponse, error)
	// OpenOMCI MIB information
	GetMibDeviceData(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*omci.MibDeviceData, error)
	// OpenOMCI ALARM information
	GetAlarmDeviceData(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*omci.AlarmDeviceData, error)
	// Simulate an Alarm
	SimulateAlarm(ctx context.Context, in *SimulateAlarmRequest, opts ...grpc.CallOption) (*common.OperationResp, error)
	EnablePort(ctx context.Context, in *Port, opts ...grpc.CallOption) (*emptypb.Empty, error)
	DisablePort(ctx context.Context, in *Port, opts ...grpc.CallOption) (*emptypb.Empty, error)
	GetExtValue(ctx context.Context, in *extension.ValueSpecifier, opts ...grpc.CallOption) (*extension.ReturnValues, error)
	SetExtValue(ctx context.Context, in *extension.ValueSet, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// omci start and stop cli implementation
	StartOmciTestAction(ctx context.Context, in *omci.OmciTestRequest, opts ...grpc.CallOption) (*omci.TestResponse, error)
	// Saves or updates system wide configuration into voltha KV
	PutVoipSystemProfile(ctx context.Context, in *voip_system_profile.VoipSystemProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes the given profile from voltha KV
	DeleteVoipSystemProfile(ctx context.Context, in *common.Key, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Saves or updates a profile (VOIP) into voltha KV
	PutVoipUserProfile(ctx context.Context, in *voip_user_profile.VoipUserProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes the given profile from voltha KV
	DeleteVoipUserProfile(ctx context.Context, in *common.Key, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Disables the ONU, stops it from participating in the ranging process. different from DisableDevice
	DisableOnuDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Enables the ONU at the PLOAM , enables the ONU to participate in the ranging process. different from EnableDevice
	EnableOnuDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Disables the ONU at the PLOAM , different from DisableDevice. This would be used if the Device is not present in the VOLTHA
	DisableOnuSerialNumber(ctx context.Context, in *OnuSerialNumberOnOLTPon, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Disables the ONU at the PLOAM , different from EnableDevice. This would be used if the Device is not present in the VOLTHA
	EnableOnuSerialNumber(ctx context.Context, in *OnuSerialNumberOnOLTPon, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Update the Device configuration, for now only ip address updation is supported
	UpdateDevice(ctx context.Context, in *UpdateDevice, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type volthaServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVolthaServiceClient(cc grpc.ClientConnInterface) VolthaServiceClient {
	return &volthaServiceClient{cc}
}

func (c *volthaServiceClient) GetVoltha(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Voltha, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Voltha)
	err := c.cc.Invoke(ctx, VolthaService_GetVoltha_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListCoreInstances(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*CoreInstances, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CoreInstances)
	err := c.cc.Invoke(ctx, VolthaService_ListCoreInstances_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetCoreInstance(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*CoreInstance, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CoreInstance)
	err := c.cc.Invoke(ctx, VolthaService_GetCoreInstance_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListAdapters(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Adapters, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Adapters)
	err := c.cc.Invoke(ctx, VolthaService_ListAdapters_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDevices(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*LogicalDevices, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LogicalDevices)
	err := c.cc.Invoke(ctx, VolthaService_ListLogicalDevices_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetLogicalDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*LogicalDevice, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LogicalDevice)
	err := c.cc.Invoke(ctx, VolthaService_GetLogicalDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*LogicalPorts, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LogicalPorts)
	err := c.cc.Invoke(ctx, VolthaService_ListLogicalDevicePorts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*LogicalPort, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LogicalPort)
	err := c.cc.Invoke(ctx, VolthaService_GetLogicalDevicePort_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) EnableLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_EnableLogicalDevicePort_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DisableLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DisableLogicalDevicePort_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDeviceFlows(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Flows, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(openflow_13.Flows)
	err := c.cc.Invoke(ctx, VolthaService_ListLogicalDeviceFlows_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateLogicalDeviceFlowTable(ctx context.Context, in *openflow_13.FlowTableUpdate, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_UpdateLogicalDeviceFlowTable_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateLogicalDeviceMeterTable(ctx context.Context, in *openflow_13.MeterModUpdate, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_UpdateLogicalDeviceMeterTable_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDeviceMeters(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Meters, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(openflow_13.Meters)
	err := c.cc.Invoke(ctx, VolthaService_ListLogicalDeviceMeters_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDeviceFlowGroups(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.FlowGroups, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(openflow_13.FlowGroups)
	err := c.cc.Invoke(ctx, VolthaService_ListLogicalDeviceFlowGroups_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateLogicalDeviceFlowGroupTable(ctx context.Context, in *openflow_13.FlowGroupTableUpdate, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_UpdateLogicalDeviceFlowGroupTable_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDevices(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*Devices, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Devices)
	err := c.cc.Invoke(ctx, VolthaService_ListDevices_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDeviceIds(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*common.IDs, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(common.IDs)
	err := c.cc.Invoke(ctx, VolthaService_ListDeviceIds_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ReconcileDevices(ctx context.Context, in *common.IDs, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_ReconcileDevices_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Device, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Device)
	err := c.cc.Invoke(ctx, VolthaService_GetDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) CreateDevice(ctx context.Context, in *Device, opts ...grpc.CallOption) (*Device, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Device)
	err := c.cc.Invoke(ctx, VolthaService_CreateDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) EnableDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_EnableDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DisableDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DisableDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) RebootDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_RebootDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DeleteDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DeleteDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ForceDeleteDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_ForceDeleteDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) DownloadImage(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, VolthaService_DownloadImage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) GetImageDownloadStatus(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*ImageDownload, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ImageDownload)
	err := c.cc.Invoke(ctx, VolthaService_GetImageDownloadStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) GetImageDownload(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*ImageDownload, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ImageDownload)
	err := c.cc.Invoke(ctx, VolthaService_GetImageDownload_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) ListImageDownloads(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*ImageDownloads, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ImageDownloads)
	err := c.cc.Invoke(ctx, VolthaService_ListImageDownloads_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) CancelImageDownload(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, VolthaService_CancelImageDownload_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) ActivateImageUpdate(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, VolthaService_ActivateImageUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) RevertImageUpdate(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, VolthaService_RevertImageUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DownloadImageToDevice(ctx context.Context, in *DeviceImageDownloadRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, VolthaService_DownloadImageToDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetImageStatus(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, VolthaService_GetImageStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) AbortImageUpgradeToDevice(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, VolthaService_AbortImageUpgradeToDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetOnuImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*OnuImages, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(OnuImages)
	err := c.cc.Invoke(ctx, VolthaService_GetOnuImages_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ActivateImage(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, VolthaService_ActivateImage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) CommitImage(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, VolthaService_CommitImage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Ports, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Ports)
	err := c.cc.Invoke(ctx, VolthaService_ListDevicePorts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDevicePmConfigs(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*PmConfigs, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PmConfigs)
	err := c.cc.Invoke(ctx, VolthaService_ListDevicePmConfigs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateDevicePmConfigs(ctx context.Context, in *PmConfigs, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_UpdateDevicePmConfigs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDeviceFlows(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Flows, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(openflow_13.Flows)
	err := c.cc.Invoke(ctx, VolthaService_ListDeviceFlows_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDeviceFlowGroups(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.FlowGroups, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(openflow_13.FlowGroups)
	err := c.cc.Invoke(ctx, VolthaService_ListDeviceFlowGroups_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDeviceTypes(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*DeviceTypes, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeviceTypes)
	err := c.cc.Invoke(ctx, VolthaService_ListDeviceTypes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetDeviceType(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*DeviceType, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeviceType)
	err := c.cc.Invoke(ctx, VolthaService_GetDeviceType_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) StreamPacketsOut(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[openflow_13.PacketOut, emptypb.Empty], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &VolthaService_ServiceDesc.Streams[0], VolthaService_StreamPacketsOut_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[openflow_13.PacketOut, emptypb.Empty]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type VolthaService_StreamPacketsOutClient = grpc.ClientStreamingClient[openflow_13.PacketOut, emptypb.Empty]

func (c *volthaServiceClient) ReceivePacketsIn(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[openflow_13.PacketIn], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &VolthaService_ServiceDesc.Streams[1], VolthaService_ReceivePacketsIn_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[emptypb.Empty, openflow_13.PacketIn]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type VolthaService_ReceivePacketsInClient = grpc.ServerStreamingClient[openflow_13.PacketIn]

func (c *volthaServiceClient) ReceiveChangeEvents(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[openflow_13.ChangeEvent], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &VolthaService_ServiceDesc.Streams[2], VolthaService_ReceiveChangeEvents_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[emptypb.Empty, openflow_13.ChangeEvent]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type VolthaService_ReceiveChangeEventsClient = grpc.ServerStreamingClient[openflow_13.ChangeEvent]

func (c *volthaServiceClient) CreateEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*EventFilter, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(EventFilter)
	err := c.cc.Invoke(ctx, VolthaService_CreateEventFilter_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetEventFilter(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*EventFilters, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(EventFilters)
	err := c.cc.Invoke(ctx, VolthaService_GetEventFilter_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*EventFilter, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(EventFilter)
	err := c.cc.Invoke(ctx, VolthaService_UpdateEventFilter_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DeleteEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DeleteEventFilter_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListEventFilters(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*EventFilters, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(EventFilters)
	err := c.cc.Invoke(ctx, VolthaService_ListEventFilters_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Images, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Images)
	err := c.cc.Invoke(ctx, VolthaService_GetImages_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) SelfTest(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*SelfTestResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SelfTestResponse)
	err := c.cc.Invoke(ctx, VolthaService_SelfTest_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetMibDeviceData(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*omci.MibDeviceData, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(omci.MibDeviceData)
	err := c.cc.Invoke(ctx, VolthaService_GetMibDeviceData_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetAlarmDeviceData(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*omci.AlarmDeviceData, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(omci.AlarmDeviceData)
	err := c.cc.Invoke(ctx, VolthaService_GetAlarmDeviceData_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) SimulateAlarm(ctx context.Context, in *SimulateAlarmRequest, opts ...grpc.CallOption) (*common.OperationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, VolthaService_SimulateAlarm_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) EnablePort(ctx context.Context, in *Port, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_EnablePort_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DisablePort(ctx context.Context, in *Port, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DisablePort_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetExtValue(ctx context.Context, in *extension.ValueSpecifier, opts ...grpc.CallOption) (*extension.ReturnValues, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(extension.ReturnValues)
	err := c.cc.Invoke(ctx, VolthaService_GetExtValue_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) SetExtValue(ctx context.Context, in *extension.ValueSet, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_SetExtValue_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) StartOmciTestAction(ctx context.Context, in *omci.OmciTestRequest, opts ...grpc.CallOption) (*omci.TestResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(omci.TestResponse)
	err := c.cc.Invoke(ctx, VolthaService_StartOmciTestAction_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) PutVoipSystemProfile(ctx context.Context, in *voip_system_profile.VoipSystemProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_PutVoipSystemProfile_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DeleteVoipSystemProfile(ctx context.Context, in *common.Key, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DeleteVoipSystemProfile_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) PutVoipUserProfile(ctx context.Context, in *voip_user_profile.VoipUserProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_PutVoipUserProfile_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DeleteVoipUserProfile(ctx context.Context, in *common.Key, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DeleteVoipUserProfile_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DisableOnuDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DisableOnuDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) EnableOnuDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_EnableOnuDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DisableOnuSerialNumber(ctx context.Context, in *OnuSerialNumberOnOLTPon, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_DisableOnuSerialNumber_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) EnableOnuSerialNumber(ctx context.Context, in *OnuSerialNumberOnOLTPon, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_EnableOnuSerialNumber_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateDevice(ctx context.Context, in *UpdateDevice, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VolthaService_UpdateDevice_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VolthaServiceServer is the server API for VolthaService service.
// All implementations must embed UnimplementedVolthaServiceServer
// for forward compatibility.
//
// Voltha APIs
type VolthaServiceServer interface {
	// Get high level information on the Voltha cluster
	GetVoltha(context.Context, *emptypb.Empty) (*Voltha, error)
	// List all Voltha cluster core instances
	ListCoreInstances(context.Context, *emptypb.Empty) (*CoreInstances, error)
	// Get details on a Voltha cluster instance
	GetCoreInstance(context.Context, *common.ID) (*CoreInstance, error)
	// List all active adapters (plugins) in the Voltha cluster
	ListAdapters(context.Context, *emptypb.Empty) (*Adapters, error)
	// List all logical devices managed by the Voltha cluster
	ListLogicalDevices(context.Context, *emptypb.Empty) (*LogicalDevices, error)
	// Get additional information on a given logical device
	GetLogicalDevice(context.Context, *common.ID) (*LogicalDevice, error)
	// List ports of a logical device
	ListLogicalDevicePorts(context.Context, *common.ID) (*LogicalPorts, error)
	// Gets a logical device port
	GetLogicalDevicePort(context.Context, *LogicalPortId) (*LogicalPort, error)
	// Enables a logical device port
	EnableLogicalDevicePort(context.Context, *LogicalPortId) (*emptypb.Empty, error)
	// Disables a logical device port
	DisableLogicalDevicePort(context.Context, *LogicalPortId) (*emptypb.Empty, error)
	// List all flows of a logical device
	ListLogicalDeviceFlows(context.Context, *common.ID) (*openflow_13.Flows, error)
	// Update flow table for logical device
	UpdateLogicalDeviceFlowTable(context.Context, *openflow_13.FlowTableUpdate) (*emptypb.Empty, error)
	// Update meter table for logical device
	UpdateLogicalDeviceMeterTable(context.Context, *openflow_13.MeterModUpdate) (*emptypb.Empty, error)
	// List all meters of a logical device
	ListLogicalDeviceMeters(context.Context, *common.ID) (*openflow_13.Meters, error)
	// List all flow groups of a logical device
	ListLogicalDeviceFlowGroups(context.Context, *common.ID) (*openflow_13.FlowGroups, error)
	// Update group table for device
	UpdateLogicalDeviceFlowGroupTable(context.Context, *openflow_13.FlowGroupTableUpdate) (*emptypb.Empty, error)
	// List all physical devices controlled by the Voltha cluster
	ListDevices(context.Context, *emptypb.Empty) (*Devices, error)
	// List all physical devices IDs controlled by the Voltha cluster
	ListDeviceIds(context.Context, *emptypb.Empty) (*common.IDs, error)
	// Request to a voltha Core to reconcile a set of devices based on their IDs
	ReconcileDevices(context.Context, *common.IDs) (*emptypb.Empty, error)
	// Get more information on a given physical device
	GetDevice(context.Context, *common.ID) (*Device, error)
	// Pre-provision a new physical device
	CreateDevice(context.Context, *Device) (*Device, error)
	// Enable a device.  If the device was in pre-provisioned state then it
	// will transition to ENABLED state.  If it was is DISABLED state then it
	// will transition to ENABLED state as well.
	EnableDevice(context.Context, *common.ID) (*emptypb.Empty, error)
	// Disable a device
	DisableDevice(context.Context, *common.ID) (*emptypb.Empty, error)
	// Reboot a device
	RebootDevice(context.Context, *common.ID) (*emptypb.Empty, error)
	// Delete a device
	DeleteDevice(context.Context, *common.ID) (*emptypb.Empty, error)
	// Forcefully delete a device
	ForceDeleteDevice(context.Context, *common.ID) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Request an image download to the standby partition
	// of a device.
	// Note that the call is expected to be non-blocking.
	DownloadImage(context.Context, *ImageDownload) (*common.OperationResp, error)
	// Deprecated: Do not use.
	// Get image download status on a device
	// The request retrieves progress on device and updates db record
	// Deprecated in voltha 2.8, will be removed
	GetImageDownloadStatus(context.Context, *ImageDownload) (*ImageDownload, error)
	// Deprecated: Do not use.
	// Get image download db record
	// Deprecated in voltha 2.8, will be removed
	GetImageDownload(context.Context, *ImageDownload) (*ImageDownload, error)
	// Deprecated: Do not use.
	// List image download db records for a given device
	// Deprecated in voltha 2.8, will be removed
	ListImageDownloads(context.Context, *common.ID) (*ImageDownloads, error)
	// Deprecated: Do not use.
	// Cancel an existing image download process on a device
	// Deprecated in voltha 2.8, will be removed
	CancelImageDownload(context.Context, *ImageDownload) (*common.OperationResp, error)
	// Deprecated: Do not use.
	// Activate the specified image at a standby partition
	// to active partition.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device
	// Note that the call is expected to be non-blocking.
	// Deprecated in voltha 2.8, will be removed
	ActivateImageUpdate(context.Context, *ImageDownload) (*common.OperationResp, error)
	// Deprecated: Do not use.
	// Revert the specified image at standby partition
	// to active partition, and revert to previous image
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// previous image running on device
	// Note that the call is expected to be non-blocking.
	// Deprecated in voltha 2.8, will be removed
	RevertImageUpdate(context.Context, *ImageDownload) (*common.OperationResp, error)
	// Downloads a certain image to the standby partition of the devices
	// Note that the call is expected to be non-blocking.
	DownloadImageToDevice(context.Context, *DeviceImageDownloadRequest) (*DeviceImageResponse, error)
	// Get image status on a number of devices devices
	// Polled from northbound systems to get state of download/activate/commit
	GetImageStatus(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error)
	// Aborts the upgrade of an image on a device
	// To be used carefully, stops any further operations for the Image on the given devices
	// Might also stop if possible existing work, but no guarantees are given,
	// depends on implementation and procedure status.
	AbortImageUpgradeToDevice(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error)
	// Get Both Active and Standby image for a given device
	GetOnuImages(context.Context, *common.ID) (*OnuImages, error)
	// Activate the specified image from a standby partition
	// to active partition.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device
	// Note that the call is expected to be non-blocking.
	ActivateImage(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error)
	// Commit the specified image to be default.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device upon next reboot
	// Note that the call is expected to be non-blocking.
	CommitImage(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error)
	// List ports of a device
	ListDevicePorts(context.Context, *common.ID) (*Ports, error)
	// List pm config of a device
	ListDevicePmConfigs(context.Context, *common.ID) (*PmConfigs, error)
	// Update the pm config of a device
	UpdateDevicePmConfigs(context.Context, *PmConfigs) (*emptypb.Empty, error)
	// List all flows of a device
	ListDeviceFlows(context.Context, *common.ID) (*openflow_13.Flows, error)
	// List all flow groups of a device
	ListDeviceFlowGroups(context.Context, *common.ID) (*openflow_13.FlowGroups, error)
	// List device types known to Voltha
	ListDeviceTypes(context.Context, *emptypb.Empty) (*DeviceTypes, error)
	// Get additional information on a device type
	GetDeviceType(context.Context, *common.ID) (*DeviceType, error)
	// Stream control packets to the dataplane
	StreamPacketsOut(grpc.ClientStreamingServer[openflow_13.PacketOut, emptypb.Empty]) error
	// Receive control packet stream
	ReceivePacketsIn(*emptypb.Empty, grpc.ServerStreamingServer[openflow_13.PacketIn]) error
	ReceiveChangeEvents(*emptypb.Empty, grpc.ServerStreamingServer[openflow_13.ChangeEvent]) error
	CreateEventFilter(context.Context, *EventFilter) (*EventFilter, error)
	// Get all filters present for a device
	GetEventFilter(context.Context, *common.ID) (*EventFilters, error)
	UpdateEventFilter(context.Context, *EventFilter) (*EventFilter, error)
	DeleteEventFilter(context.Context, *EventFilter) (*emptypb.Empty, error)
	// Get all the filters present
	ListEventFilters(context.Context, *emptypb.Empty) (*EventFilters, error)
	GetImages(context.Context, *common.ID) (*Images, error)
	SelfTest(context.Context, *common.ID) (*SelfTestResponse, error)
	// OpenOMCI MIB information
	GetMibDeviceData(context.Context, *common.ID) (*omci.MibDeviceData, error)
	// OpenOMCI ALARM information
	GetAlarmDeviceData(context.Context, *common.ID) (*omci.AlarmDeviceData, error)
	// Simulate an Alarm
	SimulateAlarm(context.Context, *SimulateAlarmRequest) (*common.OperationResp, error)
	EnablePort(context.Context, *Port) (*emptypb.Empty, error)
	DisablePort(context.Context, *Port) (*emptypb.Empty, error)
	GetExtValue(context.Context, *extension.ValueSpecifier) (*extension.ReturnValues, error)
	SetExtValue(context.Context, *extension.ValueSet) (*emptypb.Empty, error)
	// omci start and stop cli implementation
	StartOmciTestAction(context.Context, *omci.OmciTestRequest) (*omci.TestResponse, error)
	// Saves or updates system wide configuration into voltha KV
	PutVoipSystemProfile(context.Context, *voip_system_profile.VoipSystemProfileRequest) (*emptypb.Empty, error)
	// Deletes the given profile from voltha KV
	DeleteVoipSystemProfile(context.Context, *common.Key) (*emptypb.Empty, error)
	// Saves or updates a profile (VOIP) into voltha KV
	PutVoipUserProfile(context.Context, *voip_user_profile.VoipUserProfileRequest) (*emptypb.Empty, error)
	// Deletes the given profile from voltha KV
	DeleteVoipUserProfile(context.Context, *common.Key) (*emptypb.Empty, error)
	// Disables the ONU, stops it from participating in the ranging process. different from DisableDevice
	DisableOnuDevice(context.Context, *common.ID) (*emptypb.Empty, error)
	// Enables the ONU at the PLOAM , enables the ONU to participate in the ranging process. different from EnableDevice
	EnableOnuDevice(context.Context, *common.ID) (*emptypb.Empty, error)
	// Disables the ONU at the PLOAM , different from DisableDevice. This would be used if the Device is not present in the VOLTHA
	DisableOnuSerialNumber(context.Context, *OnuSerialNumberOnOLTPon) (*emptypb.Empty, error)
	// Disables the ONU at the PLOAM , different from EnableDevice. This would be used if the Device is not present in the VOLTHA
	EnableOnuSerialNumber(context.Context, *OnuSerialNumberOnOLTPon) (*emptypb.Empty, error)
	// Update the Device configuration, for now only ip address updation is supported
	UpdateDevice(context.Context, *UpdateDevice) (*emptypb.Empty, error)
	mustEmbedUnimplementedVolthaServiceServer()
}

// UnimplementedVolthaServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedVolthaServiceServer struct{}

func (UnimplementedVolthaServiceServer) GetVoltha(context.Context, *emptypb.Empty) (*Voltha, error) {
	return nil, status.Error(codes.Unimplemented, "method GetVoltha not implemented")
}
func (UnimplementedVolthaServiceServer) ListCoreInstances(context.Context, *emptypb.Empty) (*CoreInstances, error) {
	return nil, status.Error(codes.Unimplemented, "method ListCoreInstances not implemented")
}
func (UnimplementedVolthaServiceServer) GetCoreInstance(context.Context, *common.ID) (*CoreInstance, error) {
	return nil, status.Error(codes.Unimplemented, "method GetCoreInstance not implemented")
}
func (UnimplementedVolthaServiceServer) ListAdapters(context.Context, *emptypb.Empty) (*Adapters, error) {
	return nil, status.Error(codes.Unimplemented, "method ListAdapters not implemented")
}
func (UnimplementedVolthaServiceServer) ListLogicalDevices(context.Context, *emptypb.Empty) (*LogicalDevices, error) {
	return nil, status.Error(codes.Unimplemented, "method ListLogicalDevices not implemented")
}
func (UnimplementedVolthaServiceServer) GetLogicalDevice(context.Context, *common.ID) (*LogicalDevice, error) {
	return nil, status.Error(codes.Unimplemented, "method GetLogicalDevice not implemented")
}
func (UnimplementedVolthaServiceServer) ListLogicalDevicePorts(context.Context, *common.ID) (*LogicalPorts, error) {
	return nil, status.Error(codes.Unimplemented, "method ListLogicalDevicePorts not implemented")
}
func (UnimplementedVolthaServiceServer) GetLogicalDevicePort(context.Context, *LogicalPortId) (*LogicalPort, error) {
	return nil, status.Error(codes.Unimplemented, "method GetLogicalDevicePort not implemented")
}
func (UnimplementedVolthaServiceServer) EnableLogicalDevicePort(context.Context, *LogicalPortId) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method EnableLogicalDevicePort not implemented")
}
func (UnimplementedVolthaServiceServer) DisableLogicalDevicePort(context.Context, *LogicalPortId) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisableLogicalDevicePort not implemented")
}
func (UnimplementedVolthaServiceServer) ListLogicalDeviceFlows(context.Context, *common.ID) (*openflow_13.Flows, error) {
	return nil, status.Error(codes.Unimplemented, "method ListLogicalDeviceFlows not implemented")
}
func (UnimplementedVolthaServiceServer) UpdateLogicalDeviceFlowTable(context.Context, *openflow_13.FlowTableUpdate) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateLogicalDeviceFlowTable not implemented")
}
func (UnimplementedVolthaServiceServer) UpdateLogicalDeviceMeterTable(context.Context, *openflow_13.MeterModUpdate) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateLogicalDeviceMeterTable not implemented")
}
func (UnimplementedVolthaServiceServer) ListLogicalDeviceMeters(context.Context, *common.ID) (*openflow_13.Meters, error) {
	return nil, status.Error(codes.Unimplemented, "method ListLogicalDeviceMeters not implemented")
}
func (UnimplementedVolthaServiceServer) ListLogicalDeviceFlowGroups(context.Context, *common.ID) (*openflow_13.FlowGroups, error) {
	return nil, status.Error(codes.Unimplemented, "method ListLogicalDeviceFlowGroups not implemented")
}
func (UnimplementedVolthaServiceServer) UpdateLogicalDeviceFlowGroupTable(context.Context, *openflow_13.FlowGroupTableUpdate) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateLogicalDeviceFlowGroupTable not implemented")
}
func (UnimplementedVolthaServiceServer) ListDevices(context.Context, *emptypb.Empty) (*Devices, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDevices not implemented")
}
func (UnimplementedVolthaServiceServer) ListDeviceIds(context.Context, *emptypb.Empty) (*common.IDs, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDeviceIds not implemented")
}
func (UnimplementedVolthaServiceServer) ReconcileDevices(context.Context, *common.IDs) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method ReconcileDevices not implemented")
}
func (UnimplementedVolthaServiceServer) GetDevice(context.Context, *common.ID) (*Device, error) {
	return nil, status.Error(codes.Unimplemented, "method GetDevice not implemented")
}
func (UnimplementedVolthaServiceServer) CreateDevice(context.Context, *Device) (*Device, error) {
	return nil, status.Error(codes.Unimplemented, "method CreateDevice not implemented")
}
func (UnimplementedVolthaServiceServer) EnableDevice(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method EnableDevice not implemented")
}
func (UnimplementedVolthaServiceServer) DisableDevice(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisableDevice not implemented")
}
func (UnimplementedVolthaServiceServer) RebootDevice(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method RebootDevice not implemented")
}
func (UnimplementedVolthaServiceServer) DeleteDevice(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteDevice not implemented")
}
func (UnimplementedVolthaServiceServer) ForceDeleteDevice(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method ForceDeleteDevice not implemented")
}
func (UnimplementedVolthaServiceServer) DownloadImage(context.Context, *ImageDownload) (*common.OperationResp, error) {
	return nil, status.Error(codes.Unimplemented, "method DownloadImage not implemented")
}
func (UnimplementedVolthaServiceServer) GetImageDownloadStatus(context.Context, *ImageDownload) (*ImageDownload, error) {
	return nil, status.Error(codes.Unimplemented, "method GetImageDownloadStatus not implemented")
}
func (UnimplementedVolthaServiceServer) GetImageDownload(context.Context, *ImageDownload) (*ImageDownload, error) {
	return nil, status.Error(codes.Unimplemented, "method GetImageDownload not implemented")
}
func (UnimplementedVolthaServiceServer) ListImageDownloads(context.Context, *common.ID) (*ImageDownloads, error) {
	return nil, status.Error(codes.Unimplemented, "method ListImageDownloads not implemented")
}
func (UnimplementedVolthaServiceServer) CancelImageDownload(context.Context, *ImageDownload) (*common.OperationResp, error) {
	return nil, status.Error(codes.Unimplemented, "method CancelImageDownload not implemented")
}
func (UnimplementedVolthaServiceServer) ActivateImageUpdate(context.Context, *ImageDownload) (*common.OperationResp, error) {
	return nil, status.Error(codes.Unimplemented, "method ActivateImageUpdate not implemented")
}
func (UnimplementedVolthaServiceServer) RevertImageUpdate(context.Context, *ImageDownload) (*common.OperationResp, error) {
	return nil, status.Error(codes.Unimplemented, "method RevertImageUpdate not implemented")
}
func (UnimplementedVolthaServiceServer) DownloadImageToDevice(context.Context, *DeviceImageDownloadRequest) (*DeviceImageResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method DownloadImageToDevice not implemented")
}
func (UnimplementedVolthaServiceServer) GetImageStatus(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetImageStatus not implemented")
}
func (UnimplementedVolthaServiceServer) AbortImageUpgradeToDevice(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method AbortImageUpgradeToDevice not implemented")
}
func (UnimplementedVolthaServiceServer) GetOnuImages(context.Context, *common.ID) (*OnuImages, error) {
	return nil, status.Error(codes.Unimplemented, "method GetOnuImages not implemented")
}
func (UnimplementedVolthaServiceServer) ActivateImage(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ActivateImage not implemented")
}
func (UnimplementedVolthaServiceServer) CommitImage(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method CommitImage not implemented")
}
func (UnimplementedVolthaServiceServer) ListDevicePorts(context.Context, *common.ID) (*Ports, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDevicePorts not implemented")
}
func (UnimplementedVolthaServiceServer) ListDevicePmConfigs(context.Context, *common.ID) (*PmConfigs, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDevicePmConfigs not implemented")
}
func (UnimplementedVolthaServiceServer) UpdateDevicePmConfigs(context.Context, *PmConfigs) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateDevicePmConfigs not implemented")
}
func (UnimplementedVolthaServiceServer) ListDeviceFlows(context.Context, *common.ID) (*openflow_13.Flows, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDeviceFlows not implemented")
}
func (UnimplementedVolthaServiceServer) ListDeviceFlowGroups(context.Context, *common.ID) (*openflow_13.FlowGroups, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDeviceFlowGroups not implemented")
}
func (UnimplementedVolthaServiceServer) ListDeviceTypes(context.Context, *emptypb.Empty) (*DeviceTypes, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDeviceTypes not implemented")
}
func (UnimplementedVolthaServiceServer) GetDeviceType(context.Context, *common.ID) (*DeviceType, error) {
	return nil, status.Error(codes.Unimplemented, "method GetDeviceType not implemented")
}
func (UnimplementedVolthaServiceServer) StreamPacketsOut(grpc.ClientStreamingServer[openflow_13.PacketOut, emptypb.Empty]) error {
	return status.Error(codes.Unimplemented, "method StreamPacketsOut not implemented")
}
func (UnimplementedVolthaServiceServer) ReceivePacketsIn(*emptypb.Empty, grpc.ServerStreamingServer[openflow_13.PacketIn]) error {
	return status.Error(codes.Unimplemented, "method ReceivePacketsIn not implemented")
}
func (UnimplementedVolthaServiceServer) ReceiveChangeEvents(*emptypb.Empty, grpc.ServerStreamingServer[openflow_13.ChangeEvent]) error {
	return status.Error(codes.Unimplemented, "method ReceiveChangeEvents not implemented")
}
func (UnimplementedVolthaServiceServer) CreateEventFilter(context.Context, *EventFilter) (*EventFilter, error) {
	return nil, status.Error(codes.Unimplemented, "method CreateEventFilter not implemented")
}
func (UnimplementedVolthaServiceServer) GetEventFilter(context.Context, *common.ID) (*EventFilters, error) {
	return nil, status.Error(codes.Unimplemented, "method GetEventFilter not implemented")
}
func (UnimplementedVolthaServiceServer) UpdateEventFilter(context.Context, *EventFilter) (*EventFilter, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateEventFilter not implemented")
}
func (UnimplementedVolthaServiceServer) DeleteEventFilter(context.Context, *EventFilter) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteEventFilter not implemented")
}
func (UnimplementedVolthaServiceServer) ListEventFilters(context.Context, *emptypb.Empty) (*EventFilters, error) {
	return nil, status.Error(codes.Unimplemented, "method ListEventFilters not implemented")
}
func (UnimplementedVolthaServiceServer) GetImages(context.Context, *common.ID) (*Images, error) {
	return nil, status.Error(codes.Unimplemented, "method GetImages not implemented")
}
func (UnimplementedVolthaServiceServer) SelfTest(context.Context, *common.ID) (*SelfTestResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method SelfTest not implemented")
}
func (UnimplementedVolthaServiceServer) GetMibDeviceData(context.Context, *common.ID) (*omci.MibDeviceData, error) {
	return nil, status.Error(codes.Unimplemented, "method GetMibDeviceData not implemented")
}
func (UnimplementedVolthaServiceServer) GetAlarmDeviceData(context.Context, *common.ID) (*omci.AlarmDeviceData, error) {
	return nil, status.Error(codes.Unimplemented, "method GetAlarmDeviceData not implemented")
}
func (UnimplementedVolthaServiceServer) SimulateAlarm(context.Context, *SimulateAlarmRequest) (*common.OperationResp, error) {
	return nil, status.Error(codes.Unimplemented, "method SimulateAlarm not implemented")
}
func (UnimplementedVolthaServiceServer) EnablePort(context.Context, *Port) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method EnablePort not implemented")
}
func (UnimplementedVolthaServiceServer) DisablePort(context.Context, *Port) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisablePort not implemented")
}
func (UnimplementedVolthaServiceServer) GetExtValue(context.Context, *extension.ValueSpecifier) (*extension.ReturnValues, error) {
	return nil, status.Error(codes.Unimplemented, "method GetExtValue not implemented")
}
func (UnimplementedVolthaServiceServer) SetExtValue(context.Context, *extension.ValueSet) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method SetExtValue not implemented")
}
func (UnimplementedVolthaServiceServer) StartOmciTestAction(context.Context, *omci.OmciTestRequest) (*omci.TestResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method StartOmciTestAction not implemented")
}
func (UnimplementedVolthaServiceServer) PutVoipSystemProfile(context.Context, *voip_system_profile.VoipSystemProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method PutVoipSystemProfile not implemented")
}
func (UnimplementedVolthaServiceServer) DeleteVoipSystemProfile(context.Context, *common.Key) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteVoipSystemProfile not implemented")
}
func (UnimplementedVolthaServiceServer) PutVoipUserProfile(context.Context, *voip_user_profile.VoipUserProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method PutVoipUserProfile not implemented")
}
func (UnimplementedVolthaServiceServer) DeleteVoipUserProfile(context.Context, *common.Key) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteVoipUserProfile not implemented")
}
func (UnimplementedVolthaServiceServer) DisableOnuDevice(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisableOnuDevice not implemented")
}
func (UnimplementedVolthaServiceServer) EnableOnuDevice(context.Context, *common.ID) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method EnableOnuDevice not implemented")
}
func (UnimplementedVolthaServiceServer) DisableOnuSerialNumber(context.Context, *OnuSerialNumberOnOLTPon) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method DisableOnuSerialNumber not implemented")
}
func (UnimplementedVolthaServiceServer) EnableOnuSerialNumber(context.Context, *OnuSerialNumberOnOLTPon) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method EnableOnuSerialNumber not implemented")
}
func (UnimplementedVolthaServiceServer) UpdateDevice(context.Context, *UpdateDevice) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateDevice not implemented")
}
func (UnimplementedVolthaServiceServer) mustEmbedUnimplementedVolthaServiceServer() {}
func (UnimplementedVolthaServiceServer) testEmbeddedByValue()                       {}

// UnsafeVolthaServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VolthaServiceServer will
// result in compilation errors.
type UnsafeVolthaServiceServer interface {
	mustEmbedUnimplementedVolthaServiceServer()
}

func RegisterVolthaServiceServer(s grpc.ServiceRegistrar, srv VolthaServiceServer) {
	// If the following call panics, it indicates UnimplementedVolthaServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&VolthaService_ServiceDesc, srv)
}

func _VolthaService_GetVoltha_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetVoltha(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetVoltha_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetVoltha(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListCoreInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListCoreInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListCoreInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListCoreInstances(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetCoreInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetCoreInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetCoreInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetCoreInstance(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListAdapters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListAdapters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListAdapters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListAdapters(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListLogicalDevices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDevices(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetLogicalDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetLogicalDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetLogicalDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetLogicalDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDevicePorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDevicePorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListLogicalDevicePorts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDevicePorts(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetLogicalDevicePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogicalPortId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetLogicalDevicePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetLogicalDevicePort_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetLogicalDevicePort(ctx, req.(*LogicalPortId))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_EnableLogicalDevicePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogicalPortId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).EnableLogicalDevicePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_EnableLogicalDevicePort_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).EnableLogicalDevicePort(ctx, req.(*LogicalPortId))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DisableLogicalDevicePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogicalPortId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DisableLogicalDevicePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DisableLogicalDevicePort_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DisableLogicalDevicePort(ctx, req.(*LogicalPortId))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDeviceFlows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDeviceFlows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListLogicalDeviceFlows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDeviceFlows(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateLogicalDeviceFlowTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(openflow_13.FlowTableUpdate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceFlowTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_UpdateLogicalDeviceFlowTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceFlowTable(ctx, req.(*openflow_13.FlowTableUpdate))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateLogicalDeviceMeterTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(openflow_13.MeterModUpdate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceMeterTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_UpdateLogicalDeviceMeterTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceMeterTable(ctx, req.(*openflow_13.MeterModUpdate))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDeviceMeters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDeviceMeters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListLogicalDeviceMeters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDeviceMeters(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDeviceFlowGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDeviceFlowGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListLogicalDeviceFlowGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDeviceFlowGroups(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateLogicalDeviceFlowGroupTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(openflow_13.FlowGroupTableUpdate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceFlowGroupTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_UpdateLogicalDeviceFlowGroupTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceFlowGroupTable(ctx, req.(*openflow_13.FlowGroupTableUpdate))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListDevices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDevices(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDeviceIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDeviceIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListDeviceIds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDeviceIds(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ReconcileDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.IDs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ReconcileDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ReconcileDevices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ReconcileDevices(ctx, req.(*common.IDs))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_CreateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Device)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).CreateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_CreateDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).CreateDevice(ctx, req.(*Device))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_EnableDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).EnableDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_EnableDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).EnableDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DisableDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DisableDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DisableDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DisableDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_RebootDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).RebootDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_RebootDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).RebootDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DeleteDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DeleteDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DeleteDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DeleteDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ForceDeleteDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ForceDeleteDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ForceDeleteDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ForceDeleteDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DownloadImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DownloadImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DownloadImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DownloadImage(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetImageDownloadStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetImageDownloadStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetImageDownloadStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetImageDownloadStatus(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetImageDownload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetImageDownload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetImageDownload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetImageDownload(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListImageDownloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListImageDownloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListImageDownloads_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListImageDownloads(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_CancelImageDownload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).CancelImageDownload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_CancelImageDownload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).CancelImageDownload(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ActivateImageUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ActivateImageUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ActivateImageUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ActivateImageUpdate(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_RevertImageUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).RevertImageUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_RevertImageUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).RevertImageUpdate(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DownloadImageToDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageDownloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DownloadImageToDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DownloadImageToDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DownloadImageToDevice(ctx, req.(*DeviceImageDownloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetImageStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetImageStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetImageStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetImageStatus(ctx, req.(*DeviceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_AbortImageUpgradeToDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).AbortImageUpgradeToDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_AbortImageUpgradeToDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).AbortImageUpgradeToDevice(ctx, req.(*DeviceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetOnuImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetOnuImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetOnuImages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetOnuImages(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ActivateImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ActivateImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ActivateImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ActivateImage(ctx, req.(*DeviceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_CommitImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).CommitImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_CommitImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).CommitImage(ctx, req.(*DeviceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDevicePorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDevicePorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListDevicePorts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDevicePorts(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDevicePmConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDevicePmConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListDevicePmConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDevicePmConfigs(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateDevicePmConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PmConfigs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateDevicePmConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_UpdateDevicePmConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateDevicePmConfigs(ctx, req.(*PmConfigs))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDeviceFlows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDeviceFlows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListDeviceFlows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDeviceFlows(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDeviceFlowGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDeviceFlowGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListDeviceFlowGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDeviceFlowGroups(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDeviceTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDeviceTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListDeviceTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDeviceTypes(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetDeviceType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetDeviceType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetDeviceType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetDeviceType(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_StreamPacketsOut_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(VolthaServiceServer).StreamPacketsOut(&grpc.GenericServerStream[openflow_13.PacketOut, emptypb.Empty]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type VolthaService_StreamPacketsOutServer = grpc.ClientStreamingServer[openflow_13.PacketOut, emptypb.Empty]

func _VolthaService_ReceivePacketsIn_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(VolthaServiceServer).ReceivePacketsIn(m, &grpc.GenericServerStream[emptypb.Empty, openflow_13.PacketIn]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type VolthaService_ReceivePacketsInServer = grpc.ServerStreamingServer[openflow_13.PacketIn]

func _VolthaService_ReceiveChangeEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(VolthaServiceServer).ReceiveChangeEvents(m, &grpc.GenericServerStream[emptypb.Empty, openflow_13.ChangeEvent]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type VolthaService_ReceiveChangeEventsServer = grpc.ServerStreamingServer[openflow_13.ChangeEvent]

func _VolthaService_CreateEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).CreateEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_CreateEventFilter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).CreateEventFilter(ctx, req.(*EventFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetEventFilter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetEventFilter(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_UpdateEventFilter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateEventFilter(ctx, req.(*EventFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DeleteEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DeleteEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DeleteEventFilter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DeleteEventFilter(ctx, req.(*EventFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListEventFilters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListEventFilters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_ListEventFilters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListEventFilters(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetImages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetImages(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_SelfTest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).SelfTest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_SelfTest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).SelfTest(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetMibDeviceData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetMibDeviceData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetMibDeviceData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetMibDeviceData(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetAlarmDeviceData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetAlarmDeviceData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetAlarmDeviceData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetAlarmDeviceData(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_SimulateAlarm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SimulateAlarmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).SimulateAlarm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_SimulateAlarm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).SimulateAlarm(ctx, req.(*SimulateAlarmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_EnablePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Port)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).EnablePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_EnablePort_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).EnablePort(ctx, req.(*Port))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DisablePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Port)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DisablePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DisablePort_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DisablePort(ctx, req.(*Port))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetExtValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(extension.ValueSpecifier)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetExtValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_GetExtValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetExtValue(ctx, req.(*extension.ValueSpecifier))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_SetExtValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(extension.ValueSet)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).SetExtValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_SetExtValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).SetExtValue(ctx, req.(*extension.ValueSet))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_StartOmciTestAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(omci.OmciTestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).StartOmciTestAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_StartOmciTestAction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).StartOmciTestAction(ctx, req.(*omci.OmciTestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_PutVoipSystemProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voip_system_profile.VoipSystemProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).PutVoipSystemProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_PutVoipSystemProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).PutVoipSystemProfile(ctx, req.(*voip_system_profile.VoipSystemProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DeleteVoipSystemProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.Key)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DeleteVoipSystemProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DeleteVoipSystemProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DeleteVoipSystemProfile(ctx, req.(*common.Key))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_PutVoipUserProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(voip_user_profile.VoipUserProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).PutVoipUserProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_PutVoipUserProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).PutVoipUserProfile(ctx, req.(*voip_user_profile.VoipUserProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DeleteVoipUserProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.Key)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DeleteVoipUserProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DeleteVoipUserProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DeleteVoipUserProfile(ctx, req.(*common.Key))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DisableOnuDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DisableOnuDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DisableOnuDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DisableOnuDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_EnableOnuDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).EnableOnuDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_EnableOnuDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).EnableOnuDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DisableOnuSerialNumber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OnuSerialNumberOnOLTPon)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DisableOnuSerialNumber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_DisableOnuSerialNumber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DisableOnuSerialNumber(ctx, req.(*OnuSerialNumberOnOLTPon))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_EnableOnuSerialNumber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OnuSerialNumberOnOLTPon)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).EnableOnuSerialNumber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_EnableOnuSerialNumber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).EnableOnuSerialNumber(ctx, req.(*OnuSerialNumberOnOLTPon))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDevice)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VolthaService_UpdateDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateDevice(ctx, req.(*UpdateDevice))
	}
	return interceptor(ctx, in, info, handler)
}

// VolthaService_ServiceDesc is the grpc.ServiceDesc for VolthaService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VolthaService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "voltha.VolthaService",
	HandlerType: (*VolthaServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetVoltha",
			Handler:    _VolthaService_GetVoltha_Handler,
		},
		{
			MethodName: "ListCoreInstances",
			Handler:    _VolthaService_ListCoreInstances_Handler,
		},
		{
			MethodName: "GetCoreInstance",
			Handler:    _VolthaService_GetCoreInstance_Handler,
		},
		{
			MethodName: "ListAdapters",
			Handler:    _VolthaService_ListAdapters_Handler,
		},
		{
			MethodName: "ListLogicalDevices",
			Handler:    _VolthaService_ListLogicalDevices_Handler,
		},
		{
			MethodName: "GetLogicalDevice",
			Handler:    _VolthaService_GetLogicalDevice_Handler,
		},
		{
			MethodName: "ListLogicalDevicePorts",
			Handler:    _VolthaService_ListLogicalDevicePorts_Handler,
		},
		{
			MethodName: "GetLogicalDevicePort",
			Handler:    _VolthaService_GetLogicalDevicePort_Handler,
		},
		{
			MethodName: "EnableLogicalDevicePort",
			Handler:    _VolthaService_EnableLogicalDevicePort_Handler,
		},
		{
			MethodName: "DisableLogicalDevicePort",
			Handler:    _VolthaService_DisableLogicalDevicePort_Handler,
		},
		{
			MethodName: "ListLogicalDeviceFlows",
			Handler:    _VolthaService_ListLogicalDeviceFlows_Handler,
		},
		{
			MethodName: "UpdateLogicalDeviceFlowTable",
			Handler:    _VolthaService_UpdateLogicalDeviceFlowTable_Handler,
		},
		{
			MethodName: "UpdateLogicalDeviceMeterTable",
			Handler:    _VolthaService_UpdateLogicalDeviceMeterTable_Handler,
		},
		{
			MethodName: "ListLogicalDeviceMeters",
			Handler:    _VolthaService_ListLogicalDeviceMeters_Handler,
		},
		{
			MethodName: "ListLogicalDeviceFlowGroups",
			Handler:    _VolthaService_ListLogicalDeviceFlowGroups_Handler,
		},
		{
			MethodName: "UpdateLogicalDeviceFlowGroupTable",
			Handler:    _VolthaService_UpdateLogicalDeviceFlowGroupTable_Handler,
		},
		{
			MethodName: "ListDevices",
			Handler:    _VolthaService_ListDevices_Handler,
		},
		{
			MethodName: "ListDeviceIds",
			Handler:    _VolthaService_ListDeviceIds_Handler,
		},
		{
			MethodName: "ReconcileDevices",
			Handler:    _VolthaService_ReconcileDevices_Handler,
		},
		{
			MethodName: "GetDevice",
			Handler:    _VolthaService_GetDevice_Handler,
		},
		{
			MethodName: "CreateDevice",
			Handler:    _VolthaService_CreateDevice_Handler,
		},
		{
			MethodName: "EnableDevice",
			Handler:    _VolthaService_EnableDevice_Handler,
		},
		{
			MethodName: "DisableDevice",
			Handler:    _VolthaService_DisableDevice_Handler,
		},
		{
			MethodName: "RebootDevice",
			Handler:    _VolthaService_RebootDevice_Handler,
		},
		{
			MethodName: "DeleteDevice",
			Handler:    _VolthaService_DeleteDevice_Handler,
		},
		{
			MethodName: "ForceDeleteDevice",
			Handler:    _VolthaService_ForceDeleteDevice_Handler,
		},
		{
			MethodName: "DownloadImage",
			Handler:    _VolthaService_DownloadImage_Handler,
		},
		{
			MethodName: "GetImageDownloadStatus",
			Handler:    _VolthaService_GetImageDownloadStatus_Handler,
		},
		{
			MethodName: "GetImageDownload",
			Handler:    _VolthaService_GetImageDownload_Handler,
		},
		{
			MethodName: "ListImageDownloads",
			Handler:    _VolthaService_ListImageDownloads_Handler,
		},
		{
			MethodName: "CancelImageDownload",
			Handler:    _VolthaService_CancelImageDownload_Handler,
		},
		{
			MethodName: "ActivateImageUpdate",
			Handler:    _VolthaService_ActivateImageUpdate_Handler,
		},
		{
			MethodName: "RevertImageUpdate",
			Handler:    _VolthaService_RevertImageUpdate_Handler,
		},
		{
			MethodName: "DownloadImageToDevice",
			Handler:    _VolthaService_DownloadImageToDevice_Handler,
		},
		{
			MethodName: "GetImageStatus",
			Handler:    _VolthaService_GetImageStatus_Handler,
		},
		{
			MethodName: "AbortImageUpgradeToDevice",
			Handler:    _VolthaService_AbortImageUpgradeToDevice_Handler,
		},
		{
			MethodName: "GetOnuImages",
			Handler:    _VolthaService_GetOnuImages_Handler,
		},
		{
			MethodName: "ActivateImage",
			Handler:    _VolthaService_ActivateImage_Handler,
		},
		{
			MethodName: "CommitImage",
			Handler:    _VolthaService_CommitImage_Handler,
		},
		{
			MethodName: "ListDevicePorts",
			Handler:    _VolthaService_ListDevicePorts_Handler,
		},
		{
			MethodName: "ListDevicePmConfigs",
			Handler:    _VolthaService_ListDevicePmConfigs_Handler,
		},
		{
			MethodName: "UpdateDevicePmConfigs",
			Handler:    _VolthaService_UpdateDevicePmConfigs_Handler,
		},
		{
			MethodName: "ListDeviceFlows",
			Handler:    _VolthaService_ListDeviceFlows_Handler,
		},
		{
			MethodName: "ListDeviceFlowGroups",
			Handler:    _VolthaService_ListDeviceFlowGroups_Handler,
		},
		{
			MethodName: "ListDeviceTypes",
			Handler:    _VolthaService_ListDeviceTypes_Handler,
		},
		{
			MethodName: "GetDeviceType",
			Handler:    _VolthaService_GetDeviceType_Handler,
		},
		{
			MethodName: "CreateEventFilter",
			Handler:    _VolthaService_CreateEventFilter_Handler,
		},
		{
			MethodName: "GetEventFilter",
			Handler:    _VolthaService_GetEventFilter_Handler,
		},
		{
			MethodName: "UpdateEventFilter",
			Handler:    _VolthaService_UpdateEventFilter_Handler,
		},
		{
			MethodName: "DeleteEventFilter",
			Handler:    _VolthaService_DeleteEventFilter_Handler,
		},
		{
			MethodName: "ListEventFilters",
			Handler:    _VolthaService_ListEventFilters_Handler,
		},
		{
			MethodName: "GetImages",
			Handler:    _VolthaService_GetImages_Handler,
		},
		{
			MethodName: "SelfTest",
			Handler:    _VolthaService_SelfTest_Handler,
		},
		{
			MethodName: "GetMibDeviceData",
			Handler:    _VolthaService_GetMibDeviceData_Handler,
		},
		{
			MethodName: "GetAlarmDeviceData",
			Handler:    _VolthaService_GetAlarmDeviceData_Handler,
		},
		{
			MethodName: "SimulateAlarm",
			Handler:    _VolthaService_SimulateAlarm_Handler,
		},
		{
			MethodName: "EnablePort",
			Handler:    _VolthaService_EnablePort_Handler,
		},
		{
			MethodName: "DisablePort",
			Handler:    _VolthaService_DisablePort_Handler,
		},
		{
			MethodName: "GetExtValue",
			Handler:    _VolthaService_GetExtValue_Handler,
		},
		{
			MethodName: "SetExtValue",
			Handler:    _VolthaService_SetExtValue_Handler,
		},
		{
			MethodName: "StartOmciTestAction",
			Handler:    _VolthaService_StartOmciTestAction_Handler,
		},
		{
			MethodName: "PutVoipSystemProfile",
			Handler:    _VolthaService_PutVoipSystemProfile_Handler,
		},
		{
			MethodName: "DeleteVoipSystemProfile",
			Handler:    _VolthaService_DeleteVoipSystemProfile_Handler,
		},
		{
			MethodName: "PutVoipUserProfile",
			Handler:    _VolthaService_PutVoipUserProfile_Handler,
		},
		{
			MethodName: "DeleteVoipUserProfile",
			Handler:    _VolthaService_DeleteVoipUserProfile_Handler,
		},
		{
			MethodName: "DisableOnuDevice",
			Handler:    _VolthaService_DisableOnuDevice_Handler,
		},
		{
			MethodName: "EnableOnuDevice",
			Handler:    _VolthaService_EnableOnuDevice_Handler,
		},
		{
			MethodName: "DisableOnuSerialNumber",
			Handler:    _VolthaService_DisableOnuSerialNumber_Handler,
		},
		{
			MethodName: "EnableOnuSerialNumber",
			Handler:    _VolthaService_EnableOnuSerialNumber_Handler,
		},
		{
			MethodName: "UpdateDevice",
			Handler:    _VolthaService_UpdateDevice_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamPacketsOut",
			Handler:       _VolthaService_StreamPacketsOut_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "ReceivePacketsIn",
			Handler:       _VolthaService_ReceivePacketsIn_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ReceiveChangeEvents",
			Handler:       _VolthaService_ReceiveChangeEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "voltha_protos/voltha.proto",
}
