// Copyright 2018-2024 Open Networking Foundation (ONF) and the ONF Contributors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at:
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v4.25.8
// source: voltha_protos/extensions.proto

package extension

import (
	common "github.com/opencord/voltha-protos/v5/go/common"
	config "github.com/opencord/voltha-protos/v5/go/ext/config"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ValueType_Type int32

const (
	ValueType_EMPTY    ValueType_Type = 0
	ValueType_DISTANCE ValueType_Type = 1
)

// Enum value maps for ValueType_Type.
var (
	ValueType_Type_name = map[int32]string{
		0: "EMPTY",
		1: "DISTANCE",
	}
	ValueType_Type_value = map[string]int32{
		"EMPTY":    0,
		"DISTANCE": 1,
	}
)

func (x ValueType_Type) Enum() *ValueType_Type {
	p := new(ValueType_Type)
	*p = x
	return p
}

func (x ValueType_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValueType_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[0].Descriptor()
}

func (ValueType_Type) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[0]
}

func (x ValueType_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValueType_Type.Descriptor instead.
func (ValueType_Type) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{1, 0}
}

type GetOnuUniInfoResponse_ConfigurationInd int32

const (
	GetOnuUniInfoResponse_UNKOWN               GetOnuUniInfoResponse_ConfigurationInd = 0
	GetOnuUniInfoResponse_TEN_BASE_T_FDX       GetOnuUniInfoResponse_ConfigurationInd = 1
	GetOnuUniInfoResponse_HUNDRED_BASE_T_FDX   GetOnuUniInfoResponse_ConfigurationInd = 2
	GetOnuUniInfoResponse_GIGABIT_ETHERNET_FDX GetOnuUniInfoResponse_ConfigurationInd = 3
	GetOnuUniInfoResponse_TEN_G_ETHERNET_FDX   GetOnuUniInfoResponse_ConfigurationInd = 4
	GetOnuUniInfoResponse_TEN_BASE_T_HDX       GetOnuUniInfoResponse_ConfigurationInd = 5
	GetOnuUniInfoResponse_HUNDRED_BASE_T_HDX   GetOnuUniInfoResponse_ConfigurationInd = 6
	GetOnuUniInfoResponse_GIGABIT_ETHERNET_HDX GetOnuUniInfoResponse_ConfigurationInd = 7
)

// Enum value maps for GetOnuUniInfoResponse_ConfigurationInd.
var (
	GetOnuUniInfoResponse_ConfigurationInd_name = map[int32]string{
		0: "UNKOWN",
		1: "TEN_BASE_T_FDX",
		2: "HUNDRED_BASE_T_FDX",
		3: "GIGABIT_ETHERNET_FDX",
		4: "TEN_G_ETHERNET_FDX",
		5: "TEN_BASE_T_HDX",
		6: "HUNDRED_BASE_T_HDX",
		7: "GIGABIT_ETHERNET_HDX",
	}
	GetOnuUniInfoResponse_ConfigurationInd_value = map[string]int32{
		"UNKOWN":               0,
		"TEN_BASE_T_FDX":       1,
		"HUNDRED_BASE_T_FDX":   2,
		"GIGABIT_ETHERNET_FDX": 3,
		"TEN_G_ETHERNET_FDX":   4,
		"TEN_BASE_T_HDX":       5,
		"HUNDRED_BASE_T_HDX":   6,
		"GIGABIT_ETHERNET_HDX": 7,
	}
)

func (x GetOnuUniInfoResponse_ConfigurationInd) Enum() *GetOnuUniInfoResponse_ConfigurationInd {
	p := new(GetOnuUniInfoResponse_ConfigurationInd)
	*p = x
	return p
}

func (x GetOnuUniInfoResponse_ConfigurationInd) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetOnuUniInfoResponse_ConfigurationInd) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[1].Descriptor()
}

func (GetOnuUniInfoResponse_ConfigurationInd) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[1]
}

func (x GetOnuUniInfoResponse_ConfigurationInd) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetOnuUniInfoResponse_ConfigurationInd.Descriptor instead.
func (GetOnuUniInfoResponse_ConfigurationInd) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{7, 0}
}

type GetOnuUniInfoResponse_AdministrativeState int32

const (
	GetOnuUniInfoResponse_ADMSTATE_UNDEFINED GetOnuUniInfoResponse_AdministrativeState = 0
	GetOnuUniInfoResponse_LOCKED             GetOnuUniInfoResponse_AdministrativeState = 1
	GetOnuUniInfoResponse_UNLOCKED           GetOnuUniInfoResponse_AdministrativeState = 2
)

// Enum value maps for GetOnuUniInfoResponse_AdministrativeState.
var (
	GetOnuUniInfoResponse_AdministrativeState_name = map[int32]string{
		0: "ADMSTATE_UNDEFINED",
		1: "LOCKED",
		2: "UNLOCKED",
	}
	GetOnuUniInfoResponse_AdministrativeState_value = map[string]int32{
		"ADMSTATE_UNDEFINED": 0,
		"LOCKED":             1,
		"UNLOCKED":           2,
	}
)

func (x GetOnuUniInfoResponse_AdministrativeState) Enum() *GetOnuUniInfoResponse_AdministrativeState {
	p := new(GetOnuUniInfoResponse_AdministrativeState)
	*p = x
	return p
}

func (x GetOnuUniInfoResponse_AdministrativeState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetOnuUniInfoResponse_AdministrativeState) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[2].Descriptor()
}

func (GetOnuUniInfoResponse_AdministrativeState) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[2]
}

func (x GetOnuUniInfoResponse_AdministrativeState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetOnuUniInfoResponse_AdministrativeState.Descriptor instead.
func (GetOnuUniInfoResponse_AdministrativeState) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{7, 1}
}

type GetOnuUniInfoResponse_OperationalState int32

const (
	GetOnuUniInfoResponse_OPERSTATE_UNDEFINED GetOnuUniInfoResponse_OperationalState = 0
	GetOnuUniInfoResponse_ENABLED             GetOnuUniInfoResponse_OperationalState = 1
	GetOnuUniInfoResponse_DISABLED            GetOnuUniInfoResponse_OperationalState = 2
)

// Enum value maps for GetOnuUniInfoResponse_OperationalState.
var (
	GetOnuUniInfoResponse_OperationalState_name = map[int32]string{
		0: "OPERSTATE_UNDEFINED",
		1: "ENABLED",
		2: "DISABLED",
	}
	GetOnuUniInfoResponse_OperationalState_value = map[string]int32{
		"OPERSTATE_UNDEFINED": 0,
		"ENABLED":             1,
		"DISABLED":            2,
	}
)

func (x GetOnuUniInfoResponse_OperationalState) Enum() *GetOnuUniInfoResponse_OperationalState {
	p := new(GetOnuUniInfoResponse_OperationalState)
	*p = x
	return p
}

func (x GetOnuUniInfoResponse_OperationalState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetOnuUniInfoResponse_OperationalState) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[3].Descriptor()
}

func (GetOnuUniInfoResponse_OperationalState) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[3]
}

func (x GetOnuUniInfoResponse_OperationalState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetOnuUniInfoResponse_OperationalState.Descriptor instead.
func (GetOnuUniInfoResponse_OperationalState) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{7, 2}
}

type GetOltPortCounters_PortType int32

const (
	GetOltPortCounters_Port_UNKNOWN      GetOltPortCounters_PortType = 0
	GetOltPortCounters_Port_ETHERNET_NNI GetOltPortCounters_PortType = 1
	GetOltPortCounters_Port_PON_OLT      GetOltPortCounters_PortType = 2
)

// Enum value maps for GetOltPortCounters_PortType.
var (
	GetOltPortCounters_PortType_name = map[int32]string{
		0: "Port_UNKNOWN",
		1: "Port_ETHERNET_NNI",
		2: "Port_PON_OLT",
	}
	GetOltPortCounters_PortType_value = map[string]int32{
		"Port_UNKNOWN":      0,
		"Port_ETHERNET_NNI": 1,
		"Port_PON_OLT":      2,
	}
)

func (x GetOltPortCounters_PortType) Enum() *GetOltPortCounters_PortType {
	p := new(GetOltPortCounters_PortType)
	*p = x
	return p
}

func (x GetOltPortCounters_PortType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetOltPortCounters_PortType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[4].Descriptor()
}

func (GetOltPortCounters_PortType) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[4]
}

func (x GetOltPortCounters_PortType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetOltPortCounters_PortType.Descriptor instead.
func (GetOltPortCounters_PortType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{8, 0}
}

type GetOnuEthernetBridgePortHistory_Direction int32

const (
	GetOnuEthernetBridgePortHistory_UNDEFINED  GetOnuEthernetBridgePortHistory_Direction = 0
	GetOnuEthernetBridgePortHistory_UPSTREAM   GetOnuEthernetBridgePortHistory_Direction = 1
	GetOnuEthernetBridgePortHistory_DOWNSTREAM GetOnuEthernetBridgePortHistory_Direction = 2
)

// Enum value maps for GetOnuEthernetBridgePortHistory_Direction.
var (
	GetOnuEthernetBridgePortHistory_Direction_name = map[int32]string{
		0: "UNDEFINED",
		1: "UPSTREAM",
		2: "DOWNSTREAM",
	}
	GetOnuEthernetBridgePortHistory_Direction_value = map[string]int32{
		"UNDEFINED":  0,
		"UPSTREAM":   1,
		"DOWNSTREAM": 2,
	}
)

func (x GetOnuEthernetBridgePortHistory_Direction) Enum() *GetOnuEthernetBridgePortHistory_Direction {
	p := new(GetOnuEthernetBridgePortHistory_Direction)
	*p = x
	return p
}

func (x GetOnuEthernetBridgePortHistory_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetOnuEthernetBridgePortHistory_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[5].Descriptor()
}

func (GetOnuEthernetBridgePortHistory_Direction) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[5]
}

func (x GetOnuEthernetBridgePortHistory_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetOnuEthernetBridgePortHistory_Direction.Descriptor instead.
func (GetOnuEthernetBridgePortHistory_Direction) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{12, 0}
}

type GetOmciEthernetFrameExtendedPmResponse_Format int32

const (
	GetOmciEthernetFrameExtendedPmResponse_THIRTY_TWO_BIT GetOmciEthernetFrameExtendedPmResponse_Format = 0
	GetOmciEthernetFrameExtendedPmResponse_SIXTY_FOUR_BIT GetOmciEthernetFrameExtendedPmResponse_Format = 1
)

// Enum value maps for GetOmciEthernetFrameExtendedPmResponse_Format.
var (
	GetOmciEthernetFrameExtendedPmResponse_Format_name = map[int32]string{
		0: "THIRTY_TWO_BIT",
		1: "SIXTY_FOUR_BIT",
	}
	GetOmciEthernetFrameExtendedPmResponse_Format_value = map[string]int32{
		"THIRTY_TWO_BIT": 0,
		"SIXTY_FOUR_BIT": 1,
	}
)

func (x GetOmciEthernetFrameExtendedPmResponse_Format) Enum() *GetOmciEthernetFrameExtendedPmResponse_Format {
	p := new(GetOmciEthernetFrameExtendedPmResponse_Format)
	*p = x
	return p
}

func (x GetOmciEthernetFrameExtendedPmResponse_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetOmciEthernetFrameExtendedPmResponse_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[6].Descriptor()
}

func (GetOmciEthernetFrameExtendedPmResponse_Format) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[6]
}

func (x GetOmciEthernetFrameExtendedPmResponse_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetOmciEthernetFrameExtendedPmResponse_Format.Descriptor instead.
func (GetOmciEthernetFrameExtendedPmResponse_Format) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{36, 0}
}

type GetOffloadedAppsStatisticsRequest_OffloadedApp int32

const (
	GetOffloadedAppsStatisticsRequest_UNDEFINED GetOffloadedAppsStatisticsRequest_OffloadedApp = 0
	GetOffloadedAppsStatisticsRequest_PPPoeIA   GetOffloadedAppsStatisticsRequest_OffloadedApp = 1
	GetOffloadedAppsStatisticsRequest_DHCPv4RA  GetOffloadedAppsStatisticsRequest_OffloadedApp = 2
	GetOffloadedAppsStatisticsRequest_DHCPv6RA  GetOffloadedAppsStatisticsRequest_OffloadedApp = 3
)

// Enum value maps for GetOffloadedAppsStatisticsRequest_OffloadedApp.
var (
	GetOffloadedAppsStatisticsRequest_OffloadedApp_name = map[int32]string{
		0: "UNDEFINED",
		1: "PPPoeIA",
		2: "DHCPv4RA",
		3: "DHCPv6RA",
	}
	GetOffloadedAppsStatisticsRequest_OffloadedApp_value = map[string]int32{
		"UNDEFINED": 0,
		"PPPoeIA":   1,
		"DHCPv4RA":  2,
		"DHCPv6RA":  3,
	}
)

func (x GetOffloadedAppsStatisticsRequest_OffloadedApp) Enum() *GetOffloadedAppsStatisticsRequest_OffloadedApp {
	p := new(GetOffloadedAppsStatisticsRequest_OffloadedApp)
	*p = x
	return p
}

func (x GetOffloadedAppsStatisticsRequest_OffloadedApp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetOffloadedAppsStatisticsRequest_OffloadedApp) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[7].Descriptor()
}

func (GetOffloadedAppsStatisticsRequest_OffloadedApp) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[7]
}

func (x GetOffloadedAppsStatisticsRequest_OffloadedApp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetOffloadedAppsStatisticsRequest_OffloadedApp.Descriptor instead.
func (GetOffloadedAppsStatisticsRequest_OffloadedApp) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{45, 0}
}

type GetValueResponse_Status int32

const (
	GetValueResponse_STATUS_UNDEFINED GetValueResponse_Status = 0
	GetValueResponse_OK               GetValueResponse_Status = 1
	GetValueResponse_ERROR            GetValueResponse_Status = 2
)

// Enum value maps for GetValueResponse_Status.
var (
	GetValueResponse_Status_name = map[int32]string{
		0: "STATUS_UNDEFINED",
		1: "OK",
		2: "ERROR",
	}
	GetValueResponse_Status_value = map[string]int32{
		"STATUS_UNDEFINED": 0,
		"OK":               1,
		"ERROR":            2,
	}
)

func (x GetValueResponse_Status) Enum() *GetValueResponse_Status {
	p := new(GetValueResponse_Status)
	*p = x
	return p
}

func (x GetValueResponse_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetValueResponse_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[8].Descriptor()
}

func (GetValueResponse_Status) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[8]
}

func (x GetValueResponse_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetValueResponse_Status.Descriptor instead.
func (GetValueResponse_Status) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{48, 0}
}

type GetValueResponse_ErrorReason int32

const (
	GetValueResponse_REASON_UNDEFINED  GetValueResponse_ErrorReason = 0
	GetValueResponse_UNSUPPORTED       GetValueResponse_ErrorReason = 1
	GetValueResponse_INVALID_DEVICE_ID GetValueResponse_ErrorReason = 2
	GetValueResponse_INVALID_PORT_TYPE GetValueResponse_ErrorReason = 3
	GetValueResponse_TIMEOUT           GetValueResponse_ErrorReason = 4
	GetValueResponse_INVALID_REQ_TYPE  GetValueResponse_ErrorReason = 5
	GetValueResponse_INTERNAL_ERROR    GetValueResponse_ErrorReason = 6
	GetValueResponse_INVALID_DEVICE    GetValueResponse_ErrorReason = 7
)

// Enum value maps for GetValueResponse_ErrorReason.
var (
	GetValueResponse_ErrorReason_name = map[int32]string{
		0: "REASON_UNDEFINED",
		1: "UNSUPPORTED",
		2: "INVALID_DEVICE_ID",
		3: "INVALID_PORT_TYPE",
		4: "TIMEOUT",
		5: "INVALID_REQ_TYPE",
		6: "INTERNAL_ERROR",
		7: "INVALID_DEVICE",
	}
	GetValueResponse_ErrorReason_value = map[string]int32{
		"REASON_UNDEFINED":  0,
		"UNSUPPORTED":       1,
		"INVALID_DEVICE_ID": 2,
		"INVALID_PORT_TYPE": 3,
		"TIMEOUT":           4,
		"INVALID_REQ_TYPE":  5,
		"INTERNAL_ERROR":    6,
		"INVALID_DEVICE":    7,
	}
)

func (x GetValueResponse_ErrorReason) Enum() *GetValueResponse_ErrorReason {
	p := new(GetValueResponse_ErrorReason)
	*p = x
	return p
}

func (x GetValueResponse_ErrorReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetValueResponse_ErrorReason) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[9].Descriptor()
}

func (GetValueResponse_ErrorReason) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[9]
}

func (x GetValueResponse_ErrorReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetValueResponse_ErrorReason.Descriptor instead.
func (GetValueResponse_ErrorReason) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{48, 1}
}

type SetValueResponse_Status int32

const (
	SetValueResponse_STATUS_UNDEFINED SetValueResponse_Status = 0
	SetValueResponse_OK               SetValueResponse_Status = 1
	SetValueResponse_ERROR            SetValueResponse_Status = 2
)

// Enum value maps for SetValueResponse_Status.
var (
	SetValueResponse_Status_name = map[int32]string{
		0: "STATUS_UNDEFINED",
		1: "OK",
		2: "ERROR",
	}
	SetValueResponse_Status_value = map[string]int32{
		"STATUS_UNDEFINED": 0,
		"OK":               1,
		"ERROR":            2,
	}
)

func (x SetValueResponse_Status) Enum() *SetValueResponse_Status {
	p := new(SetValueResponse_Status)
	*p = x
	return p
}

func (x SetValueResponse_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SetValueResponse_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[10].Descriptor()
}

func (SetValueResponse_Status) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[10]
}

func (x SetValueResponse_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SetValueResponse_Status.Descriptor instead.
func (SetValueResponse_Status) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{52, 0}
}

type SetValueResponse_ErrorReason int32

const (
	SetValueResponse_REASON_UNDEFINED      SetValueResponse_ErrorReason = 0
	SetValueResponse_UNSUPPORTED           SetValueResponse_ErrorReason = 1
	SetValueResponse_INVALID_DEVICE_ID     SetValueResponse_ErrorReason = 2
	SetValueResponse_INVALID_ONU_DEVICE_ID SetValueResponse_ErrorReason = 3
	SetValueResponse_INVALID_UNI_ID        SetValueResponse_ErrorReason = 4
)

// Enum value maps for SetValueResponse_ErrorReason.
var (
	SetValueResponse_ErrorReason_name = map[int32]string{
		0: "REASON_UNDEFINED",
		1: "UNSUPPORTED",
		2: "INVALID_DEVICE_ID",
		3: "INVALID_ONU_DEVICE_ID",
		4: "INVALID_UNI_ID",
	}
	SetValueResponse_ErrorReason_value = map[string]int32{
		"REASON_UNDEFINED":      0,
		"UNSUPPORTED":           1,
		"INVALID_DEVICE_ID":     2,
		"INVALID_ONU_DEVICE_ID": 3,
		"INVALID_UNI_ID":        4,
	}
)

func (x SetValueResponse_ErrorReason) Enum() *SetValueResponse_ErrorReason {
	p := new(SetValueResponse_ErrorReason)
	*p = x
	return p
}

func (x SetValueResponse_ErrorReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SetValueResponse_ErrorReason) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_extensions_proto_enumTypes[11].Descriptor()
}

func (SetValueResponse_ErrorReason) Type() protoreflect.EnumType {
	return &file_voltha_protos_extensions_proto_enumTypes[11]
}

func (x SetValueResponse_ErrorReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SetValueResponse_ErrorReason.Descriptor instead.
func (SetValueResponse_ErrorReason) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{52, 1}
}

type ValueSet struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Id    string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Types that are valid to be assigned to Value:
	//
	//	*ValueSet_AlarmConfig
	Value         isValueSet_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValueSet) Reset() {
	*x = ValueSet{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValueSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueSet) ProtoMessage() {}

func (x *ValueSet) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueSet.ProtoReflect.Descriptor instead.
func (*ValueSet) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{0}
}

func (x *ValueSet) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ValueSet) GetValue() isValueSet_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ValueSet) GetAlarmConfig() *config.AlarmConfig {
	if x != nil {
		if x, ok := x.Value.(*ValueSet_AlarmConfig); ok {
			return x.AlarmConfig
		}
	}
	return nil
}

type isValueSet_Value interface {
	isValueSet_Value()
}

type ValueSet_AlarmConfig struct {
	AlarmConfig *config.AlarmConfig `protobuf:"bytes,2,opt,name=alarm_config,json=alarmConfig,proto3,oneof"`
}

func (*ValueSet_AlarmConfig) isValueSet_Value() {}

type ValueType struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValueType) Reset() {
	*x = ValueType{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValueType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueType) ProtoMessage() {}

func (x *ValueType) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueType.ProtoReflect.Descriptor instead.
func (*ValueType) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{1}
}

type ValueSpecifier struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Value         ValueType_Type         `protobuf:"varint,2,opt,name=value,proto3,enum=extension.ValueType_Type" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValueSpecifier) Reset() {
	*x = ValueSpecifier{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValueSpecifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueSpecifier) ProtoMessage() {}

func (x *ValueSpecifier) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueSpecifier.ProtoReflect.Descriptor instead.
func (*ValueSpecifier) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{2}
}

func (x *ValueSpecifier) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ValueSpecifier) GetValue() ValueType_Type {
	if x != nil {
		return x.Value
	}
	return ValueType_EMPTY
}

type ReturnValues struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Set           uint32                 `protobuf:"varint,1,opt,name=Set,proto3" json:"Set,omitempty"`                 // Specifies what values are
	Unsupported   uint32                 `protobuf:"varint,2,opt,name=Unsupported,proto3" json:"Unsupported,omitempty"` // Specifies requested values not
	Error         uint32                 `protobuf:"varint,3,opt,name=Error,proto3" json:"Error,omitempty"`             // Specifies requested values not
	Distance      uint32                 `protobuf:"varint,4,opt,name=Distance,proto3" json:"Distance,omitempty"`       // Value of distance Set includes
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReturnValues) Reset() {
	*x = ReturnValues{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReturnValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReturnValues) ProtoMessage() {}

func (x *ReturnValues) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReturnValues.ProtoReflect.Descriptor instead.
func (*ReturnValues) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{3}
}

func (x *ReturnValues) GetSet() uint32 {
	if x != nil {
		return x.Set
	}
	return 0
}

func (x *ReturnValues) GetUnsupported() uint32 {
	if x != nil {
		return x.Unsupported
	}
	return 0
}

func (x *ReturnValues) GetError() uint32 {
	if x != nil {
		return x.Error
	}
	return 0
}

func (x *ReturnValues) GetDistance() uint32 {
	if x != nil {
		return x.Distance
	}
	return 0
}

type GetDistanceRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OnuDeviceId   string                 `protobuf:"bytes,1,opt,name=onuDeviceId,proto3" json:"onuDeviceId,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetDistanceRequest) Reset() {
	*x = GetDistanceRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDistanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDistanceRequest) ProtoMessage() {}

func (x *GetDistanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDistanceRequest.ProtoReflect.Descriptor instead.
func (*GetDistanceRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{4}
}

func (x *GetDistanceRequest) GetOnuDeviceId() string {
	if x != nil {
		return x.OnuDeviceId
	}
	return ""
}

type GetDistanceResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Distance      uint32                 `protobuf:"varint,1,opt,name=distance,proto3" json:"distance,omitempty"` // distance in meters
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetDistanceResponse) Reset() {
	*x = GetDistanceResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDistanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDistanceResponse) ProtoMessage() {}

func (x *GetDistanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDistanceResponse.ProtoReflect.Descriptor instead.
func (*GetDistanceResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{5}
}

func (x *GetDistanceResponse) GetDistance() uint32 {
	if x != nil {
		return x.Distance
	}
	return 0
}

type GetOnuUniInfoRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UniIndex      uint32                 `protobuf:"varint,1,opt,name=uniIndex,proto3" json:"uniIndex,omitempty"` // Index of the uni starting from 0
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuUniInfoRequest) Reset() {
	*x = GetOnuUniInfoRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuUniInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuUniInfoRequest) ProtoMessage() {}

func (x *GetOnuUniInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuUniInfoRequest.ProtoReflect.Descriptor instead.
func (*GetOnuUniInfoRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{6}
}

func (x *GetOnuUniInfoRequest) GetUniIndex() uint32 {
	if x != nil {
		return x.UniIndex
	}
	return 0
}

type GetOnuUniInfoResponse struct {
	state         protoimpl.MessageState                    `protogen:"open.v1"`
	AdmState      GetOnuUniInfoResponse_AdministrativeState `protobuf:"varint,1,opt,name=admState,proto3,enum=extension.GetOnuUniInfoResponse_AdministrativeState" json:"admState,omitempty"`
	OperState     GetOnuUniInfoResponse_OperationalState    `protobuf:"varint,2,opt,name=operState,proto3,enum=extension.GetOnuUniInfoResponse_OperationalState" json:"operState,omitempty"`
	ConfigInd     GetOnuUniInfoResponse_ConfigurationInd    `protobuf:"varint,3,opt,name=configInd,proto3,enum=extension.GetOnuUniInfoResponse_ConfigurationInd" json:"configInd,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuUniInfoResponse) Reset() {
	*x = GetOnuUniInfoResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuUniInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuUniInfoResponse) ProtoMessage() {}

func (x *GetOnuUniInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuUniInfoResponse.ProtoReflect.Descriptor instead.
func (*GetOnuUniInfoResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{7}
}

func (x *GetOnuUniInfoResponse) GetAdmState() GetOnuUniInfoResponse_AdministrativeState {
	if x != nil {
		return x.AdmState
	}
	return GetOnuUniInfoResponse_ADMSTATE_UNDEFINED
}

func (x *GetOnuUniInfoResponse) GetOperState() GetOnuUniInfoResponse_OperationalState {
	if x != nil {
		return x.OperState
	}
	return GetOnuUniInfoResponse_OPERSTATE_UNDEFINED
}

func (x *GetOnuUniInfoResponse) GetConfigInd() GetOnuUniInfoResponse_ConfigurationInd {
	if x != nil {
		return x.ConfigInd
	}
	return GetOnuUniInfoResponse_UNKOWN
}

type GetOltPortCounters struct {
	state         protoimpl.MessageState      `protogen:"open.v1"`
	PortNo        uint32                      `protobuf:"varint,1,opt,name=portNo,proto3" json:"portNo,omitempty"` // Device-unique port number
	PortType      GetOltPortCounters_PortType `protobuf:"varint,2,opt,name=portType,proto3,enum=extension.GetOltPortCounters_PortType" json:"portType,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOltPortCounters) Reset() {
	*x = GetOltPortCounters{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOltPortCounters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOltPortCounters) ProtoMessage() {}

func (x *GetOltPortCounters) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOltPortCounters.ProtoReflect.Descriptor instead.
func (*GetOltPortCounters) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{8}
}

func (x *GetOltPortCounters) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *GetOltPortCounters) GetPortType() GetOltPortCounters_PortType {
	if x != nil {
		return x.PortType
	}
	return GetOltPortCounters_Port_UNKNOWN
}

type GetOltPortCountersResponse struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	TxBytes        uint64                 `protobuf:"varint,1,opt,name=txBytes,proto3" json:"txBytes,omitempty"`
	RxBytes        uint64                 `protobuf:"varint,2,opt,name=rxBytes,proto3" json:"rxBytes,omitempty"`
	TxPackets      uint64                 `protobuf:"varint,3,opt,name=txPackets,proto3" json:"txPackets,omitempty"`
	RxPackets      uint64                 `protobuf:"varint,4,opt,name=rxPackets,proto3" json:"rxPackets,omitempty"`
	TxErrorPackets uint64                 `protobuf:"varint,5,opt,name=txErrorPackets,proto3" json:"txErrorPackets,omitempty"`
	RxErrorPackets uint64                 `protobuf:"varint,6,opt,name=rxErrorPackets,proto3" json:"rxErrorPackets,omitempty"`
	TxBcastPackets uint64                 `protobuf:"varint,7,opt,name=txBcastPackets,proto3" json:"txBcastPackets,omitempty"`
	RxBcastPackets uint64                 `protobuf:"varint,8,opt,name=rxBcastPackets,proto3" json:"rxBcastPackets,omitempty"`
	TxUcastPackets uint64                 `protobuf:"varint,9,opt,name=txUcastPackets,proto3" json:"txUcastPackets,omitempty"`
	RxUcastPackets uint64                 `protobuf:"varint,10,opt,name=rxUcastPackets,proto3" json:"rxUcastPackets,omitempty"`
	TxMcastPackets uint64                 `protobuf:"varint,11,opt,name=txMcastPackets,proto3" json:"txMcastPackets,omitempty"`
	RxMcastPackets uint64                 `protobuf:"varint,12,opt,name=rxMcastPackets,proto3" json:"rxMcastPackets,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GetOltPortCountersResponse) Reset() {
	*x = GetOltPortCountersResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOltPortCountersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOltPortCountersResponse) ProtoMessage() {}

func (x *GetOltPortCountersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOltPortCountersResponse.ProtoReflect.Descriptor instead.
func (*GetOltPortCountersResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{9}
}

func (x *GetOltPortCountersResponse) GetTxBytes() uint64 {
	if x != nil {
		return x.TxBytes
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetRxBytes() uint64 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetTxPackets() uint64 {
	if x != nil {
		return x.TxPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetRxPackets() uint64 {
	if x != nil {
		return x.RxPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetTxErrorPackets() uint64 {
	if x != nil {
		return x.TxErrorPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetRxErrorPackets() uint64 {
	if x != nil {
		return x.RxErrorPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetTxBcastPackets() uint64 {
	if x != nil {
		return x.TxBcastPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetRxBcastPackets() uint64 {
	if x != nil {
		return x.RxBcastPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetTxUcastPackets() uint64 {
	if x != nil {
		return x.TxUcastPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetRxUcastPackets() uint64 {
	if x != nil {
		return x.RxUcastPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetTxMcastPackets() uint64 {
	if x != nil {
		return x.TxMcastPackets
	}
	return 0
}

func (x *GetOltPortCountersResponse) GetRxMcastPackets() uint64 {
	if x != nil {
		return x.RxMcastPackets
	}
	return 0
}

type GetOnuPonOpticalInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Empty         *emptypb.Empty         `protobuf:"bytes,1,opt,name=empty,proto3" json:"empty,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuPonOpticalInfo) Reset() {
	*x = GetOnuPonOpticalInfo{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuPonOpticalInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuPonOpticalInfo) ProtoMessage() {}

func (x *GetOnuPonOpticalInfo) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuPonOpticalInfo.ProtoReflect.Descriptor instead.
func (*GetOnuPonOpticalInfo) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{10}
}

func (x *GetOnuPonOpticalInfo) GetEmpty() *emptypb.Empty {
	if x != nil {
		return x.Empty
	}
	return nil
}

// These values correspond to the Optical Line Supervision Test results
// described in section A3.39.5 of ITU-T G.988 (11/2017) specification.
type GetOnuPonOpticalInfoResponse struct {
	state                  protoimpl.MessageState `protogen:"open.v1"`
	PowerFeedVoltage       float32                `protobuf:"fixed32,1,opt,name=powerFeedVoltage,proto3" json:"powerFeedVoltage,omitempty"`             // unit of value is voltage
	ReceivedOpticalPower   float32                `protobuf:"fixed32,2,opt,name=receivedOpticalPower,proto3" json:"receivedOpticalPower,omitempty"`     // unit of value is dBm
	MeanOpticalLaunchPower float32                `protobuf:"fixed32,3,opt,name=meanOpticalLaunchPower,proto3" json:"meanOpticalLaunchPower,omitempty"` // unit of value is dBm
	LaserBiasCurrent       float32                `protobuf:"fixed32,4,opt,name=laserBiasCurrent,proto3" json:"laserBiasCurrent,omitempty"`             // unit of value is milli-amphere (mA)
	Temperature            float32                `protobuf:"fixed32,5,opt,name=temperature,proto3" json:"temperature,omitempty"`                       // unit of value is degree celsius
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *GetOnuPonOpticalInfoResponse) Reset() {
	*x = GetOnuPonOpticalInfoResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuPonOpticalInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuPonOpticalInfoResponse) ProtoMessage() {}

func (x *GetOnuPonOpticalInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuPonOpticalInfoResponse.ProtoReflect.Descriptor instead.
func (*GetOnuPonOpticalInfoResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{11}
}

func (x *GetOnuPonOpticalInfoResponse) GetPowerFeedVoltage() float32 {
	if x != nil {
		return x.PowerFeedVoltage
	}
	return 0
}

func (x *GetOnuPonOpticalInfoResponse) GetReceivedOpticalPower() float32 {
	if x != nil {
		return x.ReceivedOpticalPower
	}
	return 0
}

func (x *GetOnuPonOpticalInfoResponse) GetMeanOpticalLaunchPower() float32 {
	if x != nil {
		return x.MeanOpticalLaunchPower
	}
	return 0
}

func (x *GetOnuPonOpticalInfoResponse) GetLaserBiasCurrent() float32 {
	if x != nil {
		return x.LaserBiasCurrent
	}
	return 0
}

func (x *GetOnuPonOpticalInfoResponse) GetTemperature() float32 {
	if x != nil {
		return x.Temperature
	}
	return 0
}

type GetOnuEthernetBridgePortHistory struct {
	state         protoimpl.MessageState                    `protogen:"open.v1"`
	Direction     GetOnuEthernetBridgePortHistory_Direction `protobuf:"varint,1,opt,name=direction,proto3,enum=extension.GetOnuEthernetBridgePortHistory_Direction" json:"direction,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuEthernetBridgePortHistory) Reset() {
	*x = GetOnuEthernetBridgePortHistory{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuEthernetBridgePortHistory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuEthernetBridgePortHistory) ProtoMessage() {}

func (x *GetOnuEthernetBridgePortHistory) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuEthernetBridgePortHistory.ProtoReflect.Descriptor instead.
func (*GetOnuEthernetBridgePortHistory) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{12}
}

func (x *GetOnuEthernetBridgePortHistory) GetDirection() GetOnuEthernetBridgePortHistory_Direction {
	if x != nil {
		return x.Direction
	}
	return GetOnuEthernetBridgePortHistory_UNDEFINED
}

type GetOnuEthernetBridgePortHistoryResponse struct {
	state                   protoimpl.MessageState `protogen:"open.v1"`
	DropEvents              uint32                 `protobuf:"varint,1,opt,name=dropEvents,proto3" json:"dropEvents,omitempty"`
	Octets                  uint32                 `protobuf:"varint,2,opt,name=octets,proto3" json:"octets,omitempty"`
	Packets                 uint32                 `protobuf:"varint,3,opt,name=packets,proto3" json:"packets,omitempty"`
	BroadcastPackets        uint32                 `protobuf:"varint,4,opt,name=broadcastPackets,proto3" json:"broadcastPackets,omitempty"`
	MulticastPackets        uint32                 `protobuf:"varint,5,opt,name=multicastPackets,proto3" json:"multicastPackets,omitempty"`
	CrcErroredPackets       uint32                 `protobuf:"varint,6,opt,name=crcErroredPackets,proto3" json:"crcErroredPackets,omitempty"`
	UndersizePackets        uint32                 `protobuf:"varint,7,opt,name=undersizePackets,proto3" json:"undersizePackets,omitempty"`
	OversizePackets         uint32                 `protobuf:"varint,8,opt,name=oversizePackets,proto3" json:"oversizePackets,omitempty"`
	Packets64Octets         uint32                 `protobuf:"varint,9,opt,name=packets64octets,proto3" json:"packets64octets,omitempty"`
	Packets65To127Octets    uint32                 `protobuf:"varint,10,opt,name=packets65To127octets,proto3" json:"packets65To127octets,omitempty"`
	Packets128To255Octets   uint32                 `protobuf:"varint,11,opt,name=packets128To255Octets,proto3" json:"packets128To255Octets,omitempty"`
	Packets256To511Octets   uint32                 `protobuf:"varint,12,opt,name=packets256To511octets,proto3" json:"packets256To511octets,omitempty"`
	Packets512To1023Octets  uint32                 `protobuf:"varint,13,opt,name=packets512To1023octets,proto3" json:"packets512To1023octets,omitempty"`
	Packets1024To1518Octets uint32                 `protobuf:"varint,14,opt,name=packets1024To1518octets,proto3" json:"packets1024To1518octets,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetOnuEthernetBridgePortHistoryResponse) Reset() {
	*x = GetOnuEthernetBridgePortHistoryResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuEthernetBridgePortHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuEthernetBridgePortHistoryResponse) ProtoMessage() {}

func (x *GetOnuEthernetBridgePortHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuEthernetBridgePortHistoryResponse.ProtoReflect.Descriptor instead.
func (*GetOnuEthernetBridgePortHistoryResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{13}
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetDropEvents() uint32 {
	if x != nil {
		return x.DropEvents
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetOctets() uint32 {
	if x != nil {
		return x.Octets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetPackets() uint32 {
	if x != nil {
		return x.Packets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetBroadcastPackets() uint32 {
	if x != nil {
		return x.BroadcastPackets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetMulticastPackets() uint32 {
	if x != nil {
		return x.MulticastPackets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetCrcErroredPackets() uint32 {
	if x != nil {
		return x.CrcErroredPackets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetUndersizePackets() uint32 {
	if x != nil {
		return x.UndersizePackets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetOversizePackets() uint32 {
	if x != nil {
		return x.OversizePackets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetPackets64Octets() uint32 {
	if x != nil {
		return x.Packets64Octets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetPackets65To127Octets() uint32 {
	if x != nil {
		return x.Packets65To127Octets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetPackets128To255Octets() uint32 {
	if x != nil {
		return x.Packets128To255Octets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetPackets256To511Octets() uint32 {
	if x != nil {
		return x.Packets256To511Octets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetPackets512To1023Octets() uint32 {
	if x != nil {
		return x.Packets512To1023Octets
	}
	return 0
}

func (x *GetOnuEthernetBridgePortHistoryResponse) GetPackets1024To1518Octets() uint32 {
	if x != nil {
		return x.Packets1024To1518Octets
	}
	return 0
}

// GetOnuAllocGemHistoryRequest collects GEM and AllocId stats from ONU
type GetOnuAllocGemHistoryRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Empty         *emptypb.Empty         `protobuf:"bytes,1,opt,name=empty,proto3" json:"empty,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuAllocGemHistoryRequest) Reset() {
	*x = GetOnuAllocGemHistoryRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuAllocGemHistoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuAllocGemHistoryRequest) ProtoMessage() {}

func (x *GetOnuAllocGemHistoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuAllocGemHistoryRequest.ProtoReflect.Descriptor instead.
func (*GetOnuAllocGemHistoryRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{14}
}

func (x *GetOnuAllocGemHistoryRequest) GetEmpty() *emptypb.Empty {
	if x != nil {
		return x.Empty
	}
	return nil
}

type OnuGemPortHistoryData struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	GemId                uint32                 `protobuf:"varint,1,opt,name=gemId,proto3" json:"gemId,omitempty"`
	TransmittedGEMFrames uint32                 `protobuf:"varint,2,opt,name=transmittedGEMFrames,proto3" json:"transmittedGEMFrames,omitempty"`
	ReceivedGEMFrames    uint32                 `protobuf:"varint,3,opt,name=receivedGEMFrames,proto3" json:"receivedGEMFrames,omitempty"`
	// Deprecated: uint32 cannot handle large byte counters and will overflow after ~4GB.
	// Use received_payload_bytes_64 instead for full 64-bit precision.
	//
	// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
	ReceivedPayloadBytes uint32 `protobuf:"varint,4,opt,name=receivedPayloadBytes,proto3" json:"receivedPayloadBytes,omitempty"`
	// Deprecated: uint32 cannot handle large byte counters and will overflow after ~4GB.
	// Use transmitted_payload_bytes_64 instead for full 64-bit precision.
	//
	// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
	TransmittedPayloadBytes    uint32 `protobuf:"varint,5,opt,name=transmittedPayloadBytes,proto3" json:"transmittedPayloadBytes,omitempty"`
	EncryptionKeyErrors        uint32 `protobuf:"varint,6,opt,name=encryptionKeyErrors,proto3" json:"encryptionKeyErrors,omitempty"`
	ReceivedPayloadBytes_64    uint64 `protobuf:"fixed64,7,opt,name=received_payload_bytes_64,json=receivedPayloadBytes64,proto3" json:"received_payload_bytes_64,omitempty"`
	TransmittedPayloadBytes_64 uint64 `protobuf:"fixed64,8,opt,name=transmitted_payload_bytes_64,json=transmittedPayloadBytes64,proto3" json:"transmitted_payload_bytes_64,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *OnuGemPortHistoryData) Reset() {
	*x = OnuGemPortHistoryData{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuGemPortHistoryData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuGemPortHistoryData) ProtoMessage() {}

func (x *OnuGemPortHistoryData) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuGemPortHistoryData.ProtoReflect.Descriptor instead.
func (*OnuGemPortHistoryData) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{15}
}

func (x *OnuGemPortHistoryData) GetGemId() uint32 {
	if x != nil {
		return x.GemId
	}
	return 0
}

func (x *OnuGemPortHistoryData) GetTransmittedGEMFrames() uint32 {
	if x != nil {
		return x.TransmittedGEMFrames
	}
	return 0
}

func (x *OnuGemPortHistoryData) GetReceivedGEMFrames() uint32 {
	if x != nil {
		return x.ReceivedGEMFrames
	}
	return 0
}

// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
func (x *OnuGemPortHistoryData) GetReceivedPayloadBytes() uint32 {
	if x != nil {
		return x.ReceivedPayloadBytes
	}
	return 0
}

// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
func (x *OnuGemPortHistoryData) GetTransmittedPayloadBytes() uint32 {
	if x != nil {
		return x.TransmittedPayloadBytes
	}
	return 0
}

func (x *OnuGemPortHistoryData) GetEncryptionKeyErrors() uint32 {
	if x != nil {
		return x.EncryptionKeyErrors
	}
	return 0
}

func (x *OnuGemPortHistoryData) GetReceivedPayloadBytes_64() uint64 {
	if x != nil {
		return x.ReceivedPayloadBytes_64
	}
	return 0
}

func (x *OnuGemPortHistoryData) GetTransmittedPayloadBytes_64() uint64 {
	if x != nil {
		return x.TransmittedPayloadBytes_64
	}
	return 0
}

type OnuAllocHistoryData struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	AllocId       uint32                 `protobuf:"varint,1,opt,name=allocId,proto3" json:"allocId,omitempty"`
	RxBytes       uint32                 `protobuf:"varint,2,opt,name=rxBytes,proto3" json:"rxBytes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuAllocHistoryData) Reset() {
	*x = OnuAllocHistoryData{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuAllocHistoryData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuAllocHistoryData) ProtoMessage() {}

func (x *OnuAllocHistoryData) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuAllocHistoryData.ProtoReflect.Descriptor instead.
func (*OnuAllocHistoryData) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{16}
}

func (x *OnuAllocHistoryData) GetAllocId() uint32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *OnuAllocHistoryData) GetRxBytes() uint32 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

type OnuAllocGemHistoryData struct {
	state          protoimpl.MessageState   `protogen:"open.v1"`
	OnuAllocIdInfo *OnuAllocHistoryData     `protobuf:"bytes,1,opt,name=onuAllocIdInfo,proto3" json:"onuAllocIdInfo,omitempty"`
	GemPortInfo    []*OnuGemPortHistoryData `protobuf:"bytes,2,rep,name=gemPortInfo,proto3" json:"gemPortInfo,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *OnuAllocGemHistoryData) Reset() {
	*x = OnuAllocGemHistoryData{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuAllocGemHistoryData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuAllocGemHistoryData) ProtoMessage() {}

func (x *OnuAllocGemHistoryData) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuAllocGemHistoryData.ProtoReflect.Descriptor instead.
func (*OnuAllocGemHistoryData) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{17}
}

func (x *OnuAllocGemHistoryData) GetOnuAllocIdInfo() *OnuAllocHistoryData {
	if x != nil {
		return x.OnuAllocIdInfo
	}
	return nil
}

func (x *OnuAllocGemHistoryData) GetGemPortInfo() []*OnuGemPortHistoryData {
	if x != nil {
		return x.GemPortInfo
	}
	return nil
}

type GetOnuAllocGemHistoryResponse struct {
	state                  protoimpl.MessageState    `protogen:"open.v1"`
	OnuAllocGemHistoryData []*OnuAllocGemHistoryData `protobuf:"bytes,1,rep,name=onuAllocGemHistoryData,proto3" json:"onuAllocGemHistoryData,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *GetOnuAllocGemHistoryResponse) Reset() {
	*x = GetOnuAllocGemHistoryResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuAllocGemHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuAllocGemHistoryResponse) ProtoMessage() {}

func (x *GetOnuAllocGemHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuAllocGemHistoryResponse.ProtoReflect.Descriptor instead.
func (*GetOnuAllocGemHistoryResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{18}
}

func (x *GetOnuAllocGemHistoryResponse) GetOnuAllocGemHistoryData() []*OnuAllocGemHistoryData {
	if x != nil {
		return x.OnuAllocGemHistoryData
	}
	return nil
}

type GetOnuFecHistory struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Empty         *emptypb.Empty         `protobuf:"bytes,1,opt,name=empty,proto3" json:"empty,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuFecHistory) Reset() {
	*x = GetOnuFecHistory{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuFecHistory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuFecHistory) ProtoMessage() {}

func (x *GetOnuFecHistory) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuFecHistory.ProtoReflect.Descriptor instead.
func (*GetOnuFecHistory) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{19}
}

func (x *GetOnuFecHistory) GetEmpty() *emptypb.Empty {
	if x != nil {
		return x.Empty
	}
	return nil
}

type GetOnuFecHistoryResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Deprecated: uint32 cannot handle large counter values and will overflow.
	// Use fec_corrected_bytes_64 instead for full 64-bit precision.
	//
	// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
	CorrectedBytes uint32 `protobuf:"varint,1,opt,name=correctedBytes,proto3" json:"correctedBytes,omitempty"`
	// Deprecated: uint32 cannot handle large counter values and will overflow.
	// Use fec_corrected_code_words_64 instead for full 64-bit precision.
	//
	// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
	CorrectedCodeWords uint32 `protobuf:"varint,2,opt,name=correctedCodeWords,proto3" json:"correctedCodeWords,omitempty"`
	FecSeconds         uint32 `protobuf:"varint,3,opt,name=fecSeconds,proto3" json:"fecSeconds,omitempty"`
	// Deprecated: uint32 cannot handle large counter values and will overflow.
	// Use total_code_words_64 instead for full 64-bit precision.
	//
	// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
	TotalCodeWords uint32 `protobuf:"varint,4,opt,name=totalCodeWords,proto3" json:"totalCodeWords,omitempty"`
	// Deprecated: uint32 cannot handle large counter values and will overflow.
	// Use uncorrectable_code_words_64 instead for full 64-bit precision.
	//
	// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
	UncorrectableCodeWords    uint32 `protobuf:"varint,5,opt,name=uncorrectableCodeWords,proto3" json:"uncorrectableCodeWords,omitempty"`
	FecCorrectedBytes_64      uint64 `protobuf:"fixed64,6,opt,name=fec_corrected_bytes_64,json=fecCorrectedBytes64,proto3" json:"fec_corrected_bytes_64,omitempty"`
	FecCorrectedCodeWords_64  uint64 `protobuf:"fixed64,7,opt,name=fec_corrected_code_words_64,json=fecCorrectedCodeWords64,proto3" json:"fec_corrected_code_words_64,omitempty"`
	TotalCodeWords_64         uint64 `protobuf:"fixed64,8,opt,name=total_code_words_64,json=totalCodeWords64,proto3" json:"total_code_words_64,omitempty"`
	UncorrectableCodeWords_64 uint64 `protobuf:"fixed64,9,opt,name=uncorrectable_code_words_64,json=uncorrectableCodeWords64,proto3" json:"uncorrectable_code_words_64,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *GetOnuFecHistoryResponse) Reset() {
	*x = GetOnuFecHistoryResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuFecHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuFecHistoryResponse) ProtoMessage() {}

func (x *GetOnuFecHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuFecHistoryResponse.ProtoReflect.Descriptor instead.
func (*GetOnuFecHistoryResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{20}
}

// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
func (x *GetOnuFecHistoryResponse) GetCorrectedBytes() uint32 {
	if x != nil {
		return x.CorrectedBytes
	}
	return 0
}

// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
func (x *GetOnuFecHistoryResponse) GetCorrectedCodeWords() uint32 {
	if x != nil {
		return x.CorrectedCodeWords
	}
	return 0
}

func (x *GetOnuFecHistoryResponse) GetFecSeconds() uint32 {
	if x != nil {
		return x.FecSeconds
	}
	return 0
}

// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
func (x *GetOnuFecHistoryResponse) GetTotalCodeWords() uint32 {
	if x != nil {
		return x.TotalCodeWords
	}
	return 0
}

// Deprecated: Marked as deprecated in voltha_protos/extensions.proto.
func (x *GetOnuFecHistoryResponse) GetUncorrectableCodeWords() uint32 {
	if x != nil {
		return x.UncorrectableCodeWords
	}
	return 0
}

func (x *GetOnuFecHistoryResponse) GetFecCorrectedBytes_64() uint64 {
	if x != nil {
		return x.FecCorrectedBytes_64
	}
	return 0
}

func (x *GetOnuFecHistoryResponse) GetFecCorrectedCodeWords_64() uint64 {
	if x != nil {
		return x.FecCorrectedCodeWords_64
	}
	return 0
}

func (x *GetOnuFecHistoryResponse) GetTotalCodeWords_64() uint64 {
	if x != nil {
		return x.TotalCodeWords_64
	}
	return 0
}

func (x *GetOnuFecHistoryResponse) GetUncorrectableCodeWords_64() uint64 {
	if x != nil {
		return x.UncorrectableCodeWords_64
	}
	return 0
}

type GetOnuCountersRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuCountersRequest) Reset() {
	*x = GetOnuCountersRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuCountersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuCountersRequest) ProtoMessage() {}

func (x *GetOnuCountersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuCountersRequest.ProtoReflect.Descriptor instead.
func (*GetOnuCountersRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{21}
}

func (x *GetOnuCountersRequest) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *GetOnuCountersRequest) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

type GetOmciEthernetFrameExtendedPmRequest struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	OnuDeviceId string                 `protobuf:"bytes,1,opt,name=onuDeviceId,proto3" json:"onuDeviceId,omitempty"`
	// Types that are valid to be assigned to IsUniIndex:
	//
	//	*GetOmciEthernetFrameExtendedPmRequest_UniIndex
	IsUniIndex    isGetOmciEthernetFrameExtendedPmRequest_IsUniIndex `protobuf_oneof:"is_uni_index"`
	Reset_        bool                                               `protobuf:"varint,3,opt,name=reset,proto3" json:"reset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOmciEthernetFrameExtendedPmRequest) Reset() {
	*x = GetOmciEthernetFrameExtendedPmRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOmciEthernetFrameExtendedPmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOmciEthernetFrameExtendedPmRequest) ProtoMessage() {}

func (x *GetOmciEthernetFrameExtendedPmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOmciEthernetFrameExtendedPmRequest.ProtoReflect.Descriptor instead.
func (*GetOmciEthernetFrameExtendedPmRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{22}
}

func (x *GetOmciEthernetFrameExtendedPmRequest) GetOnuDeviceId() string {
	if x != nil {
		return x.OnuDeviceId
	}
	return ""
}

func (x *GetOmciEthernetFrameExtendedPmRequest) GetIsUniIndex() isGetOmciEthernetFrameExtendedPmRequest_IsUniIndex {
	if x != nil {
		return x.IsUniIndex
	}
	return nil
}

func (x *GetOmciEthernetFrameExtendedPmRequest) GetUniIndex() uint32 {
	if x != nil {
		if x, ok := x.IsUniIndex.(*GetOmciEthernetFrameExtendedPmRequest_UniIndex); ok {
			return x.UniIndex
		}
	}
	return 0
}

func (x *GetOmciEthernetFrameExtendedPmRequest) GetReset_() bool {
	if x != nil {
		return x.Reset_
	}
	return false
}

type isGetOmciEthernetFrameExtendedPmRequest_IsUniIndex interface {
	isGetOmciEthernetFrameExtendedPmRequest_IsUniIndex()
}

type GetOmciEthernetFrameExtendedPmRequest_UniIndex struct {
	UniIndex uint32 `protobuf:"varint,2,opt,name=uniIndex,proto3,oneof"` // Index of the uni starting from 0
}

func (*GetOmciEthernetFrameExtendedPmRequest_UniIndex) isGetOmciEthernetFrameExtendedPmRequest_IsUniIndex() {
}

// DEPRECATED
type GetRxPowerRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetRxPowerRequest) Reset() {
	*x = GetRxPowerRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRxPowerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRxPowerRequest) ProtoMessage() {}

func (x *GetRxPowerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRxPowerRequest.ProtoReflect.Descriptor instead.
func (*GetRxPowerRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{23}
}

func (x *GetRxPowerRequest) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *GetRxPowerRequest) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

type GetOltRxPowerRequest struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	PortLabel string                 `protobuf:"bytes,1,opt,name=port_label,json=portLabel,proto3" json:"port_label,omitempty"`
	// onu_sn is optional and if onu_sn is an empty string and the label is
	// of a PON port then it means that the Rx Power corresponding to all
	// the ONUs on that PON port is requested. In case the port_label is not
	// of a PON port, the onu_sn does not have any significance
	OnuSn         string `protobuf:"bytes,2,opt,name=onu_sn,json=onuSn,proto3" json:"onu_sn,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOltRxPowerRequest) Reset() {
	*x = GetOltRxPowerRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOltRxPowerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOltRxPowerRequest) ProtoMessage() {}

func (x *GetOltRxPowerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOltRxPowerRequest.ProtoReflect.Descriptor instead.
func (*GetOltRxPowerRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{24}
}

func (x *GetOltRxPowerRequest) GetPortLabel() string {
	if x != nil {
		return x.PortLabel
	}
	return ""
}

func (x *GetOltRxPowerRequest) GetOnuSn() string {
	if x != nil {
		return x.OnuSn
	}
	return ""
}

type GetPonStatsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to PortInfo:
	//
	//	*GetPonStatsRequest_PortLabel
	//	*GetPonStatsRequest_PortId
	PortInfo      isGetPonStatsRequest_PortInfo `protobuf_oneof:"portInfo"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetPonStatsRequest) Reset() {
	*x = GetPonStatsRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPonStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPonStatsRequest) ProtoMessage() {}

func (x *GetPonStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPonStatsRequest.ProtoReflect.Descriptor instead.
func (*GetPonStatsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{25}
}

func (x *GetPonStatsRequest) GetPortInfo() isGetPonStatsRequest_PortInfo {
	if x != nil {
		return x.PortInfo
	}
	return nil
}

func (x *GetPonStatsRequest) GetPortLabel() string {
	if x != nil {
		if x, ok := x.PortInfo.(*GetPonStatsRequest_PortLabel); ok {
			return x.PortLabel
		}
	}
	return ""
}

func (x *GetPonStatsRequest) GetPortId() uint32 {
	if x != nil {
		if x, ok := x.PortInfo.(*GetPonStatsRequest_PortId); ok {
			return x.PortId
		}
	}
	return 0
}

type isGetPonStatsRequest_PortInfo interface {
	isGetPonStatsRequest_PortInfo()
}

type GetPonStatsRequest_PortLabel struct {
	PortLabel string `protobuf:"bytes,1,opt,name=portLabel,proto3,oneof"`
}

type GetPonStatsRequest_PortId struct {
	PortId uint32 `protobuf:"fixed32,2,opt,name=portId,proto3,oneof"`
}

func (*GetPonStatsRequest_PortLabel) isGetPonStatsRequest_PortInfo() {}

func (*GetPonStatsRequest_PortId) isGetPonStatsRequest_PortInfo() {}

type GetPonStatsResponse struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	PonPort        uint32                 `protobuf:"varint,1,opt,name=ponPort,proto3" json:"ponPort,omitempty"`
	PortStatistics *common.PortStatistics `protobuf:"bytes,2,opt,name=portStatistics,proto3" json:"portStatistics,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GetPonStatsResponse) Reset() {
	*x = GetPonStatsResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPonStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPonStatsResponse) ProtoMessage() {}

func (x *GetPonStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPonStatsResponse.ProtoReflect.Descriptor instead.
func (*GetPonStatsResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{26}
}

func (x *GetPonStatsResponse) GetPonPort() uint32 {
	if x != nil {
		return x.PonPort
	}
	return 0
}

func (x *GetPonStatsResponse) GetPortStatistics() *common.PortStatistics {
	if x != nil {
		return x.PortStatistics
	}
	return nil
}

type GetNNIStatsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to PortInfo:
	//
	//	*GetNNIStatsRequest_PortLabel
	//	*GetNNIStatsRequest_PortId
	PortInfo      isGetNNIStatsRequest_PortInfo `protobuf_oneof:"portInfo"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetNNIStatsRequest) Reset() {
	*x = GetNNIStatsRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNNIStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNNIStatsRequest) ProtoMessage() {}

func (x *GetNNIStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNNIStatsRequest.ProtoReflect.Descriptor instead.
func (*GetNNIStatsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{27}
}

func (x *GetNNIStatsRequest) GetPortInfo() isGetNNIStatsRequest_PortInfo {
	if x != nil {
		return x.PortInfo
	}
	return nil
}

func (x *GetNNIStatsRequest) GetPortLabel() string {
	if x != nil {
		if x, ok := x.PortInfo.(*GetNNIStatsRequest_PortLabel); ok {
			return x.PortLabel
		}
	}
	return ""
}

func (x *GetNNIStatsRequest) GetPortId() uint32 {
	if x != nil {
		if x, ok := x.PortInfo.(*GetNNIStatsRequest_PortId); ok {
			return x.PortId
		}
	}
	return 0
}

type isGetNNIStatsRequest_PortInfo interface {
	isGetNNIStatsRequest_PortInfo()
}

type GetNNIStatsRequest_PortLabel struct {
	PortLabel string `protobuf:"bytes,1,opt,name=portLabel,proto3,oneof"`
}

type GetNNIStatsRequest_PortId struct {
	PortId uint32 `protobuf:"fixed32,2,opt,name=portId,proto3,oneof"`
}

func (*GetNNIStatsRequest_PortLabel) isGetNNIStatsRequest_PortInfo() {}

func (*GetNNIStatsRequest_PortId) isGetNNIStatsRequest_PortInfo() {}

type GetNNIStatsResponse struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	NniPort        uint32                 `protobuf:"varint,1,opt,name=nniPort,proto3" json:"nniPort,omitempty"`
	PortStatistics *common.PortStatistics `protobuf:"bytes,2,opt,name=portStatistics,proto3" json:"portStatistics,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GetNNIStatsResponse) Reset() {
	*x = GetNNIStatsResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNNIStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNNIStatsResponse) ProtoMessage() {}

func (x *GetNNIStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNNIStatsResponse.ProtoReflect.Descriptor instead.
func (*GetNNIStatsResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{28}
}

func (x *GetNNIStatsResponse) GetNniPort() uint32 {
	if x != nil {
		return x.NniPort
	}
	return 0
}

func (x *GetNNIStatsResponse) GetPortStatistics() *common.PortStatistics {
	if x != nil {
		return x.PortStatistics
	}
	return nil
}

// GetOnuStatsFromOltRequest collects GEM and AllocId stats from the OLT for a particular ONU.
type GetOnuStatsFromOltRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intfId,proto3" json:"intfId,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onuId,proto3" json:"onuId,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuStatsFromOltRequest) Reset() {
	*x = GetOnuStatsFromOltRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuStatsFromOltRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuStatsFromOltRequest) ProtoMessage() {}

func (x *GetOnuStatsFromOltRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuStatsFromOltRequest.ProtoReflect.Descriptor instead.
func (*GetOnuStatsFromOltRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{29}
}

func (x *GetOnuStatsFromOltRequest) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *GetOnuStatsFromOltRequest) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

type OnuGemPortInfoFromOlt struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GemId         uint32                 `protobuf:"varint,1,opt,name=gemId,proto3" json:"gemId,omitempty"`
	RxPackets     uint64                 `protobuf:"varint,2,opt,name=rxPackets,proto3" json:"rxPackets,omitempty"`
	RxBytes       uint64                 `protobuf:"varint,3,opt,name=rxBytes,proto3" json:"rxBytes,omitempty"`
	TxPackets     uint64                 `protobuf:"varint,4,opt,name=txPackets,proto3" json:"txPackets,omitempty"`
	TxBytes       uint64                 `protobuf:"varint,5,opt,name=txBytes,proto3" json:"txBytes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuGemPortInfoFromOlt) Reset() {
	*x = OnuGemPortInfoFromOlt{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuGemPortInfoFromOlt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuGemPortInfoFromOlt) ProtoMessage() {}

func (x *OnuGemPortInfoFromOlt) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuGemPortInfoFromOlt.ProtoReflect.Descriptor instead.
func (*OnuGemPortInfoFromOlt) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{30}
}

func (x *OnuGemPortInfoFromOlt) GetGemId() uint32 {
	if x != nil {
		return x.GemId
	}
	return 0
}

func (x *OnuGemPortInfoFromOlt) GetRxPackets() uint64 {
	if x != nil {
		return x.RxPackets
	}
	return 0
}

func (x *OnuGemPortInfoFromOlt) GetRxBytes() uint64 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

func (x *OnuGemPortInfoFromOlt) GetTxPackets() uint64 {
	if x != nil {
		return x.TxPackets
	}
	return 0
}

func (x *OnuGemPortInfoFromOlt) GetTxBytes() uint64 {
	if x != nil {
		return x.TxBytes
	}
	return 0
}

type OnuAllocIdInfoFromOlt struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	AllocId       uint32                 `protobuf:"varint,1,opt,name=allocId,proto3" json:"allocId,omitempty"`
	RxBytes       uint64                 `protobuf:"varint,2,opt,name=rxBytes,proto3" json:"rxBytes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuAllocIdInfoFromOlt) Reset() {
	*x = OnuAllocIdInfoFromOlt{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuAllocIdInfoFromOlt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuAllocIdInfoFromOlt) ProtoMessage() {}

func (x *OnuAllocIdInfoFromOlt) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuAllocIdInfoFromOlt.ProtoReflect.Descriptor instead.
func (*OnuAllocIdInfoFromOlt) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{31}
}

func (x *OnuAllocIdInfoFromOlt) GetAllocId() uint32 {
	if x != nil {
		return x.AllocId
	}
	return 0
}

func (x *OnuAllocIdInfoFromOlt) GetRxBytes() uint64 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

type OnuAllocGemStatsFromOltResponse struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	AllocIdInfo   *OnuAllocIdInfoFromOlt   `protobuf:"bytes,1,opt,name=allocIdInfo,proto3" json:"allocIdInfo,omitempty"`
	GemPortInfo   []*OnuGemPortInfoFromOlt `protobuf:"bytes,2,rep,name=gemPortInfo,proto3" json:"gemPortInfo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnuAllocGemStatsFromOltResponse) Reset() {
	*x = OnuAllocGemStatsFromOltResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnuAllocGemStatsFromOltResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnuAllocGemStatsFromOltResponse) ProtoMessage() {}

func (x *OnuAllocGemStatsFromOltResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnuAllocGemStatsFromOltResponse.ProtoReflect.Descriptor instead.
func (*OnuAllocGemStatsFromOltResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{32}
}

func (x *OnuAllocGemStatsFromOltResponse) GetAllocIdInfo() *OnuAllocIdInfoFromOlt {
	if x != nil {
		return x.AllocIdInfo
	}
	return nil
}

func (x *OnuAllocGemStatsFromOltResponse) GetGemPortInfo() []*OnuGemPortInfoFromOlt {
	if x != nil {
		return x.GemPortInfo
	}
	return nil
}

type GetOnuStatsFromOltResponse struct {
	state             protoimpl.MessageState             `protogen:"open.v1"`
	AllocGemStatsInfo []*OnuAllocGemStatsFromOltResponse `protobuf:"bytes,1,rep,name=allocGemStatsInfo,proto3" json:"allocGemStatsInfo,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *GetOnuStatsFromOltResponse) Reset() {
	*x = GetOnuStatsFromOltResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuStatsFromOltResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuStatsFromOltResponse) ProtoMessage() {}

func (x *GetOnuStatsFromOltResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuStatsFromOltResponse.ProtoReflect.Descriptor instead.
func (*GetOnuStatsFromOltResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{33}
}

func (x *GetOnuStatsFromOltResponse) GetAllocGemStatsInfo() []*OnuAllocGemStatsFromOltResponse {
	if x != nil {
		return x.AllocGemStatsInfo
	}
	return nil
}

type GetOnuCountersResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to IsIntfId:
	//
	//	*GetOnuCountersResponse_IntfId
	IsIntfId isGetOnuCountersResponse_IsIntfId `protobuf_oneof:"is_intf_id"`
	// Types that are valid to be assigned to IsOnuId:
	//
	//	*GetOnuCountersResponse_OnuId
	IsOnuId isGetOnuCountersResponse_IsOnuId `protobuf_oneof:"is_onu_id"`
	// Types that are valid to be assigned to IsPositiveDrift:
	//
	//	*GetOnuCountersResponse_PositiveDrift
	IsPositiveDrift isGetOnuCountersResponse_IsPositiveDrift `protobuf_oneof:"is_positive_drift"`
	// Types that are valid to be assigned to IsNegativeDrift:
	//
	//	*GetOnuCountersResponse_NegativeDrift
	IsNegativeDrift isGetOnuCountersResponse_IsNegativeDrift `protobuf_oneof:"is_negative_drift"`
	// Types that are valid to be assigned to IsDelimiterMissDetection:
	//
	//	*GetOnuCountersResponse_DelimiterMissDetection
	IsDelimiterMissDetection isGetOnuCountersResponse_IsDelimiterMissDetection `protobuf_oneof:"is_delimiter_miss_detection"`
	// Types that are valid to be assigned to IsBipErrors:
	//
	//	*GetOnuCountersResponse_BipErrors
	IsBipErrors isGetOnuCountersResponse_IsBipErrors `protobuf_oneof:"is_bip_errors"`
	// Types that are valid to be assigned to IsBipUnits:
	//
	//	*GetOnuCountersResponse_BipUnits
	IsBipUnits isGetOnuCountersResponse_IsBipUnits `protobuf_oneof:"is_bip_units"`
	// Types that are valid to be assigned to IsFecCorrectedSymbols:
	//
	//	*GetOnuCountersResponse_FecCorrectedSymbols
	IsFecCorrectedSymbols isGetOnuCountersResponse_IsFecCorrectedSymbols `protobuf_oneof:"is_fec_corrected_symbols"`
	// Types that are valid to be assigned to IsFecCodewordsCorrected:
	//
	//	*GetOnuCountersResponse_FecCodewordsCorrected
	IsFecCodewordsCorrected isGetOnuCountersResponse_IsFecCodewordsCorrected `protobuf_oneof:"is_fec_codewords_corrected"`
	// Types that are valid to be assigned to IsFecCodewordsUncorrectable:
	//
	//	*GetOnuCountersResponse_FecCodewordsUncorrectable
	IsFecCodewordsUncorrectable isGetOnuCountersResponse_IsFecCodewordsUncorrectable `protobuf_oneof:"is_fec_codewords_uncorrectable"`
	// Types that are valid to be assigned to IsFecCodewords:
	//
	//	*GetOnuCountersResponse_FecCodewords
	IsFecCodewords isGetOnuCountersResponse_IsFecCodewords `protobuf_oneof:"is_fec_codewords"`
	// Types that are valid to be assigned to IsFecCorrectedUnits:
	//
	//	*GetOnuCountersResponse_FecCorrectedUnits
	IsFecCorrectedUnits isGetOnuCountersResponse_IsFecCorrectedUnits `protobuf_oneof:"is_fec_corrected_units"`
	// Types that are valid to be assigned to IsXgemKeyErrors:
	//
	//	*GetOnuCountersResponse_XgemKeyErrors
	IsXgemKeyErrors isGetOnuCountersResponse_IsXgemKeyErrors `protobuf_oneof:"is_xgem_key_errors"`
	// Types that are valid to be assigned to IsXgemLoss:
	//
	//	*GetOnuCountersResponse_XgemLoss
	IsXgemLoss isGetOnuCountersResponse_IsXgemLoss `protobuf_oneof:"is_xgem_loss"`
	// Types that are valid to be assigned to IsRxPloamsError:
	//
	//	*GetOnuCountersResponse_RxPloamsError
	IsRxPloamsError isGetOnuCountersResponse_IsRxPloamsError `protobuf_oneof:"is_rx_ploams_error"`
	// Types that are valid to be assigned to IsRxPloamsNonIdle:
	//
	//	*GetOnuCountersResponse_RxPloamsNonIdle
	IsRxPloamsNonIdle isGetOnuCountersResponse_IsRxPloamsNonIdle `protobuf_oneof:"is_rx_ploams_non_idle"`
	// Types that are valid to be assigned to IsRxOmci:
	//
	//	*GetOnuCountersResponse_RxOmci
	IsRxOmci isGetOnuCountersResponse_IsRxOmci `protobuf_oneof:"is_rx_omci"`
	// Types that are valid to be assigned to IsTxOmci:
	//
	//	*GetOnuCountersResponse_TxOmci
	IsTxOmci isGetOnuCountersResponse_IsTxOmci `protobuf_oneof:"is_tx_omci"`
	// Types that are valid to be assigned to IsRxOmciPacketsCrcError:
	//
	//	*GetOnuCountersResponse_RxOmciPacketsCrcError
	IsRxOmciPacketsCrcError isGetOnuCountersResponse_IsRxOmciPacketsCrcError `protobuf_oneof:"is_rx_omci_packets_crc_error"`
	// Types that are valid to be assigned to IsRxBytes:
	//
	//	*GetOnuCountersResponse_RxBytes
	IsRxBytes isGetOnuCountersResponse_IsRxBytes `protobuf_oneof:"is_rx_bytes"`
	// Types that are valid to be assigned to IsRxPackets:
	//
	//	*GetOnuCountersResponse_RxPackets
	IsRxPackets isGetOnuCountersResponse_IsRxPackets `protobuf_oneof:"is_rx_packets"`
	// Types that are valid to be assigned to IsTxBytes:
	//
	//	*GetOnuCountersResponse_TxBytes
	IsTxBytes isGetOnuCountersResponse_IsTxBytes `protobuf_oneof:"is_tx_bytes"`
	// Types that are valid to be assigned to IsTxPackets:
	//
	//	*GetOnuCountersResponse_TxPackets
	IsTxPackets isGetOnuCountersResponse_IsTxPackets `protobuf_oneof:"is_tx_packets"`
	// Types that are valid to be assigned to IsBerReported:
	//
	//	*GetOnuCountersResponse_BerReported
	IsBerReported isGetOnuCountersResponse_IsBerReported `protobuf_oneof:"is_ber_reported"`
	// Types that are valid to be assigned to IsLcdgErrors:
	//
	//	*GetOnuCountersResponse_LcdgErrors
	IsLcdgErrors isGetOnuCountersResponse_IsLcdgErrors `protobuf_oneof:"is_lcdg_errors"`
	// Types that are valid to be assigned to IsRdiErrors:
	//
	//	*GetOnuCountersResponse_RdiErrors
	IsRdiErrors isGetOnuCountersResponse_IsRdiErrors `protobuf_oneof:"is_rdi_errors"`
	// Types that are valid to be assigned to IsTimestamp:
	//
	//	*GetOnuCountersResponse_Timestamp
	IsTimestamp isGetOnuCountersResponse_IsTimestamp `protobuf_oneof:"is_timestamp"`
	// Types that are valid to be assigned to IsHecErrors:
	//
	//	*GetOnuCountersResponse_HecErrors
	IsHecErrors   isGetOnuCountersResponse_IsHecErrors `protobuf_oneof:"is_hec_errors"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuCountersResponse) Reset() {
	*x = GetOnuCountersResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuCountersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuCountersResponse) ProtoMessage() {}

func (x *GetOnuCountersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuCountersResponse.ProtoReflect.Descriptor instead.
func (*GetOnuCountersResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{34}
}

func (x *GetOnuCountersResponse) GetIsIntfId() isGetOnuCountersResponse_IsIntfId {
	if x != nil {
		return x.IsIntfId
	}
	return nil
}

func (x *GetOnuCountersResponse) GetIntfId() uint32 {
	if x != nil {
		if x, ok := x.IsIntfId.(*GetOnuCountersResponse_IntfId); ok {
			return x.IntfId
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsOnuId() isGetOnuCountersResponse_IsOnuId {
	if x != nil {
		return x.IsOnuId
	}
	return nil
}

func (x *GetOnuCountersResponse) GetOnuId() uint32 {
	if x != nil {
		if x, ok := x.IsOnuId.(*GetOnuCountersResponse_OnuId); ok {
			return x.OnuId
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsPositiveDrift() isGetOnuCountersResponse_IsPositiveDrift {
	if x != nil {
		return x.IsPositiveDrift
	}
	return nil
}

func (x *GetOnuCountersResponse) GetPositiveDrift() uint64 {
	if x != nil {
		if x, ok := x.IsPositiveDrift.(*GetOnuCountersResponse_PositiveDrift); ok {
			return x.PositiveDrift
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsNegativeDrift() isGetOnuCountersResponse_IsNegativeDrift {
	if x != nil {
		return x.IsNegativeDrift
	}
	return nil
}

func (x *GetOnuCountersResponse) GetNegativeDrift() uint64 {
	if x != nil {
		if x, ok := x.IsNegativeDrift.(*GetOnuCountersResponse_NegativeDrift); ok {
			return x.NegativeDrift
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsDelimiterMissDetection() isGetOnuCountersResponse_IsDelimiterMissDetection {
	if x != nil {
		return x.IsDelimiterMissDetection
	}
	return nil
}

func (x *GetOnuCountersResponse) GetDelimiterMissDetection() uint64 {
	if x != nil {
		if x, ok := x.IsDelimiterMissDetection.(*GetOnuCountersResponse_DelimiterMissDetection); ok {
			return x.DelimiterMissDetection
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsBipErrors() isGetOnuCountersResponse_IsBipErrors {
	if x != nil {
		return x.IsBipErrors
	}
	return nil
}

func (x *GetOnuCountersResponse) GetBipErrors() uint64 {
	if x != nil {
		if x, ok := x.IsBipErrors.(*GetOnuCountersResponse_BipErrors); ok {
			return x.BipErrors
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsBipUnits() isGetOnuCountersResponse_IsBipUnits {
	if x != nil {
		return x.IsBipUnits
	}
	return nil
}

func (x *GetOnuCountersResponse) GetBipUnits() uint64 {
	if x != nil {
		if x, ok := x.IsBipUnits.(*GetOnuCountersResponse_BipUnits); ok {
			return x.BipUnits
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsFecCorrectedSymbols() isGetOnuCountersResponse_IsFecCorrectedSymbols {
	if x != nil {
		return x.IsFecCorrectedSymbols
	}
	return nil
}

func (x *GetOnuCountersResponse) GetFecCorrectedSymbols() uint64 {
	if x != nil {
		if x, ok := x.IsFecCorrectedSymbols.(*GetOnuCountersResponse_FecCorrectedSymbols); ok {
			return x.FecCorrectedSymbols
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsFecCodewordsCorrected() isGetOnuCountersResponse_IsFecCodewordsCorrected {
	if x != nil {
		return x.IsFecCodewordsCorrected
	}
	return nil
}

func (x *GetOnuCountersResponse) GetFecCodewordsCorrected() uint64 {
	if x != nil {
		if x, ok := x.IsFecCodewordsCorrected.(*GetOnuCountersResponse_FecCodewordsCorrected); ok {
			return x.FecCodewordsCorrected
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsFecCodewordsUncorrectable() isGetOnuCountersResponse_IsFecCodewordsUncorrectable {
	if x != nil {
		return x.IsFecCodewordsUncorrectable
	}
	return nil
}

func (x *GetOnuCountersResponse) GetFecCodewordsUncorrectable() uint64 {
	if x != nil {
		if x, ok := x.IsFecCodewordsUncorrectable.(*GetOnuCountersResponse_FecCodewordsUncorrectable); ok {
			return x.FecCodewordsUncorrectable
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsFecCodewords() isGetOnuCountersResponse_IsFecCodewords {
	if x != nil {
		return x.IsFecCodewords
	}
	return nil
}

func (x *GetOnuCountersResponse) GetFecCodewords() uint64 {
	if x != nil {
		if x, ok := x.IsFecCodewords.(*GetOnuCountersResponse_FecCodewords); ok {
			return x.FecCodewords
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsFecCorrectedUnits() isGetOnuCountersResponse_IsFecCorrectedUnits {
	if x != nil {
		return x.IsFecCorrectedUnits
	}
	return nil
}

func (x *GetOnuCountersResponse) GetFecCorrectedUnits() uint64 {
	if x != nil {
		if x, ok := x.IsFecCorrectedUnits.(*GetOnuCountersResponse_FecCorrectedUnits); ok {
			return x.FecCorrectedUnits
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsXgemKeyErrors() isGetOnuCountersResponse_IsXgemKeyErrors {
	if x != nil {
		return x.IsXgemKeyErrors
	}
	return nil
}

func (x *GetOnuCountersResponse) GetXgemKeyErrors() uint64 {
	if x != nil {
		if x, ok := x.IsXgemKeyErrors.(*GetOnuCountersResponse_XgemKeyErrors); ok {
			return x.XgemKeyErrors
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsXgemLoss() isGetOnuCountersResponse_IsXgemLoss {
	if x != nil {
		return x.IsXgemLoss
	}
	return nil
}

func (x *GetOnuCountersResponse) GetXgemLoss() uint64 {
	if x != nil {
		if x, ok := x.IsXgemLoss.(*GetOnuCountersResponse_XgemLoss); ok {
			return x.XgemLoss
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsRxPloamsError() isGetOnuCountersResponse_IsRxPloamsError {
	if x != nil {
		return x.IsRxPloamsError
	}
	return nil
}

func (x *GetOnuCountersResponse) GetRxPloamsError() uint64 {
	if x != nil {
		if x, ok := x.IsRxPloamsError.(*GetOnuCountersResponse_RxPloamsError); ok {
			return x.RxPloamsError
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsRxPloamsNonIdle() isGetOnuCountersResponse_IsRxPloamsNonIdle {
	if x != nil {
		return x.IsRxPloamsNonIdle
	}
	return nil
}

func (x *GetOnuCountersResponse) GetRxPloamsNonIdle() uint64 {
	if x != nil {
		if x, ok := x.IsRxPloamsNonIdle.(*GetOnuCountersResponse_RxPloamsNonIdle); ok {
			return x.RxPloamsNonIdle
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsRxOmci() isGetOnuCountersResponse_IsRxOmci {
	if x != nil {
		return x.IsRxOmci
	}
	return nil
}

func (x *GetOnuCountersResponse) GetRxOmci() uint64 {
	if x != nil {
		if x, ok := x.IsRxOmci.(*GetOnuCountersResponse_RxOmci); ok {
			return x.RxOmci
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsTxOmci() isGetOnuCountersResponse_IsTxOmci {
	if x != nil {
		return x.IsTxOmci
	}
	return nil
}

func (x *GetOnuCountersResponse) GetTxOmci() uint64 {
	if x != nil {
		if x, ok := x.IsTxOmci.(*GetOnuCountersResponse_TxOmci); ok {
			return x.TxOmci
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsRxOmciPacketsCrcError() isGetOnuCountersResponse_IsRxOmciPacketsCrcError {
	if x != nil {
		return x.IsRxOmciPacketsCrcError
	}
	return nil
}

func (x *GetOnuCountersResponse) GetRxOmciPacketsCrcError() uint64 {
	if x != nil {
		if x, ok := x.IsRxOmciPacketsCrcError.(*GetOnuCountersResponse_RxOmciPacketsCrcError); ok {
			return x.RxOmciPacketsCrcError
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsRxBytes() isGetOnuCountersResponse_IsRxBytes {
	if x != nil {
		return x.IsRxBytes
	}
	return nil
}

func (x *GetOnuCountersResponse) GetRxBytes() uint64 {
	if x != nil {
		if x, ok := x.IsRxBytes.(*GetOnuCountersResponse_RxBytes); ok {
			return x.RxBytes
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsRxPackets() isGetOnuCountersResponse_IsRxPackets {
	if x != nil {
		return x.IsRxPackets
	}
	return nil
}

func (x *GetOnuCountersResponse) GetRxPackets() uint64 {
	if x != nil {
		if x, ok := x.IsRxPackets.(*GetOnuCountersResponse_RxPackets); ok {
			return x.RxPackets
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsTxBytes() isGetOnuCountersResponse_IsTxBytes {
	if x != nil {
		return x.IsTxBytes
	}
	return nil
}

func (x *GetOnuCountersResponse) GetTxBytes() uint64 {
	if x != nil {
		if x, ok := x.IsTxBytes.(*GetOnuCountersResponse_TxBytes); ok {
			return x.TxBytes
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsTxPackets() isGetOnuCountersResponse_IsTxPackets {
	if x != nil {
		return x.IsTxPackets
	}
	return nil
}

func (x *GetOnuCountersResponse) GetTxPackets() uint64 {
	if x != nil {
		if x, ok := x.IsTxPackets.(*GetOnuCountersResponse_TxPackets); ok {
			return x.TxPackets
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsBerReported() isGetOnuCountersResponse_IsBerReported {
	if x != nil {
		return x.IsBerReported
	}
	return nil
}

func (x *GetOnuCountersResponse) GetBerReported() uint64 {
	if x != nil {
		if x, ok := x.IsBerReported.(*GetOnuCountersResponse_BerReported); ok {
			return x.BerReported
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsLcdgErrors() isGetOnuCountersResponse_IsLcdgErrors {
	if x != nil {
		return x.IsLcdgErrors
	}
	return nil
}

func (x *GetOnuCountersResponse) GetLcdgErrors() uint64 {
	if x != nil {
		if x, ok := x.IsLcdgErrors.(*GetOnuCountersResponse_LcdgErrors); ok {
			return x.LcdgErrors
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsRdiErrors() isGetOnuCountersResponse_IsRdiErrors {
	if x != nil {
		return x.IsRdiErrors
	}
	return nil
}

func (x *GetOnuCountersResponse) GetRdiErrors() uint64 {
	if x != nil {
		if x, ok := x.IsRdiErrors.(*GetOnuCountersResponse_RdiErrors); ok {
			return x.RdiErrors
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsTimestamp() isGetOnuCountersResponse_IsTimestamp {
	if x != nil {
		return x.IsTimestamp
	}
	return nil
}

func (x *GetOnuCountersResponse) GetTimestamp() uint32 {
	if x != nil {
		if x, ok := x.IsTimestamp.(*GetOnuCountersResponse_Timestamp); ok {
			return x.Timestamp
		}
	}
	return 0
}

func (x *GetOnuCountersResponse) GetIsHecErrors() isGetOnuCountersResponse_IsHecErrors {
	if x != nil {
		return x.IsHecErrors
	}
	return nil
}

func (x *GetOnuCountersResponse) GetHecErrors() uint64 {
	if x != nil {
		if x, ok := x.IsHecErrors.(*GetOnuCountersResponse_HecErrors); ok {
			return x.HecErrors
		}
	}
	return 0
}

type isGetOnuCountersResponse_IsIntfId interface {
	isGetOnuCountersResponse_IsIntfId()
}

type GetOnuCountersResponse_IntfId struct {
	IntfId uint32 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3,oneof"`
}

func (*GetOnuCountersResponse_IntfId) isGetOnuCountersResponse_IsIntfId() {}

type isGetOnuCountersResponse_IsOnuId interface {
	isGetOnuCountersResponse_IsOnuId()
}

type GetOnuCountersResponse_OnuId struct {
	OnuId uint32 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3,oneof"`
}

func (*GetOnuCountersResponse_OnuId) isGetOnuCountersResponse_IsOnuId() {}

type isGetOnuCountersResponse_IsPositiveDrift interface {
	isGetOnuCountersResponse_IsPositiveDrift()
}

type GetOnuCountersResponse_PositiveDrift struct {
	PositiveDrift uint64 `protobuf:"fixed64,3,opt,name=positive_drift,json=positiveDrift,proto3,oneof"`
}

func (*GetOnuCountersResponse_PositiveDrift) isGetOnuCountersResponse_IsPositiveDrift() {}

type isGetOnuCountersResponse_IsNegativeDrift interface {
	isGetOnuCountersResponse_IsNegativeDrift()
}

type GetOnuCountersResponse_NegativeDrift struct {
	NegativeDrift uint64 `protobuf:"fixed64,4,opt,name=negative_drift,json=negativeDrift,proto3,oneof"`
}

func (*GetOnuCountersResponse_NegativeDrift) isGetOnuCountersResponse_IsNegativeDrift() {}

type isGetOnuCountersResponse_IsDelimiterMissDetection interface {
	isGetOnuCountersResponse_IsDelimiterMissDetection()
}

type GetOnuCountersResponse_DelimiterMissDetection struct {
	DelimiterMissDetection uint64 `protobuf:"fixed64,5,opt,name=delimiter_miss_detection,json=delimiterMissDetection,proto3,oneof"`
}

func (*GetOnuCountersResponse_DelimiterMissDetection) isGetOnuCountersResponse_IsDelimiterMissDetection() {
}

type isGetOnuCountersResponse_IsBipErrors interface {
	isGetOnuCountersResponse_IsBipErrors()
}

type GetOnuCountersResponse_BipErrors struct {
	BipErrors uint64 `protobuf:"fixed64,6,opt,name=bip_errors,json=bipErrors,proto3,oneof"`
}

func (*GetOnuCountersResponse_BipErrors) isGetOnuCountersResponse_IsBipErrors() {}

type isGetOnuCountersResponse_IsBipUnits interface {
	isGetOnuCountersResponse_IsBipUnits()
}

type GetOnuCountersResponse_BipUnits struct {
	BipUnits uint64 `protobuf:"fixed64,7,opt,name=bip_units,json=bipUnits,proto3,oneof"`
}

func (*GetOnuCountersResponse_BipUnits) isGetOnuCountersResponse_IsBipUnits() {}

type isGetOnuCountersResponse_IsFecCorrectedSymbols interface {
	isGetOnuCountersResponse_IsFecCorrectedSymbols()
}

type GetOnuCountersResponse_FecCorrectedSymbols struct {
	FecCorrectedSymbols uint64 `protobuf:"fixed64,8,opt,name=fec_corrected_symbols,json=fecCorrectedSymbols,proto3,oneof"`
}

func (*GetOnuCountersResponse_FecCorrectedSymbols) isGetOnuCountersResponse_IsFecCorrectedSymbols() {}

type isGetOnuCountersResponse_IsFecCodewordsCorrected interface {
	isGetOnuCountersResponse_IsFecCodewordsCorrected()
}

type GetOnuCountersResponse_FecCodewordsCorrected struct {
	FecCodewordsCorrected uint64 `protobuf:"fixed64,9,opt,name=fec_codewords_corrected,json=fecCodewordsCorrected,proto3,oneof"`
}

func (*GetOnuCountersResponse_FecCodewordsCorrected) isGetOnuCountersResponse_IsFecCodewordsCorrected() {
}

type isGetOnuCountersResponse_IsFecCodewordsUncorrectable interface {
	isGetOnuCountersResponse_IsFecCodewordsUncorrectable()
}

type GetOnuCountersResponse_FecCodewordsUncorrectable struct {
	FecCodewordsUncorrectable uint64 `protobuf:"fixed64,10,opt,name=fec_codewords_uncorrectable,json=fecCodewordsUncorrectable,proto3,oneof"`
}

func (*GetOnuCountersResponse_FecCodewordsUncorrectable) isGetOnuCountersResponse_IsFecCodewordsUncorrectable() {
}

type isGetOnuCountersResponse_IsFecCodewords interface {
	isGetOnuCountersResponse_IsFecCodewords()
}

type GetOnuCountersResponse_FecCodewords struct {
	FecCodewords uint64 `protobuf:"fixed64,11,opt,name=fec_codewords,json=fecCodewords,proto3,oneof"`
}

func (*GetOnuCountersResponse_FecCodewords) isGetOnuCountersResponse_IsFecCodewords() {}

type isGetOnuCountersResponse_IsFecCorrectedUnits interface {
	isGetOnuCountersResponse_IsFecCorrectedUnits()
}

type GetOnuCountersResponse_FecCorrectedUnits struct {
	FecCorrectedUnits uint64 `protobuf:"fixed64,12,opt,name=fec_corrected_units,json=fecCorrectedUnits,proto3,oneof"`
}

func (*GetOnuCountersResponse_FecCorrectedUnits) isGetOnuCountersResponse_IsFecCorrectedUnits() {}

type isGetOnuCountersResponse_IsXgemKeyErrors interface {
	isGetOnuCountersResponse_IsXgemKeyErrors()
}

type GetOnuCountersResponse_XgemKeyErrors struct {
	XgemKeyErrors uint64 `protobuf:"fixed64,13,opt,name=xgem_key_errors,json=xgemKeyErrors,proto3,oneof"`
}

func (*GetOnuCountersResponse_XgemKeyErrors) isGetOnuCountersResponse_IsXgemKeyErrors() {}

type isGetOnuCountersResponse_IsXgemLoss interface {
	isGetOnuCountersResponse_IsXgemLoss()
}

type GetOnuCountersResponse_XgemLoss struct {
	XgemLoss uint64 `protobuf:"fixed64,14,opt,name=xgem_loss,json=xgemLoss,proto3,oneof"`
}

func (*GetOnuCountersResponse_XgemLoss) isGetOnuCountersResponse_IsXgemLoss() {}

type isGetOnuCountersResponse_IsRxPloamsError interface {
	isGetOnuCountersResponse_IsRxPloamsError()
}

type GetOnuCountersResponse_RxPloamsError struct {
	RxPloamsError uint64 `protobuf:"fixed64,15,opt,name=rx_ploams_error,json=rxPloamsError,proto3,oneof"`
}

func (*GetOnuCountersResponse_RxPloamsError) isGetOnuCountersResponse_IsRxPloamsError() {}

type isGetOnuCountersResponse_IsRxPloamsNonIdle interface {
	isGetOnuCountersResponse_IsRxPloamsNonIdle()
}

type GetOnuCountersResponse_RxPloamsNonIdle struct {
	RxPloamsNonIdle uint64 `protobuf:"fixed64,16,opt,name=rx_ploams_non_idle,json=rxPloamsNonIdle,proto3,oneof"`
}

func (*GetOnuCountersResponse_RxPloamsNonIdle) isGetOnuCountersResponse_IsRxPloamsNonIdle() {}

type isGetOnuCountersResponse_IsRxOmci interface {
	isGetOnuCountersResponse_IsRxOmci()
}

type GetOnuCountersResponse_RxOmci struct {
	RxOmci uint64 `protobuf:"fixed64,17,opt,name=rx_omci,json=rxOmci,proto3,oneof"`
}

func (*GetOnuCountersResponse_RxOmci) isGetOnuCountersResponse_IsRxOmci() {}

type isGetOnuCountersResponse_IsTxOmci interface {
	isGetOnuCountersResponse_IsTxOmci()
}

type GetOnuCountersResponse_TxOmci struct {
	TxOmci uint64 `protobuf:"fixed64,18,opt,name=tx_omci,json=txOmci,proto3,oneof"`
}

func (*GetOnuCountersResponse_TxOmci) isGetOnuCountersResponse_IsTxOmci() {}

type isGetOnuCountersResponse_IsRxOmciPacketsCrcError interface {
	isGetOnuCountersResponse_IsRxOmciPacketsCrcError()
}

type GetOnuCountersResponse_RxOmciPacketsCrcError struct {
	RxOmciPacketsCrcError uint64 `protobuf:"fixed64,19,opt,name=rx_omci_packets_crc_error,json=rxOmciPacketsCrcError,proto3,oneof"`
}

func (*GetOnuCountersResponse_RxOmciPacketsCrcError) isGetOnuCountersResponse_IsRxOmciPacketsCrcError() {
}

type isGetOnuCountersResponse_IsRxBytes interface {
	isGetOnuCountersResponse_IsRxBytes()
}

type GetOnuCountersResponse_RxBytes struct {
	RxBytes uint64 `protobuf:"fixed64,20,opt,name=rx_bytes,json=rxBytes,proto3,oneof"`
}

func (*GetOnuCountersResponse_RxBytes) isGetOnuCountersResponse_IsRxBytes() {}

type isGetOnuCountersResponse_IsRxPackets interface {
	isGetOnuCountersResponse_IsRxPackets()
}

type GetOnuCountersResponse_RxPackets struct {
	RxPackets uint64 `protobuf:"fixed64,21,opt,name=rx_packets,json=rxPackets,proto3,oneof"`
}

func (*GetOnuCountersResponse_RxPackets) isGetOnuCountersResponse_IsRxPackets() {}

type isGetOnuCountersResponse_IsTxBytes interface {
	isGetOnuCountersResponse_IsTxBytes()
}

type GetOnuCountersResponse_TxBytes struct {
	TxBytes uint64 `protobuf:"fixed64,22,opt,name=tx_bytes,json=txBytes,proto3,oneof"`
}

func (*GetOnuCountersResponse_TxBytes) isGetOnuCountersResponse_IsTxBytes() {}

type isGetOnuCountersResponse_IsTxPackets interface {
	isGetOnuCountersResponse_IsTxPackets()
}

type GetOnuCountersResponse_TxPackets struct {
	TxPackets uint64 `protobuf:"fixed64,23,opt,name=tx_packets,json=txPackets,proto3,oneof"`
}

func (*GetOnuCountersResponse_TxPackets) isGetOnuCountersResponse_IsTxPackets() {}

type isGetOnuCountersResponse_IsBerReported interface {
	isGetOnuCountersResponse_IsBerReported()
}

type GetOnuCountersResponse_BerReported struct {
	BerReported uint64 `protobuf:"fixed64,24,opt,name=ber_reported,json=berReported,proto3,oneof"`
}

func (*GetOnuCountersResponse_BerReported) isGetOnuCountersResponse_IsBerReported() {}

type isGetOnuCountersResponse_IsLcdgErrors interface {
	isGetOnuCountersResponse_IsLcdgErrors()
}

type GetOnuCountersResponse_LcdgErrors struct {
	LcdgErrors uint64 `protobuf:"fixed64,25,opt,name=lcdg_errors,json=lcdgErrors,proto3,oneof"`
}

func (*GetOnuCountersResponse_LcdgErrors) isGetOnuCountersResponse_IsLcdgErrors() {}

type isGetOnuCountersResponse_IsRdiErrors interface {
	isGetOnuCountersResponse_IsRdiErrors()
}

type GetOnuCountersResponse_RdiErrors struct {
	RdiErrors uint64 `protobuf:"fixed64,26,opt,name=rdi_errors,json=rdiErrors,proto3,oneof"`
}

func (*GetOnuCountersResponse_RdiErrors) isGetOnuCountersResponse_IsRdiErrors() {}

type isGetOnuCountersResponse_IsTimestamp interface {
	isGetOnuCountersResponse_IsTimestamp()
}

type GetOnuCountersResponse_Timestamp struct {
	// reported timestamp in seconds since epoch
	Timestamp uint32 `protobuf:"fixed32,27,opt,name=timestamp,proto3,oneof"`
}

func (*GetOnuCountersResponse_Timestamp) isGetOnuCountersResponse_IsTimestamp() {}

type isGetOnuCountersResponse_IsHecErrors interface {
	isGetOnuCountersResponse_IsHecErrors()
}

type GetOnuCountersResponse_HecErrors struct {
	HecErrors uint64 `protobuf:"fixed64,28,opt,name=hec_errors,json=hecErrors,proto3,oneof"`
}

func (*GetOnuCountersResponse_HecErrors) isGetOnuCountersResponse_IsHecErrors() {}

type OmciEthernetFrameExtendedPm struct {
	state                    protoimpl.MessageState `protogen:"open.v1"`
	DropEvents               uint64                 `protobuf:"fixed64,1,opt,name=drop_events,json=dropEvents,proto3" json:"drop_events,omitempty"`
	Octets                   uint64                 `protobuf:"fixed64,2,opt,name=octets,proto3" json:"octets,omitempty"`
	Frames                   uint64                 `protobuf:"fixed64,3,opt,name=frames,proto3" json:"frames,omitempty"`
	BroadcastFrames          uint64                 `protobuf:"fixed64,4,opt,name=broadcast_frames,json=broadcastFrames,proto3" json:"broadcast_frames,omitempty"`
	MulticastFrames          uint64                 `protobuf:"fixed64,5,opt,name=multicast_frames,json=multicastFrames,proto3" json:"multicast_frames,omitempty"`
	CrcErroredFrames         uint64                 `protobuf:"fixed64,6,opt,name=crc_errored_frames,json=crcErroredFrames,proto3" json:"crc_errored_frames,omitempty"`
	UndersizeFrames          uint64                 `protobuf:"fixed64,7,opt,name=undersize_frames,json=undersizeFrames,proto3" json:"undersize_frames,omitempty"`
	OversizeFrames           uint64                 `protobuf:"fixed64,8,opt,name=oversize_frames,json=oversizeFrames,proto3" json:"oversize_frames,omitempty"`
	Frames_64Octets          uint64                 `protobuf:"fixed64,9,opt,name=frames_64_octets,json=frames64Octets,proto3" json:"frames_64_octets,omitempty"`
	Frames_65To_127Octets    uint64                 `protobuf:"fixed64,10,opt,name=frames_65_to_127_octets,json=frames65To127Octets,proto3" json:"frames_65_to_127_octets,omitempty"`
	Frames_128To_255Octets   uint64                 `protobuf:"fixed64,11,opt,name=frames_128_to_255_octets,json=frames128To255Octets,proto3" json:"frames_128_to_255_octets,omitempty"`
	Frames_256To_511Octets   uint64                 `protobuf:"fixed64,12,opt,name=frames_256_to_511_octets,json=frames256To511Octets,proto3" json:"frames_256_to_511_octets,omitempty"`
	Frames_512To_1023Octets  uint64                 `protobuf:"fixed64,13,opt,name=frames_512_to_1023_octets,json=frames512To1023Octets,proto3" json:"frames_512_to_1023_octets,omitempty"`
	Frames_1024To_1518Octets uint64                 `protobuf:"fixed64,14,opt,name=frames_1024_to_1518_octets,json=frames1024To1518Octets,proto3" json:"frames_1024_to_1518_octets,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *OmciEthernetFrameExtendedPm) Reset() {
	*x = OmciEthernetFrameExtendedPm{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OmciEthernetFrameExtendedPm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OmciEthernetFrameExtendedPm) ProtoMessage() {}

func (x *OmciEthernetFrameExtendedPm) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OmciEthernetFrameExtendedPm.ProtoReflect.Descriptor instead.
func (*OmciEthernetFrameExtendedPm) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{35}
}

func (x *OmciEthernetFrameExtendedPm) GetDropEvents() uint64 {
	if x != nil {
		return x.DropEvents
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetOctets() uint64 {
	if x != nil {
		return x.Octets
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetFrames() uint64 {
	if x != nil {
		return x.Frames
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetBroadcastFrames() uint64 {
	if x != nil {
		return x.BroadcastFrames
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetMulticastFrames() uint64 {
	if x != nil {
		return x.MulticastFrames
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetCrcErroredFrames() uint64 {
	if x != nil {
		return x.CrcErroredFrames
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetUndersizeFrames() uint64 {
	if x != nil {
		return x.UndersizeFrames
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetOversizeFrames() uint64 {
	if x != nil {
		return x.OversizeFrames
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetFrames_64Octets() uint64 {
	if x != nil {
		return x.Frames_64Octets
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetFrames_65To_127Octets() uint64 {
	if x != nil {
		return x.Frames_65To_127Octets
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetFrames_128To_255Octets() uint64 {
	if x != nil {
		return x.Frames_128To_255Octets
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetFrames_256To_511Octets() uint64 {
	if x != nil {
		return x.Frames_256To_511Octets
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetFrames_512To_1023Octets() uint64 {
	if x != nil {
		return x.Frames_512To_1023Octets
	}
	return 0
}

func (x *OmciEthernetFrameExtendedPm) GetFrames_1024To_1518Octets() uint64 {
	if x != nil {
		return x.Frames_1024To_1518Octets
	}
	return 0
}

type GetOmciEthernetFrameExtendedPmResponse struct {
	state                             protoimpl.MessageState                        `protogen:"open.v1"`
	Upstream                          *OmciEthernetFrameExtendedPm                  `protobuf:"bytes,1,opt,name=upstream,proto3" json:"upstream,omitempty"`
	Downstream                        *OmciEthernetFrameExtendedPm                  `protobuf:"bytes,2,opt,name=downstream,proto3" json:"downstream,omitempty"`
	OmciEthernetFrameExtendedPmFormat GetOmciEthernetFrameExtendedPmResponse_Format `protobuf:"varint,3,opt,name=omci_ethernet_frame_extended_pm_format,json=omciEthernetFrameExtendedPmFormat,proto3,enum=extension.GetOmciEthernetFrameExtendedPmResponse_Format" json:"omci_ethernet_frame_extended_pm_format,omitempty"`
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *GetOmciEthernetFrameExtendedPmResponse) Reset() {
	*x = GetOmciEthernetFrameExtendedPmResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOmciEthernetFrameExtendedPmResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOmciEthernetFrameExtendedPmResponse) ProtoMessage() {}

func (x *GetOmciEthernetFrameExtendedPmResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOmciEthernetFrameExtendedPmResponse.ProtoReflect.Descriptor instead.
func (*GetOmciEthernetFrameExtendedPmResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{36}
}

func (x *GetOmciEthernetFrameExtendedPmResponse) GetUpstream() *OmciEthernetFrameExtendedPm {
	if x != nil {
		return x.Upstream
	}
	return nil
}

func (x *GetOmciEthernetFrameExtendedPmResponse) GetDownstream() *OmciEthernetFrameExtendedPm {
	if x != nil {
		return x.Downstream
	}
	return nil
}

func (x *GetOmciEthernetFrameExtendedPmResponse) GetOmciEthernetFrameExtendedPmFormat() GetOmciEthernetFrameExtendedPmResponse_Format {
	if x != nil {
		return x.OmciEthernetFrameExtendedPmFormat
	}
	return GetOmciEthernetFrameExtendedPmResponse_THIRTY_TWO_BIT
}

type RxPower struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OnuSn         string                 `protobuf:"bytes,1,opt,name=onu_sn,json=onuSn,proto3" json:"onu_sn,omitempty"` // if the port on which RxPower is measured is not a PON port this will be empty ("") string
	Status        string                 `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	FailReason    string                 `protobuf:"bytes,3,opt,name=fail_reason,json=failReason,proto3" json:"fail_reason,omitempty"`
	RxPower       float64                `protobuf:"fixed64,4,opt,name=rx_power,json=rxPower,proto3" json:"rx_power,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RxPower) Reset() {
	*x = RxPower{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RxPower) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RxPower) ProtoMessage() {}

func (x *RxPower) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RxPower.ProtoReflect.Descriptor instead.
func (*RxPower) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{37}
}

func (x *RxPower) GetOnuSn() string {
	if x != nil {
		return x.OnuSn
	}
	return ""
}

func (x *RxPower) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *RxPower) GetFailReason() string {
	if x != nil {
		return x.FailReason
	}
	return ""
}

func (x *RxPower) GetRxPower() float64 {
	if x != nil {
		return x.RxPower
	}
	return 0
}

type GetOltRxPowerResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PortLabel     string                 `protobuf:"bytes,1,opt,name=port_label,json=portLabel,proto3" json:"port_label,omitempty"`
	RxPower       []*RxPower             `protobuf:"bytes,2,rep,name=rx_power,json=rxPower,proto3" json:"rx_power,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOltRxPowerResponse) Reset() {
	*x = GetOltRxPowerResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOltRxPowerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOltRxPowerResponse) ProtoMessage() {}

func (x *GetOltRxPowerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOltRxPowerResponse.ProtoReflect.Descriptor instead.
func (*GetOltRxPowerResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{38}
}

func (x *GetOltRxPowerResponse) GetPortLabel() string {
	if x != nil {
		return x.PortLabel
	}
	return ""
}

func (x *GetOltRxPowerResponse) GetRxPower() []*RxPower {
	if x != nil {
		return x.RxPower
	}
	return nil
}

// DEPRECATED
type GetRxPowerResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IntfId        uint32                 `protobuf:"fixed32,1,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	OnuId         uint32                 `protobuf:"fixed32,2,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	Status        string                 `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	FailReason    string                 `protobuf:"bytes,4,opt,name=fail_reason,json=failReason,proto3" json:"fail_reason,omitempty"`
	RxPower       float64                `protobuf:"fixed64,5,opt,name=rx_power,json=rxPower,proto3" json:"rx_power,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetRxPowerResponse) Reset() {
	*x = GetRxPowerResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRxPowerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRxPowerResponse) ProtoMessage() {}

func (x *GetRxPowerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRxPowerResponse.ProtoReflect.Descriptor instead.
func (*GetRxPowerResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{39}
}

func (x *GetRxPowerResponse) GetIntfId() uint32 {
	if x != nil {
		return x.IntfId
	}
	return 0
}

func (x *GetRxPowerResponse) GetOnuId() uint32 {
	if x != nil {
		return x.OnuId
	}
	return 0
}

func (x *GetRxPowerResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *GetRxPowerResponse) GetFailReason() string {
	if x != nil {
		return x.FailReason
	}
	return ""
}

func (x *GetRxPowerResponse) GetRxPower() float64 {
	if x != nil {
		return x.RxPower
	}
	return 0
}

type GetOnuOmciTxRxStatsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Empty         *emptypb.Empty         `protobuf:"bytes,1,opt,name=empty,proto3" json:"empty,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuOmciTxRxStatsRequest) Reset() {
	*x = GetOnuOmciTxRxStatsRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuOmciTxRxStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuOmciTxRxStatsRequest) ProtoMessage() {}

func (x *GetOnuOmciTxRxStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuOmciTxRxStatsRequest.ProtoReflect.Descriptor instead.
func (*GetOnuOmciTxRxStatsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{40}
}

func (x *GetOnuOmciTxRxStatsRequest) GetEmpty() *emptypb.Empty {
	if x != nil {
		return x.Empty
	}
	return nil
}

// see ITU-T G.988 clause 11.2.2
type GetOnuOmciTxRxStatsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// OMCI baseline Tx frames with AR bit set
	BaseTxArFrames uint32 `protobuf:"varint,1,opt,name=base_tx_ar_frames,json=baseTxArFrames,proto3" json:"base_tx_ar_frames,omitempty"`
	// OMCI baseline Rx frames with AK bit set
	BaseRxAkFrames uint32 `protobuf:"varint,2,opt,name=base_rx_ak_frames,json=baseRxAkFrames,proto3" json:"base_rx_ak_frames,omitempty"`
	// OMCI baseline Tx frames with AR bit unset
	BaseTxNoArFrames uint32 `protobuf:"varint,3,opt,name=base_tx_no_ar_frames,json=baseTxNoArFrames,proto3" json:"base_tx_no_ar_frames,omitempty"`
	// OMCI baseline Rx frames with AK bit unset
	BaseRxNoAkFrames uint32 `protobuf:"varint,4,opt,name=base_rx_no_ak_frames,json=baseRxNoAkFrames,proto3" json:"base_rx_no_ak_frames,omitempty"`
	// OMCI extended Tx frames with AR bit set
	ExtTxArFrames uint32 `protobuf:"varint,5,opt,name=ext_tx_ar_frames,json=extTxArFrames,proto3" json:"ext_tx_ar_frames,omitempty"`
	// OMCI extended Rx frames with AK bit set
	ExtRxAkFrames uint32 `protobuf:"varint,6,opt,name=ext_rx_ak_frames,json=extRxAkFrames,proto3" json:"ext_rx_ak_frames,omitempty"`
	// OMCI extended Tx frames with AR bit unset
	ExtTxNoArFrames uint32 `protobuf:"varint,7,opt,name=ext_tx_no_ar_frames,json=extTxNoArFrames,proto3" json:"ext_tx_no_ar_frames,omitempty"`
	// OMCI extended Rx frames with AK bit unset
	ExtRxNoAkFrames uint32 `protobuf:"varint,8,opt,name=ext_rx_no_ak_frames,json=extRxNoAkFrames,proto3" json:"ext_rx_no_ak_frames,omitempty"`
	// Number of retries of requests (tx) due to not received responses (Rx)
	TxOmciCounterRetries uint32 `protobuf:"varint,9,opt,name=tx_omci_counter_retries,json=txOmciCounterRetries,proto3" json:"tx_omci_counter_retries,omitempty"`
	// Number of timeouts of requests (tx) due to not received responses (Rx) after configured number of retries
	TxOmciCounterTimeouts uint32 `protobuf:"varint,10,opt,name=tx_omci_counter_timeouts,json=txOmciCounterTimeouts,proto3" json:"tx_omci_counter_timeouts,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetOnuOmciTxRxStatsResponse) Reset() {
	*x = GetOnuOmciTxRxStatsResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuOmciTxRxStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuOmciTxRxStatsResponse) ProtoMessage() {}

func (x *GetOnuOmciTxRxStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuOmciTxRxStatsResponse.ProtoReflect.Descriptor instead.
func (*GetOnuOmciTxRxStatsResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{41}
}

func (x *GetOnuOmciTxRxStatsResponse) GetBaseTxArFrames() uint32 {
	if x != nil {
		return x.BaseTxArFrames
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetBaseRxAkFrames() uint32 {
	if x != nil {
		return x.BaseRxAkFrames
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetBaseTxNoArFrames() uint32 {
	if x != nil {
		return x.BaseTxNoArFrames
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetBaseRxNoAkFrames() uint32 {
	if x != nil {
		return x.BaseRxNoAkFrames
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetExtTxArFrames() uint32 {
	if x != nil {
		return x.ExtTxArFrames
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetExtRxAkFrames() uint32 {
	if x != nil {
		return x.ExtRxAkFrames
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetExtTxNoArFrames() uint32 {
	if x != nil {
		return x.ExtTxNoArFrames
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetExtRxNoAkFrames() uint32 {
	if x != nil {
		return x.ExtRxNoAkFrames
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetTxOmciCounterRetries() uint32 {
	if x != nil {
		return x.TxOmciCounterRetries
	}
	return 0
}

func (x *GetOnuOmciTxRxStatsResponse) GetTxOmciCounterTimeouts() uint32 {
	if x != nil {
		return x.TxOmciCounterTimeouts
	}
	return 0
}

type GetOnuOmciActiveAlarmsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Empty         *emptypb.Empty         `protobuf:"bytes,1,opt,name=empty,proto3" json:"empty,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuOmciActiveAlarmsRequest) Reset() {
	*x = GetOnuOmciActiveAlarmsRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuOmciActiveAlarmsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuOmciActiveAlarmsRequest) ProtoMessage() {}

func (x *GetOnuOmciActiveAlarmsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuOmciActiveAlarmsRequest.ProtoReflect.Descriptor instead.
func (*GetOnuOmciActiveAlarmsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{42}
}

func (x *GetOnuOmciActiveAlarmsRequest) GetEmpty() *emptypb.Empty {
	if x != nil {
		return x.Empty
	}
	return nil
}

type AlarmData struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ClassId       uint32                 `protobuf:"varint,1,opt,name=class_id,json=classId,proto3" json:"class_id,omitempty"`
	InstanceId    uint32                 `protobuf:"varint,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	Name          string                 `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Description   string                 `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AlarmData) Reset() {
	*x = AlarmData{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AlarmData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlarmData) ProtoMessage() {}

func (x *AlarmData) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlarmData.ProtoReflect.Descriptor instead.
func (*AlarmData) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{43}
}

func (x *AlarmData) GetClassId() uint32 {
	if x != nil {
		return x.ClassId
	}
	return 0
}

func (x *AlarmData) GetInstanceId() uint32 {
	if x != nil {
		return x.InstanceId
	}
	return 0
}

func (x *AlarmData) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AlarmData) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

type GetOnuOmciActiveAlarmsResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ActiveAlarms  []*AlarmData           `protobuf:"bytes,1,rep,name=active_alarms,json=activeAlarms,proto3" json:"active_alarms,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOnuOmciActiveAlarmsResponse) Reset() {
	*x = GetOnuOmciActiveAlarmsResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnuOmciActiveAlarmsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnuOmciActiveAlarmsResponse) ProtoMessage() {}

func (x *GetOnuOmciActiveAlarmsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnuOmciActiveAlarmsResponse.ProtoReflect.Descriptor instead.
func (*GetOnuOmciActiveAlarmsResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{44}
}

func (x *GetOnuOmciActiveAlarmsResponse) GetActiveAlarms() []*AlarmData {
	if x != nil {
		return x.ActiveAlarms
	}
	return nil
}

type GetOffloadedAppsStatisticsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The offloaded application whose statistics are requested
	StatsFor      GetOffloadedAppsStatisticsRequest_OffloadedApp `protobuf:"varint,1,opt,name=statsFor,proto3,enum=extension.GetOffloadedAppsStatisticsRequest_OffloadedApp" json:"statsFor,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOffloadedAppsStatisticsRequest) Reset() {
	*x = GetOffloadedAppsStatisticsRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOffloadedAppsStatisticsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOffloadedAppsStatisticsRequest) ProtoMessage() {}

func (x *GetOffloadedAppsStatisticsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOffloadedAppsStatisticsRequest.ProtoReflect.Descriptor instead.
func (*GetOffloadedAppsStatisticsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{45}
}

func (x *GetOffloadedAppsStatisticsRequest) GetStatsFor() GetOffloadedAppsStatisticsRequest_OffloadedApp {
	if x != nil {
		return x.StatsFor
	}
	return GetOffloadedAppsStatisticsRequest_UNDEFINED
}

type GetOffloadedAppsStatisticsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Stats:
	//
	//	*GetOffloadedAppsStatisticsResponse_Dhcpv4RaStats
	//	*GetOffloadedAppsStatisticsResponse_Dhcpv6RaStats
	//	*GetOffloadedAppsStatisticsResponse_PppoeIaStats
	Stats         isGetOffloadedAppsStatisticsResponse_Stats `protobuf_oneof:"stats"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOffloadedAppsStatisticsResponse) Reset() {
	*x = GetOffloadedAppsStatisticsResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOffloadedAppsStatisticsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOffloadedAppsStatisticsResponse) ProtoMessage() {}

func (x *GetOffloadedAppsStatisticsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOffloadedAppsStatisticsResponse.ProtoReflect.Descriptor instead.
func (*GetOffloadedAppsStatisticsResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{46}
}

func (x *GetOffloadedAppsStatisticsResponse) GetStats() isGetOffloadedAppsStatisticsResponse_Stats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *GetOffloadedAppsStatisticsResponse) GetDhcpv4RaStats() *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats {
	if x != nil {
		if x, ok := x.Stats.(*GetOffloadedAppsStatisticsResponse_Dhcpv4RaStats); ok {
			return x.Dhcpv4RaStats
		}
	}
	return nil
}

func (x *GetOffloadedAppsStatisticsResponse) GetDhcpv6RaStats() *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats {
	if x != nil {
		if x, ok := x.Stats.(*GetOffloadedAppsStatisticsResponse_Dhcpv6RaStats); ok {
			return x.Dhcpv6RaStats
		}
	}
	return nil
}

func (x *GetOffloadedAppsStatisticsResponse) GetPppoeIaStats() *GetOffloadedAppsStatisticsResponse_PPPoeIAStats {
	if x != nil {
		if x, ok := x.Stats.(*GetOffloadedAppsStatisticsResponse_PppoeIaStats); ok {
			return x.PppoeIaStats
		}
	}
	return nil
}

type isGetOffloadedAppsStatisticsResponse_Stats interface {
	isGetOffloadedAppsStatisticsResponse_Stats()
}

type GetOffloadedAppsStatisticsResponse_Dhcpv4RaStats struct {
	Dhcpv4RaStats *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats `protobuf:"bytes,1,opt,name=dhcpv4RaStats,proto3,oneof"`
}

type GetOffloadedAppsStatisticsResponse_Dhcpv6RaStats struct {
	Dhcpv6RaStats *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats `protobuf:"bytes,2,opt,name=dhcpv6RaStats,proto3,oneof"`
}

type GetOffloadedAppsStatisticsResponse_PppoeIaStats struct {
	PppoeIaStats *GetOffloadedAppsStatisticsResponse_PPPoeIAStats `protobuf:"bytes,3,opt,name=pppoeIaStats,proto3,oneof"`
}

func (*GetOffloadedAppsStatisticsResponse_Dhcpv4RaStats) isGetOffloadedAppsStatisticsResponse_Stats() {
}

func (*GetOffloadedAppsStatisticsResponse_Dhcpv6RaStats) isGetOffloadedAppsStatisticsResponse_Stats() {
}

func (*GetOffloadedAppsStatisticsResponse_PppoeIaStats) isGetOffloadedAppsStatisticsResponse_Stats() {
}

type GetValueRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Request:
	//
	//	*GetValueRequest_Distance
	//	*GetValueRequest_UniInfo
	//	*GetValueRequest_OltPortInfo
	//	*GetValueRequest_OnuOpticalInfo
	//	*GetValueRequest_EthBridgePort
	//	*GetValueRequest_FecHistory
	//	*GetValueRequest_OnuPonInfo
	//	*GetValueRequest_OnuInfo
	//	*GetValueRequest_RxPower
	//	*GetValueRequest_OnuOmciStats
	//	*GetValueRequest_OltRxPower
	//	*GetValueRequest_OnuActiveAlarms
	//	*GetValueRequest_OffloadedAppsStats
	//	*GetValueRequest_OnuAllocGemStats
	//	*GetValueRequest_OnuStatsFromOlt
	//	*GetValueRequest_OltPonStats
	//	*GetValueRequest_OltNniStats
	Request       isGetValueRequest_Request `protobuf_oneof:"request"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetValueRequest) Reset() {
	*x = GetValueRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetValueRequest) ProtoMessage() {}

func (x *GetValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetValueRequest.ProtoReflect.Descriptor instead.
func (*GetValueRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{47}
}

func (x *GetValueRequest) GetRequest() isGetValueRequest_Request {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *GetValueRequest) GetDistance() *GetDistanceRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_Distance); ok {
			return x.Distance
		}
	}
	return nil
}

func (x *GetValueRequest) GetUniInfo() *GetOnuUniInfoRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_UniInfo); ok {
			return x.UniInfo
		}
	}
	return nil
}

func (x *GetValueRequest) GetOltPortInfo() *GetOltPortCounters {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OltPortInfo); ok {
			return x.OltPortInfo
		}
	}
	return nil
}

func (x *GetValueRequest) GetOnuOpticalInfo() *GetOnuPonOpticalInfo {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OnuOpticalInfo); ok {
			return x.OnuOpticalInfo
		}
	}
	return nil
}

func (x *GetValueRequest) GetEthBridgePort() *GetOnuEthernetBridgePortHistory {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_EthBridgePort); ok {
			return x.EthBridgePort
		}
	}
	return nil
}

func (x *GetValueRequest) GetFecHistory() *GetOnuFecHistory {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_FecHistory); ok {
			return x.FecHistory
		}
	}
	return nil
}

func (x *GetValueRequest) GetOnuPonInfo() *GetOnuCountersRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OnuPonInfo); ok {
			return x.OnuPonInfo
		}
	}
	return nil
}

func (x *GetValueRequest) GetOnuInfo() *GetOmciEthernetFrameExtendedPmRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OnuInfo); ok {
			return x.OnuInfo
		}
	}
	return nil
}

func (x *GetValueRequest) GetRxPower() *GetRxPowerRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_RxPower); ok {
			return x.RxPower
		}
	}
	return nil
}

func (x *GetValueRequest) GetOnuOmciStats() *GetOnuOmciTxRxStatsRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OnuOmciStats); ok {
			return x.OnuOmciStats
		}
	}
	return nil
}

func (x *GetValueRequest) GetOltRxPower() *GetOltRxPowerRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OltRxPower); ok {
			return x.OltRxPower
		}
	}
	return nil
}

func (x *GetValueRequest) GetOnuActiveAlarms() *GetOnuOmciActiveAlarmsRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OnuActiveAlarms); ok {
			return x.OnuActiveAlarms
		}
	}
	return nil
}

func (x *GetValueRequest) GetOffloadedAppsStats() *GetOffloadedAppsStatisticsRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OffloadedAppsStats); ok {
			return x.OffloadedAppsStats
		}
	}
	return nil
}

func (x *GetValueRequest) GetOnuAllocGemStats() *GetOnuAllocGemHistoryRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OnuAllocGemStats); ok {
			return x.OnuAllocGemStats
		}
	}
	return nil
}

func (x *GetValueRequest) GetOnuStatsFromOlt() *GetOnuStatsFromOltRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OnuStatsFromOlt); ok {
			return x.OnuStatsFromOlt
		}
	}
	return nil
}

func (x *GetValueRequest) GetOltPonStats() *GetPonStatsRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OltPonStats); ok {
			return x.OltPonStats
		}
	}
	return nil
}

func (x *GetValueRequest) GetOltNniStats() *GetNNIStatsRequest {
	if x != nil {
		if x, ok := x.Request.(*GetValueRequest_OltNniStats); ok {
			return x.OltNniStats
		}
	}
	return nil
}

type isGetValueRequest_Request interface {
	isGetValueRequest_Request()
}

type GetValueRequest_Distance struct {
	Distance *GetDistanceRequest `protobuf:"bytes,1,opt,name=distance,proto3,oneof"`
}

type GetValueRequest_UniInfo struct {
	UniInfo *GetOnuUniInfoRequest `protobuf:"bytes,2,opt,name=uniInfo,proto3,oneof"`
}

type GetValueRequest_OltPortInfo struct {
	// Corresponds to PmMetricId.PON_PORT_COUNTERS, PmMetricId.NNI_PORT_COUNTERS
	OltPortInfo *GetOltPortCounters `protobuf:"bytes,3,opt,name=oltPortInfo,proto3,oneof"`
}

type GetValueRequest_OnuOpticalInfo struct {
	// Corresponds to PmMetricId.PON_OPTICAL
	OnuOpticalInfo *GetOnuPonOpticalInfo `protobuf:"bytes,4,opt,name=onuOpticalInfo,proto3,oneof"`
}

type GetValueRequest_EthBridgePort struct {
	// Corresponds to PmMetricId.ETHERNET_BRIDGE_PORT_HISTORY
	EthBridgePort *GetOnuEthernetBridgePortHistory `protobuf:"bytes,5,opt,name=ethBridgePort,proto3,oneof"`
}

type GetValueRequest_FecHistory struct {
	// Corresponds to PmMetricId.FEC_HISTORY
	FecHistory *GetOnuFecHistory `protobuf:"bytes,6,opt,name=fecHistory,proto3,oneof"`
}

type GetValueRequest_OnuPonInfo struct {
	OnuPonInfo *GetOnuCountersRequest `protobuf:"bytes,7,opt,name=onuPonInfo,proto3,oneof"`
}

type GetValueRequest_OnuInfo struct {
	OnuInfo *GetOmciEthernetFrameExtendedPmRequest `protobuf:"bytes,8,opt,name=onuInfo,proto3,oneof"`
}

type GetValueRequest_RxPower struct {
	RxPower *GetRxPowerRequest `protobuf:"bytes,9,opt,name=rxPower,proto3,oneof"` // This is deprecated
}

type GetValueRequest_OnuOmciStats struct {
	OnuOmciStats *GetOnuOmciTxRxStatsRequest `protobuf:"bytes,10,opt,name=onuOmciStats,proto3,oneof"`
}

type GetValueRequest_OltRxPower struct {
	OltRxPower *GetOltRxPowerRequest `protobuf:"bytes,11,opt,name=oltRxPower,proto3,oneof"`
}

type GetValueRequest_OnuActiveAlarms struct {
	OnuActiveAlarms *GetOnuOmciActiveAlarmsRequest `protobuf:"bytes,12,opt,name=onuActiveAlarms,proto3,oneof"`
}

type GetValueRequest_OffloadedAppsStats struct {
	OffloadedAppsStats *GetOffloadedAppsStatisticsRequest `protobuf:"bytes,13,opt,name=offloadedAppsStats,proto3,oneof"`
}

type GetValueRequest_OnuAllocGemStats struct {
	OnuAllocGemStats *GetOnuAllocGemHistoryRequest `protobuf:"bytes,14,opt,name=onuAllocGemStats,proto3,oneof"`
}

type GetValueRequest_OnuStatsFromOlt struct {
	OnuStatsFromOlt *GetOnuStatsFromOltRequest `protobuf:"bytes,15,opt,name=onuStatsFromOlt,proto3,oneof"`
}

type GetValueRequest_OltPonStats struct {
	OltPonStats *GetPonStatsRequest `protobuf:"bytes,16,opt,name=oltPonStats,proto3,oneof"`
}

type GetValueRequest_OltNniStats struct {
	OltNniStats *GetNNIStatsRequest `protobuf:"bytes,17,opt,name=oltNniStats,proto3,oneof"`
}

func (*GetValueRequest_Distance) isGetValueRequest_Request() {}

func (*GetValueRequest_UniInfo) isGetValueRequest_Request() {}

func (*GetValueRequest_OltPortInfo) isGetValueRequest_Request() {}

func (*GetValueRequest_OnuOpticalInfo) isGetValueRequest_Request() {}

func (*GetValueRequest_EthBridgePort) isGetValueRequest_Request() {}

func (*GetValueRequest_FecHistory) isGetValueRequest_Request() {}

func (*GetValueRequest_OnuPonInfo) isGetValueRequest_Request() {}

func (*GetValueRequest_OnuInfo) isGetValueRequest_Request() {}

func (*GetValueRequest_RxPower) isGetValueRequest_Request() {}

func (*GetValueRequest_OnuOmciStats) isGetValueRequest_Request() {}

func (*GetValueRequest_OltRxPower) isGetValueRequest_Request() {}

func (*GetValueRequest_OnuActiveAlarms) isGetValueRequest_Request() {}

func (*GetValueRequest_OffloadedAppsStats) isGetValueRequest_Request() {}

func (*GetValueRequest_OnuAllocGemStats) isGetValueRequest_Request() {}

func (*GetValueRequest_OnuStatsFromOlt) isGetValueRequest_Request() {}

func (*GetValueRequest_OltPonStats) isGetValueRequest_Request() {}

func (*GetValueRequest_OltNniStats) isGetValueRequest_Request() {}

type GetValueResponse struct {
	state     protoimpl.MessageState       `protogen:"open.v1"`
	Status    GetValueResponse_Status      `protobuf:"varint,1,opt,name=status,proto3,enum=extension.GetValueResponse_Status" json:"status,omitempty"`
	ErrReason GetValueResponse_ErrorReason `protobuf:"varint,2,opt,name=errReason,proto3,enum=extension.GetValueResponse_ErrorReason" json:"errReason,omitempty"`
	// Types that are valid to be assigned to Response:
	//
	//	*GetValueResponse_Distance
	//	*GetValueResponse_UniInfo
	//	*GetValueResponse_PortCoutners
	//	*GetValueResponse_OnuOpticalInfo
	//	*GetValueResponse_EthBridgePortInfo
	//	*GetValueResponse_FecHistory
	//	*GetValueResponse_OnuPonCounters
	//	*GetValueResponse_OnuCounters
	//	*GetValueResponse_RxPower
	//	*GetValueResponse_OnuOmciStats
	//	*GetValueResponse_OltRxPower
	//	*GetValueResponse_OnuActiveAlarms
	//	*GetValueResponse_OffloadedAppsStats
	//	*GetValueResponse_OnuAllocGemStatsResponse
	//	*GetValueResponse_OnuStatsFromOltResponse
	//	*GetValueResponse_OltPonStatsResponse
	//	*GetValueResponse_OltNniStatsResponse
	Response      isGetValueResponse_Response `protobuf_oneof:"response"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetValueResponse) Reset() {
	*x = GetValueResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetValueResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetValueResponse) ProtoMessage() {}

func (x *GetValueResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetValueResponse.ProtoReflect.Descriptor instead.
func (*GetValueResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{48}
}

func (x *GetValueResponse) GetStatus() GetValueResponse_Status {
	if x != nil {
		return x.Status
	}
	return GetValueResponse_STATUS_UNDEFINED
}

func (x *GetValueResponse) GetErrReason() GetValueResponse_ErrorReason {
	if x != nil {
		return x.ErrReason
	}
	return GetValueResponse_REASON_UNDEFINED
}

func (x *GetValueResponse) GetResponse() isGetValueResponse_Response {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *GetValueResponse) GetDistance() *GetDistanceResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_Distance); ok {
			return x.Distance
		}
	}
	return nil
}

func (x *GetValueResponse) GetUniInfo() *GetOnuUniInfoResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_UniInfo); ok {
			return x.UniInfo
		}
	}
	return nil
}

func (x *GetValueResponse) GetPortCoutners() *GetOltPortCountersResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_PortCoutners); ok {
			return x.PortCoutners
		}
	}
	return nil
}

func (x *GetValueResponse) GetOnuOpticalInfo() *GetOnuPonOpticalInfoResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OnuOpticalInfo); ok {
			return x.OnuOpticalInfo
		}
	}
	return nil
}

func (x *GetValueResponse) GetEthBridgePortInfo() *GetOnuEthernetBridgePortHistoryResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_EthBridgePortInfo); ok {
			return x.EthBridgePortInfo
		}
	}
	return nil
}

func (x *GetValueResponse) GetFecHistory() *GetOnuFecHistoryResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_FecHistory); ok {
			return x.FecHistory
		}
	}
	return nil
}

func (x *GetValueResponse) GetOnuPonCounters() *GetOnuCountersResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OnuPonCounters); ok {
			return x.OnuPonCounters
		}
	}
	return nil
}

func (x *GetValueResponse) GetOnuCounters() *GetOmciEthernetFrameExtendedPmResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OnuCounters); ok {
			return x.OnuCounters
		}
	}
	return nil
}

func (x *GetValueResponse) GetRxPower() *GetRxPowerResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_RxPower); ok {
			return x.RxPower
		}
	}
	return nil
}

func (x *GetValueResponse) GetOnuOmciStats() *GetOnuOmciTxRxStatsResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OnuOmciStats); ok {
			return x.OnuOmciStats
		}
	}
	return nil
}

func (x *GetValueResponse) GetOltRxPower() *GetOltRxPowerResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OltRxPower); ok {
			return x.OltRxPower
		}
	}
	return nil
}

func (x *GetValueResponse) GetOnuActiveAlarms() *GetOnuOmciActiveAlarmsResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OnuActiveAlarms); ok {
			return x.OnuActiveAlarms
		}
	}
	return nil
}

func (x *GetValueResponse) GetOffloadedAppsStats() *GetOffloadedAppsStatisticsResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OffloadedAppsStats); ok {
			return x.OffloadedAppsStats
		}
	}
	return nil
}

func (x *GetValueResponse) GetOnuAllocGemStatsResponse() *GetOnuAllocGemHistoryResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OnuAllocGemStatsResponse); ok {
			return x.OnuAllocGemStatsResponse
		}
	}
	return nil
}

func (x *GetValueResponse) GetOnuStatsFromOltResponse() *GetOnuStatsFromOltResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OnuStatsFromOltResponse); ok {
			return x.OnuStatsFromOltResponse
		}
	}
	return nil
}

func (x *GetValueResponse) GetOltPonStatsResponse() *GetPonStatsResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OltPonStatsResponse); ok {
			return x.OltPonStatsResponse
		}
	}
	return nil
}

func (x *GetValueResponse) GetOltNniStatsResponse() *GetNNIStatsResponse {
	if x != nil {
		if x, ok := x.Response.(*GetValueResponse_OltNniStatsResponse); ok {
			return x.OltNniStatsResponse
		}
	}
	return nil
}

type isGetValueResponse_Response interface {
	isGetValueResponse_Response()
}

type GetValueResponse_Distance struct {
	Distance *GetDistanceResponse `protobuf:"bytes,3,opt,name=distance,proto3,oneof"`
}

type GetValueResponse_UniInfo struct {
	UniInfo *GetOnuUniInfoResponse `protobuf:"bytes,4,opt,name=uniInfo,proto3,oneof"`
}

type GetValueResponse_PortCoutners struct {
	PortCoutners *GetOltPortCountersResponse `protobuf:"bytes,5,opt,name=portCoutners,proto3,oneof"`
}

type GetValueResponse_OnuOpticalInfo struct {
	OnuOpticalInfo *GetOnuPonOpticalInfoResponse `protobuf:"bytes,6,opt,name=onuOpticalInfo,proto3,oneof"`
}

type GetValueResponse_EthBridgePortInfo struct {
	EthBridgePortInfo *GetOnuEthernetBridgePortHistoryResponse `protobuf:"bytes,7,opt,name=ethBridgePortInfo,proto3,oneof"`
}

type GetValueResponse_FecHistory struct {
	FecHistory *GetOnuFecHistoryResponse `protobuf:"bytes,8,opt,name=fecHistory,proto3,oneof"`
}

type GetValueResponse_OnuPonCounters struct {
	OnuPonCounters *GetOnuCountersResponse `protobuf:"bytes,9,opt,name=onuPonCounters,proto3,oneof"`
}

type GetValueResponse_OnuCounters struct {
	OnuCounters *GetOmciEthernetFrameExtendedPmResponse `protobuf:"bytes,10,opt,name=onuCounters,proto3,oneof"`
}

type GetValueResponse_RxPower struct {
	RxPower *GetRxPowerResponse `protobuf:"bytes,11,opt,name=rxPower,proto3,oneof"` // This is DEPRECATED
}

type GetValueResponse_OnuOmciStats struct {
	OnuOmciStats *GetOnuOmciTxRxStatsResponse `protobuf:"bytes,12,opt,name=onuOmciStats,proto3,oneof"`
}

type GetValueResponse_OltRxPower struct {
	OltRxPower *GetOltRxPowerResponse `protobuf:"bytes,13,opt,name=oltRxPower,proto3,oneof"`
}

type GetValueResponse_OnuActiveAlarms struct {
	OnuActiveAlarms *GetOnuOmciActiveAlarmsResponse `protobuf:"bytes,14,opt,name=onuActiveAlarms,proto3,oneof"`
}

type GetValueResponse_OffloadedAppsStats struct {
	OffloadedAppsStats *GetOffloadedAppsStatisticsResponse `protobuf:"bytes,15,opt,name=offloadedAppsStats,proto3,oneof"`
}

type GetValueResponse_OnuAllocGemStatsResponse struct {
	OnuAllocGemStatsResponse *GetOnuAllocGemHistoryResponse `protobuf:"bytes,16,opt,name=onuAllocGemStatsResponse,proto3,oneof"`
}

type GetValueResponse_OnuStatsFromOltResponse struct {
	OnuStatsFromOltResponse *GetOnuStatsFromOltResponse `protobuf:"bytes,17,opt,name=onuStatsFromOltResponse,proto3,oneof"`
}

type GetValueResponse_OltPonStatsResponse struct {
	OltPonStatsResponse *GetPonStatsResponse `protobuf:"bytes,18,opt,name=oltPonStatsResponse,proto3,oneof"`
}

type GetValueResponse_OltNniStatsResponse struct {
	OltNniStatsResponse *GetNNIStatsResponse `protobuf:"bytes,19,opt,name=oltNniStatsResponse,proto3,oneof"`
}

func (*GetValueResponse_Distance) isGetValueResponse_Response() {}

func (*GetValueResponse_UniInfo) isGetValueResponse_Response() {}

func (*GetValueResponse_PortCoutners) isGetValueResponse_Response() {}

func (*GetValueResponse_OnuOpticalInfo) isGetValueResponse_Response() {}

func (*GetValueResponse_EthBridgePortInfo) isGetValueResponse_Response() {}

func (*GetValueResponse_FecHistory) isGetValueResponse_Response() {}

func (*GetValueResponse_OnuPonCounters) isGetValueResponse_Response() {}

func (*GetValueResponse_OnuCounters) isGetValueResponse_Response() {}

func (*GetValueResponse_RxPower) isGetValueResponse_Response() {}

func (*GetValueResponse_OnuOmciStats) isGetValueResponse_Response() {}

func (*GetValueResponse_OltRxPower) isGetValueResponse_Response() {}

func (*GetValueResponse_OnuActiveAlarms) isGetValueResponse_Response() {}

func (*GetValueResponse_OffloadedAppsStats) isGetValueResponse_Response() {}

func (*GetValueResponse_OnuAllocGemStatsResponse) isGetValueResponse_Response() {}

func (*GetValueResponse_OnuStatsFromOltResponse) isGetValueResponse_Response() {}

func (*GetValueResponse_OltPonStatsResponse) isGetValueResponse_Response() {}

func (*GetValueResponse_OltNniStatsResponse) isGetValueResponse_Response() {}

// AppOffloadConfig is the configuration for offloading applications to the OLT and has OLT wide configuration.
type AppOffloadConfig struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	EnableDHCPv4RA bool                   `protobuf:"varint,1,opt,name=enableDHCPv4RA,proto3" json:"enableDHCPv4RA,omitempty"`
	EnableDHCPv6RA bool                   `protobuf:"varint,2,opt,name=enableDHCPv6RA,proto3" json:"enableDHCPv6RA,omitempty"`
	EnablePPPoEIA  bool                   `protobuf:"varint,3,opt,name=enablePPPoEIA,proto3" json:"enablePPPoEIA,omitempty"`
	// Follows the same as the BBF Access Node Id defined in https://github.com/BroadbandForum/yang/blob/master/standard/networking/bbf-subscriber-profiles.yang
	AccessNodeID  string `protobuf:"bytes,4,opt,name=accessNodeID,proto3" json:"accessNodeID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppOffloadConfig) Reset() {
	*x = AppOffloadConfig{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppOffloadConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppOffloadConfig) ProtoMessage() {}

func (x *AppOffloadConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppOffloadConfig.ProtoReflect.Descriptor instead.
func (*AppOffloadConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{49}
}

func (x *AppOffloadConfig) GetEnableDHCPv4RA() bool {
	if x != nil {
		return x.EnableDHCPv4RA
	}
	return false
}

func (x *AppOffloadConfig) GetEnableDHCPv6RA() bool {
	if x != nil {
		return x.EnableDHCPv6RA
	}
	return false
}

func (x *AppOffloadConfig) GetEnablePPPoEIA() bool {
	if x != nil {
		return x.EnablePPPoEIA
	}
	return false
}

func (x *AppOffloadConfig) GetAccessNodeID() string {
	if x != nil {
		return x.AccessNodeID
	}
	return ""
}

// AppOffloadOnuConfig has Onu specfic configuration which the OLT runs applications which have been offloaded.
type AppOffloadOnuConfig struct {
	state         protoimpl.MessageState              `protogen:"open.v1"`
	OnuDeviceId   string                              `protobuf:"bytes,1,opt,name=onuDeviceId,proto3" json:"onuDeviceId,omitempty"`
	PerUniInfo    []*AppOffloadOnuConfig_PerUniConfig `protobuf:"bytes,5,rep,name=perUniInfo,proto3" json:"perUniInfo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppOffloadOnuConfig) Reset() {
	*x = AppOffloadOnuConfig{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppOffloadOnuConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppOffloadOnuConfig) ProtoMessage() {}

func (x *AppOffloadOnuConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppOffloadOnuConfig.ProtoReflect.Descriptor instead.
func (*AppOffloadOnuConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{50}
}

func (x *AppOffloadOnuConfig) GetOnuDeviceId() string {
	if x != nil {
		return x.OnuDeviceId
	}
	return ""
}

func (x *AppOffloadOnuConfig) GetPerUniInfo() []*AppOffloadOnuConfig_PerUniConfig {
	if x != nil {
		return x.PerUniInfo
	}
	return nil
}

type SetValueRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Request:
	//
	//	*SetValueRequest_AlarmConfig
	//	*SetValueRequest_AppOffloadConfig
	//	*SetValueRequest_AppOffloadOnuConfig
	Request       isSetValueRequest_Request `protobuf_oneof:"request"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetValueRequest) Reset() {
	*x = SetValueRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetValueRequest) ProtoMessage() {}

func (x *SetValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetValueRequest.ProtoReflect.Descriptor instead.
func (*SetValueRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{51}
}

func (x *SetValueRequest) GetRequest() isSetValueRequest_Request {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *SetValueRequest) GetAlarmConfig() *config.AlarmConfig {
	if x != nil {
		if x, ok := x.Request.(*SetValueRequest_AlarmConfig); ok {
			return x.AlarmConfig
		}
	}
	return nil
}

func (x *SetValueRequest) GetAppOffloadConfig() *AppOffloadConfig {
	if x != nil {
		if x, ok := x.Request.(*SetValueRequest_AppOffloadConfig); ok {
			return x.AppOffloadConfig
		}
	}
	return nil
}

func (x *SetValueRequest) GetAppOffloadOnuConfig() *AppOffloadOnuConfig {
	if x != nil {
		if x, ok := x.Request.(*SetValueRequest_AppOffloadOnuConfig); ok {
			return x.AppOffloadOnuConfig
		}
	}
	return nil
}

type isSetValueRequest_Request interface {
	isSetValueRequest_Request()
}

type SetValueRequest_AlarmConfig struct {
	AlarmConfig *config.AlarmConfig `protobuf:"bytes,1,opt,name=alarm_config,json=alarmConfig,proto3,oneof"`
}

type SetValueRequest_AppOffloadConfig struct {
	AppOffloadConfig *AppOffloadConfig `protobuf:"bytes,2,opt,name=app_offload_config,json=appOffloadConfig,proto3,oneof"`
}

type SetValueRequest_AppOffloadOnuConfig struct {
	AppOffloadOnuConfig *AppOffloadOnuConfig `protobuf:"bytes,3,opt,name=app_offload_onu_config,json=appOffloadOnuConfig,proto3,oneof"`
}

func (*SetValueRequest_AlarmConfig) isSetValueRequest_Request() {}

func (*SetValueRequest_AppOffloadConfig) isSetValueRequest_Request() {}

func (*SetValueRequest_AppOffloadOnuConfig) isSetValueRequest_Request() {}

type SetValueResponse struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Status        SetValueResponse_Status      `protobuf:"varint,1,opt,name=status,proto3,enum=extension.SetValueResponse_Status" json:"status,omitempty"`
	ErrReason     SetValueResponse_ErrorReason `protobuf:"varint,2,opt,name=errReason,proto3,enum=extension.SetValueResponse_ErrorReason" json:"errReason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetValueResponse) Reset() {
	*x = SetValueResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetValueResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetValueResponse) ProtoMessage() {}

func (x *SetValueResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetValueResponse.ProtoReflect.Descriptor instead.
func (*SetValueResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{52}
}

func (x *SetValueResponse) GetStatus() SetValueResponse_Status {
	if x != nil {
		return x.Status
	}
	return SetValueResponse_STATUS_UNDEFINED
}

func (x *SetValueResponse) GetErrReason() SetValueResponse_ErrorReason {
	if x != nil {
		return x.ErrReason
	}
	return SetValueResponse_REASON_UNDEFINED
}

type SingleGetValueRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TargetId      string                 `protobuf:"bytes,1,opt,name=targetId,proto3" json:"targetId,omitempty"`
	Request       *GetValueRequest       `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SingleGetValueRequest) Reset() {
	*x = SingleGetValueRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleGetValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleGetValueRequest) ProtoMessage() {}

func (x *SingleGetValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleGetValueRequest.ProtoReflect.Descriptor instead.
func (*SingleGetValueRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{53}
}

func (x *SingleGetValueRequest) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *SingleGetValueRequest) GetRequest() *GetValueRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

type SingleGetValueResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Response      *GetValueResponse      `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SingleGetValueResponse) Reset() {
	*x = SingleGetValueResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleGetValueResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleGetValueResponse) ProtoMessage() {}

func (x *SingleGetValueResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleGetValueResponse.ProtoReflect.Descriptor instead.
func (*SingleGetValueResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{54}
}

func (x *SingleGetValueResponse) GetResponse() *GetValueResponse {
	if x != nil {
		return x.Response
	}
	return nil
}

type SingleSetValueRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TargetId      string                 `protobuf:"bytes,1,opt,name=targetId,proto3" json:"targetId,omitempty"`
	Request       *SetValueRequest       `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SingleSetValueRequest) Reset() {
	*x = SingleSetValueRequest{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleSetValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleSetValueRequest) ProtoMessage() {}

func (x *SingleSetValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleSetValueRequest.ProtoReflect.Descriptor instead.
func (*SingleSetValueRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{55}
}

func (x *SingleSetValueRequest) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *SingleSetValueRequest) GetRequest() *SetValueRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

type SingleSetValueResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Response      *SetValueResponse      `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SingleSetValueResponse) Reset() {
	*x = SingleSetValueResponse{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleSetValueResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleSetValueResponse) ProtoMessage() {}

func (x *SingleSetValueResponse) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleSetValueResponse.ProtoReflect.Descriptor instead.
func (*SingleSetValueResponse) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{56}
}

func (x *SingleSetValueResponse) GetResponse() *SetValueResponse {
	if x != nil {
		return x.Response
	}
	return nil
}

type GetOffloadedAppsStatisticsResponse_DHCPv4RAStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// From https://github.com/BroadbandForum/yang/blob/master/standard/networking/bbf-l2-dhcpv4-relay.yang
	InBadPacketsFromClient           uint32 `protobuf:"varint,1,opt,name=in_bad_packets_from_client,json=inBadPacketsFromClient,proto3" json:"in_bad_packets_from_client,omitempty"`
	InBadPacketsFromServer           uint32 `protobuf:"varint,2,opt,name=in_bad_packets_from_server,json=inBadPacketsFromServer,proto3" json:"in_bad_packets_from_server,omitempty"`
	InPacketsFromClient              uint32 `protobuf:"varint,3,opt,name=in_packets_from_client,json=inPacketsFromClient,proto3" json:"in_packets_from_client,omitempty"`
	InPacketsFromServer              uint32 `protobuf:"varint,4,opt,name=in_packets_from_server,json=inPacketsFromServer,proto3" json:"in_packets_from_server,omitempty"`
	OutPacketsToServer               uint32 `protobuf:"varint,5,opt,name=out_packets_to_server,json=outPacketsToServer,proto3" json:"out_packets_to_server,omitempty"`
	OutPacketsToClient               uint32 `protobuf:"varint,6,opt,name=out_packets_to_client,json=outPacketsToClient,proto3" json:"out_packets_to_client,omitempty"`
	Option_82InsertedPacketsToServer uint32 `protobuf:"varint,7,opt,name=option_82_inserted_packets_to_server,json=option82InsertedPacketsToServer,proto3" json:"option_82_inserted_packets_to_server,omitempty"`
	Option_82RemovedPacketsToClient  uint32 `protobuf:"varint,8,opt,name=option_82_removed_packets_to_client,json=option82RemovedPacketsToClient,proto3" json:"option_82_removed_packets_to_client,omitempty"`
	Option_82NotInsertedToServer     uint32 `protobuf:"varint,9,opt,name=option_82_not_inserted_to_server,json=option82NotInsertedToServer,proto3" json:"option_82_not_inserted_to_server,omitempty"`
	// Name value pairs that gives the flexibility to report different statistics that implementations may choose
	AdditionalStats map[string]string `protobuf:"bytes,10,rep,name=additional_stats,json=additionalStats,proto3" json:"additional_stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) Reset() {
	*x = GetOffloadedAppsStatisticsResponse_DHCPv4RAStats{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) ProtoMessage() {}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOffloadedAppsStatisticsResponse_DHCPv4RAStats.ProtoReflect.Descriptor instead.
func (*GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{46, 0}
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetInBadPacketsFromClient() uint32 {
	if x != nil {
		return x.InBadPacketsFromClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetInBadPacketsFromServer() uint32 {
	if x != nil {
		return x.InBadPacketsFromServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetInPacketsFromClient() uint32 {
	if x != nil {
		return x.InPacketsFromClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetInPacketsFromServer() uint32 {
	if x != nil {
		return x.InPacketsFromServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetOutPacketsToServer() uint32 {
	if x != nil {
		return x.OutPacketsToServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetOutPacketsToClient() uint32 {
	if x != nil {
		return x.OutPacketsToClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetOption_82InsertedPacketsToServer() uint32 {
	if x != nil {
		return x.Option_82InsertedPacketsToServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetOption_82RemovedPacketsToClient() uint32 {
	if x != nil {
		return x.Option_82RemovedPacketsToClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetOption_82NotInsertedToServer() uint32 {
	if x != nil {
		return x.Option_82NotInsertedToServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv4RAStats) GetAdditionalStats() map[string]string {
	if x != nil {
		return x.AdditionalStats
	}
	return nil
}

type GetOffloadedAppsStatisticsResponse_DHCPv6RAStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// From https://github.com/BroadbandForum/yang/blob/master/standard/networking/bbf-ldra.yang
	InBadPacketsFromClient               uint32 `protobuf:"varint,1,opt,name=in_bad_packets_from_client,json=inBadPacketsFromClient,proto3" json:"in_bad_packets_from_client,omitempty"`
	InBadPacketsFromServer               uint32 `protobuf:"varint,2,opt,name=in_bad_packets_from_server,json=inBadPacketsFromServer,proto3" json:"in_bad_packets_from_server,omitempty"`
	Option_17InsertedPacketsToServer     uint32 `protobuf:"varint,3,opt,name=option_17_inserted_packets_to_server,json=option17InsertedPacketsToServer,proto3" json:"option_17_inserted_packets_to_server,omitempty"`
	Option_17RemovedPacketsToClient      uint32 `protobuf:"varint,4,opt,name=option_17_removed_packets_to_client,json=option17RemovedPacketsToClient,proto3" json:"option_17_removed_packets_to_client,omitempty"`
	Option_18InsertedPacketsToServer     uint32 `protobuf:"varint,5,opt,name=option_18_inserted_packets_to_server,json=option18InsertedPacketsToServer,proto3" json:"option_18_inserted_packets_to_server,omitempty"`
	Option_18RemovedPacketsToClient      uint32 `protobuf:"varint,6,opt,name=option_18_removed_packets_to_client,json=option18RemovedPacketsToClient,proto3" json:"option_18_removed_packets_to_client,omitempty"`
	Option_37InsertedPacketsToServer     uint32 `protobuf:"varint,7,opt,name=option_37_inserted_packets_to_server,json=option37InsertedPacketsToServer,proto3" json:"option_37_inserted_packets_to_server,omitempty"`
	Option_37RemovedPacketsToClient      uint32 `protobuf:"varint,8,opt,name=option_37_removed_packets_to_client,json=option37RemovedPacketsToClient,proto3" json:"option_37_removed_packets_to_client,omitempty"`
	OutgoingMtuExceededPacketsFromClient uint32 `protobuf:"varint,9,opt,name=outgoing_mtu_exceeded_packets_from_client,json=outgoingMtuExceededPacketsFromClient,proto3" json:"outgoing_mtu_exceeded_packets_from_client,omitempty"`
	// Name value pairs that gives the flexibility to report different statistics that implementations may choose
	AdditionalStats map[string]string `protobuf:"bytes,10,rep,name=additional_stats,json=additionalStats,proto3" json:"additional_stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) Reset() {
	*x = GetOffloadedAppsStatisticsResponse_DHCPv6RAStats{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) ProtoMessage() {}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOffloadedAppsStatisticsResponse_DHCPv6RAStats.ProtoReflect.Descriptor instead.
func (*GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{46, 1}
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetInBadPacketsFromClient() uint32 {
	if x != nil {
		return x.InBadPacketsFromClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetInBadPacketsFromServer() uint32 {
	if x != nil {
		return x.InBadPacketsFromServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetOption_17InsertedPacketsToServer() uint32 {
	if x != nil {
		return x.Option_17InsertedPacketsToServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetOption_17RemovedPacketsToClient() uint32 {
	if x != nil {
		return x.Option_17RemovedPacketsToClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetOption_18InsertedPacketsToServer() uint32 {
	if x != nil {
		return x.Option_18InsertedPacketsToServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetOption_18RemovedPacketsToClient() uint32 {
	if x != nil {
		return x.Option_18RemovedPacketsToClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetOption_37InsertedPacketsToServer() uint32 {
	if x != nil {
		return x.Option_37InsertedPacketsToServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetOption_37RemovedPacketsToClient() uint32 {
	if x != nil {
		return x.Option_37RemovedPacketsToClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetOutgoingMtuExceededPacketsFromClient() uint32 {
	if x != nil {
		return x.OutgoingMtuExceededPacketsFromClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_DHCPv6RAStats) GetAdditionalStats() map[string]string {
	if x != nil {
		return x.AdditionalStats
	}
	return nil
}

type GetOffloadedAppsStatisticsResponse_PPPoeIAStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// From https://github.com/BroadbandForum/yang/blob/master/standard/networking/bbf-pppoe-intermediate-agent.yang
	InErrorPacketsFromClient                 uint32 `protobuf:"varint,1,opt,name=in_error_packets_from_client,json=inErrorPacketsFromClient,proto3" json:"in_error_packets_from_client,omitempty"`
	InErrorPacketsFromServer                 uint32 `protobuf:"varint,2,opt,name=in_error_packets_from_server,json=inErrorPacketsFromServer,proto3" json:"in_error_packets_from_server,omitempty"`
	InPacketsFromClient                      uint32 `protobuf:"varint,3,opt,name=in_packets_from_client,json=inPacketsFromClient,proto3" json:"in_packets_from_client,omitempty"`
	InPacketsFromServer                      uint32 `protobuf:"varint,4,opt,name=in_packets_from_server,json=inPacketsFromServer,proto3" json:"in_packets_from_server,omitempty"`
	OutPacketsToServer                       uint32 `protobuf:"varint,5,opt,name=out_packets_to_server,json=outPacketsToServer,proto3" json:"out_packets_to_server,omitempty"`
	OutPacketsToClient                       uint32 `protobuf:"varint,6,opt,name=out_packets_to_client,json=outPacketsToClient,proto3" json:"out_packets_to_client,omitempty"`
	VendorSpecificTagInsertedPacketsToServer uint32 `protobuf:"varint,7,opt,name=vendor_specific_tag_inserted_packets_to_server,json=vendorSpecificTagInsertedPacketsToServer,proto3" json:"vendor_specific_tag_inserted_packets_to_server,omitempty"`
	VendorSpecificTagRemovedPacketsToClient  uint32 `protobuf:"varint,8,opt,name=vendor_specific_tag_removed_packets_to_client,json=vendorSpecificTagRemovedPacketsToClient,proto3" json:"vendor_specific_tag_removed_packets_to_client,omitempty"`
	OutgoingMtuExceededPacketsFromClient     uint32 `protobuf:"varint,9,opt,name=outgoing_mtu_exceeded_packets_from_client,json=outgoingMtuExceededPacketsFromClient,proto3" json:"outgoing_mtu_exceeded_packets_from_client,omitempty"`
	// Name value pairs that gives the flexibility to report different statistics that implementations may choose
	AdditionalStats map[string]string `protobuf:"bytes,10,rep,name=additional_stats,json=additionalStats,proto3" json:"additional_stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) Reset() {
	*x = GetOffloadedAppsStatisticsResponse_PPPoeIAStats{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOffloadedAppsStatisticsResponse_PPPoeIAStats) ProtoMessage() {}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOffloadedAppsStatisticsResponse_PPPoeIAStats.ProtoReflect.Descriptor instead.
func (*GetOffloadedAppsStatisticsResponse_PPPoeIAStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{46, 2}
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetInErrorPacketsFromClient() uint32 {
	if x != nil {
		return x.InErrorPacketsFromClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetInErrorPacketsFromServer() uint32 {
	if x != nil {
		return x.InErrorPacketsFromServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetInPacketsFromClient() uint32 {
	if x != nil {
		return x.InPacketsFromClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetInPacketsFromServer() uint32 {
	if x != nil {
		return x.InPacketsFromServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetOutPacketsToServer() uint32 {
	if x != nil {
		return x.OutPacketsToServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetOutPacketsToClient() uint32 {
	if x != nil {
		return x.OutPacketsToClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetVendorSpecificTagInsertedPacketsToServer() uint32 {
	if x != nil {
		return x.VendorSpecificTagInsertedPacketsToServer
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetVendorSpecificTagRemovedPacketsToClient() uint32 {
	if x != nil {
		return x.VendorSpecificTagRemovedPacketsToClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetOutgoingMtuExceededPacketsFromClient() uint32 {
	if x != nil {
		return x.OutgoingMtuExceededPacketsFromClient
	}
	return 0
}

func (x *GetOffloadedAppsStatisticsResponse_PPPoeIAStats) GetAdditionalStats() map[string]string {
	if x != nil {
		return x.AdditionalStats
	}
	return nil
}

type AppOffloadOnuConfig_PerUniConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// As per the BBF Agent Remote Id defined in https://github.com/BroadbandForum/yang/blob/master/standard/networking/bbf-pppoe-intermediate-agent-profile-common.yang
	AgentRemoteID string `protobuf:"bytes,2,opt,name=agentRemoteID,proto3" json:"agentRemoteID,omitempty"`
	// As per the BBF Agent Circuit Id defined in https://github.com/BroadbandForum/yang/blob/master/standard/networking/bbf-pppoe-intermediate-agent-profile-common.yang
	AgentCircuitID string `protobuf:"bytes,3,opt,name=agentCircuitID,proto3" json:"agentCircuitID,omitempty"`
	// The id of the UNI on the Onu for which this configuration is relevant. The UNI ids are numbered from 0 to n depending on the number of UNI ports on the ONU.
	OnuUniId      uint32 `protobuf:"varint,4,opt,name=onuUniId,proto3" json:"onuUniId,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppOffloadOnuConfig_PerUniConfig) Reset() {
	*x = AppOffloadOnuConfig_PerUniConfig{}
	mi := &file_voltha_protos_extensions_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppOffloadOnuConfig_PerUniConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppOffloadOnuConfig_PerUniConfig) ProtoMessage() {}

func (x *AppOffloadOnuConfig_PerUniConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_extensions_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppOffloadOnuConfig_PerUniConfig.ProtoReflect.Descriptor instead.
func (*AppOffloadOnuConfig_PerUniConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_extensions_proto_rawDescGZIP(), []int{50, 0}
}

func (x *AppOffloadOnuConfig_PerUniConfig) GetAgentRemoteID() string {
	if x != nil {
		return x.AgentRemoteID
	}
	return ""
}

func (x *AppOffloadOnuConfig_PerUniConfig) GetAgentCircuitID() string {
	if x != nil {
		return x.AgentCircuitID
	}
	return ""
}

func (x *AppOffloadOnuConfig_PerUniConfig) GetOnuUniId() uint32 {
	if x != nil {
		return x.OnuUniId
	}
	return 0
}

var File_voltha_protos_extensions_proto protoreflect.FileDescriptor

const file_voltha_protos_extensions_proto_rawDesc = "" +
	"\n" +
	"\x1evoltha_protos/extensions.proto\x12\textension\x1a\x1evoltha_protos/ext_config.proto\x1a\x1bgoogle/protobuf/empty.proto\x1a\x1avoltha_protos/common.proto\"]\n" +
	"\bValueSet\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x128\n" +
	"\falarm_config\x18\x02 \x01(\v2\x13.config.AlarmConfigH\x00R\valarmConfigB\a\n" +
	"\x05value\",\n" +
	"\tValueType\"\x1f\n" +
	"\x04Type\x12\t\n" +
	"\x05EMPTY\x10\x00\x12\f\n" +
	"\bDISTANCE\x10\x01\"Q\n" +
	"\x0eValueSpecifier\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12/\n" +
	"\x05value\x18\x02 \x01(\x0e2\x19.extension.ValueType.TypeR\x05value\"t\n" +
	"\fReturnValues\x12\x10\n" +
	"\x03Set\x18\x01 \x01(\rR\x03Set\x12 \n" +
	"\vUnsupported\x18\x02 \x01(\rR\vUnsupported\x12\x14\n" +
	"\x05Error\x18\x03 \x01(\rR\x05Error\x12\x1a\n" +
	"\bDistance\x18\x04 \x01(\rR\bDistance\"6\n" +
	"\x12GetDistanceRequest\x12 \n" +
	"\vonuDeviceId\x18\x01 \x01(\tR\vonuDeviceId\"1\n" +
	"\x13GetDistanceResponse\x12\x1a\n" +
	"\bdistance\x18\x01 \x01(\rR\bdistance\"2\n" +
	"\x14GetOnuUniInfoRequest\x12\x1a\n" +
	"\buniIndex\x18\x01 \x01(\rR\buniIndex\"\xe1\x04\n" +
	"\x15GetOnuUniInfoResponse\x12P\n" +
	"\badmState\x18\x01 \x01(\x0e24.extension.GetOnuUniInfoResponse.AdministrativeStateR\badmState\x12O\n" +
	"\toperState\x18\x02 \x01(\x0e21.extension.GetOnuUniInfoResponse.OperationalStateR\toperState\x12O\n" +
	"\tconfigInd\x18\x03 \x01(\x0e21.extension.GetOnuUniInfoResponse.ConfigurationIndR\tconfigInd\"\xc2\x01\n" +
	"\x10ConfigurationInd\x12\n" +
	"\n" +
	"\x06UNKOWN\x10\x00\x12\x12\n" +
	"\x0eTEN_BASE_T_FDX\x10\x01\x12\x16\n" +
	"\x12HUNDRED_BASE_T_FDX\x10\x02\x12\x18\n" +
	"\x14GIGABIT_ETHERNET_FDX\x10\x03\x12\x16\n" +
	"\x12TEN_G_ETHERNET_FDX\x10\x04\x12\x12\n" +
	"\x0eTEN_BASE_T_HDX\x10\x05\x12\x16\n" +
	"\x12HUNDRED_BASE_T_HDX\x10\x06\x12\x18\n" +
	"\x14GIGABIT_ETHERNET_HDX\x10\a\"G\n" +
	"\x13AdministrativeState\x12\x16\n" +
	"\x12ADMSTATE_UNDEFINED\x10\x00\x12\n" +
	"\n" +
	"\x06LOCKED\x10\x01\x12\f\n" +
	"\bUNLOCKED\x10\x02\"F\n" +
	"\x10OperationalState\x12\x17\n" +
	"\x13OPERSTATE_UNDEFINED\x10\x00\x12\v\n" +
	"\aENABLED\x10\x01\x12\f\n" +
	"\bDISABLED\x10\x02\"\xb7\x01\n" +
	"\x12GetOltPortCounters\x12\x16\n" +
	"\x06portNo\x18\x01 \x01(\rR\x06portNo\x12B\n" +
	"\bportType\x18\x02 \x01(\x0e2&.extension.GetOltPortCounters.PortTypeR\bportType\"E\n" +
	"\bPortType\x12\x10\n" +
	"\fPort_UNKNOWN\x10\x00\x12\x15\n" +
	"\x11Port_ETHERNET_NNI\x10\x01\x12\x10\n" +
	"\fPort_PON_OLT\x10\x02\"\xcc\x03\n" +
	"\x1aGetOltPortCountersResponse\x12\x18\n" +
	"\atxBytes\x18\x01 \x01(\x04R\atxBytes\x12\x18\n" +
	"\arxBytes\x18\x02 \x01(\x04R\arxBytes\x12\x1c\n" +
	"\ttxPackets\x18\x03 \x01(\x04R\ttxPackets\x12\x1c\n" +
	"\trxPackets\x18\x04 \x01(\x04R\trxPackets\x12&\n" +
	"\x0etxErrorPackets\x18\x05 \x01(\x04R\x0etxErrorPackets\x12&\n" +
	"\x0erxErrorPackets\x18\x06 \x01(\x04R\x0erxErrorPackets\x12&\n" +
	"\x0etxBcastPackets\x18\a \x01(\x04R\x0etxBcastPackets\x12&\n" +
	"\x0erxBcastPackets\x18\b \x01(\x04R\x0erxBcastPackets\x12&\n" +
	"\x0etxUcastPackets\x18\t \x01(\x04R\x0etxUcastPackets\x12&\n" +
	"\x0erxUcastPackets\x18\n" +
	" \x01(\x04R\x0erxUcastPackets\x12&\n" +
	"\x0etxMcastPackets\x18\v \x01(\x04R\x0etxMcastPackets\x12&\n" +
	"\x0erxMcastPackets\x18\f \x01(\x04R\x0erxMcastPackets\"D\n" +
	"\x14GetOnuPonOpticalInfo\x12,\n" +
	"\x05empty\x18\x01 \x01(\v2\x16.google.protobuf.EmptyR\x05empty\"\x84\x02\n" +
	"\x1cGetOnuPonOpticalInfoResponse\x12*\n" +
	"\x10powerFeedVoltage\x18\x01 \x01(\x02R\x10powerFeedVoltage\x122\n" +
	"\x14receivedOpticalPower\x18\x02 \x01(\x02R\x14receivedOpticalPower\x126\n" +
	"\x16meanOpticalLaunchPower\x18\x03 \x01(\x02R\x16meanOpticalLaunchPower\x12*\n" +
	"\x10laserBiasCurrent\x18\x04 \x01(\x02R\x10laserBiasCurrent\x12 \n" +
	"\vtemperature\x18\x05 \x01(\x02R\vtemperature\"\xaf\x01\n" +
	"\x1fGetOnuEthernetBridgePortHistory\x12R\n" +
	"\tdirection\x18\x01 \x01(\x0e24.extension.GetOnuEthernetBridgePortHistory.DirectionR\tdirection\"8\n" +
	"\tDirection\x12\r\n" +
	"\tUNDEFINED\x10\x00\x12\f\n" +
	"\bUPSTREAM\x10\x01\x12\x0e\n" +
	"\n" +
	"DOWNSTREAM\x10\x02\"\x93\x05\n" +
	"'GetOnuEthernetBridgePortHistoryResponse\x12\x1e\n" +
	"\n" +
	"dropEvents\x18\x01 \x01(\rR\n" +
	"dropEvents\x12\x16\n" +
	"\x06octets\x18\x02 \x01(\rR\x06octets\x12\x18\n" +
	"\apackets\x18\x03 \x01(\rR\apackets\x12*\n" +
	"\x10broadcastPackets\x18\x04 \x01(\rR\x10broadcastPackets\x12*\n" +
	"\x10multicastPackets\x18\x05 \x01(\rR\x10multicastPackets\x12,\n" +
	"\x11crcErroredPackets\x18\x06 \x01(\rR\x11crcErroredPackets\x12*\n" +
	"\x10undersizePackets\x18\a \x01(\rR\x10undersizePackets\x12(\n" +
	"\x0foversizePackets\x18\b \x01(\rR\x0foversizePackets\x12(\n" +
	"\x0fpackets64octets\x18\t \x01(\rR\x0fpackets64octets\x122\n" +
	"\x14packets65To127octets\x18\n" +
	" \x01(\rR\x14packets65To127octets\x124\n" +
	"\x15packets128To255Octets\x18\v \x01(\rR\x15packets128To255Octets\x124\n" +
	"\x15packets256To511octets\x18\f \x01(\rR\x15packets256To511octets\x126\n" +
	"\x16packets512To1023octets\x18\r \x01(\rR\x16packets512To1023octets\x128\n" +
	"\x17packets1024To1518octets\x18\x0e \x01(\rR\x17packets1024To1518octets\"L\n" +
	"\x1cGetOnuAllocGemHistoryRequest\x12,\n" +
	"\x05empty\x18\x01 \x01(\v2\x16.google.protobuf.EmptyR\x05empty\"\xb3\x03\n" +
	"\x15OnuGemPortHistoryData\x12\x14\n" +
	"\x05gemId\x18\x01 \x01(\rR\x05gemId\x122\n" +
	"\x14transmittedGEMFrames\x18\x02 \x01(\rR\x14transmittedGEMFrames\x12,\n" +
	"\x11receivedGEMFrames\x18\x03 \x01(\rR\x11receivedGEMFrames\x126\n" +
	"\x14receivedPayloadBytes\x18\x04 \x01(\rB\x02\x18\x01R\x14receivedPayloadBytes\x12<\n" +
	"\x17transmittedPayloadBytes\x18\x05 \x01(\rB\x02\x18\x01R\x17transmittedPayloadBytes\x120\n" +
	"\x13encryptionKeyErrors\x18\x06 \x01(\rR\x13encryptionKeyErrors\x129\n" +
	"\x19received_payload_bytes_64\x18\a \x01(\x06R\x16receivedPayloadBytes64\x12?\n" +
	"\x1ctransmitted_payload_bytes_64\x18\b \x01(\x06R\x19transmittedPayloadBytes64\"I\n" +
	"\x13OnuAllocHistoryData\x12\x18\n" +
	"\aallocId\x18\x01 \x01(\rR\aallocId\x12\x18\n" +
	"\arxBytes\x18\x02 \x01(\rR\arxBytes\"\xa4\x01\n" +
	"\x16OnuAllocGemHistoryData\x12F\n" +
	"\x0eonuAllocIdInfo\x18\x01 \x01(\v2\x1e.extension.OnuAllocHistoryDataR\x0eonuAllocIdInfo\x12B\n" +
	"\vgemPortInfo\x18\x02 \x03(\v2 .extension.OnuGemPortHistoryDataR\vgemPortInfo\"z\n" +
	"\x1dGetOnuAllocGemHistoryResponse\x12Y\n" +
	"\x16onuAllocGemHistoryData\x18\x01 \x03(\v2!.extension.OnuAllocGemHistoryDataR\x16onuAllocGemHistoryData\"@\n" +
	"\x10GetOnuFecHistory\x12,\n" +
	"\x05empty\x18\x01 \x01(\v2\x16.google.protobuf.EmptyR\x05empty\"\xe3\x03\n" +
	"\x18GetOnuFecHistoryResponse\x12*\n" +
	"\x0ecorrectedBytes\x18\x01 \x01(\rB\x02\x18\x01R\x0ecorrectedBytes\x122\n" +
	"\x12correctedCodeWords\x18\x02 \x01(\rB\x02\x18\x01R\x12correctedCodeWords\x12\x1e\n" +
	"\n" +
	"fecSeconds\x18\x03 \x01(\rR\n" +
	"fecSeconds\x12*\n" +
	"\x0etotalCodeWords\x18\x04 \x01(\rB\x02\x18\x01R\x0etotalCodeWords\x12:\n" +
	"\x16uncorrectableCodeWords\x18\x05 \x01(\rB\x02\x18\x01R\x16uncorrectableCodeWords\x123\n" +
	"\x16fec_corrected_bytes_64\x18\x06 \x01(\x06R\x13fecCorrectedBytes64\x12<\n" +
	"\x1bfec_corrected_code_words_64\x18\a \x01(\x06R\x17fecCorrectedCodeWords64\x12-\n" +
	"\x13total_code_words_64\x18\b \x01(\x06R\x10totalCodeWords64\x12=\n" +
	"\x1buncorrectable_code_words_64\x18\t \x01(\x06R\x18uncorrectableCodeWords64\"G\n" +
	"\x15GetOnuCountersRequest\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\"\x8d\x01\n" +
	"%GetOmciEthernetFrameExtendedPmRequest\x12 \n" +
	"\vonuDeviceId\x18\x01 \x01(\tR\vonuDeviceId\x12\x1c\n" +
	"\buniIndex\x18\x02 \x01(\rH\x00R\buniIndex\x12\x14\n" +
	"\x05reset\x18\x03 \x01(\bR\x05resetB\x0e\n" +
	"\fis_uni_index\"C\n" +
	"\x11GetRxPowerRequest\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\"L\n" +
	"\x14GetOltRxPowerRequest\x12\x1d\n" +
	"\n" +
	"port_label\x18\x01 \x01(\tR\tportLabel\x12\x15\n" +
	"\x06onu_sn\x18\x02 \x01(\tR\x05onuSn\"Z\n" +
	"\x12GetPonStatsRequest\x12\x1e\n" +
	"\tportLabel\x18\x01 \x01(\tH\x00R\tportLabel\x12\x18\n" +
	"\x06portId\x18\x02 \x01(\aH\x00R\x06portIdB\n" +
	"\n" +
	"\bportInfo\"o\n" +
	"\x13GetPonStatsResponse\x12\x18\n" +
	"\aponPort\x18\x01 \x01(\rR\aponPort\x12>\n" +
	"\x0eportStatistics\x18\x02 \x01(\v2\x16.common.PortStatisticsR\x0eportStatistics\"Z\n" +
	"\x12GetNNIStatsRequest\x12\x1e\n" +
	"\tportLabel\x18\x01 \x01(\tH\x00R\tportLabel\x12\x18\n" +
	"\x06portId\x18\x02 \x01(\aH\x00R\x06portIdB\n" +
	"\n" +
	"\bportInfo\"o\n" +
	"\x13GetNNIStatsResponse\x12\x18\n" +
	"\anniPort\x18\x01 \x01(\rR\anniPort\x12>\n" +
	"\x0eportStatistics\x18\x02 \x01(\v2\x16.common.PortStatisticsR\x0eportStatistics\"I\n" +
	"\x19GetOnuStatsFromOltRequest\x12\x16\n" +
	"\x06intfId\x18\x01 \x01(\aR\x06intfId\x12\x14\n" +
	"\x05onuId\x18\x02 \x01(\aR\x05onuId\"\x9d\x01\n" +
	"\x15OnuGemPortInfoFromOlt\x12\x14\n" +
	"\x05gemId\x18\x01 \x01(\rR\x05gemId\x12\x1c\n" +
	"\trxPackets\x18\x02 \x01(\x04R\trxPackets\x12\x18\n" +
	"\arxBytes\x18\x03 \x01(\x04R\arxBytes\x12\x1c\n" +
	"\ttxPackets\x18\x04 \x01(\x04R\ttxPackets\x12\x18\n" +
	"\atxBytes\x18\x05 \x01(\x04R\atxBytes\"K\n" +
	"\x15OnuAllocIdInfoFromOlt\x12\x18\n" +
	"\aallocId\x18\x01 \x01(\rR\aallocId\x12\x18\n" +
	"\arxBytes\x18\x02 \x01(\x04R\arxBytes\"\xa9\x01\n" +
	"\x1fOnuAllocGemStatsFromOltResponse\x12B\n" +
	"\vallocIdInfo\x18\x01 \x01(\v2 .extension.OnuAllocIdInfoFromOltR\vallocIdInfo\x12B\n" +
	"\vgemPortInfo\x18\x02 \x03(\v2 .extension.OnuGemPortInfoFromOltR\vgemPortInfo\"v\n" +
	"\x1aGetOnuStatsFromOltResponse\x12X\n" +
	"\x11allocGemStatsInfo\x18\x01 \x03(\v2*.extension.OnuAllocGemStatsFromOltResponseR\x11allocGemStatsInfo\"\x96\r\n" +
	"\x16GetOnuCountersResponse\x12\x19\n" +
	"\aintf_id\x18\x01 \x01(\aH\x00R\x06intfId\x12\x17\n" +
	"\x06onu_id\x18\x02 \x01(\aH\x01R\x05onuId\x12'\n" +
	"\x0epositive_drift\x18\x03 \x01(\x06H\x02R\rpositiveDrift\x12'\n" +
	"\x0enegative_drift\x18\x04 \x01(\x06H\x03R\rnegativeDrift\x12:\n" +
	"\x18delimiter_miss_detection\x18\x05 \x01(\x06H\x04R\x16delimiterMissDetection\x12\x1f\n" +
	"\n" +
	"bip_errors\x18\x06 \x01(\x06H\x05R\tbipErrors\x12\x1d\n" +
	"\tbip_units\x18\a \x01(\x06H\x06R\bbipUnits\x124\n" +
	"\x15fec_corrected_symbols\x18\b \x01(\x06H\aR\x13fecCorrectedSymbols\x128\n" +
	"\x17fec_codewords_corrected\x18\t \x01(\x06H\bR\x15fecCodewordsCorrected\x12@\n" +
	"\x1bfec_codewords_uncorrectable\x18\n" +
	" \x01(\x06H\tR\x19fecCodewordsUncorrectable\x12%\n" +
	"\rfec_codewords\x18\v \x01(\x06H\n" +
	"R\ffecCodewords\x120\n" +
	"\x13fec_corrected_units\x18\f \x01(\x06H\vR\x11fecCorrectedUnits\x12(\n" +
	"\x0fxgem_key_errors\x18\r \x01(\x06H\fR\rxgemKeyErrors\x12\x1d\n" +
	"\txgem_loss\x18\x0e \x01(\x06H\rR\bxgemLoss\x12(\n" +
	"\x0frx_ploams_error\x18\x0f \x01(\x06H\x0eR\rrxPloamsError\x12-\n" +
	"\x12rx_ploams_non_idle\x18\x10 \x01(\x06H\x0fR\x0frxPloamsNonIdle\x12\x19\n" +
	"\arx_omci\x18\x11 \x01(\x06H\x10R\x06rxOmci\x12\x19\n" +
	"\atx_omci\x18\x12 \x01(\x06H\x11R\x06txOmci\x12:\n" +
	"\x19rx_omci_packets_crc_error\x18\x13 \x01(\x06H\x12R\x15rxOmciPacketsCrcError\x12\x1b\n" +
	"\brx_bytes\x18\x14 \x01(\x06H\x13R\arxBytes\x12\x1f\n" +
	"\n" +
	"rx_packets\x18\x15 \x01(\x06H\x14R\trxPackets\x12\x1b\n" +
	"\btx_bytes\x18\x16 \x01(\x06H\x15R\atxBytes\x12\x1f\n" +
	"\n" +
	"tx_packets\x18\x17 \x01(\x06H\x16R\ttxPackets\x12#\n" +
	"\fber_reported\x18\x18 \x01(\x06H\x17R\vberReported\x12!\n" +
	"\vlcdg_errors\x18\x19 \x01(\x06H\x18R\n" +
	"lcdgErrors\x12\x1f\n" +
	"\n" +
	"rdi_errors\x18\x1a \x01(\x06H\x19R\trdiErrors\x12\x1e\n" +
	"\ttimestamp\x18\x1b \x01(\aH\x1aR\ttimestamp\x12\x1f\n" +
	"\n" +
	"hec_errors\x18\x1c \x01(\x06H\x1bR\thecErrorsB\f\n" +
	"\n" +
	"is_intf_idB\v\n" +
	"\tis_onu_idB\x13\n" +
	"\x11is_positive_driftB\x13\n" +
	"\x11is_negative_driftB\x1d\n" +
	"\x1bis_delimiter_miss_detectionB\x0f\n" +
	"\ris_bip_errorsB\x0e\n" +
	"\fis_bip_unitsB\x1a\n" +
	"\x18is_fec_corrected_symbolsB\x1c\n" +
	"\x1ais_fec_codewords_correctedB \n" +
	"\x1eis_fec_codewords_uncorrectableB\x12\n" +
	"\x10is_fec_codewordsB\x18\n" +
	"\x16is_fec_corrected_unitsB\x14\n" +
	"\x12is_xgem_key_errorsB\x0e\n" +
	"\fis_xgem_lossB\x14\n" +
	"\x12is_rx_ploams_errorB\x17\n" +
	"\x15is_rx_ploams_non_idleB\f\n" +
	"\n" +
	"is_rx_omciB\f\n" +
	"\n" +
	"is_tx_omciB\x1e\n" +
	"\x1cis_rx_omci_packets_crc_errorB\r\n" +
	"\vis_rx_bytesB\x0f\n" +
	"\ris_rx_packetsB\r\n" +
	"\vis_tx_bytesB\x0f\n" +
	"\ris_tx_packetsB\x11\n" +
	"\x0fis_ber_reportedB\x10\n" +
	"\x0eis_lcdg_errorsB\x0f\n" +
	"\ris_rdi_errorsB\x0e\n" +
	"\fis_timestampB\x0f\n" +
	"\ris_hec_errors\"\x8c\x05\n" +
	"\x1bOmciEthernetFrameExtendedPm\x12\x1f\n" +
	"\vdrop_events\x18\x01 \x01(\x06R\n" +
	"dropEvents\x12\x16\n" +
	"\x06octets\x18\x02 \x01(\x06R\x06octets\x12\x16\n" +
	"\x06frames\x18\x03 \x01(\x06R\x06frames\x12)\n" +
	"\x10broadcast_frames\x18\x04 \x01(\x06R\x0fbroadcastFrames\x12)\n" +
	"\x10multicast_frames\x18\x05 \x01(\x06R\x0fmulticastFrames\x12,\n" +
	"\x12crc_errored_frames\x18\x06 \x01(\x06R\x10crcErroredFrames\x12)\n" +
	"\x10undersize_frames\x18\a \x01(\x06R\x0fundersizeFrames\x12'\n" +
	"\x0foversize_frames\x18\b \x01(\x06R\x0eoversizeFrames\x12(\n" +
	"\x10frames_64_octets\x18\t \x01(\x06R\x0eframes64Octets\x124\n" +
	"\x17frames_65_to_127_octets\x18\n" +
	" \x01(\x06R\x13frames65To127Octets\x126\n" +
	"\x18frames_128_to_255_octets\x18\v \x01(\x06R\x14frames128To255Octets\x126\n" +
	"\x18frames_256_to_511_octets\x18\f \x01(\x06R\x14frames256To511Octets\x128\n" +
	"\x19frames_512_to_1023_octets\x18\r \x01(\x06R\x15frames512To1023Octets\x12:\n" +
	"\x1aframes_1024_to_1518_octets\x18\x0e \x01(\x06R\x16frames1024To1518Octets\"\xf4\x02\n" +
	"&GetOmciEthernetFrameExtendedPmResponse\x12B\n" +
	"\bupstream\x18\x01 \x01(\v2&.extension.OmciEthernetFrameExtendedPmR\bupstream\x12F\n" +
	"\n" +
	"downstream\x18\x02 \x01(\v2&.extension.OmciEthernetFrameExtendedPmR\n" +
	"downstream\x12\x8b\x01\n" +
	"&omci_ethernet_frame_extended_pm_format\x18\x03 \x01(\x0e28.extension.GetOmciEthernetFrameExtendedPmResponse.FormatR!omciEthernetFrameExtendedPmFormat\"0\n" +
	"\x06Format\x12\x12\n" +
	"\x0eTHIRTY_TWO_BIT\x10\x00\x12\x12\n" +
	"\x0eSIXTY_FOUR_BIT\x10\x01\"t\n" +
	"\aRxPower\x12\x15\n" +
	"\x06onu_sn\x18\x01 \x01(\tR\x05onuSn\x12\x16\n" +
	"\x06status\x18\x02 \x01(\tR\x06status\x12\x1f\n" +
	"\vfail_reason\x18\x03 \x01(\tR\n" +
	"failReason\x12\x19\n" +
	"\brx_power\x18\x04 \x01(\x01R\arxPower\"e\n" +
	"\x15GetOltRxPowerResponse\x12\x1d\n" +
	"\n" +
	"port_label\x18\x01 \x01(\tR\tportLabel\x12-\n" +
	"\brx_power\x18\x02 \x03(\v2\x12.extension.RxPowerR\arxPower\"\x98\x01\n" +
	"\x12GetRxPowerResponse\x12\x17\n" +
	"\aintf_id\x18\x01 \x01(\aR\x06intfId\x12\x15\n" +
	"\x06onu_id\x18\x02 \x01(\aR\x05onuId\x12\x16\n" +
	"\x06status\x18\x03 \x01(\tR\x06status\x12\x1f\n" +
	"\vfail_reason\x18\x04 \x01(\tR\n" +
	"failReason\x12\x19\n" +
	"\brx_power\x18\x05 \x01(\x01R\arxPower\"J\n" +
	"\x1aGetOnuOmciTxRxStatsRequest\x12,\n" +
	"\x05empty\x18\x01 \x01(\v2\x16.google.protobuf.EmptyR\x05empty\"\xf1\x03\n" +
	"\x1bGetOnuOmciTxRxStatsResponse\x12)\n" +
	"\x11base_tx_ar_frames\x18\x01 \x01(\rR\x0ebaseTxArFrames\x12)\n" +
	"\x11base_rx_ak_frames\x18\x02 \x01(\rR\x0ebaseRxAkFrames\x12.\n" +
	"\x14base_tx_no_ar_frames\x18\x03 \x01(\rR\x10baseTxNoArFrames\x12.\n" +
	"\x14base_rx_no_ak_frames\x18\x04 \x01(\rR\x10baseRxNoAkFrames\x12'\n" +
	"\x10ext_tx_ar_frames\x18\x05 \x01(\rR\rextTxArFrames\x12'\n" +
	"\x10ext_rx_ak_frames\x18\x06 \x01(\rR\rextRxAkFrames\x12,\n" +
	"\x13ext_tx_no_ar_frames\x18\a \x01(\rR\x0fextTxNoArFrames\x12,\n" +
	"\x13ext_rx_no_ak_frames\x18\b \x01(\rR\x0fextRxNoAkFrames\x125\n" +
	"\x17tx_omci_counter_retries\x18\t \x01(\rR\x14txOmciCounterRetries\x127\n" +
	"\x18tx_omci_counter_timeouts\x18\n" +
	" \x01(\rR\x15txOmciCounterTimeouts\"M\n" +
	"\x1dGetOnuOmciActiveAlarmsRequest\x12,\n" +
	"\x05empty\x18\x01 \x01(\v2\x16.google.protobuf.EmptyR\x05empty\"}\n" +
	"\tAlarmData\x12\x19\n" +
	"\bclass_id\x18\x01 \x01(\rR\aclassId\x12\x1f\n" +
	"\vinstance_id\x18\x02 \x01(\rR\n" +
	"instanceId\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x04 \x01(\tR\vdescription\"[\n" +
	"\x1eGetOnuOmciActiveAlarmsResponse\x129\n" +
	"\ractive_alarms\x18\x01 \x03(\v2\x14.extension.AlarmDataR\factiveAlarms\"\xc2\x01\n" +
	"!GetOffloadedAppsStatisticsRequest\x12U\n" +
	"\bstatsFor\x18\x01 \x01(\x0e29.extension.GetOffloadedAppsStatisticsRequest.OffloadedAppR\bstatsFor\"F\n" +
	"\fOffloadedApp\x12\r\n" +
	"\tUNDEFINED\x10\x00\x12\v\n" +
	"\aPPPoeIA\x10\x01\x12\f\n" +
	"\bDHCPv4RA\x10\x02\x12\f\n" +
	"\bDHCPv6RA\x10\x03\"\x8b\x16\n" +
	"\"GetOffloadedAppsStatisticsResponse\x12c\n" +
	"\rdhcpv4RaStats\x18\x01 \x01(\v2;.extension.GetOffloadedAppsStatisticsResponse.DHCPv4RAStatsH\x00R\rdhcpv4RaStats\x12c\n" +
	"\rdhcpv6RaStats\x18\x02 \x01(\v2;.extension.GetOffloadedAppsStatisticsResponse.DHCPv6RAStatsH\x00R\rdhcpv6RaStats\x12`\n" +
	"\fpppoeIaStats\x18\x03 \x01(\v2:.extension.GetOffloadedAppsStatisticsResponse.PPPoeIAStatsH\x00R\fpppoeIaStats\x1a\xfb\x05\n" +
	"\rDHCPv4RAStats\x12:\n" +
	"\x1ain_bad_packets_from_client\x18\x01 \x01(\rR\x16inBadPacketsFromClient\x12:\n" +
	"\x1ain_bad_packets_from_server\x18\x02 \x01(\rR\x16inBadPacketsFromServer\x123\n" +
	"\x16in_packets_from_client\x18\x03 \x01(\rR\x13inPacketsFromClient\x123\n" +
	"\x16in_packets_from_server\x18\x04 \x01(\rR\x13inPacketsFromServer\x121\n" +
	"\x15out_packets_to_server\x18\x05 \x01(\rR\x12outPacketsToServer\x121\n" +
	"\x15out_packets_to_client\x18\x06 \x01(\rR\x12outPacketsToClient\x12M\n" +
	"$option_82_inserted_packets_to_server\x18\a \x01(\rR\x1foption82InsertedPacketsToServer\x12K\n" +
	"#option_82_removed_packets_to_client\x18\b \x01(\rR\x1eoption82RemovedPacketsToClient\x12E\n" +
	" option_82_not_inserted_to_server\x18\t \x01(\rR\x1boption82NotInsertedToServer\x12{\n" +
	"\x10additional_stats\x18\n" +
	" \x03(\v2P.extension.GetOffloadedAppsStatisticsResponse.DHCPv4RAStats.AdditionalStatsEntryR\x0fadditionalStats\x1aB\n" +
	"\x14AdditionalStatsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a\xf5\x06\n" +
	"\rDHCPv6RAStats\x12:\n" +
	"\x1ain_bad_packets_from_client\x18\x01 \x01(\rR\x16inBadPacketsFromClient\x12:\n" +
	"\x1ain_bad_packets_from_server\x18\x02 \x01(\rR\x16inBadPacketsFromServer\x12M\n" +
	"$option_17_inserted_packets_to_server\x18\x03 \x01(\rR\x1foption17InsertedPacketsToServer\x12K\n" +
	"#option_17_removed_packets_to_client\x18\x04 \x01(\rR\x1eoption17RemovedPacketsToClient\x12M\n" +
	"$option_18_inserted_packets_to_server\x18\x05 \x01(\rR\x1foption18InsertedPacketsToServer\x12K\n" +
	"#option_18_removed_packets_to_client\x18\x06 \x01(\rR\x1eoption18RemovedPacketsToClient\x12M\n" +
	"$option_37_inserted_packets_to_server\x18\a \x01(\rR\x1foption37InsertedPacketsToServer\x12K\n" +
	"#option_37_removed_packets_to_client\x18\b \x01(\rR\x1eoption37RemovedPacketsToClient\x12W\n" +
	")outgoing_mtu_exceeded_packets_from_client\x18\t \x01(\rR$outgoingMtuExceededPacketsFromClient\x12{\n" +
	"\x10additional_stats\x18\n" +
	" \x03(\v2P.extension.GetOffloadedAppsStatisticsResponse.DHCPv6RAStats.AdditionalStatsEntryR\x0fadditionalStats\x1aB\n" +
	"\x14AdditionalStatsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a\xb9\x06\n" +
	"\fPPPoeIAStats\x12>\n" +
	"\x1cin_error_packets_from_client\x18\x01 \x01(\rR\x18inErrorPacketsFromClient\x12>\n" +
	"\x1cin_error_packets_from_server\x18\x02 \x01(\rR\x18inErrorPacketsFromServer\x123\n" +
	"\x16in_packets_from_client\x18\x03 \x01(\rR\x13inPacketsFromClient\x123\n" +
	"\x16in_packets_from_server\x18\x04 \x01(\rR\x13inPacketsFromServer\x121\n" +
	"\x15out_packets_to_server\x18\x05 \x01(\rR\x12outPacketsToServer\x121\n" +
	"\x15out_packets_to_client\x18\x06 \x01(\rR\x12outPacketsToClient\x12`\n" +
	".vendor_specific_tag_inserted_packets_to_server\x18\a \x01(\rR(vendorSpecificTagInsertedPacketsToServer\x12^\n" +
	"-vendor_specific_tag_removed_packets_to_client\x18\b \x01(\rR'vendorSpecificTagRemovedPacketsToClient\x12W\n" +
	")outgoing_mtu_exceeded_packets_from_client\x18\t \x01(\rR$outgoingMtuExceededPacketsFromClient\x12z\n" +
	"\x10additional_stats\x18\n" +
	" \x03(\v2O.extension.GetOffloadedAppsStatisticsResponse.PPPoeIAStats.AdditionalStatsEntryR\x0fadditionalStats\x1aB\n" +
	"\x14AdditionalStatsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\a\n" +
	"\x05stats\"\xf8\t\n" +
	"\x0fGetValueRequest\x12;\n" +
	"\bdistance\x18\x01 \x01(\v2\x1d.extension.GetDistanceRequestH\x00R\bdistance\x12;\n" +
	"\auniInfo\x18\x02 \x01(\v2\x1f.extension.GetOnuUniInfoRequestH\x00R\auniInfo\x12A\n" +
	"\voltPortInfo\x18\x03 \x01(\v2\x1d.extension.GetOltPortCountersH\x00R\voltPortInfo\x12I\n" +
	"\x0eonuOpticalInfo\x18\x04 \x01(\v2\x1f.extension.GetOnuPonOpticalInfoH\x00R\x0eonuOpticalInfo\x12R\n" +
	"\rethBridgePort\x18\x05 \x01(\v2*.extension.GetOnuEthernetBridgePortHistoryH\x00R\rethBridgePort\x12=\n" +
	"\n" +
	"fecHistory\x18\x06 \x01(\v2\x1b.extension.GetOnuFecHistoryH\x00R\n" +
	"fecHistory\x12B\n" +
	"\n" +
	"onuPonInfo\x18\a \x01(\v2 .extension.GetOnuCountersRequestH\x00R\n" +
	"onuPonInfo\x12L\n" +
	"\aonuInfo\x18\b \x01(\v20.extension.GetOmciEthernetFrameExtendedPmRequestH\x00R\aonuInfo\x128\n" +
	"\arxPower\x18\t \x01(\v2\x1c.extension.GetRxPowerRequestH\x00R\arxPower\x12K\n" +
	"\fonuOmciStats\x18\n" +
	" \x01(\v2%.extension.GetOnuOmciTxRxStatsRequestH\x00R\fonuOmciStats\x12A\n" +
	"\n" +
	"oltRxPower\x18\v \x01(\v2\x1f.extension.GetOltRxPowerRequestH\x00R\n" +
	"oltRxPower\x12T\n" +
	"\x0fonuActiveAlarms\x18\f \x01(\v2(.extension.GetOnuOmciActiveAlarmsRequestH\x00R\x0fonuActiveAlarms\x12^\n" +
	"\x12offloadedAppsStats\x18\r \x01(\v2,.extension.GetOffloadedAppsStatisticsRequestH\x00R\x12offloadedAppsStats\x12U\n" +
	"\x10onuAllocGemStats\x18\x0e \x01(\v2'.extension.GetOnuAllocGemHistoryRequestH\x00R\x10onuAllocGemStats\x12P\n" +
	"\x0fonuStatsFromOlt\x18\x0f \x01(\v2$.extension.GetOnuStatsFromOltRequestH\x00R\x0fonuStatsFromOlt\x12A\n" +
	"\voltPonStats\x18\x10 \x01(\v2\x1d.extension.GetPonStatsRequestH\x00R\voltPonStats\x12A\n" +
	"\voltNniStats\x18\x11 \x01(\v2\x1d.extension.GetNNIStatsRequestH\x00R\voltNniStatsB\t\n" +
	"\arequest\"\xe7\r\n" +
	"\x10GetValueResponse\x12:\n" +
	"\x06status\x18\x01 \x01(\x0e2\".extension.GetValueResponse.StatusR\x06status\x12E\n" +
	"\terrReason\x18\x02 \x01(\x0e2'.extension.GetValueResponse.ErrorReasonR\terrReason\x12<\n" +
	"\bdistance\x18\x03 \x01(\v2\x1e.extension.GetDistanceResponseH\x00R\bdistance\x12<\n" +
	"\auniInfo\x18\x04 \x01(\v2 .extension.GetOnuUniInfoResponseH\x00R\auniInfo\x12K\n" +
	"\fportCoutners\x18\x05 \x01(\v2%.extension.GetOltPortCountersResponseH\x00R\fportCoutners\x12Q\n" +
	"\x0eonuOpticalInfo\x18\x06 \x01(\v2'.extension.GetOnuPonOpticalInfoResponseH\x00R\x0eonuOpticalInfo\x12b\n" +
	"\x11ethBridgePortInfo\x18\a \x01(\v22.extension.GetOnuEthernetBridgePortHistoryResponseH\x00R\x11ethBridgePortInfo\x12E\n" +
	"\n" +
	"fecHistory\x18\b \x01(\v2#.extension.GetOnuFecHistoryResponseH\x00R\n" +
	"fecHistory\x12K\n" +
	"\x0eonuPonCounters\x18\t \x01(\v2!.extension.GetOnuCountersResponseH\x00R\x0eonuPonCounters\x12U\n" +
	"\vonuCounters\x18\n" +
	" \x01(\v21.extension.GetOmciEthernetFrameExtendedPmResponseH\x00R\vonuCounters\x129\n" +
	"\arxPower\x18\v \x01(\v2\x1d.extension.GetRxPowerResponseH\x00R\arxPower\x12L\n" +
	"\fonuOmciStats\x18\f \x01(\v2&.extension.GetOnuOmciTxRxStatsResponseH\x00R\fonuOmciStats\x12B\n" +
	"\n" +
	"oltRxPower\x18\r \x01(\v2 .extension.GetOltRxPowerResponseH\x00R\n" +
	"oltRxPower\x12U\n" +
	"\x0fonuActiveAlarms\x18\x0e \x01(\v2).extension.GetOnuOmciActiveAlarmsResponseH\x00R\x0fonuActiveAlarms\x12_\n" +
	"\x12offloadedAppsStats\x18\x0f \x01(\v2-.extension.GetOffloadedAppsStatisticsResponseH\x00R\x12offloadedAppsStats\x12f\n" +
	"\x18onuAllocGemStatsResponse\x18\x10 \x01(\v2(.extension.GetOnuAllocGemHistoryResponseH\x00R\x18onuAllocGemStatsResponse\x12a\n" +
	"\x17onuStatsFromOltResponse\x18\x11 \x01(\v2%.extension.GetOnuStatsFromOltResponseH\x00R\x17onuStatsFromOltResponse\x12R\n" +
	"\x13oltPonStatsResponse\x18\x12 \x01(\v2\x1e.extension.GetPonStatsResponseH\x00R\x13oltPonStatsResponse\x12R\n" +
	"\x13oltNniStatsResponse\x18\x13 \x01(\v2\x1e.extension.GetNNIStatsResponseH\x00R\x13oltNniStatsResponse\"1\n" +
	"\x06Status\x12\x14\n" +
	"\x10STATUS_UNDEFINED\x10\x00\x12\x06\n" +
	"\x02OK\x10\x01\x12\t\n" +
	"\x05ERROR\x10\x02\"\xad\x01\n" +
	"\vErrorReason\x12\x14\n" +
	"\x10REASON_UNDEFINED\x10\x00\x12\x0f\n" +
	"\vUNSUPPORTED\x10\x01\x12\x15\n" +
	"\x11INVALID_DEVICE_ID\x10\x02\x12\x15\n" +
	"\x11INVALID_PORT_TYPE\x10\x03\x12\v\n" +
	"\aTIMEOUT\x10\x04\x12\x14\n" +
	"\x10INVALID_REQ_TYPE\x10\x05\x12\x12\n" +
	"\x0eINTERNAL_ERROR\x10\x06\x12\x12\n" +
	"\x0eINVALID_DEVICE\x10\aB\n" +
	"\n" +
	"\bresponse\"\xac\x01\n" +
	"\x10AppOffloadConfig\x12&\n" +
	"\x0eenableDHCPv4RA\x18\x01 \x01(\bR\x0eenableDHCPv4RA\x12&\n" +
	"\x0eenableDHCPv6RA\x18\x02 \x01(\bR\x0eenableDHCPv6RA\x12$\n" +
	"\renablePPPoEIA\x18\x03 \x01(\bR\renablePPPoEIA\x12\"\n" +
	"\faccessNodeID\x18\x04 \x01(\tR\faccessNodeID\"\xfe\x01\n" +
	"\x13AppOffloadOnuConfig\x12 \n" +
	"\vonuDeviceId\x18\x01 \x01(\tR\vonuDeviceId\x12K\n" +
	"\n" +
	"perUniInfo\x18\x05 \x03(\v2+.extension.AppOffloadOnuConfig.PerUniConfigR\n" +
	"perUniInfo\x1ax\n" +
	"\fPerUniConfig\x12$\n" +
	"\ragentRemoteID\x18\x02 \x01(\tR\ragentRemoteID\x12&\n" +
	"\x0eagentCircuitID\x18\x03 \x01(\tR\x0eagentCircuitID\x12\x1a\n" +
	"\bonuUniId\x18\x04 \x01(\rR\bonuUniId\"\xfa\x01\n" +
	"\x0fSetValueRequest\x128\n" +
	"\falarm_config\x18\x01 \x01(\v2\x13.config.AlarmConfigH\x00R\valarmConfig\x12K\n" +
	"\x12app_offload_config\x18\x02 \x01(\v2\x1b.extension.AppOffloadConfigH\x00R\x10appOffloadConfig\x12U\n" +
	"\x16app_offload_onu_config\x18\x03 \x01(\v2\x1e.extension.AppOffloadOnuConfigH\x00R\x13appOffloadOnuConfigB\t\n" +
	"\arequest\"\xc4\x02\n" +
	"\x10SetValueResponse\x12:\n" +
	"\x06status\x18\x01 \x01(\x0e2\".extension.SetValueResponse.StatusR\x06status\x12E\n" +
	"\terrReason\x18\x02 \x01(\x0e2'.extension.SetValueResponse.ErrorReasonR\terrReason\"1\n" +
	"\x06Status\x12\x14\n" +
	"\x10STATUS_UNDEFINED\x10\x00\x12\x06\n" +
	"\x02OK\x10\x01\x12\t\n" +
	"\x05ERROR\x10\x02\"z\n" +
	"\vErrorReason\x12\x14\n" +
	"\x10REASON_UNDEFINED\x10\x00\x12\x0f\n" +
	"\vUNSUPPORTED\x10\x01\x12\x15\n" +
	"\x11INVALID_DEVICE_ID\x10\x02\x12\x19\n" +
	"\x15INVALID_ONU_DEVICE_ID\x10\x03\x12\x12\n" +
	"\x0eINVALID_UNI_ID\x10\x04\"i\n" +
	"\x15SingleGetValueRequest\x12\x1a\n" +
	"\btargetId\x18\x01 \x01(\tR\btargetId\x124\n" +
	"\arequest\x18\x02 \x01(\v2\x1a.extension.GetValueRequestR\arequest\"Q\n" +
	"\x16SingleGetValueResponse\x127\n" +
	"\bresponse\x18\x01 \x01(\v2\x1b.extension.GetValueResponseR\bresponse\"i\n" +
	"\x15SingleSetValueRequest\x12\x1a\n" +
	"\btargetId\x18\x01 \x01(\tR\btargetId\x124\n" +
	"\arequest\x18\x02 \x01(\v2\x1a.extension.SetValueRequestR\arequest\"Q\n" +
	"\x16SingleSetValueResponse\x127\n" +
	"\bresponse\x18\x01 \x01(\v2\x1b.extension.SetValueResponseR\bresponse2\xb3\x01\n" +
	"\tExtension\x12R\n" +
	"\vGetExtValue\x12 .extension.SingleGetValueRequest\x1a!.extension.SingleGetValueResponse\x12R\n" +
	"\vSetExtValue\x12 .extension.SingleSetValueRequest\x1a!.extension.SingleSetValueResponseBR\n" +
	"\x1dorg.opencord.voltha.extensionZ1github.com/opencord/voltha-protos/v5/go/extensionb\x06proto3"

var (
	file_voltha_protos_extensions_proto_rawDescOnce sync.Once
	file_voltha_protos_extensions_proto_rawDescData []byte
)

func file_voltha_protos_extensions_proto_rawDescGZIP() []byte {
	file_voltha_protos_extensions_proto_rawDescOnce.Do(func() {
		file_voltha_protos_extensions_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_voltha_protos_extensions_proto_rawDesc), len(file_voltha_protos_extensions_proto_rawDesc)))
	})
	return file_voltha_protos_extensions_proto_rawDescData
}

var file_voltha_protos_extensions_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_voltha_protos_extensions_proto_msgTypes = make([]protoimpl.MessageInfo, 64)
var file_voltha_protos_extensions_proto_goTypes = []any{
	(ValueType_Type)(0),                                      // 0: extension.ValueType.Type
	(GetOnuUniInfoResponse_ConfigurationInd)(0),              // 1: extension.GetOnuUniInfoResponse.ConfigurationInd
	(GetOnuUniInfoResponse_AdministrativeState)(0),           // 2: extension.GetOnuUniInfoResponse.AdministrativeState
	(GetOnuUniInfoResponse_OperationalState)(0),              // 3: extension.GetOnuUniInfoResponse.OperationalState
	(GetOltPortCounters_PortType)(0),                         // 4: extension.GetOltPortCounters.PortType
	(GetOnuEthernetBridgePortHistory_Direction)(0),           // 5: extension.GetOnuEthernetBridgePortHistory.Direction
	(GetOmciEthernetFrameExtendedPmResponse_Format)(0),       // 6: extension.GetOmciEthernetFrameExtendedPmResponse.Format
	(GetOffloadedAppsStatisticsRequest_OffloadedApp)(0),      // 7: extension.GetOffloadedAppsStatisticsRequest.OffloadedApp
	(GetValueResponse_Status)(0),                             // 8: extension.GetValueResponse.Status
	(GetValueResponse_ErrorReason)(0),                        // 9: extension.GetValueResponse.ErrorReason
	(SetValueResponse_Status)(0),                             // 10: extension.SetValueResponse.Status
	(SetValueResponse_ErrorReason)(0),                        // 11: extension.SetValueResponse.ErrorReason
	(*ValueSet)(nil),                                         // 12: extension.ValueSet
	(*ValueType)(nil),                                        // 13: extension.ValueType
	(*ValueSpecifier)(nil),                                   // 14: extension.ValueSpecifier
	(*ReturnValues)(nil),                                     // 15: extension.ReturnValues
	(*GetDistanceRequest)(nil),                               // 16: extension.GetDistanceRequest
	(*GetDistanceResponse)(nil),                              // 17: extension.GetDistanceResponse
	(*GetOnuUniInfoRequest)(nil),                             // 18: extension.GetOnuUniInfoRequest
	(*GetOnuUniInfoResponse)(nil),                            // 19: extension.GetOnuUniInfoResponse
	(*GetOltPortCounters)(nil),                               // 20: extension.GetOltPortCounters
	(*GetOltPortCountersResponse)(nil),                       // 21: extension.GetOltPortCountersResponse
	(*GetOnuPonOpticalInfo)(nil),                             // 22: extension.GetOnuPonOpticalInfo
	(*GetOnuPonOpticalInfoResponse)(nil),                     // 23: extension.GetOnuPonOpticalInfoResponse
	(*GetOnuEthernetBridgePortHistory)(nil),                  // 24: extension.GetOnuEthernetBridgePortHistory
	(*GetOnuEthernetBridgePortHistoryResponse)(nil),          // 25: extension.GetOnuEthernetBridgePortHistoryResponse
	(*GetOnuAllocGemHistoryRequest)(nil),                     // 26: extension.GetOnuAllocGemHistoryRequest
	(*OnuGemPortHistoryData)(nil),                            // 27: extension.OnuGemPortHistoryData
	(*OnuAllocHistoryData)(nil),                              // 28: extension.OnuAllocHistoryData
	(*OnuAllocGemHistoryData)(nil),                           // 29: extension.OnuAllocGemHistoryData
	(*GetOnuAllocGemHistoryResponse)(nil),                    // 30: extension.GetOnuAllocGemHistoryResponse
	(*GetOnuFecHistory)(nil),                                 // 31: extension.GetOnuFecHistory
	(*GetOnuFecHistoryResponse)(nil),                         // 32: extension.GetOnuFecHistoryResponse
	(*GetOnuCountersRequest)(nil),                            // 33: extension.GetOnuCountersRequest
	(*GetOmciEthernetFrameExtendedPmRequest)(nil),            // 34: extension.GetOmciEthernetFrameExtendedPmRequest
	(*GetRxPowerRequest)(nil),                                // 35: extension.GetRxPowerRequest
	(*GetOltRxPowerRequest)(nil),                             // 36: extension.GetOltRxPowerRequest
	(*GetPonStatsRequest)(nil),                               // 37: extension.GetPonStatsRequest
	(*GetPonStatsResponse)(nil),                              // 38: extension.GetPonStatsResponse
	(*GetNNIStatsRequest)(nil),                               // 39: extension.GetNNIStatsRequest
	(*GetNNIStatsResponse)(nil),                              // 40: extension.GetNNIStatsResponse
	(*GetOnuStatsFromOltRequest)(nil),                        // 41: extension.GetOnuStatsFromOltRequest
	(*OnuGemPortInfoFromOlt)(nil),                            // 42: extension.OnuGemPortInfoFromOlt
	(*OnuAllocIdInfoFromOlt)(nil),                            // 43: extension.OnuAllocIdInfoFromOlt
	(*OnuAllocGemStatsFromOltResponse)(nil),                  // 44: extension.OnuAllocGemStatsFromOltResponse
	(*GetOnuStatsFromOltResponse)(nil),                       // 45: extension.GetOnuStatsFromOltResponse
	(*GetOnuCountersResponse)(nil),                           // 46: extension.GetOnuCountersResponse
	(*OmciEthernetFrameExtendedPm)(nil),                      // 47: extension.OmciEthernetFrameExtendedPm
	(*GetOmciEthernetFrameExtendedPmResponse)(nil),           // 48: extension.GetOmciEthernetFrameExtendedPmResponse
	(*RxPower)(nil),                                          // 49: extension.RxPower
	(*GetOltRxPowerResponse)(nil),                            // 50: extension.GetOltRxPowerResponse
	(*GetRxPowerResponse)(nil),                               // 51: extension.GetRxPowerResponse
	(*GetOnuOmciTxRxStatsRequest)(nil),                       // 52: extension.GetOnuOmciTxRxStatsRequest
	(*GetOnuOmciTxRxStatsResponse)(nil),                      // 53: extension.GetOnuOmciTxRxStatsResponse
	(*GetOnuOmciActiveAlarmsRequest)(nil),                    // 54: extension.GetOnuOmciActiveAlarmsRequest
	(*AlarmData)(nil),                                        // 55: extension.AlarmData
	(*GetOnuOmciActiveAlarmsResponse)(nil),                   // 56: extension.GetOnuOmciActiveAlarmsResponse
	(*GetOffloadedAppsStatisticsRequest)(nil),                // 57: extension.GetOffloadedAppsStatisticsRequest
	(*GetOffloadedAppsStatisticsResponse)(nil),               // 58: extension.GetOffloadedAppsStatisticsResponse
	(*GetValueRequest)(nil),                                  // 59: extension.GetValueRequest
	(*GetValueResponse)(nil),                                 // 60: extension.GetValueResponse
	(*AppOffloadConfig)(nil),                                 // 61: extension.AppOffloadConfig
	(*AppOffloadOnuConfig)(nil),                              // 62: extension.AppOffloadOnuConfig
	(*SetValueRequest)(nil),                                  // 63: extension.SetValueRequest
	(*SetValueResponse)(nil),                                 // 64: extension.SetValueResponse
	(*SingleGetValueRequest)(nil),                            // 65: extension.SingleGetValueRequest
	(*SingleGetValueResponse)(nil),                           // 66: extension.SingleGetValueResponse
	(*SingleSetValueRequest)(nil),                            // 67: extension.SingleSetValueRequest
	(*SingleSetValueResponse)(nil),                           // 68: extension.SingleSetValueResponse
	(*GetOffloadedAppsStatisticsResponse_DHCPv4RAStats)(nil), // 69: extension.GetOffloadedAppsStatisticsResponse.DHCPv4RAStats
	(*GetOffloadedAppsStatisticsResponse_DHCPv6RAStats)(nil), // 70: extension.GetOffloadedAppsStatisticsResponse.DHCPv6RAStats
	(*GetOffloadedAppsStatisticsResponse_PPPoeIAStats)(nil),  // 71: extension.GetOffloadedAppsStatisticsResponse.PPPoeIAStats
	nil,                                      // 72: extension.GetOffloadedAppsStatisticsResponse.DHCPv4RAStats.AdditionalStatsEntry
	nil,                                      // 73: extension.GetOffloadedAppsStatisticsResponse.DHCPv6RAStats.AdditionalStatsEntry
	nil,                                      // 74: extension.GetOffloadedAppsStatisticsResponse.PPPoeIAStats.AdditionalStatsEntry
	(*AppOffloadOnuConfig_PerUniConfig)(nil), // 75: extension.AppOffloadOnuConfig.PerUniConfig
	(*config.AlarmConfig)(nil),               // 76: config.AlarmConfig
	(*emptypb.Empty)(nil),                    // 77: google.protobuf.Empty
	(*common.PortStatistics)(nil),            // 78: common.PortStatistics
}
var file_voltha_protos_extensions_proto_depIdxs = []int32{
	76, // 0: extension.ValueSet.alarm_config:type_name -> config.AlarmConfig
	0,  // 1: extension.ValueSpecifier.value:type_name -> extension.ValueType.Type
	2,  // 2: extension.GetOnuUniInfoResponse.admState:type_name -> extension.GetOnuUniInfoResponse.AdministrativeState
	3,  // 3: extension.GetOnuUniInfoResponse.operState:type_name -> extension.GetOnuUniInfoResponse.OperationalState
	1,  // 4: extension.GetOnuUniInfoResponse.configInd:type_name -> extension.GetOnuUniInfoResponse.ConfigurationInd
	4,  // 5: extension.GetOltPortCounters.portType:type_name -> extension.GetOltPortCounters.PortType
	77, // 6: extension.GetOnuPonOpticalInfo.empty:type_name -> google.protobuf.Empty
	5,  // 7: extension.GetOnuEthernetBridgePortHistory.direction:type_name -> extension.GetOnuEthernetBridgePortHistory.Direction
	77, // 8: extension.GetOnuAllocGemHistoryRequest.empty:type_name -> google.protobuf.Empty
	28, // 9: extension.OnuAllocGemHistoryData.onuAllocIdInfo:type_name -> extension.OnuAllocHistoryData
	27, // 10: extension.OnuAllocGemHistoryData.gemPortInfo:type_name -> extension.OnuGemPortHistoryData
	29, // 11: extension.GetOnuAllocGemHistoryResponse.onuAllocGemHistoryData:type_name -> extension.OnuAllocGemHistoryData
	77, // 12: extension.GetOnuFecHistory.empty:type_name -> google.protobuf.Empty
	78, // 13: extension.GetPonStatsResponse.portStatistics:type_name -> common.PortStatistics
	78, // 14: extension.GetNNIStatsResponse.portStatistics:type_name -> common.PortStatistics
	43, // 15: extension.OnuAllocGemStatsFromOltResponse.allocIdInfo:type_name -> extension.OnuAllocIdInfoFromOlt
	42, // 16: extension.OnuAllocGemStatsFromOltResponse.gemPortInfo:type_name -> extension.OnuGemPortInfoFromOlt
	44, // 17: extension.GetOnuStatsFromOltResponse.allocGemStatsInfo:type_name -> extension.OnuAllocGemStatsFromOltResponse
	47, // 18: extension.GetOmciEthernetFrameExtendedPmResponse.upstream:type_name -> extension.OmciEthernetFrameExtendedPm
	47, // 19: extension.GetOmciEthernetFrameExtendedPmResponse.downstream:type_name -> extension.OmciEthernetFrameExtendedPm
	6,  // 20: extension.GetOmciEthernetFrameExtendedPmResponse.omci_ethernet_frame_extended_pm_format:type_name -> extension.GetOmciEthernetFrameExtendedPmResponse.Format
	49, // 21: extension.GetOltRxPowerResponse.rx_power:type_name -> extension.RxPower
	77, // 22: extension.GetOnuOmciTxRxStatsRequest.empty:type_name -> google.protobuf.Empty
	77, // 23: extension.GetOnuOmciActiveAlarmsRequest.empty:type_name -> google.protobuf.Empty
	55, // 24: extension.GetOnuOmciActiveAlarmsResponse.active_alarms:type_name -> extension.AlarmData
	7,  // 25: extension.GetOffloadedAppsStatisticsRequest.statsFor:type_name -> extension.GetOffloadedAppsStatisticsRequest.OffloadedApp
	69, // 26: extension.GetOffloadedAppsStatisticsResponse.dhcpv4RaStats:type_name -> extension.GetOffloadedAppsStatisticsResponse.DHCPv4RAStats
	70, // 27: extension.GetOffloadedAppsStatisticsResponse.dhcpv6RaStats:type_name -> extension.GetOffloadedAppsStatisticsResponse.DHCPv6RAStats
	71, // 28: extension.GetOffloadedAppsStatisticsResponse.pppoeIaStats:type_name -> extension.GetOffloadedAppsStatisticsResponse.PPPoeIAStats
	16, // 29: extension.GetValueRequest.distance:type_name -> extension.GetDistanceRequest
	18, // 30: extension.GetValueRequest.uniInfo:type_name -> extension.GetOnuUniInfoRequest
	20, // 31: extension.GetValueRequest.oltPortInfo:type_name -> extension.GetOltPortCounters
	22, // 32: extension.GetValueRequest.onuOpticalInfo:type_name -> extension.GetOnuPonOpticalInfo
	24, // 33: extension.GetValueRequest.ethBridgePort:type_name -> extension.GetOnuEthernetBridgePortHistory
	31, // 34: extension.GetValueRequest.fecHistory:type_name -> extension.GetOnuFecHistory
	33, // 35: extension.GetValueRequest.onuPonInfo:type_name -> extension.GetOnuCountersRequest
	34, // 36: extension.GetValueRequest.onuInfo:type_name -> extension.GetOmciEthernetFrameExtendedPmRequest
	35, // 37: extension.GetValueRequest.rxPower:type_name -> extension.GetRxPowerRequest
	52, // 38: extension.GetValueRequest.onuOmciStats:type_name -> extension.GetOnuOmciTxRxStatsRequest
	36, // 39: extension.GetValueRequest.oltRxPower:type_name -> extension.GetOltRxPowerRequest
	54, // 40: extension.GetValueRequest.onuActiveAlarms:type_name -> extension.GetOnuOmciActiveAlarmsRequest
	57, // 41: extension.GetValueRequest.offloadedAppsStats:type_name -> extension.GetOffloadedAppsStatisticsRequest
	26, // 42: extension.GetValueRequest.onuAllocGemStats:type_name -> extension.GetOnuAllocGemHistoryRequest
	41, // 43: extension.GetValueRequest.onuStatsFromOlt:type_name -> extension.GetOnuStatsFromOltRequest
	37, // 44: extension.GetValueRequest.oltPonStats:type_name -> extension.GetPonStatsRequest
	39, // 45: extension.GetValueRequest.oltNniStats:type_name -> extension.GetNNIStatsRequest
	8,  // 46: extension.GetValueResponse.status:type_name -> extension.GetValueResponse.Status
	9,  // 47: extension.GetValueResponse.errReason:type_name -> extension.GetValueResponse.ErrorReason
	17, // 48: extension.GetValueResponse.distance:type_name -> extension.GetDistanceResponse
	19, // 49: extension.GetValueResponse.uniInfo:type_name -> extension.GetOnuUniInfoResponse
	21, // 50: extension.GetValueResponse.portCoutners:type_name -> extension.GetOltPortCountersResponse
	23, // 51: extension.GetValueResponse.onuOpticalInfo:type_name -> extension.GetOnuPonOpticalInfoResponse
	25, // 52: extension.GetValueResponse.ethBridgePortInfo:type_name -> extension.GetOnuEthernetBridgePortHistoryResponse
	32, // 53: extension.GetValueResponse.fecHistory:type_name -> extension.GetOnuFecHistoryResponse
	46, // 54: extension.GetValueResponse.onuPonCounters:type_name -> extension.GetOnuCountersResponse
	48, // 55: extension.GetValueResponse.onuCounters:type_name -> extension.GetOmciEthernetFrameExtendedPmResponse
	51, // 56: extension.GetValueResponse.rxPower:type_name -> extension.GetRxPowerResponse
	53, // 57: extension.GetValueResponse.onuOmciStats:type_name -> extension.GetOnuOmciTxRxStatsResponse
	50, // 58: extension.GetValueResponse.oltRxPower:type_name -> extension.GetOltRxPowerResponse
	56, // 59: extension.GetValueResponse.onuActiveAlarms:type_name -> extension.GetOnuOmciActiveAlarmsResponse
	58, // 60: extension.GetValueResponse.offloadedAppsStats:type_name -> extension.GetOffloadedAppsStatisticsResponse
	30, // 61: extension.GetValueResponse.onuAllocGemStatsResponse:type_name -> extension.GetOnuAllocGemHistoryResponse
	45, // 62: extension.GetValueResponse.onuStatsFromOltResponse:type_name -> extension.GetOnuStatsFromOltResponse
	38, // 63: extension.GetValueResponse.oltPonStatsResponse:type_name -> extension.GetPonStatsResponse
	40, // 64: extension.GetValueResponse.oltNniStatsResponse:type_name -> extension.GetNNIStatsResponse
	75, // 65: extension.AppOffloadOnuConfig.perUniInfo:type_name -> extension.AppOffloadOnuConfig.PerUniConfig
	76, // 66: extension.SetValueRequest.alarm_config:type_name -> config.AlarmConfig
	61, // 67: extension.SetValueRequest.app_offload_config:type_name -> extension.AppOffloadConfig
	62, // 68: extension.SetValueRequest.app_offload_onu_config:type_name -> extension.AppOffloadOnuConfig
	10, // 69: extension.SetValueResponse.status:type_name -> extension.SetValueResponse.Status
	11, // 70: extension.SetValueResponse.errReason:type_name -> extension.SetValueResponse.ErrorReason
	59, // 71: extension.SingleGetValueRequest.request:type_name -> extension.GetValueRequest
	60, // 72: extension.SingleGetValueResponse.response:type_name -> extension.GetValueResponse
	63, // 73: extension.SingleSetValueRequest.request:type_name -> extension.SetValueRequest
	64, // 74: extension.SingleSetValueResponse.response:type_name -> extension.SetValueResponse
	72, // 75: extension.GetOffloadedAppsStatisticsResponse.DHCPv4RAStats.additional_stats:type_name -> extension.GetOffloadedAppsStatisticsResponse.DHCPv4RAStats.AdditionalStatsEntry
	73, // 76: extension.GetOffloadedAppsStatisticsResponse.DHCPv6RAStats.additional_stats:type_name -> extension.GetOffloadedAppsStatisticsResponse.DHCPv6RAStats.AdditionalStatsEntry
	74, // 77: extension.GetOffloadedAppsStatisticsResponse.PPPoeIAStats.additional_stats:type_name -> extension.GetOffloadedAppsStatisticsResponse.PPPoeIAStats.AdditionalStatsEntry
	65, // 78: extension.Extension.GetExtValue:input_type -> extension.SingleGetValueRequest
	67, // 79: extension.Extension.SetExtValue:input_type -> extension.SingleSetValueRequest
	66, // 80: extension.Extension.GetExtValue:output_type -> extension.SingleGetValueResponse
	68, // 81: extension.Extension.SetExtValue:output_type -> extension.SingleSetValueResponse
	80, // [80:82] is the sub-list for method output_type
	78, // [78:80] is the sub-list for method input_type
	78, // [78:78] is the sub-list for extension type_name
	78, // [78:78] is the sub-list for extension extendee
	0,  // [0:78] is the sub-list for field type_name
}

func init() { file_voltha_protos_extensions_proto_init() }
func file_voltha_protos_extensions_proto_init() {
	if File_voltha_protos_extensions_proto != nil {
		return
	}
	file_voltha_protos_extensions_proto_msgTypes[0].OneofWrappers = []any{
		(*ValueSet_AlarmConfig)(nil),
	}
	file_voltha_protos_extensions_proto_msgTypes[22].OneofWrappers = []any{
		(*GetOmciEthernetFrameExtendedPmRequest_UniIndex)(nil),
	}
	file_voltha_protos_extensions_proto_msgTypes[25].OneofWrappers = []any{
		(*GetPonStatsRequest_PortLabel)(nil),
		(*GetPonStatsRequest_PortId)(nil),
	}
	file_voltha_protos_extensions_proto_msgTypes[27].OneofWrappers = []any{
		(*GetNNIStatsRequest_PortLabel)(nil),
		(*GetNNIStatsRequest_PortId)(nil),
	}
	file_voltha_protos_extensions_proto_msgTypes[34].OneofWrappers = []any{
		(*GetOnuCountersResponse_IntfId)(nil),
		(*GetOnuCountersResponse_OnuId)(nil),
		(*GetOnuCountersResponse_PositiveDrift)(nil),
		(*GetOnuCountersResponse_NegativeDrift)(nil),
		(*GetOnuCountersResponse_DelimiterMissDetection)(nil),
		(*GetOnuCountersResponse_BipErrors)(nil),
		(*GetOnuCountersResponse_BipUnits)(nil),
		(*GetOnuCountersResponse_FecCorrectedSymbols)(nil),
		(*GetOnuCountersResponse_FecCodewordsCorrected)(nil),
		(*GetOnuCountersResponse_FecCodewordsUncorrectable)(nil),
		(*GetOnuCountersResponse_FecCodewords)(nil),
		(*GetOnuCountersResponse_FecCorrectedUnits)(nil),
		(*GetOnuCountersResponse_XgemKeyErrors)(nil),
		(*GetOnuCountersResponse_XgemLoss)(nil),
		(*GetOnuCountersResponse_RxPloamsError)(nil),
		(*GetOnuCountersResponse_RxPloamsNonIdle)(nil),
		(*GetOnuCountersResponse_RxOmci)(nil),
		(*GetOnuCountersResponse_TxOmci)(nil),
		(*GetOnuCountersResponse_RxOmciPacketsCrcError)(nil),
		(*GetOnuCountersResponse_RxBytes)(nil),
		(*GetOnuCountersResponse_RxPackets)(nil),
		(*GetOnuCountersResponse_TxBytes)(nil),
		(*GetOnuCountersResponse_TxPackets)(nil),
		(*GetOnuCountersResponse_BerReported)(nil),
		(*GetOnuCountersResponse_LcdgErrors)(nil),
		(*GetOnuCountersResponse_RdiErrors)(nil),
		(*GetOnuCountersResponse_Timestamp)(nil),
		(*GetOnuCountersResponse_HecErrors)(nil),
	}
	file_voltha_protos_extensions_proto_msgTypes[46].OneofWrappers = []any{
		(*GetOffloadedAppsStatisticsResponse_Dhcpv4RaStats)(nil),
		(*GetOffloadedAppsStatisticsResponse_Dhcpv6RaStats)(nil),
		(*GetOffloadedAppsStatisticsResponse_PppoeIaStats)(nil),
	}
	file_voltha_protos_extensions_proto_msgTypes[47].OneofWrappers = []any{
		(*GetValueRequest_Distance)(nil),
		(*GetValueRequest_UniInfo)(nil),
		(*GetValueRequest_OltPortInfo)(nil),
		(*GetValueRequest_OnuOpticalInfo)(nil),
		(*GetValueRequest_EthBridgePort)(nil),
		(*GetValueRequest_FecHistory)(nil),
		(*GetValueRequest_OnuPonInfo)(nil),
		(*GetValueRequest_OnuInfo)(nil),
		(*GetValueRequest_RxPower)(nil),
		(*GetValueRequest_OnuOmciStats)(nil),
		(*GetValueRequest_OltRxPower)(nil),
		(*GetValueRequest_OnuActiveAlarms)(nil),
		(*GetValueRequest_OffloadedAppsStats)(nil),
		(*GetValueRequest_OnuAllocGemStats)(nil),
		(*GetValueRequest_OnuStatsFromOlt)(nil),
		(*GetValueRequest_OltPonStats)(nil),
		(*GetValueRequest_OltNniStats)(nil),
	}
	file_voltha_protos_extensions_proto_msgTypes[48].OneofWrappers = []any{
		(*GetValueResponse_Distance)(nil),
		(*GetValueResponse_UniInfo)(nil),
		(*GetValueResponse_PortCoutners)(nil),
		(*GetValueResponse_OnuOpticalInfo)(nil),
		(*GetValueResponse_EthBridgePortInfo)(nil),
		(*GetValueResponse_FecHistory)(nil),
		(*GetValueResponse_OnuPonCounters)(nil),
		(*GetValueResponse_OnuCounters)(nil),
		(*GetValueResponse_RxPower)(nil),
		(*GetValueResponse_OnuOmciStats)(nil),
		(*GetValueResponse_OltRxPower)(nil),
		(*GetValueResponse_OnuActiveAlarms)(nil),
		(*GetValueResponse_OffloadedAppsStats)(nil),
		(*GetValueResponse_OnuAllocGemStatsResponse)(nil),
		(*GetValueResponse_OnuStatsFromOltResponse)(nil),
		(*GetValueResponse_OltPonStatsResponse)(nil),
		(*GetValueResponse_OltNniStatsResponse)(nil),
	}
	file_voltha_protos_extensions_proto_msgTypes[51].OneofWrappers = []any{
		(*SetValueRequest_AlarmConfig)(nil),
		(*SetValueRequest_AppOffloadConfig)(nil),
		(*SetValueRequest_AppOffloadOnuConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_voltha_protos_extensions_proto_rawDesc), len(file_voltha_protos_extensions_proto_rawDesc)),
			NumEnums:      12,
			NumMessages:   64,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_voltha_protos_extensions_proto_goTypes,
		DependencyIndexes: file_voltha_protos_extensions_proto_depIdxs,
		EnumInfos:         file_voltha_protos_extensions_proto_enumTypes,
		MessageInfos:      file_voltha_protos_extensions_proto_msgTypes,
	}.Build()
	File_voltha_protos_extensions_proto = out.File
	file_voltha_protos_extensions_proto_goTypes = nil
	file_voltha_protos_extensions_proto_depIdxs = nil
}
