# VOLTHA-go-controller

- Go based light-weight controller 
- Handling the control plane functionality which translates the user-configurations to system configurations
- Community Defined gRPC based communication towards voltha
- Seamless software upgrade with support for data migration

```text
                    +--------------------------+------------+--------------------------+
                    |                          | NBI (REST) |                          |
                    |                          +------------+                          |
                    |                                                                  |
                    |                      Voltha-Go-Controller          +--------+    |
                    |                                                    | VGCCTL |    |
                    |     +------------------------------------------+   +--------+    |
                    |     |               Applications               |                 |
                    |     +------------------------------------------+   +---------+   |
                    |                                                    |   NB    |   |
                    |     +------------------------------------------+   | HANDLER |   |
                    |     |                Controller                |   +---------+   |
                    |     +------------------------------------------+                 |
                    |                                                    +---------+   |
                    |     +------------------------------------------+   |   DB    |   |
                    |     |                 VPAgent                  |   | HANDLER |   |
                    |     +------------------------------------------+   | (Redis) |   |
                    |                                                    +---------+   |
                    +------------------------------------------------------------------+
                                                  |
                                                  | gRPC 
                                                  |
                              +------------------------------------------+
                              |                                          |
                              |                 Voltha                   |
                              |                                          |
                              +------------------------------------------+

```
## Features Supported:
- User Profile Configuration
- Logical Device Management
- DHCP Relay
- PPPoE Relay
- Igmp Proxy
- Periodic Audit of Flows/Groups/Meters
- CLI support for read-only access to configuration

## Interfaces Supported
- North     : REST
- South     : gRPC (community defined)
- East-West : Kafka

## NB API Details:

#### Add Meter Profile:

```
curl --request  POST -H Content-Type:application/json http://$VGC_POD_IP:8181/profiles/service1 -d @addbw.json

addbw.json:
{
            "id": "High-Speed-Internet",
            "gir": 50000,
            "cbs": 10000,
            "cir": 50000,
            "pbs": 1000,
            "pir": 300000
}
```

#### Add Service/Subscriber Info:

```
curl --request  POST -H Content-Type:application/json http://$VGC_POD_IP:8181/subscribers/service1 -d @addsub.json

addsub.json
{
  "id": "service1",
  "nasPortId": "XXXX429d750e-1",
  "uniTagList": [
    {
      "uniTagMatch": 4096,
      "ponCTag": 4096,
      "ponSTag": 140,
      "technologyProfileId": 64,
      "downstreamBandwidthProfile": "High-Speed-Internet",
      "upstreamBandwidthProfile": "High-Speed-Internet"
    }
  ]
}
```

#### Remove Service and bring down flows:
```
    curl --request  DELETE http://$VGC_POD_IP:8181/subscribers/service1
```

## CLI Support: VGCCTL

```
device      : Lists Device Info
group       : Lists configured Groups
vnet        : Lists configured VNET profiles
tasklist    : Lists TaskList
igmp        : Displays current IGMP configuration
mcast       : Displays current MCAST configuration
flows       : Lists configured flows
service     : Lists configured services
mvlan       : Lists configured MVLANs
dhcpsession : Lists DHCP Session Info
port        : Lists all the logical ports
igmpgroup   : Lists configured IGMP Groups
meter       : Lists all the meter profiles
vpvs        : Lists configured vpvs
igmpchannel : Lists configured IGMP channels
igmpport    : Lists configured IGMP ports
igmpdevice  : Lists configured IGMP devices

```

## Pre-Requisties:

Use the package manager [pip](https://pip.pypa.io/en/stable/) to install foobar.

## Compatibility:

```
Compatible goLang version: go1.16.3
Compatible Redis version: github.com/go-redis/redis/v8 v8.3.4
```

## Development Usage:

```
build                     : Build voltha-go-controller image
clean                     : Removes any local filesystem artifacts generated by a build
help                      : Print help for each Makefile target
lint-dockerfile           : Perform static analysis on Dockerfile
lint                      : Run all lint targets
lint-mod                  : Verify the Go dependencies
local-lib-go              : Copies a local version of the voltha-lib-go dependency into the vendor directory
local-protos              : Copies a local version of the voltha-protos dependency into the vendor directory
mod-update                : Update go mod files
sca                       : Runs static code analysis with the golangci-lint tool
test                      : Run unit tests
```

#### Basic build:

```bash
Clone "voltha-go-controller"
cd voltha-go-controller
go mod vendor
make clean; make build
```

## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.

Please make sure to update tests as appropriate.

## License
[APACHE](http://www.apache.org/licenses/LICENSE-2.0)
