// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/device.proto

package voltha

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	common "github.com/opencord/voltha-protos/v5/go/common"
	openflow_13 "github.com/opencord/voltha-protos/v5/go/openflow_13"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PmConfig_PmType int32

const (
	PmConfig_COUNTER PmConfig_PmType = 0
	PmConfig_GAUGE   PmConfig_PmType = 1
	PmConfig_STATE   PmConfig_PmType = 2
	PmConfig_CONTEXT PmConfig_PmType = 3
)

var PmConfig_PmType_name = map[int32]string{
	0: "COUNTER",
	1: "GAUGE",
	2: "STATE",
	3: "CONTEXT",
}

var PmConfig_PmType_value = map[string]int32{
	"COUNTER": 0,
	"GAUGE":   1,
	"STATE":   2,
	"CONTEXT": 3,
}

func (x PmConfig_PmType) String() string {
	return proto.EnumName(PmConfig_PmType_name, int32(x))
}

func (PmConfig_PmType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{2, 0}
}

type ImageDownload_ImageDownloadState int32

const (
	ImageDownload_DOWNLOAD_UNKNOWN     ImageDownload_ImageDownloadState = 0
	ImageDownload_DOWNLOAD_SUCCEEDED   ImageDownload_ImageDownloadState = 1
	ImageDownload_DOWNLOAD_REQUESTED   ImageDownload_ImageDownloadState = 2
	ImageDownload_DOWNLOAD_STARTED     ImageDownload_ImageDownloadState = 3
	ImageDownload_DOWNLOAD_FAILED      ImageDownload_ImageDownloadState = 4
	ImageDownload_DOWNLOAD_UNSUPPORTED ImageDownload_ImageDownloadState = 5
	ImageDownload_DOWNLOAD_CANCELLED   ImageDownload_ImageDownloadState = 6
)

var ImageDownload_ImageDownloadState_name = map[int32]string{
	0: "DOWNLOAD_UNKNOWN",
	1: "DOWNLOAD_SUCCEEDED",
	2: "DOWNLOAD_REQUESTED",
	3: "DOWNLOAD_STARTED",
	4: "DOWNLOAD_FAILED",
	5: "DOWNLOAD_UNSUPPORTED",
	6: "DOWNLOAD_CANCELLED",
}

var ImageDownload_ImageDownloadState_value = map[string]int32{
	"DOWNLOAD_UNKNOWN":     0,
	"DOWNLOAD_SUCCEEDED":   1,
	"DOWNLOAD_REQUESTED":   2,
	"DOWNLOAD_STARTED":     3,
	"DOWNLOAD_FAILED":      4,
	"DOWNLOAD_UNSUPPORTED": 5,
	"DOWNLOAD_CANCELLED":   6,
}

func (x ImageDownload_ImageDownloadState) String() string {
	return proto.EnumName(ImageDownload_ImageDownloadState_name, int32(x))
}

func (ImageDownload_ImageDownloadState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{6, 0}
}

type ImageDownload_ImageDownloadFailureReason int32

const (
	ImageDownload_NO_ERROR           ImageDownload_ImageDownloadFailureReason = 0
	ImageDownload_INVALID_URL        ImageDownload_ImageDownloadFailureReason = 1
	ImageDownload_DEVICE_BUSY        ImageDownload_ImageDownloadFailureReason = 2
	ImageDownload_INSUFFICIENT_SPACE ImageDownload_ImageDownloadFailureReason = 3
	ImageDownload_UNKNOWN_ERROR      ImageDownload_ImageDownloadFailureReason = 4
	ImageDownload_CANCELLED          ImageDownload_ImageDownloadFailureReason = 5
)

var ImageDownload_ImageDownloadFailureReason_name = map[int32]string{
	0: "NO_ERROR",
	1: "INVALID_URL",
	2: "DEVICE_BUSY",
	3: "INSUFFICIENT_SPACE",
	4: "UNKNOWN_ERROR",
	5: "CANCELLED",
}

var ImageDownload_ImageDownloadFailureReason_value = map[string]int32{
	"NO_ERROR":           0,
	"INVALID_URL":        1,
	"DEVICE_BUSY":        2,
	"INSUFFICIENT_SPACE": 3,
	"UNKNOWN_ERROR":      4,
	"CANCELLED":          5,
}

func (x ImageDownload_ImageDownloadFailureReason) String() string {
	return proto.EnumName(ImageDownload_ImageDownloadFailureReason_name, int32(x))
}

func (ImageDownload_ImageDownloadFailureReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{6, 1}
}

type ImageDownload_ImageActivateState int32

const (
	ImageDownload_IMAGE_UNKNOWN    ImageDownload_ImageActivateState = 0
	ImageDownload_IMAGE_INACTIVE   ImageDownload_ImageActivateState = 1
	ImageDownload_IMAGE_ACTIVATING ImageDownload_ImageActivateState = 2
	ImageDownload_IMAGE_ACTIVE     ImageDownload_ImageActivateState = 3
	ImageDownload_IMAGE_REVERTING  ImageDownload_ImageActivateState = 4
	ImageDownload_IMAGE_REVERTED   ImageDownload_ImageActivateState = 5
)

var ImageDownload_ImageActivateState_name = map[int32]string{
	0: "IMAGE_UNKNOWN",
	1: "IMAGE_INACTIVE",
	2: "IMAGE_ACTIVATING",
	3: "IMAGE_ACTIVE",
	4: "IMAGE_REVERTING",
	5: "IMAGE_REVERTED",
}

var ImageDownload_ImageActivateState_value = map[string]int32{
	"IMAGE_UNKNOWN":    0,
	"IMAGE_INACTIVE":   1,
	"IMAGE_ACTIVATING": 2,
	"IMAGE_ACTIVE":     3,
	"IMAGE_REVERTING":  4,
	"IMAGE_REVERTED":   5,
}

func (x ImageDownload_ImageActivateState) String() string {
	return proto.EnumName(ImageDownload_ImageActivateState_name, int32(x))
}

func (ImageDownload_ImageActivateState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{6, 2}
}

type ImageState_ImageDownloadState int32

const (
	ImageState_DOWNLOAD_UNKNOWN     ImageState_ImageDownloadState = 0
	ImageState_DOWNLOAD_SUCCEEDED   ImageState_ImageDownloadState = 1
	ImageState_DOWNLOAD_REQUESTED   ImageState_ImageDownloadState = 2
	ImageState_DOWNLOAD_STARTED     ImageState_ImageDownloadState = 3
	ImageState_DOWNLOAD_FAILED      ImageState_ImageDownloadState = 4
	ImageState_DOWNLOAD_UNSUPPORTED ImageState_ImageDownloadState = 5
	ImageState_DOWNLOAD_CANCELLING  ImageState_ImageDownloadState = 6
	ImageState_DOWNLOAD_CANCELLED   ImageState_ImageDownloadState = 7
)

var ImageState_ImageDownloadState_name = map[int32]string{
	0: "DOWNLOAD_UNKNOWN",
	1: "DOWNLOAD_SUCCEEDED",
	2: "DOWNLOAD_REQUESTED",
	3: "DOWNLOAD_STARTED",
	4: "DOWNLOAD_FAILED",
	5: "DOWNLOAD_UNSUPPORTED",
	6: "DOWNLOAD_CANCELLING",
	7: "DOWNLOAD_CANCELLED",
}

var ImageState_ImageDownloadState_value = map[string]int32{
	"DOWNLOAD_UNKNOWN":     0,
	"DOWNLOAD_SUCCEEDED":   1,
	"DOWNLOAD_REQUESTED":   2,
	"DOWNLOAD_STARTED":     3,
	"DOWNLOAD_FAILED":      4,
	"DOWNLOAD_UNSUPPORTED": 5,
	"DOWNLOAD_CANCELLING":  6,
	"DOWNLOAD_CANCELLED":   7,
}

func (x ImageState_ImageDownloadState) String() string {
	return proto.EnumName(ImageState_ImageDownloadState_name, int32(x))
}

func (ImageState_ImageDownloadState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{12, 0}
}

type ImageState_ImageFailureReason int32

const (
	ImageState_NO_ERROR               ImageState_ImageFailureReason = 0
	ImageState_INVALID_URL            ImageState_ImageFailureReason = 1
	ImageState_DEVICE_BUSY            ImageState_ImageFailureReason = 2
	ImageState_INSUFFICIENT_SPACE     ImageState_ImageFailureReason = 3
	ImageState_UNKNOWN_ERROR          ImageState_ImageFailureReason = 4
	ImageState_CANCELLED_ON_REQUEST   ImageState_ImageFailureReason = 5
	ImageState_CANCELLED_ON_ONU_STATE ImageState_ImageFailureReason = 6
	ImageState_VENDOR_DEVICE_MISMATCH ImageState_ImageFailureReason = 7
	ImageState_OMCI_TRANSFER_ERROR    ImageState_ImageFailureReason = 8
	ImageState_IMAGE_REFUSED_BY_ONU   ImageState_ImageFailureReason = 9
)

var ImageState_ImageFailureReason_name = map[int32]string{
	0: "NO_ERROR",
	1: "INVALID_URL",
	2: "DEVICE_BUSY",
	3: "INSUFFICIENT_SPACE",
	4: "UNKNOWN_ERROR",
	5: "CANCELLED_ON_REQUEST",
	6: "CANCELLED_ON_ONU_STATE",
	7: "VENDOR_DEVICE_MISMATCH",
	8: "OMCI_TRANSFER_ERROR",
	9: "IMAGE_REFUSED_BY_ONU",
}

var ImageState_ImageFailureReason_value = map[string]int32{
	"NO_ERROR":               0,
	"INVALID_URL":            1,
	"DEVICE_BUSY":            2,
	"INSUFFICIENT_SPACE":     3,
	"UNKNOWN_ERROR":          4,
	"CANCELLED_ON_REQUEST":   5,
	"CANCELLED_ON_ONU_STATE": 6,
	"VENDOR_DEVICE_MISMATCH": 7,
	"OMCI_TRANSFER_ERROR":    8,
	"IMAGE_REFUSED_BY_ONU":   9,
}

func (x ImageState_ImageFailureReason) String() string {
	return proto.EnumName(ImageState_ImageFailureReason_name, int32(x))
}

func (ImageState_ImageFailureReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{12, 1}
}

type ImageState_ImageActivationState int32

const (
	ImageState_IMAGE_UNKNOWN             ImageState_ImageActivationState = 0
	ImageState_IMAGE_INACTIVE            ImageState_ImageActivationState = 1
	ImageState_IMAGE_ACTIVATING          ImageState_ImageActivationState = 2
	ImageState_IMAGE_ACTIVE              ImageState_ImageActivationState = 3
	ImageState_IMAGE_COMMITTING          ImageState_ImageActivationState = 4
	ImageState_IMAGE_COMMITTED           ImageState_ImageActivationState = 5
	ImageState_IMAGE_ACTIVATION_ABORTING ImageState_ImageActivationState = 6
	ImageState_IMAGE_ACTIVATION_ABORTED  ImageState_ImageActivationState = 7
	ImageState_IMAGE_COMMIT_ABORTING     ImageState_ImageActivationState = 8
	ImageState_IMAGE_COMMIT_ABORTED      ImageState_ImageActivationState = 9
	ImageState_IMAGE_DOWNLOADING         ImageState_ImageActivationState = 10
	ImageState_IMAGE_DOWNLOADING_ABORTED ImageState_ImageActivationState = 11
)

var ImageState_ImageActivationState_name = map[int32]string{
	0:  "IMAGE_UNKNOWN",
	1:  "IMAGE_INACTIVE",
	2:  "IMAGE_ACTIVATING",
	3:  "IMAGE_ACTIVE",
	4:  "IMAGE_COMMITTING",
	5:  "IMAGE_COMMITTED",
	6:  "IMAGE_ACTIVATION_ABORTING",
	7:  "IMAGE_ACTIVATION_ABORTED",
	8:  "IMAGE_COMMIT_ABORTING",
	9:  "IMAGE_COMMIT_ABORTED",
	10: "IMAGE_DOWNLOADING",
	11: "IMAGE_DOWNLOADING_ABORTED",
}

var ImageState_ImageActivationState_value = map[string]int32{
	"IMAGE_UNKNOWN":             0,
	"IMAGE_INACTIVE":            1,
	"IMAGE_ACTIVATING":          2,
	"IMAGE_ACTIVE":              3,
	"IMAGE_COMMITTING":          4,
	"IMAGE_COMMITTED":           5,
	"IMAGE_ACTIVATION_ABORTING": 6,
	"IMAGE_ACTIVATION_ABORTED":  7,
	"IMAGE_COMMIT_ABORTING":     8,
	"IMAGE_COMMIT_ABORTED":      9,
	"IMAGE_DOWNLOADING":         10,
	"IMAGE_DOWNLOADING_ABORTED": 11,
}

func (x ImageState_ImageActivationState) String() string {
	return proto.EnumName(ImageState_ImageActivationState_name, int32(x))
}

func (ImageState_ImageActivationState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{12, 2}
}

type Port_PortType int32

const (
	Port_UNKNOWN      Port_PortType = 0
	Port_ETHERNET_NNI Port_PortType = 1
	Port_ETHERNET_UNI Port_PortType = 2
	Port_PON_OLT      Port_PortType = 3
	Port_PON_ONU      Port_PortType = 4
	Port_VENET_OLT    Port_PortType = 5
	Port_VENET_ONU    Port_PortType = 6
)

var Port_PortType_name = map[int32]string{
	0: "UNKNOWN",
	1: "ETHERNET_NNI",
	2: "ETHERNET_UNI",
	3: "PON_OLT",
	4: "PON_ONU",
	5: "VENET_OLT",
	6: "VENET_ONU",
}

var Port_PortType_value = map[string]int32{
	"UNKNOWN":      0,
	"ETHERNET_NNI": 1,
	"ETHERNET_UNI": 2,
	"PON_OLT":      3,
	"PON_ONU":      4,
	"VENET_OLT":    5,
	"VENET_ONU":    6,
}

func (x Port_PortType) String() string {
	return proto.EnumName(Port_PortType_name, int32(x))
}

func (Port_PortType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13, 0}
}

type SelfTestResponse_SelfTestResult int32

const (
	SelfTestResponse_SUCCESS       SelfTestResponse_SelfTestResult = 0
	SelfTestResponse_FAILURE       SelfTestResponse_SelfTestResult = 1
	SelfTestResponse_NOT_SUPPORTED SelfTestResponse_SelfTestResult = 2
	SelfTestResponse_UNKNOWN_ERROR SelfTestResponse_SelfTestResult = 3
)

var SelfTestResponse_SelfTestResult_name = map[int32]string{
	0: "SUCCESS",
	1: "FAILURE",
	2: "NOT_SUPPORTED",
	3: "UNKNOWN_ERROR",
}

var SelfTestResponse_SelfTestResult_value = map[string]int32{
	"SUCCESS":       0,
	"FAILURE":       1,
	"NOT_SUPPORTED": 2,
	"UNKNOWN_ERROR": 3,
}

func (x SelfTestResponse_SelfTestResult) String() string {
	return proto.EnumName(SelfTestResponse_SelfTestResult_name, int32(x))
}

func (SelfTestResponse_SelfTestResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{19, 0}
}

type SimulateAlarmRequest_OperationType int32

const (
	SimulateAlarmRequest_RAISE SimulateAlarmRequest_OperationType = 0
	SimulateAlarmRequest_CLEAR SimulateAlarmRequest_OperationType = 1
)

var SimulateAlarmRequest_OperationType_name = map[int32]string{
	0: "RAISE",
	1: "CLEAR",
}

var SimulateAlarmRequest_OperationType_value = map[string]int32{
	"RAISE": 0,
	"CLEAR": 1,
}

func (x SimulateAlarmRequest_OperationType) String() string {
	return proto.EnumName(SimulateAlarmRequest_OperationType_name, int32(x))
}

func (SimulateAlarmRequest_OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{21, 0}
}

// A Device Type
type DeviceType struct {
	// Unique name for the device type
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Unique vendor id for the device type applicable to ONU
	// 4 bytes of vendor id from ONU serial number
	VendorId  string   `protobuf:"bytes,5,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	VendorIds []string `protobuf:"bytes,6,rep,name=vendor_ids,json=vendorIds,proto3" json:"vendor_ids,omitempty"`
	// Name of the adapter that handles device type
	// Deprecated and replaced by adapterType
	Adapter string `protobuf:"bytes,2,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Capabilities
	AcceptsBulkFlowUpdate           bool `protobuf:"varint,3,opt,name=accepts_bulk_flow_update,json=acceptsBulkFlowUpdate,proto3" json:"accepts_bulk_flow_update,omitempty"`
	AcceptsAddRemoveFlowUpdates     bool `protobuf:"varint,4,opt,name=accepts_add_remove_flow_updates,json=acceptsAddRemoveFlowUpdates,proto3" json:"accepts_add_remove_flow_updates,omitempty"`
	AcceptsDirectLogicalFlowsUpdate bool `protobuf:"varint,7,opt,name=accepts_direct_logical_flows_update,json=acceptsDirectLogicalFlowsUpdate,proto3" json:"accepts_direct_logical_flows_update,omitempty"`
	// Type of adapter that can handle this device type
	AdapterType          string   `protobuf:"bytes,8,opt,name=adapter_type,json=adapterType,proto3" json:"adapter_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceType) Reset()         { *m = DeviceType{} }
func (m *DeviceType) String() string { return proto.CompactTextString(m) }
func (*DeviceType) ProtoMessage()    {}
func (*DeviceType) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{0}
}

func (m *DeviceType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceType.Unmarshal(m, b)
}
func (m *DeviceType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceType.Marshal(b, m, deterministic)
}
func (m *DeviceType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceType.Merge(m, src)
}
func (m *DeviceType) XXX_Size() int {
	return xxx_messageInfo_DeviceType.Size(m)
}
func (m *DeviceType) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceType.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceType proto.InternalMessageInfo

func (m *DeviceType) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeviceType) GetVendorId() string {
	if m != nil {
		return m.VendorId
	}
	return ""
}

func (m *DeviceType) GetVendorIds() []string {
	if m != nil {
		return m.VendorIds
	}
	return nil
}

func (m *DeviceType) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *DeviceType) GetAcceptsBulkFlowUpdate() bool {
	if m != nil {
		return m.AcceptsBulkFlowUpdate
	}
	return false
}

func (m *DeviceType) GetAcceptsAddRemoveFlowUpdates() bool {
	if m != nil {
		return m.AcceptsAddRemoveFlowUpdates
	}
	return false
}

func (m *DeviceType) GetAcceptsDirectLogicalFlowsUpdate() bool {
	if m != nil {
		return m.AcceptsDirectLogicalFlowsUpdate
	}
	return false
}

func (m *DeviceType) GetAdapterType() string {
	if m != nil {
		return m.AdapterType
	}
	return ""
}

// A plurality of device types
type DeviceTypes struct {
	Items                []*DeviceType `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DeviceTypes) Reset()         { *m = DeviceTypes{} }
func (m *DeviceTypes) String() string { return proto.CompactTextString(m) }
func (*DeviceTypes) ProtoMessage()    {}
func (*DeviceTypes) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{1}
}

func (m *DeviceTypes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceTypes.Unmarshal(m, b)
}
func (m *DeviceTypes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceTypes.Marshal(b, m, deterministic)
}
func (m *DeviceTypes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceTypes.Merge(m, src)
}
func (m *DeviceTypes) XXX_Size() int {
	return xxx_messageInfo_DeviceTypes.Size(m)
}
func (m *DeviceTypes) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceTypes.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceTypes proto.InternalMessageInfo

func (m *DeviceTypes) GetItems() []*DeviceType {
	if m != nil {
		return m.Items
	}
	return nil
}

type PmConfig struct {
	Name                 string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type                 PmConfig_PmType `protobuf:"varint,2,opt,name=type,proto3,enum=device.PmConfig_PmType" json:"type,omitempty"`
	Enabled              bool            `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	SampleFreq           uint32          `protobuf:"varint,4,opt,name=sample_freq,json=sampleFreq,proto3" json:"sample_freq,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *PmConfig) Reset()         { *m = PmConfig{} }
func (m *PmConfig) String() string { return proto.CompactTextString(m) }
func (*PmConfig) ProtoMessage()    {}
func (*PmConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{2}
}

func (m *PmConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmConfig.Unmarshal(m, b)
}
func (m *PmConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmConfig.Marshal(b, m, deterministic)
}
func (m *PmConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmConfig.Merge(m, src)
}
func (m *PmConfig) XXX_Size() int {
	return xxx_messageInfo_PmConfig.Size(m)
}
func (m *PmConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PmConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PmConfig proto.InternalMessageInfo

func (m *PmConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PmConfig) GetType() PmConfig_PmType {
	if m != nil {
		return m.Type
	}
	return PmConfig_COUNTER
}

func (m *PmConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PmConfig) GetSampleFreq() uint32 {
	if m != nil {
		return m.SampleFreq
	}
	return 0
}

type PmGroupConfig struct {
	GroupName            string      `protobuf:"bytes,1,opt,name=group_name,json=groupName,proto3" json:"group_name,omitempty"`
	GroupFreq            uint32      `protobuf:"varint,2,opt,name=group_freq,json=groupFreq,proto3" json:"group_freq,omitempty"`
	Enabled              bool        `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Metrics              []*PmConfig `protobuf:"bytes,4,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *PmGroupConfig) Reset()         { *m = PmGroupConfig{} }
func (m *PmGroupConfig) String() string { return proto.CompactTextString(m) }
func (*PmGroupConfig) ProtoMessage()    {}
func (*PmGroupConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{3}
}

func (m *PmGroupConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmGroupConfig.Unmarshal(m, b)
}
func (m *PmGroupConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmGroupConfig.Marshal(b, m, deterministic)
}
func (m *PmGroupConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmGroupConfig.Merge(m, src)
}
func (m *PmGroupConfig) XXX_Size() int {
	return xxx_messageInfo_PmGroupConfig.Size(m)
}
func (m *PmGroupConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PmGroupConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PmGroupConfig proto.InternalMessageInfo

func (m *PmGroupConfig) GetGroupName() string {
	if m != nil {
		return m.GroupName
	}
	return ""
}

func (m *PmGroupConfig) GetGroupFreq() uint32 {
	if m != nil {
		return m.GroupFreq
	}
	return 0
}

func (m *PmGroupConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PmGroupConfig) GetMetrics() []*PmConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type PmConfigs struct {
	Id          string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	DefaultFreq uint32 `protobuf:"varint,2,opt,name=default_freq,json=defaultFreq,proto3" json:"default_freq,omitempty"`
	// Forces group names and group semantics
	Grouped bool `protobuf:"varint,3,opt,name=grouped,proto3" json:"grouped,omitempty"`
	// Allows Pm to set an individual sample frequency
	FreqOverride         bool             `protobuf:"varint,4,opt,name=freq_override,json=freqOverride,proto3" json:"freq_override,omitempty"`
	Groups               []*PmGroupConfig `protobuf:"bytes,5,rep,name=groups,proto3" json:"groups,omitempty"`
	Metrics              []*PmConfig      `protobuf:"bytes,6,rep,name=metrics,proto3" json:"metrics,omitempty"`
	MaxSkew              uint32           `protobuf:"varint,7,opt,name=max_skew,json=maxSkew,proto3" json:"max_skew,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PmConfigs) Reset()         { *m = PmConfigs{} }
func (m *PmConfigs) String() string { return proto.CompactTextString(m) }
func (*PmConfigs) ProtoMessage()    {}
func (*PmConfigs) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{4}
}

func (m *PmConfigs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmConfigs.Unmarshal(m, b)
}
func (m *PmConfigs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmConfigs.Marshal(b, m, deterministic)
}
func (m *PmConfigs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmConfigs.Merge(m, src)
}
func (m *PmConfigs) XXX_Size() int {
	return xxx_messageInfo_PmConfigs.Size(m)
}
func (m *PmConfigs) XXX_DiscardUnknown() {
	xxx_messageInfo_PmConfigs.DiscardUnknown(m)
}

var xxx_messageInfo_PmConfigs proto.InternalMessageInfo

func (m *PmConfigs) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PmConfigs) GetDefaultFreq() uint32 {
	if m != nil {
		return m.DefaultFreq
	}
	return 0
}

func (m *PmConfigs) GetGrouped() bool {
	if m != nil {
		return m.Grouped
	}
	return false
}

func (m *PmConfigs) GetFreqOverride() bool {
	if m != nil {
		return m.FreqOverride
	}
	return false
}

func (m *PmConfigs) GetGroups() []*PmGroupConfig {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *PmConfigs) GetMetrics() []*PmConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *PmConfigs) GetMaxSkew() uint32 {
	if m != nil {
		return m.MaxSkew
	}
	return 0
}

//Object representing an image
type Image struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version, this is the sole identifier of the image. it's the vendor specified OMCI version
	// must be known at the time of initiating a download, activate, commit image on an onu.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// hash of the image to be verified against
	// Deprecated in voltha 2.8, will be removed
	Hash uint32 `protobuf:"varint,3,opt,name=hash,proto3" json:"hash,omitempty"`
	// Deprecated in voltha 2.8, will be removed
	InstallDatetime string `protobuf:"bytes,4,opt,name=install_datetime,json=installDatetime,proto3" json:"install_datetime,omitempty"`
	// The active software image is one that is currently loaded and executing
	// in the ONU or circuit pack. Under normal operation, one software image
	// is always active while the other is inactive. Under no circumstances are
	// both software images allowed to be active at the same time
	// Deprecated in voltha 2.8, will be removed
	IsActive bool `protobuf:"varint,5,opt,name=is_active,json=isActive,proto3" json:"is_active,omitempty"`
	// The committed software image is loaded and executed upon reboot of the
	// ONU and/or circuit pack. During normal operation, one software image is
	// always committed, while the other is uncommitted.
	// Deprecated in voltha 2.8, will be removed
	IsCommitted bool `protobuf:"varint,6,opt,name=is_committed,json=isCommitted,proto3" json:"is_committed,omitempty"`
	// A software image is valid if it has been verified to be an executable
	// code image. The verification mechanism is not subject to standardization;
	// however, it should include at least a data integrity (e.g., CRC) check of
	// the entire code image.
	// Deprecated in voltha 2.8, will be removed
	IsValid bool `protobuf:"varint,7,opt,name=is_valid,json=isValid,proto3" json:"is_valid,omitempty"`
	// URL where the image is available
	// URL MUST be fully qualified,
	// including filename, username and password
	Url string `protobuf:"bytes,8,opt,name=url,proto3" json:"url,omitempty"`
	// Represents the vendor/device mfr
	// Needs to match the vendor of the device the image will be installed on
	// optional, if not matched no check will be performed
	Vendor string `protobuf:"bytes,9,opt,name=vendor,proto3" json:"vendor,omitempty"`
	// Represents the ONU Image CRC value.
	// Default to value 0 if not specified.
	// If different then 0 it's used to verify the image retrieved from outside before sending it to the ONU.
	// Calculation of this needs to be done according to ITU-T I.363.5 as per OMCI spec (section A.2.27)
	Crc32                uint32   `protobuf:"varint,10,opt,name=crc32,proto3" json:"crc32,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{5}
}

func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Image) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Image) GetHash() uint32 {
	if m != nil {
		return m.Hash
	}
	return 0
}

func (m *Image) GetInstallDatetime() string {
	if m != nil {
		return m.InstallDatetime
	}
	return ""
}

func (m *Image) GetIsActive() bool {
	if m != nil {
		return m.IsActive
	}
	return false
}

func (m *Image) GetIsCommitted() bool {
	if m != nil {
		return m.IsCommitted
	}
	return false
}

func (m *Image) GetIsValid() bool {
	if m != nil {
		return m.IsValid
	}
	return false
}

func (m *Image) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Image) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *Image) GetCrc32() uint32 {
	if m != nil {
		return m.Crc32
	}
	return 0
}

// Older version of the API please see DeviceImageDownloadRequest
// Deprecated in voltha 2.8, will be removed
//
// Deprecated: Do not use.
type ImageDownload struct {
	// Device Identifier
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Image unique identifier
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// URL where the image is available
	// should include username password
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// CRC of the image to be verified aginst
	Crc uint32 `protobuf:"varint,4,opt,name=crc,proto3" json:"crc,omitempty"`
	// Download state
	DownloadState ImageDownload_ImageDownloadState `protobuf:"varint,5,opt,name=download_state,json=downloadState,proto3,enum=device.ImageDownload_ImageDownloadState" json:"download_state,omitempty"`
	// Downloaded version
	ImageVersion string `protobuf:"bytes,6,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Bytes downloaded
	DownloadedBytes uint32 `protobuf:"varint,7,opt,name=downloaded_bytes,json=downloadedBytes,proto3" json:"downloaded_bytes,omitempty"`
	// Download failure reason
	Reason ImageDownload_ImageDownloadFailureReason `protobuf:"varint,8,opt,name=reason,proto3,enum=device.ImageDownload_ImageDownloadFailureReason" json:"reason,omitempty"`
	// Additional info
	AdditionalInfo string `protobuf:"bytes,9,opt,name=additional_info,json=additionalInfo,proto3" json:"additional_info,omitempty"`
	// Save current configuration
	SaveConfig bool `protobuf:"varint,10,opt,name=save_config,json=saveConfig,proto3" json:"save_config,omitempty"`
	// Image local location
	LocalDir string `protobuf:"bytes,11,opt,name=local_dir,json=localDir,proto3" json:"local_dir,omitempty"`
	// Image activation state
	ImageState ImageDownload_ImageActivateState `protobuf:"varint,12,opt,name=image_state,json=imageState,proto3,enum=device.ImageDownload_ImageActivateState" json:"image_state,omitempty"`
	// Image file size
	FileSize             uint32   `protobuf:"varint,13,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageDownload) Reset()         { *m = ImageDownload{} }
func (m *ImageDownload) String() string { return proto.CompactTextString(m) }
func (*ImageDownload) ProtoMessage()    {}
func (*ImageDownload) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{6}
}

func (m *ImageDownload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageDownload.Unmarshal(m, b)
}
func (m *ImageDownload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageDownload.Marshal(b, m, deterministic)
}
func (m *ImageDownload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageDownload.Merge(m, src)
}
func (m *ImageDownload) XXX_Size() int {
	return xxx_messageInfo_ImageDownload.Size(m)
}
func (m *ImageDownload) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageDownload.DiscardUnknown(m)
}

var xxx_messageInfo_ImageDownload proto.InternalMessageInfo

func (m *ImageDownload) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ImageDownload) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImageDownload) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *ImageDownload) GetCrc() uint32 {
	if m != nil {
		return m.Crc
	}
	return 0
}

func (m *ImageDownload) GetDownloadState() ImageDownload_ImageDownloadState {
	if m != nil {
		return m.DownloadState
	}
	return ImageDownload_DOWNLOAD_UNKNOWN
}

func (m *ImageDownload) GetImageVersion() string {
	if m != nil {
		return m.ImageVersion
	}
	return ""
}

func (m *ImageDownload) GetDownloadedBytes() uint32 {
	if m != nil {
		return m.DownloadedBytes
	}
	return 0
}

func (m *ImageDownload) GetReason() ImageDownload_ImageDownloadFailureReason {
	if m != nil {
		return m.Reason
	}
	return ImageDownload_NO_ERROR
}

func (m *ImageDownload) GetAdditionalInfo() string {
	if m != nil {
		return m.AdditionalInfo
	}
	return ""
}

func (m *ImageDownload) GetSaveConfig() bool {
	if m != nil {
		return m.SaveConfig
	}
	return false
}

func (m *ImageDownload) GetLocalDir() string {
	if m != nil {
		return m.LocalDir
	}
	return ""
}

func (m *ImageDownload) GetImageState() ImageDownload_ImageActivateState {
	if m != nil {
		return m.ImageState
	}
	return ImageDownload_IMAGE_UNKNOWN
}

func (m *ImageDownload) GetFileSize() uint32 {
	if m != nil {
		return m.FileSize
	}
	return 0
}

// Deprecated in voltha 2.8, will be removed
//
// Deprecated: Do not use.
type ImageDownloads struct {
	Items                []*ImageDownload `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ImageDownloads) Reset()         { *m = ImageDownloads{} }
func (m *ImageDownloads) String() string { return proto.CompactTextString(m) }
func (*ImageDownloads) ProtoMessage()    {}
func (*ImageDownloads) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7}
}

func (m *ImageDownloads) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageDownloads.Unmarshal(m, b)
}
func (m *ImageDownloads) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageDownloads.Marshal(b, m, deterministic)
}
func (m *ImageDownloads) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageDownloads.Merge(m, src)
}
func (m *ImageDownloads) XXX_Size() int {
	return xxx_messageInfo_ImageDownloads.Size(m)
}
func (m *ImageDownloads) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageDownloads.DiscardUnknown(m)
}

var xxx_messageInfo_ImageDownloads proto.InternalMessageInfo

func (m *ImageDownloads) GetItems() []*ImageDownload {
	if m != nil {
		return m.Items
	}
	return nil
}

type Images struct {
	Image                []*Image `protobuf:"bytes,1,rep,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Images) Reset()         { *m = Images{} }
func (m *Images) String() string { return proto.CompactTextString(m) }
func (*Images) ProtoMessage()    {}
func (*Images) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{8}
}

func (m *Images) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Images.Unmarshal(m, b)
}
func (m *Images) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Images.Marshal(b, m, deterministic)
}
func (m *Images) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Images.Merge(m, src)
}
func (m *Images) XXX_Size() int {
	return xxx_messageInfo_Images.Size(m)
}
func (m *Images) XXX_DiscardUnknown() {
	xxx_messageInfo_Images.DiscardUnknown(m)
}

var xxx_messageInfo_Images proto.InternalMessageInfo

func (m *Images) GetImage() []*Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// OnuImage represents the OMCI information as per OMCI spec
// the information will be populates exactly as extracted from the device.
type OnuImage struct {
	//image version
	Version     string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	IsCommited  bool   `protobuf:"varint,2,opt,name=isCommited,proto3" json:"isCommited,omitempty"`
	IsActive    bool   `protobuf:"varint,3,opt,name=isActive,proto3" json:"isActive,omitempty"`
	IsValid     bool   `protobuf:"varint,4,opt,name=isValid,proto3" json:"isValid,omitempty"`
	ProductCode string `protobuf:"bytes,5,opt,name=productCode,proto3" json:"productCode,omitempty"`
	// Hash is computed by the ONU and is optional as per OMCI spec (paragraph 9.1.4)
	// No assumption should be made on the existence of this attribute at any time.
	Hash                 string   `protobuf:"bytes,6,opt,name=hash,proto3" json:"hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OnuImage) Reset()         { *m = OnuImage{} }
func (m *OnuImage) String() string { return proto.CompactTextString(m) }
func (*OnuImage) ProtoMessage()    {}
func (*OnuImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9}
}

func (m *OnuImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OnuImage.Unmarshal(m, b)
}
func (m *OnuImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OnuImage.Marshal(b, m, deterministic)
}
func (m *OnuImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OnuImage.Merge(m, src)
}
func (m *OnuImage) XXX_Size() int {
	return xxx_messageInfo_OnuImage.Size(m)
}
func (m *OnuImage) XXX_DiscardUnknown() {
	xxx_messageInfo_OnuImage.DiscardUnknown(m)
}

var xxx_messageInfo_OnuImage proto.InternalMessageInfo

func (m *OnuImage) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *OnuImage) GetIsCommited() bool {
	if m != nil {
		return m.IsCommited
	}
	return false
}

func (m *OnuImage) GetIsActive() bool {
	if m != nil {
		return m.IsActive
	}
	return false
}

func (m *OnuImage) GetIsValid() bool {
	if m != nil {
		return m.IsValid
	}
	return false
}

func (m *OnuImage) GetProductCode() string {
	if m != nil {
		return m.ProductCode
	}
	return ""
}

func (m *OnuImage) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

type OnuImages struct {
	Items                []*OnuImage `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *OnuImages) Reset()         { *m = OnuImages{} }
func (m *OnuImages) String() string { return proto.CompactTextString(m) }
func (*OnuImages) ProtoMessage()    {}
func (*OnuImages) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{10}
}

func (m *OnuImages) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OnuImages.Unmarshal(m, b)
}
func (m *OnuImages) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OnuImages.Marshal(b, m, deterministic)
}
func (m *OnuImages) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OnuImages.Merge(m, src)
}
func (m *OnuImages) XXX_Size() int {
	return xxx_messageInfo_OnuImages.Size(m)
}
func (m *OnuImages) XXX_DiscardUnknown() {
	xxx_messageInfo_OnuImages.DiscardUnknown(m)
}

var xxx_messageInfo_OnuImages proto.InternalMessageInfo

func (m *OnuImages) GetItems() []*OnuImage {
	if m != nil {
		return m.Items
	}
	return nil
}

type DeviceImageState struct {
	DeviceId             string      `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	ImageState           *ImageState `protobuf:"bytes,2,opt,name=imageState,proto3" json:"imageState,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *DeviceImageState) Reset()         { *m = DeviceImageState{} }
func (m *DeviceImageState) String() string { return proto.CompactTextString(m) }
func (*DeviceImageState) ProtoMessage()    {}
func (*DeviceImageState) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{11}
}

func (m *DeviceImageState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceImageState.Unmarshal(m, b)
}
func (m *DeviceImageState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceImageState.Marshal(b, m, deterministic)
}
func (m *DeviceImageState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceImageState.Merge(m, src)
}
func (m *DeviceImageState) XXX_Size() int {
	return xxx_messageInfo_DeviceImageState.Size(m)
}
func (m *DeviceImageState) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceImageState.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceImageState proto.InternalMessageInfo

func (m *DeviceImageState) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *DeviceImageState) GetImageState() *ImageState {
	if m != nil {
		return m.ImageState
	}
	return nil
}

type ImageState struct {
	// image version
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Download state
	DownloadState ImageState_ImageDownloadState `protobuf:"varint,2,opt,name=download_state,json=downloadState,proto3,enum=device.ImageState_ImageDownloadState" json:"download_state,omitempty"`
	// Image Operation Failure reason (use for both Download and Activate)
	Reason ImageState_ImageFailureReason `protobuf:"varint,3,opt,name=reason,proto3,enum=device.ImageState_ImageFailureReason" json:"reason,omitempty"`
	// Image activation state
	ImageState           ImageState_ImageActivationState `protobuf:"varint,4,opt,name=image_state,json=imageState,proto3,enum=device.ImageState_ImageActivationState" json:"image_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *ImageState) Reset()         { *m = ImageState{} }
func (m *ImageState) String() string { return proto.CompactTextString(m) }
func (*ImageState) ProtoMessage()    {}
func (*ImageState) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{12}
}

func (m *ImageState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageState.Unmarshal(m, b)
}
func (m *ImageState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageState.Marshal(b, m, deterministic)
}
func (m *ImageState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageState.Merge(m, src)
}
func (m *ImageState) XXX_Size() int {
	return xxx_messageInfo_ImageState.Size(m)
}
func (m *ImageState) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageState.DiscardUnknown(m)
}

var xxx_messageInfo_ImageState proto.InternalMessageInfo

func (m *ImageState) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ImageState) GetDownloadState() ImageState_ImageDownloadState {
	if m != nil {
		return m.DownloadState
	}
	return ImageState_DOWNLOAD_UNKNOWN
}

func (m *ImageState) GetReason() ImageState_ImageFailureReason {
	if m != nil {
		return m.Reason
	}
	return ImageState_NO_ERROR
}

func (m *ImageState) GetImageState() ImageState_ImageActivationState {
	if m != nil {
		return m.ImageState
	}
	return ImageState_IMAGE_UNKNOWN
}

type Port struct {
	PortNo     uint32                  `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	Label      string                  `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	Type       Port_PortType           `protobuf:"varint,3,opt,name=type,proto3,enum=device.Port_PortType" json:"type,omitempty"`
	AdminState common.AdminState_Types `protobuf:"varint,5,opt,name=admin_state,json=adminState,proto3,enum=common.AdminState_Types" json:"admin_state,omitempty"`
	OperStatus common.OperStatus_Types `protobuf:"varint,6,opt,name=oper_status,json=operStatus,proto3,enum=common.OperStatus_Types" json:"oper_status,omitempty"`
	DeviceId   string                  `protobuf:"bytes,7,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	Peers      []*Port_PeerPort        `protobuf:"bytes,8,rep,name=peers,proto3" json:"peers,omitempty"`
	RxPackets  uint64                  `protobuf:"fixed64,9,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	RxBytes    uint64                  `protobuf:"fixed64,10,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	RxErrors   uint64                  `protobuf:"fixed64,11,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	TxPackets  uint64                  `protobuf:"fixed64,12,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	TxBytes    uint64                  `protobuf:"fixed64,13,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxErrors   uint64                  `protobuf:"fixed64,14,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	// ofp_port represents the characteristics of a port, e.g. hardware
	// address and supported features.  This field is relevant only for
	// UNI and NNI ports.   For PON ports, it can be left empty.
	OfpPort              *openflow_13.OfpPort `protobuf:"bytes,15,opt,name=ofp_port,json=ofpPort,proto3" json:"ofp_port,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Port) Reset()         { *m = Port{} }
func (m *Port) String() string { return proto.CompactTextString(m) }
func (*Port) ProtoMessage()    {}
func (*Port) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13}
}

func (m *Port) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Port.Unmarshal(m, b)
}
func (m *Port) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Port.Marshal(b, m, deterministic)
}
func (m *Port) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port.Merge(m, src)
}
func (m *Port) XXX_Size() int {
	return xxx_messageInfo_Port.Size(m)
}
func (m *Port) XXX_DiscardUnknown() {
	xxx_messageInfo_Port.DiscardUnknown(m)
}

var xxx_messageInfo_Port proto.InternalMessageInfo

func (m *Port) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *Port) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Port) GetType() Port_PortType {
	if m != nil {
		return m.Type
	}
	return Port_UNKNOWN
}

func (m *Port) GetAdminState() common.AdminState_Types {
	if m != nil {
		return m.AdminState
	}
	return common.AdminState_UNKNOWN
}

func (m *Port) GetOperStatus() common.OperStatus_Types {
	if m != nil {
		return m.OperStatus
	}
	return common.OperStatus_UNKNOWN
}

func (m *Port) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Port) GetPeers() []*Port_PeerPort {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *Port) GetRxPackets() uint64 {
	if m != nil {
		return m.RxPackets
	}
	return 0
}

func (m *Port) GetRxBytes() uint64 {
	if m != nil {
		return m.RxBytes
	}
	return 0
}

func (m *Port) GetRxErrors() uint64 {
	if m != nil {
		return m.RxErrors
	}
	return 0
}

func (m *Port) GetTxPackets() uint64 {
	if m != nil {
		return m.TxPackets
	}
	return 0
}

func (m *Port) GetTxBytes() uint64 {
	if m != nil {
		return m.TxBytes
	}
	return 0
}

func (m *Port) GetTxErrors() uint64 {
	if m != nil {
		return m.TxErrors
	}
	return 0
}

func (m *Port) GetOfpPort() *openflow_13.OfpPort {
	if m != nil {
		return m.OfpPort
	}
	return nil
}

type Port_PeerPort struct {
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	PortNo               uint32   `protobuf:"varint,2,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Port_PeerPort) Reset()         { *m = Port_PeerPort{} }
func (m *Port_PeerPort) String() string { return proto.CompactTextString(m) }
func (*Port_PeerPort) ProtoMessage()    {}
func (*Port_PeerPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13, 0}
}

func (m *Port_PeerPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Port_PeerPort.Unmarshal(m, b)
}
func (m *Port_PeerPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Port_PeerPort.Marshal(b, m, deterministic)
}
func (m *Port_PeerPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port_PeerPort.Merge(m, src)
}
func (m *Port_PeerPort) XXX_Size() int {
	return xxx_messageInfo_Port_PeerPort.Size(m)
}
func (m *Port_PeerPort) XXX_DiscardUnknown() {
	xxx_messageInfo_Port_PeerPort.DiscardUnknown(m)
}

var xxx_messageInfo_Port_PeerPort proto.InternalMessageInfo

func (m *Port_PeerPort) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Port_PeerPort) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

type Ports struct {
	Items                []*Port  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Ports) Reset()         { *m = Ports{} }
func (m *Ports) String() string { return proto.CompactTextString(m) }
func (*Ports) ProtoMessage()    {}
func (*Ports) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{14}
}

func (m *Ports) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ports.Unmarshal(m, b)
}
func (m *Ports) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ports.Marshal(b, m, deterministic)
}
func (m *Ports) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ports.Merge(m, src)
}
func (m *Ports) XXX_Size() int {
	return xxx_messageInfo_Ports.Size(m)
}
func (m *Ports) XXX_DiscardUnknown() {
	xxx_messageInfo_Ports.DiscardUnknown(m)
}

var xxx_messageInfo_Ports proto.InternalMessageInfo

func (m *Ports) GetItems() []*Port {
	if m != nil {
		return m.Items
	}
	return nil
}

// A Physical Device instance
type Device struct {
	// Voltha's device identifier
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Device type, refers to one of the registered device types
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Is this device a root device. Each logical switch has one root
	// device that is associated with the logical flow switch.
	Root bool `protobuf:"varint,3,opt,name=root,proto3" json:"root,omitempty"`
	// Parent device id, in the device tree (for a root device, the parent_id
	// is the logical_device.id)
	ParentId     string `protobuf:"bytes,4,opt,name=parent_id,json=parentId,proto3" json:"parent_id,omitempty"`
	ParentPortNo uint32 `protobuf:"varint,20,opt,name=parent_port_no,json=parentPortNo,proto3" json:"parent_port_no,omitempty"`
	// Vendor, version, serial number, etc.
	Vendor          string `protobuf:"bytes,5,opt,name=vendor,proto3" json:"vendor,omitempty"`
	Model           string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	HardwareVersion string `protobuf:"bytes,7,opt,name=hardware_version,json=hardwareVersion,proto3" json:"hardware_version,omitempty"`
	FirmwareVersion string `protobuf:"bytes,8,opt,name=firmware_version,json=firmwareVersion,proto3" json:"firmware_version,omitempty"`
	// List of software on the device
	Images       *Images `protobuf:"bytes,9,opt,name=images,proto3" json:"images,omitempty"`
	SerialNumber string  `protobuf:"bytes,10,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	VendorId     string  `protobuf:"bytes,24,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	// Indicates how to reach the adapter instance that manages this device
	AdapterEndpoint string `protobuf:"bytes,25,opt,name=adapter_endpoint,json=adapterEndpoint,proto3" json:"adapter_endpoint,omitempty"`
	// Device contact on vlan (if 0, no vlan)
	Vlan uint32 `protobuf:"varint,12,opt,name=vlan,proto3" json:"vlan,omitempty"`
	// Device contact MAC address (format: "xx:xx:xx:xx:xx:xx")
	MacAddress string `protobuf:"bytes,13,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// Types that are valid to be assigned to Address:
	//	*Device_Ipv4Address
	//	*Device_Ipv6Address
	//	*Device_HostAndPort
	Address       isDevice_Address           `protobuf_oneof:"address"`
	ExtraArgs     string                     `protobuf:"bytes,23,opt,name=extra_args,json=extraArgs,proto3" json:"extra_args,omitempty"`
	ProxyAddress  *Device_ProxyAddress       `protobuf:"bytes,19,opt,name=proxy_address,json=proxyAddress,proto3" json:"proxy_address,omitempty"`
	AdminState    common.AdminState_Types    `protobuf:"varint,16,opt,name=admin_state,json=adminState,proto3,enum=common.AdminState_Types" json:"admin_state,omitempty"`
	OperStatus    common.OperStatus_Types    `protobuf:"varint,17,opt,name=oper_status,json=operStatus,proto3,enum=common.OperStatus_Types" json:"oper_status,omitempty"`
	Reason        string                     `protobuf:"bytes,22,opt,name=reason,proto3" json:"reason,omitempty"`
	ConnectStatus common.ConnectStatus_Types `protobuf:"varint,18,opt,name=connect_status,json=connectStatus,proto3,enum=common.ConnectStatus_Types" json:"connect_status,omitempty"`
	// Device type specific attributes
	Custom *any.Any `protobuf:"bytes,64,opt,name=custom,proto3" json:"custom,omitempty"`
	// PmConfigs type
	PmConfigs            *PmConfigs       `protobuf:"bytes,131,opt,name=pm_configs,json=pmConfigs,proto3" json:"pm_configs,omitempty"`
	ImageDownloads       []*ImageDownload `protobuf:"bytes,133,rep,name=image_downloads,json=imageDownloads,proto3" json:"image_downloads,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Device) Reset()         { *m = Device{} }
func (m *Device) String() string { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()    {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{15}
}

func (m *Device) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device.Unmarshal(m, b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device.Marshal(b, m, deterministic)
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return xxx_messageInfo_Device.Size(m)
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

func (m *Device) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Device) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Device) GetRoot() bool {
	if m != nil {
		return m.Root
	}
	return false
}

func (m *Device) GetParentId() string {
	if m != nil {
		return m.ParentId
	}
	return ""
}

func (m *Device) GetParentPortNo() uint32 {
	if m != nil {
		return m.ParentPortNo
	}
	return 0
}

func (m *Device) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *Device) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *Device) GetHardwareVersion() string {
	if m != nil {
		return m.HardwareVersion
	}
	return ""
}

func (m *Device) GetFirmwareVersion() string {
	if m != nil {
		return m.FirmwareVersion
	}
	return ""
}

func (m *Device) GetImages() *Images {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Device) GetSerialNumber() string {
	if m != nil {
		return m.SerialNumber
	}
	return ""
}

func (m *Device) GetVendorId() string {
	if m != nil {
		return m.VendorId
	}
	return ""
}

func (m *Device) GetAdapterEndpoint() string {
	if m != nil {
		return m.AdapterEndpoint
	}
	return ""
}

func (m *Device) GetVlan() uint32 {
	if m != nil {
		return m.Vlan
	}
	return 0
}

func (m *Device) GetMacAddress() string {
	if m != nil {
		return m.MacAddress
	}
	return ""
}

type isDevice_Address interface {
	isDevice_Address()
}

type Device_Ipv4Address struct {
	Ipv4Address string `protobuf:"bytes,14,opt,name=ipv4_address,json=ipv4Address,proto3,oneof"`
}

type Device_Ipv6Address struct {
	Ipv6Address string `protobuf:"bytes,15,opt,name=ipv6_address,json=ipv6Address,proto3,oneof"`
}

type Device_HostAndPort struct {
	HostAndPort string `protobuf:"bytes,21,opt,name=host_and_port,json=hostAndPort,proto3,oneof"`
}

func (*Device_Ipv4Address) isDevice_Address() {}

func (*Device_Ipv6Address) isDevice_Address() {}

func (*Device_HostAndPort) isDevice_Address() {}

func (m *Device) GetAddress() isDevice_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Device) GetIpv4Address() string {
	if x, ok := m.GetAddress().(*Device_Ipv4Address); ok {
		return x.Ipv4Address
	}
	return ""
}

func (m *Device) GetIpv6Address() string {
	if x, ok := m.GetAddress().(*Device_Ipv6Address); ok {
		return x.Ipv6Address
	}
	return ""
}

func (m *Device) GetHostAndPort() string {
	if x, ok := m.GetAddress().(*Device_HostAndPort); ok {
		return x.HostAndPort
	}
	return ""
}

func (m *Device) GetExtraArgs() string {
	if m != nil {
		return m.ExtraArgs
	}
	return ""
}

func (m *Device) GetProxyAddress() *Device_ProxyAddress {
	if m != nil {
		return m.ProxyAddress
	}
	return nil
}

func (m *Device) GetAdminState() common.AdminState_Types {
	if m != nil {
		return m.AdminState
	}
	return common.AdminState_UNKNOWN
}

func (m *Device) GetOperStatus() common.OperStatus_Types {
	if m != nil {
		return m.OperStatus
	}
	return common.OperStatus_UNKNOWN
}

func (m *Device) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Device) GetConnectStatus() common.ConnectStatus_Types {
	if m != nil {
		return m.ConnectStatus
	}
	return common.ConnectStatus_UNKNOWN
}

func (m *Device) GetCustom() *any.Any {
	if m != nil {
		return m.Custom
	}
	return nil
}

func (m *Device) GetPmConfigs() *PmConfigs {
	if m != nil {
		return m.PmConfigs
	}
	return nil
}

func (m *Device) GetImageDownloads() []*ImageDownload {
	if m != nil {
		return m.ImageDownloads
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Device) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Device_Ipv4Address)(nil),
		(*Device_Ipv6Address)(nil),
		(*Device_HostAndPort)(nil),
	}
}

type Device_ProxyAddress struct {
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	DeviceType           string   `protobuf:"bytes,2,opt,name=device_type,json=deviceType,proto3" json:"device_type,omitempty"`
	ChannelId            uint32   `protobuf:"varint,3,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	ChannelGroupId       uint32   `protobuf:"varint,4,opt,name=channel_group_id,json=channelGroupId,proto3" json:"channel_group_id,omitempty"`
	ChannelTermination   string   `protobuf:"bytes,5,opt,name=channel_termination,json=channelTermination,proto3" json:"channel_termination,omitempty"`
	OnuId                uint32   `protobuf:"varint,6,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	OnuSessionId         uint32   `protobuf:"varint,7,opt,name=onu_session_id,json=onuSessionId,proto3" json:"onu_session_id,omitempty"`
	AdapterEndpoint      string   `protobuf:"bytes,8,opt,name=adapter_endpoint,json=adapterEndpoint,proto3" json:"adapter_endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Device_ProxyAddress) Reset()         { *m = Device_ProxyAddress{} }
func (m *Device_ProxyAddress) String() string { return proto.CompactTextString(m) }
func (*Device_ProxyAddress) ProtoMessage()    {}
func (*Device_ProxyAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{15, 0}
}

func (m *Device_ProxyAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device_ProxyAddress.Unmarshal(m, b)
}
func (m *Device_ProxyAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device_ProxyAddress.Marshal(b, m, deterministic)
}
func (m *Device_ProxyAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device_ProxyAddress.Merge(m, src)
}
func (m *Device_ProxyAddress) XXX_Size() int {
	return xxx_messageInfo_Device_ProxyAddress.Size(m)
}
func (m *Device_ProxyAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_Device_ProxyAddress.DiscardUnknown(m)
}

var xxx_messageInfo_Device_ProxyAddress proto.InternalMessageInfo

func (m *Device_ProxyAddress) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Device_ProxyAddress) GetDeviceType() string {
	if m != nil {
		return m.DeviceType
	}
	return ""
}

func (m *Device_ProxyAddress) GetChannelId() uint32 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *Device_ProxyAddress) GetChannelGroupId() uint32 {
	if m != nil {
		return m.ChannelGroupId
	}
	return 0
}

func (m *Device_ProxyAddress) GetChannelTermination() string {
	if m != nil {
		return m.ChannelTermination
	}
	return ""
}

func (m *Device_ProxyAddress) GetOnuId() uint32 {
	if m != nil {
		return m.OnuId
	}
	return 0
}

func (m *Device_ProxyAddress) GetOnuSessionId() uint32 {
	if m != nil {
		return m.OnuSessionId
	}
	return 0
}

func (m *Device_ProxyAddress) GetAdapterEndpoint() string {
	if m != nil {
		return m.AdapterEndpoint
	}
	return ""
}

type DeviceImageDownloadRequest struct {
	// Device Id
	// allows for operations on multiple devices.
	DeviceId []*common.ID `protobuf:"bytes,1,rep,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	//The image for the device containing all the information
	Image *Image `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	//Activate the image if the download to the device is successful
	ActivateOnSuccess bool `protobuf:"varint,3,opt,name=activateOnSuccess,proto3" json:"activateOnSuccess,omitempty"`
	//Automatically commit the image if the activation on the device is successful
	CommitOnSuccess      bool     `protobuf:"varint,4,opt,name=commitOnSuccess,proto3" json:"commitOnSuccess,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceImageDownloadRequest) Reset()         { *m = DeviceImageDownloadRequest{} }
func (m *DeviceImageDownloadRequest) String() string { return proto.CompactTextString(m) }
func (*DeviceImageDownloadRequest) ProtoMessage()    {}
func (*DeviceImageDownloadRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{16}
}

func (m *DeviceImageDownloadRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceImageDownloadRequest.Unmarshal(m, b)
}
func (m *DeviceImageDownloadRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceImageDownloadRequest.Marshal(b, m, deterministic)
}
func (m *DeviceImageDownloadRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceImageDownloadRequest.Merge(m, src)
}
func (m *DeviceImageDownloadRequest) XXX_Size() int {
	return xxx_messageInfo_DeviceImageDownloadRequest.Size(m)
}
func (m *DeviceImageDownloadRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceImageDownloadRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceImageDownloadRequest proto.InternalMessageInfo

func (m *DeviceImageDownloadRequest) GetDeviceId() []*common.ID {
	if m != nil {
		return m.DeviceId
	}
	return nil
}

func (m *DeviceImageDownloadRequest) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *DeviceImageDownloadRequest) GetActivateOnSuccess() bool {
	if m != nil {
		return m.ActivateOnSuccess
	}
	return false
}

func (m *DeviceImageDownloadRequest) GetCommitOnSuccess() bool {
	if m != nil {
		return m.CommitOnSuccess
	}
	return false
}

type DeviceImageRequest struct {
	//Device Id
	//allows for operations on multiple adapters.
	DeviceId []*common.ID `protobuf:"bytes,1,rep,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Image Version, this is the sole identifier of the image. it's the vendor specified OMCI version
	// must be known at the time of initiating a download, activate, commit image on an onu.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	//Automatically commit the image if the activation on the device is successful
	CommitOnSuccess      bool     `protobuf:"varint,3,opt,name=commitOnSuccess,proto3" json:"commitOnSuccess,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceImageRequest) Reset()         { *m = DeviceImageRequest{} }
func (m *DeviceImageRequest) String() string { return proto.CompactTextString(m) }
func (*DeviceImageRequest) ProtoMessage()    {}
func (*DeviceImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{17}
}

func (m *DeviceImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceImageRequest.Unmarshal(m, b)
}
func (m *DeviceImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceImageRequest.Marshal(b, m, deterministic)
}
func (m *DeviceImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceImageRequest.Merge(m, src)
}
func (m *DeviceImageRequest) XXX_Size() int {
	return xxx_messageInfo_DeviceImageRequest.Size(m)
}
func (m *DeviceImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceImageRequest proto.InternalMessageInfo

func (m *DeviceImageRequest) GetDeviceId() []*common.ID {
	if m != nil {
		return m.DeviceId
	}
	return nil
}

func (m *DeviceImageRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *DeviceImageRequest) GetCommitOnSuccess() bool {
	if m != nil {
		return m.CommitOnSuccess
	}
	return false
}

type DeviceImageResponse struct {
	//Image state for the different devices
	DeviceImageStates    []*DeviceImageState `protobuf:"bytes,1,rep,name=device_image_states,json=deviceImageStates,proto3" json:"device_image_states,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *DeviceImageResponse) Reset()         { *m = DeviceImageResponse{} }
func (m *DeviceImageResponse) String() string { return proto.CompactTextString(m) }
func (*DeviceImageResponse) ProtoMessage()    {}
func (*DeviceImageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{18}
}

func (m *DeviceImageResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceImageResponse.Unmarshal(m, b)
}
func (m *DeviceImageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceImageResponse.Marshal(b, m, deterministic)
}
func (m *DeviceImageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceImageResponse.Merge(m, src)
}
func (m *DeviceImageResponse) XXX_Size() int {
	return xxx_messageInfo_DeviceImageResponse.Size(m)
}
func (m *DeviceImageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceImageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceImageResponse proto.InternalMessageInfo

func (m *DeviceImageResponse) GetDeviceImageStates() []*DeviceImageState {
	if m != nil {
		return m.DeviceImageStates
	}
	return nil
}

// Device Self Test Response
type SelfTestResponse struct {
	Result               SelfTestResponse_SelfTestResult `protobuf:"varint,1,opt,name=result,proto3,enum=device.SelfTestResponse_SelfTestResult" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SelfTestResponse) Reset()         { *m = SelfTestResponse{} }
func (m *SelfTestResponse) String() string { return proto.CompactTextString(m) }
func (*SelfTestResponse) ProtoMessage()    {}
func (*SelfTestResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{19}
}

func (m *SelfTestResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SelfTestResponse.Unmarshal(m, b)
}
func (m *SelfTestResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SelfTestResponse.Marshal(b, m, deterministic)
}
func (m *SelfTestResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SelfTestResponse.Merge(m, src)
}
func (m *SelfTestResponse) XXX_Size() int {
	return xxx_messageInfo_SelfTestResponse.Size(m)
}
func (m *SelfTestResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SelfTestResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SelfTestResponse proto.InternalMessageInfo

func (m *SelfTestResponse) GetResult() SelfTestResponse_SelfTestResult {
	if m != nil {
		return m.Result
	}
	return SelfTestResponse_SUCCESS
}

type Devices struct {
	Items                []*Device `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Devices) Reset()         { *m = Devices{} }
func (m *Devices) String() string { return proto.CompactTextString(m) }
func (*Devices) ProtoMessage()    {}
func (*Devices) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{20}
}

func (m *Devices) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Devices.Unmarshal(m, b)
}
func (m *Devices) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Devices.Marshal(b, m, deterministic)
}
func (m *Devices) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Devices.Merge(m, src)
}
func (m *Devices) XXX_Size() int {
	return xxx_messageInfo_Devices.Size(m)
}
func (m *Devices) XXX_DiscardUnknown() {
	xxx_messageInfo_Devices.DiscardUnknown(m)
}

var xxx_messageInfo_Devices proto.InternalMessageInfo

func (m *Devices) GetItems() []*Device {
	if m != nil {
		return m.Items
	}
	return nil
}

type SimulateAlarmRequest struct {
	// Device Identifier
	Id                   string                             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Indicator            string                             `protobuf:"bytes,2,opt,name=indicator,proto3" json:"indicator,omitempty"`
	IntfId               string                             `protobuf:"bytes,3,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	PortTypeName         string                             `protobuf:"bytes,4,opt,name=port_type_name,json=portTypeName,proto3" json:"port_type_name,omitempty"`
	OnuDeviceId          string                             `protobuf:"bytes,5,opt,name=onu_device_id,json=onuDeviceId,proto3" json:"onu_device_id,omitempty"`
	InverseBitErrorRate  int32                              `protobuf:"varint,6,opt,name=inverse_bit_error_rate,json=inverseBitErrorRate,proto3" json:"inverse_bit_error_rate,omitempty"`
	Drift                int32                              `protobuf:"varint,7,opt,name=drift,proto3" json:"drift,omitempty"`
	NewEqd               int32                              `protobuf:"varint,8,opt,name=new_eqd,json=newEqd,proto3" json:"new_eqd,omitempty"`
	OnuSerialNumber      string                             `protobuf:"bytes,9,opt,name=onu_serial_number,json=onuSerialNumber,proto3" json:"onu_serial_number,omitempty"`
	Operation            SimulateAlarmRequest_OperationType `protobuf:"varint,10,opt,name=operation,proto3,enum=device.SimulateAlarmRequest_OperationType" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *SimulateAlarmRequest) Reset()         { *m = SimulateAlarmRequest{} }
func (m *SimulateAlarmRequest) String() string { return proto.CompactTextString(m) }
func (*SimulateAlarmRequest) ProtoMessage()    {}
func (*SimulateAlarmRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{21}
}

func (m *SimulateAlarmRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimulateAlarmRequest.Unmarshal(m, b)
}
func (m *SimulateAlarmRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimulateAlarmRequest.Marshal(b, m, deterministic)
}
func (m *SimulateAlarmRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimulateAlarmRequest.Merge(m, src)
}
func (m *SimulateAlarmRequest) XXX_Size() int {
	return xxx_messageInfo_SimulateAlarmRequest.Size(m)
}
func (m *SimulateAlarmRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SimulateAlarmRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SimulateAlarmRequest proto.InternalMessageInfo

func (m *SimulateAlarmRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SimulateAlarmRequest) GetIndicator() string {
	if m != nil {
		return m.Indicator
	}
	return ""
}

func (m *SimulateAlarmRequest) GetIntfId() string {
	if m != nil {
		return m.IntfId
	}
	return ""
}

func (m *SimulateAlarmRequest) GetPortTypeName() string {
	if m != nil {
		return m.PortTypeName
	}
	return ""
}

func (m *SimulateAlarmRequest) GetOnuDeviceId() string {
	if m != nil {
		return m.OnuDeviceId
	}
	return ""
}

func (m *SimulateAlarmRequest) GetInverseBitErrorRate() int32 {
	if m != nil {
		return m.InverseBitErrorRate
	}
	return 0
}

func (m *SimulateAlarmRequest) GetDrift() int32 {
	if m != nil {
		return m.Drift
	}
	return 0
}

func (m *SimulateAlarmRequest) GetNewEqd() int32 {
	if m != nil {
		return m.NewEqd
	}
	return 0
}

func (m *SimulateAlarmRequest) GetOnuSerialNumber() string {
	if m != nil {
		return m.OnuSerialNumber
	}
	return ""
}

func (m *SimulateAlarmRequest) GetOperation() SimulateAlarmRequest_OperationType {
	if m != nil {
		return m.Operation
	}
	return SimulateAlarmRequest_RAISE
}

func init() {
	proto.RegisterEnum("device.PmConfig_PmType", PmConfig_PmType_name, PmConfig_PmType_value)
	proto.RegisterEnum("device.ImageDownload_ImageDownloadState", ImageDownload_ImageDownloadState_name, ImageDownload_ImageDownloadState_value)
	proto.RegisterEnum("device.ImageDownload_ImageDownloadFailureReason", ImageDownload_ImageDownloadFailureReason_name, ImageDownload_ImageDownloadFailureReason_value)
	proto.RegisterEnum("device.ImageDownload_ImageActivateState", ImageDownload_ImageActivateState_name, ImageDownload_ImageActivateState_value)
	proto.RegisterEnum("device.ImageState_ImageDownloadState", ImageState_ImageDownloadState_name, ImageState_ImageDownloadState_value)
	proto.RegisterEnum("device.ImageState_ImageFailureReason", ImageState_ImageFailureReason_name, ImageState_ImageFailureReason_value)
	proto.RegisterEnum("device.ImageState_ImageActivationState", ImageState_ImageActivationState_name, ImageState_ImageActivationState_value)
	proto.RegisterEnum("device.Port_PortType", Port_PortType_name, Port_PortType_value)
	proto.RegisterEnum("device.SelfTestResponse_SelfTestResult", SelfTestResponse_SelfTestResult_name, SelfTestResponse_SelfTestResult_value)
	proto.RegisterEnum("device.SimulateAlarmRequest_OperationType", SimulateAlarmRequest_OperationType_name, SimulateAlarmRequest_OperationType_value)
	proto.RegisterType((*DeviceType)(nil), "device.DeviceType")
	proto.RegisterType((*DeviceTypes)(nil), "device.DeviceTypes")
	proto.RegisterType((*PmConfig)(nil), "device.PmConfig")
	proto.RegisterType((*PmGroupConfig)(nil), "device.PmGroupConfig")
	proto.RegisterType((*PmConfigs)(nil), "device.PmConfigs")
	proto.RegisterType((*Image)(nil), "device.Image")
	proto.RegisterType((*ImageDownload)(nil), "device.ImageDownload")
	proto.RegisterType((*ImageDownloads)(nil), "device.ImageDownloads")
	proto.RegisterType((*Images)(nil), "device.Images")
	proto.RegisterType((*OnuImage)(nil), "device.OnuImage")
	proto.RegisterType((*OnuImages)(nil), "device.OnuImages")
	proto.RegisterType((*DeviceImageState)(nil), "device.DeviceImageState")
	proto.RegisterType((*ImageState)(nil), "device.ImageState")
	proto.RegisterType((*Port)(nil), "device.Port")
	proto.RegisterType((*Port_PeerPort)(nil), "device.Port.PeerPort")
	proto.RegisterType((*Ports)(nil), "device.Ports")
	proto.RegisterType((*Device)(nil), "device.Device")
	proto.RegisterType((*Device_ProxyAddress)(nil), "device.Device.ProxyAddress")
	proto.RegisterType((*DeviceImageDownloadRequest)(nil), "device.DeviceImageDownloadRequest")
	proto.RegisterType((*DeviceImageRequest)(nil), "device.DeviceImageRequest")
	proto.RegisterType((*DeviceImageResponse)(nil), "device.DeviceImageResponse")
	proto.RegisterType((*SelfTestResponse)(nil), "device.SelfTestResponse")
	proto.RegisterType((*Devices)(nil), "device.Devices")
	proto.RegisterType((*SimulateAlarmRequest)(nil), "device.SimulateAlarmRequest")
}

func init() { proto.RegisterFile("voltha_protos/device.proto", fileDescriptor_200940f73d155856) }

var fileDescriptor_200940f73d155856 = []byte{
	// 2860 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x5b, 0x73, 0xdb, 0xc6,
	0xf5, 0x37, 0x49, 0xf1, 0x82, 0xc3, 0x8b, 0xa0, 0x95, 0x64, 0xc3, 0x52, 0xfc, 0xb7, 0x03, 0xe7,
	0x22, 0xc7, 0x89, 0x94, 0xd8, 0xff, 0x26, 0x6d, 0x67, 0x3a, 0x31, 0x45, 0x42, 0x16, 0x5b, 0x19,
	0x54, 0x97, 0xa4, 0xd2, 0xe4, 0x05, 0x03, 0x01, 0x4b, 0x09, 0x63, 0x10, 0xa0, 0x01, 0x50, 0x92,
	0xf3, 0xd6, 0x76, 0xda, 0xa7, 0xce, 0xf4, 0xa1, 0x9f, 0xa1, 0x33, 0x7d, 0xea, 0xf4, 0x2d, 0x7d,
	0xec, 0xf4, 0x13, 0xf4, 0xb1, 0xcf, 0x7d, 0xe9, 0x07, 0x68, 0x3f, 0x40, 0x67, 0x6f, 0xb8, 0x48,
	0xb2, 0x93, 0x74, 0x3a, 0x9d, 0xbe, 0x70, 0xb0, 0xbf, 0x73, 0xf6, 0xec, 0xee, 0xd9, 0x3d, 0xbf,
	0x3d, 0x67, 0x09, 0x1b, 0x67, 0xa1, 0x9f, 0x9c, 0xda, 0xd6, 0x3c, 0x0a, 0x93, 0x30, 0xde, 0x71,
	0xc9, 0x99, 0xe7, 0x90, 0x6d, 0xd6, 0x42, 0x35, 0xde, 0xda, 0xb8, 0x7d, 0x12, 0x86, 0x27, 0x3e,
	0xd9, 0x61, 0xe8, 0xf1, 0x62, 0xba, 0x63, 0x07, 0x2f, 0xb9, 0xca, 0xc6, 0xa5, 0xee, 0x4e, 0x38,
	0x9b, 0x85, 0x81, 0x90, 0xdd, 0x2d, 0xca, 0xc2, 0x39, 0x09, 0xa6, 0x7e, 0x78, 0x6e, 0x7d, 0xf4,
	0x98, 0x2b, 0xe8, 0x7f, 0x2b, 0x03, 0xf4, 0xd9, 0x10, 0xe3, 0x97, 0x73, 0x82, 0x3a, 0x50, 0xf6,
	0x5c, 0xad, 0x74, 0xaf, 0xb4, 0xa5, 0xe0, 0xb2, 0xe7, 0xa2, 0x4d, 0x50, 0xce, 0x48, 0xe0, 0x86,
	0x91, 0xe5, 0xb9, 0x5a, 0x95, 0xc1, 0x0d, 0x0e, 0x0c, 0x5c, 0x74, 0x07, 0x20, 0x15, 0xc6, 0x5a,
	0xed, 0x5e, 0x65, 0x4b, 0xc1, 0x8a, 0x94, 0xc6, 0x48, 0x83, 0xba, 0xed, 0xda, 0xf3, 0x84, 0x44,
	0x5a, 0x99, 0xf5, 0x94, 0x4d, 0xf4, 0x09, 0x68, 0xb6, 0xe3, 0x90, 0x79, 0x12, 0x5b, 0xc7, 0x0b,
	0xff, 0xb9, 0xc5, 0xa6, 0xb4, 0x98, 0xbb, 0x76, 0x42, 0xb4, 0xca, 0xbd, 0xd2, 0x56, 0x03, 0xaf,
	0x0b, 0xf9, 0xee, 0xc2, 0x7f, 0xbe, 0xe7, 0x87, 0xe7, 0x13, 0x26, 0x44, 0x7d, 0xb8, 0x2b, 0x3b,
	0xda, 0xae, 0x6b, 0x45, 0x64, 0x16, 0x9e, 0x91, 0x7c, 0xf7, 0x58, 0x5b, 0x62, 0xfd, 0x37, 0x85,
	0x5a, 0xd7, 0x75, 0x31, 0x53, 0xca, 0x8c, 0xc4, 0xe8, 0x00, 0xee, 0x4b, 0x2b, 0xae, 0x17, 0x11,
	0x27, 0xb1, 0xfc, 0xf0, 0xc4, 0x73, 0x6c, 0x9f, 0x59, 0x8a, 0xe5, 0x4c, 0xea, 0xcc, 0x92, 0x1c,
	0xb0, 0xcf, 0x34, 0x0f, 0xb8, 0x22, 0xb5, 0x16, 0x8b, 0x39, 0xbd, 0x09, 0x2d, 0xb1, 0x2e, 0x2b,
	0x79, 0x39, 0x27, 0x5a, 0x83, 0xad, 0xb5, 0x29, 0x30, 0xea, 0x55, 0xfd, 0x13, 0x68, 0x66, 0x3e,
	0x8e, 0xd1, 0x16, 0x54, 0xbd, 0x84, 0xcc, 0x62, 0xad, 0x74, 0xaf, 0xb2, 0xd5, 0x7c, 0x84, 0xb6,
	0xc5, 0x8e, 0x67, 0x3a, 0x98, 0x2b, 0xe8, 0x7f, 0x2a, 0x41, 0xe3, 0x70, 0xd6, 0x0b, 0x83, 0xa9,
	0x77, 0x82, 0x10, 0x2c, 0x05, 0xf6, 0x8c, 0x88, 0xdd, 0x61, 0xdf, 0xe8, 0x21, 0x2c, 0xb1, 0x41,
	0xa9, 0x83, 0x3b, 0x8f, 0x6e, 0x49, 0x4b, 0xb2, 0xcf, 0xf6, 0xe1, 0x8c, 0x99, 0x63, 0x4a, 0x74,
	0x43, 0x48, 0x60, 0x1f, 0xfb, 0xc4, 0x15, 0x5e, 0x96, 0x4d, 0x74, 0x17, 0x9a, 0xb1, 0x3d, 0x9b,
	0xfb, 0xc4, 0x9a, 0x46, 0xe4, 0x05, 0xf3, 0x61, 0x1b, 0x03, 0x87, 0xf6, 0x22, 0xf2, 0x42, 0xff,
	0x2e, 0xd4, 0xb8, 0x29, 0xd4, 0x84, 0x7a, 0x6f, 0x38, 0x31, 0xc7, 0x06, 0x56, 0x6f, 0x20, 0x05,
	0xaa, 0x4f, 0xbb, 0x93, 0xa7, 0x86, 0x5a, 0xa2, 0x9f, 0xa3, 0x71, 0x77, 0x6c, 0xa8, 0x65, 0xae,
	0x62, 0x8e, 0x8d, 0x9f, 0x8c, 0xd5, 0x8a, 0xfe, 0x9b, 0x12, 0xb4, 0x0f, 0x67, 0x4f, 0xa3, 0x70,
	0x31, 0x17, 0xeb, 0xb8, 0x03, 0x70, 0x42, 0x9b, 0x56, 0x6e, 0x35, 0x0a, 0x43, 0x4c, 0xba, 0xa4,
	0x54, 0xcc, 0xa6, 0x52, 0x66, 0x53, 0xe1, 0x62, 0x3a, 0x93, 0xd7, 0x2c, 0xe2, 0x3d, 0xa8, 0xcf,
	0x48, 0x12, 0x79, 0x0e, 0x3d, 0x04, 0xd4, 0xb1, 0xea, 0x65, 0x77, 0x60, 0xa9, 0xa0, 0xff, 0xa3,
	0x04, 0x8a, 0x44, 0xe3, 0x2b, 0xa7, 0xfe, 0x4d, 0x68, 0xb9, 0x64, 0x6a, 0x2f, 0xfc, 0x24, 0x3f,
	0x89, 0xa6, 0xc0, 0xe4, 0x34, 0xd8, 0x9c, 0xb2, 0x69, 0x88, 0x26, 0xba, 0x0f, 0x6d, 0xda, 0xc9,
	0x0a, 0xcf, 0x48, 0x14, 0x79, 0x2e, 0x11, 0x27, 0xb2, 0x45, 0xc1, 0xa1, 0xc0, 0xd0, 0x07, 0x50,
	0x63, 0xfa, 0xb1, 0x56, 0x65, 0x53, 0x5d, 0xcf, 0xa6, 0x9a, 0x73, 0x15, 0x16, 0x4a, 0xf9, 0xa5,
	0xd5, 0xbe, 0x66, 0x69, 0xe8, 0x36, 0x34, 0x66, 0xf6, 0x85, 0x15, 0x3f, 0x27, 0xe7, 0xec, 0x08,
	0xb7, 0x71, 0x7d, 0x66, 0x5f, 0x8c, 0x9e, 0x93, 0x73, 0xfd, 0xd7, 0x65, 0xa8, 0x0e, 0x66, 0xf6,
	0x09, 0xb9, 0xf6, 0x2c, 0x69, 0x50, 0x3f, 0x23, 0x51, 0xec, 0x85, 0x81, 0x8c, 0x57, 0xd1, 0xa4,
	0xda, 0xa7, 0x76, 0x7c, 0xca, 0x56, 0xda, 0xc6, 0xec, 0x1b, 0x3d, 0x00, 0xd5, 0x0b, 0xe2, 0xc4,
	0xf6, 0x7d, 0x8b, 0x86, 0x41, 0xe2, 0xcd, 0xf8, 0x4a, 0x15, 0xbc, 0x2c, 0xf0, 0xbe, 0x80, 0x29,
	0x89, 0x78, 0xb1, 0x65, 0x3b, 0x89, 0x77, 0x46, 0x18, 0x89, 0x34, 0x70, 0xc3, 0x8b, 0xbb, 0xac,
	0x4d, 0x7d, 0xed, 0xc5, 0x16, 0x25, 0x2d, 0x2f, 0x49, 0x88, 0xab, 0xd5, 0x98, 0xbc, 0xe9, 0xc5,
	0x3d, 0x09, 0xd1, 0x15, 0x79, 0xb1, 0x75, 0x66, 0xfb, 0x9e, 0x2b, 0x82, 0xb2, 0xee, 0xc5, 0x47,
	0xb4, 0x89, 0x54, 0xa8, 0x2c, 0x22, 0x5f, 0xc4, 0x1c, 0xfd, 0x44, 0x37, 0xa1, 0xc6, 0x29, 0x48,
	0x53, 0x18, 0x28, 0x5a, 0x68, 0x0d, 0xaa, 0x4e, 0xe4, 0x3c, 0x7e, 0xa4, 0x01, 0x5b, 0x04, 0x6f,
	0xe8, 0x7f, 0xaf, 0x43, 0x9b, 0x79, 0xa4, 0x1f, 0x9e, 0x07, 0x7e, 0x68, 0xbb, 0x57, 0xce, 0x82,
	0xf4, 0x54, 0x39, 0xe7, 0x29, 0x31, 0x6a, 0x25, 0x1b, 0x55, 0x85, 0x8a, 0x13, 0x39, 0x22, 0x70,
	0xe8, 0x27, 0x1a, 0x42, 0xc7, 0x15, 0x36, 0xad, 0x38, 0xa1, 0x7c, 0x52, 0x65, 0x31, 0xba, 0x25,
	0x77, 0xae, 0x30, 0x6c, 0xb1, 0x35, 0xa2, 0xfa, 0xb8, 0xed, 0xe6, 0x9b, 0xf4, 0x5c, 0x79, 0x54,
	0xc9, 0x92, 0x9b, 0x54, 0x63, 0xc3, 0xb7, 0x18, 0x78, 0x24, 0x76, 0xea, 0x01, 0xa8, 0xb2, 0x17,
	0x71, 0xad, 0xe3, 0x97, 0x94, 0x11, 0xf9, 0x21, 0x58, 0xce, 0xf0, 0x5d, 0x0a, 0xa3, 0x7d, 0xa8,
	0x45, 0xc4, 0x8e, 0xc3, 0x80, 0x79, 0xaf, 0xf3, 0xe8, 0xc3, 0x6f, 0x30, 0xb1, 0x3d, 0xdb, 0xf3,
	0x17, 0x11, 0xc1, 0xac, 0x1f, 0x16, 0xfd, 0xd1, 0xbb, 0xb0, 0x6c, 0xbb, 0xae, 0x97, 0x78, 0x61,
	0x60, 0xfb, 0x96, 0x17, 0x4c, 0x43, 0xe1, 0xfb, 0x4e, 0x06, 0x0f, 0x82, 0x69, 0xc8, 0x69, 0xe6,
	0x8c, 0x58, 0x0e, 0x3b, 0xb2, 0x6c, 0x27, 0x1a, 0x94, 0x66, 0xce, 0x88, 0xa0, 0x86, 0x4d, 0x50,
	0xfc, 0x90, 0x12, 0xb1, 0xeb, 0x45, 0x5a, 0x93, 0x5f, 0x37, 0x0c, 0xe8, 0x7b, 0x11, 0x1a, 0x40,
	0x93, 0x3b, 0x80, 0xbb, 0xb3, 0xf5, 0xb5, 0xee, 0x64, 0x27, 0xcc, 0x4e, 0x08, 0x77, 0x27, 0xb0,
	0xce, 0xdc, 0x97, 0x9b, 0xa0, 0x4c, 0x3d, 0x9f, 0x58, 0xb1, 0xf7, 0x25, 0xd1, 0xda, 0xcc, 0x3f,
	0x0d, 0x0a, 0x8c, 0xbc, 0x2f, 0x89, 0xfe, 0x55, 0x09, 0xd0, 0xd5, 0xed, 0x40, 0x6b, 0xa0, 0xf6,
	0x87, 0x9f, 0x99, 0x07, 0xc3, 0x6e, 0xdf, 0x9a, 0x98, 0x3f, 0x32, 0x87, 0x9f, 0x99, 0xea, 0x0d,
	0x74, 0x13, 0x50, 0x8a, 0x8e, 0x26, 0xbd, 0x9e, 0x61, 0xf4, 0x8d, 0xbe, 0x5a, 0x2a, 0xe0, 0xd8,
	0xf8, 0xf1, 0xc4, 0x18, 0x8d, 0x8d, 0xbe, 0x5a, 0x2e, 0x58, 0x19, 0x8d, 0xbb, 0x98, 0xa2, 0x15,
	0xb4, 0x0a, 0xcb, 0x29, 0xba, 0xd7, 0x1d, 0x1c, 0x18, 0x7d, 0x75, 0x09, 0x69, 0xb0, 0x96, 0x1b,
	0x70, 0x34, 0x39, 0x3c, 0x1c, 0x32, 0xf5, 0x6a, 0xc1, 0x78, 0xaf, 0x6b, 0xf6, 0x8c, 0x03, 0xda,
	0xa3, 0xa6, 0xff, 0xb2, 0x04, 0x1b, 0xaf, 0xde, 0x2f, 0xd4, 0x82, 0x86, 0x39, 0xb4, 0x0c, 0x8c,
	0x87, 0x94, 0xbb, 0x97, 0xa1, 0x39, 0x30, 0x8f, 0xba, 0x07, 0x83, 0xbe, 0x35, 0xc1, 0x07, 0x6a,
	0x89, 0x02, 0x7d, 0xe3, 0x68, 0xd0, 0x33, 0xac, 0xdd, 0xc9, 0xe8, 0x73, 0xb5, 0x4c, 0x87, 0x19,
	0x98, 0xa3, 0xc9, 0xde, 0xde, 0xa0, 0x37, 0x30, 0xcc, 0xb1, 0x35, 0x3a, 0xec, 0xf6, 0x0c, 0xb5,
	0x82, 0x56, 0xa0, 0x2d, 0x1c, 0x20, 0x8c, 0x2d, 0xa1, 0x36, 0x28, 0xd9, 0x44, 0xaa, 0xfa, 0xaf,
	0xa4, 0x0b, 0x0b, 0x5b, 0x40, 0x3b, 0x0e, 0x9e, 0x75, 0x9f, 0x1a, 0x39, 0xff, 0x21, 0xe8, 0x70,
	0x68, 0x60, 0x76, 0x7b, 0xe3, 0xc1, 0x11, 0xbd, 0x4a, 0xd6, 0x40, 0xe5, 0x18, 0x43, 0xba, 0xe3,
	0x81, 0xf9, 0x54, 0x2d, 0x23, 0x15, 0x5a, 0x39, 0xd4, 0xe0, 0x5e, 0xe3, 0x08, 0x36, 0x8e, 0x0c,
	0xcc, 0xd4, 0x96, 0x32, 0x83, 0x1c, 0xa4, 0xd3, 0xf9, 0x7e, 0x59, 0x2b, 0xe9, 0x5d, 0xe8, 0x14,
	0x5c, 0x13, 0xa3, 0x87, 0xf2, 0x1a, 0x2e, 0x17, 0x29, 0xb8, 0xa0, 0x26, 0x6e, 0x62, 0x66, 0xe2,
	0x03, 0xa8, 0x31, 0x59, 0x8c, 0xee, 0x43, 0x95, 0x9d, 0x26, 0x71, 0x83, 0xb7, 0x0b, 0x5d, 0x31,
	0x97, 0xe9, 0x7f, 0x28, 0x41, 0x63, 0x18, 0x2c, 0x38, 0xe1, 0xe6, 0xc8, 0xb5, 0x54, 0x24, 0xd7,
	0xff, 0x03, 0x90, 0x64, 0x47, 0x5c, 0x46, 0x33, 0x0d, 0x9c, 0x43, 0xd0, 0x06, 0xa4, 0x64, 0x29,
	0xae, 0x9a, 0x8c, 0x3c, 0x35, 0x90, 0x4c, 0x28, 0x6e, 0x99, 0x94, 0x18, 0xef, 0x41, 0x73, 0x1e,
	0x85, 0xee, 0xc2, 0x49, 0x7a, 0xa1, 0x4b, 0x44, 0xea, 0x96, 0x87, 0x52, 0x52, 0xe7, 0x34, 0xc2,
	0xbe, 0xf5, 0xc7, 0xa0, 0xc8, 0x19, 0xc7, 0xe8, 0x9d, 0x62, 0x9a, 0x92, 0x5e, 0x39, 0x52, 0x43,
	0x26, 0x29, 0x0e, 0xa8, 0x3c, 0x73, 0x19, 0x14, 0x02, 0x8c, 0x6b, 0x5b, 0x29, 0x99, 0x36, 0x38,
	0x30, 0x70, 0xd1, 0x23, 0xc8, 0xc5, 0x22, 0x5b, 0x71, 0x2e, 0x09, 0xca, 0x8c, 0xe4, 0x23, 0x56,
	0xff, 0x59, 0x03, 0x20, 0x67, 0xff, 0xd5, 0xee, 0x3c, 0xb8, 0xc2, 0xbb, 0x3c, 0x37, 0x7a, 0xfb,
	0xea, 0x00, 0xdf, 0x80, 0x74, 0x7f, 0x90, 0x92, 0x64, 0xe5, 0xf5, 0x56, 0xae, 0x67, 0xc6, 0xfd,
	0x22, 0x65, 0x2d, 0x31, 0x1b, 0xef, 0xbe, 0xca, 0x86, 0x08, 0x16, 0x2f, 0x0c, 0xae, 0xae, 0xff,
	0x2f, 0xff, 0xf3, 0xa4, 0x74, 0x0b, 0x56, 0x2f, 0x93, 0x12, 0x8d, 0xc8, 0xda, 0x2b, 0xd8, 0xaa,
	0xae, 0xff, 0x53, 0x2e, 0xe9, 0xbf, 0xc6, 0x52, 0x1a, 0xac, 0xa5, 0x13, 0xb0, 0x86, 0xa6, 0xf4,
	0x81, 0x5a, 0x45, 0x1b, 0x70, 0xb3, 0x20, 0x19, 0x9a, 0x13, 0x8b, 0xa7, 0xb3, 0x35, 0x2a, 0x3b,
	0x32, 0xcc, 0xfe, 0x10, 0x5b, 0x62, 0xe0, 0x67, 0x83, 0xd1, 0xb3, 0xee, 0xb8, 0xb7, 0xaf, 0xd6,
	0xe9, 0xa2, 0x87, 0xcf, 0x7a, 0x03, 0x6b, 0x8c, 0xbb, 0xe6, 0x68, 0xcf, 0xc0, 0x62, 0xa8, 0x06,
	0x1d, 0x4a, 0xd2, 0xd0, 0xde, 0x64, 0x64, 0xf4, 0xad, 0xdd, 0xcf, 0xa9, 0x51, 0x55, 0xd1, 0xff,
	0x58, 0x86, 0xb5, 0xeb, 0xb6, 0xfb, 0x3f, 0xcd, 0x8e, 0xa9, 0x5e, 0x6f, 0xf8, 0xec, 0xd9, 0x60,
	0x2c, 0xe8, 0x31, 0xe5, 0x4c, 0x81, 0xb2, 0xad, 0xbb, 0x03, 0xb7, 0x8b, 0x26, 0x87, 0xa6, 0xd5,
	0xdd, 0x1d, 0x72, 0x4a, 0xad, 0xa1, 0x37, 0x40, 0xbb, 0x5e, 0x4c, 0xb7, 0x11, 0xdd, 0x86, 0xf5,
	0xbc, 0xc5, 0xac, 0x63, 0xce, 0x09, 0x79, 0x91, 0xd1, 0x57, 0x15, 0xb4, 0x0e, 0x2b, 0x5c, 0x22,
	0x4f, 0x06, 0xed, 0x00, 0xd9, 0x44, 0x72, 0x70, 0xda, 0xab, 0xa9, 0x7f, 0x55, 0x85, 0xa5, 0xc3,
	0x30, 0x4a, 0xd0, 0x2d, 0xa8, 0xcf, 0xc3, 0x28, 0xb1, 0x82, 0x90, 0x85, 0x7f, 0x1b, 0xd7, 0x68,
	0xd3, 0x0c, 0x69, 0x96, 0xe7, 0xdb, 0xc7, 0xc4, 0x17, 0xe9, 0x1a, 0x6f, 0xa0, 0x07, 0xa2, 0x4a,
	0xe2, 0x31, 0x9c, 0xe5, 0xda, 0x61, 0x94, 0xb0, 0x9f, 0x5c, 0x8d, 0xf4, 0x3d, 0x68, 0xda, 0xee,
	0xcc, 0x0b, 0x0a, 0x39, 0x9b, 0xb6, 0x2d, 0x8a, 0xea, 0x2e, 0x15, 0xf1, 0x88, 0x65, 0xa5, 0x1c,
	0x06, 0x3b, 0x45, 0x68, 0xd7, 0x70, 0x4e, 0x22, 0xd6, 0x73, 0x11, 0x33, 0x5e, 0xcd, 0x75, 0x1d,
	0xce, 0x49, 0x34, 0x62, 0x12, 0xd9, 0x35, 0x4c, 0x91, 0x22, 0x5d, 0xd6, 0x2f, 0xd1, 0xe5, 0x43,
	0xa8, 0xce, 0x09, 0x89, 0x62, 0xad, 0x71, 0xa9, 0x54, 0x60, 0xd3, 0x27, 0x24, 0xa2, 0x1f, 0x98,
	0xeb, 0xd0, 0xea, 0x29, 0xba, 0xb0, 0xe6, 0xb6, 0xf3, 0x9c, 0x24, 0x31, 0x4b, 0xc3, 0x6a, 0x58,
	0x89, 0x2e, 0x0e, 0x39, 0x40, 0x53, 0xe9, 0xe8, 0x42, 0xe4, 0x85, 0xc0, 0x84, 0xf5, 0xe8, 0x82,
	0xe7, 0x83, 0x9b, 0xa0, 0x44, 0x17, 0x16, 0x89, 0xa2, 0x30, 0x8a, 0x59, 0xee, 0x55, 0xc3, 0x8d,
	0xe8, 0xc2, 0x60, 0x6d, 0x6a, 0x36, 0xc9, 0xcc, 0xb6, 0xb8, 0xd9, 0x24, 0x6f, 0x36, 0x91, 0x66,
	0xdb, 0xdc, 0x6c, 0x92, 0x99, 0x4d, 0x52, 0xb3, 0x1d, 0x6e, 0x36, 0x91, 0x66, 0x3f, 0x84, 0x46,
	0x38, 0x9d, 0x5b, 0x74, 0xf3, 0xb4, 0x65, 0x76, 0x0f, 0xac, 0x6f, 0xe7, 0xdf, 0x28, 0xa4, 0x10,
	0xd7, 0xc3, 0xe9, 0x9c, 0x2e, 0x73, 0xe3, 0x09, 0x34, 0xe4, 0x92, 0x5f, 0x7f, 0xc9, 0xe4, 0x8e,
	0x48, 0x39, 0x7f, 0x44, 0xf4, 0x18, 0x1a, 0x72, 0xcf, 0x69, 0xa5, 0x9a, 0x05, 0x9b, 0x0a, 0x2d,
	0x63, 0xbc, 0x6f, 0x60, 0xd3, 0x18, 0x5b, 0xa6, 0x39, 0x50, 0x4b, 0x05, 0x64, 0x62, 0x0e, 0x78,
	0x69, 0x7b, 0x48, 0xe9, 0xe1, 0x60, 0xac, 0x56, 0xd2, 0x86, 0x39, 0xe1, 0x19, 0xd0, 0x91, 0x41,
	0x15, 0xa9, 0xac, 0x9a, 0x6b, 0x9a, 0x13, 0xb5, 0xa6, 0x3f, 0x84, 0x2a, 0x1d, 0x34, 0x46, 0x7a,
	0xf1, 0x52, 0x6d, 0xe5, 0x37, 0x53, 0x5e, 0xa8, 0x7f, 0x05, 0xa8, 0xf1, 0x1b, 0xf5, 0xba, 0x6a,
	0x24, 0xad, 0xf7, 0x15, 0x71, 0x64, 0x11, 0x2c, 0x45, 0x61, 0x98, 0x88, 0xe4, 0x80, 0x7d, 0x53,
	0xd7, 0xcc, 0xed, 0x88, 0x04, 0x89, 0x25, 0x52, 0x03, 0x05, 0x37, 0x38, 0x30, 0x70, 0xd1, 0x5b,
	0xd0, 0x11, 0x42, 0xe9, 0xa1, 0x35, 0xe6, 0xa1, 0x16, 0x47, 0x0f, 0x79, 0x28, 0x65, 0x85, 0x54,
	0xf5, 0x72, 0x21, 0x35, 0x0b, 0x5d, 0xe2, 0x8b, 0xc4, 0x81, 0x37, 0x68, 0xe1, 0x71, 0x6a, 0x47,
	0xee, 0xb9, 0x1d, 0x65, 0x05, 0x0a, 0x3f, 0xc8, 0xcb, 0x12, 0xcf, 0xd5, 0x28, 0x53, 0x2f, 0x9a,
	0x15, 0x54, 0x79, 0x01, 0xb7, 0x2c, 0x71, 0xa9, 0xfa, 0x0e, 0xd4, 0xd8, 0x1d, 0xc8, 0x4f, 0x72,
	0xf3, 0x51, 0xa7, 0x70, 0x75, 0xc6, 0x58, 0x48, 0x69, 0x6d, 0x14, 0x93, 0xc8, 0xb3, 0x7d, 0x2b,
	0x58, 0xcc, 0x8e, 0x49, 0xc4, 0xce, 0xb6, 0x82, 0x5b, 0x1c, 0x34, 0x19, 0x56, 0x7c, 0xcb, 0xd2,
	0x2e, 0xbd, 0x65, 0x3d, 0x00, 0x55, 0xbe, 0xe2, 0x90, 0xc0, 0x9d, 0x87, 0x5e, 0x90, 0x68, 0xb7,
	0xf9, 0xa4, 0x04, 0x6e, 0x08, 0x98, 0xfa, 0xfb, 0xcc, 0xb7, 0x03, 0x16, 0x05, 0x6d, 0xcc, 0xbe,
	0x69, 0x65, 0x33, 0xb3, 0x1d, 0xcb, 0x76, 0xdd, 0x88, 0xc4, 0x3c, 0x06, 0x14, 0x0c, 0x33, 0xdb,
	0xe9, 0x72, 0x04, 0xdd, 0x87, 0x96, 0x37, 0x3f, 0xfb, 0xff, 0x54, 0x83, 0x46, 0x82, 0xb2, 0x7f,
	0x03, 0x37, 0x29, 0x5a, 0x54, 0xfa, 0x38, 0x55, 0x5a, 0xce, 0x29, 0x7d, 0x2c, 0x95, 0xde, 0x82,
	0xf6, 0x69, 0x18, 0x27, 0x96, 0x1d, 0xb8, 0x3c, 0x70, 0xd6, 0xa5, 0x16, 0x85, 0xbb, 0x81, 0xcb,
	0x62, 0xe3, 0x0e, 0x00, 0xb9, 0x48, 0x22, 0xdb, 0xb2, 0xa3, 0x93, 0x58, 0xbb, 0xc5, 0x1f, 0x59,
	0x18, 0xd2, 0x8d, 0x4e, 0x62, 0xf4, 0x04, 0xda, 0xf3, 0x28, 0xbc, 0x78, 0x99, 0x0e, 0xb5, 0xca,
	0xfc, 0xbb, 0x59, 0x7c, 0x8a, 0xda, 0x3e, 0xa4, 0x3a, 0x62, 0x60, 0xdc, 0x9a, 0xe7, 0x5a, 0x97,
	0x89, 0x52, 0xfd, 0xf7, 0x89, 0x72, 0xe5, 0x5b, 0x10, 0xe5, 0xcd, 0x34, 0x1f, 0xbb, 0xc9, 0x0f,
	0xa5, 0x48, 0xb4, 0x76, 0xa1, 0xe3, 0x84, 0x41, 0x40, 0x9c, 0x44, 0x5a, 0x45, 0xcc, 0xea, 0xa6,
	0xb4, 0xda, 0xe3, 0xd2, 0x82, 0xe1, 0xb6, 0x93, 0x07, 0xd1, 0xfb, 0x50, 0x73, 0x16, 0x71, 0x12,
	0xce, 0xb4, 0x27, 0xcc, 0x19, 0x6b, 0xdb, 0xfc, 0xcd, 0x75, 0x5b, 0xbe, 0xb9, 0x6e, 0x77, 0x83,
	0x97, 0x58, 0xe8, 0xa0, 0x8f, 0x00, 0xe6, 0x33, 0x51, 0xc9, 0xc6, 0xda, 0xcf, 0x4b, 0xac, 0xcb,
	0xca, 0xe5, 0x67, 0x99, 0x18, 0x2b, 0xf3, 0xf4, 0x99, 0xe9, 0x53, 0x58, 0xe6, 0xd9, 0xa0, 0xcc,
	0x31, 0x63, 0xed, 0x17, 0xa5, 0xd7, 0xd5, 0x1e, 0x1d, 0xaf, 0x50, 0xb1, 0x6c, 0xfc, 0xbe, 0x0c,
	0xad, 0xfc, 0x96, 0xbc, 0x9e, 0x01, 0xef, 0x42, 0x53, 0x08, 0x73, 0x94, 0x01, 0x6e, 0xf6, 0xd8,
	0x7b, 0x07, 0xc0, 0x39, 0xb5, 0x83, 0x80, 0xf8, 0xb4, 0x3b, 0x7f, 0xdc, 0x51, 0x04, 0x32, 0x70,
	0xd1, 0x16, 0xa8, 0x52, 0xcc, 0x1f, 0xe4, 0x04, 0x95, 0xb4, 0x71, 0x47, 0xe0, 0xec, 0xa9, 0x6a,
	0xe0, 0xa2, 0x1d, 0x58, 0x95, 0x9a, 0x09, 0x89, 0x66, 0x5e, 0xc0, 0xb2, 0x1a, 0xc1, 0x1b, 0x48,
	0x88, 0xc6, 0x99, 0x04, 0xad, 0x43, 0x2d, 0x0c, 0x16, 0xd4, 0x60, 0x8d, 0xbf, 0xc6, 0x84, 0xc1,
	0x82, 0x13, 0x13, 0x85, 0x63, 0x12, 0xd3, 0xe8, 0x97, 0x77, 0x61, 0x1b, 0xb7, 0xc2, 0x60, 0x31,
	0xe2, 0xe0, 0x2b, 0x42, 0xb5, 0x71, 0x6d, 0xa8, 0xee, 0x2a, 0x50, 0x17, 0x07, 0xfc, 0x87, 0x4b,
	0x8d, 0xa6, 0xda, 0xd2, 0xff, 0x5c, 0x82, 0x8d, 0x5c, 0xb1, 0x92, 0x7a, 0x9a, 0xbc, 0x58, 0x90,
	0x38, 0x41, 0xef, 0x16, 0xfd, 0x49, 0xb7, 0x06, 0xe4, 0x09, 0x1a, 0xf4, 0x73, 0xbe, 0x4d, 0x0b,
	0x40, 0x5e, 0xbd, 0x5c, 0x5b, 0x00, 0xa2, 0xf7, 0x61, 0xc5, 0x16, 0xf5, 0xef, 0x30, 0x18, 0x2d,
	0x1c, 0x87, 0x06, 0x1a, 0x67, 0xe9, 0xab, 0x02, 0xb4, 0x05, 0xcb, 0xfc, 0x15, 0x2c, 0xd3, 0xe5,
	0x35, 0xdd, 0x65, 0x58, 0xff, 0x69, 0x09, 0x50, 0x6e, 0x11, 0xdf, 0x7a, 0xf2, 0xaf, 0x7e, 0xe8,
	0xbb, 0x66, 0x0e, 0x95, 0xeb, 0xe7, 0x60, 0xc1, 0x6a, 0x61, 0x0a, 0xf1, 0x3c, 0x0c, 0x62, 0x82,
	0xf6, 0x61, 0x55, 0xce, 0x21, 0xab, 0x7b, 0xe4, 0x65, 0xa7, 0x15, 0xd9, 0x25, 0x57, 0xe9, 0xad,
	0xb8, 0x97, 0x90, 0x58, 0xff, 0x6d, 0x09, 0xd4, 0x11, 0xf1, 0xa7, 0x63, 0x12, 0x27, 0xa9, 0xf9,
	0x4f, 0x69, 0xf8, 0xc7, 0x0b, 0x3f, 0x61, 0x87, 0x3d, 0x57, 0x4a, 0x5d, 0xd6, 0xcc, 0x03, 0x0b,
	0x3f, 0xc1, 0xa2, 0x9b, 0x7e, 0x08, 0x9d, 0xa2, 0x84, 0x5e, 0xe2, 0xac, 0x44, 0x1a, 0x8d, 0xd4,
	0x1b, 0xb4, 0x41, 0x2b, 0x9d, 0x09, 0xa6, 0x89, 0xf6, 0x0a, 0xb4, 0xcd, 0xe1, 0xd8, 0xca, 0x6a,
	0x9c, 0xf2, 0xd5, 0x9a, 0xa2, 0xa2, 0xef, 0x40, 0x9d, 0x2f, 0x87, 0x32, 0x73, 0xe1, 0x6e, 0xef,
	0x14, 0x97, 0x2b, 0x6f, 0xf7, 0xdf, 0x55, 0x60, 0x6d, 0xe4, 0xcd, 0x16, 0xbe, 0x9d, 0x90, 0xae,
	0x6f, 0x47, 0x33, 0xb9, 0x7f, 0x97, 0xef, 0xfa, 0x37, 0x40, 0xf1, 0x02, 0xd7, 0x73, 0xec, 0x24,
	0x94, 0xff, 0xa0, 0x64, 0x00, 0xcd, 0x6f, 0xbc, 0x20, 0x99, 0xca, 0xc8, 0x55, 0x70, 0x8d, 0x36,
	0xc5, 0xed, 0x4e, 0xaf, 0x75, 0x1a, 0xf4, 0xfc, 0x89, 0x9d, 0xdf, 0xff, 0xad, 0xb9, 0xc8, 0x7a,
	0xd8, 0x2b, 0xbb, 0x0e, 0x6d, 0x1a, 0x6a, 0xd9, 0x81, 0x11, 0x2f, 0x04, 0x61, 0xb0, 0xe8, 0xcb,
	0x73, 0xf2, 0x18, 0x6e, 0x7a, 0x01, 0x3d, 0x1a, 0xc4, 0x3a, 0xf6, 0x12, 0x9e, 0xc3, 0x59, 0x11,
	0x65, 0x7b, 0x1a, 0xb5, 0x55, 0xbc, 0x2a, 0xa4, 0xbb, 0x5e, 0xc2, 0xf2, 0x39, 0xcc, 0x2b, 0xd2,
	0xaa, 0x1b, 0x79, 0xd3, 0x84, 0x85, 0x6e, 0x15, 0xf3, 0x06, 0x9d, 0x6d, 0x40, 0xce, 0x2d, 0xf2,
	0xc2, 0x65, 0xa1, 0x5a, 0xc5, 0xb5, 0x80, 0x9c, 0x1b, 0x2f, 0x5c, 0xf4, 0x1e, 0xac, 0xf0, 0x90,
	0xcf, 0xdf, 0xde, 0xfc, 0xf5, 0x70, 0x99, 0x45, 0x7d, 0xee, 0x02, 0xdf, 0x07, 0x85, 0x5e, 0x05,
	0x9c, 0x5c, 0x80, 0x1d, 0x80, 0xf7, 0xd2, 0x03, 0x70, 0x8d, 0x47, 0xd9, 0x55, 0xc2, 0xb4, 0x59,
	0x82, 0x9f, 0x75, 0xd6, 0xdf, 0x86, 0x76, 0x41, 0x86, 0x14, 0xa8, 0xe2, 0xee, 0x60, 0x64, 0xf0,
	0xff, 0x34, 0x7a, 0x07, 0x46, 0x17, 0xab, 0xa5, 0xdd, 0x2f, 0x60, 0x23, 0x8c, 0x4e, 0x58, 0x46,
	0xea, 0x84, 0x91, 0xbb, 0xcd, 0xff, 0x4c, 0x13, 0x43, 0xee, 0xb6, 0x8e, 0x58, 0x93, 0xbb, 0xeb,
	0x8b, 0xed, 0x13, 0x2f, 0x39, 0x5d, 0x1c, 0xd3, 0x80, 0xdb, 0x91, 0x1d, 0x76, 0x78, 0x87, 0x0f,
	0xc4, 0xbf, 0x6f, 0x67, 0xdf, 0xd9, 0x39, 0x09, 0x05, 0x76, 0x5c, 0x63, 0xe0, 0xe3, 0x7f, 0x05,
	0x00, 0x00, 0xff, 0xff, 0x01, 0xc2, 0x5e, 0x57, 0xfd, 0x1b, 0x00, 0x00,
}
