/*
* Copyright 2022-present Open Networking Foundation
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
 */

// Code generated by MockGen. DO NOT EDIT.
// Source: /home/aksoni/var/work/gerrit/voltha-go-controller/internal/pkg/application/application.go

// Package mock_application is a generated GoMock package.
package mocks

import (
	context "context"
	reflect "reflect"
	application "voltha-go-controller/internal/pkg/application"
	of "voltha-go-controller/internal/pkg/of"
	common "voltha-go-controller/internal/pkg/types"

	gomock "github.com/golang/mock/gomock"
)

// MockVoltDevInterface is a mock of VoltDevInterface interface.
type MockVoltDevInterface struct {
	ctrl     *gomock.Controller
	recorder *MockVoltDevInterfaceMockRecorder
}

// MockVoltDevInterfaceMockRecorder is the mock recorder for MockVoltDevInterface.
type MockVoltDevInterfaceMockRecorder struct {
	mock *MockVoltDevInterface
}

// NewMockVoltDevInterface creates a new mock instance.
func NewMockVoltDevInterface(ctrl *gomock.Controller) *MockVoltDevInterface {
	mock := &MockVoltDevInterface{ctrl: ctrl}
	mock.recorder = &MockVoltDevInterfaceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockVoltDevInterface) EXPECT() *MockVoltDevInterfaceMockRecorder {
	return m.recorder
}

// GetPortNameFromPortID mocks base method.
func (m *MockVoltDevInterface) GetPortNameFromPortID(portID uint32) string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPortNameFromPortID", portID)
	ret0, _ := ret[0].(string)
	return ret0
}

// GetPortNameFromPortID indicates an expected call of GetPortNameFromPortID.
func (mr *MockVoltDevInterfaceMockRecorder) GetPortNameFromPortID(portID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPortNameFromPortID", reflect.TypeOf((*MockVoltDevInterface)(nil).GetPortNameFromPortID), portID)
}

// MockVoltAppInterface is a mock of VoltAppInterface interface.
type MockVoltAppInterface struct {
	ctrl     *gomock.Controller
	recorder *MockVoltAppInterfaceMockRecorder
}

// MockVoltAppInterfaceMockRecorder is the mock recorder for MockVoltAppInterface.
type MockVoltAppInterfaceMockRecorder struct {
	mock *MockVoltAppInterface
}

// NewMockVoltAppInterface creates a new mock instance.
func NewMockVoltAppInterface(ctrl *gomock.Controller) *MockVoltAppInterface {
	mock := &MockVoltAppInterface{ctrl: ctrl}
	mock.recorder = &MockVoltAppInterfaceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockVoltAppInterface) EXPECT() *MockVoltAppInterfaceMockRecorder {
	return m.recorder
}

// ActivateService mocks base method.
func (m *MockVoltAppInterface) ActivateService(cntx context.Context, deviceID, portNo string, sVlan, cVlan of.VlanType, tpID uint16) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ActivateService", cntx, deviceID, portNo, sVlan, cVlan, tpID)
	ret0, _ := ret[0].(error)
	return ret0
}

// ActivateService indicates an expected call of ActivateService.
func (mr *MockVoltAppInterfaceMockRecorder) ActivateService(cntx, deviceID, portNo, sVlan, cVlan, tpID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActivateService", reflect.TypeOf((*MockVoltAppInterface)(nil).ActivateService), cntx, deviceID, portNo, sVlan, cVlan, tpID)
}

// AddDeviceConfig mocks base method.
func (m *MockVoltAppInterface) AddDeviceConfig(cntx context.Context, serialNum, hardwareIdentifier, nasID, ipAddress, uplinkPort string, nniDhcpTrapID uint16) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddDeviceConfig", cntx, serialNum, hardwareIdentifier, nasID, ipAddress, uplinkPort, nniDhcpTrapID)
	ret0, _ := ret[0].(error)
	return ret0
}

// AddDeviceConfig indicates an expected call of AddDeviceConfig.
func (mr *MockVoltAppInterfaceMockRecorder) AddDeviceConfig(cntx, serialNum, hardwareIdentifier, nasID, ipAddress, uplinkPort, nniDhcpTrapID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddDeviceConfig", reflect.TypeOf((*MockVoltAppInterface)(nil).AddDeviceConfig), cntx, serialNum, hardwareIdentifier, nasID, ipAddress, uplinkPort, nniDhcpTrapID)
}

// AddMcastConfig mocks base method.
func (m *MockVoltAppInterface) AddMcastConfig(cntx context.Context, MvlanProfileID, IgmpProfileID, IgmpProxyIP, OltSerialNum string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddMcastConfig", cntx, MvlanProfileID, IgmpProfileID, IgmpProxyIP, OltSerialNum)
	ret0, _ := ret[0].(error)
	return ret0
}

// AddMcastConfig indicates an expected call of AddMcastConfig.
func (mr *MockVoltAppInterfaceMockRecorder) AddMcastConfig(cntx, MvlanProfileID, IgmpProfileID, IgmpProxyIP, OltSerialNum interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddMcastConfig", reflect.TypeOf((*MockVoltAppInterface)(nil).AddMcastConfig), cntx, MvlanProfileID, IgmpProfileID, IgmpProxyIP, OltSerialNum)
}

// AddMeterProf mocks base method.
func (m *MockVoltAppInterface) AddMeterProf(cntx context.Context, cfg application.VoltMeter) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "AddMeterProf", cntx, cfg)
}

// AddMeterProf indicates an expected call of AddMeterProf.
func (mr *MockVoltAppInterfaceMockRecorder) AddMeterProf(cntx, cfg interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddMeterProf", reflect.TypeOf((*MockVoltAppInterface)(nil).AddMeterProf), cntx, cfg)
}

// AddMvlanProfile mocks base method.
func (m *MockVoltAppInterface) AddMvlanProfile(cntx context.Context, name string, mvlan, ponVlan of.VlanType, groups map[string][]string, isChannelBasedGroup bool, OLTSerialNum []string, activeChannelsPerPon uint32, proxy map[string]common.MulticastGroupProxy) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddMvlanProfile", cntx, name, mvlan, ponVlan, groups, isChannelBasedGroup, OLTSerialNum, activeChannelsPerPon, proxy)
	ret0, _ := ret[0].(error)
	return ret0
}

// AddMvlanProfile indicates an expected call of AddMvlanProfile.
func (mr *MockVoltAppInterfaceMockRecorder) AddMvlanProfile(cntx, name, mvlan, ponVlan, groups, isChannelBasedGroup, OLTSerialNum, activeChannelsPerPon, proxy interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddMvlanProfile", reflect.TypeOf((*MockVoltAppInterface)(nil).AddMvlanProfile), cntx, name, mvlan, ponVlan, groups, isChannelBasedGroup, OLTSerialNum, activeChannelsPerPon, proxy)
}

// AddService mocks base method.
func (m *MockVoltAppInterface) AddService(cntx context.Context, cfg application.VoltServiceCfg, oper *application.VoltServiceOper) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddService", cntx, cfg, oper)
	ret0, _ := ret[0].(error)
	return ret0
}

// AddService indicates an expected call of AddService.
func (mr *MockVoltAppInterfaceMockRecorder) AddService(cntx, cfg, oper interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddService", reflect.TypeOf((*MockVoltAppInterface)(nil).AddService), cntx, cfg, oper)
}

// AddVnet mocks base method.
func (m *MockVoltAppInterface) AddVnet(cntx context.Context, cfg application.VnetConfig, oper *application.VnetOper) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddVnet", cntx, cfg, oper)
	ret0, _ := ret[0].(error)
	return ret0
}

// AddVnet indicates an expected call of AddVnet.
func (mr *MockVoltAppInterfaceMockRecorder) AddVnet(cntx, cfg, oper interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddVnet", reflect.TypeOf((*MockVoltAppInterface)(nil).AddVnet), cntx, cfg, oper)
}

// DeactivateService mocks base method.
func (m *MockVoltAppInterface) DeactivateService(cntx context.Context, deviceID, portNo string, sVlan, cVlan of.VlanType, tpID uint16) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeactivateService", cntx, deviceID, portNo, sVlan, cVlan, tpID)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeactivateService indicates an expected call of DeactivateService.
func (mr *MockVoltAppInterfaceMockRecorder) DeactivateService(cntx, deviceID, portNo, sVlan, cVlan, tpID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeactivateService", reflect.TypeOf((*MockVoltAppInterface)(nil).DeactivateService), cntx, deviceID, portNo, sVlan, cVlan, tpID)
}

// DelMeterProf mocks base method.
func (m *MockVoltAppInterface) DelMeterProf(cntx context.Context, name string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DelMeterProf", cntx, name)
	ret0, _ := ret[0].(error)
	return ret0
}

// DelMeterProf indicates an expected call of DelMeterProf.
func (mr *MockVoltAppInterfaceMockRecorder) DelMeterProf(cntx, name interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DelMeterProf", reflect.TypeOf((*MockVoltAppInterface)(nil).DelMeterProf), cntx, name)
}

// DelMvlanProfile mocks base method.
func (m *MockVoltAppInterface) DelMvlanProfile(cntx context.Context, name string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DelMvlanProfile", cntx, name)
	ret0, _ := ret[0].(error)
	return ret0
}

// DelMvlanProfile indicates an expected call of DelMvlanProfile.
func (mr *MockVoltAppInterfaceMockRecorder) DelMvlanProfile(cntx, name interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DelMvlanProfile", reflect.TypeOf((*MockVoltAppInterface)(nil).DelMvlanProfile), cntx, name)
}

// DelServiceWithPrefix mocks base method.
func (m *MockVoltAppInterface) DelServiceWithPrefix(cntx context.Context, prefix string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DelServiceWithPrefix", cntx, prefix)
	ret0, _ := ret[0].(error)
	return ret0
}

// DelServiceWithPrefix indicates an expected call of DelServiceWithPrefix.
func (mr *MockVoltAppInterfaceMockRecorder) DelServiceWithPrefix(cntx, prefix interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DelServiceWithPrefix", reflect.TypeOf((*MockVoltAppInterface)(nil).DelServiceWithPrefix), cntx, prefix)
}

// GetAllMacLearnerInfo mocks base method.
func (m *MockVoltAppInterface) GetAllMacLearnerInfo() ([]application.MacLearnerInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllMacLearnerInfo")
	ret0, _ := ret[0].([]application.MacLearnerInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllMacLearnerInfo indicates an expected call of GetAllMacLearnerInfo.
func (mr *MockVoltAppInterfaceMockRecorder) GetAllMacLearnerInfo() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllMacLearnerInfo", reflect.TypeOf((*MockVoltAppInterface)(nil).GetAllMacLearnerInfo))
}

// GetAllocations mocks base method.
func (m *MockVoltAppInterface) GetAllocations(cntx context.Context, deviceID string) ([]application.DhcpAllocation, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllocations", cntx, deviceID)
	ret0, _ := ret[0].([]application.DhcpAllocation)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllocations indicates an expected call of GetAllocations.
func (mr *MockVoltAppInterfaceMockRecorder) GetAllocations(cntx, deviceID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllocations", reflect.TypeOf((*MockVoltAppInterface)(nil).GetAllocations), cntx, deviceID)
}

// GetDevice mocks base method.
func (m *MockVoltAppInterface) GetDevice(device string) *application.VoltDevice {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDevice", device)
	ret0, _ := ret[0].(*application.VoltDevice)
	return ret0
}

// GetDevice indicates an expected call of GetDevice.
func (mr *MockVoltAppInterfaceMockRecorder) GetDevice(device interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDevice", reflect.TypeOf((*MockVoltAppInterface)(nil).GetDevice), device)
}

// GetDeviceConfig mocks base method.
func (m *MockVoltAppInterface) GetDeviceConfig(serNum string) *application.DeviceConfig {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDeviceConfig", serNum)
	ret0, _ := ret[0].(*application.DeviceConfig)
	return ret0
}

// GetDeviceConfig indicates an expected call of GetDeviceConfig.
func (mr *MockVoltAppInterfaceMockRecorder) GetDeviceConfig(serNum interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDeviceConfig", reflect.TypeOf((*MockVoltAppInterface)(nil).GetDeviceConfig), serNum)
}

// GetFlowProvisionStatus mocks base method.
func (m *MockVoltAppInterface) GetFlowProvisionStatus(portNo string) application.FlowProvisionStatus {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetFlowProvisionStatus", portNo)
	ret0, _ := ret[0].(application.FlowProvisionStatus)
	return ret0
}

// GetFlowProvisionStatus indicates an expected call of GetFlowProvisionStatus.
func (mr *MockVoltAppInterfaceMockRecorder) GetFlowProvisionStatus(portNo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetFlowProvisionStatus", reflect.TypeOf((*MockVoltAppInterface)(nil).GetFlowProvisionStatus), portNo)
}

// GetIgnoredPorts mocks base method.
func (m *MockVoltAppInterface) GetIgnoredPorts() (map[string][]string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIgnoredPorts")
	ret0, _ := ret[0].(map[string][]string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetIgnoredPorts indicates an expected call of GetIgnoredPorts.
func (mr *MockVoltAppInterfaceMockRecorder) GetIgnoredPorts() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIgnoredPorts", reflect.TypeOf((*MockVoltAppInterface)(nil).GetIgnoredPorts))
}

// GetMacLearnerInfo mocks base method.
func (m *MockVoltAppInterface) GetMacLearnerInfo(cntx context.Context, deviceID, portNumber, vlanID string) (application.MacLearnerInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMacLearnerInfo", cntx, deviceID, portNumber, vlanID)
	ret0, _ := ret[0].(application.MacLearnerInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMacLearnerInfo indicates an expected call of GetMacLearnerInfo.
func (mr *MockVoltAppInterfaceMockRecorder) GetMacLearnerInfo(cntx, deviceID, portNumber, vlanID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMacLearnerInfo", reflect.TypeOf((*MockVoltAppInterface)(nil).GetMacLearnerInfo), cntx, deviceID, portNumber, vlanID)
}

// GetMeterByName mocks base method.
func (m *MockVoltAppInterface) GetMeterByName(name string) (*application.VoltMeter, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMeterByName", name)
	ret0, _ := ret[0].(*application.VoltMeter)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetMeterByName indicates an expected call of GetMeterByName.
func (mr *MockVoltAppInterfaceMockRecorder) GetMeterByName(name interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMeterByName", reflect.TypeOf((*MockVoltAppInterface)(nil).GetMeterByName), name)
}

// GetMvlanProfileByTag mocks base method.
func (m *MockVoltAppInterface) GetMvlanProfileByTag(vlan of.VlanType) *application.MvlanProfile {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMvlanProfileByTag", vlan)
	ret0, _ := ret[0].(*application.MvlanProfile)
	return ret0
}

// GetMvlanProfileByTag indicates an expected call of GetMvlanProfileByTag.
func (mr *MockVoltAppInterfaceMockRecorder) GetMvlanProfileByTag(vlan interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMvlanProfileByTag", reflect.TypeOf((*MockVoltAppInterface)(nil).GetMvlanProfileByTag), vlan)
}

// GetProgrammedSubscribers mocks base method.
func (m *MockVoltAppInterface) GetProgrammedSubscribers(cntx context.Context, deviceID, portNo string) ([]*application.VoltService, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetProgrammedSubscribers", cntx, deviceID, portNo)
	ret0, _ := ret[0].([]*application.VoltService)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetProgrammedSubscribers indicates an expected call of GetProgrammedSubscribers.
func (mr *MockVoltAppInterfaceMockRecorder) GetProgrammedSubscribers(cntx, deviceID, portNo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetProgrammedSubscribers", reflect.TypeOf((*MockVoltAppInterface)(nil).GetProgrammedSubscribers), cntx, deviceID, portNo)
}

// GetTaskList mocks base method.
func (m *MockVoltAppInterface) GetTaskList(device string) map[int]*application.TaskInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTaskList", device)
	ret0, _ := ret[0].(map[int]*application.TaskInfo)
	return ret0
}

// GetTaskList indicates an expected call of GetTaskList.
func (mr *MockVoltAppInterfaceMockRecorder) GetTaskList(device interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTaskList", reflect.TypeOf((*MockVoltAppInterface)(nil).GetTaskList), device)
}

// UpdateDeviceConfig mocks base method.
func (m *MockVoltAppInterface) UpdateDeviceConfig(cntx context.Context, deviceConfig *application.DeviceConfig) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateDeviceConfig", cntx, deviceConfig)
}

// UpdateDeviceConfig indicates an expected call of UpdateDeviceConfig.
func (mr *MockVoltAppInterfaceMockRecorder) UpdateDeviceConfig(cntx, deviceConfig interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDeviceConfig", reflect.TypeOf((*MockVoltAppInterface)(nil).UpdateDeviceConfig), cntx, deviceConfig)
}

// UpdateOltFlowService mocks base method.
func (m *MockVoltAppInterface) UpdateOltFlowService(cntx context.Context, oltFlowService application.OltFlowService) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateOltFlowService", cntx, oltFlowService)
}

// UpdateOltFlowService indicates an expected call of UpdateOltFlowService.
func (mr *MockVoltAppInterfaceMockRecorder) UpdateOltFlowService(cntx, oltFlowService interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateOltFlowService", reflect.TypeOf((*MockVoltAppInterface)(nil).UpdateOltFlowService), cntx, oltFlowService)
}
