// Copyright (c) 2008 The Board of Trustees of The Leland Stanford
// Junior University
// Copyright 2011-2024 Open Networking Foundation (ONF) and the ONF Contributors
//
// We are making the OpenFlow specification and associated documentation
// (Software) available for public use and benefit with the expectation
// that others will use, modify and enhance the Software and contribute
// those enhancements back to the community. However, since we would
// like to make the Software available for broadest use, with as few
// restrictions as possible permission is hereby granted, free of
// charge, to any person obtaining a copy of this Software to deal in
// the Software under the copyrights without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
// BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// The name and trademarks of copyright holder(s) may NOT be used in
// advertising or publicity pertaining to the Software or any
// derivatives without specific, written prior permission.

// OpenFlow: protocol between controller and datapath.

//
// This is a relatively straightforward rendering of OpenFlow message
// definitions into protocol buffer messages. We preserved the snake
// case syntax, and made the following changes:
// - all pad fields dropped
// - for each enum value above 0x7fffffff the MSB is dropped. For example,
//   0xffffffff is now 0x7fffffff.
// - '<type> thing[...]' is replaced with 'repeated <type> thing'
// - 'char thing[...]' is replaced with 'string thing'
// - 'uint8_t data[...]' is replaced with 'bytes data'
// - the following systematic changes are done to various integer types:
//   uint8_t  -> uint32
//   uint16_t -> uint32
//   uint32_t -> uint32
//   uint64_t -> uint64
// - removed most length, len, size fields where these values can be determined
//   from the explicitly encoded length of "repeated" protobuf fields.
// - explicit use of enum types whereever it is unambigous (and not used as
//   bitmask/flags value.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v4.25.8
// source: voltha_protos/openflow_13.proto

package openflow_13

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Port numbering. Ports are numbered starting from 1.
type OfpPortNo int32

const (
	OfpPortNo_OFPP_INVALID OfpPortNo = 0
	// Maximum number of physical and logical switch ports.
	OfpPortNo_OFPP_MAX OfpPortNo = 2147483392
	// Reserved OpenFlow Port (fake output "ports").
	OfpPortNo_OFPP_IN_PORT    OfpPortNo = 2147483640
	OfpPortNo_OFPP_TABLE      OfpPortNo = 2147483641
	OfpPortNo_OFPP_NORMAL     OfpPortNo = 2147483642 // Forward using non-OpenFlow pipeline.
	OfpPortNo_OFPP_FLOOD      OfpPortNo = 2147483643 // Flood using non-OpenFlow pipeline.
	OfpPortNo_OFPP_ALL        OfpPortNo = 2147483644 // All standard ports except input port.
	OfpPortNo_OFPP_CONTROLLER OfpPortNo = 2147483645 // Send to controller.
	OfpPortNo_OFPP_LOCAL      OfpPortNo = 2147483646 // Local openflow "port".
	OfpPortNo_OFPP_ANY        OfpPortNo = 2147483647
)

// Enum value maps for OfpPortNo.
var (
	OfpPortNo_name = map[int32]string{
		0:          "OFPP_INVALID",
		2147483392: "OFPP_MAX",
		2147483640: "OFPP_IN_PORT",
		2147483641: "OFPP_TABLE",
		2147483642: "OFPP_NORMAL",
		2147483643: "OFPP_FLOOD",
		2147483644: "OFPP_ALL",
		2147483645: "OFPP_CONTROLLER",
		2147483646: "OFPP_LOCAL",
		2147483647: "OFPP_ANY",
	}
	OfpPortNo_value = map[string]int32{
		"OFPP_INVALID":    0,
		"OFPP_MAX":        2147483392,
		"OFPP_IN_PORT":    2147483640,
		"OFPP_TABLE":      2147483641,
		"OFPP_NORMAL":     2147483642,
		"OFPP_FLOOD":      2147483643,
		"OFPP_ALL":        2147483644,
		"OFPP_CONTROLLER": 2147483645,
		"OFPP_LOCAL":      2147483646,
		"OFPP_ANY":        2147483647,
	}
)

func (x OfpPortNo) Enum() *OfpPortNo {
	p := new(OfpPortNo)
	*p = x
	return p
}

func (x OfpPortNo) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpPortNo) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[0].Descriptor()
}

func (OfpPortNo) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[0]
}

func (x OfpPortNo) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpPortNo.Descriptor instead.
func (OfpPortNo) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{0}
}

type OfpType int32

const (
	// Immutable messages.
	OfpType_OFPT_HELLO        OfpType = 0 // Symmetric message
	OfpType_OFPT_ERROR        OfpType = 1 // Symmetric message
	OfpType_OFPT_ECHO_REQUEST OfpType = 2 // Symmetric message
	OfpType_OFPT_ECHO_REPLY   OfpType = 3 // Symmetric message
	OfpType_OFPT_EXPERIMENTER OfpType = 4 // Symmetric message
	// Switch configuration messages.
	OfpType_OFPT_FEATURES_REQUEST   OfpType = 5 // Controller/switch message
	OfpType_OFPT_FEATURES_REPLY     OfpType = 6 // Controller/switch message
	OfpType_OFPT_GET_CONFIG_REQUEST OfpType = 7 // Controller/switch message
	OfpType_OFPT_GET_CONFIG_REPLY   OfpType = 8 // Controller/switch message
	OfpType_OFPT_SET_CONFIG         OfpType = 9 // Controller/switch message
	// Asynchronous messages.
	OfpType_OFPT_PACKET_IN    OfpType = 10 // Async message
	OfpType_OFPT_FLOW_REMOVED OfpType = 11 // Async message
	OfpType_OFPT_PORT_STATUS  OfpType = 12 // Async message
	// Controller command messages.
	OfpType_OFPT_PACKET_OUT OfpType = 13 // Controller/switch message
	OfpType_OFPT_FLOW_MOD   OfpType = 14 // Controller/switch message
	OfpType_OFPT_GROUP_MOD  OfpType = 15 // Controller/switch message
	OfpType_OFPT_PORT_MOD   OfpType = 16 // Controller/switch message
	OfpType_OFPT_TABLE_MOD  OfpType = 17 // Controller/switch message
	// Multipart messages.
	OfpType_OFPT_MULTIPART_REQUEST OfpType = 18 // Controller/switch message
	OfpType_OFPT_MULTIPART_REPLY   OfpType = 19 // Controller/switch message
	// Barrier messages.
	OfpType_OFPT_BARRIER_REQUEST OfpType = 20 // Controller/switch message
	OfpType_OFPT_BARRIER_REPLY   OfpType = 21 // Controller/switch message
	// Queue Configuration messages.
	OfpType_OFPT_QUEUE_GET_CONFIG_REQUEST OfpType = 22 // Controller/switch message
	OfpType_OFPT_QUEUE_GET_CONFIG_REPLY   OfpType = 23 // Controller/switch message
	// Controller role change request messages.
	OfpType_OFPT_ROLE_REQUEST OfpType = 24 // Controller/switch message
	OfpType_OFPT_ROLE_REPLY   OfpType = 25 // Controller/switch message
	// Asynchronous message configuration.
	OfpType_OFPT_GET_ASYNC_REQUEST OfpType = 26 // Controller/switch message
	OfpType_OFPT_GET_ASYNC_REPLY   OfpType = 27 // Controller/switch message
	OfpType_OFPT_SET_ASYNC         OfpType = 28 // Controller/switch message
	// Meters and rate limiters configuration messages.
	OfpType_OFPT_METER_MOD OfpType = 29 // Controller/switch message
)

// Enum value maps for OfpType.
var (
	OfpType_name = map[int32]string{
		0:  "OFPT_HELLO",
		1:  "OFPT_ERROR",
		2:  "OFPT_ECHO_REQUEST",
		3:  "OFPT_ECHO_REPLY",
		4:  "OFPT_EXPERIMENTER",
		5:  "OFPT_FEATURES_REQUEST",
		6:  "OFPT_FEATURES_REPLY",
		7:  "OFPT_GET_CONFIG_REQUEST",
		8:  "OFPT_GET_CONFIG_REPLY",
		9:  "OFPT_SET_CONFIG",
		10: "OFPT_PACKET_IN",
		11: "OFPT_FLOW_REMOVED",
		12: "OFPT_PORT_STATUS",
		13: "OFPT_PACKET_OUT",
		14: "OFPT_FLOW_MOD",
		15: "OFPT_GROUP_MOD",
		16: "OFPT_PORT_MOD",
		17: "OFPT_TABLE_MOD",
		18: "OFPT_MULTIPART_REQUEST",
		19: "OFPT_MULTIPART_REPLY",
		20: "OFPT_BARRIER_REQUEST",
		21: "OFPT_BARRIER_REPLY",
		22: "OFPT_QUEUE_GET_CONFIG_REQUEST",
		23: "OFPT_QUEUE_GET_CONFIG_REPLY",
		24: "OFPT_ROLE_REQUEST",
		25: "OFPT_ROLE_REPLY",
		26: "OFPT_GET_ASYNC_REQUEST",
		27: "OFPT_GET_ASYNC_REPLY",
		28: "OFPT_SET_ASYNC",
		29: "OFPT_METER_MOD",
	}
	OfpType_value = map[string]int32{
		"OFPT_HELLO":                    0,
		"OFPT_ERROR":                    1,
		"OFPT_ECHO_REQUEST":             2,
		"OFPT_ECHO_REPLY":               3,
		"OFPT_EXPERIMENTER":             4,
		"OFPT_FEATURES_REQUEST":         5,
		"OFPT_FEATURES_REPLY":           6,
		"OFPT_GET_CONFIG_REQUEST":       7,
		"OFPT_GET_CONFIG_REPLY":         8,
		"OFPT_SET_CONFIG":               9,
		"OFPT_PACKET_IN":                10,
		"OFPT_FLOW_REMOVED":             11,
		"OFPT_PORT_STATUS":              12,
		"OFPT_PACKET_OUT":               13,
		"OFPT_FLOW_MOD":                 14,
		"OFPT_GROUP_MOD":                15,
		"OFPT_PORT_MOD":                 16,
		"OFPT_TABLE_MOD":                17,
		"OFPT_MULTIPART_REQUEST":        18,
		"OFPT_MULTIPART_REPLY":          19,
		"OFPT_BARRIER_REQUEST":          20,
		"OFPT_BARRIER_REPLY":            21,
		"OFPT_QUEUE_GET_CONFIG_REQUEST": 22,
		"OFPT_QUEUE_GET_CONFIG_REPLY":   23,
		"OFPT_ROLE_REQUEST":             24,
		"OFPT_ROLE_REPLY":               25,
		"OFPT_GET_ASYNC_REQUEST":        26,
		"OFPT_GET_ASYNC_REPLY":          27,
		"OFPT_SET_ASYNC":                28,
		"OFPT_METER_MOD":                29,
	}
)

func (x OfpType) Enum() *OfpType {
	p := new(OfpType)
	*p = x
	return p
}

func (x OfpType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[1].Descriptor()
}

func (OfpType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[1]
}

func (x OfpType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpType.Descriptor instead.
func (OfpType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{1}
}

// Hello elements types.
type OfpHelloElemType int32

const (
	OfpHelloElemType_OFPHET_INVALID       OfpHelloElemType = 0
	OfpHelloElemType_OFPHET_VERSIONBITMAP OfpHelloElemType = 1 // Bitmap of version supported.
)

// Enum value maps for OfpHelloElemType.
var (
	OfpHelloElemType_name = map[int32]string{
		0: "OFPHET_INVALID",
		1: "OFPHET_VERSIONBITMAP",
	}
	OfpHelloElemType_value = map[string]int32{
		"OFPHET_INVALID":       0,
		"OFPHET_VERSIONBITMAP": 1,
	}
)

func (x OfpHelloElemType) Enum() *OfpHelloElemType {
	p := new(OfpHelloElemType)
	*p = x
	return p
}

func (x OfpHelloElemType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpHelloElemType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[2].Descriptor()
}

func (OfpHelloElemType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[2]
}

func (x OfpHelloElemType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpHelloElemType.Descriptor instead.
func (OfpHelloElemType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{2}
}

type OfpConfigFlags int32

const (
	// Handling of IP fragments.
	OfpConfigFlags_OFPC_FRAG_NORMAL OfpConfigFlags = 0 // No special handling for fragments.
	OfpConfigFlags_OFPC_FRAG_DROP   OfpConfigFlags = 1 // Drop fragments.
	OfpConfigFlags_OFPC_FRAG_REASM  OfpConfigFlags = 2 // Reassemble (only if OFPC_IP_REASM set).
	OfpConfigFlags_OFPC_FRAG_MASK   OfpConfigFlags = 3 // Bitmask of flags dealing with frag.
)

// Enum value maps for OfpConfigFlags.
var (
	OfpConfigFlags_name = map[int32]string{
		0: "OFPC_FRAG_NORMAL",
		1: "OFPC_FRAG_DROP",
		2: "OFPC_FRAG_REASM",
		3: "OFPC_FRAG_MASK",
	}
	OfpConfigFlags_value = map[string]int32{
		"OFPC_FRAG_NORMAL": 0,
		"OFPC_FRAG_DROP":   1,
		"OFPC_FRAG_REASM":  2,
		"OFPC_FRAG_MASK":   3,
	}
)

func (x OfpConfigFlags) Enum() *OfpConfigFlags {
	p := new(OfpConfigFlags)
	*p = x
	return p
}

func (x OfpConfigFlags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpConfigFlags) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[3].Descriptor()
}

func (OfpConfigFlags) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[3]
}

func (x OfpConfigFlags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpConfigFlags.Descriptor instead.
func (OfpConfigFlags) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{3}
}

// Flags to configure the table. Reserved for future use.
type OfpTableConfig int32

const (
	OfpTableConfig_OFPTC_INVALID         OfpTableConfig = 0
	OfpTableConfig_OFPTC_DEPRECATED_MASK OfpTableConfig = 3 // Deprecated bits
)

// Enum value maps for OfpTableConfig.
var (
	OfpTableConfig_name = map[int32]string{
		0: "OFPTC_INVALID",
		3: "OFPTC_DEPRECATED_MASK",
	}
	OfpTableConfig_value = map[string]int32{
		"OFPTC_INVALID":         0,
		"OFPTC_DEPRECATED_MASK": 3,
	}
)

func (x OfpTableConfig) Enum() *OfpTableConfig {
	p := new(OfpTableConfig)
	*p = x
	return p
}

func (x OfpTableConfig) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpTableConfig) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[4].Descriptor()
}

func (OfpTableConfig) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[4]
}

func (x OfpTableConfig) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpTableConfig.Descriptor instead.
func (OfpTableConfig) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{4}
}

// Table numbering. Tables can use any number up to OFPT_MAX.
type OfpTable int32

const (
	OfpTable_OFPTT_INVALID OfpTable = 0
	// Last usable table number.
	OfpTable_OFPTT_MAX OfpTable = 254
	// Fake tables.
	OfpTable_OFPTT_ALL OfpTable = 255
)

// Enum value maps for OfpTable.
var (
	OfpTable_name = map[int32]string{
		0:   "OFPTT_INVALID",
		254: "OFPTT_MAX",
		255: "OFPTT_ALL",
	}
	OfpTable_value = map[string]int32{
		"OFPTT_INVALID": 0,
		"OFPTT_MAX":     254,
		"OFPTT_ALL":     255,
	}
)

func (x OfpTable) Enum() *OfpTable {
	p := new(OfpTable)
	*p = x
	return p
}

func (x OfpTable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpTable) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[5].Descriptor()
}

func (OfpTable) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[5]
}

func (x OfpTable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpTable.Descriptor instead.
func (OfpTable) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{5}
}

// Capabilities supported by the datapath.
type OfpCapabilities int32

const (
	OfpCapabilities_OFPC_INVALID      OfpCapabilities = 0
	OfpCapabilities_OFPC_FLOW_STATS   OfpCapabilities = 1   // Flow statistics.
	OfpCapabilities_OFPC_TABLE_STATS  OfpCapabilities = 2   // Table statistics.
	OfpCapabilities_OFPC_PORT_STATS   OfpCapabilities = 4   // Port statistics.
	OfpCapabilities_OFPC_GROUP_STATS  OfpCapabilities = 8   // Group statistics.
	OfpCapabilities_OFPC_IP_REASM     OfpCapabilities = 32  // Can reassemble IP fragments.
	OfpCapabilities_OFPC_QUEUE_STATS  OfpCapabilities = 64  // Queue statistics.
	OfpCapabilities_OFPC_PORT_BLOCKED OfpCapabilities = 256 // Switch will block looping ports.
)

// Enum value maps for OfpCapabilities.
var (
	OfpCapabilities_name = map[int32]string{
		0:   "OFPC_INVALID",
		1:   "OFPC_FLOW_STATS",
		2:   "OFPC_TABLE_STATS",
		4:   "OFPC_PORT_STATS",
		8:   "OFPC_GROUP_STATS",
		32:  "OFPC_IP_REASM",
		64:  "OFPC_QUEUE_STATS",
		256: "OFPC_PORT_BLOCKED",
	}
	OfpCapabilities_value = map[string]int32{
		"OFPC_INVALID":      0,
		"OFPC_FLOW_STATS":   1,
		"OFPC_TABLE_STATS":  2,
		"OFPC_PORT_STATS":   4,
		"OFPC_GROUP_STATS":  8,
		"OFPC_IP_REASM":     32,
		"OFPC_QUEUE_STATS":  64,
		"OFPC_PORT_BLOCKED": 256,
	}
)

func (x OfpCapabilities) Enum() *OfpCapabilities {
	p := new(OfpCapabilities)
	*p = x
	return p
}

func (x OfpCapabilities) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpCapabilities) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[6].Descriptor()
}

func (OfpCapabilities) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[6]
}

func (x OfpCapabilities) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpCapabilities.Descriptor instead.
func (OfpCapabilities) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{6}
}

// Flags to indicate behavior of the physical port.  These flags are
// used in ofp_port to describe the current configuration.  They are
// used in the ofp_port_mod message to configure the port's behavior.
type OfpPortConfig int32

const (
	OfpPortConfig_OFPPC_INVALID      OfpPortConfig = 0
	OfpPortConfig_OFPPC_PORT_DOWN    OfpPortConfig = 1  // Port is administratively down.
	OfpPortConfig_OFPPC_NO_RECV      OfpPortConfig = 4  // Drop all packets received by port.
	OfpPortConfig_OFPPC_NO_FWD       OfpPortConfig = 32 // Drop packets forwarded to port.
	OfpPortConfig_OFPPC_NO_PACKET_IN OfpPortConfig = 64 // Do not send packet-in msgs for port.
)

// Enum value maps for OfpPortConfig.
var (
	OfpPortConfig_name = map[int32]string{
		0:  "OFPPC_INVALID",
		1:  "OFPPC_PORT_DOWN",
		4:  "OFPPC_NO_RECV",
		32: "OFPPC_NO_FWD",
		64: "OFPPC_NO_PACKET_IN",
	}
	OfpPortConfig_value = map[string]int32{
		"OFPPC_INVALID":      0,
		"OFPPC_PORT_DOWN":    1,
		"OFPPC_NO_RECV":      4,
		"OFPPC_NO_FWD":       32,
		"OFPPC_NO_PACKET_IN": 64,
	}
)

func (x OfpPortConfig) Enum() *OfpPortConfig {
	p := new(OfpPortConfig)
	*p = x
	return p
}

func (x OfpPortConfig) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpPortConfig) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[7].Descriptor()
}

func (OfpPortConfig) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[7]
}

func (x OfpPortConfig) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpPortConfig.Descriptor instead.
func (OfpPortConfig) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{7}
}

// Current state of the physical port.  These are not configurable from
// the controller.
type OfpPortState int32

const (
	OfpPortState_OFPPS_INVALID   OfpPortState = 0
	OfpPortState_OFPPS_LINK_DOWN OfpPortState = 1 // No physical link present.
	OfpPortState_OFPPS_BLOCKED   OfpPortState = 2 // Port is blocked
	OfpPortState_OFPPS_LIVE      OfpPortState = 4 // Live for Fast Failover Group.
)

// Enum value maps for OfpPortState.
var (
	OfpPortState_name = map[int32]string{
		0: "OFPPS_INVALID",
		1: "OFPPS_LINK_DOWN",
		2: "OFPPS_BLOCKED",
		4: "OFPPS_LIVE",
	}
	OfpPortState_value = map[string]int32{
		"OFPPS_INVALID":   0,
		"OFPPS_LINK_DOWN": 1,
		"OFPPS_BLOCKED":   2,
		"OFPPS_LIVE":      4,
	}
)

func (x OfpPortState) Enum() *OfpPortState {
	p := new(OfpPortState)
	*p = x
	return p
}

func (x OfpPortState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpPortState) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[8].Descriptor()
}

func (OfpPortState) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[8]
}

func (x OfpPortState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpPortState.Descriptor instead.
func (OfpPortState) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{8}
}

// Features of ports available in a datapath.
type OfpPortFeatures int32

const (
	OfpPortFeatures_OFPPF_INVALID    OfpPortFeatures = 0
	OfpPortFeatures_OFPPF_10MB_HD    OfpPortFeatures = 1     // 10 Mb half-duplex rate support.
	OfpPortFeatures_OFPPF_10MB_FD    OfpPortFeatures = 2     // 10 Mb full-duplex rate support.
	OfpPortFeatures_OFPPF_100MB_HD   OfpPortFeatures = 4     // 100 Mb half-duplex rate support.
	OfpPortFeatures_OFPPF_100MB_FD   OfpPortFeatures = 8     // 100 Mb full-duplex rate support.
	OfpPortFeatures_OFPPF_1GB_HD     OfpPortFeatures = 16    // 1 Gb half-duplex rate support.
	OfpPortFeatures_OFPPF_1GB_FD     OfpPortFeatures = 32    // 1 Gb full-duplex rate support.
	OfpPortFeatures_OFPPF_10GB_FD    OfpPortFeatures = 64    // 10 Gb full-duplex rate support.
	OfpPortFeatures_OFPPF_40GB_FD    OfpPortFeatures = 128   // 40 Gb full-duplex rate support.
	OfpPortFeatures_OFPPF_100GB_FD   OfpPortFeatures = 256   // 100 Gb full-duplex rate support.
	OfpPortFeatures_OFPPF_1TB_FD     OfpPortFeatures = 512   // 1 Tb full-duplex rate support.
	OfpPortFeatures_OFPPF_OTHER      OfpPortFeatures = 1024  // Other rate, not in the list.
	OfpPortFeatures_OFPPF_COPPER     OfpPortFeatures = 2048  // Copper medium.
	OfpPortFeatures_OFPPF_FIBER      OfpPortFeatures = 4096  // Fiber medium.
	OfpPortFeatures_OFPPF_AUTONEG    OfpPortFeatures = 8192  // Auto-negotiation.
	OfpPortFeatures_OFPPF_PAUSE      OfpPortFeatures = 16384 // Pause.
	OfpPortFeatures_OFPPF_PAUSE_ASYM OfpPortFeatures = 32768 // Asymmetric pause.
)

// Enum value maps for OfpPortFeatures.
var (
	OfpPortFeatures_name = map[int32]string{
		0:     "OFPPF_INVALID",
		1:     "OFPPF_10MB_HD",
		2:     "OFPPF_10MB_FD",
		4:     "OFPPF_100MB_HD",
		8:     "OFPPF_100MB_FD",
		16:    "OFPPF_1GB_HD",
		32:    "OFPPF_1GB_FD",
		64:    "OFPPF_10GB_FD",
		128:   "OFPPF_40GB_FD",
		256:   "OFPPF_100GB_FD",
		512:   "OFPPF_1TB_FD",
		1024:  "OFPPF_OTHER",
		2048:  "OFPPF_COPPER",
		4096:  "OFPPF_FIBER",
		8192:  "OFPPF_AUTONEG",
		16384: "OFPPF_PAUSE",
		32768: "OFPPF_PAUSE_ASYM",
	}
	OfpPortFeatures_value = map[string]int32{
		"OFPPF_INVALID":    0,
		"OFPPF_10MB_HD":    1,
		"OFPPF_10MB_FD":    2,
		"OFPPF_100MB_HD":   4,
		"OFPPF_100MB_FD":   8,
		"OFPPF_1GB_HD":     16,
		"OFPPF_1GB_FD":     32,
		"OFPPF_10GB_FD":    64,
		"OFPPF_40GB_FD":    128,
		"OFPPF_100GB_FD":   256,
		"OFPPF_1TB_FD":     512,
		"OFPPF_OTHER":      1024,
		"OFPPF_COPPER":     2048,
		"OFPPF_FIBER":      4096,
		"OFPPF_AUTONEG":    8192,
		"OFPPF_PAUSE":      16384,
		"OFPPF_PAUSE_ASYM": 32768,
	}
)

func (x OfpPortFeatures) Enum() *OfpPortFeatures {
	p := new(OfpPortFeatures)
	*p = x
	return p
}

func (x OfpPortFeatures) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpPortFeatures) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[9].Descriptor()
}

func (OfpPortFeatures) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[9]
}

func (x OfpPortFeatures) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpPortFeatures.Descriptor instead.
func (OfpPortFeatures) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{9}
}

// What changed about the physical port
type OfpPortReason int32

const (
	OfpPortReason_OFPPR_ADD    OfpPortReason = 0 // The port was added.
	OfpPortReason_OFPPR_DELETE OfpPortReason = 1 // The port was removed.
	OfpPortReason_OFPPR_MODIFY OfpPortReason = 2 // Some attribute of the port has changed.
)

// Enum value maps for OfpPortReason.
var (
	OfpPortReason_name = map[int32]string{
		0: "OFPPR_ADD",
		1: "OFPPR_DELETE",
		2: "OFPPR_MODIFY",
	}
	OfpPortReason_value = map[string]int32{
		"OFPPR_ADD":    0,
		"OFPPR_DELETE": 1,
		"OFPPR_MODIFY": 2,
	}
)

func (x OfpPortReason) Enum() *OfpPortReason {
	p := new(OfpPortReason)
	*p = x
	return p
}

func (x OfpPortReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpPortReason) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[10].Descriptor()
}

func (OfpPortReason) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[10]
}

func (x OfpPortReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpPortReason.Descriptor instead.
func (OfpPortReason) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{10}
}

// What changed about the physical device
type OfpDeviceConnection int32

const (
	OfpDeviceConnection_OFPDEV_CONNECTED    OfpDeviceConnection = 0 // The device connected.
	OfpDeviceConnection_OFPDEV_DISCONNECTED OfpDeviceConnection = 1 // The device disconnected.
)

// Enum value maps for OfpDeviceConnection.
var (
	OfpDeviceConnection_name = map[int32]string{
		0: "OFPDEV_CONNECTED",
		1: "OFPDEV_DISCONNECTED",
	}
	OfpDeviceConnection_value = map[string]int32{
		"OFPDEV_CONNECTED":    0,
		"OFPDEV_DISCONNECTED": 1,
	}
)

func (x OfpDeviceConnection) Enum() *OfpDeviceConnection {
	p := new(OfpDeviceConnection)
	*p = x
	return p
}

func (x OfpDeviceConnection) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpDeviceConnection) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[11].Descriptor()
}

func (OfpDeviceConnection) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[11]
}

func (x OfpDeviceConnection) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpDeviceConnection.Descriptor instead.
func (OfpDeviceConnection) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{11}
}

// The match type indicates the match structure (set of fields that compose the
// match) in use. The match type is placed in the type field at the beginning
// of all match structures. The "OpenFlow Extensible Match" type corresponds
// to OXM TLV format described below and must be supported by all OpenFlow
// switches. Extensions that define other match types may be published on the
// ONF wiki. Support for extensions is optional.
type OfpMatchType int32

const (
	OfpMatchType_OFPMT_STANDARD OfpMatchType = 0 // Deprecated.
	OfpMatchType_OFPMT_OXM      OfpMatchType = 1 // OpenFlow Extensible Match
)

// Enum value maps for OfpMatchType.
var (
	OfpMatchType_name = map[int32]string{
		0: "OFPMT_STANDARD",
		1: "OFPMT_OXM",
	}
	OfpMatchType_value = map[string]int32{
		"OFPMT_STANDARD": 0,
		"OFPMT_OXM":      1,
	}
)

func (x OfpMatchType) Enum() *OfpMatchType {
	p := new(OfpMatchType)
	*p = x
	return p
}

func (x OfpMatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[12].Descriptor()
}

func (OfpMatchType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[12]
}

func (x OfpMatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMatchType.Descriptor instead.
func (OfpMatchType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{12}
}

// OXM Class IDs.
// The high order bit differentiate reserved classes from member classes.
// Classes 0x0000 to 0x7FFF are member classes, allocated by ONF.
// Classes 0x8000 to 0xFFFE are reserved classes, reserved for standardisation.
type OfpOxmClass int32

const (
	OfpOxmClass_OFPXMC_NXM_0          OfpOxmClass = 0     // Backward compatibility with NXM
	OfpOxmClass_OFPXMC_NXM_1          OfpOxmClass = 1     // Backward compatibility with NXM
	OfpOxmClass_OFPXMC_OPENFLOW_BASIC OfpOxmClass = 32768 // Basic class for OpenFlow
	OfpOxmClass_OFPXMC_EXPERIMENTER   OfpOxmClass = 65535 // Experimenter class
)

// Enum value maps for OfpOxmClass.
var (
	OfpOxmClass_name = map[int32]string{
		0:     "OFPXMC_NXM_0",
		1:     "OFPXMC_NXM_1",
		32768: "OFPXMC_OPENFLOW_BASIC",
		65535: "OFPXMC_EXPERIMENTER",
	}
	OfpOxmClass_value = map[string]int32{
		"OFPXMC_NXM_0":          0,
		"OFPXMC_NXM_1":          1,
		"OFPXMC_OPENFLOW_BASIC": 32768,
		"OFPXMC_EXPERIMENTER":   65535,
	}
)

func (x OfpOxmClass) Enum() *OfpOxmClass {
	p := new(OfpOxmClass)
	*p = x
	return p
}

func (x OfpOxmClass) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpOxmClass) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[13].Descriptor()
}

func (OfpOxmClass) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[13]
}

func (x OfpOxmClass) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpOxmClass.Descriptor instead.
func (OfpOxmClass) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{13}
}

// OXM Flow field types for OpenFlow basic class.
type OxmOfbFieldTypes int32

const (
	OxmOfbFieldTypes_OFPXMT_OFB_IN_PORT        OxmOfbFieldTypes = 0  // Switch input port.
	OxmOfbFieldTypes_OFPXMT_OFB_IN_PHY_PORT    OxmOfbFieldTypes = 1  // Switch physical input port.
	OxmOfbFieldTypes_OFPXMT_OFB_METADATA       OxmOfbFieldTypes = 2  // Metadata passed between tables.
	OxmOfbFieldTypes_OFPXMT_OFB_ETH_DST        OxmOfbFieldTypes = 3  // Ethernet destination address.
	OxmOfbFieldTypes_OFPXMT_OFB_ETH_SRC        OxmOfbFieldTypes = 4  // Ethernet source address.
	OxmOfbFieldTypes_OFPXMT_OFB_ETH_TYPE       OxmOfbFieldTypes = 5  // Ethernet frame type.
	OxmOfbFieldTypes_OFPXMT_OFB_VLAN_VID       OxmOfbFieldTypes = 6  // VLAN id.
	OxmOfbFieldTypes_OFPXMT_OFB_VLAN_PCP       OxmOfbFieldTypes = 7  // VLAN priority.
	OxmOfbFieldTypes_OFPXMT_OFB_IP_DSCP        OxmOfbFieldTypes = 8  // IP DSCP (6 bits in ToS field).
	OxmOfbFieldTypes_OFPXMT_OFB_IP_ECN         OxmOfbFieldTypes = 9  // IP ECN (2 bits in ToS field).
	OxmOfbFieldTypes_OFPXMT_OFB_IP_PROTO       OxmOfbFieldTypes = 10 // IP protocol.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV4_SRC       OxmOfbFieldTypes = 11 // IPv4 source address.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV4_DST       OxmOfbFieldTypes = 12 // IPv4 destination address.
	OxmOfbFieldTypes_OFPXMT_OFB_TCP_SRC        OxmOfbFieldTypes = 13 // TCP source port.
	OxmOfbFieldTypes_OFPXMT_OFB_TCP_DST        OxmOfbFieldTypes = 14 // TCP destination port.
	OxmOfbFieldTypes_OFPXMT_OFB_UDP_SRC        OxmOfbFieldTypes = 15 // UDP source port.
	OxmOfbFieldTypes_OFPXMT_OFB_UDP_DST        OxmOfbFieldTypes = 16 // UDP destination port.
	OxmOfbFieldTypes_OFPXMT_OFB_SCTP_SRC       OxmOfbFieldTypes = 17 // SCTP source port.
	OxmOfbFieldTypes_OFPXMT_OFB_SCTP_DST       OxmOfbFieldTypes = 18 // SCTP destination port.
	OxmOfbFieldTypes_OFPXMT_OFB_ICMPV4_TYPE    OxmOfbFieldTypes = 19 // ICMP type.
	OxmOfbFieldTypes_OFPXMT_OFB_ICMPV4_CODE    OxmOfbFieldTypes = 20 // ICMP code.
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_OP         OxmOfbFieldTypes = 21 // ARP opcode.
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_SPA        OxmOfbFieldTypes = 22 // ARP source IPv4 address.
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_TPA        OxmOfbFieldTypes = 23 // ARP target IPv4 address.
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_SHA        OxmOfbFieldTypes = 24 // ARP source hardware address.
	OxmOfbFieldTypes_OFPXMT_OFB_ARP_THA        OxmOfbFieldTypes = 25 // ARP target hardware address.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_SRC       OxmOfbFieldTypes = 26 // IPv6 source address.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_DST       OxmOfbFieldTypes = 27 // IPv6 destination address.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_FLABEL    OxmOfbFieldTypes = 28 // IPv6 Flow Label
	OxmOfbFieldTypes_OFPXMT_OFB_ICMPV6_TYPE    OxmOfbFieldTypes = 29 // ICMPv6 type.
	OxmOfbFieldTypes_OFPXMT_OFB_ICMPV6_CODE    OxmOfbFieldTypes = 30 // ICMPv6 code.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_ND_TARGET OxmOfbFieldTypes = 31 // Target address for ND.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_ND_SLL    OxmOfbFieldTypes = 32 // Source link-layer for ND.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_ND_TLL    OxmOfbFieldTypes = 33 // Target link-layer for ND.
	OxmOfbFieldTypes_OFPXMT_OFB_MPLS_LABEL     OxmOfbFieldTypes = 34 // MPLS label.
	OxmOfbFieldTypes_OFPXMT_OFB_MPLS_TC        OxmOfbFieldTypes = 35 // MPLS TC.
	OxmOfbFieldTypes_OFPXMT_OFB_MPLS_BOS       OxmOfbFieldTypes = 36 // MPLS BoS bit.
	OxmOfbFieldTypes_OFPXMT_OFB_PBB_ISID       OxmOfbFieldTypes = 37 // PBB I-SID.
	OxmOfbFieldTypes_OFPXMT_OFB_TUNNEL_ID      OxmOfbFieldTypes = 38 // Logical Port Metadata.
	OxmOfbFieldTypes_OFPXMT_OFB_IPV6_EXTHDR    OxmOfbFieldTypes = 39 // IPv6 Extension Header pseudo-field
)

// Enum value maps for OxmOfbFieldTypes.
var (
	OxmOfbFieldTypes_name = map[int32]string{
		0:  "OFPXMT_OFB_IN_PORT",
		1:  "OFPXMT_OFB_IN_PHY_PORT",
		2:  "OFPXMT_OFB_METADATA",
		3:  "OFPXMT_OFB_ETH_DST",
		4:  "OFPXMT_OFB_ETH_SRC",
		5:  "OFPXMT_OFB_ETH_TYPE",
		6:  "OFPXMT_OFB_VLAN_VID",
		7:  "OFPXMT_OFB_VLAN_PCP",
		8:  "OFPXMT_OFB_IP_DSCP",
		9:  "OFPXMT_OFB_IP_ECN",
		10: "OFPXMT_OFB_IP_PROTO",
		11: "OFPXMT_OFB_IPV4_SRC",
		12: "OFPXMT_OFB_IPV4_DST",
		13: "OFPXMT_OFB_TCP_SRC",
		14: "OFPXMT_OFB_TCP_DST",
		15: "OFPXMT_OFB_UDP_SRC",
		16: "OFPXMT_OFB_UDP_DST",
		17: "OFPXMT_OFB_SCTP_SRC",
		18: "OFPXMT_OFB_SCTP_DST",
		19: "OFPXMT_OFB_ICMPV4_TYPE",
		20: "OFPXMT_OFB_ICMPV4_CODE",
		21: "OFPXMT_OFB_ARP_OP",
		22: "OFPXMT_OFB_ARP_SPA",
		23: "OFPXMT_OFB_ARP_TPA",
		24: "OFPXMT_OFB_ARP_SHA",
		25: "OFPXMT_OFB_ARP_THA",
		26: "OFPXMT_OFB_IPV6_SRC",
		27: "OFPXMT_OFB_IPV6_DST",
		28: "OFPXMT_OFB_IPV6_FLABEL",
		29: "OFPXMT_OFB_ICMPV6_TYPE",
		30: "OFPXMT_OFB_ICMPV6_CODE",
		31: "OFPXMT_OFB_IPV6_ND_TARGET",
		32: "OFPXMT_OFB_IPV6_ND_SLL",
		33: "OFPXMT_OFB_IPV6_ND_TLL",
		34: "OFPXMT_OFB_MPLS_LABEL",
		35: "OFPXMT_OFB_MPLS_TC",
		36: "OFPXMT_OFB_MPLS_BOS",
		37: "OFPXMT_OFB_PBB_ISID",
		38: "OFPXMT_OFB_TUNNEL_ID",
		39: "OFPXMT_OFB_IPV6_EXTHDR",
	}
	OxmOfbFieldTypes_value = map[string]int32{
		"OFPXMT_OFB_IN_PORT":        0,
		"OFPXMT_OFB_IN_PHY_PORT":    1,
		"OFPXMT_OFB_METADATA":       2,
		"OFPXMT_OFB_ETH_DST":        3,
		"OFPXMT_OFB_ETH_SRC":        4,
		"OFPXMT_OFB_ETH_TYPE":       5,
		"OFPXMT_OFB_VLAN_VID":       6,
		"OFPXMT_OFB_VLAN_PCP":       7,
		"OFPXMT_OFB_IP_DSCP":        8,
		"OFPXMT_OFB_IP_ECN":         9,
		"OFPXMT_OFB_IP_PROTO":       10,
		"OFPXMT_OFB_IPV4_SRC":       11,
		"OFPXMT_OFB_IPV4_DST":       12,
		"OFPXMT_OFB_TCP_SRC":        13,
		"OFPXMT_OFB_TCP_DST":        14,
		"OFPXMT_OFB_UDP_SRC":        15,
		"OFPXMT_OFB_UDP_DST":        16,
		"OFPXMT_OFB_SCTP_SRC":       17,
		"OFPXMT_OFB_SCTP_DST":       18,
		"OFPXMT_OFB_ICMPV4_TYPE":    19,
		"OFPXMT_OFB_ICMPV4_CODE":    20,
		"OFPXMT_OFB_ARP_OP":         21,
		"OFPXMT_OFB_ARP_SPA":        22,
		"OFPXMT_OFB_ARP_TPA":        23,
		"OFPXMT_OFB_ARP_SHA":        24,
		"OFPXMT_OFB_ARP_THA":        25,
		"OFPXMT_OFB_IPV6_SRC":       26,
		"OFPXMT_OFB_IPV6_DST":       27,
		"OFPXMT_OFB_IPV6_FLABEL":    28,
		"OFPXMT_OFB_ICMPV6_TYPE":    29,
		"OFPXMT_OFB_ICMPV6_CODE":    30,
		"OFPXMT_OFB_IPV6_ND_TARGET": 31,
		"OFPXMT_OFB_IPV6_ND_SLL":    32,
		"OFPXMT_OFB_IPV6_ND_TLL":    33,
		"OFPXMT_OFB_MPLS_LABEL":     34,
		"OFPXMT_OFB_MPLS_TC":        35,
		"OFPXMT_OFB_MPLS_BOS":       36,
		"OFPXMT_OFB_PBB_ISID":       37,
		"OFPXMT_OFB_TUNNEL_ID":      38,
		"OFPXMT_OFB_IPV6_EXTHDR":    39,
	}
)

func (x OxmOfbFieldTypes) Enum() *OxmOfbFieldTypes {
	p := new(OxmOfbFieldTypes)
	*p = x
	return p
}

func (x OxmOfbFieldTypes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OxmOfbFieldTypes) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[14].Descriptor()
}

func (OxmOfbFieldTypes) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[14]
}

func (x OxmOfbFieldTypes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OxmOfbFieldTypes.Descriptor instead.
func (OxmOfbFieldTypes) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{14}
}

// The VLAN id is 12-bits, so we can use the entire 16 bits to indicate
// special conditions.
type OfpVlanId int32

const (
	OfpVlanId_OFPVID_NONE    OfpVlanId = 0    // No VLAN id was set.
	OfpVlanId_OFPVID_PRESENT OfpVlanId = 4096 // Bit that indicate that a VLAN id is set
)

// Enum value maps for OfpVlanId.
var (
	OfpVlanId_name = map[int32]string{
		0:    "OFPVID_NONE",
		4096: "OFPVID_PRESENT",
	}
	OfpVlanId_value = map[string]int32{
		"OFPVID_NONE":    0,
		"OFPVID_PRESENT": 4096,
	}
)

func (x OfpVlanId) Enum() *OfpVlanId {
	p := new(OfpVlanId)
	*p = x
	return p
}

func (x OfpVlanId) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpVlanId) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[15].Descriptor()
}

func (OfpVlanId) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[15]
}

func (x OfpVlanId) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpVlanId.Descriptor instead.
func (OfpVlanId) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{15}
}

// Bit definitions for IPv6 Extension Header pseudo-field.
type OfpIpv6ExthdrFlags int32

const (
	OfpIpv6ExthdrFlags_OFPIEH_INVALID OfpIpv6ExthdrFlags = 0
	OfpIpv6ExthdrFlags_OFPIEH_NONEXT  OfpIpv6ExthdrFlags = 1   // "No next header" encountered.
	OfpIpv6ExthdrFlags_OFPIEH_ESP     OfpIpv6ExthdrFlags = 2   // Encrypted Sec Payload header present.
	OfpIpv6ExthdrFlags_OFPIEH_AUTH    OfpIpv6ExthdrFlags = 4   // Authentication header present.
	OfpIpv6ExthdrFlags_OFPIEH_DEST    OfpIpv6ExthdrFlags = 8   // 1 or 2 dest headers present.
	OfpIpv6ExthdrFlags_OFPIEH_FRAG    OfpIpv6ExthdrFlags = 16  // Fragment header present.
	OfpIpv6ExthdrFlags_OFPIEH_ROUTER  OfpIpv6ExthdrFlags = 32  // Router header present.
	OfpIpv6ExthdrFlags_OFPIEH_HOP     OfpIpv6ExthdrFlags = 64  // Hop-by-hop header present.
	OfpIpv6ExthdrFlags_OFPIEH_UNREP   OfpIpv6ExthdrFlags = 128 // Unexpected repeats encountered.
	OfpIpv6ExthdrFlags_OFPIEH_UNSEQ   OfpIpv6ExthdrFlags = 256 // Unexpected sequencing encountered.
)

// Enum value maps for OfpIpv6ExthdrFlags.
var (
	OfpIpv6ExthdrFlags_name = map[int32]string{
		0:   "OFPIEH_INVALID",
		1:   "OFPIEH_NONEXT",
		2:   "OFPIEH_ESP",
		4:   "OFPIEH_AUTH",
		8:   "OFPIEH_DEST",
		16:  "OFPIEH_FRAG",
		32:  "OFPIEH_ROUTER",
		64:  "OFPIEH_HOP",
		128: "OFPIEH_UNREP",
		256: "OFPIEH_UNSEQ",
	}
	OfpIpv6ExthdrFlags_value = map[string]int32{
		"OFPIEH_INVALID": 0,
		"OFPIEH_NONEXT":  1,
		"OFPIEH_ESP":     2,
		"OFPIEH_AUTH":    4,
		"OFPIEH_DEST":    8,
		"OFPIEH_FRAG":    16,
		"OFPIEH_ROUTER":  32,
		"OFPIEH_HOP":     64,
		"OFPIEH_UNREP":   128,
		"OFPIEH_UNSEQ":   256,
	}
)

func (x OfpIpv6ExthdrFlags) Enum() *OfpIpv6ExthdrFlags {
	p := new(OfpIpv6ExthdrFlags)
	*p = x
	return p
}

func (x OfpIpv6ExthdrFlags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpIpv6ExthdrFlags) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[16].Descriptor()
}

func (OfpIpv6ExthdrFlags) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[16]
}

func (x OfpIpv6ExthdrFlags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpIpv6ExthdrFlags.Descriptor instead.
func (OfpIpv6ExthdrFlags) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{16}
}

type OfpActionType int32

const (
	OfpActionType_OFPAT_OUTPUT       OfpActionType = 0 // Output to switch port.
	OfpActionType_OFPAT_COPY_TTL_OUT OfpActionType = 11
	OfpActionType_OFPAT_COPY_TTL_IN  OfpActionType = 12
	OfpActionType_OFPAT_SET_MPLS_TTL OfpActionType = 15 // MPLS TTL
	OfpActionType_OFPAT_DEC_MPLS_TTL OfpActionType = 16 // Decrement MPLS TTL
	OfpActionType_OFPAT_PUSH_VLAN    OfpActionType = 17 // Push a new VLAN tag
	OfpActionType_OFPAT_POP_VLAN     OfpActionType = 18 // Pop the outer VLAN tag
	OfpActionType_OFPAT_PUSH_MPLS    OfpActionType = 19 // Push a new MPLS tag
	OfpActionType_OFPAT_POP_MPLS     OfpActionType = 20 // Pop the outer MPLS tag
	OfpActionType_OFPAT_SET_QUEUE    OfpActionType = 21 // Set queue id when outputting to a port
	OfpActionType_OFPAT_GROUP        OfpActionType = 22 // Apply group.
	OfpActionType_OFPAT_SET_NW_TTL   OfpActionType = 23 // IP TTL.
	OfpActionType_OFPAT_DEC_NW_TTL   OfpActionType = 24 // Decrement IP TTL.
	OfpActionType_OFPAT_SET_FIELD    OfpActionType = 25 // Set a header field using OXM TLV format.
	OfpActionType_OFPAT_PUSH_PBB     OfpActionType = 26 // Push a new PBB service tag (I-TAG)
	OfpActionType_OFPAT_POP_PBB      OfpActionType = 27 // Pop the outer PBB service tag (I-TAG)
	OfpActionType_OFPAT_EXPERIMENTER OfpActionType = 65535
)

// Enum value maps for OfpActionType.
var (
	OfpActionType_name = map[int32]string{
		0:     "OFPAT_OUTPUT",
		11:    "OFPAT_COPY_TTL_OUT",
		12:    "OFPAT_COPY_TTL_IN",
		15:    "OFPAT_SET_MPLS_TTL",
		16:    "OFPAT_DEC_MPLS_TTL",
		17:    "OFPAT_PUSH_VLAN",
		18:    "OFPAT_POP_VLAN",
		19:    "OFPAT_PUSH_MPLS",
		20:    "OFPAT_POP_MPLS",
		21:    "OFPAT_SET_QUEUE",
		22:    "OFPAT_GROUP",
		23:    "OFPAT_SET_NW_TTL",
		24:    "OFPAT_DEC_NW_TTL",
		25:    "OFPAT_SET_FIELD",
		26:    "OFPAT_PUSH_PBB",
		27:    "OFPAT_POP_PBB",
		65535: "OFPAT_EXPERIMENTER",
	}
	OfpActionType_value = map[string]int32{
		"OFPAT_OUTPUT":       0,
		"OFPAT_COPY_TTL_OUT": 11,
		"OFPAT_COPY_TTL_IN":  12,
		"OFPAT_SET_MPLS_TTL": 15,
		"OFPAT_DEC_MPLS_TTL": 16,
		"OFPAT_PUSH_VLAN":    17,
		"OFPAT_POP_VLAN":     18,
		"OFPAT_PUSH_MPLS":    19,
		"OFPAT_POP_MPLS":     20,
		"OFPAT_SET_QUEUE":    21,
		"OFPAT_GROUP":        22,
		"OFPAT_SET_NW_TTL":   23,
		"OFPAT_DEC_NW_TTL":   24,
		"OFPAT_SET_FIELD":    25,
		"OFPAT_PUSH_PBB":     26,
		"OFPAT_POP_PBB":      27,
		"OFPAT_EXPERIMENTER": 65535,
	}
)

func (x OfpActionType) Enum() *OfpActionType {
	p := new(OfpActionType)
	*p = x
	return p
}

func (x OfpActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[17].Descriptor()
}

func (OfpActionType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[17]
}

func (x OfpActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpActionType.Descriptor instead.
func (OfpActionType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{17}
}

type OfpControllerMaxLen int32

const (
	OfpControllerMaxLen_OFPCML_INVALID   OfpControllerMaxLen = 0
	OfpControllerMaxLen_OFPCML_MAX       OfpControllerMaxLen = 65509
	OfpControllerMaxLen_OFPCML_NO_BUFFER OfpControllerMaxLen = 65535
)

// Enum value maps for OfpControllerMaxLen.
var (
	OfpControllerMaxLen_name = map[int32]string{
		0:     "OFPCML_INVALID",
		65509: "OFPCML_MAX",
		65535: "OFPCML_NO_BUFFER",
	}
	OfpControllerMaxLen_value = map[string]int32{
		"OFPCML_INVALID":   0,
		"OFPCML_MAX":       65509,
		"OFPCML_NO_BUFFER": 65535,
	}
)

func (x OfpControllerMaxLen) Enum() *OfpControllerMaxLen {
	p := new(OfpControllerMaxLen)
	*p = x
	return p
}

func (x OfpControllerMaxLen) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpControllerMaxLen) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[18].Descriptor()
}

func (OfpControllerMaxLen) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[18]
}

func (x OfpControllerMaxLen) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpControllerMaxLen.Descriptor instead.
func (OfpControllerMaxLen) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{18}
}

type OfpInstructionType int32

const (
	OfpInstructionType_OFPIT_INVALID        OfpInstructionType = 0
	OfpInstructionType_OFPIT_GOTO_TABLE     OfpInstructionType = 1
	OfpInstructionType_OFPIT_WRITE_METADATA OfpInstructionType = 2
	OfpInstructionType_OFPIT_WRITE_ACTIONS  OfpInstructionType = 3
	OfpInstructionType_OFPIT_APPLY_ACTIONS  OfpInstructionType = 4 // Applies the action(s) immediately
	OfpInstructionType_OFPIT_CLEAR_ACTIONS  OfpInstructionType = 5
	OfpInstructionType_OFPIT_METER          OfpInstructionType = 6     // Apply meter (rate limiter)
	OfpInstructionType_OFPIT_EXPERIMENTER   OfpInstructionType = 65535 // Experimenter instruction
)

// Enum value maps for OfpInstructionType.
var (
	OfpInstructionType_name = map[int32]string{
		0:     "OFPIT_INVALID",
		1:     "OFPIT_GOTO_TABLE",
		2:     "OFPIT_WRITE_METADATA",
		3:     "OFPIT_WRITE_ACTIONS",
		4:     "OFPIT_APPLY_ACTIONS",
		5:     "OFPIT_CLEAR_ACTIONS",
		6:     "OFPIT_METER",
		65535: "OFPIT_EXPERIMENTER",
	}
	OfpInstructionType_value = map[string]int32{
		"OFPIT_INVALID":        0,
		"OFPIT_GOTO_TABLE":     1,
		"OFPIT_WRITE_METADATA": 2,
		"OFPIT_WRITE_ACTIONS":  3,
		"OFPIT_APPLY_ACTIONS":  4,
		"OFPIT_CLEAR_ACTIONS":  5,
		"OFPIT_METER":          6,
		"OFPIT_EXPERIMENTER":   65535,
	}
)

func (x OfpInstructionType) Enum() *OfpInstructionType {
	p := new(OfpInstructionType)
	*p = x
	return p
}

func (x OfpInstructionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpInstructionType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[19].Descriptor()
}

func (OfpInstructionType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[19]
}

func (x OfpInstructionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpInstructionType.Descriptor instead.
func (OfpInstructionType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{19}
}

type OfpFlowModCommand int32

const (
	OfpFlowModCommand_OFPFC_ADD           OfpFlowModCommand = 0 // New flow.
	OfpFlowModCommand_OFPFC_MODIFY        OfpFlowModCommand = 1 // Modify all matching flows.
	OfpFlowModCommand_OFPFC_MODIFY_STRICT OfpFlowModCommand = 2
	OfpFlowModCommand_OFPFC_DELETE        OfpFlowModCommand = 3 // Delete all matching flows.
	OfpFlowModCommand_OFPFC_DELETE_STRICT OfpFlowModCommand = 4
)

// Enum value maps for OfpFlowModCommand.
var (
	OfpFlowModCommand_name = map[int32]string{
		0: "OFPFC_ADD",
		1: "OFPFC_MODIFY",
		2: "OFPFC_MODIFY_STRICT",
		3: "OFPFC_DELETE",
		4: "OFPFC_DELETE_STRICT",
	}
	OfpFlowModCommand_value = map[string]int32{
		"OFPFC_ADD":           0,
		"OFPFC_MODIFY":        1,
		"OFPFC_MODIFY_STRICT": 2,
		"OFPFC_DELETE":        3,
		"OFPFC_DELETE_STRICT": 4,
	}
)

func (x OfpFlowModCommand) Enum() *OfpFlowModCommand {
	p := new(OfpFlowModCommand)
	*p = x
	return p
}

func (x OfpFlowModCommand) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpFlowModCommand) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[20].Descriptor()
}

func (OfpFlowModCommand) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[20]
}

func (x OfpFlowModCommand) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpFlowModCommand.Descriptor instead.
func (OfpFlowModCommand) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{20}
}

type OfpFlowModFlags int32

const (
	OfpFlowModFlags_OFPFF_INVALID       OfpFlowModFlags = 0
	OfpFlowModFlags_OFPFF_SEND_FLOW_REM OfpFlowModFlags = 1
	OfpFlowModFlags_OFPFF_CHECK_OVERLAP OfpFlowModFlags = 2  // Check for overlapping entries first.
	OfpFlowModFlags_OFPFF_RESET_COUNTS  OfpFlowModFlags = 4  // Reset flow packet and byte counts.
	OfpFlowModFlags_OFPFF_NO_PKT_COUNTS OfpFlowModFlags = 8  // Don't keep track of packet count.
	OfpFlowModFlags_OFPFF_NO_BYT_COUNTS OfpFlowModFlags = 16 // Don't keep track of byte count.
)

// Enum value maps for OfpFlowModFlags.
var (
	OfpFlowModFlags_name = map[int32]string{
		0:  "OFPFF_INVALID",
		1:  "OFPFF_SEND_FLOW_REM",
		2:  "OFPFF_CHECK_OVERLAP",
		4:  "OFPFF_RESET_COUNTS",
		8:  "OFPFF_NO_PKT_COUNTS",
		16: "OFPFF_NO_BYT_COUNTS",
	}
	OfpFlowModFlags_value = map[string]int32{
		"OFPFF_INVALID":       0,
		"OFPFF_SEND_FLOW_REM": 1,
		"OFPFF_CHECK_OVERLAP": 2,
		"OFPFF_RESET_COUNTS":  4,
		"OFPFF_NO_PKT_COUNTS": 8,
		"OFPFF_NO_BYT_COUNTS": 16,
	}
)

func (x OfpFlowModFlags) Enum() *OfpFlowModFlags {
	p := new(OfpFlowModFlags)
	*p = x
	return p
}

func (x OfpFlowModFlags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpFlowModFlags) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[21].Descriptor()
}

func (OfpFlowModFlags) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[21]
}

func (x OfpFlowModFlags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpFlowModFlags.Descriptor instead.
func (OfpFlowModFlags) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{21}
}

// Group numbering. Groups can use any number up to OFPG_MAX.
type OfpGroup int32

const (
	OfpGroup_OFPG_INVALID OfpGroup = 0
	// Last usable group number.
	OfpGroup_OFPG_MAX OfpGroup = 2147483392
	// Fake groups.
	OfpGroup_OFPG_ALL OfpGroup = 2147483644
	OfpGroup_OFPG_ANY OfpGroup = 2147483647 // Special wildcard: no group specified.
)

// Enum value maps for OfpGroup.
var (
	OfpGroup_name = map[int32]string{
		0:          "OFPG_INVALID",
		2147483392: "OFPG_MAX",
		2147483644: "OFPG_ALL",
		2147483647: "OFPG_ANY",
	}
	OfpGroup_value = map[string]int32{
		"OFPG_INVALID": 0,
		"OFPG_MAX":     2147483392,
		"OFPG_ALL":     2147483644,
		"OFPG_ANY":     2147483647,
	}
)

func (x OfpGroup) Enum() *OfpGroup {
	p := new(OfpGroup)
	*p = x
	return p
}

func (x OfpGroup) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpGroup) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[22].Descriptor()
}

func (OfpGroup) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[22]
}

func (x OfpGroup) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpGroup.Descriptor instead.
func (OfpGroup) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{22}
}

// Group commands
type OfpGroupModCommand int32

const (
	OfpGroupModCommand_OFPGC_ADD    OfpGroupModCommand = 0 // New group.
	OfpGroupModCommand_OFPGC_MODIFY OfpGroupModCommand = 1 // Modify all matching groups.
	OfpGroupModCommand_OFPGC_DELETE OfpGroupModCommand = 2 // Delete all matching groups.
)

// Enum value maps for OfpGroupModCommand.
var (
	OfpGroupModCommand_name = map[int32]string{
		0: "OFPGC_ADD",
		1: "OFPGC_MODIFY",
		2: "OFPGC_DELETE",
	}
	OfpGroupModCommand_value = map[string]int32{
		"OFPGC_ADD":    0,
		"OFPGC_MODIFY": 1,
		"OFPGC_DELETE": 2,
	}
)

func (x OfpGroupModCommand) Enum() *OfpGroupModCommand {
	p := new(OfpGroupModCommand)
	*p = x
	return p
}

func (x OfpGroupModCommand) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpGroupModCommand) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[23].Descriptor()
}

func (OfpGroupModCommand) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[23]
}

func (x OfpGroupModCommand) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpGroupModCommand.Descriptor instead.
func (OfpGroupModCommand) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{23}
}

// Group types.  Values in the range [128; 255] are reserved for experimental
// use.
type OfpGroupType int32

const (
	OfpGroupType_OFPGT_ALL      OfpGroupType = 0 // All (multicast/broadcast) group.
	OfpGroupType_OFPGT_SELECT   OfpGroupType = 1 // Select group.
	OfpGroupType_OFPGT_INDIRECT OfpGroupType = 2 // Indirect group.
	OfpGroupType_OFPGT_FF       OfpGroupType = 3 // Fast failover group.
)

// Enum value maps for OfpGroupType.
var (
	OfpGroupType_name = map[int32]string{
		0: "OFPGT_ALL",
		1: "OFPGT_SELECT",
		2: "OFPGT_INDIRECT",
		3: "OFPGT_FF",
	}
	OfpGroupType_value = map[string]int32{
		"OFPGT_ALL":      0,
		"OFPGT_SELECT":   1,
		"OFPGT_INDIRECT": 2,
		"OFPGT_FF":       3,
	}
)

func (x OfpGroupType) Enum() *OfpGroupType {
	p := new(OfpGroupType)
	*p = x
	return p
}

func (x OfpGroupType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpGroupType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[24].Descriptor()
}

func (OfpGroupType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[24]
}

func (x OfpGroupType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpGroupType.Descriptor instead.
func (OfpGroupType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{24}
}

// Why is this packet being sent to the controller?
type OfpPacketInReason int32

const (
	OfpPacketInReason_OFPR_NO_MATCH    OfpPacketInReason = 0 // No matching flow (table-miss flow entry).
	OfpPacketInReason_OFPR_ACTION      OfpPacketInReason = 1 // Action explicitly output to controller.
	OfpPacketInReason_OFPR_INVALID_TTL OfpPacketInReason = 2 // Packet has invalid TTL
)

// Enum value maps for OfpPacketInReason.
var (
	OfpPacketInReason_name = map[int32]string{
		0: "OFPR_NO_MATCH",
		1: "OFPR_ACTION",
		2: "OFPR_INVALID_TTL",
	}
	OfpPacketInReason_value = map[string]int32{
		"OFPR_NO_MATCH":    0,
		"OFPR_ACTION":      1,
		"OFPR_INVALID_TTL": 2,
	}
)

func (x OfpPacketInReason) Enum() *OfpPacketInReason {
	p := new(OfpPacketInReason)
	*p = x
	return p
}

func (x OfpPacketInReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpPacketInReason) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[25].Descriptor()
}

func (OfpPacketInReason) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[25]
}

func (x OfpPacketInReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpPacketInReason.Descriptor instead.
func (OfpPacketInReason) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{25}
}

// Why was this flow removed?
type OfpFlowRemovedReason int32

const (
	OfpFlowRemovedReason_OFPRR_IDLE_TIMEOUT OfpFlowRemovedReason = 0 // Flow idle time exceeded idle_timeout.
	OfpFlowRemovedReason_OFPRR_HARD_TIMEOUT OfpFlowRemovedReason = 1 // Time exceeded hard_timeout.
	OfpFlowRemovedReason_OFPRR_DELETE       OfpFlowRemovedReason = 2 // Evicted by a DELETE flow mod.
	OfpFlowRemovedReason_OFPRR_GROUP_DELETE OfpFlowRemovedReason = 3 // Group was removed.
	OfpFlowRemovedReason_OFPRR_METER_DELETE OfpFlowRemovedReason = 4 // Meter was removed
)

// Enum value maps for OfpFlowRemovedReason.
var (
	OfpFlowRemovedReason_name = map[int32]string{
		0: "OFPRR_IDLE_TIMEOUT",
		1: "OFPRR_HARD_TIMEOUT",
		2: "OFPRR_DELETE",
		3: "OFPRR_GROUP_DELETE",
		4: "OFPRR_METER_DELETE",
	}
	OfpFlowRemovedReason_value = map[string]int32{
		"OFPRR_IDLE_TIMEOUT": 0,
		"OFPRR_HARD_TIMEOUT": 1,
		"OFPRR_DELETE":       2,
		"OFPRR_GROUP_DELETE": 3,
		"OFPRR_METER_DELETE": 4,
	}
)

func (x OfpFlowRemovedReason) Enum() *OfpFlowRemovedReason {
	p := new(OfpFlowRemovedReason)
	*p = x
	return p
}

func (x OfpFlowRemovedReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpFlowRemovedReason) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[26].Descriptor()
}

func (OfpFlowRemovedReason) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[26]
}

func (x OfpFlowRemovedReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpFlowRemovedReason.Descriptor instead.
func (OfpFlowRemovedReason) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{26}
}

// Meter numbering. Flow meters can use any number up to OFPM_MAX.
type OfpMeter int32

const (
	OfpMeter_OFPM_ZERO OfpMeter = 0
	// Last usable meter.
	OfpMeter_OFPM_MAX OfpMeter = 2147418112
	// Virtual meters.
	OfpMeter_OFPM_SLOWPATH   OfpMeter = 2147483645 // Meter for slow datapath.
	OfpMeter_OFPM_CONTROLLER OfpMeter = 2147483646 // Meter for controller connection.
	OfpMeter_OFPM_ALL        OfpMeter = 2147483647
)

// Enum value maps for OfpMeter.
var (
	OfpMeter_name = map[int32]string{
		0:          "OFPM_ZERO",
		2147418112: "OFPM_MAX",
		2147483645: "OFPM_SLOWPATH",
		2147483646: "OFPM_CONTROLLER",
		2147483647: "OFPM_ALL",
	}
	OfpMeter_value = map[string]int32{
		"OFPM_ZERO":       0,
		"OFPM_MAX":        2147418112,
		"OFPM_SLOWPATH":   2147483645,
		"OFPM_CONTROLLER": 2147483646,
		"OFPM_ALL":        2147483647,
	}
)

func (x OfpMeter) Enum() *OfpMeter {
	p := new(OfpMeter)
	*p = x
	return p
}

func (x OfpMeter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMeter) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[27].Descriptor()
}

func (OfpMeter) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[27]
}

func (x OfpMeter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMeter.Descriptor instead.
func (OfpMeter) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{27}
}

// Meter band types
type OfpMeterBandType int32

const (
	OfpMeterBandType_OFPMBT_INVALID      OfpMeterBandType = 0
	OfpMeterBandType_OFPMBT_DROP         OfpMeterBandType = 1     // Drop packet.
	OfpMeterBandType_OFPMBT_DSCP_REMARK  OfpMeterBandType = 2     // Remark DSCP in the IP header.
	OfpMeterBandType_OFPMBT_EXPERIMENTER OfpMeterBandType = 65535 // Experimenter meter band.
)

// Enum value maps for OfpMeterBandType.
var (
	OfpMeterBandType_name = map[int32]string{
		0:     "OFPMBT_INVALID",
		1:     "OFPMBT_DROP",
		2:     "OFPMBT_DSCP_REMARK",
		65535: "OFPMBT_EXPERIMENTER",
	}
	OfpMeterBandType_value = map[string]int32{
		"OFPMBT_INVALID":      0,
		"OFPMBT_DROP":         1,
		"OFPMBT_DSCP_REMARK":  2,
		"OFPMBT_EXPERIMENTER": 65535,
	}
)

func (x OfpMeterBandType) Enum() *OfpMeterBandType {
	p := new(OfpMeterBandType)
	*p = x
	return p
}

func (x OfpMeterBandType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMeterBandType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[28].Descriptor()
}

func (OfpMeterBandType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[28]
}

func (x OfpMeterBandType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMeterBandType.Descriptor instead.
func (OfpMeterBandType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{28}
}

// Meter commands
type OfpMeterModCommand int32

const (
	OfpMeterModCommand_OFPMC_ADD    OfpMeterModCommand = 0 // New meter.
	OfpMeterModCommand_OFPMC_MODIFY OfpMeterModCommand = 1 // Modify specified meter.
	OfpMeterModCommand_OFPMC_DELETE OfpMeterModCommand = 2 // Delete specified meter.
)

// Enum value maps for OfpMeterModCommand.
var (
	OfpMeterModCommand_name = map[int32]string{
		0: "OFPMC_ADD",
		1: "OFPMC_MODIFY",
		2: "OFPMC_DELETE",
	}
	OfpMeterModCommand_value = map[string]int32{
		"OFPMC_ADD":    0,
		"OFPMC_MODIFY": 1,
		"OFPMC_DELETE": 2,
	}
)

func (x OfpMeterModCommand) Enum() *OfpMeterModCommand {
	p := new(OfpMeterModCommand)
	*p = x
	return p
}

func (x OfpMeterModCommand) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMeterModCommand) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[29].Descriptor()
}

func (OfpMeterModCommand) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[29]
}

func (x OfpMeterModCommand) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMeterModCommand.Descriptor instead.
func (OfpMeterModCommand) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{29}
}

// Meter configuration flags
type OfpMeterFlags int32

const (
	OfpMeterFlags_OFPMF_INVALID OfpMeterFlags = 0
	OfpMeterFlags_OFPMF_KBPS    OfpMeterFlags = 1 // Rate value in kb/s (kilo-bit per second).
	OfpMeterFlags_OFPMF_PKTPS   OfpMeterFlags = 2 // Rate value in packet/sec.
	OfpMeterFlags_OFPMF_BURST   OfpMeterFlags = 4 // Do burst size.
	OfpMeterFlags_OFPMF_STATS   OfpMeterFlags = 8 // Collect statistics.
)

// Enum value maps for OfpMeterFlags.
var (
	OfpMeterFlags_name = map[int32]string{
		0: "OFPMF_INVALID",
		1: "OFPMF_KBPS",
		2: "OFPMF_PKTPS",
		4: "OFPMF_BURST",
		8: "OFPMF_STATS",
	}
	OfpMeterFlags_value = map[string]int32{
		"OFPMF_INVALID": 0,
		"OFPMF_KBPS":    1,
		"OFPMF_PKTPS":   2,
		"OFPMF_BURST":   4,
		"OFPMF_STATS":   8,
	}
)

func (x OfpMeterFlags) Enum() *OfpMeterFlags {
	p := new(OfpMeterFlags)
	*p = x
	return p
}

func (x OfpMeterFlags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMeterFlags) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[30].Descriptor()
}

func (OfpMeterFlags) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[30]
}

func (x OfpMeterFlags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMeterFlags.Descriptor instead.
func (OfpMeterFlags) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{30}
}

// Values for 'type' in ofp_error_message.  These values are immutable: they
// will not change in future versions of the protocol (although new values may
// be added).
type OfpErrorType int32

const (
	OfpErrorType_OFPET_HELLO_FAILED          OfpErrorType = 0     // Hello protocol failed.
	OfpErrorType_OFPET_BAD_REQUEST           OfpErrorType = 1     // Request was not understood.
	OfpErrorType_OFPET_BAD_ACTION            OfpErrorType = 2     // Error in action description.
	OfpErrorType_OFPET_BAD_INSTRUCTION       OfpErrorType = 3     // Error in instruction list.
	OfpErrorType_OFPET_BAD_MATCH             OfpErrorType = 4     // Error in match.
	OfpErrorType_OFPET_FLOW_MOD_FAILED       OfpErrorType = 5     // Problem modifying flow entry.
	OfpErrorType_OFPET_GROUP_MOD_FAILED      OfpErrorType = 6     // Problem modifying group entry.
	OfpErrorType_OFPET_PORT_MOD_FAILED       OfpErrorType = 7     // Port mod request failed.
	OfpErrorType_OFPET_TABLE_MOD_FAILED      OfpErrorType = 8     // Table mod request failed.
	OfpErrorType_OFPET_QUEUE_OP_FAILED       OfpErrorType = 9     // Queue operation failed.
	OfpErrorType_OFPET_SWITCH_CONFIG_FAILED  OfpErrorType = 10    // Switch config request failed.
	OfpErrorType_OFPET_ROLE_REQUEST_FAILED   OfpErrorType = 11    // Controller Role request failed.
	OfpErrorType_OFPET_METER_MOD_FAILED      OfpErrorType = 12    // Error in meter.
	OfpErrorType_OFPET_TABLE_FEATURES_FAILED OfpErrorType = 13    // Setting table features failed.
	OfpErrorType_OFPET_EXPERIMENTER          OfpErrorType = 65535 // Experimenter error messages.
)

// Enum value maps for OfpErrorType.
var (
	OfpErrorType_name = map[int32]string{
		0:     "OFPET_HELLO_FAILED",
		1:     "OFPET_BAD_REQUEST",
		2:     "OFPET_BAD_ACTION",
		3:     "OFPET_BAD_INSTRUCTION",
		4:     "OFPET_BAD_MATCH",
		5:     "OFPET_FLOW_MOD_FAILED",
		6:     "OFPET_GROUP_MOD_FAILED",
		7:     "OFPET_PORT_MOD_FAILED",
		8:     "OFPET_TABLE_MOD_FAILED",
		9:     "OFPET_QUEUE_OP_FAILED",
		10:    "OFPET_SWITCH_CONFIG_FAILED",
		11:    "OFPET_ROLE_REQUEST_FAILED",
		12:    "OFPET_METER_MOD_FAILED",
		13:    "OFPET_TABLE_FEATURES_FAILED",
		65535: "OFPET_EXPERIMENTER",
	}
	OfpErrorType_value = map[string]int32{
		"OFPET_HELLO_FAILED":          0,
		"OFPET_BAD_REQUEST":           1,
		"OFPET_BAD_ACTION":            2,
		"OFPET_BAD_INSTRUCTION":       3,
		"OFPET_BAD_MATCH":             4,
		"OFPET_FLOW_MOD_FAILED":       5,
		"OFPET_GROUP_MOD_FAILED":      6,
		"OFPET_PORT_MOD_FAILED":       7,
		"OFPET_TABLE_MOD_FAILED":      8,
		"OFPET_QUEUE_OP_FAILED":       9,
		"OFPET_SWITCH_CONFIG_FAILED":  10,
		"OFPET_ROLE_REQUEST_FAILED":   11,
		"OFPET_METER_MOD_FAILED":      12,
		"OFPET_TABLE_FEATURES_FAILED": 13,
		"OFPET_EXPERIMENTER":          65535,
	}
)

func (x OfpErrorType) Enum() *OfpErrorType {
	p := new(OfpErrorType)
	*p = x
	return p
}

func (x OfpErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[31].Descriptor()
}

func (OfpErrorType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[31]
}

func (x OfpErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpErrorType.Descriptor instead.
func (OfpErrorType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{31}
}

// ofp_error_msg 'code' values for OFPET_HELLO_FAILED.  'data' contains an
// ASCII text string that may give failure details.
type OfpHelloFailedCode int32

const (
	OfpHelloFailedCode_OFPHFC_INCOMPATIBLE OfpHelloFailedCode = 0 // No compatible version.
	OfpHelloFailedCode_OFPHFC_EPERM        OfpHelloFailedCode = 1 // Permissions error.
)

// Enum value maps for OfpHelloFailedCode.
var (
	OfpHelloFailedCode_name = map[int32]string{
		0: "OFPHFC_INCOMPATIBLE",
		1: "OFPHFC_EPERM",
	}
	OfpHelloFailedCode_value = map[string]int32{
		"OFPHFC_INCOMPATIBLE": 0,
		"OFPHFC_EPERM":        1,
	}
)

func (x OfpHelloFailedCode) Enum() *OfpHelloFailedCode {
	p := new(OfpHelloFailedCode)
	*p = x
	return p
}

func (x OfpHelloFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpHelloFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[32].Descriptor()
}

func (OfpHelloFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[32]
}

func (x OfpHelloFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpHelloFailedCode.Descriptor instead.
func (OfpHelloFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{32}
}

// ofp_error_msg 'code' values for OFPET_BAD_REQUEST.  'data' contains at least
// the first 64 bytes of the failed request.
type OfpBadRequestCode int32

const (
	OfpBadRequestCode_OFPBRC_BAD_VERSION               OfpBadRequestCode = 0 // ofp_header.version not supported.
	OfpBadRequestCode_OFPBRC_BAD_TYPE                  OfpBadRequestCode = 1 // ofp_header.type not supported.
	OfpBadRequestCode_OFPBRC_BAD_MULTIPART             OfpBadRequestCode = 2 // ofp_multipart_request.type not supported.
	OfpBadRequestCode_OFPBRC_BAD_EXPERIMENTER          OfpBadRequestCode = 3
	OfpBadRequestCode_OFPBRC_BAD_EXP_TYPE              OfpBadRequestCode = 4 // Experimenter type not supported.
	OfpBadRequestCode_OFPBRC_EPERM                     OfpBadRequestCode = 5 // Permissions error.
	OfpBadRequestCode_OFPBRC_BAD_LEN                   OfpBadRequestCode = 6 // Wrong request length for type.
	OfpBadRequestCode_OFPBRC_BUFFER_EMPTY              OfpBadRequestCode = 7 // Specified buffer has already been used.
	OfpBadRequestCode_OFPBRC_BUFFER_UNKNOWN            OfpBadRequestCode = 8 // Specified buffer does not exist.
	OfpBadRequestCode_OFPBRC_BAD_TABLE_ID              OfpBadRequestCode = 9
	OfpBadRequestCode_OFPBRC_IS_SLAVE                  OfpBadRequestCode = 10 // Denied because controller is slave.
	OfpBadRequestCode_OFPBRC_BAD_PORT                  OfpBadRequestCode = 11 // Invalid port.
	OfpBadRequestCode_OFPBRC_BAD_PACKET                OfpBadRequestCode = 12 // Invalid packet in packet-out.
	OfpBadRequestCode_OFPBRC_MULTIPART_BUFFER_OVERFLOW OfpBadRequestCode = 13
)

// Enum value maps for OfpBadRequestCode.
var (
	OfpBadRequestCode_name = map[int32]string{
		0:  "OFPBRC_BAD_VERSION",
		1:  "OFPBRC_BAD_TYPE",
		2:  "OFPBRC_BAD_MULTIPART",
		3:  "OFPBRC_BAD_EXPERIMENTER",
		4:  "OFPBRC_BAD_EXP_TYPE",
		5:  "OFPBRC_EPERM",
		6:  "OFPBRC_BAD_LEN",
		7:  "OFPBRC_BUFFER_EMPTY",
		8:  "OFPBRC_BUFFER_UNKNOWN",
		9:  "OFPBRC_BAD_TABLE_ID",
		10: "OFPBRC_IS_SLAVE",
		11: "OFPBRC_BAD_PORT",
		12: "OFPBRC_BAD_PACKET",
		13: "OFPBRC_MULTIPART_BUFFER_OVERFLOW",
	}
	OfpBadRequestCode_value = map[string]int32{
		"OFPBRC_BAD_VERSION":               0,
		"OFPBRC_BAD_TYPE":                  1,
		"OFPBRC_BAD_MULTIPART":             2,
		"OFPBRC_BAD_EXPERIMENTER":          3,
		"OFPBRC_BAD_EXP_TYPE":              4,
		"OFPBRC_EPERM":                     5,
		"OFPBRC_BAD_LEN":                   6,
		"OFPBRC_BUFFER_EMPTY":              7,
		"OFPBRC_BUFFER_UNKNOWN":            8,
		"OFPBRC_BAD_TABLE_ID":              9,
		"OFPBRC_IS_SLAVE":                  10,
		"OFPBRC_BAD_PORT":                  11,
		"OFPBRC_BAD_PACKET":                12,
		"OFPBRC_MULTIPART_BUFFER_OVERFLOW": 13,
	}
)

func (x OfpBadRequestCode) Enum() *OfpBadRequestCode {
	p := new(OfpBadRequestCode)
	*p = x
	return p
}

func (x OfpBadRequestCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpBadRequestCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[33].Descriptor()
}

func (OfpBadRequestCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[33]
}

func (x OfpBadRequestCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpBadRequestCode.Descriptor instead.
func (OfpBadRequestCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{33}
}

// ofp_error_msg 'code' values for OFPET_BAD_ACTION.  'data' contains at least
// the first 64 bytes of the failed request.
type OfpBadActionCode int32

const (
	OfpBadActionCode_OFPBAC_BAD_TYPE           OfpBadActionCode = 0 // Unknown or unsupported action type.
	OfpBadActionCode_OFPBAC_BAD_LEN            OfpBadActionCode = 1 // Length problem in actions.
	OfpBadActionCode_OFPBAC_BAD_EXPERIMENTER   OfpBadActionCode = 2 // Unknown experimenter id specified.
	OfpBadActionCode_OFPBAC_BAD_EXP_TYPE       OfpBadActionCode = 3 // Unknown action for experimenter id.
	OfpBadActionCode_OFPBAC_BAD_OUT_PORT       OfpBadActionCode = 4 // Problem validating output port.
	OfpBadActionCode_OFPBAC_BAD_ARGUMENT       OfpBadActionCode = 5 // Bad action argument.
	OfpBadActionCode_OFPBAC_EPERM              OfpBadActionCode = 6 // Permissions error.
	OfpBadActionCode_OFPBAC_TOO_MANY           OfpBadActionCode = 7 // Can't handle this many actions.
	OfpBadActionCode_OFPBAC_BAD_QUEUE          OfpBadActionCode = 8 // Problem validating output queue.
	OfpBadActionCode_OFPBAC_BAD_OUT_GROUP      OfpBadActionCode = 9 // Invalid group id in forward action.
	OfpBadActionCode_OFPBAC_MATCH_INCONSISTENT OfpBadActionCode = 10
	OfpBadActionCode_OFPBAC_UNSUPPORTED_ORDER  OfpBadActionCode = 11
	OfpBadActionCode_OFPBAC_BAD_TAG            OfpBadActionCode = 12
	OfpBadActionCode_OFPBAC_BAD_SET_TYPE       OfpBadActionCode = 13 // Unsupported type in SET_FIELD action.
	OfpBadActionCode_OFPBAC_BAD_SET_LEN        OfpBadActionCode = 14 // Length problem in SET_FIELD action.
	OfpBadActionCode_OFPBAC_BAD_SET_ARGUMENT   OfpBadActionCode = 15 // Bad argument in SET_FIELD action.
)

// Enum value maps for OfpBadActionCode.
var (
	OfpBadActionCode_name = map[int32]string{
		0:  "OFPBAC_BAD_TYPE",
		1:  "OFPBAC_BAD_LEN",
		2:  "OFPBAC_BAD_EXPERIMENTER",
		3:  "OFPBAC_BAD_EXP_TYPE",
		4:  "OFPBAC_BAD_OUT_PORT",
		5:  "OFPBAC_BAD_ARGUMENT",
		6:  "OFPBAC_EPERM",
		7:  "OFPBAC_TOO_MANY",
		8:  "OFPBAC_BAD_QUEUE",
		9:  "OFPBAC_BAD_OUT_GROUP",
		10: "OFPBAC_MATCH_INCONSISTENT",
		11: "OFPBAC_UNSUPPORTED_ORDER",
		12: "OFPBAC_BAD_TAG",
		13: "OFPBAC_BAD_SET_TYPE",
		14: "OFPBAC_BAD_SET_LEN",
		15: "OFPBAC_BAD_SET_ARGUMENT",
	}
	OfpBadActionCode_value = map[string]int32{
		"OFPBAC_BAD_TYPE":           0,
		"OFPBAC_BAD_LEN":            1,
		"OFPBAC_BAD_EXPERIMENTER":   2,
		"OFPBAC_BAD_EXP_TYPE":       3,
		"OFPBAC_BAD_OUT_PORT":       4,
		"OFPBAC_BAD_ARGUMENT":       5,
		"OFPBAC_EPERM":              6,
		"OFPBAC_TOO_MANY":           7,
		"OFPBAC_BAD_QUEUE":          8,
		"OFPBAC_BAD_OUT_GROUP":      9,
		"OFPBAC_MATCH_INCONSISTENT": 10,
		"OFPBAC_UNSUPPORTED_ORDER":  11,
		"OFPBAC_BAD_TAG":            12,
		"OFPBAC_BAD_SET_TYPE":       13,
		"OFPBAC_BAD_SET_LEN":        14,
		"OFPBAC_BAD_SET_ARGUMENT":   15,
	}
)

func (x OfpBadActionCode) Enum() *OfpBadActionCode {
	p := new(OfpBadActionCode)
	*p = x
	return p
}

func (x OfpBadActionCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpBadActionCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[34].Descriptor()
}

func (OfpBadActionCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[34]
}

func (x OfpBadActionCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpBadActionCode.Descriptor instead.
func (OfpBadActionCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{34}
}

// ofp_error_msg 'code' values for OFPET_BAD_INSTRUCTION.  'data' contains at
// least the first 64 bytes of the failed request.
type OfpBadInstructionCode int32

const (
	OfpBadInstructionCode_OFPBIC_UNKNOWN_INST        OfpBadInstructionCode = 0 // Unknown instruction.
	OfpBadInstructionCode_OFPBIC_UNSUP_INST          OfpBadInstructionCode = 1
	OfpBadInstructionCode_OFPBIC_BAD_TABLE_ID        OfpBadInstructionCode = 2 // Invalid Table-ID specified.
	OfpBadInstructionCode_OFPBIC_UNSUP_METADATA      OfpBadInstructionCode = 3 // Metadata value unsupported by datapath.
	OfpBadInstructionCode_OFPBIC_UNSUP_METADATA_MASK OfpBadInstructionCode = 4
	OfpBadInstructionCode_OFPBIC_BAD_EXPERIMENTER    OfpBadInstructionCode = 5 // Unknown experimenter id specified.
	OfpBadInstructionCode_OFPBIC_BAD_EXP_TYPE        OfpBadInstructionCode = 6 // Unknown instruction for experimenter id.
	OfpBadInstructionCode_OFPBIC_BAD_LEN             OfpBadInstructionCode = 7 // Length problem in instructions.
	OfpBadInstructionCode_OFPBIC_EPERM               OfpBadInstructionCode = 8 // Permissions error.
)

// Enum value maps for OfpBadInstructionCode.
var (
	OfpBadInstructionCode_name = map[int32]string{
		0: "OFPBIC_UNKNOWN_INST",
		1: "OFPBIC_UNSUP_INST",
		2: "OFPBIC_BAD_TABLE_ID",
		3: "OFPBIC_UNSUP_METADATA",
		4: "OFPBIC_UNSUP_METADATA_MASK",
		5: "OFPBIC_BAD_EXPERIMENTER",
		6: "OFPBIC_BAD_EXP_TYPE",
		7: "OFPBIC_BAD_LEN",
		8: "OFPBIC_EPERM",
	}
	OfpBadInstructionCode_value = map[string]int32{
		"OFPBIC_UNKNOWN_INST":        0,
		"OFPBIC_UNSUP_INST":          1,
		"OFPBIC_BAD_TABLE_ID":        2,
		"OFPBIC_UNSUP_METADATA":      3,
		"OFPBIC_UNSUP_METADATA_MASK": 4,
		"OFPBIC_BAD_EXPERIMENTER":    5,
		"OFPBIC_BAD_EXP_TYPE":        6,
		"OFPBIC_BAD_LEN":             7,
		"OFPBIC_EPERM":               8,
	}
)

func (x OfpBadInstructionCode) Enum() *OfpBadInstructionCode {
	p := new(OfpBadInstructionCode)
	*p = x
	return p
}

func (x OfpBadInstructionCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpBadInstructionCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[35].Descriptor()
}

func (OfpBadInstructionCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[35]
}

func (x OfpBadInstructionCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpBadInstructionCode.Descriptor instead.
func (OfpBadInstructionCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{35}
}

// ofp_error_msg 'code' values for OFPET_BAD_MATCH.  'data' contains at least
// the first 64 bytes of the failed request.
type OfpBadMatchCode int32

const (
	OfpBadMatchCode_OFPBMC_BAD_TYPE         OfpBadMatchCode = 0
	OfpBadMatchCode_OFPBMC_BAD_LEN          OfpBadMatchCode = 1 // Length problem in match.
	OfpBadMatchCode_OFPBMC_BAD_TAG          OfpBadMatchCode = 2 // Match uses an unsupported tag/encap.
	OfpBadMatchCode_OFPBMC_BAD_DL_ADDR_MASK OfpBadMatchCode = 3
	OfpBadMatchCode_OFPBMC_BAD_NW_ADDR_MASK OfpBadMatchCode = 4
	OfpBadMatchCode_OFPBMC_BAD_WILDCARDS    OfpBadMatchCode = 5
	OfpBadMatchCode_OFPBMC_BAD_FIELD        OfpBadMatchCode = 6 // Unsupported field type in the match.
	OfpBadMatchCode_OFPBMC_BAD_VALUE        OfpBadMatchCode = 7 // Unsupported value in a match field.
	OfpBadMatchCode_OFPBMC_BAD_MASK         OfpBadMatchCode = 8
	OfpBadMatchCode_OFPBMC_BAD_PREREQ       OfpBadMatchCode = 9  // A prerequisite was not met.
	OfpBadMatchCode_OFPBMC_DUP_FIELD        OfpBadMatchCode = 10 // A field type was duplicated.
	OfpBadMatchCode_OFPBMC_EPERM            OfpBadMatchCode = 11 // Permissions error.
)

// Enum value maps for OfpBadMatchCode.
var (
	OfpBadMatchCode_name = map[int32]string{
		0:  "OFPBMC_BAD_TYPE",
		1:  "OFPBMC_BAD_LEN",
		2:  "OFPBMC_BAD_TAG",
		3:  "OFPBMC_BAD_DL_ADDR_MASK",
		4:  "OFPBMC_BAD_NW_ADDR_MASK",
		5:  "OFPBMC_BAD_WILDCARDS",
		6:  "OFPBMC_BAD_FIELD",
		7:  "OFPBMC_BAD_VALUE",
		8:  "OFPBMC_BAD_MASK",
		9:  "OFPBMC_BAD_PREREQ",
		10: "OFPBMC_DUP_FIELD",
		11: "OFPBMC_EPERM",
	}
	OfpBadMatchCode_value = map[string]int32{
		"OFPBMC_BAD_TYPE":         0,
		"OFPBMC_BAD_LEN":          1,
		"OFPBMC_BAD_TAG":          2,
		"OFPBMC_BAD_DL_ADDR_MASK": 3,
		"OFPBMC_BAD_NW_ADDR_MASK": 4,
		"OFPBMC_BAD_WILDCARDS":    5,
		"OFPBMC_BAD_FIELD":        6,
		"OFPBMC_BAD_VALUE":        7,
		"OFPBMC_BAD_MASK":         8,
		"OFPBMC_BAD_PREREQ":       9,
		"OFPBMC_DUP_FIELD":        10,
		"OFPBMC_EPERM":            11,
	}
)

func (x OfpBadMatchCode) Enum() *OfpBadMatchCode {
	p := new(OfpBadMatchCode)
	*p = x
	return p
}

func (x OfpBadMatchCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpBadMatchCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[36].Descriptor()
}

func (OfpBadMatchCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[36]
}

func (x OfpBadMatchCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpBadMatchCode.Descriptor instead.
func (OfpBadMatchCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{36}
}

// ofp_error_msg 'code' values for OFPET_FLOW_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpFlowModFailedCode int32

const (
	OfpFlowModFailedCode_OFPFMFC_UNKNOWN      OfpFlowModFailedCode = 0 // Unspecified error.
	OfpFlowModFailedCode_OFPFMFC_TABLE_FULL   OfpFlowModFailedCode = 1 // Flow not added because table was full.
	OfpFlowModFailedCode_OFPFMFC_BAD_TABLE_ID OfpFlowModFailedCode = 2 // Table does not exist
	OfpFlowModFailedCode_OFPFMFC_OVERLAP      OfpFlowModFailedCode = 3
	OfpFlowModFailedCode_OFPFMFC_EPERM        OfpFlowModFailedCode = 4 // Permissions error.
	OfpFlowModFailedCode_OFPFMFC_BAD_TIMEOUT  OfpFlowModFailedCode = 5
	OfpFlowModFailedCode_OFPFMFC_BAD_COMMAND  OfpFlowModFailedCode = 6 // Unsupported or unknown command.
	OfpFlowModFailedCode_OFPFMFC_BAD_FLAGS    OfpFlowModFailedCode = 7 // Unsupported or unknown flags.
)

// Enum value maps for OfpFlowModFailedCode.
var (
	OfpFlowModFailedCode_name = map[int32]string{
		0: "OFPFMFC_UNKNOWN",
		1: "OFPFMFC_TABLE_FULL",
		2: "OFPFMFC_BAD_TABLE_ID",
		3: "OFPFMFC_OVERLAP",
		4: "OFPFMFC_EPERM",
		5: "OFPFMFC_BAD_TIMEOUT",
		6: "OFPFMFC_BAD_COMMAND",
		7: "OFPFMFC_BAD_FLAGS",
	}
	OfpFlowModFailedCode_value = map[string]int32{
		"OFPFMFC_UNKNOWN":      0,
		"OFPFMFC_TABLE_FULL":   1,
		"OFPFMFC_BAD_TABLE_ID": 2,
		"OFPFMFC_OVERLAP":      3,
		"OFPFMFC_EPERM":        4,
		"OFPFMFC_BAD_TIMEOUT":  5,
		"OFPFMFC_BAD_COMMAND":  6,
		"OFPFMFC_BAD_FLAGS":    7,
	}
)

func (x OfpFlowModFailedCode) Enum() *OfpFlowModFailedCode {
	p := new(OfpFlowModFailedCode)
	*p = x
	return p
}

func (x OfpFlowModFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpFlowModFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[37].Descriptor()
}

func (OfpFlowModFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[37]
}

func (x OfpFlowModFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpFlowModFailedCode.Descriptor instead.
func (OfpFlowModFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{37}
}

// ofp_error_msg 'code' values for OFPET_GROUP_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpGroupModFailedCode int32

const (
	OfpGroupModFailedCode_OFPGMFC_GROUP_EXISTS         OfpGroupModFailedCode = 0
	OfpGroupModFailedCode_OFPGMFC_INVALID_GROUP        OfpGroupModFailedCode = 1
	OfpGroupModFailedCode_OFPGMFC_WEIGHT_UNSUPPORTED   OfpGroupModFailedCode = 2
	OfpGroupModFailedCode_OFPGMFC_OUT_OF_GROUPS        OfpGroupModFailedCode = 3 // The group table is full.
	OfpGroupModFailedCode_OFPGMFC_OUT_OF_BUCKETS       OfpGroupModFailedCode = 4
	OfpGroupModFailedCode_OFPGMFC_CHAINING_UNSUPPORTED OfpGroupModFailedCode = 5
	OfpGroupModFailedCode_OFPGMFC_WATCH_UNSUPPORTED    OfpGroupModFailedCode = 6
	OfpGroupModFailedCode_OFPGMFC_LOOP                 OfpGroupModFailedCode = 7 // Group entry would cause a loop.
	OfpGroupModFailedCode_OFPGMFC_UNKNOWN_GROUP        OfpGroupModFailedCode = 8
	OfpGroupModFailedCode_OFPGMFC_CHAINED_GROUP        OfpGroupModFailedCode = 9
	OfpGroupModFailedCode_OFPGMFC_BAD_TYPE             OfpGroupModFailedCode = 10 // Unsupported or unknown group type.
	OfpGroupModFailedCode_OFPGMFC_BAD_COMMAND          OfpGroupModFailedCode = 11 // Unsupported or unknown command.
	OfpGroupModFailedCode_OFPGMFC_BAD_BUCKET           OfpGroupModFailedCode = 12 // Error in bucket.
	OfpGroupModFailedCode_OFPGMFC_BAD_WATCH            OfpGroupModFailedCode = 13 // Error in watch port/group.
	OfpGroupModFailedCode_OFPGMFC_EPERM                OfpGroupModFailedCode = 14 // Permissions error.
)

// Enum value maps for OfpGroupModFailedCode.
var (
	OfpGroupModFailedCode_name = map[int32]string{
		0:  "OFPGMFC_GROUP_EXISTS",
		1:  "OFPGMFC_INVALID_GROUP",
		2:  "OFPGMFC_WEIGHT_UNSUPPORTED",
		3:  "OFPGMFC_OUT_OF_GROUPS",
		4:  "OFPGMFC_OUT_OF_BUCKETS",
		5:  "OFPGMFC_CHAINING_UNSUPPORTED",
		6:  "OFPGMFC_WATCH_UNSUPPORTED",
		7:  "OFPGMFC_LOOP",
		8:  "OFPGMFC_UNKNOWN_GROUP",
		9:  "OFPGMFC_CHAINED_GROUP",
		10: "OFPGMFC_BAD_TYPE",
		11: "OFPGMFC_BAD_COMMAND",
		12: "OFPGMFC_BAD_BUCKET",
		13: "OFPGMFC_BAD_WATCH",
		14: "OFPGMFC_EPERM",
	}
	OfpGroupModFailedCode_value = map[string]int32{
		"OFPGMFC_GROUP_EXISTS":         0,
		"OFPGMFC_INVALID_GROUP":        1,
		"OFPGMFC_WEIGHT_UNSUPPORTED":   2,
		"OFPGMFC_OUT_OF_GROUPS":        3,
		"OFPGMFC_OUT_OF_BUCKETS":       4,
		"OFPGMFC_CHAINING_UNSUPPORTED": 5,
		"OFPGMFC_WATCH_UNSUPPORTED":    6,
		"OFPGMFC_LOOP":                 7,
		"OFPGMFC_UNKNOWN_GROUP":        8,
		"OFPGMFC_CHAINED_GROUP":        9,
		"OFPGMFC_BAD_TYPE":             10,
		"OFPGMFC_BAD_COMMAND":          11,
		"OFPGMFC_BAD_BUCKET":           12,
		"OFPGMFC_BAD_WATCH":            13,
		"OFPGMFC_EPERM":                14,
	}
)

func (x OfpGroupModFailedCode) Enum() *OfpGroupModFailedCode {
	p := new(OfpGroupModFailedCode)
	*p = x
	return p
}

func (x OfpGroupModFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpGroupModFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[38].Descriptor()
}

func (OfpGroupModFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[38]
}

func (x OfpGroupModFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpGroupModFailedCode.Descriptor instead.
func (OfpGroupModFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{38}
}

// ofp_error_msg 'code' values for OFPET_PORT_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpPortModFailedCode int32

const (
	OfpPortModFailedCode_OFPPMFC_BAD_PORT      OfpPortModFailedCode = 0 // Specified port number does not exist.
	OfpPortModFailedCode_OFPPMFC_BAD_HW_ADDR   OfpPortModFailedCode = 1
	OfpPortModFailedCode_OFPPMFC_BAD_CONFIG    OfpPortModFailedCode = 2 // Specified config is invalid.
	OfpPortModFailedCode_OFPPMFC_BAD_ADVERTISE OfpPortModFailedCode = 3 // Specified advertise is invalid.
	OfpPortModFailedCode_OFPPMFC_EPERM         OfpPortModFailedCode = 4 // Permissions error.
)

// Enum value maps for OfpPortModFailedCode.
var (
	OfpPortModFailedCode_name = map[int32]string{
		0: "OFPPMFC_BAD_PORT",
		1: "OFPPMFC_BAD_HW_ADDR",
		2: "OFPPMFC_BAD_CONFIG",
		3: "OFPPMFC_BAD_ADVERTISE",
		4: "OFPPMFC_EPERM",
	}
	OfpPortModFailedCode_value = map[string]int32{
		"OFPPMFC_BAD_PORT":      0,
		"OFPPMFC_BAD_HW_ADDR":   1,
		"OFPPMFC_BAD_CONFIG":    2,
		"OFPPMFC_BAD_ADVERTISE": 3,
		"OFPPMFC_EPERM":         4,
	}
)

func (x OfpPortModFailedCode) Enum() *OfpPortModFailedCode {
	p := new(OfpPortModFailedCode)
	*p = x
	return p
}

func (x OfpPortModFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpPortModFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[39].Descriptor()
}

func (OfpPortModFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[39]
}

func (x OfpPortModFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpPortModFailedCode.Descriptor instead.
func (OfpPortModFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{39}
}

// ofp_error_msg 'code' values for OFPET_TABLE_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpTableModFailedCode int32

const (
	OfpTableModFailedCode_OFPTMFC_BAD_TABLE  OfpTableModFailedCode = 0 // Specified table does not exist.
	OfpTableModFailedCode_OFPTMFC_BAD_CONFIG OfpTableModFailedCode = 1 // Specified config is invalid.
	OfpTableModFailedCode_OFPTMFC_EPERM      OfpTableModFailedCode = 2 // Permissions error.
)

// Enum value maps for OfpTableModFailedCode.
var (
	OfpTableModFailedCode_name = map[int32]string{
		0: "OFPTMFC_BAD_TABLE",
		1: "OFPTMFC_BAD_CONFIG",
		2: "OFPTMFC_EPERM",
	}
	OfpTableModFailedCode_value = map[string]int32{
		"OFPTMFC_BAD_TABLE":  0,
		"OFPTMFC_BAD_CONFIG": 1,
		"OFPTMFC_EPERM":      2,
	}
)

func (x OfpTableModFailedCode) Enum() *OfpTableModFailedCode {
	p := new(OfpTableModFailedCode)
	*p = x
	return p
}

func (x OfpTableModFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpTableModFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[40].Descriptor()
}

func (OfpTableModFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[40]
}

func (x OfpTableModFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpTableModFailedCode.Descriptor instead.
func (OfpTableModFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{40}
}

// ofp_error msg 'code' values for OFPET_QUEUE_OP_FAILED. 'data' contains
// at least the first 64 bytes of the failed request
type OfpQueueOpFailedCode int32

const (
	OfpQueueOpFailedCode_OFPQOFC_BAD_PORT  OfpQueueOpFailedCode = 0 // Invalid port (or port does not exist).
	OfpQueueOpFailedCode_OFPQOFC_BAD_QUEUE OfpQueueOpFailedCode = 1 // Queue does not exist.
	OfpQueueOpFailedCode_OFPQOFC_EPERM     OfpQueueOpFailedCode = 2 // Permissions error.
)

// Enum value maps for OfpQueueOpFailedCode.
var (
	OfpQueueOpFailedCode_name = map[int32]string{
		0: "OFPQOFC_BAD_PORT",
		1: "OFPQOFC_BAD_QUEUE",
		2: "OFPQOFC_EPERM",
	}
	OfpQueueOpFailedCode_value = map[string]int32{
		"OFPQOFC_BAD_PORT":  0,
		"OFPQOFC_BAD_QUEUE": 1,
		"OFPQOFC_EPERM":     2,
	}
)

func (x OfpQueueOpFailedCode) Enum() *OfpQueueOpFailedCode {
	p := new(OfpQueueOpFailedCode)
	*p = x
	return p
}

func (x OfpQueueOpFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpQueueOpFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[41].Descriptor()
}

func (OfpQueueOpFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[41]
}

func (x OfpQueueOpFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpQueueOpFailedCode.Descriptor instead.
func (OfpQueueOpFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{41}
}

// ofp_error_msg 'code' values for OFPET_SWITCH_CONFIG_FAILED. 'data' contains
// at least the first 64 bytes of the failed request.
type OfpSwitchConfigFailedCode int32

const (
	OfpSwitchConfigFailedCode_OFPSCFC_BAD_FLAGS OfpSwitchConfigFailedCode = 0 // Specified flags is invalid.
	OfpSwitchConfigFailedCode_OFPSCFC_BAD_LEN   OfpSwitchConfigFailedCode = 1 // Specified len is invalid.
	OfpSwitchConfigFailedCode_OFPSCFC_EPERM     OfpSwitchConfigFailedCode = 2 // Permissions error.
)

// Enum value maps for OfpSwitchConfigFailedCode.
var (
	OfpSwitchConfigFailedCode_name = map[int32]string{
		0: "OFPSCFC_BAD_FLAGS",
		1: "OFPSCFC_BAD_LEN",
		2: "OFPSCFC_EPERM",
	}
	OfpSwitchConfigFailedCode_value = map[string]int32{
		"OFPSCFC_BAD_FLAGS": 0,
		"OFPSCFC_BAD_LEN":   1,
		"OFPSCFC_EPERM":     2,
	}
)

func (x OfpSwitchConfigFailedCode) Enum() *OfpSwitchConfigFailedCode {
	p := new(OfpSwitchConfigFailedCode)
	*p = x
	return p
}

func (x OfpSwitchConfigFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpSwitchConfigFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[42].Descriptor()
}

func (OfpSwitchConfigFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[42]
}

func (x OfpSwitchConfigFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpSwitchConfigFailedCode.Descriptor instead.
func (OfpSwitchConfigFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{42}
}

// ofp_error_msg 'code' values for OFPET_ROLE_REQUEST_FAILED. 'data' contains
// at least the first 64 bytes of the failed request.
type OfpRoleRequestFailedCode int32

const (
	OfpRoleRequestFailedCode_OFPRRFC_STALE    OfpRoleRequestFailedCode = 0 // Stale Message: old generation_id.
	OfpRoleRequestFailedCode_OFPRRFC_UNSUP    OfpRoleRequestFailedCode = 1 // Controller role change unsupported.
	OfpRoleRequestFailedCode_OFPRRFC_BAD_ROLE OfpRoleRequestFailedCode = 2 // Invalid role.
)

// Enum value maps for OfpRoleRequestFailedCode.
var (
	OfpRoleRequestFailedCode_name = map[int32]string{
		0: "OFPRRFC_STALE",
		1: "OFPRRFC_UNSUP",
		2: "OFPRRFC_BAD_ROLE",
	}
	OfpRoleRequestFailedCode_value = map[string]int32{
		"OFPRRFC_STALE":    0,
		"OFPRRFC_UNSUP":    1,
		"OFPRRFC_BAD_ROLE": 2,
	}
)

func (x OfpRoleRequestFailedCode) Enum() *OfpRoleRequestFailedCode {
	p := new(OfpRoleRequestFailedCode)
	*p = x
	return p
}

func (x OfpRoleRequestFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpRoleRequestFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[43].Descriptor()
}

func (OfpRoleRequestFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[43]
}

func (x OfpRoleRequestFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpRoleRequestFailedCode.Descriptor instead.
func (OfpRoleRequestFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{43}
}

// ofp_error_msg 'code' values for OFPET_METER_MOD_FAILED.  'data' contains
// at least the first 64 bytes of the failed request.
type OfpMeterModFailedCode int32

const (
	OfpMeterModFailedCode_OFPMMFC_UNKNOWN         OfpMeterModFailedCode = 0 // Unspecified error.
	OfpMeterModFailedCode_OFPMMFC_METER_EXISTS    OfpMeterModFailedCode = 1
	OfpMeterModFailedCode_OFPMMFC_INVALID_METER   OfpMeterModFailedCode = 2
	OfpMeterModFailedCode_OFPMMFC_UNKNOWN_METER   OfpMeterModFailedCode = 3
	OfpMeterModFailedCode_OFPMMFC_BAD_COMMAND     OfpMeterModFailedCode = 4  // Unsupported or unknown command.
	OfpMeterModFailedCode_OFPMMFC_BAD_FLAGS       OfpMeterModFailedCode = 5  // Flag configuration unsupported.
	OfpMeterModFailedCode_OFPMMFC_BAD_RATE        OfpMeterModFailedCode = 6  // Rate unsupported.
	OfpMeterModFailedCode_OFPMMFC_BAD_BURST       OfpMeterModFailedCode = 7  // Burst size unsupported.
	OfpMeterModFailedCode_OFPMMFC_BAD_BAND        OfpMeterModFailedCode = 8  // Band unsupported.
	OfpMeterModFailedCode_OFPMMFC_BAD_BAND_DETAIL OfpMeterModFailedCode = 9  // Band value unsupported.
	OfpMeterModFailedCode_OFPMMFC_OUT_OF_METERS   OfpMeterModFailedCode = 10 // No more meters available.
	OfpMeterModFailedCode_OFPMMFC_OUT_OF_BANDS    OfpMeterModFailedCode = 11
)

// Enum value maps for OfpMeterModFailedCode.
var (
	OfpMeterModFailedCode_name = map[int32]string{
		0:  "OFPMMFC_UNKNOWN",
		1:  "OFPMMFC_METER_EXISTS",
		2:  "OFPMMFC_INVALID_METER",
		3:  "OFPMMFC_UNKNOWN_METER",
		4:  "OFPMMFC_BAD_COMMAND",
		5:  "OFPMMFC_BAD_FLAGS",
		6:  "OFPMMFC_BAD_RATE",
		7:  "OFPMMFC_BAD_BURST",
		8:  "OFPMMFC_BAD_BAND",
		9:  "OFPMMFC_BAD_BAND_DETAIL",
		10: "OFPMMFC_OUT_OF_METERS",
		11: "OFPMMFC_OUT_OF_BANDS",
	}
	OfpMeterModFailedCode_value = map[string]int32{
		"OFPMMFC_UNKNOWN":         0,
		"OFPMMFC_METER_EXISTS":    1,
		"OFPMMFC_INVALID_METER":   2,
		"OFPMMFC_UNKNOWN_METER":   3,
		"OFPMMFC_BAD_COMMAND":     4,
		"OFPMMFC_BAD_FLAGS":       5,
		"OFPMMFC_BAD_RATE":        6,
		"OFPMMFC_BAD_BURST":       7,
		"OFPMMFC_BAD_BAND":        8,
		"OFPMMFC_BAD_BAND_DETAIL": 9,
		"OFPMMFC_OUT_OF_METERS":   10,
		"OFPMMFC_OUT_OF_BANDS":    11,
	}
)

func (x OfpMeterModFailedCode) Enum() *OfpMeterModFailedCode {
	p := new(OfpMeterModFailedCode)
	*p = x
	return p
}

func (x OfpMeterModFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMeterModFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[44].Descriptor()
}

func (OfpMeterModFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[44]
}

func (x OfpMeterModFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMeterModFailedCode.Descriptor instead.
func (OfpMeterModFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{44}
}

// ofp_error_msg 'code' values for OFPET_TABLE_FEATURES_FAILED. 'data' contains
// at least the first 64 bytes of the failed request.
type OfpTableFeaturesFailedCode int32

const (
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_TABLE    OfpTableFeaturesFailedCode = 0 // Specified table does not exist.
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_METADATA OfpTableFeaturesFailedCode = 1 // Invalid metadata mask.
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_TYPE     OfpTableFeaturesFailedCode = 2 // Unknown property type.
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_LEN      OfpTableFeaturesFailedCode = 3 // Length problem in properties.
	OfpTableFeaturesFailedCode_OFPTFFC_BAD_ARGUMENT OfpTableFeaturesFailedCode = 4 // Unsupported property value.
	OfpTableFeaturesFailedCode_OFPTFFC_EPERM        OfpTableFeaturesFailedCode = 5 // Permissions error.
)

// Enum value maps for OfpTableFeaturesFailedCode.
var (
	OfpTableFeaturesFailedCode_name = map[int32]string{
		0: "OFPTFFC_BAD_TABLE",
		1: "OFPTFFC_BAD_METADATA",
		2: "OFPTFFC_BAD_TYPE",
		3: "OFPTFFC_BAD_LEN",
		4: "OFPTFFC_BAD_ARGUMENT",
		5: "OFPTFFC_EPERM",
	}
	OfpTableFeaturesFailedCode_value = map[string]int32{
		"OFPTFFC_BAD_TABLE":    0,
		"OFPTFFC_BAD_METADATA": 1,
		"OFPTFFC_BAD_TYPE":     2,
		"OFPTFFC_BAD_LEN":      3,
		"OFPTFFC_BAD_ARGUMENT": 4,
		"OFPTFFC_EPERM":        5,
	}
)

func (x OfpTableFeaturesFailedCode) Enum() *OfpTableFeaturesFailedCode {
	p := new(OfpTableFeaturesFailedCode)
	*p = x
	return p
}

func (x OfpTableFeaturesFailedCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpTableFeaturesFailedCode) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[45].Descriptor()
}

func (OfpTableFeaturesFailedCode) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[45]
}

func (x OfpTableFeaturesFailedCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpTableFeaturesFailedCode.Descriptor instead.
func (OfpTableFeaturesFailedCode) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{45}
}

type OfpMultipartType int32

const (
	// Description of this OpenFlow switch.
	// The request body is empty.
	// The reply body is struct ofp_desc.
	OfpMultipartType_OFPMP_DESC OfpMultipartType = 0
	// Individual flow statistics.
	// The request body is struct ofp_flow_stats_request.
	// The reply body is an array of struct ofp_flow_stats.
	OfpMultipartType_OFPMP_FLOW OfpMultipartType = 1
	// Aggregate flow statistics.
	// The request body is struct ofp_aggregate_stats_request.
	// The reply body is struct ofp_aggregate_stats_reply.
	OfpMultipartType_OFPMP_AGGREGATE OfpMultipartType = 2
	// Flow table statistics.
	// The request body is empty.
	// The reply body is an array of struct ofp_table_stats.
	OfpMultipartType_OFPMP_TABLE OfpMultipartType = 3
	// Port statistics.
	// The request body is struct ofp_port_stats_request.
	// The reply body is an array of struct ofp_port_stats.
	OfpMultipartType_OFPMP_PORT_STATS OfpMultipartType = 4
	// Queue statistics for a port
	// The request body is struct ofp_queue_stats_request.
	// The reply body is an array of struct ofp_queue_stats
	OfpMultipartType_OFPMP_QUEUE OfpMultipartType = 5
	// Group counter statistics.
	// The request body is struct ofp_group_stats_request.
	// The reply is an array of struct ofp_group_stats.
	OfpMultipartType_OFPMP_GROUP OfpMultipartType = 6
	// Group description.
	// The request body is empty.
	// The reply body is an array of struct ofp_group_desc.
	OfpMultipartType_OFPMP_GROUP_DESC OfpMultipartType = 7
	// Group features.
	// The request body is empty.
	// The reply body is struct ofp_group_features.
	OfpMultipartType_OFPMP_GROUP_FEATURES OfpMultipartType = 8
	// Meter statistics.
	// The request body is struct ofp_meter_multipart_requests.
	// The reply body is an array of struct ofp_meter_stats.
	OfpMultipartType_OFPMP_METER OfpMultipartType = 9
	// Meter configuration.
	// The request body is struct ofp_meter_multipart_requests.
	// The reply body is an array of struct ofp_meter_config.
	OfpMultipartType_OFPMP_METER_CONFIG OfpMultipartType = 10
	// Meter features.
	// The request body is empty.
	// The reply body is struct ofp_meter_features.
	OfpMultipartType_OFPMP_METER_FEATURES OfpMultipartType = 11
	// Table features.
	// The request body is either empty or contains an array of
	// struct ofp_table_features containing the controller's
	// desired view of the switch. If the switch is unable to
	// set the specified view an error is returned.
	// The reply body is an array of struct ofp_table_features.
	OfpMultipartType_OFPMP_TABLE_FEATURES OfpMultipartType = 12
	// Port description.
	// The request body is empty.
	// The reply body is an array of struct ofp_port.
	OfpMultipartType_OFPMP_PORT_DESC OfpMultipartType = 13
	// Experimenter extension.
	// The request and reply bodies begin with
	// struct ofp_experimenter_multipart_header.
	// The request and reply bodies are otherwise experimenter-defined.
	OfpMultipartType_OFPMP_EXPERIMENTER OfpMultipartType = 65535
)

// Enum value maps for OfpMultipartType.
var (
	OfpMultipartType_name = map[int32]string{
		0:     "OFPMP_DESC",
		1:     "OFPMP_FLOW",
		2:     "OFPMP_AGGREGATE",
		3:     "OFPMP_TABLE",
		4:     "OFPMP_PORT_STATS",
		5:     "OFPMP_QUEUE",
		6:     "OFPMP_GROUP",
		7:     "OFPMP_GROUP_DESC",
		8:     "OFPMP_GROUP_FEATURES",
		9:     "OFPMP_METER",
		10:    "OFPMP_METER_CONFIG",
		11:    "OFPMP_METER_FEATURES",
		12:    "OFPMP_TABLE_FEATURES",
		13:    "OFPMP_PORT_DESC",
		65535: "OFPMP_EXPERIMENTER",
	}
	OfpMultipartType_value = map[string]int32{
		"OFPMP_DESC":           0,
		"OFPMP_FLOW":           1,
		"OFPMP_AGGREGATE":      2,
		"OFPMP_TABLE":          3,
		"OFPMP_PORT_STATS":     4,
		"OFPMP_QUEUE":          5,
		"OFPMP_GROUP":          6,
		"OFPMP_GROUP_DESC":     7,
		"OFPMP_GROUP_FEATURES": 8,
		"OFPMP_METER":          9,
		"OFPMP_METER_CONFIG":   10,
		"OFPMP_METER_FEATURES": 11,
		"OFPMP_TABLE_FEATURES": 12,
		"OFPMP_PORT_DESC":      13,
		"OFPMP_EXPERIMENTER":   65535,
	}
)

func (x OfpMultipartType) Enum() *OfpMultipartType {
	p := new(OfpMultipartType)
	*p = x
	return p
}

func (x OfpMultipartType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMultipartType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[46].Descriptor()
}

func (OfpMultipartType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[46]
}

func (x OfpMultipartType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMultipartType.Descriptor instead.
func (OfpMultipartType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{46}
}

type OfpMultipartRequestFlags int32

const (
	OfpMultipartRequestFlags_OFPMPF_REQ_INVALID OfpMultipartRequestFlags = 0
	OfpMultipartRequestFlags_OFPMPF_REQ_MORE    OfpMultipartRequestFlags = 1 // More requests to follow.
)

// Enum value maps for OfpMultipartRequestFlags.
var (
	OfpMultipartRequestFlags_name = map[int32]string{
		0: "OFPMPF_REQ_INVALID",
		1: "OFPMPF_REQ_MORE",
	}
	OfpMultipartRequestFlags_value = map[string]int32{
		"OFPMPF_REQ_INVALID": 0,
		"OFPMPF_REQ_MORE":    1,
	}
)

func (x OfpMultipartRequestFlags) Enum() *OfpMultipartRequestFlags {
	p := new(OfpMultipartRequestFlags)
	*p = x
	return p
}

func (x OfpMultipartRequestFlags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMultipartRequestFlags) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[47].Descriptor()
}

func (OfpMultipartRequestFlags) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[47]
}

func (x OfpMultipartRequestFlags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMultipartRequestFlags.Descriptor instead.
func (OfpMultipartRequestFlags) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{47}
}

type OfpMultipartReplyFlags int32

const (
	OfpMultipartReplyFlags_OFPMPF_REPLY_INVALID OfpMultipartReplyFlags = 0
	OfpMultipartReplyFlags_OFPMPF_REPLY_MORE    OfpMultipartReplyFlags = 1 // More replies to follow.
)

// Enum value maps for OfpMultipartReplyFlags.
var (
	OfpMultipartReplyFlags_name = map[int32]string{
		0: "OFPMPF_REPLY_INVALID",
		1: "OFPMPF_REPLY_MORE",
	}
	OfpMultipartReplyFlags_value = map[string]int32{
		"OFPMPF_REPLY_INVALID": 0,
		"OFPMPF_REPLY_MORE":    1,
	}
)

func (x OfpMultipartReplyFlags) Enum() *OfpMultipartReplyFlags {
	p := new(OfpMultipartReplyFlags)
	*p = x
	return p
}

func (x OfpMultipartReplyFlags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpMultipartReplyFlags) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[48].Descriptor()
}

func (OfpMultipartReplyFlags) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[48]
}

func (x OfpMultipartReplyFlags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpMultipartReplyFlags.Descriptor instead.
func (OfpMultipartReplyFlags) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{48}
}

// Table Feature property types.
// Low order bit cleared indicates a property for a regular Flow Entry.
// Low order bit set indicates a property for the Table-Miss Flow Entry.
type OfpTableFeaturePropType int32

const (
	OfpTableFeaturePropType_OFPTFPT_INSTRUCTIONS        OfpTableFeaturePropType = 0     // Instructions property.
	OfpTableFeaturePropType_OFPTFPT_INSTRUCTIONS_MISS   OfpTableFeaturePropType = 1     // Instructions for table-miss.
	OfpTableFeaturePropType_OFPTFPT_NEXT_TABLES         OfpTableFeaturePropType = 2     // Next Table property.
	OfpTableFeaturePropType_OFPTFPT_NEXT_TABLES_MISS    OfpTableFeaturePropType = 3     // Next Table for table-miss.
	OfpTableFeaturePropType_OFPTFPT_WRITE_ACTIONS       OfpTableFeaturePropType = 4     // Write Actions property.
	OfpTableFeaturePropType_OFPTFPT_WRITE_ACTIONS_MISS  OfpTableFeaturePropType = 5     // Write Actions for table-miss.
	OfpTableFeaturePropType_OFPTFPT_APPLY_ACTIONS       OfpTableFeaturePropType = 6     // Apply Actions property.
	OfpTableFeaturePropType_OFPTFPT_APPLY_ACTIONS_MISS  OfpTableFeaturePropType = 7     // Apply Actions for table-miss.
	OfpTableFeaturePropType_OFPTFPT_MATCH               OfpTableFeaturePropType = 8     // Match property.
	OfpTableFeaturePropType_OFPTFPT_WILDCARDS           OfpTableFeaturePropType = 10    // Wildcards property.
	OfpTableFeaturePropType_OFPTFPT_WRITE_SETFIELD      OfpTableFeaturePropType = 12    // Write Set-Field property.
	OfpTableFeaturePropType_OFPTFPT_WRITE_SETFIELD_MISS OfpTableFeaturePropType = 13    // Write Set-Field for table-miss.
	OfpTableFeaturePropType_OFPTFPT_APPLY_SETFIELD      OfpTableFeaturePropType = 14    // Apply Set-Field property.
	OfpTableFeaturePropType_OFPTFPT_APPLY_SETFIELD_MISS OfpTableFeaturePropType = 15    // Apply Set-Field for table-miss.
	OfpTableFeaturePropType_OFPTFPT_EXPERIMENTER        OfpTableFeaturePropType = 65534 // Experimenter property.
	OfpTableFeaturePropType_OFPTFPT_EXPERIMENTER_MISS   OfpTableFeaturePropType = 65535 // Experimenter for table-miss.
)

// Enum value maps for OfpTableFeaturePropType.
var (
	OfpTableFeaturePropType_name = map[int32]string{
		0:     "OFPTFPT_INSTRUCTIONS",
		1:     "OFPTFPT_INSTRUCTIONS_MISS",
		2:     "OFPTFPT_NEXT_TABLES",
		3:     "OFPTFPT_NEXT_TABLES_MISS",
		4:     "OFPTFPT_WRITE_ACTIONS",
		5:     "OFPTFPT_WRITE_ACTIONS_MISS",
		6:     "OFPTFPT_APPLY_ACTIONS",
		7:     "OFPTFPT_APPLY_ACTIONS_MISS",
		8:     "OFPTFPT_MATCH",
		10:    "OFPTFPT_WILDCARDS",
		12:    "OFPTFPT_WRITE_SETFIELD",
		13:    "OFPTFPT_WRITE_SETFIELD_MISS",
		14:    "OFPTFPT_APPLY_SETFIELD",
		15:    "OFPTFPT_APPLY_SETFIELD_MISS",
		65534: "OFPTFPT_EXPERIMENTER",
		65535: "OFPTFPT_EXPERIMENTER_MISS",
	}
	OfpTableFeaturePropType_value = map[string]int32{
		"OFPTFPT_INSTRUCTIONS":        0,
		"OFPTFPT_INSTRUCTIONS_MISS":   1,
		"OFPTFPT_NEXT_TABLES":         2,
		"OFPTFPT_NEXT_TABLES_MISS":    3,
		"OFPTFPT_WRITE_ACTIONS":       4,
		"OFPTFPT_WRITE_ACTIONS_MISS":  5,
		"OFPTFPT_APPLY_ACTIONS":       6,
		"OFPTFPT_APPLY_ACTIONS_MISS":  7,
		"OFPTFPT_MATCH":               8,
		"OFPTFPT_WILDCARDS":           10,
		"OFPTFPT_WRITE_SETFIELD":      12,
		"OFPTFPT_WRITE_SETFIELD_MISS": 13,
		"OFPTFPT_APPLY_SETFIELD":      14,
		"OFPTFPT_APPLY_SETFIELD_MISS": 15,
		"OFPTFPT_EXPERIMENTER":        65534,
		"OFPTFPT_EXPERIMENTER_MISS":   65535,
	}
)

func (x OfpTableFeaturePropType) Enum() *OfpTableFeaturePropType {
	p := new(OfpTableFeaturePropType)
	*p = x
	return p
}

func (x OfpTableFeaturePropType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpTableFeaturePropType) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[49].Descriptor()
}

func (OfpTableFeaturePropType) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[49]
}

func (x OfpTableFeaturePropType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpTableFeaturePropType.Descriptor instead.
func (OfpTableFeaturePropType) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{49}
}

// Group configuration flags
type OfpGroupCapabilities int32

const (
	OfpGroupCapabilities_OFPGFC_INVALID         OfpGroupCapabilities = 0
	OfpGroupCapabilities_OFPGFC_SELECT_WEIGHT   OfpGroupCapabilities = 1 // Support weight for select groups
	OfpGroupCapabilities_OFPGFC_SELECT_LIVENESS OfpGroupCapabilities = 2 // Support liveness for select groups
	OfpGroupCapabilities_OFPGFC_CHAINING        OfpGroupCapabilities = 4 // Support chaining groups
	OfpGroupCapabilities_OFPGFC_CHAINING_CHECKS OfpGroupCapabilities = 8 // Check chaining for loops and delete
)

// Enum value maps for OfpGroupCapabilities.
var (
	OfpGroupCapabilities_name = map[int32]string{
		0: "OFPGFC_INVALID",
		1: "OFPGFC_SELECT_WEIGHT",
		2: "OFPGFC_SELECT_LIVENESS",
		4: "OFPGFC_CHAINING",
		8: "OFPGFC_CHAINING_CHECKS",
	}
	OfpGroupCapabilities_value = map[string]int32{
		"OFPGFC_INVALID":         0,
		"OFPGFC_SELECT_WEIGHT":   1,
		"OFPGFC_SELECT_LIVENESS": 2,
		"OFPGFC_CHAINING":        4,
		"OFPGFC_CHAINING_CHECKS": 8,
	}
)

func (x OfpGroupCapabilities) Enum() *OfpGroupCapabilities {
	p := new(OfpGroupCapabilities)
	*p = x
	return p
}

func (x OfpGroupCapabilities) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpGroupCapabilities) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[50].Descriptor()
}

func (OfpGroupCapabilities) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[50]
}

func (x OfpGroupCapabilities) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpGroupCapabilities.Descriptor instead.
func (OfpGroupCapabilities) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{50}
}

type OfpQueueProperties int32

const (
	OfpQueueProperties_OFPQT_INVALID      OfpQueueProperties = 0
	OfpQueueProperties_OFPQT_MIN_RATE     OfpQueueProperties = 1     // Minimum datarate guaranteed.
	OfpQueueProperties_OFPQT_MAX_RATE     OfpQueueProperties = 2     // Maximum datarate.
	OfpQueueProperties_OFPQT_EXPERIMENTER OfpQueueProperties = 65535 // Experimenter defined property.
)

// Enum value maps for OfpQueueProperties.
var (
	OfpQueueProperties_name = map[int32]string{
		0:     "OFPQT_INVALID",
		1:     "OFPQT_MIN_RATE",
		2:     "OFPQT_MAX_RATE",
		65535: "OFPQT_EXPERIMENTER",
	}
	OfpQueueProperties_value = map[string]int32{
		"OFPQT_INVALID":      0,
		"OFPQT_MIN_RATE":     1,
		"OFPQT_MAX_RATE":     2,
		"OFPQT_EXPERIMENTER": 65535,
	}
)

func (x OfpQueueProperties) Enum() *OfpQueueProperties {
	p := new(OfpQueueProperties)
	*p = x
	return p
}

func (x OfpQueueProperties) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpQueueProperties) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[51].Descriptor()
}

func (OfpQueueProperties) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[51]
}

func (x OfpQueueProperties) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpQueueProperties.Descriptor instead.
func (OfpQueueProperties) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{51}
}

// Controller roles.
type OfpControllerRole int32

const (
	OfpControllerRole_OFPCR_ROLE_NOCHANGE OfpControllerRole = 0 // Don't change current role.
	OfpControllerRole_OFPCR_ROLE_EQUAL    OfpControllerRole = 1 // Default role, full access.
	OfpControllerRole_OFPCR_ROLE_MASTER   OfpControllerRole = 2 // Full access, at most one master.
	OfpControllerRole_OFPCR_ROLE_SLAVE    OfpControllerRole = 3 // Read-only access.
)

// Enum value maps for OfpControllerRole.
var (
	OfpControllerRole_name = map[int32]string{
		0: "OFPCR_ROLE_NOCHANGE",
		1: "OFPCR_ROLE_EQUAL",
		2: "OFPCR_ROLE_MASTER",
		3: "OFPCR_ROLE_SLAVE",
	}
	OfpControllerRole_value = map[string]int32{
		"OFPCR_ROLE_NOCHANGE": 0,
		"OFPCR_ROLE_EQUAL":    1,
		"OFPCR_ROLE_MASTER":   2,
		"OFPCR_ROLE_SLAVE":    3,
	}
)

func (x OfpControllerRole) Enum() *OfpControllerRole {
	p := new(OfpControllerRole)
	*p = x
	return p
}

func (x OfpControllerRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfpControllerRole) Descriptor() protoreflect.EnumDescriptor {
	return file_voltha_protos_openflow_13_proto_enumTypes[52].Descriptor()
}

func (OfpControllerRole) Type() protoreflect.EnumType {
	return &file_voltha_protos_openflow_13_proto_enumTypes[52]
}

func (x OfpControllerRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfpControllerRole.Descriptor instead.
func (OfpControllerRole) EnumDescriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{52}
}

// Header on all OpenFlow packets.
type OfpHeader struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`                    // OFP_VERSION.
	Type          OfpType                `protobuf:"varint,2,opt,name=type,proto3,enum=openflow_13.OfpType" json:"type,omitempty"` // One of the OFPT_ constants.
	Xid           uint32                 `protobuf:"varint,3,opt,name=xid,proto3" json:"xid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpHeader) Reset() {
	*x = OfpHeader{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpHeader) ProtoMessage() {}

func (x *OfpHeader) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpHeader.ProtoReflect.Descriptor instead.
func (*OfpHeader) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{0}
}

func (x *OfpHeader) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *OfpHeader) GetType() OfpType {
	if x != nil {
		return x.Type
	}
	return OfpType_OFPT_HELLO
}

func (x *OfpHeader) GetXid() uint32 {
	if x != nil {
		return x.Xid
	}
	return 0
}

// Common header for all Hello Elements
type OfpHelloElemHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  OfpHelloElemType       `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpHelloElemType" json:"type,omitempty"` // One of OFPHET_*.
	// Types that are valid to be assigned to Element:
	//
	//	*OfpHelloElemHeader_Versionbitmap
	Element       isOfpHelloElemHeader_Element `protobuf_oneof:"element"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpHelloElemHeader) Reset() {
	*x = OfpHelloElemHeader{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpHelloElemHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpHelloElemHeader) ProtoMessage() {}

func (x *OfpHelloElemHeader) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpHelloElemHeader.ProtoReflect.Descriptor instead.
func (*OfpHelloElemHeader) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{1}
}

func (x *OfpHelloElemHeader) GetType() OfpHelloElemType {
	if x != nil {
		return x.Type
	}
	return OfpHelloElemType_OFPHET_INVALID
}

func (x *OfpHelloElemHeader) GetElement() isOfpHelloElemHeader_Element {
	if x != nil {
		return x.Element
	}
	return nil
}

func (x *OfpHelloElemHeader) GetVersionbitmap() *OfpHelloElemVersionbitmap {
	if x != nil {
		if x, ok := x.Element.(*OfpHelloElemHeader_Versionbitmap); ok {
			return x.Versionbitmap
		}
	}
	return nil
}

type isOfpHelloElemHeader_Element interface {
	isOfpHelloElemHeader_Element()
}

type OfpHelloElemHeader_Versionbitmap struct {
	Versionbitmap *OfpHelloElemVersionbitmap `protobuf:"bytes,2,opt,name=versionbitmap,proto3,oneof"`
}

func (*OfpHelloElemHeader_Versionbitmap) isOfpHelloElemHeader_Element() {}

// Version bitmap Hello Element
type OfpHelloElemVersionbitmap struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Bitmaps       []uint32               `protobuf:"varint,2,rep,packed,name=bitmaps,proto3" json:"bitmaps,omitempty"` // List of bitmaps - supported versions
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpHelloElemVersionbitmap) Reset() {
	*x = OfpHelloElemVersionbitmap{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpHelloElemVersionbitmap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpHelloElemVersionbitmap) ProtoMessage() {}

func (x *OfpHelloElemVersionbitmap) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpHelloElemVersionbitmap.ProtoReflect.Descriptor instead.
func (*OfpHelloElemVersionbitmap) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{2}
}

func (x *OfpHelloElemVersionbitmap) GetBitmaps() []uint32 {
	if x != nil {
		return x.Bitmaps
	}
	return nil
}

// OFPT_HELLO.  This message includes zero or more hello elements having
// variable size. Unknown elements types must be ignored/skipped, to allow
// for future extensions.
type OfpHello struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Hello element list
	Elements      []*OfpHelloElemHeader `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"` // 0 or more
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpHello) Reset() {
	*x = OfpHello{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpHello) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpHello) ProtoMessage() {}

func (x *OfpHello) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpHello.ProtoReflect.Descriptor instead.
func (*OfpHello) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{3}
}

func (x *OfpHello) GetElements() []*OfpHelloElemHeader {
	if x != nil {
		return x.Elements
	}
	return nil
}

// Switch configuration.
type OfpSwitchConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Flags         uint32 `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"` // Bitmap of OFPC_* flags.
	MissSendLen   uint32 `protobuf:"varint,2,opt,name=miss_send_len,json=missSendLen,proto3" json:"miss_send_len,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpSwitchConfig) Reset() {
	*x = OfpSwitchConfig{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpSwitchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpSwitchConfig) ProtoMessage() {}

func (x *OfpSwitchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpSwitchConfig.ProtoReflect.Descriptor instead.
func (*OfpSwitchConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{4}
}

func (x *OfpSwitchConfig) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *OfpSwitchConfig) GetMissSendLen() uint32 {
	if x != nil {
		return x.MissSendLen
	}
	return 0
}

// Configure/Modify behavior of a flow table
type OfpTableMod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	TableId       uint32 `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"` // ID of the table, OFPTT_ALL indicates all tables
	Config        uint32 `protobuf:"varint,2,opt,name=config,proto3" json:"config,omitempty"`                  // Bitmap of OFPTC_* flags
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpTableMod) Reset() {
	*x = OfpTableMod{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableMod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableMod) ProtoMessage() {}

func (x *OfpTableMod) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableMod.ProtoReflect.Descriptor instead.
func (*OfpTableMod) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{5}
}

func (x *OfpTableMod) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpTableMod) GetConfig() uint32 {
	if x != nil {
		return x.Config
	}
	return 0
}

// Description of a port
type OfpPort struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	PortNo uint32                 `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	HwAddr []uint32               `protobuf:"varint,2,rep,packed,name=hw_addr,json=hwAddr,proto3" json:"hw_addr,omitempty"` // [OFP_ETH_ALEN];
	Name   string                 `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`                           // Null-terminated
	Config uint32                 `protobuf:"varint,4,opt,name=config,proto3" json:"config,omitempty"`                      // Bitmap of OFPPC_* flags.
	State  uint32                 `protobuf:"varint,5,opt,name=state,proto3" json:"state,omitempty"`                        // Bitmap of OFPPS_* flags.
	// Bitmaps of OFPPF_* that describe features.  All bits zeroed if
	// unsupported or unavailable.
	Curr          uint32 `protobuf:"varint,6,opt,name=curr,proto3" json:"curr,omitempty"`                             // Current features.
	Advertised    uint32 `protobuf:"varint,7,opt,name=advertised,proto3" json:"advertised,omitempty"`                 // Features being advertised by the port.
	Supported     uint32 `protobuf:"varint,8,opt,name=supported,proto3" json:"supported,omitempty"`                   // Features supported by the port.
	Peer          uint32 `protobuf:"varint,9,opt,name=peer,proto3" json:"peer,omitempty"`                             // Features advertised by peer.
	CurrSpeed     uint32 `protobuf:"varint,10,opt,name=curr_speed,json=currSpeed,proto3" json:"curr_speed,omitempty"` // Current port bitrate in kbps.
	MaxSpeed      uint32 `protobuf:"varint,11,opt,name=max_speed,json=maxSpeed,proto3" json:"max_speed,omitempty"`    // Max port bitrate in kbps
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpPort) Reset() {
	*x = OfpPort{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpPort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpPort) ProtoMessage() {}

func (x *OfpPort) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpPort.ProtoReflect.Descriptor instead.
func (*OfpPort) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{6}
}

func (x *OfpPort) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *OfpPort) GetHwAddr() []uint32 {
	if x != nil {
		return x.HwAddr
	}
	return nil
}

func (x *OfpPort) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OfpPort) GetConfig() uint32 {
	if x != nil {
		return x.Config
	}
	return 0
}

func (x *OfpPort) GetState() uint32 {
	if x != nil {
		return x.State
	}
	return 0
}

func (x *OfpPort) GetCurr() uint32 {
	if x != nil {
		return x.Curr
	}
	return 0
}

func (x *OfpPort) GetAdvertised() uint32 {
	if x != nil {
		return x.Advertised
	}
	return 0
}

func (x *OfpPort) GetSupported() uint32 {
	if x != nil {
		return x.Supported
	}
	return 0
}

func (x *OfpPort) GetPeer() uint32 {
	if x != nil {
		return x.Peer
	}
	return 0
}

func (x *OfpPort) GetCurrSpeed() uint32 {
	if x != nil {
		return x.CurrSpeed
	}
	return 0
}

func (x *OfpPort) GetMaxSpeed() uint32 {
	if x != nil {
		return x.MaxSpeed
	}
	return 0
}

// Switch features.
type OfpSwitchFeatures struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	DatapathId  uint64 `protobuf:"varint,1,opt,name=datapath_id,json=datapathId,proto3" json:"datapath_id,omitempty"`
	NBuffers    uint32 `protobuf:"varint,2,opt,name=n_buffers,json=nBuffers,proto3" json:"n_buffers,omitempty"`          // Max packets buffered at once.
	NTables     uint32 `protobuf:"varint,3,opt,name=n_tables,json=nTables,proto3" json:"n_tables,omitempty"`             // Number of tables supported by datapath.
	AuxiliaryId uint32 `protobuf:"varint,4,opt,name=auxiliary_id,json=auxiliaryId,proto3" json:"auxiliary_id,omitempty"` // Identify auxiliary connections
	// Features.
	Capabilities  uint32 `protobuf:"varint,5,opt,name=capabilities,proto3" json:"capabilities,omitempty"` // Bitmap of support "ofp_capabilities".
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpSwitchFeatures) Reset() {
	*x = OfpSwitchFeatures{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpSwitchFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpSwitchFeatures) ProtoMessage() {}

func (x *OfpSwitchFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpSwitchFeatures.ProtoReflect.Descriptor instead.
func (*OfpSwitchFeatures) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{7}
}

func (x *OfpSwitchFeatures) GetDatapathId() uint64 {
	if x != nil {
		return x.DatapathId
	}
	return 0
}

func (x *OfpSwitchFeatures) GetNBuffers() uint32 {
	if x != nil {
		return x.NBuffers
	}
	return 0
}

func (x *OfpSwitchFeatures) GetNTables() uint32 {
	if x != nil {
		return x.NTables
	}
	return 0
}

func (x *OfpSwitchFeatures) GetAuxiliaryId() uint32 {
	if x != nil {
		return x.AuxiliaryId
	}
	return 0
}

func (x *OfpSwitchFeatures) GetCapabilities() uint32 {
	if x != nil {
		return x.Capabilities
	}
	return 0
}

// A physical port has changed in the datapath
type OfpPortStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Reason        OfpPortReason `protobuf:"varint,1,opt,name=reason,proto3,enum=openflow_13.OfpPortReason" json:"reason,omitempty"` // One of OFPPR_*.
	Desc          *OfpPort      `protobuf:"bytes,2,opt,name=desc,proto3" json:"desc,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpPortStatus) Reset() {
	*x = OfpPortStatus{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpPortStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpPortStatus) ProtoMessage() {}

func (x *OfpPortStatus) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpPortStatus.ProtoReflect.Descriptor instead.
func (*OfpPortStatus) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{8}
}

func (x *OfpPortStatus) GetReason() OfpPortReason {
	if x != nil {
		return x.Reason
	}
	return OfpPortReason_OFPPR_ADD
}

func (x *OfpPortStatus) GetDesc() *OfpPort {
	if x != nil {
		return x.Desc
	}
	return nil
}

// A physical device has changed in the datapath
type OfpDeviceStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Status        OfpDeviceConnection `protobuf:"varint,1,opt,name=status,proto3,enum=openflow_13.OfpDeviceConnection" json:"status,omitempty"` // One of OFPDEV_*.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpDeviceStatus) Reset() {
	*x = OfpDeviceStatus{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpDeviceStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpDeviceStatus) ProtoMessage() {}

func (x *OfpDeviceStatus) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpDeviceStatus.ProtoReflect.Descriptor instead.
func (*OfpDeviceStatus) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{9}
}

func (x *OfpDeviceStatus) GetStatus() OfpDeviceConnection {
	if x != nil {
		return x.Status
	}
	return OfpDeviceConnection_OFPDEV_CONNECTED
}

// Modify behavior of the physical port
type OfpPortMod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	PortNo uint32   `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	HwAddr []uint32 `protobuf:"varint,2,rep,packed,name=hw_addr,json=hwAddr,proto3" json:"hw_addr,omitempty"` //[OFP_ETH_ALEN];
	// The hardware address is not
	// configurable.  This is used to
	// sanity-check the request, so it must
	// be the same as returned in an
	// ofp_port struct.
	Config        uint32 `protobuf:"varint,3,opt,name=config,proto3" json:"config,omitempty"` // Bitmap of OFPPC_* flags.
	Mask          uint32 `protobuf:"varint,4,opt,name=mask,proto3" json:"mask,omitempty"`     // Bitmap of OFPPC_* flags to be changed.
	Advertise     uint32 `protobuf:"varint,5,opt,name=advertise,proto3" json:"advertise,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpPortMod) Reset() {
	*x = OfpPortMod{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpPortMod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpPortMod) ProtoMessage() {}

func (x *OfpPortMod) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpPortMod.ProtoReflect.Descriptor instead.
func (*OfpPortMod) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{10}
}

func (x *OfpPortMod) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *OfpPortMod) GetHwAddr() []uint32 {
	if x != nil {
		return x.HwAddr
	}
	return nil
}

func (x *OfpPortMod) GetConfig() uint32 {
	if x != nil {
		return x.Config
	}
	return 0
}

func (x *OfpPortMod) GetMask() uint32 {
	if x != nil {
		return x.Mask
	}
	return 0
}

func (x *OfpPortMod) GetAdvertise() uint32 {
	if x != nil {
		return x.Advertise
	}
	return 0
}

// Fields to match against flows
type OfpMatch struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          OfpMatchType           `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpMatchType" json:"type,omitempty"` // One of OFPMT_*
	OxmFields     []*OfpOxmField         `protobuf:"bytes,2,rep,name=oxm_fields,json=oxmFields,proto3" json:"oxm_fields,omitempty"`     // 0 or more
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMatch) Reset() {
	*x = OfpMatch{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMatch) ProtoMessage() {}

func (x *OfpMatch) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMatch.ProtoReflect.Descriptor instead.
func (*OfpMatch) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{11}
}

func (x *OfpMatch) GetType() OfpMatchType {
	if x != nil {
		return x.Type
	}
	return OfpMatchType_OFPMT_STANDARD
}

func (x *OfpMatch) GetOxmFields() []*OfpOxmField {
	if x != nil {
		return x.OxmFields
	}
	return nil
}

// OXM Flow match fields
type OfpOxmField struct {
	state    protoimpl.MessageState `protogen:"open.v1"`
	OxmClass OfpOxmClass            `protobuf:"varint,1,opt,name=oxm_class,json=oxmClass,proto3,enum=openflow_13.OfpOxmClass" json:"oxm_class,omitempty"`
	// Types that are valid to be assigned to Field:
	//
	//	*OfpOxmField_OfbField
	//	*OfpOxmField_ExperimenterField
	Field         isOfpOxmField_Field `protobuf_oneof:"field"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpOxmField) Reset() {
	*x = OfpOxmField{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpOxmField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpOxmField) ProtoMessage() {}

func (x *OfpOxmField) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpOxmField.ProtoReflect.Descriptor instead.
func (*OfpOxmField) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{12}
}

func (x *OfpOxmField) GetOxmClass() OfpOxmClass {
	if x != nil {
		return x.OxmClass
	}
	return OfpOxmClass_OFPXMC_NXM_0
}

func (x *OfpOxmField) GetField() isOfpOxmField_Field {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *OfpOxmField) GetOfbField() *OfpOxmOfbField {
	if x != nil {
		if x, ok := x.Field.(*OfpOxmField_OfbField); ok {
			return x.OfbField
		}
	}
	return nil
}

func (x *OfpOxmField) GetExperimenterField() *OfpOxmExperimenterField {
	if x != nil {
		if x, ok := x.Field.(*OfpOxmField_ExperimenterField); ok {
			return x.ExperimenterField
		}
	}
	return nil
}

type isOfpOxmField_Field interface {
	isOfpOxmField_Field()
}

type OfpOxmField_OfbField struct {
	// 2 and 3 reserved for NXM_0 and NXM-1 OXM classes
	OfbField *OfpOxmOfbField `protobuf:"bytes,4,opt,name=ofb_field,json=ofbField,proto3,oneof"`
}

type OfpOxmField_ExperimenterField struct {
	ExperimenterField *OfpOxmExperimenterField `protobuf:"bytes,5,opt,name=experimenter_field,json=experimenterField,proto3,oneof"`
}

func (*OfpOxmField_OfbField) isOfpOxmField_Field() {}

func (*OfpOxmField_ExperimenterField) isOfpOxmField_Field() {}

// OXM OpenFlow Basic Match Field
type OfpOxmOfbField struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Type    OxmOfbFieldTypes       `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OxmOfbFieldTypes" json:"type,omitempty"`
	HasMask bool                   `protobuf:"varint,2,opt,name=has_mask,json=hasMask,proto3" json:"has_mask,omitempty"`
	// Types that are valid to be assigned to Value:
	//
	//	*OfpOxmOfbField_Port
	//	*OfpOxmOfbField_PhysicalPort
	//	*OfpOxmOfbField_TableMetadata
	//	*OfpOxmOfbField_EthDst
	//	*OfpOxmOfbField_EthSrc
	//	*OfpOxmOfbField_EthType
	//	*OfpOxmOfbField_VlanVid
	//	*OfpOxmOfbField_VlanPcp
	//	*OfpOxmOfbField_IpDscp
	//	*OfpOxmOfbField_IpEcn
	//	*OfpOxmOfbField_IpProto
	//	*OfpOxmOfbField_Ipv4Src
	//	*OfpOxmOfbField_Ipv4Dst
	//	*OfpOxmOfbField_TcpSrc
	//	*OfpOxmOfbField_TcpDst
	//	*OfpOxmOfbField_UdpSrc
	//	*OfpOxmOfbField_UdpDst
	//	*OfpOxmOfbField_SctpSrc
	//	*OfpOxmOfbField_SctpDst
	//	*OfpOxmOfbField_Icmpv4Type
	//	*OfpOxmOfbField_Icmpv4Code
	//	*OfpOxmOfbField_ArpOp
	//	*OfpOxmOfbField_ArpSpa
	//	*OfpOxmOfbField_ArpTpa
	//	*OfpOxmOfbField_ArpSha
	//	*OfpOxmOfbField_ArpTha
	//	*OfpOxmOfbField_Ipv6Src
	//	*OfpOxmOfbField_Ipv6Dst
	//	*OfpOxmOfbField_Ipv6Flabel
	//	*OfpOxmOfbField_Icmpv6Type
	//	*OfpOxmOfbField_Icmpv6Code
	//	*OfpOxmOfbField_Ipv6NdTarget
	//	*OfpOxmOfbField_Ipv6NdSsl
	//	*OfpOxmOfbField_Ipv6NdTll
	//	*OfpOxmOfbField_MplsLabel
	//	*OfpOxmOfbField_MplsTc
	//	*OfpOxmOfbField_MplsBos
	//	*OfpOxmOfbField_PbbIsid
	//	*OfpOxmOfbField_TunnelId
	//	*OfpOxmOfbField_Ipv6Exthdr
	Value isOfpOxmOfbField_Value `protobuf_oneof:"value"`
	// Optional mask values (must be present when has_mask is true
	// Types that are valid to be assigned to Mask:
	//
	//	*OfpOxmOfbField_TableMetadataMask
	//	*OfpOxmOfbField_EthDstMask
	//	*OfpOxmOfbField_EthSrcMask
	//	*OfpOxmOfbField_VlanVidMask
	//	*OfpOxmOfbField_Ipv4SrcMask
	//	*OfpOxmOfbField_Ipv4DstMask
	//	*OfpOxmOfbField_ArpSpaMask
	//	*OfpOxmOfbField_ArpTpaMask
	//	*OfpOxmOfbField_Ipv6SrcMask
	//	*OfpOxmOfbField_Ipv6DstMask
	//	*OfpOxmOfbField_Ipv6FlabelMask
	//	*OfpOxmOfbField_PbbIsidMask
	//	*OfpOxmOfbField_TunnelIdMask
	//	*OfpOxmOfbField_Ipv6ExthdrMask
	Mask          isOfpOxmOfbField_Mask `protobuf_oneof:"mask"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpOxmOfbField) Reset() {
	*x = OfpOxmOfbField{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpOxmOfbField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpOxmOfbField) ProtoMessage() {}

func (x *OfpOxmOfbField) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpOxmOfbField.ProtoReflect.Descriptor instead.
func (*OfpOxmOfbField) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{13}
}

func (x *OfpOxmOfbField) GetType() OxmOfbFieldTypes {
	if x != nil {
		return x.Type
	}
	return OxmOfbFieldTypes_OFPXMT_OFB_IN_PORT
}

func (x *OfpOxmOfbField) GetHasMask() bool {
	if x != nil {
		return x.HasMask
	}
	return false
}

func (x *OfpOxmOfbField) GetValue() isOfpOxmOfbField_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *OfpOxmOfbField) GetPort() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Port); ok {
			return x.Port
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetPhysicalPort() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_PhysicalPort); ok {
			return x.PhysicalPort
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetTableMetadata() uint64 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_TableMetadata); ok {
			return x.TableMetadata
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetEthDst() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_EthDst); ok {
			return x.EthDst
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetEthSrc() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_EthSrc); ok {
			return x.EthSrc
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetEthType() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_EthType); ok {
			return x.EthType
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetVlanVid() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_VlanVid); ok {
			return x.VlanVid
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetVlanPcp() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_VlanPcp); ok {
			return x.VlanPcp
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpDscp() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_IpDscp); ok {
			return x.IpDscp
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpEcn() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_IpEcn); ok {
			return x.IpEcn
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpProto() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_IpProto); ok {
			return x.IpProto
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpv4Src() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv4Src); ok {
			return x.Ipv4Src
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpv4Dst() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv4Dst); ok {
			return x.Ipv4Dst
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetTcpSrc() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_TcpSrc); ok {
			return x.TcpSrc
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetTcpDst() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_TcpDst); ok {
			return x.TcpDst
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetUdpSrc() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_UdpSrc); ok {
			return x.UdpSrc
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetUdpDst() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_UdpDst); ok {
			return x.UdpDst
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetSctpSrc() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_SctpSrc); ok {
			return x.SctpSrc
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetSctpDst() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_SctpDst); ok {
			return x.SctpDst
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIcmpv4Type() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Icmpv4Type); ok {
			return x.Icmpv4Type
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIcmpv4Code() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Icmpv4Code); ok {
			return x.Icmpv4Code
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetArpOp() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_ArpOp); ok {
			return x.ArpOp
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetArpSpa() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_ArpSpa); ok {
			return x.ArpSpa
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetArpTpa() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_ArpTpa); ok {
			return x.ArpTpa
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetArpSha() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_ArpSha); ok {
			return x.ArpSha
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetArpTha() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_ArpTha); ok {
			return x.ArpTha
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetIpv6Src() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv6Src); ok {
			return x.Ipv6Src
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetIpv6Dst() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv6Dst); ok {
			return x.Ipv6Dst
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetIpv6Flabel() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv6Flabel); ok {
			return x.Ipv6Flabel
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIcmpv6Type() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Icmpv6Type); ok {
			return x.Icmpv6Type
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIcmpv6Code() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Icmpv6Code); ok {
			return x.Icmpv6Code
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpv6NdTarget() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv6NdTarget); ok {
			return x.Ipv6NdTarget
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetIpv6NdSsl() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv6NdSsl); ok {
			return x.Ipv6NdSsl
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetIpv6NdTll() []byte {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv6NdTll); ok {
			return x.Ipv6NdTll
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetMplsLabel() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_MplsLabel); ok {
			return x.MplsLabel
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetMplsTc() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_MplsTc); ok {
			return x.MplsTc
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetMplsBos() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_MplsBos); ok {
			return x.MplsBos
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetPbbIsid() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_PbbIsid); ok {
			return x.PbbIsid
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetTunnelId() uint64 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_TunnelId); ok {
			return x.TunnelId
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpv6Exthdr() uint32 {
	if x != nil {
		if x, ok := x.Value.(*OfpOxmOfbField_Ipv6Exthdr); ok {
			return x.Ipv6Exthdr
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetMask() isOfpOxmOfbField_Mask {
	if x != nil {
		return x.Mask
	}
	return nil
}

func (x *OfpOxmOfbField) GetTableMetadataMask() uint64 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_TableMetadataMask); ok {
			return x.TableMetadataMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetEthDstMask() []byte {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_EthDstMask); ok {
			return x.EthDstMask
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetEthSrcMask() []byte {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_EthSrcMask); ok {
			return x.EthSrcMask
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetVlanVidMask() uint32 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_VlanVidMask); ok {
			return x.VlanVidMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpv4SrcMask() uint32 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_Ipv4SrcMask); ok {
			return x.Ipv4SrcMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpv4DstMask() uint32 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_Ipv4DstMask); ok {
			return x.Ipv4DstMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetArpSpaMask() uint32 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_ArpSpaMask); ok {
			return x.ArpSpaMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetArpTpaMask() uint32 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_ArpTpaMask); ok {
			return x.ArpTpaMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpv6SrcMask() []byte {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_Ipv6SrcMask); ok {
			return x.Ipv6SrcMask
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetIpv6DstMask() []byte {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_Ipv6DstMask); ok {
			return x.Ipv6DstMask
		}
	}
	return nil
}

func (x *OfpOxmOfbField) GetIpv6FlabelMask() uint32 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_Ipv6FlabelMask); ok {
			return x.Ipv6FlabelMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetPbbIsidMask() uint32 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_PbbIsidMask); ok {
			return x.PbbIsidMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetTunnelIdMask() uint64 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_TunnelIdMask); ok {
			return x.TunnelIdMask
		}
	}
	return 0
}

func (x *OfpOxmOfbField) GetIpv6ExthdrMask() uint32 {
	if x != nil {
		if x, ok := x.Mask.(*OfpOxmOfbField_Ipv6ExthdrMask); ok {
			return x.Ipv6ExthdrMask
		}
	}
	return 0
}

type isOfpOxmOfbField_Value interface {
	isOfpOxmOfbField_Value()
}

type OfpOxmOfbField_Port struct {
	// #define OXM_OF_IN_PORT    OXM_HEADER  (0x8000, OFPXMT_OFB_IN_PORT, 4)
	Port uint32 `protobuf:"varint,3,opt,name=port,proto3,oneof"` // Used for OFPXMT_OFB_IN_PORT
}

type OfpOxmOfbField_PhysicalPort struct {
	// #define OXM_OF_IN_PHY_PORT OXM_HEADER  (0x8000, OFPXMT_OFB_IN_PHY_PORT, 4)
	PhysicalPort uint32 `protobuf:"varint,4,opt,name=physical_port,json=physicalPort,proto3,oneof"` // Used for OFPXMT_OF_IN_PHY_PORT
}

type OfpOxmOfbField_TableMetadata struct {
	// #define OXM_OF_METADATA   OXM_HEADER  (0x8000, OFPXMT_OFB_METADATA, 8)
	// #define OXM_OF_METADATA_W OXM_HEADER_W(0x8000, OFPXMT_OFB_METADATA, 8)
	TableMetadata uint64 `protobuf:"varint,5,opt,name=table_metadata,json=tableMetadata,proto3,oneof"` // Used for OFPXMT_OFB_METADATA
}

type OfpOxmOfbField_EthDst struct {
	// #define OXM_OF_ETH_DST    OXM_HEADER  (0x8000, OFPXMT_OFB_ETH_DST, 6)
	// #define OXM_OF_ETH_DST_W  OXM_HEADER_W(0x8000, OFPXMT_OFB_ETH_DST, 6)
	// #define OXM_OF_ETH_SRC    OXM_HEADER  (0x8000, OFPXMT_OFB_ETH_SRC, 6)
	// #define OXM_OF_ETH_SRC_W  OXM_HEADER_W(0x8000, OFPXMT_OFB_ETH_SRC, 6)
	EthDst []byte `protobuf:"bytes,6,opt,name=eth_dst,json=ethDst,proto3,oneof"` // Used for OFPXMT_OFB_ETH_DST (exactly 6 bytes)
}

type OfpOxmOfbField_EthSrc struct {
	EthSrc []byte `protobuf:"bytes,7,opt,name=eth_src,json=ethSrc,proto3,oneof"` // Used for OFPXMT_OFB_ETH_SRC (exactly 6 bytes)
}

type OfpOxmOfbField_EthType struct {
	// #define OXM_OF_ETH_TYPE   OXM_HEADER  (0x8000, OFPXMT_OFB_ETH_TYPE,2)
	EthType uint32 `protobuf:"varint,8,opt,name=eth_type,json=ethType,proto3,oneof"` // Used for OFPXMT_OFB_ETH_TYPE
}

type OfpOxmOfbField_VlanVid struct {
	// #define OXM_OF_VLAN_VID   OXM_HEADER  (0x8000, OFPXMT_OFB_VLAN_VID, 2)
	// #define OXM_OF_VLAN_VID_W OXM_HEADER_W(0x8000, OFPXMT_OFB_VLAN_VID, 2)
	VlanVid uint32 `protobuf:"varint,9,opt,name=vlan_vid,json=vlanVid,proto3,oneof"` // Used for OFPXMT_OFB_VLAN_VID
}

type OfpOxmOfbField_VlanPcp struct {
	// #define OXM_OF_VLAN_PCP   OXM_HEADER  (0x8000, OFPXMT_OFB_VLAN_PCP, 1)
	VlanPcp uint32 `protobuf:"varint,10,opt,name=vlan_pcp,json=vlanPcp,proto3,oneof"` // Used for OFPXMT_OFB_VLAN_PCP
}

type OfpOxmOfbField_IpDscp struct {
	// #define OXM_OF_IP_DSCP     OXM_HEADER  (0x8000, OFPXMT_OFB_IP_DSCP, 1)
	IpDscp uint32 `protobuf:"varint,11,opt,name=ip_dscp,json=ipDscp,proto3,oneof"` // Used for OFPXMT_OFB_IP_DSCP
}

type OfpOxmOfbField_IpEcn struct {
	// #define OXM_OF_IP_ECN     OXM_HEADER  (0x8000, OFPXMT_OFB_IP_ECN, 1)
	IpEcn uint32 `protobuf:"varint,12,opt,name=ip_ecn,json=ipEcn,proto3,oneof"` // Used for OFPXMT_OFB_IP_ECN
}

type OfpOxmOfbField_IpProto struct {
	// #define OXM_OF_IP_PROTO   OXM_HEADER  (0x8000, OFPXMT_OFB_IP_PROTO, 1)
	IpProto uint32 `protobuf:"varint,13,opt,name=ip_proto,json=ipProto,proto3,oneof"` // Used for OFPXMT_OFB_IP_PROTO
}

type OfpOxmOfbField_Ipv4Src struct {
	// #define OXM_OF_IPV4_SRC     OXM_HEADER  (0x8000, OFPXMT_OFB_IPV4_SRC, 4)
	// #define OXM_OF_IPV4_SRC_W   OXM_HEADER_W(0x8000, OFPXMT_OFB_IPV4_SRC, 4)
	// #define OXM_OF_IPV4_DST     OXM_HEADER  (0x8000, OFPXMT_OFB_IPV4_DST, 4)
	// #define OXM_OF_IPV4_DST_W   OXM_HEADER_W(0x8000, OFPXMT_OFB_IPV4_DST, 4)
	Ipv4Src uint32 `protobuf:"varint,14,opt,name=ipv4_src,json=ipv4Src,proto3,oneof"` // Used for OFPXMT_OFB_IPV4_SRC
}

type OfpOxmOfbField_Ipv4Dst struct {
	Ipv4Dst uint32 `protobuf:"varint,15,opt,name=ipv4_dst,json=ipv4Dst,proto3,oneof"` // Used for OFPXMT_OFB_IPV4_DST
}

type OfpOxmOfbField_TcpSrc struct {
	// #define OXM_OF_TCP_SRC    OXM_HEADER  (0x8000, OFPXMT_OFB_TCP_SRC, 2)
	// #define OXM_OF_TCP_DST    OXM_HEADER  (0x8000, OFPXMT_OFB_TCP_DST, 2)
	TcpSrc uint32 `protobuf:"varint,16,opt,name=tcp_src,json=tcpSrc,proto3,oneof"` // Used for OFPXMT_OFB_TCP_SRC
}

type OfpOxmOfbField_TcpDst struct {
	TcpDst uint32 `protobuf:"varint,17,opt,name=tcp_dst,json=tcpDst,proto3,oneof"` // Used for OFPXMT_OFB_TCP_DST
}

type OfpOxmOfbField_UdpSrc struct {
	// #define OXM_OF_UDP_SRC    OXM_HEADER  (0x8000, OFPXMT_OFB_UDP_SRC, 2)
	// #define OXM_OF_UDP_DST    OXM_HEADER  (0x8000, OFPXMT_OFB_UDP_DST, 2)
	UdpSrc uint32 `protobuf:"varint,18,opt,name=udp_src,json=udpSrc,proto3,oneof"` // Used for OFPXMT_OFB_UDP_SRC
}

type OfpOxmOfbField_UdpDst struct {
	UdpDst uint32 `protobuf:"varint,19,opt,name=udp_dst,json=udpDst,proto3,oneof"` // Used for OFPXMT_OFB_UDP_DST
}

type OfpOxmOfbField_SctpSrc struct {
	// #define OXM_OF_SCTP_SRC   OXM_HEADER  (0x8000, OFPXMT_OFB_SCTP_SRC, 2)
	// #define OXM_OF_SCTP_DST   OXM_HEADER  (0x8000, OFPXMT_OFB_SCTP_DST, 2)
	SctpSrc uint32 `protobuf:"varint,20,opt,name=sctp_src,json=sctpSrc,proto3,oneof"` // Used for OFPXMT_OFB_SCTP_SRC
}

type OfpOxmOfbField_SctpDst struct {
	SctpDst uint32 `protobuf:"varint,21,opt,name=sctp_dst,json=sctpDst,proto3,oneof"` // Used for OFPXMT_OFB_SCTP_DST
}

type OfpOxmOfbField_Icmpv4Type struct {
	// #define OXM_OF_ICMPV4_TYPE  OXM_HEADER  (0x8000, OFPXMT_OFB_ICMPV4_TYPE, 1)
	// #define OXM_OF_ICMPV4_CODE  OXM_HEADER  (0x8000, OFPXMT_OFB_ICMPV4_CODE, 1)
	Icmpv4Type uint32 `protobuf:"varint,22,opt,name=icmpv4_type,json=icmpv4Type,proto3,oneof"` // Used for OFPXMT_OFB_ICMPV4_TYPE
}

type OfpOxmOfbField_Icmpv4Code struct {
	Icmpv4Code uint32 `protobuf:"varint,23,opt,name=icmpv4_code,json=icmpv4Code,proto3,oneof"` // Used for OFPXMT_OFB_ICMPV4_CODE
}

type OfpOxmOfbField_ArpOp struct {
	// #define OXM_OF_ARP_OP     OXM_HEADER  (0x8000, OFPXMT_OFB_ARP_OP, 2)
	ArpOp uint32 `protobuf:"varint,24,opt,name=arp_op,json=arpOp,proto3,oneof"` // Used for OFPXMT_OFB_ARP_OP
}

type OfpOxmOfbField_ArpSpa struct {
	// #define OXM_OF_ARP_SPA    OXM_HEADER  (0x8000, OFPXMT_OFB_ARP_SPA, 4)
	// #define OXM_OF_ARP_SPA_W  OXM_HEADER_W(0x8000, OFPXMT_OFB_ARP_SPA, 4)
	// #define OXM_OF_ARP_TPA    OXM_HEADER  (0x8000, OFPXMT_OFB_ARP_TPA, 4)
	// #define OXM_OF_ARP_TPA_W  OXM_HEADER_W(0x8000, OFPXMT_OFB_ARP_TPA, 4)
	ArpSpa uint32 `protobuf:"varint,25,opt,name=arp_spa,json=arpSpa,proto3,oneof"` // For OFPXMT_OFB_ARP_SPA
}

type OfpOxmOfbField_ArpTpa struct {
	ArpTpa uint32 `protobuf:"varint,26,opt,name=arp_tpa,json=arpTpa,proto3,oneof"` // For OFPXMT_OFB_ARP_TPA
}

type OfpOxmOfbField_ArpSha struct {
	// #define OXM_OF_ARP_SHA    OXM_HEADER   (0x8000, OFPXMT_OFB_ARP_SHA, 6)
	// #define OXM_OF_ARP_SHA_W  OXM_HEADER_W (0x8000, OFPXMT_OFB_ARP_SHA, 6)
	// #define OXM_OF_ARP_THA    OXM_HEADER   (0x8000, OFPXMT_OFB_ARP_THA, 6)
	// #define OXM_OF_ARP_THA_W  OXM_HEADER_W (0x8000, OFPXMT_OFB_ARP_THA, 6)
	ArpSha []byte `protobuf:"bytes,27,opt,name=arp_sha,json=arpSha,proto3,oneof"` // For OFPXMT_OFB_ARP_SHA (6 bytes)
}

type OfpOxmOfbField_ArpTha struct {
	ArpTha []byte `protobuf:"bytes,28,opt,name=arp_tha,json=arpTha,proto3,oneof"` // For OFPXMT_OFB_ARP_THA (6 bytes)
}

type OfpOxmOfbField_Ipv6Src struct {
	// #define OXM_OF_IPV6_SRC    OXM_HEADER  (0x8000, OFPXMT_OFB_IPV6_SRC, 16)
	// #define OXM_OF_IPV6_SRC_W  OXM_HEADER_W(0x8000, OFPXMT_OFB_IPV6_SRC, 16)
	// #define OXM_OF_IPV6_DST    OXM_HEADER  (0x8000, OFPXMT_OFB_IPV6_DST, 16)
	// #define OXM_OF_IPV6_DST_W  OXM_HEADER_W(0x8000, OFPXMT_OFB_IPV6_DST, 16)
	Ipv6Src []byte `protobuf:"bytes,29,opt,name=ipv6_src,json=ipv6Src,proto3,oneof"` // For OFPXMT_OFB_IPV6_SRC
}

type OfpOxmOfbField_Ipv6Dst struct {
	Ipv6Dst []byte `protobuf:"bytes,30,opt,name=ipv6_dst,json=ipv6Dst,proto3,oneof"` // For OFPXMT_OFB_IPV6_DST
}

type OfpOxmOfbField_Ipv6Flabel struct {
	// #define OXM_OF_IPV6_FLABEL   OXM_HEADER  (0x8000, OFPXMT_OFB_IPV6_FLABEL, 4)
	// #define OXM_OF_IPV6_FLABEL_W OXM_HEADER_W(0x8000, OFPXMT_OFB_IPV6_FLABEL, 4)
	Ipv6Flabel uint32 `protobuf:"varint,31,opt,name=ipv6_flabel,json=ipv6Flabel,proto3,oneof"` // For OFPXMT_OFB_IPV6_FLABEL
}

type OfpOxmOfbField_Icmpv6Type struct {
	// #define OXM_OF_ICMPV6_TYPE OXM_HEADER  (0x8000, OFPXMT_OFB_ICMPV6_TYPE, 1)
	// #define OXM_OF_ICMPV6_CODE OXM_HEADER  (0x8000, OFPXMT_OFB_ICMPV6_CODE, 1)
	Icmpv6Type uint32 `protobuf:"varint,32,opt,name=icmpv6_type,json=icmpv6Type,proto3,oneof"` // For OFPXMT_OFB_ICMPV6_TYPE
}

type OfpOxmOfbField_Icmpv6Code struct {
	Icmpv6Code uint32 `protobuf:"varint,33,opt,name=icmpv6_code,json=icmpv6Code,proto3,oneof"` // For OFPXMT_OFB_ICMPV6_CODE
}

type OfpOxmOfbField_Ipv6NdTarget struct {
	//	#define OXM_OF_IPV6_ND_TARGET OXM_HEADER \
	//	   (0x8000, OFPXMT_OFB_IPV6_ND_TARGET, 16)
	Ipv6NdTarget []byte `protobuf:"bytes,34,opt,name=ipv6_nd_target,json=ipv6NdTarget,proto3,oneof"` // For OFPXMT_OFB_IPV6_ND_TARGET
}

type OfpOxmOfbField_Ipv6NdSsl struct {
	// #define OXM_OF_IPV6_ND_SLL  OXM_HEADER  (0x8000, OFPXMT_OFB_IPV6_ND_SLL, 6)
	Ipv6NdSsl []byte `protobuf:"bytes,35,opt,name=ipv6_nd_ssl,json=ipv6NdSsl,proto3,oneof"` // For OFPXMT_OFB_IPV6_ND_SLL
}

type OfpOxmOfbField_Ipv6NdTll struct {
	// #define OXM_OF_IPV6_ND_TLL  OXM_HEADER  (0x8000, OFPXMT_OFB_IPV6_ND_TLL, 6)
	Ipv6NdTll []byte `protobuf:"bytes,36,opt,name=ipv6_nd_tll,json=ipv6NdTll,proto3,oneof"` // For OFPXMT_OFB_IPV6_ND_TLL
}

type OfpOxmOfbField_MplsLabel struct {
	// #define OXM_OF_MPLS_LABEL  OXM_HEADER  (0x8000, OFPXMT_OFB_MPLS_LABEL, 4)
	MplsLabel uint32 `protobuf:"varint,37,opt,name=mpls_label,json=mplsLabel,proto3,oneof"` // For OFPXMT_OFB_MPLS_LABEL
}

type OfpOxmOfbField_MplsTc struct {
	// #define OXM_OF_MPLS_TC     OXM_HEADER  (0x8000, OFPXMT_OFB_MPLS_TC, 1)
	MplsTc uint32 `protobuf:"varint,38,opt,name=mpls_tc,json=mplsTc,proto3,oneof"` // For OFPXMT_OFB_MPLS_TC
}

type OfpOxmOfbField_MplsBos struct {
	// #define OXM_OF_MPLS_BOS     OXM_HEADER  (0x8000, OFPXMT_OFB_MPLS_BOS, 1)
	MplsBos uint32 `protobuf:"varint,39,opt,name=mpls_bos,json=mplsBos,proto3,oneof"` // For OFPXMT_OFB_MPLS_BOS
}

type OfpOxmOfbField_PbbIsid struct {
	// #define OXM_OF_PBB_ISID   OXM_HEADER  (0x8000, OFPXMT_OFB_PBB_ISID, 3)
	// #define OXM_OF_PBB_ISID_W OXM_HEADER_W(0x8000, OFPXMT_OFB_PBB_ISID, 3)
	PbbIsid uint32 `protobuf:"varint,40,opt,name=pbb_isid,json=pbbIsid,proto3,oneof"` // For OFPXMT_OFB_PBB_ISID
}

type OfpOxmOfbField_TunnelId struct {
	// #define OXM_OF_TUNNEL_ID    OXM_HEADER  (0x8000, OFPXMT_OFB_TUNNEL_ID, 8)
	// #define OXM_OF_TUNNEL_ID_W  OXM_HEADER_W(0x8000, OFPXMT_OFB_TUNNEL_ID, 8)
	TunnelId uint64 `protobuf:"varint,41,opt,name=tunnel_id,json=tunnelId,proto3,oneof"` // For OFPXMT_OFB_TUNNEL_ID
}

type OfpOxmOfbField_Ipv6Exthdr struct {
	// #define OXM_OF_IPV6_EXTHDR   OXM_HEADER  (0x8000, OFPXMT_OFB_IPV6_EXTHDR, 2)
	// #define OXM_OF_IPV6_EXTHDR_W OXM_HEADER_W(0x8000, OFPXMT_OFB_IPV6_EXTHDR, 2)
	Ipv6Exthdr uint32 `protobuf:"varint,42,opt,name=ipv6_exthdr,json=ipv6Exthdr,proto3,oneof"` // For OFPXMT_OFB_IPV6_EXTHDR
}

func (*OfpOxmOfbField_Port) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_PhysicalPort) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_TableMetadata) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_EthDst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_EthSrc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_EthType) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_VlanVid) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_VlanPcp) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_IpDscp) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_IpEcn) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_IpProto) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv4Src) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv4Dst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_TcpSrc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_TcpDst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_UdpSrc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_UdpDst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_SctpSrc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_SctpDst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Icmpv4Type) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Icmpv4Code) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpOp) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpSpa) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpTpa) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpSha) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_ArpTha) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6Src) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6Dst) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6Flabel) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Icmpv6Type) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Icmpv6Code) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6NdTarget) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6NdSsl) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6NdTll) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_MplsLabel) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_MplsTc) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_MplsBos) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_PbbIsid) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_TunnelId) isOfpOxmOfbField_Value() {}

func (*OfpOxmOfbField_Ipv6Exthdr) isOfpOxmOfbField_Value() {}

type isOfpOxmOfbField_Mask interface {
	isOfpOxmOfbField_Mask()
}

type OfpOxmOfbField_TableMetadataMask struct {
	TableMetadataMask uint64 `protobuf:"varint,105,opt,name=table_metadata_mask,json=tableMetadataMask,proto3,oneof"` // For OFPXMT_OFB_METADATA
}

type OfpOxmOfbField_EthDstMask struct {
	EthDstMask []byte `protobuf:"bytes,106,opt,name=eth_dst_mask,json=ethDstMask,proto3,oneof"` // For OFPXMT_OFB_ETH_DST (exactly 6 bytes)
}

type OfpOxmOfbField_EthSrcMask struct {
	EthSrcMask []byte `protobuf:"bytes,107,opt,name=eth_src_mask,json=ethSrcMask,proto3,oneof"` // For OFPXMT_OFB_ETH_SRC (exactly 6 bytes)
}

type OfpOxmOfbField_VlanVidMask struct {
	VlanVidMask uint32 `protobuf:"varint,109,opt,name=vlan_vid_mask,json=vlanVidMask,proto3,oneof"` // For OFPXMT_OFB_VLAN_VID
}

type OfpOxmOfbField_Ipv4SrcMask struct {
	Ipv4SrcMask uint32 `protobuf:"varint,114,opt,name=ipv4_src_mask,json=ipv4SrcMask,proto3,oneof"` // For OFPXMT_OFB_IPV4_SRC
}

type OfpOxmOfbField_Ipv4DstMask struct {
	Ipv4DstMask uint32 `protobuf:"varint,115,opt,name=ipv4_dst_mask,json=ipv4DstMask,proto3,oneof"` // For OFPXMT_OFB_IPV4_DST
}

type OfpOxmOfbField_ArpSpaMask struct {
	ArpSpaMask uint32 `protobuf:"varint,125,opt,name=arp_spa_mask,json=arpSpaMask,proto3,oneof"` // For OFPXMT_OFB_ARP_SPA
}

type OfpOxmOfbField_ArpTpaMask struct {
	ArpTpaMask uint32 `protobuf:"varint,126,opt,name=arp_tpa_mask,json=arpTpaMask,proto3,oneof"` // For OFPXMT_OFB_ARP_TPA
}

type OfpOxmOfbField_Ipv6SrcMask struct {
	Ipv6SrcMask []byte `protobuf:"bytes,129,opt,name=ipv6_src_mask,json=ipv6SrcMask,proto3,oneof"` // For OFPXMT_OFB_IPV6_SRC
}

type OfpOxmOfbField_Ipv6DstMask struct {
	Ipv6DstMask []byte `protobuf:"bytes,130,opt,name=ipv6_dst_mask,json=ipv6DstMask,proto3,oneof"` // For OFPXMT_OFB_IPV6_DST
}

type OfpOxmOfbField_Ipv6FlabelMask struct {
	Ipv6FlabelMask uint32 `protobuf:"varint,131,opt,name=ipv6_flabel_mask,json=ipv6FlabelMask,proto3,oneof"` // For OFPXMT_OFB_IPV6_FLABEL
}

type OfpOxmOfbField_PbbIsidMask struct {
	PbbIsidMask uint32 `protobuf:"varint,140,opt,name=pbb_isid_mask,json=pbbIsidMask,proto3,oneof"` // For OFPXMT_OFB_PBB_ISID
}

type OfpOxmOfbField_TunnelIdMask struct {
	TunnelIdMask uint64 `protobuf:"varint,141,opt,name=tunnel_id_mask,json=tunnelIdMask,proto3,oneof"` // For OFPXMT_OFB_TUNNEL_ID
}

type OfpOxmOfbField_Ipv6ExthdrMask struct {
	Ipv6ExthdrMask uint32 `protobuf:"varint,142,opt,name=ipv6_exthdr_mask,json=ipv6ExthdrMask,proto3,oneof"` // For OFPXMT_OFB_IPV6_EXTHDR
}

func (*OfpOxmOfbField_TableMetadataMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_EthDstMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_EthSrcMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_VlanVidMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv4SrcMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv4DstMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_ArpSpaMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_ArpTpaMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv6SrcMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv6DstMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv6FlabelMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_PbbIsidMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_TunnelIdMask) isOfpOxmOfbField_Mask() {}

func (*OfpOxmOfbField_Ipv6ExthdrMask) isOfpOxmOfbField_Mask() {}

// Header for OXM experimenter match fields.
// The experimenter class should not use OXM_HEADER() macros for defining
// fields due to this extra header.
type OfpOxmExperimenterField struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OxmHeader     uint32                 `protobuf:"varint,1,opt,name=oxm_header,json=oxmHeader,proto3" json:"oxm_header,omitempty"` // oxm_class = OFPXMC_EXPERIMENTER
	Experimenter  uint32                 `protobuf:"varint,2,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpOxmExperimenterField) Reset() {
	*x = OfpOxmExperimenterField{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpOxmExperimenterField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpOxmExperimenterField) ProtoMessage() {}

func (x *OfpOxmExperimenterField) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpOxmExperimenterField.ProtoReflect.Descriptor instead.
func (*OfpOxmExperimenterField) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{14}
}

func (x *OfpOxmExperimenterField) GetOxmHeader() uint32 {
	if x != nil {
		return x.OxmHeader
	}
	return 0
}

func (x *OfpOxmExperimenterField) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

// Action header that is common to all actions.  The length includes the
// header and any padding used to make the action 64-bit aligned.
// NB: The length of an action *must* always be a multiple of eight.
type OfpAction struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  OfpActionType          `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpActionType" json:"type,omitempty"` // One of OFPAT_*.
	// Types that are valid to be assigned to Action:
	//
	//	*OfpAction_Output
	//	*OfpAction_MplsTtl
	//	*OfpAction_Push
	//	*OfpAction_PopMpls
	//	*OfpAction_Group
	//	*OfpAction_NwTtl
	//	*OfpAction_SetField
	//	*OfpAction_Experimenter
	Action        isOfpAction_Action `protobuf_oneof:"action"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpAction) Reset() {
	*x = OfpAction{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpAction) ProtoMessage() {}

func (x *OfpAction) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpAction.ProtoReflect.Descriptor instead.
func (*OfpAction) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{15}
}

func (x *OfpAction) GetType() OfpActionType {
	if x != nil {
		return x.Type
	}
	return OfpActionType_OFPAT_OUTPUT
}

func (x *OfpAction) GetAction() isOfpAction_Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *OfpAction) GetOutput() *OfpActionOutput {
	if x != nil {
		if x, ok := x.Action.(*OfpAction_Output); ok {
			return x.Output
		}
	}
	return nil
}

func (x *OfpAction) GetMplsTtl() *OfpActionMplsTtl {
	if x != nil {
		if x, ok := x.Action.(*OfpAction_MplsTtl); ok {
			return x.MplsTtl
		}
	}
	return nil
}

func (x *OfpAction) GetPush() *OfpActionPush {
	if x != nil {
		if x, ok := x.Action.(*OfpAction_Push); ok {
			return x.Push
		}
	}
	return nil
}

func (x *OfpAction) GetPopMpls() *OfpActionPopMpls {
	if x != nil {
		if x, ok := x.Action.(*OfpAction_PopMpls); ok {
			return x.PopMpls
		}
	}
	return nil
}

func (x *OfpAction) GetGroup() *OfpActionGroup {
	if x != nil {
		if x, ok := x.Action.(*OfpAction_Group); ok {
			return x.Group
		}
	}
	return nil
}

func (x *OfpAction) GetNwTtl() *OfpActionNwTtl {
	if x != nil {
		if x, ok := x.Action.(*OfpAction_NwTtl); ok {
			return x.NwTtl
		}
	}
	return nil
}

func (x *OfpAction) GetSetField() *OfpActionSetField {
	if x != nil {
		if x, ok := x.Action.(*OfpAction_SetField); ok {
			return x.SetField
		}
	}
	return nil
}

func (x *OfpAction) GetExperimenter() *OfpActionExperimenter {
	if x != nil {
		if x, ok := x.Action.(*OfpAction_Experimenter); ok {
			return x.Experimenter
		}
	}
	return nil
}

type isOfpAction_Action interface {
	isOfpAction_Action()
}

type OfpAction_Output struct {
	Output *OfpActionOutput `protobuf:"bytes,2,opt,name=output,proto3,oneof"`
}

type OfpAction_MplsTtl struct {
	MplsTtl *OfpActionMplsTtl `protobuf:"bytes,3,opt,name=mpls_ttl,json=mplsTtl,proto3,oneof"`
}

type OfpAction_Push struct {
	Push *OfpActionPush `protobuf:"bytes,4,opt,name=push,proto3,oneof"`
}

type OfpAction_PopMpls struct {
	PopMpls *OfpActionPopMpls `protobuf:"bytes,5,opt,name=pop_mpls,json=popMpls,proto3,oneof"`
}

type OfpAction_Group struct {
	Group *OfpActionGroup `protobuf:"bytes,6,opt,name=group,proto3,oneof"`
}

type OfpAction_NwTtl struct {
	NwTtl *OfpActionNwTtl `protobuf:"bytes,7,opt,name=nw_ttl,json=nwTtl,proto3,oneof"`
}

type OfpAction_SetField struct {
	SetField *OfpActionSetField `protobuf:"bytes,8,opt,name=set_field,json=setField,proto3,oneof"`
}

type OfpAction_Experimenter struct {
	Experimenter *OfpActionExperimenter `protobuf:"bytes,9,opt,name=experimenter,proto3,oneof"`
}

func (*OfpAction_Output) isOfpAction_Action() {}

func (*OfpAction_MplsTtl) isOfpAction_Action() {}

func (*OfpAction_Push) isOfpAction_Action() {}

func (*OfpAction_PopMpls) isOfpAction_Action() {}

func (*OfpAction_Group) isOfpAction_Action() {}

func (*OfpAction_NwTtl) isOfpAction_Action() {}

func (*OfpAction_SetField) isOfpAction_Action() {}

func (*OfpAction_Experimenter) isOfpAction_Action() {}

// Action structure for OFPAT_OUTPUT, which sends packets out 'port'.
// When the 'port' is the OFPP_CONTROLLER, 'max_len' indicates the max
// number of bytes to send.  A 'max_len' of zero means no bytes of the
// packet should be sent. A 'max_len' of OFPCML_NO_BUFFER means that
// the packet is not buffered and the complete packet is to be sent to
// the controller.
type OfpActionOutput struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Port          uint32                 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`                   // Output port.
	MaxLen        uint32                 `protobuf:"varint,2,opt,name=max_len,json=maxLen,proto3" json:"max_len,omitempty"` // Max length to send to controller.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionOutput) Reset() {
	*x = OfpActionOutput{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionOutput) ProtoMessage() {}

func (x *OfpActionOutput) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionOutput.ProtoReflect.Descriptor instead.
func (*OfpActionOutput) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{16}
}

func (x *OfpActionOutput) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *OfpActionOutput) GetMaxLen() uint32 {
	if x != nil {
		return x.MaxLen
	}
	return 0
}

// Action structure for OFPAT_SET_MPLS_TTL.
type OfpActionMplsTtl struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MplsTtl       uint32                 `protobuf:"varint,1,opt,name=mpls_ttl,json=mplsTtl,proto3" json:"mpls_ttl,omitempty"` // MPLS TTL
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionMplsTtl) Reset() {
	*x = OfpActionMplsTtl{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionMplsTtl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionMplsTtl) ProtoMessage() {}

func (x *OfpActionMplsTtl) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionMplsTtl.ProtoReflect.Descriptor instead.
func (*OfpActionMplsTtl) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{17}
}

func (x *OfpActionMplsTtl) GetMplsTtl() uint32 {
	if x != nil {
		return x.MplsTtl
	}
	return 0
}

// Action structure for OFPAT_PUSH_VLAN/MPLS/PBB.
type OfpActionPush struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Ethertype     uint32                 `protobuf:"varint,1,opt,name=ethertype,proto3" json:"ethertype,omitempty"` // Ethertype
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionPush) Reset() {
	*x = OfpActionPush{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionPush) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionPush) ProtoMessage() {}

func (x *OfpActionPush) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionPush.ProtoReflect.Descriptor instead.
func (*OfpActionPush) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{18}
}

func (x *OfpActionPush) GetEthertype() uint32 {
	if x != nil {
		return x.Ethertype
	}
	return 0
}

// Action structure for OFPAT_POP_MPLS.
type OfpActionPopMpls struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Ethertype     uint32                 `protobuf:"varint,1,opt,name=ethertype,proto3" json:"ethertype,omitempty"` // Ethertype
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionPopMpls) Reset() {
	*x = OfpActionPopMpls{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionPopMpls) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionPopMpls) ProtoMessage() {}

func (x *OfpActionPopMpls) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionPopMpls.ProtoReflect.Descriptor instead.
func (*OfpActionPopMpls) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{19}
}

func (x *OfpActionPopMpls) GetEthertype() uint32 {
	if x != nil {
		return x.Ethertype
	}
	return 0
}

// Action structure for OFPAT_GROUP.
type OfpActionGroup struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupId       uint32                 `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"` // Group identifier.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionGroup) Reset() {
	*x = OfpActionGroup{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionGroup) ProtoMessage() {}

func (x *OfpActionGroup) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionGroup.ProtoReflect.Descriptor instead.
func (*OfpActionGroup) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{20}
}

func (x *OfpActionGroup) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

// Action structure for OFPAT_SET_NW_TTL.
type OfpActionNwTtl struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NwTtl         uint32                 `protobuf:"varint,1,opt,name=nw_ttl,json=nwTtl,proto3" json:"nw_ttl,omitempty"` // IP TTL
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionNwTtl) Reset() {
	*x = OfpActionNwTtl{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionNwTtl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionNwTtl) ProtoMessage() {}

func (x *OfpActionNwTtl) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionNwTtl.ProtoReflect.Descriptor instead.
func (*OfpActionNwTtl) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{21}
}

func (x *OfpActionNwTtl) GetNwTtl() uint32 {
	if x != nil {
		return x.NwTtl
	}
	return 0
}

// Action structure for OFPAT_SET_FIELD.
type OfpActionSetField struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Field         *OfpOxmField           `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionSetField) Reset() {
	*x = OfpActionSetField{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionSetField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionSetField) ProtoMessage() {}

func (x *OfpActionSetField) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionSetField.ProtoReflect.Descriptor instead.
func (*OfpActionSetField) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{22}
}

func (x *OfpActionSetField) GetField() *OfpOxmField {
	if x != nil {
		return x.Field
	}
	return nil
}

// Action header for OFPAT_EXPERIMENTER.
// The rest of the body is experimenter-defined.
type OfpActionExperimenter struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Experimenter  uint32                 `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	Data          []byte                 `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionExperimenter) Reset() {
	*x = OfpActionExperimenter{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionExperimenter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionExperimenter) ProtoMessage() {}

func (x *OfpActionExperimenter) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionExperimenter.ProtoReflect.Descriptor instead.
func (*OfpActionExperimenter) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{23}
}

func (x *OfpActionExperimenter) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

func (x *OfpActionExperimenter) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Instruction header that is common to all instructions.  The length includes
// the header and any padding used to make the instruction 64-bit aligned.
// NB: The length of an instruction *must* always be a multiple of eight.
type OfpInstruction struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"` // Instruction type
	// Types that are valid to be assigned to Data:
	//
	//	*OfpInstruction_GotoTable
	//	*OfpInstruction_WriteMetadata
	//	*OfpInstruction_Actions
	//	*OfpInstruction_Meter
	//	*OfpInstruction_Experimenter
	Data          isOfpInstruction_Data `protobuf_oneof:"data"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpInstruction) Reset() {
	*x = OfpInstruction{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpInstruction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpInstruction) ProtoMessage() {}

func (x *OfpInstruction) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpInstruction.ProtoReflect.Descriptor instead.
func (*OfpInstruction) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{24}
}

func (x *OfpInstruction) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *OfpInstruction) GetData() isOfpInstruction_Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *OfpInstruction) GetGotoTable() *OfpInstructionGotoTable {
	if x != nil {
		if x, ok := x.Data.(*OfpInstruction_GotoTable); ok {
			return x.GotoTable
		}
	}
	return nil
}

func (x *OfpInstruction) GetWriteMetadata() *OfpInstructionWriteMetadata {
	if x != nil {
		if x, ok := x.Data.(*OfpInstruction_WriteMetadata); ok {
			return x.WriteMetadata
		}
	}
	return nil
}

func (x *OfpInstruction) GetActions() *OfpInstructionActions {
	if x != nil {
		if x, ok := x.Data.(*OfpInstruction_Actions); ok {
			return x.Actions
		}
	}
	return nil
}

func (x *OfpInstruction) GetMeter() *OfpInstructionMeter {
	if x != nil {
		if x, ok := x.Data.(*OfpInstruction_Meter); ok {
			return x.Meter
		}
	}
	return nil
}

func (x *OfpInstruction) GetExperimenter() *OfpInstructionExperimenter {
	if x != nil {
		if x, ok := x.Data.(*OfpInstruction_Experimenter); ok {
			return x.Experimenter
		}
	}
	return nil
}

type isOfpInstruction_Data interface {
	isOfpInstruction_Data()
}

type OfpInstruction_GotoTable struct {
	GotoTable *OfpInstructionGotoTable `protobuf:"bytes,2,opt,name=goto_table,json=gotoTable,proto3,oneof"`
}

type OfpInstruction_WriteMetadata struct {
	WriteMetadata *OfpInstructionWriteMetadata `protobuf:"bytes,3,opt,name=write_metadata,json=writeMetadata,proto3,oneof"`
}

type OfpInstruction_Actions struct {
	Actions *OfpInstructionActions `protobuf:"bytes,4,opt,name=actions,proto3,oneof"`
}

type OfpInstruction_Meter struct {
	Meter *OfpInstructionMeter `protobuf:"bytes,5,opt,name=meter,proto3,oneof"`
}

type OfpInstruction_Experimenter struct {
	Experimenter *OfpInstructionExperimenter `protobuf:"bytes,6,opt,name=experimenter,proto3,oneof"`
}

func (*OfpInstruction_GotoTable) isOfpInstruction_Data() {}

func (*OfpInstruction_WriteMetadata) isOfpInstruction_Data() {}

func (*OfpInstruction_Actions) isOfpInstruction_Data() {}

func (*OfpInstruction_Meter) isOfpInstruction_Data() {}

func (*OfpInstruction_Experimenter) isOfpInstruction_Data() {}

// Instruction structure for OFPIT_GOTO_TABLE
type OfpInstructionGotoTable struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TableId       uint32                 `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"` // Set next table in the lookup pipeline
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpInstructionGotoTable) Reset() {
	*x = OfpInstructionGotoTable{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpInstructionGotoTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpInstructionGotoTable) ProtoMessage() {}

func (x *OfpInstructionGotoTable) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpInstructionGotoTable.ProtoReflect.Descriptor instead.
func (*OfpInstructionGotoTable) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{25}
}

func (x *OfpInstructionGotoTable) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

// Instruction structure for OFPIT_WRITE_METADATA
type OfpInstructionWriteMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Metadata      uint64                 `protobuf:"varint,1,opt,name=metadata,proto3" json:"metadata,omitempty"`                             // Metadata value to write
	MetadataMask  uint64                 `protobuf:"varint,2,opt,name=metadata_mask,json=metadataMask,proto3" json:"metadata_mask,omitempty"` // Metadata write bitmask
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpInstructionWriteMetadata) Reset() {
	*x = OfpInstructionWriteMetadata{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpInstructionWriteMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpInstructionWriteMetadata) ProtoMessage() {}

func (x *OfpInstructionWriteMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpInstructionWriteMetadata.ProtoReflect.Descriptor instead.
func (*OfpInstructionWriteMetadata) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{26}
}

func (x *OfpInstructionWriteMetadata) GetMetadata() uint64 {
	if x != nil {
		return x.Metadata
	}
	return 0
}

func (x *OfpInstructionWriteMetadata) GetMetadataMask() uint64 {
	if x != nil {
		return x.MetadataMask
	}
	return 0
}

// Instruction structure for OFPIT_WRITE/APPLY/CLEAR_ACTIONS
type OfpInstructionActions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Actions       []*OfpAction           `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpInstructionActions) Reset() {
	*x = OfpInstructionActions{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpInstructionActions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpInstructionActions) ProtoMessage() {}

func (x *OfpInstructionActions) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpInstructionActions.ProtoReflect.Descriptor instead.
func (*OfpInstructionActions) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{27}
}

func (x *OfpInstructionActions) GetActions() []*OfpAction {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Instruction structure for OFPIT_METER
type OfpInstructionMeter struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MeterId       uint32                 `protobuf:"varint,1,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"` // Meter instance.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpInstructionMeter) Reset() {
	*x = OfpInstructionMeter{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpInstructionMeter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpInstructionMeter) ProtoMessage() {}

func (x *OfpInstructionMeter) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpInstructionMeter.ProtoReflect.Descriptor instead.
func (*OfpInstructionMeter) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{28}
}

func (x *OfpInstructionMeter) GetMeterId() uint32 {
	if x != nil {
		return x.MeterId
	}
	return 0
}

// Instruction structure for experimental instructions
type OfpInstructionExperimenter struct {
	state        protoimpl.MessageState `protogen:"open.v1"`
	Experimenter uint32                 `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	// Experimenter-defined arbitrary additional data.
	Data          []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpInstructionExperimenter) Reset() {
	*x = OfpInstructionExperimenter{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpInstructionExperimenter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpInstructionExperimenter) ProtoMessage() {}

func (x *OfpInstructionExperimenter) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpInstructionExperimenter.ProtoReflect.Descriptor instead.
func (*OfpInstructionExperimenter) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{29}
}

func (x *OfpInstructionExperimenter) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

func (x *OfpInstructionExperimenter) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Flow setup and teardown (controller -> datapath).
type OfpFlowMod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Cookie        uint64            `protobuf:"varint,1,opt,name=cookie,proto3" json:"cookie,omitempty"` // Opaque controller-issued identifier.
	CookieMask    uint64            `protobuf:"varint,2,opt,name=cookie_mask,json=cookieMask,proto3" json:"cookie_mask,omitempty"`
	TableId       uint32            `protobuf:"varint,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	Command       OfpFlowModCommand `protobuf:"varint,4,opt,name=command,proto3,enum=openflow_13.OfpFlowModCommand" json:"command,omitempty"` // One of OFPFC_*.
	IdleTimeout   uint32            `protobuf:"varint,5,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`         // Idle time before discarding (seconds).
	HardTimeout   uint32            `protobuf:"varint,6,opt,name=hard_timeout,json=hardTimeout,proto3" json:"hard_timeout,omitempty"`         // Max time before discarding (seconds).
	Priority      uint32            `protobuf:"varint,7,opt,name=priority,proto3" json:"priority,omitempty"`                                  // Priority level of flow entry.
	BufferId      uint32            `protobuf:"varint,8,opt,name=buffer_id,json=bufferId,proto3" json:"buffer_id,omitempty"`
	OutPort       uint32            `protobuf:"varint,9,opt,name=out_port,json=outPort,proto3" json:"out_port,omitempty"`
	OutGroup      uint32            `protobuf:"varint,10,opt,name=out_group,json=outGroup,proto3" json:"out_group,omitempty"`
	Flags         uint32            `protobuf:"varint,11,opt,name=flags,proto3" json:"flags,omitempty"`              // Bitmap of OFPFF_* flags.
	Match         *OfpMatch         `protobuf:"bytes,12,opt,name=match,proto3" json:"match,omitempty"`               // Fields to match. Variable size.
	Instructions  []*OfpInstruction `protobuf:"bytes,13,rep,name=instructions,proto3" json:"instructions,omitempty"` // 0 or more.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpFlowMod) Reset() {
	*x = OfpFlowMod{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpFlowMod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpFlowMod) ProtoMessage() {}

func (x *OfpFlowMod) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpFlowMod.ProtoReflect.Descriptor instead.
func (*OfpFlowMod) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{30}
}

func (x *OfpFlowMod) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *OfpFlowMod) GetCookieMask() uint64 {
	if x != nil {
		return x.CookieMask
	}
	return 0
}

func (x *OfpFlowMod) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpFlowMod) GetCommand() OfpFlowModCommand {
	if x != nil {
		return x.Command
	}
	return OfpFlowModCommand_OFPFC_ADD
}

func (x *OfpFlowMod) GetIdleTimeout() uint32 {
	if x != nil {
		return x.IdleTimeout
	}
	return 0
}

func (x *OfpFlowMod) GetHardTimeout() uint32 {
	if x != nil {
		return x.HardTimeout
	}
	return 0
}

func (x *OfpFlowMod) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *OfpFlowMod) GetBufferId() uint32 {
	if x != nil {
		return x.BufferId
	}
	return 0
}

func (x *OfpFlowMod) GetOutPort() uint32 {
	if x != nil {
		return x.OutPort
	}
	return 0
}

func (x *OfpFlowMod) GetOutGroup() uint32 {
	if x != nil {
		return x.OutGroup
	}
	return 0
}

func (x *OfpFlowMod) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *OfpFlowMod) GetMatch() *OfpMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *OfpFlowMod) GetInstructions() []*OfpInstruction {
	if x != nil {
		return x.Instructions
	}
	return nil
}

// Bucket for use in groups.
type OfpBucket struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Weight        uint32                 `protobuf:"varint,1,opt,name=weight,proto3" json:"weight,omitempty"`
	WatchPort     uint32                 `protobuf:"varint,2,opt,name=watch_port,json=watchPort,proto3" json:"watch_port,omitempty"`
	WatchGroup    uint32                 `protobuf:"varint,3,opt,name=watch_group,json=watchGroup,proto3" json:"watch_group,omitempty"`
	Actions       []*OfpAction           `protobuf:"bytes,4,rep,name=actions,proto3" json:"actions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpBucket) Reset() {
	*x = OfpBucket{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpBucket) ProtoMessage() {}

func (x *OfpBucket) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpBucket.ProtoReflect.Descriptor instead.
func (*OfpBucket) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{31}
}

func (x *OfpBucket) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *OfpBucket) GetWatchPort() uint32 {
	if x != nil {
		return x.WatchPort
	}
	return 0
}

func (x *OfpBucket) GetWatchGroup() uint32 {
	if x != nil {
		return x.WatchGroup
	}
	return 0
}

func (x *OfpBucket) GetActions() []*OfpAction {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Group setup and teardown (controller -> datapath).
type OfpGroupMod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Command       OfpGroupModCommand `protobuf:"varint,1,opt,name=command,proto3,enum=openflow_13.OfpGroupModCommand" json:"command,omitempty"` // One of OFPGC_*.
	Type          OfpGroupType       `protobuf:"varint,2,opt,name=type,proto3,enum=openflow_13.OfpGroupType" json:"type,omitempty"`             // One of OFPGT_*.
	GroupId       uint32             `protobuf:"varint,3,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`                      // Group identifier.
	Buckets       []*OfpBucket       `protobuf:"bytes,4,rep,name=buckets,proto3" json:"buckets,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpGroupMod) Reset() {
	*x = OfpGroupMod{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpGroupMod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpGroupMod) ProtoMessage() {}

func (x *OfpGroupMod) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpGroupMod.ProtoReflect.Descriptor instead.
func (*OfpGroupMod) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{32}
}

func (x *OfpGroupMod) GetCommand() OfpGroupModCommand {
	if x != nil {
		return x.Command
	}
	return OfpGroupModCommand_OFPGC_ADD
}

func (x *OfpGroupMod) GetType() OfpGroupType {
	if x != nil {
		return x.Type
	}
	return OfpGroupType_OFPGT_ALL
}

func (x *OfpGroupMod) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

func (x *OfpGroupMod) GetBuckets() []*OfpBucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// Send packet (controller -> datapath).
type OfpPacketOut struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	BufferId uint32       `protobuf:"varint,1,opt,name=buffer_id,json=bufferId,proto3" json:"buffer_id,omitempty"`
	InPort   uint32       `protobuf:"varint,2,opt,name=in_port,json=inPort,proto3" json:"in_port,omitempty"` // Packet's input port or OFPP_CONTROLLER.
	Actions  []*OfpAction `protobuf:"bytes,3,rep,name=actions,proto3" json:"actions,omitempty"`              // Action list - 0 or more.
	// The variable size action list is optionally followed by packet data.
	// This data is only present and meaningful if buffer_id == -1.
	Data          []byte `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"` // Packet data.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpPacketOut) Reset() {
	*x = OfpPacketOut{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpPacketOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpPacketOut) ProtoMessage() {}

func (x *OfpPacketOut) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpPacketOut.ProtoReflect.Descriptor instead.
func (*OfpPacketOut) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{33}
}

func (x *OfpPacketOut) GetBufferId() uint32 {
	if x != nil {
		return x.BufferId
	}
	return 0
}

func (x *OfpPacketOut) GetInPort() uint32 {
	if x != nil {
		return x.InPort
	}
	return 0
}

func (x *OfpPacketOut) GetActions() []*OfpAction {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *OfpPacketOut) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Packet received on port (datapath -> controller).
type OfpPacketIn struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	BufferId      uint32            `protobuf:"varint,1,opt,name=buffer_id,json=bufferId,proto3" json:"buffer_id,omitempty"`                // ID assigned by datapath.
	Reason        OfpPacketInReason `protobuf:"varint,2,opt,name=reason,proto3,enum=openflow_13.OfpPacketInReason" json:"reason,omitempty"` // Reason packet is being sent
	TableId       uint32            `protobuf:"varint,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`                   // ID of the table that was looked up
	Cookie        uint64            `protobuf:"varint,4,opt,name=cookie,proto3" json:"cookie,omitempty"`                                    // Cookie of the flow entry that was looked up.
	Match         *OfpMatch         `protobuf:"bytes,5,opt,name=match,proto3" json:"match,omitempty"`                                       // Packet metadata. Variable size.
	Data          []byte            `protobuf:"bytes,6,opt,name=data,proto3" json:"data,omitempty"`                                         // Ethernet frame
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpPacketIn) Reset() {
	*x = OfpPacketIn{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpPacketIn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpPacketIn) ProtoMessage() {}

func (x *OfpPacketIn) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpPacketIn.ProtoReflect.Descriptor instead.
func (*OfpPacketIn) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{34}
}

func (x *OfpPacketIn) GetBufferId() uint32 {
	if x != nil {
		return x.BufferId
	}
	return 0
}

func (x *OfpPacketIn) GetReason() OfpPacketInReason {
	if x != nil {
		return x.Reason
	}
	return OfpPacketInReason_OFPR_NO_MATCH
}

func (x *OfpPacketIn) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpPacketIn) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *OfpPacketIn) GetMatch() *OfpMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *OfpPacketIn) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Flow removed (datapath -> controller).
type OfpFlowRemoved struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Cookie        uint64               `protobuf:"varint,1,opt,name=cookie,proto3" json:"cookie,omitempty"`                                       // Opaque controller-issued identifier.
	Priority      uint32               `protobuf:"varint,2,opt,name=priority,proto3" json:"priority,omitempty"`                                   // Priority level of flow entry.
	Reason        OfpFlowRemovedReason `protobuf:"varint,3,opt,name=reason,proto3,enum=openflow_13.OfpFlowRemovedReason" json:"reason,omitempty"` // One of OFPRR_*.
	TableId       uint32               `protobuf:"varint,4,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`                      // ID of the table
	DurationSec   uint32               `protobuf:"varint,5,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"`          // Time flow was alive in seconds.
	DurationNsec  uint32               `protobuf:"varint,6,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	IdleTimeout   uint32               `protobuf:"varint,7,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"` // Idle timeout from original flow mod.
	HardTimeout   uint32               `protobuf:"varint,8,opt,name=hard_timeout,json=hardTimeout,proto3" json:"hard_timeout,omitempty"` // Hard timeout from original flow mod.
	PacketCount   uint64               `protobuf:"varint,9,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"`
	ByteCount     uint64               `protobuf:"varint,10,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`
	Match         *OfpMatch            `protobuf:"bytes,121,opt,name=match,proto3" json:"match,omitempty"` // Description of fields. Variable size.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpFlowRemoved) Reset() {
	*x = OfpFlowRemoved{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpFlowRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpFlowRemoved) ProtoMessage() {}

func (x *OfpFlowRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpFlowRemoved.ProtoReflect.Descriptor instead.
func (*OfpFlowRemoved) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{35}
}

func (x *OfpFlowRemoved) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *OfpFlowRemoved) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *OfpFlowRemoved) GetReason() OfpFlowRemovedReason {
	if x != nil {
		return x.Reason
	}
	return OfpFlowRemovedReason_OFPRR_IDLE_TIMEOUT
}

func (x *OfpFlowRemoved) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpFlowRemoved) GetDurationSec() uint32 {
	if x != nil {
		return x.DurationSec
	}
	return 0
}

func (x *OfpFlowRemoved) GetDurationNsec() uint32 {
	if x != nil {
		return x.DurationNsec
	}
	return 0
}

func (x *OfpFlowRemoved) GetIdleTimeout() uint32 {
	if x != nil {
		return x.IdleTimeout
	}
	return 0
}

func (x *OfpFlowRemoved) GetHardTimeout() uint32 {
	if x != nil {
		return x.HardTimeout
	}
	return 0
}

func (x *OfpFlowRemoved) GetPacketCount() uint64 {
	if x != nil {
		return x.PacketCount
	}
	return 0
}

func (x *OfpFlowRemoved) GetByteCount() uint64 {
	if x != nil {
		return x.ByteCount
	}
	return 0
}

func (x *OfpFlowRemoved) GetMatch() *OfpMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

// Common header for all meter bands
type OfpMeterBandHeader struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Type      OfpMeterBandType       `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpMeterBandType" json:"type,omitempty"` // One of OFPMBT_*.
	Rate      uint32                 `protobuf:"varint,2,opt,name=rate,proto3" json:"rate,omitempty"`                                   // Rate for this band.
	BurstSize uint32                 `protobuf:"varint,3,opt,name=burst_size,json=burstSize,proto3" json:"burst_size,omitempty"`        // Size of bursts.
	// Types that are valid to be assigned to Data:
	//
	//	*OfpMeterBandHeader_Drop
	//	*OfpMeterBandHeader_DscpRemark
	//	*OfpMeterBandHeader_Experimenter
	Data          isOfpMeterBandHeader_Data `protobuf_oneof:"data"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterBandHeader) Reset() {
	*x = OfpMeterBandHeader{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterBandHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterBandHeader) ProtoMessage() {}

func (x *OfpMeterBandHeader) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterBandHeader.ProtoReflect.Descriptor instead.
func (*OfpMeterBandHeader) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{36}
}

func (x *OfpMeterBandHeader) GetType() OfpMeterBandType {
	if x != nil {
		return x.Type
	}
	return OfpMeterBandType_OFPMBT_INVALID
}

func (x *OfpMeterBandHeader) GetRate() uint32 {
	if x != nil {
		return x.Rate
	}
	return 0
}

func (x *OfpMeterBandHeader) GetBurstSize() uint32 {
	if x != nil {
		return x.BurstSize
	}
	return 0
}

func (x *OfpMeterBandHeader) GetData() isOfpMeterBandHeader_Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *OfpMeterBandHeader) GetDrop() *OfpMeterBandDrop {
	if x != nil {
		if x, ok := x.Data.(*OfpMeterBandHeader_Drop); ok {
			return x.Drop
		}
	}
	return nil
}

func (x *OfpMeterBandHeader) GetDscpRemark() *OfpMeterBandDscpRemark {
	if x != nil {
		if x, ok := x.Data.(*OfpMeterBandHeader_DscpRemark); ok {
			return x.DscpRemark
		}
	}
	return nil
}

func (x *OfpMeterBandHeader) GetExperimenter() *OfpMeterBandExperimenter {
	if x != nil {
		if x, ok := x.Data.(*OfpMeterBandHeader_Experimenter); ok {
			return x.Experimenter
		}
	}
	return nil
}

type isOfpMeterBandHeader_Data interface {
	isOfpMeterBandHeader_Data()
}

type OfpMeterBandHeader_Drop struct {
	Drop *OfpMeterBandDrop `protobuf:"bytes,4,opt,name=drop,proto3,oneof"`
}

type OfpMeterBandHeader_DscpRemark struct {
	DscpRemark *OfpMeterBandDscpRemark `protobuf:"bytes,5,opt,name=dscp_remark,json=dscpRemark,proto3,oneof"`
}

type OfpMeterBandHeader_Experimenter struct {
	Experimenter *OfpMeterBandExperimenter `protobuf:"bytes,6,opt,name=experimenter,proto3,oneof"`
}

func (*OfpMeterBandHeader_Drop) isOfpMeterBandHeader_Data() {}

func (*OfpMeterBandHeader_DscpRemark) isOfpMeterBandHeader_Data() {}

func (*OfpMeterBandHeader_Experimenter) isOfpMeterBandHeader_Data() {}

// OFPMBT_DROP band - drop packets
type OfpMeterBandDrop struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterBandDrop) Reset() {
	*x = OfpMeterBandDrop{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterBandDrop) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterBandDrop) ProtoMessage() {}

func (x *OfpMeterBandDrop) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterBandDrop.ProtoReflect.Descriptor instead.
func (*OfpMeterBandDrop) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{37}
}

// OFPMBT_DSCP_REMARK band - Remark DSCP in the IP header
type OfpMeterBandDscpRemark struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PrecLevel     uint32                 `protobuf:"varint,1,opt,name=prec_level,json=precLevel,proto3" json:"prec_level,omitempty"` // Number of drop precedence level to add.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterBandDscpRemark) Reset() {
	*x = OfpMeterBandDscpRemark{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterBandDscpRemark) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterBandDscpRemark) ProtoMessage() {}

func (x *OfpMeterBandDscpRemark) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterBandDscpRemark.ProtoReflect.Descriptor instead.
func (*OfpMeterBandDscpRemark) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{38}
}

func (x *OfpMeterBandDscpRemark) GetPrecLevel() uint32 {
	if x != nil {
		return x.PrecLevel
	}
	return 0
}

// OFPMBT_EXPERIMENTER band - Experimenter type.
// The rest of the band is experimenter-defined.
type OfpMeterBandExperimenter struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Experimenter  uint32                 `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterBandExperimenter) Reset() {
	*x = OfpMeterBandExperimenter{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterBandExperimenter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterBandExperimenter) ProtoMessage() {}

func (x *OfpMeterBandExperimenter) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterBandExperimenter.ProtoReflect.Descriptor instead.
func (*OfpMeterBandExperimenter) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{39}
}

func (x *OfpMeterBandExperimenter) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

// Meter configuration. OFPT_METER_MOD.
type OfpMeterMod struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Command       OfpMeterModCommand     `protobuf:"varint,1,opt,name=command,proto3,enum=openflow_13.OfpMeterModCommand" json:"command,omitempty"` // One of OFPMC_*.
	Flags         uint32                 `protobuf:"varint,2,opt,name=flags,proto3" json:"flags,omitempty"`                                         // Bitmap of OFPMF_* flags.
	MeterId       uint32                 `protobuf:"varint,3,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"`                      // Meter instance.
	Bands         []*OfpMeterBandHeader  `protobuf:"bytes,4,rep,name=bands,proto3" json:"bands,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterMod) Reset() {
	*x = OfpMeterMod{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterMod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterMod) ProtoMessage() {}

func (x *OfpMeterMod) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterMod.ProtoReflect.Descriptor instead.
func (*OfpMeterMod) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{40}
}

func (x *OfpMeterMod) GetCommand() OfpMeterModCommand {
	if x != nil {
		return x.Command
	}
	return OfpMeterModCommand_OFPMC_ADD
}

func (x *OfpMeterMod) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *OfpMeterMod) GetMeterId() uint32 {
	if x != nil {
		return x.MeterId
	}
	return 0
}

func (x *OfpMeterMod) GetBands() []*OfpMeterBandHeader {
	if x != nil {
		return x.Bands
	}
	return nil
}

// OFPT_ERROR: Error message (datapath -> controller).
type OfpErrorMsg struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Header        *OfpHeader             `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Type          uint32                 `protobuf:"varint,2,opt,name=type,proto3" json:"type,omitempty"`
	Code          uint32                 `protobuf:"varint,3,opt,name=code,proto3" json:"code,omitempty"`
	Data          []byte                 `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpErrorMsg) Reset() {
	*x = OfpErrorMsg{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpErrorMsg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpErrorMsg) ProtoMessage() {}

func (x *OfpErrorMsg) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpErrorMsg.ProtoReflect.Descriptor instead.
func (*OfpErrorMsg) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{41}
}

func (x *OfpErrorMsg) GetHeader() *OfpHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *OfpErrorMsg) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *OfpErrorMsg) GetCode() uint32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *OfpErrorMsg) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// OFPET_EXPERIMENTER: Error message (datapath -> controller).
type OfpErrorExperimenterMsg struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`                      // OFPET_EXPERIMENTER.
	ExpType       uint32                 `protobuf:"varint,2,opt,name=exp_type,json=expType,proto3" json:"exp_type,omitempty"` // Experimenter defined.
	Experimenter  uint32                 `protobuf:"varint,3,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	Data          []byte                 `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpErrorExperimenterMsg) Reset() {
	*x = OfpErrorExperimenterMsg{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpErrorExperimenterMsg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpErrorExperimenterMsg) ProtoMessage() {}

func (x *OfpErrorExperimenterMsg) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpErrorExperimenterMsg.ProtoReflect.Descriptor instead.
func (*OfpErrorExperimenterMsg) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{42}
}

func (x *OfpErrorExperimenterMsg) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *OfpErrorExperimenterMsg) GetExpType() uint32 {
	if x != nil {
		return x.ExpType
	}
	return 0
}

func (x *OfpErrorExperimenterMsg) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

func (x *OfpErrorExperimenterMsg) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

type OfpMultipartRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Type          OfpMultipartType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpMultipartType" json:"type,omitempty"` // One of the OFPMP_* constants.
	Flags         uint32           `protobuf:"varint,2,opt,name=flags,proto3" json:"flags,omitempty"`                                 // OFPMPF_REQ_* flags.
	Body          []byte           `protobuf:"bytes,3,opt,name=body,proto3" json:"body,omitempty"`                                    // Body of the request. 0 or more bytes.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMultipartRequest) Reset() {
	*x = OfpMultipartRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMultipartRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMultipartRequest) ProtoMessage() {}

func (x *OfpMultipartRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMultipartRequest.ProtoReflect.Descriptor instead.
func (*OfpMultipartRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{43}
}

func (x *OfpMultipartRequest) GetType() OfpMultipartType {
	if x != nil {
		return x.Type
	}
	return OfpMultipartType_OFPMP_DESC
}

func (x *OfpMultipartRequest) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *OfpMultipartRequest) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

type OfpMultipartReply struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Type          OfpMultipartType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpMultipartType" json:"type,omitempty"` // One of the OFPMP_* constants.
	Flags         uint32           `protobuf:"varint,2,opt,name=flags,proto3" json:"flags,omitempty"`                                 // OFPMPF_REPLY_* flags.
	Body          []byte           `protobuf:"bytes,3,opt,name=body,proto3" json:"body,omitempty"`                                    // Body of the reply. 0 or more bytes.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMultipartReply) Reset() {
	*x = OfpMultipartReply{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMultipartReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMultipartReply) ProtoMessage() {}

func (x *OfpMultipartReply) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMultipartReply.ProtoReflect.Descriptor instead.
func (*OfpMultipartReply) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{44}
}

func (x *OfpMultipartReply) GetType() OfpMultipartType {
	if x != nil {
		return x.Type
	}
	return OfpMultipartType_OFPMP_DESC
}

func (x *OfpMultipartReply) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *OfpMultipartReply) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

// Body of reply to OFPMP_DESC request.  Each entry is a NULL-terminated
// ASCII string.
type OfpDesc struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MfrDesc       string                 `protobuf:"bytes,1,opt,name=mfr_desc,json=mfrDesc,proto3" json:"mfr_desc,omitempty"`       // Manufacturer description.
	HwDesc        string                 `protobuf:"bytes,2,opt,name=hw_desc,json=hwDesc,proto3" json:"hw_desc,omitempty"`          // Hardware description.
	SwDesc        string                 `protobuf:"bytes,3,opt,name=sw_desc,json=swDesc,proto3" json:"sw_desc,omitempty"`          // Software description.
	SerialNum     string                 `protobuf:"bytes,4,opt,name=serial_num,json=serialNum,proto3" json:"serial_num,omitempty"` // Serial number.
	DpDesc        string                 `protobuf:"bytes,5,opt,name=dp_desc,json=dpDesc,proto3" json:"dp_desc,omitempty"`          // Human readable description of datapath.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpDesc) Reset() {
	*x = OfpDesc{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpDesc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpDesc) ProtoMessage() {}

func (x *OfpDesc) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpDesc.ProtoReflect.Descriptor instead.
func (*OfpDesc) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{45}
}

func (x *OfpDesc) GetMfrDesc() string {
	if x != nil {
		return x.MfrDesc
	}
	return ""
}

func (x *OfpDesc) GetHwDesc() string {
	if x != nil {
		return x.HwDesc
	}
	return ""
}

func (x *OfpDesc) GetSwDesc() string {
	if x != nil {
		return x.SwDesc
	}
	return ""
}

func (x *OfpDesc) GetSerialNum() string {
	if x != nil {
		return x.SerialNum
	}
	return ""
}

func (x *OfpDesc) GetDpDesc() string {
	if x != nil {
		return x.DpDesc
	}
	return ""
}

// Body for ofp_multipart_request of type OFPMP_FLOW.
type OfpFlowStatsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TableId       uint32                 `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	OutPort       uint32                 `protobuf:"varint,2,opt,name=out_port,json=outPort,proto3" json:"out_port,omitempty"`
	OutGroup      uint32                 `protobuf:"varint,3,opt,name=out_group,json=outGroup,proto3" json:"out_group,omitempty"`
	Cookie        uint64                 `protobuf:"varint,4,opt,name=cookie,proto3" json:"cookie,omitempty"`
	CookieMask    uint64                 `protobuf:"varint,5,opt,name=cookie_mask,json=cookieMask,proto3" json:"cookie_mask,omitempty"`
	Match         *OfpMatch              `protobuf:"bytes,6,opt,name=match,proto3" json:"match,omitempty"` // Fields to match. Variable size.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpFlowStatsRequest) Reset() {
	*x = OfpFlowStatsRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpFlowStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpFlowStatsRequest) ProtoMessage() {}

func (x *OfpFlowStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpFlowStatsRequest.ProtoReflect.Descriptor instead.
func (*OfpFlowStatsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{46}
}

func (x *OfpFlowStatsRequest) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpFlowStatsRequest) GetOutPort() uint32 {
	if x != nil {
		return x.OutPort
	}
	return 0
}

func (x *OfpFlowStatsRequest) GetOutGroup() uint32 {
	if x != nil {
		return x.OutGroup
	}
	return 0
}

func (x *OfpFlowStatsRequest) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *OfpFlowStatsRequest) GetCookieMask() uint64 {
	if x != nil {
		return x.CookieMask
	}
	return 0
}

func (x *OfpFlowStatsRequest) GetMatch() *OfpMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

// Body of reply to OFPMP_FLOW request.
type OfpFlowStats struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            uint64                 `protobuf:"varint,14,opt,name=id,proto3" json:"id,omitempty"`                                     // Unique ID of flow within device.
	TableId       uint32                 `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`             // ID of table flow came from.
	DurationSec   uint32                 `protobuf:"varint,2,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"` // Time flow has been alive in seconds.
	DurationNsec  uint32                 `protobuf:"varint,3,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	Priority      uint32                 `protobuf:"varint,4,opt,name=priority,proto3" json:"priority,omitempty"`                          // Priority of the entry.
	IdleTimeout   uint32                 `protobuf:"varint,5,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"` // Number of seconds idle before expiration.
	HardTimeout   uint32                 `protobuf:"varint,6,opt,name=hard_timeout,json=hardTimeout,proto3" json:"hard_timeout,omitempty"` // Number of seconds before expiration.
	Flags         uint32                 `protobuf:"varint,7,opt,name=flags,proto3" json:"flags,omitempty"`                                // Bitmap of OFPFF_* flags.
	Cookie        uint64                 `protobuf:"varint,8,opt,name=cookie,proto3" json:"cookie,omitempty"`                              // Opaque controller-issued identifier.
	PacketCount   uint64                 `protobuf:"varint,9,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"` // Number of packets in flow.
	ByteCount     uint64                 `protobuf:"varint,10,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`      // Number of bytes in flow.
	Match         *OfpMatch              `protobuf:"bytes,12,opt,name=match,proto3" json:"match,omitempty"`                                // Description of fields. Variable size.
	Instructions  []*OfpInstruction      `protobuf:"bytes,13,rep,name=instructions,proto3" json:"instructions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpFlowStats) Reset() {
	*x = OfpFlowStats{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpFlowStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpFlowStats) ProtoMessage() {}

func (x *OfpFlowStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpFlowStats.ProtoReflect.Descriptor instead.
func (*OfpFlowStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{47}
}

func (x *OfpFlowStats) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *OfpFlowStats) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpFlowStats) GetDurationSec() uint32 {
	if x != nil {
		return x.DurationSec
	}
	return 0
}

func (x *OfpFlowStats) GetDurationNsec() uint32 {
	if x != nil {
		return x.DurationNsec
	}
	return 0
}

func (x *OfpFlowStats) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *OfpFlowStats) GetIdleTimeout() uint32 {
	if x != nil {
		return x.IdleTimeout
	}
	return 0
}

func (x *OfpFlowStats) GetHardTimeout() uint32 {
	if x != nil {
		return x.HardTimeout
	}
	return 0
}

func (x *OfpFlowStats) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *OfpFlowStats) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *OfpFlowStats) GetPacketCount() uint64 {
	if x != nil {
		return x.PacketCount
	}
	return 0
}

func (x *OfpFlowStats) GetByteCount() uint64 {
	if x != nil {
		return x.ByteCount
	}
	return 0
}

func (x *OfpFlowStats) GetMatch() *OfpMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *OfpFlowStats) GetInstructions() []*OfpInstruction {
	if x != nil {
		return x.Instructions
	}
	return nil
}

// Body for ofp_multipart_request of type OFPMP_AGGREGATE.
type OfpAggregateStatsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TableId       uint32                 `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	OutPort       uint32                 `protobuf:"varint,2,opt,name=out_port,json=outPort,proto3" json:"out_port,omitempty"`
	OutGroup      uint32                 `protobuf:"varint,3,opt,name=out_group,json=outGroup,proto3" json:"out_group,omitempty"`
	Cookie        uint64                 `protobuf:"varint,4,opt,name=cookie,proto3" json:"cookie,omitempty"`
	CookieMask    uint64                 `protobuf:"varint,5,opt,name=cookie_mask,json=cookieMask,proto3" json:"cookie_mask,omitempty"`
	Match         *OfpMatch              `protobuf:"bytes,6,opt,name=match,proto3" json:"match,omitempty"` // Fields to match. Variable size.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpAggregateStatsRequest) Reset() {
	*x = OfpAggregateStatsRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpAggregateStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpAggregateStatsRequest) ProtoMessage() {}

func (x *OfpAggregateStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpAggregateStatsRequest.ProtoReflect.Descriptor instead.
func (*OfpAggregateStatsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{48}
}

func (x *OfpAggregateStatsRequest) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpAggregateStatsRequest) GetOutPort() uint32 {
	if x != nil {
		return x.OutPort
	}
	return 0
}

func (x *OfpAggregateStatsRequest) GetOutGroup() uint32 {
	if x != nil {
		return x.OutGroup
	}
	return 0
}

func (x *OfpAggregateStatsRequest) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *OfpAggregateStatsRequest) GetCookieMask() uint64 {
	if x != nil {
		return x.CookieMask
	}
	return 0
}

func (x *OfpAggregateStatsRequest) GetMatch() *OfpMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

// Body of reply to OFPMP_AGGREGATE request.
type OfpAggregateStatsReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PacketCount   uint64                 `protobuf:"varint,1,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"` // Number of packets in flows.
	ByteCount     uint64                 `protobuf:"varint,2,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`       // Number of bytes in flows.
	FlowCount     uint32                 `protobuf:"varint,3,opt,name=flow_count,json=flowCount,proto3" json:"flow_count,omitempty"`       // Number of flows.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpAggregateStatsReply) Reset() {
	*x = OfpAggregateStatsReply{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpAggregateStatsReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpAggregateStatsReply) ProtoMessage() {}

func (x *OfpAggregateStatsReply) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpAggregateStatsReply.ProtoReflect.Descriptor instead.
func (*OfpAggregateStatsReply) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{49}
}

func (x *OfpAggregateStatsReply) GetPacketCount() uint64 {
	if x != nil {
		return x.PacketCount
	}
	return 0
}

func (x *OfpAggregateStatsReply) GetByteCount() uint64 {
	if x != nil {
		return x.ByteCount
	}
	return 0
}

func (x *OfpAggregateStatsReply) GetFlowCount() uint32 {
	if x != nil {
		return x.FlowCount
	}
	return 0
}

// Common header for all Table Feature Properties
type OfpTableFeatureProperty struct {
	state protoimpl.MessageState  `protogen:"open.v1"`
	Type  OfpTableFeaturePropType `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpTableFeaturePropType" json:"type,omitempty"` // One of OFPTFPT_*.
	// Types that are valid to be assigned to Value:
	//
	//	*OfpTableFeatureProperty_Instructions
	//	*OfpTableFeatureProperty_NextTables
	//	*OfpTableFeatureProperty_Actions
	//	*OfpTableFeatureProperty_Oxm
	//	*OfpTableFeatureProperty_Experimenter
	Value         isOfpTableFeatureProperty_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpTableFeatureProperty) Reset() {
	*x = OfpTableFeatureProperty{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableFeatureProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableFeatureProperty) ProtoMessage() {}

func (x *OfpTableFeatureProperty) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableFeatureProperty.ProtoReflect.Descriptor instead.
func (*OfpTableFeatureProperty) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{50}
}

func (x *OfpTableFeatureProperty) GetType() OfpTableFeaturePropType {
	if x != nil {
		return x.Type
	}
	return OfpTableFeaturePropType_OFPTFPT_INSTRUCTIONS
}

func (x *OfpTableFeatureProperty) GetValue() isOfpTableFeatureProperty_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *OfpTableFeatureProperty) GetInstructions() *OfpTableFeaturePropInstructions {
	if x != nil {
		if x, ok := x.Value.(*OfpTableFeatureProperty_Instructions); ok {
			return x.Instructions
		}
	}
	return nil
}

func (x *OfpTableFeatureProperty) GetNextTables() *OfpTableFeaturePropNextTables {
	if x != nil {
		if x, ok := x.Value.(*OfpTableFeatureProperty_NextTables); ok {
			return x.NextTables
		}
	}
	return nil
}

func (x *OfpTableFeatureProperty) GetActions() *OfpTableFeaturePropActions {
	if x != nil {
		if x, ok := x.Value.(*OfpTableFeatureProperty_Actions); ok {
			return x.Actions
		}
	}
	return nil
}

func (x *OfpTableFeatureProperty) GetOxm() *OfpTableFeaturePropOxm {
	if x != nil {
		if x, ok := x.Value.(*OfpTableFeatureProperty_Oxm); ok {
			return x.Oxm
		}
	}
	return nil
}

func (x *OfpTableFeatureProperty) GetExperimenter() *OfpTableFeaturePropExperimenter {
	if x != nil {
		if x, ok := x.Value.(*OfpTableFeatureProperty_Experimenter); ok {
			return x.Experimenter
		}
	}
	return nil
}

type isOfpTableFeatureProperty_Value interface {
	isOfpTableFeatureProperty_Value()
}

type OfpTableFeatureProperty_Instructions struct {
	Instructions *OfpTableFeaturePropInstructions `protobuf:"bytes,2,opt,name=instructions,proto3,oneof"`
}

type OfpTableFeatureProperty_NextTables struct {
	NextTables *OfpTableFeaturePropNextTables `protobuf:"bytes,3,opt,name=next_tables,json=nextTables,proto3,oneof"`
}

type OfpTableFeatureProperty_Actions struct {
	Actions *OfpTableFeaturePropActions `protobuf:"bytes,4,opt,name=actions,proto3,oneof"`
}

type OfpTableFeatureProperty_Oxm struct {
	Oxm *OfpTableFeaturePropOxm `protobuf:"bytes,5,opt,name=oxm,proto3,oneof"`
}

type OfpTableFeatureProperty_Experimenter struct {
	Experimenter *OfpTableFeaturePropExperimenter `protobuf:"bytes,6,opt,name=experimenter,proto3,oneof"`
}

func (*OfpTableFeatureProperty_Instructions) isOfpTableFeatureProperty_Value() {}

func (*OfpTableFeatureProperty_NextTables) isOfpTableFeatureProperty_Value() {}

func (*OfpTableFeatureProperty_Actions) isOfpTableFeatureProperty_Value() {}

func (*OfpTableFeatureProperty_Oxm) isOfpTableFeatureProperty_Value() {}

func (*OfpTableFeatureProperty_Experimenter) isOfpTableFeatureProperty_Value() {}

// Instructions property
type OfpTableFeaturePropInstructions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of OFPTFPT_INSTRUCTIONS,
	// OFPTFPT_INSTRUCTIONS_MISS.
	Instructions  []*OfpInstruction `protobuf:"bytes,1,rep,name=instructions,proto3" json:"instructions,omitempty"` // List of instructions
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpTableFeaturePropInstructions) Reset() {
	*x = OfpTableFeaturePropInstructions{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableFeaturePropInstructions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableFeaturePropInstructions) ProtoMessage() {}

func (x *OfpTableFeaturePropInstructions) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableFeaturePropInstructions.ProtoReflect.Descriptor instead.
func (*OfpTableFeaturePropInstructions) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{51}
}

func (x *OfpTableFeaturePropInstructions) GetInstructions() []*OfpInstruction {
	if x != nil {
		return x.Instructions
	}
	return nil
}

// Next Tables property
type OfpTableFeaturePropNextTables struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of OFPTFPT_NEXT_TABLES,
	// OFPTFPT_NEXT_TABLES_MISS.
	NextTableIds  []uint32 `protobuf:"varint,1,rep,packed,name=next_table_ids,json=nextTableIds,proto3" json:"next_table_ids,omitempty"` // List of table ids.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpTableFeaturePropNextTables) Reset() {
	*x = OfpTableFeaturePropNextTables{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableFeaturePropNextTables) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableFeaturePropNextTables) ProtoMessage() {}

func (x *OfpTableFeaturePropNextTables) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableFeaturePropNextTables.ProtoReflect.Descriptor instead.
func (*OfpTableFeaturePropNextTables) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{52}
}

func (x *OfpTableFeaturePropNextTables) GetNextTableIds() []uint32 {
	if x != nil {
		return x.NextTableIds
	}
	return nil
}

// Actions property
type OfpTableFeaturePropActions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of OFPTFPT_WRITE_ACTIONS,
	// OFPTFPT_WRITE_ACTIONS_MISS,
	// OFPTFPT_APPLY_ACTIONS,
	// OFPTFPT_APPLY_ACTIONS_MISS.
	Actions       []*OfpAction `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"` // List of actions
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpTableFeaturePropActions) Reset() {
	*x = OfpTableFeaturePropActions{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableFeaturePropActions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableFeaturePropActions) ProtoMessage() {}

func (x *OfpTableFeaturePropActions) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableFeaturePropActions.ProtoReflect.Descriptor instead.
func (*OfpTableFeaturePropActions) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{53}
}

func (x *OfpTableFeaturePropActions) GetActions() []*OfpAction {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Match, Wildcard or Set-Field property
type OfpTableFeaturePropOxm struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// TODO is this a uint32???
	OxmIds        []uint32 `protobuf:"varint,3,rep,packed,name=oxm_ids,json=oxmIds,proto3" json:"oxm_ids,omitempty"` // Array of OXM headers
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpTableFeaturePropOxm) Reset() {
	*x = OfpTableFeaturePropOxm{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableFeaturePropOxm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableFeaturePropOxm) ProtoMessage() {}

func (x *OfpTableFeaturePropOxm) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableFeaturePropOxm.ProtoReflect.Descriptor instead.
func (*OfpTableFeaturePropOxm) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{54}
}

func (x *OfpTableFeaturePropOxm) GetOxmIds() []uint32 {
	if x != nil {
		return x.OxmIds
	}
	return nil
}

// Experimenter table feature property
type OfpTableFeaturePropExperimenter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One of OFPTFPT_EXPERIMENTER,
	// OFPTFPT_EXPERIMENTER_MISS.
	Experimenter     uint32   `protobuf:"varint,2,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	ExpType          uint32   `protobuf:"varint,3,opt,name=exp_type,json=expType,proto3" json:"exp_type,omitempty"` // Experimenter defined.
	ExperimenterData []uint32 `protobuf:"varint,4,rep,packed,name=experimenter_data,json=experimenterData,proto3" json:"experimenter_data,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *OfpTableFeaturePropExperimenter) Reset() {
	*x = OfpTableFeaturePropExperimenter{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableFeaturePropExperimenter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableFeaturePropExperimenter) ProtoMessage() {}

func (x *OfpTableFeaturePropExperimenter) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableFeaturePropExperimenter.ProtoReflect.Descriptor instead.
func (*OfpTableFeaturePropExperimenter) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{55}
}

func (x *OfpTableFeaturePropExperimenter) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

func (x *OfpTableFeaturePropExperimenter) GetExpType() uint32 {
	if x != nil {
		return x.ExpType
	}
	return 0
}

func (x *OfpTableFeaturePropExperimenter) GetExperimenterData() []uint32 {
	if x != nil {
		return x.ExperimenterData
	}
	return nil
}

// Body for ofp_multipart_request of type OFPMP_TABLE_FEATURES./
// Body of reply to OFPMP_TABLE_FEATURES request.
type OfpTableFeatures struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TableId       uint32                 `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	Name          string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	MetadataMatch uint64                 `protobuf:"varint,3,opt,name=metadata_match,json=metadataMatch,proto3" json:"metadata_match,omitempty"` // Bits of metadata table can match.
	MetadataWrite uint64                 `protobuf:"varint,4,opt,name=metadata_write,json=metadataWrite,proto3" json:"metadata_write,omitempty"` // Bits of metadata table can write.
	Config        uint32                 `protobuf:"varint,5,opt,name=config,proto3" json:"config,omitempty"`                                    // Bitmap of OFPTC_* values
	MaxEntries    uint32                 `protobuf:"varint,6,opt,name=max_entries,json=maxEntries,proto3" json:"max_entries,omitempty"`          // Max number of entries supported.
	// Table Feature Property list
	Properties    []*OfpTableFeatureProperty `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpTableFeatures) Reset() {
	*x = OfpTableFeatures{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableFeatures) ProtoMessage() {}

func (x *OfpTableFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableFeatures.ProtoReflect.Descriptor instead.
func (*OfpTableFeatures) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{56}
}

func (x *OfpTableFeatures) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpTableFeatures) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OfpTableFeatures) GetMetadataMatch() uint64 {
	if x != nil {
		return x.MetadataMatch
	}
	return 0
}

func (x *OfpTableFeatures) GetMetadataWrite() uint64 {
	if x != nil {
		return x.MetadataWrite
	}
	return 0
}

func (x *OfpTableFeatures) GetConfig() uint32 {
	if x != nil {
		return x.Config
	}
	return 0
}

func (x *OfpTableFeatures) GetMaxEntries() uint32 {
	if x != nil {
		return x.MaxEntries
	}
	return 0
}

func (x *OfpTableFeatures) GetProperties() []*OfpTableFeatureProperty {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Body of reply to OFPMP_TABLE request.
type OfpTableStats struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TableId       uint32                 `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	ActiveCount   uint32                 `protobuf:"varint,2,opt,name=active_count,json=activeCount,proto3" json:"active_count,omitempty"`    // Number of active entries.
	LookupCount   uint64                 `protobuf:"varint,3,opt,name=lookup_count,json=lookupCount,proto3" json:"lookup_count,omitempty"`    // Number of packets looked up in table.
	MatchedCount  uint64                 `protobuf:"varint,4,opt,name=matched_count,json=matchedCount,proto3" json:"matched_count,omitempty"` // Number of packets that hit table.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpTableStats) Reset() {
	*x = OfpTableStats{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpTableStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpTableStats) ProtoMessage() {}

func (x *OfpTableStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpTableStats.ProtoReflect.Descriptor instead.
func (*OfpTableStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{57}
}

func (x *OfpTableStats) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *OfpTableStats) GetActiveCount() uint32 {
	if x != nil {
		return x.ActiveCount
	}
	return 0
}

func (x *OfpTableStats) GetLookupCount() uint64 {
	if x != nil {
		return x.LookupCount
	}
	return 0
}

func (x *OfpTableStats) GetMatchedCount() uint64 {
	if x != nil {
		return x.MatchedCount
	}
	return 0
}

// Body for ofp_multipart_request of type OFPMP_PORT.
type OfpPortStatsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PortNo        uint32                 `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpPortStatsRequest) Reset() {
	*x = OfpPortStatsRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpPortStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpPortStatsRequest) ProtoMessage() {}

func (x *OfpPortStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpPortStatsRequest.ProtoReflect.Descriptor instead.
func (*OfpPortStatsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{58}
}

func (x *OfpPortStatsRequest) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

// Body of reply to OFPMP_PORT request. If a counter is unsupported, set
// the field to all ones.
type OfpPortStats struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PortNo        uint32                 `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	RxPackets     uint64                 `protobuf:"varint,2,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"` // Number of received packets.
	TxPackets     uint64                 `protobuf:"varint,3,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"` // Number of transmitted packets.
	RxBytes       uint64                 `protobuf:"varint,4,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`       // Number of received bytes.
	TxBytes       uint64                 `protobuf:"varint,5,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`       // Number of transmitted bytes.
	RxDropped     uint64                 `protobuf:"varint,6,opt,name=rx_dropped,json=rxDropped,proto3" json:"rx_dropped,omitempty"` // Number of packets dropped by RX.
	TxDropped     uint64                 `protobuf:"varint,7,opt,name=tx_dropped,json=txDropped,proto3" json:"tx_dropped,omitempty"` // Number of packets dropped by TX.
	RxErrors      uint64                 `protobuf:"varint,8,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	TxErrors      uint64                 `protobuf:"varint,9,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	RxFrameErr    uint64                 `protobuf:"varint,10,opt,name=rx_frame_err,json=rxFrameErr,proto3" json:"rx_frame_err,omitempty"`  // Number of frame alignment errors.
	RxOverErr     uint64                 `protobuf:"varint,11,opt,name=rx_over_err,json=rxOverErr,proto3" json:"rx_over_err,omitempty"`     // Number of packets with RX overrun.
	RxCrcErr      uint64                 `protobuf:"varint,12,opt,name=rx_crc_err,json=rxCrcErr,proto3" json:"rx_crc_err,omitempty"`        // Number of CRC errors.
	Collisions    uint64                 `protobuf:"varint,13,opt,name=collisions,proto3" json:"collisions,omitempty"`                      // Number of collisions.
	DurationSec   uint32                 `protobuf:"varint,14,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"` // Time port has been alive in seconds.
	DurationNsec  uint32                 `protobuf:"varint,15,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpPortStats) Reset() {
	*x = OfpPortStats{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpPortStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpPortStats) ProtoMessage() {}

func (x *OfpPortStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpPortStats.ProtoReflect.Descriptor instead.
func (*OfpPortStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{59}
}

func (x *OfpPortStats) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *OfpPortStats) GetRxPackets() uint64 {
	if x != nil {
		return x.RxPackets
	}
	return 0
}

func (x *OfpPortStats) GetTxPackets() uint64 {
	if x != nil {
		return x.TxPackets
	}
	return 0
}

func (x *OfpPortStats) GetRxBytes() uint64 {
	if x != nil {
		return x.RxBytes
	}
	return 0
}

func (x *OfpPortStats) GetTxBytes() uint64 {
	if x != nil {
		return x.TxBytes
	}
	return 0
}

func (x *OfpPortStats) GetRxDropped() uint64 {
	if x != nil {
		return x.RxDropped
	}
	return 0
}

func (x *OfpPortStats) GetTxDropped() uint64 {
	if x != nil {
		return x.TxDropped
	}
	return 0
}

func (x *OfpPortStats) GetRxErrors() uint64 {
	if x != nil {
		return x.RxErrors
	}
	return 0
}

func (x *OfpPortStats) GetTxErrors() uint64 {
	if x != nil {
		return x.TxErrors
	}
	return 0
}

func (x *OfpPortStats) GetRxFrameErr() uint64 {
	if x != nil {
		return x.RxFrameErr
	}
	return 0
}

func (x *OfpPortStats) GetRxOverErr() uint64 {
	if x != nil {
		return x.RxOverErr
	}
	return 0
}

func (x *OfpPortStats) GetRxCrcErr() uint64 {
	if x != nil {
		return x.RxCrcErr
	}
	return 0
}

func (x *OfpPortStats) GetCollisions() uint64 {
	if x != nil {
		return x.Collisions
	}
	return 0
}

func (x *OfpPortStats) GetDurationSec() uint32 {
	if x != nil {
		return x.DurationSec
	}
	return 0
}

func (x *OfpPortStats) GetDurationNsec() uint32 {
	if x != nil {
		return x.DurationNsec
	}
	return 0
}

// Body of OFPMP_GROUP request.
type OfpGroupStatsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupId       uint32                 `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"` // All groups if OFPG_ALL.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpGroupStatsRequest) Reset() {
	*x = OfpGroupStatsRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpGroupStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpGroupStatsRequest) ProtoMessage() {}

func (x *OfpGroupStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpGroupStatsRequest.ProtoReflect.Descriptor instead.
func (*OfpGroupStatsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{60}
}

func (x *OfpGroupStatsRequest) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

// Used in group stats replies.
type OfpBucketCounter struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PacketCount   uint64                 `protobuf:"varint,1,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"` // Number of packets processed by bucket.
	ByteCount     uint64                 `protobuf:"varint,2,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`       // Number of bytes processed by bucket.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpBucketCounter) Reset() {
	*x = OfpBucketCounter{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpBucketCounter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpBucketCounter) ProtoMessage() {}

func (x *OfpBucketCounter) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpBucketCounter.ProtoReflect.Descriptor instead.
func (*OfpBucketCounter) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{61}
}

func (x *OfpBucketCounter) GetPacketCount() uint64 {
	if x != nil {
		return x.PacketCount
	}
	return 0
}

func (x *OfpBucketCounter) GetByteCount() uint64 {
	if x != nil {
		return x.ByteCount
	}
	return 0
}

// Body of reply to OFPMP_GROUP request.
type OfpGroupStats struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupId       uint32                 `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"` // Group identifier.
	RefCount      uint32                 `protobuf:"varint,2,opt,name=ref_count,json=refCount,proto3" json:"ref_count,omitempty"`
	PacketCount   uint64                 `protobuf:"varint,3,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"` // Number of packets processed by group.
	ByteCount     uint64                 `protobuf:"varint,4,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`       // Number of bytes processed by group.
	DurationSec   uint32                 `protobuf:"varint,5,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"` // Time group has been alive in seconds.
	DurationNsec  uint32                 `protobuf:"varint,6,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	BucketStats   []*OfpBucketCounter    `protobuf:"bytes,7,rep,name=bucket_stats,json=bucketStats,proto3" json:"bucket_stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpGroupStats) Reset() {
	*x = OfpGroupStats{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpGroupStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpGroupStats) ProtoMessage() {}

func (x *OfpGroupStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpGroupStats.ProtoReflect.Descriptor instead.
func (*OfpGroupStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{62}
}

func (x *OfpGroupStats) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

func (x *OfpGroupStats) GetRefCount() uint32 {
	if x != nil {
		return x.RefCount
	}
	return 0
}

func (x *OfpGroupStats) GetPacketCount() uint64 {
	if x != nil {
		return x.PacketCount
	}
	return 0
}

func (x *OfpGroupStats) GetByteCount() uint64 {
	if x != nil {
		return x.ByteCount
	}
	return 0
}

func (x *OfpGroupStats) GetDurationSec() uint32 {
	if x != nil {
		return x.DurationSec
	}
	return 0
}

func (x *OfpGroupStats) GetDurationNsec() uint32 {
	if x != nil {
		return x.DurationNsec
	}
	return 0
}

func (x *OfpGroupStats) GetBucketStats() []*OfpBucketCounter {
	if x != nil {
		return x.BucketStats
	}
	return nil
}

// Body of reply to OFPMP_GROUP_DESC request.
type OfpGroupDesc struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          OfpGroupType           `protobuf:"varint,1,opt,name=type,proto3,enum=openflow_13.OfpGroupType" json:"type,omitempty"` // One of OFPGT_*.
	GroupId       uint32                 `protobuf:"varint,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`          // Group identifier.
	Buckets       []*OfpBucket           `protobuf:"bytes,3,rep,name=buckets,proto3" json:"buckets,omitempty"`                          // List of buckets - 0 or more.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpGroupDesc) Reset() {
	*x = OfpGroupDesc{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpGroupDesc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpGroupDesc) ProtoMessage() {}

func (x *OfpGroupDesc) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpGroupDesc.ProtoReflect.Descriptor instead.
func (*OfpGroupDesc) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{63}
}

func (x *OfpGroupDesc) GetType() OfpGroupType {
	if x != nil {
		return x.Type
	}
	return OfpGroupType_OFPGT_ALL
}

func (x *OfpGroupDesc) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

func (x *OfpGroupDesc) GetBuckets() []*OfpBucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

type OfpGroupEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Desc          *OfpGroupDesc          `protobuf:"bytes,1,opt,name=desc,proto3" json:"desc,omitempty"`
	Stats         *OfpGroupStats         `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpGroupEntry) Reset() {
	*x = OfpGroupEntry{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpGroupEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpGroupEntry) ProtoMessage() {}

func (x *OfpGroupEntry) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpGroupEntry.ProtoReflect.Descriptor instead.
func (*OfpGroupEntry) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{64}
}

func (x *OfpGroupEntry) GetDesc() *OfpGroupDesc {
	if x != nil {
		return x.Desc
	}
	return nil
}

func (x *OfpGroupEntry) GetStats() *OfpGroupStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// Body of reply to OFPMP_GROUP_FEATURES request. Group features.
type OfpGroupFeatures struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Types         uint32                 `protobuf:"varint,1,opt,name=types,proto3" json:"types,omitempty"`                                 // Bitmap of (1 << OFPGT_*) values supported.
	Capabilities  uint32                 `protobuf:"varint,2,opt,name=capabilities,proto3" json:"capabilities,omitempty"`                   // Bitmap of OFPGFC_* capability supported.
	MaxGroups     []uint32               `protobuf:"varint,3,rep,packed,name=max_groups,json=maxGroups,proto3" json:"max_groups,omitempty"` // Maximum number of groups for each type.
	Actions       []uint32               `protobuf:"varint,4,rep,packed,name=actions,proto3" json:"actions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpGroupFeatures) Reset() {
	*x = OfpGroupFeatures{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpGroupFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpGroupFeatures) ProtoMessage() {}

func (x *OfpGroupFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpGroupFeatures.ProtoReflect.Descriptor instead.
func (*OfpGroupFeatures) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{65}
}

func (x *OfpGroupFeatures) GetTypes() uint32 {
	if x != nil {
		return x.Types
	}
	return 0
}

func (x *OfpGroupFeatures) GetCapabilities() uint32 {
	if x != nil {
		return x.Capabilities
	}
	return 0
}

func (x *OfpGroupFeatures) GetMaxGroups() []uint32 {
	if x != nil {
		return x.MaxGroups
	}
	return nil
}

func (x *OfpGroupFeatures) GetActions() []uint32 {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Body of OFPMP_METER and OFPMP_METER_CONFIG requests.
type OfpMeterMultipartRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MeterId       uint32                 `protobuf:"varint,1,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"` // Meter instance, or OFPM_ALL.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterMultipartRequest) Reset() {
	*x = OfpMeterMultipartRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterMultipartRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterMultipartRequest) ProtoMessage() {}

func (x *OfpMeterMultipartRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterMultipartRequest.ProtoReflect.Descriptor instead.
func (*OfpMeterMultipartRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{66}
}

func (x *OfpMeterMultipartRequest) GetMeterId() uint32 {
	if x != nil {
		return x.MeterId
	}
	return 0
}

// Statistics for each meter band
type OfpMeterBandStats struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	PacketBandCount uint64                 `protobuf:"varint,1,opt,name=packet_band_count,json=packetBandCount,proto3" json:"packet_band_count,omitempty"` // Number of packets in band.
	ByteBandCount   uint64                 `protobuf:"varint,2,opt,name=byte_band_count,json=byteBandCount,proto3" json:"byte_band_count,omitempty"`       // Number of bytes in band.
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *OfpMeterBandStats) Reset() {
	*x = OfpMeterBandStats{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterBandStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterBandStats) ProtoMessage() {}

func (x *OfpMeterBandStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterBandStats.ProtoReflect.Descriptor instead.
func (*OfpMeterBandStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{67}
}

func (x *OfpMeterBandStats) GetPacketBandCount() uint64 {
	if x != nil {
		return x.PacketBandCount
	}
	return 0
}

func (x *OfpMeterBandStats) GetByteBandCount() uint64 {
	if x != nil {
		return x.ByteBandCount
	}
	return 0
}

// Body of reply to OFPMP_METER request. Meter statistics.
type OfpMeterStats struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MeterId       uint32                 `protobuf:"varint,1,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"`                     // Meter instance.
	FlowCount     uint32                 `protobuf:"varint,2,opt,name=flow_count,json=flowCount,proto3" json:"flow_count,omitempty"`               // Number of flows bound to meter.
	PacketInCount uint64                 `protobuf:"varint,3,opt,name=packet_in_count,json=packetInCount,proto3" json:"packet_in_count,omitempty"` // Number of packets in input.
	ByteInCount   uint64                 `protobuf:"varint,4,opt,name=byte_in_count,json=byteInCount,proto3" json:"byte_in_count,omitempty"`       // Number of bytes in input.
	DurationSec   uint32                 `protobuf:"varint,5,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"`         // Time meter has been alive in seconds.
	DurationNsec  uint32                 `protobuf:"varint,6,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	BandStats     []*OfpMeterBandStats   `protobuf:"bytes,7,rep,name=band_stats,json=bandStats,proto3" json:"band_stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterStats) Reset() {
	*x = OfpMeterStats{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterStats) ProtoMessage() {}

func (x *OfpMeterStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterStats.ProtoReflect.Descriptor instead.
func (*OfpMeterStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{68}
}

func (x *OfpMeterStats) GetMeterId() uint32 {
	if x != nil {
		return x.MeterId
	}
	return 0
}

func (x *OfpMeterStats) GetFlowCount() uint32 {
	if x != nil {
		return x.FlowCount
	}
	return 0
}

func (x *OfpMeterStats) GetPacketInCount() uint64 {
	if x != nil {
		return x.PacketInCount
	}
	return 0
}

func (x *OfpMeterStats) GetByteInCount() uint64 {
	if x != nil {
		return x.ByteInCount
	}
	return 0
}

func (x *OfpMeterStats) GetDurationSec() uint32 {
	if x != nil {
		return x.DurationSec
	}
	return 0
}

func (x *OfpMeterStats) GetDurationNsec() uint32 {
	if x != nil {
		return x.DurationNsec
	}
	return 0
}

func (x *OfpMeterStats) GetBandStats() []*OfpMeterBandStats {
	if x != nil {
		return x.BandStats
	}
	return nil
}

// Body of reply to OFPMP_METER_CONFIG request. Meter configuration.
type OfpMeterConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Flags         uint32                 `protobuf:"varint,1,opt,name=flags,proto3" json:"flags,omitempty"`                    // All OFPMF_* that apply.
	MeterId       uint32                 `protobuf:"varint,2,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"` // Meter instance.
	Bands         []*OfpMeterBandHeader  `protobuf:"bytes,3,rep,name=bands,proto3" json:"bands,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterConfig) Reset() {
	*x = OfpMeterConfig{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterConfig) ProtoMessage() {}

func (x *OfpMeterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterConfig.ProtoReflect.Descriptor instead.
func (*OfpMeterConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{69}
}

func (x *OfpMeterConfig) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *OfpMeterConfig) GetMeterId() uint32 {
	if x != nil {
		return x.MeterId
	}
	return 0
}

func (x *OfpMeterConfig) GetBands() []*OfpMeterBandHeader {
	if x != nil {
		return x.Bands
	}
	return nil
}

// Body of reply to OFPMP_METER_FEATURES request. Meter features.
type OfpMeterFeatures struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MaxMeter      uint32                 `protobuf:"varint,1,opt,name=max_meter,json=maxMeter,proto3" json:"max_meter,omitempty"`    // Maximum number of meters.
	BandTypes     uint32                 `protobuf:"varint,2,opt,name=band_types,json=bandTypes,proto3" json:"band_types,omitempty"` // Bitmaps of (1 << OFPMBT_*) values supported.
	Capabilities  uint32                 `protobuf:"varint,3,opt,name=capabilities,proto3" json:"capabilities,omitempty"`            // Bitmaps of "ofp_meter_flags".
	MaxBands      uint32                 `protobuf:"varint,4,opt,name=max_bands,json=maxBands,proto3" json:"max_bands,omitempty"`    // Maximum bands per meters
	MaxColor      uint32                 `protobuf:"varint,5,opt,name=max_color,json=maxColor,proto3" json:"max_color,omitempty"`    // Maximum color value
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterFeatures) Reset() {
	*x = OfpMeterFeatures{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterFeatures) ProtoMessage() {}

func (x *OfpMeterFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterFeatures.ProtoReflect.Descriptor instead.
func (*OfpMeterFeatures) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{70}
}

func (x *OfpMeterFeatures) GetMaxMeter() uint32 {
	if x != nil {
		return x.MaxMeter
	}
	return 0
}

func (x *OfpMeterFeatures) GetBandTypes() uint32 {
	if x != nil {
		return x.BandTypes
	}
	return 0
}

func (x *OfpMeterFeatures) GetCapabilities() uint32 {
	if x != nil {
		return x.Capabilities
	}
	return 0
}

func (x *OfpMeterFeatures) GetMaxBands() uint32 {
	if x != nil {
		return x.MaxBands
	}
	return 0
}

func (x *OfpMeterFeatures) GetMaxColor() uint32 {
	if x != nil {
		return x.MaxColor
	}
	return 0
}

type OfpMeterEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Config        *OfpMeterConfig        `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	Stats         *OfpMeterStats         `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpMeterEntry) Reset() {
	*x = OfpMeterEntry{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpMeterEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpMeterEntry) ProtoMessage() {}

func (x *OfpMeterEntry) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpMeterEntry.ProtoReflect.Descriptor instead.
func (*OfpMeterEntry) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{71}
}

func (x *OfpMeterEntry) GetConfig() *OfpMeterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *OfpMeterEntry) GetStats() *OfpMeterStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// Body for ofp_multipart_request/reply of type OFPMP_EXPERIMENTER.
type OfpExperimenterMultipartHeader struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Experimenter  uint32                 `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	ExpType       uint32                 `protobuf:"varint,2,opt,name=exp_type,json=expType,proto3" json:"exp_type,omitempty"` // Experimenter defined.
	Data          []byte                 `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`                       // Experimenter-defined arbitrary additional data.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpExperimenterMultipartHeader) Reset() {
	*x = OfpExperimenterMultipartHeader{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpExperimenterMultipartHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpExperimenterMultipartHeader) ProtoMessage() {}

func (x *OfpExperimenterMultipartHeader) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpExperimenterMultipartHeader.ProtoReflect.Descriptor instead.
func (*OfpExperimenterMultipartHeader) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{72}
}

func (x *OfpExperimenterMultipartHeader) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

func (x *OfpExperimenterMultipartHeader) GetExpType() uint32 {
	if x != nil {
		return x.ExpType
	}
	return 0
}

func (x *OfpExperimenterMultipartHeader) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Experimenter extension.
type OfpExperimenterHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;  /* Type OFPT_EXPERIMENTER. */
	Experimenter  uint32 `protobuf:"varint,1,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	ExpType       uint32 `protobuf:"varint,2,opt,name=exp_type,json=expType,proto3" json:"exp_type,omitempty"` // Experimenter defined.
	Data          []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`                       // Experimenter-defined arbitrary additional data.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpExperimenterHeader) Reset() {
	*x = OfpExperimenterHeader{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpExperimenterHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpExperimenterHeader) ProtoMessage() {}

func (x *OfpExperimenterHeader) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpExperimenterHeader.ProtoReflect.Descriptor instead.
func (*OfpExperimenterHeader) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{73}
}

func (x *OfpExperimenterHeader) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

func (x *OfpExperimenterHeader) GetExpType() uint32 {
	if x != nil {
		return x.ExpType
	}
	return 0
}

func (x *OfpExperimenterHeader) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Common description for a queue.
type OfpQueuePropHeader struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Property      uint32                 `protobuf:"varint,1,opt,name=property,proto3" json:"property,omitempty"` // One of OFPQT_.
	Len           uint32                 `protobuf:"varint,2,opt,name=len,proto3" json:"len,omitempty"`           // Length of property, including this header.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpQueuePropHeader) Reset() {
	*x = OfpQueuePropHeader{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpQueuePropHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpQueuePropHeader) ProtoMessage() {}

func (x *OfpQueuePropHeader) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpQueuePropHeader.ProtoReflect.Descriptor instead.
func (*OfpQueuePropHeader) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{74}
}

func (x *OfpQueuePropHeader) GetProperty() uint32 {
	if x != nil {
		return x.Property
	}
	return 0
}

func (x *OfpQueuePropHeader) GetLen() uint32 {
	if x != nil {
		return x.Len
	}
	return 0
}

// Min-Rate queue property description.
type OfpQueuePropMinRate struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PropHeader    *OfpQueuePropHeader    `protobuf:"bytes,1,opt,name=prop_header,json=propHeader,proto3" json:"prop_header,omitempty"` // prop: OFPQT_MIN, len: 16.
	Rate          uint32                 `protobuf:"varint,2,opt,name=rate,proto3" json:"rate,omitempty"`                              // In 1/10 of a percent = 0;>1000 -> disabled.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpQueuePropMinRate) Reset() {
	*x = OfpQueuePropMinRate{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpQueuePropMinRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpQueuePropMinRate) ProtoMessage() {}

func (x *OfpQueuePropMinRate) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpQueuePropMinRate.ProtoReflect.Descriptor instead.
func (*OfpQueuePropMinRate) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{75}
}

func (x *OfpQueuePropMinRate) GetPropHeader() *OfpQueuePropHeader {
	if x != nil {
		return x.PropHeader
	}
	return nil
}

func (x *OfpQueuePropMinRate) GetRate() uint32 {
	if x != nil {
		return x.Rate
	}
	return 0
}

// Max-Rate queue property description.
type OfpQueuePropMaxRate struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PropHeader    *OfpQueuePropHeader    `protobuf:"bytes,1,opt,name=prop_header,json=propHeader,proto3" json:"prop_header,omitempty"` // prop: OFPQT_MAX, len: 16.
	Rate          uint32                 `protobuf:"varint,2,opt,name=rate,proto3" json:"rate,omitempty"`                              // In 1/10 of a percent = 0;>1000 -> disabled.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpQueuePropMaxRate) Reset() {
	*x = OfpQueuePropMaxRate{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpQueuePropMaxRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpQueuePropMaxRate) ProtoMessage() {}

func (x *OfpQueuePropMaxRate) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpQueuePropMaxRate.ProtoReflect.Descriptor instead.
func (*OfpQueuePropMaxRate) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{76}
}

func (x *OfpQueuePropMaxRate) GetPropHeader() *OfpQueuePropHeader {
	if x != nil {
		return x.PropHeader
	}
	return nil
}

func (x *OfpQueuePropMaxRate) GetRate() uint32 {
	if x != nil {
		return x.Rate
	}
	return 0
}

// Experimenter queue property description.
type OfpQueuePropExperimenter struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PropHeader    *OfpQueuePropHeader    `protobuf:"bytes,1,opt,name=prop_header,json=propHeader,proto3" json:"prop_header,omitempty"` // prop: OFPQT_EXPERIMENTER
	Experimenter  uint32                 `protobuf:"varint,2,opt,name=experimenter,proto3" json:"experimenter,omitempty"`
	Data          []byte                 `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"` // Experimenter defined data.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpQueuePropExperimenter) Reset() {
	*x = OfpQueuePropExperimenter{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpQueuePropExperimenter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpQueuePropExperimenter) ProtoMessage() {}

func (x *OfpQueuePropExperimenter) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpQueuePropExperimenter.ProtoReflect.Descriptor instead.
func (*OfpQueuePropExperimenter) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{77}
}

func (x *OfpQueuePropExperimenter) GetPropHeader() *OfpQueuePropHeader {
	if x != nil {
		return x.PropHeader
	}
	return nil
}

func (x *OfpQueuePropExperimenter) GetExperimenter() uint32 {
	if x != nil {
		return x.Experimenter
	}
	return 0
}

func (x *OfpQueuePropExperimenter) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Full description for a queue.
type OfpPacketQueue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	QueueId       uint32                 `protobuf:"varint,1,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"` // id for the specific queue.
	Port          uint32                 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`                      // Port this queue is attached to.
	Properties    []*OfpQueuePropHeader  `protobuf:"bytes,4,rep,name=properties,proto3" json:"properties,omitempty"`           // List of properties.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpPacketQueue) Reset() {
	*x = OfpPacketQueue{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpPacketQueue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpPacketQueue) ProtoMessage() {}

func (x *OfpPacketQueue) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpPacketQueue.ProtoReflect.Descriptor instead.
func (*OfpPacketQueue) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{78}
}

func (x *OfpPacketQueue) GetQueueId() uint32 {
	if x != nil {
		return x.QueueId
	}
	return 0
}

func (x *OfpPacketQueue) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *OfpPacketQueue) GetProperties() []*OfpQueuePropHeader {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Query for port queue configuration.
type OfpQueueGetConfigRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Port          uint32 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpQueueGetConfigRequest) Reset() {
	*x = OfpQueueGetConfigRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpQueueGetConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpQueueGetConfigRequest) ProtoMessage() {}

func (x *OfpQueueGetConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpQueueGetConfigRequest.ProtoReflect.Descriptor instead.
func (*OfpQueueGetConfigRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{79}
}

func (x *OfpQueueGetConfigRequest) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// Queue configuration for a given port.
type OfpQueueGetConfigReply struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;
	Port          uint32            `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	Queues        []*OfpPacketQueue `protobuf:"bytes,2,rep,name=queues,proto3" json:"queues,omitempty"` // List of configured queues.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpQueueGetConfigReply) Reset() {
	*x = OfpQueueGetConfigReply{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpQueueGetConfigReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpQueueGetConfigReply) ProtoMessage() {}

func (x *OfpQueueGetConfigReply) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpQueueGetConfigReply.ProtoReflect.Descriptor instead.
func (*OfpQueueGetConfigReply) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{80}
}

func (x *OfpQueueGetConfigReply) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *OfpQueueGetConfigReply) GetQueues() []*OfpPacketQueue {
	if x != nil {
		return x.Queues
	}
	return nil
}

// OFPAT_SET_QUEUE action struct: send packets to given queue on port.
type OfpActionSetQueue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          uint32                 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`                      // OFPAT_SET_QUEUE.
	QueueId       uint32                 `protobuf:"varint,3,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"` // Queue id for the packets.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpActionSetQueue) Reset() {
	*x = OfpActionSetQueue{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpActionSetQueue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpActionSetQueue) ProtoMessage() {}

func (x *OfpActionSetQueue) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpActionSetQueue.ProtoReflect.Descriptor instead.
func (*OfpActionSetQueue) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{81}
}

func (x *OfpActionSetQueue) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *OfpActionSetQueue) GetQueueId() uint32 {
	if x != nil {
		return x.QueueId
	}
	return 0
}

type OfpQueueStatsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PortNo        uint32                 `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`    // All ports if OFPP_ANY.
	QueueId       uint32                 `protobuf:"varint,2,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"` // All queues if OFPQ_ALL.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpQueueStatsRequest) Reset() {
	*x = OfpQueueStatsRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpQueueStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpQueueStatsRequest) ProtoMessage() {}

func (x *OfpQueueStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpQueueStatsRequest.ProtoReflect.Descriptor instead.
func (*OfpQueueStatsRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{82}
}

func (x *OfpQueueStatsRequest) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *OfpQueueStatsRequest) GetQueueId() uint32 {
	if x != nil {
		return x.QueueId
	}
	return 0
}

type OfpQueueStats struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PortNo        uint32                 `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	QueueId       uint32                 `protobuf:"varint,2,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"`             // Queue i.d
	TxBytes       uint64                 `protobuf:"varint,3,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`             // Number of transmitted bytes.
	TxPackets     uint64                 `protobuf:"varint,4,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`       // Number of transmitted packets.
	TxErrors      uint64                 `protobuf:"varint,5,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`          // Number of packets dropped due to overrun.
	DurationSec   uint32                 `protobuf:"varint,6,opt,name=duration_sec,json=durationSec,proto3" json:"duration_sec,omitempty"` // Time queue has been alive in seconds.
	DurationNsec  uint32                 `protobuf:"varint,7,opt,name=duration_nsec,json=durationNsec,proto3" json:"duration_nsec,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpQueueStats) Reset() {
	*x = OfpQueueStats{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpQueueStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpQueueStats) ProtoMessage() {}

func (x *OfpQueueStats) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpQueueStats.ProtoReflect.Descriptor instead.
func (*OfpQueueStats) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{83}
}

func (x *OfpQueueStats) GetPortNo() uint32 {
	if x != nil {
		return x.PortNo
	}
	return 0
}

func (x *OfpQueueStats) GetQueueId() uint32 {
	if x != nil {
		return x.QueueId
	}
	return 0
}

func (x *OfpQueueStats) GetTxBytes() uint64 {
	if x != nil {
		return x.TxBytes
	}
	return 0
}

func (x *OfpQueueStats) GetTxPackets() uint64 {
	if x != nil {
		return x.TxPackets
	}
	return 0
}

func (x *OfpQueueStats) GetTxErrors() uint64 {
	if x != nil {
		return x.TxErrors
	}
	return 0
}

func (x *OfpQueueStats) GetDurationSec() uint32 {
	if x != nil {
		return x.DurationSec
	}
	return 0
}

func (x *OfpQueueStats) GetDurationNsec() uint32 {
	if x != nil {
		return x.DurationNsec
	}
	return 0
}

// Role request and reply message.
type OfpRoleRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;        /* Type OFPT_ROLE_REQUEST/OFPT_ROLE_REPLY. */
	Role          OfpControllerRole `protobuf:"varint,1,opt,name=role,proto3,enum=openflow_13.OfpControllerRole" json:"role,omitempty"`  // One of OFPCR_ROLE_*.
	GenerationId  uint64            `protobuf:"varint,2,opt,name=generation_id,json=generationId,proto3" json:"generation_id,omitempty"` // Master Election Generation Id
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfpRoleRequest) Reset() {
	*x = OfpRoleRequest{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpRoleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpRoleRequest) ProtoMessage() {}

func (x *OfpRoleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpRoleRequest.ProtoReflect.Descriptor instead.
func (*OfpRoleRequest) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{84}
}

func (x *OfpRoleRequest) GetRole() OfpControllerRole {
	if x != nil {
		return x.Role
	}
	return OfpControllerRole_OFPCR_ROLE_NOCHANGE
}

func (x *OfpRoleRequest) GetGenerationId() uint64 {
	if x != nil {
		return x.GenerationId
	}
	return 0
}

// Asynchronous message configuration.
type OfpAsyncConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ofp_header header;    /* OFPT_GET_ASYNC_REPLY or OFPT_SET_ASYNC. */
	PacketInMask    []uint32 `protobuf:"varint,1,rep,packed,name=packet_in_mask,json=packetInMask,proto3" json:"packet_in_mask,omitempty"`          // Bitmasks of OFPR_* values.
	PortStatusMask  []uint32 `protobuf:"varint,2,rep,packed,name=port_status_mask,json=portStatusMask,proto3" json:"port_status_mask,omitempty"`    // Bitmasks of OFPPR_* values.
	FlowRemovedMask []uint32 `protobuf:"varint,3,rep,packed,name=flow_removed_mask,json=flowRemovedMask,proto3" json:"flow_removed_mask,omitempty"` // Bitmasks of OFPRR_* values.
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *OfpAsyncConfig) Reset() {
	*x = OfpAsyncConfig{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfpAsyncConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfpAsyncConfig) ProtoMessage() {}

func (x *OfpAsyncConfig) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfpAsyncConfig.ProtoReflect.Descriptor instead.
func (*OfpAsyncConfig) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{85}
}

func (x *OfpAsyncConfig) GetPacketInMask() []uint32 {
	if x != nil {
		return x.PacketInMask
	}
	return nil
}

func (x *OfpAsyncConfig) GetPortStatusMask() []uint32 {
	if x != nil {
		return x.PortStatusMask
	}
	return nil
}

func (x *OfpAsyncConfig) GetFlowRemovedMask() []uint32 {
	if x != nil {
		return x.FlowRemovedMask
	}
	return nil
}

type MeterModUpdate struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // Device.id or LogicalDevice.id
	MeterMod      *OfpMeterMod           `protobuf:"bytes,2,opt,name=meter_mod,json=meterMod,proto3" json:"meter_mod,omitempty"`
	Xid           uint32                 `protobuf:"varint,3,opt,name=xid,proto3" json:"xid,omitempty"` //Transaction id associated with this request.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeterModUpdate) Reset() {
	*x = MeterModUpdate{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeterModUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeterModUpdate) ProtoMessage() {}

func (x *MeterModUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeterModUpdate.ProtoReflect.Descriptor instead.
func (*MeterModUpdate) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{86}
}

func (x *MeterModUpdate) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *MeterModUpdate) GetMeterMod() *OfpMeterMod {
	if x != nil {
		return x.MeterMod
	}
	return nil
}

func (x *MeterModUpdate) GetXid() uint32 {
	if x != nil {
		return x.Xid
	}
	return 0
}

type MeterStatsReply struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MeterStats    []*OfpMeterStats       `protobuf:"bytes,1,rep,name=meter_stats,json=meterStats,proto3" json:"meter_stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeterStatsReply) Reset() {
	*x = MeterStatsReply{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeterStatsReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeterStatsReply) ProtoMessage() {}

func (x *MeterStatsReply) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeterStatsReply.ProtoReflect.Descriptor instead.
func (*MeterStatsReply) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{87}
}

func (x *MeterStatsReply) GetMeterStats() []*OfpMeterStats {
	if x != nil {
		return x.MeterStats
	}
	return nil
}

type FlowTableUpdate struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // Device.id or LogicalDevice.id
	FlowMod       *OfpFlowMod            `protobuf:"bytes,2,opt,name=flow_mod,json=flowMod,proto3" json:"flow_mod,omitempty"`
	Xid           uint32                 `protobuf:"varint,3,opt,name=xid,proto3" json:"xid,omitempty"` //Transaction id associated with this request.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowTableUpdate) Reset() {
	*x = FlowTableUpdate{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowTableUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowTableUpdate) ProtoMessage() {}

func (x *FlowTableUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowTableUpdate.ProtoReflect.Descriptor instead.
func (*FlowTableUpdate) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{88}
}

func (x *FlowTableUpdate) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *FlowTableUpdate) GetFlowMod() *OfpFlowMod {
	if x != nil {
		return x.FlowMod
	}
	return nil
}

func (x *FlowTableUpdate) GetXid() uint32 {
	if x != nil {
		return x.Xid
	}
	return 0
}

type FlowGroupTableUpdate struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // Device.id or LogicalDevice.id
	GroupMod      *OfpGroupMod           `protobuf:"bytes,2,opt,name=group_mod,json=groupMod,proto3" json:"group_mod,omitempty"`
	Xid           uint32                 `protobuf:"varint,3,opt,name=xid,proto3" json:"xid,omitempty"` //Transaction id associated with this request.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowGroupTableUpdate) Reset() {
	*x = FlowGroupTableUpdate{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowGroupTableUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowGroupTableUpdate) ProtoMessage() {}

func (x *FlowGroupTableUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowGroupTableUpdate.ProtoReflect.Descriptor instead.
func (*FlowGroupTableUpdate) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{89}
}

func (x *FlowGroupTableUpdate) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *FlowGroupTableUpdate) GetGroupMod() *OfpGroupMod {
	if x != nil {
		return x.GroupMod
	}
	return nil
}

func (x *FlowGroupTableUpdate) GetXid() uint32 {
	if x != nil {
		return x.Xid
	}
	return 0
}

type Flows struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Items         []*OfpFlowStats        `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Flows) Reset() {
	*x = Flows{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Flows) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Flows) ProtoMessage() {}

func (x *Flows) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Flows.ProtoReflect.Descriptor instead.
func (*Flows) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{90}
}

func (x *Flows) GetItems() []*OfpFlowStats {
	if x != nil {
		return x.Items
	}
	return nil
}

type Meters struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Items         []*OfpMeterEntry       `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Meters) Reset() {
	*x = Meters{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Meters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Meters) ProtoMessage() {}

func (x *Meters) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Meters.ProtoReflect.Descriptor instead.
func (*Meters) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{91}
}

func (x *Meters) GetItems() []*OfpMeterEntry {
	if x != nil {
		return x.Items
	}
	return nil
}

type FlowGroups struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Items         []*OfpGroupEntry       `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowGroups) Reset() {
	*x = FlowGroups{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowGroups) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowGroups) ProtoMessage() {}

func (x *FlowGroups) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowGroups.ProtoReflect.Descriptor instead.
func (*FlowGroups) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{92}
}

func (x *FlowGroups) GetItems() []*OfpGroupEntry {
	if x != nil {
		return x.Items
	}
	return nil
}

type FlowChanges struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ToAdd         *Flows                 `protobuf:"bytes,1,opt,name=to_add,json=toAdd,proto3" json:"to_add,omitempty"`
	ToRemove      *Flows                 `protobuf:"bytes,2,opt,name=to_remove,json=toRemove,proto3" json:"to_remove,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowChanges) Reset() {
	*x = FlowChanges{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowChanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowChanges) ProtoMessage() {}

func (x *FlowChanges) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowChanges.ProtoReflect.Descriptor instead.
func (*FlowChanges) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{93}
}

func (x *FlowChanges) GetToAdd() *Flows {
	if x != nil {
		return x.ToAdd
	}
	return nil
}

func (x *FlowChanges) GetToRemove() *Flows {
	if x != nil {
		return x.ToRemove
	}
	return nil
}

type FlowGroupChanges struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ToAdd         *FlowGroups            `protobuf:"bytes,1,opt,name=to_add,json=toAdd,proto3" json:"to_add,omitempty"`
	ToRemove      *FlowGroups            `protobuf:"bytes,2,opt,name=to_remove,json=toRemove,proto3" json:"to_remove,omitempty"`
	ToUpdate      *FlowGroups            `protobuf:"bytes,3,opt,name=to_update,json=toUpdate,proto3" json:"to_update,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowGroupChanges) Reset() {
	*x = FlowGroupChanges{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowGroupChanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowGroupChanges) ProtoMessage() {}

func (x *FlowGroupChanges) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowGroupChanges.ProtoReflect.Descriptor instead.
func (*FlowGroupChanges) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{94}
}

func (x *FlowGroupChanges) GetToAdd() *FlowGroups {
	if x != nil {
		return x.ToAdd
	}
	return nil
}

func (x *FlowGroupChanges) GetToRemove() *FlowGroups {
	if x != nil {
		return x.ToRemove
	}
	return nil
}

func (x *FlowGroupChanges) GetToUpdate() *FlowGroups {
	if x != nil {
		return x.ToUpdate
	}
	return nil
}

type PacketIn struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // LogicalDevice.id
	PacketIn      *OfpPacketIn           `protobuf:"bytes,2,opt,name=packet_in,json=packetIn,proto3" json:"packet_in,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PacketIn) Reset() {
	*x = PacketIn{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PacketIn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketIn) ProtoMessage() {}

func (x *PacketIn) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketIn.ProtoReflect.Descriptor instead.
func (*PacketIn) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{95}
}

func (x *PacketIn) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PacketIn) GetPacketIn() *OfpPacketIn {
	if x != nil {
		return x.PacketIn
	}
	return nil
}

type PacketOut struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // LogicalDevice.id
	PacketOut     *OfpPacketOut          `protobuf:"bytes,2,opt,name=packet_out,json=packetOut,proto3" json:"packet_out,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PacketOut) Reset() {
	*x = PacketOut{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PacketOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketOut) ProtoMessage() {}

func (x *PacketOut) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketOut.ProtoReflect.Descriptor instead.
func (*PacketOut) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{96}
}

func (x *PacketOut) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PacketOut) GetPacketOut() *OfpPacketOut {
	if x != nil {
		return x.PacketOut
	}
	return nil
}

type ChangeEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Id    string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // LogicalDevice.id
	// Types that are valid to be assigned to Event:
	//
	//	*ChangeEvent_PortStatus
	//	*ChangeEvent_Error
	//	*ChangeEvent_DeviceStatus
	Event         isChangeEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChangeEvent) Reset() {
	*x = ChangeEvent{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeEvent) ProtoMessage() {}

func (x *ChangeEvent) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeEvent.ProtoReflect.Descriptor instead.
func (*ChangeEvent) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{97}
}

func (x *ChangeEvent) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ChangeEvent) GetEvent() isChangeEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *ChangeEvent) GetPortStatus() *OfpPortStatus {
	if x != nil {
		if x, ok := x.Event.(*ChangeEvent_PortStatus); ok {
			return x.PortStatus
		}
	}
	return nil
}

func (x *ChangeEvent) GetError() *OfpErrorMsg {
	if x != nil {
		if x, ok := x.Event.(*ChangeEvent_Error); ok {
			return x.Error
		}
	}
	return nil
}

func (x *ChangeEvent) GetDeviceStatus() *OfpDeviceStatus {
	if x != nil {
		if x, ok := x.Event.(*ChangeEvent_DeviceStatus); ok {
			return x.DeviceStatus
		}
	}
	return nil
}

type isChangeEvent_Event interface {
	isChangeEvent_Event()
}

type ChangeEvent_PortStatus struct {
	PortStatus *OfpPortStatus `protobuf:"bytes,2,opt,name=port_status,json=portStatus,proto3,oneof"`
}

type ChangeEvent_Error struct {
	Error *OfpErrorMsg `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

type ChangeEvent_DeviceStatus struct {
	DeviceStatus *OfpDeviceStatus `protobuf:"bytes,4,opt,name=device_status,json=deviceStatus,proto3,oneof"`
}

func (*ChangeEvent_PortStatus) isChangeEvent_Event() {}

func (*ChangeEvent_Error) isChangeEvent_Event() {}

func (*ChangeEvent_DeviceStatus) isChangeEvent_Event() {}

// Additional information required to process flow at device adapters
type FlowMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Meters associated with flow-update to adapter
	Meters        []*OfpMeterConfig `protobuf:"bytes,1,rep,name=meters,proto3" json:"meters,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FlowMetadata) Reset() {
	*x = FlowMetadata{}
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowMetadata) ProtoMessage() {}

func (x *FlowMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_openflow_13_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowMetadata.ProtoReflect.Descriptor instead.
func (*FlowMetadata) Descriptor() ([]byte, []int) {
	return file_voltha_protos_openflow_13_proto_rawDescGZIP(), []int{98}
}

func (x *FlowMetadata) GetMeters() []*OfpMeterConfig {
	if x != nil {
		return x.Meters
	}
	return nil
}

var File_voltha_protos_openflow_13_proto protoreflect.FileDescriptor

const file_voltha_protos_openflow_13_proto_rawDesc = "" +
	"\n" +
	"\x1fvoltha_protos/openflow_13.proto\x12\vopenflow_13\x1a\x1cgoogle/api/annotations.proto\"c\n" +
	"\n" +
	"ofp_header\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12)\n" +
	"\x04type\x18\x02 \x01(\x0e2\x15.openflow_13.ofp_typeR\x04type\x12\x10\n" +
	"\x03xid\x18\x03 \x01(\rR\x03xid\"\xab\x01\n" +
	"\x15ofp_hello_elem_header\x124\n" +
	"\x04type\x18\x01 \x01(\x0e2 .openflow_13.ofp_hello_elem_typeR\x04type\x12Q\n" +
	"\rversionbitmap\x18\x02 \x01(\v2).openflow_13.ofp_hello_elem_versionbitmapH\x00R\rversionbitmapB\t\n" +
	"\aelement\"8\n" +
	"\x1cofp_hello_elem_versionbitmap\x12\x18\n" +
	"\abitmaps\x18\x02 \x03(\rR\abitmaps\"K\n" +
	"\tofp_hello\x12>\n" +
	"\belements\x18\x01 \x03(\v2\".openflow_13.ofp_hello_elem_headerR\belements\"M\n" +
	"\x11ofp_switch_config\x12\x14\n" +
	"\x05flags\x18\x01 \x01(\rR\x05flags\x12\"\n" +
	"\rmiss_send_len\x18\x02 \x01(\rR\vmissSendLen\"B\n" +
	"\rofp_table_mod\x12\x19\n" +
	"\btable_id\x18\x01 \x01(\rR\atableId\x12\x16\n" +
	"\x06config\x18\x02 \x01(\rR\x06config\"\xa0\x02\n" +
	"\bofp_port\x12\x17\n" +
	"\aport_no\x18\x01 \x01(\rR\x06portNo\x12\x17\n" +
	"\ahw_addr\x18\x02 \x03(\rR\x06hwAddr\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12\x16\n" +
	"\x06config\x18\x04 \x01(\rR\x06config\x12\x14\n" +
	"\x05state\x18\x05 \x01(\rR\x05state\x12\x12\n" +
	"\x04curr\x18\x06 \x01(\rR\x04curr\x12\x1e\n" +
	"\n" +
	"advertised\x18\a \x01(\rR\n" +
	"advertised\x12\x1c\n" +
	"\tsupported\x18\b \x01(\rR\tsupported\x12\x12\n" +
	"\x04peer\x18\t \x01(\rR\x04peer\x12\x1d\n" +
	"\n" +
	"curr_speed\x18\n" +
	" \x01(\rR\tcurrSpeed\x12\x1b\n" +
	"\tmax_speed\x18\v \x01(\rR\bmaxSpeed\"\xb5\x01\n" +
	"\x13ofp_switch_features\x12\x1f\n" +
	"\vdatapath_id\x18\x01 \x01(\x04R\n" +
	"datapathId\x12\x1b\n" +
	"\tn_buffers\x18\x02 \x01(\rR\bnBuffers\x12\x19\n" +
	"\bn_tables\x18\x03 \x01(\rR\anTables\x12!\n" +
	"\fauxiliary_id\x18\x04 \x01(\rR\vauxiliaryId\x12\"\n" +
	"\fcapabilities\x18\x05 \x01(\rR\fcapabilities\"r\n" +
	"\x0fofp_port_status\x124\n" +
	"\x06reason\x18\x01 \x01(\x0e2\x1c.openflow_13.ofp_port_reasonR\x06reason\x12)\n" +
	"\x04desc\x18\x02 \x01(\v2\x15.openflow_13.ofp_portR\x04desc\"O\n" +
	"\x11ofp_device_status\x12:\n" +
	"\x06status\x18\x01 \x01(\x0e2\".openflow_13.ofp_device_connectionR\x06status\"\x8a\x01\n" +
	"\fofp_port_mod\x12\x17\n" +
	"\aport_no\x18\x01 \x01(\rR\x06portNo\x12\x17\n" +
	"\ahw_addr\x18\x02 \x03(\rR\x06hwAddr\x12\x16\n" +
	"\x06config\x18\x03 \x01(\rR\x06config\x12\x12\n" +
	"\x04mask\x18\x04 \x01(\rR\x04mask\x12\x1c\n" +
	"\tadvertise\x18\x05 \x01(\rR\tadvertise\"w\n" +
	"\tofp_match\x12/\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1b.openflow_13.ofp_match_typeR\x04type\x129\n" +
	"\n" +
	"oxm_fields\x18\x02 \x03(\v2\x1a.openflow_13.ofp_oxm_fieldR\toxmFields\"\xea\x01\n" +
	"\rofp_oxm_field\x127\n" +
	"\toxm_class\x18\x01 \x01(\x0e2\x1a.openflow_13.ofp_oxm_classR\boxmClass\x12=\n" +
	"\tofb_field\x18\x04 \x01(\v2\x1e.openflow_13.ofp_oxm_ofb_fieldH\x00R\bofbField\x12X\n" +
	"\x12experimenter_field\x18\x05 \x01(\v2'.openflow_13.ofp_oxm_experimenter_fieldH\x00R\x11experimenterFieldB\a\n" +
	"\x05field\"\xd7\x0e\n" +
	"\x11ofp_oxm_ofb_field\x124\n" +
	"\x04type\x18\x01 \x01(\x0e2 .openflow_13.oxm_ofb_field_typesR\x04type\x12\x19\n" +
	"\bhas_mask\x18\x02 \x01(\bR\ahasMask\x12\x14\n" +
	"\x04port\x18\x03 \x01(\rH\x00R\x04port\x12%\n" +
	"\rphysical_port\x18\x04 \x01(\rH\x00R\fphysicalPort\x12'\n" +
	"\x0etable_metadata\x18\x05 \x01(\x04H\x00R\rtableMetadata\x12\x19\n" +
	"\aeth_dst\x18\x06 \x01(\fH\x00R\x06ethDst\x12\x19\n" +
	"\aeth_src\x18\a \x01(\fH\x00R\x06ethSrc\x12\x1b\n" +
	"\beth_type\x18\b \x01(\rH\x00R\aethType\x12\x1b\n" +
	"\bvlan_vid\x18\t \x01(\rH\x00R\avlanVid\x12\x1b\n" +
	"\bvlan_pcp\x18\n" +
	" \x01(\rH\x00R\avlanPcp\x12\x19\n" +
	"\aip_dscp\x18\v \x01(\rH\x00R\x06ipDscp\x12\x17\n" +
	"\x06ip_ecn\x18\f \x01(\rH\x00R\x05ipEcn\x12\x1b\n" +
	"\bip_proto\x18\r \x01(\rH\x00R\aipProto\x12\x1b\n" +
	"\bipv4_src\x18\x0e \x01(\rH\x00R\aipv4Src\x12\x1b\n" +
	"\bipv4_dst\x18\x0f \x01(\rH\x00R\aipv4Dst\x12\x19\n" +
	"\atcp_src\x18\x10 \x01(\rH\x00R\x06tcpSrc\x12\x19\n" +
	"\atcp_dst\x18\x11 \x01(\rH\x00R\x06tcpDst\x12\x19\n" +
	"\audp_src\x18\x12 \x01(\rH\x00R\x06udpSrc\x12\x19\n" +
	"\audp_dst\x18\x13 \x01(\rH\x00R\x06udpDst\x12\x1b\n" +
	"\bsctp_src\x18\x14 \x01(\rH\x00R\asctpSrc\x12\x1b\n" +
	"\bsctp_dst\x18\x15 \x01(\rH\x00R\asctpDst\x12!\n" +
	"\vicmpv4_type\x18\x16 \x01(\rH\x00R\n" +
	"icmpv4Type\x12!\n" +
	"\vicmpv4_code\x18\x17 \x01(\rH\x00R\n" +
	"icmpv4Code\x12\x17\n" +
	"\x06arp_op\x18\x18 \x01(\rH\x00R\x05arpOp\x12\x19\n" +
	"\aarp_spa\x18\x19 \x01(\rH\x00R\x06arpSpa\x12\x19\n" +
	"\aarp_tpa\x18\x1a \x01(\rH\x00R\x06arpTpa\x12\x19\n" +
	"\aarp_sha\x18\x1b \x01(\fH\x00R\x06arpSha\x12\x19\n" +
	"\aarp_tha\x18\x1c \x01(\fH\x00R\x06arpTha\x12\x1b\n" +
	"\bipv6_src\x18\x1d \x01(\fH\x00R\aipv6Src\x12\x1b\n" +
	"\bipv6_dst\x18\x1e \x01(\fH\x00R\aipv6Dst\x12!\n" +
	"\vipv6_flabel\x18\x1f \x01(\rH\x00R\n" +
	"ipv6Flabel\x12!\n" +
	"\vicmpv6_type\x18  \x01(\rH\x00R\n" +
	"icmpv6Type\x12!\n" +
	"\vicmpv6_code\x18! \x01(\rH\x00R\n" +
	"icmpv6Code\x12&\n" +
	"\x0eipv6_nd_target\x18\" \x01(\fH\x00R\fipv6NdTarget\x12 \n" +
	"\vipv6_nd_ssl\x18# \x01(\fH\x00R\tipv6NdSsl\x12 \n" +
	"\vipv6_nd_tll\x18$ \x01(\fH\x00R\tipv6NdTll\x12\x1f\n" +
	"\n" +
	"mpls_label\x18% \x01(\rH\x00R\tmplsLabel\x12\x19\n" +
	"\ampls_tc\x18& \x01(\rH\x00R\x06mplsTc\x12\x1b\n" +
	"\bmpls_bos\x18' \x01(\rH\x00R\amplsBos\x12\x1b\n" +
	"\bpbb_isid\x18( \x01(\rH\x00R\apbbIsid\x12\x1d\n" +
	"\ttunnel_id\x18) \x01(\x04H\x00R\btunnelId\x12!\n" +
	"\vipv6_exthdr\x18* \x01(\rH\x00R\n" +
	"ipv6Exthdr\x120\n" +
	"\x13table_metadata_mask\x18i \x01(\x04H\x01R\x11tableMetadataMask\x12\"\n" +
	"\feth_dst_mask\x18j \x01(\fH\x01R\n" +
	"ethDstMask\x12\"\n" +
	"\feth_src_mask\x18k \x01(\fH\x01R\n" +
	"ethSrcMask\x12$\n" +
	"\rvlan_vid_mask\x18m \x01(\rH\x01R\vvlanVidMask\x12$\n" +
	"\ripv4_src_mask\x18r \x01(\rH\x01R\vipv4SrcMask\x12$\n" +
	"\ripv4_dst_mask\x18s \x01(\rH\x01R\vipv4DstMask\x12\"\n" +
	"\farp_spa_mask\x18} \x01(\rH\x01R\n" +
	"arpSpaMask\x12\"\n" +
	"\farp_tpa_mask\x18~ \x01(\rH\x01R\n" +
	"arpTpaMask\x12%\n" +
	"\ripv6_src_mask\x18\x81\x01 \x01(\fH\x01R\vipv6SrcMask\x12%\n" +
	"\ripv6_dst_mask\x18\x82\x01 \x01(\fH\x01R\vipv6DstMask\x12+\n" +
	"\x10ipv6_flabel_mask\x18\x83\x01 \x01(\rH\x01R\x0eipv6FlabelMask\x12%\n" +
	"\rpbb_isid_mask\x18\x8c\x01 \x01(\rH\x01R\vpbbIsidMask\x12'\n" +
	"\x0etunnel_id_mask\x18\x8d\x01 \x01(\x04H\x01R\ftunnelIdMask\x12+\n" +
	"\x10ipv6_exthdr_mask\x18\x8e\x01 \x01(\rH\x01R\x0eipv6ExthdrMaskB\a\n" +
	"\x05valueB\x06\n" +
	"\x04mask\"_\n" +
	"\x1aofp_oxm_experimenter_field\x12\x1d\n" +
	"\n" +
	"oxm_header\x18\x01 \x01(\rR\toxmHeader\x12\"\n" +
	"\fexperimenter\x18\x02 \x01(\rR\fexperimenter\"\xb2\x04\n" +
	"\n" +
	"ofp_action\x120\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1c.openflow_13.ofp_action_typeR\x04type\x128\n" +
	"\x06output\x18\x02 \x01(\v2\x1e.openflow_13.ofp_action_outputH\x00R\x06output\x12=\n" +
	"\bmpls_ttl\x18\x03 \x01(\v2 .openflow_13.ofp_action_mpls_ttlH\x00R\amplsTtl\x122\n" +
	"\x04push\x18\x04 \x01(\v2\x1c.openflow_13.ofp_action_pushH\x00R\x04push\x12=\n" +
	"\bpop_mpls\x18\x05 \x01(\v2 .openflow_13.ofp_action_pop_mplsH\x00R\apopMpls\x125\n" +
	"\x05group\x18\x06 \x01(\v2\x1d.openflow_13.ofp_action_groupH\x00R\x05group\x127\n" +
	"\x06nw_ttl\x18\a \x01(\v2\x1e.openflow_13.ofp_action_nw_ttlH\x00R\x05nwTtl\x12@\n" +
	"\tset_field\x18\b \x01(\v2!.openflow_13.ofp_action_set_fieldH\x00R\bsetField\x12J\n" +
	"\fexperimenter\x18\t \x01(\v2$.openflow_13.ofp_action_experimenterH\x00R\fexperimenterB\b\n" +
	"\x06action\"@\n" +
	"\x11ofp_action_output\x12\x12\n" +
	"\x04port\x18\x01 \x01(\rR\x04port\x12\x17\n" +
	"\amax_len\x18\x02 \x01(\rR\x06maxLen\"0\n" +
	"\x13ofp_action_mpls_ttl\x12\x19\n" +
	"\bmpls_ttl\x18\x01 \x01(\rR\amplsTtl\"/\n" +
	"\x0fofp_action_push\x12\x1c\n" +
	"\tethertype\x18\x01 \x01(\rR\tethertype\"3\n" +
	"\x13ofp_action_pop_mpls\x12\x1c\n" +
	"\tethertype\x18\x01 \x01(\rR\tethertype\"-\n" +
	"\x10ofp_action_group\x12\x19\n" +
	"\bgroup_id\x18\x01 \x01(\rR\agroupId\"*\n" +
	"\x11ofp_action_nw_ttl\x12\x15\n" +
	"\x06nw_ttl\x18\x01 \x01(\rR\x05nwTtl\"H\n" +
	"\x14ofp_action_set_field\x120\n" +
	"\x05field\x18\x01 \x01(\v2\x1a.openflow_13.ofp_oxm_fieldR\x05field\"Q\n" +
	"\x17ofp_action_experimenter\x12\"\n" +
	"\fexperimenter\x18\x01 \x01(\rR\fexperimenter\x12\x12\n" +
	"\x04data\x18\x02 \x01(\fR\x04data\"\x9c\x03\n" +
	"\x0fofp_instruction\x12\x12\n" +
	"\x04type\x18\x01 \x01(\rR\x04type\x12H\n" +
	"\n" +
	"goto_table\x18\x02 \x01(\v2'.openflow_13.ofp_instruction_goto_tableH\x00R\tgotoTable\x12T\n" +
	"\x0ewrite_metadata\x18\x03 \x01(\v2+.openflow_13.ofp_instruction_write_metadataH\x00R\rwriteMetadata\x12@\n" +
	"\aactions\x18\x04 \x01(\v2$.openflow_13.ofp_instruction_actionsH\x00R\aactions\x12:\n" +
	"\x05meter\x18\x05 \x01(\v2\".openflow_13.ofp_instruction_meterH\x00R\x05meter\x12O\n" +
	"\fexperimenter\x18\x06 \x01(\v2).openflow_13.ofp_instruction_experimenterH\x00R\fexperimenterB\x06\n" +
	"\x04data\"7\n" +
	"\x1aofp_instruction_goto_table\x12\x19\n" +
	"\btable_id\x18\x01 \x01(\rR\atableId\"a\n" +
	"\x1eofp_instruction_write_metadata\x12\x1a\n" +
	"\bmetadata\x18\x01 \x01(\x04R\bmetadata\x12#\n" +
	"\rmetadata_mask\x18\x02 \x01(\x04R\fmetadataMask\"L\n" +
	"\x17ofp_instruction_actions\x121\n" +
	"\aactions\x18\x01 \x03(\v2\x17.openflow_13.ofp_actionR\aactions\"2\n" +
	"\x15ofp_instruction_meter\x12\x19\n" +
	"\bmeter_id\x18\x01 \x01(\rR\ameterId\"V\n" +
	"\x1cofp_instruction_experimenter\x12\"\n" +
	"\fexperimenter\x18\x01 \x01(\rR\fexperimenter\x12\x12\n" +
	"\x04data\x18\x02 \x01(\fR\x04data\"\xdc\x03\n" +
	"\fofp_flow_mod\x12\x16\n" +
	"\x06cookie\x18\x01 \x01(\x04R\x06cookie\x12\x1f\n" +
	"\vcookie_mask\x18\x02 \x01(\x04R\n" +
	"cookieMask\x12\x19\n" +
	"\btable_id\x18\x03 \x01(\rR\atableId\x12;\n" +
	"\acommand\x18\x04 \x01(\x0e2!.openflow_13.ofp_flow_mod_commandR\acommand\x12!\n" +
	"\fidle_timeout\x18\x05 \x01(\rR\vidleTimeout\x12!\n" +
	"\fhard_timeout\x18\x06 \x01(\rR\vhardTimeout\x12\x1a\n" +
	"\bpriority\x18\a \x01(\rR\bpriority\x12\x1b\n" +
	"\tbuffer_id\x18\b \x01(\rR\bbufferId\x12\x19\n" +
	"\bout_port\x18\t \x01(\rR\aoutPort\x12\x1b\n" +
	"\tout_group\x18\n" +
	" \x01(\rR\boutGroup\x12\x14\n" +
	"\x05flags\x18\v \x01(\rR\x05flags\x12,\n" +
	"\x05match\x18\f \x01(\v2\x16.openflow_13.ofp_matchR\x05match\x12@\n" +
	"\finstructions\x18\r \x03(\v2\x1c.openflow_13.ofp_instructionR\finstructions\"\x97\x01\n" +
	"\n" +
	"ofp_bucket\x12\x16\n" +
	"\x06weight\x18\x01 \x01(\rR\x06weight\x12\x1d\n" +
	"\n" +
	"watch_port\x18\x02 \x01(\rR\twatchPort\x12\x1f\n" +
	"\vwatch_group\x18\x03 \x01(\rR\n" +
	"watchGroup\x121\n" +
	"\aactions\x18\x04 \x03(\v2\x17.openflow_13.ofp_actionR\aactions\"\xcc\x01\n" +
	"\rofp_group_mod\x12<\n" +
	"\acommand\x18\x01 \x01(\x0e2\".openflow_13.ofp_group_mod_commandR\acommand\x12/\n" +
	"\x04type\x18\x02 \x01(\x0e2\x1b.openflow_13.ofp_group_typeR\x04type\x12\x19\n" +
	"\bgroup_id\x18\x03 \x01(\rR\agroupId\x121\n" +
	"\abuckets\x18\x04 \x03(\v2\x17.openflow_13.ofp_bucketR\abuckets\"\x8d\x01\n" +
	"\x0eofp_packet_out\x12\x1b\n" +
	"\tbuffer_id\x18\x01 \x01(\rR\bbufferId\x12\x17\n" +
	"\ain_port\x18\x02 \x01(\rR\x06inPort\x121\n" +
	"\aactions\x18\x03 \x03(\v2\x17.openflow_13.ofp_actionR\aactions\x12\x12\n" +
	"\x04data\x18\x04 \x01(\fR\x04data\"\xdc\x01\n" +
	"\rofp_packet_in\x12\x1b\n" +
	"\tbuffer_id\x18\x01 \x01(\rR\bbufferId\x129\n" +
	"\x06reason\x18\x02 \x01(\x0e2!.openflow_13.ofp_packet_in_reasonR\x06reason\x12\x19\n" +
	"\btable_id\x18\x03 \x01(\rR\atableId\x12\x16\n" +
	"\x06cookie\x18\x04 \x01(\x04R\x06cookie\x12,\n" +
	"\x05match\x18\x05 \x01(\v2\x16.openflow_13.ofp_matchR\x05match\x12\x12\n" +
	"\x04data\x18\x06 \x01(\fR\x04data\"\x9d\x03\n" +
	"\x10ofp_flow_removed\x12\x16\n" +
	"\x06cookie\x18\x01 \x01(\x04R\x06cookie\x12\x1a\n" +
	"\bpriority\x18\x02 \x01(\rR\bpriority\x12<\n" +
	"\x06reason\x18\x03 \x01(\x0e2$.openflow_13.ofp_flow_removed_reasonR\x06reason\x12\x19\n" +
	"\btable_id\x18\x04 \x01(\rR\atableId\x12!\n" +
	"\fduration_sec\x18\x05 \x01(\rR\vdurationSec\x12#\n" +
	"\rduration_nsec\x18\x06 \x01(\rR\fdurationNsec\x12!\n" +
	"\fidle_timeout\x18\a \x01(\rR\vidleTimeout\x12!\n" +
	"\fhard_timeout\x18\b \x01(\rR\vhardTimeout\x12!\n" +
	"\fpacket_count\x18\t \x01(\x04R\vpacketCount\x12\x1d\n" +
	"\n" +
	"byte_count\x18\n" +
	" \x01(\x04R\tbyteCount\x12,\n" +
	"\x05match\x18y \x01(\v2\x16.openflow_13.ofp_matchR\x05match\"\xdc\x02\n" +
	"\x15ofp_meter_band_header\x124\n" +
	"\x04type\x18\x01 \x01(\x0e2 .openflow_13.ofp_meter_band_typeR\x04type\x12\x12\n" +
	"\x04rate\x18\x02 \x01(\rR\x04rate\x12\x1d\n" +
	"\n" +
	"burst_size\x18\x03 \x01(\rR\tburstSize\x126\n" +
	"\x04drop\x18\x04 \x01(\v2 .openflow_13.ofp_meter_band_dropH\x00R\x04drop\x12J\n" +
	"\vdscp_remark\x18\x05 \x01(\v2'.openflow_13.ofp_meter_band_dscp_remarkH\x00R\n" +
	"dscpRemark\x12N\n" +
	"\fexperimenter\x18\x06 \x01(\v2(.openflow_13.ofp_meter_band_experimenterH\x00R\fexperimenterB\x06\n" +
	"\x04data\"\x15\n" +
	"\x13ofp_meter_band_drop\";\n" +
	"\x1aofp_meter_band_dscp_remark\x12\x1d\n" +
	"\n" +
	"prec_level\x18\x01 \x01(\rR\tprecLevel\"A\n" +
	"\x1bofp_meter_band_experimenter\x12\"\n" +
	"\fexperimenter\x18\x01 \x01(\rR\fexperimenter\"\xb8\x01\n" +
	"\rofp_meter_mod\x12<\n" +
	"\acommand\x18\x01 \x01(\x0e2\".openflow_13.ofp_meter_mod_commandR\acommand\x12\x14\n" +
	"\x05flags\x18\x02 \x01(\rR\x05flags\x12\x19\n" +
	"\bmeter_id\x18\x03 \x01(\rR\ameterId\x128\n" +
	"\x05bands\x18\x04 \x03(\v2\".openflow_13.ofp_meter_band_headerR\x05bands\"|\n" +
	"\rofp_error_msg\x12/\n" +
	"\x06header\x18\x01 \x01(\v2\x17.openflow_13.ofp_headerR\x06header\x12\x12\n" +
	"\x04type\x18\x02 \x01(\rR\x04type\x12\x12\n" +
	"\x04code\x18\x03 \x01(\rR\x04code\x12\x12\n" +
	"\x04data\x18\x04 \x01(\fR\x04data\"\x83\x01\n" +
	"\x1aofp_error_experimenter_msg\x12\x12\n" +
	"\x04type\x18\x01 \x01(\rR\x04type\x12\x19\n" +
	"\bexp_type\x18\x02 \x01(\rR\aexpType\x12\"\n" +
	"\fexperimenter\x18\x03 \x01(\rR\fexperimenter\x12\x12\n" +
	"\x04data\x18\x04 \x01(\fR\x04data\"v\n" +
	"\x15ofp_multipart_request\x123\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1f.openflow_13.ofp_multipart_typeR\x04type\x12\x14\n" +
	"\x05flags\x18\x02 \x01(\rR\x05flags\x12\x12\n" +
	"\x04body\x18\x03 \x01(\fR\x04body\"t\n" +
	"\x13ofp_multipart_reply\x123\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1f.openflow_13.ofp_multipart_typeR\x04type\x12\x14\n" +
	"\x05flags\x18\x02 \x01(\rR\x05flags\x12\x12\n" +
	"\x04body\x18\x03 \x01(\fR\x04body\"\x8f\x01\n" +
	"\bofp_desc\x12\x19\n" +
	"\bmfr_desc\x18\x01 \x01(\tR\amfrDesc\x12\x17\n" +
	"\ahw_desc\x18\x02 \x01(\tR\x06hwDesc\x12\x17\n" +
	"\asw_desc\x18\x03 \x01(\tR\x06swDesc\x12\x1d\n" +
	"\n" +
	"serial_num\x18\x04 \x01(\tR\tserialNum\x12\x17\n" +
	"\adp_desc\x18\x05 \x01(\tR\x06dpDesc\"\xd2\x01\n" +
	"\x16ofp_flow_stats_request\x12\x19\n" +
	"\btable_id\x18\x01 \x01(\rR\atableId\x12\x19\n" +
	"\bout_port\x18\x02 \x01(\rR\aoutPort\x12\x1b\n" +
	"\tout_group\x18\x03 \x01(\rR\boutGroup\x12\x16\n" +
	"\x06cookie\x18\x04 \x01(\x04R\x06cookie\x12\x1f\n" +
	"\vcookie_mask\x18\x05 \x01(\x04R\n" +
	"cookieMask\x12,\n" +
	"\x05match\x18\x06 \x01(\v2\x16.openflow_13.ofp_matchR\x05match\"\xc5\x03\n" +
	"\x0eofp_flow_stats\x12\x0e\n" +
	"\x02id\x18\x0e \x01(\x04R\x02id\x12\x19\n" +
	"\btable_id\x18\x01 \x01(\rR\atableId\x12!\n" +
	"\fduration_sec\x18\x02 \x01(\rR\vdurationSec\x12#\n" +
	"\rduration_nsec\x18\x03 \x01(\rR\fdurationNsec\x12\x1a\n" +
	"\bpriority\x18\x04 \x01(\rR\bpriority\x12!\n" +
	"\fidle_timeout\x18\x05 \x01(\rR\vidleTimeout\x12!\n" +
	"\fhard_timeout\x18\x06 \x01(\rR\vhardTimeout\x12\x14\n" +
	"\x05flags\x18\a \x01(\rR\x05flags\x12\x16\n" +
	"\x06cookie\x18\b \x01(\x04R\x06cookie\x12!\n" +
	"\fpacket_count\x18\t \x01(\x04R\vpacketCount\x12\x1d\n" +
	"\n" +
	"byte_count\x18\n" +
	" \x01(\x04R\tbyteCount\x12,\n" +
	"\x05match\x18\f \x01(\v2\x16.openflow_13.ofp_matchR\x05match\x12@\n" +
	"\finstructions\x18\r \x03(\v2\x1c.openflow_13.ofp_instructionR\finstructions\"\xd7\x01\n" +
	"\x1bofp_aggregate_stats_request\x12\x19\n" +
	"\btable_id\x18\x01 \x01(\rR\atableId\x12\x19\n" +
	"\bout_port\x18\x02 \x01(\rR\aoutPort\x12\x1b\n" +
	"\tout_group\x18\x03 \x01(\rR\boutGroup\x12\x16\n" +
	"\x06cookie\x18\x04 \x01(\x04R\x06cookie\x12\x1f\n" +
	"\vcookie_mask\x18\x05 \x01(\x04R\n" +
	"cookieMask\x12,\n" +
	"\x05match\x18\x06 \x01(\v2\x16.openflow_13.ofp_matchR\x05match\"|\n" +
	"\x19ofp_aggregate_stats_reply\x12!\n" +
	"\fpacket_count\x18\x01 \x01(\x04R\vpacketCount\x12\x1d\n" +
	"\n" +
	"byte_count\x18\x02 \x01(\x04R\tbyteCount\x12\x1d\n" +
	"\n" +
	"flow_count\x18\x03 \x01(\rR\tflowCount\"\xed\x03\n" +
	"\x1aofp_table_feature_property\x12<\n" +
	"\x04type\x18\x01 \x01(\x0e2(.openflow_13.ofp_table_feature_prop_typeR\x04type\x12V\n" +
	"\finstructions\x18\x02 \x01(\v20.openflow_13.ofp_table_feature_prop_instructionsH\x00R\finstructions\x12R\n" +
	"\vnext_tables\x18\x03 \x01(\v2/.openflow_13.ofp_table_feature_prop_next_tablesH\x00R\n" +
	"nextTables\x12G\n" +
	"\aactions\x18\x04 \x01(\v2+.openflow_13.ofp_table_feature_prop_actionsH\x00R\aactions\x12;\n" +
	"\x03oxm\x18\x05 \x01(\v2'.openflow_13.ofp_table_feature_prop_oxmH\x00R\x03oxm\x12V\n" +
	"\fexperimenter\x18\x06 \x01(\v20.openflow_13.ofp_table_feature_prop_experimenterH\x00R\fexperimenterB\a\n" +
	"\x05value\"g\n" +
	"#ofp_table_feature_prop_instructions\x12@\n" +
	"\finstructions\x18\x01 \x03(\v2\x1c.openflow_13.ofp_instructionR\finstructions\"J\n" +
	"\"ofp_table_feature_prop_next_tables\x12$\n" +
	"\x0enext_table_ids\x18\x01 \x03(\rR\fnextTableIds\"S\n" +
	"\x1eofp_table_feature_prop_actions\x121\n" +
	"\aactions\x18\x01 \x03(\v2\x17.openflow_13.ofp_actionR\aactions\"5\n" +
	"\x1aofp_table_feature_prop_oxm\x12\x17\n" +
	"\aoxm_ids\x18\x03 \x03(\rR\x06oxmIds\"\x91\x01\n" +
	"#ofp_table_feature_prop_experimenter\x12\"\n" +
	"\fexperimenter\x18\x02 \x01(\rR\fexperimenter\x12\x19\n" +
	"\bexp_type\x18\x03 \x01(\rR\aexpType\x12+\n" +
	"\x11experimenter_data\x18\x04 \x03(\rR\x10experimenterData\"\x93\x02\n" +
	"\x12ofp_table_features\x12\x19\n" +
	"\btable_id\x18\x01 \x01(\rR\atableId\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12%\n" +
	"\x0emetadata_match\x18\x03 \x01(\x04R\rmetadataMatch\x12%\n" +
	"\x0emetadata_write\x18\x04 \x01(\x04R\rmetadataWrite\x12\x16\n" +
	"\x06config\x18\x05 \x01(\rR\x06config\x12\x1f\n" +
	"\vmax_entries\x18\x06 \x01(\rR\n" +
	"maxEntries\x12G\n" +
	"\n" +
	"properties\x18\a \x03(\v2'.openflow_13.ofp_table_feature_propertyR\n" +
	"properties\"\x97\x01\n" +
	"\x0fofp_table_stats\x12\x19\n" +
	"\btable_id\x18\x01 \x01(\rR\atableId\x12!\n" +
	"\factive_count\x18\x02 \x01(\rR\vactiveCount\x12!\n" +
	"\flookup_count\x18\x03 \x01(\x04R\vlookupCount\x12#\n" +
	"\rmatched_count\x18\x04 \x01(\x04R\fmatchedCount\"1\n" +
	"\x16ofp_port_stats_request\x12\x17\n" +
	"\aport_no\x18\x01 \x01(\rR\x06portNo\"\xdd\x03\n" +
	"\x0eofp_port_stats\x12\x17\n" +
	"\aport_no\x18\x01 \x01(\rR\x06portNo\x12\x1d\n" +
	"\n" +
	"rx_packets\x18\x02 \x01(\x04R\trxPackets\x12\x1d\n" +
	"\n" +
	"tx_packets\x18\x03 \x01(\x04R\ttxPackets\x12\x19\n" +
	"\brx_bytes\x18\x04 \x01(\x04R\arxBytes\x12\x19\n" +
	"\btx_bytes\x18\x05 \x01(\x04R\atxBytes\x12\x1d\n" +
	"\n" +
	"rx_dropped\x18\x06 \x01(\x04R\trxDropped\x12\x1d\n" +
	"\n" +
	"tx_dropped\x18\a \x01(\x04R\ttxDropped\x12\x1b\n" +
	"\trx_errors\x18\b \x01(\x04R\brxErrors\x12\x1b\n" +
	"\ttx_errors\x18\t \x01(\x04R\btxErrors\x12 \n" +
	"\frx_frame_err\x18\n" +
	" \x01(\x04R\n" +
	"rxFrameErr\x12\x1e\n" +
	"\vrx_over_err\x18\v \x01(\x04R\trxOverErr\x12\x1c\n" +
	"\n" +
	"rx_crc_err\x18\f \x01(\x04R\brxCrcErr\x12\x1e\n" +
	"\n" +
	"collisions\x18\r \x01(\x04R\n" +
	"collisions\x12!\n" +
	"\fduration_sec\x18\x0e \x01(\rR\vdurationSec\x12#\n" +
	"\rduration_nsec\x18\x0f \x01(\rR\fdurationNsec\"4\n" +
	"\x17ofp_group_stats_request\x12\x19\n" +
	"\bgroup_id\x18\x01 \x01(\rR\agroupId\"V\n" +
	"\x12ofp_bucket_counter\x12!\n" +
	"\fpacket_count\x18\x01 \x01(\x04R\vpacketCount\x12\x1d\n" +
	"\n" +
	"byte_count\x18\x02 \x01(\x04R\tbyteCount\"\x97\x02\n" +
	"\x0fofp_group_stats\x12\x19\n" +
	"\bgroup_id\x18\x01 \x01(\rR\agroupId\x12\x1b\n" +
	"\tref_count\x18\x02 \x01(\rR\brefCount\x12!\n" +
	"\fpacket_count\x18\x03 \x01(\x04R\vpacketCount\x12\x1d\n" +
	"\n" +
	"byte_count\x18\x04 \x01(\x04R\tbyteCount\x12!\n" +
	"\fduration_sec\x18\x05 \x01(\rR\vdurationSec\x12#\n" +
	"\rduration_nsec\x18\x06 \x01(\rR\fdurationNsec\x12B\n" +
	"\fbucket_stats\x18\a \x03(\v2\x1f.openflow_13.ofp_bucket_counterR\vbucketStats\"\x8f\x01\n" +
	"\x0eofp_group_desc\x12/\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1b.openflow_13.ofp_group_typeR\x04type\x12\x19\n" +
	"\bgroup_id\x18\x02 \x01(\rR\agroupId\x121\n" +
	"\abuckets\x18\x03 \x03(\v2\x17.openflow_13.ofp_bucketR\abuckets\"v\n" +
	"\x0fofp_group_entry\x12/\n" +
	"\x04desc\x18\x01 \x01(\v2\x1b.openflow_13.ofp_group_descR\x04desc\x122\n" +
	"\x05stats\x18\x02 \x01(\v2\x1c.openflow_13.ofp_group_statsR\x05stats\"\x87\x01\n" +
	"\x12ofp_group_features\x12\x14\n" +
	"\x05types\x18\x01 \x01(\rR\x05types\x12\"\n" +
	"\fcapabilities\x18\x02 \x01(\rR\fcapabilities\x12\x1d\n" +
	"\n" +
	"max_groups\x18\x03 \x03(\rR\tmaxGroups\x12\x18\n" +
	"\aactions\x18\x04 \x03(\rR\aactions\"8\n" +
	"\x1bofp_meter_multipart_request\x12\x19\n" +
	"\bmeter_id\x18\x01 \x01(\rR\ameterId\"j\n" +
	"\x14ofp_meter_band_stats\x12*\n" +
	"\x11packet_band_count\x18\x01 \x01(\x04R\x0fpacketBandCount\x12&\n" +
	"\x0fbyte_band_count\x18\x02 \x01(\x04R\rbyteBandCount\"\xa1\x02\n" +
	"\x0fofp_meter_stats\x12\x19\n" +
	"\bmeter_id\x18\x01 \x01(\rR\ameterId\x12\x1d\n" +
	"\n" +
	"flow_count\x18\x02 \x01(\rR\tflowCount\x12&\n" +
	"\x0fpacket_in_count\x18\x03 \x01(\x04R\rpacketInCount\x12\"\n" +
	"\rbyte_in_count\x18\x04 \x01(\x04R\vbyteInCount\x12!\n" +
	"\fduration_sec\x18\x05 \x01(\rR\vdurationSec\x12#\n" +
	"\rduration_nsec\x18\x06 \x01(\rR\fdurationNsec\x12@\n" +
	"\n" +
	"band_stats\x18\a \x03(\v2!.openflow_13.ofp_meter_band_statsR\tbandStats\"}\n" +
	"\x10ofp_meter_config\x12\x14\n" +
	"\x05flags\x18\x01 \x01(\rR\x05flags\x12\x19\n" +
	"\bmeter_id\x18\x02 \x01(\rR\ameterId\x128\n" +
	"\x05bands\x18\x03 \x03(\v2\".openflow_13.ofp_meter_band_headerR\x05bands\"\xae\x01\n" +
	"\x12ofp_meter_features\x12\x1b\n" +
	"\tmax_meter\x18\x01 \x01(\rR\bmaxMeter\x12\x1d\n" +
	"\n" +
	"band_types\x18\x02 \x01(\rR\tbandTypes\x12\"\n" +
	"\fcapabilities\x18\x03 \x01(\rR\fcapabilities\x12\x1b\n" +
	"\tmax_bands\x18\x04 \x01(\rR\bmaxBands\x12\x1b\n" +
	"\tmax_color\x18\x05 \x01(\rR\bmaxColor\"|\n" +
	"\x0fofp_meter_entry\x125\n" +
	"\x06config\x18\x01 \x01(\v2\x1d.openflow_13.ofp_meter_configR\x06config\x122\n" +
	"\x05stats\x18\x02 \x01(\v2\x1c.openflow_13.ofp_meter_statsR\x05stats\"v\n" +
	"!ofp_experimenter_multipart_header\x12\"\n" +
	"\fexperimenter\x18\x01 \x01(\rR\fexperimenter\x12\x19\n" +
	"\bexp_type\x18\x02 \x01(\rR\aexpType\x12\x12\n" +
	"\x04data\x18\x03 \x01(\fR\x04data\"l\n" +
	"\x17ofp_experimenter_header\x12\"\n" +
	"\fexperimenter\x18\x01 \x01(\rR\fexperimenter\x12\x19\n" +
	"\bexp_type\x18\x02 \x01(\rR\aexpType\x12\x12\n" +
	"\x04data\x18\x03 \x01(\fR\x04data\"E\n" +
	"\x15ofp_queue_prop_header\x12\x1a\n" +
	"\bproperty\x18\x01 \x01(\rR\bproperty\x12\x10\n" +
	"\x03len\x18\x02 \x01(\rR\x03len\"r\n" +
	"\x17ofp_queue_prop_min_rate\x12C\n" +
	"\vprop_header\x18\x01 \x01(\v2\".openflow_13.ofp_queue_prop_headerR\n" +
	"propHeader\x12\x12\n" +
	"\x04rate\x18\x02 \x01(\rR\x04rate\"r\n" +
	"\x17ofp_queue_prop_max_rate\x12C\n" +
	"\vprop_header\x18\x01 \x01(\v2\".openflow_13.ofp_queue_prop_headerR\n" +
	"propHeader\x12\x12\n" +
	"\x04rate\x18\x02 \x01(\rR\x04rate\"\x9a\x01\n" +
	"\x1bofp_queue_prop_experimenter\x12C\n" +
	"\vprop_header\x18\x01 \x01(\v2\".openflow_13.ofp_queue_prop_headerR\n" +
	"propHeader\x12\"\n" +
	"\fexperimenter\x18\x02 \x01(\rR\fexperimenter\x12\x12\n" +
	"\x04data\x18\x03 \x01(\fR\x04data\"\x85\x01\n" +
	"\x10ofp_packet_queue\x12\x19\n" +
	"\bqueue_id\x18\x01 \x01(\rR\aqueueId\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12B\n" +
	"\n" +
	"properties\x18\x04 \x03(\v2\".openflow_13.ofp_queue_prop_headerR\n" +
	"properties\"2\n" +
	"\x1cofp_queue_get_config_request\x12\x12\n" +
	"\x04port\x18\x01 \x01(\rR\x04port\"g\n" +
	"\x1aofp_queue_get_config_reply\x12\x12\n" +
	"\x04port\x18\x01 \x01(\rR\x04port\x125\n" +
	"\x06queues\x18\x02 \x03(\v2\x1d.openflow_13.ofp_packet_queueR\x06queues\"E\n" +
	"\x14ofp_action_set_queue\x12\x12\n" +
	"\x04type\x18\x01 \x01(\rR\x04type\x12\x19\n" +
	"\bqueue_id\x18\x03 \x01(\rR\aqueueId\"M\n" +
	"\x17ofp_queue_stats_request\x12\x17\n" +
	"\aport_no\x18\x01 \x01(\rR\x06portNo\x12\x19\n" +
	"\bqueue_id\x18\x02 \x01(\rR\aqueueId\"\xe4\x01\n" +
	"\x0fofp_queue_stats\x12\x17\n" +
	"\aport_no\x18\x01 \x01(\rR\x06portNo\x12\x19\n" +
	"\bqueue_id\x18\x02 \x01(\rR\aqueueId\x12\x19\n" +
	"\btx_bytes\x18\x03 \x01(\x04R\atxBytes\x12\x1d\n" +
	"\n" +
	"tx_packets\x18\x04 \x01(\x04R\ttxPackets\x12\x1b\n" +
	"\ttx_errors\x18\x05 \x01(\x04R\btxErrors\x12!\n" +
	"\fduration_sec\x18\x06 \x01(\rR\vdurationSec\x12#\n" +
	"\rduration_nsec\x18\a \x01(\rR\fdurationNsec\"m\n" +
	"\x10ofp_role_request\x124\n" +
	"\x04role\x18\x01 \x01(\x0e2 .openflow_13.ofp_controller_roleR\x04role\x12#\n" +
	"\rgeneration_id\x18\x02 \x01(\x04R\fgenerationId\"\x8e\x01\n" +
	"\x10ofp_async_config\x12$\n" +
	"\x0epacket_in_mask\x18\x01 \x03(\rR\fpacketInMask\x12(\n" +
	"\x10port_status_mask\x18\x02 \x03(\rR\x0eportStatusMask\x12*\n" +
	"\x11flow_removed_mask\x18\x03 \x03(\rR\x0fflowRemovedMask\"k\n" +
	"\x0eMeterModUpdate\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x127\n" +
	"\tmeter_mod\x18\x02 \x01(\v2\x1a.openflow_13.ofp_meter_modR\bmeterMod\x12\x10\n" +
	"\x03xid\x18\x03 \x01(\rR\x03xid\"P\n" +
	"\x0fMeterStatsReply\x12=\n" +
	"\vmeter_stats\x18\x01 \x03(\v2\x1c.openflow_13.ofp_meter_statsR\n" +
	"meterStats\"i\n" +
	"\x0fFlowTableUpdate\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x124\n" +
	"\bflow_mod\x18\x02 \x01(\v2\x19.openflow_13.ofp_flow_modR\aflowMod\x12\x10\n" +
	"\x03xid\x18\x03 \x01(\rR\x03xid\"q\n" +
	"\x14FlowGroupTableUpdate\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x127\n" +
	"\tgroup_mod\x18\x02 \x01(\v2\x1a.openflow_13.ofp_group_modR\bgroupMod\x12\x10\n" +
	"\x03xid\x18\x03 \x01(\rR\x03xid\":\n" +
	"\x05Flows\x121\n" +
	"\x05items\x18\x01 \x03(\v2\x1b.openflow_13.ofp_flow_statsR\x05items\"<\n" +
	"\x06Meters\x122\n" +
	"\x05items\x18\x01 \x03(\v2\x1c.openflow_13.ofp_meter_entryR\x05items\"@\n" +
	"\n" +
	"FlowGroups\x122\n" +
	"\x05items\x18\x01 \x03(\v2\x1c.openflow_13.ofp_group_entryR\x05items\"i\n" +
	"\vFlowChanges\x12)\n" +
	"\x06to_add\x18\x01 \x01(\v2\x12.openflow_13.FlowsR\x05toAdd\x12/\n" +
	"\tto_remove\x18\x02 \x01(\v2\x12.openflow_13.FlowsR\btoRemove\"\xae\x01\n" +
	"\x10FlowGroupChanges\x12.\n" +
	"\x06to_add\x18\x01 \x01(\v2\x17.openflow_13.FlowGroupsR\x05toAdd\x124\n" +
	"\tto_remove\x18\x02 \x01(\v2\x17.openflow_13.FlowGroupsR\btoRemove\x124\n" +
	"\tto_update\x18\x03 \x01(\v2\x17.openflow_13.FlowGroupsR\btoUpdate\"S\n" +
	"\bPacketIn\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x127\n" +
	"\tpacket_in\x18\x02 \x01(\v2\x1a.openflow_13.ofp_packet_inR\bpacketIn\"W\n" +
	"\tPacketOut\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12:\n" +
	"\n" +
	"packet_out\x18\x02 \x01(\v2\x1b.openflow_13.ofp_packet_outR\tpacketOut\"\xe2\x01\n" +
	"\vChangeEvent\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12?\n" +
	"\vport_status\x18\x02 \x01(\v2\x1c.openflow_13.ofp_port_statusH\x00R\n" +
	"portStatus\x122\n" +
	"\x05error\x18\x03 \x01(\v2\x1a.openflow_13.ofp_error_msgH\x00R\x05error\x12E\n" +
	"\rdevice_status\x18\x04 \x01(\v2\x1e.openflow_13.ofp_device_statusH\x00R\fdeviceStatusB\a\n" +
	"\x05event\"E\n" +
	"\fFlowMetadata\x125\n" +
	"\x06meters\x18\x01 \x03(\v2\x1d.openflow_13.ofp_meter_configR\x06meters*\xd5\x01\n" +
	"\vofp_port_no\x12\x10\n" +
	"\fOFPP_INVALID\x10\x00\x12\x10\n" +
	"\bOFPP_MAX\x10\x80\xfe\xff\xff\a\x12\x14\n" +
	"\fOFPP_IN_PORT\x10\xf8\xff\xff\xff\a\x12\x12\n" +
	"\n" +
	"OFPP_TABLE\x10\xf9\xff\xff\xff\a\x12\x13\n" +
	"\vOFPP_NORMAL\x10\xfa\xff\xff\xff\a\x12\x12\n" +
	"\n" +
	"OFPP_FLOOD\x10\xfb\xff\xff\xff\a\x12\x10\n" +
	"\bOFPP_ALL\x10\xfc\xff\xff\xff\a\x12\x17\n" +
	"\x0fOFPP_CONTROLLER\x10\xfd\xff\xff\xff\a\x12\x12\n" +
	"\n" +
	"OFPP_LOCAL\x10\xfe\xff\xff\xff\a\x12\x10\n" +
	"\bOFPP_ANY\x10\xff\xff\xff\xff\a*\xc8\x05\n" +
	"\bofp_type\x12\x0e\n" +
	"\n" +
	"OFPT_HELLO\x10\x00\x12\x0e\n" +
	"\n" +
	"OFPT_ERROR\x10\x01\x12\x15\n" +
	"\x11OFPT_ECHO_REQUEST\x10\x02\x12\x13\n" +
	"\x0fOFPT_ECHO_REPLY\x10\x03\x12\x15\n" +
	"\x11OFPT_EXPERIMENTER\x10\x04\x12\x19\n" +
	"\x15OFPT_FEATURES_REQUEST\x10\x05\x12\x17\n" +
	"\x13OFPT_FEATURES_REPLY\x10\x06\x12\x1b\n" +
	"\x17OFPT_GET_CONFIG_REQUEST\x10\a\x12\x19\n" +
	"\x15OFPT_GET_CONFIG_REPLY\x10\b\x12\x13\n" +
	"\x0fOFPT_SET_CONFIG\x10\t\x12\x12\n" +
	"\x0eOFPT_PACKET_IN\x10\n" +
	"\x12\x15\n" +
	"\x11OFPT_FLOW_REMOVED\x10\v\x12\x14\n" +
	"\x10OFPT_PORT_STATUS\x10\f\x12\x13\n" +
	"\x0fOFPT_PACKET_OUT\x10\r\x12\x11\n" +
	"\rOFPT_FLOW_MOD\x10\x0e\x12\x12\n" +
	"\x0eOFPT_GROUP_MOD\x10\x0f\x12\x11\n" +
	"\rOFPT_PORT_MOD\x10\x10\x12\x12\n" +
	"\x0eOFPT_TABLE_MOD\x10\x11\x12\x1a\n" +
	"\x16OFPT_MULTIPART_REQUEST\x10\x12\x12\x18\n" +
	"\x14OFPT_MULTIPART_REPLY\x10\x13\x12\x18\n" +
	"\x14OFPT_BARRIER_REQUEST\x10\x14\x12\x16\n" +
	"\x12OFPT_BARRIER_REPLY\x10\x15\x12!\n" +
	"\x1dOFPT_QUEUE_GET_CONFIG_REQUEST\x10\x16\x12\x1f\n" +
	"\x1bOFPT_QUEUE_GET_CONFIG_REPLY\x10\x17\x12\x15\n" +
	"\x11OFPT_ROLE_REQUEST\x10\x18\x12\x13\n" +
	"\x0fOFPT_ROLE_REPLY\x10\x19\x12\x1a\n" +
	"\x16OFPT_GET_ASYNC_REQUEST\x10\x1a\x12\x18\n" +
	"\x14OFPT_GET_ASYNC_REPLY\x10\x1b\x12\x12\n" +
	"\x0eOFPT_SET_ASYNC\x10\x1c\x12\x12\n" +
	"\x0eOFPT_METER_MOD\x10\x1d*C\n" +
	"\x13ofp_hello_elem_type\x12\x12\n" +
	"\x0eOFPHET_INVALID\x10\x00\x12\x18\n" +
	"\x14OFPHET_VERSIONBITMAP\x10\x01*e\n" +
	"\x10ofp_config_flags\x12\x14\n" +
	"\x10OFPC_FRAG_NORMAL\x10\x00\x12\x12\n" +
	"\x0eOFPC_FRAG_DROP\x10\x01\x12\x13\n" +
	"\x0fOFPC_FRAG_REASM\x10\x02\x12\x12\n" +
	"\x0eOFPC_FRAG_MASK\x10\x03*@\n" +
	"\x10ofp_table_config\x12\x11\n" +
	"\rOFPTC_INVALID\x10\x00\x12\x19\n" +
	"\x15OFPTC_DEPRECATED_MASK\x10\x03*>\n" +
	"\tofp_table\x12\x11\n" +
	"\rOFPTT_INVALID\x10\x00\x12\x0e\n" +
	"\tOFPTT_MAX\x10\xfe\x01\x12\x0e\n" +
	"\tOFPTT_ALL\x10\xff\x01*\xbb\x01\n" +
	"\x10ofp_capabilities\x12\x10\n" +
	"\fOFPC_INVALID\x10\x00\x12\x13\n" +
	"\x0fOFPC_FLOW_STATS\x10\x01\x12\x14\n" +
	"\x10OFPC_TABLE_STATS\x10\x02\x12\x13\n" +
	"\x0fOFPC_PORT_STATS\x10\x04\x12\x14\n" +
	"\x10OFPC_GROUP_STATS\x10\b\x12\x11\n" +
	"\rOFPC_IP_REASM\x10 \x12\x14\n" +
	"\x10OFPC_QUEUE_STATS\x10@\x12\x16\n" +
	"\x11OFPC_PORT_BLOCKED\x10\x80\x02*v\n" +
	"\x0fofp_port_config\x12\x11\n" +
	"\rOFPPC_INVALID\x10\x00\x12\x13\n" +
	"\x0fOFPPC_PORT_DOWN\x10\x01\x12\x11\n" +
	"\rOFPPC_NO_RECV\x10\x04\x12\x10\n" +
	"\fOFPPC_NO_FWD\x10 \x12\x16\n" +
	"\x12OFPPC_NO_PACKET_IN\x10@*[\n" +
	"\x0eofp_port_state\x12\x11\n" +
	"\rOFPPS_INVALID\x10\x00\x12\x13\n" +
	"\x0fOFPPS_LINK_DOWN\x10\x01\x12\x11\n" +
	"\rOFPPS_BLOCKED\x10\x02\x12\x0e\n" +
	"\n" +
	"OFPPS_LIVE\x10\x04*\xdd\x02\n" +
	"\x11ofp_port_features\x12\x11\n" +
	"\rOFPPF_INVALID\x10\x00\x12\x11\n" +
	"\rOFPPF_10MB_HD\x10\x01\x12\x11\n" +
	"\rOFPPF_10MB_FD\x10\x02\x12\x12\n" +
	"\x0eOFPPF_100MB_HD\x10\x04\x12\x12\n" +
	"\x0eOFPPF_100MB_FD\x10\b\x12\x10\n" +
	"\fOFPPF_1GB_HD\x10\x10\x12\x10\n" +
	"\fOFPPF_1GB_FD\x10 \x12\x11\n" +
	"\rOFPPF_10GB_FD\x10@\x12\x12\n" +
	"\rOFPPF_40GB_FD\x10\x80\x01\x12\x13\n" +
	"\x0eOFPPF_100GB_FD\x10\x80\x02\x12\x11\n" +
	"\fOFPPF_1TB_FD\x10\x80\x04\x12\x10\n" +
	"\vOFPPF_OTHER\x10\x80\b\x12\x11\n" +
	"\fOFPPF_COPPER\x10\x80\x10\x12\x10\n" +
	"\vOFPPF_FIBER\x10\x80 \x12\x12\n" +
	"\rOFPPF_AUTONEG\x10\x80@\x12\x11\n" +
	"\vOFPPF_PAUSE\x10\x80\x80\x01\x12\x16\n" +
	"\x10OFPPF_PAUSE_ASYM\x10\x80\x80\x02*D\n" +
	"\x0fofp_port_reason\x12\r\n" +
	"\tOFPPR_ADD\x10\x00\x12\x10\n" +
	"\fOFPPR_DELETE\x10\x01\x12\x10\n" +
	"\fOFPPR_MODIFY\x10\x02*F\n" +
	"\x15ofp_device_connection\x12\x14\n" +
	"\x10OFPDEV_CONNECTED\x10\x00\x12\x17\n" +
	"\x13OFPDEV_DISCONNECTED\x10\x01*3\n" +
	"\x0eofp_match_type\x12\x12\n" +
	"\x0eOFPMT_STANDARD\x10\x00\x12\r\n" +
	"\tOFPMT_OXM\x10\x01*k\n" +
	"\rofp_oxm_class\x12\x10\n" +
	"\fOFPXMC_NXM_0\x10\x00\x12\x10\n" +
	"\fOFPXMC_NXM_1\x10\x01\x12\x1b\n" +
	"\x15OFPXMC_OPENFLOW_BASIC\x10\x80\x80\x02\x12\x19\n" +
	"\x13OFPXMC_EXPERIMENTER\x10\xff\xff\x03*\x90\b\n" +
	"\x13oxm_ofb_field_types\x12\x16\n" +
	"\x12OFPXMT_OFB_IN_PORT\x10\x00\x12\x1a\n" +
	"\x16OFPXMT_OFB_IN_PHY_PORT\x10\x01\x12\x17\n" +
	"\x13OFPXMT_OFB_METADATA\x10\x02\x12\x16\n" +
	"\x12OFPXMT_OFB_ETH_DST\x10\x03\x12\x16\n" +
	"\x12OFPXMT_OFB_ETH_SRC\x10\x04\x12\x17\n" +
	"\x13OFPXMT_OFB_ETH_TYPE\x10\x05\x12\x17\n" +
	"\x13OFPXMT_OFB_VLAN_VID\x10\x06\x12\x17\n" +
	"\x13OFPXMT_OFB_VLAN_PCP\x10\a\x12\x16\n" +
	"\x12OFPXMT_OFB_IP_DSCP\x10\b\x12\x15\n" +
	"\x11OFPXMT_OFB_IP_ECN\x10\t\x12\x17\n" +
	"\x13OFPXMT_OFB_IP_PROTO\x10\n" +
	"\x12\x17\n" +
	"\x13OFPXMT_OFB_IPV4_SRC\x10\v\x12\x17\n" +
	"\x13OFPXMT_OFB_IPV4_DST\x10\f\x12\x16\n" +
	"\x12OFPXMT_OFB_TCP_SRC\x10\r\x12\x16\n" +
	"\x12OFPXMT_OFB_TCP_DST\x10\x0e\x12\x16\n" +
	"\x12OFPXMT_OFB_UDP_SRC\x10\x0f\x12\x16\n" +
	"\x12OFPXMT_OFB_UDP_DST\x10\x10\x12\x17\n" +
	"\x13OFPXMT_OFB_SCTP_SRC\x10\x11\x12\x17\n" +
	"\x13OFPXMT_OFB_SCTP_DST\x10\x12\x12\x1a\n" +
	"\x16OFPXMT_OFB_ICMPV4_TYPE\x10\x13\x12\x1a\n" +
	"\x16OFPXMT_OFB_ICMPV4_CODE\x10\x14\x12\x15\n" +
	"\x11OFPXMT_OFB_ARP_OP\x10\x15\x12\x16\n" +
	"\x12OFPXMT_OFB_ARP_SPA\x10\x16\x12\x16\n" +
	"\x12OFPXMT_OFB_ARP_TPA\x10\x17\x12\x16\n" +
	"\x12OFPXMT_OFB_ARP_SHA\x10\x18\x12\x16\n" +
	"\x12OFPXMT_OFB_ARP_THA\x10\x19\x12\x17\n" +
	"\x13OFPXMT_OFB_IPV6_SRC\x10\x1a\x12\x17\n" +
	"\x13OFPXMT_OFB_IPV6_DST\x10\x1b\x12\x1a\n" +
	"\x16OFPXMT_OFB_IPV6_FLABEL\x10\x1c\x12\x1a\n" +
	"\x16OFPXMT_OFB_ICMPV6_TYPE\x10\x1d\x12\x1a\n" +
	"\x16OFPXMT_OFB_ICMPV6_CODE\x10\x1e\x12\x1d\n" +
	"\x19OFPXMT_OFB_IPV6_ND_TARGET\x10\x1f\x12\x1a\n" +
	"\x16OFPXMT_OFB_IPV6_ND_SLL\x10 \x12\x1a\n" +
	"\x16OFPXMT_OFB_IPV6_ND_TLL\x10!\x12\x19\n" +
	"\x15OFPXMT_OFB_MPLS_LABEL\x10\"\x12\x16\n" +
	"\x12OFPXMT_OFB_MPLS_TC\x10#\x12\x17\n" +
	"\x13OFPXMT_OFB_MPLS_BOS\x10$\x12\x17\n" +
	"\x13OFPXMT_OFB_PBB_ISID\x10%\x12\x18\n" +
	"\x14OFPXMT_OFB_TUNNEL_ID\x10&\x12\x1a\n" +
	"\x16OFPXMT_OFB_IPV6_EXTHDR\x10'*3\n" +
	"\vofp_vlan_id\x12\x0f\n" +
	"\vOFPVID_NONE\x10\x00\x12\x13\n" +
	"\x0eOFPVID_PRESENT\x10\x80 *\xc9\x01\n" +
	"\x14ofp_ipv6exthdr_flags\x12\x12\n" +
	"\x0eOFPIEH_INVALID\x10\x00\x12\x11\n" +
	"\rOFPIEH_NONEXT\x10\x01\x12\x0e\n" +
	"\n" +
	"OFPIEH_ESP\x10\x02\x12\x0f\n" +
	"\vOFPIEH_AUTH\x10\x04\x12\x0f\n" +
	"\vOFPIEH_DEST\x10\b\x12\x0f\n" +
	"\vOFPIEH_FRAG\x10\x10\x12\x11\n" +
	"\rOFPIEH_ROUTER\x10 \x12\x0e\n" +
	"\n" +
	"OFPIEH_HOP\x10@\x12\x11\n" +
	"\fOFPIEH_UNREP\x10\x80\x01\x12\x11\n" +
	"\fOFPIEH_UNSEQ\x10\x80\x02*\xfc\x02\n" +
	"\x0fofp_action_type\x12\x10\n" +
	"\fOFPAT_OUTPUT\x10\x00\x12\x16\n" +
	"\x12OFPAT_COPY_TTL_OUT\x10\v\x12\x15\n" +
	"\x11OFPAT_COPY_TTL_IN\x10\f\x12\x16\n" +
	"\x12OFPAT_SET_MPLS_TTL\x10\x0f\x12\x16\n" +
	"\x12OFPAT_DEC_MPLS_TTL\x10\x10\x12\x13\n" +
	"\x0fOFPAT_PUSH_VLAN\x10\x11\x12\x12\n" +
	"\x0eOFPAT_POP_VLAN\x10\x12\x12\x13\n" +
	"\x0fOFPAT_PUSH_MPLS\x10\x13\x12\x12\n" +
	"\x0eOFPAT_POP_MPLS\x10\x14\x12\x13\n" +
	"\x0fOFPAT_SET_QUEUE\x10\x15\x12\x0f\n" +
	"\vOFPAT_GROUP\x10\x16\x12\x14\n" +
	"\x10OFPAT_SET_NW_TTL\x10\x17\x12\x14\n" +
	"\x10OFPAT_DEC_NW_TTL\x10\x18\x12\x13\n" +
	"\x0fOFPAT_SET_FIELD\x10\x19\x12\x12\n" +
	"\x0eOFPAT_PUSH_PBB\x10\x1a\x12\x11\n" +
	"\rOFPAT_POP_PBB\x10\x1b\x12\x18\n" +
	"\x12OFPAT_EXPERIMENTER\x10\xff\xff\x03*V\n" +
	"\x16ofp_controller_max_len\x12\x12\n" +
	"\x0eOFPCML_INVALID\x10\x00\x12\x10\n" +
	"\n" +
	"OFPCML_MAX\x10\xe5\xff\x03\x12\x16\n" +
	"\x10OFPCML_NO_BUFFER\x10\xff\xff\x03*\xcf\x01\n" +
	"\x14ofp_instruction_type\x12\x11\n" +
	"\rOFPIT_INVALID\x10\x00\x12\x14\n" +
	"\x10OFPIT_GOTO_TABLE\x10\x01\x12\x18\n" +
	"\x14OFPIT_WRITE_METADATA\x10\x02\x12\x17\n" +
	"\x13OFPIT_WRITE_ACTIONS\x10\x03\x12\x17\n" +
	"\x13OFPIT_APPLY_ACTIONS\x10\x04\x12\x17\n" +
	"\x13OFPIT_CLEAR_ACTIONS\x10\x05\x12\x0f\n" +
	"\vOFPIT_METER\x10\x06\x12\x18\n" +
	"\x12OFPIT_EXPERIMENTER\x10\xff\xff\x03*{\n" +
	"\x14ofp_flow_mod_command\x12\r\n" +
	"\tOFPFC_ADD\x10\x00\x12\x10\n" +
	"\fOFPFC_MODIFY\x10\x01\x12\x17\n" +
	"\x13OFPFC_MODIFY_STRICT\x10\x02\x12\x10\n" +
	"\fOFPFC_DELETE\x10\x03\x12\x17\n" +
	"\x13OFPFC_DELETE_STRICT\x10\x04*\xa3\x01\n" +
	"\x12ofp_flow_mod_flags\x12\x11\n" +
	"\rOFPFF_INVALID\x10\x00\x12\x17\n" +
	"\x13OFPFF_SEND_FLOW_REM\x10\x01\x12\x17\n" +
	"\x13OFPFF_CHECK_OVERLAP\x10\x02\x12\x16\n" +
	"\x12OFPFF_RESET_COUNTS\x10\x04\x12\x17\n" +
	"\x13OFPFF_NO_PKT_COUNTS\x10\b\x12\x17\n" +
	"\x13OFPFF_NO_BYT_COUNTS\x10\x10*S\n" +
	"\tofp_group\x12\x10\n" +
	"\fOFPG_INVALID\x10\x00\x12\x10\n" +
	"\bOFPG_MAX\x10\x80\xfe\xff\xff\a\x12\x10\n" +
	"\bOFPG_ALL\x10\xfc\xff\xff\xff\a\x12\x10\n" +
	"\bOFPG_ANY\x10\xff\xff\xff\xff\a*J\n" +
	"\x15ofp_group_mod_command\x12\r\n" +
	"\tOFPGC_ADD\x10\x00\x12\x10\n" +
	"\fOFPGC_MODIFY\x10\x01\x12\x10\n" +
	"\fOFPGC_DELETE\x10\x02*S\n" +
	"\x0eofp_group_type\x12\r\n" +
	"\tOFPGT_ALL\x10\x00\x12\x10\n" +
	"\fOFPGT_SELECT\x10\x01\x12\x12\n" +
	"\x0eOFPGT_INDIRECT\x10\x02\x12\f\n" +
	"\bOFPGT_FF\x10\x03*P\n" +
	"\x14ofp_packet_in_reason\x12\x11\n" +
	"\rOFPR_NO_MATCH\x10\x00\x12\x0f\n" +
	"\vOFPR_ACTION\x10\x01\x12\x14\n" +
	"\x10OFPR_INVALID_TTL\x10\x02*\x8b\x01\n" +
	"\x17ofp_flow_removed_reason\x12\x16\n" +
	"\x12OFPRR_IDLE_TIMEOUT\x10\x00\x12\x16\n" +
	"\x12OFPRR_HARD_TIMEOUT\x10\x01\x12\x10\n" +
	"\fOFPRR_DELETE\x10\x02\x12\x16\n" +
	"\x12OFPRR_GROUP_DELETE\x10\x03\x12\x16\n" +
	"\x12OFPRR_METER_DELETE\x10\x04*n\n" +
	"\tofp_meter\x12\r\n" +
	"\tOFPM_ZERO\x10\x00\x12\x10\n" +
	"\bOFPM_MAX\x10\x80\x80\xfc\xff\a\x12\x15\n" +
	"\rOFPM_SLOWPATH\x10\xfd\xff\xff\xff\a\x12\x17\n" +
	"\x0fOFPM_CONTROLLER\x10\xfe\xff\xff\xff\a\x12\x10\n" +
	"\bOFPM_ALL\x10\xff\xff\xff\xff\a*m\n" +
	"\x13ofp_meter_band_type\x12\x12\n" +
	"\x0eOFPMBT_INVALID\x10\x00\x12\x0f\n" +
	"\vOFPMBT_DROP\x10\x01\x12\x16\n" +
	"\x12OFPMBT_DSCP_REMARK\x10\x02\x12\x19\n" +
	"\x13OFPMBT_EXPERIMENTER\x10\xff\xff\x03*J\n" +
	"\x15ofp_meter_mod_command\x12\r\n" +
	"\tOFPMC_ADD\x10\x00\x12\x10\n" +
	"\fOFPMC_MODIFY\x10\x01\x12\x10\n" +
	"\fOFPMC_DELETE\x10\x02*g\n" +
	"\x0fofp_meter_flags\x12\x11\n" +
	"\rOFPMF_INVALID\x10\x00\x12\x0e\n" +
	"\n" +
	"OFPMF_KBPS\x10\x01\x12\x0f\n" +
	"\vOFPMF_PKTPS\x10\x02\x12\x0f\n" +
	"\vOFPMF_BURST\x10\x04\x12\x0f\n" +
	"\vOFPMF_STATS\x10\b*\xa4\x03\n" +
	"\x0eofp_error_type\x12\x16\n" +
	"\x12OFPET_HELLO_FAILED\x10\x00\x12\x15\n" +
	"\x11OFPET_BAD_REQUEST\x10\x01\x12\x14\n" +
	"\x10OFPET_BAD_ACTION\x10\x02\x12\x19\n" +
	"\x15OFPET_BAD_INSTRUCTION\x10\x03\x12\x13\n" +
	"\x0fOFPET_BAD_MATCH\x10\x04\x12\x19\n" +
	"\x15OFPET_FLOW_MOD_FAILED\x10\x05\x12\x1a\n" +
	"\x16OFPET_GROUP_MOD_FAILED\x10\x06\x12\x19\n" +
	"\x15OFPET_PORT_MOD_FAILED\x10\a\x12\x1a\n" +
	"\x16OFPET_TABLE_MOD_FAILED\x10\b\x12\x19\n" +
	"\x15OFPET_QUEUE_OP_FAILED\x10\t\x12\x1e\n" +
	"\x1aOFPET_SWITCH_CONFIG_FAILED\x10\n" +
	"\x12\x1d\n" +
	"\x19OFPET_ROLE_REQUEST_FAILED\x10\v\x12\x1a\n" +
	"\x16OFPET_METER_MOD_FAILED\x10\f\x12\x1f\n" +
	"\x1bOFPET_TABLE_FEATURES_FAILED\x10\r\x12\x18\n" +
	"\x12OFPET_EXPERIMENTER\x10\xff\xff\x03*B\n" +
	"\x15ofp_hello_failed_code\x12\x17\n" +
	"\x13OFPHFC_INCOMPATIBLE\x10\x00\x12\x10\n" +
	"\fOFPHFC_EPERM\x10\x01*\xed\x02\n" +
	"\x14ofp_bad_request_code\x12\x16\n" +
	"\x12OFPBRC_BAD_VERSION\x10\x00\x12\x13\n" +
	"\x0fOFPBRC_BAD_TYPE\x10\x01\x12\x18\n" +
	"\x14OFPBRC_BAD_MULTIPART\x10\x02\x12\x1b\n" +
	"\x17OFPBRC_BAD_EXPERIMENTER\x10\x03\x12\x17\n" +
	"\x13OFPBRC_BAD_EXP_TYPE\x10\x04\x12\x10\n" +
	"\fOFPBRC_EPERM\x10\x05\x12\x12\n" +
	"\x0eOFPBRC_BAD_LEN\x10\x06\x12\x17\n" +
	"\x13OFPBRC_BUFFER_EMPTY\x10\a\x12\x19\n" +
	"\x15OFPBRC_BUFFER_UNKNOWN\x10\b\x12\x17\n" +
	"\x13OFPBRC_BAD_TABLE_ID\x10\t\x12\x13\n" +
	"\x0fOFPBRC_IS_SLAVE\x10\n" +
	"\x12\x13\n" +
	"\x0fOFPBRC_BAD_PORT\x10\v\x12\x15\n" +
	"\x11OFPBRC_BAD_PACKET\x10\f\x12$\n" +
	" OFPBRC_MULTIPART_BUFFER_OVERFLOW\x10\r*\x9c\x03\n" +
	"\x13ofp_bad_action_code\x12\x13\n" +
	"\x0fOFPBAC_BAD_TYPE\x10\x00\x12\x12\n" +
	"\x0eOFPBAC_BAD_LEN\x10\x01\x12\x1b\n" +
	"\x17OFPBAC_BAD_EXPERIMENTER\x10\x02\x12\x17\n" +
	"\x13OFPBAC_BAD_EXP_TYPE\x10\x03\x12\x17\n" +
	"\x13OFPBAC_BAD_OUT_PORT\x10\x04\x12\x17\n" +
	"\x13OFPBAC_BAD_ARGUMENT\x10\x05\x12\x10\n" +
	"\fOFPBAC_EPERM\x10\x06\x12\x13\n" +
	"\x0fOFPBAC_TOO_MANY\x10\a\x12\x14\n" +
	"\x10OFPBAC_BAD_QUEUE\x10\b\x12\x18\n" +
	"\x14OFPBAC_BAD_OUT_GROUP\x10\t\x12\x1d\n" +
	"\x19OFPBAC_MATCH_INCONSISTENT\x10\n" +
	"\x12\x1c\n" +
	"\x18OFPBAC_UNSUPPORTED_ORDER\x10\v\x12\x12\n" +
	"\x0eOFPBAC_BAD_TAG\x10\f\x12\x17\n" +
	"\x13OFPBAC_BAD_SET_TYPE\x10\r\x12\x16\n" +
	"\x12OFPBAC_BAD_SET_LEN\x10\x0e\x12\x1b\n" +
	"\x17OFPBAC_BAD_SET_ARGUMENT\x10\x0f*\xfa\x01\n" +
	"\x18ofp_bad_instruction_code\x12\x17\n" +
	"\x13OFPBIC_UNKNOWN_INST\x10\x00\x12\x15\n" +
	"\x11OFPBIC_UNSUP_INST\x10\x01\x12\x17\n" +
	"\x13OFPBIC_BAD_TABLE_ID\x10\x02\x12\x19\n" +
	"\x15OFPBIC_UNSUP_METADATA\x10\x03\x12\x1e\n" +
	"\x1aOFPBIC_UNSUP_METADATA_MASK\x10\x04\x12\x1b\n" +
	"\x17OFPBIC_BAD_EXPERIMENTER\x10\x05\x12\x17\n" +
	"\x13OFPBIC_BAD_EXP_TYPE\x10\x06\x12\x12\n" +
	"\x0eOFPBIC_BAD_LEN\x10\a\x12\x10\n" +
	"\fOFPBIC_EPERM\x10\b*\xa5\x02\n" +
	"\x12ofp_bad_match_code\x12\x13\n" +
	"\x0fOFPBMC_BAD_TYPE\x10\x00\x12\x12\n" +
	"\x0eOFPBMC_BAD_LEN\x10\x01\x12\x12\n" +
	"\x0eOFPBMC_BAD_TAG\x10\x02\x12\x1b\n" +
	"\x17OFPBMC_BAD_DL_ADDR_MASK\x10\x03\x12\x1b\n" +
	"\x17OFPBMC_BAD_NW_ADDR_MASK\x10\x04\x12\x18\n" +
	"\x14OFPBMC_BAD_WILDCARDS\x10\x05\x12\x14\n" +
	"\x10OFPBMC_BAD_FIELD\x10\x06\x12\x14\n" +
	"\x10OFPBMC_BAD_VALUE\x10\a\x12\x13\n" +
	"\x0fOFPBMC_BAD_MASK\x10\b\x12\x15\n" +
	"\x11OFPBMC_BAD_PREREQ\x10\t\x12\x14\n" +
	"\x10OFPBMC_DUP_FIELD\x10\n" +
	"\x12\x10\n" +
	"\fOFPBMC_EPERM\x10\v*\xd2\x01\n" +
	"\x18ofp_flow_mod_failed_code\x12\x13\n" +
	"\x0fOFPFMFC_UNKNOWN\x10\x00\x12\x16\n" +
	"\x12OFPFMFC_TABLE_FULL\x10\x01\x12\x18\n" +
	"\x14OFPFMFC_BAD_TABLE_ID\x10\x02\x12\x13\n" +
	"\x0fOFPFMFC_OVERLAP\x10\x03\x12\x11\n" +
	"\rOFPFMFC_EPERM\x10\x04\x12\x17\n" +
	"\x13OFPFMFC_BAD_TIMEOUT\x10\x05\x12\x17\n" +
	"\x13OFPFMFC_BAD_COMMAND\x10\x06\x12\x15\n" +
	"\x11OFPFMFC_BAD_FLAGS\x10\a*\xa1\x03\n" +
	"\x19ofp_group_mod_failed_code\x12\x18\n" +
	"\x14OFPGMFC_GROUP_EXISTS\x10\x00\x12\x19\n" +
	"\x15OFPGMFC_INVALID_GROUP\x10\x01\x12\x1e\n" +
	"\x1aOFPGMFC_WEIGHT_UNSUPPORTED\x10\x02\x12\x19\n" +
	"\x15OFPGMFC_OUT_OF_GROUPS\x10\x03\x12\x1a\n" +
	"\x16OFPGMFC_OUT_OF_BUCKETS\x10\x04\x12 \n" +
	"\x1cOFPGMFC_CHAINING_UNSUPPORTED\x10\x05\x12\x1d\n" +
	"\x19OFPGMFC_WATCH_UNSUPPORTED\x10\x06\x12\x10\n" +
	"\fOFPGMFC_LOOP\x10\a\x12\x19\n" +
	"\x15OFPGMFC_UNKNOWN_GROUP\x10\b\x12\x19\n" +
	"\x15OFPGMFC_CHAINED_GROUP\x10\t\x12\x14\n" +
	"\x10OFPGMFC_BAD_TYPE\x10\n" +
	"\x12\x17\n" +
	"\x13OFPGMFC_BAD_COMMAND\x10\v\x12\x16\n" +
	"\x12OFPGMFC_BAD_BUCKET\x10\f\x12\x15\n" +
	"\x11OFPGMFC_BAD_WATCH\x10\r\x12\x11\n" +
	"\rOFPGMFC_EPERM\x10\x0e*\x8f\x01\n" +
	"\x18ofp_port_mod_failed_code\x12\x14\n" +
	"\x10OFPPMFC_BAD_PORT\x10\x00\x12\x17\n" +
	"\x13OFPPMFC_BAD_HW_ADDR\x10\x01\x12\x16\n" +
	"\x12OFPPMFC_BAD_CONFIG\x10\x02\x12\x19\n" +
	"\x15OFPPMFC_BAD_ADVERTISE\x10\x03\x12\x11\n" +
	"\rOFPPMFC_EPERM\x10\x04*]\n" +
	"\x19ofp_table_mod_failed_code\x12\x15\n" +
	"\x11OFPTMFC_BAD_TABLE\x10\x00\x12\x16\n" +
	"\x12OFPTMFC_BAD_CONFIG\x10\x01\x12\x11\n" +
	"\rOFPTMFC_EPERM\x10\x02*Z\n" +
	"\x18ofp_queue_op_failed_code\x12\x14\n" +
	"\x10OFPQOFC_BAD_PORT\x10\x00\x12\x15\n" +
	"\x11OFPQOFC_BAD_QUEUE\x10\x01\x12\x11\n" +
	"\rOFPQOFC_EPERM\x10\x02*^\n" +
	"\x1dofp_switch_config_failed_code\x12\x15\n" +
	"\x11OFPSCFC_BAD_FLAGS\x10\x00\x12\x13\n" +
	"\x0fOFPSCFC_BAD_LEN\x10\x01\x12\x11\n" +
	"\rOFPSCFC_EPERM\x10\x02*Z\n" +
	"\x1cofp_role_request_failed_code\x12\x11\n" +
	"\rOFPRRFC_STALE\x10\x00\x12\x11\n" +
	"\rOFPRRFC_UNSUP\x10\x01\x12\x14\n" +
	"\x10OFPRRFC_BAD_ROLE\x10\x02*\xc5\x02\n" +
	"\x19ofp_meter_mod_failed_code\x12\x13\n" +
	"\x0fOFPMMFC_UNKNOWN\x10\x00\x12\x18\n" +
	"\x14OFPMMFC_METER_EXISTS\x10\x01\x12\x19\n" +
	"\x15OFPMMFC_INVALID_METER\x10\x02\x12\x19\n" +
	"\x15OFPMMFC_UNKNOWN_METER\x10\x03\x12\x17\n" +
	"\x13OFPMMFC_BAD_COMMAND\x10\x04\x12\x15\n" +
	"\x11OFPMMFC_BAD_FLAGS\x10\x05\x12\x14\n" +
	"\x10OFPMMFC_BAD_RATE\x10\x06\x12\x15\n" +
	"\x11OFPMMFC_BAD_BURST\x10\a\x12\x14\n" +
	"\x10OFPMMFC_BAD_BAND\x10\b\x12\x1b\n" +
	"\x17OFPMMFC_BAD_BAND_DETAIL\x10\t\x12\x19\n" +
	"\x15OFPMMFC_OUT_OF_METERS\x10\n" +
	"\x12\x18\n" +
	"\x14OFPMMFC_OUT_OF_BANDS\x10\v*\xa9\x01\n" +
	"\x1eofp_table_features_failed_code\x12\x15\n" +
	"\x11OFPTFFC_BAD_TABLE\x10\x00\x12\x18\n" +
	"\x14OFPTFFC_BAD_METADATA\x10\x01\x12\x14\n" +
	"\x10OFPTFFC_BAD_TYPE\x10\x02\x12\x13\n" +
	"\x0fOFPTFFC_BAD_LEN\x10\x03\x12\x18\n" +
	"\x14OFPTFFC_BAD_ARGUMENT\x10\x04\x12\x11\n" +
	"\rOFPTFFC_EPERM\x10\x05*\xce\x02\n" +
	"\x12ofp_multipart_type\x12\x0e\n" +
	"\n" +
	"OFPMP_DESC\x10\x00\x12\x0e\n" +
	"\n" +
	"OFPMP_FLOW\x10\x01\x12\x13\n" +
	"\x0fOFPMP_AGGREGATE\x10\x02\x12\x0f\n" +
	"\vOFPMP_TABLE\x10\x03\x12\x14\n" +
	"\x10OFPMP_PORT_STATS\x10\x04\x12\x0f\n" +
	"\vOFPMP_QUEUE\x10\x05\x12\x0f\n" +
	"\vOFPMP_GROUP\x10\x06\x12\x14\n" +
	"\x10OFPMP_GROUP_DESC\x10\a\x12\x18\n" +
	"\x14OFPMP_GROUP_FEATURES\x10\b\x12\x0f\n" +
	"\vOFPMP_METER\x10\t\x12\x16\n" +
	"\x12OFPMP_METER_CONFIG\x10\n" +
	"\x12\x18\n" +
	"\x14OFPMP_METER_FEATURES\x10\v\x12\x18\n" +
	"\x14OFPMP_TABLE_FEATURES\x10\f\x12\x13\n" +
	"\x0fOFPMP_PORT_DESC\x10\r\x12\x18\n" +
	"\x12OFPMP_EXPERIMENTER\x10\xff\xff\x03*J\n" +
	"\x1bofp_multipart_request_flags\x12\x16\n" +
	"\x12OFPMPF_REQ_INVALID\x10\x00\x12\x13\n" +
	"\x0fOFPMPF_REQ_MORE\x10\x01*L\n" +
	"\x19ofp_multipart_reply_flags\x12\x18\n" +
	"\x14OFPMPF_REPLY_INVALID\x10\x00\x12\x15\n" +
	"\x11OFPMPF_REPLY_MORE\x10\x01*\xe4\x03\n" +
	"\x1bofp_table_feature_prop_type\x12\x18\n" +
	"\x14OFPTFPT_INSTRUCTIONS\x10\x00\x12\x1d\n" +
	"\x19OFPTFPT_INSTRUCTIONS_MISS\x10\x01\x12\x17\n" +
	"\x13OFPTFPT_NEXT_TABLES\x10\x02\x12\x1c\n" +
	"\x18OFPTFPT_NEXT_TABLES_MISS\x10\x03\x12\x19\n" +
	"\x15OFPTFPT_WRITE_ACTIONS\x10\x04\x12\x1e\n" +
	"\x1aOFPTFPT_WRITE_ACTIONS_MISS\x10\x05\x12\x19\n" +
	"\x15OFPTFPT_APPLY_ACTIONS\x10\x06\x12\x1e\n" +
	"\x1aOFPTFPT_APPLY_ACTIONS_MISS\x10\a\x12\x11\n" +
	"\rOFPTFPT_MATCH\x10\b\x12\x15\n" +
	"\x11OFPTFPT_WILDCARDS\x10\n" +
	"\x12\x1a\n" +
	"\x16OFPTFPT_WRITE_SETFIELD\x10\f\x12\x1f\n" +
	"\x1bOFPTFPT_WRITE_SETFIELD_MISS\x10\r\x12\x1a\n" +
	"\x16OFPTFPT_APPLY_SETFIELD\x10\x0e\x12\x1f\n" +
	"\x1bOFPTFPT_APPLY_SETFIELD_MISS\x10\x0f\x12\x1a\n" +
	"\x14OFPTFPT_EXPERIMENTER\x10\xfe\xff\x03\x12\x1f\n" +
	"\x19OFPTFPT_EXPERIMENTER_MISS\x10\xff\xff\x03*\x93\x01\n" +
	"\x16ofp_group_capabilities\x12\x12\n" +
	"\x0eOFPGFC_INVALID\x10\x00\x12\x18\n" +
	"\x14OFPGFC_SELECT_WEIGHT\x10\x01\x12\x1a\n" +
	"\x16OFPGFC_SELECT_LIVENESS\x10\x02\x12\x13\n" +
	"\x0fOFPGFC_CHAINING\x10\x04\x12\x1a\n" +
	"\x16OFPGFC_CHAINING_CHECKS\x10\b*k\n" +
	"\x14ofp_queue_properties\x12\x11\n" +
	"\rOFPQT_INVALID\x10\x00\x12\x12\n" +
	"\x0eOFPQT_MIN_RATE\x10\x01\x12\x12\n" +
	"\x0eOFPQT_MAX_RATE\x10\x02\x12\x18\n" +
	"\x12OFPQT_EXPERIMENTER\x10\xff\xff\x03*q\n" +
	"\x13ofp_controller_role\x12\x17\n" +
	"\x13OFPCR_ROLE_NOCHANGE\x10\x00\x12\x14\n" +
	"\x10OFPCR_ROLE_EQUAL\x10\x01\x12\x15\n" +
	"\x11OFPCR_ROLE_MASTER\x10\x02\x12\x14\n" +
	"\x10OFPCR_ROLE_SLAVE\x10\x03BU\n" +
	"\x1eorg.opencord.voltha.openflow13Z3github.com/opencord/voltha-protos/v5/go/openflow_13b\x06proto3"

var (
	file_voltha_protos_openflow_13_proto_rawDescOnce sync.Once
	file_voltha_protos_openflow_13_proto_rawDescData []byte
)

func file_voltha_protos_openflow_13_proto_rawDescGZIP() []byte {
	file_voltha_protos_openflow_13_proto_rawDescOnce.Do(func() {
		file_voltha_protos_openflow_13_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_voltha_protos_openflow_13_proto_rawDesc), len(file_voltha_protos_openflow_13_proto_rawDesc)))
	})
	return file_voltha_protos_openflow_13_proto_rawDescData
}

var file_voltha_protos_openflow_13_proto_enumTypes = make([]protoimpl.EnumInfo, 53)
var file_voltha_protos_openflow_13_proto_msgTypes = make([]protoimpl.MessageInfo, 99)
var file_voltha_protos_openflow_13_proto_goTypes = []any{
	(OfpPortNo)(0),                          // 0: openflow_13.ofp_port_no
	(OfpType)(0),                            // 1: openflow_13.ofp_type
	(OfpHelloElemType)(0),                   // 2: openflow_13.ofp_hello_elem_type
	(OfpConfigFlags)(0),                     // 3: openflow_13.ofp_config_flags
	(OfpTableConfig)(0),                     // 4: openflow_13.ofp_table_config
	(OfpTable)(0),                           // 5: openflow_13.ofp_table
	(OfpCapabilities)(0),                    // 6: openflow_13.ofp_capabilities
	(OfpPortConfig)(0),                      // 7: openflow_13.ofp_port_config
	(OfpPortState)(0),                       // 8: openflow_13.ofp_port_state
	(OfpPortFeatures)(0),                    // 9: openflow_13.ofp_port_features
	(OfpPortReason)(0),                      // 10: openflow_13.ofp_port_reason
	(OfpDeviceConnection)(0),                // 11: openflow_13.ofp_device_connection
	(OfpMatchType)(0),                       // 12: openflow_13.ofp_match_type
	(OfpOxmClass)(0),                        // 13: openflow_13.ofp_oxm_class
	(OxmOfbFieldTypes)(0),                   // 14: openflow_13.oxm_ofb_field_types
	(OfpVlanId)(0),                          // 15: openflow_13.ofp_vlan_id
	(OfpIpv6ExthdrFlags)(0),                 // 16: openflow_13.ofp_ipv6exthdr_flags
	(OfpActionType)(0),                      // 17: openflow_13.ofp_action_type
	(OfpControllerMaxLen)(0),                // 18: openflow_13.ofp_controller_max_len
	(OfpInstructionType)(0),                 // 19: openflow_13.ofp_instruction_type
	(OfpFlowModCommand)(0),                  // 20: openflow_13.ofp_flow_mod_command
	(OfpFlowModFlags)(0),                    // 21: openflow_13.ofp_flow_mod_flags
	(OfpGroup)(0),                           // 22: openflow_13.ofp_group
	(OfpGroupModCommand)(0),                 // 23: openflow_13.ofp_group_mod_command
	(OfpGroupType)(0),                       // 24: openflow_13.ofp_group_type
	(OfpPacketInReason)(0),                  // 25: openflow_13.ofp_packet_in_reason
	(OfpFlowRemovedReason)(0),               // 26: openflow_13.ofp_flow_removed_reason
	(OfpMeter)(0),                           // 27: openflow_13.ofp_meter
	(OfpMeterBandType)(0),                   // 28: openflow_13.ofp_meter_band_type
	(OfpMeterModCommand)(0),                 // 29: openflow_13.ofp_meter_mod_command
	(OfpMeterFlags)(0),                      // 30: openflow_13.ofp_meter_flags
	(OfpErrorType)(0),                       // 31: openflow_13.ofp_error_type
	(OfpHelloFailedCode)(0),                 // 32: openflow_13.ofp_hello_failed_code
	(OfpBadRequestCode)(0),                  // 33: openflow_13.ofp_bad_request_code
	(OfpBadActionCode)(0),                   // 34: openflow_13.ofp_bad_action_code
	(OfpBadInstructionCode)(0),              // 35: openflow_13.ofp_bad_instruction_code
	(OfpBadMatchCode)(0),                    // 36: openflow_13.ofp_bad_match_code
	(OfpFlowModFailedCode)(0),               // 37: openflow_13.ofp_flow_mod_failed_code
	(OfpGroupModFailedCode)(0),              // 38: openflow_13.ofp_group_mod_failed_code
	(OfpPortModFailedCode)(0),               // 39: openflow_13.ofp_port_mod_failed_code
	(OfpTableModFailedCode)(0),              // 40: openflow_13.ofp_table_mod_failed_code
	(OfpQueueOpFailedCode)(0),               // 41: openflow_13.ofp_queue_op_failed_code
	(OfpSwitchConfigFailedCode)(0),          // 42: openflow_13.ofp_switch_config_failed_code
	(OfpRoleRequestFailedCode)(0),           // 43: openflow_13.ofp_role_request_failed_code
	(OfpMeterModFailedCode)(0),              // 44: openflow_13.ofp_meter_mod_failed_code
	(OfpTableFeaturesFailedCode)(0),         // 45: openflow_13.ofp_table_features_failed_code
	(OfpMultipartType)(0),                   // 46: openflow_13.ofp_multipart_type
	(OfpMultipartRequestFlags)(0),           // 47: openflow_13.ofp_multipart_request_flags
	(OfpMultipartReplyFlags)(0),             // 48: openflow_13.ofp_multipart_reply_flags
	(OfpTableFeaturePropType)(0),            // 49: openflow_13.ofp_table_feature_prop_type
	(OfpGroupCapabilities)(0),               // 50: openflow_13.ofp_group_capabilities
	(OfpQueueProperties)(0),                 // 51: openflow_13.ofp_queue_properties
	(OfpControllerRole)(0),                  // 52: openflow_13.ofp_controller_role
	(*OfpHeader)(nil),                       // 53: openflow_13.ofp_header
	(*OfpHelloElemHeader)(nil),              // 54: openflow_13.ofp_hello_elem_header
	(*OfpHelloElemVersionbitmap)(nil),       // 55: openflow_13.ofp_hello_elem_versionbitmap
	(*OfpHello)(nil),                        // 56: openflow_13.ofp_hello
	(*OfpSwitchConfig)(nil),                 // 57: openflow_13.ofp_switch_config
	(*OfpTableMod)(nil),                     // 58: openflow_13.ofp_table_mod
	(*OfpPort)(nil),                         // 59: openflow_13.ofp_port
	(*OfpSwitchFeatures)(nil),               // 60: openflow_13.ofp_switch_features
	(*OfpPortStatus)(nil),                   // 61: openflow_13.ofp_port_status
	(*OfpDeviceStatus)(nil),                 // 62: openflow_13.ofp_device_status
	(*OfpPortMod)(nil),                      // 63: openflow_13.ofp_port_mod
	(*OfpMatch)(nil),                        // 64: openflow_13.ofp_match
	(*OfpOxmField)(nil),                     // 65: openflow_13.ofp_oxm_field
	(*OfpOxmOfbField)(nil),                  // 66: openflow_13.ofp_oxm_ofb_field
	(*OfpOxmExperimenterField)(nil),         // 67: openflow_13.ofp_oxm_experimenter_field
	(*OfpAction)(nil),                       // 68: openflow_13.ofp_action
	(*OfpActionOutput)(nil),                 // 69: openflow_13.ofp_action_output
	(*OfpActionMplsTtl)(nil),                // 70: openflow_13.ofp_action_mpls_ttl
	(*OfpActionPush)(nil),                   // 71: openflow_13.ofp_action_push
	(*OfpActionPopMpls)(nil),                // 72: openflow_13.ofp_action_pop_mpls
	(*OfpActionGroup)(nil),                  // 73: openflow_13.ofp_action_group
	(*OfpActionNwTtl)(nil),                  // 74: openflow_13.ofp_action_nw_ttl
	(*OfpActionSetField)(nil),               // 75: openflow_13.ofp_action_set_field
	(*OfpActionExperimenter)(nil),           // 76: openflow_13.ofp_action_experimenter
	(*OfpInstruction)(nil),                  // 77: openflow_13.ofp_instruction
	(*OfpInstructionGotoTable)(nil),         // 78: openflow_13.ofp_instruction_goto_table
	(*OfpInstructionWriteMetadata)(nil),     // 79: openflow_13.ofp_instruction_write_metadata
	(*OfpInstructionActions)(nil),           // 80: openflow_13.ofp_instruction_actions
	(*OfpInstructionMeter)(nil),             // 81: openflow_13.ofp_instruction_meter
	(*OfpInstructionExperimenter)(nil),      // 82: openflow_13.ofp_instruction_experimenter
	(*OfpFlowMod)(nil),                      // 83: openflow_13.ofp_flow_mod
	(*OfpBucket)(nil),                       // 84: openflow_13.ofp_bucket
	(*OfpGroupMod)(nil),                     // 85: openflow_13.ofp_group_mod
	(*OfpPacketOut)(nil),                    // 86: openflow_13.ofp_packet_out
	(*OfpPacketIn)(nil),                     // 87: openflow_13.ofp_packet_in
	(*OfpFlowRemoved)(nil),                  // 88: openflow_13.ofp_flow_removed
	(*OfpMeterBandHeader)(nil),              // 89: openflow_13.ofp_meter_band_header
	(*OfpMeterBandDrop)(nil),                // 90: openflow_13.ofp_meter_band_drop
	(*OfpMeterBandDscpRemark)(nil),          // 91: openflow_13.ofp_meter_band_dscp_remark
	(*OfpMeterBandExperimenter)(nil),        // 92: openflow_13.ofp_meter_band_experimenter
	(*OfpMeterMod)(nil),                     // 93: openflow_13.ofp_meter_mod
	(*OfpErrorMsg)(nil),                     // 94: openflow_13.ofp_error_msg
	(*OfpErrorExperimenterMsg)(nil),         // 95: openflow_13.ofp_error_experimenter_msg
	(*OfpMultipartRequest)(nil),             // 96: openflow_13.ofp_multipart_request
	(*OfpMultipartReply)(nil),               // 97: openflow_13.ofp_multipart_reply
	(*OfpDesc)(nil),                         // 98: openflow_13.ofp_desc
	(*OfpFlowStatsRequest)(nil),             // 99: openflow_13.ofp_flow_stats_request
	(*OfpFlowStats)(nil),                    // 100: openflow_13.ofp_flow_stats
	(*OfpAggregateStatsRequest)(nil),        // 101: openflow_13.ofp_aggregate_stats_request
	(*OfpAggregateStatsReply)(nil),          // 102: openflow_13.ofp_aggregate_stats_reply
	(*OfpTableFeatureProperty)(nil),         // 103: openflow_13.ofp_table_feature_property
	(*OfpTableFeaturePropInstructions)(nil), // 104: openflow_13.ofp_table_feature_prop_instructions
	(*OfpTableFeaturePropNextTables)(nil),   // 105: openflow_13.ofp_table_feature_prop_next_tables
	(*OfpTableFeaturePropActions)(nil),      // 106: openflow_13.ofp_table_feature_prop_actions
	(*OfpTableFeaturePropOxm)(nil),          // 107: openflow_13.ofp_table_feature_prop_oxm
	(*OfpTableFeaturePropExperimenter)(nil), // 108: openflow_13.ofp_table_feature_prop_experimenter
	(*OfpTableFeatures)(nil),                // 109: openflow_13.ofp_table_features
	(*OfpTableStats)(nil),                   // 110: openflow_13.ofp_table_stats
	(*OfpPortStatsRequest)(nil),             // 111: openflow_13.ofp_port_stats_request
	(*OfpPortStats)(nil),                    // 112: openflow_13.ofp_port_stats
	(*OfpGroupStatsRequest)(nil),            // 113: openflow_13.ofp_group_stats_request
	(*OfpBucketCounter)(nil),                // 114: openflow_13.ofp_bucket_counter
	(*OfpGroupStats)(nil),                   // 115: openflow_13.ofp_group_stats
	(*OfpGroupDesc)(nil),                    // 116: openflow_13.ofp_group_desc
	(*OfpGroupEntry)(nil),                   // 117: openflow_13.ofp_group_entry
	(*OfpGroupFeatures)(nil),                // 118: openflow_13.ofp_group_features
	(*OfpMeterMultipartRequest)(nil),        // 119: openflow_13.ofp_meter_multipart_request
	(*OfpMeterBandStats)(nil),               // 120: openflow_13.ofp_meter_band_stats
	(*OfpMeterStats)(nil),                   // 121: openflow_13.ofp_meter_stats
	(*OfpMeterConfig)(nil),                  // 122: openflow_13.ofp_meter_config
	(*OfpMeterFeatures)(nil),                // 123: openflow_13.ofp_meter_features
	(*OfpMeterEntry)(nil),                   // 124: openflow_13.ofp_meter_entry
	(*OfpExperimenterMultipartHeader)(nil),  // 125: openflow_13.ofp_experimenter_multipart_header
	(*OfpExperimenterHeader)(nil),           // 126: openflow_13.ofp_experimenter_header
	(*OfpQueuePropHeader)(nil),              // 127: openflow_13.ofp_queue_prop_header
	(*OfpQueuePropMinRate)(nil),             // 128: openflow_13.ofp_queue_prop_min_rate
	(*OfpQueuePropMaxRate)(nil),             // 129: openflow_13.ofp_queue_prop_max_rate
	(*OfpQueuePropExperimenter)(nil),        // 130: openflow_13.ofp_queue_prop_experimenter
	(*OfpPacketQueue)(nil),                  // 131: openflow_13.ofp_packet_queue
	(*OfpQueueGetConfigRequest)(nil),        // 132: openflow_13.ofp_queue_get_config_request
	(*OfpQueueGetConfigReply)(nil),          // 133: openflow_13.ofp_queue_get_config_reply
	(*OfpActionSetQueue)(nil),               // 134: openflow_13.ofp_action_set_queue
	(*OfpQueueStatsRequest)(nil),            // 135: openflow_13.ofp_queue_stats_request
	(*OfpQueueStats)(nil),                   // 136: openflow_13.ofp_queue_stats
	(*OfpRoleRequest)(nil),                  // 137: openflow_13.ofp_role_request
	(*OfpAsyncConfig)(nil),                  // 138: openflow_13.ofp_async_config
	(*MeterModUpdate)(nil),                  // 139: openflow_13.MeterModUpdate
	(*MeterStatsReply)(nil),                 // 140: openflow_13.MeterStatsReply
	(*FlowTableUpdate)(nil),                 // 141: openflow_13.FlowTableUpdate
	(*FlowGroupTableUpdate)(nil),            // 142: openflow_13.FlowGroupTableUpdate
	(*Flows)(nil),                           // 143: openflow_13.Flows
	(*Meters)(nil),                          // 144: openflow_13.Meters
	(*FlowGroups)(nil),                      // 145: openflow_13.FlowGroups
	(*FlowChanges)(nil),                     // 146: openflow_13.FlowChanges
	(*FlowGroupChanges)(nil),                // 147: openflow_13.FlowGroupChanges
	(*PacketIn)(nil),                        // 148: openflow_13.PacketIn
	(*PacketOut)(nil),                       // 149: openflow_13.PacketOut
	(*ChangeEvent)(nil),                     // 150: openflow_13.ChangeEvent
	(*FlowMetadata)(nil),                    // 151: openflow_13.FlowMetadata
}
var file_voltha_protos_openflow_13_proto_depIdxs = []int32{
	1,   // 0: openflow_13.ofp_header.type:type_name -> openflow_13.ofp_type
	2,   // 1: openflow_13.ofp_hello_elem_header.type:type_name -> openflow_13.ofp_hello_elem_type
	55,  // 2: openflow_13.ofp_hello_elem_header.versionbitmap:type_name -> openflow_13.ofp_hello_elem_versionbitmap
	54,  // 3: openflow_13.ofp_hello.elements:type_name -> openflow_13.ofp_hello_elem_header
	10,  // 4: openflow_13.ofp_port_status.reason:type_name -> openflow_13.ofp_port_reason
	59,  // 5: openflow_13.ofp_port_status.desc:type_name -> openflow_13.ofp_port
	11,  // 6: openflow_13.ofp_device_status.status:type_name -> openflow_13.ofp_device_connection
	12,  // 7: openflow_13.ofp_match.type:type_name -> openflow_13.ofp_match_type
	65,  // 8: openflow_13.ofp_match.oxm_fields:type_name -> openflow_13.ofp_oxm_field
	13,  // 9: openflow_13.ofp_oxm_field.oxm_class:type_name -> openflow_13.ofp_oxm_class
	66,  // 10: openflow_13.ofp_oxm_field.ofb_field:type_name -> openflow_13.ofp_oxm_ofb_field
	67,  // 11: openflow_13.ofp_oxm_field.experimenter_field:type_name -> openflow_13.ofp_oxm_experimenter_field
	14,  // 12: openflow_13.ofp_oxm_ofb_field.type:type_name -> openflow_13.oxm_ofb_field_types
	17,  // 13: openflow_13.ofp_action.type:type_name -> openflow_13.ofp_action_type
	69,  // 14: openflow_13.ofp_action.output:type_name -> openflow_13.ofp_action_output
	70,  // 15: openflow_13.ofp_action.mpls_ttl:type_name -> openflow_13.ofp_action_mpls_ttl
	71,  // 16: openflow_13.ofp_action.push:type_name -> openflow_13.ofp_action_push
	72,  // 17: openflow_13.ofp_action.pop_mpls:type_name -> openflow_13.ofp_action_pop_mpls
	73,  // 18: openflow_13.ofp_action.group:type_name -> openflow_13.ofp_action_group
	74,  // 19: openflow_13.ofp_action.nw_ttl:type_name -> openflow_13.ofp_action_nw_ttl
	75,  // 20: openflow_13.ofp_action.set_field:type_name -> openflow_13.ofp_action_set_field
	76,  // 21: openflow_13.ofp_action.experimenter:type_name -> openflow_13.ofp_action_experimenter
	65,  // 22: openflow_13.ofp_action_set_field.field:type_name -> openflow_13.ofp_oxm_field
	78,  // 23: openflow_13.ofp_instruction.goto_table:type_name -> openflow_13.ofp_instruction_goto_table
	79,  // 24: openflow_13.ofp_instruction.write_metadata:type_name -> openflow_13.ofp_instruction_write_metadata
	80,  // 25: openflow_13.ofp_instruction.actions:type_name -> openflow_13.ofp_instruction_actions
	81,  // 26: openflow_13.ofp_instruction.meter:type_name -> openflow_13.ofp_instruction_meter
	82,  // 27: openflow_13.ofp_instruction.experimenter:type_name -> openflow_13.ofp_instruction_experimenter
	68,  // 28: openflow_13.ofp_instruction_actions.actions:type_name -> openflow_13.ofp_action
	20,  // 29: openflow_13.ofp_flow_mod.command:type_name -> openflow_13.ofp_flow_mod_command
	64,  // 30: openflow_13.ofp_flow_mod.match:type_name -> openflow_13.ofp_match
	77,  // 31: openflow_13.ofp_flow_mod.instructions:type_name -> openflow_13.ofp_instruction
	68,  // 32: openflow_13.ofp_bucket.actions:type_name -> openflow_13.ofp_action
	23,  // 33: openflow_13.ofp_group_mod.command:type_name -> openflow_13.ofp_group_mod_command
	24,  // 34: openflow_13.ofp_group_mod.type:type_name -> openflow_13.ofp_group_type
	84,  // 35: openflow_13.ofp_group_mod.buckets:type_name -> openflow_13.ofp_bucket
	68,  // 36: openflow_13.ofp_packet_out.actions:type_name -> openflow_13.ofp_action
	25,  // 37: openflow_13.ofp_packet_in.reason:type_name -> openflow_13.ofp_packet_in_reason
	64,  // 38: openflow_13.ofp_packet_in.match:type_name -> openflow_13.ofp_match
	26,  // 39: openflow_13.ofp_flow_removed.reason:type_name -> openflow_13.ofp_flow_removed_reason
	64,  // 40: openflow_13.ofp_flow_removed.match:type_name -> openflow_13.ofp_match
	28,  // 41: openflow_13.ofp_meter_band_header.type:type_name -> openflow_13.ofp_meter_band_type
	90,  // 42: openflow_13.ofp_meter_band_header.drop:type_name -> openflow_13.ofp_meter_band_drop
	91,  // 43: openflow_13.ofp_meter_band_header.dscp_remark:type_name -> openflow_13.ofp_meter_band_dscp_remark
	92,  // 44: openflow_13.ofp_meter_band_header.experimenter:type_name -> openflow_13.ofp_meter_band_experimenter
	29,  // 45: openflow_13.ofp_meter_mod.command:type_name -> openflow_13.ofp_meter_mod_command
	89,  // 46: openflow_13.ofp_meter_mod.bands:type_name -> openflow_13.ofp_meter_band_header
	53,  // 47: openflow_13.ofp_error_msg.header:type_name -> openflow_13.ofp_header
	46,  // 48: openflow_13.ofp_multipart_request.type:type_name -> openflow_13.ofp_multipart_type
	46,  // 49: openflow_13.ofp_multipart_reply.type:type_name -> openflow_13.ofp_multipart_type
	64,  // 50: openflow_13.ofp_flow_stats_request.match:type_name -> openflow_13.ofp_match
	64,  // 51: openflow_13.ofp_flow_stats.match:type_name -> openflow_13.ofp_match
	77,  // 52: openflow_13.ofp_flow_stats.instructions:type_name -> openflow_13.ofp_instruction
	64,  // 53: openflow_13.ofp_aggregate_stats_request.match:type_name -> openflow_13.ofp_match
	49,  // 54: openflow_13.ofp_table_feature_property.type:type_name -> openflow_13.ofp_table_feature_prop_type
	104, // 55: openflow_13.ofp_table_feature_property.instructions:type_name -> openflow_13.ofp_table_feature_prop_instructions
	105, // 56: openflow_13.ofp_table_feature_property.next_tables:type_name -> openflow_13.ofp_table_feature_prop_next_tables
	106, // 57: openflow_13.ofp_table_feature_property.actions:type_name -> openflow_13.ofp_table_feature_prop_actions
	107, // 58: openflow_13.ofp_table_feature_property.oxm:type_name -> openflow_13.ofp_table_feature_prop_oxm
	108, // 59: openflow_13.ofp_table_feature_property.experimenter:type_name -> openflow_13.ofp_table_feature_prop_experimenter
	77,  // 60: openflow_13.ofp_table_feature_prop_instructions.instructions:type_name -> openflow_13.ofp_instruction
	68,  // 61: openflow_13.ofp_table_feature_prop_actions.actions:type_name -> openflow_13.ofp_action
	103, // 62: openflow_13.ofp_table_features.properties:type_name -> openflow_13.ofp_table_feature_property
	114, // 63: openflow_13.ofp_group_stats.bucket_stats:type_name -> openflow_13.ofp_bucket_counter
	24,  // 64: openflow_13.ofp_group_desc.type:type_name -> openflow_13.ofp_group_type
	84,  // 65: openflow_13.ofp_group_desc.buckets:type_name -> openflow_13.ofp_bucket
	116, // 66: openflow_13.ofp_group_entry.desc:type_name -> openflow_13.ofp_group_desc
	115, // 67: openflow_13.ofp_group_entry.stats:type_name -> openflow_13.ofp_group_stats
	120, // 68: openflow_13.ofp_meter_stats.band_stats:type_name -> openflow_13.ofp_meter_band_stats
	89,  // 69: openflow_13.ofp_meter_config.bands:type_name -> openflow_13.ofp_meter_band_header
	122, // 70: openflow_13.ofp_meter_entry.config:type_name -> openflow_13.ofp_meter_config
	121, // 71: openflow_13.ofp_meter_entry.stats:type_name -> openflow_13.ofp_meter_stats
	127, // 72: openflow_13.ofp_queue_prop_min_rate.prop_header:type_name -> openflow_13.ofp_queue_prop_header
	127, // 73: openflow_13.ofp_queue_prop_max_rate.prop_header:type_name -> openflow_13.ofp_queue_prop_header
	127, // 74: openflow_13.ofp_queue_prop_experimenter.prop_header:type_name -> openflow_13.ofp_queue_prop_header
	127, // 75: openflow_13.ofp_packet_queue.properties:type_name -> openflow_13.ofp_queue_prop_header
	131, // 76: openflow_13.ofp_queue_get_config_reply.queues:type_name -> openflow_13.ofp_packet_queue
	52,  // 77: openflow_13.ofp_role_request.role:type_name -> openflow_13.ofp_controller_role
	93,  // 78: openflow_13.MeterModUpdate.meter_mod:type_name -> openflow_13.ofp_meter_mod
	121, // 79: openflow_13.MeterStatsReply.meter_stats:type_name -> openflow_13.ofp_meter_stats
	83,  // 80: openflow_13.FlowTableUpdate.flow_mod:type_name -> openflow_13.ofp_flow_mod
	85,  // 81: openflow_13.FlowGroupTableUpdate.group_mod:type_name -> openflow_13.ofp_group_mod
	100, // 82: openflow_13.Flows.items:type_name -> openflow_13.ofp_flow_stats
	124, // 83: openflow_13.Meters.items:type_name -> openflow_13.ofp_meter_entry
	117, // 84: openflow_13.FlowGroups.items:type_name -> openflow_13.ofp_group_entry
	143, // 85: openflow_13.FlowChanges.to_add:type_name -> openflow_13.Flows
	143, // 86: openflow_13.FlowChanges.to_remove:type_name -> openflow_13.Flows
	145, // 87: openflow_13.FlowGroupChanges.to_add:type_name -> openflow_13.FlowGroups
	145, // 88: openflow_13.FlowGroupChanges.to_remove:type_name -> openflow_13.FlowGroups
	145, // 89: openflow_13.FlowGroupChanges.to_update:type_name -> openflow_13.FlowGroups
	87,  // 90: openflow_13.PacketIn.packet_in:type_name -> openflow_13.ofp_packet_in
	86,  // 91: openflow_13.PacketOut.packet_out:type_name -> openflow_13.ofp_packet_out
	61,  // 92: openflow_13.ChangeEvent.port_status:type_name -> openflow_13.ofp_port_status
	94,  // 93: openflow_13.ChangeEvent.error:type_name -> openflow_13.ofp_error_msg
	62,  // 94: openflow_13.ChangeEvent.device_status:type_name -> openflow_13.ofp_device_status
	122, // 95: openflow_13.FlowMetadata.meters:type_name -> openflow_13.ofp_meter_config
	96,  // [96:96] is the sub-list for method output_type
	96,  // [96:96] is the sub-list for method input_type
	96,  // [96:96] is the sub-list for extension type_name
	96,  // [96:96] is the sub-list for extension extendee
	0,   // [0:96] is the sub-list for field type_name
}

func init() { file_voltha_protos_openflow_13_proto_init() }
func file_voltha_protos_openflow_13_proto_init() {
	if File_voltha_protos_openflow_13_proto != nil {
		return
	}
	file_voltha_protos_openflow_13_proto_msgTypes[1].OneofWrappers = []any{
		(*OfpHelloElemHeader_Versionbitmap)(nil),
	}
	file_voltha_protos_openflow_13_proto_msgTypes[12].OneofWrappers = []any{
		(*OfpOxmField_OfbField)(nil),
		(*OfpOxmField_ExperimenterField)(nil),
	}
	file_voltha_protos_openflow_13_proto_msgTypes[13].OneofWrappers = []any{
		(*OfpOxmOfbField_Port)(nil),
		(*OfpOxmOfbField_PhysicalPort)(nil),
		(*OfpOxmOfbField_TableMetadata)(nil),
		(*OfpOxmOfbField_EthDst)(nil),
		(*OfpOxmOfbField_EthSrc)(nil),
		(*OfpOxmOfbField_EthType)(nil),
		(*OfpOxmOfbField_VlanVid)(nil),
		(*OfpOxmOfbField_VlanPcp)(nil),
		(*OfpOxmOfbField_IpDscp)(nil),
		(*OfpOxmOfbField_IpEcn)(nil),
		(*OfpOxmOfbField_IpProto)(nil),
		(*OfpOxmOfbField_Ipv4Src)(nil),
		(*OfpOxmOfbField_Ipv4Dst)(nil),
		(*OfpOxmOfbField_TcpSrc)(nil),
		(*OfpOxmOfbField_TcpDst)(nil),
		(*OfpOxmOfbField_UdpSrc)(nil),
		(*OfpOxmOfbField_UdpDst)(nil),
		(*OfpOxmOfbField_SctpSrc)(nil),
		(*OfpOxmOfbField_SctpDst)(nil),
		(*OfpOxmOfbField_Icmpv4Type)(nil),
		(*OfpOxmOfbField_Icmpv4Code)(nil),
		(*OfpOxmOfbField_ArpOp)(nil),
		(*OfpOxmOfbField_ArpSpa)(nil),
		(*OfpOxmOfbField_ArpTpa)(nil),
		(*OfpOxmOfbField_ArpSha)(nil),
		(*OfpOxmOfbField_ArpTha)(nil),
		(*OfpOxmOfbField_Ipv6Src)(nil),
		(*OfpOxmOfbField_Ipv6Dst)(nil),
		(*OfpOxmOfbField_Ipv6Flabel)(nil),
		(*OfpOxmOfbField_Icmpv6Type)(nil),
		(*OfpOxmOfbField_Icmpv6Code)(nil),
		(*OfpOxmOfbField_Ipv6NdTarget)(nil),
		(*OfpOxmOfbField_Ipv6NdSsl)(nil),
		(*OfpOxmOfbField_Ipv6NdTll)(nil),
		(*OfpOxmOfbField_MplsLabel)(nil),
		(*OfpOxmOfbField_MplsTc)(nil),
		(*OfpOxmOfbField_MplsBos)(nil),
		(*OfpOxmOfbField_PbbIsid)(nil),
		(*OfpOxmOfbField_TunnelId)(nil),
		(*OfpOxmOfbField_Ipv6Exthdr)(nil),
		(*OfpOxmOfbField_TableMetadataMask)(nil),
		(*OfpOxmOfbField_EthDstMask)(nil),
		(*OfpOxmOfbField_EthSrcMask)(nil),
		(*OfpOxmOfbField_VlanVidMask)(nil),
		(*OfpOxmOfbField_Ipv4SrcMask)(nil),
		(*OfpOxmOfbField_Ipv4DstMask)(nil),
		(*OfpOxmOfbField_ArpSpaMask)(nil),
		(*OfpOxmOfbField_ArpTpaMask)(nil),
		(*OfpOxmOfbField_Ipv6SrcMask)(nil),
		(*OfpOxmOfbField_Ipv6DstMask)(nil),
		(*OfpOxmOfbField_Ipv6FlabelMask)(nil),
		(*OfpOxmOfbField_PbbIsidMask)(nil),
		(*OfpOxmOfbField_TunnelIdMask)(nil),
		(*OfpOxmOfbField_Ipv6ExthdrMask)(nil),
	}
	file_voltha_protos_openflow_13_proto_msgTypes[15].OneofWrappers = []any{
		(*OfpAction_Output)(nil),
		(*OfpAction_MplsTtl)(nil),
		(*OfpAction_Push)(nil),
		(*OfpAction_PopMpls)(nil),
		(*OfpAction_Group)(nil),
		(*OfpAction_NwTtl)(nil),
		(*OfpAction_SetField)(nil),
		(*OfpAction_Experimenter)(nil),
	}
	file_voltha_protos_openflow_13_proto_msgTypes[24].OneofWrappers = []any{
		(*OfpInstruction_GotoTable)(nil),
		(*OfpInstruction_WriteMetadata)(nil),
		(*OfpInstruction_Actions)(nil),
		(*OfpInstruction_Meter)(nil),
		(*OfpInstruction_Experimenter)(nil),
	}
	file_voltha_protos_openflow_13_proto_msgTypes[36].OneofWrappers = []any{
		(*OfpMeterBandHeader_Drop)(nil),
		(*OfpMeterBandHeader_DscpRemark)(nil),
		(*OfpMeterBandHeader_Experimenter)(nil),
	}
	file_voltha_protos_openflow_13_proto_msgTypes[50].OneofWrappers = []any{
		(*OfpTableFeatureProperty_Instructions)(nil),
		(*OfpTableFeatureProperty_NextTables)(nil),
		(*OfpTableFeatureProperty_Actions)(nil),
		(*OfpTableFeatureProperty_Oxm)(nil),
		(*OfpTableFeatureProperty_Experimenter)(nil),
	}
	file_voltha_protos_openflow_13_proto_msgTypes[97].OneofWrappers = []any{
		(*ChangeEvent_PortStatus)(nil),
		(*ChangeEvent_Error)(nil),
		(*ChangeEvent_DeviceStatus)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_voltha_protos_openflow_13_proto_rawDesc), len(file_voltha_protos_openflow_13_proto_rawDesc)),
			NumEnums:      53,
			NumMessages:   99,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_voltha_protos_openflow_13_proto_goTypes,
		DependencyIndexes: file_voltha_protos_openflow_13_proto_depIdxs,
		EnumInfos:         file_voltha_protos_openflow_13_proto_enumTypes,
		MessageInfos:      file_voltha_protos_openflow_13_proto_msgTypes,
	}.Build()
	File_voltha_protos_openflow_13_proto = out.File
	file_voltha_protos_openflow_13_proto_goTypes = nil
	file_voltha_protos_openflow_13_proto_depIdxs = nil
}
