//
// Top-level Voltha API definition
//
// For details, see individual definition files.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v4.25.8
// source: voltha_protos/voltha.proto

package voltha

import (
	common "github.com/opencord/voltha-protos/v5/go/common"
	extension "github.com/opencord/voltha-protos/v5/go/extension"
	health "github.com/opencord/voltha-protos/v5/go/health"
	omci "github.com/opencord/voltha-protos/v5/go/omci"
	openflow_13 "github.com/opencord/voltha-protos/v5/go/openflow_13"
	voip_system_profile "github.com/opencord/voltha-protos/v5/go/voip_system_profile"
	voip_user_profile "github.com/opencord/voltha-protos/v5/go/voip_user_profile"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Symbols defined in public import of voltha_protos/common.proto.

type TestModeKeys = common.TestModeKeys

const TestModeKeys_api_test = common.TestModeKeys_api_test

var TestModeKeys_name = common.TestModeKeys_name
var TestModeKeys_value = common.TestModeKeys_value

type AdminState_Types = common.AdminState_Types

const AdminState_UNKNOWN = common.AdminState_UNKNOWN
const AdminState_PREPROVISIONED = common.AdminState_PREPROVISIONED
const AdminState_ENABLED = common.AdminState_ENABLED
const AdminState_DISABLED = common.AdminState_DISABLED
const AdminState_DOWNLOADING_IMAGE = common.AdminState_DOWNLOADING_IMAGE

var AdminState_Types_name = common.AdminState_Types_name
var AdminState_Types_value = common.AdminState_Types_value

type OperStatus_Types = common.OperStatus_Types

const OperStatus_UNKNOWN = common.OperStatus_UNKNOWN
const OperStatus_DISCOVERED = common.OperStatus_DISCOVERED
const OperStatus_ACTIVATING = common.OperStatus_ACTIVATING
const OperStatus_TESTING = common.OperStatus_TESTING
const OperStatus_ACTIVE = common.OperStatus_ACTIVE
const OperStatus_FAILED = common.OperStatus_FAILED
const OperStatus_RECONCILING = common.OperStatus_RECONCILING
const OperStatus_RECONCILING_FAILED = common.OperStatus_RECONCILING_FAILED
const OperStatus_REBOOTED = common.OperStatus_REBOOTED

var OperStatus_Types_name = common.OperStatus_Types_name
var OperStatus_Types_value = common.OperStatus_Types_value

type ConnectStatus_Types = common.ConnectStatus_Types

const ConnectStatus_UNKNOWN = common.ConnectStatus_UNKNOWN
const ConnectStatus_UNREACHABLE = common.ConnectStatus_UNREACHABLE
const ConnectStatus_REACHABLE = common.ConnectStatus_REACHABLE

var ConnectStatus_Types_name = common.ConnectStatus_Types_name
var ConnectStatus_Types_value = common.ConnectStatus_Types_value

type OperationResp_OperationReturnCode = common.OperationResp_OperationReturnCode

const OperationResp_OPERATION_SUCCESS = common.OperationResp_OPERATION_SUCCESS
const OperationResp_OPERATION_FAILURE = common.OperationResp_OPERATION_FAILURE
const OperationResp_OPERATION_UNSUPPORTED = common.OperationResp_OPERATION_UNSUPPORTED
const OperationResp_OPERATION_IN_PROGRESS = common.OperationResp_OPERATION_IN_PROGRESS

var OperationResp_OperationReturnCode_name = common.OperationResp_OperationReturnCode_name
var OperationResp_OperationReturnCode_value = common.OperationResp_OperationReturnCode_value

type Key = common.Key
type ID = common.ID
type IDs = common.IDs
type Connection = common.Connection
type AdminState = common.AdminState
type OperStatus = common.OperStatus
type ConnectStatus = common.ConnectStatus
type OperationResp = common.OperationResp
type PortStatistics = common.PortStatistics

// CoreInstance represents a core instance.  It is data held in memory when a core
// is running.  This data is not persistent.
type CoreInstance struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	InstanceId    string                 `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	Health        *health.HealthStatus   `protobuf:"bytes,2,opt,name=health,proto3" json:"health,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CoreInstance) Reset() {
	*x = CoreInstance{}
	mi := &file_voltha_protos_voltha_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CoreInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CoreInstance) ProtoMessage() {}

func (x *CoreInstance) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voltha_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CoreInstance.ProtoReflect.Descriptor instead.
func (*CoreInstance) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voltha_proto_rawDescGZIP(), []int{0}
}

func (x *CoreInstance) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CoreInstance) GetHealth() *health.HealthStatus {
	if x != nil {
		return x.Health
	}
	return nil
}

type CoreInstances struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Items         []*CoreInstance        `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CoreInstances) Reset() {
	*x = CoreInstances{}
	mi := &file_voltha_protos_voltha_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CoreInstances) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CoreInstances) ProtoMessage() {}

func (x *CoreInstances) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voltha_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CoreInstances.ProtoReflect.Descriptor instead.
func (*CoreInstances) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voltha_proto_rawDescGZIP(), []int{1}
}

func (x *CoreInstances) GetItems() []*CoreInstance {
	if x != nil {
		return x.Items
	}
	return nil
}

// Voltha represents the Voltha cluster data.  Each Core instance will hold a subset of
// the entire cluster. However, some items (e.g. adapters) will be held by all cores
// for better performance
type Voltha struct {
	state             protoimpl.MessageState  `protogen:"open.v1"`
	Version           string                  `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Adapters          []*Adapter              `protobuf:"bytes,2,rep,name=adapters,proto3" json:"adapters,omitempty"`
	LogicalDevices    []*LogicalDevice        `protobuf:"bytes,3,rep,name=logical_devices,json=logicalDevices,proto3" json:"logical_devices,omitempty"`
	Devices           []*Device               `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	DeviceTypes       []*DeviceType           `protobuf:"bytes,5,rep,name=device_types,json=deviceTypes,proto3" json:"device_types,omitempty"`
	EventFilters      []*EventFilter          `protobuf:"bytes,7,rep,name=event_filters,json=eventFilters,proto3" json:"event_filters,omitempty"`
	OmciMibDatabase   []*omci.MibDeviceData   `protobuf:"bytes,28,rep,name=omci_mib_database,json=omciMibDatabase,proto3" json:"omci_mib_database,omitempty"`
	OmciAlarmDatabase []*omci.AlarmDeviceData `protobuf:"bytes,29,rep,name=omci_alarm_database,json=omciAlarmDatabase,proto3" json:"omci_alarm_database,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *Voltha) Reset() {
	*x = Voltha{}
	mi := &file_voltha_protos_voltha_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Voltha) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Voltha) ProtoMessage() {}

func (x *Voltha) ProtoReflect() protoreflect.Message {
	mi := &file_voltha_protos_voltha_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Voltha.ProtoReflect.Descriptor instead.
func (*Voltha) Descriptor() ([]byte, []int) {
	return file_voltha_protos_voltha_proto_rawDescGZIP(), []int{2}
}

func (x *Voltha) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Voltha) GetAdapters() []*Adapter {
	if x != nil {
		return x.Adapters
	}
	return nil
}

func (x *Voltha) GetLogicalDevices() []*LogicalDevice {
	if x != nil {
		return x.LogicalDevices
	}
	return nil
}

func (x *Voltha) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *Voltha) GetDeviceTypes() []*DeviceType {
	if x != nil {
		return x.DeviceTypes
	}
	return nil
}

func (x *Voltha) GetEventFilters() []*EventFilter {
	if x != nil {
		return x.EventFilters
	}
	return nil
}

func (x *Voltha) GetOmciMibDatabase() []*omci.MibDeviceData {
	if x != nil {
		return x.OmciMibDatabase
	}
	return nil
}

func (x *Voltha) GetOmciAlarmDatabase() []*omci.AlarmDeviceData {
	if x != nil {
		return x.OmciAlarmDatabase
	}
	return nil
}

var File_voltha_protos_voltha_proto protoreflect.FileDescriptor

const file_voltha_protos_voltha_proto_rawDesc = "" +
	"\n" +
	"\x1avoltha_protos/voltha.proto\x12\x06voltha\x1a\x1cgoogle/api/annotations.proto\x1a\x1bgoogle/protobuf/empty.proto\x1a\x1avoltha_protos/common.proto\x1a\x1avoltha_protos/health.proto\x1a\"voltha_protos/logical_device.proto\x1a\x1avoltha_protos/device.proto\x1a\x1bvoltha_protos/adapter.proto\x1a\x1fvoltha_protos/openflow_13.proto\x1a\x1avoltha_protos/events.proto\x1a\x1evoltha_protos/extensions.proto\x1a'voltha_protos/voip_system_profile.proto\x1a%voltha_protos/voip_user_profile.proto\x1a\x1fvoltha_protos/omci_mib_db.proto\x1a!voltha_protos/omci_alarm_db.proto\x1a\x1dvoltha_protos/omci_test.proto\"]\n" +
	"\fCoreInstance\x12\x1f\n" +
	"\vinstance_id\x18\x01 \x01(\tR\n" +
	"instanceId\x12,\n" +
	"\x06health\x18\x02 \x01(\v2\x14.health.HealthStatusR\x06health\";\n" +
	"\rCoreInstances\x12*\n" +
	"\x05items\x18\x01 \x03(\v2\x14.voltha.CoreInstanceR\x05items\"\xc0\x03\n" +
	"\x06Voltha\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12,\n" +
	"\badapters\x18\x02 \x03(\v2\x10.adapter.AdapterR\badapters\x12F\n" +
	"\x0flogical_devices\x18\x03 \x03(\v2\x1d.logical_device.LogicalDeviceR\x0elogicalDevices\x12(\n" +
	"\adevices\x18\x04 \x03(\v2\x0e.device.DeviceR\adevices\x125\n" +
	"\fdevice_types\x18\x05 \x03(\v2\x12.device.DeviceTypeR\vdeviceTypes\x127\n" +
	"\revent_filters\x18\a \x03(\v2\x12.event.EventFilterR\feventFilters\x12?\n" +
	"\x11omci_mib_database\x18\x1c \x03(\v2\x13.omci.MibDeviceDataR\x0fomciMibDatabase\x12E\n" +
	"\x13omci_alarm_database\x18\x1d \x03(\v2\x15.omci.AlarmDeviceDataR\x11omciAlarmDatabaseJ\x04\b\x06\x10\a2\xbb;\n" +
	"\rVolthaService\x12D\n" +
	"\tGetVoltha\x12\x16.google.protobuf.Empty\x1a\x0e.voltha.Voltha\"\x0f\x82\xd3\xe4\x93\x02\t\x12\a/api/v1\x12]\n" +
	"\x11ListCoreInstances\x12\x16.google.protobuf.Empty\x1a\x15.voltha.CoreInstances\"\x19\x82\xd3\xe4\x93\x02\x13\x12\x11/api/v1/instances\x12S\n" +
	"\x0fGetCoreInstance\x12\n" +
	".common.ID\x1a\x14.voltha.CoreInstance\"\x1e\x82\xd3\xe4\x93\x02\x18\x12\x16/api/v1/instances/{id}\x12S\n" +
	"\fListAdapters\x12\x16.google.protobuf.Empty\x1a\x11.adapter.Adapters\"\x18\x82\xd3\xe4\x93\x02\x12\x12\x10/api/v1/adapters\x12m\n" +
	"\x12ListLogicalDevices\x12\x16.google.protobuf.Empty\x1a\x1e.logical_device.LogicalDevices\"\x1f\x82\xd3\xe4\x93\x02\x19\x12\x17/api/v1/logical_devices\x12c\n" +
	"\x10GetLogicalDevice\x12\n" +
	".common.ID\x1a\x1d.logical_device.LogicalDevice\"$\x82\xd3\xe4\x93\x02\x1e\x12\x1c/api/v1/logical_devices/{id}\x12n\n" +
	"\x16ListLogicalDevicePorts\x12\n" +
	".common.ID\x1a\x1c.logical_device.LogicalPorts\"*\x82\xd3\xe4\x93\x02$\x12\"/api/v1/logical_devices/{id}/ports\x12\x88\x01\n" +
	"\x14GetLogicalDevicePort\x12\x1d.logical_device.LogicalPortId\x1a\x1b.logical_device.LogicalPort\"4\x82\xd3\xe4\x93\x02.\x12,/api/v1/logical_devices/{id}/ports/{port_id}\x12\x8d\x01\n" +
	"\x17EnableLogicalDevicePort\x12\x1d.logical_device.LogicalPortId\x1a\x16.google.protobuf.Empty\";\x82\xd3\xe4\x93\x025\"3/api/v1/logical_devices/{id}/ports/{port_id}/enable\x12\x8f\x01\n" +
	"\x18DisableLogicalDevicePort\x12\x1d.logical_device.LogicalPortId\x1a\x16.google.protobuf.Empty\"<\x82\xd3\xe4\x93\x026\"4/api/v1/logical_devices/{id}/ports/{port_id}/disable\x12d\n" +
	"\x16ListLogicalDeviceFlows\x12\n" +
	".common.ID\x1a\x12.openflow_13.Flows\"*\x82\xd3\xe4\x93\x02$\x12\"/api/v1/logical_devices/{id}/flows\x12\x83\x01\n" +
	"\x1cUpdateLogicalDeviceFlowTable\x12\x1c.openflow_13.FlowTableUpdate\x1a\x16.google.protobuf.Empty\"-\x82\xd3\xe4\x93\x02':\x01*\"\"/api/v1/logical_devices/{id}/flows\x12\x84\x01\n" +
	"\x1dUpdateLogicalDeviceMeterTable\x12\x1b.openflow_13.MeterModUpdate\x1a\x16.google.protobuf.Empty\".\x82\xd3\xe4\x93\x02(:\x01*\"#/api/v1/logical_devices/{id}/meters\x12g\n" +
	"\x17ListLogicalDeviceMeters\x12\n" +
	".common.ID\x1a\x13.openflow_13.Meters\"+\x82\xd3\xe4\x93\x02%\x12#/api/v1/logical_devices/{id}/meters\x12t\n" +
	"\x1bListLogicalDeviceFlowGroups\x12\n" +
	".common.ID\x1a\x17.openflow_13.FlowGroups\"0\x82\xd3\xe4\x93\x02*\x12(/api/v1/logical_devices/{id}/flow_groups\x12\x93\x01\n" +
	"!UpdateLogicalDeviceFlowGroupTable\x12!.openflow_13.FlowGroupTableUpdate\x1a\x16.google.protobuf.Empty\"3\x82\xd3\xe4\x93\x02-:\x01*\"(/api/v1/logical_devices/{id}/flow_groups\x12O\n" +
	"\vListDevices\x12\x16.google.protobuf.Empty\x1a\x0f.device.Devices\"\x17\x82\xd3\xe4\x93\x02\x11\x12\x0f/api/v1/devices\x12O\n" +
	"\rListDeviceIds\x12\x16.google.protobuf.Empty\x1a\v.common.IDs\"\x19\x82\xd3\xe4\x93\x02\x13\x12\x11/api/v1/deviceids\x12U\n" +
	"\x10ReconcileDevices\x12\v.common.IDs\x1a\x16.google.protobuf.Empty\"\x1c\x82\xd3\xe4\x93\x02\x16:\x01*\"\x11/api/v1/deviceids\x12E\n" +
	"\tGetDevice\x12\n" +
	".common.ID\x1a\x0e.device.Device\"\x1c\x82\xd3\xe4\x93\x02\x16\x12\x14/api/v1/devices/{id}\x12J\n" +
	"\fCreateDevice\x12\x0e.device.Device\x1a\x0e.device.Device\"\x1a\x82\xd3\xe4\x93\x02\x14:\x01*\"\x0f/api/v1/devices\x12W\n" +
	"\fEnableDevice\x12\n" +
	".common.ID\x1a\x16.google.protobuf.Empty\"#\x82\xd3\xe4\x93\x02\x1d\"\x1b/api/v1/devices/{id}/enable\x12Y\n" +
	"\rDisableDevice\x12\n" +
	".common.ID\x1a\x16.google.protobuf.Empty\"$\x82\xd3\xe4\x93\x02\x1e\"\x1c/api/v1/devices/{id}/disable\x12W\n" +
	"\fRebootDevice\x12\n" +
	".common.ID\x1a\x16.google.protobuf.Empty\"#\x82\xd3\xe4\x93\x02\x1d\"\x1b/api/v1/devices/{id}/reboot\x12W\n" +
	"\fDeleteDevice\x12\n" +
	".common.ID\x1a\x16.google.protobuf.Empty\"#\x82\xd3\xe4\x93\x02\x1d*\x1b/api/v1/devices/{id}/delete\x12b\n" +
	"\x11ForceDeleteDevice\x12\n" +
	".common.ID\x1a\x16.google.protobuf.Empty\")\x82\xd3\xe4\x93\x02#*!/api/v1/devices/{id}/force_delete\x12x\n" +
	"\rDownloadImage\x12\x15.device.ImageDownload\x1a\x15.common.OperationResp\"9\x82\xd3\xe4\x93\x020:\x01*\"+/api/v1/devices/{id}/image_downloads/{name}\x88\x02\x01\x12\x85\x01\n" +
	"\x16GetImageDownloadStatus\x12\x15.device.ImageDownload\x1a\x15.device.ImageDownload\"=\x82\xd3\xe4\x93\x024\x122/api/v1/devices/{id}/image_downloads/{name}/status\x88\x02\x01\x12x\n" +
	"\x10GetImageDownload\x12\x15.device.ImageDownload\x1a\x15.device.ImageDownload\"6\x82\xd3\xe4\x93\x02-\x12+/api/v1/devices/{id}/image_downloads/{name}\x88\x02\x01\x12i\n" +
	"\x12ListImageDownloads\x12\n" +
	".common.ID\x1a\x16.device.ImageDownloads\"/\x82\xd3\xe4\x93\x02&\x12$/api/v1/devices/{id}/image_downloads\x88\x02\x01\x12{\n" +
	"\x13CancelImageDownload\x12\x15.device.ImageDownload\x1a\x15.common.OperationResp\"6\x82\xd3\xe4\x93\x02-*+/api/v1/devices/{id}/image_downloads/{name}\x88\x02\x01\x12\x8b\x01\n" +
	"\x13ActivateImageUpdate\x12\x15.device.ImageDownload\x1a\x15.common.OperationResp\"F\x82\xd3\xe4\x93\x02=:\x01*\"8/api/v1/devices/{id}/image_downloads/{name}/image_update\x88\x02\x01\x12\x89\x01\n" +
	"\x11RevertImageUpdate\x12\x15.device.ImageDownload\x1a\x15.common.OperationResp\"F\x82\xd3\xe4\x93\x02=:\x01*\"8/api/v1/devices/{id}/image_downloads/{name}/image_revert\x88\x02\x01\x12\x88\x01\n" +
	"\x15DownloadImageToDevice\x12\".device.DeviceImageDownloadRequest\x1a\x1b.device.DeviceImageResponse\".\x82\xd3\xe4\x93\x02(\x12&/api/v1/devices/images/download_images\x12w\n" +
	"\x0eGetImageStatus\x12\x1a.device.DeviceImageRequest\x1a\x1b.device.DeviceImageResponse\",\x82\xd3\xe4\x93\x02&\x12$/api/v1/devices/images/images_status\x12\x89\x01\n" +
	"\x19AbortImageUpgradeToDevice\x12\x1a.device.DeviceImageRequest\x1a\x1b.device.DeviceImageResponse\"3\x82\xd3\xe4\x93\x02-\x12+/api/v1/devices/images/abort_upgrade_images\x12V\n" +
	"\fGetOnuImages\x12\n" +
	".common.ID\x1a\x11.device.OnuImages\"'\x82\xd3\xe4\x93\x02!\x12\x1f/api/v1/devices/{id}/onu_images\x12{\n" +
	"\rActivateImage\x12\x1a.device.DeviceImageRequest\x1a\x1b.device.DeviceImageResponse\"1\x82\xd3\xe4\x93\x02+:\x01*\"&/api/v1/devices/images/activate_images\x12w\n" +
	"\vCommitImage\x12\x1a.device.DeviceImageRequest\x1a\x1b.device.DeviceImageResponse\"/\x82\xd3\xe4\x93\x02):\x01*\"$/api/v1/devices/images/commit_images\x12P\n" +
	"\x0fListDevicePorts\x12\n" +
	".common.ID\x1a\r.device.Ports\"\"\x82\xd3\xe4\x93\x02\x1c\x12\x1a/api/v1/devices/{id}/ports\x12]\n" +
	"\x13ListDevicePmConfigs\x12\n" +
	".common.ID\x1a\x11.device.PmConfigs\"'\x82\xd3\xe4\x93\x02!\x12\x1f/api/v1/devices/{id}/pm_configs\x12n\n" +
	"\x15UpdateDevicePmConfigs\x12\x11.device.PmConfigs\x1a\x16.google.protobuf.Empty\"*\x82\xd3\xe4\x93\x02$:\x01*\"\x1f/api/v1/devices/{id}/pm_configs\x12U\n" +
	"\x0fListDeviceFlows\x12\n" +
	".common.ID\x1a\x12.openflow_13.Flows\"\"\x82\xd3\xe4\x93\x02\x1c\x12\x1a/api/v1/devices/{id}/flows\x12e\n" +
	"\x14ListDeviceFlowGroups\x12\n" +
	".common.ID\x1a\x17.openflow_13.FlowGroups\"(\x82\xd3\xe4\x93\x02\"\x12 /api/v1/devices/{id}/flow_groups\x12\\\n" +
	"\x0fListDeviceTypes\x12\x16.google.protobuf.Empty\x1a\x13.device.DeviceTypes\"\x1c\x82\xd3\xe4\x93\x02\x16\x12\x14/api/v1/device_types\x12R\n" +
	"\rGetDeviceType\x12\n" +
	".common.ID\x1a\x12.device.DeviceType\"!\x82\xd3\xe4\x93\x02\x1b\x12\x19/api/v1/device_types/{id}\x12F\n" +
	"\x10StreamPacketsOut\x12\x16.openflow_13.PacketOut\x1a\x16.google.protobuf.Empty\"\x00(\x01\x12E\n" +
	"\x10ReceivePacketsIn\x12\x16.google.protobuf.Empty\x1a\x15.openflow_13.PacketIn\"\x000\x01\x12K\n" +
	"\x13ReceiveChangeEvents\x12\x16.google.protobuf.Empty\x1a\x18.openflow_13.ChangeEvent\"\x000\x01\x12]\n" +
	"\x11CreateEventFilter\x12\x12.event.EventFilter\x1a\x12.event.EventFilter\" \x82\xd3\xe4\x93\x02\x1a:\x01*\"\x15/api/v1/event_filters\x12U\n" +
	"\x0eGetEventFilter\x12\n" +
	".common.ID\x1a\x13.event.EventFilters\"\"\x82\xd3\xe4\x93\x02\x1c\x12\x1a/api/v1/event_filters/{id}\x12b\n" +
	"\x11UpdateEventFilter\x12\x12.event.EventFilter\x1a\x12.event.EventFilter\"%\x82\xd3\xe4\x93\x02\x1f:\x01*\x1a\x1a/api/v1/event_filters/{id}\x12c\n" +
	"\x11DeleteEventFilter\x12\x12.event.EventFilter\x1a\x16.google.protobuf.Empty\"\"\x82\xd3\xe4\x93\x02\x1c*\x1a/api/v1/event_filters/{id}\x12^\n" +
	"\x10ListEventFilters\x12\x16.google.protobuf.Empty\x1a\x13.event.EventFilters\"\x1d\x82\xd3\xe4\x93\x02\x17\x12\x15/api/v1/event_filters\x12L\n" +
	"\tGetImages\x12\n" +
	".common.ID\x1a\x0e.device.Images\"#\x82\xd3\xe4\x93\x02\x1d\x12\x1b/api/v1/devices/{id}/images\x12X\n" +
	"\bSelfTest\x12\n" +
	".common.ID\x1a\x18.device.SelfTestResponse\"&\x82\xd3\xe4\x93\x02 \"\x1e/api/v1/devices/{id}/self_test\x12V\n" +
	"\x10GetMibDeviceData\x12\n" +
	".common.ID\x1a\x13.omci.MibDeviceData\"!\x82\xd3\xe4\x93\x02\x1b\x12\x19/api/v1/openomci/{id}/mib\x12\\\n" +
	"\x12GetAlarmDeviceData\x12\n" +
	".common.ID\x1a\x15.omci.AlarmDeviceData\"#\x82\xd3\xe4\x93\x02\x1d\x12\x1b/api/v1/openomci/{id}/alarm\x12s\n" +
	"\rSimulateAlarm\x12\x1c.device.SimulateAlarmRequest\x1a\x15.common.OperationResp\"-\x82\xd3\xe4\x93\x02':\x01*\"\"/api/v1/devices/{id}/simulate_larm\x12M\n" +
	"\n" +
	"EnablePort\x12\f.device.Port\x1a\x16.google.protobuf.Empty\"\x19\x82\xd3\xe4\x93\x02\x13:\x01*\"\x0e/v1/EnablePort\x12O\n" +
	"\vDisablePort\x12\f.device.Port\x1a\x16.google.protobuf.Empty\"\x1a\x82\xd3\xe4\x93\x02\x14:\x01*\"\x0f/v1/DisablePort\x12^\n" +
	"\vGetExtValue\x12\x19.extension.ValueSpecifier\x1a\x17.extension.ReturnValues\"\x1b\x82\xd3\xe4\x93\x02\x15\x12\x13/api/v1/GetExtValue\x12W\n" +
	"\vSetExtValue\x12\x13.extension.ValueSet\x1a\x16.google.protobuf.Empty\"\x1b\x82\xd3\xe4\x93\x02\x15\x12\x13/api/v1/SetExtValue\x12d\n" +
	"\x13StartOmciTestAction\x12\x15.omci.OmciTestRequest\x1a\x12.omci.TestResponse\"\"\x82\xd3\xe4\x93\x02\x1c:\x01*\"\x17/api/v1/start_omci_test\x12\x85\x01\n" +
	"\x14PutVoipSystemProfile\x12-.voip_system_profile.VoipSystemProfileRequest\x1a\x16.google.protobuf.Empty\"&\x82\xd3\xe4\x93\x02 :\x01*\"\x1b/api/v1/voip_system_profile\x12p\n" +
	"\x17DeleteVoipSystemProfile\x12\v.common.Key\x1a\x16.google.protobuf.Empty\"0\x82\xd3\xe4\x93\x02**(/api/v1/voip_system_profile/{key}/delete\x12}\n" +
	"\x12PutVoipUserProfile\x12).voip_user_profile.VoipUserProfileRequest\x1a\x16.google.protobuf.Empty\"$\x82\xd3\xe4\x93\x02\x1e:\x01*\"\x19/api/v1/voip_user_profile\x12l\n" +
	"\x15DeleteVoipUserProfile\x12\v.common.Key\x1a\x16.google.protobuf.Empty\".\x82\xd3\xe4\x93\x02(*&/api/v1/voip_user_profile/{key}/delete\x12Z\n" +
	"\x10DisableOnuDevice\x12\n" +
	".common.ID\x1a\x16.google.protobuf.Empty\"\"\x82\xd3\xe4\x93\x02\x1c\"\x1a/api/v1/disable_onu_device\x12X\n" +
	"\x0fEnableOnuDevice\x12\n" +
	".common.ID\x1a\x16.google.protobuf.Empty\"!\x82\xd3\xe4\x93\x02\x1b\"\x19/api/v1/enable_onu_device\x12|\n" +
	"\x16DisableOnuSerialNumber\x12\x1f.device.OnuSerialNumberOnOLTPon\x1a\x16.google.protobuf.Empty\")\x82\xd3\xe4\x93\x02#\"!/api/v1/disable_onu_serial_number\x12z\n" +
	"\x15EnableOnuSerialNumber\x12\x1f.device.OnuSerialNumberOnOLTPon\x1a\x16.google.protobuf.Empty\"(\x82\xd3\xe4\x93\x02\"\" /api/v1/enable_onu_serial_number\x12[\n" +
	"\fUpdateDevice\x12\x14.device.UpdateDevice\x1a\x16.google.protobuf.Empty\"\x1d\x82\xd3\xe4\x93\x02\x17\"\x15/api/v1/update_deviceBl\n" +
	"\x13org.opencord.volthaB\fVolthaProtosZ.github.com/opencord/voltha-protos/v5/go/voltha\xaa\x02\x16Opencord.Voltha.VolthaP\x02b\x06proto3"

var (
	file_voltha_protos_voltha_proto_rawDescOnce sync.Once
	file_voltha_protos_voltha_proto_rawDescData []byte
)

func file_voltha_protos_voltha_proto_rawDescGZIP() []byte {
	file_voltha_protos_voltha_proto_rawDescOnce.Do(func() {
		file_voltha_protos_voltha_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_voltha_protos_voltha_proto_rawDesc), len(file_voltha_protos_voltha_proto_rawDesc)))
	})
	return file_voltha_protos_voltha_proto_rawDescData
}

var file_voltha_protos_voltha_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_voltha_protos_voltha_proto_goTypes = []any{
	(*CoreInstance)(nil),                                 // 0: voltha.CoreInstance
	(*CoreInstances)(nil),                                // 1: voltha.CoreInstances
	(*Voltha)(nil),                                       // 2: voltha.Voltha
	(*health.HealthStatus)(nil),                          // 3: health.HealthStatus
	(*Adapter)(nil),                                      // 4: adapter.Adapter
	(*LogicalDevice)(nil),                                // 5: logical_device.LogicalDevice
	(*Device)(nil),                                       // 6: device.Device
	(*DeviceType)(nil),                                   // 7: device.DeviceType
	(*EventFilter)(nil),                                  // 8: event.EventFilter
	(*omci.MibDeviceData)(nil),                           // 9: omci.MibDeviceData
	(*omci.AlarmDeviceData)(nil),                         // 10: omci.AlarmDeviceData
	(*emptypb.Empty)(nil),                                // 11: google.protobuf.Empty
	(*common.ID)(nil),                                    // 12: common.ID
	(*LogicalPortId)(nil),                                // 13: logical_device.LogicalPortId
	(*openflow_13.FlowTableUpdate)(nil),                  // 14: openflow_13.FlowTableUpdate
	(*openflow_13.MeterModUpdate)(nil),                   // 15: openflow_13.MeterModUpdate
	(*openflow_13.FlowGroupTableUpdate)(nil),             // 16: openflow_13.FlowGroupTableUpdate
	(*common.IDs)(nil),                                   // 17: common.IDs
	(*ImageDownload)(nil),                                // 18: device.ImageDownload
	(*DeviceImageDownloadRequest)(nil),                   // 19: device.DeviceImageDownloadRequest
	(*DeviceImageRequest)(nil),                           // 20: device.DeviceImageRequest
	(*PmConfigs)(nil),                                    // 21: device.PmConfigs
	(*openflow_13.PacketOut)(nil),                        // 22: openflow_13.PacketOut
	(*SimulateAlarmRequest)(nil),                         // 23: device.SimulateAlarmRequest
	(*Port)(nil),                                         // 24: device.Port
	(*extension.ValueSpecifier)(nil),                     // 25: extension.ValueSpecifier
	(*extension.ValueSet)(nil),                           // 26: extension.ValueSet
	(*omci.OmciTestRequest)(nil),                         // 27: omci.OmciTestRequest
	(*voip_system_profile.VoipSystemProfileRequest)(nil), // 28: voip_system_profile.VoipSystemProfileRequest
	(*common.Key)(nil),                                   // 29: common.Key
	(*voip_user_profile.VoipUserProfileRequest)(nil),     // 30: voip_user_profile.VoipUserProfileRequest
	(*OnuSerialNumberOnOLTPon)(nil),                      // 31: device.OnuSerialNumberOnOLTPon
	(*UpdateDevice)(nil),                                 // 32: device.UpdateDevice
	(*Adapters)(nil),                                     // 33: adapter.Adapters
	(*LogicalDevices)(nil),                               // 34: logical_device.LogicalDevices
	(*LogicalPorts)(nil),                                 // 35: logical_device.LogicalPorts
	(*LogicalPort)(nil),                                  // 36: logical_device.LogicalPort
	(*openflow_13.Flows)(nil),                            // 37: openflow_13.Flows
	(*openflow_13.Meters)(nil),                           // 38: openflow_13.Meters
	(*openflow_13.FlowGroups)(nil),                       // 39: openflow_13.FlowGroups
	(*Devices)(nil),                                      // 40: device.Devices
	(*common.OperationResp)(nil),                         // 41: common.OperationResp
	(*ImageDownloads)(nil),                               // 42: device.ImageDownloads
	(*DeviceImageResponse)(nil),                          // 43: device.DeviceImageResponse
	(*OnuImages)(nil),                                    // 44: device.OnuImages
	(*Ports)(nil),                                        // 45: device.Ports
	(*DeviceTypes)(nil),                                  // 46: device.DeviceTypes
	(*openflow_13.PacketIn)(nil),                         // 47: openflow_13.PacketIn
	(*openflow_13.ChangeEvent)(nil),                      // 48: openflow_13.ChangeEvent
	(*EventFilters)(nil),                                 // 49: event.EventFilters
	(*Images)(nil),                                       // 50: device.Images
	(*SelfTestResponse)(nil),                             // 51: device.SelfTestResponse
	(*extension.ReturnValues)(nil),                       // 52: extension.ReturnValues
	(*omci.TestResponse)(nil),                            // 53: omci.TestResponse
}
var file_voltha_protos_voltha_proto_depIdxs = []int32{
	3,  // 0: voltha.CoreInstance.health:type_name -> health.HealthStatus
	0,  // 1: voltha.CoreInstances.items:type_name -> voltha.CoreInstance
	4,  // 2: voltha.Voltha.adapters:type_name -> adapter.Adapter
	5,  // 3: voltha.Voltha.logical_devices:type_name -> logical_device.LogicalDevice
	6,  // 4: voltha.Voltha.devices:type_name -> device.Device
	7,  // 5: voltha.Voltha.device_types:type_name -> device.DeviceType
	8,  // 6: voltha.Voltha.event_filters:type_name -> event.EventFilter
	9,  // 7: voltha.Voltha.omci_mib_database:type_name -> omci.MibDeviceData
	10, // 8: voltha.Voltha.omci_alarm_database:type_name -> omci.AlarmDeviceData
	11, // 9: voltha.VolthaService.GetVoltha:input_type -> google.protobuf.Empty
	11, // 10: voltha.VolthaService.ListCoreInstances:input_type -> google.protobuf.Empty
	12, // 11: voltha.VolthaService.GetCoreInstance:input_type -> common.ID
	11, // 12: voltha.VolthaService.ListAdapters:input_type -> google.protobuf.Empty
	11, // 13: voltha.VolthaService.ListLogicalDevices:input_type -> google.protobuf.Empty
	12, // 14: voltha.VolthaService.GetLogicalDevice:input_type -> common.ID
	12, // 15: voltha.VolthaService.ListLogicalDevicePorts:input_type -> common.ID
	13, // 16: voltha.VolthaService.GetLogicalDevicePort:input_type -> logical_device.LogicalPortId
	13, // 17: voltha.VolthaService.EnableLogicalDevicePort:input_type -> logical_device.LogicalPortId
	13, // 18: voltha.VolthaService.DisableLogicalDevicePort:input_type -> logical_device.LogicalPortId
	12, // 19: voltha.VolthaService.ListLogicalDeviceFlows:input_type -> common.ID
	14, // 20: voltha.VolthaService.UpdateLogicalDeviceFlowTable:input_type -> openflow_13.FlowTableUpdate
	15, // 21: voltha.VolthaService.UpdateLogicalDeviceMeterTable:input_type -> openflow_13.MeterModUpdate
	12, // 22: voltha.VolthaService.ListLogicalDeviceMeters:input_type -> common.ID
	12, // 23: voltha.VolthaService.ListLogicalDeviceFlowGroups:input_type -> common.ID
	16, // 24: voltha.VolthaService.UpdateLogicalDeviceFlowGroupTable:input_type -> openflow_13.FlowGroupTableUpdate
	11, // 25: voltha.VolthaService.ListDevices:input_type -> google.protobuf.Empty
	11, // 26: voltha.VolthaService.ListDeviceIds:input_type -> google.protobuf.Empty
	17, // 27: voltha.VolthaService.ReconcileDevices:input_type -> common.IDs
	12, // 28: voltha.VolthaService.GetDevice:input_type -> common.ID
	6,  // 29: voltha.VolthaService.CreateDevice:input_type -> device.Device
	12, // 30: voltha.VolthaService.EnableDevice:input_type -> common.ID
	12, // 31: voltha.VolthaService.DisableDevice:input_type -> common.ID
	12, // 32: voltha.VolthaService.RebootDevice:input_type -> common.ID
	12, // 33: voltha.VolthaService.DeleteDevice:input_type -> common.ID
	12, // 34: voltha.VolthaService.ForceDeleteDevice:input_type -> common.ID
	18, // 35: voltha.VolthaService.DownloadImage:input_type -> device.ImageDownload
	18, // 36: voltha.VolthaService.GetImageDownloadStatus:input_type -> device.ImageDownload
	18, // 37: voltha.VolthaService.GetImageDownload:input_type -> device.ImageDownload
	12, // 38: voltha.VolthaService.ListImageDownloads:input_type -> common.ID
	18, // 39: voltha.VolthaService.CancelImageDownload:input_type -> device.ImageDownload
	18, // 40: voltha.VolthaService.ActivateImageUpdate:input_type -> device.ImageDownload
	18, // 41: voltha.VolthaService.RevertImageUpdate:input_type -> device.ImageDownload
	19, // 42: voltha.VolthaService.DownloadImageToDevice:input_type -> device.DeviceImageDownloadRequest
	20, // 43: voltha.VolthaService.GetImageStatus:input_type -> device.DeviceImageRequest
	20, // 44: voltha.VolthaService.AbortImageUpgradeToDevice:input_type -> device.DeviceImageRequest
	12, // 45: voltha.VolthaService.GetOnuImages:input_type -> common.ID
	20, // 46: voltha.VolthaService.ActivateImage:input_type -> device.DeviceImageRequest
	20, // 47: voltha.VolthaService.CommitImage:input_type -> device.DeviceImageRequest
	12, // 48: voltha.VolthaService.ListDevicePorts:input_type -> common.ID
	12, // 49: voltha.VolthaService.ListDevicePmConfigs:input_type -> common.ID
	21, // 50: voltha.VolthaService.UpdateDevicePmConfigs:input_type -> device.PmConfigs
	12, // 51: voltha.VolthaService.ListDeviceFlows:input_type -> common.ID
	12, // 52: voltha.VolthaService.ListDeviceFlowGroups:input_type -> common.ID
	11, // 53: voltha.VolthaService.ListDeviceTypes:input_type -> google.protobuf.Empty
	12, // 54: voltha.VolthaService.GetDeviceType:input_type -> common.ID
	22, // 55: voltha.VolthaService.StreamPacketsOut:input_type -> openflow_13.PacketOut
	11, // 56: voltha.VolthaService.ReceivePacketsIn:input_type -> google.protobuf.Empty
	11, // 57: voltha.VolthaService.ReceiveChangeEvents:input_type -> google.protobuf.Empty
	8,  // 58: voltha.VolthaService.CreateEventFilter:input_type -> event.EventFilter
	12, // 59: voltha.VolthaService.GetEventFilter:input_type -> common.ID
	8,  // 60: voltha.VolthaService.UpdateEventFilter:input_type -> event.EventFilter
	8,  // 61: voltha.VolthaService.DeleteEventFilter:input_type -> event.EventFilter
	11, // 62: voltha.VolthaService.ListEventFilters:input_type -> google.protobuf.Empty
	12, // 63: voltha.VolthaService.GetImages:input_type -> common.ID
	12, // 64: voltha.VolthaService.SelfTest:input_type -> common.ID
	12, // 65: voltha.VolthaService.GetMibDeviceData:input_type -> common.ID
	12, // 66: voltha.VolthaService.GetAlarmDeviceData:input_type -> common.ID
	23, // 67: voltha.VolthaService.SimulateAlarm:input_type -> device.SimulateAlarmRequest
	24, // 68: voltha.VolthaService.EnablePort:input_type -> device.Port
	24, // 69: voltha.VolthaService.DisablePort:input_type -> device.Port
	25, // 70: voltha.VolthaService.GetExtValue:input_type -> extension.ValueSpecifier
	26, // 71: voltha.VolthaService.SetExtValue:input_type -> extension.ValueSet
	27, // 72: voltha.VolthaService.StartOmciTestAction:input_type -> omci.OmciTestRequest
	28, // 73: voltha.VolthaService.PutVoipSystemProfile:input_type -> voip_system_profile.VoipSystemProfileRequest
	29, // 74: voltha.VolthaService.DeleteVoipSystemProfile:input_type -> common.Key
	30, // 75: voltha.VolthaService.PutVoipUserProfile:input_type -> voip_user_profile.VoipUserProfileRequest
	29, // 76: voltha.VolthaService.DeleteVoipUserProfile:input_type -> common.Key
	12, // 77: voltha.VolthaService.DisableOnuDevice:input_type -> common.ID
	12, // 78: voltha.VolthaService.EnableOnuDevice:input_type -> common.ID
	31, // 79: voltha.VolthaService.DisableOnuSerialNumber:input_type -> device.OnuSerialNumberOnOLTPon
	31, // 80: voltha.VolthaService.EnableOnuSerialNumber:input_type -> device.OnuSerialNumberOnOLTPon
	32, // 81: voltha.VolthaService.UpdateDevice:input_type -> device.UpdateDevice
	2,  // 82: voltha.VolthaService.GetVoltha:output_type -> voltha.Voltha
	1,  // 83: voltha.VolthaService.ListCoreInstances:output_type -> voltha.CoreInstances
	0,  // 84: voltha.VolthaService.GetCoreInstance:output_type -> voltha.CoreInstance
	33, // 85: voltha.VolthaService.ListAdapters:output_type -> adapter.Adapters
	34, // 86: voltha.VolthaService.ListLogicalDevices:output_type -> logical_device.LogicalDevices
	5,  // 87: voltha.VolthaService.GetLogicalDevice:output_type -> logical_device.LogicalDevice
	35, // 88: voltha.VolthaService.ListLogicalDevicePorts:output_type -> logical_device.LogicalPorts
	36, // 89: voltha.VolthaService.GetLogicalDevicePort:output_type -> logical_device.LogicalPort
	11, // 90: voltha.VolthaService.EnableLogicalDevicePort:output_type -> google.protobuf.Empty
	11, // 91: voltha.VolthaService.DisableLogicalDevicePort:output_type -> google.protobuf.Empty
	37, // 92: voltha.VolthaService.ListLogicalDeviceFlows:output_type -> openflow_13.Flows
	11, // 93: voltha.VolthaService.UpdateLogicalDeviceFlowTable:output_type -> google.protobuf.Empty
	11, // 94: voltha.VolthaService.UpdateLogicalDeviceMeterTable:output_type -> google.protobuf.Empty
	38, // 95: voltha.VolthaService.ListLogicalDeviceMeters:output_type -> openflow_13.Meters
	39, // 96: voltha.VolthaService.ListLogicalDeviceFlowGroups:output_type -> openflow_13.FlowGroups
	11, // 97: voltha.VolthaService.UpdateLogicalDeviceFlowGroupTable:output_type -> google.protobuf.Empty
	40, // 98: voltha.VolthaService.ListDevices:output_type -> device.Devices
	17, // 99: voltha.VolthaService.ListDeviceIds:output_type -> common.IDs
	11, // 100: voltha.VolthaService.ReconcileDevices:output_type -> google.protobuf.Empty
	6,  // 101: voltha.VolthaService.GetDevice:output_type -> device.Device
	6,  // 102: voltha.VolthaService.CreateDevice:output_type -> device.Device
	11, // 103: voltha.VolthaService.EnableDevice:output_type -> google.protobuf.Empty
	11, // 104: voltha.VolthaService.DisableDevice:output_type -> google.protobuf.Empty
	11, // 105: voltha.VolthaService.RebootDevice:output_type -> google.protobuf.Empty
	11, // 106: voltha.VolthaService.DeleteDevice:output_type -> google.protobuf.Empty
	11, // 107: voltha.VolthaService.ForceDeleteDevice:output_type -> google.protobuf.Empty
	41, // 108: voltha.VolthaService.DownloadImage:output_type -> common.OperationResp
	18, // 109: voltha.VolthaService.GetImageDownloadStatus:output_type -> device.ImageDownload
	18, // 110: voltha.VolthaService.GetImageDownload:output_type -> device.ImageDownload
	42, // 111: voltha.VolthaService.ListImageDownloads:output_type -> device.ImageDownloads
	41, // 112: voltha.VolthaService.CancelImageDownload:output_type -> common.OperationResp
	41, // 113: voltha.VolthaService.ActivateImageUpdate:output_type -> common.OperationResp
	41, // 114: voltha.VolthaService.RevertImageUpdate:output_type -> common.OperationResp
	43, // 115: voltha.VolthaService.DownloadImageToDevice:output_type -> device.DeviceImageResponse
	43, // 116: voltha.VolthaService.GetImageStatus:output_type -> device.DeviceImageResponse
	43, // 117: voltha.VolthaService.AbortImageUpgradeToDevice:output_type -> device.DeviceImageResponse
	44, // 118: voltha.VolthaService.GetOnuImages:output_type -> device.OnuImages
	43, // 119: voltha.VolthaService.ActivateImage:output_type -> device.DeviceImageResponse
	43, // 120: voltha.VolthaService.CommitImage:output_type -> device.DeviceImageResponse
	45, // 121: voltha.VolthaService.ListDevicePorts:output_type -> device.Ports
	21, // 122: voltha.VolthaService.ListDevicePmConfigs:output_type -> device.PmConfigs
	11, // 123: voltha.VolthaService.UpdateDevicePmConfigs:output_type -> google.protobuf.Empty
	37, // 124: voltha.VolthaService.ListDeviceFlows:output_type -> openflow_13.Flows
	39, // 125: voltha.VolthaService.ListDeviceFlowGroups:output_type -> openflow_13.FlowGroups
	46, // 126: voltha.VolthaService.ListDeviceTypes:output_type -> device.DeviceTypes
	7,  // 127: voltha.VolthaService.GetDeviceType:output_type -> device.DeviceType
	11, // 128: voltha.VolthaService.StreamPacketsOut:output_type -> google.protobuf.Empty
	47, // 129: voltha.VolthaService.ReceivePacketsIn:output_type -> openflow_13.PacketIn
	48, // 130: voltha.VolthaService.ReceiveChangeEvents:output_type -> openflow_13.ChangeEvent
	8,  // 131: voltha.VolthaService.CreateEventFilter:output_type -> event.EventFilter
	49, // 132: voltha.VolthaService.GetEventFilter:output_type -> event.EventFilters
	8,  // 133: voltha.VolthaService.UpdateEventFilter:output_type -> event.EventFilter
	11, // 134: voltha.VolthaService.DeleteEventFilter:output_type -> google.protobuf.Empty
	49, // 135: voltha.VolthaService.ListEventFilters:output_type -> event.EventFilters
	50, // 136: voltha.VolthaService.GetImages:output_type -> device.Images
	51, // 137: voltha.VolthaService.SelfTest:output_type -> device.SelfTestResponse
	9,  // 138: voltha.VolthaService.GetMibDeviceData:output_type -> omci.MibDeviceData
	10, // 139: voltha.VolthaService.GetAlarmDeviceData:output_type -> omci.AlarmDeviceData
	41, // 140: voltha.VolthaService.SimulateAlarm:output_type -> common.OperationResp
	11, // 141: voltha.VolthaService.EnablePort:output_type -> google.protobuf.Empty
	11, // 142: voltha.VolthaService.DisablePort:output_type -> google.protobuf.Empty
	52, // 143: voltha.VolthaService.GetExtValue:output_type -> extension.ReturnValues
	11, // 144: voltha.VolthaService.SetExtValue:output_type -> google.protobuf.Empty
	53, // 145: voltha.VolthaService.StartOmciTestAction:output_type -> omci.TestResponse
	11, // 146: voltha.VolthaService.PutVoipSystemProfile:output_type -> google.protobuf.Empty
	11, // 147: voltha.VolthaService.DeleteVoipSystemProfile:output_type -> google.protobuf.Empty
	11, // 148: voltha.VolthaService.PutVoipUserProfile:output_type -> google.protobuf.Empty
	11, // 149: voltha.VolthaService.DeleteVoipUserProfile:output_type -> google.protobuf.Empty
	11, // 150: voltha.VolthaService.DisableOnuDevice:output_type -> google.protobuf.Empty
	11, // 151: voltha.VolthaService.EnableOnuDevice:output_type -> google.protobuf.Empty
	11, // 152: voltha.VolthaService.DisableOnuSerialNumber:output_type -> google.protobuf.Empty
	11, // 153: voltha.VolthaService.EnableOnuSerialNumber:output_type -> google.protobuf.Empty
	11, // 154: voltha.VolthaService.UpdateDevice:output_type -> google.protobuf.Empty
	82, // [82:155] is the sub-list for method output_type
	9,  // [9:82] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_voltha_protos_voltha_proto_init() }
func file_voltha_protos_voltha_proto_init() {
	if File_voltha_protos_voltha_proto != nil {
		return
	}
	file_voltha_protos_logical_device_proto_init()
	file_voltha_protos_device_proto_init()
	file_voltha_protos_adapter_proto_init()
	file_voltha_protos_events_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_voltha_protos_voltha_proto_rawDesc), len(file_voltha_protos_voltha_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_voltha_protos_voltha_proto_goTypes,
		DependencyIndexes: file_voltha_protos_voltha_proto_depIdxs,
		MessageInfos:      file_voltha_protos_voltha_proto_msgTypes,
	}.Build()
	File_voltha_protos_voltha_proto = out.File
	file_voltha_protos_voltha_proto_goTypes = nil
	file_voltha_protos_voltha_proto_depIdxs = nil
}
