/*
* Copyright 2022-present Open Networking Foundation
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
 */

// Code generated by MockGen. DO NOT EDIT.
// Source: /home/aksoni/var/work/gerrit/voltha-go-controller/internal/pkg/controller/controller.go

// Package mock_controller is a generated GoMock package.
package mocks

import (
	context "context"
	reflect "reflect"
	controller "voltha-go-controller/internal/pkg/controller"
	of "voltha-go-controller/internal/pkg/of"
	tasks "voltha-go-controller/internal/pkg/tasks"

	gomock "go.uber.org/mock/gomock"
)

// MockVoltControllerInterface is a mock of VoltControllerInterface interface.
type MockVoltControllerInterface struct {
	ctrl     *gomock.Controller
	recorder *MockVoltControllerInterfaceMockRecorder
}

// MockVoltControllerInterfaceMockRecorder is the mock recorder for MockVoltControllerInterface.
type MockVoltControllerInterfaceMockRecorder struct {
	mock *MockVoltControllerInterface
}

// NewMockVoltControllerInterface creates a new mock instance.
func NewMockVoltControllerInterface(ctrl *gomock.Controller) *MockVoltControllerInterface {
	mock := &MockVoltControllerInterface{ctrl: ctrl}
	mock.recorder = &MockVoltControllerInterfaceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockVoltControllerInterface) EXPECT() *MockVoltControllerInterfaceMockRecorder {
	return m.recorder
}

// GetAllFlows mocks base method.
func (m *MockVoltControllerInterface) GetAllFlows() ([]*of.VoltSubFlow, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllFlows")
	ret0, _ := ret[0].([]*of.VoltSubFlow)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllFlows indicates an expected call of GetAllFlows.
func (mr *MockVoltControllerInterfaceMockRecorder) GetAllFlows() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllFlows", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetAllFlows))
}

// GetAllMeterInfo mocks base method.
func (m *MockVoltControllerInterface) GetAllMeterInfo() (map[string][]*of.Meter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllMeterInfo")
	ret0, _ := ret[0].(map[string][]*of.Meter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllMeterInfo indicates an expected call of GetAllMeterInfo.
func (mr *MockVoltControllerInterfaceMockRecorder) GetAllMeterInfo() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllMeterInfo", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetAllMeterInfo))
}

// GetAllPendingFlows mocks base method.
func (m *MockVoltControllerInterface) GetAllPendingFlows() ([]*of.VoltSubFlow, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllPendingFlows")
	ret0, _ := ret[0].([]*of.VoltSubFlow)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAllPendingFlows indicates an expected call of GetAllPendingFlows.
func (mr *MockVoltControllerInterfaceMockRecorder) GetAllPendingFlows() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllPendingFlows", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetAllPendingFlows))
}

// GetDevice mocks base method.
func (m *MockVoltControllerInterface) GetDevice(id string) (*controller.Device, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDevice", id)
	ret0, _ := ret[0].(*controller.Device)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDevice indicates an expected call of GetDevice.
func (mr *MockVoltControllerInterfaceMockRecorder) GetDevice(id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDevice", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetDevice), id)
}

// GetFlow mocks base method.
func (m *MockVoltControllerInterface) GetFlow(deviceID string, cookie uint64) (*of.VoltSubFlow, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetFlow", deviceID, cookie)
	ret0, _ := ret[0].(*of.VoltSubFlow)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetFlow indicates an expected call of GetFlow.
func (mr *MockVoltControllerInterfaceMockRecorder) GetFlow(deviceID, cookie interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetFlow", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetFlow), deviceID, cookie)
}

// GetFlows mocks base method.
func (m *MockVoltControllerInterface) GetFlows(deviceID string) ([]*of.VoltSubFlow, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetFlows", deviceID)
	ret0, _ := ret[0].([]*of.VoltSubFlow)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetFlows indicates an expected call of GetFlows.
func (mr *MockVoltControllerInterfaceMockRecorder) GetFlows(deviceID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetFlows", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetFlows), deviceID)
}

// GetGroupList mocks base method.
func (m *MockVoltControllerInterface) GetGroupList() ([]*of.Group, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetGroupList")
	ret0, _ := ret[0].([]*of.Group)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetGroupList indicates an expected call of GetGroupList.
func (mr *MockVoltControllerInterfaceMockRecorder) GetGroupList() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetGroupList", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetGroupList))
}

// GetGroups mocks base method.
func (m *MockVoltControllerInterface) GetGroups(cntx context.Context, id uint32) (*of.Group, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetGroups", cntx, id)
	ret0, _ := ret[0].(*of.Group)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetGroups indicates an expected call of GetGroups.
func (mr *MockVoltControllerInterfaceMockRecorder) GetGroups(cntx, id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetGroups", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetGroups), cntx, id)
}

// GetMeterInfo mocks base method.
func (m *MockVoltControllerInterface) GetMeterInfo(cntx context.Context, id uint32) (map[string]*of.Meter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMeterInfo", cntx, id)
	ret0, _ := ret[0].(map[string]*of.Meter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMeterInfo indicates an expected call of GetMeterInfo.
func (mr *MockVoltControllerInterfaceMockRecorder) GetMeterInfo(cntx, id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMeterInfo", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetMeterInfo), cntx, id)
}

// GetTaskList mocks base method.
func (m *MockVoltControllerInterface) GetTaskList(device string) []tasks.Task {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTaskList", device)
	ret0, _ := ret[0].([]tasks.Task)
	return ret0
}

// GetTaskList indicates an expected call of GetTaskList.
func (mr *MockVoltControllerInterfaceMockRecorder) GetTaskList(device interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTaskList", reflect.TypeOf((*MockVoltControllerInterface)(nil).GetTaskList), device)
}
