/*
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package l2oam

import (
	"github.com/google/gopacket"
)

// GenerateSetVlanPonVIDValue generates VlanPonVIDValue message
func GenerateSetVlanPonVIDValue(pkgType string, idx int, iTpidValue []byte, iVidValue []byte) gopacket.SerializableLayer {

	if pkgType == OnuPkgTypeB {
		tibitData := &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xfe, 0x90, 0x82, 0x60, 0x03,
				0xca, 0xfe, 0x00, 0xb7, 0x00, 0x15, 0x02,
			},
		}

		tibitData.Data = append(tibitData.Data, iVidValue...)

		return tibitData
	}
	switch idx {
	case 1: // Downstream Rule
		tibitData := &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xfe, 0x00, 0x10, 0x00, 0x03,
				0xd6, 0x00, 0x03, 0x01, 0x00, 0xd7, 0x05, 0x01,
				0x02, 0x01, 0x0a, 0xd7, 0x05, 0x01, 0x07, 0x02,
				0x03, 0x00, 0x00, 0x00, 0x07, 0x00, 0xd7, 0x05,
				0x01, 0x02, 0x03, 0x02, 0xd7, 0x05, 0x01, 0x0b,
				0x03, 0x04, 0x08, 0x00, 0x00, 0x00, 0x04,
			},
		}

		// itpid must be 4 bytes length
		tibitData.Data = append(tibitData.Data, iTpidValue...)
		// ivid must be 2 bytes length
		tibitData.Data = append(tibitData.Data, iVidValue...)

		bytes := []byte{
			0xd7, 0x05, 0x01, 0x04, 0x03, 0x07, 0x08, 0x00,
			0xd7, 0x05, 0x01, 0x01, 0x00, 0xd9, 0x05, 0x02,
			0x80, 0x00,
		}

		tibitData.Data = append(tibitData.Data, bytes...)

		return tibitData

	case 2: // Upstream Rule
		tibitData := &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xfe, 0x00, 0x10, 0x00, 0x03,
				0xd6, 0x00, 0x01, 0x01, 0x00, 0xd7, 0x05, 0x01,
				0x02, 0x01, 0x0a, 0xd7, 0x05, 0x01, 0x07, 0x02,
				0x03, 0x00, 0x00, 0x00, 0x07, 0x00, 0xd7, 0x05,
				0x01, 0x02, 0x03, 0x02, 0xd7, 0x05, 0x01, 0x0b,
				0x03, 0x04, 0x08, 0x00, 0x00, 0x00, 0x04,
			},
		}

		// itpid must be 4 bytes length
		tibitData.Data = append(tibitData.Data, iTpidValue...)
		// ivid must be 2 bytes length
		tibitData.Data = append(tibitData.Data, iVidValue...)

		bytes := []byte{
			0xd7, 0x05, 0x01, 0x04, 0x03, 0x07, 0x08, 0x00,
			0xd7, 0x05, 0x01, 0x01, 0x00, 0xd9, 0x05, 0x02,
			0x80, 0x00,
		}

		tibitData.Data = append(tibitData.Data, bytes...)

		return tibitData

	default:
		return &TibitFrame{
			Data: []byte{},
		}
	}
}
